/*
**
** FileSelP.h
**
** Copyright (C) 1995, 1996 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@dipmza.physik.uni-mainz.de)
**           Department of Physic
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/


#ifndef _XawFileSelectionP_h
#define _XawFileSelectionP_h

#include "paths.h"
#include INC_XAW(Viewport.h)
#include INC_XAW(Command.h)
#include INC_XAW(AsciiText.h)
#include INC_XAW(Grip.h)
#include INC_XAW(Paned.h)
#include "AaaP.h"

#include "ListcP.h"

#ifdef VMS
#   include "vms_dir.h"
#else
#   include <sys/dirent.h>
#endif

#include "FileSel.h"

/*####################################################################
   Private Delarations
####################################################################*/

typedef struct {
	String	*entry;
	int	num_of_entries;
} FSDir;


typedef struct _FileSelectionClassPart {
    int foo;			/* keep compiler happy. */
} FileSelectionClassPart;


typedef struct {
    /* resources */
    Pixel	highlightPixel;
    String      path;
    String      file;
    int		view_mode;
    String	view_order;
    int         buttons;
    int		preferredButton;    
    /* private data */
    Widget	pathframeFS;
    Widget	pathFS;
    Widget	fileframeFS;
    Widget	fileFS;
    Widget	rescanFS;
    Widget	filterFS;
    Widget	panedFS;
    Widget	topframeFS;
    Widget	topviewFS;
    Widget	toplistFS;
    Widget	curframeFS;
    Widget	curviewFS;
    Widget	curlistFS;
    Widget	subframeFS;
    Widget	subviewFS;
    Widget	sublistFS;
    Widget	button1FS;
    Widget	button2FS;
    Widget	button3FS;
    Widget	button4FS;
    FSDir       topdir;
    int         topdir_alloc;
    FSDir       curdir;
    int         curdir_alloc;
    FSDir       subdir;
    int         subdir_alloc;
    String      app_dir;
    String      both;
    String      current_dir;
    String      path_field_value;
    String      file_field_value;    
    int         internal_buttons;    
    unsigned long multiclick;
    Pixel	old_highlightPixel;
} FileSelectionPart;

typedef struct _FileSelectionClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    AaaClassPart        aaa_class;
    FileSelectionClassPart   file_selection_class;
} FileSelectionClassRec;

extern FileSelectionClassRec file_selectionClassRec;

/**************************************************************************
 *
 * Full instance record declaration
 *
 **************************************************************************/

typedef struct {int empty;} FileSelectionConstraintsPart;

typedef struct _FileSelectionConstraintsRec {
    SubInfoRec	aaa;
    FileSelectionConstraintsPart file_selection;
} FileSelectionConstraintsRec, *FileSelectionConstraints;

typedef struct _FileSelectionRec {
    CorePart       core;
    CompositePart  composite;
    ConstraintPart constraint;
    AaaPart        aaa;
    FileSelectionPart file_selection;
} FileSelectionRec;

#endif /* _XawFileSelectionP_h */
