/*
**
** d_mem.c
**
** Copyright (C) 1995, 1996 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@dipmza.physik.uni-mainz.de)
**           Department of Physic
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define GV_MEMDEBUG_OUT stderr

typedef struct _mem {
   int number;
   unsigned long adress;
} adress;

#define MAX_ADR 2000
static adress ad[MAX_ADR];

static char matchbuf[20];

static int num = 0;

#define GV_MEMDEBUG_STD_MESSAGE(aaa)             \
   { char *tmp = strrchr(file,']');              \
     if (!tmp) tmp = strrchr(file,':');          \
     if (!tmp) tmp = " ";                        \
     tmp++;                                      \
     sprintf(buf,"%4s | %4s | %4d | %17s | %7d",caller,aaa,line,tmp,num);  \
   }

#define CHECK_FOR_MATCH(aaa)                                                      \
   {                                                                              \
     int i=0;                                                                     \
     strcpy(matchbuf,"");                                                         \
     while (ad[i].number > -2 && i<MAX_ADR) {                                     \
         if (ad[i].number > -1 && ad[i].adress == (unsigned long) ptr) {          \
            sprintf(matchbuf," | %7d",ad[i].number);                              \
            ad[i].number = -1;                                                    \
            break;                                                                \
         }                                                                        \
         ++i;                                                                     \
     }                                                                            \
   }

#define ADD_TO_STACK(aaa)                                                         \
   if (num==0) {                                                                  \
      while (num<MAX_ADR) { ad[num].number=-1; num++; }                           \
      num=0;                                                                      \
      ad[1].number=-2;                                                            \
      fprintf(GV_MEMDEBUG_OUT,"   Adress |   Size | Call | Type | Line |              File |   Entry |   Match\n");\
   }                                                                              \
   {                                                                              \
     int i=0;                                                                     \
     while (i<MAX_ADR && ad[i].number >=0) ++i;                                   \
     if (i==MAX_ADR)                                                              \
        fprintf(GV_MEMDEBUG_OUT,"D_XTMEM.C: Warning, stack too small.\n");        \
     else {                                                                       \
        if (ad[i].number == -2) {                                                 \
           if (i==MAX_ADR-1)                                                      \
              fprintf(GV_MEMDEBUG_OUT,"D_XTMEM.C: Warning, stack exhausted.\n");  \
           else                                                                   \
              ad[i+1].number = -2;                                                \
        }                                                                         \
        ad[i].number = num;                                                       \
        ad[i].adress = (unsigned long) aaa;                                       \
     }                                                                            \
   }

void * d_calloc(count,size,line,file,caller)
   size_t count;
   size_t size;
   int    line;
   char   *file;
   char   *caller;
{
   void *tmp;
   char buf[100];
   GV_MEMDEBUG_STD_MESSAGE("C");

   tmp = calloc(count,size);
   if (!tmp)
      fprintf(GV_MEMDEBUG_OUT,"d_calloc Warning cannot allocate %d bytes\n",size);
   else {
      ADD_TO_STACK(tmp);
      fprintf(GV_MEMDEBUG_OUT,"+ %ld | %6d | %s\n",tmp,size*count,buf);
   }
   num++;
   return tmp;
}

void * d_malloc(size,line,file,caller)
   size_t size;
   int    line;
   char   *file;
   char   *caller;
{
   void *tmp;
   char buf[100];
   GV_MEMDEBUG_STD_MESSAGE("M");

   tmp = malloc(size);
   if (!tmp)
      fprintf(GV_MEMDEBUG_OUT,"d_malloc Warning cannot allocate %d bytes\n",size);
   else {
      ADD_TO_STACK(tmp);
      fprintf(GV_MEMDEBUG_OUT,"+ %ld | %6d | %s\n",tmp,size,buf);
   }
   num++;
   return tmp;
}

void * d_realloc(ptr,size,line,file,caller)
   void   *ptr;
   size_t size;
   int    line;
   char   *file;
   char   *caller;
{
   void *tmp;
   char buf[100];
   GV_MEMDEBUG_STD_MESSAGE("R");

   CHECK_FOR_MATCH(ptr);
   fprintf(GV_MEMDEBUG_OUT,"- %ld | %6s | %s%s\n",ptr,"",buf,matchbuf);
   tmp = realloc(ptr,size);
   if (!tmp)
      fprintf(GV_MEMDEBUG_OUT,"d_realloc: Warning cannot reallocate %d bytes\n",size);
   else {
      ADD_TO_STACK(tmp);
      fprintf(GV_MEMDEBUG_OUT,"+ %ld | %6d | %s\n",tmp,size,buf);
   }
   num++;
   return tmp;
}

void d_free(ptr,line,file,caller)
   void *ptr;
   int  line;
   char *file;
   char *caller;
{
   char buf[100];
   GV_MEMDEBUG_STD_MESSAGE("F");

   CHECK_FOR_MATCH(ptr);
   fprintf(GV_MEMDEBUG_OUT,"- %ld | %6s | %s%s\n",ptr,"",buf,matchbuf);
   free(ptr);
   num++;
   return;
}

void d_cfree(ptr,line,file,caller)
   void     *ptr;
   int line;
   char *file;
   char *caller;
{
   char buf[100];
   GV_MEMDEBUG_STD_MESSAGE("CF");

   CHECK_FOR_MATCH(ptr);
   fprintf(GV_MEMDEBUG_OUT,"- %ld | %6s | %s%s\n",ptr,"",buf,matchbuf);
   cfree(ptr);
   num++;
   return;
}

void d_MemDump()
{
   char buf[100];
   int i=0;
   int j=0;

   if (!num) { 
      fprintf(GV_MEMDEBUG_OUT,"MemDebug: no call registered.\n");
      return;
   }
   while (i<MAX_ADR && ad[i].number>-2) {
      if (ad[i].number>=0)
        fprintf(GV_MEMDEBUG_OUT,"? %ld | %7d\n",ad[i].adress,ad[i].number);
      if (ad[i].number==-1) ++j;
      ++i;
   }
   fprintf(GV_MEMDEBUG_OUT,"MemDebug: %7d out of %7d stack positions are unused.\n",j,i);
}
