/*   SSLEAY BUFFER I/O object  for use with multithreaded routines. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "http_base_code/message_service.h"
#include "http_base_code/decnet_access.h"
#include "cryptlib.h"
#include "buffer.h"

/*************************************************************************/
struct rpc_msg {		/* Should have member alignment inhibited */
   char channel;		/* 'A'-app data. 'R'-remote client 'G'-global */
   char function;		/* 'G'-get, 'P'-put, 'C'-confirm, 'X'-close */
   unsigned short int length;	/* Amount of data returned or max to return */
   char data[4092];		/* variable data */
};
#define RPC_HDR_SIZE (sizeof(struct rpc_msg) - 4092)

struct rpc_ctx {
    int filled, pos;
    struct rpc_msg msg;
};

static int rtcp_write(BIO *h,char *buf,int num);
static int rtcp_read(BIO *h,char *buf,int size);
static int rtcp_puts(BIO *h,char *str);
static int rtcp_gets(BIO *h,char *str,int size);
static long rtcp_ctrl(BIO *h,int cmd,long arg1,char *arg2);
static int rtcp_new(BIO *h);
static int rtcp_free(BIO *data);

static BIO_METHOD rtcp_method=
	{
	BIO_TYPE_FD,"RTCP",
	rtcp_write,
	rtcp_read,
	rtcp_puts,
	rtcp_gets,
	rtcp_ctrl,
	rtcp_new,
	rtcp_free,
	};

BIO_METHOD *BIO_s_mst()
	{
	return(&rtcp_method);
	}
/***************************************************************************/

static int rtcp_new(bi)
BIO *bi;
{
    struct rpc_ctx *ctx;
	bi->init=1;
	bi->num=0;
	bi->flags = 0;
	bi->ptr=malloc(sizeof(struct rpc_ctx));
	ctx = (struct rpc_ctx *) bi->ptr;
	ctx->filled = 0;
	ctx->pos = 0;
	return(1);
}

static int rtcp_free(a)
BIO *a;
{
	if (a == NULL) return(0);
	if ( a->ptr ) free ( a->ptr );
	a->ptr = NULL;
	return(1);
}
	
static int rtcp_read(b,out,outl)
BIO *b;
char *out;
int outl;
{
    int status, length, written;
    struct rpc_ctx *ctx;
    /*
     * read data, return existing.
     */
    ctx = (struct rpc_ctx *) b->ptr;
    if ( ctx->pos < ctx->filled ) {
	length = ctx->filled - ctx->pos;
	if ( length > outl ) length = outl;
	memmove ( out, &ctx->msg.data[ctx->pos], length );
	ctx->pos += length;
	return length;
    }
    /*
     * Requst more data from R channel.
     */
    ctx->msg.channel = 'R';
    ctx->msg.function = 'G';
    ctx->msg.length = sizeof(ctx->msg.data);
    if ( b->num == 0 )
	status = mst_write ( (mst_link_t) b->ptr, (char *) &ctx->msg, 
		RPC_HDR_SIZE, &written );
    else
	status = dnet_write ( (void *) b->ptr, (char *) &ctx->msg, 
		RPC_HDR_SIZE, &written );
    if ( (status&1) == 0 ) {
	return -1;
    }
    /*
     * Read.
     */
    ctx->pos = ctx->filled = 0;
    if ( b->num == 0 ) 
	status = mst_read ( (mst_link_t) b->ptr, (char *) &ctx->msg, 
		sizeof(ctx->msg), &length );
    else
	status = dnet_read ( (void *) b->ptr, (char *) &ctx->msg,
		sizeof(ctx->msg), &length );
    if ( (status&1) == 0 ) length = -1;
    if ( ctx->msg.channel != 'R' || ctx->msg.function != 'C' ) {
	length = -1;
    }
    ctx->filled = length - RPC_HDR_SIZE;
    
    if ( ctx->pos < ctx->filled ) {
	length = ctx->filled - ctx->pos;
	if ( length > outl ) length = outl;
	memmove ( out, ctx->msg.data, length );
	ctx->pos += length;
	return length;
    }

    return length;
}

static int rtcp_write(b,in,inl)
BIO *b;
char *in;
int inl;
{
    int status, i, segment, length, written;
    struct rpc_ctx *ctx;
    /*
     * Output data, send in chunks no larger that sizeof(ctx->msg.data).
     */
    ctx = (struct rpc_ctx *) b->ptr;
    for ( i = 0; i < inl; i += segment ) {
	segment = inl - i;
	if ( segment > sizeof(ctx->msg.data) ) segment = sizeof(ctx->msg.data);
	ctx->msg.channel = 'R';
	ctx->msg.function = 'P';
	ctx->msg.length = segment;
	memmove ( ctx->msg.data, &in[i], segment );
	if ( b->num == 0 )
	    status = mst_write ( (mst_link_t) b->ptr, (char *) &ctx->msg, 
		segment + RPC_HDR_SIZE, &written );
	else
	    status = dnet_write ( (void *) b->ptr, (char *) &ctx->msg, 
		segment + RPC_HDR_SIZE, &written );
	if ((status&1) == 0 ) { i = -1; break; }

	if ( b->num == 0 ) 
	    status = mst_read ( (mst_link_t) b->ptr, (char *) &ctx->msg, 
		sizeof(ctx->msg), &length );
	else
	    status = dnet_read ( (void *) b->ptr, (char *) &ctx->msg,
		sizeof(ctx->msg), &length );
	if ( ((status&1) == 0) || (length < RPC_HDR_SIZE) ) { i = -1; break; }
	if ( (ctx->msg.channel != 'R') || (ctx->msg.function != 'C') ) {
	   printf("unexpected response when confirming put %c %c\n",
		ctx->msg.channel, ctx->msg.function );

	}
    }
    return(i);
}

static long rtcp_ctrl(b,cmd,num,ptr)
BIO *b;
int cmd;
long num;
char *ptr;
	{
	long ret=1;

	switch (cmd)
		{
	case BIO_CTRL_RESET:
	case BIO_CTRL_EOF:
		ret = 1;
		break;
	case BIO_CTRL_SET:
		b->num = num;
		b->ptr = ptr;
		ret = 1;
	 	break;
	case BIO_CTRL_SET_CLOSE:
	case BIO_CTRL_FLUSH:
		ret=1;
		break;
	case BIO_CTRL_GET_CLOSE:
	case BIO_CTRL_INFO:
	case BIO_CTRL_GET:
	case BIO_CTRL_PENDING:
	case BIO_CTRL_SHOULD_RETRY:
	case BIO_CTRL_RETRY_TYPE:
	default:
		ret=0;
		break;
		}
	return(ret);
	}

static int rtcp_gets(bp,buf,size)
BIO *bp;
char *buf;
int size;
	{
	return(0);
	}

static int rtcp_puts(bp,str)
BIO *bp;
char *str;
{
    int length;
    if (str == NULL) return(0);
    length = strlen ( str );
    if ( length == 0 ) return (0);
    return rtcp_write ( bp,str, length );
}

