/*
 * Define private structures used by ssl_server_v3 implementation.
 */
struct ssl_rec {
    int frag_length;		/* Length of fragment */
    int data_alloc;		/* Size of allocated data buffer. */
    int v2_pad;			/* padding value. */
    unsigned int sequence;	/* Message sequence number */
    union {
      struct {
	unsigned char type;
	unsigned char ver_major, ver_minor;		/* 3, 0 */
	unsigned char len_msb, len_lsb;		/* big-endian fragment length*/
      } plain;
      struct {
	unsigned char len_msb;
	unsigned char len_lsb;
	unsigned char pad;
      } v2_hdr;
      unsigned char raw[8];
    } hdr;
    int filled;
    int is_escape;
    unsigned char *data;
};
/*
 * define primary context structure returned by init_context.
 */
struct ssl_control {
    struct ssl_control *next;
    int ssl_version;		/* sll protocol in use (2, 3, etc) */
    int cnx_state;		/* Connection state */
    /*
     * Communication stream.
     */
    void *tcp_ctx;		/* Context for TCP transport layer */
    int (*get)();		/* Read from client */
    int (*put)();		/* Write to client */
    int (*error)();		/* Report error */
    int max_io;			/* Largest I/O */
     /*
      * SSL record layer.
      */
     struct ssl_rec in_rec, out_rec;
     /*
      * connection state.
      */
};
typedef struct ssl_control *ssl_context;
#define SSL_CTX 1		/* Inhibits definition of ssl_context */
/*
 * Extern function prototypes.
 */
#include "ssl_server.h"		/* public functions */

int tssl_handshake ( ssl_context ctx );
