$ save_verify = 'f$verify(0)'
$!
$! Perform sanity checks on configuration file.  P1 is name of file.
$!
$! Currently, only checks done are that rule names are valid and that
$! named include files exist.
$!
$! Open specified file.
$ if P1 .eqs. "" then inquire P1 "Configuration file name"
$ if P1 .eqs. "" then exit
$ verstate = save_verify
$ if P2 .nes. "" then verstate = f$integer(p2)
$ depth = f$environment("DEPTH")
$ open cfile'depth' 'P1'
$ on error then goto cleanup
$ on control_y then goto cleanup
$!
$! Define www_root and www_system logicals if not defined.
$!
$ lintproc = f$environment("PROCEDURE")
$ mrg0 = f$extract(0,2*(depth-1),"                                          ")
$ mrg = mrg0 + "  "
$ say = "write sys$output"
$!
$ dlist = ",EXEC,MAP,PASS,FAIL,INCLUDE,ACCESSLOG,TRACELEVEL,USERDIR" + -
   ",USERMAP,REDIRECT,SUFFIX,PRESENTATION,DIRACCESS,WELCOME,AUTHENTICATOR" + -
   ",DEFPROT,HOSTPROT,PROTECT,DNSLOOKUP,TRACELEVEL,EVENTCOUNTER,HOSTNAME" + -
   ",LOCALADDRESS,PORT,THREADPOOL,SERVICE,HTBIN,MAPIMAGE,SEARCH,"
$ if f$trnlnm("www_root") .eqs. ""
$ then
$    root_dir = f$parse("1.;",lintproc,,,"NO_CONCEAL,SYNTAX_ONLY") - "][" - "]1.;"
$    l = f$length(root_dir)
$ trim_last:
$    l = l - 1
$    if f$extract(l,1,root_dir) .nes. "." .and. l .gt. 0 then goto trim_last
$    root_dir = f$extract(0,l,root_dir) + ".]"
$    say "Defining www_root as ", root_dir
$    define www_root 'root_dir'/trans=(term,conceal)
$ endif
$ if f$trnlnm("www_system") .eqs. ""
$ then
$    sys_dir = f$parse("1.;",lintproc,,,"NO_CONCEAL,SYNTAX_ONLY") - "][" - "]1.;"
$    sys_dir = sys_dir + "]"
$    say "Defining www_system as ", sys_dir
$    define www_system 'sys_dir'
$ endif
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! read file.
$ say mrg0, "Checking ", p1," ..."
$ cur_line = 0
$ next_rule:
$ rule = ""
$ next_line:
$    read/end=done cfile'depth' line
$    cur_line = cur_line + 1
$    rule = rule + f$edit(f$element(0,"#",line),"TRIM,COMPRESS")
$    if rule .eqs. "" then goto next_line
$    if f$extract(f$length(rule)-1,1,rule) .nes. "\" then goto parse_rule
$    rule = f$extract(0,f$length(rule)-1,rule)
$    goto next_line
$!
$ parse_rule:
$   if verstate then say mrg, cur_line,": ", rule
$   directive = f$edit(f$element(0," ",rule),"UPCASE")
$   arg1 = f$element(1," ",rule)
$   arg2 = f$element(2," ",rule)
$   voff = f$locate(","+directive+",",dlist) - f$length(dlist)
$   if voff .lt. 0 then goto chk_'directive'
$   say mrg, "!!!Bad directive, '", directive, -
	"' line ", cur_line
$   goto next_rule
$   chk_include:
$	jfspec = f$search(arg1)
$	if ( jfspec .eqs. "" ) then say mrg, -
		"!!!Include file '", arg1, "' missing, line ", cur_line
$       @'lintproc' 'arg1' 'verstate'
$    goto next_rule
$    chk_exec:
$    chk_map:
$    chk_pass:
$    chk_fail:
$    chk_accesslog:
$    chk_tracelvel:
$    chk_userdir:
$    chk_usermap:
$    chk_redirect:
$    chk_suffix:
$    chk_presentation:
$    chk_diraccess:
$    chk_welcome:
$    chk_authenticator:
$    chk_defprot:
$    chk_hostprot:
$    chk_protect:
$    chk_dnslookup:
$	if arg1 .eqs. " " then say mrg,"!!!Missing argument, line ", cur_line
$	goto next_rule
$    chk_tracelevel:
$    chk_eventcounter:
$    chk_hostname:
$    chk_localaddress:
$    chk_port:
$    chk_threadpool:
$    chk_service:
$    chk_htbin:
$    chk_mapimage:
$    chk_search:
$
$ checks_done:
$ goto next_rule
$!
$ done:
$ say mrg0, P1, " done, ", cur_line, " lines"
$ say ""
$ cleanup:
$ close cfile'depth'
$ save_verify = f$verify(save_verify)
