 /*  * actions.c  **  * Copyright -C- 1981 Giles C. Billingsley%  * sccsid "@(#)actions.c	1.1  9/5/83"1  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program ;  * KIC is available free of charge to any interested party.eB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */b  e    /*'  * Action routines for fast CIF parser.   * s9  * These routines handle both conversion from and to CIF.e?  * AEnd will be the last routine invoked in a successful parse.p  */x   #include "parser.h"  #include "cd.h"e  
 #ifdef vms #include <types.h> #include <timeb.h> #elsei #include <sys/types.h> #endif   #define	RADTODEG		57.29577951a   static int CurrentLayer; static char TypeOut[200];5     /* Library routines */ char *ctime(); char *strcpy();c double sin(), cos(); #ifndef vmsy char *sprintf(); #endif     AEnd(){      /*!      * The CIF parsing has ended.[      */[ #ifdef TRACEPARSER GenEnd(stderr);= #endif     }i     ABeginSymbol(SymbolNum,A,B)      int SymbolNum,A,B;     {y     /*E      * This routine begins the parsing action for a symbol definition D      * and performs all necessary initialization for the new symbol.      *      * DCONTROLCDTO:G      *    On the first pass, we add the symbol name to the symbol table H      *    which is in CDDesc.dSymTabNames.  To do this we have to switchE      *    according to the value of 'CDDesc.dProgram' which specifiesyE      *    the style of the CIF.  On the second pass, we open the FILEYG      *    descriptor for the KIC cell that coresponds to the respectiverF      *    CIF symbol and write the header information in the KIC cell.      *      * DCONTROLPCIF:G      *    On the first pass, we add the symbol name to the symbol table H      *    which is in CDDesc.dSymTabNames.  To do this we have to switchE      *    according to the value of 'CDDesc.dProgram' which specifies I      *    the style of the CIF.  Also, we open the symbol in the database E      *    via CDOpen() which places the symbol name in the hash table F      *    which is in CDSymbolTable.  We must not invoke CDClose sinceB      *    that will remove the symbol from memory;  the purpose ofE      *    DCONTROLPCIF is to construct the database in memory without E      *    relying on a KIC cell directory in the current search path. F      *    On the second pass, we need only invoke CDSymbol() to obtain5      *    the symbol desc. for the respective symbol.       *      * DCONTROLCDOPEN G      *    No action.  It is assumed that the file being parsed is a KIC @      *    cell which will always contain exactly one CIF symbol.      */      time_t Long1;      int Int1 = 0;    #ifdef TRACEPARSER% GenBeginSymbol(stderr,SymbolNum,A,B);  #endif     CurrentLayer = 0; K     if(CDDesc.dControl == DCONTROLCDTO Or CDDesc.dControl == DCONTROLPCIF){  	CDDesc.dRoot = False; 	CDDesc.dDSA = A;  	CDDesc.dDSB = B; 
         /*&          * We switch on the following:L          * k KIC:      A KIC symbol name follows a DS command as in 9 PadIn;O          * a Stanford: Stanford symbol name follows a DS command as in (PadIn); M          * b NCA:      An NCA symbol name follows a DS command as in (PadIn);M          * h IGS:      An IGS symbol name follows a DS command as in 9 PadIn; K          * i Icarus:   An Icarus name follows a DS command as in (9 PadIn); K          * s Sif:      A Sif name follows a DS command as in (Name: PadIn);           * n none of the above          */E 	if(CDDesc.dProgram == 'i'){ 	    /* B 	     * Icarus files have the symbol name in a comment of the form- 	     * (9 SymbolName); after the DS command.  	     */ 	    loop { 5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);o 		if(PReturned == PFAILED) 		    return(PFAILED);   		elif(PChar == '9') 		    break; 		}* 	    loop {i5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);d 		if(PReturned == PFAILED) 		    return(PFAILED); a 		elif(PChar == ')'){m% 		    CDDesc.dSymbolName[Int1] = EOS;t1 		    if(CDDesc.dNumSymbolTable < CDNUMREMEMBER){r6 			strcpy(CDDesc.dSymTabNames[CDDesc.dNumSymbolTable], 			    CDDesc.dSymbolName);d; 			CDDesc.dSymTabNumbers[CDDesc.dNumSymbolTable]=SymbolNum;f 			++CDDesc.dNumSymbolTable; 			} 		    }e 		elif(PChar == ';') 		    break; 		else { 		    if(Int1 < FILENAMESIZE)i& 			CDDesc.dSymbolName[Int1++] = PChar; 		    }t 		}  	    }8 	elif(CDDesc.dProgram == 'a' Or CDDesc.dProgram == 'b'){ 	    /**@ 	     * Some files have the symbol name in a comment of the form+ 	     * (SymbolName); after the DS command.y 	     */ 	    loop {a5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);  		if(PReturned == PFAILED) 		    return(PFAILED); s 		elif(PChar == '(') 		    break; 		}* 	    loop {C5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);  		if(PReturned == PFAILED) 		    return(PFAILED); s 		elif(PChar == ')'){ % 		    CDDesc.dSymbolName[Int1] = EOS; 1 		    if(CDDesc.dNumSymbolTable < CDNUMREMEMBER){r6 			strcpy(CDDesc.dSymTabNames[CDDesc.dNumSymbolTable], 			    CDDesc.dSymbolName); ; 			CDDesc.dSymTabNumbers[CDDesc.dNumSymbolTable]=SymbolNum;w 			++CDDesc.dNumSymbolTable; 			} 		    }o 		elif(PChar == ';') 		    break; 		else { 		    if(Int1 < FILENAMESIZE)e& 			CDDesc.dSymbolName[Int1++] = PChar; 		    }  		}n 	    } 	elif(CDDesc.dProgram == 's'){ 	    /*D? 	     * Sif files have the symbol name in a comment of the form 2 	     * ( Name: SymbolName); after the DS command. 	     */ 	    loop { 5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);e 		if(PReturned == PFAILED) 		    return(PFAILED); a 		elif(PChar == ':') 		    break; 		}c 	    loop {(5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);l 		if(PReturned == PFAILED) 		    return(PFAILED);   		elif(PChar == ')'){o% 		    CDDesc.dSymbolName[Int1] = EOS; 1 		    if(CDDesc.dNumSymbolTable < CDNUMREMEMBER){a6 			strcpy(CDDesc.dSymTabNames[CDDesc.dNumSymbolTable], 			    CDDesc.dSymbolName);a; 			CDDesc.dSymTabNumbers[CDDesc.dNumSymbolTable]=SymbolNum;i 			++CDDesc.dNumSymbolTable; 			} 		    }  		elif(PChar == ';') 		    break; 		else { 		    if(Int1 < FILENAMESIZE)N& 			CDDesc.dSymbolName[Int1++] = PChar; 		    }  		}	 	    } 	elif(CDDesc.dProgram == 'q'){ 	    /*)5 	     * SQUID files have the symbol name in the form  7 	     * 9 FullName; after the DS command where FullName 6 	     * is the full pathname to the cell or directory. 	     *u7 	     * NOTE: This code only works for UNIX file names.= 	     */! 	    char PrevName[FILENAMESIZE];S 	    loop {C5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);e 		if(PReturned == PFAILED) 		    return(PFAILED); s 		elif(PChar == '9') 		    break; 		}s 	    loop {y5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);n 		if(PReturned == PFAILED) 		    return(PFAILED);   		elif(PChar == ';'){s% 		    CDDesc.dSymbolName[Int1] = EOS;a4 		    if(Int1 == 1 And CDDesc.dSymbolName[0] == '.')' 			strcpy(CDDesc.dSymbolName,PrevName); 1 		    if(CDDesc.dNumSymbolTable < CDNUMREMEMBER){o6 			strcpy(CDDesc.dSymTabNames[CDDesc.dNumSymbolTable], 			    CDDesc.dSymbolName);c; 			CDDesc.dSymTabNumbers[CDDesc.dNumSymbolTable]=SymbolNum;y 			++CDDesc.dNumSymbolTable; 			} 		    break; 		    }  		elif(PChar == '/'){D5 		    /* begin new name; last name was a directory */a 		    Int1 = 0; * 		    strcpy(PrevName,CDDesc.dSymbolName); 		    }c 		else { 		    if(Int1 < FILENAMESIZE)y& 			CDDesc.dSymbolName[Int1++] = PChar; 		    }  		}* 	    }8 	elif(CDDesc.dProgram == 'h' Or CDDesc.dProgram == 'k'){ 	    /*=; 	     * IGS and KIC files have the symbol name in the form y+ 	     * 9 SymbolName; after the DS command.t 	     */ 	    loop {a5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);  		if(PReturned == PFAILED) 		    return(PFAILED);   		elif(PChar == '9') 		    break; 		}r 	    loop {d5 		PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);  		if(PReturned == PFAILED) 		    return(PFAILED); t 		elif(PChar == ';'){ % 		    CDDesc.dSymbolName[Int1] = EOS; 1 		    if(CDDesc.dNumSymbolTable < CDNUMREMEMBER){ 6 			strcpy(CDDesc.dSymTabNames[CDDesc.dNumSymbolTable], 			    CDDesc.dSymbolName); ; 			CDDesc.dSymTabNumbers[CDDesc.dNumSymbolTable]=SymbolNum;  			++CDDesc.dNumSymbolTable; 			} 		    break; 		    }; 		else { 		    if(Int1 < FILENAMESIZE)	& 			CDDesc.dSymbolName[Int1++] = PChar; 		    }E 		}	 	    }% 	if(CDDesc.dControl == DCONTROLPCIF){  	    if(CDDesc.dFirstPass){r 		/*< 		 * Open the symbol, but don't search the current directory8 		 * for a KIC cell.  Also, don't close the symbol since. 		 * that would remove the symbol from memory. 		 */o7 		for(Int1 = 0; Int1 < CDDesc.dNumSymbolTable; ++Int1){)9 		    if(CDDesc.dSymTabNumbers[Int1] == SymbolNum) break;	 		    }r, 	        if(Int1 == CDDesc.dNumSymbolTable){1 		    if(CDDesc.dNumSymbolTable < CDNUMREMEMBER){eE 	                sprintf(CDDesc.dSymTabNames[CDDesc.dNumSymbolTable],  			    "Symbol%d",SymbolNum);uI 	                CDDesc.dSymTabNumbers[CDDesc.dNumSymbolTable]=SymbolNum;c 			++CDDesc.dNumSymbolTable; 			}
 		    else 			return(PFAILED);T 		    }PN                 if(!CDOpen(CDDesc.dSymTabNames[Int1],&CDDesc.dSymbolDesc,'n')) 		    return(PFAILED);                 }o
 	    else{ 		/*7 		 * Symbol is already open.  Just get the desc for it.d 		 */I7 		for(Int1 = 0; Int1 < CDDesc.dNumSymbolTable; ++Int1){	9 		    if(CDDesc.dSymTabNumbers[Int1] == SymbolNum) break;d 		    }S, 	        if(Int1 == CDDesc.dNumSymbolTable){ 		    return(PFAILED); 		    }.>     		CDSymbol(CDDesc.dSymTabNames[Int1],&CDDesc.dSymbolDesc);! 		if(CDDesc.dSymbolDesc == NULL){C 		    return(PFAILED); 		    }S 		}N$ 	    CDDesc.dControl = DCONTROLPCIF; 	    }' 	elif(CDDesc.dControl == DCONTROLCDTO){r 	    if(CDDesc.dFirstPass) 	        return(PSUCCEEDED);% 	    if(CDDesc.dSymbolName[0] == EOS)	: 	        sprintf(CDDesc.dSymbolName,"Symbol%d",SymbolNum);? 	    if((CDDesc.dSymbolFileDesc = POpen(CDDesc.dSymbolName,"w",m' 		(char *)NULL,(char **)NULL)) == NULL)  	        return(PFAILED);a7 	    sprintf(TypeOut," Symbol %s ",CDDesc.dSymbolName);G0 	    GenComment(CDDesc.dSymbolFileDesc,TypeOut);" 	    Long1 = time((time_t *)NULL);G 	    sprintf(TypeOut," Creation Date: %.24s ",ctime((time_t *)&Long1));C0 	    GenComment(CDDesc.dSymbolFileDesc,TypeOut);E 	    GenUserExtension(CDDesc.dSymbolFileDesc,'9',CDDesc.dSymbolName);o2 	    GenBeginSymbol(CDDesc.dSymbolFileDesc,0,1,1);! 	    CDDesc.dSymbolName[0] = EOS;) 	    } 	},     elif(CDDesc.dControl == DCONTROLCDOPEN){+         /* add property list information */D)         while(CDDesc.dPrptyList != NULL){s#             struct prpty PrptyCopy;SE             if(Not CDAddProperty(CDDesc.dSymbolDesc,(struct o *)NULL,DI 	        CDDesc.dPrptyList->prpty_Value,CDDesc.dPrptyList->prpty_String))  		return(PFAILED);3             /* free storage of CDDesc.dPrptyList */m+             PrptyCopy = *CDDesc.dPrptyList; 2             free(CDDesc.dPrptyList->prpty_String);4             free((struct prpty *)CDDesc.dPrptyList);5             CDDesc.dPrptyList = PrptyCopy.prpty_Succ;.
             }l 	}     return(PSUCCEEDED);a     }     
 AEndSymbol(){r     /*D      * This routine performs the necessary actions to close a symbol      * definition.      *      * DCONTROLCDTO:H      *     Return on first pass (we are only building the symbol table).B      *     On the second pass, we terminate and close the KIC cell0      *     containing the respective CIF symbol.      *      * DCONTROLPCIF:H      *     We set the current cell desc in CDDesc.dSymbolDesc to that of      *     the root symbol.d      *      * DCONTROLCDOPEN:      *     No action.s      */N #ifdef TRACEPARSER GenEndSymbol(stderr);  #endif(     if(CDDesc.dControl == DCONTROLCDTO){ 	if(CDDesc.dFirstPass) 	    return;& 	GenEndSymbol(CDDesc.dSymbolFileDesc);  	GenEnd(CDDesc.dSymbolFileDesc);  	fclose(CDDesc.dSymbolFileDesc); 	CDDesc.dRoot = True;  	}*     elif(CDDesc.dControl == DCONTROLPCIF){+ 	CDDesc.dSymbolDesc = CDDesc.dRootCellDesc;y 	CDDesc.dRoot = True;  	},     elif(CDDesc.dControl == DCONTROLCDOPEN){* 	if(CDDesc.dSymbolDesc->sLeft == INFINITY)< 	    CDDesc.dSymbolDesc->sLeft = CDDesc.dSymbolDesc->sBottom> 		= CDDesc.dSymbolDesc->sRight = CDDesc.dSymbolDesc->sTop = 0; 	/*T9 	 * Force the dummy call command at the end of the symbol	  	 * to be ignored by ABeginCall. 	 */ 	CDDesc.dSymbolName[0] = EOS;e 	}     }S     ADeleteSymbol(SymbolNum)     int SymbolNum;     {	     /*.      * We do not deal with definition deletes.B      * It could be handled by using the symbol table to obtain theD      * respective symbol numbers, and invoking CDClose on those cell!      * definitions to be deleted.	      */	   #ifdef TRACEPARSER% fprintf(stderr,"DD %d;\n",SymbolNum);  #endif     /*      *Ignore DD commands.c      */ K     fprintf(stderr,"Definition Delete of Symbol %d - ignored\n",SymbolNum);      }M     AEndCall(){  #ifdef TRACEPARSER fprintf(stderr,";\n"); #endif(     if(CDDesc.dControl == DCONTROLCDTO){ 	if(CDDesc.dFirstPass) 	    return(PSUCCEEDED); 	if(CDDesc.dRoot)o& 	    GenEndCall(CDDesc.dRootFileDesc); 	else ( 	    GenEndCall(CDDesc.dSymbolFileDesc); 	}O     elif(CDDesc.dControl == DCONTROLCDOPEN Or CDDesc.dControl == DCONTROLPCIF){e: 	if(CDDesc.dFirstPass And CDDesc.dControl == DCONTROLPCIF) 	    return(PSUCCEEDED);: 	if(Not CDEndMakeCall(CDDesc.dSymbolDesc,CDDesc.dPointer)) 	    return(PFAILED);p" 	while(CDDesc.dPrptyList != NULL){ 	    struct prpty PrptyCopy;= 	    if(Not CDAddProperty(CDDesc.dSymbolDesc,CDDesc.dPointer,;B 		CDDesc.dPrptyList->prpty_Value,CDDesc.dPrptyList->prpty_String)) 		return(PFAILED);, 	    /* free storage of CDDesc.dPrptyList */$ 	    PrptyCopy = *CDDesc.dPrptyList;+ 	    free(CDDesc.dPrptyList->prpty_String);d- 	    free((struct prpty *)CDDesc.dPrptyList);*. 	    CDDesc.dPrptyList = PrptyCopy.prpty_Succ; 	    } 	}     return(PSUCCEEDED);      }p     AT(Type,X,Y)     char Type;     int X,Y;     {n #ifdef TRACEPARSER' fprintf(stderr," T:%c %d %d",Type,X,Y);I #endif(     if(CDDesc.dControl == DCONTROLCDTO){ 	if(CDDesc.dFirstPass) 	    return(PSUCCEEDED); 	if(Type == CDTRANSLATE) 	    if(CDDesc.dRoot) & 		GenTranslation(CDDesc.dRootFileDesc,4 		    X*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB,5 		    Y*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB);t0 	    else GenTranslation(CDDesc.dSymbolFileDesc,4 		    X*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB,5 		    Y*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB);C 	elif(Type == CDROTATE){" 	    if(abs(X) > 1 Or abs(Y) > 1){5 		X = X*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;	C5 		Y = Y*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;	f 		}I 	    if(CDDesc.dRoot)S( 		GenRotation(CDDesc.dRootFileDesc,X,Y);	 	    elseD* 		GenRotation(CDDesc.dSymbolFileDesc,X,Y); 	    } 	elif(Type == CDMIRRORX) 	    if(CDDesc.dRoot)h# 		GenMirrorX(CDDesc.dRootFileDesc);e	 	    elseC% 		GenMirrorX(CDDesc.dSymbolFileDesc);S 	elif(Type == CDMIRRORY) 	    if(CDDesc.dRoot) # 		GenMirrorY(CDDesc.dRootFileDesc);*	 	    elsed% 		GenMirrorY(CDDesc.dSymbolFileDesc);  	}O     elif(CDDesc.dControl == DCONTROLCDOPEN Or CDDesc.dControl == DCONTROLPCIF){m: 	if(CDDesc.dFirstPass And CDDesc.dControl == DCONTROLPCIF) 	    return(PSUCCEEDED);' 	return(CDT(CDDesc.dPointer,Type,X,Y));D 	}     return(PSUCCEEDED);      }      ABeginCall(SymbolNum)      int SymbolNum;     {r
     int Int1;l #ifdef TRACEPARSER" fprintf(stderr,"C %d ",SymbolNum); #endifK     if(CDDesc.dControl == DCONTROLPCIF Or CDDesc.dControl == DCONTROLCDTO){r 	if(CDDesc.dFirstPass) 	    return(PSUCCEEDED); 	if(CDDesc.dProgram != 'n'){: 	    for(Int1 = 0; Int1 < CDDesc.dNumSymbolTable; ++Int1){5 		if(CDDesc.dSymTabNumbers[Int1] == SymbolNum) break;C 		}. 	    } 	}(     if(CDDesc.dControl == DCONTROLCDTO){> 	if(CDDesc.dProgram != 'n' And Int1 < CDDesc.dNumSymbolTable){6 	    sprintf(TypeOut," %s",CDDesc.dSymTabNames[Int1]); 	    if(CDDesc.dRoot)05 		GenUserExtension(CDDesc.dRootFileDesc,'9',TypeOut);D	 	    elseN7 		GenUserExtension(CDDesc.dSymbolFileDesc,'9',TypeOut);( 	    }$ 	elif(CDDesc.dSymbolName[0] != EOS){/ 	    sprintf(TypeOut," %s",CDDesc.dSymbolName);a 	    if(CDDesc.dRoot)y5 		GenUserExtension(CDDesc.dRootFileDesc,'9',TypeOut);e	 	    elseD7 		GenUserExtension(CDDesc.dSymbolFileDesc,'9',TypeOut);  	    } 	else {e6 	    sprintf(CDDesc.dSymbolName,"Symbol%d",SymbolNum);, 	    sprintf(TypeOut," Symbol%d",SymbolNum); 	    if(CDDesc.dRoot)S5 		GenUserExtension(CDDesc.dRootFileDesc,'9',TypeOut);o	 	    else 7 		GenUserExtension(CDDesc.dSymbolFileDesc,'9',TypeOut);" 	    } 	if(CDDesc.dRoot))* 	    GenBeginCall(CDDesc.dRootFileDesc,0); 	else 4 	    GenBeginCall(CDDesc.dSymbolFileDesc,SymbolNum); 	CDDesc.dSymbolName[0] = EOS;e 	}*     elif(CDDesc.dControl == DCONTROLPCIF){> 	if(CDDesc.dProgram != 'n' And Int1 < CDDesc.dNumSymbolTable){: 	    strcpy(CDDesc.dSymbolName,CDDesc.dSymTabNames[Int1]); 	    } 	else {x6 	    sprintf(CDDesc.dSymbolName,"Symbol%d",SymbolNum); 	    }> 	if(Not CDBeginMakeCall(CDDesc.dSymbolDesc,CDDesc.dSymbolName,G 	    CDDesc.dNumX,CDDesc.dDX,CDDesc.dNumY,CDDesc.dDY,&CDDesc.dPointer)){ 	    return(PFAILED);t 	CDDesc.dSymbolName[0] = EOS; ! 	CDDesc.dNumX = CDDesc.dNumY = 1;  	CDDesc.dDX = CDDesc.dDY = 0;o'         CDDesc.dControl = DCONTROLPCIF;D 	},     elif(CDDesc.dControl == DCONTROLCDOPEN){! 	if(CDDesc.dSymbolName[0] != EOS)rB 	    if(Not CDBeginMakeCall(CDDesc.dSymbolDesc,CDDesc.dSymbolName,2 		CDDesc.dNumX,CDDesc.dDX,CDDesc.dNumY,CDDesc.dDY, 		&CDDesc.dPointer)) 		return(PFAILED); 	CDDesc.dSymbolName[0] = EOS;i! 	CDDesc.dNumX = CDDesc.dNumY = 1;e 	CDDesc.dDX = CDDesc.dDY = 0;d 	}     return(PSUCCEEDED);.     }i     APolygon(Path)     struct p *Path;      {r     struct p *Pair;d #ifdef TRACEPARSER GenPolygon(stderr,Path); #endif(     if(CDDesc.dControl == DCONTROLCDTO){' 	int NumVertices,Left,Bottom,Right,Top;L 	if(CDDesc.dFirstPass) 	    return(PSUCCEEDED);
 	Pair = Path;T 	NumVertices = 0;( 	Left = Bottom = INFINITY; 	Right = Top = -INFINITY;r 	while(Pair != NULL){D 	    if(Pair->pX < Left) 		Left = Pair->pX; 	    if(Pair->pX > Right)C 		Right = Pair->pX;d 	    if(Pair->pY < Bottom) 		Bottom = Pair->pY; 	    if(Pair->pY > Top){ 		Top = Pair->pY;a 	    ++NumVertices;b 	    Pair = Pair->pSucc; 	    } 	if(NumVertices == 4){( 	    if((Path->pX == Path->pSucc->pX And/ 		Path->pSucc->pY == Path->pSucc->pSucc->pY Andn= 		Path->pSucc->pSucc->pX == Path->pSucc->pSucc->pSucc->pX Ando, 		Path->pY == Path->pSucc->pSucc->pSucc->pY) 		Or" 		(Path->pY == Path->pSucc->pY And/ 		Path->pSucc->pX == Path->pSucc->pSucc->pX And}= 		Path->pSucc->pSucc->pY == Path->pSucc->pSucc->pSucc->pY And%- 		Path->pX == Path->pSucc->pSucc->pSucc->pX))y 		{e: 		return(ABox(Right-Left,Top-Bottom,Left+((Right-Left)/2),$ 		    Bottom+((Top-Bottom)/2),1,0)); 		}s 	    }
 	Pair = Path;} 	while(Pair != NULL){fE 	    Pair->pX = Pair->pX*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;oE 	    Pair->pY = Pair->pY*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;o 	    Pair = Pair->pSucc; 	    } 	if(CDDesc.dRoot)i+ 	    GenPolygon(CDDesc.dRootFileDesc,Path);  	else(- 	    GenPolygon(CDDesc.dSymbolFileDesc,Path);i 	}O     elif(CDDesc.dControl == DCONTROLCDOPEN Or CDDesc.dControl == DCONTROLPCIF){m: 	if(CDDesc.dFirstPass And CDDesc.dControl == DCONTROLPCIF) 	    return(PSUCCEEDED);; 	if(Not CDMakePolygon(CDDesc.dSymbolDesc,CurrentLayer,Path,e 	    &CDDesc.dPointer))m 	    return(PFAILED);}" 	while(CDDesc.dPrptyList != NULL){ 	    struct prpty PrptyCopy;= 	    if(Not CDAddProperty(CDDesc.dSymbolDesc,CDDesc.dPointer,mB 		CDDesc.dPrptyList->prpty_Value,CDDesc.dPrptyList->prpty_String)) 		return(PFAILED);, 	    /* free storage of CDDesc.dPrptyList */$ 	    PrptyCopy = *CDDesc.dPrptyList;+ 	    free(CDDesc.dPrptyList->prpty_String);D- 	    free((struct prpty *)CDDesc.dPrptyList);D. 	    CDDesc.dPrptyList = PrptyCopy.prpty_Succ; 	    } 	}     return(PSUCCEEDED);e     }C     AWire(Width,Path)C     struct p *Path;	     int Width;     {,     struct p *Pair;D #ifdef TRACEPARSER GenWire(stderr,Width,Path);D #endif(     if(CDDesc.dControl == DCONTROLCDTO){ 	if(CDDesc.dFirstPass) 	    return(PSUCCEEDED);
 	Pair = Path;C 	while(Pair != NULL){PE 	    Pair->pX = Pair->pX*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;fE 	    Pair->pY = Pair->pY*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;= 	    Pair = Pair->pSucc; 	    } 	if(CDDesc.dRoot)TZ 	    GenWire(CDDesc.dRootFileDesc,Width*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB,Path); 	else \ 	    GenWire(CDDesc.dSymbolFileDesc,Width*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB,Path); 	}O     elif(CDDesc.dControl == DCONTROLCDOPEN Or CDDesc.dControl == DCONTROLPCIF){D: 	if(CDDesc.dFirstPass And CDDesc.dControl == DCONTROLPCIF) 	    return(PSUCCEEDED);> 	if(Not CDMakeWire(CDDesc.dSymbolDesc,CurrentLayer,Width,Path, 	    &CDDesc.dPointer))D 	    return(PFAILED);e" 	while(CDDesc.dPrptyList != NULL){ 	    struct prpty PrptyCopy;= 	    if(Not CDAddProperty(CDDesc.dSymbolDesc,CDDesc.dPointer,cB 		CDDesc.dPrptyList->prpty_Value,CDDesc.dPrptyList->prpty_String)) 		return(PFAILED);, 	    /* free storage of CDDesc.dPrptyList */$ 	    PrptyCopy = *CDDesc.dPrptyList;+ 	    free(CDDesc.dPrptyList->prpty_String);d- 	    free((struct prpty *)CDDesc.dPrptyList);e. 	    CDDesc.dPrptyList = PrptyCopy.prpty_Succ; 	    } 	}     return(PSUCCEEDED);c     }l    , ABox(Length,Width,X,Y,XDirection,YDirection)/     int Length,Width,X,Y,XDirection,YDirection;F     {) #ifdef TRACEPARSER6 GenBox(stderr,Length,Width,X,Y,XDirection,YDirection); #endif(     if(CDDesc.dControl == DCONTROLCDTO){ 	if(CDDesc.dFirstPass) 	    return(PSUCCEEDED);= 	Length = Length*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;P; 	Width = Width*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;s3 	X = X*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;S3 	Y = Y*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB; ) 	if(XDirection == 1 And YDirection == 0){B 	    if(CDDesc.dRoot) / 		GenBox(CDDesc.dRootFileDesc,Length,Width,X,Y,T 		    XDirection,YDirection);o	 	    elseN1 		GenBox(CDDesc.dSymbolFileDesc,Length,Width,X,Y,L 		    XDirection,YDirection);  	    } 	else {; 	    /*(/ 	     * Transform non-Manhattan box to polygon.( 	     */
 	    float C;t  	    int Left,Bottom,Right,Top;  	    struct p *Path,*Pair;   	    Left = X-(Length >> 1); 	    Right = X+(Length >> 1);V 	    Bottom = Y-(Width >> 1);p 	    Top = Y+(Width >> 1);E 	    C = sqrt((double)(XDirection*XDirection+YDirection*YDirection));tE 	    if((Pair = Path = (struct p *)malloc(sizeof(struct p))) == NULL)a 		return(AMallocFailed());3 	    Pair->pX = (Left*XDirection-Bottom*YDirection-n! 		XDirection*X+YDirection*Y)/C+X;d3 	    Pair->pY = (Left*YDirection+Bottom*XDirection- ! 		YDirection*X-XDirection*Y)/C+Y;p* 	    if((Pair = Pair->pSucc = (struct p *)$ 		malloc(sizeof(struct p))) == NULL) 		return(AMallocFailed());0 	    Pair->pX = (Left*XDirection-Top*YDirection-! 		XDirection*X+YDirection*Y)/C+X;i0 	    Pair->pY = (Left*YDirection+Top*XDirection-! 		YDirection*X-XDirection*Y)/C+Y;s* 	    if((Pair = Pair->pSucc = (struct p *)$ 		malloc(sizeof(struct p))) == NULL) 		return(AMallocFailed());1 	    Pair->pX = (Right*XDirection-Top*YDirection-o! 		XDirection*X+YDirection*Y)/C+X;i1 	    Pair->pY = (Right*YDirection+Top*XDirection-r! 		YDirection*X-XDirection*Y)/C+Y;i* 	    if((Pair = Pair->pSucc = (struct p *)$ 		malloc(sizeof(struct p))) == NULL) 		return(AMallocFailed());4 	    Pair->pX = (Right*XDirection-Bottom*YDirection-! 		XDirection*X+YDirection*Y)/C+X;y4 	    Pair->pY = (Right*YDirection+Bottom*XDirection-! 		YDirection*X-XDirection*Y)/C+Y;i 	    Pair->pSucc = NULL; 	    if(CDDesc.dRoot) ( 		GenPolygon(CDDesc.dRootFileDesc,Path);	 	    elseL* 		GenPolygon(CDDesc.dSymbolFileDesc,Path); 	    } 	}O     elif(CDDesc.dControl == DCONTROLCDOPEN Or CDDesc.dControl == DCONTROLPCIF){p: 	if(CDDesc.dFirstPass And CDDesc.dControl == DCONTROLPCIF) 	    return(PSUCCEEDED);? 	if(Not CDMakeBox(CDDesc.dSymbolDesc,CurrentLayer,Length,Width,n 	    X,Y,&CDDesc.dPointer))R 	    return(PFAILED);W" 	while(CDDesc.dPrptyList != NULL){ 	    struct prpty PrptyCopy;= 	    if(Not CDAddProperty(CDDesc.dSymbolDesc,CDDesc.dPointer,DB 		CDDesc.dPrptyList->prpty_Value,CDDesc.dPrptyList->prpty_String)) 		return(PFAILED);, 	    /* free storage of CDDesc.dPrptyList */$ 	    PrptyCopy = *CDDesc.dPrptyList;+ 	    free(CDDesc.dPrptyList->prpty_String);s- 	    free((struct prpty *)CDDesc.dPrptyList);r. 	    CDDesc.dPrptyList = PrptyCopy.prpty_Succ; 	    } 	}     return(PSUCCEEDED);Y     }      ARoundFlash(Width,X,Y)     int Width,X,Y;     {.     struct p *Path, *NewPath;Y     struct p Pair;     /*L      *KIC DOES NOT SUPPORT ROUND FLASHES: convert to a wire with one vertex.=      *Therefore, KIC will never try to generate a Roundflash.p      */s(     if(CDDesc.dControl == DCONTROLCDTO){ 	if(CDDesc.dFirstPass) 	    return(PSUCCEEDED);9 	Pair.pX = X*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;C9 	Pair.pY = Y*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB;c 	Pair.pSucc = NULL;p 	if(CDDesc.dRoot)o[ 	    GenWire(CDDesc.dRootFileDesc,Width*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB,&Pair);a 	else ] 	    GenWire(CDDesc.dSymbolFileDesc,Width*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB,&Pair);  	}O     elif(CDDesc.dControl == DCONTROLCDOPEN Or CDDesc.dControl == DCONTROLPCIF){T: 	if(CDDesc.dFirstPass And CDDesc.dControl == DCONTROLPCIF) 	    return(PSUCCEEDED);D 	if((NewPath = Path = (struct p *)malloc(sizeof(struct p))) != NULL) 	    return(AMallocFailed());s 	NewPath->pX = X;- 	NewPath->pY = Y;s 	NewPath->pSucc = NULL;A> 	if(Not CDMakeWire(CDDesc.dSymbolDesc,CurrentLayer,Width,Path, 	    &CDDesc.dPointer))e 	    return(PFAILED); " 	while(CDDesc.dPrptyList != NULL){ 	    struct prpty PrptyCopy;= 	    if(Not CDAddProperty(CDDesc.dSymbolDesc,CDDesc.dPointer,OB 		CDDesc.dPrptyList->prpty_Value,CDDesc.dPrptyList->prpty_String)) 		return(PFAILED);, 	    /* free storage of CDDesc.dPrptyList */$ 	    PrptyCopy = *CDDesc.dPrptyList;+ 	    free(CDDesc.dPrptyList->prpty_String);e- 	    free((struct prpty *)CDDesc.dPrptyList); . 	    CDDesc.dPrptyList = PrptyCopy.prpty_Succ; 	    } 	}     return(PSUCCEEDED);d     }s     ALayer(Technology,Mask)i     char Technology,Mask[];P     {;     int Layer; #ifdef TRACEPARSER! GenLayer(stderr,Technology,Mask);c #endif(     if(CDDesc.dControl == DCONTROLCDTO){ 	if(CDDesc.dFirstPass) 	    return(PSUCCEEDED); 	if(CDDesc.dRoot).4 	    GenLayer(CDDesc.dRootFileDesc,Technology,Mask); 	elseU6 	    GenLayer(CDDesc.dSymbolFileDesc,Technology,Mask); 	return(PSUCCEEDED); 	}O     elif(CDDesc.dControl == DCONTROLCDOPEN Or CDDesc.dControl == DCONTROLPCIF){c- 	for(Layer = 1;Layer <= CDNUMLAYERS;++Layer){t4 	    if(CDLayer[Layer].lTechnology == Technology And( 		CDLayer[Layer].lMask[0] == Mask[0] And( 		CDLayer[Layer].lMask[1] == Mask[1] And& 		CDLayer[Layer].lMask[2] == Mask[2]){ 		CurrentLayer = Layer;a 		return(PSUCCEEDED);  		}f 	    } 	/*T+ 	 * Layer is not defined in CD layer table!CC 	 * If parsing CIF and layer is unknown, put it in the layer table. > 	 * If opening a cell and layer is unknown, complain about it. 	 */% 	if(CDDesc.dControl == DCONTROLPCIF){ 1 	    for(Layer = 1;Layer <= CDNUMLAYERS;++Layer){v0 	        if(CDLayer[Layer].lTechnology == ' ') {1 	            CDSetLayer(Layer, Technology, Mask);*" 	            CurrentLayer = Layer;  	            return(PSUCCEEDED); 		    }r 		}C 	    } 	CurrentLayer = 1; 	}     return(PFAILED);     }.     AUserExtension(Digit,Text)     char Digit;.     char *Text;      {S     int X,Y,Layer;     char Label[81];n   #ifdef TRACEPARSER$ GenUserExtension(stderr,Digit,Text); #endif(     if(CDDesc.dControl == DCONTROLCDTO){0 	if(CDDesc.dFirstPass Or CDDesc.dProgram == 'n') 	    return(PSUCCEEDED); 	/*}C 	 * When converting to KIC format, we pass CD user extensions only.O2 	 * If we find an illegal extension, we ignore it. 	 */ D 	if(Digit == '9'){ 	    if(Text[0] == '4'){6 		if(CDDesc.dProgram == 'm'){		/* mextra text label */? 		    if(sscanf(&(Text[1]),"%s%d%d%s",Label,&X,&Y,TypeOut) < 4)a 			return(PFAILED);h 		    if(CDDesc.dRoot){ @ 		        GenLayer(CDDesc.dRootFileDesc,TypeOut[0],&TypeOut[1]); 		        }e 		    else{(B 		        GenLayer(CDDesc.dSymbolFileDesc,TypeOut[0],&TypeOut[1]); 		        }  		    }D! 		else{					/* normal CD label */s. 		    sscanf(&(Text[1]),"%s%d%d",Label,&X,&Y); 		    }p% 		sprintf(TypeOut,"4 %s %d %d",Label,D4 		    X*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB,5 		    Y*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB);t 		if(CDDesc.dRoot){e9 		    GenUserExtension(CDDesc.dRootFileDesc,'9',TypeOut);s 		    }i 		else{y; 		    GenUserExtension(CDDesc.dSymbolFileDesc,'9',TypeOut);s 		    }y 		}c- 	    elif(Text[0] == '2'){			 /* NCA Label */ 3 		sscanf(&(Text[1]),"%s%d%d%d",Label,&X,&Y,&Layer);d" 		sprintf(TypeOut,"%d    ",Layer); 		if(CDDesc.dRoot){ < 		    GenLayer(CDDesc.dRootFileDesc,TypeOut[0],&TypeOut[1]); 		    }D 		else{t> 		    GenLayer(CDDesc.dSymbolFileDesc,TypeOut[0],&TypeOut[1]); 		    }n% 		sprintf(TypeOut,"4 %s %d %d",Label,,4 		    X*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB,5 		    Y*CDDesc.dB*CDDesc.dDSA/CDDesc.dA/CDDesc.dDSB);I 		if(CDDesc.dRoot){L9 		    GenUserExtension(CDDesc.dRootFileDesc,'9',TypeOut);h 		    }  		else{y; 		    GenUserExtension(CDDesc.dSymbolFileDesc,'9',TypeOut);e 		    }1 		}M 	    else {	 		/* symbol name */2 		if(Text[0] == ' '), 		    strcpy(CDDesc.dSymbolName,&(Text[1]));' 		else strcpy(CDDesc.dSymbolName,Text);d 		if(CDDesc.dRoot)8 		    GenUserExtension(CDDesc.dRootFileDesc,Digit,Text); 		else: 		    GenUserExtension(CDDesc.dSymbolFileDesc,Digit,Text); 		}  	    }9 	elif(Digit == '5' And (Text[0] < '0' Or Text[0] > '9')){;3 	    /* Reserved for CD property list extensions */  	    if(CDDesc.dRoot)o4 		GenUserExtension(CDDesc.dRootFileDesc,Digit,Text);	 	    else	6 		GenUserExtension(CDDesc.dSymbolFileDesc,Digit,Text); 	    } 	}O     elif(CDDesc.dControl == DCONTROLCDOPEN Or CDDesc.dControl == DCONTROLPCIF){P 	/*p; 	 * When parsing CIF, we accept only CD user extensions ande" 	 * ignore any illegal extensions. 	 */ 	if(Digit == '9'){ 	    if(Text[0] == '4'){
 		/* Label */i* 		sscanf(&(Text[1]),"%s%d%d",Label,&X,&Y);B 	        if(CDDesc.dFirstPass And CDDesc.dControl == DCONTROLPCIF)  	            return(PSUCCEEDED); #ifdef DEBUG: fprintf(stderr,"Making label on layer %d\n",CurrentLayer); #endif; 		if(Not CDMakeLabel(CDDesc.dSymbolDesc,CurrentLayer,Label,D 		    X,Y,&CDDesc.dPointer)) 		    return(PFAILED);# 		while(CDDesc.dPrptyList != NULL){e 		    struct prpty PrptyCopy;d. 		    if(Not CDAddProperty(CDDesc.dSymbolDesc,2 			CDDesc.dPointer,CDDesc.dPrptyList->prpty_Value,5 			CDDesc.dPrptyList->prpty_String)) return(PFAILED);P- 		    /* free storage of CDDesc.dPrptyList */s% 		    PrptyCopy = *CDDesc.dPrptyList;P, 		    free(CDDesc.dPrptyList->prpty_String);. 		    free((struct prpty *)CDDesc.dPrptyList);/ 		    CDDesc.dPrptyList = PrptyCopy.prpty_Succ;  		    }r 		}r* 	    elif(Text[0] < '0' Or Text[0] > '9'){ 		/* Symbol name */p 		X = 0; 		while(Text[X] <= ' ') ++X;( 		strcpy(CDDesc.dSymbolName,&(Text[X])); 		}e 	    }9 	elif(Digit == '1' And (Text[0] < '0' Or Text[0] > '9')){T+ 	    /* Reserved for CD Array extensions */L 	    sscanf(Text,"%s",TypeOut);a& 	    if(strcmp(TypeOut,"Array") == 0){= 		sscanf(Text,"%s%d%d%d%d",TypeOut,&CDDesc.dNumX,&CDDesc.dDX,e! 		    &CDDesc.dNumY,&CDDesc.dDY);r 		}C 	    }9 	elif(Digit == '5' And (Text[0] < '0' Or Text[0] > '9')){n3 	    /* Reserved for CD Property List extensions */  	    struct prpty *PDesc;u 	    unsigned int size;	 	    int i;d  E 	    if((PDesc = (struct prpty *)malloc(sizeof(struct prpty)))==NULL)c 		return(PFAILED);2 	    if(sscanf(Text,"%d",&PDesc->prpty_Value) < 1) 		return(PFAILED); 	    i = 0; 3 	    /* skip white space before property integer */FE 	    while((Text[i] < '0' Or Text[i] > '9') And Text[i] != NULL) ++i;*  	    /* skip property integer */2 	    while(Text[i] >= '0' And Text[i] <= '9') ++i;D 	    /* skip white space and control chars after property integer */3 	    while(Text[i] <= ' ' And Text[i] != NULL) ++i;U$ 	    size = strlen(&(Text[i])) + 2; 5 	    if((PDesc->prpty_String = malloc(size)) == NULL)0 		return(PFAILED);, 	    strcpy(PDesc->prpty_String,&(Text[i]));+ 	    PDesc->prpty_Succ = CDDesc.dPrptyList;e  	    CDDesc.dPrptyList = PDesc;  	    } 	}     return(PSUCCEEDED);E     }n     AComment(Text)     char *Text;      {  #ifdef TRACEPARSER GenComment(stderr,Text); #endif(     if(CDDesc.dControl == DCONTROLCDTO){ 	if(Not CDDesc.dFirstPass){n 	    if(CDDesc.dRoot)n/ 	        GenComment(CDDesc.dRootFileDesc,Text);(	 	    else'1 	        GenComment(CDDesc.dSymbolFileDesc,Text);a 	    } 	}     }%     AMallocFailed(){-     sprintf(CDStatusString,"Out of memory.");=!     CDStatusInt = CDMALLOCFAILED;(     return(PFAILED);     }p