 /*
  * basic.c  **  * Copyright -C- 1981 Giles C. Billingsley#  * sccsid "@(#)basic.c	1.1  9/5/83"h  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programu;  * KIC is available free of charge to any interested party.TB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */n     n /*  * The KIC basic menu code.m  */.   #include "kic.h"
 #ifdef vms #include <types.h> #elseP #include <sys/types.h> #endif   /* Library routines */ char *strcpy();r #ifndef vms  char *sprintf(); #endif   char TypeOut[200];   Basic(){     int LookedAhead = False;     char *TypeIn;L       InitVLT();     FBForeground(ERASE,0);     FBFlood();     ShowBasicMenu();     ShowLayerTable();t'     if(Parameters.kpCellName[0] != EOS)a 	/*o1 	 * User invoked KIC with a cell name in argv[.].) 	 */ 	Edit(True,True,False); 
     else { 	/*P 	 * Show the KIC logo. 	 */ 	ShowLayout(); 	KIC();0 	FBTransfer(); 	}
     loop { 	InitSignals();	 	if(Not LookedAhead)
 	    Point();t 	elser 	    LookedAhead = False;t% 	if(Parameters.kpCellName[0] == EOS){y 	    /* < 	     * The CD package doesn't check the integrity of symbol; 	     * descriptors and now Parameters.kpCellDesc == NULL.  ; 	     * Except for a few commands, each command invokes the : 	     * CD package.  If such a command is invoked now, the@ 	     * CD package will crash and thus KIC will.  So, force userB 	     * to select a cell to edit before invoking any such command. 	     */: 	    if(Not (strcmp(Parameters.kpCommand,MenuEDIT) == 0 Or0 		strcmp(Parameters.kpCommand,MenuDEBUG) == 0 Or. 		strcmp(Parameters.kpCommand,MenuDIR) == 0 Or0 		strcmp(Parameters.kpCommand,MenuABORT) == 0)){5 		ShowPrompt("You haven't selected a cell to edit.");; 		continue;e 		}y 	    }0 	if(strcmp(Parameters.kpCommand,MenuEDIT) == 0){! 	    Parameters.kpNumWindows = 0;s 	    Edit(False,True,False); 	    }3 	elif(strcmp(Parameters.kpCommand,MenuABORT) == 0){s 	    MenuSelect(MenuABORT);]C 	    if(Parameters.kpModified And Parameters.kpCellName[0] != EOS){(7 		ShowPrompt("You've modified this cell.  Abort(N)?"); ! 		FBKeyboard(&TypeIn);+ 		if(TypeIn[0] == 'Y' Or TypeIn[0] == 'y'){} 		    FBEnd(); 		    exit(0); 		    }e 		else MenuDeselect(MenuABORT);s 		}  	    else {[
 		FBEnd();
 		exit(0); 		}a 	    }2 	elif(strcmp(Parameters.kpCommand,MenuEXPND) == 0) 	    Expand();1 	elif(strcmp(Parameters.kpCommand,MenuPEEK) == 0)l 	    Peek();1 	elif(strcmp(Parameters.kpCommand,Menu45S) == 0){n 	    if(Parameters.kp45s){ 		MenuDeselect(Menu45S); 		Parameters.kp45s = False;  		}r 	    else {y 		MenuSelect(Menu45S); 		Parameters.kp45s = True; 		}; 	    }2 	elif(strcmp(Parameters.kpCommand,MenuSNAP) == 0){ 	    MenuSelect(MenuSNAP);P 	    ShowPrompt("Number of lambda between points to which cursor is snapped? "); 	    FBKeyboard(&TypeIn);%; 	    sscanf(TypeIn,"%d",&Parameters.kpPixToLambdaSnapping);e- 	    if(Parameters.kpPixToLambdaSnapping < 1)e' 		Parameters.kpPixToLambdaSnapping = 1;.4 	    Parameters.kpPixToLambdaSnapping *= RESOLUTION;+ 	    Parameters.kpHalfPixToLambdaSnapping =;% 		Parameters.kpPixToLambdaSnapping/2;! 	    MenuDeselect(MenuSNAP); 	    }2 	elif(strcmp(Parameters.kpCommand,MenuGRID) == 0){ 	    MenuSelect(MenuGRID);: 	    ShowPrompt("Number of lambda between grid points? "); 	    FBKeyboard(&TypeIn);L, 	    sscanf(TypeIn,"%d",&Parameters.kpGrid);% 	    Parameters.kpGrid *= RESOLUTION;; 	    ShowFineViewport(); 	    MenuDeselect(MenuGRID); 	    }3 	elif(strcmp(Parameters.kpCommand,MenuRDRAW) == 0){  	    MenuSelect(MenuRDRAW);e 	    FullRedisplay();a 	    }2 	elif(strcmp(Parameters.kpCommand,MenuVIEW) == 0){ 	    MenuSelect(MenuVIEW); 	    ShowLayout(); 	    CenterFullView();3 	    Redisplay(Parameters.kpCellDesc,CoarseWindow);1 	    ShowParameters(); 	    MenuDeselect(MenuVIEW); 	    }1 	elif(strcmp(Parameters.kpCommand,MenuDIR) == 0){E 	    MenuSelect(MenuDIR);o
 #ifdef vms1 	    sprintf(TypeOut,"DIR/COLUMN=3/OUTPUT=KIC ");r 	    ShowProcess(TypeOut); #elseC 	    ShowProcess("ls -CF");i #endif 	    MenuDeselect(MenuDIR);  	    }2 	elif(strcmp(Parameters.kpCommand,MenuBOXES) == 0) 	    Boxes(&LookedAhead);o2 	elif(strcmp(Parameters.kpCommand,MenuWIRES) == 0) 	    Wires(&LookedAhead);e2 	elif(strcmp(Parameters.kpCommand,MenuWIDTH) == 0) 	    Width(&LookedAhead);p2 	elif(strcmp(Parameters.kpCommand,MenuPOLYG) == 0) 	    Polygons(&LookedAhead);2 	elif(strcmp(Parameters.kpCommand,MenuLABEL) == 0) 	    Label(&LookedAhead);n2 	elif(strcmp(Parameters.kpCommand,MenuDONUT) == 0) 	    Doughnut(&LookedAhead);0 	elif(strcmp(Parameters.kpCommand,MenuARC) == 0) 	    Arcs(&LookedAhead);2 	elif(strcmp(Parameters.kpCommand,MenuFLASH) == 0) 	    Flash(&LookedAhead);	1 	elif(strcmp(Parameters.kpCommand,MenuLYRA) == 0)R 	    Lyra(&LookedAhead);2 	elif(strcmp(Parameters.kpCommand,MenuTECH) == 0){ 	    MenuSelect(MenuTECH);G 	    ShowPrompt("Enter the name of the technology (nmos or cmos-pw):");0 	    FBKeyboard(&TypeIn);c 	    UseLRC(TypeIn); 	    MenuDeselect(MenuTECH); 	    }2 	elif(strcmp(Parameters.kpCommand,MenuUNDO) == 0){ 	    MenuSelect(MenuUNDO);- 	    ShowPrompt("Sorry, but it's too late.");s 	    MenuDeselect(MenuUNDO); 	    }3 	elif(strcmp(Parameters.kpCommand,MenuINSTA) == 0){( 	    Instances(&LookedAhead);m 	    ShowBasicMenu();o 	    }3 	elif(strcmp(Parameters.kpCommand,MenuPRPTY) == 0){) 	    Properties(&LookedAhead); 	    ShowBasicMenu();a 	    }2 	elif(strcmp(Parameters.kpCommand,MenuSAVE) == 0){ 	    Save(); 	    }3 	elif(strcmp(Parameters.kpCommand,MenuWRITE) == 0){n 	    WriteCell();  	    }1 	elif(strcmp(Parameters.kpCommand,MenuPAN) == 0){P 	    Pan(&LookedAhead);  	    }2 	elif(strcmp(Parameters.kpCommand,MenuZOOM) == 0){ 	    Zoom(&LookedAhead); 	    }3 	elif(strcmp(Parameters.kpCommand,MenuWINDO) == 0){d 	    Windo(&LookedAhead);  	    }2 	elif(strcmp(Parameters.kpCommand,MenuLAST) == 0){ 	    LastView(); 	    }3 	elif(strcmp(Parameters.kpCommand,MenuSELEC) == 0){  	    Selections(&LookedAhead); 	    ShowBasicMenu();m 	    }3 	elif(strcmp(Parameters.kpCommand,MenuATTRI) == 0){)
 	    Attri();d 	    ShowBasicMenu();i 	    }3 	elif(strcmp(Parameters.kpCommand,MenuDEBUG) == 0){c
 	    Debug();  	    ShowBasicMenu();C 	    } 	}     }      Edit(Ready,Center,Modified)c     int Ready,Center,Modified;     /*<      * Ready == True if the name of the cell to be edited is(      * already in Parameters.kpCellName.C      * Center == True if the cell should be automatically centered.=I      * Pop does NOT want it to be--it wants it to be exactly where it was       * when it was pushed into.)      */}     {(+     char *TypeIn,*CellName,*NextCellName();        MenuSelect(MenuEDIT);eB     if(Parameters.kpModified And Parameters.kpCellName[0] != EOS){H 	ShowPrompt("You've modified this cell.  Do you want to save it (No)?"); 	FBKeyboard(&TypeIn); * 	if(TypeIn[0] == 'y' Or TypeIn[0] == 'Y'){ 	    Save();- 	    if(Not CDReflect(Parameters.kpCellDesc))i 		MallocFailed();e 	    } 	else {y+ 	    if(Not CDClose(Parameters.kpCellDesc))  		MallocFailed();i 	    } 	}     if(Not Ready){ 	loop{ 	    ShowPrompt("Cell?");( 	    FBKeyboard(&CellName);s0 	    if(*CellName == '\n' Or *CellName == NULL){, 		/* get next cellname from argument list */* 		if((CellName = NextCellName()) != NULL){- 		    strcpy(Parameters.kpCellName,CellName);r 		    break; 		    }l% 		elif(Parameters.kpCellName != NULL u) 		    And *Parameters.kpCellName != NULL)K 		    break; 		}o
 	    else{) 		strcpy(Parameters.kpCellName,CellName);I 		break; 		}  	    } 	}     SelectQClear();)     ShowParameters();A)     Parameters.kpExpandInstances = False;]0     Parameters.kpExpandFineViewportOnly = False;     MenuDeselect(MenuEXPND);     MenuDeselect(MenuPEEK);o3     ShowPrompt("Building database.  Please wait.");rE     if(Not CDOpen(Parameters.kpCellName,&Parameters.kpCellDesc,'w')){hD 	sprintf(TypeOut,"Can't edit cell %s. MORE",Parameters.kpCellName);  	ShowPrompt(TypeOut);s 	FBKeyboard(&TypeIn); + 	sprintf(TypeOut,"%s MORE",CDStatusString);. 	ShowPrompt(TypeOut);  	FBKeyboard(&TypeIn);m  	Parameters.kpCellName[0] = EOS; 	}
     else {  	if(CDStatusInt == CDNEWSYMBOL){ 	    DefaultWindows(); 	    } 	elif(Center){ 	    CenterFullView(); 	    } 	ShowLayout(); 	/*&/ 	 * CDUnmark is expensive and has two purposes!,C 	 * First, we make sure that all objects begin with a 0 info field..D 	 * We will therefore see EVERYTHING in the symbol during redisplay.= 	 * Secondly, the bounding boxes are recomputed and therefore)/ 	 * propogated correctly through the hierarchy.= 	 */! 	CDUnmark(Parameters.kpCellDesc);(/ 	Redisplay(Parameters.kpCellDesc,CoarseWindow);A 	if(CDStatusInt == CDNEWSYMBOL)P3 	    ShowPrompt("New cell is ready to be edited.");e 	else / 	    ShowPrompt("Cell is ready to be edited.");d" 	Parameters.kpModified = Modified; 	}     ShowParameters();e     MenuDeselect(MenuEDIT);e     }    Save(){a     MenuSelect(MenuSAVE);N(     if(Parameters.kpCellName[0] != EOS){, 	ShowPrompt("Saving cell.    Please wait.");1 	if(CDUpdate(Parameters.kpCellDesc,(char *)NULL))e0 	    ShowPrompt("Current cell has been saved."); 	else $ 	    ShowPrompt("Can't save cell."); 	Parameters.kpModified = False;n 	}     else- 	ShowPrompt("There isn't anything to save.");a     MenuDeselect(MenuSAVE);Y     }o   ShowBasicMenu(){%     ShowMenu(BasicMenu,NumBasicMenu);o"     Parameters.kpMenu = BASICMENU;+     if(Parameters.kpExpandFineViewportOnly)( 	MenuSelect(MenuPEEK);$     if(Parameters.kpExpandInstances) 	MenuSelect(MenuEXPND);o     if(Parameters.kp45s) 	MenuSelect(Menu45S);d     FBTransfer();      }t   Peek(){l<     if(Parameters.kpRedisplayControl == COARSEVIEWPORTONLY){) 	ShowPrompt("Peek mode isn't required.");  	}.     elif(Parameters.kpExpandFineViewportOnly){ 	MenuDeselect(MenuPEEK);- 	Parameters.kpExpandFineViewportOnly = False;e 	ShowFineViewport(); 	}
     else {" 	if(Parameters.kpExpandInstances){ 	    MenuDeselect(MenuEXPND);.* 	    Parameters.kpExpandInstances = False;8 	    Parameters.kpRedisplayControl = COARSEVIEWPORTONLY; 	    ShowLayout();3 	    Redisplay(Parameters.kpCellDesc,CoarseWindow); 1 	    Parameters.kpRedisplayControl = SPLITSCREEN;e 	    }, 	Parameters.kpExpandFineViewportOnly = True; 	MenuSelect(MenuPEEK); 	ShowFineViewport(); 	}     }t    	 Expand(){b%     if(Parameters.kpExpandInstances){e 	MenuDeselect(MenuEXPND);r& 	Parameters.kpExpandInstances = False;- 	Parameters.kpExpandFineViewportOnly = False;l 	ShowLayout();/ 	Redisplay(Parameters.kpCellDesc,CoarseWindow);f 	}
     else { 	MenuSelect(MenuEXPND);o 	MenuDeselect(MenuPEEK);- 	Parameters.kpExpandFineViewportOnly = False;O% 	Parameters.kpExpandInstances = True;C 	ShowLayout();/ 	Redisplay(Parameters.kpCellDesc,CoarseWindow);  	}     }V     CenterFullView(){y     int L,B,R,T;D     if(Not CDBB(Parameters.kpCellDesc,(struct o *)NULL,&L,&B,&R,&T)) 	MallocFailed();     /*-      * Window cell automatically.  How slick.V3      * Leave some white space around the perimeter.y%      * Check for a null (empty) cell.       */)>     if(L == R Or B == T Or (L == INFINITY And B == INFINITY)){ 	L = B = -200 * RESOLUTION;  	R = T = 200 * RESOLUTION; 	}     if(R-L < T-B)i7 	InitCoarseWindow(L+((R-L)/2), B+((T-B)/2), 5*(T-B)/2);      else7 	InitCoarseWindow(L+((R-L)/2), B+((T-B)/2), 5*(R-L)/2);m-     InitFineWindow(L+((R-L)/2), B+((T-B)/2));      SwitchToFinePositioning();     }E  