 /*
  * boxes.c  **  * Copyright -C- 1981 Giles C. Billingsley#  * sccsid "@(#)boxes.c	1.1  9/5/83"d  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programe;  * KIC is available free of charge to any interested party.vB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,e  * is forbidden.  */;     f /*  * Box management.  *I  * CIFToKIC--the CDTo routine in the CD package--transforms non-ManhattanMG  * boxes to polygons, so the direction vector parameter in the routines   * here are superfluous.  *(  * KIC only knows about Manhattan boxes.5  * To make a 45, the user must use a wire or polygon.n  */q   #include "kic.h"   InBox(X,Y,AOI)     int X,Y;     struct ka AOI;     {eE     if(AOI.kaLeft <= X And X <= AOI.kaRight And AOI.kaBottom <= Y Andp 	Y <= AOI.kaTop) e 	return(True);     else return(False);      }D   ShowBox(Layer,BB,Window)     int Layer;     struct ka BB,Window;     {t     char oldRedisplay;     int ShowLeft = True;     int ShowBottom = True;     int ShowRight = True;a     int ShowTop = True;t  $     TPoint(&BB.kaLeft,&BB.kaBottom);"     TPoint(&BB.kaRight,&BB.kaTop);     if(BB.kaLeft > BB.kaRight)  	SwapInts(BB.kaLeft,BB.kaRight);     if(BB.kaBottom > BB.kaTop)  	SwapInts(BB.kaBottom,BB.kaTop);     /*      * Initial clippingm      */xB     if(BB.kaLeft > Window.kaRight Or BB.kaRight < Window.kaLeft Or: 	BB.kaBottom > Window.kaTop Or BB.kaTop < Window.kaBottom) 	return;"     if(BB.kaLeft < Window.kaLeft){ 	BB.kaLeft = Window.kaLeft;; 	ShowLeft = False; 	}&     if(BB.kaBottom < Window.kaBottom){ 	BB.kaBottom = Window.kaBottom;y 	ShowBottom = False; 	}$     if(BB.kaRight > Window.kaRight){ 	BB.kaRight = Window.kaRight;  	ShowRight = False;f 	}      if(BB.kaTop > Window.kaTop){ 	BB.kaTop = Window.kaTop;M 	ShowTop = False;  	}O     if(Layer != Parameters.kpHighlightingPixel And LayerTable[Layer].klFilled){u> 	Box(DISPLAY,Layer,BB.kaLeft,BB.kaBottom,BB.kaRight,BB.kaTop);< 	/* Outline a stippled box if Parameters.kpOutline is set */> 	if(LayerTable[Layer].klStyleID == 0 Or !Parameters.kpOutline) 	    return;, 	if(LayerTable[Layer].klCoarseStyleID != 0){< 	    if(ShowTop) ShowManhattanLine(Layer,BB.kaLeft,BB.kaTop, 		BB.kaRight,BB.kaTop,Window);= 	    if(ShowLeft) ShowManhattanLine(Layer,BB.kaLeft,BB.kaTop,o  		BB.kaLeft,BB.kaBottom,Window);? 	    if(ShowRight) ShowManhattanLine(Layer,BB.kaRight,BB.kaTop,t! 		BB.kaRight,BB.kaBottom,Window); B 	    if(ShowBottom) ShowManhattanLine(Layer,BB.kaLeft,BB.kaBottom,! 		BB.kaRight,BB.kaBottom,Window);m 	    }* 	elif(LayerTable[Layer].klFineStyleID != 0> 	    And Parameters.kpRedisplayControl != COARSEVIEWPORTONLY){2 	    oldRedisplay = Parameters.kpRedisplayControl;6 	    Parameters.kpRedisplayControl = FINEVIEWPORTONLY;< 	    if(ShowTop) ShowManhattanLine(Layer,BB.kaLeft,BB.kaTop," 		BB.kaRight,BB.kaTop,FineWindow);= 	    if(ShowLeft) ShowManhattanLine(Layer,BB.kaLeft,BB.kaTop,e$ 		BB.kaLeft,BB.kaBottom,FineWindow);? 	    if(ShowRight) ShowManhattanLine(Layer,BB.kaRight,BB.kaTop,n% 		BB.kaRight,BB.kaBottom,FineWindow); 6 	    if(ShowBottom) ShowManhattanLine(Layer,BB.kaLeft,1 		BB.kaBottom,BB.kaRight,BB.kaBottom,FineWindow);p2 	    Parameters.kpRedisplayControl = oldRedisplay; 	    } 	}
     else { 	/*t3 	 * Outlined boxes are THICK--1 lambda wide lines. n; 	 * But on highlighting layer, they are only 0 lambda wide., 	 */
 	if(ShowTop){ ; 	    if(BB.kaLeft == BB.kaRight Or BB.kaBottom == BB.kaTop E- 		Or Layer == Parameters.kpHighlightingPixel) - 		ShowManhattanLine(Layer,BB.kaLeft,BB.kaTop,m" 		    BB.kaRight,BB.kaTop,Window);	 	    else)? 		Box(DISPLAY,Layer,BB.kaLeft,BB.kaTop-25,BB.kaRight,BB.kaTop);m 	    }   	if(ShowLeft){; 	    if(BB.kaTop == BB.kaBottom Or BB.kaLeft == BB.kaRight i- 		Or Layer == Parameters.kpHighlightingPixel) - 		ShowManhattanLine(Layer,BB.kaLeft,BB.kaTop,h$ 		    BB.kaLeft,BB.kaBottom,Window);	 	    elserA 		Box(DISPLAY,Layer,BB.kaLeft,BB.kaBottom,BB.kaLeft+25,BB.kaTop);f 	    }   	if(ShowRight){ ; 	    if(BB.kaTop == BB.kaBottom Or BB.kaLeft == BB.kaRight e- 		Or Layer == Parameters.kpHighlightingPixel)l. 		ShowManhattanLine(Layer,BB.kaRight,BB.kaTop,% 		    BB.kaRight,BB.kaBottom,Window); 	 	    elsew. 		Box(DISPLAY,Layer,BB.kaRight-25,BB.kaBottom, 		    BB.kaRight,BB.kaTop);  	    }   	if(ShowBottom){; 	    if(BB.kaLeft == BB.kaRight Or BB.kaBottom == BB.kaTop f- 		Or Layer == Parameters.kpHighlightingPixel)y0 		ShowManhattanLine(Layer,BB.kaLeft,BB.kaBottom,% 		    BB.kaRight,BB.kaBottom,Window);;	 	    elsen5 		Box(DISPLAY,Layer,BB.kaLeft,BB.kaBottom,BB.kaRight,( 		    BB.kaBottom+25); 	    } 	}     }t     EraseBox(BB,Window)r     struct ka BB,Window;     {e$     TPoint(&BB.kaLeft,&BB.kaBottom);"     TPoint(&BB.kaRight,&BB.kaTop);     if(BB.kaLeft > BB.kaRight)  	SwapInts(BB.kaLeft,BB.kaRight);     if(BB.kaBottom > BB.kaTop)  	SwapInts(BB.kaBottom,BB.kaTop);     /*      * Initial clippingn      */rB     if(BB.kaLeft > Window.kaRight Or BB.kaRight < Window.kaLeft Or: 	BB.kaBottom > Window.kaTop Or BB.kaTop < Window.kaBottom) 	return;"     if(BB.kaLeft < Window.kaLeft){ 	BB.kaLeft = Window.kaLeft;t 	}&     if(BB.kaBottom < Window.kaBottom){ 	BB.kaBottom = Window.kaBottom;  	}$     if(BB.kaRight > Window.kaRight){ 	BB.kaRight = Window.kaRight;p 	}      if(BB.kaTop > Window.kaTop){ 	BB.kaTop = Window.kaTop;e 	};     Box(ERASE,0,BB.kaLeft,BB.kaBottom,BB.kaRight,BB.kaTop);      }h     Boxes(LookedAhead)     int *LookedAhead;T     {	     struct ka BB;o      int ExpectFirstPoint = True;     int JustMadeABox = False;      int NumBoxesMade = 0;t     int X,Y;        Parameters.kpPointer = NULL;     MenuSelect(MenuBOXES);1     ShowPrompt("Point to diagonal's endpoints.");o
     loop {	 	Point();p$ 	if(Parameters.kpCommand[0] != EOS){4 	    if(strcmp(Parameters.kpCommand,MenuUNDO) == 0){ 		if(Not JustMadeABox){  		    *LookedAhead = True;" 		    Parameters.kpPointer = NULL; 		    MenuDeselect(MenuBOXES);
 		    return;i 		    }. 		else { 		    MenuSelect(MenuUNDO);a; 		    CDDelete(Parameters.kpCellDesc,Parameters.kpPointer);k 		    JustMadeABox = False;R 		    --NumBoxesMade;  		    EraseBox(BB,BB);* 		    Redisplay(Parameters.kpCellDesc,BB); 		    FBTransfer();i 		    MenuDeselect(MenuUNDO);= 		    }t 		}r 	    else {  		*LookedAhead = True; 		Parameters.kpPointer = NULL; 		MenuDeselect(MenuBOXES); 		if(NumBoxesMade > 0)# 		    Parameters.kpModified = True;;	 		return;r 		}o 	    }F 	elif(Parameters.kpPointLayerTable Or !Parameters.kpPointCoarseWindow) 	    continue; 	elif(ExpectFirstPoint){ 	    ExpectFirstPoint = False; 	    X = Cursor.kcX; 	    Y = Cursor.kcY; 	    } 	else {a 	    ExpectFirstPoint = True;,# 	    BB.kaLeft = min(X,Cursor.kcX);)% 	    BB.kaBottom = min(Y,Cursor.kcY);i$ 	    BB.kaRight = max(X,Cursor.kcX);" 	    BB.kaTop = max(Y,Cursor.kcY); 	    if(BB.kaRight-BB.kaLeft <0 		LayerTable[Parameters.kpLayer].klMinDimensions 		Or BB.kaTop-BB.kaBottom <n1 		LayerTable[Parameters.kpLayer].klMinDimensions)k2 		ShowPrompt("Can't.    Box area is too small.");  	    else {c< 		if(Not CDMakeBox(Parameters.kpCellDesc,Parameters.kpLayer, 		    (BB.kaRight-BB.kaLeft),  		    (BB.kaTop-BB.kaBottom),4) 		    (BB.kaRight-BB.kaLeft)/2+BB.kaLeft,*+ 		    (BB.kaTop-BB.kaBottom)/2+BB.kaBottom, - 		    &Parameters.kpPointer)) MallocFailed();I 		++NumBoxesMade;< 		JustMadeABox = True;& 		Redisplay(Parameters.kpCellDesc,BB); 		FBTransfer();  		}r
 	    }     	}     }   ! Box(DisplayOrErase,Layer,L,B,R,T)a     char DisplayOrErase;     int Layer,L,B,R,T;     /*(      * Show or erase box on layer Layer.G      * BB must be in RESOLUTION*lambda and must be transformed already.       */t     {L     int LP,BP,RP,TP;  7     if(Parameters.kpRedisplayControl == SPLITSCREEN Or i6 	Parameters.kpRedisplayControl == COARSEVIEWPORTONLY){ 	LP = L; 	BP = B; 	RP = R; 	TP = T;) 	LToP(CoarseViewport,CoarseWindow,LP,BP); ) 	LToP(CoarseViewport,CoarseWindow,RP,TP);  #ifdef FBCONTROL 	if(Parameters.kpEnableFB) #endifG 	    FBBox(Layer,DisplayOrErase,FILL,LayerTable[Layer].klCoarseStyleID,o 		LP,BP,RP,TP);a 	}7     if(Parameters.kpRedisplayControl == SPLITSCREEN Or o4 	Parameters.kpRedisplayControl == FINEVIEWPORTONLY){ 	LP = L; 	BP = B; 	RP = R; 	TP = T; 	/*i 	 * Box test with FineWindow.k 	 */< 	if(LP <= FineWindow.kaRight And RP >= FineWindow.kaLeft And; 	    BP <= FineWindow.kaTop And TP >= FineWindow.kaBottom){=) 	    LToP(FineViewport,FineWindow,LP,BP);g) 	    LToP(FineViewport,FineWindow,RP,TP);, #ifdef FBCONTROL 	    if(Parameters.kpEnableFB) #endifB 		FBBox(Layer,DisplayOrErase,FILL,LayerTable[Layer].klFineStyleID, 		    LP,BP,RP,TP);o 	    } 	}     }      OversizeBox(BB,Delta)d     struct ka *BB;     int Delta;     {      BB->kaTop += Delta;o     BB->kaRight += Delta;      BB->kaBottom -= Delta;     BB->kaLeft -= Delta;     }k