 /*  * cd.ce  *=  * Copyright -C- 1981 Kenneth H. Keller, Giles C. Billingsleyn   * sccsid "@(#)cd.c	1.1  9/5/83"  *H  *     CD is a CIF database package that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atG  * the University of California, Berkeley, California.  The programs inX;  * CD are available free of charge to any interested party.OD  * The sale, resale, or use of these programs for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,{  * is forbidden.  */}     I /*======================================================================*w  *									*3  *                       CCCCCC       DDDDDDD 				*r4  *                      CC    CC      DD    DD 				*4  *                     CC      CC     DD     DD				*A  *                     CC             DD     DD               		*o@  *                     CC             DD     DD	             		*4  *                     CC      CC     DD     DD				*3  *                      CC    CC      DD    DD				* 2  *                       CCCCCC       DDDDDDD				*  *									*  *									*  * CD package code.							**  *									*  *									*J  *======================================================================*/   #include "cd.h"  #include "parser.h"u     /* Library routines */ char *strcpy();u #ifndef vms  char *sprintf(); #endif     /*9  * The following is the policy for handling errors in CD:*@  * When a routine encounters difficulty, it will set CDStatusInt;  * to some identifying value, copy a diagnostic string into @  * CDStatusString, and return a 'False'.  Otherwise, the routine=  * will return 'True' and not alter the value of CDStatusInt.p>  * Every routine that uses malloc will test the returned value2  * and return Flase via CDError() if malloc fails.  */r char *CDStatusString;] int  CDStatusInt;n   #define	LARGEBUFFERSIZE		400         sN /*===========================================================================*  *									     *oN  * III N   N III TTTTT III   A   L     III ZZZZZ   A   TTTTT III  OOO  N   N *N  *  I  NN  N  I    T    I   A A  L      I     Z   A A    T    I  O   O NN  N *N  *  I  N N N  I    T    I  A   A L      I    Z   A   A   T    I  O   O N N N *N  *  I  N  NN  I    T    I  AAAAA L      I   Z    AAAAA   T    I  O   O N  NN *N  * III N   N III   T   III A   A LLLLL III ZZZZZ A   A   T   III  OOO  N   N *  *									     *XD  *             RRRR   OOO  U   U TTTTT III N   N EEEEE  SSSS		     *D  *             R   R O   O U   U   T    I  NN  N E     S    		     *C  *             RRRR  O   O U   U   T    I  N N N EEE    SSS		     *lD  *             R R   O   O U   U   T    I  N  NN E         S		     *C  *             R  R   OOO   UUU    T   III N   N EEEEE SSSS		     *   *									     *r  *									     *s  *									     *   *	CDInit()							     *  *	CDPath(Path)							     *)  *	CDSetLayer(Layer,Tech,Mask)					     *c  *	CDDebug(Flag)							     *o  *									     * O  *===========================================================================*/t   void	 CDInit(){d     /*@      * This must be the first CD routine called.  It initializes@      * the layer table, search path, symbol table, and transform!      * stack.  No returned value.r      */c4     static char CDDiagnosticString[LARGEBUFFERSIZE];     int Layer,Int1;D+     for(Int1 = 0;Int1 < CDNUMLAYERS;++Int1)1 	CDSymbolTable[Int1] = NULL;0     for(Layer = 1;Layer <= CDNUMLAYERS;++Layer){" 	CDLayer[Layer].lTechnology = ' '; 	CDLayer[Layer].lMask[0] = ' ';* 	CDLayer[Layer].lMask[1] = ' ';e 	CDLayer[Layer].lMask[2] = ' ';i  	CDLayer[Layer].lCDFrom = False; 	}     CDPath(".");     CDDebug(False);m     CDDesc.dPrptyList = NULL;.$     CDDesc.dNumSymbolsAllocated = 0;(     CDStatusString = CDDiagnosticString;       /* Vanilla operation. */&     CDDesc.dControl = DCONTROLVANILLA;     TInit();     }      int  CDPath(Path)     char *Path;*     /*4      * Sets search rules for symbol name resolution.G      * Path is a list of directory names to search separated by blanks. &      * csh-style names are understood.@      * False is returned if the search path argument is invalid.      */n     {e     if(Not PSetPath(Path)) 	return(CDError(CDBADPATH));     else 	return(True);     }l     void! CDSetLayer(Layer,Technology,Mask)l     int  Layer;t     char Technology,Mask[];T     /*F      * This routine sets the layer Layer to the name 'TechnologyMask'."      * There is no returned value.      */=     {=,     CDLayer[Layer].lTechnology = Technology;&     CDLayer[Layer].lMask[0] = Mask[0];&     CDLayer[Layer].lMask[1] = Mask[1];&     CDLayer[Layer].lMask[2] = Mask[2];     }      void CDDebug(Debug)     int Debug;     {      /*B      * If Debug is true, then CD will run in debug mode.  There is      * no returned value.       */A     CDDesc.dDebug = Debug;     }N        I /*======================================================================*   *									*4  *                SSSS Y   Y M   M BBBB   OOO  L			*4  *               S      Y Y  MM MM B   B O   O L			*4  *                SSS    Y   M M M BBBB  O   O L			*4  *                   S   Y   M   M B   B O   O L			*8  *               SSSS    Y   M   M BBBB   OOO  LLLLL			*  *									*C  *    M   M   A   N   N   A    GGG  EEEEE M   M EEEEE N   N TTTTT	* B  *    MM MM  A A  NN  N  A A  G     E     MM MM E     NN  N   T		*B  *    M M M A   A N N N A   A G GGG EEE   M M M EEE   N N N   T		*B  *    M   M AAAAA N  NN AAAAA G   G E     M   M E     N  NN   T		*B  *    M   M A   A N   N A   A  GGG  EEEEE M   M EEEEE N   N   T		*  *									*  *									*  *									*,  *	CDOpen(SymbolName,SymbolDesc,Access)				*(  *	CDSymbol(SymbolName,SymbolDesc)					*  *	CDClose(SymbolDesc)						*o  *	CDReflect(SymbolDesc)						*l/  *	CDPatchInstances(SymbolDesc,MasterName)				*g  *									*J  *======================================================================*/   intT$ CDOpen(SymbolName,SymbolDesc,Access)     char Access;     char *SymbolName;L     struct s **SymbolDesc;     /**      * Open symbol and return desc for it.      * 'J      * CDOpen returns False if parse failed or out of memory.  When CDOpen@      * returns, CDStatusInt assumes one of the following values:A      *   (FATAL)-CDPARSEFAILED if parser failed or out of memory.DM      *           CDOLDSYMBOL if success and symbol already exists in memory. LH      *           CDNEWSYMBOL if success and symbol is a new (empty) one.;      *           CDSUCCEEDED if no problem was encountered. L      * If the return is fatal, CDStatusString contains a diagnostic message.G      * Only CDPARSEFAILED is returned as a fatal error; this simplifiesh      * the diagnostic test.       *J      * If Access == 'w', then create the cell if it doesn't already exist.H      * In other words, open cell for writing.  This solves the followingG      * problem: if the user tries to create an instance of a cell that eJ      * doesn't exist, it will not be created in the database.  If the cellI      * was added to the database, a second attempt to place the cell thato.      * doesn't exist would succeed.  Bad News!      *K      * If Access == 'n', then create a new cell if it doesn't already existwJ      * in the database.  Unlike Access == 'w', the cell will not be parsed/      * if it exists in the current search path.*      */      {      char *StatusString;D
     char *cp;      FILE *FDesc;     struct bu *Bucket;     struct m *MasterListDesc;      struct s *MasterSymbolDesc;	     struct s *NewDesc;     struct prpty PrptyCopy;      int Key,Int1,Int2;     int Layer;     int StatusInt;     unsigned int size;#     static int RecursionLevel = 0; *   #ifdef DEBUGREFLECT	2 printf("Begin CDOpen of symbol %s.\n",SymbolName); #endif  2     if(SymbolName == NULL Or *SymbolName == NULL){ 	CDStatusInt = CDPARSEFAILED;c9 	sprintf(CDStatusString,"Null symbol name encountered.");  	return(False);) 	}%     CDDesc.dControl = DCONTROLCDOPEN;      ++RecursionLevel;g  !     /* Is symbol open already? */      Key = 0;     *SymbolDesc = NULL;i     Int2 = strlen(SymbolName);&     for(Int1 = 0; Int1 < Int2; ++Int1) 	Key += SymbolName[Int1];S.     Bucket = CDSymbolTable[Key % CDNUMLAYERS];     while(Bucket != NULL){9 	if(strcmp(Bucket->buSymbolDesc->sName,SymbolName) == 0){u( 	    *SymbolDesc = Bucket->buSymbolDesc; 	    break;a 	    } 	Bucket = Bucket->buSucc;l 	}     if(*SymbolDesc != NULL){ 	CDStatusInt = CDOLDSYMBOL;  	*CDStatusString = NULL; 	}
     else {$ 	/* first, try to allocate memory */> 	if((NewDesc = (struct s *)malloc(sizeof(struct s))) == NULL){+ 	    CDStatusInt = CDError(CDMALLOCFAILED);D! 	    CDStatusInt = CDPARSEFAILED;  	    return(False);k 	    } 	size = Int2 + 2; ! 	if((cp = malloc(size)) == NULL){;+ 	    CDStatusInt = CDError(CDMALLOCFAILED);e! 	    CDStatusInt = CDPARSEFAILED;  	    return(False);d 	    }? 	if((Bucket = (struct bu *)malloc(sizeof(struct bu))) == NULL){=+ 	    CDStatusInt = CDError(CDMALLOCFAILED);y! 	    CDStatusInt = CDPARSEFAILED;D 	    return(False);c 	    }A 	if(Access != 'n' And (FDesc = POpen(SymbolName,"r",(char *)NULL,s 	    (char **)NULL)) != NULL){ 	    /*s7 	     * Symbol already exists, so user probably intendsd# 	     * to edit it or just read it.c 	     */  ' 	    /* put symbol into symbol table */d0 	    *SymbolDesc = CDDesc.dSymbolDesc = NewDesc;# 	    ++CDDesc.dNumSymbolsAllocated; 0 	    for(Layer = 0;Layer <= CDNUMLAYERS;++Layer)7 		CDDesc.dSymbolDesc->sBin[Layer] = (struct o ***)NULL;c$ 	    CDDesc.dSymbolDesc->sName = cp;, 	    strcpy(CDDesc.dSymbolName,SymbolName); ; 	    strcpy(CDDesc.dSymbolDesc->sName,CDDesc.dSymbolName); e% 	    CDDesc.dNumX = CDDesc.dNumY = 1;s! 	    CDDesc.dDX = CDDesc.dDY = 0;i  	    CDDesc.dSymbolDesc->sA = 1;  	    CDDesc.dSymbolDesc->sB = 1;* 	    CDDesc.dSymbolDesc->sBBValid = True; G 	    CDDesc.dSymbolDesc->sLeft = CDDesc.dSymbolDesc->sBottom =INFINITY;sG 	    CDDesc.dSymbolDesc->sRight = CDDesc.dSymbolDesc->sTop = -INFINITY;t# 	    CDDesc.dSymbolDesc->sInfo = 0;s, 	    CDDesc.dSymbolDesc->sMasterList = NULL;+ 	    CDDesc.dSymbolDesc->sPrptyList = NULL;1( 	    /* add property list information */& 	    while(CDDesc.dPrptyList != NULL){B 	        if(Not CDAddProperty(CDDesc.dSymbolDesc,(struct o *)NULL,% 		    CDDesc.dPrptyList->prpty_Value, ( 		    CDDesc.dPrptyList->prpty_String)){, 		    CDStatusInt = CDError(CDMALLOCFAILED);" 		    CDStatusInt = CDPARSEFAILED; 		    return(False); 		    }a0 	        /* free storage of CDDesc.dPrptyList */( 	        PrptyCopy = *CDDesc.dPrptyList;/ 	        free(CDDesc.dPrptyList->prpty_String);s1 	        free((struct prpty *)CDDesc.dPrptyList);(2 	        CDDesc.dPrptyList = PrptyCopy.prpty_Succ;
 	        } 	    /*C+ 	     * Insert symbol desc in symbol table.u0 	     * The hash table 'Key' was computed above. 	     */1 	    if(CDSymbolTable[Key % CDNUMLAYERS] != NULL)D4 		CDSymbolTable[Key % CDNUMLAYERS]->buPred = Bucket; 	    Bucket->buPred = NULL;U7 	    Bucket->buSucc = CDSymbolTable[Key % CDNUMLAYERS];L( 	    Bucket->buSymbolDesc = *SymbolDesc;0 	    CDSymbolTable[Key % CDNUMLAYERS] = Bucket;  	    fclose(FDesc); / 	    PCIF(SymbolName,&StatusString,&StatusInt);)  	    if(StatusInt == PSUCCEEDED) 		CDStatusInt = CDOLDSYMBOL;
 	    else{ 		CDStatusInt = CDPARSEFAILED;& 		strcpy(CDStatusString,StatusString); 		if(Not CDClose(*SymbolDesc))& 		    return(CDError(CDMALLOCFAILED)); 		return(False); 		}B 	    /*sC 	     * Now, the master list descs and instance descs, if any, haveCC 	     * to be filled in.  See the discussion in CDBeginMakeCall for % 	     * why this wasn't done earlier.	 	     */6 	    MasterListDesc = CDDesc.dSymbolDesc->sMasterList;# 	    while(MasterListDesc != NULL){O 		/*A 		 * This recursive call is safe, because PCIF has done its work. @ 		 * Because StatusInt is checked, we ignore the returned value. 		 */ 6 		CDOpen(MasterListDesc->mName,&MasterSymbolDesc,'r');A 		if(CDStatusInt == CDNEWSYMBOL Or CDStatusInt == CDPARSEFAILED){ % 		    if(CDStatusInt == CDNEWSYMBOL){  			CDStatusInt = CDPARSEFAILED;  			sprintf(CDStatusString,0 			    "Master %s doesn't seem to be around.\n", 			     MasterListDesc->mName);E 			} 		    return(False); 		    }	& 		if(Not CDReflect(MasterSymbolDesc)){" 		    CDStatusInt = CDPARSEFAILED; 		    return(False); 		    }*) 		MasterListDesc = MasterListDesc->mSucc;e 		}m 	    CDStatusInt = CDSUCCEEDED;n 	    } 	else {s( 	    if(Access == 'w' Or Access == 'n'){ 		/* create cell in database */= 		CDDesc.dSymbolDesc = NewDesc;n  		++CDDesc.dNumSymbolsAllocated;- 		for(Layer = 0;Layer <= CDNUMLAYERS;++Layer)L; 		    CDDesc.dSymbolDesc->sBin[Layer] = (struct o ***)NULL;r! 		CDDesc.dSymbolDesc->sName = cp;*) 		strcpy(CDDesc.dSymbolName,SymbolName); t8 		strcpy(CDDesc.dSymbolDesc->sName,CDDesc.dSymbolName); " 		CDDesc.dNumX = CDDesc.dNumY = 1; 		CDDesc.dDX = CDDesc.dDY = 0; 		CDDesc.dSymbolDesc->sA = 1;D 		CDDesc.dSymbolDesc->sB = 1;i' 		CDDesc.dSymbolDesc->sBBValid = True; m 		CDDesc.dSymbolDesc->sLeftW/ 		    = CDDesc.dSymbolDesc->sBottom = INFINITY;  		CDDesc.dSymbolDesc->sRight- 		    = CDDesc.dSymbolDesc->sTop = -INFINITY;n  		CDDesc.dSymbolDesc->sInfo = 0;) 		CDDesc.dSymbolDesc->sMasterList = NULL;U( 		CDDesc.dSymbolDesc->sPrptyList = NULL;, 	        /* add property list information */* 	        while(CDDesc.dPrptyList != NULL){F 	            if(Not CDAddProperty(CDDesc.dSymbolDesc,(struct o *)NULL,) 		        CDDesc.dPrptyList->prpty_Value,t, 		        CDDesc.dPrptyList->prpty_String)){) 			CDStatusInt = CDError(CDMALLOCFAILED);D 			CDStatusInt = CDPARSEFAILED;o 			return(False);; 			}4 	            /* free storage of CDDesc.dPrptyList */, 	            PrptyCopy = *CDDesc.dPrptyList;3 	            free(CDDesc.dPrptyList->prpty_String);	5 	            free((struct prpty *)CDDesc.dPrptyList); 6 	            CDDesc.dPrptyList = PrptyCopy.prpty_Succ; 	            } 		/*( 		 * Insert symbol desc in symbol table.- 		 * The hash table 'Key' was computed above.  		 */t# 		*SymbolDesc = CDDesc.dSymbolDesc;c. 		if(CDSymbolTable[Key % CDNUMLAYERS] != NULL)8 		    CDSymbolTable[Key % CDNUMLAYERS]->buPred = Bucket;4 		Bucket->buSucc = CDSymbolTable[Key % CDNUMLAYERS];% 		Bucket->buSymbolDesc = *SymbolDesc;w 		Bucket->buPred = NULL;- 		CDSymbolTable[Key % CDNUMLAYERS] = Bucket; e 		}  	    else {  	        *SymbolDesc = NULL;> 		/* free the previously allocated memory.  It's not needed */ 		free((struct s *)NewDesc); 		free((struct bu *)Bucket); 		free(cp);S 		}  	    CDStatusInt = CDNEWSYMBOL;  	    } 	}     --RecursionLevel;O?     if(RecursionLevel == 0 And CDDesc.dControl != DCONTROLPCIF),# 	CDDesc.dControl = DCONTROLVANILLA;e   #ifdef DEBUGREFLECTa0 printf("End CDOpen of symbol %s.\n",SymbolName); #endif       return(True);t     }S     void CDSymbol(SymbolName,SymbolDesc)I     char *SymbolName;e     struct s **SymbolDesc;     /*-      * Returns symbol desc if any for symbol.CC      * If SymbolName is not in symbol table, the pointer SymbolDesc'      * is returned NULL.      */=     {e     int Key,Int1,Int2;     struct bu *Bucket;       Key = 0;     *SymbolDesc = NULL;N     if(SymbolName == NULL) 	return;     Int2 = strlen(SymbolName);$     for(Int1 = 0;Int1 < Int2;++Int1) 	Key += SymbolName[Int1];S.     Bucket = CDSymbolTable[Key % CDNUMLAYERS];     while(Bucket != NULL){9 	if(strcmp(Bucket->buSymbolDesc->sName,SymbolName) == 0){C( 	    *SymbolDesc = Bucket->buSymbolDesc; 	    return; 	    } 	Bucket = Bucket->buSucc;y 	}     }B     intT CDClose(SymbolDesc)b     struct s *SymbolDesc;e     /*&      * Close symbol.  Free SymbolDesc.H      * If malloc fails, False is returned.  Otherwise, True is returned.      */l     {I     struct bu *Bucket;     struct g *GenDesc;     struct o *Pointer;     struct prpty *PrptyDesc;     struct prpty PrptyCopy;m     int Key,Int1,Int2;     int Layer;       /*,      * Delete symbol desc from symbol table.      */c     Key = 0;%     Int2 = strlen(SymbolDesc->sName);y&     for(Int1 = 0; Int1 < Int2; ++Int1)  	Key += SymbolDesc->sName[Int1];.     Bucket = CDSymbolTable[Key % CDNUMLAYERS];     while(Bucket != NULL){? 	if(strcmp(Bucket->buSymbolDesc->sName,SymbolDesc->sName) == 0)p 	    break;b 	Bucket = Bucket->buSucc;l 	}     if(Bucket == NULL) 	return(True);:     if(Bucket->buPred == NULL And Bucket->buSucc == NULL){ 	/*-$ 	 * Only desc--has no pred or succ.  	 */) 	CDSymbolTable[Key % CDNUMLAYERS] = NULL;  	}!     elif(Bucket->buPred == NULL){. 	/*o, 	 * First desc.    Has a succ, but no pred.  	 */3 	CDSymbolTable[Key % CDNUMLAYERS] = Bucket->buSucc;  	Bucket->buSucc->buPred = NULL;  	}!     elif(Bucket->buSucc == NULL){N 	/* ( 	 * Last desc--has a pred, but no succ.  	 */  	Bucket->buPred->buSucc = NULL;  	}
     else { 	/*s' 	 * Vanilla desc has a pred and a succ.D 	 */* 	Bucket->buSucc->buPred = Bucket->buPred; ) 	Bucket->buPred->buSucc = Bucket->buSucc;  	}     /*'      * Free storage taken up by symbol.n      */o0     for(Layer = 0;Layer <= CDNUMLAYERS;++Layer){A 	if(Not CDInitGen(SymbolDesc,Layer,(int)-INFINITY,(int)-INFINITY,D+ 	    (int)INFINITY,(int)INFINITY,&GenDesc))e% 	    return(CDError(CDMALLOCFAILED));r 	loop {p( 	    CDGen(SymbolDesc,GenDesc,&Pointer); 	    if(Pointer == NULL) 		break;
 	    else{ 		CDDelete(SymbolDesc,Pointer);  		}} 	    } 	}     /*%      * Free storage of property list;       */ '     PrptyDesc = SymbolDesc->sPrptyList;      while(PrptyDesc != NULL){  	PrptyCopy = *PrptyDesc;$ 	if(PrptyDesc->prpty_String != NULL)# 	    free(PrptyDesc->prpty_String);  	free(PrptyDesc);-" 	PrptyDesc = PrptyCopy.prpty_Succ; 	}     free(Bucket->buSymbolDesc);t     free(Bucket);      return(True);e     }e     intc CDReflect(SymbolDesc)      struct s *SymbolDesc;r     /*E      * This routine must be invoked at certain times by the CD user. eF      * All bounding box information must be up-to-date if the indexing      * method is to work.       *G      * CDReflect will return False if malloc fails.  Otherwise, True isK      * returned.      *      * Here's the problem.D      * Suppose we have a symbol called Load and there is an instanceD      * of it in NAND.  Then, there is a master list desc for Load inG      * NAND's master list.  Suppose Load is edited and its BB changes. ;O      * Then, the instance desc for the instance of Load in NAND will be wrong. yF      * Calling CDReflect(Load) reflects the change to Load's BB to all9      * symbols that DIRECTLY or INDIRECTLY reference it. 2      *?      * In one sentence, here is when you must invoke CDReflect:KJ      *     You have opened a symbol and edited it so that its bounding boxF      *     has changed and you are done editing it for the time being.      */-     {      int Int1,L,B,R,T;B     struct bu *Bucket;     struct m *MasterListDesc;r       /*      * Here's the algorithm.9      * Let the name of the symbol we are reflecting be S.n      *      * Recompute BB of S.b      * CDUpdate does this.      *L      * For each symbol named i, i != S, in CD's hash table of symbol descs,       * do the following. b      *N      * For each master named M, if any, in master list of i, do the following.<      *     If M == S and M's BB != S's BB, do the following.      * 	       M's BB = S's BB.e<      * 	       Patch up i's instance descs that reference M.      * 	       Update i's BB.c-      * 	       Invoke Reflect(i) recursively.-      */b   #ifdef DEBUGREFLECT 1 printf("Begin Reflect(%s).\n",SymbolDesc->sName);lL printf("    Old BB is %d %d %d %d.\n",SymbolDesc->sLeft,SymbolDesc->sBottom,)     SymbolDesc->sRight,SymbolDesc->sTop);N #endif       /*      * Recompute BB of S.e      */ 9     if(Not CDBB(SymbolDesc,(struct o *)NULL,&L,&B,&R,&T))n 	return(False);s   #ifdef DEBUGREFLECToL printf("    New BB is %d %d %d %d.\n",SymbolDesc->sLeft,SymbolDesc->sBottom,)     SymbolDesc->sRight,SymbolDesc->sTop);p #endif  ,     for(Int1 = 0;Int1 < CDNUMLAYERS;++Int1){ 	Bucket = CDSymbolTable[Int1]; 	loop) 	    if(Bucket == NULL)s 		break; 	    /*p% 	     * SymbolDesc is the desc for S.s/ 	     * Bucket->buSymbolDesc is the desc for i.c 	     */E 	    elif(strcmp(Bucket->buSymbolDesc->sName,SymbolDesc->sName) == 0)  		Bucket = Bucket->buSucc; 	    else {D   #ifdef DEBUGREFLECT P printf("    Begin traversing master list of %s.\n",Bucket->buSymbolDesc->sName); #endif  5 		MasterListDesc = Bucket->buSymbolDesc->sMasterList;b 		loop! 		    if(MasterListDesc == NULL){    #ifdef DEBUGREFLECT N printf("    End traversing master list of %s.\n",Bucket->buSymbolDesc->sName); #endif  	 			break;  			} 		    else { 			/* ! 			 * MasterListDesc->mName is M.% 			 */   #ifdef DEBUGREFLECTD2 printf("Considering %s.\n",MasterListDesc->mName);M printf("BB is %d %d %d %d.\n",MasterListDesc->mLeft,MasterListDesc->mBottom, y2     MasterListDesc->mRight,MasterListDesc->mTop);  #endif  : 			if(strcmp(MasterListDesc->mName,SymbolDesc->sName) == 0: 			    And (MasterListDesc->mLeft != SymbolDesc->sLeft Or 9 			    MasterListDesc->mBottom != SymbolDesc->sBottom Or u7 			    MasterListDesc->mRight != SymbolDesc->sRight Or C2 			    MasterListDesc->mTop != SymbolDesc->sTop)){   #ifdef DEBUGREFLECT0 printf("BB conflict.\n");N #endif  2 			    MasterListDesc->mLeft = SymbolDesc->sLeft; 6 			    MasterListDesc->mBottom = SymbolDesc->sBottom; 4 			    MasterListDesc->mRight = SymbolDesc->sRight; / 			    MasterListDesc->mTop = SymbolDesc->sTop;l	 			    /* " 			     * Patch up instance descs. 			     * A very big loop.# 			     * Warrants its own routine.i
 			     */4 			    if(Not CDPatchInstances(Bucket->buSymbolDesc,* 				MasterListDesc->mName)) return(False);	 			    /*t 			     * Recompute i's BB. 
 			     */. 			    Bucket->buSymbolDesc->sBBValid = False;9 			    if(Not CDBB(Bucket->buSymbolDesc,(struct o *)NULL,t  				&L,&B,&R,&T)) return(False);	 			    /* - 			     * Reflect changes up the hierarchy of  			     * instance references.
 			     */. 			    if(Not CDReflect(Bucket->buSymbolDesc)) 				return(False); 			    }* 			MasterListDesc = MasterListDesc->mSucc; 			};u 		Bucket = Bucket->buSucc; 		}; 	}   #ifdef DEBUGREFLECTs/ printf("End Reflect(%s).\n",SymbolDesc->sName);  #endif       return(True);D     },     int ' CDPatchInstances(SymbolDesc,MasterName)N     struct s *SymbolDesc;o     char *MasterName;      {.     /*I      * This routine will delete all instances of MasterName in the symbolyK      * pointed to by SymbolDesc, and then recreate the same instance in the K      * symbol.  The result is to reflect any change in the BB of MasterName       * in the symbol.y      *:      * CDPatchInstances will return False if malloc fails.#      * Otherwise, True is returned.D      */e     struct g *GenDesc;     struct o *OldPntr,*NewPntr;      struct t *TGen;D     struct prpty *PrptyDesc;     char *SymbolName;t     int X,Y;     int NumX,DX,NumY,DY;     int OldL,OldB,OldR,OldT;     int NewL,NewB,NewR,NewT;     char Type;   #ifdef DEBUGREFLECT _ printf("Begin patching instances of master %s for symbol %s.\n",MasterName,SymbolDesc->sName); m #endif       if(MasterName == NULL) 	return(True);N     if(Not CDInitGen(SymbolDesc,0,(int)-INFINITY,(int)-INFINITY,(int)INFINITY,: 	(int)INFINITY,&GenDesc)) return(CDError(CDMALLOCFAILED));
     loop {$ 	CDGen(SymbolDesc,GenDesc,&OldPntr); 	if(OldPntr == NULL) 	    break;i1 	CDCall(OldPntr,&SymbolName,&NumX,&DX,&NumY,&DY);	 	if(SymbolName == NULL)- 	    continue;/ 	if(*SymbolName == NULL Or *MasterName == NULL)  	    continue;' 	if(strcmp(SymbolName,MasterName) != 0)! 	    continue;9 	if(Not CDBB(SymbolDesc,OldPntr,&OldL,&OldB,&OldR,&OldT))i 	    return(False);e   #ifdef DEBUGREFLECTo< printf("    Old BB is %d %d %d %d.\n",OldL,OldB,OldR,OldT);  #endif  ? 	/* we can assume here that the only error is CDMALLOCFAILED */MH 	if(Not CDBeginMakeCall(SymbolDesc,SymbolName,NumX,DX,NumY,DY,&NewPntr))& 	    if(CDStatusInt == CDMALLOCFAILED)" 		return(CDError(CDMALLOCFAILED)); 	CDInitTGen(OldPntr,&TGen);  	loop {c 	    CDTGen(&TGen,&Type,&X,&Y);o 	    if(TGen == NULL)i 		break;	 	    else  		if(Not CDT(NewPntr,Type,X,Y))a& 		    return(CDError(CDMALLOCFAILED)); 	    }* 	if(Not CDEndMakeCall(SymbolDesc,NewPntr))% 	    return(CDError(CDMALLOCFAILED));  	/* copy the property list */ + 	CDProperty(SymbolDesc,OldPntr,&PrptyDesc);D 	while(PrptyDesc != NULL){E 	    if(Not (CDAddProperty(SymbolDesc,NewPntr,PrptyDesc->prpty_Value,t 		PrptyDesc->prpty_String))){t) 	        return(CDError(CDMALLOCFAILED));  		}l' 	    PrptyDesc = PrptyDesc->prpty_Succ;l 	    }9 	if(Not CDBB(SymbolDesc,NewPntr,&NewL,&NewB,&NewR,&NewT)) % 	    return(CDError(CDMALLOCFAILED));    #ifdef DEBUGREFLECTr< printf("    New BB is %d %d %d %d.\n",NewL,NewB,NewR,NewT);  #endif   	/* A 	 * The generator may return an instance desc that was created inu* 	 * this loop.  So, remove any duplicates. 	 */A 	if(OldL != NewL Or OldB != NewB Or OldR != NewR Or OldT != NewT)m 	    /*s% 	     * Remove desc with invalid BB. , 	     */" 	    CDDelete(SymbolDesc,OldPntr); 	else  	    /*h 	     * Remove duplicate.c 	     */" 	    CDDelete(SymbolDesc,NewPntr); 	}   #ifdef DEBUGREFLECTP] printf("End patching instances of master %s for symbol %s.\n",MasterName,SymbolDesc->sName); h #endif       return(True);d     }t       tI /*======================================================================*;  *									*8  *                OOO  BBBB      J EEEEE  CCCC TTTTT			*6  *               O   O B   B     J E     C       T			*6  *               O   O BBBB      J EEE   C       T			*6  *               O   O B   B J   J E     C       T			*6  *                OOO  BBBB   JJJ  EEEEE  CCCC   T			*  *									*;  *          CCCC RRRR  EEEEE   A   TTTTT III  OOO  N   N		*i;  *         C     R   R E      A A    T    I  O   O NN  N		*=;  *         C     RRRR  EEE   A   A   T    I  O   O N N N		* ;  *         C     R R   E     AAAAA   T    I  O   O N  NN		* ;  *          CCCC R  R  EEEEE A   A   T   III  OOO  N   N		*(  *									*  *									*  *									*:  *	CDMakeBox(SymbolDesc,Layer,Length,Width,X,Y,Pointer)		*6  *	CDMakeLabel(SymbolDesc,Layer,Label,X,Y,Pointer)			*3  *	CDMakePolygon(SymbolDesc,Layer,Path,Pointer)			*D6  *	CDMakeWire(SymbolDesc,Layer,Width,Path,Pointer)			*:  *	CDMakeRoundFlash(SymbolDesc,Layer,Width,X,Y,Pointer)		*C  *	CDBeginMakeCall(SymbolDesc,SymbolName,NumX,DX,NumY,DY,Pointer)	*e)  *	CDEndMakeCall(SymbolDesc,Pointer)				*y0  *	CDInsertObjectDesc(SymbolDesc,ObjectDesc)			*  *	CDCheckPath(Path)						*o  *									*J  *======================================================================*/   int 4 CDMakeBox(SymbolDesc,Layer,Length,Width,X,Y,Pointer)     struct s *SymbolDesc;t     int Layer,Length,Width,X,Y;c     struct o **Pointer;e     {i     struct o *ObjectDesc; !     if(Length == 0 Or Width == 0)l 	return(CDError(CDBADBOX));tC     if((ObjectDesc = (struct o *)malloc(sizeof(struct o))) == NULL)n! 	return(CDError(CDMALLOCFAILED));      Length = abs(Length);      Width = abs(Width);w     ObjectDesc->oRep = NULL;"     ObjectDesc->oPrptyList = NULL;     ObjectDesc->oInfo = 0;     ObjectDesc->oType = CDBOX;     ObjectDesc->oLayer = Layer;M#     ObjectDesc->oLeft = X-Length/2; $     ObjectDesc->oBottom = Y-Width/2;$     ObjectDesc->oRight = X+Length/2;!     ObjectDesc->oTop = Y+Width/2;a     *Pointer = ObjectDesc; s5     if(Not CDInsertObjectDesc(SymbolDesc,ObjectDesc))d 	return(False);      return(True);      }      intl/ CDMakeLabel(SymbolDesc,Layer,Label,X,Y,Pointer)e     struct s *SymbolDesc;,     int Layer;     char *Label;     int X,Y;     struct o **Pointer;      {d     struct la *LabelDesc;C     struct o *ObjectDesc;;     unsigned int size;  D     if((LabelDesc = (struct la *)malloc(sizeof(struct la))) == NULL)! 	return(CDError(CDMALLOCFAILED));fC     if((ObjectDesc = (struct o *)malloc(sizeof(struct o))) == NULL)=! 	return(CDError(CDMALLOCFAILED));=     size = strlen(Label) + 2; 3     if((LabelDesc->laLabel = malloc(size)) == NULL)*! 	return(CDError(CDMALLOCFAILED)); %     strcpy(LabelDesc->laLabel,Label);O     LabelDesc->laX = X;      LabelDesc->laY = Y;O-     ObjectDesc->oRep = (struct o *)LabelDesc; "     ObjectDesc->oPrptyList = NULL;     ObjectDesc->oInfo = 0;      ObjectDesc->oType = CDLABEL;     ObjectDesc->oLayer = Layer; /     ObjectDesc->oLeft = ObjectDesc->oRight = X;=/     ObjectDesc->oBottom = ObjectDesc->oTop = Y;      *Pointer = ObjectDesc;  5     if(Not CDInsertObjectDesc(SymbolDesc,ObjectDesc))  	return(False);E     return(True);O     }N     int	, CDMakePolygon(SymbolDesc,Layer,Path,Pointer)     struct s *SymbolDesc;h     int Layer;     struct p *Path;l     struct o **Pointer;,     {e     struct po *PolygonDesc;o     struct o *ObjectDesc;	     struct p *Pair;b  F     if((PolygonDesc = (struct po *)malloc(sizeof(struct po))) == NULL)! 	return(CDError(CDMALLOCFAILED));aC     if((ObjectDesc = (struct o *)malloc(sizeof(struct o))) == NULL)e! 	return(CDError(CDMALLOCFAILED));C     CDCheckPath(Path);     PolygonDesc->poPath = Path;a/     ObjectDesc->oRep = (struct o *)PolygonDesc;="     ObjectDesc->oPrptyList = NULL;     ObjectDesc->oInfo = 0;"     ObjectDesc->oType = CDPOLYGON;     ObjectDesc->oLayer = Layer;*7     ObjectDesc->oLeft = ObjectDesc->oBottom = INFINITY;t6     ObjectDesc->oRight = ObjectDesc->oTop = -INFINITY;     Pair = Path;     while(Pair != NULL){! 	if(ObjectDesc->oLeft > Pair->pX)c" 	    ObjectDesc->oLeft = Pair->pX;" 	if(ObjectDesc->oRight < Pair->pX)# 	    ObjectDesc->oRight = Pair->pX;t# 	if(ObjectDesc->oBottom > Pair->pY)b$ 	    ObjectDesc->oBottom = Pair->pY;  	if(ObjectDesc->oTop < Pair->pY)! 	    ObjectDesc->oTop = Pair->pY;p 	Pair = Pair->pSucc; 	}     *Pointer = ObjectDesc; t5     if(Not CDInsertObjectDesc(SymbolDesc,ObjectDesc))- 	return(False);(     return(True);I     },     intN/ CDMakeWire(SymbolDesc,Layer,Width,Path,Pointer);     struct s *SymbolDesc;D     int Layer,Width;     struct p *Path;)     struct o **Pointer;l     {S     struct w *WireDesc;,     struct o *ObjectDesc;U     struct p *Pair;   A     if((WireDesc = (struct w *)malloc(sizeof(struct w))) == NULL)(! 	return(CDError(CDMALLOCFAILED));!C     if((ObjectDesc = (struct o *)malloc(sizeof(struct o))) == NULL)O! 	return(CDError(CDMALLOCFAILED));d     CDCheckPath(Path);     Width = abs(Width);%     WireDesc->wWidth = Width;e     WireDesc->wPath = Path;e,     ObjectDesc->oRep = (struct o *)WireDesc;"     ObjectDesc->oPrptyList = NULL;     ObjectDesc->oInfo = 0;     ObjectDesc->oType = CDWIRE;M     ObjectDesc->oLayer = Layer;M7     ObjectDesc->oLeft = ObjectDesc->oBottom = INFINITY; 6     ObjectDesc->oRight = ObjectDesc->oTop = -INFINITY;     Pair = Path;     while(Pair != NULL){) 	if(ObjectDesc->oLeft > Pair->pX-Width/2)I* 	    ObjectDesc->oLeft = Pair->pX-Width/2;* 	if(ObjectDesc->oRight < Pair->pX+Width/2)+ 	    ObjectDesc->oRight = Pair->pX+Width/2;C+ 	if(ObjectDesc->oBottom > Pair->pY-Width/2)w, 	    ObjectDesc->oBottom = Pair->pY-Width/2;( 	if(ObjectDesc->oTop < Pair->pY+Width/2)) 	    ObjectDesc->oTop = Pair->pY+Width/2;  	Pair = Pair->pSucc; 	}     *Pointer = ObjectDesc; p5     if(Not CDInsertObjectDesc(SymbolDesc,ObjectDesc))S 	return(False);,     return(True);N     }      intr4 CDMakeRoundFlash(SymbolDesc,Layer,Width,X,Y,Pointer)     struct s *SymbolDesc;e     int Layer,Width,X,Y;     struct o **Pointer;=     {h     struct r *RoundFlashDesc;;     struct o *ObjectDesc;c  G     if((RoundFlashDesc = (struct r *)malloc(sizeof(struct r))) == NULL) ! 	return(CDError(CDMALLOCFAILED));LC     if((ObjectDesc = (struct o *)malloc(sizeof(struct o))) == NULL) ! 	return(CDError(CDMALLOCFAILED)); #     RoundFlashDesc->rWidth = Width;u     RoundFlashDesc->rX = X;t     RoundFlashDesc->rY = Y;d2     ObjectDesc->oRep = (struct o *)RoundFlashDesc;"     ObjectDesc->oPrptyList = NULL;     ObjectDesc->oInfo = 0;%     ObjectDesc->oType = CDROUNDFLASH;r     ObjectDesc->oLayer = Layer; "     ObjectDesc->oLeft = X-Width/2;$     ObjectDesc->oBottom = Y-Width/2;#     ObjectDesc->oRight = X+Width/2; !     ObjectDesc->oTop = Y+Width/2;      *Pointer = ObjectDesc; -5     if(Not CDInsertObjectDesc(SymbolDesc,ObjectDesc))  	return(False);o     return(True);P     }a     int;> CDBeginMakeCall(SymbolDesc,SymbolName,NumX,DX,NumY,DY,Pointer)     struct s *SymbolDesc;      char *SymbolName;e     struct o **Pointer;      int NumX,DX,NumY,DY;     {,     /*B      * CDBeginMakeCall will return False if a CDMALLOCFAILED errorB      * occurs or if CDOpen fails.  Possible values for CDStatusInt      * upon return are:b-      *   (Fatal)-CDPARSEFAILED - Syntax errore/      *   (Fatal)-CDMALLOCFAILED - Out of memoryU4      *   (Fatal)-CDNEWSYMBOL - symbol does not exist?      *           CDOLDSYMBOL - successful return, symbol exists(D      * Only CDOLDSYMBOL is not a fatal return (i.e., CDBeginMakeCall      * returns True).W      */d     struct c *CallDesc;      struct o *ObjectDesc;R     struct m *MasterListDesc;      struct s *MasterSymbolDesc;      unsigned int size;  E     /* The symbol call is inserted into the database CDEndMakeCall */ A     if((CallDesc = (struct c *)malloc(sizeof(struct c))) == NULL)c! 	return(CDError(CDMALLOCFAILED));NC     if((ObjectDesc = (struct o *)malloc(sizeof(struct o))) == NULL)f! 	return(CDError(CDMALLOCFAILED));D     CallDesc->cNumX = NumX;;     CallDesc->cDX = DX;<     CallDesc->cNumY = NumY;c     CallDesc->cT = NULL;     CallDesc->cDY = DY;>,     ObjectDesc->oRep = (struct o *)CallDesc;"     ObjectDesc->oPrptyList = NULL;     ObjectDesc->oInfo = 0;%     ObjectDesc->oType = CDSYMBOLCALL;Y     ObjectDesc->oLayer = 0;c     *Pointer = ObjectDesc; D-     MasterListDesc = SymbolDesc->sMasterList;c     /*7      * Search masterList for an instance of SymbolName. I      * If not found, insert into the masterList (which is a linked list).yI      * An entry in the master list contains the symbol name, the bounding )      * box, and the number of references.b      */c	     loop{( 	if(MasterListDesc == NULL){ 	    /*e 	     * Insert into list' 	     * Firstly, try to allocate memoryf 	     */H 	    if((MasterListDesc = (struct m *)malloc(sizeof(struct m))) == NULL)" 		return(CDError(CDMALLOCFAILED));# 	    size = strlen(SymbolName) + 2;>7 	    if((MasterListDesc->mName = malloc(size)) == NULL)R" 		return(CDError(CDMALLOCFAILED));< 	    /* insert new instance at end of (linked) masterList */( 	    if(SymbolDesc->sMasterList != NULL)2 		SymbolDesc->sMasterList->mPred = MasterListDesc;5 	    MasterListDesc->mSucc = SymbolDesc->sMasterList;a" 	    MasterListDesc->mPred = NULL;. 	    SymbolDesc->sMasterList = MasterListDesc;) 	    MasterListDesc->mReferenceCount = 0;e. 	    strcpy(MasterListDesc->mName,SymbolName);, 	    if(CDDesc.dControl == DCONTROLVANILLA){ 		/*? 		 * DCONTROLVANILLA tells us that CDOpen is safe to call here.t@ 		 * Because StatusInt is checked, we ignore the returned value. 		 */>6 		CDOpen(MasterListDesc->mName,&MasterSymbolDesc,'r');A 		if(CDStatusInt == CDPARSEFAILED Or CDStatusInt == CDNEWSYMBOL){t? 		    /* CDOpen failed -- Don't put bad master in MasterList */ $ 		    if(CDStatusInt == CDNEWSYMBOL)1 			sprintf(CDStatusString,"Symbol %s not found.",u 			    MasterListDesc->mName);) 		    if(SymbolDesc->sMasterList != NULL)i) 			SymbolDesc->sMasterList->mPred = NULL;o' 		    strcpy(MasterListDesc->mName,"");p6 		    SymbolDesc->sMasterList = MasterListDesc->mSucc; 		    free(MasterListDesc);r 		    return(False); 		    }a0 		if(Not CDBB(MasterSymbolDesc,(struct o *)NULL,: 		    &(MasterListDesc->mLeft),&(MasterListDesc->mBottom),9 		    &(MasterListDesc->mRight),&(MasterListDesc->mTop)))  			return(False);(# 		if(Not CDClose(MasterSymbolDesc))e 		    return(False); 		} . 	    elif(CDDesc.dControl == DCONTROLCDOPEN Or* 	        CDDesc.dControl == DCONTROLPCIF){ 		/*= 		 * We CANNOT invoke CDBB here, because if the master symboli< 		 * hasn't already been mapped into main memory via CDOpen,< 		 * CDBB will invoke CDOpen which will then invoke PCIF and< 		 * since PCIF CANNOT be invoked recursively, all of PCIF's< 		 * state will be broken.  The solution is to defer filling> 		 * in the bounding box information for master list descs and? 		 * instance descs until PCIF has returned in CDOpen.  Why notT< 		 * write PCIF so it can be invoked recursively? For a deep6 		 * hierarchy, we might exceed the limit on open file= 		 * descriptors and we clearly don't want to limit hierarchym 		 * depth.n 		 */ 4 		MasterListDesc->mLeft = MasterListDesc->mBottom = 9 		    MasterListDesc->mRight = MasterListDesc->mTop = 0; e 		}t 	    break;  	    }5 	elif(strcmp(SymbolName,MasterListDesc->mName) == 0){s 	    /*s4 	     * A match!  This symbol is already in memeory. 	     */ 	    CDStatusInt = CDOLDSYMBOL;l 	    *CDStatusString = NULL; 	    break;s 	    } 	elseo, 	    MasterListDesc = MasterListDesc->mSucc; 	}'     CallDesc->cMaster = MasterListDesc;o)     MasterListDesc->mReferenceCount += 1;c     return(True);L     }y     int> CDT(Pointer,Type,X,Y)s     struct o *Pointer;     char Type;     int X,Y;     /*H      * After invoking BeginMakeCall, invoke T for each transformation inG      * the call.  The transformation is a linked list of transformation(F      * descs headed by the ct field of the call desc.  Finally, invoke      * EndMakeCall.D      */N     {l     struct c *CDesc;     struct t *TDesc;  '     CDesc = (struct c *)Pointer->oRep; t     TDesc = CDesc->cT;         if(TDesc == NULL){G 	if((CDesc->cT = TDesc = (struct t *)malloc(sizeof(struct t))) == NULL)a% 	    return(CDError(CDMALLOCFAILED));e 	TDesc->tSucc = NULL;a 	TDesc->tX = X;r 	TDesc->tY = Y;f 	TDesc->tType = Type;  	return(True); 	}     while(TDesc->tSucc != NULL)" 	TDesc = TDesc->tSucc;M     if((TDesc = TDesc->tSucc = (struct t *)malloc(sizeof(struct t))) == NULL)i! 	return(CDError(CDMALLOCFAILED));s     TDesc->tSucc = NULL;     TDesc->tX = X;     TDesc->tY = Y;     TDesc->tType = Type;     return(True);      }e     inte! CDEndMakeCall(SymbolDesc,Pointer)y     struct s *SymbolDesc;      struct o *Pointer;     {&     struct c *CallDesc;,     struct o *ObjectDesc;R     struct m *MasterListDesc;      struct t *TGen;      int X,Y;     char Type;       ObjectDesc = Pointer; ,     CallDesc = (struct c *)ObjectDesc->oRep;'     MasterListDesc = CallDesc->cMaster;R     if(TFull())	# 	return(CDError(CDXFORMSTACKFULL));e     TPush();     TIdentity();     CDInitTGen(Pointer,&TGen);
     loop { 	CDTGen(&TGen,&Type,&X,&Y);k 	if(TGen == NULL)  	    break;C 	if(Type == CDROTATE)  	    TRotate(X,Y); 	elif(Type == CDTRANSLATE) 	    TTranslate(X,Y);. 	elif(Type == CDMIRRORX) 	    TMX();* 	elif(Type == CDMIRRORY) 	    TMY();s 	}   #ifdef DEBUGREFLECT H printf("Making call of master %s in symbol %s.\n",MasterListDesc->mName,     SymbolDesc->sName);r7 printf("Untransformed (master's) BB is %d %d %d %d.\n",i2     MasterListDesc->mLeft,MasterListDesc->mBottom,1     MasterListDesc->mRight,MasterListDesc->mTop);  #endif  /     ObjectDesc->oLeft = MasterListDesc->mLeft; A2     ObjectDesc->oBottom = MasterListDesc->mBottom;8     TPoint(&(ObjectDesc->oLeft),&(ObjectDesc->oBottom));1     ObjectDesc->oRight = MasterListDesc->mRight;  ,     ObjectDesc->oTop = MasterListDesc->mTop;6     TPoint(&(ObjectDesc->oRight),&(ObjectDesc->oTop));.     if(ObjectDesc->oRight < ObjectDesc->oLeft)0 	SwapInts(ObjectDesc->oLeft,ObjectDesc->oRight);.     if(ObjectDesc->oTop < ObjectDesc->oBottom)0 	SwapInts(ObjectDesc->oBottom,ObjectDesc->oTop);   #ifdef DEBUGREFLECT 5 printf("Transformed, unarrayed BB is %d %d %d %d.\n",l*     ObjectDesc->oLeft,ObjectDesc->oBottom,)     ObjectDesc->oRight,ObjectDesc->oTop);C #endif       /**      * Take into account array parameters.      */)*     ObjectDesc->oRight = ObjectDesc->oLeft9 	+ (ObjectDesc->oRight-ObjectDesc->oLeft + CallDesc->cDX) ! 	* CallDesc->cNumX-CallDesc->cDX;A*     ObjectDesc->oTop = ObjectDesc->oBottom9 	+ (ObjectDesc->oTop-ObjectDesc->oBottom + CallDesc->cDY) ! 	* CallDesc->cNumY-CallDesc->cDY;c   #ifdef DEBUGREFLECT 3 printf("Transformed, arrayed BB is %d %d %d %d.\n",P*     ObjectDesc->oLeft,ObjectDesc->oBottom,)     ObjectDesc->oRight,ObjectDesc->oTop);  #endif       TPop();05     if(Not CDInsertObjectDesc(SymbolDesc,ObjectDesc))S 	return(False);r     return(True);      }c     void CDCheckPath(Path)o     struct p *Path;*     {      /*A      * Check to see that the path does not have two identical anda      * adjacent vertices.       */r     struct p *Pair;      struct p *Copy;e     Pair = Path;     while(Pair->pSucc != NULL){rA 	if(Pair->pX == Pair->pSucc->pX And Pair->pY == Pair->pSucc->pY){  	    Copy = Pair->pSucc; 	    Pair->pSucc = Copy->pSucc;) 	    free( Copy ); 	    } 	elses 	    Pair = Pair->pSucc; 	}     }      intC) CDInsertObjectDesc(SymbolDesc,ObjectDesc)t     struct s *SymbolDesc;      struct o *ObjectDesc;L     {      int Int1,Int2,Layer,X,Y;      int BeginX,EndX,BeginY,EndY;  I     CDIntersect(ObjectDesc->oLeft,ObjectDesc->oBottom,ObjectDesc->oRight,i/ 	ObjectDesc->oTop,&BeginX,&EndX,&BeginY,&EndY);A(     if(BeginX != EndX Or BeginY != EndY) 	X = Y = 0; 
     else {
 	X = BeginX; (
 	Y = BeginY; R 	}     Layer = ObjectDesc->oLayer;R6     if(SymbolDesc->sBin[Layer] == (struct o ***)NULL){ 	/* allocate Bin */ - 	if((SymbolDesc->sBin[Layer] = (struct o ***) 4 	    malloc(sizeof(char*) * (CDNUMBINS+1))) == NULL)% 	    return(CDError(CDMALLOCFAILED));t* 	for(Int1 = 0; Int1 <= CDNUMBINS; ++Int1){6 	    if((SymbolDesc->sBin[Layer][Int1] = (struct o **)8 	        malloc(sizeof(char*) * (CDNUMBINS+1))) == NULL)) 	        return(CDError(CDMALLOCFAILED)); . 	    for(Int2 = 0; Int2 <= CDNUMBINS; ++Int2){? 	        if((SymbolDesc->sBin[Layer][Int1][Int2] = (struct o *) , 	            malloc(sizeof(char*))) == NULL)- 	            return(CDError(CDMALLOCFAILED));)9 		SymbolDesc->sBin[Layer][Int1][Int2] = (struct o *)NULL;t
 	        } 	    } 	}0     elif(SymbolDesc->sBin[Layer][X][Y] != NULL){3 	SymbolDesc->sBin[Layer][X][Y]->oPred = ObjectDesc;e 	}6     ObjectDesc->oSucc = SymbolDesc->sBin[Layer][X][Y];/     SymbolDesc->sBin[Layer][X][Y] = ObjectDesc;L     ObjectDesc->oPred = NULL;bB     SymbolDesc->sLeft = min(SymbolDesc->sLeft,ObjectDesc->oLeft); H     SymbolDesc->sBottom = min(SymbolDesc->sBottom,ObjectDesc->oBottom); E     SymbolDesc->sRight = max(SymbolDesc->sRight,ObjectDesc->oRight);  ?     SymbolDesc->sTop = max(SymbolDesc->sTop,ObjectDesc->oTop); D   #ifdef DEBUGGENb if(X == 0 And Y == 0)sD     printf("Inserting a desc on layer %d in residual bin.\n",Layer); elseG     printf("Inserting a desc on layer %d in bin (%d,%d).\n",Layer,X,Y);b #endif   #ifdef DEBUGREFLECTt if(X == 0 And Y == 0)RD     printf("Inserting a desc on layer %d in residual bin.\n",Layer); elseG     printf("Inserting a desc on layer %d in bin (%d,%d).\n",Layer,X,Y);c #endif       return(True);o     }t       aI /*======================================================================*d  *									*9  *                 OOO  BBBB      J EEEEE  CCCC TTTTT			* 7  *                O   O B   B     J E     C       T			*S7  *                O   O BBBB      J EEE   C       T			*>7  *                O   O B   B J   J E     C       T			*P7  *                 OOO  BBBB   JJJ  EEEEE  CCCC   T			*e  *									*=  *           DDDD  EEEEE L     EEEEE TTTTT III  OOO  N   N		*o=  *           D   D E     L     E       T    I  O   O NN  N		*b=  *           D   D EEE   L     EEE     T    I  O   O N N N		*M=  *           D   D E     L     E       T    I  O   O N  NN		*==  *           DDDD  EEEEE LLLLL EEEEE   T   III  OOO  N   N		*Y  *									*  *									*  *									*0  *	CDDeleteObjectDesc(SymbolDesc,ObjectDesc)			*  *									*J  *======================================================================*/   void) CDDeleteObjectDesc(SymbolDesc,ObjectDesc)      struct s *SymbolDesc;      struct o *ObjectDesc;      {a     int Layer,X,Y;      int BeginX,EndX,BeginY,EndY;     struct p PCopy;      struct t TCopy;)     struct prpty  PrptyCopy;     struct prpty *PrptyDesc;  :     /* we should test the descriptors as valid pointers */     Layer = ObjectDesc->oLayer;(     /* is the Bin allocated? */c=     if(SymbolDesc->sBin[Layer] == NULL Or ObjectDesc == NULL)T 	return;I     CDIntersect(ObjectDesc->oLeft,ObjectDesc->oBottom,ObjectDesc->oRight,S/ 	ObjectDesc->oTop,&BeginX,&EndX,&BeginY,&EndY);m(     if(BeginX != EndX Or BeginY != EndY) 	X = Y = 0;A
     else {
 	X = BeginX; t
 	Y = BeginY;   	}.     if(SymbolDesc->sBin[Layer][X][Y] == NULL){ 	/* Something's rotten */) 	return; 	}B     elif(ObjectDesc->oPred == NULL And ObjectDesc->oSucc == NULL){% 	/* Only desc--has no pred or succ */ & 	SymbolDesc->sBin[Layer][X][Y] = NULL; 	}$     elif(ObjectDesc->oPred == NULL){- 	/* First desc.    Has a succ, but no pred */p3 	SymbolDesc->sBin[Layer][X][Y] = ObjectDesc->oSucc;u! 	ObjectDesc->oSucc->oPred = NULL;r 	}$     elif(ObjectDesc->oSucc == NULL){) 	/* Last desc--has a pred, but no succ */e" 	ObjectDesc->oPred->oSucc = NULL;  	}
     else {) 	/* Vanilla desc has a pred and a succ */t/ 	ObjectDesc->oSucc->oPred = ObjectDesc->oPred; B. 	ObjectDesc->oPred->oSucc = ObjectDesc->oSucc; 	}     /*      * Invalidate BB.       */n!     SymbolDesc->sBBValid = False;      /*%      * Free storage of property list;[      */ '     PrptyDesc = ObjectDesc->oPrptyList;      while(PrptyDesc != NULL){= 	PrptyCopy = *PrptyDesc;$ 	if(PrptyDesc->prpty_String != NULL)# 	    free(PrptyDesc->prpty_String);A 	free(PrptyDesc);*" 	PrptyDesc = PrptyCopy.prpty_Succ; 	}     /*      * Free storage of oRep;      */ )     if(ObjectDesc->oType == CDROUNDFLASH)*$ 	free((struct r *)ObjectDesc->oRep);,     elif(ObjectDesc->oType == CDSYMBOLCALL){ 	struct c *CallDesc; 	struct t *TDesc;   * 	CallDesc = (struct c *)ObjectDesc->oRep;  	TDesc = CallDesc->cT; 	while(TDesc != NULL){ 	    TCopy = *TDesc; 	    free(TDesc);  	    TDesc = TCopy.tSucc;T 	    } 	free(CallDesc); 	})     elif(ObjectDesc->oType == CDPOLYGON){  	struct po *PolygonDesc; 	struct p *Pair;  . 	PolygonDesc = (struct po *)ObjectDesc->oRep;  	Pair = PolygonDesc->poPath; 	while(Pair != NULL){	 	    PCopy = *Pair;  	    free(Pair); 	    Pair = PCopy.pSucc; 	    } 	free(PolygonDesc);	 	}&     elif(ObjectDesc->oType == CDWIRE){ 	struct w *WireDesc; 	struct p *Pair;  * 	WireDesc = (struct w *)ObjectDesc->oRep;  	Pair = WireDesc->wPath; 	while(Pair != NULL){t 	    PCopy = *Pair;n 	    free(Pair); 	    Pair = PCopy.pSucc; 	    } 	free(WireDesc); 	}     free(ObjectDesc);t   #ifdef DEBUGGENpB printf("Deleting a desc on layer %d in bin (%d,%d)\n.",Layer,X,Y); #endif       }i        I /*======================================================================*S  *									*A  *           A    CCCC  CCCC EEEEE  SSSS  SSSS III N   N  GGGG		*(@  *          A A  C     C     E     S     S      I  NN  N G   		*A  *         A   A C     C     EEE    SSS   SSS   I  N N N G GGG		*rA  *         AAAAA C     C     E         S     S  I  N  NN G   G		*g@  *         A   A  CCCC  CCCC EEEEE SSSS  SSSS  III N   N  GGG		*  *									*;  *             OOO  BBBB      J EEEEE  CCCC TTTTT  SSSS			*O7  *            O   O B   B     J E     C       T   S			* ;  *            O   O BBBB      J EEE   C       T    SSS 			*f;  *            O   O B   B J   J E     C       T       S			*b:  *             OOO  BBBB   JJJ  EEEEE  CCCC   T   SSSS			*  *									*  *									*  *									*1  *	CDCall(Pointer,SymbolName,NumX,DX,NumY,DY)			*a-  *	CDBox(Pointer,Layer,Length,Width,X,Y)				*s(  *	CDLabel(Pointer,Layer,Label,X,Y)				*&  *	CDPolygon(Pointer,Layer,Path)					*(  *	CDWire(Pointer,Layer,Width,Path)				*-  *	CDRoundFlash(Pointer,Layer,Width,X,Y)				*e  *									*J  *======================================================================*/   void* CDCall(Pointer,SymbolName,NumX,DX,NumY,DY)     struct o *Pointer;     char **SymbolName;     int *NumX,*DX,*NumY,*DY;     {P     struct c *CallDesc;i       if(Pointer == NULL)= 	return;'     if(Pointer->oType != CDSYMBOLCALL){( 	*SymbolName = NULL; 	*NumX = 0; 	 	*DX = 0;  	*NumY = 0;D	 	*DY = 0;a 	}
     else {& 	CallDesc = (struct c *)Pointer->oRep;( 	*SymbolName = CallDesc->cMaster->mName; 	*NumX = CallDesc->cNumX;) 	*DX = CallDesc->cDX;I 	*NumY = CallDesc->cNumY;  	*DY = CallDesc->cDY;- 	}     }]     void% CDBox(Pointer,Layer,Length,Width,X,Y)(     struct o *Pointer;$     int *Layer,*Length,*Width,*X,*Y;     {)       if(Pointer == NULL)r 	return;      if(Pointer->oType != CDBOX){) 	*Layer = *Length = *Width = *X = *Y = 0;a 	}
     else { 	*Layer = Pointer->oLayer;, 	*Length = Pointer->oRight - Pointer->oLeft;+ 	*Width = Pointer->oTop - Pointer->oBottom; & 	*X = Pointer->oLeft + (*Length >> 1);' 	*Y = Pointer->oBottom + (*Width >> 1);  	}     }e     void  CDLabel(Pointer,Layer,Label,X,Y)     struct o *Pointer;     int *Layer;(     char **Label;,     int *X,*Y;     {      struct la *LabelDesc;x       if(Pointer == NULL)e 	return;"     if(Pointer->oType != CDLABEL){ 	*Layer = *X = *Y = 0; 	*Label = NULL;d 	}
     else { 	*Layer = Pointer->oLayer;( 	LabelDesc = (struct la *)Pointer->oRep; 	*Label = LabelDesc->laLabel;  	*X = LabelDesc->laX;c 	*Y = LabelDesc->laY;, 	}     }e     void CDPolygon(Pointer,Layer,Path)      struct o *Pointer;     int *Layer;t     struct p **Path;     {i     struct po *PolygonDesc;        if(Pointer == NULL)o 	return;$     if(Pointer->oType != CDPOLYGON){ 	*Layer = 0; 	*Path = NULL; 	}
     else { 	*Layer = Pointer->oLayer;* 	PolygonDesc = (struct po *)Pointer->oRep; 	*Path = PolygonDesc->poPath;p 	}     }}     void  CDWire(Pointer,Layer,Width,Path)     struct o *Pointer;     int *Layer,*Width;     struct p **Path;     {c     struct w *WireDesc;D       if(Pointer == NULL){ 	return;!     if(Pointer->oType != CDWIRE){  	*Layer = *Width = 0;) 	*Path = NULL; 	}
     else { 	*Layer = Pointer->oLayer;& 	WireDesc = (struct w *)Pointer->oRep; 	*Width = WireDesc->wWidth;t 	*Path = WireDesc->wPath;e 	}     }      void% CDRoundFlash(Pointer,Layer,Width,X,Y)      struct o *Pointer;     int *Layer,*Width,*X,*Y;     {t     struct r *RoundFlashDesc;(       if(Pointer == NULL)	 	return;&     if(Pointer->oType != CDROUNDFLASH) 	return;     *Layer = Pointer->oLayer;=/     RoundFlashDesc = (struct r *)Pointer->oRep; $     *Width = RoundFlashDesc->rWidth;     *X = RoundFlashDesc->rX;     *Y = RoundFlashDesc->rY;     }n       DI /*======================================================================*   *									*A  *           A    CCCC  CCCC EEEEE  SSSS  SSSS III N   N  GGGG		*=@  *          A A  C     C     E     S     S      I  NN  N G   		*A  *         A   A C     C     EEE    SSS   SSS   I  N N N G GGG		*>A  *         AAAAA C     C     E         S     S  I  N  NN G   G		*=@  *         A   A  CCCC  CCCC EEEEE SSSS  SSSS  III N   N  GGG		*  *									*E  *    III N   N FFFFF  OOO  RRRR  M   M   A   TTTTT III  OOO  N   N	*hE  *     I  NN  N F     O   O R   R MM MM  A A    T    I  O   O NN  N	*iE  *     I  N N N FFF   O   O RRRR  M M M A   A   T    I  O   O N N N	* E  *     I  N  NN F     O   O R R   M   M AAAAA   T    I  O   O N  NN	*iE  *    III N   N F      OOO  R  R  M   M A   A   T   III  OOO  N   N	*e  *									*  *									*  *									*(  *	CDInfo(SymbolDesc,Pointer,Info)					**  *	CDSetInfo(SymbolDesc,Pointer,Info)				*/  *	CDProperty(SymbolDesc,Pointer,Property)				**5  *	CDAddProperty(SymbolDesc,Pointer,Value,String)			*e1  *	CDRemoveProperty(SymbolDesc,Pointer,Value)			*P  *	CDType(Pointer,Type)						*5  *	CDBB(SymbolDesc,Pointer,Left,Bottom,Right,Top)			**?  *	CDIntersect(Left,Bottom,Right,Top,BeginX,EndX,BeginY,EndY)	*;  *									*J  *======================================================================*/   void CDInfo(SymbolDesc,Pointer,Info)h     struct s *SymbolDesc;      struct o *Pointer;     int *Info;     /*#      * Return info field of object.f4      * If Pointer == NULL, object is symbol itself.       */N     {a     if(Pointer == NULL)  	*Info = SymbolDesc->sInfo;n     else 	*Info = Pointer->oInfo; p     }n     void" CDSetInfo(SymbolDesc,Pointer,Info)     struct s *SymbolDesc;P     struct o *Pointer;
     int Info;*     /*       * Set info field of object.4      * If Pointer == NULL, object is symbol itself.       */r     {L     if(Pointer == NULL)t 	SymbolDesc->sInfo = Info;     else 	Pointer->oInfo = Info;      }      void' CDProperty(SymbolDesc,Pointer,Property)r     struct s *SymbolDesc;i     struct o *Pointer;     struct prpty **Property;     /*#      * Return info field of object.y4      * If Pointer == NULL, object is symbol itself.       */c     {u     if(Pointer == NULL) $ 	*Property = SymbolDesc->sPrptyList;     else" 	*Property = Pointer->oPrptyList;      }r     intP. CDAddProperty(SymbolDesc,Pointer,Value,String)     struct s *SymbolDesc;o     struct o *Pointer;     char *String;r     int Value;     {s     char * cp;     struct prpty *prptyDesc;     unsigned int size;  K     if((prptyDesc = (struct prpty *) malloc(sizeof(struct prpty))) == NULL);! 	return(CDError(CDMALLOCFAILED));      size = strlen(String) + 2; G=     if((cp = prptyDesc->prpty_String = malloc(size)) == NULL)y! 	return(CDError(CDMALLOCFAILED)); #     prptyDesc->prpty_Value = Value;=+     strcpy(prptyDesc->prpty_String,String);	3     /* we can't allaow semicolons because of CIF */S%     while(cp != NULL && *cp != NULL){C 	if(*cp == ';')S 	    *cp = ' ';  	++cp; 	}     if(Pointer == NULL){0 	prptyDesc->prpty_Succ = SymbolDesc->sPrptyList;$ 	SymbolDesc->sPrptyList = prptyDesc; 	}	     else{G- 	prptyDesc->prpty_Succ = Pointer->oPrptyList;S" 	Pointer->oPrptyList = prptyDesc;  	}     return(True);B     }      intC* CDRemoveProperty(SymbolDesc,Pointer,Value)     struct s *SymbolDesc;      struct o *Pointer;     int Value;     {      struct prpty *prptyDesc;     struct prpty *prptyHead;     struct prpty prptyCopy;        if(Pointer == NULL){0 	prptyHead = prptyDesc = SymbolDesc->sPrptyList; 	SymbolDesc->sPrptyList = NULL;e 	}	     else{m. 	prptyHead = prptyDesc = Pointer->oPrptyList;  	Pointer->oPrptyList = NULL; o 	}     while(prptyDesc != NULL){X% 	if(prptyDesc->prpty_Value != Value){eD 	    if(Not CDAddProperty(SymbolDesc,Pointer,prptyDesc->prpty_Value," 	        prptyDesc->prpty_String)) 	        return(False);o 	    }# 	prptyDesc = prptyDesc->prpty_Succ;  	}     /*)      * Free storage of property old list;D      */      prptyDesc = prptyHead;     while(prptyDesc != NULL){= 	prptyCopy = *prptyDesc;$ 	if(prptyDesc->prpty_String != NULL)# 	    free(prptyDesc->prpty_String);  	free(prptyDesc); " 	prptyDesc = prptyCopy.prpty_Succ; 	}     return(True);c     }      void CDType(Pointer,Type)     struct o *Pointer;     char *Type;c     /*4      * Returns type of object pointed to by Pointer.      */      {      *Type = Pointer->oType;      }n     int;. CDBB(SymbolDesc,Pointer,Left,Bottom,Right,Top)     struct s *SymbolDesc;s     struct o *Pointer;"     int *Left,*Bottom,*Right,*Top;     /*1      * Return BB of object pointed to by Pointer.R6      * If Pointer == NULL, return BB of symbol itself.M      * Basically, we CAN'T afford to recompute the BB of the symbol each timer9      * CDDelete or an object creation routine is invoked.r      *L      * If malloc fails, CDBB will return False via CDError.  Otherwise, True      * is returned.o      */u     {o     struct g *GenDesc;     int Layer;  1     if(Pointer == NULL And SymbolDesc->sBBValid){s 	*Left = SymbolDesc->sLeft;  	*Bottom = SymbolDesc->sBottom;  	*Right = SymbolDesc->sRight;) 	*Top = SymbolDesc->sTop;(   #ifdef DEBUGREFLECT N printf("CDBB1(%s,%d,%d,%d,%d)\n",SymbolDesc->sName,*Left,*Bottom,*Right,*Top); #endif L   #ifdef DEBUGGEN(N printf("CDBB1(%s,%d,%d,%d,%d)\n",SymbolDesc->sName,*Left,*Bottom,*Right,*Top); #endif i   	return(True); 	}     elif(Pointer != NULL){ 	*Left = Pointer->oLeft; 	*Bottom = Pointer->oBottom; 	*Right = Pointer->oRight; 	*Top = Pointer->oTop;   #ifdef DEBUGREFLECT N printf("CDBB2(%s,%d,%d,%d,%d)\n",SymbolDesc->sName,*Left,*Bottom,*Right,*Top); #endif }   #ifdef DEBUGGENyN printf("CDBB2(%s,%d,%d,%d,%d)\n",SymbolDesc->sName,*Left,*Bottom,*Right,*Top); #endif u   	return(True); 	}7     SymbolDesc->sLeft = SymbolDesc->sBottom = INFINITY;t6     SymbolDesc->sRight = SymbolDesc->sTop = -INFINITY;N     if(Not CDInitGen(SymbolDesc,0,(int)-INFINITY,(int)-INFINITY,(int)INFINITY,: 	(int)INFINITY,&GenDesc)) return(CDError(CDMALLOCFAILED));
     loop {$ 	CDGen(SymbolDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;l< 	SymbolDesc->sLeft = min(SymbolDesc->sLeft,Pointer->oLeft); B 	SymbolDesc->sBottom = min(SymbolDesc->sBottom,Pointer->oBottom); ? 	SymbolDesc->sRight = max(SymbolDesc->sRight,Pointer->oRight); e9 	SymbolDesc->sTop = max(SymbolDesc->sTop,Pointer->oTop); t 	}0     for(Layer = 1;Layer <= CDNUMLAYERS;++Layer){A 	if(Not CDInitGen(SymbolDesc,Layer,(int)-INFINITY,(int)-INFINITY,o+ 	    (int)INFINITY,(int)INFINITY,&GenDesc))r% 	    return(CDError(CDMALLOCFAILED));=$ 	CDGen(SymbolDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    continue; 	loop {-@ 	    SymbolDesc->sLeft = min(SymbolDesc->sLeft,Pointer->oLeft); F 	    SymbolDesc->sBottom = min(SymbolDesc->sBottom,Pointer->oBottom); C 	    SymbolDesc->sRight = max(SymbolDesc->sRight,Pointer->oRight); A= 	    SymbolDesc->sTop = max(SymbolDesc->sTop,Pointer->oTop);  ( 	    CDGen(SymbolDesc,GenDesc,&Pointer); 	    if(Pointer == NULL) 		break; 	    } 	}%     if(SymbolDesc->sLeft == INFINITY)O@ 	SymbolDesc->sLeft = SymbolDesc->sBottom = SymbolDesc->sRight =  	    SymbolDesc->sTop = 0;      SymbolDesc->sBBValid = True;     *Left = SymbolDesc->sLeft;"     *Bottom = SymbolDesc->sBottom;      *Right = SymbolDesc->sRight;     *Top = SymbolDesc->sTop;   #ifdef DEBUGGEN N printf("CDBB3(%s,%d,%d,%d,%d)\n",SymbolDesc->sName,*Left,*Bottom,*Right,*Top); #endif r   #ifdef DEBUGREFLECTnN printf("CDBB3(%s,%d,%d,%d,%d)\n",SymbolDesc->sName,*Left,*Bottom,*Right,*Top); #endif A       return(True);,     },     /*  * Test code for CDIntersect.(	  * main()P  *     {9  *     int Left,Bottom,Right,Top,BeginX,EndX,BeginY,EndY;c  *  *     printf("BB?");T3  *     scanf("%d%d%d%d",&Left,&Bottom,&Right,&Top);,F  *     CDIntersect(Left,Bottom,Right,Top,&BeginX,&EndX,&BeginY,&EndY);B  *     printf("Bin[.][%d..%d][%d..%d]\n",BeginX,EndX,BeginY,EndY);  *     }  */    void: CDIntersect(Left,Bottom,Right,Top,BeginX,EndX,BeginY,EndY)     int Left,Bottom,Right,Top;$     int *BeginX,*EndX,*BeginY,*EndY;     /*)      * Returns which bins overlap the AOIf*      * The residual bin is always searched      * Runs in constant time      */;     {  #ifdef FLOATc     *BeginX = (int)((float)(Left-CDBINMINX) * (float)(CDNUMBINS)/(float)(CDBINMAXX-CDBINMINX) + 1);      if(*BeginX > CDNUMBINS)h 	*BeginX = CDNUMBINS;      elif(*BeginX < 1)c
 	*BeginX = 1; b     *EndX = (int)((float)(Right-CDBINMINX) * (float)(CDNUMBINS)/(float)(CDBINMAXX-CDBINMINX) + 1);     if(*EndX > CDNUMBINS)  	*EndX = CDNUMBINS;s     elif(*EndX < 1)e 	*EndX = 1;Le     *BeginY = (int)((float)(Bottom-CDBINMINY) * (float)(CDNUMBINS)/(float)(CDBINMAXY-CDBINMINY) + 1);      if(*BeginY > CDNUMBINS)s 	*BeginY = CDNUMBINS;-     elif(*BeginY < 1)o
 	*BeginY = 1;s`     *EndY = (int)((float)(Top-CDBINMINY) * (float)(CDNUMBINS)/(float)(CDBINMAXY-CDBINMINY) + 1);     if(*EndY > CDNUMBINS)o 	*EndY = CDNUMBINS;C     elif(*EndY < 1)  	*EndY = 1;t #elsebI     *BeginX = ((Left-CDBINMINX) * (CDNUMBINS)/(CDBINMAXX-CDBINMINX) + 1);I     if(*BeginX > CDNUMBINS)D 	*BeginX = CDNUMBINS;=     elif(*BeginX < 1)D
 	*BeginX = 1; H     *EndX = ((Right-CDBINMINX) * (CDNUMBINS)/(CDBINMAXX-CDBINMINX) + 1);     if(*EndX > CDNUMBINS)r 	*EndX = CDNUMBINS;o     elif(*EndX < 1)S 	*EndX = 1;oK     *BeginY = ((Bottom-CDBINMINY) * (CDNUMBINS)/(CDBINMAXY-CDBINMINY) + 1);i     if(*BeginY > CDNUMBINS)D 	*BeginY = CDNUMBINS;e     elif(*BeginY < 1);
 	*BeginY = 1;SF     *EndY = ((Top-CDBINMINY) * (CDNUMBINS)/(CDBINMAXY-CDBINMINY) + 1);     if(*EndY > CDNUMBINS)e 	*EndY = CDNUMBINS;m     elif(*EndY < 1)o 	*EndY = 1;m #endif     }s        I /*======================================================================*y  *									*D  *      GGGG EEEEE N   N EEEEE RRRR    A   TTTTT  OOO  RRRR   SSSS	*A  *     G     E     NN  N E     R   R  A A    T   O   O R   R S		*(C  *     G GGG EEE   N N N EEE   RRRR  A   A   T   O   O RRRR   SSS	*dD  *     G   G E     N  NN E     R R   AAAAA   T   O   O R R       S	*C  *      GGG  EEEEE N   N EEEEE R  R  A   A   T    OOO  R  R  SSSS	*,  *									*  *									*  *									*>  *	CDInitGen(SymbolDesc,Layer,Left,Bottom,Right,Top,GenDesc)	*)  *	CDGen(SymbolDesc,GenDesc,Pointer)				*(!  *	CDInitTGen(Pointer,TGen)					*L  *	CDTGen(TGen,Type,X,Y)						*   *									*J  *======================================================================*/   intd9 CDInitGen(SymbolDesc,Layer,Left,Bottom,Right,Top,GenDesc)      struct s *SymbolDesc;h$     int Layer,Left,Bottom,Right,Top;     struct g **GenDesc;      /*-      * Returns a pointer to a generator desc.t       * Layer == 0 denotes calls.      */e     {a      int BeginX,BeginY,EndX,EndY;   #ifdef DEBUGGENeP printf("Begin initializing generator to search symbol %s.\n",SymbolDesc->sName);D printf("Untransformed AOI is %d %d %d %d.\n",Left,Bottom,Right,Top); #endif       /*6      * Apply inverse of current transformation to AOI.      */E     TInverse();t!     TInversePoint(&Left,&Bottom);I     TInversePoint(&Right,&Top);+     if(Right < Left) 	SwapInts(Left,Right);     if(Top < Bottom) 	SwapInts(Bottom,Top);   #ifdef DEBUGGEN(B printf("Transformed AOI is %d %d %d %d.\n",Left,Bottom,Right,Top); #endif  C     CDIntersect(Left,Bottom,Right,Top,&BeginX,&EndX,&BeginY,&EndY);a   #ifdef DEBUGGENtK printf("Initialized generator to search bins %d..%d,%d..%d on layer %d.\n", #     BeginX,EndX,BeginY,EndY,Layer);c #endif  A     if((*GenDesc = (struct g *)malloc(sizeof(struct g))) == NULL)n! 	return(CDError(CDMALLOCFAILED));g     (*GenDesc)->gLeft = Left; !     (*GenDesc)->gBottom = Bottom;-     (*GenDesc)->gRight = Right;-     (*GenDesc)->gTop = Top;s     (*GenDesc)->gLayer = Layer;c2     (*GenDesc)->gX = (*GenDesc)->gBeginX = BeginX;0     (*GenDesc)->gY = (*GenDesc)->gBeginY = EndY;     (*GenDesc)->gEndX = EndX;h     (*GenDesc)->gEndY = BeginY;G     /*7      * CDGen will ALWAYS search the residual bin FIRST.o6      * The vanilla bins will be searched in the order       *  for Y = EndY..BeginY =       *      for X = BeginX..EndX      *	  ...-      * so that redisplays will flow top down.o      */d'     if(SymbolDesc->sBin[Layer] == NULL)%$         (*GenDesc)->gPointer = NULL;     else=         (*GenDesc)->gPointer = SymbolDesc->sBin[Layer][0][0];,   #ifdef DEBUGGENsN printf("End initializing generator to search symbol %s.\n",SymbolDesc->sName); #endif       return(True);      }I     void! CDGen(SymbolDesc,GenDesc,Pointer)o     struct s *SymbolDesc;C     struct g *GenDesc;     struct o **Pointer;T     /*&      * Returns pointer to next object.H      * You should invoke CDType to access object's type and dispatch offI      * of type.  See traversal code in CDUpdate.  Pointer == NULL if lasts-      * object at which time GenDesc is freed.e      */N     {-     int i,L,B,R,T;  
     loop { 	if(GenDesc->gPointer != NULL){( 	    /*M? 	     * gPointer points to an object desc.    Is it in the AOI? G 	     * This test is necessary, because of the granularity of the bins.Y1 	     * Suppose AOI lies entirely within one bin.CE 	     * Then there may, in general, be descs in the bin whose BBs lie* 	     * outside the AOI. l 	     */" 	    L = GenDesc->gPointer->oLeft;$ 	    B = GenDesc->gPointer->oBottom;# 	    R = GenDesc->gPointer->oRight;t! 	    T = GenDesc->gPointer->oTop;s   #ifdef DEBUGGENr? printf("Generator intersecting %d %d %d %d to AOI.\n",L,B,R,T);  #endif  3 	    if(L > GenDesc->gRight Or B > GenDesc->gTop Or.. 		R < GenDesc->gLeft Or T < GenDesc->gBottom){ 		/*? 		 * Object isn't visible, so consider the next one, if any, in)& 		 * the bin currently being searched. 		 */ / 		GenDesc->gPointer = GenDesc->gPointer->oSucc;f   #ifdef DEBUGGENs printf("Invisible.\n");t #endif   		}  	    else {    #ifdef DEBUGGENt printf("Visible.\n");E #endif   		/*. 		 * Object is visible, so return object desc. 		 */  		*Pointer = GenDesc->gPointer;a/ 		GenDesc->gPointer = GenDesc->gPointer->oSucc;c	 		return;  		}  	    } 	else {u& 	    if(GenDesc->gY < GenDesc->gEndY){ 		/* The generator is done */L 		free(GenDesc); 		*Pointer = NULL;	 		return;D 		}> 	    /* * 	     * Consider first object in next bin.A 	     * If the bin is empty, we will pass through the loop again.  	     */ 	    i = GenDesc->gLayer;=% 	    if(SymbolDesc->sBin[i] == NULL){c 		/* The generator is done */s 		free(GenDesc); 		*Pointer = NULL;	 		return;Y 		} G 	    GenDesc->gPointer = SymbolDesc->sBin[i][GenDesc->gX][GenDesc->gY];e 	    ++(GenDesc->gX);e& 	    if(GenDesc->gX > GenDesc->gEndX){! 		GenDesc->gX = GenDesc->gBeginX;e 		--(GenDesc->gY); 		}  	    } 	}     }s     void CDInitTGen(Pointer,TGen)     struct o *Pointer;     struct t **TGen;     {*     struct c *CallDesc;;       if(Pointer == NULL)s 	return;&     if(Pointer->oType != CDSYMBOLCALL) 	return;)     CallDesc = (struct c *)Pointer->oRep;t     *TGen = CallDesc->cT;o     }s     void CDTGen(TGen,Type,X,Y))     struct t **TGen;     char *Type;G     int *X,*Y;     {t     static FirstDesc = True;       if(*TGen == NULL)t 	return;     elif(FirstDesc){ 	FirstDesc = False;t 	*X = (*TGen)->tX; 	*Y = (*TGen)->tY; 	*Type = (*TGen)->tType; 	}
     else { 	*TGen = (*TGen)->tSucc; 	if(*TGen == NULL){t 	    FirstDesc = True; 	    return; 	    } 	*X = (*TGen)->tX; 	*Y = (*TGen)->tY; 	*Type = (*TGen)->tType; 	}     }o       (I /*======================================================================*t  *									*/  *                          CCCC III FFFFF				*e.  *                         C      I  F   				*.  *                         C      I  FFFF				*-  *                         C      I  F  				* -  *                          CCCC III F 					*   *									*E  *  TTTTT RRRR    A   N   N  SSSS L       A   TTTTT III  OOO  N   N	* E  *    T   R   R  A A  NN  N S     L      A A    T    I  O   O NN  N	* E  *    T   RRRR  A   A N N N  SSS  L     A   A   T    I  O   O N N N	*CE  *    T   R R   AAAAA N  NN     S L     AAAAA   T    I  O   O N  NN	**E  *    T   R  R  A   A N   N SSSS  LLLLL A   A   T   III  OOO  N   N	*   *									*  *									*  *									*(  *	CDUpdate(SymbolDesc,SymbolFile)					*2  *	CDGenCIF(FileDesc,SymbolDesc,SymbolNum,A,B)			*'  *	CDTo(CIFFile,Root,A,B,Program)					*=7  *	CDFrom(Root,CIFFile,A,B,Layers,NumLayers,Program)		*=  *	CDUnmark(SymbolDesc)						*  *									*J  *======================================================================*/   intR CDUpdate(SymbolDesc,SymbolFile)(     struct s *SymbolDesc;E     char *SymbolFile;O     /*$      * Update symbol to symbol file.?      * If SymbolFile == NULL, update to file SymbolDesc->sName. 3      * Returns True if success, else returns False.	      */*     {	     FILE *FileDesc;C     struct g *GenDesc;     struct o *Pointer;     struct t *TGen;S     struct p *Path;n     struct prpty *PrptyDesc;     char *Label;     char *SymbolName;)     int Layer,X,Y,Length,Width;=     int NumX,DX,NumY,DY;     char Type;       if(SymbolFile == NULL){ H 	if((FileDesc = POpen(SymbolDesc->sName,"w",(char *)NULL,(char **)NULL)) 	    == NULL) return(False);8 	fprintf(FileDesc,"(Symbol %s);\n",SymbolDesc->sName); }
     else {A 	if((FileDesc = POpen(SymbolFile,"w",(char *)NULL,(char **)NULL))  	    == NULL) return(False); X2 	fprintf(FileDesc,"(Symbol %s);\n",SymbolFile); } 2     fprintf(FileDesc,"9 %s;\n",SymbolDesc->sName);      /* add property list info */7     CDProperty(SymbolDesc,(struct o *)NULL,&PrptyDesc);,     while(PrptyDesc != NULL){D6 	fprintf(FileDesc,"5 %d %s;\n",PrptyDesc->prpty_Value, 	    PrptyDesc->prpty_String);# 	PrptyDesc = PrptyDesc->prpty_Succ;s 	}#     GenBeginSymbol(FileDesc,0,1,1);b7     SymbolDesc->sLeft = SymbolDesc->sBottom = INFINITY; 6     SymbolDesc->sRight = SymbolDesc->sTop = -INFINITY;N     if(Not CDInitGen(SymbolDesc,0,(int)-INFINITY,(int)-INFINITY,(int)INFINITY,: 	(int)INFINITY,&GenDesc)) return(CDError(CDMALLOCFAILED));
     loop {$ 	CDGen(SymbolDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;	1 	CDCall(Pointer,&SymbolName,&NumX,&DX,&NumY,&DY);	  	/* add symbol name extension */( 	fprintf(FileDesc,"9 %s;\n",SymbolName); 	/* add property list info */ + 	CDProperty(SymbolDesc,Pointer,&PrptyDesc);  	while(PrptyDesc != NULL){: 	    fprintf(FileDesc,"5 %d %s;\n",PrptyDesc->prpty_Value, 		PrptyDesc->prpty_String); ' 	    PrptyDesc = PrptyDesc->prpty_Succ;  	    }! 	/* add symbol array extension */  	if(NumX != 1 Or NumY != 1) @ 	    fprintf(FileDesc,"1 Array %d %d %d %d;\n",NumX,DX,NumY,DY); 	fprintf(FileDesc,"C 0");  	CDInitTGen(Pointer,&TGen);R 	loop {  	    CDTGen(&TGen,&Type,&X,&Y);O 	    if(TGen == NULL){ 		fprintf(FileDesc,";\n"); 		break; 		}( 	    elif(Type == CDROTATE) # 		fprintf(FileDesc," R %d %d",X,Y);l 	    elif(Type == CDTRANSLATE)# 		fprintf(FileDesc," T %d %d",X,Y);t 	    elif(Type == CDMIRRORX) 		fprintf(FileDesc," MX"); 	    elif(Type == CDMIRRORY) 		fprintf(FileDesc," MY"); 	    }< 	SymbolDesc->sLeft = min(SymbolDesc->sLeft,Pointer->oLeft); B 	SymbolDesc->sBottom = min(SymbolDesc->sBottom,Pointer->oBottom); ? 	SymbolDesc->sRight = max(SymbolDesc->sRight,Pointer->oRight); b9 	SymbolDesc->sTop = max(SymbolDesc->sTop,Pointer->oTop); R 	}0     for(Layer = 1;Layer <= CDNUMLAYERS;++Layer){A 	if(Not CDInitGen(SymbolDesc,Layer,(int)-INFINITY,(int)-INFINITY,o+ 	    (int)INFINITY,(int)INFINITY,&GenDesc))p% 	    return(CDError(CDMALLOCFAILED)); $ 	CDGen(SymbolDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    continue;D 	GenLayer(FileDesc,CDLayer[Layer].lTechnology,CDLayer[Layer].lMask); 	loop{/ 	    CDProperty(SymbolDesc,Pointer,&PrptyDesc);U 	    while(PrptyDesc != NULL){7 		fprintf(FileDesc,"5 %d %s;\n",PrptyDesc->prpty_Value,o 		    PrptyDesc->prpty_String);($ 		PrptyDesc = PrptyDesc->prpty_Succ; 		}L 	    CDType(Pointer,&Type);U 	    if(Type == CDWIRE){& 		CDWire(Pointer,&Layer,&Width,&Path); 		GenWire(FileDesc,Width,Path);s 		}S 	    elif(Type == CDPOLYGON){p" 		CDPolygon(Pointer,&Layer,&Path); 		GenPolygon(FileDesc,Path); 		}D 	    elif(Type == CDLABEL){=' 		CDLabel(Pointer,&Layer,&Label,&X,&Y);P, 		fprintf(FileDesc,"94 %s %d %d",Label,X,Y); 		fprintf(FileDesc,";\n"); 		}> 	    elif(Type == CDBOX){g- 		CDBox(Pointer,&Layer,&Length,&Width,&X,&Y);f( 		GenBox(FileDesc,Length,Width,X,Y,1,0); 		}l@ 	    SymbolDesc->sLeft = min(SymbolDesc->sLeft,Pointer->oLeft); F 	    SymbolDesc->sBottom = min(SymbolDesc->sBottom,Pointer->oBottom); C 	    SymbolDesc->sRight = max(SymbolDesc->sRight,Pointer->oRight);  = 	    SymbolDesc->sTop = max(SymbolDesc->sTop,Pointer->oTop); s( 	    CDGen(SymbolDesc,GenDesc,&Pointer); 	    if(Pointer == NULL) 		break; 	    } 	}%     if(SymbolDesc->sLeft == INFINITY) @ 	SymbolDesc->sLeft = SymbolDesc->sBottom = SymbolDesc->sRight =  	    SymbolDesc->sTop = 0;     GenEndSymbol(FileDesc);e     GenEnd(FileDesc);p     fclose(FileDesc);a)     CDDesc.dSymbolDesc->sBBValid = True;       return(True);>     }      intc3 CDGenCIF(FileDesc,SymbolDesc,SymbolNum,A,B,Program)	     FILE *FileDesc;e     struct s *SymbolDesc;>     int *SymbolNum,A,B;i     char Program;e     {g     struct g *GenDesc;     struct o *Pointer;     struct s *MasterDesc;D     struct p *Pair,*Path;e     struct t *TGen;      struct prpty *PrptyDesc;     char *SymbolName;r     char *Label;     int Layer,X,Y,Length,Width;;     int NumX,DX,NumY,DY;
     int Info;      int i,j,FirstT;      int Left,Bottom,Right,Top;     int OutputLayer;     char Type;       *SymbolNum += 1; >     /*B      * Mark symbol associated withSymbolDesc as visited by storing2      * its symbol # in its info field.  VERY NICE.      */ 6     CDSetInfo(SymbolDesc,(struct o *)NULL,*SymbolNum);       /*?      * First write to the CIF file any symbol definitions below;-      * the symbol associated with SymbolDesc.       */lN     if(Not CDInitGen(SymbolDesc,0,(int)-INFINITY,(int)-INFINITY,(int)INFINITY,: 	(int)INFINITY,&GenDesc)) return(CDError(CDMALLOCFAILED));
     loop {$ 	CDGen(SymbolDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;,1 	CDCall(Pointer,&SymbolName,&NumX,&DX,&NumY,&DY);C+ 	if(Not CDOpen(SymbolName,&MasterDesc,'w'))	 	    return(False); + 	CDInfo(MasterDesc,(struct o *)NULL,&Info);b 	if(Info == 0)1 	    /* Write master's definition to CIF file. */i@ 	    if(Not CDGenCIF(FileDesc,MasterDesc,SymbolNum,A,B,Program)) 		return(False); 	}       /*I      * Write to the CIF file the definition of the symbol associated withP:      * SymbolDesc.  Instance calls first--then geometries.      */y     if(Program == 'e'){F4 	CDProperty(SymbolDesc,(struct o *)NULL,&PrptyDesc); 	while(PrptyDesc != NULL){: 	    fprintf(FileDesc,"5 %d %s;\n",PrptyDesc->prpty_Value, 		PrptyDesc->prpty_String);>' 	    PrptyDesc = PrptyDesc->prpty_Succ;n 	    } 	}.     CDInfo(SymbolDesc,(struct o *)NULL,&Info);*     fprintf(FileDesc,"DS %d 1 1;\n",Info);'     /* write symbol rename extension */)@     if(Program == 'b' Or Program == 'a')		/* NCA/Stanford CIF */1 	fprintf(FileDesc,"( %s );\n",SymbolDesc->sName);>2     elif(Program == 'i')				/* Icarus style CIF */3 	fprintf(FileDesc,"( 9 %s );\n",SymbolDesc->sName);m/     elif(Program == 's')				/* SIF style CIF */L7 	fprintf(FileDesc,"( Name: %s );\n",SymbolDesc->sName);I"     else						/* KIC/CD default *// 	fprintf(FileDesc,"9 %s;\n",SymbolDesc->sName);DN     if(Not CDInitGen(SymbolDesc,0,(int)-INFINITY,(int)-INFINITY,(int)INFINITY,: 	(int)INFINITY,&GenDesc)) return(CDError(CDMALLOCFAILED));
     loop {$ 	CDGen(SymbolDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;m1 	CDCall(Pointer,&SymbolName,&NumX,&DX,&NumY,&DY);>+ 	if(Not CDOpen(SymbolName,&MasterDesc,'w'))e 	    return(False);g+ 	CDInfo(MasterDesc,(struct o *)NULL,&Info);tD 	if(Not CDBB(MasterDesc,(struct o *)NULL,&Left,&Bottom,&Right,&Top)) 	    return(False);D 	for(i = 1;i <= NumY;++i){ 	    for(j = 1;j <= NumX;++j){ 		Width = Right - Left;  		Length = Top - Bottom;% 		/* write property list extension */n 		if(Program == 'e'){;0 		    CDProperty(SymbolDesc,Pointer,&PrptyDesc); 		    while(PrptyDesc != NULL){r8 			fprintf(FileDesc,"5 %d %s;\n",PrptyDesc->prpty_Value,  			    PrptyDesc->prpty_String);% 			PrptyDesc = PrptyDesc->prpty_Succ;f 			} 		    }t  		fprintf(FileDesc,"C %d",Info); 		FirstT = True; 		CDInitTGen(Pointer,&TGen); 		loop {  		    CDTGen(&TGen,&Type,&X,&Y); 		    if(TGen == NULL){  			fprintf(FileDesc,";\n");n	 			break;, 			} 		    elif(Type == CDROTATE){I$ 			fprintf(FileDesc," R %d %d",X,Y);
 			if(X == 0)M 			    SwapInts(Width,Length); 			}+ 		    elif(Type == CDTRANSLATE And FirstT){L 			fprintf(FileDesc," T %d %d",,; 			    (X+(j-1)*(Width+DX))*A/B,(Y+(i-1)*(Length+DY))*A/B);, 			FirstT = False; 			}  		    elif(Type == CDTRANSLATE) , 			fprintf(FileDesc," T %d %d",X*A/B,Y*A/B); 		    elif(Type == CDMIRRORX)  			fprintf(FileDesc," MX");  		    elif(Type == CDMIRRORY)m 			fprintf(FileDesc," MY");n 		    }  		}  	    } 	}0     for(Layer = 1;Layer <= CDNUMLAYERS;++Layer){ 	if(CDLayer[Layer-1].lCDFrom){/ 	    if(Program == 'b'){				/* NCA style CIF */ + 	        fprintf(FileDesc,"L %d;\n",Layer);r 		} 
 	    else{6 	        GenLayer(FileDesc,CDLayer[Layer].lTechnology, 		    CDLayer[Layer].lMask); 		}  	    OutputLayer = True; 	    } 	elsen 	    OutputLayer = False;eA 	if(Not CDInitGen(SymbolDesc,Layer,(int)-INFINITY,(int)-INFINITY,(+ 	    (int)INFINITY,(int)INFINITY,&GenDesc)) % 	    return(CDError(CDMALLOCFAILED));  	loop {t( 	    CDGen(SymbolDesc,GenDesc,&Pointer); 	    if(Pointer == NULL) 	        break;R( 	    /* write property list extension */ 	    if(Program == 'e'){, 		CDProperty(SymbolDesc,Pointer,&PrptyDesc);. 		while(PrptyDesc != NULL And Program == 'e'){; 		    fprintf(FileDesc,"5 %d %s;\n",PrptyDesc->prpty_Value,> 			PrptyDesc->prpty_String);( 		    PrptyDesc = PrptyDesc->prpty_Succ; 		    }o 		}e 	    CDType(Pointer,&Type);L) 	    if(!OutputLayer && Type != CDLABEL){( 		/* output all labels */Y 		}  	    elif(Type == CDBOX){I- 		CDBox(Pointer,&Layer,&Length,&Width,&X,&Y);L8 		GenBox(FileDesc,Length*A/B,Width*A/B,X*A/B,Y*A/B,1,0); 		}L 	    elif(Type == CDWIRE){& 		CDWire(Pointer,&Layer,&Width,&Path); 		if(Path->pSucc == NULL){. 		    fprintf(FileDesc,"W %d %d %d",Width*A/B, 			Path->pX*A/B,Path->pY*A/B); 		else {) 		    fprintf(FileDesc,"W %d",Width*A/B);V 		    Pair = Path; 		    while(Pair != NULL){8 			fprintf(FileDesc," %d %d",Pair->pX*A/B,Pair->pY*A/B); 			Pair = Pair->pSucc; 			} 		    }D 		fprintf(FileDesc,";\n"); 		}; 	    elif(Type == CDPOLYGON){ " 		CDPolygon(Pointer,&Layer,&Path); 		fprintf(FileDesc,"P"); 		Pair = Path; 		while(Pair != NULL){; 		    fprintf(FileDesc," %d %d",Pair->pX*A/B,Pair->pY*A/B);c 		    Pair = Pair->pSucc;l 		    }% 		fprintf(FileDesc,";\n"); 		}  	    elif(Type == CDLABEL){ ' 		CDLabel(Pointer,&Layer,&Label,&X,&Y); : 		if(Program == 'k' Or Program == 'e'){	/* KIC/CD label */; 		    fprintf(FileDesc,"94 %s %d %d;\n",Label,X*A/B,Y*A/B);o 		    }e) 		elif(Program == 'b'){			/* NCA label */r+ 		    fprintf(FileDesc,"94 %s %d %d %d;\n",( 			Label,X*A/B,Y*A/B,Layer); 		    }=, 		elif(Program == 'm'){			/* mextra label */8 		    fprintf(FileDesc,"94 %s %d %d",Label,X*A/B,Y*A/B);, 		    if(CDLayer[Layer].lTechnology != ' '){6 			fprintf(FileDesc," %c",CDLayer[Layer].lTechnology);	 			i = 0;A2 			while(i < 3 And CDLayer[Layer].lMask[i] > 040){: 	    		    fprintf(FileDesc,"%c",CDLayer[Layer].lMask[i]); 			    i++;, 			    } 			} 		    fprintf(FileDesc,";\n"); 		    }a 		}= 	    } 	}     GenEndSymbol(FileDesc);-     return(True);i     }a     int{ CDTo(CIFFile,Root,A,B,Program)     char *CIFFile,*Root;     char Program;      int A,B;     /*1      * Translate from CIF file into symbol files. I      * Each time we see a symbol definition, we write it in its own file. L      * The problem is that commands may be in the file that aren't part of aH      * symbol definition.  The solution is to have a file named Root for      * the commands.        */t     {C
     int Int1;,     int StatusInt;     char *StatusString; #     CDDesc.dControl = DCONTROLCDTO;r          /*=      * On the first pass, we just fill the symbol name table.e      */e     CDDesc.dFirstPass = True;      CDDesc.dNumSymbolTable = 0;t+     if((CDDesc.dProgram = Program) != 'n'){e+ 	for(Int1 = 0;Int1 < CDNUMREMEMBER;++Int1){D( 	    CDDesc.dSymTabNames[Int1][0] = EOS;' 	    CDDesc.dSymTabNumbers[Int1] = -1; ( 	    }( 	PCIF(CIFFile,&StatusString,&StatusInt); 	if(StatusInt == PFAILED){! 	    CDStatusInt = CDPARSEFAILED;,) 	    strcpy(CDStatusString,StatusString);l 	    return(False);h 	    } 	}     /*=      * On the second pass, we do the sequential translation. W      */h     CDDesc.dFirstPass = False;     CDDesc.dPrptyList = NULL;      CDDesc.dA = A;     CDDesc.dB = B;"     CDDesc.dDSA = CDDesc.dDSB = 1;     CDDesc.dRoot = True;J     if((CDDesc.dRootFileDesc = POpen(Root,"w",(char *)NULL,(char **)NULL))
 	== NULL){1 	sprintf(CDStatusString,"Can't open file Root.");  	CDStatusInt = CDPARSEFAILED;; 	return(False);( 	}9     fprintf(CDDesc.dRootFileDesc,"(Symbol %s.);\n",Root);iD     fprintf(CDDesc.dRootFileDesc,"(Microns/lambda = %d/%d);\n",A,B);1     fprintf(CDDesc.dRootFileDesc,"9 %s;\n",Root); /     GenBeginSymbol(CDDesc.dRootFileDesc,0,1,1);i+     PCIF(CIFFile,&StatusString,&StatusInt);E     if(StatusInt == PFAILED){& 	CDStatusInt = CDPARSEFAILED; % 	strcpy(CDStatusString,StatusString);  	return(False);( 	}     else 	CDStatusInt = CDSUCCEEDED;)'     GenEndSymbol(CDDesc.dRootFileDesc);*!     GenEnd(CDDesc.dRootFileDesc);a!     fclose(CDDesc.dRootFileDesc);%&     CDDesc.dControl = DCONTROLVANILLA;     return(True);*     }      int 1 CDFrom(Root,CIFFile,A,B,Layers,NumLayers,Program)m      char *Root,*CIFFile,Program;     int Layers[],NumLayers;f     int A,B;     /*D      * Translate symbol hierarchy rooted with symbol named Root into      * CIF file named CIFFile. >      */      {N     struct s *SymbolDesc;i     FILE *FileDesc;F     int SymbolNum = 0;
     int Info;e     int Layer;  ,     for(Layer = 0;Layer < NumLayers;++Layer) 	if(Layers[Layer])# 	    CDLayer[Layer].lCDFrom = True;e 	elseC$ 	    CDLayer[Layer].lCDFrom = False;L     if((FileDesc = POpen(CIFFile,"w",(char *)NULL,(char **)NULL)) == NULL){	 	CDStatusInt = CDPARSEFAILED;*0 	sprintf(CDStatusString,"Can't open CIF file."); 	return(False);t 	})     if(Not CDOpen(Root,&SymbolDesc,'r')){= 	CDStatusInt = CDPARSEFAILED;= 	return(False);{ 	}#     if(CDStatusInt == CDNEWSYMBOL){p4 	sprintf(CDStatusString,"Can't open file %s.",Root); 	return(False);) 	}L     fprintf(FileDesc,"(CIF file of symbol hierarchy rooted at %s);\n",Root);@     if(Not CDGenCIF(FileDesc,SymbolDesc,&SymbolNum,A,B,Program)) 	return(False);r.     CDInfo(SymbolDesc,(struct o *)NULL,&Info);(     fprintf(FileDesc,"C %d;\nE\n",Info);     fclose(FileDesc);=     /*I      * Really should set all of the info fields in all symbol descs to 0.	      * CDUnmark(SymbolDesc);      */D     return(True);e     }	     int   CDParseCIF(Root,CIFFile,Program)      char *Root,*CIFFile,Program;     /*D      * Construct CD database from a CIF file rather than a hierarchy      * of cell files.x      */      {      struct m *MasterListDesc1;     struct m *MasterListDesc2;      struct s *MasterSymbolDesc1;      struct s *MasterSymbolDesc2;     char *StatusString;	     int StatusInt;
     int Int1;r       CDDesc.dProgram = Program;     CDDesc.dA = CDDesc.dB = 1;"     CDDesc.dDSA = CDDesc.dDSB = 1;     CDDesc.dRoot = True;#     CDDesc.dControl = DCONTROLPCIF; .     CDDesc.dSymbolDesc = CDDesc.dRootCellDesc;3     if(Not CDOpen(Root,&CDDesc.dRootCellDesc,'n')){D 	CDStatusInt = CDMALLOCFAILED;         return(False);	         }(#     CDDesc.dControl = DCONTROLPCIF;        /*=      * On the first pass, we just fill the symbol name table.t      */&     CDDesc.dFirstPass = True;=     CDDesc.dNumSymbolTable = 0;R.     for(Int1 = 0;Int1 < CDNUMREMEMBER;++Int1){$ 	CDDesc.dSymTabNames[Int1][0] = EOS;" 	CDDesc.dSymTabNumbers[Int1] = -1; 	}+     PCIF(CIFFile,&StatusString,&StatusInt);s     if(StatusInt == PFAILED){C 	CDStatusInt = CDPARSEFAILED;e,         strcpy(CDStatusString,StatusString);         return(False); 	}          /*=      * On the second pass, we do the sequential translation. a      */n     CDDesc.dFirstPass = False;+     PCIF(CIFFile,&StatusString,&StatusInt);h     if(StatusInt == PFAILED){  	CDStatusInt = CDPARSEFAILED;F,         strcpy(CDStatusString,StatusString);         return(False); 	}8     MasterListDesc1 = CDDesc.dRootCellDesc->sMasterList;#     while(MasterListDesc1 != NULL){;7 	CDOpen(MasterListDesc1->mName,&MasterSymbolDesc1,'r'); @ 	if(CDStatusInt == CDNEWSYMBOL Or CDStatusInt == CDPARSEFAILED){$ 	    if(CDStatusInt == CDNEWSYMBOL){ 		CDStatusInt = CDPARSEFAILED;B 		sprintf(CDStatusString,"Master %s doesn't seem to be around.\n", 		    MasterListDesc1->mName); 		}  	    return(False);y 	    }2 	MasterListDesc2 = MasterSymbolDesc1->sMasterList;'         while(MasterListDesc2 != NULL){M; 	    CDOpen(MasterListDesc2->mName,&MasterSymbolDesc2,'r'); D 	    if(CDStatusInt == CDNEWSYMBOL Or CDStatusInt == CDPARSEFAILED){! 		if(CDStatusInt == CDNEWSYMBOL){f" 		    CDStatusInt = CDPARSEFAILED; 		    sprintf(CDStatusString,(, 			"Master %s doesn't seem to be around.\n", 			MasterListDesc2->mName);e 		    }\ 		return(False); 		}e* 	    if(Not CDReflect(MasterSymbolDesc2)){ 		CDStatusInt = CDPARSEFAILED;" 		return(CDError(CDMALLOCFAILED)); 		}b. 	    MasterListDesc2 = MasterListDesc2->mSucc; 	    }& 	if(Not CDReflect(MasterSymbolDesc1)){! 	    CDStatusInt = CDPARSEFAILED;*% 	    return(CDError(CDMALLOCFAILED));I 	    }* 	MasterListDesc1 = MasterListDesc1->mSucc; 	},     if(Not CDReflect(CDDesc.dRootCellDesc)){ 	CDStatusInt = CDPARSEFAILED;c! 	return(CDError(CDMALLOCFAILED));; 	}     return(True);y     }c     inth CDUnmark(SymbolDesc)     struct s *SymbolDesc;n     {      struct g *GenDesc;     struct o *Pointer;     char *SymbolName;e     int NumX,DX,NumY,DY;
     int Info;o     int Layer;     struct s *MasterDesc;C  N     if(Not CDInitGen(SymbolDesc,0,(int)-INFINITY,(int)-INFINITY,(int)INFINITY,: 	(int)INFINITY,&GenDesc)) return(CDError(CDMALLOCFAILED)); #ifdef DEBUG_CDUNMARKn fprintf(stderr,"\n\n");aL fprintf(stderr,"1CDUnmark: Inititialezed generator on instance layer.\n\n"); #endif
     loop {$ 	CDGen(SymbolDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;e   #ifdef DEBUG_CDUNMARK N fprintf(stderr,"2CDUnmark: CDGen found instance: Pointer = 0x%x\n\n",Pointer); #endif  1 	CDCall(Pointer,&SymbolName,&NumX,&DX,&NumY,&DY);t   #ifdef DEBUG_CDUNMARKt? fprintf(stderr,"3CDUnmark: instance name = %s\n\n",SymbolName);* #endif   	/*a9 	 * Cell has already been mapped into memory.  Therefore,e9 	 * we can assume that CDOpen does not fail in the parse.  	 */+ 	if(Not CDOpen(SymbolName,&MasterDesc,'r'))t% 	    return(CDError(CDMALLOCFAILED));    #ifdef DEBUG_CDUNMARKtN fprintf(stderr,"4CDUnmark: CDOpen returned MasterDesc = 0x%x\n\n",MasterDesc); #endif  + 	CDInfo(MasterDesc,(struct o *)NULL,&Info);  	if(Info != 0){C 	    /* Unmark master */. 	    CDSetInfo(MasterDesc,(struct o *)NULL,0);! 	    if(Not CDUnmark(MasterDesc))O 		return(False); 	    } 	}2     for(Layer = 1; Layer <= CDNUMLAYERS; ++Layer){A 	if(Not CDInitGen(SymbolDesc,Layer,(int)-INFINITY,(int)-INFINITY, + 	    (int)INFINITY,(int)INFINITY,&GenDesc))d% 	    return(CDError(CDMALLOCFAILED));    #ifdef DEBUG_CDUNMARK=L fprintf(stderr,"5CDUnmark: Inititialezed generator on layer %d.\n\n",Layer); #endif   	loop{( 	    CDGen(SymbolDesc,GenDesc,&Pointer); 	    if(Pointer == NULL) 	        break;s   #ifdef DEBUG_CDUNMARKtN fprintf(stderr,"6CDUnmark: CDGen found instance: Pointer = 0x%x\n\n",Pointer); #endif  / 	    CDInfo(SymbolDesc,(struct o *)NULL,&Info);  	    if(Info != 0){  	        /* Unmark geometry */) 	        CDSetInfo(SymbolDesc,Pointer,0);s 		}  	    } 	}     return(True);T     }0       oI /*======================================================================*O  *									*&  *  EEEEE RRRR  RRRR   OOO  RRRR					*'  *  E     R   R R   R O   O R   R					*f&  *  EEE   RRRR  RRRR  O   O RRRR					*&  *  E     R R   R R   O   O R R 					*'  *  EEEEE R  R  R  R   OOO  R  R 					*t  *									*5  *  RRRR   OOO  U   U TTTTT III N   N EEEEE  SSSS			*r5  *  R   R O   O U   U   T    I  NN  N E     S    			*y4  *  RRRR  O   O U   U   T    I  N N N EEE    SSS			*5  *  R R   O   O U   U   T    I  N  NN E         S			*u4  *  R  R   OOO   UUU    T   III N   N EEEEE SSSS			*  *									*  *									*  *									*  *	CDError(ID)							*  *									*J  *======================================================================*/   intI CDError(ID))     int ID;r     {L     CDStatusInt = ID;B     switch(ID){i   	case CDMALLOCFAILED:i1 	    sprintf(CDStatusString,"CD Out of memory.");n 	    return(False);    	case CDBADBOX: = 	    sprintf(CDStatusString,"Can't allow a zero width box.");  	    /* not a fatal error */ 	    return(True);   	case CDXFORMSTACKFULL:s8 	    sprintf(CDStatusString,"Transform stack is full."); 	    return(False);m   	case CDBADPATH:6 	    sprintf(CDStatusString,"Can't set search path."); 	    return(False);S  	 	default: . 	    sprintf(CDStatusString,"Unknown Error."); 	    return(False);o   	}     }c  