 /*  * cd.hk  *=  * Copyright -C- 1981 Kenneth H. Keller, Giles C. Billingsleyd   * sccsid "@(#)cd.h	1.1  9/5/83"  *H  *     CD is a CIF database package that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atG  * the University of California, Berkeley, California.  The programs in=;  * CD are available free of charge to any interested party.	D  * The sale, resale, or use of these programs for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,,  * is forbidden.  */r  l  o /*  * CD package data structures.  *    * Giles Billingsley
  * Ken Keller&  */s   #include <stdio.h> #include <math.h>C #include "nmalloc.h" #include "macros.h"y #include "xforms.h"s  
 #ifdef vms #define	void	int #endif  # #define	CDDelete	CDDeleteObjectDescc  : #define FILENAMESIZE	16		/* maximum size of a file name */   /*B  * Values routines return in StatusInt of CDOpen, CDBeginMakeCall,  * CDTo, CDFrom, or CDParseCIF.A  */{3 #define	CDPARSEFAILED		1	/* (FATAL) parse failed */ > #define	CDOLDSYMBOL		2	/* symbol already exists in database */> #define	CDNEWSYMBOL		3	/* (empty) symbol not in search path */? #define	CDSUCCEEDED		4	/* new symbol(s) found in search path */M   /*   * Valid arguments to CDError().  */N6 #define	CDMALLOCFAILED		11	/* (FATAL) out of memory */3 #define CDBADBOX		12	/* zero width or length box */D: #define	CDXFORMSTACKFULL	13	/* transform stack overflow */= #define CDBADPATH		14	/* bad directory name in search path */s   /*  * Types of geometries  */m #define CDSYMBOLCALL		'c'e #define CDPOLYGON		'p' #define CDROUNDFLASH		'r'	 #define CDLABEL			'l'c #define CDWIRE			'w' #define CDBOX			'b'A   /*  * Types of transformationsO  */E9 #define	CDMIRRORX		'x'	/* mirror in the direction of x */ 9 #define	CDMIRRORY		'y'	/* mirror in the direction of y */u0 #define	CDROTATE		'r'	/* rotate by vector X,Y *// #define	CDTRANSLATE		't'	/* translate to X,Y */    /*(  * CD Control flags; See struct d below.  */R #define DCONTROLCDOPEN		'o'  #define DCONTROLPCIF		'p'  #define DCONTROLCDTO		't'  #define DCONTROLVANILLA		'v'   /*:  * Coordinate system with 1 micron features and 1 cm dice.4  * Remember that there are 100 CIF units per micron.  */  #define INFINITY		100000000	   /*F  * These are the numbers that CD uses to determine which bin an objectF  * resides in.  They should reflect the average size of a layout beingB  * edited by KIC.  KIC will not fail if the numbers are too small.A  * Anything outside of this window is placed in the residual bin.SE  * If these numbers become too large, CDIntersect() must use floating   * point calculations.  */C #define CDBINMAXX		500000. #define CDBINMAXY		500000r #define CDBINMINX		(-CDBINMAXX)s #define CDBINMINY		(-CDBINMAXY)f   /*  * PLEASE NOTE  * ^^^^^^^^^^^C  * Because a char is used as the layer fields, the absolute maximumu?  * number of layers is 127.  The may be increase by recompilingu+  * KIC and CD with the Layer typed as ints.r  */; #define CDNUMBINS		10  #define CDNUMLAYERS		35t   /*G  * Number of symbols stored in the symbol table for any given CIF file.s  */) #define CDNUMREMEMBER		1000L   /*(  * Storage for diagnostics of CDError().  */r extern char *CDStatusString; extern int  CDStatusInt;   /*  * Master list desc.  */r
 struct m {     int mReferenceCount;#     int mLeft,mBottom,mRight,mTop;       char *mName;     struct m *mPred,*mSucc;      };     /*  * Propety List desc.e  */F struct prpty {     int prpty_Value;     char *prpty_String;L     struct prpty *prpty_Succ;l     };     /*  * Symbol desc.N  */Y
 struct s {#     int sLeft,sBottom,sRight,sTop;       int sBBValid;(     int sA,sB;     char *sName;     short sInfo;     /*;      * One bin foe each layer.  Layer 0 is for call descs. ;@      * Each bin points to a double linked list of object descs. H      * Bin[.][0][0] are the RESIDUAL bins--Bin[.][0][1] and Bin[.][1][0]B      * are unused TUNABLE.  NumBins should be as big as it can be.,      * For 20 layers and 100 bins per layer,.      * the data structure becomes 2000 words.       */e$     struct o ***sBin[CDNUMLAYERS+1];     struct m *sMasterList;     struct prpty *sPrptyList;e     };     /*  * Object desc.r  */B
 struct o {"     int oLeft,oBottom,oRight,oTop;     char oType;o     char oLayer;     short oInfo;     struct o *oRep;o     struct o *oPred,*oSucc;A     struct prpty *oPrptyList;      };     /*  * Polygon desc.  */t struct po {      struct p *poPath;      };     /*  * Round flash desc.  */R
 struct r {     int rWidth,rX,rY;F     };     /*
  * Wire desc.t  */d
 struct w {     int wWidth;      struct p *wPath;     };       /*
  * Call desc.m  */.
 struct c {
     int cNum;e/     /* Pointer to transformation descriptor. */Y     struct t *cT; ,     /* Pointer to master list descriptor. */     struct m *cMaster;     /* Array parameters. */      int cNumX,cNumY,cDX,cDY;     };     /*  * Transform desc.  * If MX, tType == CDMIRRORX.r  * If MY, tType == CDMIRRORX.d?  * If R, tType == CDROTATE, tX == XDirection, tY == YDirection.b1  * If T, tType == CDTRANSLATE, tX == TX, tY = TY;n  */*
 struct t {     char tType;d     int tX,tY;     struct t *tSucc;     };     /*  * Label desc.  */C struct la {d     char *laLabel;     int laX,laY;     };     /*  * Linked path structure  */a
 struct p {     int pX,pY;     struct p *pSucc;     };     /*  * Generator desc.!  * Search Bin[Layer][0][0] first.*/  * Then Bin[Layer][BeginX..EndX][BeginY..EndY]. (  * Bin[Layer][X][Y] is the current bin. :  * Pointer points to the current desc in the current bin.   */ 
 struct g {#     int  gLeft,gBottom,gRight,gTop;	+     int  gBeginX,gX,gEndX,gBeginY,gY,gEndY;D     char gLayer;     struct o *gPointer;;     };     /*   * CD's current parameter struct  */ 
 struct d {     /*-      * DCONTROLCDOPEN denotes CD is in CDOpenRK      * DCONTROLPCIF denotes CD is in CDOpen and parsing CIF rather than kic )      * DCONTROLCDTO denotes CD is in CDTo{9      * DCONTROLVANILLA denotes CD is in none of the abovet      */r     char dControl;  ?     /* Current parameters for symbol being parsed in CDOpen. */R     int  dNumX,dDX,dNumY,dDY;(  ,     /* Scale factors for CDTo and CDFrom. */     int dA,dB;       /* Symbol scale factors. */      int dDSA,dDSB;       struct o *dPointer;t     struct s *dSymbolDesc;     struct s *dRootCellDesc;  6     /* UNIX file names are limited to 14 characters */#     char dSymbolName[FILENAMESIZE];h     FILE *dSymbolFileDesc;       /*"      * Fields used in CDTo follow.      */t  &     /* True if parsing root symbol. */     int dRoot;       /* Root's file desc. */      FILE *dRootFileDesc;  7     /* Current property list for symbol being parsed */e     struct prpty *dPrptyList;        /*'      * dProgram == 'h' if IGS gened it.h*      *          == 'i' if Icarus gened it.'      *          == 's' if Sif gened it.w,      *          == 'n' if none of the above.      */t     char dProgram;       /*      * Symbol name table.vI      * 16 comes from the fact that a UNIX file name is only 14 charactersoI      * long and each symbol name is a UNIX file name.  VMS file names arel      * smaller.c      */i4     char dSymTabNames[CDNUMREMEMBER][FILENAMESIZE]; (     int  dSymTabNumbers[CDNUMREMEMBER];      int  dNumSymbolTable;        /*D      * Because CIF files may have FORWARD references, CDTo must pass       * over the CIF file TWICE. A      * On the first pass, it just fills up the symbol name table.,A      * On the second pass, it does the translation to KIC format./      */      int dFirstPass;f       /*      * True if debugging.e      */d     int dDebug;n     int dNumSymbolsAllocated;b     }i CDDesc;p     /*  * CD layer table	  */  struct l     {n     char lTechnology;      char lMask[3];+     /*True if CDFrom should output layer.*/D     char lCDFrom;      }r CDLayer[CDNUMLAYERS+1];2     /*5  * Hash table of symbol descs keyed on symbol's name.*  */s
 struct bu      {      struct s *buSymbolDesc;b     struct bu *buPred;     struct bu *buSucc;     };( struct bu *CDSymbolTable[CDNUMLAYERS+1];   /*"  * Ousterhout's file name package.  */H FILE *POpen(); char *PGetPath();f   /*  * CD routines  */D extern void CDInit();p extern void CDSetLayer();E extern void CDDebug(); extern void CDSymbol();o extern void CDCheckPath();! extern void CDDeleteObjectDesc();f extern void CDCall();  extern void CDBox(); extern void CDLabel(); extern void CDPolygon(); extern void CDWire();t extern void CDRoundFlash();  extern void CDInfo();* extern void CDSetInfo(); extern void CDProperty();* extern void CDType();  extern void CDIntersect(); extern void CDGen(); extern void CDInitTGen();  extern void CDTGen();{ extern int CDBB(); extern int CDOpen(); extern int CDPath(); extern int CDClose();  extern int CDReflect();l extern int CDPatchInstances(); extern int CDAddProperty();m extern int CDRemoveProperty(); extern int CDMakeBox();  extern int CDMakeLabel();S extern int CDMakePolygon();D extern int CDMakeWire(); extern int CDMakeRoundFlash(); extern int CDBeginMakeCall();o extern int CDT();n extern int CDEndMakeCall();e  extern int CDInsertObjectDesc(); extern int CDInitGen();e extern int CDUpdate(); extern int CDGenCIF(); extern int CDTo(); extern int CDFrom(); extern int CDParseCIF(); extern int CDUnmark(); extern int CDError();.