 /*	  * copy.c.  **  * Copyright -C- 1981 Giles C. Billingsley"  * sccsid "@(#)copy.c	1.1  9/5/83"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programg;  * KIC is available free of charge to any interested party.rB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,n  * is forbidden.  */      i /*  * Copy selection operator.w  */    #include "kic.h" #include "select.h".   /* Library routines */ char *strcpy();n   Copy(LookedAhead).     int *LookedAhead;t     {a     struct ks *SelectQDesc;t     struct p *Path;      struct o *Pointer;     struct t *TGen;      char *SymbolName;e     char *Label;     char *TypeIn;e(     int ReferencePointX, CopiedToPointX;(     int ReferencePointY, CopiedToPointY;     int Width, Length;
     int Info;(
     int Undo;T     int X,Y;     int Layer;     int NumX,DX,NumY,DY;     int FirstTime = True;      int l,b,r,t;     int lc,bc,rc,tc;     int TF[9];     struct ka BB,CopyBB;     char Type;       MenuSelect(MenuCOPY);h     if(SelectQHead == NULL){7 	ShowPrompt("You haven't selected anything to move."); t 	MenuDeselect(MenuCOPY); 	return; 	}     *LookedAhead = False;t+     Parameters.kpPointCoarseWindow = False;Y.     while(Not Parameters.kpPointCoarseWindow){. 	ShowPrompt("Point to the reference point."); 	 	Point();" 	if(Not GetCurrentTransform()){ ( 	    if(Parameters.kpCommand[0] != EOS){ 		MenuDeselect(MenuCOPY);I 		*LookedAhead = True;	 		return;p 		} . 	    elif(Not Parameters.kpPointCoarseWindow){ 		NotPointingAtLayout(); 		}e 	    } 	}!     ReferencePointX = Cursor.kcX;w!     ReferencePointY = Cursor.kcY;l
     loop { 	Undo = False; 	if(*LookedAhead == False), 	    Parameters.kpPointCoarseWindow = False;C 	while(*LookedAhead == True Or Not Parameters.kpPointCoarseWindow){  	    if(Not *LookedAhead){B 		ShowPrompt("Point to where the selected items will be copied.");
 		Point(); 		} 	 	    elsem 		*LookedAhead = False;r# 	    if(Not GetCurrentTransform()){eA 		if(Not FirstTime And strcmp(Parameters.kpCommand,MenuUNDO)==0){k 		    MenuSelect(MenuUNDO);* 		    Undo = True; 		    MenuDeselect(MenuUNDO);e 		    break; 		    }N' 		elif(Parameters.kpCommand[0] != EOS){* 		    MenuDeselect(MenuCOPY);D 		    *LookedAhead = True;
 		    return;t 		    }o+ 		elif(Not Parameters.kpPointCoarseWindow){( 		    NotPointingAtLayout(); 		    }i 		}k 	    } 	FirstTime = False;i 	if(Not Undo){! 	    CopiedToPointX = Cursor.kcX;w! 	    CopiedToPointY = Cursor.kcY;/7 	    if(Not Parameters.kpMX And Not Parameters.kpMY Andt% 		Parameters.kpRotationAngle == 0 And ' 		CopiedToPointX == ReferencePointX Andi& 		CopiedToPointY == ReferencePointY ){G 		ShowPrompt("This will copy objects over themselves.  Continue(No)?");i 		FBKeyboard(&TypeIn);, 		if(TypeIn[0] != 'Y' And TypeIn[0] != 'y'){ 		    FirstTime = True;X 		    continue;  		    }- 		}o 	    }1 	CopyBB.kaLeft = CopyBB.kaRight = CopiedToPointX; 1 	CopyBB.kaTop = CopyBB.kaBottom = CopiedToPointY;)
 	BB = CopyBB; 	 	TPush();(
 	TIdentity();)/ 	TTranslate(-ReferencePointX,-ReferencePointY);t 	if(Parameters.kpMX) 	    TMX();i 	if(Parameters.kpMY) 	    TMY();0% 	if(Parameters.kpRotationAngle != 0){S) 	    if(Parameters.kpRotationAngle == 90)S 		TRotate(0,1);;, 	    elif(Parameters.kpRotationAngle == 180) 		TRotate(-1,0);, 	    elif(Parameters.kpRotationAngle == 270) 		TRotate(0,-1); 	    }+ 	TTranslate(CopiedToPointX,CopiedToPointY);  	SelectQDesc = SelectQHead;L 	while(SelectQDesc != NULL){@ 	    CDInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,&Info); 	    if(Info == 3) 		continue;  	    else {S' 		CDType(SelectQDesc->ksPointer,&Type);l 		if(Type == CDLABEL){: 		    CDLabel(SelectQDesc->ksPointer,&Layer,&Label,&X,&Y); 		    TPoint(&X,&Y);; 		    if(Not CDMakeLabel(Parameters.kpCellDesc,Layer,Label, ! 			X,Y,&Pointer)) MallocFailed();t; 		    /* CDBB will always return True if Pointer != NULL */eB 		    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft,' 			&BB.kaBottom,&BB.kaRight,&BB.kaTop);e1 		    CDSetInfo(Parameters.kpCellDesc,Pointer,3);h 		    SelectQInsert(Pointer);  		    }h 		elif(Type == CDBOX){@ 		    CDBox(SelectQDesc->ksPointer,&Layer,&Length,&Width,&X,&Y); 		    TPoint(&X,&Y);, 		    if(Parameters.kpRotationAngle == 90 Or& 			Parameters.kpRotationAngle == 270){ 			SwapInts(Width,Length); 			}@ 		    if(Not CDMakeBox(Parameters.kpCellDesc,Layer,Length,Width,! 			X,Y,&Pointer)) MallocFailed();;; 		    /* CDBB will always return True if Pointer != NULL */CB 		    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft,' 			&BB.kaBottom,&BB.kaRight,&BB.kaTop);n1 		    CDSetInfo(Parameters.kpCellDesc,Pointer,3);n 		    SelectQInsert(Pointer);N 		    }P 		elif(Type == CDSYMBOLCALL){*: 		    CDCall(SelectQDesc->ksPointer,&SymbolName,&NumX,&DX, 			&NumY,&DY); 		    /*; 		     * To handle transforms of instance arrays correctly,t< 		     * we need the BB of the original array.  We apply the? 		     * transform to this BB, and that tells us what the finalP3 		     * position of the transformed array MUST be.  		     *? 		     * KIC does not handle instance arrays well (the NumX ando; 		     * NumY values are always positive).  If the array isP< 		     * rotated, the NumX and NumY values could effectively@ 		     * become negative.  We must deal with this by translating@ 		     * the array such that the NumX and NumY will be positive.	 		     * -@ 		     * The algorithm is to define the transform without regard> 		     * to the positioning error.  We create a dummy cell and> 		     * compute it's bounding box.  We know that the cells in> 		     * this dummy array are rotated and mirrored accurately,: 		     * but the array is offset because of the NumX, NumY? 		     * phenomenon described above.  We delete the dummy cell,): 		     * compare its BB with the BB that we computed above9 		     * (the one which we know is correct BB), and add atA 		     * translation to the current transform that would make theS= 		     * two BB's identical.  The translation is saved in theC= 		     * array 'SaveArrayData' so that it does not have to be 8 		     * recomputed if the user decides to do an 'UNDO'.	 		     */o/ 		    CDStatusInt = CDBB(Parameters.kpCellDesc,a' 			SelectQDesc->ksPointer,&l,&b,&r,&t);& 			TPoint(&l,&b);t 			TPoint(&r,&t);N, 		    if(Parameters.kpRotationAngle == 90 Or& 			Parameters.kpRotationAngle == 270){ 			SwapInts(NumX,NumY);y 			SwapInts(DX,DY);t 			}/ 		    /* we can only expect a CDMALLOCFAILED */e> 		    if(Not CDBeginMakeCall(Parameters.kpCellDesc,SymbolName, 			NumX,DX,NumY,DY,&Pointer))s4 			if(CDStatusInt == CDMALLOCFAILED) MallocFailed(); 		    /*8 		     * The symbol transform must be handled separately	 		     */, 		    TPush(); 		    TIdentity();1 		    /* only possible error is CDMALLOCFAILED */c> 		    if(Not CDBeginMakeCall(Parameters.kpCellDesc,SymbolName,$ 		        NumX,DX,NumY,DY,&Pointer))+ 		        if(CDStatusInt == CDMALLOCFAILED)p 			    MallocFailed();/ 		    CDInitTGen(SelectQDesc->ksPointer,&TGen);u 		    loop {< 		        /* first determine transform of the placed cell */$ 		        CDTGen(&TGen,&Type,&X,&Y); 		        if(TGen == NULL)
 			    break; $ 		        elif(Type == CDTRANSLATE){ 			    TTranslate(X,Y);  			    }! 		        elif(Type == CDROTATE){C 			    TRotate(X,Y); 			    }" 		        elif(Type == CDMIRRORY){
 			    TMY();  			    }" 		        elif(Type == CDMIRRORX){
 			    TMX();  			    } 		        } > 		    /* now add the previous transform to that of the move */4 		    TTranslate(-ReferencePointX,-ReferencePointY); 		    if(Parameters.kpMX){	 			TMX();  		        }e 		    if(Parameters.kpMY){	 			TMY();s 		        }i* 		    if(Parameters.kpRotationAngle != 0){) 			if(Parameters.kpRotationAngle == 180){  			    TRotate(-1,0);r 			    }* 			elif(Parameters.kpRotationAngle == 90){ 			    TRotate(0,1); 			    }+ 			elif(Parameters.kpRotationAngle == 270){( 			    TRotate(0,-1);( 			    } 		        }s0 		    TTranslate(CopiedToPointX,CopiedToPointY); 		    TCurrent(TF);u( 		    AddResultingTransform(Pointer,TF);: 		    if(Not CDEndMakeCall(Parameters.kpCellDesc,Pointer)) 		        MallocFailed();i4 		    /* get BB of dummy cell, and then delete it */7 		    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,; 			&lc,&bc,&rc,&tc);. 		    CDDelete(Parameters.kpCellDesc,Pointer);1 		    /* only possible error is CDMALLOCFAILED */ > 		    if(Not CDBeginMakeCall(Parameters.kpCellDesc,SymbolName,$ 		        NumX,DX,NumY,DY,&Pointer))+ 		        if(CDStatusInt == CDMALLOCFAILED)t 			    MallocFailed(); 		    l = min(l,r);m 		    b = min(t,b);t 		    lc = min(lc,rc); 		    bc = min(tc,bc); 		    TTranslate(l-lc,b-bc); 		    TCurrent(TF);n( 		    AddResultingTransform(Pointer,TF);: 		    if(Not CDEndMakeCall(Parameters.kpCellDesc,Pointer)) 			MallocFailed();; 		    /* CDBB will always return True if Pointer != NULL */.B 		    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft,' 			&BB.kaBottom,&BB.kaRight,&BB.kaTop); 1 		    CDSetInfo(Parameters.kpCellDesc,Pointer,3);r 		    SelectQInsert(Pointer); 
 		    TPop();, 		    }e 		elif(Type == CDWIRE){=9 		    CDWire(SelectQDesc->ksPointer,&Layer,&Width,&Path);m 		    CopyPathWithXForm(&Path);a? 		    if(Not CDMakeWire(Parameters.kpCellDesc,Layer,Width,Path,o 			&Pointer)) MallocFailed();A; 		    /* CDBB will always return True if Pointer != NULL */SB 		    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft,' 			&BB.kaBottom,&BB.kaRight,&BB.kaTop);F1 		    CDSetInfo(Parameters.kpCellDesc,Pointer,3);T 		    SelectQInsert(Pointer);  		    }d 		elif(Type == CDPOLYGON){5 		    CDPolygon(SelectQDesc->ksPointer,&Layer,&Path);  		    CopyPathWithXForm(&Path);e< 		    if(Not CDMakePolygon(Parameters.kpCellDesc,Layer,Path, 			&Pointer)) MallocFailed();f; 		    /* CDBB will always return True if Pointer != NULL */ B 		    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft,' 			&BB.kaBottom,&BB.kaRight,&BB.kaTop); 1 		    CDSetInfo(Parameters.kpCellDesc,Pointer,3);r 		    SelectQInsert(Pointer);  		    }a/ 		CopyBB.kaLeft = min(CopyBB.kaLeft,BB.kaLeft); 5 		CopyBB.kaBottom = min(CopyBB.kaBottom,BB.kaBottom);f2 		CopyBB.kaRight = max(CopyBB.kaRight,BB.kaRight);, 		CopyBB.kaTop = max(CopyBB.kaTop,BB.kaTop); 		}e' 	    SelectQDesc = SelectQDesc->ksSucc;a 	    } 	TPop(); 	EraseBox(CopyBB,CopyBB);t) 	Redisplay(Parameters.kpCellDesc,CopyBB);	 	/*} 	 * Look ahead for undo. 	 */
 	Undo = True;  	ShowPrompt("Point to copy.");  ( 	Parameters.kpPointCoarseWindow = False;+ 	while(Not Parameters.kpPointCoarseWindow){	
 	    Point();g# 	    if(Not GetCurrentTransform()){C1 		if(strcmp(Parameters.kpCommand,MenuUNDO) != 0){ # 		    Parameters.kpModified = True;  		    *LookedAhead = True; 		    Undo = False;t 		    }D 		else{t 		    MenuSelect(MenuUNDO);& 		    }c 		break; 		}D 	    } 	SelectQDesc = SelectQHead;; 	while(SelectQDesc != NULL){@ 	    CDInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,&Info); 	    if(Info == 3){  		if(Undo){X@ 		    CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,2);= 		    CDDelete(Parameters.kpCellDesc,SelectQDesc->ksPointer);( 		    }	 		else{m@ 		    CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,0); 		    }r( 		SelectQDelete(SelectQDesc->ksPointer); 		SelectQDesc = SelectQHead; 		}C
 	    else{$ 		SelectQDesc = SelectQDesc->ksSucc; 		}m 	    } 	SelectQComputeBB(); Y
 	if(Undo){ 	    EraseBox(CopyBB,CopyBB); - 	    Redisplay(Parameters.kpCellDesc,CopyBB);d 	    MenuDeselect(MenuUNDO); 	    } 	}     }      GetCurrentTransform(){1     if(strcmp(Parameters.kpCommand,MenuMX) == 0){  	if(Parameters.kpMX){y 	    Parameters.kpMX = False;K 	    MenuDeselect(MenuMX); 	    } 	else {N 	    Parameters.kpMX = True; 	    MenuSelect(MenuMX); 	    } 	}3     elif(strcmp(Parameters.kpCommand,MenuMY) == 0){e 	if(Parameters.kpMY){c 	    Parameters.kpMY = False;h 	    MenuDeselect(MenuMY); 	    } 	else {  	    Parameters.kpMY = True; 	    MenuSelect(MenuMY); 	    } 	}B     /* the handling of angles must be special cased to the menu */2     elif(strcmp(Parameters.kpCommand,Menu0) == 0){' 	if(Parameters.kpMenu == INSTANCEMENU){t$ 	    Parameters.kpRotationAngle = 0;% 	    MenuDeselect(SelectionMenu[37]);l% 	    strcpy(SelectionMenu[37],Menu0);c 	    } 	else{% 	    Parameters.kpRotationAngle = 90;b& 	    strcpy(SelectionMenu[37],Menu90); 	    } 	MenuSelect(SelectionMenu[37]);p 	}3     elif(strcmp(Parameters.kpCommand,Menu90) == 0){)' 	if(Parameters.kpMenu == INSTANCEMENU){ % 	    Parameters.kpRotationAngle = 90; % 	    MenuDeselect(SelectionMenu[37]);l& 	    strcpy(SelectionMenu[37],Menu90); 	    } 	else{& 	    Parameters.kpRotationAngle = 180;' 	    strcpy(SelectionMenu[37],Menu180);' 	    } 	MenuSelect(SelectionMenu[37]);D 	}4     elif(strcmp(Parameters.kpCommand,Menu180) == 0){' 	if(Parameters.kpMenu == INSTANCEMENU){F& 	    Parameters.kpRotationAngle = 180;% 	    MenuDeselect(SelectionMenu[37]);D' 	    strcpy(SelectionMenu[37],Menu180);i 	    } 	else{& 	    Parameters.kpRotationAngle = 270;' 	    strcpy(SelectionMenu[37],Menu270);, 	    } 	MenuSelect(SelectionMenu[37]);) 	}4     elif(strcmp(Parameters.kpCommand,Menu270) == 0){' 	if(Parameters.kpMenu == INSTANCEMENU){&& 	    Parameters.kpRotationAngle = 270;% 	    MenuDeselect(SelectionMenu[37]);e' 	    strcpy(SelectionMenu[37],Menu270);  	    } 	else{$ 	    Parameters.kpRotationAngle = 0;% 	    strcpy(SelectionMenu[37],Menu0);  	    } 	MenuSelect(SelectionMenu[37]);- 	}     else 	return(False);o     return(True);)     }      CopyPathWithXForm(Path)D     struct p **Path;     {;     struct p *OldPair,*NewPair;l     /*>      * Copy Path with transform and return pointer to new path      */C     OldPair = *Path;@     if((NewPair = (struct p *)malloc(sizeof(struct p))) == NULL) 	MallocFailed();     *Path = NewPair;     NewPair->pX = OldPair->pX; s     NewPair->pY = OldPair->pY; Q&     TPoint(&NewPair->pX,&NewPair->pY);     NewPair->pSucc = NULL;     OldPair = OldPair->pSucc;p     while(OldPair != NULL){uD 	if((NewPair->pSucc = (struct p *)malloc(sizeof(struct p))) == NULL) 	    MallocFailed(); 	NewPair = NewPair->pSucc; 	NewPair->pX = OldPair->pX;  	NewPair->pY = OldPair->pY;  	NewPair->pSucc = NULL; # 	TPoint(&NewPair->pX,&NewPair->pY);  	OldPair = OldPair->pSucc; 	}     }l