 /*  * dotkic.c*  **  * Copyright -C- 1981 Giles C. Billingsley$  * sccsid "@(#)dotkic.c	1.1  9/5/83"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program ;  * KIC is available free of charge to any interested party. B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */        /*  * Parser for .KIC files  *  * Giles Billingsley  * Ed Gouldu%  * National Semiconductor Corporation   * 28 April 82  *  */(     /*%  * definitions for parsing .KIC files   */n% #define curlayer    LayerTable[layer])     /*  * Here is the format.  * e  * Path? (~user/KIC)  * d  * LayerName? nd  * Color'sName? greenc  * RGB? 0 255 0e  * Filled? y  * (Invisible)
  * (Blink)  * MinDimensions? 2c  * Symbolic? n  * M  * ...  * () = Optional  */i   #include "kic.h"   /* Library routines */ #ifndef vms  char *sprintf(); #endif  	 DotKIC(){	     int layer = 0;     int i,j;     int rgb[3];      char c,*cp;e     char *GetKeyWord();s     char str1[512];l6     char inbuf[512];		/* 512 character input buffer */     FILE *dotkic;t       /*$      * Initialize for default values      */R#     Parameters.kpMenuTextColor = 2;	+     Parameters.kpMenuHighlightingColor = 4; %     Parameters.kpMenuSelectColor = 2;u%     Parameters.kpCoarseGridColor = 1;;#     Parameters.kpFineGridColor = 2;F"     Parameters.kpGridOnTop = True;1     Parameters.kpShowGridInLargeViewport = False;       Parameters.kpOutline = True;*     Parameters.kpDisplayAllLabels = False;+     Parameters.kpLabelAllInstances = False;p%     Parameters.kpBackgroundRed = 230;y'     Parameters.kpBackgroundGreen = 230;t&     Parameters.kpBackgroundBlue = 230;%     Parameters.kpHighlightingRed = 0;l'     Parameters.kpHighlightingGreen = 0;t&     Parameters.kpHighlightingBlue = 0;       /*#      * In lambda * RESOLUTION unitsL      */0#     Parameters.kpGrid = RESOLUTION;Q  "     LayerTable[0].klFilled = True;      LayerTable[0].klStyleID = 0;#     LayerTable[0].klVisible = True;s         /*(      * CDInit must be invoked only once,+      * else the layer table will be trashed       */ 
     CDInit();o     if(FB.fDisplay != NULL)o
 #ifdef vms& 	sprintf(str1, "%s.KIC", FB.fDisplay); #else-' 	sprintf(str1, ".KIC.%s", FB.fDisplay);  #endif     else
 #ifdef vms 	sprintf(str1, "LAYERS.KIC");N #else  	sprintf(str1, ".KIC");c #endif
 #ifdef vms+     if((dotkic = fopen(str1, "r")) == NULL) 0 	if((dotkic = fopen("LAYERS.KIC", "r")) == NULL)B 	    if((dotkic = POpen(DEFAULT_DOT_KIC, "r", NULL, NULL))==NULL){& 		printf("Can't access .KIC file.\n");
 		exit(1); 		}T #elseN+     if((dotkic = fopen(str1, "r")) == NULL)r* 	if((dotkic = fopen(".KIC", "r")) == NULL); 	    if((dotkic = POpen(DEFAULT_DOT_KIC, "r", (char *)NULL,r 		(char **)NULL))==NULL){D& 		printf("Can't access .KIC file.\n");
 		exit(1); 		}= #endif+     while((cp = GetKeyWord(dotkic,inbuf))){t 	if(strcmp(cp,"PATH") == 0){ 	    i = 0;  	    while(inbuf[i] != '(')m" 		if(inbuf[i++] == NULL) continue; 	    j = 0;e) 	    while((str1[j] = inbuf[++i]) != ')')r! 		if(str1[j++] == NULL) continue;s 	    str1[j] = NULL; 	    CDPath(str1); 	    }A 	else if(strcmp(cp,"LAYERNAME") == 0 || strcmp(cp,"LAYER") == 0){  	    if(++layer > CDNUMLAYERS){7: 		printf("There are too many layers in your .KIC file\n");
 		exit(1); 		}a 	    curlayer.klTechnology  =) 		curlayer.klMask[0] = 		curlayer.klMask[1] = 		curlayer.klMask[2] = ' ';  	    curlayer.klBlink = False; 	    curlayer.klVisible = True;o 	    i = 0;u 	    while(c = inbuf[i++]){r3 		if((c > 057 && c < 072) || (c > 0100 && c < 0133)M  		    || (c > 0140 && c < 0173)) 		    break; 		}[ 	    if(c == NULL) continue; 	    curlayer.klTechnology = c; . 	    if(((c = inbuf[i++]) > 057 && c < 072) ||4 		(c > 0100 && c < 0133) || (c > 0140 && c < 0173)){ 		curlayer.klMask[0] = c;e+ 		if(((c = inbuf[i++]) > 057 && c < 072) ||*8 		    (c > 0100 && c < 0133) || (c > 0140 && c < 0173)){ 		    curlayer.klMask[1] = c;a- 		    if(((c = inbuf[i]) > 057 && c < 072) ||U5 			(c > 0100 && c < 0133) || (c > 0140 && c < 0173)){g 			curlayer.klMask[2] = c; 			} 		    }  		}n> 	    CDSetLayer(layer, curlayer.klTechnology,curlayer.klMask); 	    }B 	else if(strcmp(cp,"COLOR'SNAME") == 0 || strcmp(cp,"COLOR") == 0) 	    /*H/ 	     * color name is not used except by peoplet 	     */ 	    continue;  	else if(strcmp(cp,"RGB") == 0){" 	    rgb[0] = rgb[1] = rgb[2] = 0;6 	    sscanf(inbuf,"%d %d %d",&rgb[0],&rgb[1],&rgb[2]);+ 	    curlayer.klR = max(min(rgb[0],255),0);0+ 	    curlayer.klG = max(min(rgb[1],255),0);i+ 	    curlayer.klB = max(min(rgb[2],255),0);  	    }# 	else if(strcmp(cp,"FILLED") == 0){D 	    i = 0; . 	    while((c = inbuf[i]) == 040 || c == '\t')" 		if(inbuf[i++] == NULL) continue; 	    if(c == 'y' || c == 'Y'){ 		curlayer.klFilled = True;  		}f# 	    else if(c == 'n' || c == 'N'){  		curlayer.klFilled = False; 		}e
 	    else{ 		curlayer.klFilled = True;s. 		sscanf(&inbuf[i], "%x %x %x %x %x %x %x %x",0 		    &curlayer.klStyle[0],&curlayer.klStyle[1],0 		    &curlayer.klStyle[2],&curlayer.klStyle[3],0 		    &curlayer.klStyle[4],&curlayer.klStyle[5],1 		    &curlayer.klStyle[6],&curlayer.klStyle[7]);r 		}( 	    }( 	else if(strcmp(cp,"GRIDSPACING") == 0){+ 	    sscanf(inbuf,"%d",&Parameters.kpGrid);U% 	    Parameters.kpGrid *= RESOLUTION;n 	    }* 	else if(strcmp(cp,"MINDIMENSIONS") == 0){3 	    sscanf(inbuf,"%d", &curlayer.klMinDimensions); 5 	    curlayer.klWireWidth = curlayer.klMinDimensions;i 	    }% 	else if(strcmp(cp,"INVISIBLE") == 0)i  	    curlayer.klVisible = False;! 	else if(strcmp(cp,"BLINK") == 0)s 	    curlayer.klBlink = True; $ 	else if(strcmp(cp,"MENUTEXT") == 0)6 	    sscanf(inbuf, "%d", &Parameters.kpMenuTextColor);, 	else if(strcmp(cp,"MENUHIGHLIGHTING") == 0)> 	    sscanf(inbuf, "%d", &Parameters.kpMenuHighlightingColor);& 	else if(strcmp(cp,"MENUSELECT") == 0)8 	    sscanf(inbuf, "%d", &Parameters.kpMenuSelectColor);& 	else if(strcmp(cp,"COARSEGRID") == 0)8 	    sscanf(inbuf, "%d", &Parameters.kpCoarseGridColor);$ 	else if(strcmp(cp,"FINEGRID") == 0)6 	    sscanf(inbuf, "%d", &Parameters.kpFineGridColor);& 	else if(strcmp(cp,"NO_OUTLINE") == 0)" 	    Parameters.kpOutline = False;$ 	else if(strcmp(cp,"SHOWGRID") == 0)1 	    Parameters.kpShowGridInLargeViewport = True;0( 	else if(strcmp(cp,"GRIDONBOTTOM") == 0)$ 	    Parameters.kpGridOnTop = False;* 	else if(strcmp(cp,"DISPLAYALLTEXT") == 0)* 	    Parameters.kpDisplayAllLabels = True;- 	else if(strcmp(cp,"LABELALLINSTANCES") == 0)[+ 	    Parameters.kpLabelAllInstances = True;   	else if(strcmp(cp,"LRC") == 0){ 	    sscanf(inbuf,"%s",str1);g 	    UseLRC(str1); 	    }% 	else if(strcmp(cp,"LRCRULES") == 0){( 	    sscanf(inbuf,"%s",str1);r 	    UseRules(str1); 	    }) 	else if(strcmp(cp,"HIGHLIGHTING") == 0){a" 	    rgb[0] = rgb[1] = rgb[2] = 0;6 	    sscanf(inbuf,"%d %d %d",&rgb[0],&rgb[1],&rgb[2]);; 	    Parameters.kpHighlightingRed = min(max(rgb[0],0),255);e= 	    Parameters.kpHighlightingGreen = min(max(rgb[1],0),255);t< 	    Parameters.kpHighlightingBlue = min(max(rgb[2],0),255); 	    }' 	else if(strcmp(cp,"BACKGROUND") == 0){n" 	    rgb[0] = rgb[1] = rgb[2] = 0;6 	    sscanf(inbuf,"%d %d %d",&rgb[0],&rgb[1],&rgb[2]);9 	    Parameters.kpBackgroundRed = min(max(rgb[0],0),255);*; 	    Parameters.kpBackgroundGreen = min(max(rgb[1],0),255);M: 	    Parameters.kpBackgroundBlue = min(max(rgb[2],0),255); 	    }% 	else if(strcmp(cp,"SYMBOLIC") == 0){u. 	    while((c = inbuf[i]) == 040 || c == '\t')" 		if(inbuf[i++] == NULL) continue; 	    if(c == 'y' || c == 'Y')  		curlayer.klSymbolic = True;K" 	    else if(c == 'n' || c == 'N') 		curlayer.klSymbolic = False; 	    } 	else{9 	    printf("Unknown keyword \"%s\" in .KIC file\n", cp);e 	    } 	}     NumLayerTable = layer;     fclose(dotkic);      }a   char *GetKeyWord(file,inbuf)4     FILE *file;s     char *inbuf;     { 
     char *cp;k
     int c;     static char keyword[40];  !     /* look for first key word */GJ     while(((c = getc(file)) < 0101 || c > 0132) && (c < 0141 || c > 0172)) 	if(c == EOF) return(NULL); :     /* scan to end of keyword and convert to upper case */     cp = keyword;FF     while(c != 040 && c != '\t' && c != 077 && c != '\n' && c != EOF){" 	if(c > 0140 && c < 0173) c -= 32; 	*cp++ = c;  	c = getc(file); 	}     *cp = 0;3     /* scan to end of line and put args in inbuf */ !     while(c != '\n' && c != EOF){/# 	if(c == '\t' || c == 077) c = 040;" 	*inbuf++ = c; 	c = getc(file); 	}     *inbuf = 0;s     return(keyword);     }]