 /*  * fbmascomp.c  **  * Copyright -C- 1981 Giles C. Billingsley'  * sccsid "@(#)fbmascomp.c	1.1  9/5/83"e  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program ;  * KIC is available free of charge to any interested party.,B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,U  * is forbidden.  */;     E /******************************************************************** # FB package for the Masscomp MC-500.t   Giles BillingsleyoF *********************************************************************/   #include <sys/ioctl.h> #include <termio.h>	 #include "kic.h"   /*D  * For early, nonvirtual versions of the mc500, the NON_VIRTUAL flagG  * must be defined.  This will cause KIC to allocate MG_MEM_SPACE bytesMK  * of memory for working storage before the graphics processor is assigned.   */r /******************  #define	NON_VERTUALa *******************/ #define JOYSTICK   struct termio oldterm; struct termio newterm;   #ifdef NON_VIRTUAL@ #define MG_MEM_SPACE	(1024*1024*2)	/* 2 meg of initial memory */G static char MGMemAllocated = False;	/* non vm memory allocation flag */r #endif  M static char MGUserHasPointed;	/* boolean to indicate that user has pointed */fB static short MGPointMask;	/* mask recovered by button interrupt */E static short MGIntensityBits;	/* number of bits in color intensity */ L static short MGIntensityPad;	/* unused bits in 1st byte of color map reg. */2 static int MGFontNumber;	/* current font number */E static int MGCurrentX;		/* current graphics X position in viewport */	E static int MGCurrentY;		/* current graphics Y position in viewport */O* static int MGCurrentHue;	/* current hue */4 static int MGFillPattern;	/* current fill pattern */A static int MGPointX;		/* X value recovered by button interrupt */gA static int MGPointY;		/* Y value recovered by button interrupt */{G static int MGConfiguration[14];	/* configuration report of MG device */c2 static int ButtonMask[]		/* MC-500 button masks */     = {0x01, 0x02, 0x04, 0x08};   ! short DefaultCursor[] = { 0x8002,r 			  0x4004, 			  0x2008, 			  0x1010, 			  0x0820, 			  0x0440, 			  0x0280, 			  0x0100, 			  0x0280, 			  0x0440, 			  0x0820, 			  0x1010, 			  0x2008, 			  0x4004, 			  0x8002, 			  0x0000 };   /* taken from mfb.h */ struct mfbpath {     int nvertices;     int *xy;     };  " typedef struct mfbpath MFBPOLYGON;  typedef enum {false, true} Bool;   FBTransfer() {
     /* nop */h     };   FBBegin(Display)     char *Display;     {      /*
      * Notes:d0      *    Initialize TTY and save current state.-      *    Also, the output buffer is cleared.       */  #ifdef NON_VIRTUAL
     char *cp;I      if(MGMemAllocated == False){) 	if((cp = malloc(MG_MEM_SPACE)) == NULL){ G 	    fprintf(stderr,"Initial memory allocation failed in FBBegin()\n");n 	    exit(-1); 	    }
 	free(cp); 	MGMemAllocated = True;N 	} #endif3     if(FB.fDeviceName != NULL And !FB.fInitialized)). 	fprintf(stderr,"-d option not available.\n");     FB.fDisplay = Display;     FBInitialize();t     }    FBInitialize(){      int i,null,left,bottom;       int FBCatchPointInterrupt();
     null = 0;s     /* turn off cursor */      printf("\033[2J");     /* turn off cursor */P     printf("\033Gac");     if(!FB.fInitialized){ * 	/* first put terminal in 'CBREAK' mode */" 	if(ioctl(1,TCGETA,&oldterm) < 0){< 	    fprintf(stderr,"Can't get device status from ioctl\n"); 	    exit(-1); 	    } 	newterm = oldterm; $ 	newterm.c_lflag |= (ISIG & NOFLSH);# 	newterm.c_lflag &= ~(ECHO|ICANON);' 	newterm.c_iflag &= ~ICRNL;9 	newterm.c_oflag &= ~TAB3; 	newterm.c_cc[VMIN] = 1; 	newterm.c_cc[VTIME] = 1; # 	if(ioctl(1,TCSETAF,&newterm) < 0){ < 	    fprintf(stderr,"Can't set device status with ioctl\n"); 	    exit(-1); 	    } 	/* initialize */1         mginit(0,0);% 	/* get configuaration information */l%         mgigethc(12,MGConfiguration);u #ifdef DEBUG         for(i=0; i<12; ++i)d7 	    fprintf(stderr,"(%d) %d   ",i,MGConfiguration[i]);r 	fprintf(stderr,"\n"); #endif 	/* set origin of viewport */r 	mgivcoor(2,0,0); 2 	/* ask the MC-500 for the size of the viewport */8 	mgigetvcoor(2,&left,&bottom,&FB.fMaxX,&FB.fMaxY,&null);? 	/* we'll arbitrarily use font number 1 as the standard font */t 	MGFontNumber = 1;  	mgifetchgf(MGFontNumber,"5x7"); 	mgigf(MGFontNumber);M( 	/* leave 2 pixels between characters */ 	FB.fFontWidth = 7;i 	FB.fFontHeight = 10;	 	}6     /* the current viewport is and will always be 2 */     mgiv(2);     /* calculate intensity */,     FB.fMaxP = 1; '     for(i=0; i<MGConfiguration[7]; ++i)	 	FB.fMaxP *= 2;0     FB.fMaxP--;1 #ifdef DEBUG8     fprintf(stderr,"MaxPixelIntensity = %d\n",FB.fMaxP); #endif/     /* all intensities are normalized to 255 */      FB.fMaxIntensity = 255;	)     MGIntensityBits = MGConfiguration[7];u)     MGIntensityPad = 8 - MGIntensityBits;x     /* use frame buffer 1 */     mgifb(1,1);;!     /* we will use every plane */      mgipln(-1); <     /* the ALU operation will be destructive or replacing */     mgimodfunc(3,0,0);&     /* take care of pointing device */     MGPointX = MGPointY = 0;     MGUserHasPointed = False;r(     mgibuttonint(FBCatchPointInterrupt);:     /* initialize the rest of FB for this configuration */     FB.fNumColors = 1;'     for(i=0; i<MGConfiguration[5]; ++i)l 	FB.fNumColors *= 2;     FB.fNumColors--;7     /* load new cursor on the KIC highlighting layer */ 1     mgiloadcurs(7,7,FB.fNumColors,DefaultCursor);i #ifdef DEBUG5     fprintf(stderr,"NumColors = %d\n",FB.fNumColors);p #endif     FB.fNumFillPatterns = 0;*     FB.fNumRows = FB.fMaxY/FB.fFontHeight;,     FB.fNumColumns = FB.fMaxX/FB.fFontWidth;     FB.fLastCursorColumn = 0;f     FB.fNumButtons = 4;"     FB.fButtons = True;f      FB.fButtonMask = ButtonMask;     FB.fFilledPolygons = True;&     FB.fDefinableFillPatterns = False;"     FB.fNonDestructiveText = True;     FB.fInitialized = True;t!     MGCurrentX = MGCurrentY = -1;      }i  
 FBHalt() {%     if(ioctl(1,TCSETAF,&oldterm) < 0)g, 	fprintf(stderr,"ioctl failed in FBHalt\n"); #ifdef DEBUG     fprintf(stderr,"FBHalt\n");w #endif     FBForeground(ERASE,0);     FBFlood();     FB.fInitialized = False;     mgideagp(0,0);     /* turn on cursor */     printf("\033Gc\033Gb");t     }   	 FBEnd() { %     if(ioctl(1,TCSETAF,&oldterm) < 0)1+ 	fprintf(stderr,"ioctl failed in FBEnd\n");n     FBForeground(ERASE,0);     FBFlood();     FB.fInitialized = False;     mgideagp(0,0);     /* turn on cursor */     printf("\033Gc\033Gb");i     }r  " FBForeground(DisplayOrErase,Pixel)     char DisplayOrErase;     int Pixel;     {/*     if(DisplayOrErase == ERASE) Pixel = 0;%     if(MGCurrentHue == Pixel) return;f,     MGCurrentHue = min(Pixel,FB.fNumColors);,     /* use absolute color specifications. */     mgihue(MGCurrentHue);d     }e   FBMoveTo(X1,Y1)i     int X1,Y1;       {y     MGCurrentX = X1;     MGCurrentY = Y1;     }*   FBDrawLineTo(X2,Y2)*     int X2,Y2; *     {*&     mgil(MGCurrentX,MGCurrentY,X2,Y2);     MGCurrentX = X2;     MGCurrentY = Y2;     }*   FBLine(X1,Y1,X2,Y2)*     int X1,Y1,X2,Y2; *     {      mgil(X1,Y1,X2,Y2);     MGCurrentX = X2;     MGCurrentY = Y2;     }F  % FBDefineFillPattern(StyleId,BitArray)0     int StyleId;     int *BitArray;     {T
     /* nop */K     }l   FBSetFillPattern(StyleId)*     int StyleId;     {o      if(MGFillPattern == StyleId) 	return;     MGFillPattern = StyleId;
     /* nop */_     }a   FBVLT(Pixel,R,G,B)     int Pixel,R,G,B;     {t     int index = 0;     if(Pixel < 0) return;f%     Pixel = min(Pixel,FB.fNumColors);4     /* normalized to 255 */m*     R = (R * FB.fMaxP) / FB.fMaxIntensity;*     G = (G * FB.fMaxP) / FB.fMaxIntensity;*     B = (B * FB.fMaxP) / FB.fMaxIntensity;2     index = ((R & 0x0F) << (16 + MGIntensityPad)) ( 	| ((G & 0x0F) << (8 + MGIntensityPad)) " 	| ((B & 0x0F) << MGIntensityPad);     mgicm(Pixel,index);t     }l  " FBText(Mode,RowOrX,ColumnOrY,Text)     char Mode;     int RowOrX,ColumnOrY;r     char *Text;t     {M
     int i;     if(Mode == ROW_COLUMN){t( 	i = FB.fMaxY - RowOrX * FB.fFontHeight;* 	RowOrX = (ColumnOrY - 1) * FB.fFontWidth; 	ColumnOrY = i;t 	}(     mgigfs((RowOrX+1),ColumnOrY,0,Text);     }r  " FBPolygon(Pixel,Type,StyleId,xy,n)     int *xy;     int Pixel,StyleId,n;     char Type;     {      /*$      * Type == OUTLINE means outline      * Type == FILL means fill2      * StyleId defines stipple pattern (0 = SOLID)      */h
     int j,j2; 4     int X[MAXPOLYGONVERTICES],Y[MAXPOLYGONVERTICES];  /     if(n < 2 || n > MAXPOLYGONVERTICES) return;B     else if(n < 3){( 	mgil(xy[0],xy[1],xy[2],xy[3]);  	}      FBForeground(DISPLAY,Pixel);     FBSetFillPattern(StyleId);     for(j=0; j<n; ++j){, 	j2 = j + j; 	X[j] = xy[j2];o 	Y[j] = xy[j2 + 1];3 	}&     /* make sure the loop is closed */)     if(X[0] != X[n-1] || Y[0] != Y[n-1]){d         X[n] = X[0];         Y[n] = Y[0];         n++; 	}     if(Type == OUTLINE){ 	mgils(n,X,Y); 	}	     else{p 	mgipoly(n,X,Y); 	}     }    FBBlink(Layer,r,g,b,Flag))     int Layer, Flag;     int r,g,b;     {e
     /* nop */s     }r   FBFlood() {i#     mgiclearpln(2,-1,MGCurrentHue);=     }    FBSetCursorColor(colorId)u     int colorId;     { 
     /* nop */m     }l   FBPolygonClip(coord,n,window)l     int *coord;c     int *n;      struct ka window;d     {e     MFBPOLYGON poly;     poly.nvertices = *n;     if(*n < 3) return;     poly.xy = coord;T     MFBPolygonClip(&poly,window.kaLeft,window.kaBottom,window.kaRight,window.kaTop);     *n = poly.nvertices;     }    FBKeyboard(TypeIn)     char **TypeIn;     {*     /*
      * Notes:*B      *    Read type-in from keyboard until user types return key. 9      *    Do rub-out processing--rub out and ctrl-h keys.       */t
     int Int1;      int x,y;     int X,Y;     char c[2];$     static char FBTypeInBuffer[161];  
     Int1 = 0;      c[1] = NULL;     /* FBSetFillPattern(0); */5     FBForeground(DISPLAY,Parameters.kpMenuTextColor);(J     Y = y = FB.fMaxY - (FB.fNumRows - Parameters.kpNumLayerMenuRows - 1) * 	FB.fFontHeight;1     X = x = FB.fLastCursorColumn * FB.fFontWidth;i       /*      * NAIVE KEYBOARDM      */.  )     /* echo characters using graphtext */M     for(;;){         X += FB.fFontWidth;M         FBTransfer(); A         if((c[0] = getchar()) == 13 || c[0] == 10 || Int1 > 160){I%     	    FBTypeInBuffer[Int1] = NULL;e     	    break;g
     	    }B         else if(c[0] == 8 || c[0] == 0177){    /* ctrl-h or del */ 	    X -= FB.fFontWidth;7 	    if(Int1 > 0){		       /* can't bs further . . . */R 	        FBForeground(ERASE,0);OD 	        FBBox(0,ERASE,FILL,0,X,Y,X+FB.fFontWidth,Y+FB.fFontHeight);: 	        FBForeground(DISPLAY,Parameters.kpMenuTextColor); 	        X -= FB.fFontWidth; 	        Int1--;
 	        } 	    }E         else if(c[0] == 24 || c[0] == 21){     /* ctrl-x or ctrl-u */E 	    FBForeground(ERASE,0);=@ 	    FBBox(0,ERASE,FILL,0,x,y,X+FB.fFontWidth,Y+FB.fFontHeight);6 	    FBForeground(DISPLAY,Parameters.kpMenuTextColor); 	    X = x;G 	    Int1 = 0; 	    }'         else if(c[0] == 27){  /* esc */ , 	    FBText(PIXEL_COORDINATE,X,Y,"ESCAPE"); 	    FBTypeInBuffer[0] = NULL; 	    Int1 = 0; 	    break;P 	    }
         else{o# 	    FBTypeInBuffer[Int1++] = c[0];j 	    X = min(FB.fMaxX,X);n 	    Y = min(FB.fMaxY,Y);B$ 	    FBText(PIXEL_COORDINATE,X,Y,c); 	    }	         }t     *TypeIn = FBTypeInBuffer;8     }t   FBPoint(X,Y,Key,Buttons)     int *X,*Y,*Buttons;(     char *Key;     {u     long arg = 0;      *X = *Y = 0;(     mgibuttonint(FBCatchPointInterrupt); #ifdef JOYSTICK/     mgicursmode(0x01F);  #elset     mgicursmode(0x07); #endif1     while(MGUserHasPointed == False && arg <= 0){= 	ioctl(1,FIONREAD,&arg); 	}!     if(MGUserHasPointed == True){l
 	*Key = NULL;  	*X = MGPointX;g 	*Y = MGPointY;B 	*Buttons = MGPointMask; 	MGUserHasPointed = False; 	}     else         *Key = getchar();l     mgicursmode(0);e     }r   FBCatchPointInterrupt(x,y,mask)      int x,y;     short mask;r     {l.     /* ignore when user releases the button */E     if(mask == 0x01 || mask == 0x02 || mask == 0x04 || mask == 0x08){  	MGUserHasPointed = True;F 	MGPointX = x; 	MGPointY = y;         MGPointMask = mask;  #ifdef DEBUGE         fprintf(stderr,"User pointed: mask = 0x%x  x = %d  y = %d\n", $ 	    MGPointMask,MGPointX,MGPointY); #endif 	}	     else{;!         MGUserHasPointed = False;a #ifdef DEBUG5         fprintf(stderr,"User has released button\n");t #endif 	}     }M  & FBMore(Left,Bottom,Right,Top,Textfile)
     int Left;S     int Bottom;0     int Right;     int Top;     FILE *Textfile;i     {B1     char cbuf[200];		/* 200 chars per line max */B     int c,i;     int linecount;     int done = 0;i     int oldfillpattern;p     int oldforeground;     int nlines;j     int nchars;   (     /* test to be sure of window area */     if(Top < Bottom) 	SwapInts(Top,Bottom);     if(Right < Left) 	SwapInts(Left,Right);       /* calculate parameters */+     nlines = (Top - Bottom)/FB.fFontHeight;;*     nchars = (Right - Left)/FB.fFontWidth;     nchars = min(nchars,200);,       /* save old style ID's */ !     oldforeground = MGCurrentHue;(#     oldfillpattern = MGFillPattern;C       if(nlines <= 0) return;o     linecount = 1;0     FBBox(0,ERASE,FILL,0,Left,Bottom,Right,Top);     FBForeground(DISPLAY,1);     while(! done) {  	i = 0;x= 	while(i < nchars && (c = getc(Textfile)) != '\n' && c != EOFE, 	    && ((c >= ' ' && c <= '~') || c == 9)){ 	    if(c == 9){ /* tab */ 		cbuf[i++] = ' ';4 		while(i < nchars && (i % 8) != 0) cbuf[i++] = ' '; 		}e	 	    else  		cbuf[i++] = c; 	    } 	cbuf[i] = NULL; 	if(c == EOF) done = 1;FG 	FBText(PIXEL_COORDINATE,Left,Top - (linecount) * FB.fFontHeight,cbuf);l 	FBTransfer();# 	if(done || ++linecount >= nlines){m 	    linecount = 1; 
 	    if(done)x0 		FBText(PIXEL_COORDINATE,Left,Bottom,"-DONE-");	 	    else = 		FBText(PIXEL_COORDINATE,Left,Bottom,"-MORE- (^D to exit)");u 	    FBTransfer(); 	    c = getchar();r 	    if(c == 4) break;1 	    FBBox(0,ERASE,FILL,0,Left,Bottom,Right,Top);t 	    FBForeground(DISPLAY,1);T 	    } 	}+     /* FBSetFillPattern(oldfillpattern); */x(     FBForeground(DISPLAY,oldforeground);     }          /*   * MFB polygon clipping routines  */f  I /************************************************************************Y  *'  *                              MFBClipe  *@  *     MFBClip contains routines for special viewport management  *     and geometry clipping.e  *  *     MFBPolygonClip,  *     MFBLineClip  *     MFB_X_Intercept  *     MFB_Y_Intercept  *J  ************************************************************************/   #define CODELEFT 1 #define CODEBOTTOM 2 #define CODERIGHT 4  #define CODETOP 8a #define CODE(x,y,c)  c = 0;\                      if(x < l)\='                          c = CODELEFT;\a$                      else if(x > r)\(                          c = CODERIGHT;\                      if(y < b)\(*                          c |= CODEBOTTOM;\$                      else if(y > t)\&                          c |= CODETOP;   void! MFB_Y_Intercept(x1,y1,x2,y2,e,yi) <     int x1,y1,x2,y2;                /* two points on line */D     int e;                          /* vertical line of intercept */C     int *yi;                        /* y coordinate of intercept */j     {n     /*J      * MFB_Y_Intercept will return the value 'yi' where the the coordinateI      * (e,yi) is the intersection of the vertical line x = e and the linel9      * determined by the coordinates (x1,y1) and (x2,y2).e      */ 
     *yi = y1;h7     if(x1 == x2) return;            /* vertical line */ 0     *yi = y1 + ((e - x1) * (y2 - y1))/(x2 - x1);     }u     void! MFB_X_Intercept(x1,y1,x2,y2,e,xi)n<     int x1,y1,x2,y2;                /* two points on line */F     int e;                          /* horizontal line of intercept */C     int *xi;                        /* x coordinate of intercept */n     {s     /*J      * MFB_X_Intercept will return the value 'xi' where the the coordinateK      * (xi,e) is the intersection of the horizontal line y = e and the linee9      * determined by the coordinates (x1,y1) and (x2,y2).*      */ 
     *xi = x1; 9     if(y1 == y2) return;            /* horizontal line */n0     *xi = x1 + ((e - y1) * (x2 - x1))/(y2 - y1);     }-     Bool$ MFBLineClip(pX1,pY1,pX2,pY2,l,b,r,t)$     int *pX1,*pY1,*pX2,*pY2,l,b,r,t;     {a     /*H      * MFBLineClip will clip a line to a rectangular area.  The returnedH      * value is 'true' if the line is out of the AOI (therefore does notC      * need to be displayed) and 'false' if the line is in the AOI.F      */i     int x1 = *pX1;     int y1 = *pY1;     int x2 = *pX2;     int y2 = *pY2;     int x,y,c,c1,c2;       CODE(x1,y1,c1)     CODE(x2,y2,c2)     while(c1 != 0 || c2 != 0) {.H         if((c1 & c2) != 0) return(true); /*Assert:  Line is invisible.*/!         if((c = c1) == 0) c = c2;          if(c & CODELEFT) {*             y = y1+(y2-y1)*(l-x1)/(x2-x1);             x = l; 	    }          else if(c & CODERIGHT) {*             y = y1+(y2-y1)*(r-x1)/(x2-x1);             x = r; 	    }!         else if(c & CODEBOTTOM) {R*             x = x1+(x2-x1)*(b-y1)/(y2-y1);             y = b; 	    }         else if(c & CODETOP) {*             x = x1+(x2-x1)*(t-y1)/(y2-y1);             y = t; 	    }         if(c == c1) {p(             x1 = x; y1 = y; CODE(x,y,c1) 	    }         else {(             x2 = x; y2 = y; CODE(x,y,c2) 	    } 	}     *pX1 = x1; *pY1 = y1;'     *pX2 = x2; *pY2 = y2; C     return(false); /*Assert:  Line is at least partially visible.*/      }     * MFBPolygonClip(poly,left,bottom,right,top)     MFBPOLYGON *poly;u6     int top,bottom,left,right;      /* bounding box */     {E     /*E      * MFBPolygonClip will take the polygon 'poly' and clip it to the+;      * box described by 'top','bottom','left', and 'right'.M      */r     MFBPOLYGON p1,p2;l+     static int polybuffer1[POLYGONBUFSIZE];i+     static int polybuffer2[POLYGONBUFSIZE];=     int i,k,n,*swap;     int minx, miny, maxx, maxy;(       if(top < bottom)         SwapInts(top,bottom);x     if(right < left)         SwapInts(left,right);   *     n = poly->nvertices + poly->nvertices;     if(n < 4) return;_     n = min(POLYGONBUFSIZE,n);     p1.xy = polybuffer1;     p2.xy = polybuffer2;     minx = maxx = poly->xy[0];     miny = maxy = poly->xy[1];     for(i=0; i<n; i++){x         p2.xy[i] = poly->xy[i];o 	maxx = max(p2.xy[i],maxx);  	minx = min(p2.xy[i],minx);r 	++i;l         p2.xy[i] = poly->xy[i];  	maxy = max(p2.xy[i],maxy);  	miny = min(p2.xy[i],miny);r 	}  '     /* test if clipping is necessary */i     poly->nvertices = 0;B     if(maxx < left || minx > right || maxy < bottom || miny > top) 	return;       /*&      * start with the right side first      */-     k = i = 0;,     while(p2.xy[i] > right && i < n) i += 2;     if(i == 0){n          p1.xy[k++] = p2.xy[i++];          p1.xy[k++] = p2.xy[i++];	         }l     else if(i == n)a         return;d
     else {         p1.xy[k++] = right;uB         MFB_Y_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1], 	    right,&p1.xy[k++]);	         }      while(i < n){=         if(p2.xy[i] <= right){$             p1.xy[k++] = p2.xy[i++];$             p1.xy[k++] = p2.xy[i++];
             },         else {$             if(p2.xy[i-2] != right){#                 p1.xy[k++] = right;:J                 MFB_Y_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1], 		    right,&p1.xy[k++]);                  }x4             while(i < n && p2.xy[i] > right) i += 2;+             if(i < n && p2.xy[i] <= right){-#                 p1.xy[k++] = right; J                 MFB_Y_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1], 		    right,&p1.xy[k++]);                  }e
             })	         } 3     if((p2.xy[0] > right && p2.xy[n-2] <= right) ||;3         (p2.xy[0] <= right && p2.xy[n-2] > right)){          p1.xy[k++] = right; F         MFB_Y_Intercept(p2.xy[0],p2.xy[1],p2.xy[n-2],p2.xy[n-1],right, 	    &p1.xy[k++]);	         }p     if(k < 4) return;      n = min(POLYGONBUFSIZE,k);     swap = p1.xy;l     p1.xy = p2.xy;     p2.xy = swap;l       /*      * next the left sideF      */*     k = i = 0;+     while(p2.xy[i] < left && i < n) i += 2;/     if(i == 0){           p1.xy[k++] = p2.xy[i++];          p1.xy[k++] = p2.xy[i++];	         }b     else if(i == n)n         return; 
     else {         p1.xy[k++] = left;G         MFB_Y_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1],left,- 	    &p1.xy[k++]);	         }T     while(i < n){=         if(p2.xy[i] >= left){r$             p1.xy[k++] = p2.xy[i++];$             p1.xy[k++] = p2.xy[i++];
             }          else {#             if(p2.xy[i-2] != left){x"                 p1.xy[k++] = left;J                 MFB_Y_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1], 		    left,&p1.xy[k++]);                 }*3             while(i < n && p2.xy[i] < left) i += 2; *             if(i < n && p2.xy[i] >= left){"                 p1.xy[k++] = left;J                 MFB_Y_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1], 		    left,&p1.xy[k++]);                 }Y
             } 	         }*1     if((p2.xy[0] < left && p2.xy[n-2] >= left) ||*1         (p2.xy[0] >= left && p2.xy[n-2] < left)){M         p1.xy[k++] = left;E         MFB_Y_Intercept(p2.xy[0],p2.xy[1],p2.xy[n-2],p2.xy[n-1],left,( 	    &p1.xy[k++]);	         }      if(k < 4) return;      n = min(POLYGONBUFSIZE,k);     swap = p1.xy;      p1.xy = p2.xy;     p2.xy = swap;        /*      * next the top side      */|     k = i = 0;,     while(p2.xy[i+1] > top && i < n) i += 2;     if(i == 0){c          p1.xy[k++] = p2.xy[i++];          p1.xy[k++] = p2.xy[i++];	         }      else if(i == n)p         return; 
     else {F         MFB_X_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1],top, 	    &p1.xy[k++]);         p1.xy[k++] = top;p	         }'     while(i < n){M         if(p2.xy[i+1] <= top){$             p1.xy[k++] = p2.xy[i++];$             p1.xy[k++] = p2.xy[i++];
             }]         else {"             if(p2.xy[i-1] != top){J                 MFB_X_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1], 		    top,&p1.xy[k++]);s!                 p1.xy[k++] = top;r                 }i4             while(i < n && p2.xy[i+1] > top) i += 2;+             if(i < n && p2.xy[i+1] <= top){ J                 MFB_X_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1], 		    top,&p1.xy[k++]);=!                 p1.xy[k++] = top;2                 }x
             }1	         } /     if((p2.xy[1] > top && p2.xy[n-1] <= top) ||n/         (p2.xy[1] <= top && p2.xy[n-1] > top)){.D         MFB_X_Intercept(p2.xy[0],p2.xy[1],p2.xy[n-2],p2.xy[n-1],top, 	    &p1.xy[k++]);         p1.xy[k++] = top;l	         }<     if(k < 4) return;/     n = min(POLYGONBUFSIZE,k);     swap = p1.xy;;     p1.xy = p2.xy;     p2.xy = swap;        /*      * finally the bottom side      */      i = k = 0;/     while(p2.xy[i+1] < bottom && i < n) i += 2;[     if(i == 0){2          p1.xy[k++] = p2.xy[i++];          p1.xy[k++] = p2.xy[i++];	         }      else if(i == n)l         return; 
     else {I         MFB_X_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1],bottom,  	    &p1.xy[k++]);         p1.xy[k++] = bottom;	         }      while(i < n){;!         if(p2.xy[i+1] >= bottom){2$             p1.xy[k++] = p2.xy[i++];$             p1.xy[k++] = p2.xy[i++];
             }          else {%             if(p2.xy[i-1] != bottom){ J                 MFB_X_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1], 		    bottom,&p1.xy[k++]);$                 p1.xy[k++] = bottom;                 }&7             while(i < n && p2.xy[i+1] < bottom) i += 2; .             if(i < n && p2.xy[i+1] >= bottom){J                 MFB_X_Intercept(p2.xy[i-2],p2.xy[i-1],p2.xy[i],p2.xy[i+1], 		    bottom,&p1.xy[k++]);$                 p1.xy[k++] = bottom;                 } 
             };	         } 5     if((p2.xy[1] < bottom && p2.xy[n-1] >= bottom) ||;5         (p2.xy[1] >= bottom && p2.xy[n-1] < bottom)){wG         MFB_X_Intercept(p2.xy[0],p2.xy[1],p2.xy[n-2],p2.xy[n-1],bottom,h 	    &p1.xy[k++]);         p1.xy[k++] = bottom;	         }      if(k < 4) return;i     k = min(POLYGONBUFSIZE,k);     poly->nvertices = k >> 1;(       /*@      * Transfer coordinates to poly buffer and one last clipping      */,     for(i=0; i<k; i += 2){4         poly->xy[i] = max(min(p1.xy[i],right),left);8         poly->xy[i+1] = max(min(p1.xy[i+1],top),bottom);	         }1     }]  