 /*  * flatten.c  **  * Copyright -C- 1981 Giles C. Billingsley%  * sccsid "@(#)flatten.c	1.1  9/5/83"9  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program ;  * KIC is available free of charge to any interested party.0B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,l  * is forbidden.  */   b  e /*  * The KIC flatten code.  */e   #include "kic.h" #include "select.h"s   /* Library routines */ #ifndef vms  char *sprintf(); #endif   char TypeOut[200];   Flatten() {      struct t *TGen;e     struct s *MasterDesc;i     struct ks *SelectQDesc;d     struct ks *OldSelectQDesc;     char *MasterName;i     char *TypeIn;o
     int Info;      int X,Y;     int NumX,DX,NumY,DY;!     int MasterHeight,MasterWidth;n     int Int1,Int2;     struct ka MasterBB;      struct ka OldSelectQBB;n     char Type;       if(SelectQHead == NULL){9 	ShowPrompt("You haven't selected anything to flatten.");m 	return; 	}     MenuSelect(MenuFLATN);G     ShowPrompt("The FLATTEN command cannot be undone.  Continue (Y)?");;     FBKeyboard(&TypeIn);-     if(TypeIn[0] == 'N' Or TypeIn[0] == 'n'){/ 	MenuDeselect(MenuFLATN);y 	return; 	}     SelectQDesc = SelectQHead;     SelectQComputeBB();      OldSelectQBB = SelectQBB;f     while(SelectQDesc != NULL){l& 	CDType(SelectQDesc->ksPointer,&Type); 	if(Type == CDSYMBOLCALL){@ 	    CDInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,&Info); 	    if(Info == 2) 		continue;BD 	    CDCall(SelectQDesc->ksPointer,&MasterName,&NumX,&DX,&NumY,&DY);0 	    if(Not CDOpen(MasterName,&MasterDesc,'r')){8 		sprintf(TypeOut,"Can't flatten %s. MORE",MasterName);  		ShowPrompt(TypeOut); 		FBKeyboard(&TypeIn); 		ShowPrompt(CDStatusString); 	 		return;d 		} & 	    elif(CDStatusInt == CDNEWSYMBOL){5 		sprintf(TypeOut,"Can't find cell %s.",MasterName); f 		ShowPrompt(TypeOut);	 		return;e 		}i> 	    if(Not CDBB(MasterDesc,(struct o *)NULL,&MasterBB.kaLeft,8 		&MasterBB.kaBottom,&MasterBB.kaRight,&MasterBB.kaTop)) 		MallocFailed();a' 	    for(Int1 = NumY;Int1 >= 1;--Int1){ $ 		for(Int2 = 1;Int2 <= NumX;++Int2){7 		    MasterWidth = MasterBB.kaRight - MasterBB.kaLeft;o8 		    MasterHeight = MasterBB.kaTop - MasterBB.kaBottom; 		    TPush(); 		    TIdentity();/ 		    CDInitTGen(SelectQDesc->ksPointer,&TGen);M 		    loop { 			CDTGen(&TGen,&Type,&X,&Y);a 			if(TGen == NULL),
 			    break;o 			if(Type == CDROTATE){ 			    TRotate(X,Y); 			    if(X == 0)\' 				SwapInts(MasterWidth,MasterHeight);R 			    } 			elif(Type == CDTRANSLATE). 			    TTranslate(X+(Int2-1)*(MasterWidth+DX)," 				Y+(Int1-1)*(MasterHeight+DY)); 			elif(Type == CDMIRRORX)
 			    TMX();\ 			elif(Type == CDMIRRORY)
 			    TMY();  			} 		    TPremultiply();, 		    FlattenCell(MasterDesc); d
 		    TPop();O 		    }  		}h< 	    CDDelete(Parameters.kpCellDesc,SelectQDesc->ksPointer);" 	    OldSelectQDesc = SelectQDesc;* 	    SelectQDesc = OldSelectQDesc->ksSucc;. 	    SelectQDelete(OldSelectQDesc->ksPointer);" 	    Parameters.kpModified = True; 	    } 	elsei' 	    SelectQDesc = SelectQDesc->ksSucc;F 	}'     /* take care of instance markers */B      OldSelectQBB.kaRight += 600;     OldSelectQBB.kaLeft -= 600;      OldSelectQBB.kaTop += 600;!     OldSelectQBB.kaBottom -= 600;.(     EraseBox(OldSelectQBB,OldSelectQBB);2     Redisplay(Parameters.kpCellDesc,OldSelectQBB);     FBTransfer();x     SelectQComputeBB();      MenuDeselect(MenuFLATN);     }e     FlattenCell(CellDesc)i     struct s *CellDesc;      {x     struct g *GenDesc;     struct o *Pointer;     struct p *Path;T     struct t *TGen;l     struct s *MasterDesc;a     struct ka MasterBB;d     char Type;     char *Label;     char *MasterName;,     char *TypeIn;*
     int Info;      int Layer;     int Left,Bottom,Right,Top;     int X,Y,Lngth,Width;     int NumX,DX,NumY,DY;!     int MasterHeight,MasterWidth;v     register int Int1,Int2;c       /*      * Traverse calls first.<      * So, if instances aren't expanded, top level geometry @      * isn't obscured by the symbolic pictures of any instances.      */rL     if(Not CDInitGen(CellDesc,0,(int)-INFINITY,(int)-INFINITY,(int)INFINITY,) 	(int)INFINITY,&GenDesc)) MallocFailed();g
     loop {" 	CDGen(CellDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;  	/* E 	 * Don't flatten if conditionally deleted.  Info == 5 (conditionally%' 	 * created) only applies to geometries; 	 */  	CDInfo(CellDesc,Pointer,&Info); 	if(Info == 2) 	    continue;1 	CDCall(Pointer,&MasterName,&NumX,&DX,&NumY,&DY);&
 	if(TFull()){)4 	    ShowPrompt("Cell hierarchy is too deep. MORE"); 	    FBKeyboard(&TypeIn);t< 	    ShowPrompt("Probably you have a recursive hierarchy.");
 	    TInit();  	    return; 	    } 	else {a0 	    if(Not CDOpen(MasterName,&MasterDesc,'r')){8 		sprintf(TypeOut,"Can't flatten %s. MORE",MasterName);  		ShowPrompt(TypeOut); 		FBKeyboard(&TypeIn); 		ShowPrompt(CDStatusString);b	 		return;i 		}e& 	    elif(CDStatusInt == CDNEWSYMBOL){5 		sprintf(TypeOut,"Can't find cell %s.",MasterName); ) 		ShowPrompt(TypeOut);	 		return;N 		}) 	    }: 	if(Not CDBB(MasterDesc,(struct o *)NULL,&MasterBB.kaLeft,; 	    &MasterBB.kaBottom,&MasterBB.kaRight,&MasterBB.kaTop))  	    MallocFailed();# 	for(Int1 = NumY;Int1 >= 1;--Int1){e' 	    for(Int2 = 1;Int2 <= NumX;++Int2){c3 		MasterWidth = MasterBB.kaRight - MasterBB.kaLeft;a4 		MasterHeight = MasterBB.kaTop - MasterBB.kaBottom;
 		TPush(); 		TIdentity(); 		CDInitTGen(Pointer,&TGen); 		loop {  		    CDTGen(&TGen,&Type,&X,&Y); 		    if(TGen == NULL)	 			break;p 		    if(Type == CDROTATE){s 			TRotate(X,Y);
 			if(X == 0)c* 			    SwapInts(MasterWidth,MasterHeight); 			} 		    elif(Type == CDTRANSLATE)+* 			TTranslate(X+(Int2-1)*(MasterWidth+DX),% 			    Y+(Int1-1)*(MasterHeight+DY));l 		    elif(Type == CDMIRRORX)r	 			TMX();e 		    elif(Type == CDMIRRORY)i	 			TMY();e 		    }l 		TPremultiply();; 		FlattenCell(MasterDesc);	 		TPop();e 		}  	    } 	}2     for(Layer = 1;Layer <= NumLayerTable;++Layer){? 	if(Not CDInitGen(CellDesc,Layer,(int)-INFINITY,(int)-INFINITY, ; 	    (int)INFINITY,(int)INFINITY,&GenDesc)) MallocFailed();l 	loop {u& 	    CDGen(CellDesc,GenDesc,&Pointer); 	    if(Pointer == NULL) 		break;$ 	    CDInfo(CellDesc,Pointer,&Info); 	    /* 7 	     * Info == 2 means object is conditionally deleted,E 	     * Info == 5 means object is being created (it is impossible forr0 	     * this to occur here, so we don't test it) 	     */ 	    if(Info == 2) 		continue;  	    CDType(Pointer,&Type);e 	    if(Type == CDBOX){r, 		CDBox(Pointer,&Layer,&Lngth,&Width,&X,&Y); 		/* 		 * KLUDGEe: 		 * So that the length and widths are rotated, we have to9 		 * convert to a ka box and transform the corner points.a 		 */l 		Left = Pointer->oLeft; 		Bottom = Pointer->oBottom; 		Right = Pointer->oRight; 		Top = Pointer->oTop; 		if(Right < Left) 		    SwapInts(Right,Left);  		if(Top < Bottom) 		    SwapInts(Top,Bottom);b 		TPoint(&Left,&Bottom); 		TPoint(&Right,&Top); 		Lngth = Right - Left;e 		Width = Top - Bottom;i 		X = Left + (Lngth >> 1); 		Y = Bottom + (Width >> 1);? 		if(Not CDMakeBox(Parameters.kpCellDesc,Layer,Lngth,Width,X,Y,a  		    &Pointer)) MallocFailed(); 		}d 	    elif(Type == CDLABEL){s' 		CDLabel(Pointer,&Layer,&Label,&X,&Y);e 		TPoint(&X,&Y);7 		if(Not CDMakeLabel(Parameters.kpCellDesc,Layer,Label,r$ 		    X,Y,&Pointer)) MallocFailed(); 		}  	    elif(Type == CDWIRE){& 		CDWire(Pointer,&Layer,&Width,&Path); 		CopyPathWithXForm(&Path);L; 		if(Not CDMakeWire(Parameters.kpCellDesc,Layer,Width,Path,m  		    &Pointer)) MallocFailed(); 		}N 	    elif(Type == CDPOLYGON){ " 		CDPolygon(Pointer,&Layer,&Path); 		CopyPathWithXForm(&Path);e8 		if(Not CDMakePolygon(Parameters.kpCellDesc,Layer,Path,  		    &Pointer)) MallocFailed(); 		}  	    } 	}     }e