 /*  * kic.c  **  * Copyright -C- 1981 Giles C. Billingsley!  * sccsid "@(#)kic.c	1.1  9/5/83"n  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programf;  * KIC is available free of charge to any interested party.tB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,n  * is forbidden.  */t  s    /*  * Main procedure for KIC.  */a   #define Allocate   #include <signal.h>o #include "kic.h"   /* Library routines */ char *strcpy();  #ifndef vms  char *sprintf(); #endif   extern Catch();c extern Trap(); extern CatchSIGINT();   B #define	MAXCELLS	80	/* max number of cell names on the arg list */  B static char DeviceName[MAXCELLS];	/* Output device if not stdio */C static char *CellNames[MAXCELLS];	/* Cell names in argumnet list */r= static int CurrentCell;			/* Current cell in argument list */ = static int NumCells;			/* Number of cells in argument list */t   main(argc,argv)e
     int argc;      char *argv[];	     { 
     int Int1;        CurrentCell = 0;     NumCells = 0;l      /* partial initialization */"     Parameters.kpMenu = BASICMENU;#     Parameters.kpCellName[0] = EOS;(      FineViewportOnBottom = True;*     nm_set_block_size(NMALLOC_BLOCK_SIZE);     FB.fInitialized = False;     /* default terminal type */ #     FB.fDisplay = DEFAULT_TERMINAL;      /* use stdio by default */     FB.fDeviceName = NULL;%     for(Int1 = 1;Int1 < argc;++Int1){N2 	if(*argv[Int1] == '-' && *(argv[Int1]+1) == 'g'){ 	    ++argv[Int1];  	    if(*(++argv[Int1]) == NULL) 		FB.fDisplay = argv[++Int1]; 	 	    else  		FB.fDisplay = argv[Int1];w 	    }4 	elif(*argv[Int1] == '-' && *(argv[Int1]+1) == 'd'){ 	    ++argv[Int1];  	    if(*(++argv[Int1]) == NULL)  		FB.fDeviceName = argv[++Int1];	 	    else  		FB.fDeviceName = argv[Int1]; #ifndef vmso/ 	    if(strncmp(FB.fDeviceName,"/dev",4) != 0){C; 		if(FB.fDeviceName[1] >= '0' And FB.fDeviceName[1] <= '9') 6 		    sprintf(DeviceName,"/dev/tty%s",FB.fDeviceName);= 		elif(FB.fDeviceName[0] == 't' And FB.fDeviceName[1] == 't')h3 		    sprintf(DeviceName,"/dev/%s",FB.fDeviceName);n 		else. 		    sprintf(DeviceName,"%s",FB.fDeviceName); 		FB.fDeviceName = DeviceName; 		}Y' 	    if(access(FB.fDeviceName,6) != 0){l; 		fprintf(stderr,"Can't open device %s.\n",FB.fDeviceName);b
 		exit(1); 		}m #endif 	    } 	elses( 	    CellNames[NumCells++] = argv[Int1]; 	if(NumCells >= MAXCELLS){. 	    fprintf(stderr,"Too many file names.\n"); 	    NumCells = MAXCELLS - 1;e 	    sleep(3); 	    break;e 	    } 	}       CellNames[NumCells] = NULL;s     if(NumCells > 1){o( 	printf("%d cells to edit\n",NumCells);
 	sleep(3); 	}     Init();      if(NumCells > 0){t6 	strcpy(Parameters.kpCellName,CellNames[CurrentCell]); 	}     Basic();     }s     char e *NextCellName(){"     if(++CurrentCell >= NumCells){ 	if(NumCells > 0){ 	    --CurrentCell;d0 	    ShowPromptAndWait("no more cells to edit"); 	    } 	else . 	    ShowPromptAndWait("no current cellname"); 	return( NULL ); 	}     else" 	return( CellNames[CurrentCell] );     }c    
 SaveDotKIC(){p     char String[161];      char *patbuf;      int Layer,i,n;     FILE *DotKICFileDesc1;     FILE *patterns;      FILE *cifplot;       /*#      * Save .KIC and .KIC.xx files.h2      * It seems silly to save the .KIC file twice,9      * but it would be more silly for kictocif to ask the "      * user for his terminal type.      */      for(n=0; n<2; ++n){o 	if(n == 0){
 #ifdef vms* 	    sprintf(String,"%s.KIC",FB.fDisplay); #else + 	    sprintf(String,".KIC.%s",FB.fDisplay);h #endif7 	    if((DotKICFileDesc1 = fopen(String,"w")) == NULL){o( 		ShowPrompt("Can't access .KIC file.");	 		return;a 		}  	    } 	else{
 #ifdef vms< 	    if((DotKICFileDesc1 = fopen("LAYERS.KIC","w")) == NULL) #elseg6 	    if((DotKICFileDesc1 = fopen(".KIC","w")) == NULL) #endif 		{s( 		ShowPrompt("Can't access .KIC file.");	 		return;u 		}r 	    } 	/* print path */a7 	fprintf(DotKICFileDesc1,"Path? ( %s ) \n",PGetPath());e 	fprintf(DotKICFileDesc1,"\n");*1 	for(Layer = 1; Layer <= NumLayerTable; ++Layer){. 	    /*g 	     * LayerName? 	     */5 	    fprintf(DotKICFileDesc1,"LayerName? %c%c%c%c\n",l" 		LayerTable[Layer].klTechnology , 		LayerTable[Layer].klMask[0] ,t 		LayerTable[Layer].klMask[1] ,a  		LayerTable[Layer].klMask[2] ); 	    /*= 	     * RGB? 	     */E 	    fprintf(DotKICFileDesc1,"RGB? %d %d %d\n",LayerTable[Layer].klR,m/ 		LayerTable[Layer].klG,LayerTable[Layer].klB);  	    /*e 	     * Filled?y 	     */( 	    fprintf(DotKICFileDesc1,"Filled?");( 	    if(Not LayerTable[Layer].klFilled){" 		fprintf(DotKICFileDesc1," n\n"); 		})
 	    else{* 		if(LayerTable[Layer].klStyle[0] == 0 And, 		     LayerTable[Layer].klStyle[1] == 0 And, 		     LayerTable[Layer].klStyle[2] == 0 And, 		     LayerTable[Layer].klStyle[3] == 0 And, 		     LayerTable[Layer].klStyle[4] == 0 And, 		     LayerTable[Layer].klStyle[5] == 0 And, 		     LayerTable[Layer].klStyle[6] == 0 And+ 		     LayerTable[Layer].klStyle[7] == 0 ){ ' 		     fprintf(DotKICFileDesc1," y\n");k 		     } 		 else{ 		    for(i=0; i<8; ++i){L? 			fprintf(DotKICFileDesc1," %x",LayerTable[Layer].klStyle[i]);s 			}$ 		    fprintf(DotKICFileDesc1,"\n"); 		    }) 		}s 	    /*a 	     * Invisible? 	     */) 	    if(Not LayerTable[Layer].klVisible){ ) 		fprintf(DotKICFileDesc1,"Invisible\n");e 		}  	    /*{ 	     * Blinkers?{ 	     */# 	    if(LayerTable[Layer].klBlink){"% 		fprintf(DotKICFileDesc1,"Blink\n");  		}  	    /*p 	     * MinDimensions? 	     */2 	    fprintf(DotKICFileDesc1,"MinDimensions %d\n",% 		LayerTable[Layer].klMinDimensions);) 	    /*h 	     * Symbolic?  	     */& 	    if(LayerTable[Layer].klSymbolic){+ 		fprintf(DotKICFileDesc1,"Symbolic? y\n");E 		}p
 	    else{+ 		fprintf(DotKICFileDesc1,"Symbolic? n\n");  		}      # 	    fprintf(DotKICFileDesc1,"\n");  	    }E 	fprintf(DotKICFileDesc1,"MenuText %d\n",Parameters.kpMenuTextColor);eI 	fprintf(DotKICFileDesc1,"MenuSelect %d\n",Parameters.kpMenuSelectColor); 1 	fprintf(DotKICFileDesc1,"MenuHighlighting %d\n", ) 	    Parameters.kpMenuHighlightingColor);hE 	fprintf(DotKICFileDesc1,"FineGrid %d\n",Parameters.kpFineGridColor);hI 	fprintf(DotKICFileDesc1,"CoarseGrid %d\n",Parameters.kpCoarseGridColor);d, 	fprintf(DotKICFileDesc1,"GridSpacing %d\n",# 	    Parameters.kpGrid/RESOLUTION);i3 	fprintf(DotKICFileDesc1,"Highlighting %d %d %d\n",d" 	    Parameters.kpHighlightingRed,$ 	    Parameters.kpHighlightingGreen,$ 	    Parameters.kpHighlightingBlue);1 	fprintf(DotKICFileDesc1,"Background %d %d %d\n",f  	    Parameters.kpBackgroundRed," 	    Parameters.kpBackgroundGreen," 	    Parameters.kpBackgroundBlue);* 	if(Parameters.kpShowGridInLargeViewport){+ 	    fprintf(DotKICFileDesc1,"ShowGrid\n");l 	    }  	if(Not Parameters.kpGridOnTop){/ 	    fprintf(DotKICFileDesc1,"GridOnBottom\n");e 	    } 	if(Not Parameters.kpOutline){- 	    fprintf(DotKICFileDesc1,"No_Outline\n");  	    }# 	if(Parameters.kpDisplayAllLabels){r1 	    fprintf(DotKICFileDesc1,"DisplayAllText\n");i 	    }$ 	if(Parameters.kpLabelAllInstances){4 	    fprintf(DotKICFileDesc1,"LabelAllInstances\n"); 	    } 	PrintLRC(DotKICFileDesc1);n      	fclose(DotKICFileDesc1);  	}         /*      * cifplot pattern filea      */e     patbuf = String;M     if((patterns = POpen(CIFPLOT_PATTERNS, "r", (char *)NULL, (char **)NULL))N
 	== NULL){2 	ShowPrompt("Can't open cifplot pattern file.\n"); 	return; 	}1     if((cifplot = fopen("cifplot","w")) == NULL){m4 	ShowPrompt("Can't create cifplot pattern file.\n"); 	return; 	}     fprintf(cifplot, "\n");r     Layer = 0;$     while(++Layer <= NumLayerTable){' 	if(fscanf(patterns,"%s",patbuf) <= 0){i 	    rewind(patterns);
 	    --Layer;A 	    continue; 	    }+ 	if(LayerTable[Layer].klTechnology != ' '){t> 	    fprintf(cifplot, "\"%c", LayerTable[Layer].klTechnology); 	    for(i=0; i<3; ++i){( 		if(LayerTable[Layer].klMask[i] == ' ') 		    break; 		else: 		    fprintf(cifplot, "%c", LayerTable[Layer].klMask[i]); 		} ( 	    fprintf(cifplot, "\"%s\n", patbuf); 	    } 	}     fprintf(cifplot, "\n");'     fclose(patterns);;     fclose(cifplot);     }N     InitSignals(){
     int i;
 #ifdef vms     signal(SIGINT,CatchSIGINT);w #else}
 #ifdef SIGSETn?     sigset(SIGINT,CatchSIGINT);		/* use sigset() for 4.1 BSD */i #elsekG     signal(SIGINT,CatchSIGINT);		/* use signal() otherwise (4.2 BSD) */; #endif     signal(SIGHUP,Trap);     signal(SIGTSTP,Catch);     signal(SIGSTOP,Catch);     signal(SIGCONT,Catch); #endif&     Parameters.kpSIGINTERRUPT = False;  
 #ifndef DEBUGy     for(i=3;i<16;i++)f 	signal(i,Trap); #endif     }      Trap(n)T
     int n;     {d     char *mktemp();i     char buf[120];     signal(n,SIG_IGN);     FBEnd();(     strcpy(&buf[0],mktemp("KicXXXXXX"));     switch(n){
 	case SIGHUP: ! 	    fprintf(stderr,"hangup - ");P 	    break;r 	case SIGQUIT: 	    fprintf(stderr,"quit - ");i 	    break;%
 	case SIGILL:r. 	    fprintf(stderr,"illegal instruction - "); 	    break;e 	case SIGTRAP: 	    fprintf(stderr,"trap - ");f 	    break;s
 	case SIGIOT:%* 	    fprintf(stderr,"IOT instruction - "); 	    break;m
 	case SIGEMT:u* 	    fprintf(stderr,"EMT instruction - "); 	    break;e
 	case SIGFPE:L3 	    fprintf(stderr,"floating point exception - ");d 	    break;}
 	case SIGBUS:e$ 	    fprintf(stderr,"bus error - "); 	    break;r 	case SIGSEGV:1 	    fprintf(stderr,"segmentation violation - ");n 	    break;D
 	case SIGSYS:e6 	    fprintf(stderr,"bad argument to system call - "); 	    break;t 	case SIGPIPE:& 	    fprintf(stderr,"broken pipe - "); 	    break;I 	case SIGALRM:& 	    fprintf(stderr,"alarm clock - "); 	    break;  	case SIGTERM:6 	    fprintf(stderr,"software termination signal - "); 	    break; 	 	default:t% 	    fprintf(stderr,"unknown error");S 	    break;f 	}(     if(Parameters.kpCellName[0] != EOS){, 	if(Not CDUpdate(Parameters.kpCellDesc,buf))3 	    fprintf(stderr,"Can't save current cell.\n");; 	else 8 	    fprintf(stderr,"Current cell saved in %s.\n",buf); 	} #ifndef vms      /* creat the core file */t     signal(n,SIG_DFL);     if(kill(0,n) < 0){) 	fprintf(stderr,"Can't kill process!\n");{ 	} #endif     exit(1);     })    
 Catch(sig)     int sig;     {      TInit();
 #ifdef SIGVEC ;     sigsetmask(0);			/* for 4.2 BSD, must clear sig mask */n #endif #ifndef vmsa     signal(sig,SIG_DFL);     switch(sig){   	case SIGTSTP: 	case SIGSTOP: 	    FBHalt(); 	    if(kill(0,sig) < 0){ - 		fprintf(stderr,"Can't suspend process!\n");k
 		exit(1); 		}  	    break;c   	case SIGCONT: 	    FBInitialize(); 	    FullRedisplay();n 	    break;o 	} #endif     InitSignals();     }      CatchSIGINT(sig)     int sig;     {f
 #ifdef vms     signal(sig,CatchSIGINT); #endif     if(sig != SIGINT)t 	return;     /*?      * Parameters.kpINTERRUPT is set to False by InitSignals().aC      * We must return with it True to signify that we have receivedn      * an interrupt.      */G%     Parameters.kpSIGINTERRUPT = True;; #ifndef vmsS
 #ifdef SIGSET <     sigrelse(sig);			/* release the signal (4.1 BSD only) */ #endif #endif     return;s     },     MallocFailed(){ 
     char *cp;      char *mktemp();      cp = mktemp("KicXXXXXX");f%     if(CDStatusInt != CDMALLOCFAILED)n 	return;@     ShowPromptAndWait("OUT OF MEMORY.  This is a fatal error!");     FBEnd();(     if(Parameters.kpCellName[0] != EOS){+ 	if(Not CDUpdate(Parameters.kpCellDesc,cp))a> 	    fprintf(stderr,"Sorry.  Couldn't save current cell.\n"); 	else07 	    fprintf(stderr,"Current cell saved in %s.\n",cp);  	}     exit(1);     }e