 /*  * kic.h  *=  * Copyright -C- 1981 Kenneth H. Keller, Giles C. Billingsleys!  * sccsid "@(#)kic.h	1.1  9/5/83"c  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program ;  * KIC is available free of charge to any interested party.nB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,d  * is forbidden.  */s     l /*  * KIC data structures.I  * :  */    #include "macros.h"  #include <stdio.h> #include <setjmp.h>  #include "cd.h"r #include "fb.h"" #include "coords.h"s #include "extern.h"n   #define FBCONTROLe     /*1  * Size of memory blocks to be managed by nmallocn  */d #define NMALLOC_BLOCK_SIZE	4096k   /*9  * Size of the window/viewport stack for the current celle  */m #define VIEW_STACK_SIZE		15f   /*+  * Size of the storage for polygon verticess  */  #define	POLYGONBUFSIZE		600e #define	MAXPOLYGONVERTICES	300   /*  * Viewport control flags   */* #define SPLITSCREEN		'b' #define FINEVIEWPORTONLY	'f' #define COARSEVIEWPORTONLY	'c'   /*
  * Menu names   */t #define BASICMENU		'b' #define DEBUGMENU		'd' #define SELECTIONMENU		's' #define INSTANCEMENU		'i'/ #define ATTRIBUTESMENU		'a'  #define PROPERTYMENU		'p'm #define AMBIGUITYMENU		'A'     struct kl {{       /*7        * The following info is read from the .KIC file.s	        */ (       int klR,klG,klB;			/* RGB color */;       int klMinDimensions;		/* Minimum lambda dimensions */F/       int klFilled;			/* filled or outlined? */k8       int klStyle[8];			/* bit array for fill pattern */%       int klStyleID;			/* style ID */s<       int klCoarseStyleID;		/* style ID for Coarse window */8       int klFineStyleID;		/* style ID for Fine window */'       int klVisible;			/* visibility */t*       int klBlink;			/* blinking layer? */'       int klSymbolic;			/* symbolic? */G:       int klWireWidth;			/* wire width >= mindimensions */8       char klTechnology,klMask[3];      /* layer name */       };   int NumLayerTable;$ struct kl LayerTable[CDNUMLAYERS+1];   /*  * Cursor desc.   */r struct kc {        /*       In lambda units.       */"       int kcPredX,kcPredY,kcX,kcY;       int kcDX,kcDY;       int kcRow,kcColumn;a       } Cursor;    /*  * Area structure.  */. struct ka { (       int kaLeft,kaBottom,kaRight,kaTop;       int kaX,kaY;       float kaWidth,kaHeight;t       };   /*1  * Structure used to save windows in window stackl  */d struct kw {)       int kwLastWindowX;       int kwLastWindowY;       int kwLastWindowWidth;       int kwLastFineWindowX;       int kwLastFineWindowY;       char kwName[8];L       };   /*0  * Layout windows and the viewports they map to.  */" int FineViewportOnBottom;a% int FineWindowWidth,FineWindowHeight;(& struct ka CoarseViewport,CoarseWindow;3 struct ka LargeCoarseViewport,SmallCoarseViewport; {" struct ka FineViewport,FineWindow;   /*  * KIC text viewports.  */	 struct ka MenuViewport;B struct ka LayerTableViewport;  struct ka ParameterViewport;     /*  * Parameters that control KIC.n  */n struct kp {b(       /* Symbol desc for current cell */       struct s *kpCellDesc;          /*<        * Object desc for a geometry currently being created.;        * KIC special cases the input of polygons and wires.i	        */        struct o *kpPointer;  0       /* True if instances should be expanded */       int kpExpandInstances;  >       /* True if instance is expanded in fine viewport only */#       int kpExpandFineViewportOnly;f  O       /* If False then the SelectQ is never redisplayed (for fast Redisplay) */)#       int kpEnableSelectQRedisplay;d  '       /* Color ID's for command menu */n       int kpMenuTextColor;"       int kpMenuHighlightingColor;       int kpMenuSelectColor;  J       /* If True, user pointed inside layer table and Command[0] == EOS */       int kpPointLayerTable;  N       /* If True, user pointed inside coarse viewport and Command[0] == EOS */       int kpPointCoarseWindow;  %       /* Control of the Layer Menu */n       int kpNumLayerMenuRows;        int kpLayersPerMenuRow;i  -       /* Number of sides for round flashes */        int kpNumRoundFlashSides;e         /* Current layer */p       int kpLayer;  M       /* True if all selection commands (SELec and Area) are LayerSpecific */i#       int kpLayerSpecificSelection;i  9       /* If True, then outline all stippled geometries */        int kpOutline;  K       /* If True, polygon vertices are clipped to the nearest grid point */r       int kpClipVerticesToGrid;r  5       /* If True, put grid below layout geometries */r       int kpGridOnTop;  9       /* If True, grid will be shown in large viewport */ $       int kpShowGridInLargeViewport;         /* Color ID's for grid */a       int kpCoarseGridColor;       int kpFineGridColor;  <       /* Number of RESOLUTION*lambda between grid points. */       int kpGrid;a  2       /* True if current cell has been modified */       int kpModified;   /       /* Parameters for modifying geometries */;       int kpModifyLeft;;       int kpModifyTop;  '       /* Bounds of coordinate system */ &       int kpMaxX,kpMaxY,kpMinX,kpMinY;         /* Debug parameters */       int kpNumGeometries;  2       /* If True, then show redisplay bandwidth */       int kpShowBandwidth;   #ifdef FBCONTROL       int kpEnableFB;; #endif  ?       /* If True, user has just pressed the interrupt key    */o       int kpSIGINTERRUPT;C         /*N        * == COARSEVIEWPORTONLY if coarse window-viewport should be redisplayedJ        * == FINEVIEWPORTONLY if fine window-viewport should be redisplayed5        * == SPLITSCREEN if both should be redisplayedt       */       int kpRedisplayControl;*  B       /* If True, Fine Viewport (Magnifying Glass) is displayed */        int kpDisplayFineViewport;  *       /* If True, all text is displayed */       int kpDisplayAllLabels;c  B       /* If True, all instances will be labeled in the viewport */       int kpLabelAllInstances;  ;       /* If True, instances will be marked when selected */         int kpShowInstanceMarkers;         /*L        * PointingThreshold is the minimum value of ViewportWidth/WindowWidthJ        * such that it is still comfortable to point with lambda precision.	        */h       int kpPointingThreshold;         /*E        * PixToLambdaSnapping is RESOLUTION times the number of lambda A        * between points to which a cursor input point is snapped.i	        */e        int kpPixToLambdaSnapping;$       int kpHalfPixToLambdaSnapping;  C       /* True if wires and polygons should be constrained to 45s */        int kp45s;  7       /* Current transform defined in Selection menu */ 3       int kpRotationAngle;	/* 0, 90, 180, or 270 */t       int kpMX;        int kpMY;   A       /* At what level in the hierarchy are we?  See Redisplay */c       int kpHierarchyLevel;l         /*A        * Window stack.  kpWindowStack[0] is always the last view.l>        * If kpNumWindows is zero, only the last view is saved.	        */s/       struct kw kpWindowStack[VIEW_STACK_SIZE];<       int kpNumWindows;p  5       /* Background and Highlighting color control */s       int kpHighlightingPixel;       int kpHighlightingRed;       int kpHighlightingGreen;       int kpHighlightingBlue;M       int kpBackgroundRed;       int kpBackgroundGreen;       int kpBackgroundBlue;e          /* used in Attributes.c */       int kpSetBackgroundColor;r!       int kpSetHighlightingColor;O  (       /* Symbol name for current cell */       char kpCellName[80];  5       /* Command selected if any from command menu */E       char kpCommand[80];O         /*        * Current command menu 2        *     == INSTANCEMENU denotes instance menu5        *     == ATTRIBUTESMENU denotes attribute menu/2        *     == PROPERTYMENU denotes property menu,        *     == BASICMENU denotes basic menu4        *     == SELECTIONMENU denotes selection menu,        *     == DEBUGMENU denotes debug menu4        *     == AMBIGUITYMENU denotes ambiguity menu	        */m       char kpMenu;         } Parameters;d   /*
  * KIC menus.i  */*   #ifdef Allocatel char *BasicMenu[] = {r       "     ",
       "EDit",t       "DIR",
       "SAve",        "WRite",       "     ",       "ATtri",       "Insta",       "SElec",       "PRpty",       "     ",       "RDraw",       "EXpnd",
       "PEek",n       "PAn",       "Zoom",        "WINdo",
       "VIEw",e
       "LASt",e       "     ",       "45s",
       "Grid",*
       "SNap",o       "BOXes",       "WIRes",       "WIDth",       "POLyg",       "DOnut",       "FLASh",       "ARC",       "LABel",
       "Undo",*       "     ",
       "LYra", 
       "TECh",        "ABort",
       "DEBug"w       };4 int NumBasicMenu = sizeof(BasicMenu)/sizeof(char *); #elseo char *BasicMenu[]; int NumBasicMenu;* #endif   #ifdef Allocatei char *InstanceMenu[] = {       "     ",       "BAsic",
       "SAve",w       "WRite",       "     ",       "RDraw",       "EXpnd",
       "PEek",p       "PAn",
       "Zoom",m       "WINdo",
       "LASt",f       "     ",       "MASte",
       "Undo",s       "#X",n       "#Y",        "DX",t       "DY",f       "MX",t       "MY",        "0    ",       "90   ",       "180  ",       "270  ",       "     ",       "LAYer",
       "AREa",v       "SElec",       "DESel",
       "MOve",        "DELet",       "FLATn",       "     ",
       "PUsh",.       "POP"c       };: int NumInstanceMenu = sizeof(InstanceMenu)/sizeof(char *); #elses char *InstanceMenu[];  int NumInstanceMenu; #endif   #ifdef AllocateZ char *AttributeMenu[] = {s       "     ",       "BAsic",       "UPdat",       "RDraw",       "     ",       "VISib",       "FIlle",       "BLink",       "DIMen",       "     ",       "Outln",       "LABel",       "Insta",
       "MARk",n       "SIdes",
       "Grid", 
       "MEnu",e       "     ",       "BGrnd",       "HLite",       "     ",       "ADLyr",       "RMOve",       "     ",       "+R",o       "-R",r       "+G",        "-G",C       "+B",        "-B",m       "RGb"        };< int NumAttributeMenu = sizeof(AttributeMenu)/sizeof(char *); #elseC char *AttributeMenu[]; int NumAttributeMenu;E #endif   #ifdef Allocate  char *SelectionMenu[] = {U       "     ",       "BAsic",
       "SAve",R       "WRite",       "     ",       "RDraw",       "EXpnd",
       "PEek",        "PAn",
       "Zoom",o       "WINdo",
       "LASt",        "     ",       "45s",       "BOXes",       "WIRes",       "WIDth",       "POLyg",       "LABel",
       "Undo",        "     ",       "LAYer",
       "AREa",        "SElec",       "DESel",       "CHlyr",       "DELet",       "     ",       "STPth",       "STBox",>       "LEft ",		/* NOTE!!!!! SelectionMenu[31] is rewritten */(       "TOp  ",		/* in select.c				    */       "     ",
       "MOve", 
       "COpy",        "MX",        "MY", F       "0    ",          /* NOTE!!!!! SelectionMenu[37] is rewritten */F       "     ",          /* in select.c and instance.c               */
       "PUsh",        "POP"        };< int NumSelectionMenu = sizeof(SelectionMenu)/sizeof(char *);   #else  char *SelectionMenu[]; int NumSelectionMenu;  #endif   #ifdef Allocate  char *DebugMenu[] = {e       "     ",       "BAsic", #ifdef FBCONTROL       "FB",[ #endif       "BW",;
       "ALloc"i       };4 int NumDebugMenu = sizeof(DebugMenu)/sizeof(char *); #elses char *DebugMenu[]; int NumDebugMenu;u #endif   #ifdef Allocatem char *PropertyMenu[] = {       "     ",       "BAsic",       "     ",       "LAYer",
       "AREa",y       "SElec",       "DESel",       "     ",
       "SHow",        "ADPrp",
       "RMPrp"M       };: int NumPropertyMenu = sizeof(PropertyMenu)/sizeof(char *); #else; char *PropertyMenu[];h int NumPropertyMenu; #endif   /*8 81 should be MenuViewport.kaBottom-MenuViewport.kaTop+1. */ char *AmbiguityMenu[81]; int NumAmbiguityMenu;r   #ifdef Allocate  char *MenuEDIT  = "EDit";I char *MenuDIR   = "DIR"; char *MenuSAVE  = "SAve";Y char *MenuWRITE = "WRite"; char *MenuATTRI = "ATtri"; char *MenuINSTA = "Insta"; char *MenuPRPTY = "PRpty"; char *MenuMARK  = "MARk";P char *MenuSELEC = "SElec"; char *MenuRDRAW = "RDraw"; char *MenuVIEW  = "VIEw";  char *MenuEXPND = "EXpnd"; char *MenuPEEK  = "PEek";  char *Menu45S   = "45s"; char *MenuGRID  = "Grid";  char *MenuSNAP  = "SNap";i char *MenuBOXES = "BOXes"; char *MenuWIRES = "WIRes"; char *MenuWIDTH = "WIDth"; char *MenuPOLYG = "POLyg"; char *MenuDONUT = "DOnut"; char *MenuARC   = "ARC"; char *MenuFLASH = "FLASh"; char *MenuLABEL = "LABel"; char *MenuUNDO  = "Undo";  char *MenuPAN   = "PAn"; char *MenuZOOM  = "Zoom";  char *MenuWINDO = "WINdo"; char *MenuLAST  = "LASt";s char *MenuPUSH  = "PUsh";i char *MenuPOP   = "POP"; char *MenuLYRA  = "LYra";g char *MenuTECH  = "TECh";d char *MenuABORT = "ABort"; char *MenuDEBUG = "DEBug"; char *MenuBASIC = "BAsic"; char *MenuMASTE = "MASte"; char *MenuNUMX  = "#X";R char *MenuNUMY  = "#Y";  char *MenuDX    = "DX";, char *MenuDY    = "DY";W char *MenuMX    = "MX";  char *MenuMY    = "MY";e char *Menu0     = "0    "; char *Menu90    = "90   "; char *Menu180   = "180  "; char *Menu270   = "270  "; char *MenuLAYER = "LAYer"; char *MenuAREA  = "AREa";  char *MenuDESEL = "DESel"; char *MenuDELET = "DELet"; char *MenuMOVE  = "MOve";  char *MenuUPDAT = "UPdat"; char *MenuVISIB = "VISib"; char *MenuFILLE = "FIlle"; char *MenuBLINK = "BLink"; char *MenuDIMEN = "DIMen"; char *MenuOUTLN = "Outln"; char *MenuMENU  = "MEnu";  char *MenuSIDES = "SIdes"; char *MenuBGRND = "BGrnd"; char *MenuHLITE = "HLite"; char *MenuADLYR = "ADLyr"; char *MenuRMOVE = "RMOve"; char *MenuPLUSR = "+R";  char *MenuMINSR = "-R";  char *MenuPLUSG = "+G";  char *MenuMINSG = "-G";s char *MenuPLUSB = "+B";  char *MenuMINSB = "-B";  char *MenuRGB   = "RGb"; char *MenuSTBOX = "STBox"; char *MenuSTPTH = "STPth"; char *MenuLEFT  = "LEft "; char *MenuTOP   = "TOp  "; char *MenuBOTTM = "BOTtm"; char *MenuRIGHT = "RIght"; char *MenuCOPY  = "COpy";  char *MenuFLATN = "FLATn"; char *MenuCHLYR = "CHlyr"; #ifdef FBCONTROL char *MenuFB    = "FB";  #endif char *MenuBW    = "BW";  char *MenuALLOC = "ALloc"; char *MenuADPRP = "ADPrp"; char *MenuRMPRP = "RMPrp"; char *MenuSHOW = "SHow"; #elseu char *MenuEDIT;e char *MenuDIR; char *MenuSAVE;p char *MenuWRITE; char *MenuATTRI; char *MenuINSTA; char *MenuPRPTY; char *MenuMARK;  char *MenuSELEC; char *MenuRDRAW; char *MenuVIEW;* char *MenuEXPND; char *MenuPEEK;  char *Menu45S; char *MenuGRID;i char *MenuSNAP;T char *MenuBOXES; char *MenuWIRES; char *MenuWIDTH; char *MenuPOLYG; char *MenuDONUT; char *MenuARC; char *MenuFLASH; char *MenuLABEL; char *MenuUNDO;r char *MenuPAN; char *MenuZOOM;u char *MenuWINDO; char *MenuLAST;  char *MenuPUSH;e char *MenuPOP; char *MenuLYRA;  char *MenuTECH;* char *MenuABORT; char *MenuDEBUG; char *MenuBASIC; char *MenuMASTE; char *MenuNUMX;I char *MenuNUMY;h
 char *MenuDX; 
 char *MenuDY;*
 char *MenuMX;n
 char *MenuMY;u char *Menu0;
 char *Menu90;S char *Menu180; char *Menu270; char *MenuLAYER; char *MenuAREA;  char *MenuDESEL; char *MenuDELET; char *MenuMOVE;  char *MenuUPDAT; char *MenuVISIB; char *MenuFILLE; char *MenuBLINK; char *MenuDIMEN; char *MenuOUTLN; char *MenuMENU;A char *MenuSIDES; char *MenuBGRND; char *MenuHLITE; char *MenuADLYR; char *MenuRMOVE; char *MenuPLUSR; char *MenuMINSR; char *MenuPLUSG; char *MenuMINSG; char *MenuPLUSB; char *MenuMINSB; char *MenuRGB; char *MenuSTBOX; char *MenuSTPTH; char *MenuLEFT;u char *MenuTOP; char *MenuBOTTM; char *MenuRIGHT; char *MenuCOPY;  char *MenuFLATN; char *MenuCHLYR; #ifdef FBCONTROL
 char *MenuFB;  #endif
 char *MenuBW;u char *MenuALLOC; char *MenuADPRP; char *MenuRMPRP; char *MenuSHOW;; #endif