8 .\	/*	kicref.ms: programmer's manual for KIC program		*/ .\	/*								*/ / .\	/*	sccsid "@(#)kicref.ms	1.2  9/4/83"					*/  .\	/*								*/ ; .de s4	\"Macro to reduce line spacing in C program listings3 .if t .vs -6 .if n .vs -3 .. .TM0 .ND0 .TL  .ps +4 PROGRAM REFERENCE FOR KIC0 .ps0 .AU0 Giles C. Billingsley .AI4 .vs 14 Electronics Research Laboratory 6 Electrical Engineering and Computer Science Department University of California Berkeley, California 94720	 .nr VS 12  .AB0D The internal structure of the KIC interactive, color graphics editorF is explained in this report.  The database, user interface, and systemA dependencies are examined, and information is presented to assist08 the programmer who would wish to extend the KIC program. .AE3	 .nr VS 122 .XS  \fBChapter 1:  Introduction\fR .XE0 .DS C  .ps +4 .B "Chapter 1" .ps  .DE  .sp 1  .DS C0 .ps +4 .B "Introduction"1 .ps8 .DE1 .sp 20 .PP L KIC [1,2] is an interactive, two-dimensional, color graphics editor intended; primarily for the mask level design of integrated circuits. @ It is written in the C programming language and runs in either a .I "UNIX"\** .FS2) UNIX is a trademark of Bell Laboratories.  .FE0 or .I "VMS"\**0 .FS - VMS is a trademark of Digital Equipment Corp.0 .FE0 environment. .PP ? KIC has been designed as a powerful, inexpensive, user-friendly H graphics editor that will run on most low to medium performance graphicsB terminals.  Data that is generated by KIC can be represented by an6 intermediate graphic description language, such as CIF$ (Caltech Intermediate Form) or Calma .I "STREAM,"\**0 .FS $ STREAM is a trademark of Calma, Inc. .FE H which permits the data to be easily transported to other layout systems.J Also, the geometric database used by KIC can be used to interface to other3 tools, such as a layout rules checking program [8].  .PP H The internal structure of the KIC program is described in detail in thisD report.  The reader must be familiar with the C programming language as defined in [3] or [9].0I Other KIC documentation includes a database manual and a user's tutorial,4@ both included as appendices to this report.  A programmer shouldM be thoroughly familiar with this report and these two appended manuals before09 attempting an addition or enhancement to the KIC program.0 .PP0G KIC can be viewed as four major subsystems, as illustrated in Figure 1. ! .de f1  \"Figure 1 for nroff only  .nf  .s4; .ne 42                   _;       pointing | |        device  |_|#                 \\     ------------ #                  \\    |          | #                   \\   | Graphics |2#                    \\__| Terminal |0"                       |          |"                       ------------                             | (                  ...........|...........(                  . KIC      |          .(    ----------    .    -------------    .(    | MFBCAP |-------->|Model Frame|    .(    |Database|    .    |   Buffer  |    .(    ----------    .    -------------    .(                  .          |          .(                  .  -----------------  .(                  .  |Window/Viewport|  .(                  .  |    Manager    |  .(                  .  -----------------  .(                  .          |          .(                  .   ---------------   .(                  .   | CD Database |   .(                  .   |             |   .(                  .   | ----------- |   .(                  .   | |Fast  CIF| |   .F                  .   | |  Parser | |   .                    ----------H                  .   ---------------   .      KICToCIF     /  Other   \\G                  .          |          .  ---------------->|   CIF    |0H                  ...........|...........  |   CIFToKIC     \\ Variants /F                             |             |                 ----------+                             |             | D                         ---------         |                 --------G                        /   KIC   \\<--------   KICToSTRM    / Calma  \\ E                        |  or CD  |<----------------------->| STREAM |mG                        \\  Files  /            STRMToKIC    \\ Format / D                         ---------                           --------   .fi3 .." .de f2  \"Figure 1 label for nroff .DS CT .B "Figure 1." .DEE .. .de f3  \"Figure 1 for troff .KFB .sp 5.5i .ce 1   \fBFigure 1.  The KIC system.\fR .sp 2  .KEr ..	 .if n .eog	 .if n .f1e	 .if n .ece	 .if n .f2n	 .if t .f3  .PPo KIC uses the .I CDo (CIF Database)I relation database system that manages a set of files.  Each file containslE the definition of a layout-cell that is stored as an ASCII CIF symboliI description [5].  A cell definition can contain instances of other cells,rG and thus the database supports hierarchical layout descriptions.  OthernD layout formats, such as Calma STREAM format, can be obtained from CDF translation routines [11].  The CD database package reads these layoutD descriptions from disc files and transforms them into virtual-memoryC data structures.  This package is described in detail in Chapter 2. F A major part of this process concerns the parsing of CIF data from theK resident disk files.  A fast CIF parser has been developed for this purpose  and is described in Chapter 3. .PP C KIC is designed to run on a wide range of raster graphics terminals > or frame buffers and indeed has been used with several devicesH including the AED 512 and 767, the Tektronix 4113 and 4105, the HP2648A,> the Metheus Omega-400, and the Masscomp MC500 series computer. KIC uses the notion of an  .I idealD color graphics frame buffer, and a separate package of routines maps commands for this  .I idealI frame buffer to the real device.  This package can be a set of hard-coded , routines for the particular terminal, or the .I "Model Frame Buffer" J (MFB) package can be used.  MFB is a terminal independent graphics packageG that uses an ASCII database file (MFBCAP) to represent the frame buffer 7 characteristics in an extended UNIX termcap format; see| .I "termcap(5)"  and  .I "curses(3)"L in the BSD UNIX programmer's manual.  MFBCAP and the associated MFB routinesF are documented in Appendix D and E.  A description of how to interface; KIC to a new graphics terminal is contained in Section 4.6.n .bp  .XS ! \fBChapter 2:  The CD Database\fR  .XE  .DS C  .ps +4 .B "Chapter 2" .ps  .DE  .sp 1  .DS C  .ps +4 .B "The CD Database" .ps- .DE- .sp 2  .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	2.1. Introduction .XEC .SH  2.1. Introduction  .PP  CD (CIF Database)rK is a package of C procedures for managing CIF databases at an object level; K geometric objects are modeled as CIF geometries and grouped as CIF symbols. 6 For a description of the CIF language, see [4] or [5].D The KIC program is only one application of the CD database package, A other applications including language conversion programs betweent% KIC/CD format, CIF, and Calma STREAM.i .PPfF Because the data model of CD is CIF, the CD database inherits both theM advantages and limitations of the CIF language.  As an example, one importantaF feature of CIF is that it is hierarchical.  However, called and placedD symbols can not be magnified or arrayed without adopting nonstandardB extensions of the language.  Such limitations are described in the! various sections of this chapter.r .PPI= The reader should be aware of the following CD terminology: a 	 .I masterD, refers to the definition of a symbol, and an .I instance 3 refers to a call and placement of a symbol within ar
 .I master. To explain the phraseo .I "traversing a symbol,"i: think of the symbol as a tree structure where each element, is an instance that is linked to its master.B A procedure that traverses a symbol would visit each branch of the+ symbol-instance tree structure.  Finally, an	 .I lambdaFM coordinate is one that is within the coarse resolution of CD; for example, iffD the CD database unit is one one-hundredth of a micron and the coarse@ resolution of CD is one hundred database units, then the minimum: lambda value is one micron.  This coarse resolution allowsA coordinates to be represented as integers while providing a finer - resolution when smooth contours are required.  .PPc When a symbol is opened via ther
 .I "CDOpen()"hH routine, it is mapped into main memory from local or library files, each" storing one CIF symbol definition.8 Also, all symbols that are called by the symbol are readC into main memory.  A symbol that has been opened is referenced by a  .I "symbol descriptor"F defined in the next section.  To reflect at its secondary storage siteC the changes to a symbol that has been opened, a program invokes thed .I "CDUpdate()"sC routine.  To remove open symbol unknown from CD (i.e., to remove ito( from main memory), a program invokes the .I "CDClose()" routine. .PPiE Geometries or objects are collectively organized in a symbol or cell.n6 The types of valid objects within a symbol are boxes, D polygons, wires, round flashes, and symbol calls or instance arrays.5 For each object there is a procedure that creates thea4 object in a particular symbol on a particular layer.! These data insertion routines arem1 .I "CDMakePolygon(), CDMakeWire(), CDMakeBox(), "u ands .I "CDMakeRoundFlash()." The CIFf .I calll, has been extended to handle instance arrays.2 To create an instance array, a program invokes the .I "CDBeginMakeCall(), CDT(), "g andv .I "CDEndMakeCall()"B procedures.  All object creation procedures return a pointer to an .I "object descriptor"D that has the purpose of referencing the object in the database.  The .I "CDDelete()"a/ procedure removes an object from a master cell.s .PPaG There are several routines for acquiring or storing information that isa/ specific to a particular object or symbol.  Theh .I "bounding box"i% of an object  can be accessed via the  .I "CDBB()"hE routine.  Associated with each object is an integer information fieldi that can be accessed by thes .I "CDSetInfo()" and 
 .I "CDInfo()" 1 routines for extending that object's description.yD In addition to the integer information field, each object can have a9 linked-list of property strings that are accessed via theh .I "CDAddProperty()" anda .I "CDProperty()"m procedures.c .PP L CD uses a two dimensional, rectilinear or "Manhattan" transformation packageK that can be used by any CD application program.  The transformation packagesG is described in Section 2.5.  With the transform package, a program candJ define a current transformation composed of translations, reflections, andB rotations, obtain the transformation and inverse transformation ofL coordinates, and manage several transformations with a transformation stack. .PP 7 Traversing the contents of a master is performed with an .I "object generator loop." K In the context of CD, an object generator is a set of procedures that allowfE the program to sequentially access objects on a particular layer thataN intersect a particular area.  To begin a generator, a program would invoke the .I "CDInitGen()"D routine with an area of interest and a specific layer as parameters.( The procedure will return a pointer to a .I "generator descriptor,"5 defined in the next section.  Every invocation of then .I "CDGen()"B procedure will then return a pointer to an object descriptor whose9 bounding box, transformed by the current transformation, m; intersects the area and lies on the particular layer.  Whene .I "CDGen()"C has returned all objects that qualify, the procedure returns a nulld! pointer to the object descriptor.n .PPr The 
 .I "CDType()" N procedure returns the type of an object descriptor, (e.g., box, polygon, etc.)I and can be used to dispatch to a type-specific procedure for manipulatingi the object.e .PP A CD provides several routines for translating to or from CIF.  Theb .I "CDTo()" / routine translates CIF directly into CD format.o
 .I "CDFrom()"c1 translates a CD symbol hierarchy into a CIF file.u	 Also, thev .I "CDParseCIF()"d@ procedure will build the CD database from a CIF file rather than! from a directory of symbol files.sE This latter procedure is useful for translating CIF into other layoutoM languages such as Calma STREAM.  These routines are explained in Section 2.7.t .bp  .XSe. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	2.2. CD Descriptor Typese .XEo .SHs 2.2. CD Descriptor Types .PPr? There are several descriptor types defined as structures in thes
 cd.h file. .bre .s4  .nfi   .ne 16J .if t .ta \w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXX      'u +\w'XXXXXX'uD .if n .ta \w'XXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXX      'u +\w'XXXXXX'u% 	\fBdescriptor type	structure name\fRU
 	symbol		s 	symbol table		buP 	master-list		me
 	object		o
 	label		la 	polygon		po 	round flash		rd 	wire		w 	call		c
 	transform		t 
 	generator		gc 	property		prpty	 	layer		lc 	path		p   .fi  .vs  .rsa .DT2 .PPeJ The following sections describe the various descriptors in greater detail. .ne 9  .XS4. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.2.1. The Symbol Descriptor .XE  .SHX 2.2.1. The Symbol Descriptor .PP ' The symbol descriptor is defined in the 	 .I "cd.h"  file as follows: .brp .s4u .nfa  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uM .ne 14 	/*M .ta \w'XXXXXXXXX'u 	* Symbol desc.a 	*/"= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uy 	struct s { # 		int sLeft, sBottom, sRight, sTop;t 		int sBBValid;k
 		int sA, sB;  		char *sName; 		short sInfo;" 		struct o ***sBin[CDNUMLAYERS+1]; 		struct m *sMasterList; 		struct prpty *sPrptyList;  		};   .fip .vse .rse .PPc? A symbol descriptor is associated with each symbol that resides D in the database and is necessary for accessing the objects contained7 in the respective symbol.  This descriptor is allocatedu and initialized by the
 .I "CDOpen()"o  routine only and released by the .I "CDClose()"H routine.  All current symbol descriptors are referenced in the CD symbolD table; the symbol table descriptor is described in the next section. .PPs Thel .I sNameH member is a pointer to a null-terminated character string containing the name of the respective symbol.9 The bounding box of the symbol in coordinates is given by  .I "sLeft, sBottom, sRight, "r andp
 .I "sTop."J Because the bounding box of the symbol depends on the objects contained inF the symbol, there is a time (for example, when the CIF is being parsed or the symbol is being opened)E when the bounding box is not valid.  This condition is flagged by ther .I sBBValidb( boolean member of the symbol descriptor. .PPn Them .I sAc ando .I sBl6 members define the magnification factor of the symbol.< KIC and the CD database do not permit symbol magnification, 4 and therefore these members are always set to unity.B If such a feature is added to KIC, it should be done at the symbol? level rather than at the object level to be consistent with theeF CIF data model.  For example, the magnification factor of any geometry< or instance in a symbol would always be unity.  However, theF magnification factor of a symbol definition that is called by another I would not necessarily have to be unity.  This symbol magnification factors2 would be defined by a ratio of two integers in the .I DS M command in the respective symbol file and these two integers would become the  .I sAt andc .I sBeA members in the symbol descriptor when the symbol is opened by CD.h .PPlJ The objects contained in a symbol are organized in a storage bin structure3 that is explained in greater detail in Section 2.3. G In brief, the storage bins are a three dimension array of doubly linked I object descriptor lists; each object list is indexed in the array of bins: according to its layer3 and the lower, left coordinate of its bounding box.X .I sBinnH is a pointer to the symbols storage bins.  The bin structure is declaredP as a triple star ( \fI***sBin[CDNUMLAYERS+1]\fR ) because the bins are allocatedB on demand for each layer with layer zero being the instance layer. .PP  .I sInfoD is the integer information field of the symbol and is initialized to	 zero, andy
 .I sPrptyList 1 is a pointer to the symbol property list.  If thee
 .I sPrptyListe, pointer is NULL, the property list is empty. .I sMasterListL is a pointer to the symbol's master-list that is explained in greater detail below. .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u# 		2.2.2. The Master-List Descriptor  .XEh .SHI .ne 9)! 2.2.2. The Master-List Descriptoro .PP , The master-list descriptor is defined in the	 .I "cd.h"  file as follows: .br  .s4  .nfD  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ua .ne 10 	/*e .ta \w'XXXXXXXXX'u 	* Master-list desc. 	*/e= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  	struct m {e 		int mReferenceCount;# 		int mLeft, mBottom, mRight, mTop;  		char *mName; 		struct m *mPred, *mSucc; 		};   .fii .vsc .rs  .PPcP Every symbol in CD has one master-list.  The master-list is a doubly linked-list@ of structures containing one link for each symbol that is called by the respective symbol.o Thep .I mName2 member is a pointer to a null-terminated character0 string containing the name of the called symbol.= The number of times that the symbol is referenced is given byo .I mReferenceCount.r8 The untransformed bounding box of the symbol is given by .I "mLeft, mBottom, mRight, "c andt .I mTop. Note that if symbola .I mName" was opened by an invocation of the
 .I "CDOpen()"cD routine, the bounding box of the returned symbol descriptor would be identical to .I "mLeft, mBottom, mRight, "e and  .I mTop. .PP"I The purpose of the master-list is to simplify the procedure of reflectingeD any change to the bounding box of an instance in the bounding box of7 all its masters.  For a brief example, consider symbolsl .B X andc .B Y" that contain an instance of symbol .B Z." If the bounding box of symboll .B Z is changed, a call to thet .I "CDReflect()"' procedure with the symbol descriptor ofC .B ZJ as an argument would cause the master-list of every resident symbol in the CD database, except symbol .B Z,n# to be searched for an occurrence ofr .B Z.t When an instance ofh .B ZJ is found, the bounding box of the instance, as specified in the respective master-list structure member,b4 is compared with the computed bounding box of symbol .B Z;eF if there is a difference, the master-list is modified and the bounding' box of the master symbol is recomputed.dB At the completion of this procedure, the bounding boxes of symbols .B X and  .B YF will have been recomputed to reflect the change in the bounding box of .B Z.s In other words, thet .I "CDReflect()"% routine has the purpose of performing  .I "bounding box propagation"i< which is further explained in Section 2.4.9 on CD integrity. .PPiC The symbol call descriptor also contains a pointer to a master-list\F descriptor.  This is further explained in Section 2.4.4 that describes  the CD object creation routines. .XSt. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u$ 		2.2.3. The Symbol Table Descriptor .XEw .SHb .ne 9 " 2.2.3. The Symbol Table Descriptor .PPwB The CD symbol table and symbol table descriptor are defined in the	 .I "cd.h"t file as follows: .brX .s4' .nf'  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uf .ne 11 	/*  .ta \w'XXXXXXXXX'u5 	* Hash table of symbol descs keyed on symbol's name.S 	*/ = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ue 	struct bu { 		struct s *buSymbolDesc;e 		struct bu *buPred; 		struct bu *buSucc; 		};  ) 	struct bu *CDSymbolTable[CDNUMLAYERS+1];b   .fih .vsI .rse .PPb5 The procedure by which CD remembers a resident symbolc6 is a hash table of symbol descriptors that is keyed on" the name of the respective symbol." Each entry in the hash table named .I CDSymbolTable+ is a null-terminated, doubly linked-list ofL .I buo? structures that contain a pointer to an open symbol descriptor. M A procedure for computing the entry point into the hash table is shown below:f .brr .s4e .nfb  H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u .ne 15 	#include "cd.h" .if n .sp 2e   	/*i .ta \w'XXXXXXXXX'u 	* Function GetSymbol()n: 	* Find and return the symbol descriptor of symbol 'Name'. 	*/fH .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	struct s *GetSymbol(Name)4 		char *Name;			/* name of the symbol to be found */ 		{s
 		int Key;
 		char *cp 		struct bu *Bucket;   .if n .sp 2e .ne 10 		cp = Name; 		while(*cp != NULL) 			Key += (int)( *cp++ );t. 		Bucket = CDSymbolTable[ Key % CDNUMLAYERS ]; 		while(Bucket != NULL){5 			if(strcmp(Bucket->buSymbolDesc->sName, Name) == 0)n! 				return(Bucket->buSymbolDesc);n 			Bucket = Bucket->buSucc;r 			} 		}g   .fi  .vs" .rs, .DTt .SHR .ne 9r 2.2.4. The Object Descriptor .PPn' The object descriptor is defined in thee	 .I "cd.h"e file as follows: .br  .XSt. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.2.4. The Object Descriptor .XEt .s4u .nf   = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ub .ne 13 	/*b .ta \w'XXXXXXXXX'u 	* Object desc.h 	*/I= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ut 	struct o {I# 		int oLeft, oBottom, oRight, oTop;y
 		char oType;i 		char oLayer; 		short oInfo; 		struct o *oPred, *oSucc; 		struct o *oRep;s 		struct prpty *oPrptyList;o 		};   .fib .vse .rsa .PPtA One object descriptor is associated with each object in a symbol. B This descriptor is allocated and initialized by an object-specific routine (e.g.,  0 .I "CDMakeBox(), CDMakeWire(), CDMakePolygon()," etc. ).y: An object descriptor is released only by invocation of the .I "CDDeleteObjectDesc()"i routine. .PPi Then .I oTypeD member is a character that identifies the type of the object and can1 assume any of the following values defined in thew	 .I "cd.h"  file:I .br  .s4  .nfe  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u G .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uh .ne 10 	/*e .if t .ta \w'XXXXXXXXX'u .if n .ta \w'XXXXX'u 	* Types of geometries 	*/dK .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'usG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u  	#define	CDSYMBOLCALL	'c'r 	#define	CDPOLYGON	'p' 	#define	CDROUNDFLASH	'r'y 	#define	CDLABEL	'l' 	#define	CDWIRE	'w'  	#define	CDBOX	'b'   .fi  .vso .rsg .PP * The bounding box of the object is given by .I "oLeft, oBottom, oRight, "t andu .I oTop.4 The layer on which the object exists is specified by
 .I oLayer., When the object descriptor is allocated, the .I oRepwJ pointer is cast as a pointer to an object-specific descriptor that extends/ the definition of the respective object;  these A object specific descriptors are defined in Section 2.4.4 concernsX the object creation routines.) .PPh .I oInfoN is the integer information field of the symbol and is initialized to zero, and
 .I oPrptyListi9 is a pointer to the null-terminated object property list.K The pointers .I oPred andk .I oSucc= are used to access the previous and successive objects in the(< doubly linked-list of objects that constitute a storage bin. .XS-. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u! 		2.2.5. The Generator Descriptort .XER .SH  .ne 9. 2.2.5. The Generator Descriptorh .PPe* The generator descriptor is defined in the	 .I "cd.h"o file as follows: .br  .s4X .nf\  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uX .ne 10 	/*  .ta \w'XXXXXXXXX'u 	* Generator desc. 	*/\= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uc 	struct g {I# 		int gLeft, gBottom, gRight, gTop;X- 		int gBeginX, gX, gEndX, gBeginY, gY, gEndY;  		char gLayer; 		struct o *gPointer;o 		};   .fir .vse .rs	 .PP 	 An objectt .I generatorL in the context of CD is a set of procedures for acquiring object descriptorsG for all objects on a specific layer and in a specific area of interest.y Invocation of thep .I "CDInitGen()"5 will return a pointer to an allocated and initialized " generator descriptor that contains> all the status information for the operation of the generator.L More specifically, the generator descriptor stores information that includes@ the area of interest, the storage bins that are to be searched, E and the present position in the storage bin currently being searched.i .PP  .I "gLeft, gBottom, gRight," andX .I gTop\$ defines the area where the generated objects should reside, and	 .I gLayerXH is the layer on which the generated objects should exist with layer zero being the instance layer.X Theu .I "gBeginX, gEndX"i and* .I "gBeginY, gEndY"X@ members define the range of the storage bins to be searched, and .I gXX and  .I gYX= define the storage bin that is currently being searched.  TheC .I gPointere? member is a pointer to an object descriptor in the storage bins'G and points to the descriptor where the next search sequence will begin.h .XSn. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u! 		2.2.6. The Transform Descriptor  .XEa .SHn .ne 4t 2.2.6. The Transform Descriptor  .PPaD The CD package uses only rectilinear or "Manhattan" transformations.L In CD, a transformation is characterized by a null-terminated linked-list of transformation descriptors.r* The transform descriptor is defined in the	 .I "cd.h"  file as follows: .bra .s4o .nfs  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'un .ne 12 	/*  .ta \w'XXXXXXXXX'u 	* Transform desc.9 	* If MX, tType == CDMIRRORX.  If MY, tType == CDMIRRORX.\? 	* If R, tType == CDROTATE, tX == XDirection, tY == YDirection. 1 	* If T, tType == CDTRANSLATE, tX == TX, tY = TY;s 	*/ = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ut 	struct t {l
 		char tType;'
 		int tX, tY;w 		struct t *tSucc; 		};   .fi  .vsX .rs+ .PPX! The transformation that is calledX .I "Mirroring in X"s= is an operation that effectively multiplies all x-coordinates\N by -1, or, in other words, mirrors in the direction of x.  This transformationL can be confusing because it is also identical to a reflection in the y-axis.+ Likewise, the transformation that is calledP .I "Mirroring in Y"w= is an operation that effectively multiplies all y-coordinates N by -1, or, in other words, mirrors in the direction of y.  This transformation0 is also identical to a reflection in the x-axis. .PPnE A rotation is always in the counter-clockwise direction and about the B origin of the coordinate system.  The angle of rotation is defined with two integers, namelys
 .I XDirection  and  .I YDirection,  " and is the arctangent of the ratio .I "YDirection/XDirection."X& If the angles of rotation is always an& integer multiple of 90 degrees, either
 .I XDirectionr or
 .I YDirection  will be zero, but never both.e .PPc/ The sequence of transformations is significant.eJ A brief example of this fact follows:  consider the point (0,0) translatedJ in the positive x-direction by 100 units and then rotated 90 degrees.  TheD resulting coordinate would be (0,100).  Now consider the point (0,0)H rotated by 90 degrees and then translated in the positive x-direction byC 100 units, the exact opposite of the previous transformation order.t5 The resulting point would be (100,0) and not (0,100).  .PPgD The sequence of the transforms is identical to the succession of the' transformation descriptors in the list.e The character member .I tTypeF specifies the type of transformation that is defined by the descriptor: and can be assigned to the following values defined in the	 .I "cd.h"e file:o .brs .s4o .nfX  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'unG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'us .ne 8t 	/*dL .if t .ta \w'XXXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uH .if n .ta \w'XXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u 	* Types of transformations\ 	*/XK .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uaG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u 5 	#define	CDMIRRORX	'x'	/* mirror in direction of x */r5 	#define	CDMIRRORY	'y'	/* mirror in direction of y */ 1 	#define	CDROTATE	'r'	/* rotate by vector X, Y */ 0 	#define	CDTRANSLATE	't'	/* translate to X, Y */   .fin .vs  .rs  .DTu .PP*6 If the transformation is a rotation or a translation,  .I tX  andl .I tYI4 define the angle or displacement, respectively.  The .I tSuccF member points to the next transformation descriptor in the linked-list9 and is null in the last transform definition in the list.a .XSd. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u% 		2.2.7. The Property List DescriptorI .XEr .SH  .ne 5 # 2.2.7. The Property List Descriptori .PP N CD provides the capability of attaching property lists to symbols and objects;L a CD property list is a null-terminated linked-list of property descriptors.. The property list descriptor is defined in the	 .I "cd.h"b file as follows: .br  .s4i .nfs  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ul .ne 9X 	/*t .ta \w'XXXXXXXXX'u 	* Property List desc. 	*/n= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ur 	struct prpty {  		int prpty_Value; 		char *prpty_String;  		struct prpty *prpty_Succ;t 		};   .fi  .vs  .rse .PPoJ In CD, a property consists of an identifying integer and a null-terminated4 character string extension.  The identifying integer .I prpty_Value6 defines the type of property, and the string extension .I prpty_Stringt6 is a modifier.  There is no standard set of propertiesC and associated property values for CD or KIC; a user is free to setiA his own standard set of property values for his own specific use.a .PPo Thet
 .I prpty_Succ @ member points to the next property descriptor in the linked-list- and is null in the last property in the list.  .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  		2.2.8. The CD Layer Descriptor .XEt .SHI .ne 5o 2.2.8. The CD Layer Descriptor .PP & The layer descriptor is defined in the	 .I "cd.h"u file as follows: .br/ .s4t .nfX  > .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u .ne 13 	#define	CDNUMLAYERS	35c   	/*c .ta \w'XXXXXXXXX'u 	* CD Layer TableT 	*/ = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  	struct l {P 		char lTechnology;r 		char lMask[3];* 		/* True if CDFrom should output layer */ 		char lCDFrom;p 		}u 	CDLayer[CDNUMLAYERS+1];   .fio .vso .rs  .PPtN The CD layer descriptor is the building block of CD's layer table that is usedK to equate a layer's name to a positive integer. This integer is always usede3 internally in CD to represent the respective layer.a .PPfH A CIF layer name can be up to four characters long.  The first character" of the CIF layer name is stored in .I lTechnology. and the remaining characters are stored in the .I lMask- character buffer; the remaining characters inl .I lMask: will be blanks.  A layer is recognized as undefined if the .I lTechnologyG character member of the layer table is a blank or space character.  They
 .I lCDFromH boolean has the purpose of identifying the layer as visible or invisible when convertingBK from KIC/CD format to another layout language, such as CIF or Calma STREAM.t .PP 6 The maximum layers known to CD, and therefore the size4 of the layer table, is defined by CDNUMLAYERS in the	 .I "cd.h"f file.n .I CDp. can be recompiled to provide more mask layers.= Because object layer numbers are stored in character fields,  - the absolute maximum number of layers is 126.g6 The size of the layer table is larger than CDNUMLAYERS5 because layer zero is reserved as the instance layer.X .XSX. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.2.9. The Path Descriptor .XE  .SHX .ne 5  2.2.9. The Path Descriptor .PPt@ A contour or trajectory of coordinates is represented in CD as aE null-terminated linked-list of path descriptors.  The path descriptor  is defined in thet	 .I "cd.h"p file as follows: .bry .s4  .nfr  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uh 	/*s .ta \w'XXXXXXXXX'u 	* Linked path structure.p 	*/t= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ud 	struct p {r
 		int pX, pY;i 		struct p *pSucc; 		};   .fi  .vsp .rsc .PPe Thep .I pXo andn .I pYp2 integer members define one coordinate in the path.? The sequence of the coordinates in the path is identical to thew6 succession of the path descriptors in the linked-list. TheS .I pSucc< member points to the next path descriptor in the linked-list/ and is null at the last coordinate in the list.b .bps .XSn. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	2.3. Storage Bins .XE  .SH# 2.3. Storage Bins3 .PP 3 All objects contained within a CD symbol are sortedt; by position and layer, and the sorted objects are stored in  .I bins.G A pointer to these storage bins is contained in the symbol descriptor, t5 and each symbol has one complete set of storage bins.EF This section presents a detailed description of the storage algorithm. .PPc: The world coordinate system of CD ranges from CDBINMINX to> CDBINMAXX in the x-direction, and from CDBINMINY to CDBINMAXY,I and the world coordinate system is covered by a square array of CDNUMBINSp? by CDNUMBINS storage bins where these values are defined in then	 .I "cd.h"e? file as shown below.  There is a special storage bin called thet .I "residual bin"cG that only for convenience is contained in the storage bin array therebyy, adding another row and column to this array. .bry .s4r .nf   K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'ulG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'un .ne 17 	/*  .if t .ta \w'XXXXXXXXX'u .if n .ta \w'XXXXX'uF 	* These are the numbers that CD uses to determine which bin an objectF 	* resides in.  They should reflect the average size of a layout beingB 	* edited by KIC.  KIC will not fail if the numbers are too small.A 	* Anything outside of this window is placed in the residual bin.dE 	* If these numbers become too large, CDIntersect() must use floatinga 	* point calculations. 	*/MK .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uXG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u  	#define	CDBINMAXX	500000  	#define	CDBINMAXY	500000w 	#define	CDBINMINX	(-CDBINMAXX)X 	#define	CDBINMINY	(-CDBINMAXY)X   	#define	CDNUMBINS	10X   .fiX .vsX .rsw .DTX .PP*@ Each storage bin contains the beginning pointer to a linked-listN of object descriptors, those objects that are contained in the particular bin.A When an object is inserted into a bin as a result of a call to ani  object creation routines (e.g.,   .I "CDMakeBox(), CDMakeWire(), "4 etc.), it is inserted at the top of the linked-list.3 The bin into which an object is inserted depends onoO the bounding box of the object.  If the bounding box intersects an area coveredaP by more than one bin, the object is inserted into the residual bin.  Otherwise, E the object is inserted into the bin that contains the bounding box of  the object.- .PP  If CDnL is compiled with a large number of bins, it will be able to rapidly traverse@ a symbol hierarchy or quickly access any geometry in the symbol.I However, many storage bins also means that a significant amount of memoryeE must be dedicated to the bin pointers, and that the number of objects 2 in the residual bin to be disproportionately largeN when compared to the number of objects in the remaining bins; because the binsM are smaller, the number of objects that intersect more than one bin increases'5 and these objects are inserted into the residual bin.X .PP*G The size of the residual bin can effect the speed at which the bins areXG searched for objects.  When the storage bins are searched for an objecti8 in a specific area, it is of course necessary to examineE the contents of each storage bin that intersects the particular area. ; However, the bounding box of an object that also intersectst< this area may also intersect several bins, in which case theI object descriptor is stored in the residual bin.  Therefore, the residualXA bin must always be searched, and consequently it is preferable to+. have the residual bin be as small as possible. .PP ? CD allocates the memory for the storage bin pointers on demand.p? This means that the memory requirements for the storage bins isc; a function of the number of layers being used in the symbolw& as well as the number of storage bins.; When CD must allocate memory for the storage bin pointers, u> CDNUMBINS+1 by CDNUMBINS+1 bins are allocated, where CDNUMBINS is defined in the*	 .I "cd.h"u file.. The bin that is pointed to by  .I "sBin[Layer][0][0]" is the residual bin.  The bins .I "sBin[Layer][X][0]" andX .I "sBin[Layer][0][Y], " whereX .I X ande .I Y= are positive integers not greater than CDNUMBINS, are unused.X? The remaining bins represent the symbols storage bin structure.M .PP1G The CD procedure that computes the range of storage bins that intersectn a particular area is calledf .I "CDIntersect()."tC The CD procedure that inserts an object descriptor into the storagetA bin of a symbol descriptor and allocates memory if the particularo$ bin has not been allocated is called .I "CDInsertObjectDesc()."D These two CD routines are intended to be transparent to the CD user,= and therefore will not be described further in this document.h .PPnI To possibly increase the efficiency of this binning algorithm, the valuesn; of CDBINMAXX, CDBINMINX, CDBINMAXY, and CDBINMINY should bee as small as possible whileA still reflecting a realistic working area for the CD application.i6 CD will not fail if the real working area exceeds CD'sF range for the world coordinate system.  Objects that exist outside the? working world coordinate system of CD will be inserted into the H outer-most bins, and an object generator will find such objects in those bins.  .PPtH To minimize the number of objects in a given bin, the value of CDNUMBINS= should be as large as is affordable with the resulting memorye; requirements.  If the size of a pointer is four bytes, thenrM the amount of memory required for only the pointers of a binning structure ino> an entire symbol hierarchy is given by the following equation: .DS CdD 4*(number of symbols)*(number of layers)*(CDNUMBINS+1)*(CDNUMBINS+1)   .DEiL For an IC layout with 80 symbols, eight mask layers, and using only 10 bins,D the memory requirements for the bin structure can exceed 300 kbytes.H Also, as the numbers of bins increases, the size of the residual bin canM be expected to increase.  But by far the greatest disadvantage to the binning,K algorithm is that most bins remain empty and unused; a layout can typicallyeN exist entirely in the first Cartesian quadrant of the world coordinate system,9 in which case only one quarter of the bins would be used.  .bpp .XSe. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	2.4. CD Procedureso .XEa .SHn 2.4. CD Procedures .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.4.1. CD Initialization .XEb .SHi 2.4.1. CD Initialization .PP A There are three procedures for initialization of the CD database.b .brs .s4n .nf    .ta \w'XXXXXXXX'u+ .ne 2' 	void CDInit()   .if n .sp 2s .ne 3  	int CDPath(Path)B 	char *Path;   .if n .sp 2i .ne 4h) 	void CDSetLayer(Layer, Technology, Mask)  	int Layer;e 	char Technology;  	char Mask[3];   .fi  .vse .rst .DTs .PPe
 .I "CDInit()"n/ must be invoked before any other CD procedures.a: This routine will clear the layer table, set the directory? search path to be the present working directory, initialize the ; transformation stack, and allocate storage for diagnostics.n
 .I "CDInit()"n- should be called only once by an application.l .PPr
 .I "CDPath()"s? sets the search rules for symbol-name resolution.  The argumentn .I Pathh: is a pointer to a null-terminated string containing a list6 of directory names to be searched separated by blanks. When a cell is opened via 
 .I "CDOpen()"cI the list of directories is searched for the existence of the symbol file.o+ The old search path is removed by a call tow
 .I "CDPath()"'* and the default search path is the current% directory.  In the UNIX environment, u .I "csh(1)"X> style names, as described in the BSD UNIX programmer's manual, will be understood.u .PPT .I "CDSetLayer()"s Inserts the layer argument .I Layer% into the CD layer table with the names .I TechnologyMask. If
 .I Technologys andg .I Maskt? contain only space or blank characters, the layer definition isaC removed from CD, but any object that exists on the particular layerIO is not deleted.  The layer table is defined above with the CD layer descriptor.  .XSi. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.4.2. Error Handling in CDs .XE" .SHL .ne 5] 2.4.2. Error Handling in CD] .PP". CD has a simple mechanism for handling errors. In the	 .I "cd.h"0B file, there are two external error variables that are allocated by .I "CDInit():" .br  .s4t .nfa  R .ta \w'XXXXXXXX'u +\w'XXXXXXX'u +\w'XXXXXX'u +\w'XXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'u .ne 3n6 	extern	int	CDStatusInt;	/* CD's diagnostic integer */6 	extern	char	*CDStatusString;	/* CD's status string */   .fip .vsd .rse .DTl .PP G If a CD routine encounters any difficulty, it will place an identifyingl diagnostic integer inn .I CDStatusInt/ and a pointer to diagnostic character string inX .I CDStatusString, '! and then return the with value of 	 .I False.e The possible fatal values forr .I CDStatusInt are defined in the	 .I "cd.h"\ file as follows: .brn .s4i .nfn  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uiG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u  .ne 7 3 	#define	CDPARSEFAILED	1	/* (FATAL) parse failed */a6 	#define	CDNEWSYMBOL	3	/* symbol not in search path */6 	#define	CDMALLOCFAILED	11	/* (FATAL) out of memory */3 	#define	CDBADBOX	12	/* zero width or length box */P; 	#define	CDXFORMSTACKFULL	13	/* transform stack overflow */d5 	#define	CDBADPATH	14	/* bad directory search path */e   .fio .vse .rsp .DTo .PPh Error handling in CDM may be confusing at first because only those routines in which an error mightiM occur will have a returned value.  The routines in which no error is expected"  are assigned the type definition .I void. .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.4.3. CD Symbol Managementc .XEn .SH  .ne 5f 2.4.3. CD Symbol Managemente .PPaD There are four CD procedures for creating, deleting, and maintaining CD symbols.e .brs .s4e .nf    .ta \w'XXXXXXXX'us .ne 4i+ 	int CDOpen(SymbolName, SymbolDesc, Access)l 	char *SymbolName, Access; 	struct s **SymbolDesc;t   .if n .sp 2e .ne 4 & 	void CDSymbol(SymbolName, SymbolDesc) 	char *SymbolName; 	struct s **SymbolDesc;r   .if n .sp 2a .ne 3l 	int CDClose(SymbolDesc) 	struct s *SymbolDesc;   .if n .sp 2u .ne 4I% 	int CDUpdate(SymbolDesc, SymbolName)e 	struct s *SymbolDesc; 	char *SymbolName;   .fig .vsM .rs  .DTi .PPy
 The procedure 
 .I "CDOpen()"  opens a symbol named .I SymbolName, b, allocates memory for and returns the pointer
 .I SymbolDesclI to a symbol descriptor that represents the new symbol in the CD database.i .PP  TheX	 .I AccessX argument to 
 .I "CDOpen()".B is a character that determines the result after the current search: path has been examined for the existence of a symbol named .I SymbolName. If the character	 .I Access  equals the character 'w', then
 .I "CDOpen()"e$ will create the cell in the database0 if it does not exist in the current search path. In other words, the symbol will be opened for writing.  If 	 .I Accesse equals the character 'r', then
 .I "CDOpen()" = will create the cell in the database if and only if it existseD in the current search path.  In other words, the symbol is only read> into memory.  If the cell does not exist in the current search= path, no symbol descriptor is inserted into the database, andt
 .I SymbolDesc + is assigned the value of NULL.  Finally, ift	 .I Access D equals the character 'n', the symbol is opened regardless of whether any symbol named
 .I SymbolNameb@ exists in the current search path.  If such a file exists in the( search path, it is not read into memory.( In other words, CD creates a new symbol. .PPo
 .I "CDOpen()". will call the routinet .I "PCIF()"kI to read the symbol into the database.  The parsing procedure is describedn in greater detail in Chapter 3.i A brief synopsis ofo .I "PCIF()"P is as follows: .bru .s4o .nfe   .ta \w'XXXXXXXX'uh .ne 5 * 	PCIF(SymbolName, StatusString, StatusInt) 	char *SymbolName; 	char **StatusInt; 	int *StatusInt;   .fi  .vse .rsf .DTy .PPt, There are three requirements for the parser;1 first, the parser must locate and read the symboly .I SymbolName,  , and insert the symbol definition into the CD> database by using the object creation routines described below in Section 2.4.4 (e.g.,   .I "CDMakeBox(), CDMakeWire(), " etc.).- Second, the parser must provide a file called)
 .I "parser.h" / which contains the diagnostics described below.X& Finally, when the parse is completed,  .I "PCIF()"t@ must return a pointer to a null-terminated diagnostic string via .I StatusString, C andt .I StatusInt% must be set to a value defined in theC .I parser.ho file as follows: .bri .s4l .nfe  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'unG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uo .ne 4 - 	#define	PSUCCEEDED	1	/* successful return */P& 	#define	PFAILED	2	/* parser failed */9 	#define	PNOTAPPLICABLE	3	/* parser failed, bad syntax */d   .fis .vsp .rsr .DTS .PPD .I "PCIF()"m% may return with the diagnostic strings .I StatusStringa0 equal to NULL if and only if the parse succeeds.
 .I "CDOpen()"s returns with the value .I FalseA if the parse failed or if it was unable to allocate memory.  Whent
 .I "CDOpen()"l	 returns, S .I CDStatusInt, E as defined above, is set to a diagnostic value that is defined in the 	 .I "cd.h"  file as follows: .bre .s4i .nfs  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'unG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'up .ne 5 3 	#define	CDPARSEFAILED	1	/* (FATAL) parse failed */t5 	#define	CDOLDSYMBOL	2	/* symbol already in opened */t6 	#define	CDNEWSYMBOL	3	/* symbol not in search path */5 	#define	CDSUCCEEDED	4	/* new symbol found in path */t   .fin .vsd .rs  .DTa .PPe7 Only CDPARSEFAILED is returned as a fatal error (i.e., i
 .I "CDOpen()"A returns with the value .I "False,"  andl .I CDStatusInt, has been set to the value of CDPARSEFAILED);5 this simplifies the diagnostic test.  However, if thee	 .I AccesstG argument is set to 'r' and the symbol is not found in the search path, a
 .I "CDOpen()"P returns with .I CDStatusIntC set to the value of CDNEWSYMBOL.  The application programmer shouldeH be aware of this behavior because it could be considered as an error if,H for any reason, the symbol is expected to exist, such as when traversing/ a symbol hierarchy.  When the returned value ofg
 .I "CDOpen()"c identifies an error, .I CDStatusStringt" will contain a diagnostic message. .PPP .I "CDSymbol()"e4 returns a pointer to symbol descriptor if the symbol
 .I SymbolNamed0 has been previously opened and exists in memory.( If the symbol does not exist in memory, 
 .I SymbolDescc is returned as a null pointer. .PPS Then .I "CDClose()". procedure will remove the symbol identified by
 .I SymbolDescs8 from memory and any associated instances and geometries.: Also, all property lists associated with the symbol or any% object in the symbol will be removed.  .PPn
 .I CDUpdate()eE will save any changes that have been made to the symbol referenced by  .I SymbolDesc.H The output will appear as CIF in a file in the current working directory( identified by the null-terminated string .I SymbolName. If
 .I SymbolNamen3 is a null pointer, the name of the CIF file will be 2 identical to the name of the symbol being updated. .XSf. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u$ 		2.4.4. CD Object Creation Routines .XEs .SHn .ne 6i" 2.4.4. CD Object Creation Routines .PPXC There are eight procedure for inserting an object into a CD symbol.+ .brX .s4X .nfX   .ta \w'XXXXXXXXX'u .ne 6#? 	int CDMakeBox(SymbolDesc, Layer, Length, Width, X, Y, Pointer)W 	struct s *SymbolDesc; 	struct o **Pointer; 	int Layer;F 	int Length, Width;u
 	int X, Y;   .if n .sp 2B .ne 629 	int CDMakeLabel(SymbolDesc, Layer, Label, X, Y, Pointer)	 	struct s *SymbolDesc; 	struct o **Pointer; 	int Layer;*
 	char *Label;s
 	int X, Y;   .if n .sp 2e .ne 8 4 	int CDMakePolygon(SymbolDesc, Layer, Path, Pointer) 	struct s *SymbolDesc; 	struct o **Pointer; 	struct p *Path; 	int Layer;    .if n .sp 2  .ne 5u8 	int CDMakeWire(SymbolDesc, Layer, Width, Path, Pointer) 	struct s *SymbolDesc; 	struct o **Pointer; 	struct p *Path; 	int Layer, Width;   .if n .sp 2n .ne 6c> 	int CDMakeRoundFlash(SymbolDesc, Layer, Width, X, Y, Pointer) 	struct s *SymbolDesc; 	struct o **Pointer; 	int Layer;i 	int Width, X, Y;b   .if n .sp 2  .ne 6wI 	int CDBeginMakeCall(SymbolDesc, SymbolName, NumX, DX, NumY, DY, Pointer)S 	struct s *SymbolDesc; 	struct o **Pointer; 	char *SymbolName; 	int NumX, DX, NumY, DY;   .if n .sp 2) .ne 4  	int CDT(Pointer, Type, X, Y)l 	struct o *Pointer;a 	char Type;t
 	int X, Y;   .if n .sp 2c .ne 3m' 	int CDEndMakeCall(SymbolDesc, Pointer)' 	struct s *SymbolDesc; 	struct o *Pointer;'   .fi  .vs# .rse .DTC .PP	 .I "CDMakeBox()" will create a box of length/	 .I Lengthi in the x direction and width .I Width in the y direction, centered ats .I X, Yr on the layer .I Layer* in the symbol identified by the descriptor .I SymbolDesc.+ Zero width or length boxes are not allowed.c
 .I Pointer4 contains a returned pointer to the object descriptorA of the newly created box.  Because the object descriptor containsp7 sufficient information to characterize a rectangle, they .I oReptK member of the object descriptor, as described previously in Section 2.2.4, r< is a null pointer if the object descriptor represents a box.! There is no box descriptor in CD.m .PP  .I "CDMakeBox()" will return with the value .I False$ if it is unable to allocate storage. Otherwise, the value .I Truel is returned. .PPa .I "CDMakeLabel()"  will create a label on the layer .I Layer* in the symbol identified by the descriptor .I SymbolDesc.+ The lower, left corner of the label will be  referenced to the coordinate	 .I X, Y, n anda .I Label> is a pointer to a null-terminated string containing the label.
 .I PointerP contains a returned pointer to the object descriptor of the newly created label. For all labels, the  .I oRep @ member of the object descriptor, as described in Section 2.2.4, A is cast as a pointer to a label descriptor that is defined in theP	 .I "cd.h"s file as follows: .brs .s4  .nfo   .ne 9i= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'un 	/*  .ta \w'XXXXXXXXX'u 	* Label desc. 	*/,A .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXX'u +\w'XXXX'ut 	struct la {  		char *laLabel;	/* text body */( 		int laX, laY;	/* lower, left corner */ 		};   .fih .vsn .rs  .PPc .I "CDMakeLabel()" will return with the value .I False$ if it is unable to allocate storage. Otherwise, the value .I Truee is returned. .PPn .I "CDMakePolygon()"8 will create a polygon with a linked-list coordinate path .I Path  on the layer .I Layer* in the symbol identified by the descriptor .I SymbolDesc. .I PathcD is a pointer to a linked-list of coordinates as described previously0 in the section that defines the path descriptor.
 .I Pointer4 contains a returned pointer to the object descriptor of the newly created polygon.; For all polygons, thei .I oRepD@ member of the object descriptor, as described in Section 2.2.4, C is cast as a pointer to a polygon descriptor that is defined in then	 .I "cd.h"C file as follows: .br, .s4t .nf   = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  .ne 7P 	/*I .ta \w'XXXXXXXXX'u 	* Polygon desc. 	*//A .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXX'u +\w'XXXX'uc 	struct po {- 		struct p *poPath;	/* the polygon contour */s 		};   .fii .vs  .rse .PPt .I "CDMakePolygon()" will return with the value .I False: if it is unable to allocate storage.  Otherwise, the value .I Truer is returned. .PPt .I "CDMakeWire()"e will create a wire of widthn .I Width with a coordinate path .I Pathn on the layer .I Layer* in the symbol referenced by the descriptor .I SymbolDesc. .I Path B is a pointer to a linked-list of coordinates as described above in3 Section 2.2.9 that concerns the CD path descriptor.'
 .I Pointer4 contains a returned pointer to the object descriptor of the newly created wire. For all wires, the .I oRepO@ member of the object descriptor, as described in Section 2.2.4, @ is cast as a pointer to a wire descriptor that is defined in the	 .I "cd.h"i file as follows: .brd .s4  .nfa  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  .ne 9p 	/*A .ta \w'XXXXXXXXX'u
 	* Wire desc., 	*/nA .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXX'u +\w'XXXX'uh 	struct w { " 		int wWidth;	/* the wire width */) 		struct p *wPath;	/* the wire contour */t 		};   .fin .vsu .rs  .PPe .I "CDMakeWire()"D will return with the value .I False$ if it is unable to allocate storage. Otherwise, the value .I Truee is returned. .PPb .I "CDMakeRoundFlash()"b% will create a round flash of diametere .I Width centered ate .I X, Yx on the layer .I Layer* in the symbol identified by the descriptor .I SymbolDesc., Zero diameter round flashes are not allowed.
 .I Pointer4 contains a returned pointer to the object descriptor! of the newly created round flash.i For all round flashes, the .I oRepa@ member of the object descriptor, as described in Section 2.2.4, G is cast as a pointer to a round flash descriptor that is defined in theu	 .I "cd.h"f file as follows: .bre .s4c .nfe  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ur .ne 8y 	/*e .ta \w'XXXXXXXXX'u 	* Round flash desc. 	*/ A .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXX'u +\w'XXXX'uP 	struct r {e& 		int rWidth;	/* the flash diameter */+ 		int rX, rY;	/* the center of the flash */t 		};   .fiv .vs  .rsu .DTs .PPrG The KIC program does not use round flashes and the round flash routinesrJ are only presented in this section for completeness.  All round geometries# are represented in KIC as polygons.+ .PPX .I "CDMakeRoundFlash()"  will return with the value .I False: if it is unable to allocate storage.  Otherwise, the value .I TrueX is returned. .PP  .I "CDBeginMakeCall()"6 allocates memory and initializes the object descriptor< that will represent the newly created instance of the symbol .I SymbolName. .I NumXl? is the number of instances in the untransformed x direction ande .I NumY < is the number of instances in the untransformed y direction. .I DXo andt .I DY I are the distances between the left and right edges and the top and bottomr? edges respectively of two adjacent cells in the instance array.d
 .I PointerJ returns a pointer to the new object descriptor.  For all symbol calls, the .I oRepo@ member of the object descriptor, as described in Section 2.2.4, @ is cast as a pointer to a call descriptor that is defined in the	 .I "cd.h"a file as follows: .br2 .s4  .nfc  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u" .ne 14 	/*a .ta \w'XXXXXXXXX'u
 	* Call desc.  	*/XA .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXX'u +\w'XXXX'u  	struct c {X 		/* not used */ 		int cNum; - 		/* Pointer to transformation descriptor. */X 		struct t *cT;s* 		/* Pointer to master-list descriptor. */ 		struct m *cMaster; 		/* Array parameters. */	 		int cNumX, cNumY, cDX, cDY;I 		};   .fi) .vsi .rst .DTi .PPe Thee .I cTlE member of the call descriptor is a pointer to the transformation liste/ that will be defined by subsequent calls to thei
 .I "CDT()"
 routine.  Thed
 .I cMasterD member is a pointer to the master-list descriptor in the master-list1 of the symbol that instances the cell representeddD by the call descriptor.  Because the master-list descriptor containsF the instance name, it is not necessary to contain a name buffer in the@ call descriptor.  The master-list is described in Section 2.2.2. .PPa If
 .I SymbolNamei% is not in the current search path, oro .I CDBeginMakeCall cannot allocate storage, I .I CDBeginMakeCall returns with the value .I False andX .I CDStatusInt2 will be set to a diagnostic integer defined in the	 .I "cd.h"X file as follows: .brs .s4* .nft  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u G .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'ue .ne 4*3 	#define	CDPARSEFAILED	1	/* (FATAL) parse failed */g6 	#define	CDNEWSYMBOL	3	/* symbol not in search path */6 	#define	CDMALLOCFAILED	11	/* (FATAL) out of memory */   .fi. .vs  .rs, .DT  .PPr After invoking .I "BeginMakeCall(), "
 the procedureI
 .I "CDT()"= is invoked for each transformation in the call.  The argumentn
 .I Pointer> is a pointer to the object descriptor that was returned by the .I "CDBeginMakeCall()" procedure.  The character  .I Type 7 identifies the transformation to be added to the call, n and the valid arguments forr .I Typee are defined in the	 .I "cd.h"  file as follows: .bra .s4l .nf   K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u+G .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uX .ne 5'5 	#define	CDMIRRORX	'x'	/* mirror in direction of x */a5 	#define	CDMIRRORY	'y'	/* mirror in direction of y */*1 	#define	CDROTATE	'r'	/* rotate by vector X, Y */P0 	#define	CDTRANSLATE	't'	/* translate to X, Y */   .fil .vsf .rss .DTl .PPa
 The arguments. .I X and, .I Y of
 .I "CDT()". are used to qualify a rotation or translation.E Only rectilinear rotations are valid.  For a rotation of 90 degrees, y .I X has the value of 1, andn .I Y4 has the value of 0.  For a rotation of 180 degrees,  .I X has the value of -1, and .I Y4 has the value of 0.  For a rotation of 270 degrees,  .I X has the value of 0, and  .I Y5 has the value of -1.  For a translation, the integersn .I X andd .I Y< are used to specify the x and y displacements, respectively. .PPp
 Remember thate) .I "transformation order is significant."t Each invocation of
 .I "CDT()") adds another transformation descriptor too- the transformation list that is referenced byo .I cTP> in the respective call descriptor, and thus the invocations of
 .I "CDT()"> must be in the identical order of the instance transformation. .PPr	 Finally,   .I "CDEndMakeCall()"B is invoked to insert the call into the master symbol identified by .I SymbolDesc. The argument
 .I Pointer0 was of course returned by a previous call to the .I "CDBeginMakeCall()"
 procedure. .I "CDEndMakeCall()" will return with the value .I False: if it is unable to allocate storage.  Otherwise, the value .I Truel is returned. .XSu. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.4.5. CD Object Generator .XEw .SHb 2.4.5. CD Object Generator .PPX	 An object' .I generatorL in the context of CD is a set of procedures for acquiring object descriptorsG for all objects on a specific layer and in a specific area of interest.L; A generator will contain the following three CD procedures:e .brp .s4/ .nfe .ta \w'XXXXXXXX'u	   .ne 8TD 	int CDInitGen(SymbolDesc, Layer, Left, Bottom, Right, Top, GenDesc) 	struct s *SymbolDesc; 	struct g **GenDesc; 	int Layer;k 	int Left, Bottom; 	int Right, Top;   .if n .sp 2n .ne 6i) 	void CDGen(SymbolDesc, GenDesc, Pointer)  	struct s *SymbolDesc; 	struct g *GenDesc;( 	struct o **Pointer;   .if n .sp 2p .ne 4n 	void CDType(Pointer, Type)b 	struct o *Pointer;n 	char *Type;   .fie .vso .rsI .PPe .I "CDInitGen()"3 returns a pointer to a generator storage descriptor 
 .I GenDesc? that is allocated automatically and described in Section 2.2.5.  Further invocations of .I "CDGen()"3 will return each object in the symbol identified byC
 .I SymbolDesc  on the layer .I Layer/ whose bounding box intersects the area given byo .I "Left, Bottom, Right, " and	 .I Top.  If .I Layer equals zero, the invocations of  .I "CDGen()"D will return instances only (i.e., layer zero is the instance layer). .I "CDInitGen()" will return with the value ofn .I False= if it is unable to allocate the generator storage descriptor.f Otherwise, the value of  .I True  is returned. .PPa .I "CDGen()"C returns a pointer to an object descriptor that identifies an object > within the area of interest as defined by the previous call to .I "CDInitGen()"6 which returned the pointer to the generator descriptor .I GenDesc.n If .I "CDGen()" returns with
 .I Pointer7 set to NULL, then the last object has been returned ande
 .I GenDesc storage has been released. .PP 
 .I "CDType()" + returns the type of an object pointed to bye .I Pointer.  The argument .I Type * is a pointer to a character that is set by
 .I "CDOpen()"r$ to a value defined as follows in the	 .I "cd.h"u file:n .bri .s4c .nfd  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uiG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uD .ne 10 	/*u .if t .ta \w'XXXXXXXXX'u .if n .ta \w'XXXXX'u 	* Types of geometries 	*/iK .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uIG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u  	#define	CDSYMBOLCALL	'c'e 	#define	CDPOLYGON	'p' 	#define	CDROUNDFLASH	'r'  	#define	CDLABEL	'l' 	#define	CDWIRE	'w'  	#define	CDBOX	'b'   .fie .vst .rsw .PPcL This information routine is typically used in a generator loop to dispatch aL type-specific procedure for accessing the object.  An example of a generatorB loop for traversing a symbol hierarchy is provided in Section 2.6. .XSc. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  		2.4.6. Accessing Objects in CD .XEw .SHX 2.4.6. Accessing Objects in CD .PPXE All information that is necessary to characterize an object is storedXH in that object's respective object descriptor and another representative7 descriptor that is referenced in the object descriptor.cC Information for a specific object is therefore easily obtained fromNM the respective object descriptor.  The following eight CD procedures are usedb* for accessing object-specific information: .brn .s4a .nfl  M .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'ud .ne 3a0 	void CDBox(Pointer, Layer, Length, Width, X, Y) 	struct o *Pointer;i$ 	int *Layer, *Length, *Width, *X, *Y   .if n .sp 2d .ne 5e* 	void CDLabel(Pointer, Layer, Label, X, Y) 	struct o *Pointer;h 	char **Label; 	int *Layer; 	int *X, *Y;   .if n .sp 2e .ne 5e% 	void CDPolygon(Pointer, Layer, Path)d 	struct o *Pointer;. 	int *Layer; 	struct p **Path;s   .if n .sp 2r .ne 5r) 	void CDWire(Pointer, Layer, Width, Path)l 	struct o *Pointer;l 	struct p **Path;e 	int *Layer, *Width;   .if n .sp 2e .ne 4u/ 	void CDRoundFlash(Pointer, Layer, Width, X, Y)  	struct o *Pointer;n 	int *Layer; 	int *Width, *X, *Y;   .if n .sp 2X .ne 4j5 	void CDCall(Pointer, SymbolName, NumX, DX, NumY, DY)o 	struct o *Pointer;  	char **SymbolName;o 	int *NumX, *DX, *NumY, *DY;   .if n .sp 2e .ne 4r 	void CDInitTGen(Pointer, TGen)l 	struct o *Pointer;g 	struct t **TGen;s   .if n .sp 2  .ne 4t 	void CDTGen(TGen, Type, X, Y) 	struct t **TGen;i 	char *Type; 	int *X, *Y;   .fia .vst .rs  .DTr .PP  .I "CDBox()" will return the length	 .I Lengthd  in the x direction and the width .I Width5 in the y direction of a box identified by the pointer+
 .I Pointer to an object descriptor.% The box is centered at the coordinateX	 .I "X, Y"X and on the layer	 .I Layer.  .PP  .I "CDLabel()". returns the pointer to a null-terminated label .I Label4 that has lower, left justification to the coordinate	 .I "X, Y"', and whose object descriptor is pointed to by .I Pointer.X The label is on the layer 	 .I Layer.C .PPO .I "CDPolygon()"8 will return a pointer to the linked-list coordinate path .I Path & of a polygon identified by the pointer
 .I Pointer to an object descriptor. The polygon is on the layers	 .I Layer.eJ The linked-list coordinate path is defined in Section 2.2.9 that describes the path descriptor. .PP 
 .I "CDWire()"s8 will return a pointer to the linked-list coordinate path .I PathX of a wire with width .I Width! that is identified by the pointer 
 .I Pointer to an object descriptor. The wire is on the layer	 .I Layer.i .PPe .I "CDRoundFlash()"  will return the diameter .I Width* of a round flash identified by the pointer
 .I Pointer to an object descriptor.- The round flash is centered at the coordinate 	 .I "X, Y"f and on the layer	 .I Layer. ? As explained earlier, KIC does not use CD round flash routines.e .PPC
 .I "CDCall()"e+ returns the a character pointer to the namet
 .I SymbolNamea2 of an instance referenced by the object descriptor .I Pointer.X Also returned is .I NumX D which is the number of instance in the untransformed x direction and .I NumYtB which is the number of instances in the untransformed y direction. .I DXn andL .I DYaI are the distances between the left and right edges and the top and bottom;? edges respectively of two adjacent cells in the instance array.  .PPc TheP .I "CDInitTGen()"eC routine initializes the transformation generator loop to access the - transformations of the instance referenced byr .I Pointer.e .I TGena: is a returned pointer to a transform generator descriptor. Subsequent invocations of 
 .I "CDTGen()"tF will return the individual components of the instance transformations. .PPl
 .I "CDTGen()"lG returns a character that identifies one component of the transformationi of the instance for which  .I TGens was returned by theD .I "CDInitTGen()"G< routine as the transform generator descriptor.  The argument .I Type * is a pointer to a character that is set by
 .I "CDTGen()" 7 to one of the values that are defined as follows in the;	 .I "cd.h"  file:s .bri .s4y .nf   K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'ulG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'us .ne 5 5 	#define	CDMIRRORX	'x'	/* mirror in direction of x */r5 	#define	CDMIRRORY	'y'	/* mirror in direction of y */v1 	#define	CDROTATE	'r'	/* rotate by vector X, Y */ 0 	#define	CDTRANSLATE	't'	/* translate to X, Y */   .fil .vse .rso .DTa .PPn@ The order in which the transformation components are returned by
 .I "CDTgen()" @ is identical to the order in which they were defined by calls to .I "CDT()."r The integer pointers	 .I "X, Y"h. are used to specify a rotation or translation. For a rotation of 90 degrees,  .I X  has the returned value of 0, and .I Y has the returned value of 1. For a rotation of 180 degrees, r .I X! has the returned value of -1, ande .I Y= has the returned value of 0.  For a rotation of 270 degrees, g .I X  has the returned value of 0, and .I YH has the returned value of -1.  For a translation, the returned values of .I X andt .I Y6 specify the x and y displacements, respectively.  When
 .I "CDTGen()"s returns with .I TGen(? set to NULL, then the last transformation has been returned andn .I TGenf storage has been freed.i .XSI. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.4.7. Object Deletion in CD .XEg .SH  .ne 4l 2.4.7. Object Deletion in CD .PPnI There is one procedure for removing objects from their respective symbol:  .bra .s4t .nf   M .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'un .ne 4e# 	void CDDelete(SymbolDesc, Pointer)o 	struct s *SymbolDesc; 	struct o *Pointer;r   .fi  .vst .rsr .DT. .PP  .I "CDDelete()"t$ will remove the object pointed to by
 .I Pointer from the symbol referenced by  .I SymbolDesc.H Because the object descriptor is doubly linked-list (i.e., it contains aO pointer to the successor and predecessor in the list), the task of deleting therH object from the list can be completed without searching the storage bins0 for the particular object that is to be removed.A Also, the memory of any property list that is associated with ther deleted object is released.l .XSu. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  		2.4.8. CD Information Routines .XEo .SHc .ne 4T 2.4.8. CD Information Routines .PPtI There are six procedure for accessing or setting a variety of informationT' fields in object or symbol descriptors:  .bry .s4" .nfn   .ta \w'XXXXXXXXX'u .ne 5a8 	int CDBB(SymbolDesc, Pointer, Left, Bottom, Right, Top) 	struct s *SymbolDesc; 	struct o *Pointer;X" 	int *Left, *Bottom, *Right, *Top;   .if n .sp 2  .ne 4w' 	void CDInfo(SymbolDesc, Pointer, Info)X 	struct s *SymbolDesc; 	struct o *Pointer;X 	int *Info;r   .if n .sp 2f .ne 4 * 	void CDSetInfo(SymbolDesc, Pointer, Info) 	struct s *SymbolDesc; 	struct o *Pointer;y
 	int Info;   .if n .sp 2C .ne 4A/ 	void CDProperty(SymbolDesc, Pointer, Property)o 	struct s *SymbolDesc; 	struct o *Pointer;m 	struct prpty **Property;e   .if n .sp 2n .ne 8s6 	int CDAddProperty(SymbolDesc, Pointer, Value, String) 	struct s *SymbolDesc; 	struct o *Pointer;I 	char *String; 	int Value;    .if n .sp 2r .ne 6o1 	int CDRemoveProperty(SymbolDesc, Pointer, Value)e 	struct s *SymbolDesc; 	struct o *Pointer;d 	int Value;    .fio .vsn .rs8 .DTr .PPr .I "CDBB()"h3 returns the bounding box of an object pointed to byv
 .I Pointer in the symbol identified by, .I SymbolDesc. If
 .I Pointer is a null pointer, then  .I "CDBB()"e. returns the bounding box of the entire symbol. TheI .I "CDBB()"Y6 procedure may have to use temporary storage during the& computation of a symbols bounding box., If it can not allocate the required memory,  .I "CDBB()"e returns with the value ofa	 .I False.d Otherwise, the value of\ .I True+ is returned. .PPu
 .I "CDInfo()"c returns the valueX .I Info ; of the integer information field of an object referenced bye .I Pointer.v If
 .I Pointer4 is a null pointer, then the value of the information! field of the symbol referenced byX
 .I SymbolDescX is returned. .PPn .I "CDSetInfo()"; sets the integer information field the object pointed to by  .I Pointer.  If
 .I PointerI is a null pointer, then the information field of the symbol referenced byP
 .I SymbolDesceL is set.  The information field is used extensively by KIC to mark the objectF or temporarily storing information while the object is being modified. .PPi .I "CDProperty()"s returns the pointeri .I PropertyaA that references the linked-list of properties associated with ther object referenced by .I Pointer.d If
 .I PointerE is a null pointer, then the property list of the symbol referenced byd
 .I SymbolDesc  is returned. The pointerI .I Property J is returned as a null pointer if there is no property list associated with the particular object. .PPD8 The property list structure is defined in Section 2.2.7.8 A property consists of an identifying integer and a null& terminated character string extension.> There is no standard set of properties or property values, and; CD never tries to interpret the entries in a property list.d= Property lists are available for the user's own specific use.a .PPe .I "CDAddProperty()"6 inserts property information into the property list of the object referenced by .I Pointer.d If
 .I Pointer4 is a null pointer, then the property is added to the) property list of the symbol referenced bye .I SymbolDesc.; The property information consists of an identifying integerI .I ValueF and a null-terminated character string extension that is pointed to by
 .I String. If .I "CDAddProperty()"' is unable to allocate memory, the valuen .I False% is returned.  Otherwise, the value ofr .I Truet is returned. .PPe .I "CDRemoveProperty()"e6 deletes property information from the property list of the object referenced by .I Pointer.  If
 .I Pointer8 is a null pointer, then the property is removed from the) property list of the symbol referenced bys .I SymbolDesc.  Every property with the value of .I Value is removed.  Ifh .I "CDRemoveProperty()"a5 has trouble allocating or releasing memory, the valuey .I False% is returned.  Otherwise, the value ofr .I True  is returned. .XSl. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.4.9. CD Integrityo .XEo .SHt .ne 4X 2.4.9. CD Integrity. .PP = After a symbol has been created or modified, it is eventuallyn< necessary to reflect the changes throughout the CD database.5 The following procedure is provided for this purpose:t .brh .s4u .nft   .ta \w'XXXXXXXXX'u .ne 3s 	int CDReflect(SymbolDesc) 	struct s *SymbolDesc;   .fiI .vse .rs( .DTe .PPe .I "CDReflect()"* must be invoked at certain times by the CD/ application if the symbol that is referenced by 
 .I SymbolDesclI is modified.  If the changes to the symbol has changed its bounding box, e	 a call toe .I "CDReflect()"H will update the bounding box information in every other symbol in the CD: database that references it either directly or indirectly. This procedure is called .I "bounding box propagation.", Only the changes to the symbol referenced by
 .I SymbolDescr$ are propagated through the database. .PP  The correct use of .I "CDReflect()"= is important and well worth an example.  Consider two symbolst .I X andr .I Y,a where symbol .I Y is called in .I X.t The bounding box of  .I Y is changed by some means.  Ify .I "CDReflect()"( is invoked with the symbol descriptor of .I X% as an argument, the changes to symbole .I Y3 will not be reflected in the bounding box of symbols .I X.r
 If however .I "CDReflect()"( is invoked with the symbol descriptor of .I Y) as an argument, all changes to the symbolb .I Y- will then be reflected in the bounding box ofP .I X and all other symbols that calln .I Y.h .PPp The value of .I False is returned if .I "CDReflect()": is unable to allocate new memory.  Otherwise, the value of .I Truep is returned. .bpm .XSe. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u, 	2.5. Two Dimensional Transformation Package .XEe .SH + 2.5. Two Dimensional Transformation Packaget .PPs; The following routines provide two dimensional, rectilinearl) transformations using integer arithmetic. 5 The package of routines includes such capabilities ast= translation, mirroring, rotation, a transformation stack, anda inverse transformations.? Transformations are modeled by three by three integer matrices.aB A further explanation of these procedures and how a transformation> may be modeled by an integer array is provided in [6] and [7]. .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		2.5.1. Initializationl .XEo .SHg 2.5.1. Initializationh .PPu: The following procedure initializes the transform package: .brs .s4r .nf    .ta \w'XXXXXXXXX'u
 	void TInit()X   .fi' .vsu .rs. .DTC .PPe .I "TInit()"H initializes the transform package and returns with the current transform, equal to the identity transform.  Unlike the
 .I "CDInit()"g
 procedure, .I "TInit()"F may be invoked more than once in an application program where the onlyF effect will be that all contexts in the transformation stack are lost.) This initialization routine is invoked by  .I "CDInit(),"G by KIC routines that capable of detecting a recursive symbol hierarchy, # and by interrupt handling routines.i .XSX. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u# 		2.5.2. The Current Transformations .XE  .SHm! 2.5.2. The Current Transformationt .PP;G The following eight procedures are used to access or modify the currento transformation:o .br; .s4r .nf    .ta \w'XXXXXXXXX'u .ne 2r 	void TIdentity()s   .if n .sp 2i .ne 2d 	void TTranslate(X, Y)
 	int X, Y;   .if n .sp 2c .ne 2m 	void TMY()r   .if n .sp 2I .ne 2  	void TMX()t   .if n .sp 2  .ne 2r% 	void TRotate(XDirection, YDirection)e 	int XDirection, YDirection;   .if n .sp 2  .ne 2  	void TPoint(X, Y) 	int *X, *Y;   .fi  .vs  .rs  .DT  .PPD .I "TIdentity()"E sets the current transformation to the identity matrix.  The previousd$ current transformation is destroyed. .PPr .I "TTranslate()",I postmultiplies the current transformation matrix by a transformation that  translates by a displacement oft
 .I "X, Y". .PPt
 .I "TMY()"I postmultiplies the current transformation matrix by a transformation thatqI mirrors the y-coordinates (i.e., mirrors in the direction of the y axis).w .PPt
 .I "TMX()"I postmultiplies the current transformation matrix by a transformation that I mirrors the x-coordinates (i.e., mirrors in the direction of the x axis).v .PP  .I "TRotate()"I postmultiplies the current transformation matrix by a transformation thatfF rotates counter-clockwise by an angle that is expressed as a CIF-styleE direction vector.  Only 0, 90, 180, 270 degree rotations are allowed.t .PPf Thes
 .I "TPoint()"e procedure transforms the point	 .I "X, Y" 7 by multiplying it by the current transformation matrix., .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u! 		2.5.3. The Transformation Stack  .XEl .SHh 2.5.3. The Transformation Stack  .PPr4 The transformation stack structure is defined in the
 .I "xforms.h"X file as follows: .brX .s4	 .nf.  F .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXX'u +\w'XXXX'u .ne 10 	#define	XFORMSTACKSIZE	100a   .if n .sp 2s= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ur 	/*D .ta \w'XXXXXXXXX'u" 	* Transformation stack structure. 	*/ = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uf 	struct tt {$ 		int ttStack[XFORMSTACKSIZE][3][3]; 		int ttSP;e 		int ttCurrent[3][3]; 		int ttInverseCurrent[3][3];  		};   .fie .vsl .rst .PPlB Transformations are saved in their respective three by three array representations in the
 .I ttStack stack structure member.  The .I ttSPeI integer member points to the current transformation on the stack, and thei/ current transformation is also contained in theX .I ttCurrent( array member.  When the user invokes the .I "TInverse()"tH procedure to compute the inverse of the current transform, the resulting% transformation matrix is saved in theo .I ttInverseCurrent  structure member.  .PPrK The following procedures are used for maintaining the transformation stack:  .br  .s4  .nfc   .ta \w'XXXXXXXXX'u .ne 2 
 	int TEmpty()    .if n .sp 2  .ne 2  	int TFull()   .if n .sp 2( .ne 2i
 	void TPush()e   .if n .sp 2o .ne 2e 	void TPop()   .if n .sp 2  .ne 2  	void TCurrent(TF)	 	int *TF;f   .fi  .vs  .rs  .DTD .PP"
 .I "TEmpty()"e returns the value of .I TrueoB if the transformation stack is empty.  If the transformation stack" is completely filled, the value of .I False is returned. .PPs .I "TFull()" returns the value of .I Truer= if the transformation stack is full.  Otherwise, the value ofo .I False is returned. .PPs .I "TPush()"F pushes the current transform onto the transformation stack.  The valueL of the current transform is not changed, and the transformation stack is not" checked for an overflow condition. .PPn .I "TPop()"rD pops the current transform from the transformation stack.  The valueE of the current transform becomes the transform that was most recentlyb: pushed onto the stack, and the transformation stack is not# checked for an underflow condition.  .PPt .I "TCurrent()" C places the current transform matrix in a nine integer array that istE passed from the calling program.  The first row of the transformationtF matrix appears as the first three integers in the argument, the secondI row of the transformation matrix appears as the next three integers, etc.e2 After several transformations have been defined by .I "TTranslate(), "a .I "TRotate(), " .I "TMX(), " and  .I "TMY(), "? it is possible to determine the minimum resultant or equivalentr= transformation through the examination of the elements of the B current transformation matrix as described in the following table: .brr .s4Y .nfh   .ne 10I .if t .ta \w'XXXXXX'u +\w'XXXXXX'u +\w'XXXXXX'u +\w'XXXXXX'u +\w'XXXXXX'ueD .if n .ta \w'X'u +\w'XXXXXX'u +\w'XXXXXX'u +\w'XXXXXX'u +\w'XXXXXX'u- \fB	TF[0]	TF[3]	TF[1]	TF[4]	Transformation\fReP .if t .ta \w'XXXXXX'u +\w'XX'u +\w'XXXXXX'u +\w'XXXXXX'u +\w'XXXXXX'u +\w'XXXX'uK .if n .ta \w'X'u +\w'XX'u +\w'XXXXXX'u +\w'XXXXXX'u +\w'XXXXXX'u +\w'XXXX'ue 	 	1	 0	 0	 1	Translate only. ( 	 	0	-1	 1	 0	Rotate 90 deg., translate.) 	 	0	 1	-1	 0	Rotate 180 deg., translate.t) 		-1	 0	 0	-1	Rotate 270 deg., translate.e% 		-1	 0	 0	 1	Mirror in X, translate.u% 	 	1	 0	 0	-1	Mirror in Y, translate.e5 	 	0	-1	-1	 0	Mirror in X, rotate 90 deg., translate. 6 	 	0	 1	 1	 0	Mirror in X, rotate 270 deg., translate.   .fia .vsn .rsa .PPPD For all cases, the X, Y translation vector is given by TF[6], TF[7]. .ne 5o .XSn. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u$ 		2.5.4. The Instance Transformation .XE  .SH " 2.5.4. The Instance Transformation .PPiI The following procedure is provided specifically for maintaining instancen transformations: .br  .s4f .nfi   .ta \w'XXXXXXXXX'u .ne 2h 	void TPremultiply()   .fit .vsx .rst .DTf .PPe? As an application program traverses a symbol hierarchy, it willrE maintain the current instance transformation by computing the product F of the symbols current transform and the transformation of its master. .I "TPremultiply()"'. forms the instance transform by premultiplying= the current transform with the transform that was last pushedu! onto the transformation stack andX9 placing the product in the current transformation matrix.XC Thus, the procedure for transforming the coordinates of an instance  is demonstrated below: .br; .s4nM .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'ua .nft   .ne 3b, 	/* push master cell transform onto stack */	 	TPush();n   .ne 3e( 	/* set current transform to identity */
 	TIdentity();l   .ne 5c? 	/* Invoke TMX, TTranslate, etc. to build instance transform */f 	TMX();a 	TMY();g 	TTranslate(Dx, Dy);   .ne 3s" 	/* Form the instance transform */ 	TPremultiply();   .ne 3r1 	/* Invoke TPoint to transform instance points */x 	TPoint(&X, &Y);   .ne 3i! 	/* return to master transform */f 	TPop();   .fie .vsi .rsy .XS". .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u. 		2.5.5. Inverse of the Current Transformation .XE  .SHu, 2.5.5. Inverse of the Current Transformation .PPtF The following procedures are used to obtain an inverse transformation: .brr .s4i .nf    .ta \w'XXXXXXXXX'u .ne 2  	void TInverse()   .if n .sp 2X .ne 3' 	void TInversePoint(X, Y)X 	int *X, *Y;   .fi  .vs  .rsw .DT+ .PPX .I "TInverse()"u3 computes the inverse of the current transformation.4E Computation of the inverse transformation does not affect the currentX transformation.  The .I "TInversePoint()" routine transforms the point	 .I "X, Y"\7 by multiplying it by the inverse transform matrix.  The  .I "TInversePoint()"( routine should not be invoked before the .I "TInverse()"tA procedure has computed the inverse of the current transformation.i .bpt .XSa. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u+ 	2.6. Traversing a Symbol Hierarchy with CDs .XE  .SH0* 2.6. Traversing a Symbol Hierarchy with CD .PP.8 The following routine is intended to display a symbol on= a graphics terminal.  The reader will note the use of the twoX2 dimensional transformation package described above as well as routines such as  .I "DisplayBox()"s! that display geometries on a CRT.lI It is assumed that the geometry display routines will accomplish whateverr& window-viewport clipping is necessary.3 This example is similar to the KIC display routine.  .br  .s4  .nf    .ne 18H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	#include "cd.h"   .if n .sp 2p 	main(){ 		     . 		     . 		     .' 		/* initialize transformation stack */s
 		TInit(); 		     . 		     . 		     . .ne 7e@ 		/* display SymbolName in the area Left, Bottom - Right, Top *// 		Display(SymbolName, Left, Bottom, Right, Top)o 		     . 		     . 		     . 		}n   .if n .sp 2a .ne 11. 	Display(SymbolName, Left, Bottom, Right, Top) 		char *SymbolName;  		int Left, Bottom, Right, Top;o 		{b 		struct s *SymbolDesc;' 		struct g *GenDesc; 		struct o *Pointer; 		struct t *TGen;v 		char *InstanceName;r 		int NumX, NumY, DX, DY;r 		int X, Y, Layer; 		char Type;   .ne 2i? 		/* open symbol named SymbolName (here we assume it exists) */n' 		CDOpen(SymbolName, &SymbolDesc, 'r');o   .ne 2n> 		/* initialize generator to return instances in SymbolName */? 		CDInitGen(SymbolDesc, 0, Left, Bottom, Right, Top, &GenDesc);I   .ne 7e 		loop {> 			/* Invoke CDGen to access a pointer to an instance array */( 			CDGen(SymbolDesc, GenDesc, &Pointer);   .ne 4I+ 			/* Have all instances been traversed? */  			if(Pointer == NULL)
 				break;   .ne 2 4 			/* push current transform of master onto stack */ 			TPush();    .ne 2i* 			/* set current transform to identity */ 			TIdentity();s   .ne 2 $ 			/* Access instance information */: 			CDCall(Pointer, &InstanceName, &NumX, &DX, &NumY, &DY);   .ne 2*A 			/* Initialize generator to return transform of InstanceName */a 			CDInitTGen(Pointer, &TGen);   .ne 14@ 			/* place instance transformation in current transformation */	 			loop {f! 				CDTGen(&TGen, &Type, &X, &Y);" 				if(TGen == NULL) 					break;T  				else if(Type == CDTRANSLATE) 					TTranslate(X, Y); 				else if(Type == CDMIRRORX) 					TMX();" 				else if(Type == CDMIRRORY) 					TMY();h 				else if(Type == CDROTATE)l 					TRotate(X, Y);a 				}i   .ne 2n; 			/* Combine transform of InstanceName with it's master */f 			TPremultiply();   .ne 2pB 			/* recursively call display to traverse and display instance */3 			Display(InstanceName, Left, Bottom, Right, Top);X   .ne 3 ( 			/* pop master transform from stack */
 			TPop(); 			}   .ne 2)# 		/* now traverse the geometries */r1 		for(Layer = 1; Layer <= CDNUMLAYERS; ++Layer) {o   .ne 2TC 			/* Set the current color to be a color associated with Layer. */T 			SetColor(Layer);    .ne 2/- 			/* initialize generator for layer Layer */(D 			CDInitGen(SymbolDesc, Layer, Left, Bottom, Right, Top, &GenDesc);   .ne 8Y	 			loop {i5 				/* Invoke CDGen to access pointer to an object */X) 				CDGen(SymbolDesc, GenDesc, &Pointer);s   				/* Last object? */ 				if(Pointer == NULL)i 					break;n   .ne 2n1 				/* Access the type of the geometry as Type */. 				CDType(Pointer, &Type);N   .ne 9e: 				/* Dispatch according to Type to specific procedure */ 				if(Type == CDBox) {  					/* Access the box */.% 					CDBox(SymbolDesc, Pointer, ...);y& 					/* Transform the box's center. */ 					TPoint(&X, &Y); 					/* Display the box. */p% 					DisplayBox(X, Y, Length, Width);t 					} .ne 14 				else if(Type == CDWire){ 					/* Access the wire */& 					CDWire(SymbolDesc, Pointer, ...); 					     .e 					     .p 					     .  					}
 				     .
 				     . 				    etc.
 				     .
 				     . 				}m 			} 		}y   .fic .vs) .rs  .DTn .bp* .SHi 2.7. Translation Routinesn .PPe- The layout description language of CD is CIF.LC The following routines are used by CD to generate or interpret CIF:e .brn .XSc. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	2.7. Translation Routines .XE  .s4  .nf	   .ta \w'XXXXXXXX'us .ne 5r# 	int CDTo(CIFFile,Root,A,B,Program)  	char *CIFFile,*Root;		 	int A,B;r 	char Program;   .if n .sp 2t .ne 5 6 	int CDFrom(Root,CIFFile,A,B,Layers,NumLayers,Program) 	char *Root,*CIFFile,Program;  	int *Layer,NumLayers;	 	int A,B;m   .if n .sp 2C .ne 4n% 	int CDParseCIF(Root,CIFFile,Program)& 	char *Root,*CIFFile,Program;e   .if n .sp 2e .ne 5a8 	int CDGenCIF(FileDesc,SymbolDesc,SymbolNum,A,B,Program) 	FILE *FileDesc; 	struct s *SymbolDesc; 	int *SymbolNum,A,B; 	char Program;   .fif .vs	 .rsn .DTn .PPp .I "CDTo()"   translates from a CIF file named
 .I CIFFileG into symbol files, each having a file name identical to the symbol thatR2 it contains.  CIF commands that are not between a  .I DSY and a matching .I DF=# are stored in the file specified by	 .I Root.# All objects are scaled by the ratioa .I "A/B" microns per lambda.	 .PPm .I "CDTo()"  will call the routinel .I "PCIF()"yJ to read the input CIF file.  The requirements for this parser can be found in Section 2.4.3 describing theo
 .I "CDOpen()"o> routine and in the section that describes the fast CIF parser. .PPe4 Because there are different styles of CIF that embed' symbol names differently, the charactern
 .I Program	 will tells .I "CDTo()"  and the parser .I "PCIF()")9 which style of CIF to expect.  Before calling the parser,( .I "CDTo()"n sets the .I dProgramtA character in the CD parameters structure described in Section 2.8k to the character .I Program. K By accessing this structure member, the parser determines the origin of the	 CIF.  The following values for
 .I Program- are valid for the fast CIF parser used by CD:n .bra .s4  .nf    .ne 120 .ta \w'XXXXXXXX'u +\w'XXX'u +\w'XXXXXXXXXXXXXX'u 	\fBProgram	CIF format\fR  		'a'	Stanford CIF,u 		'b'	NCA CIF,. 		'e'	Berkeley's KIC with property extensions, 		'h'	HP's IGS,i 		'i'	Xerox's Icarus,  		'k'	Berkeley's KIC," 		'm'	mextra-style CIF,e 		's'	Xerox's Sif, 		'n'	none of the above.   .fi  .vse .rsr .DTa .PPm If the .I "CDTo()" E routine encounters any difficulty in the CIF conversion, the value off .I False is retuned,Y .I CDStatusInt is set to value of .I CDPARSEFAILED, % and a diagnostic message is placed inu .I CDStatusString. .PPt TheI
 .I "CDFrom()" @ routine translates a symbol hierarchy rooted at the symbol named .I RootX into a CIF file namedX .I CIFFile. 6 The style of CIF output is identified by the character .I Program.0 The valid arguments forl
 .I Program are the same as for then .I "CDTo()"i
 procedure.# All objects are scaled by the ratioa .I "A/B") microns per lambda during the conversion.o. It is assumed that all instances in the symbol+ hierarchy exist in the current search path.  .PPd They	 .I Layers $ argument is a pointer to an array of .I NumLayersD integers that are used to mask certain layers in CD layer table.  If .I "Layers[N]" is zero, where .I N# is a non-negative integer less than 
 .I NumLayers, ' then any object that is on layer numberX .I N= in the CD layer table will not appear in the CIF output file.s .PPe If
 .I "CDFrom()"t9 encounters any difficulty in the conversion, the value ofe .I False is retuned and .I CDStatusInt4 is set to one of the following values defined in the .I cd.ho file:i .brc .s4  .nf	   .ne 3 K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u)G .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u 3 	#define	CDPARSEFAILED	1	/* (FATAL) parse failed */i6 	#define	CDNEWSYMBOL	3	/* symbol not in search path */6 	#define	CDMALLOCFAILED	11	/* (FATAL) out of memory */   .fit .vse .rse .DT  .PPC  If no difficulty is encountered,
 .I "CDFrom()"l returns with the value ofl .I True. .PPt Theh .I "CDParseCIF()"o< procedure will create a CD database rooted at a symbol named .I Rootl from a CIF filet
 .I CIFFileC rather than building the database from a hierarchy of symbol files.n5 The style of CIF input is identified by the character  .I Program.t The valid arguments fors
 .I Program are the same as for ther .I "CDTo()"h routine. .PP	 When .I "CDParseCIF()"uA encounters a reference to a layer that was not previously defined " in the CD layer table by a call to .I "CDSetLayer(),"A the new layer is added to the layer table.  This differs from theF
 .I "CDFrom()"I and 
 .I "CDOpen()"K1 routines that return CDPARSEFAILED whenever they iE encounter an undefined layer.  A layer is considered undefined if the	 .I lTechnology6 field in the CD layer table is a blank character.  See5 Section 2.2.8 that describes the CD layer descriptor.u .PPn If .I "CDParseCIF()"e9 encounters any difficulty in the conversion, the value oft .I False is retuned and .I CDStatusInt4 is set to one of the following values defined in the .I cd.hI file:m .br  .s4n .nfn   .ne 3sK .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u G .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uP3 	#define	CDPARSEFAILED	1	/* (FATAL) parse failed */h6 	#define	CDNEWSYMBOL	3	/* symbol not in search path */6 	#define	CDMALLOCFAILED	11	/* (FATAL) out of memory */   .fi  .vso .rsi .DT  .PP   If no difficulty is encountered,
 .I CDParseCIFh returns with the value ofc .I True. .PP  .I "CDGenCIF()"  is used by the .I "CDTo()"r7 routine to generate a CIF file identified by the streama .I FileDescC of the CD symbol referenced by .I SymbolDesc. The integera .I SymbolNum@ contains the number of the first symbol created in the CIF file;G the value will be incremented by one for succeeding symbol definitions. 6 The style of CIF output is identified by the character .I Program,n and the valid arguments forl
 .I Program are the same as for thes .I "CDTo()"f
 procedure.# All objects are scaled by the ratioi .I "A/B") microns per lambda during the conversion.X If
 .I "CDFrom()"+I encounters any difficulty in acquiring or allocating memory, the value ofw .I False is retuned and .I CDStatusInt7 is set to the value of CDMALLOCFAILED as defined in the	 .I cd.h4' file.  If no difficulty is encountered,c .I "CDGenCIF()"  returns with the value ofn .I True. .bp	 .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u" 	2.8. The CD Parameters Descriptor .XE  .SH ! 2.8. The CD Parameters Descriptorv .PPr9 Several parameters are required by CD to control actions. * The CD parameters struct is defined in the	 .I "cd.h"n file as follows: .brC .s4g .nft  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uX .ne 9' 	struct d {  		/*> .ta \w'XXXXXXXX'u +\w'XXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u* 		* DCONTROLCDOPEN denotes CD is in CDOpen; 		* DCONTROLPCIF denotes CD is in parsing CIF in CDParseCIF & 		* DCONTROLCDTO denotes CD is in CDTo6 		* DCONTROLVANILLA denotes CD is in none of the above 		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ur 		char dControl;   .if n .sp 2a .ne 2,= 		/* Current parameters for symbol being parsed in CDOpen. */e 		int  dNumX,dDX,dNumY,dDY;r   .if n .sp 2F .ne 2;* 		/* Scale factors for CDTo and CDFrom. */ 		int dA,dB;   .if n .sp 2v .ne 2n 		/* Symbol scale factors. */n 		int dDSA,dDSB;   .if n .sp 2C .ne 2  		struct o *dPointer;  		struct s *dSymbolDesc; 		struct s *dRootCellDesc;   .if n .sp 2o .ne 3t4 		/* UNIX file names are limited to 14 characters */! 		char dSymbolName[FILENAMESIZE];b 		FILE *dSymbolFileDesc;   .if n .sp 2h .ne 3a 		/*> .ta \w'XXXXXXXX'u +\w'XXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		* Fields used in CDTo follow.  		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uh   .if n .sp 2i .ne 2L$ 		/* True if parsing root symbol. */ 		int dRoot;   .if n .sp 2  .ne 2f 		/* Root's file desc. */e 		FILE *dRootFileDesc;   .if n .sp 2l .ne 2 5 		/* Current property list for symbol being parsed */l 		struct prpty *dPrptyList;a   .if n .sp 2d .ne 12 		/*> .ta \w'XXXXXXXX'u +\w'XXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u) 		*   dProgram   ==  'a' if Stanford CIF. $ 		*   dProgram   ==  'b' if NCA CIF.B 		*   dProgram   ==  'e' if Berkeley CIF with property extensions.% 		*   dProgram   ==  'h' if HP's IGS.l/ 		*   dProgram   ==  'i' if Xerox's Icarus CIF.I) 		*   dProgram   ==  'k' if Berkeley CIF.I- 		*   dProgram   ==  'm' if mextra-style CIF.f) 		*   dProgram   ==  's' if Sif gened it. . 		*   dProgram   ==  'n' if none of the above. 		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ui 		char dProgram;   .if n .sp 2e .ne 8I 		/*> .ta \w'XXXXXXXX'u +\w'XXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u0 		* Symbol name table for CIF file being parsed.= 		* UNIX file names are 14 characters, VMS names are smaller.e 		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 2 		char dSymTabNames[CDNUMREMEMBER][FILENAMESIZE]; % 		int dSymTabNumbers[CDNUMREMEMBER]; o 		int dNumSymbolTable;   .if n .sp 2e .ne 8  		/*> .ta \w'XXXXXXXX'u +\w'XXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u< 		* Because CIF files may have FORWARD references, CDTo must> 		* pass over the CIF file TWICE.  On the first pass,  it just# 		* fills up the symbol name table.X 		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'us 		int dFirstPass;N   .if n .sp 2s .ne 8i 		/* True if debugging */ 
 		int dDebug;D 		int dNumSymbolsAllocated;  		}R 	CDDesc;   .fi  .vs  .rsn .PPt, The contents of the CD parameters descriptor	 .I CDDesc\2 are available to all source files that include the	 .I "cd.h" 6 header file.  Most of the members in the CD parameters8 structure are used for the parsing or generating of CIF.6 They are used most frequently by the parser and action9 routines as working storage space for symbol information.n? See Chapter 3 that describes the CIF parser and action routines ; for a complete explanation of the use of each member in the  CD parameters descriptor.  .bpn .XSa% \fBChapter 3:  The Fast CIF Parser\fRd .XEl .DS CL .ps +4 .B "Chapter 3" .psF .DEs .sp 1i .DS C  .ps +4 .B "The Fast CIF Parser" .ps' .DE' .sp 2X .PP+D The CIF parser is the set of routines that interface KIC and CD to a3 standard intermediate layout language (CIF) and theh. secondary storage site for symbol definitions.> This section describes the requirements of the layout language3 parser and the parameters that control its actions.  .PPn The term .I fastpL is used here to indicate that whenever there was a choice to be made betweenL the size of the routines and their respective speed, the decision has alwaysK been to optimize for speed.  Consequently, the parser is the largest module'F in KIC.  With the optimizations that have been made to the parser, the
 .I "CDOpen()" B routine is nevertheless limited by the speed of the parser that is7 impeded by the excessive overhead of memory allocation.e .PP 7 Three source files constitute the CIF parser; they are   .I "parser.c, actions.c,"h ande .I "gencif.c." The routines in 
 .I "parser.c" F scan the input file for the primitive commands of the layout language.F The action routines are invoked by the parser when a primitive commandG is found.  The gencif routines produce the primitives of the CIF layout 3 language in the syntax that the parser understands.u .PPn> Because the data model for the CD database is CIF, it would beD difficult to replace the fast CIF parser with that of another layoutI language if the user should decide to do so.  It is nevertheless possiblen
 to make CD .I speakC in another language, given that the layout language is hierarchical'4 and has similar geometry types.  To accomplish this,5 the programmer would have to replace the source filesT .I "parser.c, actions.c,"i andN
 .I "gencif.c"y" as well as rewrite the CD routines. .I "CDUpdate(), CDGenCIF(), CDTo(), CDFrom()," and  .I "CDParseCIF()." .bp  .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	3.1. Action Routines  .XEu .SHP 3.1. Action Routines .PPe? The function of the parser is to interpret the layout language, I and the action routines are used by the parser to complete tasks that are.E specific to primitive commands of the layout language in one of threer3 contexts.  The context of actions is defined by they .I dControl % member of the CD parameter descriptor 	 .I CDDescr7 that can have one of four value that are defined in the 	 .I "cd.h"k file as follows: .brr .s4= .nf'  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'urG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uw .ne 8  	/*X .if t .ta \w'XXXXXXXXX'u .if n .ta \w'XXXXX'u 	* CD Control flags  	*/XK .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'ueG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'ue 	#define	DCONTROLCDOPEN	'o'r 	#define	DCONTROLPCIF	'p'e 	#define	DCONTROLCDTO	't'd 	#define	DCONTROLVANILLA	'v'   .fio .vs  .rs  .DTe .PPIB This section will describe the purpose of each of the above flags. .PPa3 The action routines are invoked only by the parser.tJ The DCONTROLVANILLA control character flag indicates that CD is not in theL process of parsing CIF.  An action routine should therefore never be invoked+ when the control flag is set to this value.  .PPtE The DCONTROLCDTO control flag is used to signify that CD is currently > translating a CIF file into individual KIC or CD symbol files.K The action to be performed for this case is to output the primitive command * that was found by the parser directly into# the respective symbol file.  If theh .I "CDDesc.dRoot"sC flag is non-zero, output will be directed to the file referenced bye .I "CDDesc.dRootFileDesc,"? and output will otherwise be directed to the file referenced byl .I "CDDesc.dSymbolFileDesc." .PP  The root file descriptor .I "CDDesc.dRootFileDesc"l is initialized bye .I "CDTo()"o; or whatever procedure that would invoke the parser with the  .I "CDDesc.dControl"& flag set to the value of DCONTROLCDTO. The symbol file descriptor .I "CDDesc.dSymbolFileDesc"o1 however must be initialized by the action routinee .I "ABeginSymbol()"i@ which is invoked for a new symbol definition, and therefore thisG action routine must be capable of determining the symbol name dependingeA on the particular style of CIF that is identified by the value ofC .I "CDDesc.dProgram."" Also this routine must set .I "CDDesc.dRoot"XB to zero to direct subsequent output to the respective symbol file. The symbol file is closed andP .I "CDDesc.dRoot" % is set to unity by the action routinea .I "AEndSymbol()"c; which is invoked at the termination of a symbol definition.r .PPp6 Because CIF may contain forward references to symbols,M it is necessary for the action routines to build and maintain a symbol table. F As a result, the parsing is a two-pass operation, where the first pass; is dedicated to the construction of the symbol table by theo .I "ABeginSymbol()"n: action routine.  The symbol table is represented in the CD- parameters descriptor as follows: the integer' .I dNumSymbolTableD is a count of the current symbols in the table.  The character array. .I "dSymTabNames[CDNUMREMEMBER][FILENAMESIZE]"( contains the symbol names, and the array" .I "dSymTabNumbers[CDNUMREMEMBER]"* contains the corresponding symbol numbers.- .de e1 \"equation for scale CDTo scale factor	 .DS C 5 (CDDesc.dB * CDDesc.dDSA) / (CDDesc.dA * CDDesc.dDSB)'   .DEh .. .PPb6 All measurements are be scaled by the following value: .e1N The integer values .I "CDDesc.dDSA" andi .I "CDDesc.dDSB"> are the symbol scale factors, dimensionless, and are currently( always set to unity.  The integer values .I "CDDesc.dA" and  .I "CDDesc.dB"8 define respectively the micron per lambda scaling ratio.? Because the conversion is from CIF, for which the database unitX@ is one one-hundredth of a micron, to KIC or CD format, for which< the database unit is one-hundredth of a lambda, the value of .I "CDDesc.dB" is in the numerator.3 The scale factor is computed for every metric valueD> to avoid the use of floating point arithmetic; because integer? arithmetic is significantly more fast than floating point, thisb is not a severe penalty. .PPtD The DCONTROLCDOPEN control flag is used when CD is currently parsingE a symbol file.  This action differs significantly from the previously I described actions in that the CD database is constructed in local memory.cA When objects are discovered by the parser, the action routine forrF the object will insert it into the the symbol descriptor referenced by .I "CDDesc.dSymbolDesc"D which is initialized by the 
 .I "CDOpen()" A procedure.  Consequently, there is one action routine for each ofP= the CD object creation procedures described in Section 2.4.4.d6 There is no scaling performed on the objects when theyE are inserted into the symbol storage bins; metric data is representedo@ in one one-hundredth lambda units in the KIC or CD symbol files. .PPO; Because the creation of an instance requires the invocationnE of several CD procedures using the same object pointer, the parametern .I "CDDesc.dPointer"C is used as the object descriptor pointer for all CD object creationc, procedures.  The property list referenced by .I "CDDesc.dPrptyList"8 as attached to each object or symbol after its creation.: This allows property information to be saved in the CIF as user extensions. .PP H The KIC or CD symbol files contain extensive information that allows theJ handling of forward references to be postponed until all geometric objectsG have been parsed, and thereby avoid two passes through the symbol file.c: When a symbol call is encountered, the action routine willG insert the object descriptor for the instance into the storage bins andaB a reference is made in the master-list of the calling symbol.  The .I "CDBeginMakeCall()"< procedure will not attempt to open the instance in CD if the .I "CDDesc.dControl" flag is set to DCONTROLCDOPEN.6 When the parsing of a particular symbol has completed,
 .I "CDOpen()"aC will begin traversing the symbol's master-list, read all referencedSC symbols into the database if they have not already been opened, andl
 invoke the .I "CDReflect()"J procedure to reflect the bounding box of the every instance throughout the# CD database.  This algorithm allows 
 .I "CDOpen()"iA to be called recursively to build a multi-level symbol hierarchy.  .PPn TheK
 .I "CDOpen()", routine will set the .I "CDDesc.dControl"@ control flag to the value of DCONTROLVANILLA before terminating. .PP = The DCONTROLPCIF control flag is used when CD is constructinguN the database from a CIF file instead of a directory of KIC or CD symbol files.K The actions to be performed are often identical to those for DCONTROLCDOPENRF where the major differences are in the handling of symbol definitions. The symbol descriptor  .I "CDDesc.dSymbolDesc"e is initialized by  .I "CDParseCIF()" ; or whatever procedure that would invoke the parser with thee .I "CDDesc.dControl"& flag set to the value of DCONTROLPCIF. The symbol descriptore .I "CDDesc.dRootFileDesc,"% is used as temporarily storage of thec .I "CDDesc.dSymbolDesc" ' symbol descriptor by the action routine  .I "ABeginSymbol()"oJ which is invoked when a new symbol definition is discovered by the parser.G This action routine will then open a new symbol in the database for thet9 new symbol definition and therefore this routine must be oB capable of determining the respective symbol name depending on the: particular style of CIF that is identified by the value of .I "CDDesc.dProgram."r The descriptor pointer .I "CDDesc.dSymbolDesc"e is again set to the pointers .I "CDDesc.dRootFileDesc," by the action routineb .I "AEndSymbol()"c; which is invoked at the termination of a symbol definition.s .PPsE When objects are discovered by the CIF parser, the action routine forlF the object will insert it into the the symbol descriptor referenced by .I "CDDesc.dSymbolDesc."6 There is no scaling performed on the objects when they* are inserted into the symbol storage bins.$ An application program that uses the .I "CDParseCIF()"d routine must be aware thatG .I "the size of the CD database unit is one one-hundredth of a micron."  .PPr6 Because CIF may contain forward references to symbols,0 it is again necessary for the action routines to" build and maintain a symbol table.F As a result, the parsing is a two-pass operation, where the first pass; is dedicated to the construction of the symbol table by theh .I "ABeginSymbol()"a: action routine.  The symbol table is represented in the CD- parameters descriptor as follows: the integerI .I dNumSymbolTableD is a count of the current symbols in the table.  The character array. .I "dSymTabNames[CDNUMREMEMBER][FILENAMESIZE]"( contains the symbol names, and the array" .I "dSymTabNumbers[CDNUMREMEMBER]"* contains the corresponding symbol numbers. .PP 4 When the parsing of the CIF file has been completed, .I "CDParseCIF()"t5 will traverse the master-lists of all symbols for ther> purpose of assuring that all referenced symbols are defined in3 the database and for bounding box propagation.  Then .I "CDBeginMakeCall()"H procedure will not try to open the referenced symbol if the control flag .I "CDDesc.dControl"J is set to DCONTROLPCIF, and the bounding box in the respective master-list= descriptor is set to a null box having zero width and heigth.fM This is necessary because a referenced symbol may not have been inserted intolK the database at the time that the call command is recognized by the parser.e .bps .XSe( \fBChapter 4:  The KIC User Interface\fR .XEe .DS Cd .ps +4 .B "Chapter 4" .pss .DEu .sp 1s .DS Ci .ps +4 .B "The KIC User Interface"e .pse .DEo .sp 2n .XSl. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u$ 	4.1. Window and Viewport Management .XEm .SHn# 4.1. Window and Viewport Managementn .PPmF A window is an area in a world coordinate system that contains objectsI to be displayed.  A viewport is the area on the graphics display in whichnL the user views the contents of a window.  In other words, the window definesL the objects in the database to be displayed, and a viewport defines where toO display the objects.  The world coordinate system in KIC contains the CD symbolbE that is currently being edited.  The unit of measurement in the worldPM coordinate system is one one-hundredth of a lambda, the same unit used by CD.  .PPtD A window may intersect an object in the current symbol such that the= object is not contained entirely in the window, in which casew the object would have to beh
 .I clipped5 to the window before it is displayed in the viewport.DC For KIC, all windows and viewports are rectangular which simplifiesb! the geometry clipping procedures.m .PP.F The coordinate system in a window is identical to the world coordinateK system.  The coordinates in a viewport usually correspond to the resolution.J of the graphics display; this provides one viewport coordinate per displayK pixel.  The origin of the coordinate system for the layout viewports in KIC)7 is assumed to be the lower, left corner of the display.h8 KIC uses a different coordinate system for the viewportsJ that contain only textual information.  In this textual coordinate system,E a coordinate refers to a character block, and the origin is the uppersM right corner of the graphics display.  For example, the text coordinate (1,1)rJ refers to the graphical text character in the upper-most row and left-mostJ column of the display;  the text coordinate (5,10) refers to the graphicalI text character in the fifth row and tenth column of the graphics display.  .PPaE KIC divides the graphics display into six viewports: the command menu @ viewport, the layer menu viewport, the information viewport, theI prompt viewport, and the course and fine layout viewports.  The followingi; figure illustrates the relative positions of each viewport. 8 .de f4 \"layout of graphics display (Figure 2) for nroff .DS Ce .ne 28G .ta \w'XXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'ua8 -------------------------------------------------------- |	|	|4N .ta \w'XXX'u +\w'XXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u |	C	|	|D |	O	|	|  |	M	|	|h |	M	|	|r |	A	|	|e |	N	|	|  |	D	|	| U .ta \w'XXX'u +\w'XXX'u +\w'XXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'ua |		|	LAYOUT VIEWPORTS	|WN .ta \w'XXX'u +\w'XXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u |	V	|	|t |	I	|	|e |	E	|	|  |	W	|	|t |	P	|	|D |	O	|	|t |	R	|	|g |	T	|	|oG .ta \w'XXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u  |	|	|p8 --------------------------------------------------------G .ta \w'XXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'ue |	PROMPT VIEWPORT		|8 --------------------------------------------------------G .ta \w'XXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'ul |	INFORMATION  VIEWPORT		|8 -------------------------------------------------------- |	LAYER  MENU  VIEWPORT		|8 -------------------------------------------------------- .DE  ..8 .de f5 \"layout of graphics display (Figure 2) for troff .ft IC .cs I 30 .ne 39 .nf   C .ta \w'XXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'ue	 .vs -.10iC4  __________________________________________________ " \h'.08i'|  \h'-.05i'C	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'O	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'M	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'M	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'A	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'N	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'D	|	\h'-.04i'| \h'.08i'|	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'M	|	\h'-.04i'|J .ta \w'XXXXXX'u +\w'XXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u3 \h'.08i'|  \h'-.05i'E	|	LAYOUT VIEWPORTS	\h'-.04i'|lC .ta \w'XXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'uo" \h'.08i'|  \h'-.05i'N	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'U	|	\h'-.04i'| \h'.08i'|	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'V	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'I	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'E	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'W	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'P	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'O	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'R	|	\h'-.04i'|" \h'.08i'|  \h'-.05i'T	|	\h'-.04i'|= \v'-.12i' __________________________________________________ .J .ta \w'XXXXXX'u +\w'XXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u/ \v'-.11i'\h'.08i'|		PROMPT VIEWPORT 	\h'-.04i'| = \v'-.23i' __________________________________________________  J .ta \w'XXXXXX'u +\w'XXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u4 \v'-.225i'\h'.08i'|		INFORMATION VIEWPORT	\h'-.04i'|= \v'-.35i' __________________________________________________ -J .ta \w'XXXXXX'u +\w'XXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u= \v'-.34i'\h'.08i'|		\h'-.06i'LAYER MENU VIEWPORT  	\h'-.04i'|	> \v'-.465i' __________________________________________________  .fi' .vs' .DTX .cs IX .ftX ..	 .if n .f4a	 .if t .f5U .DS CO+ \v'-.38i'\fBFigure 2.  The KIC viewports\fRX .DEX .PPX= KIC represents windows and viewports with the area descriptor	 that is defined in the  
 .I "kic.h" file as follows: .br  .s4X .nfX  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u- 	/*- .ta \w'XXXXXXXXX'u 	* Area structure  	*/w= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u' 	struct ka {' 		int kaLeft, kaBottom, kaRight, kaTop;- 		int kaX, kaY;- 		float kaWidth, kaHeight; 		};   .fiX .vsX .rsX .DTX .PPX@ See Section 4.2 that describes the basic KIC data structures for- an explanation of the area structure members.M .XSV. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		4.1.1. Text Viewports  .XE  .SH5 4.1.1. Text Viewportsi .PP H There are four viewports used by KIC for displaying textual information;M the layer menu viewport, the information viewport, the command menu viewport,_E and the prompt viewport.  Because the position of the prompt viewport|F can be computed from the parameter viewport, the first three viewports are defined in the
 .I "kic.h" header file as follows:' .brh .s4i .nfh  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ui .ne 14 	/*	 .ta \w'XXXXXXXXX'u 	* KIC text viewports0 	*/ = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uX 	struct ka MenuViewport; 	struct ka LayerTableViewport; 	struct ka ParameterViewport;X   .fiX .vsX .rsX .PPXK As described above, KIC uses a special coordinate system for viewports that	H display only textual information.  A coordinate in this system refers toA the space of one character block on the display given that no twoiF characters overlap.  The size and position of textual viewports in KICC are always represented by these character-block units, and only the0 .I "kaLeft, kaBottom, kaRight,"- and| .I kaTopL members of the respective area structure are used to define a text viewport.K By using this character block representation of graphic text, KIC simulatesM# a typical ASCII character terminal._ .XS_. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 			4.1.1.1. Layer Menu Viewportw .XEi .SHe 4.1.1.1. Layer Menu Viewport .PPsI The layer menu viewport is used by KIC to display the names and colors ofw) all layers in the KIC or CD layer tables. L The layer menu viewport always occupies the bottom text rows of the display,K and is described first because the size and position of all other viewportsr depend on it's size.  I KIC will display in the layer viewport only those layers that are definedoL in the layer table, and therefore the size of the layer menu viewport is notG fixed.  KIC computes the number of layer names that can be displayed inr( a single row and saves this value in the .I kpLayersPerMenuRowsH member of the KIC parameters structure that is described in Section 4.3;D a layer name is assumed to be less than or equal to four characters.G From the number of layers defined in the layer table, KIC then computesa= the number of text rows required for the layer menu viewport. ' These computations are performed by thec .I "InitViewports()"4 procedure.  After the viewports are initialized, the .I "ShowLayerTable()"nK procedure is invoked to display the layer table in the layer menu viewport.a .PPr# The layer menu viewport is indeed a  .I menui- in that it is used to indicate and select thes .I "current layer."t' The current layer is represented by the 
 .I kpLayer< member of the KIC parameters structure and defines the layer; to be used by layer dependent commands such as the geometryr= creation procedures.  The current layer is indicated by a boxX1 around the name of the layer that is drawn by theX .I "OutlineText()"A procedure.  When the KIC user points at a layer name in the layer_5 menu viewport with the graphical pointing device, theX .I "PointLayerTable()"@ procedure is invoked to determine the next current layer in KIC. .XSY. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 			4.1.1.2. Parameter Viewport .XE_ .SH_ 4.1.1.2. Parameter Viewport  .PP > The parameter viewport occupies the graphical text row that is* immediately above the layer menu viewport.? It displays current information such as the name of the currentl0 symbol and the width of the large, coarse window? in lambda units.  This information is displayed by invoking theo .I "ShowParameters()"aM procedure.  Also displayed in the parameter viewport is the lambda coordinateeG of the last point entered through the graphical pointing device and theaJ displacement of this coordinate from the location of the previous pointing5 event.  This information is displayed by invoking the	
 .I "ShowXY()"  routine. .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 			4.1.1.3. Prompt Viewporte .XEK .SH  4.1.1.3. Prompt Viewport .PPwG The prompt viewport occupies the graphical text row that is immediatelyaF above the parameter viewport and displays information that is relevantB to the command procedure that the KIC user currently is executing.F A character string is displayed in the prompt viewport by invoking the .I "ShowPrompt()"t or .I "ShowPromptAndWait()"F procedures.  The latter procedure will a bell character (control-G) toN alarm the user of the prompt, and then wait for two seconds before continuing. .PPe* As it's name suggests, the prompt viewportA is also used to prompt the KIC user for keyboard input.  When theeE user responds to the prompt by typing at the keyboard of the graphicseE device, the characters that he types will be displayed (or echoed) inoA the prompt viewport.  To inform the keyboard input routine of theoE character position at which to begin displaying input characters, thei5 character size of every prompt string is saved by ther .I "ShowPrompt()"t routines in thee .I fLastCursorColumnP member of the current frame buffer structure that is described in Section 4.6.1. .XSd. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u! 			4.1.1.4. Command Menu Viewportd .XEh .SHI 4.1.1.4. Command Menu Viewport .PPsJ The command menu viewport is a textual viewport used by KIC to display theJ current command set or command menu.  A command menu in KIC is representedF by an array of character strings, each string containing the name of aJ particular command.  When the KIC user points in the command menu viewportK with the graphical pointing device, the string that is displayed on the row"* to which the user pointed is placed in the .I kpCommand- buffer in the KIC parameters structure by theX .I "Point()"6 procedure to identify the selection of a command.  The .I "Point()". procedure is described further in Section 4.5. .PPiF The width of the command menu viewport is exactly five columns or fiveH character block units, which requires command names to be no longer thanC five characters.  The left edge of the command menu viewport is theXE is the left edge of the graphics display, and the top of the viewport C is also the top of the display.  The bottom row of the command menu+B viewport is the row that is immediately above the prompt viewport. .PP ? A command menu is displayed in the command menu viewport by the  .I "ShowMenu()"e< procedure.  When a menu command is selected by the KIC user, it is highlighted by the .I "MenuSelect()" 
 procedure. .XS'. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		4.1.2. Layout Viewports. .XET .SHi 4.1.2. Layout Viewports  .PPv4 There are two windows in KIC that will map to one of2 three viewports for displaying layout information;F the coarse viewport, the large coarse viewport, and the fine viewport.B No more than two layout viewports are ever used at any given time.3 The layout windows and viewports are defined in thee
 .I "kic.h" file as follows: .brs .s4b .nfs  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uw .ne 14 	/*  .ta \w'XXXXXXXXX'u) 	* Windows and the viewports they map to.  	*/X= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ua 	int FineViewportOnBottom;& 	int FineWindowWidth,FineWindowHeight;' 	struct ka CoarseViewport,CoarseWindow;d4 	struct ka LargeCoarseViewport,SmallCoarseViewport; # 	struct ka FineViewport,FineWindow;u   .fir .vsn .rsc .PPn The coarse windowb .I CoarseWindowu5 is typically used to define the general area in which , the KIC user is working, and the fine window
 .I FineWindows7 defines a smaller working area with greater resolution. - The fine window is generally contained in thed= area of the coarse window, but is not constrained to be such.o .PPtN The four defined viewports are allocated as follows: the large coarse viewport .I LargeCoarseViewportI represents the entire area of the screen that is dedicated for displayingiI layout information.  The fine viewport represents either the bottom thirdoE or the left half of the layout area depending on the logical value ofn .I FineViewportOnBottom.M After the display area of the fine viewport has been allocated, the remaining 7 layout area is represented by the small coarse viewport  .I SmallCoarseViewport.eH The current coarse viewport, the one that will be displayed depending on@ the width of the coarse window, is represented by the descriptor .I CoarseViewport.F Unlike text viewports, the layout viewports are measured by numbers ofB display pixels.  The size of the large and small coarse viewports,< the fine viewport, and all text viewports is computed by the .I "InitViewport()"l
 procedure. .PPrB The coarse window is displayed in either the large coarse viewport@ or the small coarse window depending on the width of the window.A When the number of pixels per lambda in the large coarse viewporte exceeds roughly the value of .I kpPointingThresholdB in the KIC parameters structure, only the large coarse viewport is2 displayed, and the fine viewport is not displayed.5 For larger windows, the contents of the coarse windowX@ are displayed in the small coarse window, and the fine window is& displayed in the fine coarse viewport.C The decision of whether the coarse window is displayed in the largey' or small coarse viewport is made in thee .I "SwitchToFinePositioning()"
 procedure. .PPoL To generalize, there are two modes in KIC for displaying layout information;K one mode is to display only the coarse window in the large coarse viewport, G and the second mode is to display the coarse window in the small coarse'= viewport and to display the fine window in the fine viewport.rB The current mode of display can be determined from the contents of .I kpRedisplayControlt@ in the KIC parameters structure that can assume one of following values defined inp
 .I "kic.h" file:  .brc .s4L .nfo  O .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uvK .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uf .ne 10 	/*a .if t .ta \w'XXXXXXXXX'u .if n .ta \w'XXXXX'u 	* Viewport control flagso 	*/eO .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXX'ulK .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u  	#define	SPLITSCREEN	'b' 	#define	FINEVIEWPORTONLY	'f'  	#define	COARSEVIEWPORTONLY	'c't   .fir .vsr .rsw .PP > If both the fine and small coarse viewports are displayed, the .I kpRedisplayControlyG parameter will be assigned the value of SPLITSCREEN by default, and the+ .I kpDisplayFineViewport% parameter will be set to the value of. .I True.4 If only the large coarse viewport is displayed, then .I kpRedisplayControli? will assume the value of COARSEVIEWPORTONLY by default, and thet .I kpDisplayFineViewport% parameter will be set to the value ofc	 .I False. J By setting the display control parameter to the value of FINEVIEWPORTONLY,< only the fine viewport will be updated by a display routine,H and the COARSEVIEWPORTONLY switch will result in only the small or large4 coarse viewport to be effected by a display routine.H Any procedure that uses the display control parameter to control the KICH geometry display routines must reset the parameter to it's default value before terminating.t .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		4.1.3. Clippingp .XEl .SHd 4.1.3. Clippinge .PPoI Because KIC was written to run on most "dumb" or low performance graphicscM terminals, it is necessary to accomplish window-to-viewport geometry clippingeF on the host machine instead of down-loading the task onto the graphicsG device.  Clipping is the procedure by which sections are removed from aeK particular geometry such that the contour will be contained entirely in the'M targeted viewport.  Because KIC uses only rectangular viewports, the clippingMH of rectangles is trivial and will not be explained here in detail.  The  .I "LToP()"l@ macro, which converts lambda coordinates to display coordinates,< performs a rectangular clipping to the destination viewport. .PP F If the graphics device provides such capabilities as geometry clippingJ and definable viewports and windows, these tasks can be down-loaded to the@ device, but probably not without considerable rewriting of code.J The graphics device would be required to support a world coordinate systemI that is as extensive as the system used by CD.  Many terminals that claimwH to have this ability limit the world coordinate values to short integers@ that are inadequate for an IC layout with sub-lambda resolution.J The KIC window management system may have to be modified to be efficientlyI adapted to graphics device with definable viewports.  At present, the KICXG geometry display routines operate under the assumption that objects canXI be displayed in any layout viewport at any time; in other words, there is	G no notion of a current viewport.  Considerable overhead may result from D viewport context switching on a graphics device that handles the KIC# viewport management in this manner.t .PPl
 The procedureE .I "MFBPolygonClip()" 4 for clipping polygons to a window is provided by the; MFB library of graphics routines and is described in details5 in [6].  It is an easy task to clip a line segment toa= a half-plane when the edge of the half-plane is parallel to ae coordinate axis.> If we consider the interior of a window or viewport to be the G intersection of four such half-planes, the clipping of a polygon can bew9 performed by traversing the edge list of the polygon onceIE for each half-plane, clipping the edges to the respective half-plane.r .PPbD Polygon clipping is performed in the world coordinate system in KIC;B a polygon is clipped to a particular window and then mapped to theB targeted viewport.  KIC invokes the frame buffer interface routine .I "FBPolygonClip()" which then invokes the .I "MFBPolygonClip()"pC procedure.  This provides the programmer with the ability to easilyoC insert his own polygon clipping routine, if he wishes to, and stilly) use routines in the MFB graphics library.c .XSn. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u( 		4.1.4. Window/Viewport Transformations .XEs .SHp& 4.1.4. Window/Viewport Transformations .PPe KIC uses the .I "LToP()"tF macro for converting from lambda database coordinates to pixel display coordinates, and the .I "PToL()"i5 procedure converts from display coordinates to lambdalK coordinates in a given window;  the macro is used for speed and performance C considerations.  For a more complete explanation of window/viewporti transformations, see [6].e .PP. The  .I "LToP()"h? macro performs window-to-viewport clipping of rectangles and ise defined as follows in thew
 .I "coords.h"c header file: .bro .s4  .nfe  i .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'uac .if t .ta \w'XXXXXXXX'u +\w'#define 'u +\w'XXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u  .ne 11& 	#define	LToP(Viewport,Window,X,Y){	\\: 		X = (int)(((float)(X-Window.kaLeft)*Viewport.kaWidth)	\\' 			/Window.kaWidth)+Viewport.kaLeft;	\\z= 		Y = (int)(((float)(Y-Window.kaBottom)*Viewport.kaHeight)	\\a* 			/Window.kaHeight)+Viewport.kaBottom;	\\1 		if(X < Viewport.kaLeft) X = Viewport.kaLeft;	\\n8 		else if(X > Viewport.kaRight) X = Viewport.kaRight;	\\5 		if(Y < Viewport.kaBottom) Y = Viewport.kaBottom;	\\n6 		else if(Y > Viewport.kaTop) Y = Viewport.kaTop; }	\\   .fiv .vsr .rsx .DT  .PPlH The efficiency of the procedure is essential because it must be executedK at least twice before any geometry can be displayed on the graphics device.pG Floating point arithmetic is however used for both safety and accuracy.aI If the computation did not use floating point arithmetic and assuming onenP hundred database units per lambda, the approximate allowable window width before4 an overflow occurred would be fourty thousand lambdaK (for a 1k by 1k display resolution and a four byte integer representation).dE If forty thousand lambda is an acceptable size for a world coordinatelB system, it is recommended that the transformation use only integerI arithmetic for efficiency; experience has frequently shown, however, thati. a larger world coordinate system is desirable. .PPr Theo .I "PToL()" ; macro performs viewport to window coordinate conversion andt@ also performs cursor snapping.  Cursor snapping is the procedureI by which coordinates that are returned from the graphical pointing deviceXM are constrained to lie on a grid.  The lambda spacing between adjacent pointsw on the grid is specified by then .I kpPixToLambdaSnapping> member in the KIC parameters structure defined in Section 4.3. .I "PToL()"e is defined in the 
 .I "coords.h"i file as follows: .bro .s4  .nfe  A .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXX'u +\w'XXXXX'un .ne 10: 	#define	HALFSNAPPING	Parameters.kpHalfPixToLambdaSnapping2 	#define	SNAPPING	Parameters.kpPixToLambdaSnapping   .if n .sp 2dH .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	PToL(Viewport,Window,X,Y) 		struct ka Viewport, Window;i
 		int *X, *Y;n 		{e 		float tmp1, tmp2;I) 		tmp1 = ((float)(*X - Viewport.kaLeft));r+ 		tmp2 = Window.kaWidth / Viewport.kaWidth;f .ne 8i, 		*X = ((int)(tmp1 * tmp2)) + Window.kaLeft;9 		if(*X >= 0) *X = ((*X+HALFSNAPPING)/SNAPPING)*SNAPPING;X2 		else *X = ((*X-HALFSNAPPING)/SNAPPING)*SNAPPING;+ 		tmp1 = ((float)(*Y - Viewport.kaBottom));u- 		tmp2 = Window.kaHeight / Viewport.kaHeight;X .ne 8X. 		*Y = ((int)(tmp1 * tmp2)) + Window.kaBottom;9 		if(*Y >= 0) *Y = ((*Y+HALFSNAPPING)/SNAPPING)*SNAPPING;d2 		else *Y = ((*Y-HALFSNAPPING)/SNAPPING)*SNAPPING; 		}i   .fil .vsY .rso .DTo .PP* Theo .I "PToL()"\H procedure is invoked whenever the KIC user points in a viewport with theH graphical pointing device or when KIC is required to compute the size inI lambda of an area on the graphics display; efficiency is certainly not an(2 issue.  Because it is essential, however, that the .I "PToL()"  procedure be the inverse of  .I "LToP(),"H accuracy is an issue, and, therefore, floating point arithmetic is used.H If one procedures was not the inverse of the other, the integrity of theC layout display and graphical pointing device would be questionable,n4 and that for a graphics editor would be intolerable. .bp  .XSa. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	4.2. KIC Data Structuresf .XEc .SHd 4.2. KIC Data Structures .PPa? The basic data structures of KIC are described in this section.eD The KIC parameters structure is described separately in Section 4.3. .XSo. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		4.2.1. The Area Descriptor .XEm .SHf 4.2.1. The Area Descriptor .PPq) The KIC area descriptor is defined in thed
 .I "kic.h" header file as follows:r .bro .s4" .nf)  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  	/*p .ta \w'XXXXXXXXX'u 	* Area structure. 	*/t= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ur 	struct ka {' 		int kaLeft, kaBottom, kaRight, kaTop;r 		int kaX, kaY;p 		float kaWidth, kaHeight; 		};   .fii .vss .rsi .PP F The KIC area structure is used for storing the representations of both! rectangles and rectangular areas.e; Every possible representation of the rectangle is contained ' in this structure for convenience.  TheX .I "kaLeft, kaBottom"'I members define the untransformed lower, left coordinate of the rectangle,n and the# .I "kaRight, kaTop"eJ members define the untransformed upper, right coordinate of the rectangle. The'
 .I "kaX, kaY"wD members represent the untransformed center of the rectangle, and the
 .I kaWidthJ member defines the width of the rectangle in the horizontal direction, and .I kaHeighto> defines the height of the rectangle in the vertical direction. .PPtC The area structure is also used by KIC for representing the severalp8 windows and viewports that are described in Section 4.1. In practice, the
 .I kaWidth andi .I kaHeightwI members are used exclusively for this purpose if and only if the viewporti8 or window is used for the display of layout information.H They are defined as floating point values so that the window-to-viewportJ transformation routines, which use floating point arithmetic for accuracy,M are not required to compute the floating point width and height and for everyn- window-to-viewport coordinate transformation.  .PPr Theu
 .I kaWidth andu .I kaHeighto) structure members are never used when theF .I kanB area structure represents a rectangle or one of the four viewportsD that display only textual information; they are used exclusively for layout viewports or windows. .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u$ 		4.2.2. The Window Stack Descriptor .XEi .SHt" 4.2.2. The Window Stack Descriptor .PPo5 The KIC window structure is defined as follows in theP
 .I "kic.h" header file: .br  .s4a .nfb  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u) .ne 12 	/*  .ta \w'XXXXXXXXX'u1 	* Structure used to save windows in window stackn 	*/ = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uF 	struct kw { 		int kwLastWindowX; 		int kwLastWindowY; 		int kwLastWindowWidth; 		int kwLastFineWindowX; 		int kwLastFineWindowY; 		char kwName[8];. 		};   .fiw .vsk .rsh .PPnJ KIC provides the user with the ability to assign names to specific windowsC and to save the respective window on a stack such that the user canA? randomly return to any desired view of the layout.  An array of	 .I kwW6 structures is just such a list of layout windows.  The	 .I kwNamet; character string is the user-specified name for the window.  The structure membersI .I kwLastWindowX andd .I kwLastWindowY/ define the center coordinate of the window, andr .I kwLastWindowWidthI defines the width of the coarse window in one one-hundredth lambda units.v The coordinate! .I "kwLastWindowX, kwLastWindowY"i: defines the center of the fine window or magnifying glass. .PPnE The width of the fine window is assumed to be that default value thati is computed by the .I "InitFineWindow()""G initialization routine.  If the width of the coarse window is such thataG it is not necessary to display the fine window, this condition would bez recognized by invoking the .I "SwitchToFinePositioning()"E procedure after retrieving a window definition from the window stack.o .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u' 		4.2.3. The KIC Layer Table Descriptor  .XE  .SHa% 4.2.3. The KIC Layer Table Descriptorh .PPe; The KIC layer descriptor and layer table are defined in thee
 .I "kic.h" header file as follows:  .bra .s4l .nf   = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uh .ne 22 	/*i .ta \w'XXXXXXXXX'u8 	* The following information is read from the .KIC file. 	*/ K .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'un 	struct kl {$ 		int klR, klG, klB;	/* RGB color */6 		int klMinDimensions;	/* Minimum lambda dimensions */) 		int klFilled;	/* filled or outlined? */s2 		int klStyle[8];	/* bit array for fill pattern */ 		int klStyleID;	/* style ID */a7 		int klCoarseStyleID;	/* style ID for Coarse window */p3 		int klFineStyleID;	/* style ID for Fine window */X! 		int klVisible;	/* visibility */o$ 		int klBlink;	/* blinking layer? */! 		int klSymbolic;	/* symbolic? */ 4 		int klWireWidth;	/* wire width >= mindimensions */% 		char klTechnology;	/* layer name */  		char klMask[3];X 		}  	LayerTable[CDNUMLAYERS+1];X   	int NumLayerTable;    .fit .vsX .rsX .PP M An array of KIC layer descriptors represents the KIC layer table that differs'G from the CD layer table in that it contains display information as wellwG as layout guidelines.  The size of the KIC layer table is identical to wB that of the CD layer table, and the entries correspond to directlyJ the CD layer numbers.  The name of a particular layer represented by a KIC1 layer descriptor is given by the character stringa .I klTechnologyklMaskeF and also is identical to the name of the corresponding layer in the CDG layer table.  As in the CD database, layer zero represents the instancemG layer, and because KIC has special procedures for displaying instances,G2 the KIC layer descriptor for layer zero is unused. .PPA The; .I klMinDimensionsH structure member specifies the minimum lambda dimension for the specificI layer in the given process technology.  If the user creates a wire in theI) layout, the width of the new wire will bea .I klWireWidth lambda units, wheree .I klWireWidth( is greater than or equal to the value of .I klMinDimensions.t TheI
 .I klSymbolicc; member identifies the particular layer as either a symbolic ' representation of data or a mask level.  .PPe Thef .I "klR, klG," ando .I klBG structure members define the RGB color combination with which the layeriE is to be displayed in the layout viewports. All color intensities areu normalized by KIC to 255.X .PPtI KIC displays layers in the layout viewports as either filled or outlined.XH If a particular layer is to be filled when displayed, it can have a fillF pattern associated with it; the outlining of a layer is not considered5 as a fill pattern in the KIC display philosophy.  The' .I klFilledXF member in the KIC layer descriptor is a boolean that specifies whetherF the respective layer should be filled or outlined when displayed.  The .I klStyleID4 member is the index that identifies the fill patternG for the respective layer; the value zero is always assumed to represent* a solid-fill pattern.  The
 .I klStyleJ array contains and eight by eight intensity array that defines of the fillP pattern that is attributed to the respective layer.  The eight least significant bits of each integer in theI
 .I klStyle1 array are used to represent a row of the pattern.o .PPaG Because a graphics terminal can in general display solid filled objectsa5 more rapidly than stippled or pattern filled objects,rB KIC uses a thresholding procedure for displaying filled geometries5 in the layout viewports to decrease the time requiredtG to display a window.  To do accomplish this, there are separate indicestJ to identify the fill pattern for a particular layer in the fine and coarse> layout viewports.  The number that identifies the fill pattern% for a layer in the coarse viewport iso .I klCoarseStyleID,  andh .I klFineStyleIDI is the fill pattern index for the fine layout viewport; for both indices,sH the value of zero identifies a solid-fill pattern, and layers are always outlined if the  .I klFilleddD layer descriptor member is zero, regardless of the value of the fillF pattern index.  If in either layout viewport the number of pixels thatG are required to display the length of one lambda unit is less than two,aA the fill pattern index for the viewport is set to zero to force as1 solid-fill pattern.  This decision is made in the  .I "InitVLT()"I routine that must therefore be invoked whenever the size of a viewport ori window changes.t .PP A The remaining descriptor members are used specifically as displaye controls.  If thes
 .I klBlinkF member is set for a particular layer, the layer will be displayed in aA blinking mode on the graphics terminal, given that the device hass* the capability of blinking colors.  If the .I klVisibleA member is zero, the respective layer will not be displayed in thei0 layout viewports; that is, it will be invisible. .XSo. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		4.2.4. The Cursor Descriptor .XEa .SHy 4.2.4. The Cursor Descriptor .PPe+ The KIC cursor descriptor is defined in the 
 .I "kic.h" file as follows: .brc .s4v .nfi  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uo .ne 12 	/*a .ta \w'XXXXXXXXX'u 	* Cursor desc.o 	*/.= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uo 	struct kc { 	      	/* In lambda units.  */y! 		int kcPredX, kcPredY, kcX, kcY;n 		int kcDX, kcDY;I 		int kcRow, kcColumn; 		}e 	Cursor;   .fi  .vsi .rst .PP $ The cursor descriptor is used by the .I "Point()"B routine in KIC to report a user pointing event.  When the KIC user@ points in a layout viewport using the graphical pointing device,A the lambda coordinate of the user-selected point is placed in thel
 .I "kcX, kcY"t5 structure members of the KIC cursor descriptor by thes .I "Point()"
 procedure.2 The previous user-selected point is moved from the
 .I "kcX, kcY"l structure members to .I "kcPredX, kcPredY,"7 and the orthogonal displacements between the two lambdan& coordinates are computed and placed in .I "kcDX, kcDY."6 Whenever the KIC user points in a layout viewport, the .I kcRow and  .I kcColumni# descriptor members are set to zero.e .PP H When the KIC user points in a text viewport using the graphical pointingB device, the respective row-column text coordinate is placed in the .I "kcRow, kcColumn"5 structure members of the KIC cursor descriptor by the" .I "Point()"I procedure.  As described in Section 4.1.1, the row-column text coordinateXN system divides the graphical display into a grid of graphical character blocks@ with the origin being in the upper, right corner of the display. .PP 	 After thea .I "Point()"- routine is invoked in KIC, KIC determines thesC viewport to which the user pointed by testing the values of certain'B integer flags in the KIC parameters structure that is described in1 Section 4.3.  The parameters of interest here are* .I kpPointCoarseWindow andX .I kpPointLayerTable.X .XSX. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  		4.2.5. The KIC Selection Queue .XEm .SHn 4.2.5. The KIC Selection Queue .PP	) The KIC selection queue is defined in the	
 .I "select.h"	 header file as follows:t .br/ .s4n .nft  H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u .ne 12 	struct ks { 		struct ks *ksSucc; 		struct o *ksPointer; 		};   .if n .sp 2y 	struct ks *SelectQHead;   .if n .sp 2/ 	struct ka SelectQBB;s   .fi? .vs  .rs  .PPe' The selection queue is a linked-list of  .I ksk@ structures that is used by KIC to identify specific objects in aE particular symbol.  The list of objects is typically used to identify = a set of objects that will be subject to an operation such ase move or copy.  The .I SelectQHead pointer references the first .I kstH structure in the linked-list and is a null pointer if the list is empty.E When a an object is inserted into the selection queue, the respectives) object descriptor pointer is saved in the  .I ksPointer member, and theh	 .I ksSuccz. pointer member is assigned to the value of the .I SelectQHead
 pointer.  TheI .I SelectQHeadF pointer is then set to point to the new member in the selection queue.F In other words, new items in the selection list are always inserted at the head of the list.e .PPo When the .I "SelectQComputeBB()"KF procedure is invoked, the bounding box of all objects in the selection# queue is computed and stored in theI .I SelectQBB area structure.  .XSI. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		4.2.6. The Context Descriptoro .XEa .SHr 4.2.6. The Context Descriptorc .PPc, The KIC context descriptor is defined in the .I "contexts.c"I source file as follows:i .brc .s4r .nfe  H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u .ne 15 	#include "cd.h" .if n .sp 2e   	/*e .ta \w'XXXXXXXXX'u@ 	* Context stack shouldn't get deeper than transformation stack. 	*/e= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'us 	struct cc {! 		int ccX,ccY,ccWidth,ccModified;d 		int ccNumWindows;s* 		struct kw ccSaveWindow[VIEW_STACK_SIZE]; 		struct o *ccInst;  		char ccMaster[81]; 		}e 	Context[XFORMSTACKSIZE];    .if n .sp 2  	int ContextSP = 0;(   .fit .vss .rsk .PP J The context stack is used by KIC to save the context of an editing session? while the KIC user edits another symbol.  A typical scenario is D as follows: the user is editing a symbol with an instance of anotherJ symbol.  The user discovers that the called symbols is, perhaps, lacking aG contact.  He then places the contexts of the current editing session inmM the context stack and begins editing the defective symbol.  When the problemsdI in the called symbol have been corrected, the user retrieves the previous B editing session from the context stack and begins editing where he3 was before he discovered the error in the instance.t .PPs@ The size of the context stack can not be larger than that of theD transformation stack because the transformations that are associatedD with the symbols being edited are saved on the transformation stack.+ The name of the symbol that is being editeds- in the respective context is contained in theo .I ccMaster  character string, andl	 .I ccInst G is a pointer to the object descriptor of the instance that the KIC usereE began editing after the context was placed on the context stack.  Thei .I "ccX, ccY," andm
 .I ccWidth? define the size and position of the coarse window; the size and > position of the fine window is assumed to be the default value computed by theS .I "InitFineWindow()" C procedure.  The window stack that is associated with the respectivec! editing context is defined by thet .I ccNumWindowsr andh .I ccSaveWindow. structure members. .PPm= The procedures for context switching are appropriately called  .I "Push()"  anda .I "Pop()."lG Both routines are responsible for maintaining the context stack pointer 
 .I ContextSP.- Thep .I "Push()" D routine assumes that the object that is referenced by the first item9 in the selection queue is the called symbol to become theg next editing context.n .bpc .XSr. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u" 	4.3. The KIC Parameters Structure .XE  .SH ! 4.3. The KIC Parameters Structure  .PPaG The KIC parameters structure contains the controlling parameters of theaD KIC program that may be shared by all program modules.  Because thisI data structure is so large and the members mostly unrelated, this sectionsI may be the most confusing of any section of this document.  Nevertheless, G a thorough knowledge of the internal structure of KIC would require the 8 programmer to recognize all parameter structure members. .PP . The KIC parameters structure is defined in the
 .I "kic.h" file as follows: .brX .s4  .nfX  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uc 	struct kp {$ 		/* Symbol desc for current cell */ 		struct s *kpCellDesc;r   		/* .ta \w'XXXXXXXX'u +\w'XXXXX'u*7 		* Object desc for a geometry currently being created.I6 		* KIC special cases the input of polygons and wires. 		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'un 		struct o *kpPointer;   .ne 2g, 		/* True if instances should be expanded */ 		int kpExpandInstances;   .ne 2i: 		/* True if instance is expanded in fine viewport only */ 		int kpExpandFineViewportOnly;t   .ne 2e4 		/* If False then the SelectQ is not redisplayed */ 		int kpEnableSelectQRedisplay;i   .ne 5 # 		/* Color ID's for command menu */l 		int kpMenuTextColor; 		int kpMenuHighlightingColor; 		int kpMenuSelectColor;   .ne 3eB 		/* If True, user pointed to layer table and Command[0] == EOS */ 		int kpPointLayerTable;   .ne 3eF 		/* If True, user pointed to coarse viewport and Command[0] == EOS */ 		int kpPointCoarseWindow;   .ne 4w! 		/* Control of the Layer Menu */X 		int kpNumLayerMenuRows;o 		int kpLayersPerMenuRow;t   .ne 3.) 		/* Number of sides for round flashes */e 		int kpNumRoundFlashSides;    .ne 3e 		/* Current layer */  		int kpLayer;   .ne 3o4 		/* True if selection commands are LayerSpecific */ 		int kpLayerSpecificSelection;r   .ne 3i5 		/* If True, then outline all stippled geometries */t 		int kpOutline;   .ne 3hC 		/* If True, polygon vertices are clipped to nearest grid point */m 		int kpClipVerticesToGrid;s   .ne 3a1 		/* If True, put grid below layout geometries */o 		int kpGridOnTop;   .ne 3p5 		/* If True, grid will be shown in large viewport */C  		int kpShowGridInLargeViewport;   .ne 4u 		/* Color ID's for grid */e 		int kpCoarseGridColor; 		int kpFineGridColor;   .ne 3a8 		/* Number of RESOLUTION*lambda between grid points. */
 		int kpGrid;X   .ne 3X. 		/* True if current cell has been modified */ 		int kpModified;    .ne 4.+ 		/* Parameters for modifying geometries */I 		int kpModifyLeft;e 		int kpModifyTop;   .ne 3a# 		/* Bounds of coordinate system */b% 		int kpMaxX, kpMaxY, kpMinX, kpMinY;s   .ne 3a 		/* Debug parameters */ 		int kpNumGeometries;   .ne 3t. 		/* If True, then show redisplay bandwidth */ 		int kpShowBandwidth;   .ne 4e; 		/* If True, user has just pressed the interrupt key    */  		int kpSIGINTERRUPT;g   .ne 8  		/* .ta \w'XXXXXXXX'u +\w'XXXXX'ubE 		* == COARSEVIEWPORTONLY if only coarse viewport should be displayed A 		* == FINEVIEWPORTONLY if only fine viewport should be displayed+. 		* == SPLITSCREEN if both should be displayed 		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u* 		int kpRedisplayControl;X   .ne 3 > 		/* If True, Fine Viewport (Magnifying Glass) is displayed */ 		int kpDisplayFineViewport;   .ne 3i& 		/* If True, all text is displayed */ 		int kpDisplayAllLabels;X   .ne 3	> 		/* If True, all instances will be labeled in the viewport */ 		int kpLabelAllInstances;   .ne 3;7 		/* If True, instances will be marked when selected */w 		int kpShowInstanceMarkers;   .ne 6t 		/* .ta \w'XXXXXXXX'u +\w'XXXXX'utG 		* PointingThreshold is the minimum value of ViewportWidth/WindowWidth E 		* such that it is still comfortable to point with lambda precision.  		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  		int kpPointingThreshold;   .ne 3 ? 		/* True if wires and polygons should be constrained to 45s */  		int kp45s;   .ne 7o 		/* .ta \w'XXXXXXXX'u +\w'XXXXX'u/@ 		* PixToLambdaSnapping is RESOLUTION times the number of lambda< 		* between points to which a cursor input point is snapped. 		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uo 		int kpPixToLambdaSnapping;  		int kpHalfPixToLambdaSnapping;   .ne 5+3 		/* Current transform defined in Selection menu */i. 		int kpRotationAngle;	/*0, 90, 180, or 270 */ 		int kpMX;T 		int kpMY;	   .ne 3*= 		/* At what level in the hierarchy are we?  See Redisplay */  		int kpHierarchyLevel;n   .ne 70 		/* .ta \w'XXXXXXXX'u +\w'XXXXX'ut< 		* Window stack.  kpWindowStack[0] is always the last view.9 		* If kpNumWindows is zero, only the last view is saved.c 		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u + 		struct kw kpWindowStack[VIEW_STACK_SIZE];t 		int kpNumWindows;    .ne 8l1 		/* Background and Highlighting color control */t 		int kpHighlightingPixel; 		int kpHighlightingRed; 		int kpHighlightingGreen; 		int kpHighlightingBlue;d 		int kpBackgroundRed; 		int kpBackgroundGreen; 		int kpBackgroundBlue;    .ne 7  		/* used in Attributes.c */ 		int kpSetBackgroundColor;  		int kpSetHighlightingColor;r   .ne 2 $ 		/* Symbol name for current cell */ 		char kpCellName[80];   .ne 2t1 		/* Command selected if any from command menu */o 		char kpCommand[80];i   .ne 12 		/*> .ta \w'XXXXXXXX'u +\w'XXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		* Current command menu* 		*		== INSTANCEMENU denotes instance menu- 		*		== ATTRIBUTESMENU denotes attribute menui* 		*		== PROPERTYMENU denotes property menu$ 		*		== BASICMENU denotes basic menu, 		*		== SELECTIONMENU denotes selection menu$ 		*		== DEBUGMENU denotes debug menu, 		*		== AMBIGUITYMENU denotes ambiguity menu 		*/= .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ue 		char kpMenu;   		}  	Parameters;   .fi  .vsa .rse .PP N The KIC parameters structure contains most of the controlling variables of theJ KIC program as well as the information that is shared between the separateL KIC procedures.  There is at least one mechanism in KIC to allow the user to% modify each of the structure members.y .PP L The name of the symbol that is currently being edited by KIC is saved in the
 .I kpCellNameiN character buffer, and the respective CD symbol descriptor is referenced by the
 .I kpCellDesc 4 member.  The current symbol descriptor is set in the .I "Edit()"n procedure only.h .PP < Another CD descriptor in the KIC parameters structure is the .I kpPointer4 object descriptor pointer that is used to reference < an object that is being inserted into the current CD symbol.G The display of a polygon or wire that is currently being created in the I layout is given special consideration; the object will be displayed above 2 all other objects so as not to obscure the detail.J If the user redefines the position of the fine window while in the process5 of specifying the contour of the wire or polygon, the  .I "ShowFineWindow()" I routine will recognize that the pointer is not a null pointer and displayrB the referenced object above all other objects in the window if the- respective object intersects the fine window.t .PP. The  .I kpCommandB character buffer indicates when a user has selected a menu commandE and identifies what the specific command is.  When a user points at aII command in the menu viewport with the graphical pointing device, the namei8 of the command is placed in this character buffer by the .I "Point()"" routine, or more specificly by the
 .I "CtrlAt()"hM procedure.  If the user types at the keyboard of the of the graphics terminaldJ while the graphical pointing device is active, the character that the user@ types is placed at the end of the contents of this buffer by the .I "Point()"F procedure.  If the user does not point in the command menu viewport or+ does not type at the terminal keyboard, the  .I "Point()"/ routine returns with the first character of the\ .I kpCommand buffer set to the value of .I EOS.E Any procedure that calls the .I "Point()"@ routine is required to test the contents of this buffer to allowJ the KIC user the opportunity to make use of the command menu at all times. .PPeC There are two other parameter structure members that are set by theN .I "Point()" routine only.  The .I kpPointLayerTable& integer is set to the logical value of .I TrueM1 if the KIC user points in the layer menu viewport + with the graphical pointing device, and theo .I kpPointCoarseWindow is set to the value of .I TruesA if the user points in the layout viewports, regardless of whethersD the fine window intersects the coarse window.  Both of the structure* members are by default set to the value of .I False by the .I "Point()"< routine.  If the user points in the layer menu viewport, the .I "PointLayerTable()" procedure sets the
 .I kpLayer5 structure member to the value of the index of the newe% current layer in the KIC layer table.S .PPO# Several parameters that control then .I "Redisplay()" routine are K .I "kpExpandInstances, kpExpandFineViewportOnly, kpEnableSelectQRedisplay,"m and  .I kpShowBandWidth.i If the .I kpExpandInstances+ integer flag is set to the logical value ofc .I True,H all instances will be displayed in full detail in both layout viewports;L otherwise, the instances will be represented in the layout viewports by onlyD a line around the perimeter of the bounding box of the cell.  If the .I kpExpandFineViewporte& integer is set to the logical value of .I True,H all instances will be expanded in full detail in the fine viewport only;K an instance in the coarse viewport will again be represented by the contoure of its bounding box.  If the .I kpEnableSelectQRedisplayl& integer is set to the logical value of .I True, theX .I "Redisplay()"! routine will invoke the procedurel .I "SelectQShow()"G before terminating; this latter procedure will highlight in both layoutF< viewports all objects contained in the selection queue.  The .I kpNumGeometries integer is set to zero when the  .I "Redisplay()"E procedure is invoked and then incremented whenever a geometric object	K is displayed thereby providing a count of the number of geometries.  If thea .I kpShowBandWidth integer flag is set, the .I "Redisplay()"H routine will compute the real, user, and system time required to displayC the particular area in the layout viewports and report these values  to the user before terminating.c .PPr Thee .I "Redisplay()" routine will invoke theP .I "ShowGrid()"sH procedure that displays a grid in the layouts viewports according to the user-specified options.  If thee	 .I kpGridoJ integer member of the parameters structure is less than unity, then a gridH will never be displayed in the layout viewports; otherwise, the value of	 .I kpGridbH specifies the lambda spacing of the grid lines starting at the origin ofH the world coordinate system.  If the number of display pixels per lambda- in the fine viewport exceeds the value of thee .I kpPointingThresholdL parameter, then a grid will be displayed in that layout viewport, and if the .I kpShowGridInLargeViewport( parameter is set to the logical value of .I True,I then a grid will also be displayed in the large coarse layout viewport ifFI the display pixel per lambda ratio is large enough to permit a grid.  Thev .I "Redisplay()" procedure will invoke ther .I "ShowGrid()"L@ procedure after all layout geometries have been displayed if the .I kpShowGridOnTop( parameter is set to the logical value of .I Trueo/ that will result in the lines of the grid beinga) displayed over layout geometries.  If thea .I kpShowGridOnTopI parameter is not set, the grid will be displayed before layout geometriesiM that will cause the view of grid lines to be obstructed by layout geometries.l .PPa. The lines of the grid that is displayed by the .I "ShowGrid()"p/ procedure will be displayed in two colors.  Thea .I kpFineGridColorD parameter is the index of the layer in the KIC layer table that willM be used to display the intermediate grid lines.  Every fifth line of the gridiJ appear in the color of the layer that is indexed in the KIC layer table by .I kpCoarseGridColor.t .PP H The parameters structure contains other viewport color information.  The .I kpMenuTextColorI is the index of the layer in the KIC layer table whose color will be usedh> as the color of all graphic text in the textual viewport.  The .I kpMenuSelectColor andi .I kpMenuHighlightingColorK members of the parameters structure define the color indices with which all = graphic text will be displayed and highlighted in the commanddJ menu viewport if the respective command is selected; a highlighted commandJ means that the name of the command is written over a box that is displayedC in the color of the layer that is indexed in the KIC layer table bya .I kpMenuHighlightingColor.i .PPo Thel .I kpBackgroundRed,e .I kpBackgroundGreen,t and  .I kpBackgroundBlue H parameter structure members define the red-green-blue combination of theK background color for all viewports.  The background color for KIC is alwaystG the first color in the video color table of the graphics terminal.  Theo .I kpHighlightingRed,  .I kpHighlightingGreen,e anda .I kpHighlightingBluei7 parameters define the red-green-blue combination of thetH highlighting color.  An object is highlighted in the layout viewports byO displaying a line in the highlighting color around the perimeter of the object.nJ The highlighting color for KIC is always the last color in the video color; table of the graphics terminal and is always indexed by thec .I kpHighlightingPixel parameter structure member.p .PP E Other members of the parameters structure that control the display ofp8 information in the layout viewports are as follows:  the .I kpOutline< parameter is set to the value of true if stippled geometriesD are to by outlined; depending on the fill patterns being used, it is> occasionally more pleasing to the eye to have the perimeter of2 stipple filled geometries clearly visible.  If the .I kpOutlineI flag is set, however, the time that is required for the graphics terminal D to redraw the layout viewports will of course increase.  Because KICN assumes that the graphics terminal is not capable of scaling graphic text, the .I "ShowLabel()"  routine, which is invoked by the .I "Redisplay()"L routine to display a label in the layout viewports, will not display a labelL in a layout viewport if the number of display pixels per lambda is less thanK two; the number two was simply chosen after trying several other values anduD finding that two was most reasonable for typical IC layouts.  If the .I kpDisplayAllLabelso( parameter is set to the logical value of .I True, thei .I "ShowLabel()"H routine will always display labels in the layout viewports regardless of, the window-to-viewport scale factor.  If the .I kpShowInstanceMarkers2 member of the KIC parameters structure is set, the .I "SelectQShow()"" procedure, which is invoked by the .I "Redisplay()"G procedure to highlight the content of the selection queue, will displaywI a small, diamond shaped marker at the reference point of each instance iniJ the selection queue; the reference point of an instance is also the originF of the world coordinate system for the respective symbol and the point2 about which the cell would be rotated or mirrored. .PPMO The procedure that places objects into the selection queue is controlled by the  .I kpLayerSpecificSelectionaJ member of the KIC parameters structure.  If this parameter is set when KICJ asks the user to point in the layout viewports with the graphical pointingG device to identify the object to be placed in the selection queue, onlyI> those objects that lie on the current layer, as defined by the
 .I kpLayerJ parameter, will be placed in the selection queue.  If under this conditionM of layer specific selection, the KIC user does not point to any object in thetL layout viewports that is on the current layer but does point to an instance,F the respective instance will be placed in the selection queue.  If the .I kpLayerSpecificSelections( parameter is set to the logical value of	 .I False,tL all objects that the KIC user identifies by pointing in the layout viewports& will be placed in the selection queue. .PPiI There are several parameters in the KIC parameters structure that controlfF the creation and editing of objects by KIC.  When the KIC user createsE a wire or polygon and begins to define the contour of the object, thevK angle formed by any two adjacent segments along contour will be constrainedO) to integer multiples of 45 degrees if the  .I kp45sA member of the parameters structure is set to the logical value off .I True. Thee .I "kpRotationAngle, kpMX,"t anda .I kpMYmL parameters define the current transformation; if a new instance is placed inK the symbol or an object is moved or copied, the operation is performed witha? the transformation that is defined by these parameters.  If the  .I kpMXrH parameter is set, the transformation will mirror in the direction of the x axis, and if the .I kpMYoF is set, the current transformation will mirror in the direction of the" y axis. The current rotation angle .I kpRotationAngleG may only be set to either the value of 0, 90, 180, or 270 degrees.  Thea .I kpModifyLefte and  .I kpModifyTopE parameters are used exclusively to specify the direction in which theSL KIC user will stretch a rectangle using the KIC stretch-box command.  If the .I kpModifyLeftc( parameter is set to the logical value of .I True,E then the left edge of the rectangle will be stretched; otherwise, the = right edge will be stretched.  As explained in Section 2.4.4,nE KIC does not use the CD round flash descriptor, preferring instead toaJ represent round objects as polygons, including arcs and doughnuts.  If the/ KIC user creates a round flash or doughnut, thet .I kpNumRoundFlashSidesIN integer will specify the number of sides on the outer perimeter of the polygonF that will represent the round object.  KIC will not allow the value of .I kpNumRoundFlashSidesa7 to be less than eight and not greater than 360.  If thee .I kpClipVerticesToGridvJ parameter is set, the vertices of all polygonal objects will be clipped toH the lambda grid; this could result in peculiarly shaped round flashes orL doughnuts if the respective diameter is small.  Finally, if the user createsD a new object in the current symbol, or modifies an existing one, the
 .I kpModifiedo flag is set to the value ofC .I True,H which will cause KIC to remind the user if the user attempts to abort or3 edit a new symbol without updating the current one.l .PPf> The KIC parameters structure contains information that is used& to control many viewport actions.  The	 .I kpMenu M member of the parameters structure defines the command menu that is currentlykD displayed in the command menu viewport.  The possible values for the	 .I kpMenu  parameter are defined in the
 .I "kic.h" file as follows: .brt .s4e .nfk  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'utG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'us .ne 10 	/*g .if t .ta \w'XXXXXXXXX'u .if n .ta \w'XXXXX'u
 	* Menu namesn 	*/sK .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u G .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uu 	#define	BASICMENU	'b' 	#define	DEBUGMENU	'd' 	#define	SELECTIONMENU	's' 	#define	INSTANCEMENU	'i'l 	#define	ATTRIBUTESMENU	'a'c 	#define	PROPERTYMENU	'p'I 	#define	AMBIGUITYMENU	'A'   .fir .vsr .rse .DTn .PP G The number of layers that can be displayed in a single row of the layerg, menu viewport is defined by the value of the .I kpLayersPerMenuRowoE parameter.  The number of graphic text rows that are dedicated to theI2 layer menu viewport is defined by the value of the .I kpNumLayerMenuRowsvG parameter.  If the size of the coarse window is sufficiently large suchnA that the fine window is to be displayed in the fine viewport, thea .I kpDisplayFineViewport( parameter is set to the logical value of .I True;E otherwise, if only the coarse window is displayed in the large coarsed viewport, the parametern .I kpDisplayFineViewport is set to the value of	 .I False.f Theg .I kpRedisplayControl ; member of the parameters structure controls the effect of at5 display routine in the layout viewport.  The value ofI .I kpRedisplayControl F specifies the current mode of display and can be one of three options " that are defined as follows in the
 .I "kic.h" file:  .brl .s4h .nfu  O .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u K .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXX'ua .ne 10 	/*l .if t .ta \w'XXXXXXXXX'u .if n .ta \w'XXXXX'u 	* Viewport control flagsn 	*/sO .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXX'utK .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uk 	#define	SPLITSCREEN	'b' 	#define	FINEVIEWPORTONLY	'f'  	#define	COARSEVIEWPORTONLY	'c'    .fiu .vst .rss .DTb .PPr> If both the fine and small coarse viewports are displayed, the .I kpRedisplayControluG parameter will be assigned the value of SPLITSCREEN by default, and theT .I kpDisplayFineViewport% parameter will be set to the value ofm .I True.4 If only the large coarse viewport is displayed, then .I kpRedisplayControlu? will assume the value of COARSEVIEWPORTONLY by default, and the  .I kpDisplayFineViewport% parameter will be set to the value of'	 .I False.+J By setting the display control parameter to the value of FINEVIEWPORTONLY,< only the fine viewport will be updated by a display routine,H and the COARSEVIEWPORTONLY switch will result in only the small or large4 coarse viewport to be effected by a display routine.H Any procedure that uses the display control parameter to control the KICH geometry display routines must reset the parameter to it's default value before terminating.S .PPM< The window stack of the current symbol is represented by the .I kpWindowStack andY .I kpNumWindows J members of the parameters structure.  See Section 4.2.2 that describes the window stack descriptor. .PPp/ A user interrupt condition is identified by ther .I kpSIGINTERRUPT.B member of the parameters structure.  Whenever the KIC user pressesI the interrupt key (break or delete under UNIX and control C for VMS), then .I kpSIGINTERRUPT   parameter is set to the value of .I Truen by the .I "CatchSIGINT()"E interrupt handling procedure.  The top of the display loop (i.e., the ' top of the CD generator loop before the  .I "CDGen()"C procedure is invoked to return a pointer to an object in the windowi! to be displayed) the value of thet .I kpSIGINTERRUPT H is tested for an interrupt condition.  If an interrupt had occurred, the% display routine is terminated and thea .I kpSIGINTERRUPT - parameter is returned to its default value ofn	 .I False.g .bpb .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	4.4. KIC Command Menuse .XEc .SHr 4.4. KIC Command Menus .PPo5 Because of the functionality of KIC, it is impossible ? to display all KIC commands simultaneously in a menu structure.sG KIC therefore is designed with a hierarchical menu system that providesT; specially tailored command sets allowing the user to easilyaO complete specific tasks.  These command sets are not so specific or restrictiveb> to frequently burdened the user with the necessity to traverse/ the command hierarchy for the desired commands.  .PPeN The present implementation of the KIC command menu system is slightly awkward.8 This method has continued in use simply because it works? and has not yet become inconvenient.  This section explains the H command menu operation, and provides a description of the task of addingD a new menu command.  Also, suggestions for improving the KIC command menu system are provided.e .PPk< There are seven possible hierarchical command menus for KIC:7 the basic menu at the top of the command hierarchy, theoF selection menu for object modification, the instance menu for instanceK placement, the attribute menu for defining the viewport display attributes, E the property menu for editing the property lists of selected objects,kC the ambiguity menu for resolving ambiguities in instance selection,R8 and the debug menu that the normal KIC user should neverF use.  The command menu that is currently displayed in the command menu viewport is identified by ther	 .I kpMenuf= member of the KIC parameters structure that can assume one of  the values defined in thee
 .I "kic.h" file as follows: .brI .s4m .nfw  K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u G .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'ub .ne 10 	/*S .if t .ta \w'XXXXXXXXX'u .if n .ta \w'XXXXX'u
 	* Menu names  	*/sK .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uMG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'u  	#define	BASICMENU	'b' 	#define	DEBUGMENU	'd' 	#define	SELECTIONMENU	's' 	#define	INSTANCEMENU	'i'  	#define	ATTRIBUTESMENU	'a'r 	#define	PROPERTYMENU	'p'd 	#define	AMBIGUITYMENU	'A'   .fit .vso .rs  .DTe .PPoL A command menu in KIC is an array of character string pointers, each pointerF referencing a particular command name.  For example, the basic menu is defined in the
 .I "kic.h" file as follows: .bre .s4r .nfe  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  .ne 14 	/*w .ta \w'XXXXXXXXX'u
 	* KIC menus.n 	*/uA .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uo 	#ifdef Allocate 		char *BasicMenu[] = {y 			"     ",a
 			"EDit",	 			"DIR", 
 			"SAve", 			"WRite",r 			"     ",g 			"ATtri",e 			"Insta",u 			"SElec",p 			"PRpty",c 			"     ",d 			"RDraw",  			"EXpnd",u
 			"PEek",	 			"PAn",e
 			"Zoom", 			"WINdo",o
 			"VIEw",
 			"LASt", 			"     ",t	 			"45s",o
 			"Grid",
 			"SNap", 			"BOXes",e 			"WIRes",  			"WIDth",  			"POLyg",r 			"DOnut",e 			"FLASh",s	 			"ARC",h 			"LABel",l
 			"Undo", 			"     ",m
 			"LYra", .ne 9s
 			"TECh", 			"ABort",t
 			"DEBug" 			};n6 		int NumBasicMenu = sizeof(BasicMenu)/sizeof(char *); 	#else 		char *BasicMenu[]; 		int NumBasicMenu;u 	#endifn   .fir .vss .rss .DTi .PP 1 There must be such an array of character pointerse for each command menu in KIC.m .PP 8 Notice that the contents of the command menu are defined  by using of a compile flag named .I Allocate.H This compile flag is set to a non-zero logical value by one and only one source file that includes the 
 .I "kic.h"I header file; typically it is defined in the source file that contains thes .I "main()"r
 procedure. .PPnI Also notice that the command names are of mixed case with the capitalizedgG letters always forming a unique prefix.  The convention has become thatKI the first, capital letters in the command name specify the minimum numberwG of characters required to identify the particular command name from anyo other KIC command;# .I "this convention must be obeyed"n because the  .I "Point()"F routine, which compares the user keyboard input to the current commandD set and thereby allows commands to be selected through the keyboard,L will compare the user keyboard input to only those characters in the command names that are capitalized.X .PP 5 The major problem with the KIC command menu structure'- is that the menus are defined entirely in the\
 .I "kic.h"F header file.  As a result, it is necessary to completely recompile KICG whenever a new command is added to a menu or the whenever the structureCI is modified.  The preferred solution to the menu problem might be to haved@ a specific source file, say, menu.c, containing the routines for# managing the command menu viewport.e .PPP TheR .I "ShowMenu()"nN procedure will display a particular command menu in the command menu viewport. Thef .I "MenuSelect()"rF procedure command is invoked to highlight a specific command menu item. whenever the command is user-selected, and the .I "MenuDeselect()"w> procedure is invoked to return a specific command menu item to& its default, unhighlighted appearance.E There is typically a menu-specific display procedure for each command  menu, such as the  .I "ShowBasicMenu()"# procedure, that in turn invokes them .I "ShowMenu()"rH routine.  The reason for this one level of indirection is that typicallyH several command items in a command menu will reflect a mode of operationF that is identified by a particular member of the parameters structure;B for example, the expand command that will cause all called symbols7 to be displayed in full detail in all layout viewports.XH The menu-specific command menu display procedure will be responsible forI testing the various modes of KIC and highlighting the identifying command . menu item if the respective mode is in effect. .PPn Thee
 .I "kic.h"< header file also has specific character pointers defined forC each possible command menu name for reasons of comparison.  Several ? such pointers for the commands in the basic menu are defined asn follows in the
 .I "kic.h" file:h .brI .s4. .nfe  A .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'uh .ne 17 	#ifdef Allocate 		char *MenuEDIT  = "EDit";e 		char *MenuDIR   = "DIR"; 		char *MenuSAVE  = "SAve";e 		char *MenuWRITE = "WRite"; 			.@ .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXX'u +\w'XXXX'u +\w'XXXX'u 			etc.nA .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ui 			. 	#else 		char *MenuEDIT;o 		char *MenuDIR; 		char *MenuSAVE;c 		char *MenuWRITE; 			.@ .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXX'u +\w'XXXX'u +\w'XXXX'u 			etc.uA .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ue 			. 	#endife   .fir .vsi .rsm .DTt .PPeJ These character pointers are typically used to determine whether a commandH menu item has been user-selected.  As is described in Section 4.3 on theC KIC parameters structure, when a command in the current command setlH is selected, whether by use of the graphical pointing device or keyboardI input, the name of the command as it appears in the command menu viewport  is placed into the .I kpCommand7 character buffer in the KIC parameters structure by them .I "Point()"1 routine.  The procedure that monitors the commandw/ menu would therefore test the returned value ofi .I kpCommandE for the appearance of a new command name.  For example, the followinge. sections of C code could be extracted from the .I "Basic()" routine: .brm .s4n .nft   .ne 10H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	#include "kic.h"o   .if n .sp 2 	 	Basic(){a 		int LookedAhead = False; 		   . 		   . 		   . 		loop { 			if(LookedAhead) 				LookedAhead = False; 			else  				Point();   .ne 5(2 			if(strcmp(Parameters.kpCommand,MenuEDIT) == 0){ 				. G .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXX'u +\w'XXXX'u  				etc.H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 				.d 				}a .ne 5r8 			else if(strcmp(Parameters.kpCommand,MenuABORT) == 0){ 				.mG .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXX'u +\w'XXXX'u  				etc.H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 				.e 				}e .ne 108 			else if(strcmp(Parameters.kpCommand,MenuEXPND) == 0){ 				. G .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXX'u +\w'XXXX'ue 				etc.H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 				.  				}X 			   .wG .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXX'u +\w'XXXX'u +\w'XXXX'uG
 			   etc.H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 			   .  			} 		}O   .fiN .vsd .rse .DTA .PPI In the .I "Basic()"L routine, the program will loop continuously until the user invokes a commandL to break the loop such as the abort command.  This is typical of all command menu routines in KIC.  .PPe3 Because the KIC command menus are hierarchical, thet .I "Basic()"& routine will invoke procedures such as* .I "Instances(), Sel(), Attri(), Debug()," andm .I "Properties()"w@ that will erase the current command viewport, display a specificJ command menu, and begin looping with the pointing device as is done in the .I "Basic()"A routine.  The only argument that is passed to these menu routinesp is a pointer to the integer  .I LookedAheadD that is used by the subroutine to notify the parent routine that theH user has already selected a menu command.  When the logical value of the .I LookedAhead integer is nonzero, they .I "Point()"D routine is not invoked during that particular pass through the loop. .bp" .XS,. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	4.5. The Pointing Device= .XEo .SHi 4.5. The Pointing Device .PP C The graphical pointing device is extremely important to KIC becauserE it is used as the major communication link between the editor and the C KIC user.  Consequently, considerable thought has been given to itsr2 application for layout entry and viewport control.& This section will survey the important .I "Point()" routine in KIC.e .PPnJ KIC demands that the graphical pointing device be the locator type; a user> pointing event would return to the host the display coordinateJ that was user-specified and a mask that would identify the button that was/ pushed on the pointing device or keyboard.  The  .I "Point()"C routine will map the display coordinate to the appropriate viewport.F and, on the basis of the position and the button mask, will attempt to% determine the intent of the KIC user.s .PP(6 If the graphical pointing device does not have specialI buttons, such as the commonly used four button mouse has, KIC will assume G that the user is pointing to a lambda coordinate in the layout viewport H if the returned display coordinate is within the layout viewport and the2 if the user pressed the space bar on the keyboard.I This being the case, the KIC user would use the space bar of the terminaluC whenever he pointed to a lambda coordinate in the layout viewports.w .PP  TheX .I "Point()"H is responsible for acting on the occurrence of several keyboard-specificI commands.  The following table lists the special keyboard commands of KIC}C and describes the actions that are performed when the event occurs:, .if n .sp 2w .if t .sp 1i .ne 2  .vs  .rss .DTv .if n .IP "control-A"  1.6il .if t .IP "control-A"  1.25i .s4sI Control A will cause KIC to abort unconditionally.  This keyboard commandoG could be dangerous, and therefore it is possible to remove it from the c .I "Point()"K routine by recompiling without the ABORT compiler flag in the point.c file.w .if n .sp 2  .if t .sp 1n .ne 2o .vsi .rs  .DTc .if n .IP "control-C"  1.6i  .if t .IP "control-C"  1.25i .s4 H This keyboard command is available if and only if KIC is compiled to runK under UNIX.  After the user types control-C, KIC will prompt the user for a J lambda coordinate that will be accepted as if the user had pointed to that. lambda coordinate in the layout viewport.  The .I "Point()" routine will return with the .I kpPointCoarseViewportB member of the KIC parameters structure set to the logical value of .I True. .if n .sp 2' .if t .sp 1+ .ne 2' .vs' .rsu .DT5 .if n .IP "control-E"  1.6i  .if t .IP "control-E"  1.25i .s4 B This keyboard command is identical to the above control-C command.> It is intended for VMS systems for which the control-C command. produces the terminal interrupt signal SIGINT. .if n .sp 2  .if t .sp 1  .ne 2p .vst .rso .DTo .if n .IP "control-F"  1.6i. .if t .IP "control-F"  1.25i .s4rB After typing control-F, KIC will prompt the user to identify a newD center of the fine window in the current symbol.  After the user hasN specified the new center, the fine window will be redrawn in its new position.L The relative size of the fine window will not be affected by this operation.	 Also, the  .I "Point()"D routine will not terminate after this user command; as a result, theG control-F keyboard command is transparent to whatever procedure invokesi
 .I "Point()."  .if n .sp 2D .if t .sp 1* .ne 2; .vsh .rse .DTE .if n .IP "control-G"  1.6i  .if t .IP "control-G"  1.25i .s4wI When the user types control-G, KIC will prompt the user to identify a neww< size and position for the fine window in the current symbol.@ After the user has specified this information by pointing to theF endpoints of the diagonal of the new fine window, the fine window willF be redrawn in its new position.  Because the fine viewport has a fixedG aspect ratio, the horizontal width of the new fine window that the userp specifies will take precedence.,E This keyboard command is similar to the control-F command in that thes .I "Point()"A routine will not return after this user command; as a result, thebG control-G keyboard command is transparent to whatever procedure invokes 
 .I "Point()."e .if n .sp 2  .if t .sp 1e .ne 2I .vsm .rs  .DTh .if n .IP "control-L"  1.6i  .if t .IP "control-L"  1.25i .s4 N When the user types control-L, KIC will prompt the user for a positive integerH that will identify the new current layer.  The number one identifies the2 first mask layer in the KIC layer table, etc.  The .I "Point()" routine will return with the .I kpPointLayerTable0 member of the KIC parameters set to the value of .I True	0 whenever the control-L keyboard command is used. .if n .sp 2n .if t .sp 1= .ne 2	 .vs  .rsw .DTX .if n .IP "control-N"  1.6i\ .if t .IP "control-N"  1.25i .s4p> This keyboard command adds another item to the window stack ofH the current symbol.  After typing control-N, KIC will prompt the user toI name the current coarse and fine windows.  When the KIC user has assigneddE a name to the current layout windows, the windows are pushed onto thea .I kpWindowStackE window stack member of the KIC parameters structure, and the value oft .I kpNumWindowst is incremented by one.E This keyboard command is similar to the control-F command in that the  .I "Point()"3 routine will not terminate after this user command.t .if n .sp 2  .if t .sp 1n .ne 2  .vs. .rs  .DT  .if n .IP "control-T"  1.6ie .if t .IP "control-T"  1.25i .s4 : This keyboard command changes the size and aspect ratio ofG the fine window and viewport.  If the fine viewport occupies the bottomwG third of the layout area of the graphics display and the KIC user types G control-T, the layout viewports be recomputed and redrawn such that the H fine window will occupy the left half of the layout area of the display.F The new fine window will have the same width in lambda as the previous3 fine window and will have the same center position.hE This keyboard command is similar to the control-F command in that thei .I "Point()"- routine will not terminate after the command.e .if n .sp 2  .if t .sp 1a .ne 2t .vso .rs  .DTw .if n .IP "control-V"  1.6i  .if t .IP "control-V"  1.25i .s4nB This keyboard command is identical to the above control-T command.B It is intended for VMS systems for which the control-T command has$ has a special meaning to the system. .if n .sp 2  .if t .sp 1l .ne 2o .vs  .rsi .DTn .if n .IP "control-W"  1.6i  .if t .IP "control-W"  1.25i .s4r. This keyboard command provides the option of a .I "'where am I?'"A command.  When the user types control-W, KIC will then expect the C user to point in the layout viewports, and will notify the KIC user . of the lambda coordinate value by invoking the
 .I "ShowXY()"v3 procedure.  This keyboard command is similar to theI control-F command in that then .I "Point()"- routine will not terminate after the command.i .if n .sp 2  .if t .sp 1n .ne 2e .vsc .rst .DTr .if n .IP "character"  1.6it .if t .IP "character"  1.25i .s4eG Whenever the KIC user types a printable character on the keyboard whiletI the graphical pointing device is active, the character is received by then .I "Point()"N routine, converted to lower case, and placed at the end of the contents of the .I kpCommand, buffer in the KIC parameters structure.  The .I "Point()"F procedure maintains a running count of the number of buffered keyboardO characters and will not immediately terminate after the user types a character.c@ After the typed character has been buffered, the contents of the .I kpCommandE buffer are compared with the current command set that is displayed ind" the command menu viewport.  If the .I "Point()"J procedure determines that the user has typed a command name, the procedure- returns with the complete command name in thea .I kpCommand buffer.c .if n .sp 2t .if t .sp 1n .ne 2  .vse .rsa .DTd .if n .IP "escape"  1.6i .if t .IP "escape"  1.25iI .s4n@ When the KIC user presses the escape button on the keyboard, all. buffered keyboard characters are cleared.  The .I "Point()"@ procedure does not return after the user presses the escape key. .if n .sp 2h .if t .sp 1s .ne 2  .vs  .rsi .DTs! .if n .IP "exclamation (!)"  1.6i " .if t .IP "exclamation (!)"  1.25i .s4rF The exclamation point is the only printable character that has special meaning to the .I "Point()"F procedure.  The exclamation point is used as the KIC system interface;F when the KIC user types an exclamation point, KIC will expect the userF to type a system command terminated by a carriage return.  The command! string will then be passed to theI .I "ShowProcess()"C routine that will execute the command and display any output in theiG area of the fine viewport.  When the user presses a key on the keyboardtD to signify that he has read the displayed output, the fine window is
 redrawn.  The  .I "Point()"B procedure does not return after the user executes a process in the fine viewport. .if n .sp 2r .if t .sp 1e .vso .rs  .DTa .bre .PPr: If the KIC user points in the layer menu viewport with the graphical pointing device, the .I "PointLayerTable()"A routine is invoked to determine if the user actually pointed at amB valid layer.  If the user user did select a new current layer, the
 .I kpLayerM member of the KIC parameters structure is set to the index of the new currenti% layer in the KIC layer table, and thed .I "Point()" procedure returns with the .I kpPointLayerTableB member of the KIC parameters structure set to the logical value of .I True. Theh .I kpPointLayerTable' is typically used by procedures such ast .I "Fille(), Blink()," or .I "Visib()"E that require the user to point in the layer menu viewport to identifyy* layers to be assigned specific attributes.I As described above, the KIC user can also select a new current layer withf the control-L keyboard command.d .PPaO When the user points in any layout viewport with the graphical pointing device,oO the viewport coordinate is converted to the respective window coordinate by thec
 .I "CtrlAt()"f  procedure that is invoked by the .I "Point()"+ procedure, and the values are placed in thea
 .I "kcX, kcY"i@ members of the KIC cursor descriptor described in Section 4.2.4. The previous values of
 .I "kcX, kcY"a are moved to .I "kcPredX, kcPredY,"2 and the displacement is computed and placed in the .I "kcDX, kcDY"t* members of the KIC cursor descriptor.  The
 .I "CtrlAt()"" procedure also sets the" .I kpPointCoarseViewport6 member of the KIC parameters structure to the value of .I Truek and invokes thes
 .I "ShowXY()"TN routine to display the current cursor information in the information viewport.& The geometry input procedures, such as .I "Boxes(), Wires()," ande .I "Polygons()"1 will wait for thec .I kpPointCoarseViewportN flag to indicate that there is new information in the cursor descriptor.  The  .I "Point()" procedure will clear the .I kpCommandP buffer in the KIC parameters structure and return immediately after invoking the
 .I "CtrlAt()"e
 procedure. .PPoL To repeat from the above table of keyboard commands, when the KIC user types+ a printable character on the keyboard while"I the graphical pointing device is active, the character is received by thea .I "Point()"N routine, converted to lower case, and placed at the end of the contents of the .I kpCommand, buffer in the KIC parameters structure.  The .I "Point()"F procedure maintains a running count of the number of buffered keyboardO characters and will not immediately terminate after the user types a character.C@ After the typed character has been buffered, the contents of the .I kpCommandL buffer are compared with the current command set; the current command set is identified by thei	 .I kpMenuf/ member of the KIC parameters structure.  If thee .I "Point()"J procedure determines that the user has typed a command name, the procedure- returns with the complete command name in the" .I kpCommand buffer.u .PPiH KIC will be easiest to use if the graphical pointing device has at least@ four buttons.  If the graphical pointing device has buttons, the .I fButtons < member of the frame buffer descriptor is set to the value of .I True,N and the number of buttons on the graphical pointing device is specified by the .I fNumButtonsI member of the frame buffer descriptor that is described in Section 4.6.1.tE When the user pushes one of these buttons on the pointing device, thehI terminal will report a button mask to the host, and this button mask will < be compared with the array of button masks referenced by the .I fButtonMaskG member of the frame buffer descriptor to identify the respective buttona* that was pushed.  The first integer in the .I fButtonMaskP array is the value of the mask for the first button on the pointing device, etc. .PP N In KIC, the first button on the graphical pointing device is used specificallyJ for identifying entries in the command or layer menus and for specifying a= window coordinate whenever KIC is prompting the user for one.nM The second pointing device button is used for repositioning the center of thedF fine window, and the fourth button is used to redefine the size of theF fine window from two user-specified window coordinates of the new fineJ window diagonal.  Because the size of the fine viewport is fixed, the sizeK of the new user-specified fine window will be clipped to fit into the fixedoI aspect ratio.  The third button on the graphical pointing device performsrK the same function as the control-W keyboard command; when the points in theIM layout viewports by pressing the third pointing device button, the respective A window coordinate is displayed in the information viewport by theo
 .I "ShowXY()"sB procedure.  The third pointing device button is typically used for3 measuring the size of objects in the database.  Thec .I "Point()"I procedure will terminate after the KIC user presses the second, third, ormE fourth pointing device button.  Only the first pointing device buttonh will cause the .I "Point()"N procedure to return with a new window coordinate in the KIC cursor descriptor. .bpt .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u  	4.6. The Frame Buffer Interface .XE  .SH  4.6. The Frame Buffer InterfaceC .PPo4 As presented in Chapter 1, KIC is designed to run on, a wide range of raster graphics terminals orF frame buffers and indeed runs on several devices including the AED 512I and 767, the Tektronix 4113 and 4105, the HP2648A, the Metheus Omega-400,fG and the Masscomp MC500.  The frame buffer is modeled by the contents ofaE the KIC frame buffer descriptor that contains the boolean and numeric,D capabilities describing the respective frame buffer characteristics.K This report assumes that the reader is familiar with the basic structure ofiK a raster color graphics terminal, including the use of video memory and the L color look-up table.  For more information on this subject, see [6] and [7]. .XSt. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u% 		4.6.1.  The Frame Buffer Descriptoro .XEk .SH " 4.6.1. The Frame Buffer Descriptor .PPs8 The frame buffer descriptor is defined as follows in the	 .I "fb.h"r header file. .brh .s4p .nfe  = .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'ua .ne 14 	/*t .ta \w'XXXXXXXXX'u 	* Frame Buffer desc.n 	*/pE .if n .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXX'uoA .if t .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXX'uc 	struct f {e 		char *fDisplay;c 		char *fDeviceName;: 		int *fButtonMask;	/* pointer to array of button masks */6 		int fMaxX,fMaxY;	/* raster dimensions of viewport */+ 		int fFontHeight;	/* standard font size */u 		int fFontWidth;e< 		int fMaxIntensity;	/* set to 255 (normalized intensity) */& 		int fMaxP;	/* max pixel intensity */' 		int fNumColors;	/* max color index */e3 		int fNumRows;	/* max number of horizontal rows */i7 		int fNumColumns;	/* max number of vertical columns */r, 		int fNumFillPatterns;	/* max fill index */2 		int fInitialized;	/* FB struct is initialized */= 		int fNonDestructiveText;	/* text doesn't wipe background */s? 		int fLastCursorColumn;	/* last column used by ShowPrompt() */i= 		int fFilledPolygons;	/* frame buffer has filled polygons */o= 		int fDefinableFillPatterns;	/* fill styles are definable */i1 		int fButtons;	/* pointing device has buttons */ : 		int fNumButtons;	/* number of pointing device buttons */ 		}t 		FB;K   .fi  .vse .rs  .DTd .PPr Them .I fDisplaytG member of the frame buffer structure is a pointer to a character stringeD that specifies the name or type of the respective graphics terminal;? for example, the Tektronix 4113 might be named \fB"t5"\fR.  Thew .I fDeviceNameM is a pointer to the name of the system device driver for the graphics device.c= An example of a UNIX device name might be \fI"/dev/tty01"\fR.  .PPe8 The resolution of the graphics display is defined by the .I fMaxX ands .I fMaxYN frame buffer structure members.  If the display size of the graphics device isM characterized by 640 horizontal pixels and 480 vertical pixels, the values ofb .I fMaxX anda .I fMaxY" would be 639 and 479 respectively. .PPn> The maximum color index for the frame buffer is defined by the
 .I fNumColorsnI member of the frame buffer descriptor.  For a monochromatic display, thiseG structure member would be assigned the value of unity.  Zero is a validrE color index and is always used by KIC as the background color.  For arK color display, the maximum gun intensity for red, green, or blue is definedf by the value of thee .I fMaxP structure member.  The .I fMaxIntensityI structure member is the value to which KIC normalizes the gun intensitiesbJ and should always be set to the value of 255.  In other words, KIC assumesH that the gun intensity for the color display is an eight bit value.  The .I "FBVLT()"E routine, which redefines an entry in the frame buffer's color look-upt@ table, will convert a color intensity of 255 to the value of the .I fMaxP structure member.r .PPr7 The maximum index of fill patterns for the frame bufferb is given by the value of the .I fNumFillPatterns ? frame buffer structure member.  Zero is assumed to be the index G for a solid-fill pattern.  If the fill patterns are definable, then theh .I fDefinableFillPatternsh' structure member is set to the value ofh .I True,@ and if the frame buffer is capable of filled polygons, including solid fill, then the .I fFilledPolygons, structure member is also set to the value of .I True.G The polygon display mechanism for graphics devices that are not capable H of filled polygons is to draw a line around the perimeter of the object. .PPoC The pixel size of the font array for graphic text is defined by the 
 .I fFontWidthe ande .I fFontHeight& members of the frame buffer structure.( From these two structure members and the .I fMaxX andg .I fMaxY  structure members, the values of .I fNumRowsh ando .I fNumColumns are computed;  .I fNumRowshG specifies the number of graphic test rows from the top to bottom of thec graphics display, andc .I fNumColumnsI contains the number of graphic text columns from the left to right of the H display.  The size of the graphic text font should be sufficiently small to allow the value of thee .I fNumRowsm' structure member to be greater than 30. C See Section 4.1.1 that describes the graphic text coordinate system " in menu and information viewports. .PP  When KIC invokes the .I "ShowPrompt()" G routine to display text in the prompt viewport, the last textual columnc* in which text is displayed is saved in the .I fLastCursorColumn# frame buffer structure member.  TheI .I "FBKeyboard()"9F routine, which obtains a user-typed character string from the keyboardC of the graphics terminal, will use this information to decide wherer8 to begin to echo user-typed text in the prompt viewport. .PPuM If the graphic text is not destructive, i.e., the background in the character E font array is not changed when a graphic character is displayed, the m .I fNonDestructiveText4 frame buffer structure member is set to the value of .I True.H It is preferable for graphic text to be non-destructive.  If the text isL destructive, the display of layout information may be corrupted by a textualH label, and KIC will also highlight command menu items differently in the .I "MenuSelect()"t
 procedure. .PP O It is assumed that the frame buffer has some form of graphical pointing device.uI If the graphical pointing device has buttons that send locator reports toaI the host such that the host can determine which button was pressed by thea
 KIC user, theg .I fButtonsa' structure member is set to the value ofu .I True.< The number of buttons on the pointing device is given by the .I fNumButtons structure member.  The .I fButtonMaskshM pointer references an array of integers that are used to identify the buttons,K of the graphical pointing device.  If the KIC user presses the first buttonl on the pointing device, thes .I "FBPoint()"L routine will return with the respective button mask that was received by the  host from the frame buffer.  The .I "Point()"E procedure will recognize that the first button was pushed because thehE button mask value will be identical to the first integer in the arrayf referenced by theI .I "fButtonMasks"rK pointer, etc.  KIC uses no more than four buttons on the graphical pointingI device.n .PPI TheY .I fInitializedrF structure member is set when the frame buffer descriptor is completelyA initialized and the graphics device driver is in CBREAK mode; seeX .I "tty(4)" $ in the BSD UNIX programmer's manual.F CBREAK mode implies that characters that are typed at the terminal are? not buffered, but becomes available to KIC when they are typed. H Also, character echo must be disabled; KIC will echo the keyboard input.? Flow control and interrupt processing should always be enabled.e .XSe. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u# 		4.6.2.  The Frame Buffer Routineso .XE  .SH   4.6.2. The Frame Buffer Routines .PPX@ The frame buffer routines that are required for KIC to control a> graphics device or frame buffer are described in this section.8 There should be sufficient information provided here forD any programmer to write a display driver for KIC.  However, the bestF procedure for interfacing KIC to a new graphics terminal is to take anC existing set of frame buffer routines for another graphics terminal 4 and modify the routines for the new graphics device. .PP   All graphics device dependenciesF are managed by these frame buffer routines, and, as a result, a set ofE frame buffer routines that were written for a particular frame buffer/H will probably differ greatly from routines that were written for anotherH graphics device.  Separate display drivers have been written for several8 graphics terminals and graphics work stations as well asC the \fIModel Frame Buffer\fR terminal independent graphics package.s .PP J The following is a synopsis of all frame buffer routines that are required by KIC for any graphics device:  .bri .s4t .nf    .ta \w'XXXXXXXX'um .ne 3c 	FBBegin(Display)  	char *Display;m   .if n .sp 2e .ne 3  	FBInitialize()o   .if n .sp 2l .ne 3r
 	FBHalt()    .if n .sp 2  .ne 3 	 	FBEnd()     .if n .sp 2d .ne 3f 	FBMoveTo(X1,Y1) 	int X1,Y1;    .if n .sp 2f .ne 3m 	FBDrawLineTo(X2,Y2) 	int X2,Y2;    .if n .sp 2t .ne 3. 	FBLine(X1,Y1,X2,Y2) 	int X1,Y1,X2,Y2;    .if n .sp 2m .ne 4 % 	FBForeground(DisplayOrErase,ColorId)i 	char DisplayOrErase;m
 	int ColorId;    .if n .sp 2l .ne 4 A 	FBBox(ColorId,DisplayOrErase,Type,StyleId,Left,Bottom,Right,Top)  	char Type,DisplayOrErase;+ 	int StyleId,ColorId,Left,Bottom,Right,Top;i   .if n .sp 2p .ne 4e& 	FBDefineFillPattern(StyleId,BitArray)
 	int StyleId;f 	int *BitArray;h   .if n .sp 2e .ne 3  	FBSetFillPattern(StyleId)
 	int StyleId;C   .if n .sp 2h .ne 3  	FBVLT(ColorId,Red,Green,Blue) 	int ColorId,Red,Green,Blue;   .if n .sp 2t .ne 5 # 	FBText(Mode,RowOrX,ColumnOrY,Text)e 	int RowOrX,ColumnOrY; 	char *Text; 	char Mode;s   .if n .sp 2i .ne 5R+ 	FBPolygon(ColorId,Type,StyleId,xy,ncoords) 	 	int *xy;s 	int ColorId,StyleId,ncoords;h 	char Type;    .if n .sp 2a .ne 4e% 	FBBlink(ColorId,Red,Green,Blue,Flag)v 	int ColorId, Flag;h 	int Red,Green,Blue;   .if n .sp 2m .ne 3d 	FBFlood() w   .if n .sp 2y .ne 3n 	FBSetCursorColor(ColorId)
 	int ColorId;    .if n .sp 2e .ne 4d! 	FBPolygonClip(xy,ncoords,window)+ 	int *xy,*ncoords; 	struct ka window;   .if n .sp 2e .ne 4 
 	FBTransfer()T   .if n .sp 2  .ne 3s 	FBKeyboard(TypeIn)f 	char **TypeIn;a   .if n .sp 2  .ne 4c 	FBPoint(X,Y,Key,Buttons)r 	int *X,*Y,*Buttons; 	char *Key;    .if n .sp 2  .ne 4b' 	FBMore(Left,Bottom,Right,Top,Textfile)r 	int Left,Bottom,Right,Top;i 	FILE *Textfile;   .fiw .vs  .rse .DTr .PPrJ KIC assumes that all frame buffer routines work properly and therefore are* not required to return a diagnostic value. .PPr The  .I "FBBegin()"L routine is the first frame buffer routine invoked by KIC and initializes theC frame buffer descriptor described above for the respective graphics  device.  The only argument
 .I Display2 specifies the display name or type and becomes the .I fDisplayf, member of the frame buffer descriptor.  The  .I fInitializedeH member of the frame buffer descriptor is used to define the state of the6 graphics device driver and is typically not set by the .I "FBBegin()"
 procedure. .PPr Thes .I "FBBegin()" routine will invoke thep .I "FBInitialize()"e5 procedure to initialize the graphics device driver toe the required state.  If the  .I fInitialized : member of the frame buffer descriptor is set to zero, the  .I "FBInitialize()"zJ routine will save the current state of the graphics device driver and thenK set the state of the driver to a CBREAK mode with no character echoing; see  .I "tty(4)"n$ in the BSD UNIX programmer's manual.I CBREAK mode allows a character to become available to the user program as K soon as it appears from the terminal and also permits flow control.  If thed .I fInitialized C structure member is not set, then typically there is no action whens .I "FBInitialize()"e is invoked.s@ When the communication link with the graphics device is not over	 .I stdio,wF such as for a Metheus Omega 400 display controller which does not haveL a keyboard, it is also desirable to place the standard input in CBREAK mode;H when KIC requests the user to input through the keyboard, the user inputG will be taken from the standard input device and echoed normally on then graphics display.c The  .I fInitializedt< member of the frame buffer descriptor is set to the value of .I Trueh
 before the .I "FBInitialize()"r procedure terminates.o .PPoI There are two procedures for releasing control of the graphics display ori
 frame buffer:p
 .I "FBHalt()"l ande
 .I "FBEnd()."  Theh
 .I "FBHalt()"dF routine is invoked when KIC receives a SIGTSTP stop signal (UNIX only)E which is generated by the KIC user from the keyboard when he wants toe2 suspend, but not terminate, the KIC program.  The  .I "FBEnd()"B routine is however the last frame buffer procedure invoked by KIC.I Both procedures will clear the graphics display, return the device driver " to its original state, and set the .I fInitialized 5 member of the frame buffer descriptor to the value of 	 .I False.e? If the KIC program was suspended by the user, invocation of theg .I "FBInitialize()"iH procedure will again save the current state of the device driver and set' the driver to the required CBREAK mode.  .PPeE A common configuration for running KIC is to have a graphics terminalrD connected to the host over a serial, full duplex, RS-232 line with aG 9600 or 19200 Baud rate.  When this is the case, it is always necessaryD to use bufferedSH output to reduce the number of system I/O requests to the host computer.F An example C procedure for buffering output characters is shown below: .brC .s4d .nfG   .ne 18> .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u 	#define	BUFSIZE	4096e   .if n .sp 2r 	static	int	NumTTYBuffer = 0;r  	static	char	TTYBuffer[BUFSIZE];   .if n .sp 2a: .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXXXXXXXXXX'u +\w'XXXX'u 	FBWrite(cp,n)7 		char *cp;	/* pointer to string to be put in buffer */g1 		int n;	/* size of string to be put in buffer */eH .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		{B  		/* test for buffer overflow */$ 		if((NumTTYBuffer + n) >= BUFSIZE){# 			write(1,TTYBuffer,NumTTYBuffer);n 			NumTTYBuffer = 0; 			} 		while(n--)% 			TTYBuffer[NumTTYBuffer++] = *cp++;t 		}e   .fiu .vs  .rsr .DTo .PP,F If the output graphics code is buffered, it is frequently necessary toJ flush the output buffer or transfer all buffered characters to insure that6 a specific display action will occur immediately.  The .I "FBTransfer()"a@ procedure would accomplish this, as in the above C procedure, byF writing all buffered characters to the graphics device and setting theA buffered character count to zero.  If output is not buffered, thee .I "FBTransfer()"h" routine will perform no operation. .PPi The  .I "FBSetFillPattern()"rF routine is invoked to set the current fill pattern of the frame buffer! to that identified by the integero .I StyleId wL that is greater than or equal to zero and less than or equal to the value of .I fNumFillPatternse@ in the frame buffer descriptor.  Solid fill is always defined by
 .I StyleIdI equal to zero.  If the graphics device does not provide filled geometriesh or has only solid fill, the  .I "FBSetFillPattern()"e$ procedure will perform no operation. .PPt Thes .I "FBDefineFillPattern()"0 procedure defines the fill pattern identified by
 .I StyleId and returns with
 .I StyleId& as the current fill style.  As for the .I "FBSetFillPattern()"  procedure, the value off .I StyleId  G is greater than or equal to zero and less than or equal to the value ofr .I fNumFillPatterns $ in the frame buffer descriptor.  The .I BitArray K argument is a pointer to an array of eight integers whose least significant J eight bits represent individual rows in an eight by eight intensity array.J For example, a fill pattern with an ascending diagonal line may be defined* by the following eight (decimal) integers: .DS C, 1 2 4 8 16 32 64 128 256   .DEbM A diagonal-grid fill pattern can be defined with the following integer array:e .DS Ce 257 130 68 40 40 68 130 257i   .DEu .PPr The value of the
 .I ColorId; argument for all frame buffer routines must be greater thanX7 or equal to zero and less than or equal to the value ofs
 .I fNumColorsn$ in the frame buffer descriptor.  The
 .I ColorIdB argument is in fact the index of a particular display color in the< video color table of the respective graphics device, and the
 .I fNumColorsrL member of the frame buffer descriptor specifies the size of the color table. .PPmC The color map that is used by KIC is simple; the first color in theo) video color table, which corresponds to ad
 .I ColorIdG value of zero, is always the background color of the display.  The last 6 color in the video color table, which corresponds to a
 .I ColorId value equal to the
 .I fNumColors F member of the frame buffer descriptor, is always used for highlightingH objects in the selection queue, displaying the coordinate axes, and alsoG defines the color of the cursor.  The remaining colors are dedicated to G the display of mask geometries.  Two mask layers can not share the sameoB color index of the video color table unless there are insufficientH display colors in which case the several mask layers will share the last1 entry in the color table, the highlighting color.b .PPo The  .I "FBVLT()"I procedure defines the video color table entry for the color identified byo
 .I StyleId" to be the color represented by the .I "Red, Green, Blue"p combination. The values of .I "Red, Green," andu .I Bluer" are normalized to the value of the .I fMaxIntensityE member of the frame buffer descriptor, which is usually equal to 255, 4 and their absolute maximum value is specified by the .I fMaxP? frame buffer structure member.  Once the color corresponding toi
 .I ColorIdF is redefined, all geometries that were written into the display memoryN of the respective frame buffer will immediately be displayed in the new color. The value of the
 .I ColorId argument must be greater than*7 or equal to zero and less than or equal to the value ofw
 .I fNumColorsX in the frame buffer descriptor.e .PP  The	 .I "FBForeground()" L routine is invoked to set the current drawing color to that specified by the
 .I ColorId argument.  The .I DisplayOrErase*F argument specifies whether the color is to be displayed or erased, and6 it must be one of the values defined as follows in the	 .I "fb.h"g header file: .brr .s4D .nf   G .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXX'u +\w'XXXXX'ueC .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXX'u +\w'XXXXX'u  .ne 4 2 	#define	ERASE	'e'	/* Erase to background color */3 	#define	DISPLAY	'd'	/* Show object as specified */r   .fit .vso .rsl .DTh .PP I If the color is to be erased, it is assumed that it will be erased to thee background color.  The .I DisplayOrErase G argument is redundant if the foreground color is set to color zero, the H background color.  It is provided for the programmer who wishes to writeG a frame buffer driver that uses a special \fIALU mode\fR which requires  this information.l .PPe' To explain the meaning of the ALU mode,w? it is necessary to understand the procedure by which a geometrybL is written into the video memory of the graphics display.  If we assume thatD the display is a typical raster device, each pixel of the display isG represented by a location in the video memory, and that memory locationb< contains the index in the video color table for the color by9 which the respective pixel is to be displayed on the CRT.oI Most frame buffers provide the capability of specifying how video displaynL memory is changed by a write operation.  One common mode of writing into the8 video memory is an arithmetic 'OR' operation between theG source color index and the contents of the destination memory location,lD where the source color index is the current, foreground color index.E In this case, the ALU mode is the 'OR' mode.  KIC will in general usesH the 'replace' mode in which the contents of the video display memory areG replaced by the source color index, regardless of the previous contentsn of the display memory. .PPf Thes .I "FBFlood()"K procedure is invoked to clear the entire display to the current, foregrounde color. .PPr Theu .I "FBSetCursorColor()"nH routine is invoked to set the color of the graphical cursor to the color
 identified byn .I ColorId.pH As described above, the last entry in the video color table of the frame+ buffer is always used for the cursor color.d .PPuH KIC allows mask colors to blink, if the respective frame buffer has this capability.  If thel .I "FBBlink()" routine is invoked with the  .I Flag" argument equal to the value of .I True,/ the color that is identified in the video colort$ table of the graphics display by the
 .I ColorIdG index is set to blink between its normal color and the color defined by & the color combination of the arguments .I "Red, Green," andf .I Blue.' The normal color for any given value ofh
 .I ColorIdL is the color that is defined in the video color table.  The rate of blinkingL is not definable; colors should blink at a rate that is comfortable to view. If the .I "FBBlink()"( routine is invoked with the value of the .I Flagt argument set tot	 .I False,f) then the color identified by the value ofl
 .I ColorIdH is set to a non-blinking state.  If the respective frame buffer does notK provide the capability of blinking colors, or alternating color definitionse in the video color table, thea .I "FBBlink()"  procedure performs no operation. .PP - There are six routines for displaying figuresf& or geometries on the graphics display:@ .I "FBMoveTo(), FBDrawLineTo(), FBLine(), FBBox(), FBPolygon()," andr .I "FBText()."C These frame buffer routines will display an object or figure in thecK current, foreground color and with the current fill pattern, if applicable.cB All coordinates that are passed as arguments to these frame buffer- procedures are display coordinates with there 
 .I "(0,0)": origin in the bottom, left corner of the graphics display.7 The effect of these routines might be delayed until theq .I "FBTransfer()"r) procedure is invoked to flush the output.  .PPi The  .I "FBMoveTo()" 3 procedure sets the current graphics position to the $ display coordinate identified by the
 .I "X1,Y1"* arguments.  A subsequent invocation of the .I "FBDrawLineTo()" I procedure will produce a solid line from the current graphics position to"( the display coordinate identified by the
 .I "X2,Y2"E arguments, and the current graphics position then moves to the latter  display coordinate.  The
 .I "FBLine()"X3 routine is invoked to display a solid line from the 
 .I "X1,Y1" display coordinate to theY
 .I "X2,Y2"K display coordinate, after which the current graphics position is set to theb
 .I "X2,Y2" display coordinate.i .PPe The  .I "FBBox()"K routine is invoked to display or erase a box in the color identified by thee
 .I ColorId- argument and in the pattern identified by thef .I Typea ande
 .I StyleIdC arguments.  The resulting box is defined by the display coordinatese .I "Left, Bottom, Right, Top"i2 and is either displayed in the color identified by .I ColorId,aB which becomes the foreground color, or is erased to the background# color depending on the value of thet .I DisplayOrErase  argument.  The .I DisplayOrErase C argument must be set to one of the values defined as follows in theo	 .I "fb.h"f header file: .br" .s4G .nf"  G .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXX'u +\w'XXXXX'utC .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXX'u +\w'XXXXX'ui .ne 4n2 	#define	ERASE	'e'	/* Erase to background color */3 	#define	DISPLAY	'd'	/* Shoe object as specified */    .fik .vst .rs  .DT  .PPe The  .I TypeuH argument specifies whether the box is to be filled or outlined, and this< argument must be one of the values defined as follows in the	 .I "fb.h"o header file: .br  .s4i .nfo  G .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXX'u +\w'XXXXX'ubC .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXX'u +\w'XXXXX'ur .ne 101 	#define	FILL	'f'	/* Fill with current pattern */n4 	#define	OUTLINE	'o'	/* Outline contour of object */   .fie .vsB .rs, .DTl .PP) If the box is filled, theh
 .I StyleIdI argument defines the fill pattern to be used; this fill style becomes the A current fill pattern.  The box must always be filled whenever thei .I DisplayOrErasee& argument specifies an erase operation. .PPr .I "FBPolygon()"> is invoked to display a polygon in the color identified by the
 .I ColorId- argument and in the pattern identified by them .I Typee and 
 .I StyleId3 arguments.  The vertices of the polygon are defined & in the integer array referenced by the .I xyr3 pointer; the number of vertices is specified by the 
 .I ncoords- argument, and the first display coordinate iss .I "(xy[0], xy[1]),"  the second display coordinate is .I "(xy[2], xy[3]),"
 etc.  The  .I TypetL argument specifies whether the polygon is to be filled or outlined, and this< argument must be one of the values defined as follows in the	 .I "fb.h"i header file: .brT .s4I .nfi  G .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXX'u +\w'XXXXX'uiC .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXX'u +\w'XXXXX'u  .ne 101 	#define	FILL	'f'	/* Fill with current pattern */i4 	#define	OUTLINE	'o'	/* Outline contour of object */   .fie .vsD .rsy .DTs .PPr If the polygon is filled, theg
 .I StyleIdI argument defines the fill pattern to be used; this fill style becomes theaG current fill pattern.  If the frame buffer is not capable of displayingU2 filled polygons, the polygons are always outlined. .PPp
 .I "FBText()"g: is invoked to display a character string referenced by the .I Texti' argument at the position defined by the 	 .I RowOrXh andp .I ColumnOrYJ arguments.  As described in Section 4.1.1, KIC uses two coordinate systems, for the positioning of graphic text, and the
 .I "FBText()"a- procedure must accommodate both systems.  The  .I Mode H argument specifies which coordinate system is to be used and must be set. to one of the values defined as follows in the	 .I "fb.h"f header file: .bre .s4p .nf   K .if t .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'uiG .if n .ta \w'XXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXX'u +\w'XXXXX'ux .ne 105 	#define	ROW_COLUMN	'r'	/* use ASCII terminal mode */h= 	#define	PIXEL_COORDINATE	'p'	/* use graphics display mode */n   .fia .vsh .rs  .DTi .PP  If the .I Modei/ argument is set to the value of ROW_COLUMN, theh	 .I RowOrXo and  .I ColumnOrYG arguments specify the position for the first character of the string insE the row-column or character block coordinate system; otherwise, theserL arguments specify the lower, left display coordinate for the first characterC of the string.  Displayed text is never rotated and normally uses a H single character font.  Because the row-column coordinate system is usedK exclusively for displaying text in the command, information, and layer menu  viewports, the .I ModedJ argument could be used, however, to specify one of two graphic text fonts. .PP  .I "FBPoint()"E is the only frame buffer routine that controls the graphical pointing  device.  When invoked, the .I "FBPoint()"O routine displays the graphical cursor and then waits for a user pointing event. : If the graphical pointing device is equipped with buttons,I a pointing event occurs when the KIC user presses one of these buttons oreK presses a character key on the keyboard; otherwise, if there are no buttonseL on the graphical pointing device, a pointing event occurs only when the userL presses a character key on the keyboard.  After one user pointing event, the ."FBPoint()"F routine terminates, and the returned values also depend on whether theN graphical pointing device is equipped with buttons.  If the graphical pointing> device has buttons and the user pressed one of these buttons,  .I "FBPoint()"A returns with the value of zero in the character referenced by the  .I KeyA pointer, the display coordinate coordinate of the graphics cursormD (i.e., the position of the cursor) in the integers referenced by the	 .I "X, Y"oJ pointers, and the identifying button mask in the integer referenced by the
 .I ButtonsB pointer; this button mask can be compared with the contents of the .I fButtonMaskO member of the frame buffer descriptor to determine the button that was pressed.oJ If the graphical pointing device has buttons and the KIC user types at theI keyboard of the graphics terminal, then the character that was user-typedt. is returned in the character referenced by the .I Key7 pointer, and the other returned values are meaningless. C If the graphical pointing device does not have buttons and the userX, presses a character key on the keyboard, the .I "FBPoint()"1 routine returns with the value of typed charactere" in the character referenced by the .I Key6 pointer, the display coordinate of the cursor position! in the integers referenced by the 	 .I "X, Y" ' pointers, and the returned value of thev
 .I ButtonsG argument is meaningless.  The graphics cursor is always disabled beforei .I "FBPoint()" terminates.  .PPt Thei .I "FBKeyboard()"oI procedure is invoked to obtain user input from the device keyboard or thehH standard input.  This input routine will perform character buffering and- input line management, and return the pointere	 .I TypeIneF to the input character buffer.  The input line management includes theN handling of the erase character (typically control-H or delete), the line kill> character (control-X or control-U), special hacking of controlD characters (especially the escape character), and character echoing.K All characters that are typed by the KIC user are echoed in the information,6 viewport beginning at the text column specified by the .I fLastCursorColumn= member of the frame buffer descriptor, and are displayed withu the color identified by thee .I kpMenuTextColorK member of the KIC parameters structure, which becomes the foreground color.X .I "FBKeyboard()"X> terminates when the user presses either the new-line or return key (control-J or control-M).\ .PPXH To display the contents of a file in a viewport of the graphics display, KIC invokes theh
 .I "FBMore()"e
 routine.  Thef .I Textfile I argument is the file descriptor for the text file that is to be displayedi  in the viewport specified by the .I "Left, Bottom"h andu .I "Right, Top"l display coordinates.
 .I "FBMore()" J will display characters from the file until it has filled the space of theG viewport, and then will prompt the KIC user in the same viewport before 0 continuing; the procedure is similar to the UNIX
 .I more(1) command.  As for the the .I "FBKeyboard()"oJ routine, special hacking of control characters should be performed because* a frame buffer with a serial, full duplex,- RS-232 interface could enter an unknown state F when it receives information that is similar to graphics command code.& When the end of the file detected, the
 .I "FBMore()" J routine will erase the viewport to the background color, color index equal0 to zero, and return.  The file referenced by the .I Textfileb* argument is not closed before termination. .PPh .I "FBPolygonClip()"0 will clip a polygon to the window defined by the	 .I windowx@ argument.  The vertices of the polygon to be clipped are defined& in the integer array referenced by the .I xynM pointer; the number of vertices is specified by the integer referenced by ther
 .I ncoords, argument, and the first window coordinate is .I "(xy[0], xy[1])," the second window coordinate ist .I "(xy[2], xy[3]),"= etc.  It is assumed that the integer buffer referenced by theh .I xy M pointer is sufficiently large to contain the returned vertices of the clipped J polygon.  The number of vertices of the clipped polygon is returned in the integer referenced by thei
 .I ncoordsO argument.  See Section 4.1.3 that describes window-to-viewport clipping in KIC.  .bpn .XSi. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	4.7. Geometry Display Routineso .XEe .SHt 4.7. Geometry Display Routines .PP K There are seven routines that are built on top of the frame buffer routinesr< specifically for displaying objects in the layout viewports:C .I "ShowBox(), ShowPolygon(), ShowWire(), ShowLabel(), ShowLine(),"  .I "ShowManhattanLine(),"y and  .I "ShowPath()."H These routines perform the window-to-viewport transformations, window toL viewport clipping, and then display the respective object in the appropriate& viewport depending on the value of the .I kpRedisplayControl 9 parameter.  A synopsis of these display routines follows:u .bre .s4n .nfJ   .ta \w'XXXXXXXX'uX .ne 4s 	ShowBox(Layer, BB, Window)n 	int Layer;f 	struct ka BB, Window;   .if n .sp 2h .ne 4B$ 	ShowLabel(Layer, Label, X, Y, Flag)
 	char *Label;h 	int Layer, X, Y, Flag;    .if n .sp 2i .ne 4 ( 	ShowLine(Layer, X1, Y1, X2, Y2, Window) 	int Layer, X1, Y1, X2, Y2;  	struct ka Window;   .if n .sp 2e .ne 4"1 	ShowManhattanLine(Layer, X1, Y1, X2, Y2, Window)n 	int Layer, X1, Y1, X2, Y2;f 	struct ka Window;   .if n .sp 2t .ne 5C) 	ShowPath(Layer, Path, Window, Terminate)i 	struct p *Path; 	struct ka Window; 	int Layer, Terminate;   .if n .sp 2e .ne 5B! 	ShowPolygon(Layer, Path, Window)i 	struct p *Path; 	struct ka Window; 	int Layer;e   .if n .sp 2r .ne 5 % 	ShowWire(Layer, Width, Path, Window)c 	struct p *Path; 	struct ka Window; 	int Layer, Width;   .fis .vsl .rs  .DTi .PPmL All coordinate values that are passed as arguments to these display routines; must be world coordinates and not display coordinates.  Theu .I LayerL argument defines the color with which the object is to be displayed, and the	 .I WindoweB argument defines the window to which the object should be clipped. .PP @ The display routines must also consider the fill pattern for theF respective layer.  Because there are frame buffers that do not provideK the capability of stippled fill patterns, the KIC geometry display routines H provide at least two modes of presentation for the objects on any layer.F These two modes are filled and outlined, and the presentation mode for7 a given layer is determined by the logical value of theh .I klFilledn7 member of the KIC layer table for the respective layer.s@ See Section 4.2.3 that describes the KIC layer table descriptor. .PPoA Except for a few peculiarities, these procedures should be easilyeJ understood by any programmer ho is familiar with the frame buffer routinesB and CD path descriptor.  The remainder of section will discuss the) peculiarities of the individual routines.e .PPl5 Because the CD database has no notion of text size, a,	 .I Windowo argument is not passed to thes .I "ShowLabel()"D procedure.  This display procedure will attempt to evaluate the size9 and position of the text label in display pixels from thea
 .I fFontWidthi ande .I fFontHeightD members of the frame buffer descriptor, and from this information itG will determine the number of characters in the label that will fit intos, each of the layout viewports.  Normally, the .I "ShowLabel()"G routine will not attempt to display a label in a viewport if the numberrK of display pixels to window lambda is less than two; the label will howevere2 always be displayed in all layout viewports if the .I Flaga argument is set to a .I Truee logical value. .PP, The  .I "ShowManhattanLine()" routine is identical to the  .I "ShowLine()"e> routine, except that it uses a more simple clipping algorithm.G If this procedure is used to display a line that is neither vertical orYD horizontal with respect to the graphics display and is not contained) entirely within the window defined by the 	 .I Windowf. argument, it will not be displayed accurately. .PPB Thea .I "ShowPath()"  routine will use the
 .I "FBLine()"t4 procedure to display the path list referenced by the .I Path  argument.  If thet .I TerminateL argument is set, the path is terminated to produce the contour of a polygon. .XSp. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 		4.7.1. Redisplay .XE  .SH  4.7.1. Redisplay .PPeL Before an area of the layout viewports can be drawn, it must first be erased to the background color.  Ther .I "ShowBox()"> routine could be used to erase an area of the layout viewports1 by drawing a box on layer zero, but typically thea .I "EraseBox()", procedure is used. .br( .s4  .nf    .ta \w'XXXXXXXX'us .ne 4n 	EraseBox(Area, Window)v 	struct ka Area, Window;   .fip .vsf .rsa .DTs .PP  Thee .I "EraseBox()"u/ procedure will erase the area identified by then .I Areao( argument in the window identified by the	 .I Windowo	 argument.d .PPp: After an area of the layout viewports has been erased, the .I "Redisplay()"E routine is invoked to display the layout information in the viewport.s .br  .s4o .nf.   .ta \w'XXXXXXXX'uK .ne 4r 	Redisplay(SymbolDesc, AOI)e 	struct s *SymbolDesc; 	struct ka AOI;r   .fil .vse .rse .DTe .PPd Then .I "Redisplay()"P procedure will display all layout information of the CD symbol referenced by the
 .I SymbolDescd< symbol descriptor contained within the window defined by the .I AOI argument.  The .I kpRedisplayControliL member of the KIC parameters structure determines the viewports that will beA affected by this routine.  This routine is also controlled by theo .I ExpandInstances andi .I kpExpandFineViewportOnlyI? members of the KIC parameters structure defined in Section 4.3.e .PPt. Given the above geometry display routines, the .I "Redisplay()"B procedure is a simple application of the CD database.  The exampleG C procedure that is provided in Section 2.6 as an example of traversing 8 a symbol hierarchy is similar, but not identical, to the .I "Redisplay()"
 procedure. .PPe; Because of the display philosophy of KIC, in particular theoL fact that a red box displayed on top of a green box will hide the green box,O this routine is inherently inefficient since it must traverse the entire symboltD hierarchy once for each layer so that the layer interactions will beH consistent (e.g., red objects are always displayed above green objects).E There are at least two possible modifications that would increase thet efficiency and speed of the  .I "Redisplay()"C procedure:  the first is to modify the CD database to recognize the)O layers in the symbol's bin structure that are in use.  This would eliminate therI overhead of initializing CD to search an empty bin structure.  The secondtE modification would be to change the display philosophy of KIC and usewG the 'OR' ALU mode described in Section 4.6.2.  In this case, each layer J would correspond to one memory plane in the frame buffer, and a red objectL displayed on top of a green object would produce a, perhaps, brown object inL the area of intersection.  This approach was used in earlier versions of KICK but was rejected in favor of priority redisplay and color stipple patterns. L The major problem with the plane-per-layer, color mixing solution is that itK severely limits the number of uniquely colored layers that can be displayedjF simultaneously on the graphics display because most frame buffers have> fewer than 10 memory planes, and most IC designers claim to beH more comfortable with the notion of layer depth than with puzzling layer
 interactions.  .bpL .XSf. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	4.8. Geometry Input Routines, .XE) .SHa 4.8. Geometry Input Routines .PP = There are seven routines in KIC that allow the user to createoD objects in the CD database.  A synopsis of these procedures follows: .br" .s4o .nfa   .ta \w'XXXXXXXX'u1 .ne 42 	Arcs(LookedAhead) 	int *LookedAhead;   .if n .sp 2n .ne 4  	Boxes(LookedAhead)  	int *LookedAhead;   .if n .sp 2i .ne 4  	Doughnut(LookedAhead) 	int *LookedAhead;   .if n .sp 2; .ne 4  	Flash(LookedAhead)o 	int *LookedAhead;   .if n .sp 2r .ne 4P 	Label(LookedAhead)o 	int *LookedAhead;   .if n .sp 2n .ne 4S 	Polygons(LookedAhead) 	int *LookedAhead;   .if n .sp 2r .ne 4W 	Wires(LookedAhead)i 	int *LookedAhead;   .fiD .vsP .rsl .DTr .PPeD From the argument list of each routine, one could correctly concludeM that these routines are similar.  This section will describe the requirementsn5 and resulting similarities of these input procedures.a .PPeE Each of the above procedures for creating geometries is invoked after 7 the KIC user selects a corresponding command menu item.h> Each routine will terminate when the user either selects a newG menu command or after an error condition is detected, such as if the CD B database is unable to create an object because of a failure of the
 .I "malloc()"AE routine.  While in one of the geometry creation routines, if the user C selects another menu command, the integer that is referenced by the" .I LookedAhead argument is set to the value ofa .I True.* Another way of interpreting the use of the .I LookedAheadO argument is that it is used by a child procedure to notify the parent procedureIE that the KIC user has performed an action that the child procedure issH unable to handle.  See Section 4.4 that describes the KIC command menus. .PPsG Because these procedures interface to the KIC user and thereby directly L affect how efficiently he can use KIC, the procedures must be user-friendly.G There is a set of requirements for any such routine.  Firstly, geometryrI creation must be a mode of operation, rather than a single command;  thisoL allows the KIC user to create several objects without having to specify thatG he is doing so for each object.  Secondly, the KIC user must be able toyF change the current layer while KIC is in the geometry creation mode ofG operation.  The user must also be capable of 'undoing' his last action.g .PPc7 A pseudo C procedure is provided below as an example oft; a basic KIC user interface routine.  All the above geometryw5 creation routines are similar to the following model:y .brt .s4i .nf    .ne 18H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	MakeObject( LookedAhead ) 		int *LookedAhead;a 		{  		\fIinitialize\fR;p8 		\fIuse ShowPrompt to tell the user what he's doing;\fR   .if n .sp 2( 		while( True ){   .if n .sp 2  			Point();n   .if n .sp 2s. 			/* Has the user selected a menu command? */) 			if ( Parameters.kpCommand[0] != EOS ){o   .ne 14 .if n .sp 2 % 				/* Did the user point to UNDO? */*6 				if ( strcmp(Parameters.kpCommand,MenuUNDO) == 0 ){" 					if ( \fInothing to undo\fR ){ 						*LookedAhead = True;
 						return;o 						};: 					else if ( \fIcurrent object has been terminated\fR ){% 						\fIdelete the entire object;\fR 9 						\fIset flag to expect first point of new object;\fR  		 				}
 					else{  						\fIundo the last point;\fR 						}c 					} .ne 8e1 				/* The user selected another menu command. */r	 				else{ ( 					\fIterminate the current object;\fR 					*LookedAhead = True;  					return; 					} 				}a   .if n .sp 2c .ne 4m7 			/* Did the user not point in the layout viewport? */h. 			else if ( !Parameters.kpPointCoarseWindow )
 				continue;e   .if n .sp 2  .ne 5C6 			/* Do we expect the first point of a new object? */( 			else if ( \fIexpect first point\fR ){ 				\fIbegin new object;\fRc 				}    .if n .sp 2e .ne 6 * 			/* Is this the same point as before? */3 			else if ( Cursor.kcX == X And Cursor.kcY == Y ){ 4 				\fIterminate current object to begin another;\fR7 				\fIset flag to expect first point of new object;\fR  				}    .if n .sp 2e .ne 9 ? 			/* If none of the above, add point to object description. */a 			else{& 				\fIadd point to current object;\fR 				}n   .if n .sp 2e 			} 		}r   .fie .vst .rsI .DTo .PPd	 The aboves .I "MakeObject()"iH procedure allows the user to describe an object by interactions with theM graphical pointing device, and thereby enter the object into the CD database. K The user also has the ability to 'undo' either the previously entered pointpI or the previously created object.  The procedure also recognizes when thetF user has not pointed in the layout viewports which permits the user toG easily change the current layer by pointing in the layer menu viewport.  .bpe .XSa. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u1 	4.9. Geometry and Symbol Modification Proceduresy .XEh .SHc% 4.9. Geometry Modification Procedurese .PP"N The KIC user must have the capability of easily editing or modifying geometricO objects.  There is an entire KIC command menu, the selection menu, dedicated torF this user need.  This chapter will describe KIC's philosophy of object- modification and the user interface routines.e .PPtJ The first assumption of object editing in KIC is that the user will desireJ to modify several objects simultaneously rather than one object at a time.J For example, he may wish to stretch a signal bus containing several wires,H or he may want to copy a bipolar transistor and add a 90 degree rotation1 without destroying the inter-spacing of geometry.  .PP M The question then arises of how to remember and represent the several objectsuC that the user will want to modify in a way that the user can easily K control and in a way that will not be cumbersome for any editing operation.sG In other words, how would the KIC user define a working set of objects? F One solution might be to require the user to define a rectangular area? that contains every object to be modified.  A problem with thissE simple solution, however, is that it does not allow the user to be asgL specific as he might wish to be; suppose, for example, that the user intends9 to move all objects in a rectangular area except one box.  .PP N The KIC solution to this problem is the selection queue that contains pointersK to the user-specified objects in the symbol that is currently being edited. % The selection queue is defined in thee
 .I "select.h"e file as follows: .bro .s4  .nfA  H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u .ne 8f 	struct ks { 		struct ks *ksSucc; 		struct o *ksPointer; 		};   .if n .sp 2  	struct ks *SelectQHead;   .if n .sp 2o 	struct ka SelectQBB;a   .fis .vs	 .rsa .ne 10 .PPuH The following procedures are used by KIC to control the selection queue. .br  .s4  .nfb   .ta \w'XXXXXXXX'u) .ne 2c 	SelectQInit()   .if n .sp 2b .ne 3j 	SelectQInsert(Pointer)t 	struct o *Pointer;g   .if n .sp 2e .ne 3t 	SelectQDelete(Pointer)  	struct o *Pointer;a   .if n .sp 2l .ne 3' 	SelectQFirst(Pointer) 	struct o **Pointer;   .if n .sp 2  .ne 3  	SelectQClear()e   .if n .sp 2n .ne 3e 	SelectQComputBB()   .if n .sp 2  .ne 3v 	SelectQShow(AOI)i 	struct ka AOI;a   .fia .vsh .rsr .DTa .PPy Thet .I "SelectQInit()"1 procedure is invoked to initialiaze the selection+1 mechanism.  This procedure is invoked once by thei .I "InitParameters()"X? procedure that assigns the default values to members of the KICs parameters structure.l .PPf .I "SelectQInsert()"1 is invoked to add an object that is referenced byc
 .I PointerN to the selection queue.  The object is always inserted at the top of the list. Any procedure that invokes .I "SelectQInsert()"H is required by convention to set the information field of the particular" object to the value of one via the .I "CDSetInfo()" database routine.y .PPe .I "SelectQDelete()"> removes from the selection queue that object referenced by the
 .I Pointer@ argument and releases the memory that was used by the respective .I kso8 structure.  No action occurs if the object descriptor isA not contained in the selection queue.  Any procedure that invokesh .I "SelectQDelete()"E is required by convention to set the information field of the removedt# object to the value of zero via theb .I "CDSetInfo()" database routine.n .PPr Thes .I "SelectQFirst()"s$ returns in the pointer referenced by
 .I PointerJ the first object in the selection queue (the object that is at the head ofH the list).  If the selection queue is empty, a null pointer is returned. .PPt Thet .I "SelectQClear()"sC procedure is invoked to remove all objects from the selection queuet' and release all related memory.  Before  .I "SelectQClear()" 9 terminates, the pointer to the top of the selection queuee .I SelectQHead! is assigned to the value of NULL.n .PP  When the .I "SelectQComputBB()"K is invoked, the bounding box of all objects that are in the selection queuev is evaluated and stored in the .I SelectQBB@ area descriptor.  If the selection queue is empty, the resultingJ bounding box will have impossible values; the top of the box will be below= the bottom, and the right side will be left of the left side.M .PPj TheL .I "SelectQShow()"M routine is invoked to highlight in the layout viewports all objects containedr= in the selection queue that intersect the area defined by the  .I AOIK argument.  The emphasis is provided by outlining the contour of all objects 5 that qualify with the color that is identified by thei .I kpHighlightingPixelN member of the KIC parameters structure.  This routine is always invoked by the .I "Redisplay()" procedure before it terminates.e .PPdH The information field of an object is used by KIC to identify the statusD of the particular object.  A table of the current uses of the object! information field is shown below:n .brj .s4f .nf	   .ne 12S .if n .ta \w'XXXXXXX'u +\w'XXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u P .if t .ta \w'XXXXX'u +\w'XInfo = XXXXXX 'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u0 	 Info = 0	Object is unselected (default value).5 	*Info = 1	Object is selected and in selection queue.sB 	 Info = 2	Object is conditionally deleted and in selection queue.A 	 Info = 3	Object is conditionally copied and in selection queue. C 	 Info = 4	Object is conditionally selected and in selection queue.e3 	 Info = 5	Object is polygon or wire being created.eD 	 Info = 10	Object is box that could not be stretched (see modify.c)< 	*Info = 11-255	Object has conditionally new layer and is in5 		selection queue.  The old layer number = Info - 10.f  9 	* means that SelectQShow() will highlight these objects.    .fi  .vs  .rs  .DTr .PPsH Given the above routines for managing the selection queue, an example isM in order.  The following procedure will examine the contents of the selection , queue and delete all objects that are boxes: .brs .s4u .nfn   .ne 18H .ta \w'XXXXXXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	#include "kic.h"t 	#include "select.h"   .if n .sp 2i 	DeleteBoxes() { 		struct ks *SelectQDesc;. 		char Type;   		SelectQDesc = SelectQHead; 		while(SelectQDesc != NULL){s( 			CDType(SelectQDesc->ksPointer,&Type); 			if(Type == CDBOX){r; 				CDDelete(Parameters.kpCellDesc,SelectQDesc->ksPointer);o* 				SelectQDelete(SelectQDesc->ksPointer); 				} % 			SelectQDesc = SelectQDesc->ksSucc;  			} 		}C   .fi( .vss .rsk .DTh .PPnM There are six routines for the user-editing of objects in KIC; each proceduree@ uses the selection queue.  A synopsis of each is provided below: .brt .s4e .nfl   .ta \w'XXXXXXXX'ul .ne 4i 	ChangeLayer(LookedAhead)f 	int *LookedAhead;   .if n .sp 2  .ne 4  	Copy(LookedAhead) 	int *LookedAhead;   .if n .sp 2  .ne 4e 	Del(LookedAhead)  	int *LookedAhead;   .if n .sp 2u .ne 4o 	Move(LookedAhead) 	int *LookedAhead;   .if n .sp 2  .ne 4c 	StretchBox(LookedAhead) 	int *LookedAhead;   .if n .sp 2s .ne 4e 	StretchPath(LookedAhead)o 	int *LookedAhead;   .fiy .vs  .rso .DTh .PP M The requirements of these user-interface procedures for geometry modificationuI are similar to those for geometry creation.  The KIC user must be capableoF of 'undoing' any command, but he most also be capable of canceling theF effect of an 'undo'.  These procedures are also mode-oriented, therebyG allowing the user to, for example, move objects in the layout viewports K without being required to select the particular command before each action.XE Also, the user is capable of redefining the current transformation ofXF objects at any time in the editing process; the current transformationB is described in Section 4.3 covering the KIC parameters structure. .bpo .XSO% \fBChapter 5:  System Dependencies\fRe .XEo .DS C. .ps +4 .B "Chapter 5" .psi .DEy .sp 1  .DS Cs .ps +4 .B "System Dependencies" .psc .DEi .sp 2s .PPeE At present, KIC runs under Berkeley VM/UNIX, Masscomp Real-Time UNIX,c- and VAX/VMS; clearly the program is portable.nE The major problems that are involved with transporting KIC to anothery/ operating system are described in this chapter. 6 It is, of course, impossible to predict every possibleH problem that may arise by attempting to move KIC to another system; onlyD those difficulties that have been experienced in past are described.E It is also assumed here that all C compilers are friendly and free oft bugs and quirks! .PP = The standard definition of the C programming language is [3]. M It is assumed in KIC to be legal to pass entire structures in argument lists. K All data structure member names in KIC are unique, and therefore no problemS: should ever arise from conflicting structure member names.& Also, data unions are not used in KIC. .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	5.1. Terminal I/O DependenciesI .XE  .SH  5.1. Terminal I/O Dependencies .PPeF Because the C programming language does not at present have a standardA set of procedures for special I/O control, the first problem with I transporting KIC to another system is usually the frame buffer interface.s3 KIC must operate in a CBREAK mode; standard I/O, ort	 .I stdio,j= is not sufficient.  CBREAK mode implies that characters typed F at the terminal are not buffered, but becomes available to the program> when they are typed.  Character echoing must also be disabled.3 This mode is easily obtained with the Berkeley UNIX  .I "tty(4)"o9 general tty interface; under VMS it is available from the" .I "sys$qiow()"  system service routine.n .XSe. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	5.2. The Directory Search Path  .XEs .SH  .ne 3p 5.2. The Directory Search Path .PP O To have the capability of easily using standard cell libraries, KIC must have aoC directory search path capability.  When KIC requires that a file be C opened, a list of directories will be searched for that file in then= order that the directory names appear on the respective list.t9 The first file found in the directory list is opened, and'M if the file name is not found, a new file is opened in the current directory.#2 This directory search algorithm is provided in the .I "POpen()" routine. .PP ) The list of directories is defined by the; .I "PSetPath()"D routine that will invoke the .I "PConvertTilde()"H procedure to perform special character conversion.  Under Berkeley UNIX,E the tilde (~) character is converted to the complete path name of thepE user's home directory; under VMS, the tilde character is converted to  the user's login name. .PPi: To transport KIC to a system that does not have UNIX style@ directory path names or does not have the equivalent of the UNIX .I "getpwnam(3)"& routine, it is necessary to modify the .I "PConvertTilde()"> procedure such that it will perform tilde expansion correctly. And most importantly, thee .I "POpen()"D procedure must be modified such that it will be capable of correctlyI appending a file name to any directory name in the directory search list.f> As an example of this under the VMS file system, the file name .I "CELL.K"s/ would have to be appended to the directory names .I "DMA0:[USER.JOE.LAYOUT]"a to produce the character stringe! .I "DMA0:[USER.JOE.LAYOUT]CELL.K"i1 as the complete path name of the respective file.o .XSd. .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	5.3. Memory Managementm .XEI .SHp .ne 3e 5.3. Memory Management .PP J On virtual memory systems, KIC and the CD database will allocate memory onM demand.  For speed considerations, a special memory management package calledm .I "nmalloc"@ has been developed.  In general, the memory allocation procedure .I "malloc(),"> which is provided in most C run-time libraries, attempts to beK efficient and miserly with the existing free memory; consequently, it tends  to be undesirably slow.i .PP  Thee .I "nmalloc()"H routine maintains a separate free list for objects of a particular size.@ A free list in this case is a linked-list of free memory blocks;@ the first few bytes of the memory block are used as a pointer toJ the next free block of memory with the same size.  Because large blocks ofF memory (greater than 100 bytes) are infrequently requested, free listsI are maintained only for memory blocks smaller than 80 bytes.  If a largerl! piece of memory is requested, ther .I "nmalloc()" routine defaults to the usuala
 .I "malloc()"p" memory allocation library routine. .PPh  All memory blocks are aligned by .I "nmalloc()"I to the size of an integer, which is typically four bytes.  Therefore, if r .I "nmalloc()"J is invoked to return a pointer to 10 bytes of free memory, the actual size@ of the allocated memory block will be 12 bytes.  Furthermore, if .I "nmalloc()"D maintains free lists for free memory blocks that are smaller than 80' bytes, only 20 free lists are required.n .PPi7 The free storage that is contained in a free list for ar3 particular size of memory block is allocated by thel .I "nmalloc()"M routine only when a block of memory having that particular size is requested.(O When the free list must be constructed, or additional memory added to the list,i .I "nmalloc()"4 will request a large block of memory from the systemO (typically 4096 bytes), and this memory block will then be divided to build theL+ desired free list.  Under Berkeley UNIX the  .I "sbrk(2)"= library routine is used to acquire this large block of memoryD( from the system, and VMS uses the normal
 .I "malloc()"  library routine. .PP ' To transport KIC to another system, thec .I "nm_block_alloc()"aI procedure must be modified such that previously described free lists will H be properly constructed.  It is possible to compile KIC to use the usual
 .I "malloc()"a library procedure, and not the .I "nmalloc"; package, by setting the USE_OLD_MALLOC compiler flag in the  .I "nmalloc.h" header file. .XS . .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u 	5.4. The System Interface .XEr .SHe .ne 3o 5.4. The System Interfacei .PPe The  .I "ShowProcess()"H procedure is used by KIC to execute a system command or a child process.H This routine must be capable of running a process, displaying any outputD in the area of the fine viewport, and detecting when the process has# completed.  Under Berkeley UNIX then
 .I "popen(3)"i* library routine is used, and under VMS the .I "LIB$SPAWN()" system service routine is used.n .PPfK To transport KIC to another operating system, it is necessary to modify the  .I "ShowProcess()"H routine, and the argument lists must also be corrected.  For example, to= display a directory listing in the area of the fine viewport,i, the command string under UNIX is as follows: .DS CX ShowProcess( " ls -C " );s   .DEs9 The corresponding command string under VMS is as follows:t .DS C 1 ShowProcess( " DIRECTORY/COLUMN=3/OUTPUT=KIC " );r   .DE  Thet .I "ShowPrompt()" D procedure for VMS will recognize the "OUTPUT=KIC" string and replaceG the three characters "KIC" with the name of a temporary file.  When the E spawned process has completed, the contents of the temporary file ares+ displayed in the area of the fine viewport.d .pn -(\n%u-1u)	 .de h1 \"b 'sp|.5ir .tl '''A.%'e 'sp|1.0i .nsf .. .wh 0 h1 .bpr	 .XS A.1 0l7 \fBAppendix A:  A Catalog of All Routines and Macros\fR  .XEl .DS Cr .sp .3io .ps +4 .B "Appendix A"r .ps  .DEy .sp 1l .DS Ce .ps +4) .B "A Catalog of All Routines and Macros"  .psn .DEd .sp 2r .PPsE The following pages contain a catalog of all routines and macros usedl4 in KIC and the source files in which they are found.J This list has two uses: it provides a index that will allow the programmerL to quickly determine the source file that contains a particular routine, andF it also allows the programmer to easily check the argument list of any function call. .DTv .de us \\$1\v'.1i'\l'|0\(ul'e ..	 .de hd	\"eK .if n .ta \w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u H .if t .ta \w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u .ft Br .vst .nf  .sp 2o .ps +2 .us "SYNOPSIS	SOURCE FILE" .psI .ft PoE .ta \w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u  .if t .vs -6 .if n .vs -3 .sp 2r ..
 .wh .8i hd .nfeE .ta \w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'ud .bpt .if n .sp 2o .ne 3k  ABeginCall(SymbolNum)	actions.c	 int SymbolNum;   .if n .sp 2l .ne 4 ( ABeginSymbol(SymbolNum, A, B)	actions.c	 int SymbolNum;	 int A, B;5   .if n .sp 2I .ne 6e< ABox(Length, Width, X, Y, XDirection, YDirection)	actions.c	 int Length, Width;	 int X, Y;s int XDirection, YDirection;t   .if n .sp 2  .ne 4r AComment(Text)	actions.c	e char *Text;u   .if n .sp 2, .ne 4y# ADeleteSymbol(SymbolNum)	actions.c	n int SymbolNum;   .if n .sp 2t .ne 3e AEnd()	actions.c	    .if n .sp 2U .ne 3n AEndCall()	actions.c	r   .if n .sp 2e .ne 3u AEndSymbol()	actions.c	W   .if n .sp 2r .ne 4u# ALayer(Technology, Mask)	actions.c	C char Technology; char *Mask;t   .if n .sp 2o .ne 3  AMallocFailed()	actions.c	   .if n .sp 2a .ne 3  APolygon(Path)	actions.c	d struct p *Path;o   .if n .sp 2e .ne 4i# ARoundFlash(Width, X, Y)	actions.c	t
 int Width;	 int X, Y;u   .if n .sp 2  .ne 4: AT(Type, X, Y)	actions.c	 
 char Type;	 int X, Y;o   .if n .sp 2m .ne 4i& AUserExtension(Digit, Text)	actions.c	 char Digit;D char *Text;M   .if n .sp 2" .ne 4  AWire(Width, Path)	actions.c	  struct p *Path; 
 int Width;   .if n .sp 2K .ne 3i AddLayer()	attri.c	r   .if n .sp 2i .ne 3  AddProperty()	prpty.c    .if n .sp 2p .ne 4 * AddResultingTransform(Pointer, TF)	move.c	 struct o *Pointer; int *TF;   .if n .sp 2n .ne 4 & AppendPointToPath(X, Y, Path)	wires.c	 struct p **Path;	 int X, Y;e   .if n .sp 2o .ne 3s Arcs(LookedAhead)	polygns.c	 int *LookedAhead;a   .if n .sp 2  .ne 30 Area(LookedAhead)	select.c	s int *LookedAhead;n   .if n .sp 2e .ne 3i Attri()	attri.c	   .if n .sp 2X .ne 6X0 BBLabel(Label, X, Y, BBCoarse, BBFine)	labels.c	 struct ka *BBCoarse; struct ka *BBFine; char *Label;	 int X, Y;m   .if n .sp 2C .ne 3a Basic()	basic.c	   .if n .sp 2d .ne 6s Blink(LookedAhead)	attri.c	l int *LookedAhead;p   .if n .sp 2  .ne 4l/ Box(DisplayOrErase, Layer, L, B, R, T)	boxes.c	  char DisplayOrErase; int Layer, L, B, R, T;   .if n .sp 2s .ne 3- Boxes(LookedAhead)	boxes.c	e int *LookedAhead;e   .if n .sp 2i .ne 6r9 CDBB(SymbolDesc, Pointer, Left, Bottom, Right, Top)	cd.c	i struct s *SymbolDesc;o struct o *Pointer; int *Left, *Bottom;i int *Right, *Top;    .if n .sp 2. .ne 6eD CDBeginMakeCall(SymbolDesc, Name, NumX, DX, NumY, DY, Pointer)	cd.c	 struct s *SymbolDesc;  struct o *Pointer; char *Name;h int NumX, DX, NumY, DY;r   .if n .sp 2  .ne 6B7 CDAddProperty(SymbolDesc, Pointer, Value, String)	cd.c	r struct s *SymbolDesc;d struct o *Pointer;
 char *String;o
 int Value;   .if n .sp 2n .ne 6e0 CDBox(Pointer, Layer, Length, Width, X, Y)	cd.c	 struct o *Pointer; int *Length, *Width; int *Layer;" int *X, *Y;e   .if n .sp 2r .ne 6"5 CDCall(Pointer, SymbolName, NumX, DX, NumY, DY)	cd.c	w struct o *Pointer; char *SymbolName; 
 int NumX, DX;y
 int NumY, DY;p   .if n .sp 2e .ne 3e CDCheckPath(Path)	cd.c	n struct p *Path;b   .if n .sp 2  .ne 3e CDClose(SymbolDesc)	cd.c	  struct s *SymbolDesc;f   .if n .sp 2  .ne 3  CDDebug(Debug)	cd.c	
 int Debug;   .if n .sp 2  .ne 4p% CDDelete(SymbolDesc, ObjectDesc)	cd.h  struct s *SymbolDesc;" struct o *ObjectDesc;e   .if n .sp 2  .ne 4D0 CDDeleteObjectDesc(SymbolDesc, ObjectDesc)	cd.c	 struct s *SymbolDesc;( struct o *ObjectDesc;s   .if n .sp 2P .ne 4P( CDEndMakeCall(SymbolDesc, Pointer)	cd.c	 struct s *SymbolDesc;d struct o *Pointer;   .if n .sp 2  .ne 3  CDError(ID)	cd.c	  int ID;n   .if n .sp 2X .ne 5t= CDFrom(Root, CIFFile, A, B, Layers, NumLayers, Program)	cd.c	E char *Root, *CIFFile, Program; int *Layers, NumLayers;t	 int A, B;    .if n .sp 2  .ne 5i) CDGen(SymbolDesc, GenDesc, Pointer)	cd.c	n struct s *SymbolDesc;K struct g *GenDesc; struct o **Pointer;s   .if n .sp 2d .ne 6t> CDGenCIF(FileDesc, SymbolDesc, SymbolNum, A, B, Program)	cd.c	 struct s *SymbolDesc;t FILE *FileDesc;  int *SymbolNum; 
 char Program;e	 int A, B;t   .if n .sp 2i .ne 5 ' CDInfo(SymbolDesc, Pointer, Info)	cd.c	  struct s *SymbolDesc;A struct o *Pointer;
 int *Info;   .if n .sp 2s .ne 3n CDInit()	cd.c	   .if n .sp 2c .ne 5 E CDInitGen(SymbolDesc, Layer, Left, Bottom, Right, Top, GenDesc)	cd.c	X struct s *SymbolDesc;, struct g **GenDesc;n$ int Layer, Left, Bottom, Right, Top;   .if n .sp 2; .ne 4* CDInitTGen(Pointer, TGen)	cd.c	C struct o *Pointer; struct t **TGen;   .if n .sp 2l .ne 4k0 CDInsertObjectDesc(SymbolDesc, ObjectDesc)	cd.c	 struct s *SymbolDesc;a struct o *ObjectDesc;R   .if n .sp 2  .ne 4sG CDIntersect(Left, Bottom, Right, Top, BeginX, EndX, BeginY, EndY)	cd.c	d int Left, Bottom, Right, Top;e# int *BeginX, *EndX, *BeginY, *EndY;m   .if n .sp 2r .ne 6 * CDLabel(Pointer, Layer, Label, X, Y)	cd.c	 struct o *Pointer; char *Label; int *Layer;i int *X, *Y;    .if n .sp 2  .ne 5 @ CDMakeBox(SymbolDesc, Layer, Length, Width, X, Y, Pointer)	cd.c	 struct s *SymbolDesc;y struct o **Pointer;* int Layer, Length, Width, X, Y;    .if n .sp 2  .ne 6 : CDMakeLabel(SymbolDesc, Layer, Label, X, Y, Pointer)	cd.c	 struct s *SymbolDesc;* struct o **Pointer;o char *Label;
 int Layer;	 int X, Y;;   .if n .sp 2n .ne 6e5 CDMakePolygon(SymbolDesc, Layer, Path, Pointer)	cd.c	u struct s *SymbolDesc;n struct p *Path;  struct o **Pointer;e
 int Layer;   .if n .sp 2D .ne 5i? CDMakeRoundFlash(SymbolDesc, Layer, Width, X, Y, Pointer)	cd.c	  struct s *SymbolDesc;  struct o **Pointer;  int Layer, Width, X, Y;    .if n .sp 2( .ne 6d9 CDMakeWire(SymbolDesc, Layer, Width, Path, Pointer)	cd.c	b struct s *SymbolDesc;s struct p *Path;  struct o **Pointer;  int Layer, Width;	   .if n .sp 2  .ne 5s, CDOpen(SymbolName, SymbolDesc, Access)	cd.c	 struct s **SymbolDesc; char *SymbolName;b char Access;   .if n .sp 2n .ne 4D( CDParseCIF(Root, CIFFile, Program)	cd.c	 char *Root, *CIFFile;e
 char Program;e   .if n .sp 2t .ne 4c. CDPatchInstances(SymbolDesc, MasterName)	cd.c	 struct s *SymbolDesc;  char *MasterName;o   .if n .sp 2r .ne 3i CDPath(Path)	cd.c	 char *Path;a   .if n .sp 2r .ne 5 % CDPolygon(Pointer, Layer, Path)	cd.c	m struct o *Pointer; struct p *Path;  int *Layer;i   .if n .sp 2  .ne 5 / CDProperty(SymbolDesc, Pointer, Property)	cd.c	  struct s *SymbolDesc;X struct o *Pointer; struct prpty **Property;   .if n .sp 2X .ne 3X CDReflect(SymbolDesc)	cd.c	X struct s *SymbolDesc;r   .if n .sp 2s .ne 5p2 CDRemoveProperty(SymbolDesc, Pointer, Value)	cd.c	 struct s *SymbolDesc;X struct o *Pointer;
 int Value;   .if n .sp 2  .ne 46/ CDRoundFlash(Pointer, Layer, Width, X, Y)	cd.c	  struct o *Pointer; int *Layer, *Width, *X, *Y;X   .if n .sp 2d .ne 5 * CDSetInfo(SymbolDesc, Pointer, Info)	cd.c	 struct s *SymbolDesc;u struct o *Pointer;	 int Info;g   .if n .sp 2N .ne 4B) CDSetLayer(Layer, Technology, Mask)	cd.c	  int  Layer;  char Technology, *Mask;h   .if n .sp 2i .ne 4r& CDSymbol(SymbolName, SymbolDesc)	cd.c	 struct s *SymbolDesc;i char *SymbolName;    .if n .sp 2n .ne 5C CDT(Pointer, Type, X, Y)	cd.c	 struct o *Pointer;
 char Type;	 int X, Y;o   .if n .sp 2t .ne 5n CDTGen(TGen, Type, X, Y)	cd.c	 struct t **TGen; char *Type;  int *X, *Y;    .if n .sp 2l .ne 5o( CDTo(CIFFile, Root, A, B, Program)	cd.c	 char *CIFFile, *Root; 
 char Program; 	 int A, B;n   .if n .sp 2t .ne 4C CDType(Pointer, Type)	cd.c	, struct o *Pointer; char *Type;b   .if n .sp 2t .ne 3e CDUnmark(SymbolDesc)	cd.c	 struct s *SymbolDesc;b   .if n .sp 2) .ne 4 & CDUpdate(SymbolDesc, SymbolFile)	cd.c	 struct s *SymbolDesc;  char *SymbolFile;c   .if n .sp 2  .ne 5s) CDWire(Pointer, Layer, Width, Path)	cd.c	a struct o *Pointer; struct p *Path;r int *Layer, *Width;g   .if n .sp 2r .ne 3a Catch(sig)	kic.c	  int sig;   .if n .sp 2D .ne 3b CatchLyra(sig)	lyra.c	 int sig;   .if n .sp 2l .ne 3  CatchSIGINT(sig)	kic.c	  int sig;   .if n .sp 2n .ne 3D CenterFullView()	basic.c	L   .if n .sp 2  .ne 3t" ChangeLayer(LookedAhead)	change.c	 int *LookedAhead;    .if n .sp 2d .ne 3Y ClipToGridPoint(X, Y)	coords.c	e int *X, *Y;s   .if n .sp 2, .ne 3P Copy(LookedAhead)	copy.c	y int *LookedAhead;p   .if n .sp 2t .ne 3i CopyPathWithXForm(Path)	copy.c	  struct p **Path;   .if n .sp 2m .ne 4o CtrlAt(Menu, X, Y)	point.c	s char **Menu;	 int X, Y;b   .if n .sp 2A .ne 3  Debug()	debug.c	   .if n .sp 2F .ne 3C DefaultWindows()	init.c	   .if n .sp 2i .ne 3h Del(LookedAhead)	delete.c	 int *LookedAhead;s   .if n .sp 2s .ne 3e Desel()	select.c	t   .if n .sp 2  .ne 3* Dimen(LookedAhead)	attri.c	  int *LookedAhead;)   .if n .sp 2a .ne 3  DotKIC()	dotkic.c	   .if n .sp 2n .ne 3y  Doughnut(LookedAhead)	polygns.c	 int *LookedAhead;    .if n .sp 2  .ne 3 & Edit(Ready, Center, Modified)	basic.c	 int Ready, Center, Modified;   .if n .sp 2c .ne 3u ElapsedRealTime()	measure.c	   .if n .sp 2i .ne 3  ElapsedSystemTime()	measure.c	   .if n .sp 2t .ne 3b ElapsedUserTime()	measure.c	   .if n .sp 2p .ne 3m EraseBox(BB, Window)	boxes.c	  struct ka BB, Window;    .if n .sp 2e .ne 4 ( EraseLabel(Layer, Label, X, Y)	labels.c	 char *Label; int Layer, X, Y;   .if n .sp 2o .ne 3e# EraseMagnifyingGlass()	viewports.c	i   .if n .sp 2  .ne 3e ErasePrompt()	viewports.c	   .if n .sp 2u .ne 3y Expand()	basic.c	o   .if n .sp 2  .ne 3  FBBegin(Display)	fb.c	 char *Display;   .if n .sp 2a .ne 4c) FBBlink(ColorId,Red,Green,Blue,Flag)	fb.c  int ColorId, Flag; int Red,Green,Blue;m   .if n .sp 2c .ne 4tM FBBox(ColorId, DisplayOrErase, Type, StyleId, Left, Bottom, Right, Top)	fb.c	T char Type, DisplayOrErase;/ int StyleId, ColorId, Left, Bottom, Right, Top;    .if n .sp 2T .ne 4p* FBDefineFillPattern(StyleId,BitArray)	fb.c int StyleId; int *BitArray;   .if n .sp 2o .ne 3e FBDrawLineTo(X2,Y2)	fb.c int X2,Y2; F   .if n .sp 2h .ne 3r
 FBEnd() 	fb.cn   .if n .sp 2t .ne 3C FBFlood()	fb.c   .if n .sp 2  .ne 4o+ FBForeground(DisplayOrErase, ColorId)	fb.c	  char DisplayOrErase; int ColorId;   .if n .sp 2c .ne 3i
 FBHalt()	fb.c    .if n .sp 2m .ne 3, FBInitialize()   .if n .sp 2y .ne 3c FBKeyboard(TypeIn)	fb.c	 char **TypeIn;   .if n .sp 2i .ne 3a FBLine(X1,Y1,X2,Y2)	fb.c int X1,Y1,X2,Y2;     .if n .sp 2r .ne 4L+ FBMore(Left,Bottom,Right,Top,Textfile)	fb.c( int Left,Bottom,Right,Top; FILE *Textfile;b   .if n .sp 2) .ne 3	 FBMoveTo(X1,Y1)	fb.c int X1,Y1;     .if n .sp 2; .ne 4t FBPoint(X,Y,Key,Buttons)	fb.c  int *X,*Y,*Buttons;D
 char *Key;   .if n .sp 2  .ne 6r4 FBPolygon(ColorId, Type, StyleId, xy, ncoords)	fb.c	 int *xy; int ColorId, StyleId, ncoords;
 char Type;   .if n .sp 2  .ne 5o( FBPolygonClip(xy, ncoords, window)	fb.c	 int *xy;
 int *ncoords;o struct ka window;f   .if n .sp 2  .ne 3  FBSetCursorColor(colorId)	fb.c	c int colorId;   .if n .sp 2c .ne 3, FBSetFillPattern(StyleId)	fb.c int StyleId;   .if n .sp 2e .ne 5t+ FBText(Mode, RowOrX, ColumnOrY, Text)	fb.c	R char *Text; 
 char Mode; int RowOrX, ColumnOrY;   .if n .sp 2c .ne 3u FBTransfer()	fb.cu   .if n .sp 2  .ne 3s FBVLT(ColorId, R, G, B)	fb.c	c int ColorId, R, G, B;)   .if n .sp 2s .ne 3l Fille(LookedAhead)	attri.c	R int *LookedAhead;n   .if n .sp 2c .ne 4   FinePosition(X, Y, Key)	point.c		 int X, Y;Y	 char Key;n   .if n .sp 2  .ne 3T Flash(LookedAhead)	polygns.c	n int *LookedAhead;    .if n .sp 2  .ne 3( Flatten() 	flatten.c	X   .if n .sp 2u .ne 3o  FlattenCell(CellDesc)	flatten.c	 struct s *CellDesc;    .if n .sp 2  .ne 3e FullRedisplay()	point.c	   .if n .sp 2Y .ne 4e( GenBeginCall(FileDesc, Number)	gencif.c	 FILE *FileDesc;  int Number;,   .if n .sp 2  .ne 4 3 GenBeginSymbol(FileDesc, SymbolNum, A, B)	gencif.c	  FILE *FileDesc;. int SymbolNum, A, B;   .if n .sp 2* .ne 5r; GenBox(FileDesc, Length, Width, X, Y, XDir, YDir)	gencif.c	  FILE *FileDesc;( int Length, Width; int X, Y, XDir, YDir;t   .if n .sp 2e .ne 4t$ GenComment(FileDesc, Text)	gencif.c	 FILE *FileDesc;  char *Text;    .if n .sp 2u .ne 3) GenEnd(FileDesc)	gencif.c	 FILE *FileDesc;e   .if n .sp 2c .ne 3	 GenEndCall(FileDesc)	gencif.c	 FILE *FileDesc;p   .if n .sp 2Y .ne 3s  GenEndSymbol(FileDesc)	gencif.c	 FILE *FileDesc;o   .if n .sp 2c .ne 5 . GenLayer(FileDesc, Technology, Mask)	gencif.c	 FILE *FileDesc;o char *Mask;t char Technology;   .if n .sp 2o .ne 3t GenMirrorX(FileDesc)	gencif.c	 FILE *FileDesc;    .if n .sp 2  .ne 3  GenMirrorY(FileDesc)	gencif.c	 FILE *FileDesc;    .if n .sp 2e .ne 4D$ GenPolygon(FileDesc, Path)	gencif.c	 FILE *FileDesc;n struct p *Path;    .if n .sp 2i .ne 4t% GenRotation(FileDesc, X, Y)	gencif.c	t FILE *FileDesc; 	 int X, Y;    .if n .sp 2T .ne 4f( GenTranslation(FileDesc, X, Y)	gencif.c	 FILE *FileDesc;X	 int X, Y;    .if n .sp 2; .ne 5i1 GenUserExtension(FileDesc, Digit, Text)	gencif.c	x FILE *FileDesc;  char *Text;i char Digit;E   .if n .sp 2  .ne 5s( GenWire(FileDesc, Width, Path)	gencif.c	 FILE *FileDesc;s struct p *Path;o
 int Width;   .if n .sp 2  .ne 3* GetCurrentTransform()	copy.c	    .if n .sp 2r .ne 4y! GetKeyWord(file, inbuf)	dotkic.c	o FILE *file;n char *inbuf;   .if n .sp 2  .ne 3; GetMoveTransform()	move.c	   .if n .sp 2y .ne 4( InBox(X, Y, AOI)	boxes.c	  struct ka AOI;	 int X, Y;t   .if n .sp 2f .ne 4 $ InPath(Delta, Path, X, Y)	polygns.c	 struct p *Path;  int X, Y, Delta;   .if n .sp 2  .ne 3l Init()	init.c	   .if n .sp 2l .ne 3 % InitCoarseWindow(X, Y, Width)	init.c	r int X, Y, Width;   .if n .sp 2* .ne 3  InitFineWindow(X, Y)	init.c		 int X, Y;    .if n .sp 2u .ne 3n InitParameters()	init.c	   .if n .sp 2L .ne 3I InitSignals()	kic.c	   .if n .sp 2, .ne 3  InitVLT()	init.c	l   .if n .sp 2h .ne 3t InitViewport()	init.c	   .if n .sp 2  .ne 3 " Instances(LookedAhead)	instance.c	 int *LookedAhead;K   .if n .sp 2s .ne 3n" IsManhattan(X1, Y1, X2, Y2)	45s.c	 int X1, Y1, X2, Y2;    .if n .sp 2  .ne 3  KIC()	viewports.c	   .if n .sp 2  .ne 5 # LRCLayer(CellDesc,AOI,Layer)	lyra.c  struct s *CellDesc;  struct ka AOI;
 int Layer;   .if n .sp 2n .ne 5 & LToP(Viewport, Window, X, Y)	coords.h	 struct ka Viewport;	 struct ka Window;  int *X, *Y;    .if n .sp 2  .ne 3  Label(LookedAhead)	labels.c	 int *LookedAhead;c   .if n .sp 2e .ne 3n LastView()	zoom.c	   .if n .sp 2  .ne 3  Lyra(LookedAhead)	lyra.c	d int *LookedAhead;r   .if n .sp 2I .ne 3e" MakeLayerInvisible(Layer)	attri.c	
 int Layer;   .if n .sp 2  .ne 3   MakeLayerVisible(Layer)	attri.c	
 int Layer;   .if n .sp 2h .ne 3t MallocFailed()	kic.c	    .if n .sp 2D .ne 3n$ MenuDeselect(Selection)	viewports.c	 char *Selection;   .if n .sp 2g .ne 3	" MenuSelect(Selection)	viewports.c	 char *Selection;   .if n .sp 2n .ne 3  Move(LookedAhead)	move.c	s int *LookedAhead;y   .if n .sp 2c .ne 4, MovePath(TX, TY, Path)	move.c	 struct p **Path; int TX, TY;g   .if n .sp 2  .ne 3  NextCellName()	kic.c   .if n .sp 2I .ne 3e NotPointingAtLayout()	point.c	   .if n .sp 2D .ne 4nQ OutlineText(Left, Bottom, Right, Top, Type, DisplayOrErase, ColorId)	viewports.c	d& int Left, Bottom, Right, Top, ColorId; char Type, DisplayOrErase;   .if n .sp 2s .ne 4n OversizeBox(BB, Delta)	boxes.c	  struct ka *BB;
 int Delta;   .if n .sp 2  .ne 3C PBox()	parser.c	   .if n .sp 2  .ne 5g4 PCIF(CIFFileName, StatusString, StatusInt)	parser.c	 char *CIFFileName; char **StatusString; int *StatusInt;    .if n .sp 2e .ne 3f PCall()	parser.c	c   .if n .sp 2e .ne 3m= PCharacter(Returned, WhiteSpaceControl, EOFControl)	parser.h	s, int Returned, WhiteSpaceControl, EOFControl;   .if n .sp 2  .ne 3  PComment()	parser.c	   .if n .sp 2b .ne 5 , PConvertTilde(psource, pdest, size)	paths.c	 char **psource;y
 char **pdest;)
 int *size;   .if n .sp 2n .ne 3, PDeleteSymbol()	parser.c	    .if n .sp 2y .ne 3s PEnd()	parser.c	   .if n .sp 2  .ne 3  PError(PErrorMessage)	parser.c	  char *PErrorMessage;   .if n .sp 2  .ne 3  PErrorCD()	parser.c	   .if n .sp 2	 .ne 3* PErrorEOF()	parser.c	a   .if n .sp 2n .ne 3I PErrorNoSemicolon()	parser.c	n   .if n .sp 2; .ne 4e* PErrorUndefinedLayer(Tech, Mask)	parser.c	 char *Mask;s
 char Tech;   .if n .sp 2  .ne 3o PGetPath()	paths.c	c   .if n .sp 2D .ne 3r( PInteger(Returned, EOFControl)	parser.h	 int Returned, EOFControl;    .if n .sp 2e .ne 3l PLayer()	parser.c	   .if n .sp 2  .ne 3;6 PLookAhead(Returned, WhiteSpaceControl, For)	parser.h	% int Returned, WhiteSpaceControl, For;h   .if n .sp 2( .ne 3n  PLookForSemi(Returned)	parser.h	
 int Returned;e   .if n .sp 2  .ne 7 * POpen(file, mode, ext, prealname)	paths.c	 char *file;e char *mode;p char *ext;	i char **prealname;    .if n .sp 2e .ne 3, PPath(Path)	parser.c	i struct p *Path;Y   .if n .sp 2  .ne 3  PPoint(X, Y)	parser.c		 int X, Y;g   .if n .sp 2* .ne 3c PPolygon()	parser.c	   .if n .sp 2i .ne 3e PPrimitiveCommand()	parser.c	t   .if n .sp 2I .ne 3e PRoundFlash()	parser.c	r   .if n .sp 2  .ne 3  PSetPath(string)	paths.c	 
 char *string;n   .if n .sp 2i .ne 3s PSymbol()	parser.c	    .if n .sp 2t .ne 5c& PToL(Viewport, Window, X, Y)	coords.c	 struct ka Viewport;i struct ka Window;h int *X, *Y;;   .if n .sp 2g .ne 3	 PUserExtension()	parser.c	   .if n .sp 2* .ne 3o> PWhiteSpace(Returned, WhiteSpaceControl, EOFControl)	parser.h	, int Returned, WhiteSpaceControl, EOFControl;   .if n .sp 2v .ne 3t, PWhiteSpace1(Returned, EOFControl)	parser.h	 int Returned, EOFControl;c   .if n .sp 2I .ne 3e, PWhiteSpace2(Returned, EOFControl)	parser.h	 int Returned, EOFControl;t   .if n .sp 2, .ne 3y, PWhiteSpace3(Returned, EOFControl)	parser.h	 int Returned, EOFControl;    .if n .sp 2T .ne 3s PWire()	parser.c	    .if n .sp 2n .ne 3i Pan(LookedAhead)	zoom.c	 int *LookedAhead;n   .if n .sp 2  .ne 3  Peek()	basic.c	p   .if n .sp 2  .ne 6 @ PeekLayer(CellDesc, AOI, Layer, BottomVisibleLayer)	redisplay.c	 struct s *CellDesc;r struct ka AOI;
 int Layer; int BottomVisibleLayer;n   .if n .sp 2a .ne 3c Point()	point.c	   .if n .sp 2t .ne 3r PointLayerTable()	viewports.c	   .if n .sp 2  .ne 3u Point_At_LAYER()	select.c	   .if n .sp 2  .ne 3   Polygons(LookedAhead)	polygns.c	 int *LookedAhead;    .if n .sp 2( .ne 3, Pop()	contexts.c	.   .if n .sp 2r .ne 3h PrintLRC(file)	lyra.c	 FILE *file;    .if n .sp 2l .ne 3o Properties(LookedAhead)	prpty.cn int *LookedAhead;.   .if n .sp 2  .ne 3  Push()	contexts.c	   .if n .sp 2  .ne 4*% Redisplay(CellDesc, AOI)	redisplay.c	  struct s *CellDesc;  struct ka AOI;   .if n .sp 2O .ne 3s& RedisplayAfterInterrupt()	redisplay.c	   .if n .sp 2s .ne 6 E RedisplayLayer(CellDesc, AOI, Layer, BottomVisibleLayer)	redisplay.c	r struct s *CellDesc;  struct ka AOI;
 int Layer; int BottomVisibleLayer;    .if n .sp 2  .ne 3r$ RemoveLastPointInPath(Path)	wires.c	 struct p **Path;   .if n .sp 2s .ne 3n! RemoveLayer(LookedAhead)	attri.c	s int *LookedAhead;A   .if n .sp 2W .ne 3c RemoveProperty()   .if n .sp 2u .ne 3h. RemovePropertyList(Pointer, PrptyDesc)	prpty.c struct o *Pointer; struct prpty **PrptyDesc;e   .if n .sp 2  .ne 3 / RestorePropertyList(Pointer, PrptyDesc)	prpty.cr struct o *Pointer; struct prpty *PrptyDesc;   .if n .sp 2i .ne 3  Save()	basic.c	(   .if n .sp 2i .ne 3t SaveDotKIC()	kic.c	s   .if n .sp 2P .ne 3  SaveLastView()	zoom.c	   .if n .sp 2* .ne 3c SaveViewOnStack()	zoom.c	i   .if n .sp 2  .ne 3i Sel(LookedAhead)	select.c	 int *LookedAhead;    .if n .sp 2( .ne 3r SelectQClear()	select.c	   .if n .sp 2r .ne 3t SelectQComputeBB()	select.c	   .if n .sp 2s .ne 3t  SelectQDelete(Pointer)	select.c	 struct o *Pointer;   .if n .sp 2	 .ne 3  SelectQFirst(Pointer)	select.c	o struct o *Pointer;   .if n .sp 2i .ne 3h SelectQInit()	select.c	    .if n .sp 2v .ne 3o  SelectQInsert(Pointer)	select.c	 struct o *Pointer;   .if n .sp 2u .ne 3O SelectQShow(AOI)	select.c	 struct ka AOI;   .if n .sp 2  .ne 3o Selection(AOI)	select.c	 struct ka AOI;   .if n .sp 2  .ne 3 ! SelectionInstances(AOI)	select.c	  struct ka AOI;   .if n .sp 2W .ne 4n$ SelectionLayer(AOI, Layer)	select.c	 struct ka AOI;
 int Layer;   .if n .sp 2n .ne 3 ! Selections(LookedAhead)	select.c	e int *LookedAhead;i   .if n .sp 2  .ne 3t SetDebounceTime()	point.c	   .if n .sp 2n .ne 3	' SetGridParameters(LookedAhead)	attri.c	w int *LookedAhead;i   .if n .sp 2  .ne 3t' SetMenuParameters(LookedAhead)	attri.c	e int *LookedAhead;s   .if n .sp 2s .ne 3a ShowAttributeMenu()	attri.c	   .if n .sp 2  .ne 3 " ShowAxes(Viewport, Window)	grid.c	 struct ka Viewport, Window;L   .if n .sp 2O .ne 3) ShowBasicMenu()	basic.c	   .if n .sp 2  .ne 5n# ShowBox(Layer, BB, Window)	boxes.c	P
 int Layer; struct ka BB, Window;    .if n .sp 2o .ne 3t ShowCommandMenu() 	viewports.c	    .if n .sp 2n .ne 3a ShowDebugMenu() 	debug.c	    .if n .sp 2d .ne 3i ShowFineViewport()	viewports.c	o   .if n .sp 2s .ne 3n' ShowGrid(Viewport, Window, AOI)	grid.c	o  struct ka Viewport, Window, AOI;   .if n .sp 2s .ne 3y ShowInstanceMenu()	instance.c	   .if n .sp 2  .ne 6a- ShowLabel(Layer, Label, X, Y, Flag)	labels.c	  char *Label;
 int Layer;	 int X, Y;,	 int Flag;    .if n .sp 2t .ne 3  ShowLayerTable()	viewports.c	    .if n .sp 2  .ne 3s ShowLayout()	viewports.c	n   .if n .sp 2  .ne 6s0 ShowLine(Layer, X1, Y1, X2, Y2, Window)	lines.c	
 int Layer; int X1, Y1, X2, Y2;e struct ka Window;o   .if n .sp 2o .ne 6i9 ShowManhattanLine(Layer, X1, Y1, X2, Y2, Window)	lines.c	e
 int Layer; int X1, Y1, X2, Y2;  struct ka Window;    .if n .sp 22 .ne 4e$ ShowMenu(Menu, NumMenu)	viewports.c	 char **Menu; int NumMenu;   .if n .sp 2t .ne 3e ShowParameters()	viewports.c	t   .if n .sp 2* .ne 6;3 ShowPath(Layer, Path, Window, Terminate)	polygns.c	a struct p *Path;  struct ka Window;t
 int Layer; int Terminate;   .if n .sp 2  .ne 5e+ ShowPolygon(Layer, Path, Window)	polygns.c	a struct p *Path;o struct ka Window; 
 int Layer;   .if n .sp 2) .ne 3. ShowPrompt(Prompt)	viewports.c	s
 char *Prompt;e   .if n .sp 2l .ne 3 & ShowPromptAndWait(Prompt)	viewports.c	
 char *Prompt;    .if n .sp 2n .ne 3e ShowProperties()	prpty.c   .if n .sp 2* .ne 3; ShowPropertyMenu()	prpty.c   .if n .sp 2t .ne 6e< ShowRatio(Name, Value, PerUnitName, PerUnitValue)	measure.c	 char *Name;  char *PerUnitName;
 int Value; int PerUnitValue;l   .if n .sp 2o .ne 3e ShowRGB()	attri.c    .if n .sp 2S .ne 3) ShowSelectionMenu()	select.c	i   .if n .sp 2  .ne 5e- ShowWire(Layer, Width, Path, Window)	wires.c	s struct p *Path;e struct ka Window;	 int Layer, Width;k   .if n .sp 2  .ne 3  ShowXY()	viewports.c	A   .if n .sp 2c .ne 3t StartTiming()	measure.c	   .if n .sp 2  .ne 3  StopTiming()	measure.c	e   .if n .sp 2L .ne 3e! StretchBox(LookedAhead)	modify.c	b int *LookedAhead;	   .if n .sp 2n .ne 3	" StretchPath(LookedAhead)	modify.c	 int *LookedAhead;A   .if n .sp 2  .ne 3 ! SwapInts(Dragon, Eagle)	macros.h	a int Dragon, Eagle;   .if n .sp 2  .ne 3s! SwitchToFinePositioning()	init.c	t   .if n .sp 2  .ne 3  TCurrent(TFP)	xforms.c	,	 int *TFP;i   .if n .sp 2  .ne 3t TEmpty()	xforms.c	   .if n .sp 2  .ne 3i TFull()	xforms.c	    .if n .sp 2n .ne 3h TIdentity()	xforms.c	)   .if n .sp 2  .ne 3  TInit()	xforms.c	w   .if n .sp 2  .ne 3  TInverse()	xforms.c	   .if n .sp 2  .ne 3  TInversePoint(X, Y)	xforms.c	  int *X, *Y;    .if n .sp 2n .ne 3h TMX()	xforms.c	v   .if n .sp 2  .ne 3s TMY()	xforms.c	w   .if n .sp 2W .ne 3A TPoint(X, Y)	xforms.c	 int *X, *Y;d   .if n .sp 2  .ne 3s TPop()	xforms.c	   .if n .sp 2a .ne 3  TPremultiply()	xforms.c	   .if n .sp 2L .ne 3, TPush()	xforms.c	    .if n .sp 2  .ne 3e) TRotate(XDirection, YDirection)	xforms.c	  int XDirection, YDirection;p   .if n .sp 2  .ne 3  TTranslate(X, Y)	xforms.c		 int X, Y;    .if n .sp 2n .ne 3h To45(x1, y1, x2, y2)	45s.c	  int x1, y1, *x2, *y2;a   .if n .sp 21 .ne 32 Trap(n)	kic.c	 int n;   .if n .sp 2  .ne 3  TypeCoordinate()	point.c	,   .if n .sp 2n .ne 3n UseLRC(cp)	lyra.c		 char *cp;    .if n .sp 2t .ne 3d UseRules(rules)	lyra.c	  char *rules;   .if n .sp 2i .ne 3. Visib(LookedAhead)	attri.c	  int *LookedAhead;p   .if n .sp 2E .ne 4o WhereAmI(X, Y, Key)	point.c		 int X, Y; 	 char Key;    .if n .sp 2r .ne 3s Width(LookedAhead)	wires.c	i int *LookedAhead;z   .if n .sp 2o .ne 3d Windo(LookedAhead)	zoom.c	 int *LookedAhead;    .if n .sp 2n .ne 3e Wires(LookedAhead)	wires.c	  int *LookedAhead;	   .if n .sp 2t .ne 3* WriteCell()	contexts.c	;   .if n .sp 2n .ne 3m Zoom(LookedAhead)	zoom.c	  int *LookedAhead;	   .if n .sp 2  .ne 3t abs(Dragon)	macros.h	l int Dragon;.   .if n .sp 2  .ne 3  free(ptr)	nmalloc.h	
 char *ptr;   .if n .sp 2n .ne 3o index(s, c)	paths.c	 char *s, c;    .if n .sp 2  .ne 4  main(argc, argv)	kic.c	 int argc; 
 char *argv[];    .if n .sp 2C .ne 3l max(Dragon, Eagle)	macros.h	 int Dragon, Eagle;   .if n .sp 2e .ne 3t min(Dragon, Eagle)	macros.h	 int Dragon, Eagle;   .fic .wh .8i	 .vsi .rss .DT  .pn -(\n%u-1u)	 .de h2 \"  'sp|.5is .tl '''B.%'u 'sp|1.0i .ns  .. .wh 0 h2 .bp 	 .XS B.1 0O. \fBAppendix B:  The CD Programmers's Manual\fR .XEi .DS C  .sp .3i  .ps +4 .B "Appendix B", .ps  .DE, .sp 1V .DS Ca .ps +4  .B "The CD Programmers's Manual" .pst .DEO .sp 2  .PP;I The Section 3 UNIX manual pages for the CD database package are containeda in this appendix.t .pn -(\n%u-1u)	 .de h3 \"  'sp|.5ie .tl '''C.%'k 'sp|1.0i .nsc .. .wh 0 h3 .bpd	 .XS C.1 0 0 \fBAppendix C:  The KIC Tutorial User's Guide\fR .XEh .DS Ce .sp .3ii .ps +4 .B "Appendix C"p .ps  .DEt .sp 1n .DS Ct .ps +4" .B "The KIC Tutorial User's Guide" .pss .DE  .sp 2  .PPaB The KIC tutorial user's guide is contained in this appendix.  ThisD user's guide is appropriate for KIC running under both UNIX and VMS. .pn -(\n%u-1u)	 .de h4 \"t 'sp|.5i  .tl '''D.%'  'sp|1.0i .ns( .. .wh 0 h4 .bp)	 .XS D.1 0a/ \fBAppendix D:  The MFB Programmers's Manual\fR; .XEi .DS C  .sp .3i. .ps +4 .B "Appendix D"p .psc .DEh .sp 1m .DS C  .ps +4! .B "The MFB Programmers's Manual"m .psi .DEt .sp 2h .PPrK The Section 3 UNIX manual pages for the Model Frame Buffer graphics packageD are contained in this appendix.  .pn -(\n%u-1u)	 .de h5 \"p 'sp|.5i  .tl '''E.%'  'sp|1.0i .ns  .. .wh 0 h5 .bp,	 .XS E.1 0 1 \fBAppendix E:  The MFBCAP Programmer's Manual\fR  .XE1 .DS C* .sp .3ii .ps +4 .B "Appendix E"n .ps. .DEn .sp 1  .DS Cs .ps +4# .B "The MFBCAP Programmer's Manual"i .pss .DE  .sp 2  .PPCI The Section 5 UNIX manual pages for the MFBCAP graphics terminal database $ file are contained in this appendix. .pn -(\n%u-1u)	 .de h6 \"  'sp|.5io .tl '''F.%'  'sp|1.0i .nsn .. .wh 0 h6 .bp,	 .XS F.1 0./ \fBAppendix F:  KIC and Related Manual Pages\fRs .XEt .DS Cd .sp .3ir .ps +4 .B "Appendix F"z .psi .DEs .sp 1n .DS Ci .ps +4! .B "KIC and Related Manual Pages"  .psi .DEs .sp 2n .PP D The Section 1 UNIX manual pages for KIC and all related programs are contained in this appendix.  .pn -(\n%u-1u)	 .de h7 \"m 'sp|.5ie .tl '''R.%'  'sp|1.0i .nsd .. .wh 0 h7 .bp 	 .XS R.1 0( .B "References"l .XE  .DS C. .sp .3i  .ps +4 .B "References"	 .pso .DE  .sp 3t
 .IP "[1]" .5i  .ne 4  K. H. Keller and A. R Newton,*G .I "KIC2: A Low-Cost Interactive Editor for Integrated Circuit Design,"*( Digest of Papers, IEEE Compcon 82 Conf.,= San Fransisco, California, February 22-25, 1982, pp. 302-304.t .sp 2r
 .IP "[2]" .5ic .ne 4 
 K. H. Keller,l4 .I "KIC, A Graphics Editor for Integrated Circuits,"J Masters Report, Department of Electrical Engineering and Computer Science,3 University of California, Berkeley, Ca., June 1981.\ .sp 2i
 .IP "[3]" .5i3 .ne 4 " B. W. Kernighan and D. M. Ritchie,  .I "The C Programming Language,"2 Prentice-Hall, Englewood Cliffs, New Jersey, 1978. .sp 2 
 .IP "[4]" .5ia .ne 4  C. A. Mead and L. Conway, " .I "Introduction to VLSI Systems,"% Addison-Wesley, Reading, Mass., 1980.' .sp 2 
 .IP "[5]" .5i  .ne 4  R. Hon ad C. Sequin,# .I "A Guide to LSI Implementation,"e+ Xerox PARC Technical Report SSL-79-7, 1980.  .sp 2e
 .IP "[6]" .5i  .ne 4s W. M. Newman and R. F. Sproull, 1 .I "Principles of Interactive Computer Graphics,"h McGraw-Hill, New York, 1977. .sp 2n
 .IP "[7]" .5in .ne 4h J. D. Foley and A. Van Dam,t3 .I "Fundamentals of Interactive Computer Graphics,"u% Addison-Wesley, Reading, Mass., 1982.  .sp 2.
 .IP "[8]" .5iw .ne 4 " M. H. Arnold and J. K. Ousterhout,< .I "LYRA: A New Approach to Geometric Layout Rule Checking,"* Proc. 19th ACM IEE Design Automation Conf.0 Las Vegas, Nevada, June 14-16, 1982, pp.530-536. .sp 2t
 .IP "[9]" .5i  .ne 4t .I "Programming in VAX-11C,"M Digital Equipment Corporation, P.O. Box CS2008, Nashua, New Hampshire.  03061s .sp 2n .IP "[10]" .5i .ne 4aG KIC2 under VAX/VMS is also distributed by the Engineering Systems Groupm> of Digital Equipment Corp., 2 Iron Way, Marlboro, Mass.  01752 .sp 2t .IP "[11]" .5i .ne 7 C STREAM is a proprietary description format for graphic data that isiM licensed by Calma, Inc.  The conversion programs between KIC and Calma STREAM J were developed at Tektronix, Inc., and the Electronics Research LaboratoryL with the permission of Calma and may be released by the Electronics Research/ Laboratory only to licensed customers of Calma.L .nr h9 0u +1 .af h9 i@ .de h8 \"header to acknowledgement section and table of contents 'sp|.5i. .tl '''\\n+(h9'e 'sp|1.0i .nss .. .wh 0 h8 .bpn .DS Co .ps +4 .sp .3ih .B "Acknowledgements"  .ps  .DE  .sp 3  .PPwG I would like to thank all those who have contributed to the developmentfE of the KIC editor.  The history of KIC and all related programs spans J several years, and appropriately there are many persons to be acknowledged  for their kind help and support. .PP(C The invaluable advice and encouragement of Professor Richard NewtonsG is greatly appreciated.  Professor Newton has guided the development ofnL the KIC editor from the time that the project was begun by Kenneth H. KellerI in the Fall of 1980, and he has provided excellent opportunities for boths? the KIC program and myself.  The opportunities for me include a.A Research Assistantship funded in part by Tektronix Inc., NationalaE Semiconductor Corp., and Digital Equipment Corp., the opportunity to 5A develop the KIC editor with an excellent user community includingX? Berkeley graduate students in the Integrated Circuits Group and1B designers from National Semiconductor, Evans and Sutherland Corp.,I CSIRO Australia, and Tektronix, and the opportunity to be part of perhapsCJ the world's most prestigious university CAD effort in integrated circuits. .PPeM The support and professional experiences provided by Professor D. O. Pedersonp> are also greatly appreciated.  Professor Pederson, along with I Dr. Stewart Taylor of Tektronix, convinced me to enter the graduate studyvD program at Berkeley and has continually helped to make my studies at# Berkeley productive and beneficial.d .PPJD I am very grateful to those persons who have provided assistance andJ software during the development of the KIC program.  These persons includeJ Kenneth H. Keller who initially designed and wrote KIC and the CD databaseL package, Peter P. Moore who developed the nmalloc memory management package,J Chris Wilson of CSIRO who wrote the initial version of geometry stretchingH procedures, Peter Harris of Jupiter Systems Inc. for firmware support onG the AED 512, Professor J. K. Ousterhout who provided the UNIX directoryM: search path procedures, and Professor Carlo Sequin for his= early interest in the KIC program and his helpful suggestionsCG for the user interface.  Also, Mark Bales implemented the first versions of the MFB graphics package. .PPi6 I also gratefully acknowledge the helpful support from" the early industrial users of KIC.C Dr. J. Craig Mudge and Chris Wilson of the VLSI design group at theoE Division of Computing Research, CSIRO, Australia, provided both ideass9 and software for the geometry stretching commands in KIC. @ J. Halverson and R. Haslan of Evans and Sutherland have provided: help for the development and improvement of KIC under VMS.E S. Sriram, F. Taku, and S. Carcia of the Engineering Systems Group ofeF Digital Equipment Corp. and A. Hanover of the Methodology and AdvancedI Development Group of Digital Equipment Corp. have also given considerablegH support to the development of KIC on VMS.  Jim Solomon and Joe Santos ofH the Speech Design Group of National Semiconductor, where I worked on KICO as a summer employee during the Summer of 1982, were the first major industrialeF users of KIC in the Santa Clara area, and I am very grateful for theirM kind support.  The work of Ed Gould, who helped to improve the user interfaceIO of the CIF conversion programs and who wrote a new .KIC parser, is appreciated. 3 Tektronix has been generously supportive of my workoE by providing graphics and computing equipment, financial support, andt? the opportunity to share ideas with their excellent CAD effort;tG in particular, I would like to acknowledge the assistance and advice of H Dr. E. Cohen, J. Crawford, and S. Potter of the Tektronix MCE CAD group. .PPtE I would also like to thank Dr. I. Getreu of Tektronix for his support 5 and encouragement throughout the course of this work.  .PP K The most important acknowledgements, the personal ones, are saved for last. L To my parents in Oregon, Virgil and Rosemary, I am deeply thankful for theirN their constant, loving support and infinite patience during my graduate years.H And to my Uncle Jess and Aunt Betty Billingsley I am especially gratefulD for their understanding and for making certain that this over-workedE Berkeley graduate student enjoyed at least one good, home-cooked meal  every month! .PPe> Finally, to the friends that I have found at Berkeley who haveE given me helpful criticism and assistance throughout the course of myeF research project.  I thankfully acknowledge the generous assistance of
 Clem Cole,
 Mark Hofmann,u Ken Keller,8
 Jim Kleckner,t
 Grace Mah, Peter Moore, Tom Quarles, and Rick Spickelmier.a .bp  .PXr