 /*  * kictostrm.c  **  * Copyright -C- 1981 Giles C. Billingsley  * sccsid "%W%  %G%"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programn;  * KIC is available free of charge to any interested party. B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,B  * is forbidden.  */M    #define Allocate   #include <math.h>  #include <time.h>  #include "kic.h" #include "stream.h"b   /*K  * We use the property list of KIC symbols to save the library information; F  * The value of the property is the numeric value of the STREAM recordJ  * type offset by 7000 (e.g. 7000 is the KIC property value describing theG  * STREAM version number, 7002 is the KIC property value describing thesK  * STREAM library name, etc.)  The offset of 7000 was arbitrarily selected,mG  * and care must be taken so that this value does not conflict with anyoC  * other convention.  The PROPERTYOFFSET define is for convenience.i  *F  * The STREAM-specific property list is attributed to every KIC symbolB  * by 'strmtokic', and 'kictostrm' will look for this information.  */  #define	PROPERTYOFFSET	7000p   #define RADTODEG	57.29577951? #define LONGSCALE(s,x)	(long) (floor( (s * (double)(x)) + 0.5))e> #define INTSCALE(s,x)	(int)  (floor( (s * (double)(x)) + 0.5))   int CDStatusInt;  int LayerNumbers[CDNUMLAYERS+1];# int DataTypeNumbers[CDNUMLAYERS+1];  char *CDStatusString;   E int SelectiveSearch;	/* If set, only those symbols that exist in the	 3 			   current working directory will be placed intom) 			   the output stream library file		 */    STRM_LIBRARY		STRMLibrary; STRM_STRCT		STRMStructure; STRM_BOUNDARY		STRMBoundary; STRM_PATH		STRMPath; STRM_TEXT		STRMText; STRM_SREF		STRMSref; STRM_AREF		STRMAref;! STRM_TRANSFORM		DefaultTransform;  STRM_PROPERTY		DefaultProperty;   	 int	argc;  char	**argv; char	*nextarg();   main(ac, av)     char *av[];i     {s     double Float1;     double Float2;     FILE *fopen();     FILE *ltable;m     struct s *SymbolDesc;t      struct tm Now, *localtime();     struct prpty *PrptyDesc;     char *cp,*mktemp();f     long tloc;     long time();     int i,j,k,l,n;     int Layer;     int Layers[CDNUMLAYERS];     int detail = 0;      int symbolic = 0;l     int all = 0;     int micperl = 0;     int DBUpermic = 0;     int inset = 0;     int SymbolNum = 0;     int UseStreamNames = 0;      int UseLayerTable;     char Root[81];     char Selection;_     char StreamFile[81];     char buffer[80];     char LayerFile[80];l       /* initialize */     UseLayerTable = False;     SelectiveSearch = False;     tloc = time((long *)NULL);     Now = *localtime(&tloc);#     STRMLibrary.lib_name[0] = NULL;r#     STRMLibrary.lib_lib1[0] = NULL;o$     STRMLibrary.lib_lib2[44] = NULL;$     STRMLibrary.lib_font0[0] = NULL;$     STRMLibrary.lib_font1[0] = NULL;$     STRMLibrary.lib_font2[0] = NULL;$     STRMLibrary.lib_font3[0] = NULL;#     STRMLibrary.lib_attr[0] = NULL;l%     STRMLibrary.lib_accessdate = Now;l"     STRMLibrary.lib_moddate = Now;      STRMLibrary.lib_uunit = .01;!     STRMLibrary.lib_munit = 1e-8;U     STRMLibrary.lib_gen = 3;$     STRMStructure.str_moddate = Now;&     STRMStructure.str_creatdate = Now;)     DefaultTransform.trns_reflection = 0; &     DefaultTransform.trns_abs_mag = 0;(     DefaultTransform.trns_abs_angle = 0;$     DefaultTransform.trns_mag = 1.0;&     DefaultTransform.trns_angle = 0.0;%     DefaultProperty.prp_npropval = 0;n       argc = ac;     argv = av;     Float1 = 1.0;      StreamFile[0] = NULL;r     Root[0] = NULL;   *     while(argc > 1 && argv[1][0] == '-') { 	switch(argv[1][1]) {a  
 	case 'l': 	    micperl++;.& 	    sscanf(nextarg(), "%f", &Float1); 	    break;o  
 	case 'z':)             /* extract STREAM filename */ 3             strcpy(STRMLibrary.lib_name,nextarg());i 	    break;e 	o
 	case 'm': 	    ++DBUpermic;e& 	    sscanf(nextarg(), "%f", &Float2); 	    break;  	o
 	case 'o':# 	    strcpy(StreamFile, nextarg());e 	    break;p 	r
 	case 'i':
 	    inset++;s 	    strcpy(Root, nextarg());l 	    break;   
 	case 's': 	    symbolic++; 	    break;t 	n
 	case 'd': 	    detail++; 	    break;,  
 	case 'a': 	    all++;  	    break;t  
 	case 'c': 	    SelectiveSearch++;M 	    break;e  
 	case 'x':" 	    strcpy(LayerFile, nextarg()); 	    UseLayerTable = 1;	 	    break;r 	 
 	case 'n': 	    UseStreamNames = 1; 	    break;a 	a	 	default: H 	    fprintf(stderr, "kictostrm: Unknown flag '%s' ignored\n", argv[1]); 	    break;I 	    } 	argc--; 	argv++; 	}  '     if(STRMLibrary.lib_name[0] == NULL) - 	sprintf(STRMLibrary.lib_name,"KICTOSTREAM");e     if(micperl == 0) {  	printf("Microns per lambda? "); 	scanf("%f", &Float1); 	}     if(inset == 0) {# 	printf("Hierarchy's root cell? ");c 	scanf("%s", Root);  	}     if(StreamFile[0] == NULL) {p 	cp = Root;  	i = 0;e# 	while(*cp != '.' And *cp != NULL){n 	    StreamFile[i] = *cp; 	 	    ++i;r
 	    ++cp; 	    } 	StreamFile[i] = NULL; 	strcat(StreamFile, ".str"); 	}     if(DBUpermic){+         STRMLibrary.lib_uunit = 1.0/Float2; =         STRMLibrary.lib_munit = 1e-6 * STRMLibrary.lib_uunit; ' 	Float1 *= (.01/STRMLibrary.lib_uunit);l 	}   /*G    * Initializes CD package and reads in .KIC file so we know the layer -    * names.  Can't generate CIF without them. 0    * DotKIC also generates a file named cifplot.@    * It is a cifplot pattern file that describes the .KIC file.     */i
     DotKIC();[)     for(k = 0; k < CDNUMLAYERS + 1; ++k){U 	LayerNumbers[k] = k;i 	DataTypeNumbers[k] = 0; 	}     if(UseLayerTable){- 	if((ltable = fopen(LayerFile,"r")) == NULL){i7 	    fprintf(stderr,"Can't open stream layer file.\n"); 
 	    exit(1);. 	    }         fscanf(ltable,"%d",&n);_         for(i = 0; i < n; ++i){s9 	    buffer[0] = buffer[1] = buffer[2] = buffer[3] = ' ';a4 	    if(fscanf(ltable,"%s %d %d",buffer,&j,&k) < 3){. 		fprintf(stderr,"Bad stream layer table.\n");
 		exit(1); 		}  	    for(l = 0; l < 4; ++l){ 		if(buffer[l] < ' ')  		    buffer[l] = ' '; 		} ' 	    for(l = 1; l <= CDNUMLAYERS; ++l){L, 		if(buffer[0] == CDLayer[l].lTechnology And* 		    buffer[1] == CDLayer[l].lMask[0] And* 		    buffer[2] == CDLayer[l].lMask[1] And( 		    buffer[3] == CDLayer[l].lMask[2]){ 		    LayerNumbers[l] = j; 		    DataTypeNumbers[l] = k;* 		    }  		}  	    }         fclose(ltable);r 	}     else if(UseStreamNames){         buffer[5] = NULL;  	for(k=0; k<CDNUMLAYERS; ++k){( 	    buffer[0] = CDLayer[k].lTechnology;% 	    buffer[1] = CDLayer[k].lMask[0];k             buffer[2] = ' ';% 	    buffer[3] = CDLayer[k].lMask[1]; % 	    buffer[4] = CDLayer[k].lMask[2];+I 	    if(sscanf(buffer,"%d %d",&LayerNumbers[k],&DataTypeNumbers[k]) < 2){:8 		fprintf(stderr,"Trouble reading Stream layer %c%s.\n",/ 		    CDLayer[k].lTechnology,CDLayer[k].lMask);* 		}C 	    } 	}  2     if(detail == 0 && symbolic == 0 && all == 0) {5 	printf("Select layers you wish to be visible - \n");u# 	printf("\t\"s\" symbolic only\n");c# 	printf("\t\"d\" detailed only\n");   	printf("\t\"a\" all layers\n");
 	printf("?");  	loop {l 	    scanf("%c", &Selection);l 	    switch(Selection) {   	    case 's':
 		symbolic++;d 		break;   	    case 'd': 		detail++;e 		break;   	    case 'a': 		break;  
 	    default:u 		continue;  		}I 	    break;l 	    } 	}  1     for(Layer = 1;Layer <= NumLayerTable;++Layer)7 	Layers[Layer-1] = True;       if(detail) {. 	for(Layer = 1;Layer <= NumLayerTable;++Layer)% 	    if(LayerTable[Layer].klSymbolic)R 		Layers[Layer-1] = False; 	}     else if(symbolic) {A. 	for(Layer = 1;Layer <= NumLayerTable;++Layer)) 	    if(Not LayerTable[Layer].klSymbolic)r 		Layers[Layer-1] = False; 	}  0     for(Layer = 0;Layer < NumLayerTable;++Layer) 	if(Layers[Layer])# 	    CDLayer[Layer].lCDFrom = True;  	elseo$ 	    CDLayer[Layer].lCDFrom = False;  O     if((STREAMFILE=POpen(StreamFile,"w",(char *)NULL,(char **)NULL)) == NULL){	C+ 	fprintf(stderr,"Can't open STREAM file.");R	 	exit(1);r 	})     if(Not CDOpen(Root,&SymbolDesc,'r')){f+ 	fprintf(stderr,"Can't open Root cell.\n"); A 	fprintf(stderr,"Parse failed at around:  %s.\n",CDStatusString);p	 	exit(1);i 	}  0     /* add STREAM-specific property list info */7     CDProperty(SymbolDesc,(struct o *)NULL,&PrptyDesc);T     while(PrptyDesc != NULL){e- 	i = PrptyDesc->prpty_Value - PROPERTYOFFSET;p 	if(i == HEADER){g 	    /* version 3 is assumed */  	    } 	else if(i == LIBNAME){U? 	    sscanf(PrptyDesc->prpty_String,"%s",STRMLibrary.lib_name);d 	    } 	else if(i == REFLIBS){'A 	    sscanf(PrptyDesc->prpty_String,"%s %s",STRMLibrary.lib_lib1,} 		STRMLibrary.lib_lib2); 	    } 	else if(i == FONTS){R2 	    sscanf(PrptyDesc->prpty_String,"%s %s %s %s",. 		STRMLibrary.lib_font0,STRMLibrary.lib_font1,/ 		STRMLibrary.lib_font2,STRMLibrary.lib_font3);s 	    } 	else if(i == GENERATIONS){k? 	    sscanf(PrptyDesc->prpty_String,"%d",&STRMLibrary.lib_gen);e 	    } 	else if(i == ATTRTABLE){r? 	    sscanf(PrptyDesc->prpty_String,"%s",STRMLibrary.lib_attr);L 	    }# 	PrptyDesc = PrptyDesc->prpty_Succ;r 	}       bgnlib(&STRMLibrary);r     SymbolNum = 1;9     if(Not GenStream(Root,SymbolDesc,&SymbolNum,Float1)){.2 	fprintf(stderr,"Unable to write stream file.\n");7 	fprintf(stderr,"Status string: %s.\n",CDStatusString);u	 	exit(1);  	}
     endlib();n     fclose(STREAMFILE);h2     printf("Translation of %s succeeded.\n",Root);     }i   char * nextarg() {      if(argv[1][2] != NULL) 	return(&argv[1][2]);b     argv++;n     argc--;(     return(argv[1]);     }   	 UseLRC(c)d     char *c;     {      }t   UseRules(c)l     char *c;     {?     }l      0 GenStream(MasterName,SymbolDesc,SymbolNum,Scale)     char *MasterName;s     struct s *SymbolDesc;;     int *SymbolNum;	     double Scale;;     {      struct g *GenDesc;     struct o *Pointer;     struct s *MasterDesc;      struct p *Pair,*Path;      struct t *TGen;b     struct prpty *PrptyDesc;     char *SymbolName;i     char *Label;     double a,b;y     unsigned int size;     int Layer,X,Y,Length,Width;      int NumX,DX,NumY,DY;
     int Info;i     int i,j;     int Left,Bottom,Right,Top;     char Type;     char garbage[120];       *SymbolNum += 1; a     /*B      * Mark symbol associated withSymbolDesc as visited by storing&      * its symbol # in its info field.      */o6     CDSetInfo(SymbolDesc,(struct o *)NULL,*SymbolNum);       /*B      * First write to the stream file any symbol definitions below-      * the symbol associated with SymbolDesc..      */iN     if(Not CDInitGen(SymbolDesc,0,(int)-INFINITY,(int)-INFINITY,(int)INFINITY,: 	(int)INFINITY,&GenDesc)) return(CDError(CDMALLOCFAILED));
     loop {$ 	CDGen(SymbolDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;i1 	CDCall(Pointer,&SymbolName,&NumX,&DX,&NumY,&DY);U, 	if(Not CDOpen(SymbolName,&MasterDesc,'w')){> 	    fprintf(stderr,"Unable to open symbol %s.\n",SymbolName);; 	    fprintf(stderr,"Status string: %s.\n",CDStatusString);=
 	    exit(1);  	    }+ 	CDInfo(MasterDesc,(struct o *)NULL,&Info);b 	if(Info == 0){ 4 	    /* Write master's definition to stream file. */> 	    if(Not GenStream(SymbolName,MasterDesc,SymbolNum,Scale)){3 		fprintf(stderr,"Unable to write stream file.\n");s8 		fprintf(stderr,"Status string: %s.\n",CDStatusString);
 		exit(1); 		}t 	    } 	}     /*F      * If the SelectiveSearch integer is set, only those symbols whichH      * exist in the current directory will be placed in the stream file.      */*     if(SelectiveSearch){ 	if(access(MasterName,0) != 0){ B 	    fprintf(stderr,"Symbol %s not found in current directory.\n", 		MasterName); 	    return(True); 	    } 	}       /*L      * Write to the stream file the definition of the symbol associated with:      * SymbolDesc.  Instance calls first--then geometries.      */*.     strcpy(STRMStructure.str_name,MasterName);     bgnstr(&STRMStructure);mN     if(Not CDInitGen(SymbolDesc,0,(int)-INFINITY,(int)-INFINITY,(int)INFINITY,: 	(int)INFINITY,&GenDesc)) return(CDError(CDMALLOCFAILED));
     loop {$ 	CDGen(SymbolDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;L1 	CDCall(Pointer,&SymbolName,&NumX,&DX,&NumY,&DY); + 	if(Not CDOpen(SymbolName,&MasterDesc,'w'))a 	    return(False);)D 	if(Not CDBB(MasterDesc,(struct o *)NULL,&Left,&Bottom,&Right,&Top)) 	    return(False); % 	strcpy(STRMSref.sr_name,SymbolName);(* 	STRMSref.sr_transform = DefaultTransform; 	/* copy the property list */'+ 	CDProperty(SymbolDesc,Pointer,&PrptyDesc);, 	while(PrptyDesc != NULL){. 	    if(STRMSref.sr_prop.prp_npropval >= 255){8 		fprintf(stderr,"Too many properties for symbol %s.\n", 		    SymbolName);& 		STRMSref.sr_prop.prp_npropval = 255; 		}+6 	    /* allow only valid STREAM property attributes */  	    i = PrptyDesc->prpty_Value; 	    if(i > 0 && i < 128){E 	        STRMSref.sr_prop.prp_propattr[STRMSref.sr_prop.prp_npropval]i
 		    = i;4 	        size = strlen(PrptyDesc->prpty_String) + 2;D 	        STRMSref.sr_prop.prp_propval[STRMSref.sr_prop.prp_npropval] 		    = malloc(size);ce 	        strcpy(STRMSref.sr_prop.prp_propval[STRMSref.sr_prop.prp_npropval],PrptyDesc->prpty_String); ) 	        ++STRMSref.sr_prop.prp_npropval;l 		} ' 	    PrptyDesc = PrptyDesc->prpty_Succ;& 	    } 	for(i = 1;i <= NumY;++i){ 	    for(j = 1;j <= NumX;++j){ 		Width = Right - Left;a 		Length = Top - Bottom; 		CDInitTGen(Pointer,&TGen); 		loop {  		    CDTGen(&TGen,&Type,&X,&Y); 		    if(TGen == NULL){b	 			break;  			} 		    elif(Type == CDROTATE){\ 			a = (double) X; 			b = (double) Y;' 			STRMSref.sr_transform.trns_angle += , 			    (RADTODEG * atan2(b,a));/
 			if(X == 0)s 			    SwapInts(Width,Length); 			}  		    elif(Type == CDTRANSLATE){ 			STRMSref.sr_xy[0]/ 			    = LONGSCALE(Scale,(X+(j-1)*(Width+DX)));n 			STRMSref.sr_xy[1]2 			    = LONGSCALE(Scale,(Y + (i-1)*(Length+DY))); 			} 		    elif(Type == CDMIRRORX){. 			STRMSref.sr_transform.trns_reflection ^= 1;- 			STRMSref.sr_transform.trns_angle += 180.0;t 			} 		    elif(Type == CDMIRRORY).. 			STRMSref.sr_transform.trns_reflection ^= 1; 		    }m 		sref(&STRMSref); 		}f 	    }& 	/* free storage of property values */4 	for(i = 0; i < STRMSref.sr_prop.prp_npropval; ++i){+ 	    free(STRMSref.sr_prop.prp_propval[i]);h 	    }# 	STRMSref.sr_prop.prp_npropval = 0;  	}0     for(Layer = 1;Layer <= CDNUMLAYERS;++Layer){A 	if(Not CDInitGen(SymbolDesc,Layer,(int)-INFINITY,(int)-INFINITY,g+ 	    (int)INFINITY,(int)INFINITY,&GenDesc))S% 	    return(CDError(CDMALLOCFAILED));T 	loop {F( 	    CDGen(SymbolDesc,GenDesc,&Pointer); 	    if(Pointer == NULL) 		break;! 	    /* copy the property list */r/ 	    CDProperty(SymbolDesc,Pointer,&PrptyDesc);o 	    while(PrptyDesc != NULL){* 		if(DefaultProperty.prp_npropval >= 255){A 		    fprintf(stderr,"Too many properties for layer %d\n",Layer); ) 		    DefaultProperty.prp_npropval = 255;t 		    }) 		i = PrptyDesc->prpty_Value;m3 		/* allow only valid STREAM property attributes */; 		if(i > 0 && i < 128){i@ 		    DefaultProperty.prp_propattr[DefaultProperty.prp_npropval] 			= i;U8 	            size = strlen(PrptyDesc->prpty_String) + 2;? 		    DefaultProperty.prp_propval[DefaultProperty.prp_npropval]l 		        = malloc(size);pg 	            strcpy(DefaultProperty.prp_propval[DefaultProperty.prp_npropval],PrptyDesc->prpty_String);t, 	            ++DefaultProperty.prp_npropval; 		    }.+ 	        PrptyDesc = PrptyDesc->prpty_Succ;o
 	        } 	    CDType(Pointer,&Type);n 	    if(Type == CDBOX){ - 		CDBox(Pointer,&Layer,&Length,&Width,&X,&Y);M 		Length /= 2;
 		Width /= 2;  		X = INTSCALE(Scale,X); 		Y = INTSCALE(Scale,Y);" 		Length = INTSCALE(Scale,Length);  		Width = INTSCALE(Scale,Width);/ 		STRMBoundary.bnd_layer = LayerNumbers[Layer]; 5 		STRMBoundary.bnd_datatype = DataTypeNumbers[Layer];r* 		STRMBoundary.bnd_prop = DefaultProperty; 		STRMBoundary.bnd_ncoord = 5;. 		STRMBoundary.bnd_xy[0] = (long)(X + Length);- 		STRMBoundary.bnd_xy[1] = (long)(Y + Width);). 		STRMBoundary.bnd_xy[2] = (long)(X + Length);- 		STRMBoundary.bnd_xy[3] = (long)(Y - Width);a. 		STRMBoundary.bnd_xy[4] = (long)(X - Length);- 		STRMBoundary.bnd_xy[5] = (long)(Y - Width); . 		STRMBoundary.bnd_xy[6] = (long)(X - Length);- 		STRMBoundary.bnd_xy[7] = (long)(Y + Width); . 		STRMBoundary.bnd_xy[8] = (long)(X + Length);- 		STRMBoundary.bnd_xy[9] = (long)(Y + Width);y 		bndry(&STRMBoundary);o 		}	 	    elif(Type == CDWIRE){& 		CDWire(Pointer,&Layer,&Width,&Path);+ 		STRMPath.pth_layer = LayerNumbers[Layer];u1 		STRMPath.pth_datatype = DataTypeNumbers[Layer];t. 		STRMPath.pth_width = LONGSCALE(Scale,Width);& 		STRMPath.pth_prop = DefaultProperty; 		STRMPath.pth_pathtype = 2;B 		/* look at the property list for a STREAM pathtype definition */3 	        CDProperty(SymbolDesc,Pointer,&PrptyDesc);;" 	        while(PrptyDesc != NULL){2 		    i = PrptyDesc->prpty_Value - PROPERTYOFFSET; 		    if(i == PATHTYPE){6 			sscanf(PrptyDesc->prpty_String,"%s %d",garbage,&i); 			if(i >= 0 && i < 3)( 		            STRMPath.pth_pathtype = i;	 			break;  			}( 		    PrptyDesc = PrptyDesc->prpty_Succ; 	            } 		Pair = Path; 		i = 0; 		if(Path->pSucc == NULL){7 		    STRMPath.pth_xy[i++] = LONGSCALE(Scale,Pair->pX);)7 		    STRMPath.pth_xy[i++] = LONGSCALE(Scale,Pair->pY);n7 		    STRMPath.pth_xy[i++] = LONGSCALE(Scale,Pair->pX);,7 		    STRMPath.pth_xy[i++] = LONGSCALE(Scale,Pair->pY);C 		    }n 		else { 		    while(Pair != NULL){4 			STRMPath.pth_xy[i++] = LONGSCALE(Scale,Pair->pX);4 			STRMPath.pth_xy[i++] = LONGSCALE(Scale,Pair->pY); 			Pair = Pair->pSucc; 			} 		    }T1 	        if(STRMPath.pth_pathtype == 0 && i > 3){R? 		    convert_pathtype(&STRMPath.pth_xy[0],&STRMPath.pth_xy[1],)0 		        STRMPath.pth_xy[2],STRMPath.pth_xy[3], 			STRMPath.pth_width);=- 		    convert_pathtype(&STRMPath.pth_xy[i-1],L. 			&STRMPath.pth_xy[i-2],STRMPath.pth_xy[i-3],, 			STRMPath.pth_xy[i-4],STRMPath.pth_width); 		    }t 		STRMPath.pth_ncoord = i/2; 		path(&STRMPath); 		}  	    elif(Type == CDPOLYGON){p 		i = 0;" 		CDPolygon(Pointer,&Layer,&Path);/ 		STRMBoundary.bnd_layer = LayerNumbers[Layer]; 5 		STRMBoundary.bnd_datatype = DataTypeNumbers[Layer];E* 		STRMBoundary.bnd_prop = DefaultProperty; 		Pair = Path; 		while(Pair != NULL){; 		    STRMBoundary.bnd_xy[i++] = LONGSCALE(Scale,Pair->pX);y; 		    STRMBoundary.bnd_xy[i++] = LONGSCALE(Scale,Pair->pY);p 		    Pair = Pair->pSucc;T 		    }y 		if(i < 8){ 		    /* close the triangle */8 		    STRMBoundary.bnd_xy[i++] = STRMBoundary.bnd_xy[0];8 		    STRMBoundary.bnd_xy[i++] = STRMBoundary.bnd_xy[1]; 		    }n  		STRMBoundary.bnd_ncoord = i/2; 		bndry(&STRMBoundary);[ 		}( 	    elif(Type == CDLABEL){n' 		CDLabel(Pointer,&Layer,&Label,&X,&Y);T+ 		STRMText.txt_layer = LayerNumbers[Layer];	1 		STRMText.txt_texttype = DataTypeNumbers[Layer];M 		STRMText.txt_pathtype = 1; 		STRMText.txt_horizontal = 0; 		STRMText.txt_vertical = 0; 		STRMText.txt_font = 0; 		STRMText.txt_width = 0;E* 		STRMText.txt_xy[0] = LONGSCALE(Scale,X);* 		STRMText.txt_xy[1] = LONGSCALE(Scale,Y);& 		STRMText.txt_prop = DefaultProperty;, 		STRMText.txt_transform = DefaultTransform;" 		strcpy(STRMText.txt_text,Label);> 		/* look at the property list for a STREAM text definition */3 	        CDProperty(SymbolDesc,Pointer,&PrptyDesc); " 	        while(PrptyDesc != NULL){ 		    long int wdth;# 		    int present,ptype,reflection;  		    double magn,rotn;e2 		    i = PrptyDesc->prpty_Value - PROPERTYOFFSET; 		    if(i == TEXT){" 			sscanf(PrptyDesc->prpty_String,0 			    "%s %ld %s %d %s %d %s %lf %s %lf %s %d",5 			    garbage,&wdth,garbage,&present,garbage,&ptype,p8 			    garbage,&magn,garbage,&rotn,garbage,&reflection);( 		        STRMText.txt_pathtype = ptype;7 		        STRMText.txt_horizontal = (present >> 8) & 3;h6 		        STRMText.txt_vertical = (present >> 10) & 3;2 		        STRMText.txt_font = (present >> 12) & 3;$ 		        STRMText.txt_width = wdth;> 		        STRMText.txt_transform.trns_reflection = reflection;1 		        STRMText.txt_transform.trns_mag = magn;S3 		        STRMText.txt_transform.trns_angle = rotn;P	 			break;> 			}( 		    PrptyDesc = PrptyDesc->prpty_Succ; 	            } 		text(&STRMText); 		}_* 	    /* free storage of property values */7 	    for(i = 0; i < DefaultProperty.prp_npropval; ++i){ . 	        free(DefaultProperty.prp_propval[i]);
 	        }& 	    DefaultProperty.prp_npropval = 0; 	    } 	}
     endstr();R     return(True);T     }p  # convert_pathtype(xe,ye,xb,yb,width)o.     long *xe,*ye;	/* coordinate of endpoint */C     long xb,yb;		/* coordinate of previous or next point in path */0!     long width;		/* path width */R     {      double angle;s     double deltaX,deltaY;      double sin(),cos(),atan2();f       if(width == 0) 	return;     else if(width < 0) 	width = -width;     width /= 2;p     if(*xe == xb){
 	if(*ye > yb)r 	    *ye += width; 	else} 	    *ye -= width; 	}     else if(*ye == yb){o
 	if(*xe > xb)e 	    *xe += width; 	else  	    *xe -= width; 	}	     else{( 	deltaX = (double)(*xe - xb);  	deltaY = (double)(*ye - yb);Y 	angle = atan2(deltaY,deltaX);' 	deltaX = (double)(width) * cos(angle);n' 	deltaY = (double)(width) * sin(angle);o 	*xe += (long)(deltaX);  	*ye += (long)(deltaY);  	}     } 