 /*	  * lyra.cy  *=  * Copyright -C- 1981 Kenneth H. Keller, Giles C. Billingsley="  * sccsid "@(#)lyra.c	1.1  9/5/83"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programa;  * KIC is available free of charge to any interested party.eB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */y  m /*  * The KIC/Lyra interface.  */p   #include <signal.h>e #include "kic.h"   #ifdef LYRAs #define TRACE 1, #endif   /* Library routines */ char *strcpy();: #ifndef vmsb char *sprintf(); #endif   char TypeOut[100];    static char *myRulesFile = NULL; static char *LyraFile = NULL;P  static char *lyraVersion = NULL; static char LyraRealName[81];c static char TechRealName[81];  static char MyLyraRules[81];   #ifdef LYRAn static jmp_buf env;  static FILE *fromLyra,*toLyra; static int toLyraPipe[2];t static int fromLyraPipe[2];k static int LRCContextFactor; static int setjmpP = 0;o( static int lyraLabelLayer,lyraRectLayer; static int lyraLayerP; static int pid;m #endif   #ifdef TRACE static FILE *trace;  #endif  	 UseLRC(s)a     char *s;     {W     char *prealname;     FILE *stream;;N     if((stream = POpen("~cad/bin/lyra","r",(char *)NULL,&prealname)) == NULL){ 	LyraFile = NULL;m 	if(FB.fInitialized){o1 	    sprintf(TypeOut,"Can't open ~cad/bin/lyra");s 	    ShowPrompt(TypeOut);o 	    sleep(2); 	    } 	}	     else{L  	strcpy(LyraRealName,prealname); 	LyraFile = LyraRealName;	 	if(FB.fInitialized){;7 	    sprintf(TypeOut,"You will be using %s.",LyraFile);e 	    ShowPrompt(TypeOut);t 	    sleep(2); 	    } 	fclose(stream); 	}:     if(strcmp("nmos",s) == 0 Or strcmp("cmos-pw",s) == 0){ 	strcpy(TechRealName,s); 	lyraVersion = TechRealName; 	}	     else{X 	lyraVersion = NULL; 	if(FB.fInitialized)> 	    ShowPrompt("Sorry, I only know about nmos and cmos-pw."); 	}     }i     UseRules(rules)      char *rules;     {W     char *prealname;     FILE *stream;FD     if((stream = POpen(rules,"r",(char *)NULL,&prealname)) == NULL){ 	myRulesFile = NULL; 	if(FB.fInitialized){ - 	    sprintf(TypeOut,"Can't open %s.",rules);2 	    ShowPrompt(TypeOut);; 	    } 	}	     else{  	strcpy(MyLyraRules,prealname);  	myRulesFile = MyLyraRules;  	if(FB.fInitialized){dB 	    sprintf(TypeOut,"You're rules file will be %s.",myRulesFile); 	    ShowPrompt(TypeOut);r 	    } 	fclose(stream); 	}     }(   PrintLRC(file)     FILE *file;r     {d     if(lyraVersion != NULL){' 	fprintf(file,"LRC %s\n",TechRealName);P 	if(myRulesFile != NULL)/ 	    fprintf(file,"LRCRules %s\n",MyLyraRules);r 	}     }e   #ifdef LYRA= CatchLyra(i)
     int i;     {;
     wait(&i);X     if(i == 0) 	return;     if(setjmpP){
 #ifdef SIGSET, 	sigrelse(SIGCHLD);i #endif 	longjmp(env,1); 	}     }f #endif   Lyra(LookedAhead)E     int *LookedAhead;F     {1 #ifdef LYRA)     struct ka AOI;     struct ka BB1,BB2;     struct o *Pointer;"     int X,Y,Layer,nViolations = 0; #endif       *LookedAhead = False;; #ifdef LYRA  #ifdef TRACE!     trace = fopen("lyra.ca","w");) #endif     MenuSelect(MenuLYRA);2     if(lyraVersion == NULL){/ 	ShowPrompt("I don't know which LYRA to use.");, 	MenuDeselect(MenuLYRA);  	return; 	}H     ShowPrompt("Point to endpoints of diagonal of area to be checked.");.     while(Not Parameters.kpPointCoarseWindow){	 	Point();C$ 	if(Parameters.kpCommand[0] != EOS){ 	    *LookedAhead = True;Y 	    MenuDeselect(MenuLYRA); 	    return; 	    } 	}+     Parameters.kpPointCoarseWindow = False; .     while(Not Parameters.kpPointCoarseWindow){	 	Point();F$ 	if(Parameters.kpCommand[0] != EOS){ 	    *LookedAhead = True;F 	    MenuDeselect(MenuLYRA); 	    return; 	    } 	}     if(pipe(toLyraPipe) == -1){*+ 	ShowPrompt("Can't create pipe to Lyra."); l 	MenuDeselect(MenuLYRA); 	return; 	}!     if(pipe(fromLyraPipe) == -1){ - 	ShowPrompt("Can't create pipe from Lyra."); r 	MenuDeselect(MenuLYRA); 	return; 	}9     if((fromLyra = fdopen(fromLyraPipe[0],"r")) == NULL){ : 	ShowPrompt("Can't create stream for reading from Lyra."); 	MenuDeselect(MenuLYRA); 	return; 	}5     if((toLyra = fdopen(toLyraPipe[1],"w")) == NULL){e8 	ShowPrompt("Can't create stream for writing to Lyra."); 	MenuDeselect(MenuLYRA); 	return; 	} #ifdef TRACE     if(myRulesFile != NULL){6 	sprintf(TypeOut,"Lyra rules file = %s.",myRulesFile); 	ShowPrompt(TypeOut);b
 	sleep(2); 	} #endif     if((pid = vfork()) == 0){s- 	if(dup2(toLyraPipe[0],fileno(stdin)) == -1) m
 	    exit(1);t/ 	if(dup2(fromLyraPipe[1],fileno(stdout)) == -1)N
 	    exit(1);)/ 	if(dup2(fromLyraPipe[1],fileno(stderr)) == -1)i
 	    exit(1);r 	close(fromLyraPipe[0]); 	close(toLyraPipe[1]); 	if(myRulesFile == NULL)6 	    execl(LyraFile,LyraFile,"-e","-t",lyraVersion,0); 	else=G 	    execl(LyraFile,LyraFile,"-e","-t",lyraVersion,"-r",myRulesFile,0);s 	}
 #ifdef SIGSETm     sigset(SIGCHLD,CatchLyra); #elser     signal(SIGCHLD,CatchLyra); #endif     if(setjmp(env) == 1){* 	ShowPrompt("Lyra died."); 	InitSignals();  	MenuDeselect(MenuLYRA); 	return; 	}     setjmpP = 1;     close(fromLyraPipe[1]);L     close(toLyraPipe[0]);r       /* get overlap from lyra */L,     fscanf(fromLyra,"%d",&LRCContextFactor); #ifdef DEBUG=     sprintf(TypeOut,"Context factor = %d.",LRCContextFactor);i     ShowPromptAndWait(TypeOut);  #endif#     LRCContextFactor *= RESOLUTION;LC     AOI.kaLeft = min(Cursor.kcPredX,Cursor.kcX) - LRCContextFactor; E     AOI.kaBottom = min(Cursor.kcPredY,Cursor.kcY) - LRCContextFactor;eD     AOI.kaRight = max(Cursor.kcPredX,Cursor.kcX) + LRCContextFactor;B     AOI.kaTop = max(Cursor.kcPredY,Cursor.kcY) + LRCContextFactor;  /     /*Write rectangles to be checked to Lyra.*/o%     fprintf(toLyra,"<< labels >>\n");( #ifdef TRACE%     fprintf(trace,"<< labels >>\n"); e     fflush(trace); #endif2     fprintf(toLyra,"label window %d %d %d %d 1\n",7 	AOI.kaLeft/HALFRESOLUTION,AOI.kaBottom/HALFRESOLUTION,=6 	AOI.kaRight/HALFRESOLUTION,AOI.kaTop/HALFRESOLUTION); #ifdef TRACE1     fprintf(trace,"label window %d %d %d %d 1\n",i7 	AOI.kaLeft/HALFRESOLUTION,AOI.kaBottom/HALFRESOLUTION,d6 	AOI.kaRight/HALFRESOLUTION,AOI.kaTop/HALFRESOLUTION);     fflush(trace); #endif2     for(Layer = 1;Layer <= NumLayerTable;++Layer){- 	if(LayerTable[Layer].klTechnology == 'L' Andp+ 	    LayerTable[Layer].klMask[0] == 'Y' Andl) 	    LayerTable[Layer].klMask[1] == 'R'){r 	    lyraLayerP = True;o, 	    if(LayerTable[Layer].klMask[2] == 'L'){ 		lyraLabelLayer = Layer;t 		} . 	    elif(LayerTable[Layer].klMask[2] == 'R'){ 		lyraRectLayer = Layer; 		}n 	    } 	elsem 	    lyraLayerP = False;# 	fprintf(toLyra,"<< %c%c%c%c >>\n", $ 	    LayerTable[Layer].klTechnology,! 	    LayerTable[Layer].klMask[0],C! 	    LayerTable[Layer].klMask[1],y" 	    LayerTable[Layer].klMask[2]); #ifdef TRACE" 	fprintf(trace,"<< %c%c%c%c >>\n",$ 	    LayerTable[Layer].klTechnology,! 	    LayerTable[Layer].klMask[0],l! 	    LayerTable[Layer].klMask[1], " 	    LayerTable[Layer].klMask[2]); 	fflush(trace);c #endif! 	Parameters.kpHierarchyLevel = 0;f+ 	LRCLayer(Parameters.kpCellDesc,AOI,Layer);y 	};i #ifdef TRACE!     fprintf(trace,"<< end >>\n");i     fflush(trace); #endif"     fprintf(toLyra,"<< end >>\n");@     fclose(toLyra); /*Close pipe so Lyra senses EOF on stdout.*//     ShowPrompt("Running LRC.    Please wait.");c?     /*In parallel with LRC, redisplay to get rid of old LRVs.*/R     EraseBox(AOI,AOI);)     Redisplay(Parameters.kpCellDesc,AOI);t     FBTransfer();t"     /*Read violations from Lyra.*/	     loop{x 	char s[81]; 	int l,b,r,t,i;0   	fscanf(fromLyra,"%s",s);, 	if(feof(fromLyra)){6 	    fclose(fromLyra); /*Close pipe to gc file desc.*/ 	    break;L 	    }; 	/*If strlen(violation label) > 80, we'll core dump here!*/a 	fscanf(fromLyra,"%s",s); " 	if(strcmp(s,"<<") == 0) continue;# 	if(strcmp(s,"end") == 0) continue;U" 	if(strcmp(s,">>") == 0) continue; 	++nViolations; . 	fscanf(fromLyra,"%d%d%d%d%d",&l,&b,&r,&t,&i); 	l *= HALFRESOLUTION;) 	b *= HALFRESOLUTION;  	r *= HALFRESOLUTION;r 	t *= HALFRESOLUTION;a 	X = (r - l)/2 + l;a 	Y = (t - b)/2 + b;n 	if(lyraLabelLayer != 0){T? 	    if(Not CDMakeLabel(Parameters.kpCellDesc,lyraLabelLayer,s,u  		X,Y,&Pointer)) MallocFailed(); 	    } 	if(lyraRectLayer != 0)nB 	    if(Not CDMakeBox(Parameters.kpCellDesc,lyraRectLayer,r-l,t-b,  		X,Y,&Pointer)) MallocFailed(); 	}     setjmpP = 0;     if(nViolations == 0)* 	ShowPrompt("Lyra didn't find any LRVs.");
     else { 	char s[81];   	Parameters.kpModified = True;> 	RedisplayLayer(Parameters.kpCellDesc,AOI,lyraRectLayer,NULL);? 	RedisplayLayer(Parameters.kpCellDesc,AOI,lyraLabelLayer,NULL);)Q 	sprintf(s,"The %d LRVs that Lyra found are on layers LYRR & LYRL.",nViolations);P 	ShowPrompt(s);t 	}     MenuDeselect(MenuLYRA);= #else &     ShowPrompt("Lyra not available."); #endif     }n     #ifdef LYRAl LRCLayer(CellDesc,AOI,Layer)     struct s *CellDesc;k     struct ka AOI;     int Layer;     {o     struct g *GenDesc;     struct o *Pointer;     struct p *Path;y     struct ka BB;i     struct t *TGen;l     struct s *MasterDesc;t!     struct ka ElementBB,MasterBB;m     char Type;     char *MasterName;L     char *TypeIn;\     char *Label;
     int Info;c     int X,Y,Width;     int NumX,DX,NumY,DY;!     int MasterHeight,MasterWidth;      register int Int1,Int2;[  "     ++Parameters.kpHierarchyLevel;N     if(Not CDInitGen(CellDesc,0,AOI.kaLeft,AOI.kaBottom,AOI.kaRight,AOI.kaTop, 	&GenDesc)) MallocFailed();a  
     loop {" 	CDGen(CellDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;m  	CDInfo(CellDesc,Pointer,&Info); 	if(Info == 2) 	    continue;1 	CDCall(Pointer,&MasterName,&NumX,&DX,&NumY,&DY); 
 	if(TFull()){ 4 	    ShowPrompt("Cell hierarchy is too deep. MORE"); 	    FBKeyboard(&TypeIn); < 	    ShowPrompt("Probably you have a recursive hierarchy.");
 	    TInit(); # 	    --Parameters.kpHierarchyLevel;i 	    return; 	    } 	else { 0 	    if(Not CDOpen(MasterName,&MasterDesc,'r')){4 		sprintf(TypeOut,"Can't LRC %s. MORE",MasterName);  		ShowPrompt(TypeOut); 		FBKeyboard(&TypeIn); 		ShowPrompt(CDStatusString);   		--Parameters.kpHierarchyLevel;	 		return;) 		} & 	    elif(CDStatusInt == CDNEWSYMBOL){5 		sprintf(TypeOut,"Can't find cell %s.",MasterName); i 		ShowPrompt(TypeOut);  		--Parameters.kpHierarchyLevel;	 		return;  		}t 	    }: 	if(Not CDBB(MasterDesc,(struct o *)NULL,&MasterBB.kaLeft,; 	    &MasterBB.kaBottom,&MasterBB.kaRight,&MasterBB.kaTop))( 	    MallocFailed();# 	for(Int1 = NumY;Int1 >= 1;--Int1){N' 	    for(Int2 = 1;Int2 <= NumX;++Int2){O3 		MasterWidth = MasterBB.kaRight - MasterBB.kaLeft;a4 		MasterHeight = MasterBB.kaTop - MasterBB.kaBottom;
 		TPush(); 		TIdentity(); 		CDInitTGen(Pointer,&TGen); 		loop {  		    CDTGen(&TGen,&Type,&X,&Y); 		    if(TGen == NULL)	 			break;i 		    if(Type == CDROTATE){C 			TRotate(X,Y);
 			if(X == 0)	* 			    SwapInts(MasterWidth,MasterHeight); 			} 		    elif(Type == CDTRANSLATE)o* 			TTranslate(X+(Int2-1)*(MasterWidth+DX),% 			    Y+(Int1-1)*(MasterHeight+DY));o 		    elif(Type == CDMIRRORX)(	 			TMX();k 		    elif(Type == CDMIRRORY)L	 			TMY();l 		    }a 		TPremultiply();, 		/*. 		 * Box test instance array element with AOI. 		 */ % 		ElementBB.kaLeft = MasterBB.kaLeft;a) 		ElementBB.kaBottom = MasterBB.kaBottom;e' 		ElementBB.kaRight = MasterBB.kaRight;"# 		ElementBB.kaTop = MasterBB.kaTop; 0 		TPoint(&ElementBB.kaLeft,&ElementBB.kaBottom);. 		TPoint(&ElementBB.kaRight,&ElementBB.kaTop);* 		if(ElementBB.kaRight < ElementBB.kaLeft)3 		    SwapInts(ElementBB.kaLeft,ElementBB.kaRight);(* 		if(ElementBB.kaTop < ElementBB.kaBottom)3 		    SwapInts(ElementBB.kaBottom,ElementBB.kaTop);}, 		if(Not (ElementBB.kaLeft > AOI.kaRight Or ' 		    ElementBB.kaRight < AOI.kaLeft Org' 		    ElementBB.kaBottom > AOI.kaTop OrL' 		    ElementBB.kaTop < AOI.kaBottom)){G& 		    LRCLayer(MasterDesc,AOI,Layer);  		    }o	 		TPop();) 		}  	    } 	}H     if(Not CDInitGen(CellDesc,Layer,AOI.kaLeft,AOI.kaBottom,AOI.kaRight,% 	AOI.kaTop,&GenDesc)) MallocFailed(); 	     loop{t" 	CDGen(CellDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;t  	CDInfo(CellDesc,Pointer,&Info); 	if(Info == 2) 	    continue; 	if(lyraLayerP){  	    CDDelete(CellDesc,Pointer);" 	    Parameters.kpModified = True; 	    continue; s 	    } 	CDType(Pointer,&Type);p 	if(Type == CDWIRE){2 	    CDWire(CellDesc,Pointer,&Layer,&Width,&Path);A 	    ShowPrompt("Your layout has a wire that won't be checked.");  	    continue; 	    } 	elif(Type == CDPOLYGON){N( 	    /*Don't even try to LRC polygons.*/D 	    ShowPrompt("Your layout has a polygon that won't be checked."); 	    continue; 	    } 	elif(Type == CDBOX){kA 	    CDStatusInt = CDBB(CellDesc,Pointer,&BB.kaLeft,&BB.kaBottom,L 		&BB.kaRight,&BB.kaTop);E 	    } 	else{ 	    continue; 	    }! 	TPoint(&BB.kaLeft,&BB.kaBottom);T 	TPoint(&BB.kaRight,&BB.kaTop);a 	if(BB.kaLeft > BB.kaRight) $ 	    SwapInts(BB.kaLeft,BB.kaRight); 	if(BB.kaBottom > BB.kaTop)c$ 	    SwapInts(BB.kaBottom,BB.kaTop);8 	BB.kaLeft = max(BB.kaLeft,AOI.kaLeft-LRCContextFactor);> 	BB.kaBottom = max(BB.kaBottom,AOI.kaBottom-LRCContextFactor);; 	BB.kaRight = min(BB.kaRight,AOI.kaRight+LRCContextFactor);m5 	BB.kaTop = min(BB.kaTop,AOI.kaTop+LRCContextFactor);e #ifdef TRACE$ 	fprintf(trace,"rect %d %d %d %d\n",9 	    BB.kaLeft/HALFRESOLUTION,BB.kaBottom/HALFRESOLUTION,e8 	    BB.kaRight/HALFRESOLUTION,BB.kaTop/HALFRESOLUTION); 	fflush(trace);i #endif% 	fprintf(toLyra,"rect %d %d %d %d\n",T9 	    BB.kaLeft/HALFRESOLUTION,BB.kaBottom/HALFRESOLUTION, 8 	    BB.kaRight/HALFRESOLUTION,BB.kaTop/HALFRESOLUTION); 	}"     --Parameters.kpHierarchyLevel;     }O #endif