 .\	/*% .\	/*	mfb.man: manual for mfb packagee- .\	/*	Copyright -c- 1982 Giles C. Billingsley; .\	/*n .\	/*	sccsid "%W%  %G%"n .\	/*F .tr || .TH MFB 3 6/21/83  .UC 4P .SH NAME# mfb \- model frame buffer interfaceB .SH SYNOPSIS" .B "#include <~cad/include/mfb.h>" in the program source. .br) .B "cc " [ flags ] files  .B " ~cad/lib/mfb.a -lm  "
 [ libraries ]F .sp) .SH DESCRIPTIONF .PPlB These routines provide the user with a virtual graphics interface.G They perform the terminal dependent task of encoding\/decoding graphicsAD code, thereby allowing the user to write graphics programs to run on almost any graphics device.  .PPn? The user opens and initializes a graphics device by calling thei
 .I MFBOpen/ routine that returns a pointer to that device'sv .I MFBI data structure defined at the end of this manual.  By maintaining severale .I MFBB data structures, an application program can drive several graphics& devices simultaneously.  Once opened,  .I MFBH graphics routines can be called to draw geometries, draw graphics text, 1 set device parameters, or receive keyboard input. L An application program can also use any of the several utility routines thatM perform line clipping, polygon clipping, or window\/viewport transformations.	9 Control of the graphics device is released by calling thei .I MFBClose	 routine. .PP: All programs that usea .I MFB routines must include the file .I mfb.h that defines the .I MFB5 data structure to contain the information provided byc
 .I MFBCAP(5).\ .sp  .ne 8  .SH INITIALIZATION ROUTINES  .nfe .PP	6 .B "MFB *MFBOpen(TerminalName, DeviceName, errorcode)"% .B "char *TerminalName, *DeviceName;"  .B "int *errorcode;" .fia .DTe .RS	
 .I MFBOpen- initializes the graphics device and fills the  .I MFB( data structure with information found in
 .I MFBCAP(5).  .I TerminalNameC? is a pointer to a null terminated string containing the name of\% the graphics device as defined in thet	 .I mfbcap C database file.  This argument has no default and can never be null."
 .I DeviceName	F is a pointer to a null terminated string containing the full path name$ to the respective graphics device.   If null, .I stdin and		 .I stdout  are used by default. .I errorcode# is a diagnostic integer returned by	 .I MFBOpen.   The possible returned values for .I errorcode are defined in the .I mfb.h file as follows: .PPg .ne 5  .nf 4 .ta \w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXX'u +\w'XXXXXX'u( #define	MFBOK	 1	/* successful return */1 #define	MFBBADENT	-10	/* Unknown terminal type */o3 #define	MFBBADMCF 	-20	/* Can't open MFBCAP file */42 #define	MFBMCELNG 	-30	/* MFBCAP entry too long */- #define	MFBBADMCE 	-40	/* Bad MFBCAP entry */U: #define	MFBINFMCE 	-50	/* infinite loop in MFBCAP entry *// #define	MFBBADTTY 	-60	/* stdout not in /dev */A7 #define	MFBBADDEV	-180	/* Can't open or close device */	< #define	MFBBADOPT	-190	/* Can't access or set device stat */0 #define	MFBBADWRT 	-220	/* Error during write */ .fio .DTe .PPl  Only MFBOK is not a fatal error. .REX .sp/ .ne 8v .nfo .PP  .B "void SetCurrentMFB(mfb)" .B "MFB *mfb;" .fiv .DTo .RS  .I SetCurrentMFBE allows the application program to define the current graphics device.S All subsequent calls tof .I MFB8 routines will affect the specified device.  Because each .I MFBE data structure contains a separate output buffer, it is not necessarye? to flush the output before resetting the current output device.x
 .I MFBOpenM returns with the opened graphics device defined as the current output device.f .REG .spe .ne 8  .nfr .PPt .B "int MFBInitialize()" .fi( .DTe .RS  .I MFBInitializeN will flush the output buffer and (re)initialize the device for graphics input.+ The graphics device or standard input will B) be placed in CBREAK mode.  See the manualx
 .I tty(4).= MFBOK is returned if the device was successfully initialized;tB MFBBADOPT is returned if an error was encountered while attempting' to access or set the device status, andTF MFBBADTTY is returned if standard output can bot be found or accessed. .RE .sp/ .ne 8a .nfn .PPo .B "int MFBClose()"	 .fii .DTc .RS2 .I MFBCloselG will flush the output buffer and release control of the graphics device1$ driver.  If the graphics device is a .I tty,e@ it is returned to the state that existed prior to the respective
 .I MFBOpen call..8 MFBOK is returned if the device was successfully closed;B MFBBADOPT is returned if an error was encountered while attempting' to access or set the device status, andn? MFBBADDEV is returned if the output device could not be closed.v .REm .sps .ne 12 .nf  .PPl .B "int MFBHalt()" .fin .DTh .RSl
 .I MFBHaltG will flush the output buffer and release control of the graphics device $ driver.  If the graphics device is a .I tty,n@ it is returned to the state that existed prior to the respective
 .I MFBOpen call.o
 .I MFBHalt differs from .I MFBClosea6 in that the memory occupied by the respective, current .I MFB( data structure is not freed.  By calling .I MFBInitialize,/E the graphics device will be reinitialized.  This routine is typically L used by an application program for handling the SIGTSTP signal (the keyboard! stop signal, usually control-Z ). O MFBOK is returned if the device was successfully returned to its initial state; B MFBBADOPT is returned if an error was encountered while attempting# to access or set the device status.	 .REf .spF .ne 10 .SH SETTING DEVICE PARAMETERSi .PPaF Each of the following routines for setting device parameters returns a* diagnostice integer that is defined in the .I mfb.h file as follows: .PPS .ne 10 .nfm4 .ta \w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXX'u +\w'XXXXXX'u( #define	MFBOK	 1	/* successful return *// #define	MFBBADLST 	-70	/* Illegal line style */c/ #define	MFBBADFST 	-80	/* Illegal fill style */i/ #define	MFBBADCST	-90	/* Illegal color style */c5 #define	MFBBADTM1	-100	/* No destructive text mode */ 6 #define	MFBBADTM2	-110	/* No overstriking text mode */3 #define	MFBNOBLNK 	-150	/* No definable blinkers */s/ #define	MFBTMBLNK 	-160	/* Too many blinkers */R< #define	MFBNOMASK	-170	/* No definable read or write mask */0 #define	MFBBADALU	-250	/* Cannot set ALU mode */ .fif .DTd .spi .ne 11 .nf  .PPe! .B "int MFBSetLineStyle(styleId)"d .B "int styleId;"n .fii .DT  .RSa .I MFBSetLineStyle= sets the current line style to that identified by the integera .I styleId y@ that is greater than or equal to zero and less than the value of .I maxLineStyles in the   .I MFB data structure.  The value ofT .I maxLineStyles can be obtained from the
 .I MFBInfo+ routine defined below.  Zero is always the n
 .I styleId2 for solid lines.  Except for the solid line style, .I MFB' assumes no default set of lines styles.dM MFBOK is returned if the line style was successfully set to that specified byt
 .I styleId or ifi
 .I styleId# was already the current line style;s MFBBADLST is returned if
 .I styleId has an illegal value.s .REr .spf .ne 11 .nf  .PPn# .B "int MFBSetFillPattern(styleId)"s .B "int styleId;"s .fin .DTB .RS  .I MFBSetFillPattern? sets the current fill pattern to that identified by the integerl .I styleId e@ that is greater than or equal to zero and less than the value of .I maxFillPatterns in the .I MFB data structure.  The value ofn .I maxFillPatterns can be obtained from the
 .I MFBInfo7 routine defined below.  Solid fill is always defined byt
 .I styleId& equal to zero.  Other than solid fill, .I MFB( assumes no default set of fill patterns.M MFBOK is returned if the fill style was successfully set to that specified bya
 .I styleId or if 
 .I styleId# was already the current fill style;m MFBBADFST is returned if
 .I styleId has an illegal value.n .RE  .spn .ne 11 .nfr .PPi' .B "int MFBSetChannelMask(channelMask)", .B "int channelMask;"i .fi/ .DTo .RSa .I MFBSetChannelMask1 defines the current write mask to be the value ofi .I channelMask.oG The channel mask allows specific memory planes to be written and erasediE without disturbing other memory planes.  The least significant bit ofn .I channelMask? corresponds to the masked value of the first memory plane, etc. F If the corresponding bit is zero, the memory plane is write-protected.4 The number of memory planes can be obtained from the
 .I MFBInfo routine defined below.; MFBOK is returned if the write mask was successfully set tos .I channelMask or ifo .I channelMask. was already the current write mask;  MFBNOMASKH is returned if the graphics device does not have a definable write mask. .REi .spt .ne 8b .nf  .PPa! .B "int MFBSetReadMask(readmask)"u .B "int readmask;" .fi  .DTd .RSR .I MFBSetReadMaskn0 defines the current read mask to be the value of .I readmask.< The read mask allows only specific memory planes to be read.: MFBOK is returned if the read mask was successfully set to .I readMask  or ift .I readMaskd- was already the current read mask;  MFBNOMASKIG is returned if the graphics device does not have a definable read mask.r .REt .spc .ne 10 .nfB .PPa .B "int MFBSetColor(colorId)"l .B "int colorId;"i .fi  .DTr .RSs .I MFBSetColorC sets the current foreground color to that identified by the integero
 .I colorId@ that is greater than or equal to zero and less than the value of .I maxColors in the .I MFB data structure.  The value ofc .I maxColors can be obtained from the
 .I MFBInfo8 routine defined below.  There is no default color map in .I MFB.r) MFBOK is returned if the foreground colore) was successfully set to that specified by 
 .I colorId or ift
 .I colorId) was already the current foreground color;e MFBBADCST is returned if
 .I colorId has an illegal value.d .REh .spe .ne 14 .nfe .PP ( .B "int MFBSetTextMode(destructiveBool)" .B "Bool destructiveBool;" .fil .DTr .RSn .I MFBSetTextModesL defines whether subsequent graphics text will overstrike or replace previous	 text.  Ifn .I destructiveBoolJ is true, the text mode is set to destructive which means that graphic textC will set the background color of the font grid to the color that istD specified by color style zero depending on the currently defined ALUG operation.  Overstriking mode will only set the pixels of the characterD% font to the current foreground color.iC MFBOK is returned if the graphic text writing mode was successfullyM set to that specified by .I destructiveBool or ifo .I destructiveBool= was already the current graphic text writing mode;  MFBBADTM1IK is returned if the graphics device does not have a destructive graphic texta mode, and MFBBADTM2iM is returned if the graphics device does not have an overstriking graphic texto mode.d .REt .sps .ne 9u .nft .PPr .B "int MFBSetALUMode(alumode)"r .B "int alumode;"e .fih .DTo .RSa .I MFBSetALUModeF changes the mode by which the graphics display is changed when an area8 of the display is over-written.  The four possible modes8 are JAM (replace mode), OR, EOR (exclusive OR), and NOR. The four valid arguments tor .I MFBSetALUMode are defined in .I mfb.h as follows:e .PPd .ne 9  .nfa4 .ta \w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXX'u +\w'XXXXXX'u. #define	MFBALUJAM 	0	/* set ALU mode to JAM */+ #define	MFBALUOR	1	/* set ALU mode to OR */n- #define	MFBALUNOR	2	/* set ALU mode to NOR */ - #define	MFBALUEOR	3	/* set ALU mode to EOR */c .fim .DT  .PPsK MFBOK is returned if the ALU mode was successfully set to that specified byr
 .I alumode or ifI
 .I alumode1 was already the current ALU operation;  MFBBADALUrJ is returned if the graphics device does not have the ALU mode specified by
 .I alumode or if 
 .I alumode" is an invalid or illegal argument. .RE; .spf .ne 8r .nfs .PPM. .B "int MFBSetCursorColor(colorId1, colorId2)" .B "int colorId1, colorId2;" .fim .DTh .RSn .I MFBSetCursorColorF sets the graphics cursor to blink between the two colors identified by .I colorId1  ands .I colorId2.! The constraints on the values for  .I colorId1f andr .I colorId2n are the same as forg .I MFBSetColor= defined above.  The frequency of the blinking cursor is fixedP( and can be changed only by modifying the	 .I mfbcaps database file.  MFBOKs; is returned if the blinking cursor colors were successfullyb set to the specified colors. .RE  .sp  .ne 10 .nfX .PP\* .B "int MFBSetRubberBanding(onFlag, X, Y)" .B "int X, Y;" .B "Bool onFlag;"f .fiF .DTS .RS0 .I MFBSetRubberBanding7 enables/disables rubber banding of the pointing device.f If	 .I onFlag9* is false, then rubber banding is disabled.0 When enabled, the center of rubber banding is at .I X, Y.- Rubber banding is always disabled immediatelyF/ after the pointing device has been used.  MFBOKnO is returned if the rubberbanding mode was successfully set to that specified bye
 .I onFlag;: MFBNORBND is returned if the graphics device does not have% rubberbanding in the pointing device.  .REn .spS .ne 13 .nft .PP)9 .B "int MFBSetBlinker(colorId, red, green, blue, onFlag)"e .B "int colorId;"l .B "int red, green, blue;" .B "int onFlag;" .fiy .DTy .RSt .I MFBSetBlinker  enables the color identified by 
 .I colorIdI to blink between its currently defined color and the color defined by thee .I red, green, bluee combination.  The values ofc .I red, green,   and  .I blued are normalized to 1000.  Ifc	 .I onFlagt" is zero, the blinking is disabled.F The number of colors that may be defined as blinkers at any given time must be less than the value of .I maxBlinkers in the .I MFB> data structure.  The frequency of the blinking colors is fixed( and can be changed only by modifying the	 .I mfbcapa database file.+ MFBOK is returned if the color specified by 
 .I colorId2 was successfully set to the desired blinking mode;5 MFBNOBLNK is returned if the graphics device does not*' have blinking VLT layers, and MFBTMBLNKoA is returned if there are already too many active blinking layers.  .REs .spO .ne 6t .SH DEFINING DEVICE PARAMETERS .PPyG Each of the following routines for defining device parameters returns ah> negative value if any difficulty is encountered.  The possible! returned integers are defined in   .I mfb.h as follows:e .PPi .ne 6a .nfe4 .ta \w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXX'u +\w'XXXXXX'u( #define	MFBOK	 1	/* successful return */8 #define	MFBNODFLP 	-120	/* No definable line patterns */8 #define	MFBNODFFP 	-130	/* No definable fill patterns */1 #define	MFBNODFCO 	-140	/* No definable colors */c .fid .sp 1s .DTc .ne 10 .nf  .PPr2 .B "int MFBDefineColor(colorId, red, green, blue)" .B "int colorId; .B "int red, green, blue;" .fie .DTv .RSh .I MFBDefineColorb3 redefines the VLT entry for the color identified bym
 .I colorId" to be the color represented by the .I red, green, blueb combination wherer .I red, green, and  .I bluee are normalized to 1000.  Once the color corresponding to 
 .I colorId7 is redefined, all geometries that were written onto thef display of a frame buffer with
 .I colorId/ as the current color will become the new color.e& MFBOK is returned if the VLT entry for
 .I colorId was successfully defined;dA MFBNODFCO is returned if the graphics device does not have a VLT.l .REd .spe .ne 10 .nfF .PPe0 .B "int MFBDefineFillPattern(styleId, BitArray)" .B "int styleId;"e .B "int *BitArray;"c .fil .DTt .RSh .I MFBDefineFillPatterna( redefines the fill pattern identified by
 .I styleId and returns with
 .I styleId as the current fill style. .I BitArraynH is a pointer to an array of eight integers whose least significant eightD bits represent individual rows in an eight by eight intensity array.J For example, a fill pattern with an ascending diagonal line may be defined* by the following eight (decimal) integers: .IPe .ne 6d .nfd .ceh 1 2 4 8 16 32 64 128 256   .fit .DT  .PPaM A diagonal-grid fill pattern can be defined with the following integer array:F .IP  .nfr .cee 257 130 68 40 40 68 130 257u   .fi  .ne 5t .PPa+ MFBOK is returned if the new fill style foru
 .I styleId$ was successfully defined;  MFBNODFFPI is returned if the graphics device does not have definable fill patterns.  .DTa .REc .spd .ne 9y .nff .PPt* .B "int MFBDefineLineStyle(styleId, Mask)" .B "int styleId;"s .B "int Mask;" .fir .DTa .RSc .I MFBDefineLineStylei$ defines the line style identified by
 .I styleIdB to be the pattern contained in the eight least significant bits of .I Maskd and returns with
 .I styleId as the current line style.' MFBOK is returned if the line style for 
 .I styleId$ was successfully defined;  MFBNODFFPI is returned if the graphics device does not have definable line patterns.o .REr .spe .ne 7m .SH INPUT\/OUTPUT ROUTINES .nft .PPc .B "int MFBUpdate()" .fir .DT  .RSo .I MFBUpdateI flushes the internal output buffer to the currently defined output devicetG and will ignore any write error that may occur.  A call to this routinetB is ABSOLUTELY necessary to complete any graphics display sequence. .I MFBUpdateL returns the number of characters sent to the output graphics device or -1 if a write error occured. .RE  .spu .ne 8r .nf  .PPw$ .B "int MFBPoint(X, Y, key, button)" .B "int *X, *Y, *button;"  .B "char *key;"c .fig .DTc .RSa .I MFBPointFC enables the graphics pointing device and then waits for user input.i If a keyboard key is pressed,t .I MFBPointu returns with .I key* containing the character that was pressed." If the pointing device is pressed, .I MFBPoint / returns with the identified viewport coordinaten .I X, Y, the contents of  .I keyA equal to zero, and the button mask of the button that was pushed.c The integer array.
 .I buttonMaskd in the s .I MFBC data structure contains all possible button mask values that can be 
 returned.  .I MFBPoint\2 returns one of the following values defined in the .I mfb.h file:e .PPA .ne 6d .nfe4 .ta \w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXX'u +\w'XXXXXX'u( #define	MFBOK	 1	/* successful return */6 #define	MFBPNTERR 	-230	/* Error in pointing device */0 #define	MFBNOPTFT 	-240	/* No pointing format */. #define	MFBNOPNT	-260	/* No pointing device */ .fip .DTt .REe .sp  .ne 8a .nfv .PPi4 .B "char *MFBKeyboard(X, Y, background, foreground)" .B "int background;" .B "int foreground;" .B "int X, Y;" .fia .DTe .RS  .I MFBKeyboardB enables the graphics keyboard and waits for user input.  A pointerB to a character buffer containing the keyboard input is returned by .I MFBKeyboard1 when the user presses the return or linefeed key.tJ Backspace is control-H or the delete character, and control-X or control-U7 will kill the line.  Pressing the ESCAPE key will causee .I MFBKeyboard; to return with a null string in the input character buffer.  .PP > All keyboard input is displayed in the viewport with the lower& left corner at the viewport coordinate .I X, Ye& and is constrained to fit on one line.
 .I Backgroundd andb
 .I foregroundoH are the background and foreground color styles respectively in which the! keyboard input will be displayed.t .RE  .nf  .spt .ne 5f .PPl .B "void MFBAudio()" .fi  .DTu .RSf .I MFBAudio K will ring the bell or alarm on the graphics device.  If the graphics deviceaG does not have a bell, then a control-G will be sent to standard output." .REF .spt .ne 12 .nfD .PPR .B "int MFBPutchar(c)" .B "char c;" .PPu .B "int MFBPutstr(cp,nchars)"e .B "int nchars;" .B "char *cp;" .PPr .B "int MFBGetchar()"r .fic .RSo+ These three routines are used internally bym .I MFB9 and typically are not used within an application program.b They are comparable to the .I stdio routines having similar names.
 .I MFBPutchar  places a character .I c in the output buffer.X .I MFBPutstr inserts a string pointed to by .I cph
 containing	 .I nchars ' characters into the output buffer.  Thep	 .I ncharsiF argument is necessary to permit embedded null characters in the outputJ stream.  The characters remain in the output buffer until the next call to .I MFBUpdateB or until the contents of the output buffer exceed 4096 characters. .PPc
 .I MFBGetcharXK returns a single character from the graphics input device.  If the graphicst7 device does not have a keyboard, input is obtained from < the terminal from which the application program was invoked. If the graphics device is a  .I tty,I2 it should be remembered that it is in CBREAK mode. .REn .sp 1I .ne 6 % .SH TWO DIMENSIONAL GEOMETRY ROUTINESX .PP B All coordinates that are passed to the following geometry routinesB are with respect to the display resolution of the graphics device. .I MFBE assumes that the lower, left corner of the display is the origin withnL an absolute coordinate (0, 0).  All coordinate values are positive integers. .ne 4Y .nfk .PPd .B "void MFBMoveTo(X1, Y1)"r .B "int X1, Y1;" .fiu .DT  .RSn .I MFBMoveTo% sets the current graphics position toh
 .I X1, Y1.5 No line will be drawn from the old graphics position.f .REF .spL .ne 5	 .nf  .PPa .B "void MFBDrawLineTo(X1, Y1)"N .B "int X1, Y1;" .fia .DTi .RSt .I MFBDrawLineTo2 draws a line from the current graphics position to	 .I X1, Y1 $ in the current line style and color.* The current graphics position then becomes
 .I X1, Y1. .REe .spe .ne 4e .nff .PPD! .B "void MFBLine(X1, Y1, X2, Y2)"i .B "int X1, Y1, X2, Y2;" .fi  .DTi .RSb
 .I MFBLine5 draws a line in the current line style and color fromb	 .I X1, Y1n to
 .I X2, Y2. .RE  .sp, .ne 4  .nfu .PPr* .B "void MFBBox(left, bottom, right, top)"" .B "int left, bottom, right, top;" .fil .DTm .RSs	 .I MFBBoxw: displays a rectangle in the current fill pattern and color with diagonal coordinates at .I left, bottomr andF .I right, top. .REe .spe .ne 12 .nfc .PPd .B "void MFBDrawPath(path)"  .B "MFBPATH *path;"  .fie .DTh .RSe .I MFBDrawPath< draws a path of vectors in the current line style and color. .I Pathn/ is a pointer to a data structure defined in the  .I mfb.h file as follows: .PPI .nfe% .ta \w'XXXXX 'u +\w'XXXXXXXXXXXXXX 'ut struct mfbpath {6 	int nvertices;	/* number of (x,y) coordinate pairs */5 	int *xy;	/* pointer to array of (x,y) coordinates */o 	};h   typedef struct mfbpath MFBPATH;e .fi  .DTr .PPeB The contents of the coordinate array are organized such that xy[0]E is the x coordinate of the first vertex, xy[1] is the y coordinate ofeF the first vertex, xy[2] is the x coordinate of the second vertex, etc. .RE  .sp8 .ne 4  .nf  .PP  .B "void MFBFlood()" .fir .DTe .RSt .I MFBFloodyK erases a frame buffer display to the current color as previously defined byo .I MFBSetColor. L The result would be the same as drawing a solid box over the entire display. .REl .sp  .ne 4P .nfn .PP  .B "void MFBPixel(X, Y)" .B "int X, Y;" .fir .DTh .RSl .I MFBPixelh sets the pixel at location .I X, Y < on the display to the current color as previously defined by .I MFBSetColor.v .REr .spr .ne 7  .nf  .PPn& .B "void MFBCircle(X, Y, rad, nsides)" .B "int X, Y, rad, nsides;"o .fia .DTh .RSe .I MFBCircleC draws the perimeter of a circle in the current line style and colori with center at .I X, Y. and with radius  .I rad.l The argument	 .I nsidesdI is the number of line segments with which the circle will be drawn if thevE frame buffer does not have a circle primitive.  The default value for,	 .I nsides"
 is twenty. .REu .sp  .ne 6  .nfB .PPo% .B "void MFBFlash(X, Y, rad, nsides)"h .B "int X, Y, rad, nsides;"  .fi  .DTt .RSd .I MFBFlashiJ draws a round flash with the current fill pattern and color with center at .I X, Y 
 and radius .I rad.t The argument	 .I nsides B is the number of line segments with which the flash will be drawn. The default value foro	 .I nsidesr
 is twenty. .REt .sph .ne 5m .nfI .PPY3 .B "void MFBArc(X, Y, rad, angle1, angle2, nsides)"X .B "int X, Y, rad;""  .B "int angle1, angle2, nsides;" .fi  .DTB .RS 	 .I MFBArce? draws an arc in the current line style and color with center at, .I X, Y  and with radiusn .I rad beginning at	 .I angle1o2 with respect to the positive y\-axis and ending at	 .I angle2D! in a counter-clockwise direction.c; Both angles are in degrees and are greater than or equal too1 zero and less than or equal to 360.  The argument.	 .I nsideseI is the number of line segments with which a 360 degree arc will be drawn.f The default value forr	 .I nsidesw
 is twenty. .REr .spt .ne 12 .nfn .PPl .B "void MFBPolygon(poly)" .B "MFBPOLYGON *poly;" .fid .DTd .RSh
 .I MFBPolygoni8 draws a polygon with the current fill pattern and color. .I Poly / is a pointer to a data structure defined in the, .I mfb.h file as follows: .PP	 .nfi% .ta \w'XXXXX 'u +\w'XXXXXXXXXXXXXX 'u  struct mfbpolygon {t6 	int nvertices;	/* number of (x,y) coordinate pairs */5 	int *xy;	/* pointer to array of (x,y) coordinates */e 	};o  % typedef struct mfbpolygon MFBPOLYGON;  .fir .DTe .PP B The contents of the coordinate array are organized such that xy[0]E is the x coordinate of the first vertex, xy[1] is the y coordinate ofRF the first vertex, xy[2] is the x coordinate of the second vertex, etc. The difference between the
 .I MFBPOLYGONh typedef and the 
 .I MFBPATH! typedef defined above is that the 
 .I MFBPOLYGON 9 struct is assumed to define a closed path of coordinates.  .RE" .spr .ne 5  .nf  .PPB; .B "MFBPATH *MFBArcPath(X, Y, rad, angle1, angle2, nsides)"t .B "int X, Y, rad;"s  .B "int angle1, angle2, nsides;" .fiv .DTr .RSr
 .I MFBArcPath  returns a pointer to a
 .I MFBPATH* struct that contains an arc with center at .I X, Ya and with radiusg .I rad beginning at	 .I angle1n( with respect to the positive y\-axis and	 ending at 	 .I angle2 ! in a counter-clockwise direction. ; Both angles are in degrees and are greater than or equal ton1 zero and less than or equal to 360.  The arguments	 .I nsides @ is the number of line segments with which the arc will be drawn. The default value for 	 .I nsidesP
 is twenty. .REh .sp" .ne 5  .nfn .PPP5 .B "MFBPOLYGON *MFBEllipse(X, Y, radx, rady, nsides)"P .B "int X, Y, rad, nsides;"f .fiR .DTh .RSh .I MFBEllipsePathe returns a pointer to a
 .I MFBPOLYGON 9 struct that contains an elliptical polygon with center ata .I X, Yt and with distancen .I radx 9 from the center to an edge along the x\-axis and distancen .I radyu; from the center to an edge along the y\-axis.  The argumentc	 .I nsidesi@ is the number of line segments with which the arc will be drawn. The default value forr	 .I nsides 
 is twenty. .REr .sps .ne 6  .nft .PPe" .B "void MFBText(text, X, Y, phi)" .B "char *text;" .B "int X, Y, phi;"M .fia .DTr .RSl
 .I MFBText/ displays a null terminated string pointed to byP .I textB with the lower left corner ata .I X, Y G in the display viewport with the current color and rotated at the angleo .I phi# in degrees.  The default value for o .I phi is zero. .RE  .spa .ne 5n .nf. .PPt3 .B "void MFBNaiveBoxFill(left, bottom, right, top)"m" .B "int top, bottom, left, right;" .fis .DT  .RS  .I MFBNaiveBoxFillE can be used to draw a filled rectangle on a graphics device that doesw not support fill patterns.  Thee
 .I MFBLineJ routine is used to draw rectangles with eight different fixed fill styles.F If the graphics device does not have a command primitive for drawing a
 box, then thea	 .I MFBBox ! routine defined above defaults to  .I MFBNaiveBoxFill.l .REu .sp, .ne 9i .SH RASTER ROUTINESu .sp 1  .nf  .PPB/ .B "void MFBRasterCopy(X,Y,DX,DY,DestX,DestY);"B .B "int X,Y,DX,DY,DestX,DestY;"  .fi  .DT  .RS[ .I MFBRasterCopy: copies a rectangular area with the bottom, left corner at  .I X,Y and with length  .I DXn in the X direcion and width  .I DYe> in the Y direction to an area with the bottom, left corner at  .I DestX,DestY.t@ The mode of the copy operation was specified by the last call to .I MFBSetALUMode.  .REF .sp  .ne 9P .SH INFORMATION ACQUISITION, .sp 1) .nfB .PP  .B "int MFBInfo(info);"l .B "int info;" .fi  .DT  .RS 
 .I MFBInfoE is a routine for obtaining device specific information.  The possibler
 values for .I infoX are defined in .I mfb.h as follows:n .PP  .nfg8 .ta \w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXX'u +\w'XXXXXX'u% #define	MAXX	1	/* max x coordinate */r% #define	MAXY	2	/* max y coordinate */d. #define	MAXCOLORS	3	/* max number of colors */0 #define	MAXINTENSITY	4	/* max color intensity */; #define	MAXFILLPATTERNS	5	/* max number of fill patterns */.7 #define	MAXLINESTYLES	6	/* max number of line styles */s2 #define	MAXBLINKERS	7	/* max number of blinkers */; #define	POINTINGDEVICE	8	/* terminal has pointing device */R; #define	POINTINGBUTTONS	9	/* pointing device has buttons */M9 #define	NUMBUTTONS	10	/* num. of pointing dev. buttons */ 3 #define	BUTTON1	11	/* value returned by button 1 */r3 #define	BUTTON2	12	/* value returned by button 2 */c3 #define	BUTTON3	13	/* value returned by button 3 */-3 #define	BUTTON4	14	/* value returned by button 4 */n3 #define	BUTTON5	15	/* value returned by button 5 */a3 #define	BUTTON6	16	/* value returned by button 6 */n3 #define	BUTTON7	17	/* value returned by button 7 */ 3 #define	BUTTON8	18	/* value returned by button 8 */R3 #define	BUTTON9	19	/* value returned by button 9 */n5 #define	BUTTON10	20	/* value returned by button 10 */I5 #define	BUTTON11	21	/* value returned by button 11 */a5 #define	BUTTON12	22	/* value returned by button 12 */u9 #define	TEXTPOSITIONALBE	30	/* Bool: positionable text */ 3 #define	TEXTROTATABLE	31	/* Bool: rotatable text */o1 #define	FONTHEIGHT	32	/* font height in pixels */ / #define	FONTWIDTH	33	/* font width in pixels */ 5 #define	FONTXOFFSET	34 	/* font x offset in pixels */u4 #define	FONTYOFFSET	35	/* font y offset in pixels */> #define	DESTRUCTIVETEXT	36	/* Bool: text can be destructive */< #define	OVERSTRIKETEXT	37	/* Bool: text can be overstrike */+ #define	VLT	38	/* Bool: terminal has VLT */e5 #define	BLINKERS	39	/* Bool: terminal has blinkers */s@ #define	FILLEDPOLYGONS	40	/* Bool: terminal can fill polygons */> #define	DEFFILLPATTERNS	41	/* Bool: definable fill patterns */: #define	DEFCHANNELMASK	42	/* Bool: definable write mask */; #define	DEFLINEPATTERN	43	/* Bool: definable line styles */ 4 #define	CURFGCOLOR	44	/* current foreground color */4 #define	CURFILLPATTERN	45	/* current fill pattern */0 #define	CURLINESTYLE	46	/* current line style */4 #define	CURCHANNELMASK	47	/* current channel mask */. #define	CURREADMASK	48	/* current read mask */2 #define	NUMBITPLANES	49	/* number of bit planes */6 #define	DEFREADMASK	50	/* Bool: definable read mask */6 #define	RASTERCOPY	51	/* Bool: term has raster copy */5 #define	OFFSCREENX	52	/* left of off screen memory */ 7 #define	OFFSCREENY	53	/* bottom of off screen memory */c8 #define	OFFSCREENDX	54	/* length of off screen memory */7 #define	OFFSCREENDY	55	/* width of off screen memory */3 .fiT .DTg .PP. If an invalid argument is used,n
 .I MFBInfo will return -1.e .REa .spl .ne 6a$ .SH WINDOW\/VIEWPORT TRANSFORMATIONS .PPs .I MFBC provides a set of procedures for converting from window coordinatesPJ to viewport coordinates and vice versa.  These transformation routines are NOT used by the  .I MFBJ display routines and must be invoked separately by an application program. .ne 4  .nfw .PPP2 .B "void MFBSetViewport(left, bottom, right, top)"" .B "int left, bottom, right, top;" .ne 2e .PP(0 .B "void MFBSetWindow(left, bottom, right, top)"" .B "int left, bottom, right, top;" .ne 2e .PPt .B "int MFBScaleX(X)"G .B "int X;"D .ne 2  .PP  .B "int MFBScaleY(Y)"a .B "int Y;"o .ne 8d .PP  .B "int MFBDescaleX(X)"d .B "int X;"f .PPv .B "int MFBDescaleY(Y)"o .B "int Y;"r .fig .DTa .RSi To use these routines, itaH is necessary to define both the viewport of the graphics display and the# window in the working area by usingt .I MFBSetViewportn and  .I MFBSetWindow.E The viewport must always be defined by non-negative integers that areM= within the resolution of the graphics display.  Once defined,, .I MFBScaleX and  .I MFBScaleYC will convert from window coordinate values to viewport coordinates.i .I MFBDescaleX and  .I MFBDescaleYG will perform the inverse transformation.  The transform routines returns the scaled values. .RE	 .sp  .ne 7o .SH GEOMETRY CLIPPING ROUTINES .PPV .I MFBM provides a set of routines for clipping lines and polygons to a given window.a .ne 7e .nfk .PP 8 .B "void MFB_Y_Intercept(X1, Y1, X2, Y2, value, Yvalue)" .B "int X1, Y1, X2, Y2;" .B "int value;"  .B "int *Yvalue;"O .fi	 .DTo .RSr .I MFB_Y_Intercept calculates the value	 .I Yvalue15 of the y coordinate at the point of intersection of aL# line defined by the two coordinates 	 .I X1, Y1	 andN
 .I X2, Y2,4 and a vertical line with all x coordinates equal to 	 .I value.e .REr .spn .ne 7  .nfd .PP	8 .B "void MFB_X_Intercept(X1, Y1, X2, Y2, value, Xvalue)" .B "int X1, Y1, X2, Y2;" .B "int value;"n .B "int *Xvalue;"	 .fir .DTc .RSl .I MFB_X_Intercept calculates the value	 .I Xvalue E of the x coordinate at the point of intersection of a line defined byM	 .I X1, Y1o and 
 .I X2, Y2,5 and a horizontal line with all y coordinates equal tor	 .I value.d .RE	 .spR .ne 6	 .nff .PPo@ .B "void MFBLineClip(X1, Y1, X2, Y2, left, bottom, right, top);" .B "int *X1, *Y1, *X2, *Y2;"" .B "int left, bottom, right, top;" .fi  .DTn .RSS' The above clipping routines are used by* .I MFBLineClip# to clip the line segment defined byn	 .I X1, Y1o andl	 .I X2, Y2e to the window defined by .I left, bottom, right,M andS .I top.I .RE  .spd .ne 6t .nfr .PPr8 .B "void MFBPolygonClip(poly, top, bottom, left, right)" .B "MFBPOLYGON *poly;"" .B "int top, bottom, left, right;" .fi  .DTb .RS  .I MFBPolygonClipo6 clips a polygon with less than 200 vertices defined by .I poly  to the window defined by .I left, bottom, right,o and  .I top.p .I polyn# is replaced by the clipped polygon.  .RE  .spo .ne 7e .nfo .PPt8 .B "MFBPATH *MFBArcClip(path, left, bottom, right, top)" .B "MFBPATH *path;"n" .B "int left, bottom, right, top;" .fiP .DTB .RS 
 .I MFBArcClip 3 clips an arc with less than 200 vertices defined by  .I path; to the window defined by .I left, bottom, right,f andD .I top. 
 .I MFBClipArcu% returns a pointer to an array of five 
 .I MFBPATHF structs that define the clipped arc.  The contents of several of these( returned structs may define a null path. .RE  .spo .ne 7  .SH SPECIAL VIEWPORT ROUTINESv .sp 1e .nfa .PPM5 .B "void MFBMore(left, bottom, right, top, Textfile)"d" .B "int left, bottom, right, top;" .B "FILE *Textfile;" .fii .DTc .RSn
 .I MFBMore# will display the contents of a filel .I TextfileM in a viewport defined by .I left, bottom, right,f andr .I top& in a manner similar to the UCB program .I MORE(1).X .RE  .spX .ne 7X .nfX .PP 7 .B "void MFBScroll(left, bottom, right, top, Textfile)"f" .B "int left, bottom, right, top;" .B "FILE *Textfile;" .fin .DT  .RSl .I MFBScroll is an enhanced version ofo
 .I MFBMoreJ defined above that allows you to scroll up or down through the contents of .I Textfile. The contents ofl .I Textfiles& are displayed in a viewport defined by .I left, bottom, right,N andE .I top.  .REn .sps .ne 6n .SH DIAGNOSTICSf .sp 1N .nfU .PP	 .B "char *MFBError(errnum)"o .B "int errnum;" .fiO .DT	 .RSm .I MFBError G can be used to obtain a null terminated string that describes the errord7 associated with any of the above mentioned error codes.n	 .I errnum3 is the error code returned by a- .I MFB routine. .I MFBErrore2 returns a pointer to the error information string. The possible values for 	 .I errnumT are defined in .I mfb.h as follows:n .spf .ne 4T .nf74 .ta \w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXX'u +\w'XXXXXX'u1 #define	MFBBADENT	-10	/* Unknown terminal type */	2 #define	MFBBADMCF	-20	/* Can't open mfbcap file */1 #define	MFBMCELNG	-30	/* MFBCAP entry too long */U, #define	MFBBADMCE	-40	/* Bad mfbcap entry */1 #define	MFBINFMCE	-50	/* Infinite mfbcap entry */*. #define	MFBBADTTY	-60	/* stdout not in /dev */. #define	MFBBADLST	-70	/* Illegal line style */. #define	MFBBADFST	-80	/* Illegal fill style *// #define	MFBBADCST	-90	/* Illegal color style */ 0 #define	MFBBADTM1	-100	/* No destructive text */1 #define	MFBBADTM2	-110	/* No overstriking text */	5 #define	MFBNODFLP	-120	/* No definable line styles */I5 #define	MFBNODFFP	-130	/* No definable fill styles */ 0 #define	MFBNODFCO	-140	/* No definable colors */( #define	MFBNOBLNK	-150	/* No blinkers */. #define	MFBTMBLNK	-160	/* Too many blinkers */7 #define	MFBBADDEV	-180	/* Can't open or close device */Y< #define	MFBBADOPT	-190	/* Can't access or set device stat */< #define	MFBNOMASK	-170	/* No definable read or write mask */+ #define	MFBBADWRT	-200	/* Error in write */u5 #define	MFBPNTERR	-210	/* Error in pointing device */t: #define	MFBNOPTFT	-220	/* No format for pointing device */. #define	MFBNOPNT	-230	/* No pointing device */- #define	MFBNORBND	-240	/* No Rubberbanding */U0 #define	MFBBADALU	-250	/* Cannot set ALU mode */ .fio .DTg .REo .spx .ne 4d .nf" .PPe .B "void MFBZeroCounters()"" .ne 2e .PPe6 .B "void MFBCounters(nCh,nBx,BxArea,nLn,LnLngth,nPxl)"/ .B "int *nCh,*nBx,*BxArea,*nLn,*LnLngth,*nPxl;"e .fi  .DTf .RSt .I MFBCountersH provides the ability to measure the communications bandwidth between the> host and the graphics device.  To use these routines, MFB must be compiled with the .B DEBUG flag defined in the 
 .I "mfb.h" file." .PPn( The procedure is initialized by invoking .I MFBZeroCounters1 after which the geometry display routines such as 	 .I MFBBoxh or
 .I MFBLine! may be called in any order.  WhenI .I MFBCounters@ is invoked, it will return the number of graphic text characters .I nCh) that where displayed, the number of boxess .I nBx displayed, the number of lines .I nLn* displayed, the average pixel area of a box
 .I BxArea, the average line lengthr
 .I LnLngth) in pixels, and the total number of pixelst .I nPxlt# that where affected.  Invocation ofe .I MFBCounters  does not clear the the counters. .REn .spI .ne 15 .SH THE MFB DATA STRUCTURE .REr .PDr .sp 1s .PP. The  .I MFB data structure is listed below.i .nfn> .ta \w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u +\w'XXXXXXXX'u   #define	TTY	't'' #define	HCOPY	'r'f    typedef enum {false, true} Bool;  ? .ta \w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'uf .ne 8M struct mfb_window {n
 	int left; 	int right;		 	int top;4 	int bottom; 	double length,width;I 	};	   .ne 8f! typedef struct mfb_window WINDOW;B# typedef struct mfb_window VIEWPORT;d   struct mfbpath { 	int nvertices;t	 	int *xy;f 	};F  " typedef struct mfbpath MFBPOLYGON; typedef struct mfbpath MFBPATH;c   .ne 8e #ifndef vms	 struct mfbremttyb {d 	struct sgttyb oldttyb;n 	struct sgttyb newttyb;e 	};k   .ne 9*? .ta \w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'un struct mfbremstat {o6 	int graphttyw;	/* old mode bits of graphics device */3 	int kybrdttyw;	/* old mode bits of standard I/O */i; 	struct stat graphstat;	/* old fstats of graphics device */f8 	struct stat kybrdstat;	/* old fstats of standard I/O */ 	};F? .ta \w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'uM  & typedef struct mfbremttyb MFBSAVETTYB;& typedef struct mfbremstat MFBSAVESTAT; #endif   struct mfbformatstrs { .ne 5c6 	char *startSequence;	/* first transmitted sequence */3 	char *endSequence;	/* last transmitted sequence */l3 	char *initLineStyles;	/* initialize line styles */;5 	char *initFillPatterns;	/* initialize fill styles */r5 	char *initColorStyles;	/* initialize color styles */n   .ne 3e* 	char *vltEntry;	/* define color in VLT */= 	char *setForegroundColor;	/* set current foreground color */y7 	char *screenFlood;	/* flood screen to current color */n   .ne 2 + 	char *channelMaskSet;	/* set write mask */t' 	char *readMaskSet;	/* set read mask */,   .ne 6B= 	char *enablePointingDevice;	/* initialize pointing device */l8 	char *enableRubberBanding;	/* turn on rubber banding */F 	char *disablePointingDevice;	/* disable pointing device and cursor */: 	char *disableRubberBanding;	/* turn off rubber banding */> 	char *readPointingDevice;	/* wait and read pointing device */D 	char *formatPointingDevice;	/* decode format for pointing device */   .ne 4f/ 	char *keyboardStart;	/* initailize keyboard */o2 	char *keyboardEnd;	/* terminate keyboard input */; 	char *keyboardBackspace;	/* keyboard backspace sequence */t+ 	char *audio;	/* ring the terminals bell */l   .ne 10; 	char *lineDefineStart;	/* begin defining a line pattern */e? 	char *lineDefineFormat;	/* define bit array of line pattern */t= 	char *lineDefineEnd;	/* terminate line pattern definition */c1 	char *setLineStyle;	/* set current line style */ ? 	char *setSolidLineStyle;	/* set current line style to solid */r< 	char *movePenSequence;	/* move current graphics position */; 	char *drawLineSequence;	/* draw a line in current style */d5 	char *drawSolidLineSequence;	/* draw a solid line *//? 	char *drawLineToSequence;	/* move and draw current position */L> 	char *drawSolidLineToSequence;	/* move and draw solid line */   .ne 2P7 	char *drawBoxSequence;	/* draw box in current style */M3 	char *drawSolidBoxSequence;	/* draw a solid box */    .ne 4,A 	char *beginPlygnSequence;	/* begin polygon in cur. fill style */d9 	char *beginSolidPlygnSequence;	/* begin solid polygon */X9 	char *sendPlygnVertex;	/* define one point in polygon */u9 	char *endPlygnSequence;	/* terminate polygon sequence */i  B 	char *drawCircleSequence;	/* draw a circle in solid line style */   .ne 6t4 	char *rotateTextSequence;	/* rotate graphic text */2 	char *graphicsTextStart;	/* begin graphic text */4 	char *graphicsTextEnd;	/* terminate graphic text */5 	char *replaceON;	/* turn on destructive text mode */T9 	char *overstrikeON;	/* turn on overstriking text mode */u9 	char *writePixel;	/* write one pixel in current color */t   .ne 4d+ 	char *setALUEOR;	/* set ALU mode to EOR */n+ 	char *setALUNOR;	/* set ALU mode to NOR *//) 	char *setALUOR;	/* set ALU mode to OR */l6 	char *setALUJAM;	/* set ALU mode to JAM or REPLACE */   .ne 2	* 	char *blinkerON;	/* make a color blink */2 	char *blinkerOFF;	/* turn off a blinking layer */   .ne 4d6 	char *rastCopyStart;	/* begin raster copy sequence */8 	char *rastCopyEnd;	/* terminate raster copy sequence */: 	char *rastCopyDest;	/* define raster copy destionation */; 	char *rastCopySource;	/* define raster copy source area */c   .ne 5t9 	char *fillDefineStart;	/* begin defining a fill style */t= 	char *fillDefineFormat;	/* define bit array of row/column */b; 	char *fillDefineEnd;	/* terminate fill style definition */;5 	char *setFillPattern;	/* set current fill pattern */cC 	char *setSolidFillPattern;	/* set current fill pattern to solid *// 	};o    H .ta \w'XXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'u" struct mfb {	/* MFB DATA STRUCT */   .ne 5a 	/*y: .ta \w'XXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXX'u 	* INTEGERS FIELDS 	*/aH .ta \w'XXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'uC /* used for decode */	int lastX,lastY;	/* for Tektronix encoding */e" 	int X,Y,Z,T;	/* parameter list */   .ne 7f6 /* Resolution */	int maxX;	/* horizontal resolution */$ 	int maxY;	/* vertical resolution */. 	int maxColors;	/* maximum number of colors */3 	int minOffScreenX;	/* left of off screen memory */m3 	int minOffScreenY;	/* bottom of off screen mem. */e1 	int offScreenDX;	/* length of off screen mem. */a0 	int offScreenDY;	/* width of off screen mem. */   .ne 2nG /* Video Layer Table */	int maxIntensity;	/* max RGB or LS intensity */o, 	int lengthOfVLT;	/* number of bit planes */   .ne 2aE /* Pointing Device */	int buttonMask[12];	/* returned button masks */o& 	int numberOfButtons;	/* 12 maximum */   .ne 2a+ /* Keyboard Control */	int keyboardYOffset;I 	int keyboardXOffset;t   .ne 2yG /* Line Drawing */	int lineDefineLength;	/* number of bytes in array */c/ 	int maxLineStyles;	/* number of line styles */m   .ne 4h; /* Text font */	int fontHeight;	/* font height in pixels */n* 	int fontWidth;	/* font width in pixels */ 	int fontXOffset;  	int fontYOffset;m  8 /* Blinkers */	int maxBlinkers;	/* number of blinkers */   .ne 3lC /* Fill Patterns */	int fillDefineHeight;	/* number of byte rows */t2 	int fillDefineWidth;	/* number of byte columns */3 	int maxFillPatterns;	/* number of fill patterns */e   .ne 9mI /* Current variables */	int cursorColor1Id;	/* blinked cursor color ID */,4 	int cursorColor2Id;	/* unblinked cursor color ID */. 	int fgColorId;	/* cur. foreground color ID */, 	int fillPattern;	/* cur. fill pattern ID */( 	int lineStyle;	/* cur. line style ID */' 	int channelMask;	/* cur. write mask */R# 	int readMask;	/* cur. read mask */ / 	int numBlinkers;	/* cur. number of blinkers */X. 	int textMode;	/* text mode (1=dest, 0=rep) */2 	int stipplePattern[8];	/* cur. stipple pattern */   .ne 2{. 	int fileDesc;	/* desc. for graphics device */3 	int numTtyBuffer;	/* cur. chars in output queue */t     .ne 5  	/*i: .ta \w'XXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXX'u 	* POINTERS  	*/ H .ta \w'XXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'u2 /* for tty's only */	char *name;	/* device name *// 	char *terminalName;	/* name of MFBCAP entry */;   .ne 6 * /* I/O routines */	int (*dsply_getchar)(); 	int (*kybrd_getchar)(); 	int (*dsply_ungetchar)(); 	int (*kybrd_ungetchar)(); 	int (*outchar)(); 	int (*outstr)();y     .ne 4* 	/*n: .ta \w'XXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXX'u 	* BOOLEANS  	*/nH .ta \w'XXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'u 	Bool initializedBool;   .ne 2q% /* Video Layer Table */	Bool vltBool;  	Bool vltUseHLSBool;   .ne 2a( /* Channel Mask */	Bool channelMaskBool; 	Bool readMaskBool;    .ne 3 . /* Pointing Device */	Bool PointingDeviceBool; 	Bool buttonsBool; 	Bool readImmediateBool;  ) /* Keyboard Control */	Bool keyboardBool;*   .ne 2f. /* Line Drawing */	Bool linePatternDefineBool; 	Bool reissueLineStyleBool;t  + /* Polygon Drawing */	Bool filledPlygnBool;    .ne 4** /* Text font */	Bool textPositionableBool; 	Bool textRotateBool;* 	Bool replaceTextBool; 	Bool overstrikeTextBool;   ! /* Blinkers */	Bool blinkersBool;t   .ne 2]$ /* Raster Copy */	Bool rastCopyBool; 	Bool rastRSCSFBool;   .ne 2/, /* Fill Patterns */	Bool fillPtrnDefineBool; 	Bool fillDefineRowMajorBool;t   .ne 3 ! /* for tty's only */	Bool litout;n
 	Bool raw; 	Bool ttyIsSet;n     .ne C .ta \w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'u  	/**D .ta \w'XXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'u
 	* STRUCTURESl 	*/ C .ta \w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'ue3 	struct mfbformatstrs strings;	/* format strings */r  + 	WINDOW currentWindow;	/* current window */o1 	VIEWPORT currentViewport;	/* current viewport */u   .ne 11 #ifndef vmst" 	/* graphics device ttyb struct */ 	MFBSAVETTYB graphTtyb;r  D 	/* keyboard ttyb struct if graphics device does not have a kybrd */ 	MFBSAVETTYB kybrdTtyb;u   	/* tty status ints */ 	MFBSAVESTAT oldstat;u #endif     .ne 11 	/*PD .ta \w'XXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'u
 	* CHARACTERSa 	*/aC .ta \w'XXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'u +\w'XXXXXXXX'ut0 	char deviceType;	/* TTY=tty, HCOPY=hard copy */7 	char strBuf[BUFSIZE];	/* storage for format strings */a4 	char ttyBuffer[TTYBUFSIZE];	/* tty output buffer */ 	};s   typedef struct mfb MFB;v   .fi  .DTn .spB .ne 10 .SH EXAMPLEi .PPp= The following C program is a simple example that uses several+ .I MFBN routines.  The terminal type is assumed to be the first command line argument.M This program will display several triangles in different line styles, displaym9 at four angles of rotation the text that is returned fromn .I MFBKeyboard,iM draw a solid line between two points, and draw an arc clipped to a rectangle.r .IP  .nf(D .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u     #include <cad/mfb.h>   main(argc, argv)
 	int argc; 	char *argv[]; 	{ 	int i, j, k, m; 	int X1, X2, Y1, Y2; 	int numcolors;X 	int numlinestyles;X 	int button; 	int error;; 	MFB *mfb, *MFBOpen();
 	MFBPATH *pp;l
 	char key; 	char *TypeIn;   .ne 2n 	/* open graphics device */ & 	mfb = MFBOpen(argv[1], NULL, &error);   .ne 5  	/* exit on any error */ 	if(error < 0) {4 		fprintf(stderr, "error:  %s\\n", MFBError(error));
 		exit(0); 		}w   .ne 6; 	/* get device information */c 	X1 = MFBInfo(MAXX)/2; 	X2 = X1/2;	 	Y1 = MFBInfo(MAXY)/30;n  	numcolors = MFBInfo(MAXCOLORS);( 	numlinestyles = MFBInfo(MAXLINESTYLES); .ne 4  	if(numcolors > 7) 		numcolors = 7; 	if(numlinestyles > 7) 		numlinestyles = 7;   .ne 5*5 	/* draw pyramid of lines in different line styles */a 	for(j=0; j<28; ++j) {A 		/* set color (increment by one to prevent 'invisible' lines) */  		k = j % (numcolors - 1); 		MFBSetColor(k + 1);    .ne 4s! 		/* define and set line style */s 		m = j % numlinestyles; 		MFBDefineLineStyle(m, j * 6);s 		MFBSetLineStyle(m);t   .ne 4f 		/* draw pyramid */  		MFBLine(0, 0, X2, Y1*j + 2*j);! 		MFBLine(X1, 0, X2, Y1*j + 2*j);a 		}o   .ne 2u 	/* flush output */f
 	MFBUpdate();i   .ne 9  	/* test of MFBKeyboard *// 	MFBText("Test of MFBKeyboard.", X2, Y1*28, 0); # 	TypeIn = MFBKeyboard(X1, 5, 0, 1);r 	MFBText(TypeIn, X1, 70, 0); 	MFBText(TypeIn, X1, 70, 90);X 	MFBText(TypeIn, X1, 70, 180); 	MFBText(TypeIn, X1, 70, 270);
 	MFBUpdate();S
 	sleep(3);   .ne 9/ 	/* test of MFBPoint */X 	MFBSetColor(1); 	MFBFlood(); 	MFBSetColor(0);, 	MFBText("Test of MFBPoint.", X2, Y1*28, 0);# 	MFBPoint(&X1, &Y1, &key, &button);X# 	MFBPoint(&X2, &Y2, &key, &button);a 	MFBSetLineStyle(0); 	MFBLine(X1, Y1, X2, Y2);	   .ne 5t) 	/* draw outline of box to contain arc */m 	MFBLine(100, 100, 100, 350);/ 	MFBLine(100, 100, 370, 100);t 	MFBLine(370, 100, 370, 350);v 	MFBLine(100, 350, 370, 350);B   .ne 7m( 	/* test of MFBArcPath and MFBClipArc */ 	i = 0;dH 	pp = MFBClipArc(MFBArcPath(70, 70, 200, 0, 0, 30), 100, 100, 370, 350);' 	while(pp[i].nvertices != 0 && i < 4) {g 		MFBDrawPath(&pp[i]); 		i++; 		}    .ne 6o 	/* flush output and wait */
 	MFBUpdate();o
 	sleep(6);   	MFBClose(); 	}     .fi  .DTt .spe .ne 10" .SH DEBOUNCING THE POINTING DEVICE .PP 3 The following C program is another example of usinga .I MFBE routines that demonstrates several methods of debouncing the pointingeE device.  Several graphics terminals can return bogus pointing reports'I that can be serious and annoying in some applications.  Identifying these B bogus reports is very terminal dependent (e.g. the AED 512 returnsF bad button masks, the Metheus 400 returns negative coordinates, etc.),8 and it is therefore necessary to use all possible tests. .IPI .nf D .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u   .ne 16 #include <cad/mfb.h>
 #ifdef vms #include <timeb.h> #else( #include <sys/timeb.h> #endif   .ne 6; /*
 .ta \w'X'u+ 	* This is the minimum time in milliseconds $ 	* between accepted pointing events. 	*/ D .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u #define DEBOUNCETIME 100   .ne 6i /*
 .ta \w'X'u- 	* we keep track of the time between pointingu  	* events to debounce the cursor 	*/rD .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u static long LastPointTime = 0;   .ne 10 /*
 .ta \w'X'u0 	* routine to read and debounce pointing device. 	*/)D .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u point(pointX,pointY,Key,Mask)  	int *pointX,*pointY,*Mask;t 	char *Key;	 	{ 	struct timeb now; 	long newtime; 	int X,Y,Buttons;L 	char KeyTyped;*   .ne 4a 	SetDebounceTime(); ) 	/* Loop until DEBOUNCETIME has passed */  	while(True) {   .ne 5/+ 		/* Loop until valid report is received */  		while(True) {F   .ne 3( 			/* Get pointing event */I& 			MFBPoint(&X,&Y,&KeyTyped,&Buttons);   .ne 3M 			/* Was a character typed? */B 			if(Key != 0)7
 				break;   .ne 6)/ 			/* Does the pointing device have buttons? */X  			if(MFBInfo(POINTINGBUTTONS)){ 				/*/ .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXXX'u,3 				* Test button masks and vicinity of coordinate.(! 				* Assume a four button mouse.L 				*/ .ne 10D .ta \w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u +\w'XXXX'u& 				if((Buttons == MFBInfo(BUTTON1) ||# 					Buttons == MFBInfo(BUTTON2) ||B# 					Buttons == MFBInfo(BUTTON3) ||1$ 					Buttons == MFBInfo(BUTTON4)) &&# 					(X < MFBInfo(MAXX) && X > 0 &&i! 					Y < MFBInfo(MAXY) && Y > 0))( 					break;0 				}) 			} .ne 57 		ftime(&now);* 		newtime = 1000 * now.time + now.millitm;8 		if((newtime - LastPointTime) < DEBOUNCETIME) continue; 		SetDebounceTime(); 		}  .ne 56
 	*pointX = X;(
 	*pointY = Y;  	*Key = KeyTyped;0 	*Mask = Buttons;E 	}     .ne 6E SetDebounceTime(){ 	struct timeb now;
 	ftime(&now);s/ 	LastPointTime = 1000 * now.time + now.millitm;o 	}     .fif .DTo .spB .ne 8l	 .SH NOTESj .PPl On some systems, r .I MFB' is contained in \/usr rather than ~cad.t .PPt .I MFB will also compile to run under .I "VMS"( (a trademark of Digital Equipment Corp.)= or any other operating system.  However, special I/O routinesX= such as those in ~cad\/src\/mfb\/vmsio.c must be provided forX .I MFB to function properly.  .PPc .I MFBF was written to be utmost UNIX compatible and consistent with the styleF of the C programming language.  For example, a control sequence always begins with a call to an .I "(MFB)Open"( routine and is terminated by a call to a .I "(MFB)Close" 1 routine.  Another example is the provision of the  .I "MFBHalt"B routine that is intended primarily for the handling of the SIGTSTP8 signal.  One possible exception to the style of C is the> use of a global output descriptor that is set by a call to the .I "SetCurrentMFB"C routine, as opposed to passing the output descriptor as an argument  to ever active function call.f .PPI .I MFB< was initially aimed toward the modeling of lower performanceC graphics terminals (e.g., there is currently no support of segmentsn8 or definable windows and viewports at the device level). As a result, programs that use .I MFB; are likely to work on the low performance (least expensive)i< graphics terminals as well as on the more expensive devices. .spg .ne 2d .SH BUGS .PPt1 Raster (hard copy) output is not yet implemented.  .spi .ne 10 .SH FUTURE ENHANCEMENTSi .PPw Future modifications too .I MFB may include the following: .IPS( Extension to hard copy graphics devices. .IPt, Definable vector and raster character fonts. .IPo: Improved cursor support including a definable cursor font,= cursor tracking by the host, cursor-on/cursor-off capability,   and cursor report without event. .IPn8 Window/viewport geometry clipping by the terminal if the! device possesses that capability.X .IP\ Bit block transfer (BitBlt). .spX .ne 4\	 .SH FILES  .nf6 ~cad/lib/mfbcapf ~cad/include/mfb.h ~cad/lib/mfb.a ~cad/src/mfb .fi  .DTf .spT .ne 2& .SH SEE ALSO .nf(4 mfbcap(5), termcap(5), curses(3), more(1), kic(CAD1) .fi	 .DTk .sp	 .ne 3	
 .SH AUTHOR .nfm Giles Billingsley 
 Ken Keller .fi  .bp.
 .SH STATUS .PPeF The following is a list of the terminals that will currently work with .I MFB:  .PP* .nfXK .ta \w'XXXXXXXX'u +\w'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'uE$ 4014	Tektronix 4014 with thumbwheels3 4113	Tektronix 4112/4113 with thumbwheels or tablet+$ AED5	AED 512 with joystick or tablet$ AED7	AED 767 with joystick or tablet: 2648	HP 2648 black and white grahpics terminal with tablet 9872	HP 9872 color pen plotter0 D125	DEC VT125 black and white graphics terminal .fim .PPoE The following table lists routines that depend on device capabilitiesu0 and may not work on all graphics devices.  Other .I MFB= routines that are not listed below will work for all devices.o .sp 1o .TSI! .if \n+(b.=1 .nr d. \n(.c-\n(c.-1e .de 35	 .ps \n(.so
 .vs \n(.vu
 .in \n(.iu
 .if \n(.u .fir
 .if \n(.j .ada .if \n(.j=0 .na  .. .nfn .nr #~ 0 .if n .nr #~ 0.6n 	 .ds #d .de .if \(ts\n(.z\(ts\(ts .ds #d nl  .fct .nr 33 \n(.s .rm 80 81 82 83 84 85 86 87h .nr 80 0 .nr 38 \w    Routine .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetLineStyle .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetFillPattern .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetChannelMask .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetReadMask  .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetColor .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetTextModen .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetALUMode .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetCursorColor .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetRubberBanding .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBSetBlinker .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBDefineColorm .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBDefineFillPatterna .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBDefineLineStyleU .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBMoveTo .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBDrawLineTo .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBLine .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBDrawPath .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBBoxt .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBPolygon  .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBFloode .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBPixeli .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBCircle .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBFlashd .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBArc  .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBText .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBPointi .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBKeyboard .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBMore .if \n(80<\n(38 .nr 80 \n(38 .nr 38 \wMFBScroll .if \n(80<\n(38 .nr 80 \n(38 .80k .rm 80 .nr 81 0 .nr 38 \w4 .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w0 .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w1 .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w4 .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \wX .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .nr 38 \w  .if \n(81<\n(38 .nr 81 \n(38 .81  .rm 81 .nr 82 0 .nr 38 \w4 .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \w1 .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \w1 .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \w3 .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \w  .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \w  .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \w  .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \w  .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \w  .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .nr 38 \wX .if \n(82<\n(38 .nr 82 \n(38 .82n .rm 82 .nr 83 0 .nr 38 \wA .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wE .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wD .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \w5 .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \w  .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \w  .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \w  .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .nr 38 \wX .if \n(83<\n(38 .nr 83 \n(38 .83H .rm 83 .nr 84 0 .nr 38 \wA .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wE .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wD .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \w7 .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \w  .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \w  .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \w  .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .nr 38 \wX .if \n(84<\n(38 .nr 84 \n(38 .84  .rm 84 .nr 85 0 .nr 38 \w2 .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \w6 .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \w4 .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \w8 .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \w  .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \w  .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \w  .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \w  .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \w  .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \w  .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .nr 38 \wX .if \n(85<\n(38 .nr 85 \n(38 .85n .rm 85 .nr 86 0 .nr 38 \w9 .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w8 .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w7 .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w2 .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \wX .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .nr 38 \w  .if \n(86<\n(38 .nr 86 \n(38 .86n .rm 86 .nr 87 0 .nr 38 \wD .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w1 .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w2 .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w5 .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \w  .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .nr 38 \wX .if \n(87<\n(38 .nr 87 \n(38 .87  .rm 87	 .nr 38 1nn .nr 79 0 .nr 40 \n(79+(1*\n(38)
 .nr 80 +\n(40n .nr 41 \n(80+(3*\n(38)
 .nr 81 +\n(41n .nr 42 \n(81+(3*\n(38)
 .nr 82 +\n(428 .nr 43 \n(82+(3*\n(38)
 .nr 83 +\n(43  .nr 44 \n(83+(3*\n(38)
 .nr 84 +\n(44  .nr 45 \n(84+(3*\n(38)
 .nr 85 +\n(45 .nr 46 \n(85+(3*\n(38)
 .nr 86 +\n(468 .nr 47 \n(86+(3*\n(38)
 .nr 87 +\n(47n .nr TW \n(87 .nr TW +1*\n(38 W .if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 42 file Input is too wide - \n(TW units5
 .ne 33v+8p .nr #I \n(.i .in +(\n(.lu-\n(TWu-\n(.iu)/2u .fc  i
 .nr #T 0-1
 .nr #a 0-1
 .nr #a 0-1 .eo  .de T#	 .ds #d .d  .if \(ts\n(.z\(ts\(ts .ds #d nl( .mk ##
 .nr ## -1v .ls 1< .if \n(#T>=0 .nr #a \n(#T\ .if \n(T. .vs \n(.vu-\n(.sp\o .if \n(T. \v'-1p'\h'|0'\h'1p'\s\n(33\l'|\n(TWu-1p\(ul'\s0\v'2p'\h'|0'\h'-1p'\s\n(33\l'|\n(TWu+1p\(ul'\s0\v'-1p'n
 .if \n(T. .vs6 .if \n(#a>=0 .sp -1  .if \n(#a>=0 \h'|0'\h'-1p'\v'1p'\s\n(33\h'-\n(#~u'\L'|\n(#au-1v-2p'\s0\v'\n(\*(#du-\n(#au+1v+1p'\h'2p'\v'-1p'\s\n(33\h'-\n(#~u'\L'|\n(#au-1v+2p'\s0\v'\n(\*(#du-\n(#au+1v-1p'\h'|\n(TWu' .if \n(#a>=0 .sp -18 .if \n(#a>=0 \h'|\n(TWu'\h'-1p'\v'-1p'\s\n(33\h'-\n(#~u'\L'|\n(#au-1v+2p'\s0\v'\n(\*(#du-\n(#au+1v-1p'\h'2p'\v'1p'\s\n(33\h'-\n(#~u'\L'|\n(#au-1v-2p'\s0\v'\n(\*(#du-\n(#au+1v+1p' .lsn .. .ec8 .nr 36 \n(.v .vs \n(.vu-\n(.spne \v'-1p'\h'|0'\h'-1p'\s\n(33\l'|\n(TWu+1p\(ul'\s0\v'2p'\h'|0'\h'1p'\s\n(33\l'|\n(TWu-1p\(ul'\s0\v'-1p' 
 .vs \n(36u .mk #a< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m< \&\h'|\n(40u'\h'|\n(41u'4\h'|\n(42u'4\h'|\n(43u'A\h'|\n(44u'A\h'|\n(45u'2\h'|\n(46u'9\h'|\n(47u'D< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m8 \&\h'|\n(40u'\h'|\n(41u'0\h'|\n(42u'1\h'|\n(43u'E\h'|\n(44u'E\h'|\n(45u'6\h'|\n(46u'8\h'|\n(47u'1< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1mn \&\h'|\n(40u'    Routine\h'|\n(41u'1\h'|\n(42u'1\h'|\n(43u'D\h'|\n(44u'D\h'|\n(45u'4\h'|\n(46u'7\h'|\n(47u'2 < .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m  \&\h'|\n(40u'\h'|\n(41u'4\h'|\n(42u'3\h'|\n(43u'5\h'|\n(44u'7\h'|\n(45u'8\h'|\n(46u'2\h'|\n(47u'5 .nr 36 \n(.v .vs \n(.vu-\n(.sp d \v'-1p'\h'|0'\h'1p'\s\n(33\l'|\n(TWu-1p\(ul'\s0\v'2p'\h'|0'\h'1p'\s\n(33\l'|\n(TWu-1p\(ul'\s0\v'-1p'
 .vs \n(36u< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m  \&\h'|\n(40u'MFBSetLineStyle\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'X2< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m  \&\h'|\n(40u'MFBSetFillPattern\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'Xn< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m  \&\h'|\n(40u'MFBSetChannelMask\h'|\n(41u' \h'|\n(42u' \h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u' \h'|\n(46u' \h'|\n(47u' n< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1mn \&\h'|\n(40u'MFBSetReadMask\h'|\n(41u' \h'|\n(42u' \h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u' \h'|\n(46u' \h'|\n(47u' < .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m  \&\h'|\n(40u'MFBSetColor\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'X<< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m  \&\h'|\n(40u'MFBSetTextMode\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u' \h'|\n(44u' \h'|\n(45u' \h'|\n(46u' \h'|\n(47u' < .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m \&\h'|\n(40u'MFBSetALUMode\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u' \h'|\n(44u' \h'|\n(45u'X\h'|\n(46u' \h'|\n(47u' << .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m< \&\h'|\n(40u'MFBSetCursorColor\h'|\n(41u' \h'|\n(42u' \h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u' \h'|\n(46u' \h'|\n(47u' (< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m( \&\h'|\n(40u'MFBSetRubberBanding\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u' \h'|\n(44u' \h'|\n(45u'X\h'|\n(46u' \h'|\n(47u'  < .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m  \&\h'|\n(40u'MFBSetBlinker\h'|\n(41u' \h'|\n(42u' \h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u' \h'|\n(46u' \h'|\n(47u' n .nr 36 \n(.v .vs \n(.vu-\n(.sp'( \h'|0'\h'1p'\s\n(33\l'|\n(TWu-1p\(ul'\s0
 .vs \n(36u< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m> \&\h'|\n(40u'MFBDefineColor\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u' \h'|\n(46u' \h'|\n(47u' < .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m' \&\h'|\n(40u'MFBDefineFillPattern\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u' \h'|\n(47u' < .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m' \&\h'|\n(40u'MFBDefineLineStyle\h'|\n(41u' \h'|\n(42u' \h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u' \h'|\n(47u'  .nr 36 \n(.v .vs \n(.vu-\n(.sp( \h'|0'\h'1p'\s\n(33\l'|\n(TWu-1p\(ul'\s0
 .vs \n(36u< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m\ \&\h'|\n(40u'MFBMoveTo\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'XX< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m8 \&\h'|\n(40u'MFBDrawLineTo\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'X\< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1mu \&\h'|\n(40u'MFBLine\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'Xu< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m  \&\h'|\n(40u'MFBDrawPath\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'X4< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m3 \&\h'|\n(40u'MFBBox\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'X< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m  \&\h'|\n(40u'MFBPolygon\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'X< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m8 \&\h'|\n(40u'MFBFlood\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u' \h'|\n(47u'X< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1mn \&\h'|\n(40u'MFBPixel\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'X< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1mn \&\h'|\n(40u'MFBCircle\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'Xn< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m* \&\h'|\n(40u'MFBFlash\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'X< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m( \&\h'|\n(40u'MFBArc\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'X< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m \&\h'|\n(40u'MFBText\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u'X\h'|\n(47u'Xu .nr 36 \n(.v .vs \n(.vu-\n(.sp1( \h'|0'\h'1p'\s\n(33\l'|\n(TWu-1p\(ul'\s0
 .vs \n(36u< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m7 \&\h'|\n(40u'MFBPoint\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u' \h'|\n(47u' < .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m\ \&\h'|\n(40u'MFBKeyboard\h'|\n(41u'X\h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u' \h'|\n(47u'X< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1mn \&\h'|\n(40u'MFBMore\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u' \h'|\n(47u'X(< .ta \n(80u \n(81u \n(82u \n(83u \n(84u \n(85u \n(86u \n(87u  .nr 31 \n(.f	 .nr 35 1m2 \&\h'|\n(40u'MFBScroll\h'|\n(41u' \h'|\n(42u'X\h'|\n(43u'X\h'|\n(44u'X\h'|\n(45u'X\h'|\n(46u' \h'|\n(47u'XX .fc| .nr T. 1 .T# 1n
 .in \n(#Iu .354 .nr #a 0 .TEn" .if \n-(b.=0 .nr c. \n(.c-\n(d.-41 .DTn