 /*
  * mfbbasic.c*  **  * Copyright -C- 1982 Giles C. Billingsley&  * sccsid "@(#)mfbbasic.c	1.9  9/3/83"  *E  *     MFB is a graphics package that was developed by the integratedc@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atD  * the University of California, Berkeley, California.  The programs?  * in MFB are available free of charge to any interested party.TC  * The sale, resale, or use of these program for profit without theeF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,i  * is forbidden.  */      #include "mfb.h" #include <stdio.h> #include <math.h>    #define	RadToDeg	57.29577951% #define	MFBFORMAT	MFBCurrent->strings*  " /* Here we take care of externs */ MFB *MFBCurrent;    N /*****************************************************************************  *)  *		    BASIC MACROS AND SERVICE ROUTINES_  *O  *****************************************************************************/    intM
 MFBInfo(Info)B
     int Info;      {      /*
      * Notes: :      *    MFBInfo is the only routine for acquiring device;      *    specific information.  The valid arguments are to ?      *    MFBInfo are defined in mfb.h.  If an invalid argument &      *    is used, MFBInfo returns -1.      */o     switch(Info){  	case  MAXX: 	    return(MFBCurrent->maxX); 	case  MAXY: 	    return(MFBCurrent->maxY); 	case  MAXCOLORS:# 	    return(MFBCurrent->maxColors);_ 	case  MAXINTENSITY:& 	    return(MFBCurrent->maxIntensity); 	case  MAXFILLPATTERNS:) 	    return(MFBCurrent->maxFillPatterns); 	case  MAXLINESTYLES:7' 	    return(MFBCurrent->maxLineStyles);| 	case  MAXBLINKERS:% 	    return(MFBCurrent->maxBlinkers); 	case  POINTINGDEVICE:1 	    return((int)MFBCurrent->PointingDeviceBool);  	case  POINTINGBUTTONS: * 	    return((int)MFBCurrent->buttonsBool); 	case  NUMBUTTONS:) 	    return(MFBCurrent->numberOfButtons); 	case  BUTTON1:7' 	    return(MFBCurrent->buttonMask[0]); 	case  BUTTON2:' 	    return(MFBCurrent->buttonMask[1]); 	case  BUTTON3:' 	    return(MFBCurrent->buttonMask[2]);  	case  BUTTON4: ' 	    return(MFBCurrent->buttonMask[3]);  	case  BUTTON5: ' 	    return(MFBCurrent->buttonMask[4]);_ 	case  BUTTON6: ' 	    return(MFBCurrent->buttonMask[5]);4 	case  BUTTON7:4' 	    return(MFBCurrent->buttonMask[6]);  	case  BUTTON8:w' 	    return(MFBCurrent->buttonMask[7]);7 	case  BUTTON9:o' 	    return(MFBCurrent->buttonMask[8]);w 	case  BUTTON10:' 	    return(MFBCurrent->buttonMask[9]);l 	case  BUTTON11:( 	    return(MFBCurrent->buttonMask[10]); 	case  BUTTON12:( 	    return(MFBCurrent->buttonMask[11]); 	case  TEXTPOSITIONALBE:3 	    return((int)MFBCurrent->textPositionableBool);n 	case  TEXTROTATABLE:r- 	    return((int)MFBCurrent->textRotateBool);o 	case  FONTHEIGHT:$ 	    return(MFBCurrent->fontHeight); 	case  FONTWIDTH:_# 	    return(MFBCurrent->fontWidth); 	case  FONTXOFFSET:_% 	    return(MFBCurrent->fontXOffset);_ 	case  FONTYOFFSET: % 	    return(MFBCurrent->fontYOffset);  	case  DESTRUCTIVETEXT: . 	    return((int)MFBCurrent->replaceTextBool); 	case  OVERSTRIKETEXT:1 	    return((int)MFBCurrent->overstrikeTextBool);  	case  VLT: & 	    return((int)MFBCurrent->vltBool); 	case  BLINKERS:+ 	    return((int)MFBCurrent->blinkersBool); 	case  FILLEDPOLYGONS:. 	    return((int)MFBCurrent->filledPlygnBool); 	case  DEFFILLPATTERNS: 1 	    return((int)MFBCurrent->fillPtrnDefineBool);  	case  DEFREADMASK:F+ 	    return((int)MFBCurrent->readMaskBool);  	case  DEFCHANNELMASK:. 	    return((int)MFBCurrent->channelMaskBool); 	case  DEFLINEPATTERN:4 	    return((int)MFBCurrent->linePatternDefineBool); 	case  CURFGCOLOR:# 	    return(MFBCurrent->fgColorId);  	case  CURFILLPATTERN:% 	    return(MFBCurrent->fillPattern);e 	case  CURLINESTYLE:# 	    return(MFBCurrent->lineStyle);n 	case  CURCHANNELMASK:% 	    return(MFBCurrent->channelMask);  	case  CURREADMASK: " 	    return(MFBCurrent->readMask); 	case  NUMBITPLANES:% 	    return(MFBCurrent->lengthOfVLT);  	case  RASTERCOPY:+ 	    return((int)MFBCurrent->rastCopyBool);i 	case  OFFSCREENX:' 	    return(MFBCurrent->minOffScreenX);  	case  OFFSCREENY:' 	    return(MFBCurrent->minOffScreenY);r 	case  OFFSCREENDX:n% 	    return(MFBCurrent->offScreenDX);t 	case  OFFSCREENDY:f% 	    return(MFBCurrent->offScreenDY);a	 	default:F 	    return(-1); 	}     }e     void MFBConvertToHLS(r,g,b)     int r,g,b;     /*
      * Notes:f7      *    The HLS values are returned in MFBCurrent->Y,t+      *    MFBCurrent->Z, and MFBCurrent->T.t      */r     {u<     double rrr,ggg,bbb,rr,gg,bb,sum,dif,mx,mn,lit,intensity;1     intensity = (double)MFBCurrent->maxIntensity;e#     /* RGB is normalized to 1000 */      rr = ((double) r)/1000.0;n     gg = ((double) g)/1000.0;      bb = ((double) b)/1000.0;k     mx = rr;     if(mx < gg) mx = gg;     if(mx < bb) mx = bb;     mn = rr;     if(mn > gg) mn = gg;     if(mn > bb) mn = bb;!     sum = mx + mn; dif = mx - mn;t     if(dif != 0.0){cF         rrr = (mx - rr)/dif; ggg = (mx - gg)/dif; bbb = (mx - bb)/dif;	         }t     /* lightness calculation */      lit = sum/2.0;      /* saturation calculation */#     if(mx == mn) MFBCurrent->T = 0;rB     else if(lit <= .5) MFBCurrent->T = (int)(intensity * dif/sum);>     else MFBCurrent->T = (int)((intensity * dif)/(2.0 - sum));     /* hue calculation */e-     if(MFBCurrent->T == 0) MFBCurrent->Y = 0;rF     else if(rr == mx) MFBCurrent->Y = (int)(60.0 * (2.0 + bbb - ggg));F     else if(gg == mx) MFBCurrent->Y = (int)(60.0 * (4.0 + rrr - bbb));9     else MFBCurrent->Y = (int)(60.0 * (6.0 + ggg - rrr));n+     MFBCurrent->Z = (int)(intensity * lit);      }t     void SetCurrentMFB(mfb)
     MFB *mfb;c     /*
      * Notes:(G      *    Set the current frame buffer.  Since each MFB struct contains-B      *    all necessary I/O information, it is possible for a hostF      *    program to manipulate several different graphics displays by:      *    simply maintaining a MFB struct for each device.      */B     {-     MFBCurrent = mfb;      }N     void MFBZeroCounters() {u #ifdef DEBUG"     if(MFBCurrent == NULL) return;+     MFBCurrent->nChars = MFBCurrent->nBoxese* 	= MFBCurrent->nLines = MFBCurrent->nChars: 	= MFBCurrent->sumBoxArea = MFBCurrent->sumLineLength = 0; #endif     }a     voidD MFBCounters(nChars,nBoxes,meanBoxArea,nLines,meanLineLength,nPixels)F     int *nChars,*nBoxes,*meanBoxArea,*nLines,*meanLineLength,*nPixels;     {  #ifdef DEBUG     /*8      * routine for measuring approximate pixel bandwidth      */)!     *nChars = MFBCurrent->nChars;(!     *nBoxes = MFBCurrent->nBoxes;c!     *nLines = MFBCurrent->nLines;r     *meanLineLength = 0;     *meanBoxArea = 0;r     if(MFBCurrent->nBoxes != 0)r: 	*meanBoxArea = MFBCurrent->sumBoxArea/MFBCurrent->nBoxes;     if(MFBCurrent->nLines != 0)t@ 	*meanLineLength = MFBCurrent->sumLineLength/MFBCurrent->nLines;     *nPixels =  A 	MFBCurrent->nChars*MFBCurrent->fontHeight*MFBCurrent->fontWidth+  	MFBCurrent->sumBoxArea+ 	MFBCurrent->sumLineLength;a #elseoE     *nChars = *nBoxes = *nLines = *meanLineLength = *meanBoxArea = 0;o #endif     }           N /*****************************************************************************  *  *	    SET VIEWPORT ATTRIBUTES  *O  *****************************************************************************/F   MFBSetLineStyle(styleId)     int styleId;     /*
      * Notes:*"      *    Sets current line style.>      *    Return immediately if line style is already current.6      *    Return MFBBADLST if styleId is out of range.      */      {F     /*9      * Check if styleId is already the current line style*      */fM     if(styleId == MFBCurrent->lineStyle && !MFBCurrent->reissueLineStyleBool)e 	return(MFBOK);a;     if(styleId < 0 || styleId >= MFBCurrent->maxLineStyles)d 	/* bad styleId */ 	return(MFBBADLST);t
     else {1 	MFBCurrent->X = MFBCurrent->lineStyle = styleId;r7 	if(styleId == 0 && MFBFORMAT.setSolidLineStyle != NULLt- 	    && *MFBFORMAT.setSolidLineStyle != NULL)r- 	    MFBGenCode(MFBFORMAT.setSolidLineStyle);r 	elseF( 	    MFBGenCode(MFBFORMAT.setLineStyle); 	}     return(MFBOK);     }t     MFBSetFillPattern(styleId)     int styleId;     /*
      * Notes:L$      *    Sets current fill pattern.      *G      *    CURRENT COLOR MUST BE SET PRIOR TO SETTING FILL STYLE!!!!!!!!BB      *    Some frame buffers allow multi-colored stipple patterns.<      *    MFB sets all pixels in the bit array to either theC      *    background color (ID = 0) or the current forground color.n      */      {        /*9      * Check if styleId is already the current fill styleg      */,*     if(styleId == MFBCurrent->fillPattern) 	return(MFBOK);F=     if(styleId < 0 || styleId >= MFBCurrent->maxFillPatterns)  	/* bad styleId */ 	return(MFBBADFST);(
     else {3 	MFBCurrent->X = MFBCurrent->fillPattern = styleId;;9 	if(styleId == 0 && MFBFORMAT.setSolidFillPattern != NULLn/ 	    && *MFBFORMAT.setSolidFillPattern != NULL) / 	    MFBGenCode(MFBFORMAT.setSolidFillPattern);r 	elsei* 	    MFBGenCode(MFBFORMAT.setFillPattern); 	}     return(MFBOK);     }(     into MFBSetChannelMask(channelMask)     int channelMask;     /*
      * Notes:LE      *    Sets write enable mask.  This is relevant only to terminals*(      *    which have write enable masks.      */o     {   &     /* Is channel mask already set? */.     if(channelMask == MFBCurrent->channelMask) 	return(MFBOK);e2     /* Are there channel or write-enable masks? */$     if(!MFBCurrent->channelMaskBool) 	return(MFBNOMASK);n	     else{e7 	MFBCurrent->X = MFBCurrent->channelMask = channelMask;n& 	MFBGenCode(MFBFORMAT.channelMaskSet); 	}     return(MFBOK);     }*     int* MFBSetReadMask(readMask)     int readMask;*     /*
      * Notes:VE      *    Sets write enable mask.  This is relevant only to terminals*(      *    which have write enable masks.      */(     {)  &     /* Is channel mask already set? */(     if(readMask == MFBCurrent->readMask) 	return(MFBOK);d2     /* Are there channel or write-enable masks? */!     if(!MFBCurrent->readMaskBool)o 	return(MFBNOMASK); 	     else{*1 	MFBCurrent->X = MFBCurrent->readMask = readMask;n# 	MFBGenCode(MFBFORMAT.readMaskSet);  	}     return(MFBOK);     }r     ints MFBSetColor(colorId)     int colorId;     /*
      * Notes:l;      *    Sets the current (foreground) color to `colorId'.r      */S     {        /*7      * Check if styleId is already the foreground colort      */07     if(colorId == MFBCurrent->fgColorId) return(MFBOK);M  7     if(colorId < 0 || colorId >= MFBCurrent->maxColors)e 	/* bad colorId */ 	return(MFBBADCST);d
     else {1 	MFBCurrent->X = MFBCurrent->fgColorId = colorId; * 	MFBGenCode(MFBFORMAT.setForegroundColor); 	}     return(MFBOK);     }*     intc MFBSetTextMode(destructiveBool)      Bool destructiveBool;      /*
      * Notes:L6      *    Changes mode of displaying text if possible.8      *    If destructiveBool is true,the the destructive;      *    text mode is set.  Also,the text index is changed(      *    to colorId.f      */c     { 6     if(MFBCurrent->textMode != (int)destructiveBool) { 	if(destructiveBool){ % 	    if(!MFBCurrent->replaceTextBool)C 		return(MFBBADTM1);% 	    MFBGenCode(MFBFORMAT.replaceON);  	    } 	else{( 	    if(!MFBCurrent->overstrikeTextBool) 		return(MFBBADTM2);( 	    MFBGenCode(MFBFORMAT.overstrikeON); 	    }- 	MFBCurrent->textMode = (int)destructiveBool;A 	}     return(MFBOK);     }      intM MFBSetALUMode(mode)P
     int mode;      /*
      * Notes:RE      *    This routine changes the mode by which pixels on the screen;F      *    are changed when written over.  The four possible operations      *    are:+      *		mode = MFBALUJAM	JAM (replace mode)l      *		mode = MFBALUOR 	ORB      *		mode = MFBALUNOR	NOR      *		mode = MFBALUEOR	EORL      *    If MFB cannot set the ALU mode, MFBBADALU is returned.  Otherwise,      *    MFBOK is returned.      */      {M
     char *cp;      switch(mode){0         case MFBALUJAM:  	    cp = MFBFORMAT.setALUJAM; 	    break;)         case MFBALUOR: 	    cp = MFBFORMAT.setALUOR;( 	    break;b         case MFBALUNOR:- 	    cp = MFBFORMAT.setALUNOR; 	    break;F         case MFBALUEOR:s 	    cp = MFBFORMAT.setALUEOR; 	    break;(         default: 	    cp = NULL;* 	}!     if(cp == NULL || *cp == NULL)m         return(MFBBADALU);     MFBGenCode(cp);*     return(MFBOK);     }m     int $ MFBSetCursorColor(colorId1,colorId2)     int colorId1,colorId2;     /*
      * Notes:yI      *    The cursor color is set when the pointing device is initialized       */      {r*     MFBCurrent->cursorColor1Id = colorId1;*     MFBCurrent->cursorColor2Id = colorId2;     return(MFBOK);     }e     ints# MFBSetBlinker(colorId,r,g,b,onFlag)-     int colorId,r,g,b,onFlag;=     /*
      * Notes: )      *    Turn ON or OF a blinking color.       */      {F!     if(!MFBCurrent->blinkersBool), 	return(MFBNOBLNK);,       MFBCurrent->X = colorId;"     if(MFBCurrent->vltUseHLSBool){ 	MFBConvertToHLS(r,g,b); 	}	     else{*         /* Normalize to 1000 */ <         MFBCurrent->Y = r * MFBCurrent->maxIntensity / 1000;<         MFBCurrent->Z = g * MFBCurrent->maxIntensity / 1000;<         MFBCurrent->T = b * MFBCurrent->maxIntensity / 1000; 	}       if(onFlag == ON) {! 	MFBGenCode(MFBFORMAT.blinkerON);e 	++MFBCurrent->numBlinkers;o 	}
     else {" 	MFBGenCode(MFBFORMAT.blinkerOFF); 	--MFBCurrent->numBlinkers;e 	}:     if(MFBCurrent->numBlinkers >= MFBCurrent->maxBlinkers) 	return(MFBTMBLNK);/     return(MFBOK);     }e     int * MFBSetRubberBanding(RubberBandingBool,X,Y)     Bool RubberBandingBool;t     int X,Y;     /*
      * Notes: :      *    Turn ON or OFF rubberbanding of pointing device.F      *    The center of the rubberbanding is assumed to be the currentF      *    graphics position,but may be kludged in the enable sequence.      */r     {N-     if(MFBFORMAT.enableRubberBanding == NULL c+ 	|| *MFBFORMAT.enableRubberBanding == NULL)  	return(MFBNORBND);(     if(RubberBandingBool){ 	MFBCurrent->X = X;  	MFBCurrent->Y = Y;c' 	MFBGenCode(MFBFORMAT.movePenSequence);r+ 	MFBGenCode(MFBFORMAT.enableRubberBanding);. 	}     else, 	MFBGenCode(MFBFORMAT.disableRubberBanding);     return(MFBOK);     }o            N /*****************************************************************************  *!  *	    DEFINE VIEWPORT ATTRIBUTES   *O  *****************************************************************************/    int  MFBDefineColor(colorId,r,g,b)      int colorId,r,g,b;     /*
      * Notes:e@      *    Defines an entry in the VLT contained in the terminal.D      *    r,g, and b are the red, green, blue intensities normalized      *    to 1000.      */      {   +     /* Are there user defineable colors? */;     if(!MFBCurrent->vltBool) 	return(MFBNODFCO); "     if(MFBCurrent->vltUseHLSBool){@ 	/* HLS return in MFBCurrent->Y, MFBCurrent->Z, MFBCurrent->T */ 	MFBConvertToHLS(r,g,b); 	}	     else{o         /* Normalize to 1000 */o<         MFBCurrent->Y = r * MFBCurrent->maxIntensity / 1000;<         MFBCurrent->Z = g * MFBCurrent->maxIntensity / 1000;<         MFBCurrent->T = b * MFBCurrent->maxIntensity / 1000; 	}D     MFBCurrent->X = MFBmax(0,MFBmin(MFBCurrent->maxColors,colorId));#     MFBGenCode(MFBFORMAT.vltEntry);      return(MFBOK);     }g     int*& MFBDefineFillPattern(styleId,BitArray)     int styleId;     int *BitArray;     /*      *  Notes:3      *    A very difficult procedure to generalize.>C      *    BitArray is a pointer to 8 integers for which the 8 leastgA      *    significant bits represent one row in the fill pattern.C      */      {F     int i,*j,Count;y  &     /* save current stipple pattern */     for(i=0; i<8; ++i)- 	MFBCurrent->stipplePattern[i] = BitArray[i];a       /*@      * Are there defineable fill patterns for this frame buffer?      */ (     if(!MFBCurrent->fillPtrnDefineBool)  	return(MFBNODFFP);R       MFBCurrent->X = styleId;*     if(MFBCurrent->fillDefineRowMajorBool)& 	Count = MFBCurrent->fillDefineHeight;     else% 	Count = MFBCurrent->fillDefineWidth;B*     MFBGenCode(MFBFORMAT.fillDefineStart);     for(i=0; i<Count; ++i){n) 	if( (int)((i/8) * 8) == i) j = BitArray;A 	MFBCurrent->Y = *j++;( 	MFBGenCode(MFBFORMAT.fillDefineFormat); 	}(     MFBGenCode(MFBFORMAT.fillDefineEnd);=     /* return with the new fill pattern as the current one */r)     return( MFBSetFillPattern(styleId) );      }i     int $ MFBDefineLineStyle(styleId,BitArray)     int styleId;     int BitArray;r     { 
     int l;       /*>      * Are there defineable line styles for this frame buffer?      */ *     if(!MFBCurrent->linePatternDefineBool) 	return(MFBNODFLP);e       MFBCurrent->X = styleId;*     MFBGenCode(MFBFORMAT.lineDefineStart);     MFBCurrent->Y = BitArray;n5     for(l = 0; l < MFBCurrent->lineDefineLength; ++l)n( 	MFBGenCode(MFBFORMAT.lineDefineFormat);(     MFBGenCode(MFBFORMAT.lineDefineEnd);;     /* return with the new line style as the current one */l'     return( MFBSetLineStyle(styleId) );      }             N /*****************************************************************************  *   *	    BASIC VIEWPORT GEOMETRIES  *O  *****************************************************************************/r  G int LastX, LastY;	/* used for terminals which have no drawLineToSeq. */    void MFBMoveTo(X1,Y1)     int X1,Y1;     /*
      * Notes:c2      *    Move current graphics position to X1,Y1.      */      {iC     /* the assignment of lastX/Y is redundant for a Tek terminal */s;     LastX = MFBCurrent->X = X1; LastY = MFBCurrent->Y = Y1; *     MFBGenCode(MFBFORMAT.movePenSequence);     }n     void MFBDrawPath(path)n     MFBPATH *path;     /*
      * Notes:tC      *    Draw the Path defined in "path" in the current linestyle. B      *    Without a 'DrawSolidLineToSequence',we must call MFBLineC      *    for the first segment to be certain that the linestyle is.      *    properly set.f      */T     {R     int n,x,y;(     if(MFBCurrent->reissueLineStyleBool)( 	MFBSetLineStyle(MFBCurrent->lineStyle);     if(path->nvertices < 2)n 	return;
     n = 2;=     MFBLine(path->xy[0],path->xy[1],path->xy[2],path->xy[3]);n     while(n < path->nvertices){r 	x = path->xy[(n << 1)]; 	y = path->xy[(n << 1) + 1]; 	MFBDrawLineTo(x,y); 	n++;r 	}     }      void MFBDrawLineTo(X1,Y1)     int X1,Y1;     /*
      * Notes:??      *    Draws a line in the current color and line style fromN.      *    the last graphics position to X1,Y1.      */n     {D(     if(MFBCurrent->reissueLineStyleBool)( 	MFBSetLineStyle(MFBCurrent->lineStyle);+     if(MFBFORMAT.drawLineToSequence == NULLO+ 	|| *MFBFORMAT.drawLineToSequence == NULL){  	MFBLine(LastX,LastY,X1,Y1);@ 	/* the assignment of lastX/Y is redundant for a Tek terminal */ 	LastX = X1; LastY = Y1; 	}	     else{M( 	MFBCurrent->X = X1; MFBCurrent->Y = Y1; 	if(MFBCurrent->lineStyle == 01 	    && MFBFORMAT.drawSolidLineToSequence != NULLI3 	    && *MFBFORMAT.drawSolidLineToSequence != NULL)B3 	    MFBGenCode(MFBFORMAT.drawSolidLineToSequence);  	elsen. 	    MFBGenCode(MFBFORMAT.drawLineToSequence); 	}     }      void MFBLine(X1,Y1,X2,Y2)     int X1,Y1,X2,Y2;     /*
      * Notes:tE      *    Draws a line in the current color and line style from X1,Y1M      *    to X2,Y2.       */r     {  #ifdef DEBUG     MFBCurrent->nLines += 1;?     MFBCurrent->sumLineLength += MFBmax(abs(X1-X2),abs(Y1-Y2));; #endif(     if(MFBCurrent->reissueLineStyleBool)( 	MFBSetLineStyle(MFBCurrent->lineStyle);+     MFBCurrent->X = X1; MFBCurrent->Y = Y1;l+     MFBCurrent->Z = X2; MFBCurrent->T = Y2;*L     if(MFBCurrent->lineStyle == 0 && MFBFORMAT.drawSolidLineSequence != NULL- 	&& *MFBFORMAT.drawSolidLineSequence != NULL)*- 	MFBGenCode(MFBFORMAT.drawSolidLineSequence);*     else( 	MFBGenCode(MFBFORMAT.drawLineSequence);     LastX = X2; LastY = Y2;e     }      void MFBBox(l,b,r,t)      int l,b,r,t;     /*
      * Notes: A      *    Draws a box in the current fill pattern from lower left :      *    corner (l,b) to upper right corner (r,t).  After2      *    this sequence,pen must be left at (r,t).      */      {  #ifdef DEBUG     MFBCurrent->nBoxes += 1;*     MFBCurrent->sumBoxArea += (r-l)*(t-b); #endifO     MFBCurrent->X = l; MFBCurrent->Y = b; MFBCurrent->Z = r; MFBCurrent->T = t;r#     if(MFBCurrent->fillPattern == 0 * 	&& MFBFORMAT.drawSolidBoxSequence != NULL- 	&& *MFBFORMAT.drawSolidBoxSequence != NULL){i, 	MFBGenCode(MFBFORMAT.drawSolidBoxSequence); 	}-     else if(MFBFORMAT.drawBoxSequence != NULLu( 	&& *MFBFORMAT.drawBoxSequence != NULL){' 	MFBGenCode(MFBFORMAT.drawBoxSequence);- 	}     else 	MFBNaiveBoxFill(l,b,r,t);     }      void MFBArc(x,y,r,astart,astop,s)+     int x;	    /* x coordinate of center */.+     int y;	    /* y coordinate of center */R"     int r;	    /* radius of arc */A     int astart;       /* initial angle ( +x axis = 0 degrees ) */*8     int astop;	/* final angle ( +x axis = 0 degrees ) */;     int s;	    /* number of segments in a 360 degree arc */*     /*
      * Notes:*C      *    Draws an arc of radius r and center at (x,y) beginning at,7      *    angle astart (in degrees) and ending at astopy      */L     {i     int i,j,xx,yy;     double d,sin(),cos();t     d = astart / RadToDeg;     xx = x + (int)(r * cos(d));.     yy = y + (int)(r * sin(d));tG     /* Must use MFBLine to force a DSL sequence if style Id is solid */F     MFBLine(xx,yy,xx,yy);n     while(astart >= astop) 	astop += 360;     if(s>2 && s<181)" 	j = MFBmax(1,(astop - astart)/s);     else# 	j = MFBmax(1,(astop - astart)/18);t,     for(i = astart + j; i <= astop; i += j){ 	d = i / RadToDeg;' 	MFBCurrent->X = x + (int)(r * cos(d));r' 	MFBCurrent->Y = y + (int)(r * sin(d));r* 	MFBGenCode(MFBFORMAT.drawLineToSequence); 	}     d = astop / RadToDeg;m*     MFBCurrent->X = x + (int)(r * cos(d));*     MFBCurrent->Y = y + (int)(r * sin(d));-     MFBGenCode(MFBFORMAT.drawLineToSequence);P     }s     void MFBCircle(x,y,r,s)'     int x;	/* x coordinate of center */ '     int y;	/* y coordinate of center */u!     int r;	/* radius of circle */rA     int s;	/* number of line segments in circle (default = 72) */n     /*
      * Notes:L?      *    Draws a circle of radius r and center at (x,y) in the(      *    current line style.t      */<     {      int i,j=5;     double d=0,sin(),cos();x,     if(MFBFORMAT.drawCircleSequence == NULL + 	|| *MFBFORMAT.drawCircleSequence == NULL){t 	MFBCurrent->X = x + r;i 	MFBCurrent->Y = y;o 	if(s>2 && s<181)o 	    j = MFBmax(1,360/s);h 	for(i = j; i <= 360; i += j){ 	    d = i / RadToDeg;+ 	    MFBCurrent->Z = x + (int)(r * cos(d));M+ 	    MFBCurrent->T = y + (int)(r * sin(d));B, 	    MFBGenCode(MFBFORMAT.drawLineSequence);# 	    MFBCurrent->X = MFBCurrent->Z;f# 	    MFBCurrent->Y = MFBCurrent->T;Y 	    } 	}
     else { 	MFBCurrent->X = x;  	MFBCurrent->Y = y;l 	MFBCurrent->Z = r;F* 	MFBGenCode(MFBFORMAT.drawCircleSequence); 	}     }a     void MFBFlash(x,y,r,s)      int x,y,r,s;     /*
      * Notes:eC      *    Draws a roundflash of radius r and center at (x,y) in theT      *    current fill style.B      */F     {.     int i=0,j;     double d=0,sin(),cos();x     MFBCurrent->X = x + r;     MFBCurrent->Y = y;     if(s>2 && s<181) 	j = 360/s;r
     else { 	j = 5;  	s = 72; 	}     MFBCurrent->Z = s;-     MFBGenCode(MFBFORMAT.beginPlygnSequence);       for(i = j; i < 360; i += j){ 	d = i / RadToDeg;' 	MFBCurrent->X = x + (int)(r * cos(d)); ' 	MFBCurrent->Y = y + (int)(r * sin(d));/' 	MFBGenCode(MFBFORMAT.sendPlygnVertex);* 	}     MFBCurrent->X = x + r;     MFBCurrent->Y = y;+     MFBGenCode(MFBFORMAT.endPlygnSequence);      }n     void
 MFBPolygon(p)n     MFBPOLYGON *p;     /*
      * Notes:nF      *    Draws a polygon with n vertices in the current fill pattern.      */+     {r     int *xy0,*xy1,n;     xy0 = xy1 = p->xy;%     MFBCurrent->Z = n = p->nvertices;L     if(n <= 0) return;     MFBCurrent->X = *xy1++;,     MFBCurrent->Y = *xy1++; &     if(MFBCurrent->fillPattern == 0 &&- 	MFBFORMAT.beginSolidPlygnSequence != NULL &&l, 	*MFBFORMAT.beginSolidPlygnSequence != NULL)/ 	MFBGenCode(MFBFORMAT.beginSolidPlygnSequence);/     else* 	MFBGenCode(MFBFORMAT.beginPlygnSequence);     n--;     while(n--) { 	MFBCurrent->X = *xy1++; 	MFBCurrent->Y = *xy1++;' 	MFBGenCode(MFBFORMAT.sendPlygnVertex);  	}     MFBCurrent->X = *xy0;o     MFBCurrent->Y = *(xy0+1); +     MFBGenCode(MFBFORMAT.endPlygnSequence);d     }T     void MFBText(text,x,y,phi)F     char *text;      int x,y;2     int phi;    /* angle of rotation in degrees */     /*
      * Notes:nE      *    Draws the string `text' in the current color with the lowerc      *    left corner at (x,y).       */t     {      char *c;      #ifdef DEBUG'     MFBCurrent->nChars += strlen(text);u #endif;     if((phi != 0) && (MFBCurrent->textRotateBool == true)){s 	MFBCurrent->X = phi;B* 	MFBGenCode(MFBFORMAT.rotateTextSequence); 	}  &     /* Move to (x + GTW),(Y + GTH). */0     MFBCurrent->X = x + MFBCurrent->fontXOffset;0     MFBCurrent->Y = y + MFBCurrent->fontYOffset;  &     /* Get ready for graphics text. */
     c = text;n     MFBCurrent->Z = 0;*     while(*c++ != NULL) (MFBCurrent->Z)++;  ,     MFBGenCode(MFBFORMAT.graphicsTextStart);       /* Output the text. */%     while(*text) MFBPutchar(*text++);s  "     /* Finish the graphics text */*     MFBGenCode(MFBFORMAT.graphicsTextEnd);  "     /* rotate text back to zero */;     if((phi != 0) && (MFBCurrent->textRotateBool == true)){F 	MFBCurrent->X = 0;T* 	MFBGenCode(MFBFORMAT.rotateTextSequence); 	}     }e     void
 MFBPixel(x,y)B     int x,y;     /*
      * Notes:eC      *    Sets the indicated pixel to the current foreground color.       */      {F)     MFBCurrent->X = x; MFBCurrent->Y = y; %     MFBGenCode(MFBFORMAT.writePixel);      }      void
 MFBFlood()     /*
      * Notes: A      *    Floods the display with the current (foreground) color.t      */+     { *     MFBCurrent->X = MFBCurrent->fgColorId;&     MFBGenCode(MFBFORMAT.screenFlood);       /*9      * MFBFlood may destroy last x/y,so be safe about it.;      */C1     MFBCurrent->lastX  = MFBCurrent->lastY  = -1;t     }2     MFBPATH>! *MFBArcPath(x,y,r,astart,astop,s)y+     int x;	    /* x coordinate of center */ +     int y;	    /* y coordinate of center */ "     int r;	    /* radius of arc */A     int astart;       /* initial angle ( +x axis = 0 degrees ) */e8     int astop;	/* final angle ( +x axis = 0 degrees ) */;     int s;	    /* number of segments in a 360 degree arc */      /*
      * Notes:r,      *    Returns MFBPATH containing an arc.      */,     {p     static MFBPATH pth;A     static int xy[400];e     int *ip,i,j;     double d,sin(),cos();      pth.xy = ip = xy;B     while(astart >= astop) 	astop += 360;     if(s<2 || s>180) 	s = 20;     pth.nvertices = 2;%     j = MFBmax(1,(astop - astart)/s);M     d = astart / RadToDeg;"     *ip++ = x + (int)(r * cos(d));"     *ip++ = y + (int)(r * sin(d));,     for(i = astart + j; i <= astop; i += j){ 	d = i / RadToDeg; 	*ip++ = x + (int)(r * cos(d));  	*ip++ = y + (int)(r * sin(d));a 	++pth.nvertices;i 	}     d = astop / RadToDeg;s"     *ip++ = x + (int)(r * cos(d));"     *ip   = y + (int)(r * sin(d));     return(&pth);      }     
 MFBPOLYGON *MFBEllipse(x,y,rx,ry,s)'     int x;	/* x coordinate of center */ '     int y;	/* y coordinate of center */o2     int rx;	/* radius of ellipse in x direction */2     int ry;	/* radius of ellipse in y direction */A     int s;	/* number of line segments in circle (default = 20) */O     /*
      * Notes:>P      *    Returns MFBPOLYGON containing an ellipse with no more than 200 coords.      */      {C     static MFBPOLYGON poly;+     static int xy[400];+     int i=0;
     int j;     int *ip;     double d=0,sin(),cos();h     poly.xy = ip = xy;     *ip++ = x + rx;+     *ip++ = y;     if(s>2 && s<181) 	j = 360/s;G
     else { 	j = 18; 	s = 20; 	}     poly.nvertices = s + 1;z     while(--s) { 	i += j; 	d = i / RadToDeg;  	*ip++ = x + (int)(rx * cos(d));  	*ip++ = y + (int)(ry * sin(d)); 	}     *ip++ = x + rx;      *ip++ = y;     return(&poly);     };            I /***********************************************************************/c /* /*			 WINDOW CONTROL /*I /***********************************************************************/)  & #define	WNDW	MFBCurrent->currentWindow) #define	VWPRT	MFBCurrent->currentViewporty   inth MFBScaleX(X)
     int X;     {      int XX; N     XX = (int)(((double)(X-WNDW.left)*VWPRT.length)/WNDW.length) + VWPRT.left;(     if(XX < VWPRT.left) XX = VWPRT.left;0     else if(XX > VWPRT.right) XX = VWPRT.right;      return(XX);=     }r   ints MFBScaleY(Y)
     int Y;     {      int YY;,P     YY = (int)(((double)(Y-WNDW.bottom)*VWPRT.width)/WNDW.width) + VWPRT.bottom;,     if(YY < VWPRT.bottom) YY = VWPRT.bottom;+     else if(YY > VWPRT.top) YY = VWPRT.top;*     return(YY);+     }=   inte MFBDescaleX(X)
     int X;     {n     int XX; =     XX = ((X-VWPRT.left)*WNDW.length)/VWPRT.length+WNDW.left;      return(XX);      }    intt MFBDescaleY(Y)
     int Y;     {t     int YY;.  ?     YY = ((Y-VWPRT.bottom)*WNDW.width)/VWPRT.width+WNDW.bottom;]     return(YY);,     }    void% MFBSetViewport(left,bottom,right,top)      int left,bottom,right,top;     {6     VWPRT.bottom = bottom;     VWPRT.top = top;     VWPRT.left = left;     VWPRT.right = right;,     VWPRT.length = VWPRT.right - VWPRT.left;+     VWPRT.width = VWPRT.top - VWPRT.bottom;i     }    void# MFBSetWindow(left,bottom,right,top)      int left,bottom,right,top;     {r     WNDW.bottom = bottom;(     WNDW.top = top;+     WNDW.left = left;      WNDW.right = right; )     WNDW.length = WNDW.right - WNDW.left; (     WNDW.width = WNDW.top - WNDW.bottom;     }   