 /*  * mfbcaps.c  *'  * Copyright -C- 1982 Giles Billingsleys%  * sccsid "@(#)mfbcaps.c	1.9  9/3/83"c  *E  *     MFB is a graphics package that was developed by the integrated @  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atD  * the University of California, Berkeley, California.  The programs?  * in MFB are available free of charge to any interested party. C  * The sale, resale, or use of these program for profit without thetF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,i  * is forbidden.  */r      = #define MAXHOP      5    /* max number of MCE=indirections */aD #define BADNUM      0    /* illegal number for numeric capability */   #include "mfb.h" #include <ctype.h>     /*G  * mfbcap - routines for dealing with the terminal capability data base (  *        mfbcap routines must be loaded  *A  * Essentially all the work here is scanning and decoding escapestA  * in string capabilities.  We don't use stdio because the editori2  * doesn't, and because living w/o it is not hard.  */    static char *mfb_buf; H static int hopcount;       /* detect infinite loops in mfbcap, init 0 */   FILE   *POpen(); char   *strcpy(); char   *MFBSkip(); char   *MFBGetStr(); char   *MFBCapDecod(); int    MFBGetNum();  int    MFBGetFlag(); int    MFBGetEnt();T int    MFBCheckForMCE();     /*/  * Get an entry for terminal name in buffer bp,r4  * from the mfbcap file.  Parse is very rudimentary;#  * we just notice escaped newlines.C  */P intm MFBGetEnt(bp, name, mfbcapFile)b
     char *bp;t     char *name;c     char *mfbcapFile;      {e     register char *cp;     register int c;n      register int i = 0, cnt = 0;     register int NewLine;e     char inputBuffer[BUFSIZE];     FILE *CapFile;     int mfbcapDesc;h       mfb_buf = bp;eO     if((CapFile = POpen(mfbcapFile, "r", (char *)NULL, (char **)NULL)) == NULL)o         return(MFBBADMCF);!     mfbcapDesc = fileno(CapFile);d       /*>      * It should be faster to read mfbcap by 4Kbytes at a time      */      for(;;){
 	NewLine = 0;S         cp = bp;         for(;;){             if(i >= cnt){ =                 cnt = read(mfbcapDesc, inputBuffer, BUFSIZE);/)                 if(cnt <= 0 && !NewLine){ -                     if(close(mfbcapDesc) < 0)N 			return(MFBBADMCF); &                     return(MFBBADENT);                     }u                 i = 0;                 } !             c = inputBuffer[i++];d   	    /*e1 	     * Check for continuation from previous linep 	     */* 	    if(NewLine && c != ' ' && c != '\t'){ 		--i; 		break; 		}m 	    /*A 	     * Check for new line 	     */ 	    NewLine = 0;  	    if(c == '\n'){s 		NewLine = 1; 		continue;y 		}l 	    /*a 	     * Check for line too long  	     */(             else if(cp >= bp + BUFSIZE){ 		return(MFBMCELNG);                 }e             else                 *cp++ = c;
             }m         *cp = 0;  
         /*'          * The real work for the match.l          */t         if(mfbnamatch(name)){x%             if(close(mfbcapDesc) < 0) 		return(MFBBADMCF);1             return( MFBCheckForMCE(mfbcapFile) );M
             } 	         }e     }h     /*6  * check the last entry, see if it's MCE=xxxxx. If so,A  * recursively find xxxxx and append that entry (minus the names)e?  * to take the place of the MCE=xxxxx entry. This allows mfbcapr;  * entries to say "like an AED but with a graphics tablet".r:  * Note that this works because of the left to right scan.  */c intn MFBCheckForMCE(mfbcapFile)     char *mfbcapFile;      {c     register char *p, *q; I     char mfbname[16];                      /* name of similar terminal */n     char mfbbuf[BUFSIZE];e     char *holdgbuf = mfb_buf;e
     int l;  "     p = mfb_buf + strlen(mfb_buf);     for(l=0; l<2; ++l){b         while(*--p != ','){_             if(p < mfb_buf){"                 return(MFBBADMCE);                 }e 	    } 	}/     while(*p == ',' || *p == ' ' || *p == '\t')l         p++;  1     /* p now points to beginning of last field */ @     if(p[0] != 'M' || p[1] != 'C' || p[2] != 'E') return(MFBOK);     strcpy(mfbname,p+4);     q = mfbname;     while(q && *q != ',')          q++;     *q = 0;n     if(++hopcount > MAXHOP){         return(MFBINFMCE);	         }l8     if((l = MFBGetEnt(mfbbuf,mfbname,mfbcapFile)) != 1){         return(l);	         } #     for(q=mfbbuf; *q != ','; q++) ;p!     l = p - holdgbuf + strlen(q);A     if(l > BUFSIZE){%         q[BUFSIZE - (p-mfb_buf)] = 0;I         return(MFBMCELNG);	         }b     strcpy(p, q+1);*     mfb_buf = holdgbuf;e     return(MFBOK);     }      /*F  * mfbnamatch deals with name matching.  The first field of the mfbcap?  * entry is a sequence of names separated by |'s, so we comparenB  * against each such name.  The normal , terminator after the last*  * name (before the first field) stops us.  */  mfbnamatch(np)
     char *np;      {      register char *Np, *Bp;        Bp = mfb_buf;f!     if(*Bp == '#') return(FALSE);c     for(;;){=         for(Np = np; *Np && *Bp == *Np; Bp++, Np++) continue; >         if(*Np == 0 && (*Bp == '|' || *Bp == ',' || *Bp == 0))             return(TRUE); 4         while(*Bp && *Bp != ',' && *Bp != '|') Bp++;1         if(*Bp == 0 || *Bp == ',') return(FALSE);e
         Bp++; 	         }      }l       /*  * Skip to the next field.  */L
 static char *  MFBSkip(bp) 
     char *bp;      { 4     while(*bp && !(*bp == ',' && *(bp - 1) != '\\')) 	bp++;  #     /* Now clear the white space */t2     while(*bp == ',' || *bp == ' ' || *bp == '\t') 	bp++;     return(bp);a     }<       /*  * Handle a flag option.B  * Flag options are given "naked", i.e. followed by a , or the end@  * of the buffer.  Return 1 if we find the option, or 0 if it is
  * not given.c  */e MFBGetFlag(id)
     char *id;n     {n      register char *bp = mfb_buf;     register char *cp;     register int i;r       for(;;){         bp = MFBSkip(bp);          if(!*bp) return(0);h 	i = 0;o	 	cp = id;  	while(*cp != 0 && *bp != 0){c 	    if(*cp++ != *bp++){ 		i = 1; 		break; 		}p 	    } 	if(!i){"             if(!*bp || *bp == ',')                 return(1);             else if(*bp == '@')*                 return(0);
             }o	         }b     }        /*  * Get a string valued option.  * These are given as2  *    GIS=\E\E\027<  * Much decoding is done on the strings, and the strings are=  * placed in area, which is a ref parameter which is updated.l3  * For speed there is no checking on area overflow.;  */  char * MFBGetStr(id, area)g     char *id, **area;      {       register char *bp = mfb_buf;     register char *cp;     register int i;        for(;;){         bp = MFBSkip(bp);          if(!*bp) return(NULL); 	i = 0;p	 	cp = id;H 	while(*cp != 0 && *bp != 0){; 	    if(*cp++ != *bp++){ 		i = 1; 		break; 		}m 	    }%         if(i || *bp != '=') continue; 
         bp++;f&         return(MFBCapDecod(bp, area));	         }h     }e       /*5  * MFBCapDecod decodes the string capability escapes.g  */a
 static char *e MFBCapDecod(str, area)     char *str;     char **area;     {b
     char *cp; 
     int c;
     char *dp; 
     int i;       cp = *area;o$     while((c = *str++) && c != ','){         switch (c){r         case '^':              c = *str++ & 037;p             break;           case '\\':0             dp = "E\033^^\\\\,,n\nr\rt\tb\bf\f";             c = *str++;t
     nextc:                 if(*dp++ == c){e                 c = *dp++;                 break;                 }n             dp++;e             if(*dp)n                 goto nextc;              if(isdigit(c)){c                  c -= '0', i = 2;                 do/                     c <<= 3, c |= *str++ - '0';e,                 while(--i && isdigit(*str));                 };             break;
             }B         *cp++ = c;	         };     *cp++ = 0;     str = *area;     *area = cp;      return(str);     }        /*"  * Return the (numeric) option id.  * Numeric options look like
  *    MCL#255u@  * i.e. the option string is separated from the numeric value by;  * a # character.  If the option is not found we return -1.i?  * Note that we handle hex numbers beginning with "0x" or "0X",e&  * and octal numbers beginning with 0.  *  */i
 MFBGetNum(id)i
     char *id;I     {      register int i, j;      register char *bp = mfb_buf;      register char negative = 0 ;     register char *cp;       for(;;){         bp = MFBSkip(bp);($         if(*bp == 0) return(BADNUM); 	i = 0; 	 	cp = id;] 	while(*cp != 0 && *bp != 0){G 	    if(*cp++ != *bp++){ 		i = 1; 		break; 		}  	    }$         if(*bp == 0) return(BADNUM);%         if(i || *bp != '#') continue;g
         bp++;e*         if((negative=(*bp == '-'))) bp++ ;         i = 0;<         while( (j = ((int)(*bp) - 060)) >= 0 && (j < 10) ) {"             bp++; i *= 10; i += j; 	    }         if(negative)                return(-i) ;          else                return(i);c	         }d     }F  