 /*  * mfbdecode.c  **  * Copyright -C- 1982 Giles C. Billingsley'  * sccsid "@(#)mfbdecode.c	1.9  9/3/83"-  *E  *     MFB is a graphics package that was developed by the integrated @  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atD  * the University of California, Berkeley, California.  The programs?  * in MFB are available free of charge to any interested party. C  * The sale, resale, or use of these program for profit without the F  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,]  * is forbidden.  */=  t  ; #include <stdio.h> #include "mfb.h"  ( char *digits = "0123456789abcdefABCDEF";a int numbers[22] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 10, 11, 12, 13, 14, 15};      /*F  * This routine performs graphics conversion of data received from theB  * graphics terminal through stdio, as specified by a mfbcap entryB  * pointed to by 'PM'.  'PM' contains printf type escapes to allow"  * graphics coordinate conversion.  *F  * The following escapes are defined for substituting x/y coordinates:  *  *    %X    the X coordinate  *    %Y    the Y coordinate  *    %Z    the Z coordinate  *    %T    the T coordinate  *@  *    The codes below affect the state but don't use up a value.  *  *    %d    as in printf  *    %2    like %2d  *    %3    like %3d4  *    %c    gives %c hacking special case characters;  *    %h1   gives one   ASCII hex of low order four    bitsx;  *    %h2   gives two   ASCII hex of low order eight   bits ;  *    %h3   gives three ASCII hex of low order twelve  bits ;  *    %h4   gives four  ASCII hex of low order sixteen bitsl=  *    %o1   gives one   ASCII octal of low order three   bitsy=  *    %o2   gives two   ASCII octal of low order six     bitsy=  *    %o3   gives three ASCII octal of low order nine    bits =  *    %o4   gives four  ASCII octal of low order twelve  bits =  *    %o5   gives five  ASCII octal of low order fifteen bits*=  *    %o6   gives six   ASCII octal of low order sixteen bitse-  *    %t1   gives X and Y in Tektronix format -  *    %t2   gives Z and T in Tektronix format -  *    %R    store value in temporary buffer 1+-  *    %r    store value in temporary buffer 2e  *    %+x   add x to the value%  *    %-x   subtract x from the valueh  *    %*x   multiply value by xM  *    %/x   divide value by x '  *    %>>x  shift value right by x bits &  *    %<<x  shift value left by x bits  *    %|x   OR value with x   *    %&x   AND value with x  *    %^x   XOR value with x   *    %=x   set value equal to x2  *    %ax   set value equal to absolute value of x-  *    %~    complement value (1's complement)   *    %%    gives %t6  *    %B    BCD (2 decimal digits encoded in one byte)&  *    %D    Delta Data (backwards bcd)  *  *  * where x can be:  *@  * (1)   one byte: the numberic value of this byte is used as x.  *E  * (2)   '#' followed by a decimal number: the decimal value is used.[  *L  * (3)   '%' followed by C, F, L, X, Y, Z, T, r, or R: the C, F, L, X, Y, Z,!  *       T, r or R value is used.   */  * all other characters are ``self-inserting''.h  */r      
 MFBDecode(PM){
     char *PM;      {1     char *cp = PM;     register int c, d;     register int which = 0;n"     register int Reg = 0, reg = 0;     int extra,hix,hiy,lox,loy;!     int mfbnumarg(), mfbdecnum();e       if (cp == NULL) {tK         MFBCurrent->X = MFBCurrent->Y = MFBCurrent->Z = MFBCurrent->T = -1;r         return(MFBCAPNOFORMAT);]	         }t     while ((c = *cp++)) {          if (c != '%') {iD             if(c != (d = (*MFBCurrent->dsply_getchar)())) return(d);             continue;i
             })         switch (*cp++) {           case 'X':h"             MFBCurrent->X = which;             continue;a           case 'Y': "             MFBCurrent->Y = which;             continue;o           case 'Z':u"             MFBCurrent->Z = which;             continue;4           case 'T':m"             MFBCurrent->T = which;             continue;            case 'R':              Reg = which;             continue;p           case 'r':              reg = which;             continue;E           case 'd':a)             which = mfbdecnum( 10, 100 );a             continue;t           case '3':e'             which = mfbdecnum( 10, 3 );f             continue;*           case '2': '             which = mfbdecnum( 10, 2 );              continue;            case 'h':f,             if  (*cp >= '1'  &&  *cp <= '4')5                 which = mfbdecnum( 16, *cp++ - '0' );a             else-                 which = mfbdecnum( 16, 100 );n             continue ;           case 'o':r,             if  (*cp >= '1'  &&  *cp <= '6')4                 which = mfbdecnum( 8, *cp++ - '0' );             else,                 which = mfbdecnum( 8, 100 );             continue ;  .         case 't':				/* Tektronix terminals */ 	    c = *cp++;> 	    if(c == 'i'){ 		/* skip control chars */C                 while((hix = (*MFBCurrent->dsply_getchar)()) < 33);N 		hix -= 32;, 		hiy = (*MFBCurrent->dsply_getchar)() - 32;, 		lox = (*MFBCurrent->dsply_getchar)() - 32;- 		extra = 0; /* use extra as negative flag */t 		if(lox < 16) 		    extra = 1; 		else 		    lox -= 16;" 		which = lox + 16*hiy + 1024*hix; 		if(extra)  		    which = -which;a 		}c# 	    else if(c == '1' || c == '2'){*5                 hiy = (*MFBCurrent->dsply_getchar)();d7                 extra = (*MFBCurrent->dsply_getchar)();e5                 loy = (*MFBCurrent->dsply_getchar)();C5                 hix = (*MFBCurrent->dsply_getchar)(); 5                 lox = (*MFBCurrent->dsply_getchar)();t                 if(c == '1') {J                     MFBCurrent->X=((hix&037)<<7)+((lox&037)<<2)+(extra&3);O                     MFBCurrent->Y=((hiy&037)<<7)+((loy&037)<<2)+((extra>>2)&3);;                     },#                 else if(c == '2') {nJ                     MFBCurrent->Z=((hix&037)<<7)+((lox&037)<<2)+(extra&3);O                     MFBCurrent->T=((hiy&037)<<7)+((loy&037)<<2)+((extra>>2)&3);                      } 
 	        }
 	    else{ 		--cp;  		}              continue;r           case '>':)                if (*cp++ == '>'){ 		  mfbarg(cp, Reg, reg, c);%                   which = which >> c;  		  }                else {                   cp--;aA                   if((d = (*MFBCurrent->dsply_getchar)()) != '>')   		      return(MFBCAPSYNTAXERR);                   }r               continue;            case '<':                 if (*cp++ == '<'){ 		  mfbarg(cp, Reg, reg, c);%                   which = which << c;  		  }e               else {                   cp--;aA                   if((d = (*MFBCurrent->dsply_getchar)()) != '<')   		      return(MFBCAPSYNTAXERR);                   }a               continue;            case '|':  	      mfbarg(cp, Reg, reg, c);,               which |= c;e               continue;            case '&':f 	      mfbarg(cp, Reg, reg, c);o               which &= c;'               continue;            case '^':n 	      mfbarg(cp, Reg, reg, c);c               which ^= c;u               continue;o           case '~':y               which = ~which;.               continue;<           case '-':f 	      mfbarg(cp, Reg, reg, c);9               which -= c;[               continue ;           case '+':, 	      mfbarg(cp, Reg, reg, c);1               which += c;n               continue ;           case '*':  	      mfbarg(cp, Reg, reg, c);r               which *= c;                continue ;           case '/':n 	      mfbarg(cp, Reg, reg, c);w               which /= c;n               continue ;           case '=':n 	      mfbarg(cp, Reg, reg, c);e               which = c;               continue ;           case 'c': 5               which = (*MFBCurrent->dsply_getchar)();*               continue;f           case 'a':n 	      mfbarg(cp, Reg, reg, c);                which = abs(c);e               continue;d           case '%':c=               if((d = (*MFBCurrent->dsply_getchar)()) != '%')  		  return(MFBCAPSYNTAXERR);               continue;            default:,               MFBCurrent->X = MFBCurrent->Y ) 		  = MFBCurrent->Z = MFBCurrent->T = -1; %               return(MFBCAPNOFORMAT);x               } 	         }      return(MFBCAPOK);w     }t         mfbdecnum( base, maxdigits )     int base, maxdigits;     {b%     register int i, j, k, result = 0;a     register char c;  &     for( i = 0; i < maxdigits; i++ ) {+         c = (*MFBCurrent->dsply_getchar)();*#         for( j = 0; j < 22; j++ ) { "             if( digits[j] == c ) {                 k = numbers[j];                  break;                 } 
             }n$         if( j >= 22 || k >= base ) {*             MFBCurrent->dsply_ungetchar();             return(result); 
             }          result *= base;          result += k;	         }      return(result);n     } 