 /*  * mfbgncode.c  **  * Copyright -C- 1982 Giles C. Billingsley'  * sccsid "@(#)mfbgncode.c	1.9  9/3/83"   *E  *     MFB is a graphics package that was developed by the integrated*@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atD  * the University of California, Berkeley, California.  The programs?  * in MFB are available free of charge to any interested party.(C  * The sale, resale, or use of these program for profit without theeF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */        #include "mfb.h"   /* Library routines */ #ifndef vms, char *sprintf(); #endif   /*C  * This routine perform graphics conversion of data as specified by(%  * a mfbcap entry pointed to by 'PM'. ;  * 'PM' is a string containing printf type escapes to allow E  * graphics coordinate conversion.  The converted data is stored in aoK  * character buffer called 'result', and a pointer to 'result' is returned.   *F  * The following escapes are defined for substituting x/y coordinates:  *  *    %X    the X coordinate  *    %Y    the Y coordinate  *    %Z    the Z coordinate  *    %T    the T coordinate  *    %C    the C Parameter   *    %F    the F Parameter   *    %L    the L Parameter(  *@  *    The codes below affect the state but don't use up a value.  *4  *    %c    gives %c hacking special case characters  *    %d    as in printf  *    %2    like %2d  *    %3    like %3d;  *    %h1   gives one   ASCII hex of low order four    bitsr;  *    %h2   gives two   ASCII hex of low order eight   bits ;  *    %h3   gives three ASCII hex of low order twelve  bits ;  *    %h4   gives four  ASCII hex of low order sixteen bitsc=  *    %o1   gives one   ASCII octal of low order three   bitse=  *    %o2   gives two   ASCII octal of low order six     bitso=  *    %o3   gives three ASCII octal of low order nine    bitsl=  *    %o4   gives four  ASCII octal of low order twelve  bits =  *    %o5   gives five  ASCII octal of low order fifteen bits =  *    %o6   gives six   ASCII octal of low order sixteen bits I  *    %t1   gives X and Y in Tektronix format with coordinate compression I  *    %t2   gives Z and T in Tektronix format with coordinate compression I  *    %t3   gives X and R in Tektronix format with coordinate compression	I  *    %t4   gives R and Y in Tektronix format with coordinate compression I  *    %t5   gives R and r in Tektronix format with coordinate compression(3  *    %ti   gives value in Tektronix integer format_0  *    %tr   gives value in Tektronix real format"  *    %@    gives a NULL character-  *    %R    store value in temporary buffer 1 -  *    %r    store value in temporary buffer 2   *    %+x   add x to the value%  *    %-x   subtract x from the value   *    %*x   multiply value by x*  *    %/x   divide value by xr'  *    %>>x  shift value right by x bits &  *    %<<x  shift value left by x bits  *    %|x   OR value with xC  *    %&x   AND value with x  *    %^x   XOR value with x   *    %=x   set value equal to x2  *    %ax   set value equal to absolute value of x-  *    %~    complement value (1's complement)F  *    %%    gives %)6  *    %B    BCD (2 decimal digits encoded in one byte)&  *    %D    Delta Data (backwards bcd)  *  *  * where x can be:  *@  * (1)   one byte: the numberic value of this byte is used as x.  *E  * (2)   '#' followed by a decimal number: the decimal value is used.   *L  * (3)   '%' followed by C, F, L, X, Y, Z, T, r, or R: the C, F, L, X, Y, Z,!  *       T, r or R value is used.p  */  * all other characters are ``self-inserting''.)  */    MFBGenCode(PM)
     char *PM;      {c     struct timeb time1, time2;D     static char result[512];    /* 512 chars maximum per transfer */=     char hexadec();    		/* return a hexadecimal character */a8     char octal();      		/* return an octal character */     char *strcpy(); 
     char *cp;      float reftime, elapsedtime;*     register char *dp;     register int c;      register int which = 0;#     register int reg=0, Reg=0;     int i,x1,y1;     int tmp,lo1,hi1,hi2;     int exponent;g4     int hiy,hix,loy,lox,extra,ohiy,ohix,oloy,oextra;     int mfbnumarg();       cp = PM;     dp = result;     if (cp == NULL) {e 	return; 	}     while (c = *cp++) {B 	if(c == '$') {i 	    if(*cp != '<'){ 		*dp++ = c; 		} 
 	    else{ 		++cp;  		*dp='\0';r 		i = dp - result;& 		/* Output the guts of the string. */ 		if (i != 0) { & 		    (*MFBCurrent->outstr)(result,i); 		    }  		/* Flush the buffer */ 		MFBUpdate(); 		/* generate the delay */ 		mfbarg(cp, Reg, reg, tmp); 		if(*cp++ != '>') 		    continue;i 		ftime(&time1);7 		reftime = (float)(time1.time * 1000 + time1.millitm);i 		while(tmp > 0){r 		    ftime(&time2);> 		    elapsedtime = (float)(time2.time * 1000 + time2.millitm)
 			- reftime;t" 		    if(elapsedtime > (float)tmp)	 			break;k 		    }r 		dp = result; 		}o 	    continue; 	    } 	else if (c != '%') {n 	    *dp++ = c;o 	    continue; 	    } 	switch (*cp++) {u  
 	case 'X': 	    which = MFBCurrent->X;  	    continue;  
 	case 'Y': 	    which = MFBCurrent->Y;U 	    continue;  
 	case 'Z': 	    which = MFBCurrent->Z;  	    continue;  
 	case 'T': 	    which = MFBCurrent->T;  	    continue;   	case 'R':   	    Reg = which;h 	    continue;   	case 'r': v 	    reg = which;/ 	    continue;  
 	case 'C':# 	    which = MFBCurrent->fgColorId;* 	    continue;  
 	case 'F':% 	    which = MFBCurrent->fillPattern;* 	    continue;  
 	case 'L':# 	    which = MFBCurrent->lineStyle;  	    continue;  
 	case 'd': 	    sprintf(dp,"%d",which); 	    while(*dp != NULL) ++dp;p 	    which = 0;  	    continue;  
 	case '3':! 	    *dp++ = (which / 100) + '0';g 	    which %= 100; 	    /* fall into... */a  
 	case '2':  	    *dp++ = (which / 10) + '0';  	    *dp++ = (which % 10) + '0';
 	    which=0;  	    continue;  
 	case 'h':' 	    if  (*cp >= '1'  &&  *cp <= '4') {d& 		for  (i = *cp++ - '1'; i >= 0; i--){' 		       *dp++ = hexadec(which>>(i*4));: 		    },
 		which=0; 		}  	    continue;  
 	case 'o':( 	    if  (*cp >= '1'  &&  *cp <= '6')  {) 		   for  (i = *cp++ - '1'; i >= 0; i--){h 			*dp++ = octal(which>>(i*3));b 		    }i
 		   which=0;c 		}  	    continue;  ( 	case 't':			  /* TEKTRONIX TERMINALS */" 	    if(*cp == 'i' || *cp == 'r'){ 		tmp = which; 		if (tmp < 0) tmp = -tmp; 		if(*cp == 'r'){a 		    exponent = 0;h 		    while(tmp > 32767){p 		        tmp /= 2;, 		        ++exponent;i 		        }; 		    }i 		hi1 = tmp/16;  		if(which < 0)h  		    lo1 = tmp - hi1 * 16 + 32; 		else  		    lo1 = tmp - hi1 * 16 + 48; 		tmp = hi1; 		if (tmp > 64) {n 		    hi1 = tmp/64;r  		    hi2 = tmp - hi1 * 64 + 64; 		    *dp++ = hi1 + 64;P 		    *dp++ = hi2; 		    }( 		else if (tmp)r 		    *dp++ = tmp + 64;= 		*dp++ = lo1; 		if(*cp == 'r'){i+ 		    /* exponent is always non-negative */{ 		    hi1 = exponent/16;% 		    lo1 = exponent - hi1 * 16 + 48;s 		    exponent = hi1;h 		    if (exponent > 64) { 		        hi1 = exponent/64;) 		        hi2 = exponent - hi1 * 64 + 64;e 		        *dp++ = hi1 + 64;a 		        *dp++ = hi2; 		        }d 		    else if (exponent)  		        *dp++ = exponent + 64; 		    *dp++ = lo1; 		    }t 		} 
 	    else{ 		if(*cp == '1'){e 		    x1 = MFBCurrent->X;f 		    y1 = MFBCurrent->Y;a 		    }n 		else if(*cp == '2'){ 		    x1 = MFBCurrent->Z;i 		    y1 = MFBCurrent->T;  		    }* 		else if(*cp == '3'){ 		    x1 = MFBCurrent->X;a 		    y1 = Reg;  		    }t 		else if(*cp == '4'){ 		    x1 = Reg;t 		    y1 = MFBCurrent->Y;* 		    }f 		else if(*cp == '5'){ 		    x1 = Reg;t 		    y1 = reg;e 		    }* 		else
 		    return;a 		hiy   = (y1 >> 7) & 037;% 		extra = x1 & 03 | ((y1 & 03) << 2);  		loy   = (y1 >> 2) & 037; 		hix   = (x1 >> 7) & 037; 		lox   = (x1 >> 2) & 037;* 		ohiy   = (MFBCurrent->lastY >> 7) & 037;A 		oextra = MFBCurrent->lastX & 03 | ((MFBCurrent->lastY & 3)<<2); * 		oloy   = (MFBCurrent->lastY >> 2) & 037;* 		ohix   = (MFBCurrent->lastX >> 7) & 037; 		MFBCurrent->lastX = x1;d 		MFBCurrent->lastY = y1;S 		if(hiy != ohiy)r 		    *dp++ = hiy | 040; 		if(hix != ohix){ 		    if(extra != oextra){ 			*dp++ = extra | 0140; 			} 		    *dp++ = loy | 0140;b 		    *dp++ = hix | 040; 		    }  		else{w 		    if(extra != oextra){ 			*dp++ = extra | 0140; 			*dp++ = loy | 0140; 			} 		    else if(loy != oloy){I 			*dp++ = loy | 0140; 			} 		    }  		*dp++ = lox | 0100;I 		}a
 	    cp++; 	    continue;  
 	case '>': 	    if (*cp++ == '>'){t 		mfbarg(cp, Reg, reg, c); 		which >>= c; 		}f 	    else {U 		cp--;  		*dp++ = '>'; 		}a 	    continue;  
 	case '<': 	    if (*cp++ == '<'){  		mfbarg(cp, Reg, reg, c); 		which <<= c; 		}f 	    else {i 		cp--;  		*dp++ = '<'; 		}	 	    continue;  
 	case '|': 	    mfbarg(cp, Reg, reg, c);f 	    which |= c; 	    continue;  
 	case '&': 	    mfbarg(cp, Reg, reg, c);> 	    which &= c; 	    continue;  
 	case '^': 	    mfbarg(cp, Reg, reg, c);} 	    which ^= c; 	    continue;  
 	case '~': 	    which = ~which; 	    continue;  
 	case '-': 	    mfbarg(cp, Reg, reg, c);  	    which -= c; 	    continue;  
 	case '+': 	    mfbarg(cp, Reg, reg, c);/ 	    which += c; 	    continue;  
 	case '*': 	    mfbarg(cp, Reg, reg, c);  	    which *= c; 	    continue;  
 	case '/': 	    mfbarg(cp, Reg, reg, c);f 	    which /= c; 	    continue;  
 	case 'c': 	    *dp++ = (char)which;x 	    which = 0;  	    continue;  
 	case '@': 	    *dp++ = 0;t 	    continue;  
 	case 'a': 	    which = abs(which); 	    continue;  
 	case '=': 	    mfbarg(cp, Reg, reg, c);  	    which = c;  	    continue;  
 	case '%': 	    *dp++ = c;  	    continue;  
 	case 'B':( 	    which = (which/10 << 4) + which%10; 	    continue;  
 	case 'D':$ 	    which = which - 2 * (which%16); 	    continue;  	 	default:r 	    return; 	    } 	}
     *dp='\0';{     i = dp - result;       /*%      * Output the guts of the string.l      */      if (i != 0) {=! 	(*MFBCurrent->outstr)(result,i);  	}     }	       char hexadec(num) ;      /* return a hexadecimal character corresponding to the(+      low order 4 bits of the argument    */g
      int num;	      {      num &= 0xf;      if(num <= 9)  	 return('0'+num);	      else0 	 return('A'+num-10);y      }         char octal(num)79     /* return an octal character corresponding to the lowt&        order 3 bits of the argument */     int num;     {F     num &= 07;     return('0' + num);     }e