 /*
  * mfbio.c  **  * Copyright -C- 1982 Giles C. Billingsley#  * sccsid "@(#)mfbio.c	1.9  9/3/83"p  *E  *     MFB is a graphics package that was developed by the integrated,@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atD  * the University of California, Berkeley, California.  The programs?  * in MFB are available free of charge to any interested party.oC  * The sale, resale, or use of these program for profit without theuF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,o  * is forbidden.  */.     #include "mfb.h" #include <stdio.h> #include <math.h>t   /* Library routines */ char *strcpy();*  H static int MFBsaveflg = 0;	  /* used for kludgy ungetc                */H static int Oldsaveflg = 0;	  /* ungetc for displays without keyboards */  % #define	MFBFORMAT	MFBCurrent->strings    struct err errors[] = {B( 	   MFBBADENT,	"Unknown terminal type!",( 	   MFBMCELNG,	"MFBCAP entry too long!",2 	   MFBBADMCF,	"Can't open or close mfbcap file!",# 	   MFBBADMCE,	"Bad mfbcap entry!", ( 	   MFBINFMCE,	"Infinite mfbcap entry!",% 	   MFBBADTTY,	"stdout not in /dev!",B% 	   MFBBADLST,	"Illegal line style!", % 	   MFBBADFST,	"Illegal fill style!", & 	   MFBBADCST,	"Illegal color style!",% 	   MFBBADTM1,	"No destructive text",r& 	   MFBBADTM2,	"No overstriking text",, 	   MFBNODFLP,	"No defineable line styles!",, 	   MFBNODFFP,	"No defineable fill styles!",' 	   MFBNODFCO,	"No defineable colors!",  	   MFBNOBLNK,	"No blinkers!",$ 	   MFBTMBLNK,	"Too many blinkers!",4 	   MFBNOMASK,	"No defineable read or write masks!",4 	   MFBBADDEV,	"Can't open or close output device!",4 	   MFBBADOPT,	"Can't access or set device status!",! 	   MFBBADWRT,	"Error in write!",++ 	   MFBPNTERR,	"Error in pointing device!",): 	   MFBNOPTFT,	"No format specified for pointing device!",# 	   MFBNOPNT,	"No pointing device",(5 	   MFBNORBND,	"No Rubberbanding of pointing device",	% 	   MFBBADALU,	"Cannot set ALU mode",F 	   01 	   };  5 #define	NUMERRORS	(sizeof(errors)/sizeof(struct err))e        N /*****************************************************************************  *$  *		              BASIC I/O ROUTINES  *O  *****************************************************************************/,  
 MFBPutchar(c))     char c;      /*
      * Notes: H      *    Place a character in the output buffer and check for overflow.      */      {i:     MFBCurrent->ttyBuffer[MFBCurrent->numTtyBuffer++] = c;.     if(MFBCurrent->numTtyBuffer >= TTYBUFSIZE)
 	MFBUpdate();      return( (int) c );     }e     MFBPutstr(c,n)     char *c;
     int n;     /*
      * Notes:rG      *    Place a string of n characters in the output buffer and checka      *     for overflow.      */      { 
     int i;
     i = n;I     /* Putchar tests for overflow after insertion, Putstr tests before */t9     if((MFBCurrent->numTtyBuffer + n + 1) >= TTYBUFSIZE){ 
 	MFBUpdate();a 	MFBCurrent->numTtyBuffer = 0; 	}     while(i--): 	MFBCurrent->ttyBuffer[MFBCurrent->numTtyBuffer++] = *c++;     return( n );     }      intM MFBGetchar() {     static char c;     char ibuffer[2];     if( MFBsaveflg != 0 )  	MFBsaveflg = 0;	     else{ 
 #ifdef vms$ 	c = dev_getc(MFBCurrent->fileDesc); #elseM 	if(MFBCurrent->fileDesc == 1) 	    c = getchar();e 	else{= 	    if((c = (char)read(MFBCurrent->fileDesc,ibuffer,1)) > 0)  	        c = ibuffer[0]; 	    } #endif 	}     return( c );     }=     int  MFBUngetchar() {     MFBsaveflg++;      }      intt OldGetchar() {     /*
      * Notes:_?      *    If the graphics display does not have a keyboard, mfbF@      *    will use the standard getchar routine to acquire input#      *    from the user's terminal.       */      static char c;     if( Oldsaveflg != 0 )  	Oldsaveflg = 0;	     else{e
 #ifdef vms 	c = dev_getchar();; #else  	c = getchar();( #endif 	}     return( c );     }1     int2 OldUngetchar() {     Oldsaveflg++;*     }b     int 
 MFBUpdate() {-     /*
      * Notes:l:      *    Flush the output buffer to the graphics display.      */s     int value;
 #ifdef vms.     if((value = MFBCurrent->numTtyBuffer) > 0)'         dev_write(MFBCurrent->fileDesc,D5 	    MFBCurrent->ttyBuffer,MFBCurrent->numTtyBuffer);e #else*     value =tO     write(MFBCurrent->fileDesc,MFBCurrent->ttyBuffer,MFBCurrent->numTtyBuffer);e #endif!     MFBCurrent->numTtyBuffer = 0;e     return(value);     }e     intm MFBFlushInput(){ #ifndef vmsi     /*E      * In the UNIX file system, all pending input is flushed whenever	0      * ioctl is called with the TIOCSETP option.      */*  E     /* the isatty() is necessary because user may be piping output */*%     if(isatty(MFBCurrent->fileDesc)){N/         if(ioctl(MFBCurrent->fileDesc,TIOCSETP,*) 	    &MFBCurrent->graphTtyb.newttyb) < 0)F 	    return(MFBBADOPT);  	}/     if(MFBCurrent->fileDesc != 1 && isatty(1)){ @         if(ioctl(1,TIOCSETP,&MFBCurrent->kybrdTtyb.newttyb) < 0) 	    return(MFBBADOPT);F	         }u #endif     return(MFBOK);     }n       void MFBAudio(){S     /*
      * Notes:       *    Rings the Bell.           */t<     if(MFBFORMAT.audio == NULL || *MFBFORMAT.audio == NULL){ 	/* cntrl-g by default */h 	if(MFBCurrent->fileDesc == 1) 	    MFBPutchar( '\07' );e 	else  	    putchar( '\07' ); 	}	     else{; 	MFBGenCode(MFBFORMAT.audio);f 	}     }n          N /*****************************************************************************  *"  *		                INITIALIZATION  *O  *****************************************************************************/*   MFB + *MFBOpen(TerminalName,DeviceName,errorcode))     char *TerminalName;      char *DeviceName;      int *errorcode;      /*
      * Notes: B      *    Called to initialize a graphics terminal.  The characterA      *    function MFBError(errnum) returns a pointer to a string(      *    describing the error.e      *;      *    TerminalName is the name used in the MFBCAP file.       *F      *    DeviceName is a pointer to a string which specifies the nameC      *    of the output device.  If DeviceName is a null string,theaB      *    current device is assumed (i.e. filedesc = 1, for UNIX).D      *    To avoid output to a tty through stdio, use DeviceName == !      *    ttyname(fileno(stdout))a      *F      *    errorcode returns an integer specifying the type of error,if5      *    any,which occurs during mfb initialization.       *      */      {      char *MFBGetStr();     char *getenv();* #ifndef vms      char *ttyname(); #endif     char *malloc();*     char *mfbcapFile;f     char *bufPtr; 
     MFB *mfb;*
     int i;  /     if((mfbcapFile = getenv("MFBCAP")) == NULL)T 	mfbcapFile = DEFAULTMFBCAP;  6     /* We won't test the return of malloc here (TODO).>      * If it doesn't work, the user will find out soon enough.      */e%     mfb = (MFB *)malloc(sizeof(MFB));n%     mfb->terminalName = TerminalName;>     SetCurrentMFB(mfb);e  G     if((*errorcode = MFBGetEnt(gEntBuf,TerminalName,mfbcapFile)) <= 0){cD 	/* Don't free the MFB because User may use it for Terminal Name. */ 	return(NULL); 	}       bufPtr = mfb->strBuf;o       if(MFBGetFlag("TTY")){ 	mfb->deviceType = TTY;i/ 	if(DeviceName == NULL || *DeviceName == NULL){y
 #ifdef vms) 	    dev_open(DeviceName,&mfb->fileDesc);   	    mfb->name = getenv("TERM"); #else  	    mfb->fileDesc = 1;a) 	    mfb->name = ttyname(2); /* stdout */  #endif 	    } 	else{
 #ifdef vms) 	    dev_open(DeviceName,&mfb->fileDesc);  #else 3 	    /* try to create the file if does not exist */"+ 	    if(close(creat(DeviceName,0644)) < 0){' 		*errorcode = MFBBADDEV;! 		return(NULL);, 		}   2 	    if((mfb->fileDesc = open(DeviceName,2)) < 0){ 		*errorcode = MFBBADDEV;t 		return(NULL);  		}F #endif 	    mfb->name = DeviceName; 	    }   #ifdef DEBUG 	MFBZeroCounters();D #endif   	/*o+ 	 * Fill up mfb structure from mfbcap entryt 	 */' 	mfb->litout = (Bool)MFBGetFlag("8BB"); $ 	mfb->raw = (Bool)MFBGetFlag("RAW");7 	mfb->strings.startSequence = MFBGetStr("GIS",&bufPtr); 5 	mfb->strings.endSequence = MFBGetStr("GFS",&bufPtr);o      	mfb->maxX = MFBGetNum("MXC"); 	mfb->maxY = MFBGetNum("MYC");8 	mfb->strings.initLineStyles = MFBGetStr("ILS",&bufPtr);9 	mfb->strings.initColorStyles = MFBGetStr("ICS",&bufPtr);s: 	mfb->strings.initFillPatterns = MFBGetStr("IFP",&bufPtr);      	/*T 	 * graphics text info 	 */5 	mfb->textPositionableBool = (Bool)MFBGetFlag("APT");d/ 	mfb->textRotateBool = (Bool)MFBGetFlag("ROT"); < 	mfb->strings.rotateTextSequence = MFBGetStr("RTS",&bufPtr);$ 	mfb->fontHeight = MFBGetNum("GCH");# 	mfb->fontWidth = MFBGetNum("GCW"); % 	mfb->fontXOffset = MFBGetNum("GTW");*% 	mfb->fontYOffset = MFBGetNum("GTH");b; 	mfb->strings.graphicsTextStart = MFBGetStr("GTS",&bufPtr);t9 	mfb->strings.graphicsTextEnd = MFBGetStr("GTE",&bufPtr);E0 	mfb->replaceTextBool = (Bool)MFBGetFlag("GTR");3 	mfb->strings.replaceON = MFBGetStr("RMO",&bufPtr);D3 	mfb->overstrikeTextBool = (Bool)MFBGetFlag("GTO");,6 	mfb->strings.overstrikeON = MFBGetStr("OMO",&bufPtr);4 	mfb->strings.writePixel = MFBGetStr("WPX",&bufPtr);      	/*r 	 * raster operationsr 	 */) 	mfb->minOffScreenX = MFBGetNum("OFFMX");() 	mfb->minOffScreenY = MFBGetNum("OFFMY");m' 	mfb->offScreenDX = MFBGetNum("OFFDX");o' 	mfb->offScreenDY = MFBGetNum("OFFDY");.0 	mfb->rastRSCSFBool = (Bool)MFBGetFlag("RSCSF");9 	mfb->strings.rastCopyStart = MFBGetStr("RSCPS",&bufPtr);B7 	mfb->strings.rastCopyEnd = MFBGetStr("RSCPE",&bufPtr);e: 	mfb->strings.rastCopySource = MFBGetStr("RSSRC",&bufPtr);8 	mfb->strings.rastCopyDest = MFBGetStr("RSDST",&bufPtr);* 	if(mfb->strings.rastCopyStart == NULL || ) 	    *mfb->strings.rastCopyStart == NULL)f 	    mfb->rastCopyBool = false;  	elsee 	    mfb->rastCopyBool = true;      	/* % 	 * display color (intensity) control  	 */# 	mfb->maxColors = MFBGetNum("MCL"); 5 	mfb->strings.screenFlood = MFBGetStr("GCS",&bufPtr);c& 	mfb->maxIntensity = MFBGetNum("VTI");( 	mfb->vltBool = (Bool)MFBGetFlag("VLT");. 	mfb->vltUseHLSBool = (Bool)MFBGetFlag("HLS"); 	if(mfb->vltBool) { ) 	    mfb->lengthOfVLT = MFBGetNum("VTL"); 6 	    mfb->strings.vltEntry = MFBGetStr("VTE",&bufPtr); 	    }< 	mfb->strings.setForegroundColor = MFBGetStr("SCS",&bufPtr);8 	mfb->strings.channelMaskSet = MFBGetStr("VWM",&bufPtr);+ 	if(mfb->strings.channelMaskSet == NULL || v* 	    *mfb->strings.channelMaskSet == NULL)" 	    mfb->channelMaskBool = false; 	else ! 	    mfb->channelMaskBool = true; 5 	mfb->strings.readMaskSet = MFBGetStr("SRM",&bufPtr);B( 	if(mfb->strings.readMaskSet == NULL || ' 	    *mfb->strings.readMaskSet == NULL)m 	    mfb->readMaskBool = false;t 	else, 	    mfb->readMaskBool = true;      	/*X, 	 * graphics input (pointing device) control 	 */3 	mfb->PointingDeviceBool = (Bool)MFBGetFlag("POD");i 	if(mfb->PointingDeviceBool){(0 	    mfb->buttonsBool = (Bool)MFBGetFlag("PDB"); 	    if(mfb->buttonsBool){5 		mfb->numberOfButtons = MFBmin(MFBGetNum("NPB"),12);i( 		mfb->buttonMask[0] = MFBGetNum("BU1");( 		mfb->buttonMask[1] = MFBGetNum("BU2");( 		mfb->buttonMask[2] = MFBGetNum("BU3");( 		mfb->buttonMask[3] = MFBGetNum("BU4");( 		mfb->buttonMask[4] = MFBGetNum("BU5");( 		mfb->buttonMask[5] = MFBGetNum("BU6");( 		mfb->buttonMask[6] = MFBGetNum("BU7");( 		mfb->buttonMask[7] = MFBGetNum("BU8");( 		mfb->buttonMask[8] = MFBGetNum("BU9");) 		mfb->buttonMask[9] = MFBGetNum("BU10");b* 		mfb->buttonMask[10] = MFBGetNum("BU11");* 		mfb->buttonMask[11] = MFBGetNum("BU12");7 		/* -1 flags an unused and inapplicable button mask */l, 		for(i = mfb->numberOfButtons; i < 12; ++i) 		    mfb->buttonMask[i] = -1; 		} 6 	    mfb->readImmediateBool = (Bool)MFBGetFlag("PRI");B 	    mfb->strings.enablePointingDevice = MFBGetStr("PDS",&bufPtr);C 	    mfb->strings.disablePointingDevice = MFBGetStr("PDE",&bufPtr); C 	    mfb->strings.enableRubberBanding = MFBGetStr("PRBON",&bufPtr); E 	    mfb->strings.disableRubberBanding = MFBGetStr("PRBOFF",&bufPtr);;@ 	    mfb->strings.readPointingDevice = MFBGetStr("PDR",&bufPtr);B 	    mfb->strings.formatPointingDevice = MFBGetStr("PDF",&bufPtr); 	    }   	/*  	 * keyboard control 	 *// 	mfb->keyboardBool = (Bool)MFBGetFlag("KYBRD");*7 	mfb->strings.keyboardStart = MFBGetStr("KYS",&bufPtr);a5 	mfb->strings.keyboardEnd = MFBGetStr("KYE",&bufPtr); ; 	mfb->strings.keyboardBackspace = MFBGetStr("KYB",&bufPtr);N) 	mfb->keyboardXOffset = MFBGetNum("KYX");a) 	mfb->keyboardYOffset = MFBGetNum("KYY");u0 	mfb->strings.audio = MFBGetStr("BELL",&bufPtr);   	/*  	 * blinker controle 	 */- 	mfb->blinkersBool = (Bool)MFBGetFlag("BLD");u% 	mfb->maxBlinkers = MFBGetNum("NBL");* 	mfb->numBlinkers = 0;3 	mfb->strings.blinkerON = MFBGetStr("BLS",&bufPtr);f4 	mfb->strings.blinkerOFF = MFBGetStr("BLE",&bufPtr);   	/*  	 * line geometry controlu 	 */' 	mfb->maxLineStyles = MFBGetNum("MLS");o5 	mfb->reissueLineStyleBool = (Bool)MFBGetFlag("RLS"); 6 	mfb->linePatternDefineBool = (Bool)MFBGetFlag("DLP");6 	mfb->strings.setLineStyle = MFBGetStr("SLS",&bufPtr);< 	mfb->strings.setSolidLineStyle = MFBGetStr("SSLS",&bufPtr);9 	mfb->strings.movePenSequence = MFBGetStr("MPS",&bufPtr);*: 	mfb->strings.drawLineSequence = MFBGetStr("DLS",&bufPtr);? 	mfb->strings.drawSolidLineSequence = MFBGetStr("DSL",&bufPtr);i< 	mfb->strings.drawLineToSequence = MFBGetStr("DLT",&bufPtr);B 	mfb->strings.drawSolidLineToSequence = MFBGetStr("DSLT",&bufPtr);! 	if(mfb->linePatternDefineBool) {m= 	    mfb->strings.lineDefineStart = MFBGetStr("LDS",&bufPtr);a> 	    mfb->strings.lineDefineFormat = MFBGetStr("LDF",&bufPtr);; 	    mfb->strings.lineDefineEnd = MFBGetStr("LDE",&bufPtr);o. 	    mfb->lineDefineLength = MFBGetNum("LDL"); 	    }   	/*[ 	 * box geometry control 	 */9 	mfb->strings.drawBoxSequence = MFBGetStr("DBS",&bufPtr);B> 	mfb->strings.drawSolidBoxSequence = MFBGetStr("DSB",&bufPtr);   	/*M 	 * polygon geometry control 	 */2 	mfb->filledPlygnBool = (Bool)MFBGetFlag("FPOLY");< 	mfb->strings.beginPlygnSequence = MFBGetStr("PLS",&bufPtr);C 	mfb->strings.beginSolidPlygnSequence = MFBGetStr("PLSOL",&bufPtr);u9 	mfb->strings.sendPlygnVertex = MFBGetStr("PLV",&bufPtr);e: 	mfb->strings.endPlygnSequence = MFBGetStr("PLE",&bufPtr);   	/*  	 * fill pattern control 	 */) 	mfb->maxFillPatterns = MFBGetNum("MFP");e3 	mfb->fillPtrnDefineBool = (Bool)MFBGetFlag("DFP");>8 	mfb->strings.setFillPattern = MFBGetStr("SFP",&bufPtr);> 	mfb->strings.setSolidFillPattern = MFBGetStr("SSFP",&bufPtr); 	if(mfb->fillPtrnDefineBool) {. 	    mfb->fillDefineHeight = MFBGetNum("FDH");- 	    mfb->fillDefineWidth = MFBGetNum("FDW");r; 	    mfb->fillDefineRowMajorBool = (Bool)MFBGetFlag("FDR");B= 	    mfb->strings.fillDefineStart = MFBGetStr("FDS",&bufPtr); > 	    mfb->strings.fillDefineFormat = MFBGetStr("FDF",&bufPtr);; 	    mfb->strings.fillDefineEnd = MFBGetStr("FDE",&bufPtr);. 	    }   	/*F 	 * Circle geometry controlb 	 */< 	mfb->strings.drawCircleSequence = MFBGetStr("DCS",&bufPtr);   	/*f
 	 * ALU modes( 	 */6 	mfb->strings.setALUJAM = MFBGetStr("ALUJAM",&bufPtr);4 	mfb->strings.setALUOR = MFBGetStr("ALUOR",&bufPtr);6 	mfb->strings.setALUNOR = MFBGetStr("ALUNOR",&bufPtr);6 	mfb->strings.setALUEOR = MFBGetStr("ALUEOR",&bufPtr);   	/*u% 	 * set defaults in mfb tty structure  	 */ 	mfb->cursorColor1Id = 0;b 	mfb->cursorColor2Id = 1;e  	mfb->fgColorId = UNINITIALIZED;" 	mfb->fillPattern = UNINITIALIZED;  	mfb->lineStyle = UNINITIALIZED;" 	mfb->channelMask = UNINITIALIZED; 	mfb->readMask = UNINITIALIZED;a 	mfb->textMode = UNINITIALIZED;g 	L% 	/*this is changed by MFBInitialize*/e 	mfb->ttyIsSet = false;b   	mfb->lastX = -1;e 	mfb->lastY = -1;S 	}	     else{  	/*>) 	 * Hardcopy devices not yet implemented.b 	 */ 	mfb->deviceType = HCOPY;e 	}       /*6      * Now try to initialize everything,return status.      */t!     *errorcode = MFBInitialize();.      mfb->initializedBool = true;       return(mfb);     }.     intL MFBInitialize()F     /*
      * Notes:;5      *    Called to reinitialize a graphics terminal..5      *    TTY mode is reset if necessary (UNIX only).>      */i     {e
     int i;  '     if(MFBCurrent->deviceType == TTY) {i 	i = MFBInitTTY();
 	if(i < 0) 	    return(i);b   	/*e& 	 * Output initialization start string 	 */% 	MFBGenCode(MFBFORMAT.startSequence);s      	/*C 	 * Flush the buffer 	 */
 	MFBUpdate();s   	/*a 	 * Output initializationt 	 */& 	MFBGenCode(MFBFORMAT.initLineStyles);' 	MFBGenCode(MFBFORMAT.initColorStyles);o( 	MFBGenCode(MFBFORMAT.initFillPatterns); 	MFBCurrent->lastX = -1; 	MFBCurrent->lastY = -1;   	/*t 	 * And flush the buffer again 	 */
 	MFBUpdate();" 	return(MFBOK);B 	}	     else{G 	return(MFBOK);m 	}     }L     intB
 MFBInitTTY(){"     /*
      * Notes:lA      *    Initialize TTY and save current state in MFB structure..,      *    Also,the output buffer is flushed.      */i #ifndef vmso     long litout = LLITOUT; #endif  %     if(MFBCurrent->deviceType != TTY)r 	return(MFBBADTTY);(!     MFBCurrent->numTtyBuffer = 0;      if(!MFBCurrent->ttyIsSet) {a #ifndef vms)B 	if(*MFBCurrent->name == NULL) {       /* => stdout not in /dev */ 	    return(MFBBADTTY);g 	    } 	/* * 	 * Set keyboard tty options if necessary.6 	 * We put the terminal in CBREAK so that any keyboard1 	 * input will be echoed on the graphics display.s 	 */  B 	/* the isatty() is necessary because user may be piping output */, 	if(MFBCurrent->fileDesc != 1 && isatty(1)){ 	    /*l> 	     * Disable user messages by changing the fstats of stdin.B 	     * Yes, this is necessary; the user may open his own terminal? 	     * as the graphics device in which case user messages willt/ 	     * still interrupt the graphics via stdio.[ 	     */4 	    if(fstat(1,&MFBCurrent->oldstat.kybrdstat) < 0) 		return(MFBBADOPT);8 	    /* 0022 corresponds to write by group and others */G 	    if(chmod(ttyname(2),MFBCurrent->oldstat.kybrdstat.st_mode & ~0022)B 		< 0) return(MFBBADOPT);/= 	    if(ioctl(1,TIOCGETP,&MFBCurrent->kybrdTtyb.oldttyb) < 0)  		return(MFBBADOPT);= 	    if(ioctl(1,TIOCLGET,&MFBCurrent->oldstat.kybrdttyw) < 0)r 		return(MFBBADOPT);C 	    MFBCurrent->kybrdTtyb.newttyb = MFBCurrent->kybrdTtyb.oldttyb;dC 	    MFBCurrent->kybrdTtyb.newttyb.sg_flags &= (ALLDELAY & ~XTABS);nE 	    MFBCurrent->kybrdTtyb.newttyb.sg_flags |= ODDP | EVENP | CBREAK;i> 	    MFBCurrent->kybrdTtyb.newttyb.sg_erase = 8;		/* ctrl-h */> 	    MFBCurrent->kybrdTtyb.newttyb.sg_kill = 24;		/* ctrl-x */= 	    if(ioctl(1,TIOCSETP,&MFBCurrent->kybrdTtyb.newttyb) < 0)  		return(MFBBADOPT); 	    } 	/*a# 	 * Set graphics device tty optionsi 	 */  B 	/* the isatty() is necessary because user may be piping output */" 	if(isatty(MFBCurrent->fileDesc)){  	    /* Disable user messages */B 	    if(stat(MFBCurrent->name,&MFBCurrent->oldstat.graphstat) < 0) 	        return(MFBBADOPT);q8 	    /* 0022 corresponds to write by group and others */ 	    if(chmod(MFBCurrent->name,l5 		MFBCurrent->oldstat.graphstat.st_mode & ~0022) < 0)  		return(MFBBADOPT);, 	    if(ioctl(MFBCurrent->fileDesc,TIOCGETP,9 		&MFBCurrent->graphTtyb.oldttyb) < 0) return(MFBBADOPT);Y, 	    if(ioctl(MFBCurrent->fileDesc,TIOCLGET,9 		&MFBCurrent->oldstat.graphttyw) < 0) return(MFBBADOPT);rC 	    MFBCurrent->graphTtyb.newttyb = MFBCurrent->graphTtyb.oldttyb;NC 	    MFBCurrent->graphTtyb.newttyb.sg_flags &= (ALLDELAY & ~XTABS);uE 	    MFBCurrent->graphTtyb.newttyb.sg_flags |= ODDP | EVENP | CBREAK;m# 	    if(MFBCurrent->fileDesc != 1){f< 	        if(MFBCurrent->graphTtyb.newttyb.sg_ispeed < B1200)= 	            MFBCurrent->graphTtyb.newttyb.sg_ispeed = B9600;I< 	        if(MFBCurrent->graphTtyb.newttyb.sg_ospeed < B1200)= 	            MFBCurrent->graphTtyb.newttyb.sg_ospeed = B9600; 
 	        } 	    if(MFBCurrent->litout){= 	        if(ioctl(MFBCurrent->fileDesc,TIOCLBIS,&litout) < 0)  		    return(MFBBADOPT);
 	        } 	    if(MFBCurrent->raw)7 	        MFBCurrent->graphTtyb.newttyb.sg_flags |= RAW;u> 	    MFBCurrent->graphTtyb.newttyb.sg_erase = 8;		/* ctrl-h */> 	    MFBCurrent->graphTtyb.newttyb.sg_kill = 24;		/* ctrl-x */, 	    if(ioctl(MFBCurrent->fileDesc,TIOCSETP,9 		&MFBCurrent->graphTtyb.newttyb) < 0) return(MFBBADOPT);  	    } #endif" 	MFBCurrent->outchar = MFBPutchar;  	MFBCurrent->outstr = MFBPutstr;( 	MFBCurrent->dsply_getchar = MFBGetchar;, 	MFBCurrent->dsply_ungetchar = MFBUngetchar; 	if(MFBCurrent->keyboardBool){, 	    MFBCurrent->kybrd_getchar = MFBGetchar;0 	    MFBCurrent->kybrd_ungetchar = MFBUngetchar; 	    } 	else{, 	    MFBCurrent->kybrd_getchar = OldGetchar;0 	    MFBCurrent->kybrd_ungetchar = OldUngetchar; 	    } 	MFBCurrent->ttyIsSet = true;. 	}     return(MFBOK);     }A            N /*****************************************************************************  *,  *	                     TERMINATION ROUTINES  *O  *****************************************************************************/F   inte MFBClose(){u     /*
      * Notes:tF      *    Called to end the graphics sequence.  Must be last procedure2      *    invoked because it frees the MFB struct.      */        /*      * Flush the bufferf      */r     MFBUpdate();&     if(!MFBCurrent->initializedBool) { 	free(MFBCurrent); 	return(MFBOK);G 	}       /*<      * Put terminal in the state that existed before MFBOpen      */b'     if(MFBCurrent->deviceType == TTY) {S 	/*f$ 	 * Output initialization end string 	 */# 	MFBGenCode(MFBFORMAT.endSequence);>   	/*. 	 * Flush the buffer 	 */
 	MFBUpdate();    #ifndef vms  	/*i 	 * Reset graphics tty options 	 *t@ 	 * NOTE: we must reset these options in just the opposite order? 	 * in which they were set.  The user might have opened his ownu= 	 * terminal, in which case the fileDesc is not unity, but wem. 	 * are still setting the standard i/o device. 	 */ 	bB 	/* the isatty() is necessary because user may be piping output */" 	if(isatty(MFBCurrent->fileDesc)){ 	    if(chmod(MFBCurrent->name,b@ 		MFBCurrent->oldstat.graphstat.st_mode) < 0) return(MFBBADOPT);, 	    if(ioctl(MFBCurrent->fileDesc,TIOCSETP,9 		&MFBCurrent->graphTtyb.oldttyb) < 0) return(MFBBADOPT);e, 	    if(ioctl(MFBCurrent->fileDesc,TIOCLSET,9 		&MFBCurrent->oldstat.graphttyw) < 0) return(MFBBADOPT);m 	    } 	tB 	/* the isatty() is necessary because user may be piping output */, 	if(MFBCurrent->fileDesc != 1 && isatty(1)){D 	    if(chmod(ttyname(2),MFBCurrent->oldstat.kybrdstat.st_mode) < 0) 		return(MFBBADOPT);= 	    if(ioctl(1,TIOCSETP,&MFBCurrent->kybrdTtyb.oldttyb) < 0)u 		return(MFBBADOPT);= 	    if(ioctl(1,TIOCLSET,&MFBCurrent->oldstat.kybrdttyw) < 0)r 		return(MFBBADOPT); 	    } #endif   	/*A 	 * don't close stdout 	 */ 	if(MFBCurrent->fileDesc != 1)( 	    if(close(MFBCurrent->fileDesc) < 0) 		return(MFBBADDEV); 	}       /*%      * Deinitialize the mfb structure       */s(     MFBCurrent->initializedBool = false;     free(MFBCurrent);d     return(MFBOK);     }a     intF
 MFBHalt(){     /*
      * Notes:u2      *    Called to disable the graphics sequence.N      *    Has same effect as MFBHalt, except that the MFBCurrent is not freed.      */      *    PERFECT FOR SUSPENDING A JOB IN UNIX!e      */          /*<      * Put terminal in the state that existed before MFBOpen      */*'     if(MFBCurrent->deviceType == TTY) {* 	/** 	 * Clear the output buffer  	 */
 	MFBUpdate();    	/*E$ 	 * Output initialization end string 	 */# 	MFBGenCode(MFBFORMAT.endSequence);*   	/** 	 * Flush the buffer 	 */
 	MFBUpdate();*   #ifndef vmst 	/*  	 * Reset graphics tty options 	 *e@ 	 * NOTE: we must reset these options in just the opposite order? 	 * in which they were set.  The user might have opened his own = 	 * terminal, in which case the fileDesc is not unity, but we . 	 * are still setting the standard i/o device. 	 */  B 	/* the isatty() is necessary because user may be piping output */" 	if(isatty(MFBCurrent->fileDesc)){ 	    if(chmod(MFBCurrent->name,t@ 		MFBCurrent->oldstat.graphstat.st_mode) < 0) return(MFBBADOPT);, 	    if(ioctl(MFBCurrent->fileDesc,TIOCSETP,9 		&MFBCurrent->graphTtyb.oldttyb) < 0) return(MFBBADOPT); , 	    if(ioctl(MFBCurrent->fileDesc,TIOCLSET,9 		&MFBCurrent->oldstat.graphttyw) < 0) return(MFBBADOPT);i 	    }  B 	/* the isatty() is necessary because user may be piping output */, 	if(MFBCurrent->fileDesc != 1 && isatty(1)){D 	    if(chmod(ttyname(2),MFBCurrent->oldstat.kybrdstat.st_mode) < 0) 		return(MFBBADOPT);= 	    if(ioctl(1,TIOCSETP,&MFBCurrent->kybrdTtyb.oldttyb) < 0)a 		return(MFBBADOPT);= 	    if(ioctl(1,TIOCLSET,&MFBCurrent->oldstat.kybrdttyw) < 0)( 		return(MFBBADOPT); 	    } #endif 	MFBCurrent->ttyIsSet = false; 	}       return(MFBOK);     }t          O  /*****************************************************************************m  *!  *		               INPUT ROUTINESs  *O  *****************************************************************************/{   inti MFBPoint(x,y,key,button)     int *x,*y,*button;     char *key;     /*
      * Notes:       *    None at this time.      */T     {t     int status;u     int retrnd;   '     if(!MFBCurrent->PointingDeviceBool). 	return(MFBNOPNT);&     if((retrnd = MFBFlushInput()) < 0) 	return(retrnd);     /*      * Enable Pointing Devicec      */ /     MFBCurrent->X = MFBCurrent->cursorColor1Id;M/     MFBCurrent->Y = MFBCurrent->cursorColor2Id; /     MFBGenCode(MFBFORMAT.enablePointingDevice);i'     MFBCurrent->X = MFBCurrent->Y = -1;g&     MFBCurrent->Z = MFBCurrent->T = 0;       /*A      * If Read Will Cause Immediate Transfer,Wait For a Character(      */t'     if(MFBCurrent->readImmediateBool) {.
 	MFBUpdate();)0 	MFBCurrent->Z = (*MFBCurrent->dsply_getchar)(); 	}       /*#      * Trigger Pointing Device Reado      */ -     MFBGenCode(MFBFORMAT.readPointingDevice);t       /*      * And Flush The Bufferd      */h     MFBUpdate();       /*"      * Read and Format Cursor Data      */uE     /* MFBDecode returns >= 0 if OK, character barfed on if ERROR. */ 8     status  = MFBDecode(MFBFORMAT.formatPointingDevice);     *button = MFBCurrent->T;"     *key    = (char)MFBCurrent->Z;     *x    = MFBCurrent->X;     *y    = MFBCurrent->Y;            /*      * Disable Pointing Device      */t0     MFBGenCode(MFBFORMAT.disablePointingDevice);       /*9      * MFBPoint may destroy last x/y,so be safe about it.b      */s1     MFBCurrent->lastX  = MFBCurrent->lastY  = -1;>  &     if((retrnd = MFBFlushInput()) < 0) 	return(retrnd);     if(status >= 0) {u 	/* character returned */  	*key = (char)status;) 	return(MFBOK);r 	}%     else if(status == MFBCAPNOFORMAT)  	return(MFBNOPTFT);t     else if(status == MFBCAPOK)- 	return(MFBOK);r     else 	return(MFBPNTERR);=     }*     char' *MFBKeyboard(x,y,background,foreground)S     int x,y;     int background;t     int foreground;D     {      /*
      * Notes:rB      *    Read type-in from keyboard until user types return key. 9      *    Do rub-out processing--rub out and ctrl-h keys.u      */;
     int Int1;n     int X,Y;     int MaxX,MaxY;     int OldTextMode;     int OldForeground;     int OldFillPattern;      static char MFBTypeIn[161];a     char c[2];  %     if(MFBCurrent->deviceType != TTY)  	return(NULL);
     Int1 = 0;      c[1] = NULL;'     OldTextMode = MFBCurrent->textMode; *     OldForeground = MFBCurrent->fgColorId;-     OldFillPattern = MFBCurrent->fillPattern;      MFBSetFillPattern(0);M     MFBSetTextMode(true);u     MFBSetColor(foreground);)     if(MFBFORMAT.keyboardStart == NULL ||r# 	*MFBFORMAT.keyboardStart == NULL){* 	/*o 	 * NAIVE KEYBOARD 	 */& 	if(!MFBCurrent->textPositionableBool) 	    return(NULL);7 	MaxX = MFBCurrent->maxX - MFBCurrent->keyboardXOffset;(7 	MaxY = MFBCurrent->maxY - MFBCurrent->keyboardYOffset; & 	/* echo characters using graphtext */% 	X = x + MFBCurrent->keyboardXOffset;r% 	Y = y + MFBCurrent->keyboardYOffset;e	 	for(;;){o< 	    X += (MFBCurrent->fontWidth + MFBCurrent->fontXOffset); 	    MFBUpdate();FA 	    if((*c = (*MFBCurrent->kybrd_getchar)()) == 13 || *c == 10){* 		MFBTypeIn[Int1] = NULL;  		break; 		}f; 	    else if(*c == 8 || *c == 0177){    /* ctrl-h or del */m9 		X -= (MFBCurrent->fontWidth + MFBCurrent->fontXOffset);n4 		if(Int1 > 0){		       /* can't bs further . . . */ 		    MFBSetColor(background);+ 		    MFBBox(X+MFBCurrent->keyboardXOffset, 9 			Y+MFBCurrent->keyboardYOffset-MFBCurrent->fontYOffset,d6 			X+MFBCurrent->keyboardXOffset+MFBCurrent->fontWidth  			    +MFBCurrent->fontXOffset,9 			Y+MFBCurrent->keyboardYOffset+MFBCurrent->fontHeight);  		    MFBSetColor(foreground);= 		    X -= (MFBCurrent->fontWidth + MFBCurrent->fontXOffset);F
 		    Int1--;  		    }  		}r; 	    else if(*c == 24 || *c == 21){  /* ctrl-x or ctrl-u */D 		MFBSetColor(background);' 		MFBBox(x+MFBCurrent->keyboardXOffset,n< 		    Y+MFBCurrent->keyboardYOffset-MFBCurrent->fontYOffset,$ 		    X+MFBCurrent->keyboardXOffset,< 		    Y+MFBCurrent->keyboardYOffset+MFBCurrent->fontHeight); 		MFBSetColor(foreground);& 		X = x + MFBCurrent->keyboardXOffset; 		Int1 = 0;  		}n" 	    else if(*c == 27){  /* esc */ 		MFBText(" ESCAPE",X,Y,0);( 		MFBTypeIn[0] = NULL; 		Int1 = 0;F 		break; 		} 
 	    else{ 		MFBTypeIn[Int1++] = *c;F 		X = MFBmin(MaxX,X);r 		Y = MFBmin(MaxY,Y);  		if(*c >= ' ' && *c <= '~') 		    MFBText(c,X,Y,0);  		else 		    MFBText("^",X,Y,0);  		}o 	    } 	}
     else {1 	MFBCurrent->X = x + MFBCurrent->keyboardXOffset;b1 	MFBCurrent->Y = y + MFBCurrent->keyboardYOffset;b% 	MFBGenCode(MFBFORMAT.keyboardStart);s 	MFBPutchar(' ');n	 	for(;;){  	    MFBPutchar(' ');X- 	    MFBGenCode(MFBFORMAT.keyboardBackspace);o 	    MFBUpdate();lA 	    if((*c = (*MFBCurrent->kybrd_getchar)()) == 13 || *c == 10){  		MFBTypeIn[Int1] = NULL;= 		break; 		}($ 	    else if(*c == 8 || *c == 0177){, 		if(Int1 == 0)	/* can't bs further . . . */ 		    MFBPutchar(7); 		else{> 		    MFBPutchar(' ');. 		    MFBGenCode(MFBFORMAT.keyboardBackspace);. 		    MFBGenCode(MFBFORMAT.keyboardBackspace);
 		    Int1--;e 		    }  		} : 	    else if(*c == 24 || *c == 21){	/* ctrl-x or ctrl-u */ 		for(; Int1 > 0; Int1--){ 		    MFBPutchar(' ');. 		    MFBGenCode(MFBFORMAT.keyboardBackspace);. 		    MFBGenCode(MFBFORMAT.keyboardBackspace); 		    }  		MFBPutchar(' ');* 		MFBGenCode(MFBFORMAT.keyboardBackspace); 		}e" 	    else if(*c == 27){  /* esc */ 		MFBTypeIn[0] = NULL; 		break; 		}t
 	    else{ 		MFBTypeIn[Int1++] = *c;/ 		if(*c >= ' ' && *c <= '~') 		    MFBPutchar(*c);g 		else 		    MFBPutchar('^'); 		}l 	    }# 	MFBGenCode(MFBFORMAT.keyboardEnd);	 	}      MFBSetTextMode(OldTextMode);     MFBSetColor(OldForeground);(&     MFBSetFillPattern(OldFillPattern);     /*<      * MFBKeyboard may destroy last x/y,so be safe about it.      */e0     MFBCurrent->lastX = MFBCurrent->lastY  = -1;       return(MFBTypeIn);     }             N /*****************************************************************************  *  *	    ERROR HANDLING ROUTINES  *O  *****************************************************************************/;   char * MFBError(errnum)     int errnum;T     {t
     int i;     static char result[200];     char *sprintf();$     for(i = 0; i < NUMERRORS; i++) {! 	if(errors[i].errnum == errnum) {M& 	    strcpy(result,errors[i].message); 	    return(result); 	    } 	}B     sprintf(result,"Illegal Error Number %d in MFBError!",errnum);     return(result);	     }   