 /*  * mfbtext.c  **  * Copyright -C- 1982 Giles C. Billingsley%  * sccsid "@(#)mfbtext.c	1.9  9/3/83"   *E  *     MFB is a graphics package that was developed by the integrated @  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atD  * the University of California, Berkeley, California.  The programs?  * in MFB are available free of charge to any interested party.nC  * The sale, resale, or use of these program for profit without the(F  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,c  * is forbidden.  */=  F  r #include "mfb.h"  % #define	MFBFORMAT	MFBCurrent->strings)    K /**************************************************************************B  *&  *                             MFBText  *E  *     MFBText contains MFB routines for the management of graphtext.r  *L  **************************************************************************/   void' MFBMore(Left,Bottom,Right,Top,Textfile) 
     int Left;e     int Bottom;      int Right;     int Top;     FILE *Textfile;)     { 1     char cbuf[200];		/* 200 chars per line max */|     int c,i;     int linecount;     int done = 0;a     int oldfillpattern;B     int oldforeground;     int nlines;r     int nchars;f     int controlchar;  (     /* test to be sure of window area */     if(Top < Bottom)         MFBSwapInt(Top,Bottom);e     if(Right < Left)         MFBSwapInt(Left,Right);t       /* calculate parameters */3     nlines = (Top - Bottom)/MFBCurrent->fontHeight; N     nchars = (Right - Left)/(MFBCurrent->fontWidth + MFBCurrent->fontXOffset);      nchars = MFBmin(nchars,200);       /* save old style ID's */n*     oldforeground = MFBCurrent->fgColorId;-     oldfillpattern = MFBCurrent->fillPattern;^       if(nlines <= 0) return;      linecount = 1;     MFBSetFillPattern(0);o     MFBSetColor(0);r"     MFBBox(Left,Bottom,Right,Top);     MFBSetColor(oldforeground);"     while(! done) {c 	i = 0;n 	controlchar = 0;M? 	while(i < nchars && (c = getc(Textfile)) != '\n' && c != EOF){  	    if(c == 9){ /* tab */ 		cbuf[i++] = ' ';4 		while(i < nchars && (i % 8) != 0) cbuf[i++] = ' '; 		}  	    else if(c < ' '){ 		if(controlchar == 0){c 		    cbuf[i++] = '^'; 		    controlchar = 1; 		    ungetc(c,Textfile);7 		    }e 		else{  		    cbuf[i++] = c + '@'; 		    controlchar = 0; 		    }e 		}	 	    else if(c <= '~') 	        cbuf[i++] = c;  	    } 	cbuf[i] = NULL; 	if(c == EOF) done = 1;|A 	MFBText(cbuf,Left,Top - (linecount) * MFBCurrent->fontHeight,0); 
 	MFBUpdate();'# 	if(done || ++linecount >= nlines){r 	    linecount = 1;F
 	    if(done)M) 	        MFBText("-DONE-",Left,Bottom,0);h	 	    else	6 	        MFBText("-MORE- (^D to exit)",Left,Bottom,0); 	    MFBUpdate(); ( 	    c = (*MFBCurrent->kybrd_getchar)(); 	    if(c == 4)  		done = 1;n             MFBSetColor(0);&# 	    MFBBox(Left,Bottom,Right,Top); '             MFBSetColor(oldforeground);  	    } 	}&     MFBSetFillPattern(oldfillpattern);     }t     void) MFBScroll(Left,Bottom,Right,Top,Textfile) 
     int Left;a     int Bottom;e     int Right;     int Top;     FILE *Textfile;/     { 1     char cbuf[200];		/* 200 chars per line max */F     int c,i,j;4     int curline;		/* current line in the textfile */     int linecount;     int done = 0;*     int oldfillpattern;*     int oldforeground;     int nlines;O     int nchars;*     int controlchar;  (     /* test to be sure of window area */     if(Top < Bottom)         MFBSwapInt(Top,Bottom);      if(Right < Left)         MFBSwapInt(Left,Right);h       /* calculate parameters */3     nlines = (Top - Bottom)/MFBCurrent->fontHeight;MN     nchars = (Right - Left)/(MFBCurrent->fontWidth + MFBCurrent->fontXOffset);      nchars = MFBmin(nchars,200);       /* save old style ID's */ *     oldforeground = MFBCurrent->fgColorId;-     oldfillpattern = MFBCurrent->fillPattern;*       if(nlines <= 0) return;*     curline = 1;     MFBSetFillPattern(0);      MFBSetColor(0);1"     MFBBox(Left,Bottom,Right,Top);     MFBSetColor(oldforeground);      while( !done ){i 	rewind(Textfile); 	/* skip first curline's */  	for(i = 1; i < curline; ++i){6 	    while((c = getc(Textfile)) != '\n' && c != EOF) ; 	    }#         /* output nlines of text */* 	linecount = 0;f$         for(j = 1; j < nlines; ++j){ 	    i = 0;* 	    controlchar = 0;rC 	    while(i < nchars && (c = getc(Textfile)) != '\n' && c != EOF){f 	        if(c == 9){ /* tab */ 		    cbuf[i++] = ' ';8 		    while(i < nchars && (i % 8) != 0) cbuf[i++] = ' '; 		    }c 	        else if(c < ' '){ 		    if(controlchar == 0){a 		        cbuf[i++] = '^'; 		        controlchar = 1; 		        ungetc(c,Textfile);  		        }< 		    else{c 		        cbuf[i++] = c + '@'; 		        controlchar = 0; 		        }  		    }T 	        else if(c <= '~') 	            cbuf[i++] = c;;
 	        } 	    if(c == '\n') ++linecount;  	    cbuf[i] = NULL;= 	    MFBText(cbuf,Left,Top - (j) * MFBCurrent->fontHeight,0);  	    MFBUpdate();t 	    if(c == EOF){
 		j = nlines;u 		done = 1;i 		}) 	    }	 	if(done) % 	    MFBText("-DONE-",Left,Bottom,0);  	elsecC 	    MFBText("-MORE- (^D to exit, ^U to scroll up)",Left,Bottom,0);h
 	MFBUpdate(); $ 	c = (*MFBCurrent->kybrd_getchar)();
 	--linecount;  	if(c == 4)e 	    done = 1; 	else if(c == 21){ 	    curline -= linecount; 	    if(curline < 1) 		curline = 1; 	    } 	elseB 	    curline += linecount;         MFBSetColor(0);( 	MFBBox(Left,Bottom,Right,Top); #         MFBSetColor(oldforeground);  	}&     MFBSetFillPattern(oldfillpattern);     }t