 /*	  * move.c,  **  * Copyright -C- 1981 Giles C. Billingsley"  * sccsid "@(#)move.c	1.1  9/5/83"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programa;  * KIC is available free of charge to any interested party. B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,d  * is forbidden.  */S  c  e /*  * Move selection operator.D  */k   #include "kic.h" #include "select.h"(   /*M  * we assume that the selectQ contains no more than MAXARRAYS instance arrays>  */n #define MAXARRAYS	300)   struct ArrayData {     struct o *Pointer;     int DeltaX,DeltaY;     };   int UndoTheMove; int RotationAngle; int ReferencePointX; int ReferencePointY; int MovedToPointX; int MovedToPointY;   Move(LookedAhead)I     int *LookedAhead;l     {c     struct ka OldSelectQBB;i     struct ka BB;f.     struct ArrayData SaveArrayData[MAXARRAYS];     struct ks *SelectQDesc;      struct p *Path;e     struct o *Pointer;     struct t *TGen;A     struct prpty *PrptyDesc;     char Type;     char *SymbolName;P     char *Label;     int NumArrays;
     int i;     int Width, Length, temp;     int X,Y;     int Layer;     int NumX,DX,NumY,DY;     int l,b,r,t;     int lc,bc,rc,tc;     int DeltaX,DeltaY;     int FirstTime = True;N     int TF[9];  J     ReferencePointX = ReferencePointY = MovedToPointX = MovedToPointY = 0;     DeltaX = DeltaY = 0;     MenuSelect(MenuMOVE);i     if(SelectQHead == NULL){7 	ShowPrompt("You haven't selected anything to move."); 	 	MenuDeselect(MenuMOVE); 	return; 	}     *LookedAhead = False;T     UndoTheMove = 0;     NumArrays = 0;
     loop {- 	ShowPrompt("Point to the reference point.");Y	 	Point();0 	if(strcmp(Parameters.kpCommand,MenuUNDO) == 0){ 	    if(FirstTime){  		MenuDeselect(MenuMOVE);e 		*LookedAhead = True;	 		return;R 		}e 	    MenuSelect(MenuUNDO);- 	    SwapInts(ReferencePointX,MovedToPointX);Q- 	    SwapInts(ReferencePointY,MovedToPointY);k 	    UndoTheMove += 1; 	    MenuDeselect(MenuUNDO); 	    } 	elif(GetCurrentTransform()){  	    FirstTime = True; 	    continue; 	    }& 	elif(Parameters.kpCommand[0] != EOS){ 	    MenuDeselect(MenuMOVE); 	    *LookedAhead = True;, 	    return; 	    }& 	elif(Parameters.kpPointCoarseWindow){" 	    ReferencePointX = Cursor.kcX;" 	    ReferencePointY = Cursor.kcY; 	    UndoTheMove = 0;u 	    } 	else{ 	    MenuDeselect(MenuMOVE); 	    return; 	    } 	if(Not (UndoTheMove & 1)) 	    NumArrays = 0;t 	if(Not UndoTheMove){,
 	    loop{A 		ShowPrompt("Point to where the selected items will be moved."); 
 		Point();  		if(Not GetCurrentTransform()){) 		    if(Parameters.kpCommand[0] != EOS){m 			MenuDeselect(MenuMOVE); 			*LookedAhead = True;p
 			return; 			}+ 		    elif(Parameters.kpPointCoarseWindow){	 			MovedToPointX = Cursor.kcX; 			MovedToPointY = Cursor.kcY;	 			break;i 			} 		    else{i 			NotPointingAtLayout();r 			} 		    }c 		}t  	    MovedToPointX = Cursor.kcX;  	    MovedToPointY = Cursor.kcY; 	    } 	FirstTime = False;r 	Parameters.kpModified = True;	 	TPush();e 	GetMoveTransform(); 	SelectQComputeBB(); r 	OldSelectQBB = SelectQBB; 	SelectQDesc = SelectQHead;  	while(SelectQDesc != NULL){* 	    CDType(SelectQDesc->ksPointer,&Type);; 	    RemovePropertyList(SelectQDesc->ksPointer,&PrptyDesc);) 	    if(Type == CDLABEL){i6 		CDLabel(SelectQDesc->ksPointer,&Layer,&Label,&X,&Y); 		TPoint(&X,&Y); 		/*8 		 * Mark object as conditionally deleted even though it6 		 * really is deleted or else ShowSelectQ will try to2 		 * show it.  This is a hack, but not too dirty.  		 */O< 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,2);9 		CDDelete(Parameters.kpCellDesc,SelectQDesc->ksPointer);}7 		if(Not CDMakeLabel(Parameters.kpCellDesc,Layer,Label,15 		    X,Y,&(SelectQDesc->ksPointer))) MallocFailed();5< 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,1); 		}  	    elif(Type == CDBOX){u< 		CDBox(SelectQDesc->ksPointer,&Layer,&Length,&Width,&X,&Y); 		TPoint(&X,&Y);2 		if(RotationAngle == 90 Or RotationAngle == 270){ 		    temp = Width;e 		    Width = Length;r 		    Length = temp; 		    }e< 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,2);9 		CDDelete(Parameters.kpCellDesc,SelectQDesc->ksPointer);t< 		if(Not CDMakeBox(Parameters.kpCellDesc,Layer,Length,Width,5 		    X,Y,&(SelectQDesc->ksPointer))) MallocFailed(); < 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,1); 		}c  	    elif(Type == CDSYMBOLCALL){A 		CDCall(SelectQDesc->ksPointer,&SymbolName,&NumX,&DX,&NumY,&DY);  		/*7 		 * To handle transforms of instance arrays correctly, 8 		 * we need the BB of the original array.  We apply the; 		 * transform to this BB, and that tells us what the final / 		 * position of the transformed array MUST be.  		 *; 		 * KIC does not handle instance arrays well (the NumX ando7 		 * NumY values are always positive).  If the array iso? 		 * rotated, the NumX and NumY values could effectively becomer9 		 * negative.  We must deal with this by translating thet8 		 * array such that the NumX and NumY will be positive. 		 * e< 		 * The algorithm is to define the transform without regard: 		 * to the positioning error.  We create a dummy cell and: 		 * compute it's bounding box.  We know that the cells in: 		 * this dummy array are rotated and mirrored accurately,6 		 * but the array is offset because of the NumX, NumY; 		 * phenomenon described above.  We delete the dummy cell,t6 		 * compare its BB with the BB that we computed above5 		 * (the one which we know is correct BB), and add aF= 		 * translation to the current transform that would make the 9 		 * two BB's identical.  The translation is saved in the 9 		 * array 'SaveArrayData' so that it does not have to bee4 		 * recomputed if the user decides to do an 'UNDO'. 		 */ B 		CDStatusInt = CDBB(Parameters.kpCellDesc,SelectQDesc->ksPointer, 		    &l,&b,&r,&t);D4 		/* find the transform of the BB of the instance */ 		TPoint(&l,&b); 		TPoint(&r,&t);< 		/* these values must be swapped for 90 or 270 rotations */( 		if(Parameters.kpRotationAngle == 90 Or) 		    Parameters.kpRotationAngle == 270){y 		    SwapInts(NumX,NumY); 		    SwapInts(DX,DY); 		    }P@ 		/* erase instance marker, but don't mess-up transform stack */	 		TPop();N. 		Parameters.kpEnableSelectQRedisplay = False;: 		ShowInstanceMarker(ERASE,Parameters.kpHighlightingPixel, 		    SelectQDesc->ksPointer);- 		Parameters.kpEnableSelectQRedisplay = True;y
 		TPush(); 		/*4 		 * The symbol transform must be handled separately; 		 * to correctly deal with arrays.  We apply the transformn; 		 * of the instance to the current transform, and then add	; 		 * the transform requested by the current move operation.s 		 */t 		TIdentity();6 		/* the only possible error here is CDMALLOCFAILED */: 		if(Not CDBeginMakeCall(Parameters.kpCellDesc,SymbolName,  		    NumX,DX,NumY,DY,&Pointer))' 		    if(CDStatusInt == CDMALLOCFAILED)a 			MallocFailed();+ 		CDInitTGen(SelectQDesc->ksPointer,&TGen);r 		loop {2 		    /* determine transform of the placed cell */  		    CDTGen(&TGen,&Type,&X,&Y); 		    if(TGen == NULL)	 			break;r  		    elif(Type == CDTRANSLATE){ 			TTranslate(X,Y);{ 			} 		    elif(Type == CDROTATE){t 			TRotate(X,Y); 			} 		    elif(Type == CDMIRRORY){	 			TMY();e 			} 		    elif(Type == CDMIRRORX){	 			TMX();i 			} 		    }T* 		/* only necessary for instance arrays */7     		if((UndoTheMove & 1) And (NumX > 1 Or NumY > 1)){u 		    DeltaX = DeltaY = 0;! 		    for(i=0; i<NumArrays; ++i){ : 			if(SaveArrayData[i].Pointer == SelectQDesc->ksPointer){) 			     DeltaX = SaveArrayData[i].DeltaX;t) 			     DeltaY = SaveArrayData[i].DeltaY;r 			     break;	 			     }a 			}" 		    TTranslate(-DeltaX,-DeltaY); 		    },: 		/* now add the previous transform to that of the move */0 		TTranslate(-ReferencePointX,-ReferencePointY);E     		/* The '&' is necessary so that Undo can be it's own inverse */      		if(UndoTheMove & 1){ 		    if(RotationAngle != 0){e 			if(RotationAngle == 180){ 			    TRotate(-1,0);e 			    } 			elif(RotationAngle == 90){L 			    TRotate(0,1); 			    } 			elif(RotationAngle == 270){ 			    TRotate(0,-1);  			    } 		        }e 		    if(Parameters.kpMY){	 			TMY();  		        }  		    if(Parameters.kpMX){	 			TMX();  		        }  		    }Y 		else{s 		    if(Parameters.kpMX){	 			TMX();r 		        }L 		    if(Parameters.kpMY){	 			TMY();D 		        }r 		    if(RotationAngle != 0){f 			if(RotationAngle == 180){ 			    TRotate(-1,0);	 			    } 			elif(RotationAngle == 90){D 			    TRotate(0,1); 			    } 			elif(RotationAngle == 270){ 			    TRotate(0,-1);a 			    } 		        }a 		    }t* 		TTranslate(MovedToPointX,MovedToPointY); 		TCurrent(TF);e$ 		AddResultingTransform(Pointer,TF);8 		if((Not(UndoTheMove & 1)) And (NumX > 1 Or NumY > 1)){: 		    if(Not CDEndMakeCall(Parameters.kpCellDesc,Pointer)) 		        MallocFailed();i7 		    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,l 			&lc,&bc,&rc,&tc);. 		    CDDelete(Parameters.kpCellDesc,Pointer);1 		    /* only possible error is CDMALLOCFAILED */l> 		    if(Not CDBeginMakeCall(Parameters.kpCellDesc,SymbolName,$ 		        NumX,DX,NumY,DY,&Pointer))+ 		        if(CDStatusInt == CDMALLOCFAILED)o 			    MallocFailed(); #ifdef DEBUG {	 char turtle[100];eM sprintf(turtle,"transformed values: l = %d, b = %d  r = %d, t = %d",l,b,r,t);c ShowPromptAndWait(turtle);U sprintf(turtle,"transformed values: lc = %d, bc = %d  rc = %d, tc = %d",lc,bc,rc,tc);n ShowPromptAndWait(turtle); }T #endif 		    l = min(l,r);t 		    b = min(b,t);h 		    lc = min(lc,rc); 		    bc = min(bc,tc);@ 		    /* we compare BB's of the dummy cell and the correct BB */ 		    DeltaX = l - lc; 		    DeltaY = b - bc;  		    TTranslate(DeltaX,DeltaY); 		    TCurrent(TF);T( 		    AddResultingTransform(Pointer,TF); 		    }p6 		if(Not CDEndMakeCall(Parameters.kpCellDesc,Pointer)) 		    MallocFailed();a< 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,2);9 		CDDelete(Parameters.kpCellDesc,SelectQDesc->ksPointer);s# 		SelectQDesc->ksPointer = Pointer;t< 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,1);8 		if((Not(UndoTheMove & 1)) And (NumX > 1 Or NumY > 1)){! 		    /* Save the array offset */	" 		    if(++NumArrays > MAXARRAYS){E 			ShowPromptAndWait("Sorry, you have too many instances selected.");T 			NumArrays = MAXARRAYS;R 			} 		    i = NumArrays - 1;> 		    /* the particular array is identified by this pointer */8 		    SaveArrayData[i].Pointer = SelectQDesc->ksPointer;' 		    SaveArrayData[i].DeltaX = DeltaX;-' 		    SaveArrayData[i].DeltaY = DeltaY;= 		    }	' 		/* must rebuild the move transform */a 		GetMoveTransform();  		}o 	    elif(Type == CDWIRE){5 		CDWire(SelectQDesc->ksPointer,&Layer,&Width,&Path);  		CopyPathWithXForm(&Path);p< 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,2);9 		CDDelete(Parameters.kpCellDesc,SelectQDesc->ksPointer);t; 		if(Not CDMakeWire(Parameters.kpCellDesc,Layer,Width,Path,!1 		    &(SelectQDesc->ksPointer))) MallocFailed();e< 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,1); 		}0 	    elif(Type == CDPOLYGON){n1 		CDPolygon(SelectQDesc->ksPointer,&Layer,&Path);	 		CopyPathWithXForm(&Path);s< 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,2);9 		CDDelete(Parameters.kpCellDesc,SelectQDesc->ksPointer);n8 		if(Not CDMakePolygon(Parameters.kpCellDesc,Layer,Path,1 		    &(SelectQDesc->ksPointer))) MallocFailed();o< 		CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,1); 		}t; 	    RestorePropertyList(SelectQDesc->ksPointer,PrptyDesc);*' 	    SelectQDesc = SelectQDesc->ksSucc;n 	    } 	TPop(); 	SelectQComputeBB(); m; 	if(InBox(SelectQBB.kaLeft,SelectQBB.kaBottom,OldSelectQBB)o< 	    Or InBox(SelectQBB.kaLeft,SelectQBB.kaTop,OldSelectQBB)@ 	    Or InBox(SelectQBB.kaRight,SelectQBB.kaBottom,OldSelectQBB)= 	    Or InBox(SelectQBB.kaRight,SelectQBB.kaTop,OldSelectQBB) B 	    Or InBox(OldSelectQBB.kaLeft,OldSelectQBB.kaBottom,SelectQBB)? 	    Or InBox(OldSelectQBB.kaLeft,OldSelectQBB.kaTop,SelectQBB)mC 	    Or InBox(OldSelectQBB.kaRight,OldSelectQBB.kaBottom,SelectQBB)*B 	    Or InBox(OldSelectQBB.kaRight,OldSelectQBB.kaTop,SelectQBB)){ 	    /*u. 	     * Old SelectQBB intersects new SelectQBB 	     */; 	    BB.kaLeft = min(OldSelectQBB.kaLeft,SelectQBB.kaLeft);DA 	    BB.kaBottom = min(OldSelectQBB.kaBottom,SelectQBB.kaBottom);e> 	    BB.kaRight = max(OldSelectQBB.kaRight,SelectQBB.kaRight);8 	    BB.kaTop = max(OldSelectQBB.kaTop,SelectQBB.kaTop); 	    EraseBox(BB,BB); ) 	    Redisplay(Parameters.kpCellDesc,BB);b 	    } 	else{ 	    /**5 	     * Old SelectQBB is not within the new SelectQBB/ 	     * So, redisplay twice. 	     */) 	    EraseBox(OldSelectQBB,OldSelectQBB);)1 	    Parameters.kpEnableSelectQRedisplay = False;Y3 	    Redisplay(Parameters.kpCellDesc,OldSelectQBB);e# 	    EraseBox(SelectQBB,SelectQBB); 0 	    Parameters.kpEnableSelectQRedisplay = True;0 	    Redisplay(Parameters.kpCellDesc,SelectQBB); 	    } 	}     }n     GetMoveTransform(){l     int TX, TY;	     TIdentity();2     TTranslate(-ReferencePointX,-ReferencePointY);/     RotationAngle = Parameters.kpRotationAngle; C     /* The '&' is necessary so that Undo can be it's own inverse */      if(UndoTheMove & 1){ 	if(RotationAngle == 90) 	    RotationAngle = 270;	 	elif(RotationAngle == 270)D 	    RotationAngle = 90;         if(RotationAngle != 0){P             TX = TY = 0;#             if(RotationAngle == 90)n     	        TY = 1;&             elif(RotationAngle == 180)     	        TX = -1;D&             elif(RotationAngle == 270)     	        TY = -1;l             TRotate(TX,TY);1
             }e         if(Parameters.kpMY)D             TMY();         if(Parameters.kpMX)	             TMX();0         TTranslate(MovedToPointX,MovedToPointY);	         }t	     else{D         if(Parameters.kpMX)S             TMX();         if(Parameters.kpMY)P             TMY();         if(RotationAngle != 0){-             TX = TY = 0;#             if(RotationAngle == 90)s     	        TY = 1;&             elif(RotationAngle == 180)     	        TX = -1;r&             elif(RotationAngle == 270)     	        TY = -1;T             TRotate(TX,TY);m
             }e0         TTranslate(MovedToPointX,MovedToPointY); 	}     }(     MovePath(TX,TY,Path)     struct p **Path;     int TX,TY;     {.     /*D      * Add translation TX,TY to the path doubly pointed to by 'Path'      */o      struct p *OldPair, *NewPair;     OldPair = *Path;@     if((NewPair = (struct p *)malloc(sizeof(struct p))) == NULL) 	MallocFailed();     *Path = NewPair;"     NewPair->pX = OldPair->pX+TX; "     NewPair->pY = OldPair->pY+TY;      NewPair->pSucc = NULL;     OldPair = OldPair->pSucc;      while(OldPair != NULL){nD 	if((NewPair->pSucc = (struct p *)malloc(sizeof(struct p))) == NULL) 	    MallocFailed(); 	NewPair = NewPair->pSucc; 	NewPair->pX = OldPair->pX+TX; B 	NewPair->pY = OldPair->pY+TY; l 	NewPair->pSucc = NULL;Q 	OldPair = OldPair->pSucc; 	}     }l    ! AddResultingTransform(Pointer,TF)a     struct o *Pointer;     int *TF;     {e     int A,B,C,D,TX,TY;     int ret;     /*4      * Take the transformation defined in TF and add5      * it to the symbol call currently being created.l      *(      *                  | a    c    0  |(      * Transform = TM = | b    d    0  |(      *                  | TX   TY   1  |      *      * A = TM[0][0] = TF[0];      * B = TM[1][0] = TF[3];      * C = TM[0][1] = TF[1];      * D = TM[1][1] = TF[4];      * TX = TM[2][0] = TF[6];e      * TY = TM[2][1] = TF[7];       */ /     A = TF[0]; B = TF[3]; C = TF[1]; D = TF[4];f     TX = TF[6]; TY = TF[7];n1     if(A == 0 And B == 1 And C == 1 And D == 0) {i 	/* MX R 0 -1 T tx,ty */ #ifdef DEBUG' ShowPromptAndWait("MX R 0 -1 T tx,ty");i #endif" 	ret = CDT(Pointer,CDMIRRORX,0,0);# 	ret &= CDT(Pointer,CDROTATE,0,-1); ' 	ret &= CDT(Pointer,CDTRANSLATE,TX,TY);t 	}5     elif(A == 0 And B == -1 And C == -1 And D == 0) {, 	/* MX R 0 1 T tx,ty */u #ifdef DEBUG& ShowPromptAndWait("MX R 0 1 T tx,ty"); #endif" 	ret = CDT(Pointer,CDMIRRORX,0,0);" 	ret &= CDT(Pointer,CDROTATE,0,1);' 	ret &= CDT(Pointer,CDTRANSLATE,TX,TY);) 	}4     elif(A == 0 And B == 1 And C == -1 And D == 0) { 	/* R 0 -1 T tx,ty */h #ifdef DEBUG$ ShowPromptAndWait("R 0 -1 T tx,ty"); #endif" 	ret = CDT(Pointer,CDROTATE,0,-1);' 	ret &= CDT(Pointer,CDTRANSLATE,TX,TY);T 	}4     elif(A == 0 And B == -1 And C == 1 And D == 0) { 	/* R 0 1 T tx,ty */ #ifdef DEBUG# ShowPromptAndWait("R 0 1 T tx,ty");a #endif! 	ret = CDT(Pointer,CDROTATE,0,1);D' 	ret &= CDT(Pointer,CDTRANSLATE,TX,TY);. 	}3     elif(A == 1 And B == 0 And C == 0 And D == 1) {i 	/* T tx,ty */ #ifdef DEBUG ShowPromptAndWait("T tx,ty");s #endif& 	ret = CDT(Pointer,CDTRANSLATE,TX,TY); 	}5     elif(A == -1 And B == 0 And C == 0 And D == -1) {* 	/* R -1 0 T tx,ty */s #ifdef DEBUG$ ShowPromptAndWait("R -1 0 T tx,ty"); #endif" 	ret = CDT(Pointer,CDROTATE,-1,0);' 	ret &= CDT(Pointer,CDTRANSLATE,TX,TY);r 	}4     elif(A == -1 And B == 0 And C == 0 And D == 1) { 	/* MX T tx,ty */  #ifdef DEBUG  ShowPromptAndWait("MX T tx,ty"); #endif" 	ret = CDT(Pointer,CDMIRRORX,0,0);' 	ret &= CDT(Pointer,CDTRANSLATE,TX,TY);Y 	}	     else{	 	/* MY T tx,ty */  #ifdef DEBUG  ShowPromptAndWait("MY T tx,ty"); #endif" 	ret = CDT(Pointer,CDMIRRORY,0,0);' 	ret &= CDT(Pointer,CDTRANSLATE,TX,TY);  	}     if(Not ret)P 	MallocFailed();     }e