 /*  * nmalloc.c  *7  * Copyright -C- 1981 Peter P. Moore, Giles Billingsley %  * sccsid "@(#)nmalloc.c	1.1  9/5/83"e  *;  *  A new malloc/free package for virtual memory machines. [  *8  *		A seperate freelist is kept for each object of size H  *  sizeof(NM_ALIGN) to NM_MAX_INDEX*sizeof(NM_ALIGN), where NM_ALIGN is@  *  the smallest-sized type having the most stringent alignment G  *  requirement on the particular machine. ( i.e. an int on the VAX ). rF  *  Any objects larger than NM_MAX_INDEX*sizeof(NM_ALIGN) is allocatedG  *  and free'd by using the old malloc and free respectively. The spacerF  *  is allocated in blocks of size BLOCK_SIZE, but this can be changedG  *  by calling nm_set_block_size(new_size). The relevant routines are :,  *A  *	    nm_malloc(size) : same syntax and usage as the old malloc.   *A  *	    nm_free(ptr, size) : free the object pointed to by ptr and   *				 of size 'size'.  *	    TC  *	    In order to allow compatibility with the old malloc and free H  *  three macros are defined in nmalloc.h : malloc(size), free(ptr), andG  *  alloc(type). Malloc and free are the same as of old, alloc returns TF  *  a properly cast pointer to an object of type 'type' ( i.e. it willD  *  keep lint quiet ). So to replace the old malloc/free, simply putB  *  #include "nmalloc.h" in any file that does malloc or free and   *  recompile with nmalloc.o.A  *-  *	Keep the following dire warnings in mind :t  *?  *	    You may use the old and new mallocs in the same program, C  *	    but DO NOT use my free on something the old malloc allocatedX  *	    or vice-versa.=  *=  *	    If you use the free(ptr) macro, sizeof(*ptr) better bef9  *	    the same as the size you used in the malloc, i.e. T  *		      *		    int *ptr;t   *		    ptr = (int *)malloc(40);  *		    free(ptr);  *>  *	    will cause the allocated object of size 40 to be placed?  *	    in the freelist for objects of size 4 ( sizeof(int) = 4 D<  *	    on a VAX). This could cause extreme difficulties. You=  *	    don`t have to worry about this if all your allocations   *	    are of the form :  *		  *		    thing *ptr; -  *		    ptr = (thing *) malloc(sizeof(thing))   *		    (* usage of ptr *)  *		    free(ptr);  *  *	    or better yet :  *		      *		    thing *ptr;X  *		    ptr = alloc(thing);   *		    (* usage of pointers *)   *		    free(ptr);  *A  *	    But if you are doing a lot of type casting of pointers or XC  *	    other jockish things, then explicit use of nm_free(ptr,size)S  *	    is suggested.  *  *?  *	The *( (char **) ptr) constructs are used to recast portionse;  *	of the objects as linking pointers to chain them to the g  *	freelist.  *  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program);  * KIC is available free of charge to any interested party.*B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */   4 #define NM_MAX_INDEX 20		/* see above description */1 #define NM_ALIGN int		/* see above description */ < #define BLOCK_SIZE 2048		/* the amount of space requested in 				   each block allocation */o   #define nm_align(size)\ B     /* round size to next largest multiple of sizeof(NM_ALIGN) */\D     (( int )(( (int) size + sizeof(NM_ALIGN) - 1)/sizeof(NM_ALIGN)))   #ifndef vmsd
 char *sbrk();} #endif   char *malloc();r) char *nm_slow_alloc(), *nm_block_alloc();;$ char *nm_freelist[NM_MAX_INDEX + 1];   int nm_block_size = BLOCK_SIZE;      char *nm_malloc(size)      /*  5      *  return a pointer to an object of size 'size',g9      *  allocating a new block of free space if necessary|      */T     unsigned int size;     {|     register char *temp;(     register int index = nm_align(size);  A     if ( index > NM_MAX_INDEX ) {	/* too large, use old malloc */M 	return( nm_slow_alloc(size) );i 	}2     else if ( nm_freelist[index] == (char *) 0 ) {. 	/* out of free space, allocate a new block */( 	return( nm_block_alloc( (int) size ) ); 	}
     else {* 	/* return the top item on the freelist */ 	temp = nm_freelist[index];** 	nm_freelist[index] = *( (char **) temp );! 	*( (char **) temp) = (char *) 0;  	return( temp ); 	}     }i   nm_free(ptr,size)      /*  7      *	Free the object pointed to by ptr of size 'size'l      */o     char *ptr;
     int size;m     {	(     register int index = nm_align(size);  ?     if ( index > NM_MAX_INDEX ) { /* too large, use old free */r 	nm_slow_free(ptr);o 	}
     else {& 	/* link to the top of the freelist */) 	*( (char **) ptr ) = nm_freelist[index];o# 	nm_freelist[index] = (char *) ptr;* 	}     }    char *nm_block_alloc(size)     /*=      *	Allocate a block of size nm_block_size, aligned to theo      *	sizeof(NM_ALIGN)       */g
     int size;      {*     int index = nm_align(size);s     char *ptr;6     char *current_pos, *start_of_block, *end_of_block;"     size = sizeof(NM_ALIGN)*index;
 #ifdef vmsH     if((start_of_block = (char *) malloc(nm_block_size)) == (char *) 0 ) 	return( (char *) 0);s #elsea     current_pos = sbrk(0);G     start_of_block = (char *) (nm_align(current_pos)*sizeof(NM_ALIGN));  #endif2     end_of_block = start_of_block + nm_block_size; #ifndef vmsr<     if ( sbrk(end_of_block - current_pos) ==  (char *) -1) { 	/* out of memory */ 	return( (char *) 0);  	} #endifJ     for(ptr = start_of_block; ptr <= end_of_block - 2*size; ptr += size) {5 	/* link all the objects in the new block together */a! 	*( (char **) ptr ) = ptr + size;n 	}$     *( (char **) ptr ) = (char *) 0;/     nm_freelist[index] = start_of_block + size;i     return( start_of_block );	     }    char *nm_slow_alloc(size)      unsigned size;     {n     return(malloc(size));z     }    nm_slow_free(ptr)x     char *ptr;     {i     free(ptr);     }    nm_set_block_size(size)e
     int size;1     {f     nm_block_size = size;d     }*  