 /*  * parser.ct  **  * Copyright -C- 1981 Giles C. Billingsley$  * sccsid "@(#)parser.c	1.1  9/5/83"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program ;  * KIC is available free of charge to any interested party. B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */   0 /*  * Fast CIF file parser.  *  D  * It is easy to use it to write programs that traverse a CIF file.   *  * Examples follows.1  * 1.    A program that translates CIF to STREAM. <  * 2.    A pattern factoring program for PG tape generation.  *       See TI's PFP.*  * 3.    A statistics generation program. J  * 4.    A program that extracts each symbol, generates a name for it, and2  *       writes it to a file.  See the CD package.O  * 5.    A program that builds a binary representation of the CIF file that can0L  *       then be edited via procedure calls and then written back to the CIF#  *       file.  See the CD package.7  * 3  * Here's how you use it.0  *  7  * First, you include the files actions.c and parser.h.0=  * Then you invoke PCIF(CIFFileName,StatusString,StatusInt). 0O  * Each time the parser recognizes a CIF command, it invokes an action routine.8@  * You should fill in the action routines in the file Actions.c.-  * Each action routine name is prefixed by A.0  * 0A  * Each parser routine and global variable name is prefixed by P. K  * StatusInt == PFAILED if the parse failed and an error message along with0@  * about where in the CIF file the error is in the StatusString.7  * Else StatusInt == PSUCCEEDED and StatusString == "".-  * ;  */;   #include "parser.h"0 #include "cd.h"0   /* Library routines */ #ifndef vms char *sprintf(); #endif  ( PCIF(CIFFileName,StatusString,StatusInt)%     char *CIFFileName,**StatusString;      int *StatusInt;;     {      PStatus[0] = EOS;      *StatusString = PStatus;I     if((PCIFFileDesc = POpen(CIFFileName,"r",(char *)NULL,(char **)NULL))7
 	== NULL){
 	PChar = EOF;0  	PError("Can't open CIF file."); 	*StatusInt = PFAILED; 	return; 	}	     loop{08 	PCharacter(PReturned,PSTRIPWHITESPACE2,PDONTFAILONEOF); 	if(PReturned == PFAILED){ 	    fclose(PCIFFileDesc); 	    *StatusInt = PFAILED; 	    return; 	    } 	elif(PChar == 'D'){8 	    PCharacter(PReturned,PSTRIPWHITESPACE2,PFAILONEOF); 	    if(PReturned == PFAILED){ 		fclose(PCIFFileDesc);0 		*StatusInt = PFAILED;0	 		return;- 		}; 	    elif(PChar == 'S'){ 		if(PSymbol() == PFAILED){b 		    fclose(PCIFFileDesc);0 		    *StatusInt = PFAILED;N
 		    return;4 		    }; 		}0 	    elif(PChar == 'D'){! 		if(PDeleteSymbol() == PFAILED){0 		    fclose(PCIFFileDesc);0 		    *StatusInt = PFAILED;0
 		    return;  		    }0 		}0 	    } 	elif(PChar == 'E'){ 	    *StatusInt = PEnd();3 	    return; 	    }4 	elif((PReturned = PPrimitiveCommand()) == PFAILED){ 	    fclose(PCIFFileDesc); 	    *StatusInt = PFAILED; 	    return; 	    }# 	elif(PReturned == PNOTAPPLICABLE){ . 	    PError("Can't understand next command."); 	    fclose(PCIFFileDesc); 	    *StatusInt = PFAILED; 	    return; 	    } 	}     }    PPrimitiveCommand(){     if(PChar == 'P') 	return(PPolygon());		     elif(PChar == 'B') 	return(PBox());     elif(PChar == 'W') 	return(PWire());f     elif(PChar == 'L') 	return(PLayer());     elif(PChar == 'C') 	return(PCall());_     elif(PChar == 'R') 	return(PRoundFlash());M'     elif('0' <= PChar And PChar <= '9')L 	return(PUserExtension());     elif(PChar == '(') 	return(PComment());     elif(PChar == ';') 	return(PSUCCEEDED);     else 	return(PNOTAPPLICABLE);     }|   PEnd(){      AEnd();i     fclose(PCIFFileDesc);t     return(PSUCCEEDED);t     }i  
 PSymbol(){
     char For;      int SymbolNum,A,B;   #ifdef TRACT& fprintf(stderr," ENTERING PSYMBOL\n"); #endif#     PInteger(PReturned,PFAILONEOF);C     if(PReturned == PFAILED) 	return(PFAILED);n     SymbolNum = PInt;r     A = B = 1;!     /* look for scaling factor */ &     for(For = '0'; For <= '9'; ++For){4         PLookAhead(PReturned,PSTRIPWHITESPACE3,For);          if(PReturned == PFAILED) 	    return(PFAILED);a         if(PChar == For){n 	    ungetc(For,PCIFFileDesc);! 	    if(PPoint(&A,&B) == PFAILED)r 	        return(PFAILED);h 	    break;; 	    } 	}     PLookForSemi(PReturned);     if(PReturned == PFAILED) 	return(PFAILED); /     if(ABeginSymbol(SymbolNum,A,B) == PFAILED){E 	PErrorCD(); 	return(PFAILED);; 	}     if(PReturned == PFAILED) 	return(PFAILED);*	     loop{ 4 	PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF); 	if(PReturned == PFAILED)s 	    return(PFAILED);;2 	if((PReturned = PPrimitiveCommand()) == PFAILED){ 	    return(PFAILED);  	    }" 	elif(PReturned == PNOTAPPLICABLE) 	    break;  	}     if(PChar != 'D') 	return(PFAILED);}7     PCharacter(PReturned,PSTRIPWHITESPACE2,PFAILONEOF);H     if(PReturned == PFAILED) 	return(PFAILED);L     if(PChar != 'F') 	return(PFAILED);I     PLookForSemi(PReturned);     if(PReturned == PFAILED) 	return(PFAILED);F     AEndSymbol();o     return(PSUCCEEDED);      }I   PDeleteSymbol(){#     PInteger(PReturned,PFAILONEOF);(     if(PReturned == PFAILED) 	return(PFAILED);0	     else{o 	PLookForSemi(PReturned);S 	if(PReturned == PFAILED)  	    return(PFAILED);0 	ADeleteSymbol(PInt);= 	return(PSUCCEEDED); 	}     }3   PCall(){     int SymbolNum,X,Y;  #     PInteger(PReturned,PFAILONEOF);{     if(PReturned == PFAILED) 	return(PFAILED);F     SymbolNum = PInt; )     if(ABeginCall(SymbolNum) == PFAILED){  	PErrorCD(); 	return(PFAILED);t 	}	     loop{ 4 	PCharacter(PReturned,PSTRIPWHITESPACE2,PFAILONEOF); 	if(PReturned == PFAILED)  	    return(PFAILED);n 	elif(PChar == 'T'){" 	    if(PPoint(&X,&Y) == PFAILED){/ 		PError("Can't parse translation transform.");r 		return(PFAILED); 		})* 	    elif(AT(CDTRANSLATE,X,Y) == PFAILED){
 		PErrorCD();h 		return(PFAILED); 		}( 	    } 	elif(PChar == 'M'){8 	    PCharacter(PReturned,PSTRIPWHITESPACE2,PFAILONEOF); 	    if(PReturned == PFAILED){ 		PErrorEOF(); 		return(PFAILED); 		}m 	    elif(PChar == 'X'){# 		if(AT(CDMIRRORX,X,Y) == PFAILED){e 		    PErrorCD();C 		    return(PFAILED); 		    }E 		}i 	    elif(PChar == 'Y'){# 		if(AT(CDMIRRORY,X,Y) == PFAILED){  		    PErrorCD();h 		    return(PFAILED); 		    }  		}d
 	    else{* 		PError("Can't parse mirror transform."); 		return(PFAILED); 		}P 	    } 	elif(PChar == 'R'){" 	    if(PPoint(&X,&Y) == PFAILED){, 		PError("Can't parse rotation transform."); 		return(PFAILED); 		} % 	    if(AT(CDROTATE,X,Y) == PFAILED){{
 		PErrorCD();A 		return(PFAILED); 		}E 	    } 	elif(PChar == ';')u 	    break;E 	else{+ 	    PError("Can't parse transformation.");n 	    return(PFAILED);i 	    } 	}       if(AEndCall() == PFAILED){ 	PErrorCD(); 	return(PFAILED);n 	}     return(PSUCCEEDED);      }c   PPolygon(){      struct p *Path;c   #ifdef TRACE' fprintf(stderr," ENTERING PPOLYGON\n");i #endif     if(PPath(&Path) == PFAILED)i 	return(PFAILED);* #ifdef TRACE# fprintf(stderr," LEAVING PPATH\n");s #endif"     if(APolygon(Path) == PFAILED){ 	PErrorCD(); 	return(PFAILED);C 	} #ifdef TRACE& fprintf(stderr," LEAVING PPOLYGON\n"); #endif     return(PSUCCEEDED);T     }.   PBox(){A/     int Length,Width,X,Y,XDirection,YDirection;r       XDirection = 1;y     YDirection = 0;e#     PInteger(PReturned,PFAILONEOF);      if(PReturned == PFAILED) 	return(PFAILED);a     Length = PInt;#     PInteger(PReturned,PFAILONEOF);0     if(PReturned == PFAILED) 	return(PFAILED);      Width = PInt;o      if(PPoint(&X,&Y) == PFAILED) 	return(PFAILED);      PLookForSemi(PReturned);     if(PReturned == PFAILED) 	return(PFAILED);      elif(PChar != ';'){n/ 	if(PPoint(&XDirection,&YDirection) == PFAILED)  	    return(PFAILED);  	PLookForSemi(PReturned);t* 	if(PReturned == PFAILED Or PChar != ';'){ 	    PErrorNoSemicolon();  	    return(PFAILED);  	    } 	}@     if(ABox(Length,Width,X,Y,XDirection,YDirection) == PFAILED){ 	PErrorCD(); 	return(PFAILED);e 	}     return(PSUCCEEDED);I     }t   PRoundFlash(){     int Width,X,Y;  #     PInteger(PReturned,PFAILONEOF);i     if(PReturned == PFAILED) 	return(PFAILED);t     Width = PInt;       if(PPoint(&X,&Y) == PFAILED) 	return(PFAILED);s     PLookForSemi(PReturned);     if(PReturned == PFAILED) 	return(PFAILED);k     elif(PChar != ';'){F 	PErrorNoSemicolon();  	return(PFAILED);I 	}*     if(ARoundFlash(Width,X,Y) == PFAILED){ 	PErrorCD(); 	return(PFAILED);o 	}     return(PSUCCEEDED);}     }f   PWire(){     int Width;     struct p *Path;o   #ifdef TRACE$ fprintf(stderr," ENTERING PWIRE\n"); #endif#     PInteger(PReturned,PFAILONEOF);(     if(PReturned == PFAILED) 	return(PFAILED);      Width = PInt;r #ifdef TRACE$ fprintf(stderr," ENTERING PPATH\n"); #endif     if(PPath(&Path) == PFAILED)	 	return(PFAILED);e%     if(AWire(Width,Path) == PFAILED){s 	PErrorCD(); 	return(PFAILED);P 	}     return(PSUCCEEDED);{     }i   PPath(Path)      struct p **Path;     {      int X,Y;     struct p *Pair;u       *Path = NULL; 	     loop{R 	PLookForSemi(PReturned);	 #ifdef TRACE if(PReturned == PFAILED)7     fprintf(stderr," PPATH FAILED AFTER PLOOKAHEAD\n");P #endif 	if(PReturned == PFAILED)) 	    return(PFAILED);) 	elif(PChar == ';')  	    break;  	else{! 	    if(PPoint(&X,&Y) == PFAILED)) 		return(PFAILED); #ifdef TRACE, fprintf(stderr," PPATH POINT %d, %d\n",X,Y); #endif? 	    if((Pair = (struct p *)malloc(sizeof(struct p))) == NULL){P 		PError("Out of memory.");t 		return(PFAILED); 		}A 	    Pair->pSucc = *Path;G 	    Pair->pX = X; 	    Pair->pY = Y; 	    *Path = Pair; 	    } 	}     return(PSUCCEEDED);i     }A   PPoint(X,Y)e     int *X,*Y;     {"H     /* it is assumed that a LookAhead is done prior to calling PPoint */#     PInteger(PReturned,PFAILONEOF);      if(PReturned == PFAILED) 	return(PFAILED);t     *X = PInt;     PLookForSemi(PReturned);     if(PReturned == PFAILED) 	return(PFAILED);n     elif(PChar == ';'){d! 	PError("Bad X,Y path element.");  	return(PFAILED);F 	}#     PInteger(PReturned,PFAILONEOF);n     if(PReturned == PFAILED) 	return(PFAILED);o     *Y = PInt;     return(PSUCCEEDED);      })  	 PLayer(){I     char Technology,Mask[4];
     int i;  6     Mask[0] = Mask[1] = Mask[2] = ' '; Mask[3] = NULL;7     PCharacter(PReturned,PSTRIPWHITESPACE2,PFAILONEOF);L     if(PReturned == PFAILED) 	return(PFAILED);      if(PChar == ';'){ E 	PError("At least one character expected after L in layer command.");L 	return(PFAILED);  	}     Technology = PChar;e     for(i=0; i<3; ++i){t) 	if((PChar = getc(PCIFFileDesc)) == EOF){              PErrorEOF(); 	    return(PFAILED);n 	    } 	elif(PChar == ';'){. 	    if(ALayer(Technology,Mask) == PSUCCEEDED) 		return(PSUCCEEDED);I
 	    else{( 		PErrorUndefinedLayer(Technology,Mask); 		return(PFAILED); 		}I 	    } 	Mask[i] = PChar;;/ 	/* check for valid CIF layer name character */ + 	if(Not ((PChar >= '0' And PChar <= '9') Or{' 	    (PChar >= 'A' And PChar <= 'Z'))){ + 	    PErrorUndefinedLayer(Technology,Mask);  	    return(PFAILED);t 	    } 	}     /* clear the semicolon */"7     PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF);L     if(PReturned == PFAILED){F 	return(PFAILED);I 	}     elif(PChar == ';'){i* 	if(ALayer(Technology,Mask) == PSUCCEEDED) 	    return(PSUCCEEDED); 	else{+ 	    PErrorUndefinedLayer(Technology,Mask);C 	    return(PFAILED);I 	    } 	}E     PError("Illegal CIF layer name with > 4 characters discovered.");f     return(PFAILED);     }E   PUserExtension(){i     char Digit; 
     int Int1;        Digit = PChar; E
     Int1 = 0;y	     loop{ 3 	PCharacter(PReturned,PLEAVEWHITESPACE,PFAILONEOF);  	if(PReturned == PFAILED)N 	    return(PFAILED);d 	elif(PChar == ';'){ 	    PString[Int1] = EOS;o2 	    if(AUserExtension(Digit,PString) == PFAILED){
 		PErrorCD();I 		return(PFAILED); 		}n #ifdef TRACE) fprintf(stderr,"PString = %s\n",PString);n #endif 	    return(PSUCCEEDED); 	    } 	elif(Int1 == PSTRINGSIZE){nC 	    PError("User extension command longer than 1920 characters.");e 	    return(PFAILED);F 	    } 	else PString[Int1++] = PChar; 	}     }    PComment(){c
     int Int1;S  
     Int1 = 0;F	     loop{ 3 	PCharacter(PReturned,PLEAVEWHITESPACE,PFAILONEOF);e 	if(PReturned == PFAILED)( 	    return(PFAILED);  	elif(PChar == ')'){8 	    PCharacter(PReturned,PSTRIPWHITESPACE1,PFAILONEOF); 	    if(PReturned == PFAILED)= 		return(PFAILED); D 	    elif(PChar == ';'){ 		PString[Int1] = EOS; 		AComment(PString); 		return(PSUCCEEDED);H 		}A 	    elif(Int1 == PSTRINGSIZE){e9 		PError("Comment command longer than 1920 characters.");  		return(PFAILED); 		}	
 	    else{ 		PErrorNoSemicolon(); 		return(PFAILED); 		}  	    } 	else PString[Int1++] = PChar; 	}     }=   PError(PErrorMessage),     char *PErrorMessage;     {D
     int Int1;u     #     for(Int1 = 0;Int1 < 20;++Int1){f 	if(PChar == EOF)= 	    break; 3 	PCharacter(PReturned,PLEAVEWHITESPACE,PFAILONEOF);C 	if(PReturned == PFAILED)  	    break;u 	PString[Int1] = PChar;  	}     PString[Int1] = EOS;G     sprintf(PStatus,"%s.  Failed at around %s.",PErrorMessage,PString);A #ifdef TRACE% fprintf(stderr,"%s\n",PErrorMessage);A #endif     }    PErrorEOF(){     PError("Early EOF.");P     })   PErrorNoSemicolon(){(     PError("; expected and not found.");     }    PErrorUndefinedLayer(Tech,Mask)      char Tech,*Mask;     {h     char buf[35];a5     sprintf(buf,"Undefined layer: %c%s. ",Tech,Mask);r     PError(buf);     }    PErrorCD(){r     PError(CDStatusString);f     }e