 /*  * parser.h1  *=  * Copyright -C- 1981 Kenneth H. Keller, Giles C. Billingsleyc$  * sccsid "@(#)parser.h	1.1  9/5/83"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programr;  * KIC is available free of charge to any interested party."B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,L  * is forbidden.  */m  r  ) /*%  * Fast CIF parser's data structures.u  * *  */G   #include "macros.h"  #include <stdio.h>   /*%  * 24*80+1=1921 characters of string.C  */) #define	PSTRINGSIZE	1921     /*'  * Status of parse when parser returns.a  */o char PStatus[80*3+1];o   /*  * CIF file desc.I  */r FILE *PCIFFileDesc;)   /*"  * string for input line buffering  */E char PString[PSTRINGSIZE];   /*  * Global token variables.  */d
 int PChar;	 int PInt;F int PReturned;   /*  * Ousterhout's path package.p  */l FILE *POpen();   /*  * Values routines return.  */n- #define PSUCCEEDED		1	/* successful return */ ' #define PFAILED			2	/* parser failed */e; #define PNOTAPPLICABLE		3	/* parser failed due to syntax */,   /*8  * Arguments to handle an EOF in PCharacter and PInteger  */] #define PFAILONEOF		1r #define PDONTFAILONEOF		22   /*?  * Arguments to specify characters to be ignored by PWhiteSpacef  */rC #define PSTRIPWHITESPACE1	1	/* strip blanks, tabs, commas, or    */ , 					/* new lines.                        */C #define PSTRIPWHITESPACE2	2	/* strip everything but upper case,  */e, 					/* hyphens, digits, parens, and ;'s. */C #define PSTRIPWHITESPACE3	3	/* strip everything but digits,      */c, 					/* hyphens, parens, and ;'s.         */ #define PLEAVEWHITESPACE	4      = #define PCharacter(Returned,WhiteSpaceControl,EOFControl){		\ =     /* PWhiteSpace returns either PSUCCEEDED or PFAILED */		\U;     PWhiteSpace(Returned,WhiteSpaceControl,EOFControl);			\ #     if(Returned != PFAILED){						\S)         PChar = getc(PCIFFileDesc);					\r          if(PChar == EOF){						\, 	    if(EOFControl != PDONTFAILONEOF) {				\#                 PErrorEOF();						\L)                 Returned = PFAILED;					\F                 }							\r 	    }								\L         }								\     }U  > #define PWhiteSpace(Returned,WhiteSpaceControl,EOFControl){		\"     Returned = PSUCCEEDED; 						\4     if(WhiteSpaceControl == PSTRIPWHITESPACE1){				\G         while((PChar = getc(PCIFFileDesc)) == ' ' Or PChar == '\t' Or	\ ) 	    PChar == '\n' Or PChar == ','){				\n$             if(PChar == EOF){						\. 	        if(EOFControl != PDONTFAILONEOF){			\&                     PErrorEOF();					\-                     Returned = PFAILED;					\(                     }							\t 	        break;							\E 	        }							\ 	    }								\ .         ungetc((char)PChar,PCIFFileDesc);				\         }								\5     elif(WhiteSpaceControl == PSTRIPWHITESPACE2){			\CE         while((PChar = getc(PCIFFileDesc)) != '-' And PChar != '(' 	\s9 	    And PChar != ')' And (PChar < 'A' Or PChar > 'Z')		\F; 	    And	(PChar < '0' Or PChar > '9') And PChar != ';'){		\ $             if(PChar == EOF){						\/ 	        if(EOFControl != PDONTFAILONEOF) {			\A&                     PErrorEOF();					\-                     Returned = PFAILED;					\C                     }							\R 	        break;							\, 	        }							\ 	    }								\A.         ungetc((char)PChar,PCIFFileDesc);				\         }								\5     elif(WhiteSpaceControl == PSTRIPWHITESPACE3){			\HD         while((PChar = getc(PCIFFileDesc)) != '-' And PChar != '('	\; 	    And PChar != ')' And (PChar< '0' Or PChar > '9') And	\  	    PChar != ';'){						\$             if(PChar == EOF){						\. 	        if(EOFControl != PDONTFAILONEOF){			\&                     PErrorEOF();					\-                     Returned = PFAILED;					\.                     }							\e 	        break;							\  	        }							\ 	    }								\	.         ungetc((char)PChar,PCIFFileDesc);				\         }								\     }   / #define PWhiteSpace1(Returned,EOFControl){				\s"     Returned = PSUCCEEDED; 						\C     while((PChar = getc(PCIFFileDesc)) == ' ' Or PChar == '\t' Or	\s& 	PChar == '\n' Or PChar == ','){					\          if(PChar == EOF){						\+ 	    if(EOFControl != PDONTFAILONEOF){				\*#                 PErrorEOF();						\g)                 Returned = PFAILED;					\*                 }							\  	    break;							\  	    }								\e 	}								\d+     ungetc((char)PChar,PCIFFileDesc);					\R     }   / #define PWhiteSpace2(Returned,EOFControl){				\D"     Returned = PSUCCEEDED; 						\B     while((PChar = getc(PCIFFileDesc)) != '-' And PChar != '(' 		\5 	And PChar != ')' And (PChar < 'A' Or PChar > 'Z')		\P7 	And (PChar < '0' Or PChar > '9') And PChar != ';'){		\	          if(PChar == EOF){						\, 	    if(EOFControl != PDONTFAILONEOF) {				\#                 PErrorEOF();						\C)                 Returned = PFAILED;					\                  }							\  	    break;							\g 	    }								\) 	}								\h+     ungetc((char)PChar,PCIFFileDesc);					\      }{  / #define PWhiteSpace3(Returned,EOFControl){				\ "     Returned = PSUCCEEDED; 						\A     while((PChar = getc(PCIFFileDesc)) != '-' And PChar != '('		\e8 	And PChar != ')' And (PChar< '0' Or PChar > '9') And		\ 	PChar != ';'){							\           if(PChar == EOF){						\+ 	    if(EOFControl != PDONTFAILONEOF){				\	#                 PErrorEOF();						\i)                 Returned = PFAILED;					\                  }							\( 	    break;							\  	    }								\	 	}								\P+     ungetc((char)PChar,PCIFFileDesc);					\	     }   9 #define PLookAhead(Returned, WhiteSpaceControl, For){			\ A     /* PCharaceter will return either PSUCCEEDED or PFAILED */		\I:     PCharacter(Returned,WhiteSpaceControl,PFAILONEOF);			\1     if(PChar != For && Returned != PFAILED){				\ .         ungetc((char)PChar,PCIFFileDesc);				\ 	}								\	     }   & #define PLookForSemi(Returned){						\=     /* PWhiteSpace returns either PSUCCEEDED or PFAILED */		\C,     PWhiteSpace3(Returned,PFAILONEOF);					\#     if(Returned != PFAILED){						\-)         PChar = getc(PCIFFileDesc);					\           if(PChar == EOF){						\             PErrorEOF();						\ &             Returned = PFAILED;						\ 	    }								\r"         elif(PChar != ';'){						\2             ungetc((char)PChar,PCIFFileDesc);				\ 	    }								\D 	}								\      }   - #define PInteger(Returned,EOFControl) {					\      loop{								\0         PWhiteSpace3(PReturned,EOFControl);				\'         if(PReturned == PFAILED){					\ &             Returned = PFAILED;						\ 	    break;							\d 	    }								\	+ 	if((PChar >= '0' And PChar <= '9') Or				\=+ 	    (PChar == '-' Or PChar == '+')) {				\O%             /* read integer */						\r<             if((fscanf(PCIFFileDesc,"%d",&PInt)) == EOF){		\. 	        if(EOFControl != PDONTFAILONEOF){			\&                     PChar = EOF;					\&                     PErrorEOF();					\-                     Returned = PFAILED;					\o                     }							\n 	        }							\(             Returned = PSUCCEEDED;					\ 	    break;							\* 	    }								\u,         /* drop unwanted characters */					\>         PCharacter(PReturned,PSTRIPWHITESPACE1,EOFControl);		\'         if(PReturned == PFAILED){					\r&             Returned = PFAILED;						\             break;							\ 	    }								\i         }								\     }o