 /*
  * paths.c  *F  * Written by John Ousterhout.  Modified for VMS by Giles Billingsley.#  * sccsid "@(#)paths.c	1.1  9/5/83"0  *J  * This file contains routines that a) implement a path mechanism, wherebyH  * several places may be searched for files, and b) provide a defaulting&  * mechanism for file name extensions.  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program6;  * KIC is available free of charge to any interested party. B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */    #include <stdio.h> #ifndef vms  #include <pwd.h> #endif #include <ctype.h>   #ifdef TEST0 main(){      char buf[100];     int i,j,k,l,n;     FILE *POpen();     char *PGetPath();I     char *prealname;
 #ifdef vms+     PSetPath(" ~ ~.foo dma1:[kic.cells] ");r #else $     PSetPath(" . ~gilesb/mfb/src "); #endif$     printf("PATH? %s\n",PGetPath());     for(;;){ 	scanf("%s",buf);	# 	POpen(buf, "r", NULL, &prealname);F 	printf("%s\n",prealname); 	}     }  #endif   #define	FALSE	0  #define	TRUE	1 #define	TILDA	'~'A   /* Library routines */  % char *strcpy(), *strncpy(), *index();   H /* The following string holds the current path,which consists of a bunch*  * of directory names separated by spaces.  */f   #define PATHSIZE 180 * static char path[PATHSIZE];o   int # PConvertTilde(psource, pdest, size) A char **psource;			/* Pointer to a pointer to the source string */ > char **pdest;			/* Pointer to a pointer to the dest. string */: int *size;			/* Pointer to no. bytes available at pdest */  O /*----------------------------------------------------------------------------- F  *	This routine converts tilde notation into standard directory names.  *  *	Results:	B  *	If the conversion was done successfully, then TRUE is returned.>  *	If a user name couldn't be found in the password file, then  *	FALSE is returned.n  *  *	Side Effects:A  *	If the first character of the string indicated by psource is a!D  *	tilde ("~") then the subsequent user name is converted to a loginD  *	directory name and stored in the string indicated by pdest.  ThenA  *	remaining characters in the file name at psource are copied toOD  *	pdest and both pointers are updated.  Upon return, psource pointsA  *	to the terminating character in the source file name and pdest	D  *	points to the next character after the last character in the fileE  *	name at that location.  If a tilde cannot be converted because the	H  *	user name cannot be found, psource is still advanced past the currentC  *	entry, but pdest is unaffected.  At most size characters will ber@  *	stored at pdest, and the size is decremented by the number of!  *	characters we actually stored.!O  *-----------------------------------------------------------------------------e  */d       {D     register char *ps, *pd;	   #ifndef vmse'     struct passwd *passwd, *getpwnam();	 #endif       char username[35];     int i, length;       ps = *psource;     if (*ps == TILDA){B 	/* Copy the user name into a string (at most 34 characters), then@ 	 * read the password file entry for the user, then grab out the  	 * login directory.h 	 */  
 #ifdef vms 	ps++; 	if(getenv("HOME") == NULL)( #elseh 	pd = username;	 	for (i=0; ; i++)  	    { 	    *pd = *++ps;e: 	    if (isspace(*pd) || (*pd=='\0') || (*pd=='/')) break; 	    if (i < 34) pd++; 	    } 	*pd = '\0'; 	passwd = getpwnam(username);f  D 	/* If the entry can't be found, skip the source entry and return */   	if (passwd == NULL) #endif 	    {1 	    while ((*ps != '\0') && !isspace(*ps)) ps++;d 	    *psource = ps;  	    return FALSE; 	    }  
 #ifdef vms! 	length = strlen(getenv("HOME"));P 	/* remove closing bracket */}
 	--length;$ 	if (length > *size) length = *size;) 	strncpy(*pdest, getenv("HOME"), length);. 	*size -= length;t 	pd = *pdest+length; #elsei! 	length = strlen(passwd->pw_dir);p$ 	if (length > *size) length = *size;) 	strncpy(*pdest, passwd->pw_dir, length);d 	*size -= length;l 	pd = *pdest+length; #endif 	}     else pd = *pdest;K  J     /* Copy the rest of the directory name from the source to the dest. */  *     while ((*ps != '\0') && !isspace(*ps)) 	if (*size > 0)  	    { 	    *pd++ = *ps++;  	    (*size)--;a 	    } 	else ps++;.
 #ifdef vms4     /* insert closing bracket for tilda expansion */     if (**psource == TILDA) {s 	if (*size > 0) {  	    *pd++ = ']';r 	    (*size)--;F 	    } 	elsed 	    *(pd - 1) = ']';: 	} #endif     *psource = ps;     *pdest = pd;     return TRUE;     }l   int) PSetPath(string)8 char *string;			/* Pointer to a string that is to become- 				 * the new fle search path.  Must consistn/ 				 * of one or more directory names separatedu) 				 * by white space.  ~ notation is ok.e 				 */d  O /*-----------------------------------------------------------------------------i,  *	PSetPath sets up the current search path.  *  *	Results:aB  *	FALSE is returned if one or more of the paths contained a tildeD  *	notation that couldn't be converted.  Otherwise TRUE is returned.  *  *	Side Effects:A  *	The string is stored as the current path, and all entries withtE  *	tilde notation are converted to non-tilde notation.  Tilde entriesmD  *	that cannot be converted are ignored.  Note:  only PATHSIZE totalB  *	bytes of path are stored, after tilde conversion.  Excess bytes  *	are truncated.aO  *-----------------------------------------------------------------------------   */h       {m     int result, spaceleft;     char *p;       if(string[0] == '\0'){       return(path[0] = '\0');      result = TRUE;     spaceleft = PATHSIZE-1;e
     p = path;e     while (*string != '\0') {t 	if (spaceleft <= 0) break; # 	while (isspace(*string)) string++;v= 	if (!PConvertTilde(&string, &p, &spaceleft)) result = FALSE; & 	else if (spaceleft-- > 0) *p++ = ' '; 	}     *p = '\0';     return result;     };   char *
 PGetPath()  O /*-----------------------------------------------------------------------------b=  *	This routine merely returns a pointer to the current path.N  *  *	Results: >  *	The address of the current path (with all tildes expanded).  *  *	Side Effects:	None.O  *-----------------------------------------------------------------------------g  */k       {-     return path;     }s   FILE *! POpen(file, mode, ext, prealname)(2 char *file;			/* Name of the file to be opened. */5 char *mode;			/* The file mode, as given to fopen. */i5 char *ext;			/* The default extension fo the file, ors3 				 * NULL if there is to be no default extension.e 				 */;? char **prealname;		/* Pointer to a location that will be filledh. 				 * in with the address of the real name of- 				 * the file that was successfully opened. ' 				 * If NULL, then nothing is stored.s 				 */t  O /*-----------------------------------------------------------------------------6=  *	This routine does a file lookup using the current path and !  *	supplying a default extension.   *  *	Results:t>  *	A pointer to a FILE, or NULL if the file couldn't be found.  *  *	Side Effects:>  *	If the file name doesn't contain the first character of ext=  *	then ext is appended to the file name, and this routine ise<  *	called recursively with the new name.  If that succeeeds,>  *	then we are done.  Otherwise, if the first character of the?  *	file name is "~" or "/" then we try to look up the file withf>  *	the original name, doing tilde expansion of course.  If theC  *	first character isn't one of those two characters, we go throughtA  *	the current path trying to look up the file once for each path&@  *	entry by prepending the path entry to the original file name.?  *	This concatenated name is stored in a static string and maderB  *	available to the caller through prealname if the open succeeds.C  *	Note: the static string will be trashed on the next call to thisiB  *	routine.  Also, note that no individual file name is allowed toF  *	be more than NAMESIZE characters long.  Excess characters are lost.O  *-----------------------------------------------------------------------------e  */	       {r #define NAMESIZE 80d#     static char realname[NAMESIZE];e)     char extendedname[NAMESIZE], *p, *p2;-     int length, spaceleft;     FILE *f;  +     if(path[0] == '\0' && file[0] != TILDA)t       return(fopen(file,mode));-  D     /* See if we must supply a default extension.  If so, then do it)      * and call this routine recursively.L      */i  1     if (prealname != NULL) *prealname = realname;F     if (ext != NULL) 	if (index(file, ext[0]) == 0) 	    { 	    length = strlen(file); 1 	    if (length >= NAMESIZE) length = NAMESIZE-1; ) 	    strncpy(extendedname, file, length);  	    p = &extendedname[length];s  	    length = NAMESIZE-1-length;- 	    if (length > 0) strncpy(p, ext, length);	% 	    extendedname[NAMESIZE-1] = '\0'; = 	    f = POpen(extendedname, mode, (char *) NULL, prealname);	 	    if (f != NULL) return f;d 	    }  H     /* OK, the default extension either wasn't necessary or didn't work.F      * Now try the original name.  If it starts with a ~ or /, look it      * up directly.*      */*  
 #ifdef vms9     if ((index(file,':') != 0) || (index(file,'[') != 0))h #elsed     if (file[0] == '/')  #endif 	{% 	strncpy(realname, file, NAMESIZE-1);	 	realname[NAMESIZE-1] = '\0';r 	return fopen(realname, mode); 	}   #ifndef vms-     if (file[0] == TILDA)- 	{ 	p = realname; 	length = NAMESIZE-1;f5 	if (!PConvertTilde(&file, &p, &length)) return NULL;d 	*p = '\0';i 	return fopen(realname, mode); 	} #endif  :     /* Last, but not least, try going through the path. */  
     p = path;e     while (*p != '\0') 	{ 	spaceleft = NAMESIZE-1; 	p2 = realname;e 	while (isspace(*p)) p++;s
 #ifdef vms6 	if(*p == '.' && (isspace(*(p+1)) || *(p+1) == '\0')){	 	    ++p;t( 	    if((f = fopen(file, mode)) != NULL) 		return f;t	 	    else  		continue;r 	    } #endif% 	while ((*p != '\0') && !isspace(*p))i' 	    if (spaceleft-- > 0) *p2++ = *p++;. 	    else p++; #ifndef vmsi" 	if (spaceleft-- > 0) *p2++ = '/'; #endif1 	if (spaceleft > 0) strncpy(p2, file, spaceleft);e 	realname[NAMESIZE-1] = '\0';b 	f = fopen(realname, mode);o 	if (f != NULL) return f;* 	}     return NULL;     }o   /*I  * VMS and the Masscomp MC-500 do not have index() in the string library.   */p #ifdef mc500 char *index(s,c)     char *s,c;     {d     char buf[2];     int i,strcspn();     buf[0] = c;n     buf[1] = NULL;     i = strcspn(s,buf);o     if(i != strlen(s)) 	return( &s[i] );h     else 	return( NULL );     }- #endif
 #ifdef vms char *index(s,c)     char *s,c;     {-     char buf[2];     int i,strcspn();     buf[0] = c;      buf[1] = NULL;     i = strcspn(s,buf);A     if(i != strlen(s)) 	return( &s[i] );f     else 	return( NULL );     }= #endif    