 /*
  * point.c  **  * Copyright -C- 1981 Giles C. Billingsley#  * sccsid "@(#)point.c	1.1  9/5/83"f  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program!;  * KIC is available free of charge to any interested party.yB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,&  * is forbidden.  */L       /*   * Graphical and keyboard input.  */}    
 #ifdef vms #include <types.h> #include <timeb.h> #elsea #include <sys/types.h> #include <sys/timeb.h> #endif   #include "kic.h"   /* Library routines */ char *strcpy();p  
 #ifdef vms #define	DEBOUNCETIME	0 #else( #define	DEBOUNCETIME	100 #endif  
 #define	ABORT=  N /* we keep track of the time between pointing events to debounce the cursor */ static long LastPointTime = 0;     Point()      /*0      * When user has typed Condition, do Action.      *      * Condition,      *     shortest unique prefix of Menu[i]
      * Action J      *     Return with command selected is stored as Parameters.kpCommand.      *      * Condition      *     ESC
      * Action %      *     Forget remembered type in.5      *      * Condition/      *     point key or tablet stylus button Z n
      * ActionhF      *     If user is pointing at a layer in the layer table viewport,$      *     change the current layer.G      *     If user is pointing at a command menu selection, return with(;      *     command selected stored as Parameters.kpCommand.hI      *     If user is pointing inside a layout viewport--coarse or fine-- A      *     return with Parameters.pkpCommand[0] == EOS and cursor)!      *     descriptor up-to-date.t      *      * Condition      *     ctrl-c or ctrl-e 
      * Action(      *     Prompt user for a coordinate.A      *     Return with Parameters.pkpCommand[0] == EOS and cursori!      *     descriptor up-to-date.f      *      * Condition      *     ctrl-a 
      * ActionN      *     Abort KIC.e      *      * Condition+      *     ctrl-f or tablet stylus button 1N
      * Action "      *     Wait for user to point.=      *     Redisplay in fine viewport around where he pointedl*      *     if fine positioning is enabled.      *      * Condition      *     ctrl-gc
      * Actioni+      *     Change scale of Magnifying Glass-      *      * Condition      *     ctrl-l-
      * Actione-      *     Select current layer from keyboardR      *      * Condition      *     ctrl-t or ctrl-vt
      * Actiont.      *     Toggle position of magnifying glass      *      * Condition+      *     ctrl-w or tablet stylus button 2e
      * Actiont"      *     Wait for user to point.*      *     Show him where he is pointing.       */d     {e     struct timeb now;o     char *TypeIn;.     char **Menu;     long newtime;s)     int NumCommand,X,Y,Buttons,Int1,Int2;.     int Layer;     int NumMenu;I     int oldButton3X,oldButton3Y,oldButton3;  /* remember last button 3 */-     int centerX,centerY;
     char Key;p       /*8      * The best way to handle interrupts reliably is to 7      * initialize the service routines as frequently asH"      * possible.  Therefore, . . .      */!     InitSignals();'     if(Parameters.kpMenu == BASICMENU){r 	Menu = BasicMenu; 	NumMenu = NumBasicMenu; 	}-     elif(Parameters.kpMenu == SELECTIONMENU){l 	Menu = SelectionMenu; 	NumMenu = NumSelectionMenu; 	}.     elif(Parameters.kpMenu == ATTRIBUTESMENU){ 	Menu = AttributeMenu; 	NumMenu = NumAttributeMenu; 	},     elif(Parameters.kpMenu == PROPERTYMENU){ 	Menu = PropertyMenu;  	NumMenu = NumPropertyMenu;T 	}-     elif(Parameters.kpMenu == AMBIGUITYMENU){a 	Menu = AmbiguityMenu; 	NumMenu = NumAmbiguityMenu; 	},     elif(Parameters.kpMenu == INSTANCEMENU){ 	Menu = InstanceMenu;  	NumMenu = NumInstanceMenu;p 	})     elif(Parameters.kpMenu == DEBUGMENU){  	Menu = DebugMenu; 	NumMenu = NumDebugMenu; 	}/     Parameters.kpCommand[NumCommand = 0] = EOS;d)     Parameters.kpPointLayerTable = False;a+     Parameters.kpPointCoarseWindow = False;t     oldButton3 = False;p     SetDebounceTime();
     loop {. 	/*	       DEBOUNCE POINTING DEVICE		  	   	*/? 	/* This is necessary for terminals LIKE THE AED which may  	*/ ? 	/* return bogus graphic reports or the Metheus 400 which   	*/e) 	/* bounces like a son-of-a-gun.			   	*/d 	loop{" 	    FBPoint(&X,&Y,&Key,&Buttons); 	    if(Key != 0) break; 	    if(FB.fButtons){p% 		if((Buttons == FB.fButtonMask[0] Ori% 		    Buttons == FB.fButtonMask[1] Or % 		    Buttons == FB.fButtonMask[2] OrC' 		    Buttons == FB.fButtonMask[3]) Andl: 		    (X < FB.fMaxX And X > 0 And Y < FB.fMaxY And Y > 0)) 		    break; 		}d 	    }
 	ftime(&now); ) 	newtime = 1000 * now.time + now.millitm;e7 	if((newtime - LastPointTime) < DEBOUNCETIME) continue;* 	SetDebounceTime();A   	if(Key != 0){  	    /* convert to lower case */" 	    if(Key > 0100 And Key < 0133) 		Key += 32;/ 	    Parameters.kpCommand[NumCommand++] = Key; m 	    if(NumCommand > 80) 		NumCommand = 80;, 	    Parameters.kpCommand[NumCommand] = EOS; 	    } 	if(Key == 27)   /* esc */0 	    Parameters.kpCommand[NumCommand = 0] = EOS; #ifdef ABORT 	elif(Key == 1){ /*ctrl-a*/  	    ShowPrompt("ABORT");n
 	    FBEnd();S
 	    exit(2);e 	    } #endif1 	elif(Key == 3 Or Key == 5){ /*ctrl-c or ctrl-e*/* 	    TypeCoordinate();0 	    Parameters.kpCommand[NumCommand = 0] = EOS; 	    return; 	    } 	elif(Key == 6 Or /*ctrl-f*/B 	    (FB.fButtons And Key == 0 And Buttons == FB.fButtonMask[1])){ 	    FinePosition(X,Y,Key);r0 	    Parameters.kpCommand[NumCommand = 0] = EOS;     	    /*e.      	     * This is necessary for debouncing.G      	     * It takes time to redisplay, so we set the time of the last ;      	     * pointing event when the redisplay is finished.N
      	     */a 	    SetDebounceTime();a 	    } 	elif(Key == 7){    /*ctrl-g*/0 	    Parameters.kpCommand[NumCommand = 0] = EOS;( 	    if(Parameters.kpCellName[0] == EOS)	 		return;e= 	    if(Parameters.kpRedisplayControl == COARSEVIEWPORTONLY){t1 		ShowPrompt("Fine positioning isn't required.");P 		continue;M 		} > 	    ShowPrompt("Point to diagonal of area to be magnified.");
 	    loop{ 		FBPoint(&X,&Y,&Key,&Buttons);i# 		if(Not FB.fButtons And Key == 32)n 		    break;5 		if(FB.fButtons And Buttons == FB.fButtonMask[0] Ande8 		    X < FB.fMaxX And X > 0 And Y < FB.fMaxY And Y > 0) 		    break; 		}M# 	    if(InBox(X,Y,CoarseViewport)){=* 		PToL(CoarseViewport,CoarseWindow,&X,&Y); 		}o# 	    elif(InBox(X,Y,FineViewport)){P& 		PToL(FineViewport,FineWindow,&X,&Y); 		}i 	    else {w 		NotPointingAtLayout(); 		continue;  		}D 	    oldButton3X = X;p 	    oldButton3Y = Y; 
 	    loop{ 		FBPoint(&X,&Y,&Key,&Buttons);s# 		if(Not FB.fButtons And Key == 32)m 		    break;7 		elif(FB.fButtons And Buttons == FB.fButtonMask[0] And*8 		    X < FB.fMaxX And X > 0 And Y < FB.fMaxY And Y > 0) 		    break; 		}*# 	    if(InBox(X,Y,CoarseViewport)){ * 		PToL(CoarseViewport,CoarseWindow,&X,&Y); 		}e# 	    elif(InBox(X,Y,FineViewport)){d& 		PToL(FineViewport,FineWindow,&X,&Y); 		}u 	    else {  		NotPointingAtLayout(); 		continue;y 		}e 	    if(X > oldButton3X) 		SwapInts(X,oldButton3X);A 	    if((oldButton3X - X) < 2){    /* two lambda minimum width */n2 		ShowPrompt("Magnifying glass width too small."); 		continue;f 		}B 	    if(Y > oldButton3Y) 		SwapInts(Y,oldButton3Y);' 	    centerX = (oldButton3X - X)/2 + X;l' 	    centerY = (oldButton3Y - Y)/2 + Y; ' 	    FineWindowWidth = oldButton3X - X; ( 	    FineWindowHeight = FineWindowWidth*- 		(FineViewport.kaTop-FineViewport.kaBottom)/*- 		(FineViewport.kaRight-FineViewport.kaLeft);e 	    EraseMagnifyingGlass();% 	    InitFineWindow(centerX,centerY);* 	    ShowFineViewport(); 	    }A 	elif(FB.fButtons And Key == 0 And Buttons == FB.fButtonMask[3]){ 0 	    Parameters.kpCommand[NumCommand = 0] = EOS;( 	    if(Parameters.kpCellName[0] == EOS)	 		return;e= 	    if(Parameters.kpRedisplayControl == COARSEVIEWPORTONLY){ 1 		ShowPrompt("Fine positioning isn't required.");c 		continue;w 		}  	    if(Not oldButton3){  		if(InBox(X,Y,CoarseViewport)){. 		    PToL(CoarseViewport,CoarseWindow,&X,&Y); 		    }-  		elif(InBox(X,Y,FineViewport)){* 		    PToL(FineViewport,FineWindow,&X,&Y); 		    }  		else { 		    NotPointingAtLayout(); 		    continue;i 		    }* 		oldButton3X = X; 		oldButton3Y = Y; 		oldButton3 = True; 		} 
 	    else{  		if(InBox(X,Y,CoarseViewport)){. 		    PToL(CoarseViewport,CoarseWindow,&X,&Y); 		    }	  		elif(InBox(X,Y,FineViewport)){* 		    PToL(FineViewport,FineWindow,&X,&Y); 		    }t 		else { 		    NotPointingAtLayout(); 		    continue;M 		    }n 		oldButton3 = False;  		if(X > oldButton3X)a 		    SwapInts(X,oldButton3X);> 		if((oldButton3X - X) < 2){    /* two lambda minimum width */6 		    ShowPrompt("Magnifying glass width too small."); 		    continue;o 		    }a 		if(Y > oldButton3Y). 		    SwapInts(Y,oldButton3Y);$ 		centerX = (oldButton3X - X)/2 + X;$ 		centerY = (oldButton3Y - Y)/2 + Y;$ 		FineWindowWidth = oldButton3X - X;% 		FineWindowHeight = FineWindowWidth*i1 		    (FineViewport.kaTop-FineViewport.kaBottom)/A1 		    (FineViewport.kaRight-FineViewport.kaLeft);X 		EraseMagnifyingGlass(); " 		InitFineWindow(centerX,centerY); 		ShowFineViewport();B 		}s 	    } 	elif(Key == 12){ /*ctrl-l*/ 	    ShowPrompt("Layer #?"); 	    FBKeyboard(&TypeIn);   	    sscanf(TypeIn,"%d",&Layer);0 	    Cursor.kcRow = LayerTableViewport.kaBottom;% 	    Cursor.kcColumn = (Layer-1)*5+1;V 	    PointLayerTable();Y0 	    Parameters.kpCommand[NumCommand = 0] = EOS; 	    return; 	    } 	elif(Key == 14){ /*ctrl-n*/0 	    Parameters.kpCommand[NumCommand = 0] = EOS; 	    SaveViewOnStack();) 	    }3 	elif(Key == 20 Or Key == 22){ /*ctrl-t or ctrl-v*/  	    FineViewportOnBottom ^= 1;n 	    InitViewport(); 	    SwitchToFinePositioning();	 	    FullRedisplay();i0 	    Parameters.kpCommand[NumCommand = 0] = EOS; 	    } 	elif(Key == 23 Or /*ctrl-w*/ B 	    (FB.fButtons And Key == 0 And Buttons == FB.fButtonMask[2])){ 	    WhereAmI(X,Y,Key);W0 	    Parameters.kpCommand[NumCommand = 0] = EOS; 	    } 	elif(Key == '!'){ 	    ShowPrompt("! "); 	    FBKeyboard(&TypeIn);  	    ShowProcess(TypeIn);  	    ShowPrompt(" ");t0 	    Parameters.kpCommand[NumCommand = 0] = EOS; 	    }1 	elif(FB.fButtons And Buttons == 0 And Key == 0){k0 	    Parameters.kpCommand[NumCommand = 0] = EOS; 	    continue; 	    }D 	elif(((Not FB.fButtons) And Key == 32) Or (FB.fButtons And Key == 0( 	    And Buttons == FB.fButtonMask[0])){0 	    Parameters.kpCommand[NumCommand = 0] = EOS; 	    CtrlAt(Menu,X,Y); 	    return; 	    } 	else {a 	    /*r% 	    Test for shortest unique prefix.i# 	    Stupid search is plenty fast. X 	    */e) 	    for(Int1 = 0;Int1 < NumMenu;++Int1){w) 		for(Int2 = 0;Int2 < NumCommand;++Int2){t  		    if('A' <= Menu[Int1][Int2]  			And Menu[Int1][Int2] <= 'Z'){# 			if(Parameters.kpCommand[Int2] != " 			    Menu[Int1][Int2]+32) break; 			}( 		    elif(Parameters.kpCommand[Int2] != 			Menu[Int1][Int2]) break;l 		    }X5 		if(Parameters.kpCommand[Int2] == EOS And Int2 > 0){&" 		    if(Menu[Int1][Int2] < 'A' Or 			Menu[Int1][Int2] > 'Z'){o+ 			strcpy(Parameters.kpCommand,Menu[Int1]);	
 			return; 			} 		    }  		}n 	    } 	}     }    NotPointingAtLayout(){>     ShowPrompt("You aren't pointing in the layout viewport.");     }s   FullRedisplay(){     FBBegin(FB.fDisplay);)     InitVLT();     FBForeground(ERASE,0);     FBFlood();     ShowCommandMenu();     ShowLayerTable();      ShowParameters();['     if(Parameters.kpCellName[0] != EOS)d6         Redisplay(Parameters.kpCellDesc,CoarseWindow);     else 	/* display logo */e 	KIC();      FBTransfer();r     }.   TypeCoordinate(){=     char *TypeIn;A       ShowPrompt("x y?");r      Cursor.kcPredX = Cursor.kcX;      Cursor.kcPredY = Cursor.kcY;'     Cursor.kcRow = Cursor.kcColumn = 0;=     FBKeyboard(&TypeIn);2     sscanf(TypeIn,"%d%d",&Cursor.kcX,&Cursor.kcY);     Cursor.kcX *= RESOLUTION;t     Cursor.kcY *= RESOLUTION; ,     Cursor.kcDX = Cursor.kcX-Cursor.kcPredX;,     Cursor.kcDY = Cursor.kcY-Cursor.kcPredY;
     ShowXY();r*     Parameters.kpPointCoarseWindow = True;     FBTransfer();e     }	   WhereAmI(X,Y,Key)a     int X,Y;
     char Key;      {a     int Buttons;  $     if(Not FB.fButtons Or Key != 0){+ 	ShowPrompt("Point to see where you are.");i 	loop{" 	    FBPoint(&X,&Y,&Key,&Buttons);& 	    if(Not FB.fButtons And Key == 32) 		break;8 	    if(FB.fButtons And Buttons == FB.fButtonMask[0] And4 		X < FB.fMaxX And X > 0 And Y < FB.fMaxY And Y > 0) 		break; 	    } 	}     /*"     Most of CtrlAt's code follows.     */F     if(X >= CoarseViewport.kaLeft And X <= CoarseViewport.kaRight And = 	Y >= CoarseViewport.kaBottom And Y <= CoarseViewport.kaTop){B 	Cursor.kcPredX = Cursor.kcX;	 	Cursor.kcPredY = Cursor.kcY;2 	Cursor.kcX = X; 	 	Cursor.kcY = Y; B; 	PToL(CoarseViewport,CoarseWindow,&Cursor.kcX,&Cursor.kcY);o) 	Cursor.kcDX = Cursor.kcX-Cursor.kcPredX;;) 	Cursor.kcDY = Cursor.kcY-Cursor.kcPredY;e
 	ShowXY(); 	Parameters.kpCommand[0] = EOS;w 	}D     elif(X >= FineViewport.kaLeft And X <= FineViewport.kaRight And 9 	Y >= FineViewport.kaBottom And Y <= FineViewport.kaTop){p 	Cursor.kcPredX = Cursor.kcX;) 	Cursor.kcPredY = Cursor.kcY;  	Cursor.kcX = X; n 	Cursor.kcY = Y; h7 	PToL(FineViewport,FineWindow,&Cursor.kcX,&Cursor.kcY);l) 	Cursor.kcDX = Cursor.kcX-Cursor.kcPredX;K) 	Cursor.kcDY = Cursor.kcY-Cursor.kcPredY;!
 	ShowXY(); 	Parameters.kpCommand[0] = EOS;  	}
     else { 	NotPointingAtLayout();  	Parameters.kpCommand[0] = EOS;  	}     }P   FinePosition(X,Y,Key)      int X,Y;
     char Key;      {[     int Buttons;  '     if(Parameters.kpCellName[0] == EOS)( 	return;<     if(Parameters.kpRedisplayControl == COARSEVIEWPORTONLY){0 	ShowPrompt("Fine positioning isn't required."); 	Parameters.kpCommand[0] = EOS;t 	return; 	} o$     if(Not FB.fButtons Or Key != 0){? 	ShowPrompt("Point to center of area you want magnified.");    0 	loop{" 	    FBPoint(&X,&Y,&Key,&Buttons); 	    if(Key == 32) 		break;" 	    elif(Key == 3){  /* ctrl-c */ 	        TypeCoordinate(); 	        X = Cursor.kcX; 	        Y = Cursor.kcY;/ 	        LToP(CoarseViewport,CoarseWindow,X,Y);r 		break;
 	        } 	    } 	}"     if(InBox(X,Y,CoarseViewport)){) 	PToL(CoarseViewport,CoarseWindow,&X,&Y);r 	}"     elif(InBox(X,Y,FineViewport)){% 	PToL(FineViewport,FineWindow,&X,&Y);= 	}
     else { 	NotPointingAtLayout();f 	return; 	}     EraseMagnifyingGlass();      InitFineWindow(X,Y);     ShowFineViewport();O     }      CtrlAt(Menu,X,Y)     char **Menu;     int X,Y;     {D"     if(InBox(X,Y,CoarseViewport)){ 	Cursor.kcPredX = Cursor.kcX;i 	Cursor.kcPredY = Cursor.kcY;r 	Cursor.kcX = X;   	Cursor.kcY = Y; a; 	PToL(CoarseViewport,CoarseWindow,&Cursor.kcX,&Cursor.kcY); ) 	Cursor.kcDX = Cursor.kcX-Cursor.kcPredX;o) 	Cursor.kcDY = Cursor.kcY-Cursor.kcPredY;{
 	ShowXY(); 	FBTransfer(); 	Parameters.kpCommand[0] = EOS; ' 	Parameters.kpPointCoarseWindow = True;t 	return; 	}"     elif(InBox(X,Y,FineViewport)){ 	Cursor.kcPredX = Cursor.kcX;x 	Cursor.kcPredY = Cursor.kcY;  	Cursor.kcX = X; t 	Cursor.kcY = Y; o7 	PToL(FineViewport,FineWindow,&Cursor.kcX,&Cursor.kcY);=) 	Cursor.kcDX = Cursor.kcX-Cursor.kcPredX;i) 	Cursor.kcDY = Cursor.kcY-Cursor.kcPredY;o
 	ShowXY(); 	FBTransfer(); 	Parameters.kpCommand[0] = EOS;r' 	Parameters.kpPointCoarseWindow = True;  	return; 	}
     else {0 	Cursor.kcRow = (FB.fMaxY-Y-3)/FB.fFontHeight+1;% 	Cursor.kcColumn = X/FB.fFontWidth+1;r; 	if(InViewport(Cursor.kcColumn,Cursor.kcRow,MenuViewport)){r7 	    strcpy(Parameters.kpCommand,Menu[Cursor.kcRow-1]);L 	    return; 	    }C 	elif(InViewport(Cursor.kcColumn,Cursor.kcRow,LayerTableViewport)){a 	    PointLayerTable(); # 	    Parameters.kpCommand[0] = EOS;r 	    return; 	    } 	}     }o     SetDebounceTime(){     struct timeb now;r     ftime(&now);2     LastPointTime = 1000 * now.time + now.millitm;     }c  