 /*  * polygns.c  **  * Copyright -C- 1981 Giles C. Billingsley%  * sccsid "@(#)polygns.c	1.1  9/5/83"C  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programo;  * KIC is available free of charge to any interested party.nB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,e  * is forbidden.  */p  m  [ /*  * Polygon management.  */r   #include "kic.h"   #define	RADTODEG		57.29577951t #define Parms			Parameters   double sin(), cos(), atan2();)   Polygons(LookedAhead)      int *LookedAhead;      {-     struct p *Path;r     struct ka BB;       int ExpectFirstPoint = True;     int Terminated = False;R     int NumVertices = 0;     int NumPolygonsMade = 0;     int X,Y;       Path = NULL;     MenuSelect(MenuPOLYG);%     ShowPrompt("Point to vertices.");t	     loop{{	 	Point();e 	if(Parms.kpCommand[0] != EOS){p/ 	    if(strcmp(Parms.kpCommand,MenuUNDO) == 0){ / 		if(NumPolygonsMade == 0 Or NumVertices == 0){( 		    *LookedAhead = True; 		    Parms.kpPointer = NULL;) 		    MenuDeselect(MenuPOLYG);
 		    return;  		    } ' 		elif(Terminated Or NumVertices == 1){d 		    MenuSelect(MenuUNDO);.1 		    CDDelete(Parms.kpCellDesc,Parms.kpPointer);  		    --NumPolygonsMade; 		    NumVertices = 0; 		    EraseBox(BB,BB);% 		    Redisplay(Parms.kpCellDesc,BB);) 		    ExpectFirstPoint = True; 		    MenuDeselect(MenuUNDO);A 		    }Y 		elif(NumVertices > 1){ 		    MenuSelect(MenuUNDO); # 		    RemoveLastPointInPath(&Path);u 		    /* delete old polygon */1 		    CDDelete(Parms.kpCellDesc,Parms.kpPointer);  		    EraseBox(BB,BB);% 		    Redisplay(Parms.kpCellDesc,BB);u= 		    /* make new polygon, and set info to 'being created' */", 		    if(Not CDMakePolygon(Parms.kpCellDesc,( 			Parms.kpLayer,Path,&Parms.kpPointer)) 			MallocFailed();4 		    CDSetInfo(Parms.kpCellDesc,Parms.kpPointer,5); 		    --NumVertices; 		    X = Y = -INFINITY; 		    /* find new BB */ : 		    CDStatusInt = CDBB(Parms.kpCellDesc,Parms.kpPointer,2 			&BB.kaLeft,&BB.kaBottom,&BB.kaRight,&BB.kaTop);, 		    ShowPath(Parms.kpLayer,Path,BB,False); 		    MenuDeselect(MenuUNDO);] 		    }  		}r
 	    else{+ 		if((NumVertices == 1 Or NumVertices == 2)p 		    And NumPolygonsMade > 0){n1 		    CDDelete(Parms.kpCellDesc,Parms.kpPointer);e6 		    ShowPrompt("Can't allow a degenerate polygon."); 		    }  		else4 		    CDSetInfo(Parms.kpCellDesc,Parms.kpPointer,0); 		*LookedAhead = True; 		if(NumPolygonsMade > 0){ 		    if(Not ExpectFirstPoint){r 			EraseBox(BB,BB); " 			Redisplay(Parms.kpCellDesc,BB); 			} 		    Parms.kpModified = True; 		    }) 		Parms.kpPointer = NULL;F 		MenuDeselect(MenuPOLYG);	 		return;W 		}, 	    }< 	elif(Parms.kpPointLayerTable Or !Parms.kpPointCoarseWindow) 	    continue; 	elif(ExpectFirstPoint){ 	    NumVertices = 1;i 	    ExpectFirstPoint = False; 	    Terminated = False;> 	    if((Path = (struct p *)malloc(sizeof(struct p))) == NULL) 		MallocFailed();r 	    Path->pX = X = Cursor.kcX;k 	    Path->pY = Y = Cursor.kcY;. 	    Path->pSucc = NULL;> 	    if(Not CDMakePolygon(Parms.kpCellDesc,Parms.kpLayer,Path,$ 		&Parms.kpPointer)) MallocFailed();3 	    CDSetInfo(Parms.kpCellDesc,Parms.kpPointer,5);s  	    BB.kaRight = BB.kaLeft = X;  	    BB.kaBottom = BB.kaTop = Y; 	    ++NumPolygonsMade;  	    }+ 	elif(Cursor.kcX == X And Cursor.kcY == Y){dE 	    /* If the number of reference points is one or two, forget it */CI 	    if( (NumVertices == 1 Or NumVertices == 2) And NumPolygonsMade > 0){ - 		CDDelete(Parms.kpCellDesc,Parms.kpPointer);r2 		ShowPrompt("Can't allow a degenerate polygon."); 		}a	 	    elseP0 		CDSetInfo(Parms.kpCellDesc,Parms.kpPointer,0); 	    EraseBox(BB,BB); $ 	    Redisplay(Parms.kpCellDesc,BB); 	    ExpectFirstPoint = True;C 	    Terminated = True;. 	    }) 	elif(NumVertices < MAXPOLYGONVERTICES){ C 	    X = Cursor.kcX; 	    Y = Cursor.kcY;$ 	    AppendPointToPath(&X,&Y,&Path); 	    /* delete old polygon */R0 	    CDDelete(Parms.kpCellDesc,Parms.kpPointer); 	    /* make new polygon */r9 	    if(Not CDMakePolygon(Parms.kpCellDesc,Parms.kpLayer,l) 		Path,&Parms.kpPointer)) MallocFailed(); 3 	    CDSetInfo(Parms.kpCellDesc,Parms.kpPointer,5);,D 	    CDStatusInt = CDBB(Parms.kpCellDesc,Parms.kpPointer,&BB.kaLeft,& 		&BB.kaBottom,&BB.kaRight,&BB.kaTop);+ 	    ShowPath(Parms.kpLayer,Path,BB,False);	 	    ++NumVertices;  	    } 	else{. 	    ShowPrompt("Sorry.  Too many vertices."); 	    } 	}     }      InPath(Delta,Path,X,Y)     int X,Y;     struct p *Path;B     int Delta;3     /* Is (X,Y) on the path described by <Path>? */R     {B     struct p *Pair;a       Pair = Path;     while(Pair != NULL){3 	if(X <= Pair->pX + Delta And X >= Pair->pX - Delta(9 	    And Y <= Pair->pY + Delta And Y >= Pair->pY - Delta)n 	    return(True); 	Pair = Pair->pSucc; 	}     return(False);     }h    % ShowPath(Layer,Path,Window,Terminate)"     int Layer;     struct p *Path;(     struct ka Window;k5     int Terminate;		/* If True, the path is closed */a     {{     struct p *Pair;F&     int firstX,firstY,X,Y,lastX,lastY;       Pair = Path;     firstX = lastX = Pair->pX;     firstY = lastY = Pair->pY;     Pair = Pair->pSucc;	     while(Pair != NULL){ 	X = Pair->pX; 	Y = Pair->pY;( 	ShowLine(Layer,lastX,lastY,X,Y,Window); 	lastX = X;  	lastY = Y;; 	Pair = Pair->pSucc; 	}     if(Terminate)=2 	ShowLine(Layer,firstX,firstY,lastX,lastY,Window);     }s     ShowPolygon(Layer,Path,Window)     int Layer;     struct p *Path;l     struct ka Window;-     {      struct p *Pair;P1     static int FinePolygonBuffer[POLYGONBUFSIZE];;3     static int CoarsePolygonBuffer[POLYGONBUFSIZE];L     char oldRedisplay;1     int i,n,nfine,ncoarse,n2,n2fine,n2coarse,X,Y;l       i = n = 0;     Pair = Path;     while(Pair != NULL){ 	n++;. 	Pair = Pair->pSucc; 	}     Pair = Path;H     if(Layer == Parms.kpHighlightingPixel Or !LayerTable[Layer].klFilled" 	Or !FB.fFilledPolygons Or n < 3){" 	ShowPath(Layer,Path,Window,True); 	return; 	}"     n = min(MAXPOLYGONVERTICES,n);     n2 = n + n;D     while(i < n2){ 	X = Pair->pX; 	Y = Pair->pY; 	TPoint(&X,&Y);  	FinePolygonBuffer[i] = X; 	CoarsePolygonBuffer[i++] = X; 	FinePolygonBuffer[i] = Y; 	CoarsePolygonBuffer[i++] = Y; 	Pair = Pair->pSucc; 	}     nfine = ncoarse = n;     ;     /* Why clip to the window twice when once is enough? */ 7     FBPolygonClip(CoarsePolygonBuffer,&ncoarse,Window);C     if(ncoarse <= 0) 	return;!     n2coarse = ncoarse + ncoarse;d     nfine = ncoarse;     for(i=0; i<n2coarse; ++i)P/ 	FinePolygonBuffer[i] = CoarsePolygonBuffer[i];o  7     FBPolygonClip(FinePolygonBuffer,&nfine,FineWindow);a=     FBPolygonClip(CoarsePolygonBuffer,&ncoarse,CoarseWindow);sA     n2fine = nfine + nfine;	    /* number of vertices must be  */rE     n2coarse = ncoarse + ncoarse;   /* handled separately.  Drag!  */g2     if(Parms.kpRedisplayControl == SPLITSCREEN Or 1 	Parms.kpRedisplayControl == COARSEVIEWPORTONLY){  	i = 0;  	while(i < n2coarse){g= 	    LToP(CoarseViewport,CoarseWindow,CoarsePolygonBuffer[i],5 		CoarsePolygonBuffer[i + 1]); 	    i += 2; 	    } 	}2     if(Parms.kpRedisplayControl == SPLITSCREEN Or / 	Parms.kpRedisplayControl == FINEVIEWPORTONLY){  	i = 0;  	while(i < n2fine){=7 	    LToP(FineViewport,FineWindow,FinePolygonBuffer[i],  		FinePolygonBuffer[i + 1]); 	    i += 2; 	    } 	}2     if(Parms.kpRedisplayControl == SPLITSCREEN Or 1 	Parms.kpRedisplayControl == COARSEVIEWPORTONLY){e #ifdef FBCONTROL 	if(Parms.kpEnableFB)i #endif< 	    FBPolygon(Layer,FILL,LayerTable[Layer].klCoarseStyleID, 		CoarsePolygonBuffer,ncoarse);o 	}2     if(Parms.kpRedisplayControl == SPLITSCREEN Or / 	Parms.kpRedisplayControl == FINEVIEWPORTONLY){  #ifdef FBCONTROL 	if(Parms.kpEnableFB)d #endif: 	    FBPolygon(Layer,FILL,LayerTable[Layer].klFineStyleID, 		FinePolygonBuffer,nfine);l 	}  $     /* don't outline a solid fill */=     if(Parms.kpOutline And LayerTable[Layer].klStyleID != 0){x+ 	if(LayerTable[Layer].klCoarseStyleID != 0)n& 	    ShowPath(Layer,Path,Window,True);* 	elif(LayerTable[Layer].klFineStyleID != 09 	    And Parms.kpRedisplayControl != COARSEVIEWPORTONLY){/- 	    oldRedisplay = Parms.kpRedisplayControl;e1 	    Parms.kpRedisplayControl = FINEVIEWPORTONLY;.* 	    ShowPath(Layer,Path,FineWindow,True);- 	    Parms.kpRedisplayControl = oldRedisplay;B 	    } 	}     }g     Flash(LookedAhead)     int *LookedAhead;h     {s     struct ka BB;t     struct p *Path, *NewPath;o     double angle, Rad;     int CenterX, CenterY;      int PerimeterX, PerimeterY;)
     int X, Y;      int i, step;     int NoFlashMade = 1;       Parms.kpPointer = NULL;      MenuSelect(MenuFLASH);2     step = max(1, 360/Parms.kpNumRoundFlashSides);	     loop{  	loop{$ 	    ShowPrompt("Point at center.");
 	    Point();d/ 	    if(strcmp(Parms.kpCommand,MenuUNDO) == 0){  		if(NoFlashMade){ 		    Parms.kpPointer = NULL;e 		    *LookedAhead = True; 		    MenuDeselect(MenuFLASH);
 		    return;f 		    }< 		else{t 		    MenuSelect(MenuUNDO);+1 		    CDDelete(Parms.kpCellDesc,Parms.kpPointer);c 		    NoFlashMade = 1; 		    EraseBox(BB,BB);% 		    Redisplay(Parms.kpCellDesc,BB);e 		    MenuDeselect(MenuUNDO);) 		    }B 		}o% 	    elif(Parms.kpCommand[0] != EOS){s 		*LookedAhead = True; 		Parms.kpPointer = NULL;e 		MenuDeselect(MenuFLASH);	 		return;e 		}o$ 	    elif(Parms.kpPointCoarseWindow) 		break; 	    } 	CenterX = Cursor.kcX; 	CenterY = Cursor.kcY;0 	/* show center so the user won't be confused */C 	ShowMarker(DISPLAY,Parms.kpHighlightingPixel,CenterX,CenterY,200);W   	loop{+ 	    ShowPrompt("Point at the perimeter."); 
 	    Point();+# 	    if(Parms.kpCommand[0] != EOS){s 		Parms.kpPointer = NULL;O 		*LookedAhead = True; 		MenuDeselect(MenuFLASH);	 		return;  		}e# 	    if(Parms.kpPointCoarseWindow){t 		PerimeterX = Cursor.kcX; 		PerimeterY = Cursor.kcY; 		X = CenterX - PerimeterX;} 		Y = CenterY - PerimeterY;y, 		Rad = sqrt( (double)((X * X) + (Y * Y)) );; 		if((int)Rad < LayerTable[Parms.kpLayer].klMinDimensions){. 		    ShowPrompt(f@ 		    "Sorry.  The radius is less than the minimum dimension.");. 		    ShowMarker(ERASE,0,CenterX,CenterY,200); 		    Parms.kpPointer = NULL;E 		    MenuDeselect(MenuFLASH);
 		    return;R 		    }  		break; 		}L 	    } 	if(Parms.kpClipVerticesToGrid)PG 	    ShowPrompt("Vertices will be clipped to the nearest grid point.");f5 	/* now erase center so the user won't be confused */ A 	ShowMarker(ERASE,Parms.kpHighlightingPixel,CenterX,CenterY,200);e  E 	if((NewPath = Path = (struct p *) malloc(sizeof(struct p))) == NULL)e 	    MallocFailed(); 	angle = 0;t1 	NewPath->pX = CenterX + (int)(Rad * sin(angle));A1 	NewPath->pY = CenterY + (int)(Rad * cos(angle));i, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY);# 	for(i = step; i < 360; i += step){a 	    angle = i/RADTODEG;! 	    if((NewPath = NewPath->pSuccl4 			= (struct p *) malloc(sizeof(struct p))) == NULL) 		MallocFailed();A5 	    NewPath->pX = CenterX + (int)(Rad * sin(angle)); 5 	    NewPath->pY = CenterY + (int)(Rad * cos(angle));n0 	    ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	    } 	angle = i/RADTODEG; 	if((NewPath = NewPath->pSuccm7 		    = (struct p *) malloc(sizeof(struct p))) == NULL)p 	    MallocFailed();1 	NewPath->pX = CenterX + (int)(Rad * sin(angle));P1 	NewPath->pY = CenterY + (int)(Rad * cos(angle));(, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	NewPath->pSucc = NULL;a: 	if(Not CDMakePolygon(Parms.kpCellDesc,Parms.kpLayer,Path,' 	    &Parms.kpPointer)) MallocFailed();; 	Y = (int)(Rad); 	BB.kaLeft = CenterX - Y;k 	BB.kaRight = CenterX + Y; 	BB.kaTop = CenterY + Y; 	BB.kaBottom = CenterY - Y;r 	EraseBox(BB,BB);f  	Redisplay(Parms.kpCellDesc,BB); 	NoFlashMade = 0;X 	Parms.kpModified = True;i 	}     }Y     Doughnut(LookedAhead)i     int *LookedAhead;a     {U     struct ka BB;;     struct o *Pointer1;n     struct o *Pointer2;i&     struct p *Path1, *Path2, *NewPath;     double angle, Rad1, Rad2;r     int CenterX, CenterY;i!     int Perimeter1X, Perimeter1Y; !     int Perimeter2X, Perimeter2Y;n
     int X, Y;a     int i, step;     int NoDonutMade = 1;       Pointer1 = NULL;     Pointer2 = NULL;     MenuSelect(MenuDONUT);2     step = max(1, 360/Parms.kpNumRoundFlashSides);	     loop{Z 	loop{$ 	    ShowPrompt("Point at center.");
 	    Point();f/ 	    if(strcmp(Parms.kpCommand,MenuUNDO) == 0){P 		if(NoDonutMade){ 		    *LookedAhead = True; 		    MenuDeselect(MenuDONUT);
 		    return;r 		    }. 		else{h 		    MenuSelect(MenuUNDO);r* 		    CDDelete(Parms.kpCellDesc,Pointer1);* 		    CDDelete(Parms.kpCellDesc,Pointer2); 		    NoDonutMade = 1; 		    EraseBox(BB,BB);% 		    Redisplay(Parms.kpCellDesc,BB);= 		    MenuDeselect(MenuUNDO);o 		    }) 		}F% 	    elif(Parms.kpCommand[0] != EOS){n 		*LookedAhead = True; 		MenuDeselect(MenuDONUT);	 		return;f 		}+$ 	    elif(Parms.kpPointCoarseWindow) 		break; 	    } 	CenterX = Cursor.kcX; 	CenterY = Cursor.kcY;0 	/* show center so the user won't be confused */C 	ShowMarker(DISPLAY,Parms.kpHighlightingPixel,CenterX,CenterY,200);u   	loop{* 	    ShowPrompt("Point at inner radius.");
 	    Point();c# 	    if(Parms.kpCommand[0] != EOS){B 		*LookedAhead = True; 		MenuDeselect(MenuDONUT);	 		return;e 		}t& 	    if(Not Parms.kpPointCoarseWindow) 		continue;n 	    Perimeter1X = Cursor.kcX; 	    Perimeter1Y = Cursor.kcY; 	    X = CenterX - Perimeter1X;	 	    Y = CenterY - Perimeter1Y;a0 	    Rad1 = sqrt( (double)((X * X) + (Y * Y)) ); 	    if(Rad1 > 0)X 		break; 	    } 	loop{* 	    ShowPrompt("Point at outer radius.");
 	    Point();a# 	    if(Parms.kpCommand[0] != EOS){t 		*LookedAhead = True; 		MenuDeselect(MenuDONUT);	 		return;h 		}w& 	    if(Not Parms.kpPointCoarseWindow) 		continue;c 	    Perimeter2X = Cursor.kcX; 	    Perimeter2Y = Cursor.kcY; 	    X = CenterX - Perimeter2X;a 	    Y = CenterY - Perimeter2Y;s0 	    Rad2 = sqrt( (double)((X * X) + (Y * Y)) ); 	    if(Rad2 > 0)S 		break; 	    } 	if(abs((int)(Rad1-Rad2)) <l0 	    LayerTable[Parms.kpLayer].klMinDimensions){I 	    ShowPrompt("Sorry.  The width is less than the minimum dimension.");  	    continue; 	    } 	if(Parms.kpClipVerticesToGrid)CG 	    ShowPrompt("Vertices will be clipped to the nearest grid point.");a5 	/* now erase center so the user won't be confused */ A 	ShowMarker(ERASE,Parms.kpHighlightingPixel,CenterX,CenterY,200);t  # 	/* start first half of doughnut */  	angle = -95/RADTODEG;F 	if((NewPath = Path1 = (struct p *) malloc(sizeof(struct p))) == NULL) 	    MallocFailed();2 	NewPath->pX = CenterX + (int)(Rad1 * sin(angle));2 	NewPath->pY = CenterY + (int)(Rad1 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY);' 	for(i = step - 95; i < 95; i += step){e 	    angle = i/RADTODEG;! 	    if((NewPath = NewPath->pSuccS4 			= (struct p *) malloc(sizeof(struct p))) == NULL) 		MallocFailed();i6 	    NewPath->pX = CenterX + (int)(Rad1 * sin(angle));6 	    NewPath->pY = CenterY + (int)(Rad1 * cos(angle));0 	    ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	    } 	angle = i/RADTODEG; 	if((NewPath = NewPath->pSuccs3 		= (struct p *) malloc(sizeof(struct p))) == NULL)s 	    MallocFailed();2 	NewPath->pX = CenterX + (int)(Rad1 * sin(angle));2 	NewPath->pY = CenterY + (int)(Rad1 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	if((NewPath = NewPath->pSuccd3 		= (struct p *) malloc(sizeof(struct p))) == NULL)+ 	    MallocFailed();2 	NewPath->pX = CenterX + (int)(Rad2 * sin(angle));2 	NewPath->pY = CenterY + (int)(Rad2 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	for(i; i > -95; i -= step){ 	    angle = i/RADTODEG;! 	    if((NewPath = NewPath->pSuccn4 			= (struct p *) malloc(sizeof(struct p))) == NULL) 		MallocFailed();L6 	    NewPath->pX = CenterX + (int)(Rad2 * sin(angle));6 	    NewPath->pY = CenterY + (int)(Rad2 * cos(angle));0 	    ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	    } 	angle = i/RADTODEG; 	if((NewPath = NewPath->pSucce3 		= (struct p *) malloc(sizeof(struct p))) == NULL); 	    MallocFailed();2 	NewPath->pX = CenterX + (int)(Rad2 * sin(angle));2 	NewPath->pY = CenterY + (int)(Rad2 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	NewPath->pSucc = NULL;P  $ 	/* start second half of doughnut */ 	angle = 85/RADTODEG;mF 	if((NewPath = Path2 = (struct p *) malloc(sizeof(struct p))) == NULL) 	    MallocFailed();2 	NewPath->pX = CenterX + (int)(Rad1 * sin(angle));2 	NewPath->pY = CenterY + (int)(Rad1 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY);( 	for(i = 85 + step; i < 275; i += step){ 	    angle = i/RADTODEG;! 	    if((NewPath = NewPath->pSuccb4 			= (struct p *) malloc(sizeof(struct p))) == NULL) 		MallocFailed();T6 	    NewPath->pX = CenterX + (int)(Rad1 * sin(angle));6 	    NewPath->pY = CenterY + (int)(Rad1 * cos(angle));0 	    ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	    } 	angle = i/RADTODEG; 	if((NewPath = NewPath->pSuccp3 		= (struct p *) malloc(sizeof(struct p))) == NULL)b 	    MallocFailed();2 	NewPath->pX = CenterX + (int)(Rad1 * sin(angle));2 	NewPath->pY = CenterY + (int)(Rad1 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	if((NewPath = NewPath->pSuccm3 		= (struct p *) malloc(sizeof(struct p))) == NULL)( 	    MallocFailed();2 	NewPath->pX = CenterX + (int)(Rad2 * sin(angle));2 	NewPath->pY = CenterY + (int)(Rad2 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	for(i; i > 85; i -= step){) 	    angle = i/RADTODEG;! 	    if((NewPath = NewPath->pSucc=4 			= (struct p *) malloc(sizeof(struct p))) == NULL) 		MallocFailed();;6 	    NewPath->pX = CenterX + (int)(Rad2 * sin(angle));6 	    NewPath->pY = CenterY + (int)(Rad2 * cos(angle));0 	    ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	    } 	angle = i/RADTODEG; 	if((NewPath = NewPath->pSucc(3 		= (struct p *) malloc(sizeof(struct p))) == NULL)r 	    MallocFailed();2 	NewPath->pX = CenterX + (int)(Rad2 * sin(angle));2 	NewPath->pY = CenterY + (int)(Rad2 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	NewPath->pSucc = NULL;=; 	if(Not CDMakePolygon(Parms.kpCellDesc,Parms.kpLayer,Path1,t  	    &Pointer1)) MallocFailed();; 	if(Not CDMakePolygon(Parms.kpCellDesc,Parms.kpLayer,Path2,=  	    &Pointer2)) MallocFailed();" 	X = (int)(Rad1); Y = (int)(Rad2);
 	if(X > Y) 	    SwapInts(X,Y);h 	BB.kaLeft = CenterX - Y;  	BB.kaRight = CenterX + Y; 	BB.kaTop = CenterY + Y; 	BB.kaBottom = CenterY - Y;G 	EraseBox(BB,BB);p  	Redisplay(Parms.kpCellDesc,BB); 	NoDonutMade = 0;N 	Parms.kpModified = True;	 	}     }      Arcs(LookedAhead)      int *LookedAhead;l     {e     struct ka BB;=     struct p *Path, *NewPath;l     double angle, Rad1, Rad2;(     int angle1, angle2;      int CenterX, CenterY;p!     int Perimeter1X, Perimeter1Y; !     int Perimeter2X, Perimeter2Y;d
     int X, Y;g     int i, step;     int NoArcMade = True;t       Parms.kpPointer = NULL;p     MenuSelect(MenuARC);2     step = max(1, 360/Parms.kpNumRoundFlashSides);	     loop{N 	loop{+ 	    ShowPrompt("Point at center of arc.");i
 	    Point();e/ 	    if(strcmp(Parms.kpCommand,MenuUNDO) == 0){  		if(NoArcMade){ 		    Parms.kpPointer = NULL;i 		    *LookedAhead = True; 		    MenuDeselect(MenuARC);
 		    return;  		    }  		else{a 		    MenuSelect(MenuUNDO);C1 		    CDDelete(Parms.kpCellDesc,Parms.kpPointer);Y 		    NoArcMade = True;  		    EraseBox(BB,BB);% 		    Redisplay(Parms.kpCellDesc,BB);  		    MenuDeselect(MenuUNDO);i 		    }h 		}w% 	    elif(Parms.kpCommand[0] != EOS){i 		Parms.kpPointer = NULL;  		*LookedAhead = True; 		MenuDeselect(MenuARC);	 		return;i 		}l$ 	    elif(Parms.kpPointCoarseWindow) 		break; 	    } 	CenterX = Cursor.kcX; 	CenterY = Cursor.kcY;0 	/* show center so the user won't be confused */C 	ShowMarker(DISPLAY,Parms.kpHighlightingPixel,CenterX,CenterY,200);X   	loop{* 	    ShowPrompt("Point at inner radius.");
 	    Point();)# 	    if(Parms.kpCommand[0] != EOS){t 		*LookedAhead = True; 		Parms.kpPointer = NULL;s 		MenuDeselect(MenuARC);	 		return;  		}N& 	    if(Not Parms.kpPointCoarseWindow) 		continue;z 	    Perimeter1X = Cursor.kcX; 	    Perimeter1Y = Cursor.kcY; 	    X = CenterX - Perimeter1X;) 	    Y = CenterY - Perimeter1Y;(0 	    Rad1 = sqrt( (double)((X * X) + (Y * Y)) ); 	    if(Rad1 > 0)> 		break; 	    } 	loop{* 	    ShowPrompt("Point at outer radius.");
 	    Point();m# 	    if(Parms.kpCommand[0] != EOS){  		Parms.kpPointer = NULL;h 		*LookedAhead = True; 		MenuDeselect(MenuARC);	 		return;n 		}+& 	    if(Not Parms.kpPointCoarseWindow) 		continue;  	    Perimeter2X = Cursor.kcX; 	    Perimeter2Y = Cursor.kcY; 	    X = CenterX - Perimeter2X;r 	    Y = CenterY - Perimeter2Y;o0 	    Rad2 = sqrt( (double)((X * X) + (Y * Y)) ); 	    if(Rad2 > 0)e 		break; 	    } 	if(abs((int)(Rad1-Rad2)) <p0 	    LayerTable[Parms.kpLayer].klMinDimensions){I 	    ShowPrompt("Sorry.  The width is less than the minimum dimension.");s 	    continue; 	    } 	loop{B 	    ShowPrompt("Point to beginning of arc in a clockwise path.");
 	    Point();f# 	    if(Parms.kpCommand[0] != EOS){E 		Parms.kpPointer = NULL;( 		*LookedAhead = True; 		MenuDeselect(MenuARC);	 		return;i 		};& 	    if(Not Parms.kpPointCoarseWindow) 		continue; A 	    angle2 = (int) (RADTODEG*atan2((double)(Cursor.kcY-CenterY),t! 		(double)(Cursor.kcX-CenterX)));i 	    break;  	    } 	loop{< 	    ShowPrompt("Point to end of arc in a clockwise path.");
 	    Point();u# 	    if(Parms.kpCommand[0] != EOS){N 		Parms.kpPointer = NULL;  		*LookedAhead = True; 		MenuDeselect(MenuARC);	 		return;w 		}>& 	    if(Not Parms.kpPointCoarseWindow) 		continue;GA 	    angle1 = (int) (RADTODEG*atan2((double)(Cursor.kcY-CenterY), ! 		(double)(Cursor.kcX-CenterX)));  	    break;m 	    } 	if(Parms.kpClipVerticesToGrid)MG 	    ShowPrompt("Vertices will be clipped to the nearest grid point.");a5 	/* now erase center so the user won't be confused */iA 	ShowMarker(ERASE,Parms.kpHighlightingPixel,CenterX,CenterY,200);    	while(angle2 < angle1)e 	    angle2 += 360;L 	if((angle2 - angle1) >= 360){< 	    ShowPrompt("Sorry.  Arc is greater than 360 degrees."); 	    continue; 	    } 	/* start first half of arc */ 	angle = angle1/RADTODEG;oE 	if((NewPath = Path = (struct p *) malloc(sizeof(struct p))) == NULL)= 	    MallocFailed();2 	NewPath->pY = CenterY + (int)(Rad1 * sin(angle));2 	NewPath->pX = CenterX + (int)(Rad1 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY);/ 	for(i = angle1 + step; i < angle2; i += step){a 	    angle = i/RADTODEG;! 	    if((NewPath = NewPath->pSucce4 			= (struct p *) malloc(sizeof(struct p))) == NULL) 		MallocFailed();m6 	    NewPath->pY = CenterY + (int)(Rad1 * sin(angle));6 	    NewPath->pX = CenterX + (int)(Rad1 * cos(angle));0 	    ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	    } 	angle = angle2/RADTODEG;a 	if((NewPath = NewPath->pSucco3 		= (struct p *) malloc(sizeof(struct p))) == NULL)i 	    MallocFailed();2 	NewPath->pY = CenterY + (int)(Rad1 * sin(angle));2 	NewPath->pX = CenterX + (int)(Rad1 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	if((NewPath = NewPath->pSuccr3 		= (struct p *) malloc(sizeof(struct p))) == NULL)n 	    MallocFailed();2 	NewPath->pY = CenterY + (int)(Rad2 * sin(angle));2 	NewPath->pX = CenterX + (int)(Rad2 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY);/ 	for(i = angle2 - step; i > angle1; i -= step){{ 	    angle = i/RADTODEG;! 	    if((NewPath = NewPath->pSucc 4 			= (struct p *) malloc(sizeof(struct p))) == NULL) 		MallocFailed(); 6 	    NewPath->pY = CenterY + (int)(Rad2 * sin(angle));6 	    NewPath->pX = CenterX + (int)(Rad2 * cos(angle));0 	    ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	    } 	angle = angle1/RADTODEG;i 	if((NewPath = NewPath->pSucc)3 		= (struct p *) malloc(sizeof(struct p))) == NULL)d 	    MallocFailed();2 	NewPath->pY = CenterY + (int)(Rad2 * sin(angle));2 	NewPath->pX = CenterX + (int)(Rad2 * cos(angle));, 	ClipToGridPoint(&NewPath->pX,&NewPath->pY); 	NewPath->pSucc = NULL;[: 	if(Not CDMakePolygon(Parms.kpCellDesc,Parms.kpLayer,Path,' 	    &Parms.kpPointer)) MallocFailed();w" 	X = (int)(Rad1); Y = (int)(Rad2);
 	if(X > Y) 	    SwapInts(X,Y);g 	BB.kaLeft = CenterX - Y;( 	BB.kaRight = CenterX + Y; 	BB.kaTop = CenterY + Y; 	BB.kaBottom = CenterY - Y;  	EraseBox(BB,BB);l  	Redisplay(Parms.kpCellDesc,BB); 	NoArcMade = 0;b 	Parms.kpModified = True;i 	}     }a