' /* @(#)qsort.c	4.2 (Berkeley) 3/9/83 */b   /*  * qsort.c: L  * Our own version of the system qsort routine which is faster by an average.  * of 25%, with lows and highs of 10% and 50%.M  * The THRESHold below is the insertion sort threshold, and has been adjustedr   * for records of size 48 bytes.;  * The MTHREShold is where we stop finding a better median.c  */l  1 #define		THRESH		4		/* threshold for insertion */S/ #define		MTHRESH		6		/* threshold for median */   7 static  int		((*qcmp)());		/* the comparison routine */e- static  int		qsz;			/* size of each record */c/ static  int		thresh;			/* THRESHold in chars */v0 static  int		mthresh;		/* MTHRESHold in chars */   /*	  * qsort: J  * First, set up some global parameters for qst to share.  Then, quicksortJ  * with qst(), and then a cleanup insertion sort ourselves.  Sound simple?  * It's not...  */    qsort(base, n, size, compar) 	char	*base; 	int	n;p
 	int	size; 	int	((*compar)());( { # 	register char c, *i, *j, *lo, *hi;r 	char *min, *max;    	if (n <= 1)	 		return;  	qsz = size; 	qcmp = compar;  	thresh = qsz * THRESH;  	mthresh = qsz * MTHRESH;w 	max = base + n * qsz; 	if (n >= THRESH) {o 		qst(base, max);i 		hi = base + thresh;o	 	} else {  		hi = max;t 	} 	/*sE 	 * First put smallest element, which must be in the first THRESH, in E 	 * the first position as a sentinel.  This is done just by searchingAE 	 * the first THRESH elements (or the first n if n < THRESH), findingh5 	 * the min, and swapping it into the first position.  	 */( 	for (j = lo = base; (lo += qsz) < hi; )&                 if ((*qcmp)(j,lo) > 0)
 			j = lo; 	if (j != base) {r 		/* swap j into place */p- 		for (i = base, hi = base + qsz; i < hi; ) {P
 			c = *j;
 			*j++ = *i;t 			*i++ = c; 		}d 	} 	/*)C 	 * With our sentinel in place, we now run the following hyper-fastnH 	 * insertion sort.  For each remaining element, min, from [1] to [n-1],A 	 * set hi to the index of the element AFTER which this one goes.(G 	 * Then, do the standard insertion sort shift on a character at a timet' 	 * basis for each element in the frob.  	 */. 	for (min = base; (hi = min += qsz) < max; ) {% 		while ((*qcmp)(hi -= qsz, min) > 0)  			/* void */; 		if ((hi += qsz) != min) {o( 			for (lo = min + qsz; --lo >= min; ) { 				c = *lo;- 				for (i = j = lo; (j -= qsz) >= hi; i = j) 
 					*i = *j;  				*i = c;t 			} 		}o 	} }a   /*  * qst:S  * Do a quicksorteM  * First, find the median element, and put that one in the first place as the K  * discriminator.  (This "median" is just the median of the first, last and N  * middle elements).  (Using this median instead of the first element is a bigG  * win).  Then, the usual partitioning/swapping, followed by moving thetM  * discriminator into the right place.  Then, figure out the sizes of the twoLN  * partions, do the smaller one recursively and the larger one via a repeat ofO  * this code.  Stopping when there are less than THRESH elements in a partition)H  * and cleaning up with an insertion sort (in our caller) is a huge win.J  * All data swaps are done in-line, which is space-losing but time-saving.8  * (And there are only three places where this is done).  */    static qst(base, max) 	char *base, *max; {o 	register char c, *i, *j, *jj; 	register int ii;T 	char *mid, *tmp;  	int lo, hi;   	/*iF 	 * At the top here, lo is the number of characters of elements in the5 	 * current partition.  (Which should be max - base).tC 	 * Find the median of the first, last, and middle element and makelC 	 * that the middle element.  Set j to largest of first and middle.oD 	 * If max is larger than that guy, then it's that guy, else compareB 	 * max with loser of first and take larger.  Things are set up to6 	 * prefer the middle, then the first in case of ties. 	 */4 	lo = max - base;		/* number of elements as chars */ 	do	{ + 		mid = i = base + qsz * ((lo / qsz) >> 1);Q 		if (lo >= mthresh) {. 			j = ((*qcmp)((jj = base), i) > 0 ? jj : i);+ 			if ((*qcmp)(j, (tmp = max - qsz)) > 0) {  				/* switch to first loser */  				j = (j == jj ? i : jj);e 				if ((*qcmp)(j, tmp) < 0)
 					j = tmp;r 			} 			if (j != i) {
 				ii = qsz;e 				do	{ 					c = *i; 					*i++ = *j;, 					*j++ = c; 				} while (--ii);  			} 		}S 		/*2 		 * Semi-standard quicksort partitioning/swapping 		 */r% 		for (i = base, j = max - qsz; ; ) {T* 			while (i < mid && (*qcmp)(i, mid) <= 0)
 				i += qsz;* 			while (j > mid) { 				if ((*qcmp)(mid, j) <= 0) {S 					j -= qsz; 					continue; 				} . 				tmp = i + qsz;	/* value of i after swap */ 				if (i == mid) {t" 					/* j <-> mid, new mid is j */ 					mid = jj = j; 				} else { 					/* i <-> j */ 					jj = j; 					j -= qsz; 				}= 				goto swap; 			} 			if (i == mid) {
 				break; 			} else {f! 				/* i <-> mid, new mid is i */{
 				jj = mid; . 				tmp = mid = i;	/* value of i after swap */
 				j -= qsz;  			} 		swap:	 			ii = qsz; 			do	{  				c = *i;D 				*i++ = *jj;* 				*jj++ = c; 			} while (--ii); 			i = tmp;  		}e 		/*8 		 * Look at sizes of the two partitions, do the smaller6 		 * one first by recursion, then do the larger one by8 		 * making sure lo is its size, base and max are update4 		 * correctly, and branching back.  But only repeat6 		 * (recursively or by branching) if the partition is 		 * of at least size THRESH.s 		 */  		i = (j = mid) + qsz;* 		if ((lo = j - base) <= (hi = max - i)) { 			if (lo >= thresh) 				qst(base, j);  			base = i; 			lo = hi;R
 		} else { 			if (hi >= thresh) 				qst(i, max); 			max = j;n 		}  	} while (lo >= thresh); }.