 /*  * redisplay.c  **  * Copyright -C- 1981 Giles C. Billingsley'  * sccsid "@(#)redisplay.c	1.1  9/5/83"i  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programi;  * KIC is available free of charge to any interested party.tB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,*  * is forbidden.  */*  *  * /*  * The KIC redisplay code.  */    #include "kic.h"   /* Library routines */ #ifndef vms* char *sprintf(); #endif   char TypeOut[200];   Redisplay(CellDesc,AOI)      struct s *CellDesc;i     struct ka AOI;     {f     struct ka FineAOI;!     int BottomVisibleLayer,Layer;O  >     /* if AOI is outside of Coarse and Fine windows, return */  #     Parameters.kpNumGeometries = 0; #     if(Parameters.kpShowBandwidth){  	StartTiming();B 	}     BottomVisibleLayer = True;,     if(Parameters.kpExpandFineViewportOnly){9 	if(Parameters.kpRedisplayControl != COARSEVIEWPORTONLY){F 	    FineAOI.kaX = AOI.kaX;. 	    FineAOI.kaY = AOI.kaY;.8 	    FineAOI.kaLeft = max(AOI.kaLeft,FineWindow.kaLeft);; 	    FineAOI.kaRight = min(AOI.kaRight,FineWindow.kaRight);E5 	    FineAOI.kaTop = min(AOI.kaTop,FineWindow.kaTop);	> 	    FineAOI.kaBottom = max(AOI.kaBottom,FineWindow.kaBottom); 	    } 	elseT 	    FineAOI = AOI;. 	}       /*6      * Incrementally update grid if grid is on Bottom.      */.      if(!Parameters.kpGridOnTop){< 	if((Parameters.kpRedisplayControl == COARSEVIEWPORTONLY And/ 	    Parameters.kpDisplayFineViewport == False)e 	    OrK. 	    (Parameters.kpShowGridInLargeViewport And8 	    Parameters.kpRedisplayControl != FINEVIEWPORTONLY))/ 	    ShowGrid(CoarseViewport,CoarseWindow,AOI);h= 	elif((Parameters.kpRedisplayControl == COARSEVIEWPORTONLY Orf2 	    Parameters.kpRedisplayControl == SPLITSCREEN) 	    And. 	    Parameters.kpDisplayFineViewport == True)+ 	    ShowAxes(CoarseViewport,CoarseWindow);b8 	if(Parameters.kpRedisplayControl == FINEVIEWPORTONLY Or2 	    Parameters.kpRedisplayControl == SPLITSCREEN)+ 	    ShowGrid(FineViewport,FineWindow,AOI);y 	}1     for(Layer = 1;Layer <= NumLayerTable;++Layer)a! 	if(LayerTable[Layer].klVisible){ & 	    Parameters.kpHierarchyLevel = 0; ; 	    RedisplayLayer(CellDesc,AOI,Layer,BottomVisibleLayer);r" 	    /* Test for user interrupt */# 	    if(Parameters.kpSIGINTERRUPT){o 		RedisplayAfterInterrupt();	 		return;  		}e- 	    if(Parameters.kpExpandFineViewportOnly){ # 		Parameters.kpHierarchyLevel = 0; n7 		PeekLayer(CellDesc,FineAOI,Layer,BottomVisibleLayer);d  		if(Parameters.kpSIGINTERRUPT){  		    RedisplayAfterInterrupt();
 		    return;t 		    }y 		}   	    BottomVisibleLayer = False; 	    };h     /*3      * Incrementally update grid if grid is on top.e      */I     if(Parameters.kpGridOnTop){m< 	if((Parameters.kpRedisplayControl == COARSEVIEWPORTONLY And/ 	    Parameters.kpDisplayFineViewport == False)e 	    Ory. 	    (Parameters.kpShowGridInLargeViewport And8 	    Parameters.kpRedisplayControl != FINEVIEWPORTONLY))/ 	    ShowGrid(CoarseViewport,CoarseWindow,AOI);K= 	elif((Parameters.kpRedisplayControl == COARSEVIEWPORTONLY Or	2 	    Parameters.kpRedisplayControl == SPLITSCREEN) 	    And. 	    Parameters.kpDisplayFineViewport == True)+ 	    ShowAxes(CoarseViewport,CoarseWindow);a8 	if(Parameters.kpRedisplayControl == FINEVIEWPORTONLY Or2 	    Parameters.kpRedisplayControl == SPLITSCREEN)+ 	    ShowGrid(FineViewport,FineWindow,AOI);e 	}     else' 	ShowAxes(CoarseViewport,CoarseWindow);r       /*5      * Show fine positioning window in coarse window.u      */ ;     if(Parameters.kpRedisplayControl == FINEVIEWPORTONLY Or / 	Parameters.kpRedisplayControl == SPLITSCREEN){yA 	ShowBox(Parameters.kpHighlightingPixel,FineWindow,CoarseWindow);f2 	FBMoveTo(FineViewport.kaLeft,FineViewport.kaTop);7 	FBDrawLineTo(FineViewport.kaRight,FineViewport.kaTop);#: 	FBDrawLineTo(FineViewport.kaRight,FineViewport.kaBottom);9 	FBDrawLineTo(FineViewport.kaLeft,FineViewport.kaBottom); 6 	FBDrawLineTo(FineViewport.kaLeft,FineViewport.kaTop); 	}       /*"      * Highlight selected objects.      */*     SelectQShow(AOI);f  #     if(Parameters.kpShowBandwidth){a 	StopTiming();C 	ShowRatio("geometries",Parameters.kpNumGeometries,"seconds(real)",, 	    ElapsedRealTime());C 	ShowRatio("geometries",Parameters.kpNumGeometries,"seconds(user)",p 	    ElapsedUserTime());E 	ShowRatio("geometries",Parameters.kpNumGeometries,"seconds(system)",S 	    ElapsedSystemTime()); 	}     }   5 RedisplayLayer(CellDesc,AOI,Layer,BottomVisibleLayer)      struct s *CellDesc;a     struct ka AOI;!     int Layer,BottomVisibleLayer;n     {,     struct g *GenDesc;     struct o *Pointer;     struct p *Path;a     struct ka BB;i     struct t *TGen;t     struct s *MasterDesc; !     struct ka ElementBB,MasterBB;y     char Type;     char *MasterName;f     char *TypeIn;/     char *Label;
     int Info;P     int X,Y,Width;     int NumX,DX,NumY,DY;!     int MasterHeight,MasterWidth;F     register int Int1,Int2;e  "     ++Parameters.kpHierarchyLevel;     /*      * Traverse calls first.<      * So, if instances aren't expanded, top level geometry @      * isn't obscured by the symbolic pictures of any instances.      */aN     if(Not CDInitGen(CellDesc,0,AOI.kaLeft,AOI.kaBottom,AOI.kaRight,AOI.kaTop, 	&GenDesc)) MallocFailed();r  
     loop { 	/* Test for user interrupt */ 	if(Parameters.kpSIGINTERRUPT){P 	    return; 	    }   	/*rH 	 * If we aren't expanding instances, we want to show symbolic layers on 	 * second level only. 	 */& 	if((Not Parameters.kpExpandInstances)) 	    And Parameters.kpHierarchyLevel > 1)P 	    break;e" 	CDGen(CellDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;n 	/*=E 	 * Don't display if conditionally deleted.  Info == 5 (conditionally)' 	 * created) only applies to geometrieso 	 */  	CDInfo(CellDesc,Pointer,&Info); 	if(Info == 2) 	    continue;1 	CDCall(Pointer,&MasterName,&NumX,&DX,&NumY,&DY);o #ifdef TRACE if(Layer == 1){O char cat[200];G sprintf(cat,"Recursive redisplay section: MasterName = %s",MasterName);p ShowPromptAndWait(cat);s }i #endif
 	if(TFull()){f4 	    ShowPrompt("Cell hierarchy is too deep. MORE"); 	    FBKeyboard(&TypeIn);n< 	    ShowPrompt("Probably you have a recursive hierarchy.");
 	    TInit();a# 	    --Parameters.kpHierarchyLevel;k 	    return; 	    } 	else {D0 	    if(Not CDOpen(MasterName,&MasterDesc,'r')){8 		sprintf(TypeOut,"Can't display %s. MORE",MasterName);  		ShowPrompt(TypeOut); 		FBKeyboard(&TypeIn);. 		sprintf(TypeOut,"%s. MORE",CDStatusString);  		ShowPrompt(TypeOut); 		FBKeyboard(&TypeIn);  		--Parameters.kpHierarchyLevel;	 		return;e 		}o& 	    elif(CDStatusInt == CDNEWSYMBOL){5 		sprintf(TypeOut,"Can't find cell %s.",MasterName); e 		ShowPrompt(TypeOut);  		--Parameters.kpHierarchyLevel;	 		return;o 		}o 	    }? 	if(BottomVisibleLayer And (Not Parameters.kpExpandInstances)){n 	    /**? 	     * Unexpanded form of an instance array is its BB with theo0 	     * name of its master shown in its center. ; 	     * If it is not 1 by 1, tell the user its dimensions. r% 	     * BB dimensions are shown also.(8 	     * CDBB will always return True if Pointer != NULL. 	     */A 	    CDStatusInt = CDBB(CellDesc,Pointer,&BB.kaLeft,&BB.kaBottom,O 		&BB.kaRight,&BB.kaTop); % 	    TPoint(&BB.kaLeft,&BB.kaBottom);o# 	    TPoint(&BB.kaRight,&BB.kaTop); ? 	    if(BB.kaRight < BB.kaLeft) SwapInts(BB.kaLeft,BB.kaRight);a? 	    if(BB.kaTop < BB.kaBottom) SwapInts(BB.kaBottom,BB.kaTop);  #ifdef TRACE {. char doggy[200];J sprintf(doggy,"Recursive redisplay section: translated BB = %d,%d  %d,%d",/     BB.kaLeft,BB.kaBottom,BB.kaRight,BB.kaTop);Y ShowPromptAndWait(doggy);a }O #endif 	    /*o 	     * Outline BB of Instance.= 	     */  	    if(LayerTable[2].klFilled){! 		LayerTable[2].klFilled = False;W 		ShowBox(2,BB,AOI); n  		LayerTable[2].klFilled = True; 		}n 	    else ShowBox(2,BB,AOI); 	    if(NumX != 1 Or NumY != 1) 3 		sprintf(TypeOut,"%d/%d %s",NumX,NumY,MasterName);t+ 	    else sprintf(TypeOut,"%s",MasterName);p0 	    ShowLabel(1,TypeOut,BB.kaLeft,BB.kaBottom +; 		(BB.kaTop-BB.kaBottom)/2,Parameters.kpLabelAllInstances);e? 	    sprintf(TypeOut,"%d/%d",(BB.kaRight-BB.kaLeft)/RESOLUTION, % 		(BB.kaTop-BB.kaBottom)/RESOLUTION);I/ 	    ShowLabel(3,TypeOut,BB.kaLeft,BB.kaBottom,W" 		Parameters.kpLabelAllInstances); 	    }* 	if((Not LayerTable[Layer].klSymbolic) And( 	    (Not Parameters.kpExpandInstances)) 	    continue;: 	if(Not CDBB(MasterDesc,(struct o *)NULL,&MasterBB.kaLeft,; 	    &MasterBB.kaBottom,&MasterBB.kaRight,&MasterBB.kaTop))a 	    MallocFailed();# 	for(Int1 = NumY;Int1 >= 1;--Int1){u' 	    for(Int2 = 1;Int2 <= NumX;++Int2){y3 		MasterWidth = MasterBB.kaRight - MasterBB.kaLeft;o4 		MasterHeight = MasterBB.kaTop - MasterBB.kaBottom;
 		TPush(); 		TIdentity(); 		CDInitTGen(Pointer,&TGen); 		loop {  		    CDTGen(&TGen,&Type,&X,&Y); 		    if(TGen == NULL)	 			break;m 		    if(Type == CDROTATE){t 			TRotate(X,Y);
 			if(X == 0)"* 			    SwapInts(MasterWidth,MasterHeight); 			} 		    elif(Type == CDTRANSLATE)%* 			TTranslate(X+(Int2-1)*(MasterWidth+DX),% 			    Y+(Int1-1)*(MasterHeight+DY));a 		    elif(Type == CDMIRRORX)u	 			TMX();  		    elif(Type == CDMIRRORY)Y	 			TMY();p 		    }e 		TPremultiply();l 		/*. 		 * Box test instance array element with AOI. 		 */k% 		ElementBB.kaLeft = MasterBB.kaLeft; ) 		ElementBB.kaBottom = MasterBB.kaBottom;e' 		ElementBB.kaRight = MasterBB.kaRight; # 		ElementBB.kaTop = MasterBB.kaTop;y0 		TPoint(&ElementBB.kaLeft,&ElementBB.kaBottom);. 		TPoint(&ElementBB.kaRight,&ElementBB.kaTop);* 		if(ElementBB.kaRight < ElementBB.kaLeft)3 		    SwapInts(ElementBB.kaLeft,ElementBB.kaRight);a* 		if(ElementBB.kaTop < ElementBB.kaBottom)3 		    SwapInts(ElementBB.kaBottom,ElementBB.kaTop);,, 		if(Not (ElementBB.kaLeft > AOI.kaRight Or ' 		    ElementBB.kaRight < AOI.kaLeft Or ' 		    ElementBB.kaBottom > AOI.kaTop Or(' 		    ElementBB.kaTop < AOI.kaBottom)){t* 		    RedisplayLayer(MasterDesc,AOI,Layer, 			BottomVisibleLayer);  		    } 	 		TPop();A 		}. 	    } 	}H     if(Not CDInitGen(CellDesc,Layer,AOI.kaLeft,AOI.kaBottom,AOI.kaRight,% 	AOI.kaTop,&GenDesc)) MallocFailed();k
     loop { 	/* Test for user interrupt */ 	if(Parameters.kpSIGINTERRUPT){  	    return; 	    }" 	CDGen(CellDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;d  	CDInfo(CellDesc,Pointer,&Info); 	if(Info == 2 Or Info == 5)T 	    continue; 	++Parameters.kpNumGeometries; 	CDType(Pointer,&Type);  	if(Type == CDWIRE){) 	    CDWire(Pointer,&Layer,&Width,&Path); $ 	    ShowWire(Layer,Width,Path,AOI); 	    } 	elif(Type == CDPOLYGON){.% 	    CDPolygon(Pointer,&Layer,&Path);P! 	    ShowPolygon(Layer,Path,AOI);  	    } 	elif(Type == CDLABEL){R* 	    CDLabel(Pointer,&Layer,&Label,&X,&Y);> 	    ShowLabel(Layer,Label,X,Y,Parameters.kpDisplayAllLabels); 	    } 	elif(Type == CDBOX){lA 	    CDStatusInt = CDBB(CellDesc,Pointer,&BB.kaLeft,&BB.kaBottom,  		&BB.kaRight,&BB.kaTop);n 	    ShowBox(Layer,BB,AOI);  	    } 	}"     --Parameters.kpHierarchyLevel;     }f    0 PeekLayer(CellDesc,AOI,Layer,BottomVisibleLayer)     struct s *CellDesc;i     struct ka AOI;!     int Layer,BottomVisibleLayer;I     {;     struct g *GenDesc;     struct o *Pointer;     char Type;     int X,Y,Width;     struct s *MasterDesc;      char *MasterName;P     int NumX,DX,NumY,DY;!     int MasterHeight,MasterWidth;{     struct p *Path;r     struct ka BB;a     struct t *TGen;*     char *TypeIn;*
     int Info;      char *Label;!     struct ka ElementBB,MasterBB;      register int Int1,Int2;d     int OldRedisplayControl;  ;     if(Parameters.kpRedisplayControl == COARSEVIEWPORTONLY)e 	return;  "     ++Parameters.kpHierarchyLevel;     /*      * Traverse calls first.<      * So, if instances aren't expanded, top level geometry @      * isn't obscured by the symbolic pictures of any instances.      */,N     if(Not CDInitGen(CellDesc,0,AOI.kaLeft,AOI.kaBottom,AOI.kaRight,AOI.kaTop, 	&GenDesc)) MallocFailed();N  
     loop { 	/* Test for user interrupt */ 	if(Parameters.kpSIGINTERRUPT){  	    return; 	    }   	/*rH 	 * If we aren't expanding instances, we want to show symbolic layers on 	 * second level only. 	 */" 	CDGen(CellDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;o  	CDInfo(CellDesc,Pointer,&Info); 	if(Info == 2 Or Info == 5)i 	    continue;1 	CDCall(Pointer,&MasterName,&NumX,&DX,&NumY,&DY);e
 	if(TFull()){o4 	    ShowPrompt("Cell hierarchy is too deep. MORE"); 	    FBKeyboard(&TypeIn);(< 	    ShowPrompt("Probably you have a recursive hierarchy.");
 	    TInit();h# 	    --Parameters.kpHierarchyLevel;r 	    return; 	    } 	else {%0 	    if(Not CDOpen(MasterName,&MasterDesc,'r')){8 		sprintf(TypeOut,"Can't display %s. MORE",MasterName);  		ShowPrompt(TypeOut); 		FBKeyboard(&TypeIn);. 		sprintf(TypeOut,"%s. MORE",CDStatusString);  		ShowPrompt(TypeOut); 		FBKeyboard(&TypeIn);  		--Parameters.kpHierarchyLevel;	 		return;	 		}f& 	    elif(CDStatusInt == CDNEWSYMBOL){5 		sprintf(TypeOut,"Can't find cell %s.",MasterName);   		ShowPrompt(TypeOut);  		--Parameters.kpHierarchyLevel;	 		return;A 		}E 	    }: 	if(Not CDBB(MasterDesc,(struct o *)NULL,&MasterBB.kaLeft,; 	    &MasterBB.kaBottom,&MasterBB.kaRight,&MasterBB.kaTop))  	    MallocFailed();# 	for(Int1 = NumY;Int1 >= 1;--Int1){P' 	    for(Int2 = 1;Int2 <= NumX;++Int2){n3 		MasterWidth = MasterBB.kaRight - MasterBB.kaLeft;t4 		MasterHeight = MasterBB.kaTop - MasterBB.kaBottom;
 		TPush(); 		TIdentity(); 		CDInitTGen(Pointer,&TGen); 		loop {  		    CDTGen(&TGen,&Type,&X,&Y); 		    if(TGen == NULL)	 			break;a 		    if(Type == CDROTATE){V 			TRotate(X,Y);
 			if(X == 0)e* 			    SwapInts(MasterWidth,MasterHeight); 			} 		    elif(Type == CDTRANSLATE)** 			TTranslate(X+(Int2-1)*(MasterWidth+DX),% 			    Y+(Int1-1)*(MasterHeight+DY));* 		    elif(Type == CDMIRRORX)a	 			TMX();n 		    elif(Type == CDMIRRORY)t	 			TMY();s 		    }{ 		TPremultiply();h 		/*. 		 * Box test instance array element with AOI. 		 */n% 		ElementBB.kaLeft = MasterBB.kaLeft; ) 		ElementBB.kaBottom = MasterBB.kaBottom;t' 		ElementBB.kaRight = MasterBB.kaRight;o# 		ElementBB.kaTop = MasterBB.kaTop;a0 		TPoint(&ElementBB.kaLeft,&ElementBB.kaBottom);. 		TPoint(&ElementBB.kaRight,&ElementBB.kaTop);* 		if(ElementBB.kaRight < ElementBB.kaLeft)3 		    SwapInts(ElementBB.kaLeft,ElementBB.kaRight);o* 		if(ElementBB.kaTop < ElementBB.kaBottom)3 		    SwapInts(ElementBB.kaBottom,ElementBB.kaTop);., 		if(Not (ElementBB.kaLeft > AOI.kaRight Or ' 		    ElementBB.kaRight < AOI.kaLeft Or ' 		    ElementBB.kaBottom > AOI.kaTop Ore' 		    ElementBB.kaTop < AOI.kaBottom)){ % 		    PeekLayer(MasterDesc,AOI,Layer,i 			BottomVisibleLayer);  		    }l	 		TPop();  		}o 	    } 	}H     if(Not CDInitGen(CellDesc,Layer,AOI.kaLeft,AOI.kaBottom,AOI.kaRight,% 	AOI.kaTop,&GenDesc)) MallocFailed();;8     OldRedisplayControl = Parameters.kpRedisplayControl;5     Parameters.kpRedisplayControl = FINEVIEWPORTONLY;o
     loop { 	/* Test for user interrupt */ 	if(Parameters.kpSIGINTERRUPT){I 	    return; 	    }  " 	CDGen(CellDesc,GenDesc,&Pointer); 	if(Pointer == NULL) 	    break;m  	CDInfo(CellDesc,Pointer,&Info); 	if(Info == 2 Or Info == 5)i 	    continue; 	++Parameters.kpNumGeometries; 	CDType(Pointer,&Type);l 	if(Type == CDWIRE){) 	    CDWire(Pointer,&Layer,&Width,&Path);&$ 	    ShowWire(Layer,Width,Path,AOI); 	    } 	elif(Type == CDPOLYGON){p% 	    CDPolygon(Pointer,&Layer,&Path);a! 	    ShowPolygon(Layer,Path,AOI);	 	    } 	elif(Type == CDLABEL){C* 	    CDLabel(Pointer,&Layer,&Label,&X,&Y);> 	    ShowLabel(Layer,Label,X,Y,Parameters.kpDisplayAllLabels); 	    } 	elif(Type == CDBOX){ A 	    CDStatusInt = CDBB(CellDesc,Pointer,&BB.kaLeft,&BB.kaBottom,L 		&BB.kaRight,&BB.kaTop);o 	    ShowBox(Layer,BB,AOI);. 	    } 	}"     --Parameters.kpHierarchyLevel;8     Parameters.kpRedisplayControl = OldRedisplayControl;     }	     RedisplayAfterInterrupt(){     TInit();+     /* small delay to let the line clear */m
     sleep(1);o     FBTransfer();.
     sleep(1);r:     ShowPrompt("Interrupted.  Type Ctrl A to abort KIC.");     InitSignals();     ShowCommandMenu();     ShowLayerTable();h     ShowParameters();	     }e