 /*  * select.c1  *=  * Copyright -C- 1981 Kenneth H. Keller, Giles C. BillingsleyE$  * sccsid "@(#)select.c	1.1  9/5/83"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programo;  * KIC is available free of charge to any interested party.sB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,n  * is forbidden.  */   c  p /*  * The KIC selection code.  * a  * eH  * The Selection code extensively uses the CD Info field.  The following  * convention is used:  *  '  *       Info = 0	Object is unselected.n7  *      *Info = 1	Object is selected and in SelectionQ.cD  *       Info = 2	Object is conditionally deleted and in SelectionQ.C  *       Info = 3	Object is conditionally copied and in SelectionQ.RE  *       Info = 4	Object is conditionally selected and in SelectionQ.h*  *       Info = 5	Object is being created.F  *	 Info = 10	Object is box that could not be stretched (see modify.c)C  *      *Info = 11-255	Object has conditionally new layer and is ini,  *      		SelectionQ.  OldLayer = Info - 10.  *>  *      * means that SelectQShow will highlight these objects.  *  * Giles Billingsley  */i   #include "kic.h" #include "select.h"f   /* Library routines */ char *strcpy();) #ifndef vmse char *sprintf(); #endif   char TypeOut[100];   Selections(LookedAhead)r     int *LookedAhead;      {c      int FirstTimeInvoked = True;     *LookedAhead = False;      ShowSelectionMenu();
     loop { 	InitSignals();s 	if(FirstTimeInvoked){ 	    FirstTimeInvoked = False; 	    Sel(LookedAhead); 	    } 	if(Not *LookedAhead)w
 	    Point();o 	else  	    *LookedAhead = False;1 	if(strcmp(Parameters.kpCommand,MenuBASIC) == 0){s 	    *LookedAhead = False; 	    return; 	    }2 	elif(strcmp(Parameters.kpCommand,MenuSAVE) == 0){ 	    Save();- 	    if(Not CDReflect(Parameters.kpCellDesc))" 		MallocFailed();k 	    }2 	elif(strcmp(Parameters.kpCommand,MenuWRITE) == 0) 	    WriteCell();s0 	elif(strcmp(Parameters.kpCommand,MenuPAN) == 0) 	    Pan(LookedAhead);1 	elif(strcmp(Parameters.kpCommand,MenuZOOM) == 0)) 	    Zoom(LookedAhead);e1 	elif(strcmp(Parameters.kpCommand,Menu45S) == 0){u 	    if(Parameters.kp45s){ 		MenuDeselect(Menu45S); 		Parameters.kp45s = False;r 		}, 	    else {n 		MenuSelect(Menu45S); 		Parameters.kp45s = True; 		}u 	    }2 	elif(strcmp(Parameters.kpCommand,MenuWINDO) == 0) 	    Windo(LookedAhead);1 	elif(strcmp(Parameters.kpCommand,MenuLAST) == 0)n 	    LastView();3 	elif(strcmp(Parameters.kpCommand,MenuRDRAW) == 0){i 	    MenuSelect(MenuRDRAW);k 	    FullRedisplay();  	    }2 	elif(strcmp(Parameters.kpCommand,MenuUNDO) == 0){ 	    MenuSelect(MenuUNDO);- 	    ShowPrompt("Sorry, but it's too late.");  	    MenuDeselect(MenuUNDO); 	    }2 	elif(strcmp(Parameters.kpCommand,MenuEXPND) == 0) 	    Expand();1 	elif(strcmp(Parameters.kpCommand,MenuPEEK) == 0)l 	    Peek();2 	elif(strcmp(Parameters.kpCommand,MenuBOXES) == 0) 	    Boxes(LookedAhead);2 	elif(strcmp(Parameters.kpCommand,MenuWIRES) == 0) 	    Wires(LookedAhead);2 	elif(strcmp(Parameters.kpCommand,MenuWIDTH) == 0) 	    Width(LookedAhead);2 	elif(strcmp(Parameters.kpCommand,MenuPOLYG) == 0) 	    Polygons(LookedAhead);R2 	elif(strcmp(Parameters.kpCommand,MenuLABEL) == 0) 	    Label(LookedAhead);1 	elif(strcmp(Parameters.kpCommand,MenuAREA) == 0)  	    Area(LookedAhead);,2 	elif(strcmp(Parameters.kpCommand,MenuSELEC) == 0) 	    Sel(LookedAhead); 	elif(Point_At_LAYER())  	    continue;2 	elif(strcmp(Parameters.kpCommand,MenuDESEL) == 0)
 	    Desel();T2 	elif(strcmp(Parameters.kpCommand,MenuDELET) == 0) 	    Del(LookedAhead);1 	elif(strcmp(Parameters.kpCommand,MenuMOVE) == 0)y 	    Move(LookedAhead);C1 	elif(strcmp(Parameters.kpCommand,MenuCOPY) == 0)c 	    Copy(LookedAhead);-2 	elif(strcmp(Parameters.kpCommand,MenuCHLYR) == 0) 	    ChangeLayer(LookedAhead);1 	elif(strcmp(Parameters.kpCommand,MenuPUSH) == 0)l 	    Push();2 	elif(strcmp(Parameters.kpCommand,MenuSTBOX) == 0) 	    StretchBox(LookedAhead);r2 	elif(strcmp(Parameters.kpCommand,MenuSTPTH) == 0) 	    StretchPath(LookedAhead);2 	elif(strcmp(Parameters.kpCommand,MenuLEFT) == 0){) 	    strcpy(SelectionMenu[30],MenuRIGHT);d 	    MenuSelect(MenuRIGHT);,% 	    Parameters.kpModifyLeft = False;h 	    }3 	elif(strcmp(Parameters.kpCommand,MenuRIGHT) == 0){p( 	    strcpy(SelectionMenu[30],MenuLEFT); 	    MenuSelect(MenuLEFT);$ 	    Parameters.kpModifyLeft = True; 	    }1 	elif(strcmp(Parameters.kpCommand,MenuTOP) == 0){ ) 	    strcpy(SelectionMenu[31],MenuBOTTM);. 	    MenuSelect(MenuBOTTM); $ 	    Parameters.kpModifyTop = False; 	    }3 	elif(strcmp(Parameters.kpCommand,MenuBOTTM) == 0){e' 	    strcpy(SelectionMenu[31],MenuTOP);= 	    MenuSelect(MenuTOP);k# 	    Parameters.kpModifyTop = True;a 	    }0 	elif(strcmp(Parameters.kpCommand,MenuPOP) == 0) 	    Pop();	0 	elif(strcmp(Parameters.kpCommand,MenuMX) == 0){ 	    if(Parameters.kpMX){u 		Parameters.kpMX = False; 		MenuDeselect(MenuMX);P 		}t 	    else {, 		Parameters.kpMX = True;V 		MenuSelect(MenuMX);r 		}r 	    }0 	elif(strcmp(Parameters.kpCommand,MenuMY) == 0){ 	    if(Parameters.kpMY){  		Parameters.kpMY = False; 		MenuDeselect(MenuMY);= 		}  	    else {c 		Parameters.kpMY = True;p 		MenuSelect(MenuMY);l 		}) 	    }/ 	elif(strcmp(Parameters.kpCommand,Menu0) == 0){r% 	    Parameters.kpRotationAngle = 90; & 	    strcpy(SelectionMenu[37],Menu90); 	    MenuSelect(Menu90); 	    }0 	elif(strcmp(Parameters.kpCommand,Menu90) == 0){& 	    Parameters.kpRotationAngle = 180;' 	    strcpy(SelectionMenu[37],Menu180);) 	    MenuSelect(Menu180);  	    }1 	elif(strcmp(Parameters.kpCommand,Menu180) == 0){d& 	    Parameters.kpRotationAngle = 270;' 	    strcpy(SelectionMenu[37],Menu270);n 	    MenuSelect(Menu270);c 	    }1 	elif(strcmp(Parameters.kpCommand,Menu270) == 0){A$ 	    Parameters.kpRotationAngle = 0;% 	    strcpy(SelectionMenu[37],Menu0);h 	    MenuSelect(Menu0);m 	    } 	}     }u     ShowSelectionMenu(){-     ShowMenu(SelectionMenu,NumSelectionMenu);i&     Parameters.kpMenu = SELECTIONMENU;     if(Parameters.kpModifyLeft)  	MenuSelect(MenuLEFT);     else 	MenuSelect(MenuRIGHT);l     if(Parameters.kpModifyTop) 	MenuSelect(MenuTOP);O     else 	MenuSelect(MenuBOTTM);C$     if(Parameters.kpExpandInstances) 	MenuSelect(MenuEXPND);(+     if(Parameters.kpExpandFineViewportOnly)m 	MenuSelect(MenuPEEK);+     if(Parameters.kpLayerSpecificSelection)r 	MenuSelect(MenuLAYER);H     if(Parameters.kp45s) 	MenuSelect(Menu45S);p     if(Parameters.kpMX)  	MenuSelect(MenuMX);     if(Parameters.kpMY)r 	MenuSelect(MenuMY);'     if(Parameters.kpRotationAngle == 0)d 	MenuSelect(Menu0);m*     elif(Parameters.kpRotationAngle == 90) 	MenuSelect(Menu90);+     elif(Parameters.kpRotationAngle == 180)  	MenuSelect(Menu180);r     else 	MenuSelect(Menu270);t     FBTransfer();e     }t     Selection(AOI)     struct ka AOI;     /*H      * If AOI is a point, then select on current layer if it is visible,.      * else area select on all visible layers.      */      {S     int Layer;     struct ka OldSelectQBB;e     /* fC      * SelectionLayer and SelectionInstances always redisplay for anB      * point select, but we must redisplay the selectQ here for an      * area select      */ "     if(AOI.kaLeft == AOI.kaRight){ 	/* - 	 * Select only one geometry or one instance.d 	 */ 	SelectQComputeBB();) 	if(Parameters.kpLayerSpecificSelection){d1 	    if(LayerTable[Parameters.kpLayer].klVisible)e, 		if(SelectionLayer(AOI,Parameters.kpLayer))
 		    return;t 	    } 	else{2 	    for(Layer = 1;Layer <= NumLayerTable;++Layer)! 		if(LayerTable[Layer].klVisible)	  		    SelectionLayer(AOI,Layer); 	    } 	SelectionInstances(AOI);h 	}
     else { 	/*s 	 * Area select. 	 */ 	SelectQComputeBB();( 	OldSelectQBB.kaLeft = SelectQBB.kaLeft;, 	OldSelectQBB.kaBottom = SelectQBB.kaBottom;* 	OldSelectQBB.kaRight = SelectQBB.kaRight;& 	OldSelectQBB.kaTop = SelectQBB.kaTop;) 	if(Parameters.kpLayerSpecificSelection){i2 	    if(LayerTable[Parameters.kpLayer].klVisible){1 		if(Not SelectionLayer(AOI,Parameters.kpLayer)){) 		    SelectionInstances(AOI); 		    }e 		}e 	    } 	else{3 	    for(Layer = 1;Layer <= NumLayerTable;++Layer){ " 		if(LayerTable[Layer].klVisible){  		    SelectionLayer(AOI,Layer); 		    }n 		}u 	    SelectionInstances(AOI);  	    } 	/*(8 	 * SelectQBB has been incrementally updated during area 	 * select search. 	 */> 	SelectQBB.kaLeft = min(SelectQBB.kaLeft,OldSelectQBB.kaLeft);D 	SelectQBB.kaBottom = min(SelectQBB.kaBottom,OldSelectQBB.kaBottom);A 	SelectQBB.kaRight = max(SelectQBB.kaRight,OldSelectQBB.kaRight);); 	SelectQBB.kaTop = max(SelectQBB.kaTop,OldSelectQBB.kaTop);p2 	if(SelectQBB.kaLeft == Parameters.kpMaxX) return; 	EraseBox(SelectQBB,SelectQBB); , 	Redisplay(Parameters.kpCellDesc,SelectQBB); 	}     }S     SelectionInstances(AOI)r     struct ka AOI;     {t     struct g *GenDesc;     struct o *Pointer;     struct ka BB;l     struct ka EdgeOfBB;u     struct o *SelectedInstance;)     struct ks *SelectQDesc;      char *SymbolName;M     char oldMenu;      int NumSelected;     int i, Info;     int NumX,DX,NumY,DY;       SelectedInstance = NULL;     NumSelected = 0;E     if(Not CDInitGen(Parameters.kpCellDesc,0,AOI.kaLeft,AOI.kaBottom,m1 	AOI.kaRight,AOI.kaTop,&GenDesc)) MallocFailed();)
     loop {/ 	CDGen(Parameters.kpCellDesc,GenDesc,&Pointer);  	if(Pointer == NULL) 	    break;k8 	/*Must have been pointed to if generator returned it.*/- 	CDInfo(Parameters.kpCellDesc,Pointer,&Info);a 	if(Info == 2)A 	    /*Don't display selected, conditionally deleted instances.*/S 	    continue;/ 	elif(Info == 1 And AOI.kaLeft != AOI.kaRight){s 	    /*Area deselect.*/ A 	    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft, & 		&BB.kaBottom,&BB.kaRight,&BB.kaTop); 	    /*Mark as unselected.*/0 	    CDSetInfo(Parameters.kpCellDesc,Pointer,0);F 	    ShowInstanceMarker(ERASE,Parameters.kpHighlightingPixel,Pointer);! 	    /*Take it out of select Q.*/e 	    SelectQDelete(Pointer); 	    /*Update SelectQBB.*/% 	    if(BB.kaLeft < SelectQBB.kaLeft)  		SelectQBB.kaLeft = BB.kaLeft;a) 	    if(BB.kaBottom < SelectQBB.kaBottom)b# 		SelectQBB.kaBottom = BB.kaBottom;;' 	    if(BB.kaRight > SelectQBB.kaRight) ! 		SelectQBB.kaRight = BB.kaRight; # 	    if(BB.kaTop > SelectQBB.kaTop)t 		SelectQBB.kaTop = BB.kaTop;  	    }/ 	elif(Info == 0 And AOI.kaLeft != AOI.kaRight){B 	    /*  	     * Area select. 	     */ 	    /*Toss into select Q.*/ 	    SelectQInsert(Pointer); 	    /*Mark as selected.*/0 	    CDSetInfo(Parameters.kpCellDesc,Pointer,1);A 	    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft,I& 		&BB.kaBottom,&BB.kaRight,&BB.kaTop); 	    /*Update SelectQBB.*/% 	    if(BB.kaLeft < SelectQBB.kaLeft)a 		SelectQBB.kaLeft = BB.kaLeft;L) 	    if(BB.kaBottom < SelectQBB.kaBottom)c# 		SelectQBB.kaBottom = BB.kaBottom; ' 	    if(BB.kaRight > SelectQBB.kaRight)d! 		SelectQBB.kaRight = BB.kaRight; # 	    if(BB.kaTop > SelectQBB.kaTop). 		SelectQBB.kaTop = BB.kaTop;S 	    }/ 	elif(Info == 0 And AOI.kaLeft == AOI.kaRight){a 	    /*  	     * Point Select.x 	     *// 	    /*Toss into select Q for the time being.*/p 	    SelectQInsert(Pointer);( 	    /*Mark as conditionally selected.*/0 	    CDSetInfo(Parameters.kpCellDesc,Pointer,4); 	    ++NumSelected;P  	    SelectedInstance = Pointer; 	    }/ 	elif(Info == 1 And AOI.kaLeft == AOI.kaRight){, 	    /* Deselect */PA 	    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft,a& 		&BB.kaBottom,&BB.kaRight,&BB.kaTop);) 	    /* Deselect ALL selected instances. e. 	     * Don't bother with conflict resolution. 	     * Mark as unselected.i 	     */0 	    CDSetInfo(Parameters.kpCellDesc,Pointer,0);  	    /* erase instance marker */F 	    ShowInstanceMarker(ERASE,Parameters.kpHighlightingPixel,Pointer);! 	    /*Take it out of select Q.*/	 	    SelectQDelete(Pointer); 	    /*Left edge.*/)% 	    EdgeOfBB.kaLeft = BB.kaLeft-300;l' 	    EdgeOfBB.kaRight = BB.kaRight+300;e# 	    EdgeOfBB.kaTop = BB.kaTop+300; ) 	    EdgeOfBB.kaBottom = BB.kaBottom-300;0! 	    EraseBox(EdgeOfBB,EdgeOfBB);n/ 	    Redisplay(Parameters.kpCellDesc,EdgeOfBB);8 	    /*Right edge.*/' 	    EdgeOfBB.kaRight = BB.kaRight+300;r& 	    EdgeOfBB.kaLeft = BB.kaRight-300;# 	    EdgeOfBB.kaTop = BB.kaTop+300;r) 	    EdgeOfBB.kaBottom = BB.kaBottom-300;S! 	    EraseBox(EdgeOfBB,EdgeOfBB);c/ 	    Redisplay(Parameters.kpCellDesc,EdgeOfBB);r 	    /*Bottom edge.*/ * 	    EdgeOfBB.kaBottom = BB.kaBottom-300; & 	    EdgeOfBB.kaTop = BB.kaBottom+300;# 	    EdgeOfBB.kaRight = BB.kaRight; ! 	    EdgeOfBB.kaLeft = BB.kaLeft;M! 	    EraseBox(EdgeOfBB,EdgeOfBB);E/ 	    Redisplay(Parameters.kpCellDesc,EdgeOfBB);n 	    /*Top edge.*/' 	    EdgeOfBB.kaBottom = BB.kaTop-300; f# 	    EdgeOfBB.kaTop = BB.kaTop+300;(# 	    EdgeOfBB.kaRight = BB.kaRight;u! 	    EdgeOfBB.kaLeft = BB.kaLeft;d! 	    EraseBox(EdgeOfBB,EdgeOfBB);s/ 	    Redisplay(Parameters.kpCellDesc,EdgeOfBB);u 	    } 	}     /*,      * return immediately for an area select      */d5     if(AOI.kaLeft != AOI.kaRight Or NumSelected == 0)k 	return;       /*K      * If point select, resolve any ambiguity (multiple instances selected)f      */n     elif(NumSelected == 1){e 	/*Mark as really selected.*/l5 	CDSetInfo(Parameters.kpCellDesc,SelectedInstance,1);0F 	CDStatusInt = CDBB(Parameters.kpCellDesc,SelectedInstance,&BB.kaLeft,) 	    &BB.kaBottom,&BB.kaRight,&BB.kaTop);  	SelectQShow(BB);l: 	CDCall(SelectedInstance,&SymbolName,&NumX,&DX,&NumY,&DY);? 	sprintf(TypeOut,"You selected an instance of %s.",SymbolName);  	ShowPrompt(TypeOut);n 	}     elif(NumSelected > 1){  	/*Let user resolve ambiguity.*/ 	i = 0;  	SelectQDesc = SelectQHead;  	while(SelectQDesc != NULL){@ 	    CDInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,&Info);E 	    if(i < MenuViewport.kaBottom-MenuViewport.kaTop+1 && Info == 4){ A 		CDCall(SelectQDesc->ksPointer,&SymbolName,&NumX,&DX,&NumY,&DY);t  		AmbiguityMenu[i] = SymbolName; 		++i; 		}C' 	    SelectQDesc = SelectQDesc->ksSucc;o 	    }   	/*Show ambiguity menu.*/B 	NumAmbiguityMenu = i; 	oldMenu = Parameters.kpMenu;t# 	Parameters.kpMenu = AMBIGUITYMENU;o* 	ShowMenu(AmbiguityMenu,NumAmbiguityMenu);  * 	/*Which instance is user interested in?*/D 	ShowPrompt("Point to the name of the instance you want selected."); 	loop {R
 	    Point();k' 	    if(Parameters.kpCommand[0] != EOS)  		break;4 	    ShowPrompt("You aren't pointing at the menu."); 	    } 	Parameters.kpMenu = oldMenu;a 	ShowCommandMenu();O   	/*i= 	 * Remove from select Q instances he isn't interested in and ? 	 * leave the one he is interested in.  We assume that only oneEC 	 * is to be selected; 'i' is used as a flag to indicate selection.R 	 */ 	i = 0;  	SelectQDesc = SelectQHead;g 	while(SelectQDesc != NULL){@ 	    CDInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,&Info); 	    if(Info == 4){aA 		CDCall(SelectQDesc->ksPointer,&SymbolName,&NumX,&DX,&NumY,&DY);r3 		if(i Or (strncmp(SymbolName,Parameters.kpCommand, 9 		    MenuViewport.kaRight-MenuViewport.kaLeft+1) != 0)){. 		    /*Uninteresting.*/' 		    Pointer = SelectQDesc->ksPointer; 1 		    CDSetInfo(Parameters.kpCellDesc,Pointer,0);f 		    SelectQDelete(Pointer);P* 		    /* deletion has messed-up pointer */  		    SelectQDesc = SelectQHead; 		    }- 		else { 		    /*Interesting.*/ 		    i = 1;@ 		    CDSetInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,1);/ 		    CDStatusInt = CDBB(Parameters.kpCellDesc,d 			SelectQDesc->ksPointer, 			&BB.kaLeft,&BB.kaBottom,  			&BB.kaRight,&BB.kaTop); 		    SelectQShow(BB);( 		    SelectQDesc = SelectQDesc->ksSucc; 		    }c 		}=	 	    elser$ 		SelectQDesc = SelectQDesc->ksSucc; 	    } 	}     u     }l     SelectionLayer(AOI,Layer)      struct ka AOI;     int Layer;     {      struct g *GenDesc;     struct o *Pointer;     struct ka BB;s     struct ka BBFine;t     char Type;
     int Info;e     int ItemSelected = False;      int X,Y;     int Length,Width;l     char *Label;     struct p *Path;=  I     if(Not CDInitGen(Parameters.kpCellDesc,Layer,AOI.kaLeft,AOI.kaBottom,/1 	AOI.kaRight,AOI.kaTop,&GenDesc)) MallocFailed();i
     loop {/ 	CDGen(Parameters.kpCellDesc,GenDesc,&Pointer);l 	if(Pointer == NULL) 	    return(ItemSelected); 	CDType(Pointer,&Type);a 	if(Type == CDWIRE){) 	    CDWire(Pointer,&Layer,&Width,&Path);e# 	    if(AOI.kaLeft == AOI.kaRight){ ; 		if(Not InPath((Width >> 1),Path,AOI.kaLeft,AOI.kaBottom))c 		    continue;t 		}PA 	    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft,a& 		&BB.kaBottom,&BB.kaRight,&BB.kaTop); 	    ItemSelected = True;Q 	    } 	elif(Type == CDPOLYGON){ % 	    CDPolygon(Pointer,&Layer,&Path);k# 	    if(AOI.kaLeft == AOI.kaRight){B0 		if(Not InPath(1,Path,AOI.kaLeft,AOI.kaBottom)) 		    continue;  		}eA 	    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft,g& 		&BB.kaBottom,&BB.kaRight,&BB.kaTop); 	    ItemSelected = True;Q 	    } 	elif(Type == CDLABEL){B* 	    CDLabel(Pointer,&Layer,&Label,&X,&Y);? 	    /* BB of labels must be special-cased.  Can't use CDBB. */ $ 	    BBLabel(Label,X,Y,&BB,&BBFine);# 	    if(AOI.kaLeft == AOI.kaRight){s+ 		if(Not InBox(AOI.kaLeft,AOI.kaBottom,BB))e 		    continue;  		}S 	    ItemSelected = True;k 	    } 	elif(Type == CDBOX){ A 	    /* Must have been pointed to it if generator returned it. */ 0 	    CDBox(Pointer,&Layer,&Length,&Width,&X,&Y);A 	    CDStatusInt = CDBB(Parameters.kpCellDesc,Pointer,&BB.kaLeft, & 		&BB.kaBottom,&BB.kaRight,&BB.kaTop); 	    ItemSelected = True;C 	    }- 	CDInfo(Parameters.kpCellDesc,Pointer,&Info);  	if(Info == 2)A 	    /* Don't display selected, conditionally deleted objects. */u 	    continue; 	elif(Info == 1){{ 	    /*Mark as unselected.*/0 	    CDSetInfo(Parameters.kpCellDesc,Pointer,0);! 	    /*Take it out of select Q.*/f 	    SelectQDelete(Pointer);# 	    if(AOI.kaLeft == AOI.kaRight){  		EraseBox(BB,BB);& 		Redisplay(Parameters.kpCellDesc,BB); 		return(ItemSelected);o 		}n 	    } 	else {r 	    /*Mark as selected.*/0 	    CDSetInfo(Parameters.kpCellDesc,Pointer,1); 	    /*Toss into select Q.*/ 	    SelectQInsert(Pointer);# 	    if(AOI.kaLeft == AOI.kaRight){c 		SelectQShow(BB); 		}e 	    } 	/*Update SelectQBB.*/! 	if(BB.kaLeft < SelectQBB.kaLeft)t" 	    SelectQBB.kaLeft = BB.kaLeft;% 	if(BB.kaBottom < SelectQBB.kaBottom)t& 	    SelectQBB.kaBottom = BB.kaBottom;# 	if(BB.kaRight > SelectQBB.kaRight)e$ 	    SelectQBB.kaRight = BB.kaRight; 	if(BB.kaTop > SelectQBB.kaTop)   	    SelectQBB.kaTop = BB.kaTop; 	}     }a     SelectQInit(){     SelectQHead = NULL;i     }r     SelectQClear(){y     struct ks *SelectQDesc;      struct o *Pointer;     SelectQDesc = SelectQHead;     while(SelectQDesc != NULL){e" 	Pointer = SelectQDesc->ksPointer;, 	CDSetInfo(Parameters.kpCellDesc,Pointer,0);# 	SelectQDesc = SelectQDesc->ksSucc;{ 	SelectQDelete(Pointer); 	}     SelectQHead = NULL;O     }t     SelectQInsert(Pointer)     struct o *Pointer;     {a     struct ks *SelectQDesc;o  G     if((SelectQDesc = (struct ks *)malloc(sizeof(struct ks))) != NULL){a# 	SelectQDesc->ksPointer = Pointer; B 	if(SelectQHead == NULL){   	    SelectQHead = SelectQDesc;   	    SelectQDesc->ksSucc = NULL; 	    } 	else { ' 	    SelectQDesc->ksSucc = SelectQHead;f 	    SelectQHead = SelectQDesc;. 	    } 	}     else 	MallocFailed();     }u     SelectQDelete(Pointer)     struct o *Pointer;     {B,     struct ks *SelectQDesc,*PredSelectQDesc;       PredSelectQDesc = NULL;(     SelectQDesc = SelectQHead;     while(SelectQDesc != NULL){ ' 	if(SelectQDesc->ksPointer == Pointer){ $ 	    if(SelectQHead == SelectQDesc){ 		/* First desc in Q. */! 		if(SelectQDesc->ksSucc == NULL)	 		    /* Only desc in Q. */a 		    SelectQHead = NULL;e 		else( 		    SelectQHead = SelectQDesc->ksSucc; 		}e' 	    elif(SelectQDesc->ksSucc == NULL){t 		/* Last desc in Q. */u! 		PredSelectQDesc->ksSucc = NULL;a 		}L 	    else {&" 		/* There's a pred and a succ. */0 		PredSelectQDesc->ksSucc = SelectQDesc->ksSucc; 		}& 	    free(SelectQDesc);  	    return; 	    } 	PredSelectQDesc = SelectQDesc;C# 	SelectQDesc = SelectQDesc->ksSucc;  	}     }      SelectQComputeBB(){o     struct ks *SelectQDesc;*     struct ka BB;      struct ka BBFine;      struct p *Path;.     char *Label,Type;m     int X,Y,Layer,Length,Width;        SelectQDesc = SelectQHead;)     SelectQBB.kaLeft = Parameters.kpMaxX;e+     SelectQBB.kaBottom = Parameters.kpMaxY;e*     SelectQBB.kaRight = Parameters.kpMinX;(     SelectQBB.kaTop = Parameters.kpMinY;     while(SelectQDesc != NULL){]& 	CDType(SelectQDesc->ksPointer,&Type); 	if(Type == CDWIRE)>8 	    CDWire(SelectQDesc->ksPointer,&Layer,&Width,&Path); 	elif(Type == CDPOLYGON)4 	    CDPolygon(SelectQDesc->ksPointer,&Layer,&Path); 	elif(Type == CDBOX)? 	    CDBox(SelectQDesc->ksPointer,&Layer,&Length,&Width,&X,&Y);i 	if(Type == CDLABEL){t9 	    CDLabel(SelectQDesc->ksPointer,&Layer,&Label,&X,&Y);R 	    /*i< 	     * BB of labels must be special-cased.  Can't use CDBB.% 	     * The labels BB must be erased.h 	     */$ 	    BBLabel(Label,X,Y,&BB,&BBFine); 	    } 	elsedE 	    CDStatusInt = CDBB(Parameters.kpCellDesc,SelectQDesc->ksPointer,d1 		&BB.kaLeft,&BB.kaBottom,&BB.kaRight,&BB.kaTop);e! 	if(BB.kaLeft < SelectQBB.kaLeft)e" 	    SelectQBB.kaLeft = BB.kaLeft;% 	if(BB.kaBottom < SelectQBB.kaBottom)S& 	    SelectQBB.kaBottom = BB.kaBottom;# 	if(BB.kaRight > SelectQBB.kaRight)e$ 	    SelectQBB.kaRight = BB.kaRight; 	if(BB.kaTop > SelectQBB.kaTop)D  	    SelectQBB.kaTop = BB.kaTop;# 	SelectQDesc = SelectQDesc->ksSucc;O 	}     }S     Area(LookedAhead)C     int *LookedAhead;w     {R     struct ka AOI;       MenuSelect(MenuAREA);n	     loop{// 	ShowPrompt("Point to endpoints of diagonal.");  	loop{
 	    Point();C0 	    if(Not Parameters.kpPointLayerTable) break; 	    }$ 	if(Parameters.kpCommand[0] != EOS){ 	    if(Not Point_At_LAYER()){ 		 *LookedAhead = True;	 		MenuDeselect(MenuAREA); 	 		return;  		}e 	    }& 	elif(Parameters.kpPointCoarseWindow){
 	    loop{
 		Point();- 		if(Not Parameters.kpPointLayerTable) break;  		}C( 	    if(Parameters.kpCommand[0] != EOS){ 		if(Not Point_At_LAYER()){/ 		    *LookedAhead = True; 		    MenuDeselect(MenuAREA);a
 		    return;e 		    }B 		}	* 	    elif(Parameters.kpPointCoarseWindow){. 		AOI.kaLeft = min(Cursor.kcPredX,Cursor.kcX);0 		AOI.kaBottom = min(Cursor.kcPredY,Cursor.kcY);/ 		AOI.kaRight = max(Cursor.kcPredX,Cursor.kcX);(- 		AOI.kaTop = max(Cursor.kcPredY,Cursor.kcY);B 		Selection(AOI);h 		FBTransfer();> 		}c 	    } 	}     }&     Desel(){     MenuSelect(MenuDESEL);     SelectQComputeBB();=     if(SelectQHead != NULL){ 	SelectQClear();$ 	/* Take care of Instance markers */ 	OversizeBox(&SelectQBB,600);c 	EraseBox(SelectQBB,SelectQBB);t, 	Redisplay(Parameters.kpCellDesc,SelectQBB); 	FBTransfer(); 	}     MenuDeselect(MenuDESEL);     }e     Sel(LookedAhead)     int *LookedAhead;=     {t     struct ka AOI;       MenuSelect(MenuSELEC);#     ShowPrompt("Point to select.");a
     loop {	 	Point();e$ 	if(Parameters.kpCommand[0] != EOS){ 	    if(Not Point_At_LAYER()){ 		*LookedAhead = True; 		MenuDeselect(MenuSELEC);	 		return;  		}r 	    }# 	elif(Parameters.kpPointLayerTable); 	    continue;& 	elif(Parameters.kpPointCoarseWindow){+ 	    AOI.kaLeft = AOI.kaRight = Cursor.kcX;)+ 	    AOI.kaBottom = AOI.kaTop = Cursor.kcY;e 	    Selection(AOI); 	    FBTransfer(); 	    } 	}     }l     Point_At_LAYER(){y4     if(strcmp(Parameters.kpCommand,MenuLAYER) == 0){) 	if(Parameters.kpLayerSpecificSelection){  	    MenuDeselect(MenuLAYER);h1 	    Parameters.kpLayerSpecificSelection = False;  	    } 	else{ 	    MenuSelect(MenuLAYER);e0 	    Parameters.kpLayerSpecificSelection = True; 	    } 	return(True); 	}     return(False);     }      SelectQFirst(Pointer)S     struct o **Pointer;f     {(     if(SelectQHead == NULL)t 	*Pointer = NULL;B	     else  # 	*Pointer = SelectQHead->ksPointer;Q     }g     SelectQShow(AOI)     struct ka AOI;     /*7      * Show selected objects by highlighting their BBs.o      */c     {=     struct ks *SelectQDesc;      struct p *Path;A     char *Label;     char *SymbolName;      struct ka BBFine;      struct ka BB;)     int X,Y;     int NumX,NumY,DX,DY;     int oldRedisplayControl;
     int Info;)     int Layer;     int Length,Width;T     char Type;  /     if(Not Parameters.kpEnableSelectQRedisplay)( 	return;     SelectQDesc = SelectQHead;     while(SelectQDesc != NULL){ < 	CDInfo(Parameters.kpCellDesc,SelectQDesc->ksPointer,&Info); 	/* Test for user interrupt */ 	if(Parameters.kpSIGINTERRUPT){l 	    RedisplayAfterInterrupt();e 	    return; 	    }. 	elif(Info == 1 Or (Info > 9 And Info < 266)){  	    /* Show Selected Objects */* 	    CDType(SelectQDesc->ksPointer,&Type); 	    if(Type == CDLABEL){t= 	        CDLabel(SelectQDesc->ksPointer,&Layer,&Label,&X,&Y); < 		/* BB of labels must be special-cased.  Can't use CDBB. */! 		BBLabel(Label,X,Y,&BB,&BBFine);(6 		oldRedisplayControl = Parameters.kpRedisplayControl;5 		Parameters.kpRedisplayControl = COARSEVIEWPORTONLY;S1 		ShowBox(Parameters.kpHighlightingPixel,BB,AOI);I& 		if(BBFine.kaLeft != BBFine.kaRight){7 		    Parameters.kpRedisplayControl = FINEVIEWPORTONLY; < 		    ShowBox(Parameters.kpHighlightingPixel,BBFine,BBFine); 		    }s6 		Parameters.kpRedisplayControl = oldRedisplayControl; 		}P 	    elif(Type == CDWIRE){5 		CDWire(SelectQDesc->ksPointer,&Layer,&Width,&Path);e: 		ShowWire(Parameters.kpHighlightingPixel,Width,Path,AOI); 		}s 	    elif(Type == CDPOLYGON){n1 		CDPolygon(SelectQDesc->ksPointer,&Layer,&Path);f9 		ShowPath(Parameters.kpHighlightingPixel,Path,AOI,True);N 		}a 	    elif(Type == CDBOX){ < 		CDBox(SelectQDesc->ksPointer,&Layer,&Length,&Width,&X,&Y);B 		CDStatusInt = CDBB(Parameters.kpCellDesc,SelectQDesc->ksPointer,5 		    &BB.kaLeft,&BB.kaBottom,&BB.kaRight,&BB.kaTop);=1 		ShowBox(Parameters.kpHighlightingPixel,BB,AOI);( 		}   	    elif(Type == CDSYMBOLCALL){A 		CDCall(SelectQDesc->ksPointer,&SymbolName,&NumX,&DX,&NumY,&DY);eB 		CDStatusInt = CDBB(Parameters.kpCellDesc,SelectQDesc->ksPointer,5 		    &BB.kaLeft,&BB.kaBottom,&BB.kaRight,&BB.kaTop);-1 		ShowBox(Parameters.kpHighlightingPixel,BB,AOI);l< 		ShowInstanceMarker(DISPLAY,Parameters.kpHighlightingPixel, 		    SelectQDesc->ksPointer); 		}* 	    }# 	SelectQDesc = SelectQDesc->ksSucc;  	}     } 