 /*  * stream.ca  **  * Copyright -C- 1981 Giles C. Billingsley$  * sccsid "@(#)stream.c	1.1  9/5/83"  */.   #include <time.h>* #include "stream.h"s   struct STREAM_info streaminfo;   union { =     short w[4];		/* double precision number as four shorts */e7     double dval;	/* value of double precision number */i     } Strm_DblAndShrt;    I /***********************************************************************/eI /* ******************************************************************* */rI /* *                                                                 * */oI /* *     The following functions will write a symbolic layout        * */aI /* *     onto a disk file in STREAM format.  The information may     * */ I /* *     then be transfered to a magnetic tape by using the 'dd'     * */tI /* *     system command.                                             * */ I /* *                                                                 * */ I /* *     The order of the function calls is *not* arbitrary.         * */nI /* *     The correct calling sequence is described below:            * */oI /* *                                                                 * */ I /* *      1) 'bgnlib' to begin library                               * */uI /* *                                                                 * */aI /* *      2) 'bgnstr' to begin structure definition                  * */LI /* *                                                                 * */DI /* *      3) 'bndry' or 'path' or 'sref' or 'aref' or 'text'         * */aI /* *         or any combination thereof.                             * */tI /* *                                                                 * */iI /* *      4) 'endstr' to end structure definition                    * */eI /* *                                                                 * */-I /* *      5) 'endlib' to end library or 'bgnstr' to begin            * */UI /* *         another structure definition                            * */DI /* *                                                                 * */DI /* ******************************************************************* */aI /***********************************************************************/     I /***********************************************************************/ I /* function STRM_PUTNCHARS                                             */aI /*      Function to enter n characters into the STREAMFILE in          */nI /*      reversed order.                                                */(I /***********************************************************************/A strm_putnchars(cp, n)e
     char *cp;;
     int n;     {      /*'      * cp = pointer to character buffer       * n = number of charactersi      */i
     int i;1     /* The order of the bytes must be reversed */k      for(i = n - 1; i >= 0; --i){#         putc( *(cp+i), STREAMFILE);e	         }}     }     I /***********************************************************************/0I /* function STRM_BEGINRECORD                                           */)I /*      Function to begin record on STREAMFILE.                        */ I /*      count     = the number of bytes that will be contained within  */ I /*                  the record.                                        */iI /*      type      = the STREAM record type.                            */oI /*      datatype  = the type of data contained in the STREAM record.   */ I /***********************************************************************/s' strm_beginrecord(count, type, datatype)      int count;
     int type;c     int datatype;a     {      /*+      * count    = number of bytes in record        * type     = type of record,      * datatype = type of data in data field      */y     char buf[8];     strm_intcopy(&count, buf);     strm_putnchars(buf, 2);;     putc(type, STREAMFILE);n     putc(datatype, STREAMFILE);      ++streaminfo.rec_count;;#     streaminfo.byte_count += count;C     }a    I /***********************************************************************/ I /* function STRM_ADDATE                                                */#I /*      Function to add date reference to the STREAMFILE.  The date    */ I /*      is stored in a 'tm' structure that is used by CTIME(3).        */iI /***********************************************************************/o strm_addate(datep)     struct tm *datep;*     {*     /*B      * datep = pointer to the year spec. of the tm date structure.      */*     char buf[8];)     strm_intcopy(&(datep->tm_year), buf);      strm_putnchars(buf, 2); (     strm_intcopy(&(datep->tm_mon), buf);     strm_putnchars(buf, 2);*)     strm_intcopy(&(datep->tm_mday), buf);*     strm_putnchars(buf, 2);*)     strm_intcopy(&(datep->tm_hour), buf);*     strm_putnchars(buf, 2);*(     strm_intcopy(&(datep->tm_min), buf);     strm_putnchars(buf, 2); (     strm_intcopy(&(datep->tm_sec), buf);     strm_putnchars(buf, 2);r     }i    I /***********************************************************************/ I /* function STRM_ENTERASC_REC                                          */*I /*      Function to enter a single ASCII record into STREAMFILE        */ I /*      If 'conv' is set, conversion to upper case is performed.       */=I /***********************************************************************/   strm_entrasc_rec(cp, type, conv)
     char *cp;-
     int type;u
     int conv;R     {)     int i = 0, j;      char c;*       i = strlen(cp);*     if(i & 1) ++i;#     strm_beginrecord(i+4, type, 6);      for(j=0; j<i; ++j){  	c = cp[j]; 
 	if(conv){ 	    if(c >= 'a' && c <= 'z') 
 		c -= 32; 	    } 	putc(c, STREAMFILE);  	}     }     I /***********************************************************************/ I /* function STRM_ENTRASC                                               */ I /*      Function to enter ascii string of 44 characters into the       */ I /*      STREAMFILE.  If 'conv' is set, conversion to upper case is     */*I /*      performed.                                                     */mI /***********************************************************************/n strm_entrasc(cp, conv)
     char *cp;u
     int conv;o     {      /*  (      * cp = pointer to character buffer.      */ 
     int i;
     int n;     char c;y     n = strlen(cp);      for(i = 0; i < n; ++i){  	c = *cp++;c
 	if(conv){ 	    if(c >= 'a' && c <= 'z')n
 		c -= 32; 	    } 	putc(c, STREAMFILE);t 	}     for(i=n; i<44; ++i)e 	putc('\0', STREAMFILE);     }     I /***********************************************************************/*I /* function BGNLIB                                                     */*I /*      Function to begin new library on the STREAMFILE.               */*I /***********************************************************************/* bgnlib(lib)*     STRM_LIBRARY *lib;     {*     char buffer[45];     int version = 3;  N     streaminfo.rec_count=0;                   /* initialize for new library */     streaminfo.struct_count=0;     streaminfo.byte_count=0;     streaminfo.level = 0;>#     strm_beginrecord(6, HEADER, 2); #     strm_intcopy(&version, buffer);      strm_putnchars(buffer, 2);$     strm_beginrecord(28, BGNLIB, 2);%     strm_addate(&(lib->lib_moddate));l(     strm_addate(&(lib->lib_accessdate));0     strm_entrasc_rec(lib->lib_name, LIBNAME, 1);=     if(lib->lib_lib1[0] != '\0' || lib->lib_lib2[0] != '\0'){ )         strm_beginrecord(92, REFLIBS, 6);*'         strm_entrasc(lib->lib_lib1, 1); '         strm_entrasc(lib->lib_lib2, 1);*	         }d=     if(lib->lib_font0[0] != '\0' || lib->lib_font1[0] != '\0'*< 	|| lib->lib_font2[0] != '\0' || lib->lib_font3[0] != '\0'){(         strm_beginrecord(180, FONTS, 6);(         strm_entrasc(lib->lib_font0, 1);(         strm_entrasc(lib->lib_font1, 1);(         strm_entrasc(lib->lib_font2, 1);(         strm_entrasc(lib->lib_font3, 1);	         }       if(lib->lib_attr[0] != '\0')/ 	strm_entrasc_rec(lib->lib_attr, ATTRTABLE, 1); (     strm_beginrecord(6, GENERATIONS, 2);*     strm_intcopy(&(lib->lib_gen), buffer);     strm_putnchars(buffer, 2);#     strm_beginrecord(20, UNITS, 5);*)     strm_dblcopy(lib->lib_uunit, buffer);.     strm_putnchars(buffer, 8);)     strm_dblcopy(lib->lib_munit, buffer);      strm_putnchars(buffer, 8);     return(0);     }r    I /***********************************************************************/ I /* function ENDLIB                                                     */oI /*      Function to end library on the STREAMFILE.                     */rI /***********************************************************************/ 	 endlib(){t     long i, j;<     if(streaminfo.level != 0 && streaminfo.test) return(-1);#     strm_beginrecord(4, ENDLIB, 0);>     /* pad with nulls */'     i = (streaminfo.byte_count % 2048);d     for(j = 0; j < i; ++j) 	putc(0, STREAMFILE);*     return(0);     }t    I /***********************************************************************/sI /* function BGNSTR                                                     */*I /*      Function to structure definition in the STREAMFILE.            */RI /***********************************************************************/  bgnstr(strp)     STRM_STRCT *strp;i     {i<     if(streaminfo.level != 0 && streaminfo.test) return(-1);     streaminfo.level = 1;*$     strm_beginrecord(28, BGNSTR, 2);(     strm_addate(&(strp->str_creatdate));&     strm_addate(&(strp->str_moddate));1     strm_entrasc_rec(strp->str_name, STRNAME, 1);i     ++streaminfo.struct_count;     return(0);     }n    I /***********************************************************************/eI /* function ENDSTR                                                     */aK /*      Function to end structure on the STREAMFILE.                     */lI /***********************************************************************/r	 endstr(){_<     if(streaminfo.level != 1 && streaminfo.test) return(-1);     streaminfo.level = 0; #     strm_beginrecord(4, ENDSTR, 0);      return(0);     }b    I /***********************************************************************/lI /* function STRM_ENDLMNT                                               */0I /*      Function to end element stream on the STREAMFILE.              */TI /***********************************************************************/> strm_endlmnt(propp)      STRM_PROPERTY *propp;t     {      int i,k;     char buf[4];
     k = 0;<     if(streaminfo.level != 2 && streaminfo.test) return(-1);     streaminfo.level = 1;)     i = propp->prp_npropval;     while(i-- > 0){t)         strm_beginrecord(6, PROPATTR, 2);t3         strm_intcopy(&propp->prp_propattr[k], buf);I         strm_putnchars(buf, 2);i@         strm_entrasc_rec(propp->prp_propval[k++], PROPVALUE, 0);	         }_"     strm_beginrecord(4, ENDEL, 0);     return(0);     }n    I /***********************************************************************/*I /* function BNDRY                                                      */ I /*      Function to enter boundary element into the STREAMFILE.        */ I /***********************************************************************/*
 bndry(bndryp)n     STRM_BOUNDARY *bndryp;     {r
     int i;     char buf[4];<     if(streaminfo.level != 1 && streaminfo.test) return(-1);     streaminfo.level = 2; %     strm_beginrecord(4, BOUNDARY, 0); "     strm_beginrecord(6, LAYER, 2);,     strm_intcopy(&(bndryp->bnd_layer), buf);     strm_putnchars(buf, 2);*%     strm_beginrecord(6, DATATYPE, 2);s/     strm_intcopy(&(bndryp->bnd_datatype), buf);      strm_putnchars(buf, 2);*     if(bndryp->bnd_ncoord < 4){i@         fprintf(stderr,"less than four boundary coordinates\n");         exit(1);	         } 
     else {<         strm_beginrecord(8 * bndryp->bnd_ncoord + 4, XY, 3);E         for(i = 0; i < bndryp->bnd_ncoord + bndryp->bnd_ncoord; ++i){=4             strm_lngcopy(&(bndryp->bnd_xy[i]), buf);#             strm_putnchars(buf, 4);r
             }n	         }r*     i = strm_endlmnt(&(bndryp->bnd_prop));     return(i);     }     I /***********************************************************************/iI /* function STRM_STRNSFM                                               */(I /*      Function to enter structure transformation record              */ I /***********************************************************************/* strm_strnsfm(trp)      STRM_TRANSFORM *trp;     {      char buf[8];
     int i;
     i = 0;/     if(trp->trns_reflection == 1) i |= 0100000;t'     if(trp->trns_abs_mag == 1) i |= 04;n)     if(trp->trns_abs_angle == 1) i |= 02;*#     strm_beginrecord(6, STRANS, 1);      strm_intcopy(&i, buf);     strm_putnchars(buf, 2);*     if(trp->trns_mag != 1){*%         strm_beginrecord(12, MAG, 5);a)         strm_dblcopy(trp->trns_mag, buf);o         strm_putnchars(buf, 8);o	         }a     if(trp->trns_angle != 0){n'         strm_beginrecord(12, ANGLE, 5);t+         strm_dblcopy(trp->trns_angle, buf);=         strm_putnchars(buf, 8);=	         }=     }     I /***********************************************************************/(I /* function PATH                                                       */*I /*      Function to enter path element into the STREAMFILE.            */*I /***********************************************************************/r path(pathp)      STRM_PATH *pathp;)     {(
     int i;     char buf[4];<     if(streaminfo.level != 1 && streaminfo.test) return(-1);     streaminfo.level = 2;t!     strm_beginrecord(4, PATH, 0); "     strm_beginrecord(6, LAYER, 2);+     strm_intcopy(&(pathp->pth_layer), buf);      strm_putnchars(buf, 2);*%     strm_beginrecord(6, DATATYPE, 2);*.     strm_intcopy(&(pathp->pth_datatype), buf);     strm_putnchars(buf, 2); %     strm_beginrecord(6, PATHTYPE, 2);i.     strm_intcopy(&(pathp->pth_pathtype), buf);     strm_putnchars(buf, 2); "     strm_beginrecord(8, WIDTH, 3);+     strm_lngcopy(&(pathp->pth_width), buf);m     strm_putnchars(buf, 4);,     if(pathp->pth_ncoord < 2){6         fprintf(stderr,"less than two path points\n");         exit(1);	         })     else  { ;         strm_beginrecord(8 * pathp->pth_ncoord + 4, XY, 3); C         for(i = 0; i < pathp->pth_ncoord + pathp->pth_ncoord; ++i){ 1             strm_lngcopy(&pathp->pth_xy[i], buf);g#             strm_putnchars(buf, 4);X
             } 	         }i)     i = strm_endlmnt(&(pathp->pth_prop));      return(i);     }m    I /***********************************************************************/ I /* function SREF                                                       */uI /*      Function to enter structure reference to the STREAMFILE.       */*I /***********************************************************************/  sref(srefp)      STRM_SREF *srefp;t     {      char buf[4];
     int i;<     if(streaminfo.level != 1 && streaminfo.test) return(-1);     streaminfo.level = 2;*J     strm_beginrecord(4, SREF, 0);                  /* enter SREF record */K     strm_entrasc_rec(srefp->sr_name, SNAME, 1);    /* enter SNAME record */ L     strm_strnsfm(&(srefp->sr_transform));          /* enter STRANS record */H     strm_beginrecord(12, XY, 3);                   /* enter XY record */*     strm_lngcopy(&(srefp->sr_xy[0]), buf);     strm_putnchars(buf, 4);g*     strm_lngcopy(&(srefp->sr_xy[1]), buf);     strm_putnchars(buf, 4); (     i = strm_endlmnt(&(srefp->sr_prop));     return(i);     }     I /***********************************************************************/aI /* function AREF                                                       */*I /*      Function to enter array reference element in the STREAMFILE.   */fI /***********************************************************************/  aref(arefp)t     STRM_AREF *arefp;t     {T
     long *ip; 
     int i;     char buf[4];<     if(streaminfo.level != 1 && streaminfo.test) return(-1);     streaminfo.level = 2;pJ     strm_beginrecord(4, AREF, 0);                  /* enter AREF record */K     strm_entrasc_rec(arefp->ar_name, SNAME, 1);    /* enter SNAME record */4L     strm_strnsfm(&(arefp->ar_transform));          /* enter STRANS record */L     strm_beginrecord(8, COLROW, 2);                /* enter COLROW record */(     strm_intcopy(&(arefp->ar_col), buf);     strm_putnchars(buf, 2); (     strm_intcopy(&(arefp->ar_row), buf);     strm_putnchars(buf, 2);tH     strm_beginrecord(28, XY, 3);                   /* enter XY record */     ip = arefp->ar_xy;     for(i = 1; i <= 6; ++i){         strm_lngcopy(ip, buf);         strm_putnchars(buf, 4);r
         ++ip;e	         }l(     i = strm_endlmnt(&(arefp->ar_prop));     return(i);     }     I /***********************************************************************/*I /* function TEXT                                                       */*I /*      Function to enter text element into the STREAMFILE.            */*I /***********************************************************************/* text(textp)m     STRM_TEXT *textp;O     {p
     int i;     char buf[4];<     if(streaminfo.level != 1 && streaminfo.test) return(-1);     streaminfo.level = 2;;J     strm_beginrecord(4, TEXT, 0);                  /* enter TEXT record */K     strm_beginrecord(6, LAYER, 2);                 /* enter LAYER record */-+     strm_intcopy(&(textp->txt_layer), buf);a     strm_putnchars(buf, 2);tN     strm_beginrecord(6, TEXTTYPE, 2);              /* enter TEXTTYPE record */.     strm_intcopy(&(textp->txt_texttype), buf);     strm_putnchars(buf, 2);*@     if(textp->txt_horizontal >= 0 && textp->txt_horizontal < 3){@         if(textp->txt_vertical >= 0 && textp->txt_vertical < 3){=             if(textp->txt_font >= 0 && textp->txt_font <= 3){ F                 i = textp->txt_horizontal + (textp->txt_vertical << 2) 		    + (textp->txt_font << 4); 5                 strm_beginrecord(6, PRESENTATION, 1);H&                 strm_intcopy(&i, buf);'                 strm_putnchars(buf, 2);f                 }g
             }T	         } N     strm_beginrecord(6, PATHTYPE, 2);              /* enter PATHTYPE record */.     strm_intcopy(&(textp->txt_pathtype), buf);     strm_putnchars(buf, 2);;"     strm_beginrecord(8, WIDTH, 3);+     strm_lngcopy(&(textp->txt_width), buf);>     strm_putnchars(buf, 4); L     strm_strnsfm(&(textp->txt_transform));         /* enter STRANS record */H     strm_beginrecord(12, XY, 3);                   /* enter XY record */+     strm_lngcopy(&(textp->txt_xy[0]), buf);p     strm_putnchars(buf, 4);F+     strm_lngcopy(&(textp->txt_xy[1]), buf);/     strm_putnchars(buf, 4);>1     strm_entrasc_rec(textp->txt_text, STRING, 0); )     i = strm_endlmnt(&(textp->txt_prop));      return(i);     }c    I /***********************************************************************/rI /* function STRM_IVAL                                                  */ I /*      Function to evaluate STREAM short integer.                     */ I /***********************************************************************/  strm_ival(b)     int *b;(     {i!     return( (*b << 8) | *(b+1) );i     };    I /***********************************************************************/dI /* function STRM_LONGVAL                                               */*I /*      Function to evaluate STREAM long integer.                      */ I /***********************************************************************/n long strm_longval(b)     int *b;E     {      long int l;*O     l=(long)(*b << 24)|(long)(*(b+1) << 16)|(long)(*(b+2) << 8)|(long)(*(b+3));      return( l );     }      /*  * function STRM_DOUBLEVAL@  *      Function to convert from STREAM to VAX double precision.C  *      The argument is a integer buffer containing the eight bytes E  *      of the STREAM double precision field.  The first character in F  *      the buffer contains the exponent, the second contains the most.  *      significant byte of the mantissa, etc.  *  *#  *    VAX's double precision field:   *H  *    Mantissa is base 2 (1/2 <= mantissa < 1).  Exponent is excess-128.  *I  *              111111 1111222222222233 3333333344444444 4455555555556666oI  *    0123456789012345 6789012345678901 2345678901234567 8901234567890123{I  *    ---------------- ---------------- ---------------- ---------------- I  *    FFFFFFFEEEEEEEES FFFFFFFFFFFFFFFF FFFFFFFFFFFFFFFF FFFFFFFFFFFFFFFFpI  *    L     M          L              M L              M L              M   *  *  *%  *    CALMA's double precision field:   *I  *    Mantissa is base 16 (1/16 <= mantissa < 1).  Exponent is excess-64.   *I  *              111111 1111222222222233 3333333344444444 4455555555556666 I  *    0123456789012345 6789012345678901 2345678901234567 8901234567890123 I  *    ---------------- ---------------- ---------------- ----------------uI  *    FFFFFFFFEEEEEEES FFFFFFFFFFFFFFFF FFFFFFFFFFFFFFFF FFFFFFFFFFFFFFFFtI  *    L      M         L              M L              M L              M   *  *!  *    where  E  =  exponent field   *           S  =  sign bit !  *           F  =  fraction field 1  *           FL =  least sig. bit of word or byte*0  *           FM =  most sig. bit of word or byte  */f double strm_doubleval(ip) 	 	int *ip;  	{	 	int exp; 
 	int sign;	 	int i,j;   
 	sign = 0; 	i = j = 0; 
 	exp = ip[0];e 	/* test the sign bit */ 	if(exp & 0x80){ 	    sign = 1; 	    exp &= 0x7f;* 	    } 	/**? 	 * We will transfer the chars of the double precision field to4? 	 * simplify this routine.  i.e., it is easier to keep track ofr> 	 * all the bits when we shift 16 bit fields rather than 8 bit 	 * fields.  	 */ 	for(i=0; i<=3; ++i)G 	    Strm_DblAndShrt.w[i] = (((ip[i+i])&0xff)<<8) | ((ip[i+i+1])&0xff);M 	/* mask the exponent */ 	Strm_DblAndShrt.w[0] &= 0xff;C 	/* multiply by 2 until the most significant mantissa bit is set */ 3 	while(!(Strm_DblAndShrt.w[0] & 0x80) && (j < 64)){y	 	    ++j;r 	    for(i=0; i <= 2; ++i){c5 		Strm_DblAndShrt.w[i] = (Strm_DblAndShrt.w[i] << 1);f@ 		if(Strm_DblAndShrt.w[i+1] & 0x8000) Strm_DblAndShrt.w[i] |= 1; 		})A 	    Strm_DblAndShrt.w[3] = (Strm_DblAndShrt.w[3] << 1) & 0xffff;* 	    } 	if(j == 64) return(0.0);* 	/**9 	 * Add exponent to the first word in the working buffer. ? 	 * We must subtract j from the exponent which is the number ofn+ 	 * times the mantissa was multiplied by 2.* 	 **B 	 * There is another trick which is not so obvious.  We multipliedB 	 * by 2 until the most significant bit of the STREAM mantissa was< 	 * set.  By dropping that bit, we convert from excess-64 to 	 * excess-128.y 	 */ 	Strm_DblAndShrt.w[0] =sH 	    (Strm_DblAndShrt.w[0] & 0x7f | (((exp << 2)+128-j) << 7)) & 0x7fff; 	/* is it negative? */	 	if(sign)t$ 	    Strm_DblAndShrt.w[0] |= 0x8000; 	return(Strm_DblAndShrt.dval); 	}     /*  * function STRM_INTCOPYB  *      Function to transfer the two bytes of a short integer to aD  *      character buffer.  The least significant byte of the integerD  *      appears as the first character in the character buffer, etc.  *  *      CAUTION:A  *      Only the first (least significant) 8 bits of the returned A  *      characters are valid.  Because of the way that characters3D  *      may be packed, it is necessary to mask any higher order bitsF  *      when converting back to an integer.  (i.e., int = char & 0xFF)  */- strm_intcopy(i,j)-     int *i;-     char *j;     {F     j[0] = (char)(*i & 0xff);F$     j[1] = (char)((*i >> 8) & 0xff);     }        /*  * function STRM_LNGCOPYB  *      Function to transfer the four bytes of a long integer to aD  *      character buffer.  The least significant byte of the integerD  *      appears as the first character in the character buffer, etc.  *  *      CAUTION:A  *      Only the first (least significant) 8 bits of the returned A  *      characters are valid.  Because of the way that characters D  *      may be packed, it is necessary to mask any higher order bitsF  *      when converting back to an integer.  (i.e., int = char & 0xFF)  */n strm_lngcopy(i,j)p     long *i;     char *j;     {i     j[0] = (char)((*i) & 0xff); $     j[1] = (char)((*i >> 8) & 0xff);%     j[2] = (char)((*i >> 16) & 0xff);i%     j[3] = (char)((*i >> 24) & 0xff);i     }i     /*  * function STRM_DBLCOPYF  *	Function to transfer double precision number to a character buffer.J  *      The first character of the buffer will contain the exponent field,J  *      the second character will contain the most significant byte of the  *      mantissa field, etc.  *  *#  *    VAX's double precision field:b  *H  *    Mantissa is base 2 (1/2 <= mantissa < 1).  Exponent is excess-128.  *I  *              111111 1111222222222233 3333333344444444 4455555555556666.I  *    0123456789012345 6789012345678901 2345678901234567 8901234567890123 I  *    ---------------- ---------------- ---------------- ---------------- I  *    FFFFFFFEEEEEEEES FFFFFFFFFFFFFFFF FFFFFFFFFFFFFFFF FFFFFFFFFFFFFFFFoI  *    L     M          L              M L              M L              Me  *  *  *%  *    CALMA's double precision field:t  *I  *    Mantissa is base 16 (1/16 <= mantissa < 1).  Exponent is excess-64.s  *I  *              111111 1111222222222233 3333333344444444 4455555555556666 I  *    0123456789012345 6789012345678901 2345678901234567 8901234567890123rI  *    ---------------- ---------------- ---------------- ----------------cI  *    FFFFFFFFEEEEEEES FFFFFFFFFFFFFFFF FFFFFFFFFFFFFFFF FFFFFFFFFFFFFFFFuI  *    L      M         L              M L              M L              M   *  *!  *    where  E  =  exponent field   *           S  =  sign bit*!  *           F  =  fraction field*1  *           FL =  least sig. bit of word or byte 0  *           FM =  most sig. bit of word or byte  */* strm_dblcopy(r,ch)
     double r;*
     char *ch;*     {*     short i,j,k,l,n,exp,sign;L       /* test the sign */ 
     sign = 0;      if(r < 0){         r = -r;          sign = 1;g	         }        /*=      * Put the double precision field into four 16 bit words.*9      * NOTE: We assume here that a short is 16 bits long!E      */      Strm_DblAndShrt.dval = r;*  ;     /* grab the VAX's exponent (sign bit should be zero) */).     /* save VAX's exponent (as excess-zero) */,     exp = (Strm_DblAndShrt.w[0] >> 7) - 128;B     /* if exponent and sign bit is zero, then the value is zero */     if(exp == -128 && !sign){  	for(i=0; i<4; ++i)e 	    *ch++ = 0;e 	return; 	}3     /* remove VAX's exponent from working buffer */ >     Strm_DblAndShrt.w[0] = (Strm_DblAndShrt.w[0] & 127) + 128;     n = 4 - (exp & 3);     /*F      * If the VAX's exponent has an integer cube root, we dont need toH      * divide (shift) the mantissa.  Otherwise, we multiply the exponent'      * by 2 until it is a perfect cube.5      */o     if(n < 4){"         for(i = 1; i <= n; ++i)  {&             for(j = 3; j >= 0; --j)  {.                 l = Strm_DblAndShrt.w[j] >> 1;2                 Strm_DblAndShrt.w[j] = l & 0x7fff;                 k = j-1;                 if(k>=0)  {t2                     if((Strm_DblAndShrt.w[k] & 1))7                         Strm_DblAndShrt.w[j] |= 0x8000;y                     }f                 }e
             } 	         }e     else         n = 0;-     /* find the CALMA's excess-64 exponent */,     exp = ((exp + n)/4) + 64;g'     Strm_DblAndShrt.w[0] |= (exp << 8);a     if(sign)  	Strm_DblAndShrt.w[0] |= 0x8000;'     /* transfer bytes to char buffer */      for(i = 0; i <= 3; ++i){0         *ch++ = (Strm_DblAndShrt.w[3-i]) & 0xff;5         *ch++ = (Strm_DblAndShrt.w[3-i] >> 8) & 0xff;*	         }      }p