 /*  * strmtokic.c  **  * Copyright -C- 1983 Giles C. Billingsley  * sccsid "%W%  %G%"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programf;  * KIC is available free of charge to any interested party.2B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,n  * is forbidden.  */s   #include <math.h>  #include <time.h>I #include "stream.h"   ! #define TMPFILE		"/tmp/strXXXXXX"d   int     NumLayerTable; int     LayerNumbers[256]; int     CurrentLayer;  int	CurrentAttribute;/ int     DataTypeNumbers[256];  int     CurrentDataType; int     NumSymbols;e int     UseLayerTable; FILE	*stderror;r char    SymbolNames[2000][45]; char    LayerNames[256][45];   double  ScaleFactor;   typedef struct rct1{
     int left;*     int bottom;n     int right;     int top;     struct rct1 *r_next;     } 	     RECT;    typedef struct{      long pointx;     long pointy;     }n
     POINT;   struct pathlist{     POINT pathpoint;     struct pathlist *pathlink;     };  ! typedef struct pathlist PATHLIST;n   /*K  * We use the property list of KIC symbols to save the library information; F  * The value of the property is the numeric value of the STREAM recordJ  * type offset by 7000 (e.g. 7000 is the KIC property value describing theG  * STREAM version number, 7002 is the KIC property value describing theaK  * STREAM library name, etc.)  The offset of 7000 was arbitrarily selected,nG  * and care must be taken so that this value does not conflict with anytC  * other convention.  The PROPERTYOFFSET define is for convenience.t  *G  * The STREAM-specific property list is attributed to every KIC symbol,r2  * and 'kictostrm' will look for this information.  */n #define	PROPERTYOFFSET	7000N   struct headerlist{     int hd_RecordType;     char hd_Text[512];     struct headerlist *hd_Succ;	     };  # typedef struct headerlist HEADLIST;T   RECT *pgtorex(); char *malloc();n char *mktemp();f char *nextarg(); char **argv;
 int  argc;    F #define	LONGSCALE(n)	(long)(floor(ScaleFactor * ((double)(n)) + 0.5));A #define NEWPATH 	(PATHLIST *) malloc((unsigned) sizeof(PATHLIST))eA #define NEWHEAD 	(HEADLIST *) malloc((unsigned) sizeof(HEADLIST))( #define	RADTODEG 	57.29577951; #define	MAXRECSIZE	2048r   main(ac, av)     int ac;l     char *av[];n     {        double sqrt(),sin(),cos();     double magn,rotn;      double segx,segy;      double a,b;e     double micprl;     FILE *fopen();     FILE *ltable;t     FILE *afile;     FILE *RootDesc;p     FILE *SymDesc;     FILE *PipeFile;t     PATHLIST *StartPolyPathp;u     PATHLIST *PolyPathp;     HEADLIST *SymbolProps;     HEADLIST *HeaderCopy;r     RECT *rectp;     RECT *reclistp;u
     char *cp;a     char *mktemp();p     long xy[500];p     long cx,cy;_      long pathwidth,width,length;     long dx,dy;T     long lone;     long deltax,deltay;o     int StandardInput;     int StandardError;     int ptype;     int reflection;o     int Root_flag;     int i,j,k,l;     int NumArefs;_     int RootSymbolNumber;t     int index;     int present;:     int type;                    /* current record type */H     int numb;                    /* number of bytes in current record */     int datatype;e     int dtype;     int layer;     int ncoords;      int ConvertToRectangles = 1;6     int struct_dates[12];        /* structure dates */     int buf[MAXRECSIZE];     int micperl = 0 ;S     int inset = 0 ;u     char cbuf[MAXRECSIZE];     char String[MAXRECSIZE];     char RootSymbol[45];     char CurrentSymbol[45];r     char RootFileName[45];     char template[45];       /*  STREAMTOKIC       *$      *  Giles Billingsley    3/30/83      *      *      options:N      *                      -P       don't convert manhattan polygons to boxesK      *                      -E         print errors in file "strmtokic.err"bB      *                      -Csname    sname = Root structure nameC      *                      -Rfilename filename = name of root cellSJ      *                      -Xfilename filename = cif layer reference file8      *                      -Lmicprl   micron per lambda      */        RootSymbol[0] = NULL;f     RootFileName[0] = NULL;o     SymbolProps = NULL;t     RootSymbolNumber = -1;     Root_flag = 0;     UseLayerTable = 0;     StandardInput = 0;     StandardError = 0;     NumArefs = 0;e     ScaleFactor = 1.0;     micprl = 1.0;h     argc = ac;     argv = av;  *     while(argc > 1 && argv[1][0] == '-') { 	switch(argv[1][1]) {*  
 	case 'c':" 	    strcpy(RootSymbol,nextarg());             Root_flag = 1;  	    /* convert to upper case */ 	    numb = 0;% 	    while(RootSymbol[numb] != NULL){f8 		if(RootSymbol[numb] >= 'a' && RootSymbol[numb] <= 'z') 		    RootSymbol[numb] -= 32;7	 		numb++;n 		}R             break;  
 	case 'r': 	    inset++ ;$ 	    strcpy(RootFileName,nextarg());             break;  
 	case 'l': 	    micperl++ ;$ 	    sscanf(nextarg(),"%f",&micprl); 	    break;   
 	case 'e': 	    StandardError = 1;  	    break;;  
 	case 'x':             UseLayerTable = 1;?             if((ltable = fopen((cp = nextarg()),"r")) == NULL){*E 	        fprintf(stderr,"101$CAN'T OPEN STREAM LAYER FILE %s.\n",cp);                  exit(1);                 }*/             fscanf(ltable,"%d",&NumLayerTable);  	    if(NumLayerTable <= 0){2 	        fprintf(stderr,"501$BAD LAYER TABLE.\n");                 exit(1); 		} /             for(i = 0; i < NumLayerTable; ++i){n0 	        fscanf(ltable,"%s %d %d",LayerNames[i],, 		    &LayerNumbers[i],&DataTypeNumbers[i]);
 	        }             fclose(ltable);              break;  
 	case 'p':$             ConvertToRectangles = 0; 	    break;b  	 	default: H 	    fprintf(stderr,"streamtokic: Unknown flag '%s' ignored\n",argv[1]);j             fprintf(stderr,"Usage: streamtokic [-Rroot] [-Xltable] [-Csname] [-Lmicprl] [-B] [infile]\n");
 	    exit(1);  	    } 	argc--; 	argv++;	         }      if(micperl == 0) {  	printf("Microns per lambda? "); 	scanf("%f", &micprl); 	}     if(inset == 0) {# 	printf("Hierarchy's root cell? ");b 	scanf("%s", RootFileName);m 	}   /* #ifdef TRACER */5! printf("Root %s\n",RootFileName); & printf("Root Symbol %s\n",RootSymbol);& printf("Mic Per Lambda %lf\n",micprl);. printf("Conversion %d\n",ConvertToRectangles); /* #endif */       if(argc >= 2){=         if((STREAMFILE = fopen((cp = argv[1]),"r")) == NULL){ )             printf("Can't open %s\n",cp);=             exit(1);
             }  /* #ifdef TRACER */e  printf("Stream File = %s\n",cp); /* #endif */	         } 	     else{f 	StandardInput = 1;e"         sprintf(template,TMPFILE);6         PipeFile = fopen((cp = mktemp(template)),"w");"         sprintf(template,"%s",cp); 	while((i = getchar()) != EOF) 	    putc((char)i, PipeFile);t 	fclose(PipeFile);" 	STREAMFILE = fopen(template,"r");	         }        if(StandardError){<         if((stderror = fopen("strmtokic.err","w")) == NULL){D 	    fprintf(stderror,"192$CAN'T OPEN FILE NAMED strmtokic.err.\n");
 	    exit(1);u 	    } 	}     else 	stderror = stderr;n       if(RootFileName[0] == NULL)t 	strcpy(RootFileName,"Root");r5     if((RootDesc = fopen(RootFileName,"w")) == NULL){eG 	fprintf(stderror,"102$CAN'T OPEN ROOT FILE NAMED %s.\n",RootFileName);;	 	exit(1);a 	}  
     type = 0;      NumSymbols = 0;       /* build the symbol table */     while(type != 4){           numb = getc(STREAMFILE);1         numb = numb * 256 + getc(STREAMFILE) - 4;           type = getc(STREAMFILE);$         datatype = getc(STREAMFILE);"         for(i = 0; i < numb; ++i){ 	    buf[i] = getc(STREAMFILE);              cbuf[i] = buf[i];  	    } 	cbuf[numb] = NULL;h 	if(type == 4) 	    break;s 	else if(type == 6){* 	    strcpy(SymbolNames[NumSymbols],cbuf); 	    ++NumSymbols; 	    } 	}     rewind(STREAMFILE);b  
     type = 0; 5     /* loop through the records and exit on ENDLIB */s     while(type != 4){           numb = getc(STREAMFILE);1         numb = numb * 256 + getc(STREAMFILE) - 4;           type = getc(STREAMFILE);$         datatype = getc(STREAMFILE);"         for(i = 0; i < numb; ++i){ 	    buf[i] = getc(STREAMFILE);T             cbuf[i] = buf[i];* 	    } 	cbuf[numb] = NULL;e         switch(type){t  
 	case HEADER:l             if(type < 0)J 		fprintf(stderror,"77$WARNING: UNEXPECTED OR ILLEGAL RECORD: %d\n",type); 	    HeaderCopy = NEWHEAD;9 	    HeaderCopy->hd_RecordType = HEADER + PROPERTYOFFSET;F' 	    HeaderCopy->hd_Succ = SymbolProps;c 	    SymbolProps = HeaderCopy;=             sprintf(HeaderCopy->hd_Text,"%d",strm_ival(buf)); A             fprintf(RootDesc,"( VERSION %d );\n",strm_ival(buf));aB             fprintf(RootDesc,"5 %d %d;\n",PROPERTYOFFSET + HEADER, 		strm_ival(buf));             break;           case BGNLIB:A 	    /* we shall not add time info to the symbol property list */s,             fprintf(RootDesc,"( MOD DATE ");             for(i=0; i<6; ++i)=                 fprintf(RootDesc,"%d ",strm_ival(&buf[i+i]));c/             fprintf(RootDesc,": ACCESS DATE ");f             for(i=0; i<6; ++i)@                 fprintf(RootDesc,"%d ",strm_ival(&buf[i+i+12]));%             fprintf(RootDesc,");\n");P             break;           case LIBNAME:( 	    HeaderCopy = NEWHEAD;: 	    HeaderCopy->hd_RecordType = LIBNAME + PROPERTYOFFSET;' 	    HeaderCopy->hd_Succ = SymbolProps;e 	    SymbolProps = HeaderCopy;-             strcpy(HeaderCopy->hd_Text,cbuf);{7             fprintf(RootDesc,"( LIBNAME %s );\n",cbuf);UI             fprintf(RootDesc,"5 %d %s;\n",PROPERTYOFFSET + LIBNAME,cbuf);              break;           case UNITS:rC 	    /* we shall not add metric info to the symbol property list */a$             a = strm_doubleval(buf);(             b = strm_doubleval(&buf[8]);P             fprintf(RootDesc,"( SCALE: %le UNITS/DBU, %le METERS/DBU );\n",a,b);G             fprintf(RootDesc,"( MICRONS PER LAMBDA = %lf );\n",micprl);  	    /*y7 	     * The length of the database unit is 1e-8 meters.b 	     * > 	     *   meters     .01 microns       lambdas         lambdas> 	     *   ------  *  -----------  *  -----------   =   -------< 	     *    DBU          meter        .01 microns         DBU 	     */& 	    ScaleFactor = (1e8 * b)/(micprl);             break;           case ENDLIB:             break;           case BGNSTR:             for(i=0; i<12; ++i) + 		struct_dates[i] = strm_ival(&buf[i + i]);              break;           case STRNAME:L             /* 	     * BEGIN SYMBOL DEFINITIONt 	     */< 	    CurrentLayer = CurrentDataType = CurrentAttribute = -1;*             /* search for symbol number */'             index = struct_index(cbuf);;  	    strcpy(CurrentSymbol,cbuf);- 	    if((SymDesc = fopen(cbuf,"w")) == NULL){*7 		fprintf(stderror,"103$CAN'T OPEN SYMBOL %s.\n",cbuf); 
 		exit(1); 		} %             /* test for RootSymbol */r             if(Root_flag){" 		if(strcmp(RootSymbol,cbuf) == 0)-                     RootSymbolNumber = index;o                 }R' 	    /* add the symbol property list */= 	    HeaderCopy = SymbolProps; 	    while(HeaderCopy != NULL){tG                 fprintf(SymDesc,"5 %d %s;\n",HeaderCopy->hd_RecordType,c 		    HeaderCopy->hd_Text);l# 		HeaderCopy = HeaderCopy->hd_Succ;c 		}d,             fprintf(SymDesc,"9 %s;\n",cbuf);2             fprintf(SymDesc,"DS %d 1 1;\n",index);0             fprintf(SymDesc,"( CREATION DATE ");"             for(i = 0; i < 6; ++i)7                 fprintf(SymDesc,"%d ",struct_dates[i]);a+             fprintf(SymDesc,": MOD DATE ");l"             for(i = 0; i < 6; ++i)9                 fprintf(SymDesc,"%d ",struct_dates[i+6]);a$             fprintf(SymDesc,");\n"); 	    /* / 	     * loop through records and exit on ENDSTRb 	     */             while(type != 7){)                 a = 0;                 b = 0;                 present = 0;                 reflection = 0;                  magn = 1;f                 rotn = 0;)  (                 numb = getc(STREAMFILE);9                 numb = numb * 256 + getc(STREAMFILE) - 4;x(                 type = getc(STREAMFILE);,                 datatype = getc(STREAMFILE);#         	for(i = 0; i < numb; ++i){r  		    buf[i] = getc(STREAMFILE); 	            cbuf[i] = buf[i]; 		    }  		cbuf[numb] = NULL;                 switch(type){T                   case STRNAME: D                     fprintf(stderror,"1$ILLEGAL RECORD: %d\n",type); 		    exit(1);                  case ENDSTR:g-                     fprintf(SymDesc,"DF;\n");L 		    fprintf(SymDesc,"E\n");  		    fclose(SymDesc);                     break;                  case BOUNDARY:M 		    /*/ 		     * loop through records and exit on ENDELi	 		     */{&                     while(type != 17){0                         numb = getc(STREAMFILE);@                         numb = numb * 256 + getc(STREAMFILE) -4;0                         type = getc(STREAMFILE);4                         datatype = getc(STREAMFILE);$         		for(i = 0; i < numb; ++i){! 			    buf[i] = getc(STREAMFILE);+ 		            cbuf[i] = buf[i];e 			    } 			cbuf[numb] = NULL; %                         switch(type){D                            case 12:L                             fprintf(stderror,"2$ILLEGAL RECORD: %d\n",type); 			    exit(1);t  #                         case LAYER: 3                             layer = strm_ival(buf); "                             break;  &                         case DATATYPE:3                             dtype = strm_ival(buf); "                             break;                            case XY:-                             ncoords = numb/4;p8                             for(i = 0; i < ncoords; ++i)1 				xy[i] = LONGSCALE( strm_longval(&buf[4*i]) );h)                             ncoords /= 2;l"                             break;  #                         case ENDEL:9"                             break;  &                         case PROPATTR:>                             CurrentAttribute = strm_ival(buf);"                             break;  '                         case PROPVALUE: : 			    if(CurrentAttribute < 1 || CurrentAttribute > 127){y                                 fprintf(stderror,"36$WARNING: BAD PROPERTY RECORD %d IN SYMBOL %s\n",type,CurrentSymbol);  				CurrentAttribute = 127;e 				}EP                             fprintf(SymDesc,"5 %d %s;\n",CurrentAttribute,cbuf);2                             CurrentAttribute = -1;"                             break;                            default:L                             fprintf(stderror,"3$ILLEGAL RECORD: %d\n",type); 			    exit(1);c                             }                          };4                     PrintLayer(SymDesc,layer,dtype);,                     if(ConvertToRectangles){=                         PolyPathp = StartPolyPathp = NEWPATH;	=                         PolyPathp->pathlink = StartPolyPathp; 5                         for(i = 0; i < ncoords; ++i){r<                             PolyPathp = PolyPathp->pathlink;B                             PolyPathp->pathpoint.pointx = xy[i+i];D                             PolyPathp->pathpoint.pointy = xy[i+i+1];:                             PolyPathp->pathlink = NEWPATH;                             }n3                         PolyPathp->pathlink = NULL;lI                         if((reclistp = pgtorex(StartPolyPathp)) != NULL){  			    rectp = reclistp; 			    while(rectp != NULL){L                                 length = (long)(rectp->right - rectp->left);K                                 width = (long)(rectp->top - rectp->bottom); D                                 cx = (long)(rectp->left) + length/2;E                                 cy = (long)(rectp->bottom) + width/2; .                                 if(length < 0) 				    length = -length;E-                                 if(width < 0)  				    width = -width;eG                                 fprintf(SymDesc,"B %ld %ld %ld %ld;\n", 8                                     length,width,cx,cy);6                                 rectp = rectp->r_next;!                                 }h                             }i                         else{"1                             fprintf(SymDesc,"P");,9                             for(i = 0; i < ncoords; ++i){ 9 			        fprintf(SymDesc," %ld %ld",xy[i+i],xy[i+i+1]);h!                                 } 3                             fprintf(SymDesc,";\n");u                             }p2                         freepath(&StartPolyPathp); 			}                     else{t-                         fprintf(SymDesc,"P");c5                         for(i = 0; i < ncoords; ++i){i5 			    fprintf(SymDesc," %ld %ld",xy[i+i],xy[i+i+1]);m                             }m/                         fprintf(SymDesc,";\n");-                         }                      break;                   case PATH: 		    /*/ 		     * loop through records and exit on ENDELr	 		     */ &                     while(type != 17){0                         numb = getc(STREAMFILE);@                         numb = numb * 256 + getc(STREAMFILE) -4;0                         type = getc(STREAMFILE);4                         datatype = getc(STREAMFILE);$         		for(i = 0; i < numb; ++i){! 			    buf[i] = getc(STREAMFILE);o 		            cbuf[i] = buf[i];n 			    } 			cbuf[numb] = NULL;s%                         switch(type){m  "                         case TEXT:L                             fprintf(stderror,"4$ILLEGAL RECORD: %d\n",type); 			    exit(1);o  #                         case LAYER: 3                             layer = strm_ival(buf); "                             break;  &                         case DATATYPE:3                             dtype = strm_ival(buf); "                             break;  #                         case WIDTH:(G                             pathwidth = LONGSCALE( strm_longval(buf) ); "                             break;                            case XY:-                             ncoords = numb/4; 8                             for(i = 0; i < ncoords; ++i)1 				xy[i] = LONGSCALE( strm_longval(&buf[4*i]) );  			    ncoords /= 2;"                             break;  #                         case ENDEL: "                             break;  #                         case FONTS: L                             fprintf(stderror,"5$ILLEGAL RECORD: %d\n",type); 			    exit(1);   &                         case PATHTYPE:	 			    /*  			     * STREAM pathtypes9 			     * 0 = square ended paths with ends that are flush   			     *     with the endpoints* 			     * 1 = round ended (CIF like) paths4 			     * 2 = square ended paths with ends that are 7 			     *     offset from the endpoint by a half width. 	 			     * , 			     * In KIC, we assume a pathtype of 2.
 			     */=                             if((ptype = strm_ival(buf)) != 2)ed                                 fprintf(SymDesc,"( PATHTYPE %d CONVERTED TO PATHTYPE 2 );\n",ptype);"                             break;  &                         case PROPATTR:>                             CurrentAttribute = strm_ival(buf);"                             break;  '                         case PROPVALUE: : 			    if(CurrentAttribute < 1 || CurrentAttribute > 127){y                                 fprintf(stderror,"32$WARNING: BAD PROPERTY RECORD %d IN SYMBOL %s\n",type,CurrentSymbol);  				CurrentAttribute = 127;a 				} P                             fprintf(SymDesc,"5 %d %s;\n",CurrentAttribute,cbuf);2                             CurrentAttribute = -1;"                             break;                            default:L                             fprintf(stderror,"6$ILLEGAL RECORD: %d\n",type); 			    exit(1);;                             }y 			}4                     PrintLayer(SymDesc,layer,dtype);$ 		    if(ptype == 0 && ncoords > 1){ 			/* / 			 * subtract a half width from the endpoints.  			 */9 			convert_pathtype(&xy[0],&xy[1],xy[2],xy[3],pathwidth);  			i = ncoords+ncoords-2; 4 			convert_pathtype(&xy[i],&xy[i+1],xy[i-2],xy[i-1], 			    pathwidth); 			} 		    if(ptype != 2){ ) 			fprintf(SymDesc,"5 %d PATHTYPE %d;\n", ( 			    PROPERTYOFFSET + PATHTYPE,ptype); 			}7                     fprintf(SymDesc,"W %ld",pathwidth);T1                     for(i = 0; i < ncoords; ++i){(? 	                fprintf(SymDesc," %ld %ld",xy[i+i],xy[i+i+1]);                          } +                     fprintf(SymDesc,";\n");_                     break;                   case SREF: 		    /*/ 		     * loop through records and exit on ENDEL 	 		     */u                     index = 0;&                     while(type != 17){0                         numb = getc(STREAMFILE);A                         numb = numb * 256 + getc(STREAMFILE) - 4;t0                         type = getc(STREAMFILE);4                         datatype = getc(STREAMFILE);$         		for(i = 0; i < numb; ++i){! 			    buf[i] = getc(STREAMFILE);t 		            cbuf[i] = buf[i];  			    } 			cbuf[numb] = NULL;,%                         switch(type){      #                         case WIDTH:=L                             fprintf(stderror,"7$ILLEGAL RECORD: %d\n",type); 			    exit(1);                             case XY:@                             cx = LONGSCALE( strm_longval(buf) );D                             cy = LONGSCALE( strm_longval(&buf[4]) );"                             break;     #                         case ENDEL: "                             break;  #                         case SNAME:o7                             index = struct_index(cbuf); "                             break;  $                         case STRING:L                             fprintf(stderror,"8$ILLEGAL RECORD: %d\n",type); 			    exit(1);      $                         case STRANS:=                             if((buf[1] & 4) || (buf[1] & 2)){l                                 fprintf(stderror,"104$WARNING: ABSOLUTE MAGNIFICATION OR ANGLE FOUND/IGNORED IN SYMBOL %s.\n",CurrentSymbol);t!                                 }	,                             if(buf[0] & 128)/                                 reflection = 1;("                             break;  !                         case MAG:o7                             magn = strm_doubleval(buf); "                             break;  #                         case ANGLE: @                             rotn = strm_doubleval(buf)/RADTODEG;"                             break;  &                         case PROPATTR:>                             CurrentAttribute = strm_ival(buf);"                             break;  '                         case PROPVALUE: : 			    if(CurrentAttribute < 1 || CurrentAttribute > 127){y                                 fprintf(stderror,"33$WARNING: BAD PROPERTY RECORD %d IN SYMBOL %s\n",type,CurrentSymbol);T 				CurrentAttribute = 127;  				}nP                             fprintf(SymDesc,"5 %d %s;\n",CurrentAttribute,cbuf);2                             CurrentAttribute = -1;"                             break;                               default:L                             fprintf(stderror,"9$ILLEGAL RECORD: %d\n",type); 			    exit(1);                              }                          }  		    if(magn == 1.0){3 			fprintf(SymDesc,"9 %s;\n",SymbolNames[index-1]); 6                         fprintf(SymDesc,"C %d",index);5                         i = (int)(100.0 * cos(rotn));y5                         j = (int)(100.0 * sin(rotn));+&                         if(reflection)% 		            fprintf(SymDesc," MY"); $ 			/* throw away default rotation */ 			if(i != 100 || j != 0))<                             fprintf(SymDesc," R %d %d",i,j);?                         fprintf(SymDesc," T %ld %ld;\n",cx,cy);	 			} 		    else{  			lone = (long)(100.0 * magn); { 			fprintf(stderror,"996$WARNING: INSTANCE %s IN SYMBOL %s, MAGNIFICATION NOT UNITY\n",SymbolNames[index-1],CurrentSymbol);[ 			/* 1 			 * If magn is less than .01, then KIC does not  			 * have the resolution. 			 */ 			if(lone > 0){ 			    j = 100;  			    while( !(lone % 10) ){  				j /= 10; 				lone /= 10;e 				}u 		            ++NumArefs; O                             sprintf(SymbolNames[NumSymbols],"AREF%d",NumArefs); ; 			    if((afile=fopen(SymbolNames[NumSymbols],"w")) == 0){ 3 				fprintf(stderror,"105$CAN'T OPEN SYMBOL %s.\n",S! 				    SymbolNames[NumSymbols]);  				exit(1); 				}u 		            ++NumSymbols; O                             fprintf(afile,"9 %s;\n",SymbolNames[NumSymbols-1]);UO                             fprintf(afile,"DS %d %ld %d;\n",NumSymbols,lone,j); 5 			    fprintf(afile,"9 %s;\n",SymbolNames[index-1]); ;                             fprintf(afile,"C %d;\n",index); 3                             fprintf(afile,"DF;\n");  			    fprintf(afile,"E\n"); 			    fclose(afile); ! 			    fprintf(SymDesc,"9 %s;\n",; 				SymbolNames[NumSymbols-1]);A?                             fprintf(SymDesc,"C %d",NumSymbols);D9                             i = (int)(100.0 * cos(rotn)); 9                             j = (int)(100.0 * sin(rotn));n*                             if(reflection)) 		                fprintf(SymDesc," MY");  			    if(i != 100 || j != 0)(@                                 fprintf(SymDesc," R %d %d",i,j);C                             fprintf(SymDesc," T %ld %ld;\n",cx,cy);  			    } 			else{ 			    fprintf(stderror,"106$WARNING: INSTANCE %s IN SYMBOL %s, MAGNIFICATION TOO SMALL\n",SymbolNames[index-1],CurrentSymbol);  			    } 			}                     break;                   case AREF: 		    /*/ 		     * loop through records and exit on ENDELy	 		     */ &                     while(type != 17){0                         numb = getc(STREAMFILE);A                         numb = numb * 256 + getc(STREAMFILE) - 4; 0                         type = getc(STREAMFILE);4                         datatype = getc(STREAMFILE);$         		for(i = 0; i < numb; ++i){! 			    buf[i] = getc(STREAMFILE);G 		            cbuf[i] = buf[i];L 			    } 			cbuf[numb] = NULL;	%                         switch(type){   #                         case WIDTH:5M                             fprintf(stderror,"10$ILLEGAL RECORD: %d\n",type);e 			    exit(1);                             case XY:2                             for(i = 0; i < 6; ++i)1 				xy[i] = LONGSCALE( strm_longval(&buf[4*i]) ); "                             break;  #                         case ENDEL: "                             break;  #                         case SNAME:/7                             index = struct_index(cbuf); "                             break;  $                         case COLROW:0                             cx = strm_ival(buf);4                             cy = strm_ival(&buf[2]);"                             break;  $                         case STRING:M                             fprintf(stderror,"11$ILLEGAL RECORD: %d\n",type);S 			    exit(1);r  $                         case STRANS:=                             if((buf[1] & 4) || (buf[1] & 2)){,                                 fprintf(stderror,"105$WARNING: ABSOLUTE MAGNIFICATION OR ANGLE FOUND/IGNORED IN SYMBOL %s.\n",CurrentSymbol); !                                 }r,                             if(buf[0] & 128)/                                 reflection = 1; "                             break;  !                         case MAG:l7                             magn = strm_doubleval(buf);b"                             break;  #                         case ANGLE:"@                             rotn = strm_doubleval(buf)/RADTODEG;"                             break;  &                         case PROPATTR:>                             CurrentAttribute = strm_ival(buf);"                             break;  '                         case PROPVALUE: : 			    if(CurrentAttribute < 1 || CurrentAttribute > 127){y                                 fprintf(stderror,"34$WARNING: BAD PROPERTY RECORD %d IN SYMBOL %s\n",type,CurrentSymbol);  				CurrentAttribute = 127;" 				}NP                             fprintf(SymDesc,"5 %d %s;\n",CurrentAttribute,cbuf);2                             CurrentAttribute = -1;"                             break;                            default:M                             fprintf(stderror,"12$ILLEGAL RECORD: %d\n",type);  			    exit(1);                              }                          }e 		    /* find deltax */ '                     if(cx <= 0) cx = 1;M)                     segx = xy[2] - xy[0];{)                     segy = xy[3] - xy[1]; @                     deltax = sqrt(segx * segx + segy * segy)/cx;  %                     /* find deltay */ '                     if(cy <= 0) cy = 1; )                     segx = xy[4] - xy[0];L)                     segy = xy[5] - xy[1]; @                     deltay = sqrt(segx * segx + segy * segy)/cy;  )                     k = 1000 * cos(rotn);()                     l = 1000 * sin(rotn); 9 		    /* first we make a row of cells in symbol AREFXX */  		    ++NumArefs; G                     sprintf(SymbolNames[NumSymbols],"AREF%d",NumArefs); ? 		    if((afile = fopen(SymbolNames[NumSymbols],"w")) == NULL){ 2 			fprintf(stderror,"109$CAN'T OPEN SYMBOL %s.\n",  			    SymbolNames[NumSymbols]); 			exit(1);; 			} 		    ++NumSymbols; G                     fprintf(afile,"9 %s;\n",SymbolNames[NumSymbols-1]); =                     fprintf(afile,"DS %d 1 1;\n",NumSymbols);t                     dx = 0;:,                     for(i = 0; i < cx; ++i){F                         fprintf(afile,"9 %s;\n",SymbolNames[index-1]);B                         fprintf(afile,"C %d T %ld 0;\n",index,dx);%                         dx += deltax;R                         }B+                     fprintf(afile,"DF;\n");  		    fprintf(afile,"E\n");  		    fclose(afile);  5 		    /* then we make columns of the symbol AREFXX */  		    ++NumArefs;	G                     sprintf(SymbolNames[NumSymbols],"AREF%d",NumArefs); ? 		    if((afile = fopen(SymbolNames[NumSymbols],"w")) == NULL){ 2 			fprintf(stderror,"110$CAN'T OPEN SYMBOL %s.\n",  			    SymbolNames[NumSymbols]); 			exit(1);) 			} 		    ++NumSymbols; G                     fprintf(afile,"9 %s;\n",SymbolNames[NumSymbols-1]);d=                     fprintf(afile,"DS %d 1 1;\n",NumSymbols);                      dy = 0; ,                     for(i = 0; i < cy; ++i){K                         fprintf(afile,"9 %s;\n",SymbolNames[NumSymbols-2]);0I                         fprintf(afile,"C %d T 0 %ld;\n",NumSymbols-1,dy);N%                         dy += deltay;x                         } +                     fprintf(afile,"DF;\n");e 		    fprintf(afile,"E\n");t 		    fclose(afile);! 		    /* now we call the array */w 		    if(magn == 1.0){M                         fprintf(SymDesc,"9 %s;\n",SymbolNames[NumSymbols-1]); ;                         fprintf(SymDesc,"C %d",NumSymbols);r&                         if(reflection) 			    fprintf(SymDesc," MY");+ 		        /* throw away default rotation */\  		        if(k != 100 || l != 0)<                             fprintf(SymDesc," R %d %d",k,l);E                         fprintf(SymDesc," T %ld %ld;\n",xy[0],xy[1]);s 			} 		    else{  			lone = (long)(100.0 * magn); { 			fprintf(stderror,"966$WARNING: INSTANCE %s IN SYMBOL %s, MAGNIFICATION NOT UNITY\n",SymbolNames[index-1],CurrentSymbol);t 			/*,1 			 * If magn is less than .01, then KIC does not  			 * have the resolution. 			 */ 			if(lone > 0){ 			    j = 100;  			    while( !(lone % 10) ){_ 				j /= 10; 				lone /= 10;  				}  		            ++NumArefs; O                             sprintf(SymbolNames[NumSymbols],"AREF%d",NumArefs);R; 			    if((afile=fopen(SymbolNames[NumSymbols],"w")) == 0){ 3 				fprintf(stderror,"105$CAN'T OPEN SYMBOL %s.\n", ! 				    SymbolNames[NumSymbols]);  				exit(1); 				}  		            ++NumSymbols; O                             fprintf(afile,"9 %s;\n",SymbolNames[NumSymbols-1]);lO                             fprintf(afile,"DS %d %ld %d;\n",NumSymbols,lone,j); : 			    fprintf(afile,"9 %s;\n",SymbolNames[NumSymbols-2]);;                             fprintf(afile,"C %d;\n",index); 3                             fprintf(afile,"DF;\n");  			    fprintf(afile,"E\n"); 			    fclose(afile); ! 			    fprintf(SymDesc,"9 %s;\n",l 				SymbolNames[NumSymbols-1]);,?                             fprintf(SymDesc,"C %d",NumSymbols);f*                             if(reflection)" 			        fprintf(SymDesc," MY");/ 		            /* throw away default rotation */f$ 		            if(k != 100 || l != 0)@                                 fprintf(SymDesc," R %d %d",k,l);C                             fprintf(SymDesc," T %ld %ld;\n",cx,cy);m 			    } 			else{ 			    fprintf(stderror,"166$WARNING: INSTANCE %s IN SYMBOL %s, MAGNIFICATION TOO SMALL\n",SymbolNames[index-1],CurrentSymbol);  			    } 			}                     break;                    case TEXT:                       present = 0;&                     while(type != 17){0                         numb = getc(STREAMFILE);A                         numb = numb * 256 + getc(STREAMFILE) - 4; 0                         type = getc(STREAMFILE);4                         datatype = getc(STREAMFILE);$         		for(i = 0; i < numb; ++i){! 			    buf[i] = getc(STREAMFILE);1 		            cbuf[i] = buf[i];i 			    } 			cbuf[numb] = NULL;[%                         switch(type){   #                         case LAYER: 3                             layer = strm_ival(buf);f"                             break;  #                         case WIDTH:fC                             width = LONGSCALE( strm_longval(buf) ); "                             break;                            case XY:@                             cx = LONGSCALE( strm_longval(buf) );D                             cy = LONGSCALE( strm_longval(&buf[4]) );"                             break;  #                         case ENDEL:m"                             break;  &                         case TEXTTYPE:3                             dtype = strm_ival(buf);o"                             break;  *                         case PRESENTATION:5                             present = strm_ival(buf);o"                             break;  $                         case STRING: 			    cp = cbuf;i 			    while(*cp != NULL){ 				if(*cp == ' ') 				    *cp = '_';	 				cp++;  				}x 			    strcpy(String,cbuf); "                             break;  $                         case STRANS:=                             if((buf[1] & 4) || (buf[1] & 2)){t                                 fprintf(stderror,"106$WARNING: ABSOLUTE MAGNIFICATION OR ANGLE FOUND/IGNORED IN SYMBOL %s.\n",CurrentSymbol); !                                 }",                             if(buf[0] & 128)/                                 reflection = 1;  			    elsea/                                 reflection = 0; "                             break;  !                         case MAG: 7                             magn = strm_doubleval(buf); "                             break;  #                         case ANGLE:x7                             rotn = strm_doubleval(buf); "                             break;  &                         case PATHTYPE:	 			    /*y 			     * STREAM pathtypes9 			     * 0 = square ended paths with ends that are flush   			     *     with the endpoints* 			     * 1 = round ended (CIF like) paths4 			     * 2 = square ended paths with ends that are 7 			     *     offset from the endpoint by a half width. 	 			     *r, 			     * In KIC, we assume a pathtype of 2.
 			     */ 			    ptype = strm_ival(buf);"                             break;  &                         case PROPATTR:>                             CurrentAttribute = strm_ival(buf);"                             break;  '                         case PROPVALUE:B: 			    if(CurrentAttribute < 1 || CurrentAttribute > 127){y                                 fprintf(stderror,"35$WARNING: BAD PROPERTY RECORD %d IN SYMBOL %s\n",type,CurrentSymbol);m" 			        CurrentAttribute = 127; 			        }P                             fprintf(SymDesc,"5 %d %s;\n",CurrentAttribute,cbuf);2                             CurrentAttribute = -1;"                             break;                            default:M                             fprintf(stderror,"13$ILLEGAL RECORD: %d\n",type);n 			    exit(1);\                             }s                         } & 		    PrintLayer(SymDesc,layer,dtype); 		    fprintf(SymDesc,"5 %d WIDTH %d PRESENT %d PTYPE %d MAG %lf ANGLE %lf REFLECT %d;\n",PROPERTYOFFSET + TEXT,width,present,ptype,magn,rotn,reflection);E                     fprintf(SymDesc,"94 %s %ld %ld;\n",String,cx,cy);                      break;   	        case SNAPNODE:  		    /* 		     * snapnodes are not used 	 		     */S&                     while(type != 17){0                         numb = getc(STREAMFILE);A                         numb = numb * 256 + getc(STREAMFILE) - 4; 0                         type = getc(STREAMFILE);4                         datatype = getc(STREAMFILE);+         	        for(i = 0; i < numb; ++i){ ( 		            buf[i] = getc(STREAMFILE);& 	                    cbuf[i] = buf[i]; 		            }. 		        cbuf[numb] = NULL;                         }                      break;                   default:E                     fprintf(stderror,"14$ILLEGAL RECORD: %d\n",type);  		    exit(1);                     }                  }              break;           case REFLIBS:              if(cbuf[0] != NULL)=- 		fprintf(RootDesc,"( REFLIB1 %s );\n",cbuf);               if(cbuf[44] != NULL)2 		fprintf(RootDesc,"( REFLIB2 %s );\n",&cbuf[44]); 	    HeaderCopy = NEWHEAD;: 	    HeaderCopy->hd_RecordType = REFLIBS + PROPERTYOFFSET;' 	    HeaderCopy->hd_Succ = SymbolProps;M 	    SymbolProps = HeaderCopy;@             sprintf(HeaderCopy->hd_Text,"%s %s",cbuf,&cbuf[44]);F             fprintf(RootDesc,"5 %d %s %s;\n",PROPERTYOFFSET + REFLIBS, 		cbuf,&cbuf[44]);             break;           case FONTS:              if(cbuf[0] != NULL) + 		fprintf(RootDesc,"( FONT1 %s );\n",cbuf);o              if(cbuf[44] != NULL)0 		fprintf(RootDesc,"( FONT2 %s );\n",&cbuf[44]);              if(cbuf[88] != NULL)0 		fprintf(RootDesc,"( FONT3 %s );\n",&cbuf[88]);!             if(cbuf[132] != NULL) 1 		fprintf(RootDesc,"( FONT4 %s );\n",&cbuf[132]);a 	    HeaderCopy = NEWHEAD;8 	    HeaderCopy->hd_RecordType = FONTS + PROPERTYOFFSET;' 	    HeaderCopy->hd_Succ = SymbolProps;5 	    SymbolProps = HeaderCopy;;             sprintf(HeaderCopy->hd_Text,"%s %s %s %s",cbuf,r" 		&cbuf[44],&cbuf[88],&cbuf[132]);J             fprintf(RootDesc,"5 %d %s %s %s %s;\n",PROPERTYOFFSET + FONTS,' 		cbuf,&cbuf[44],&cbuf[88],&cbuf[132]);e             break;           case GENERATIONS:  	    HeaderCopy = NEWHEAD;> 	    HeaderCopy->hd_RecordType = GENERATIONS + PROPERTYOFFSET;' 	    HeaderCopy->hd_Succ = SymbolProps;  	    SymbolProps = HeaderCopy;=             sprintf(HeaderCopy->hd_Text,"%d",strm_ival(buf));fE             fprintf(RootDesc,"( GENERATIONS %d );\n",strm_ival(buf));cG             fprintf(RootDesc,"5 %d %d;\n",PROPERTYOFFSET + GENERATIONS,  		strm_ival(buf));             break;           case ATTRTABLE:D 	    HeaderCopy = NEWHEAD;< 	    HeaderCopy->hd_RecordType = ATTRTABLE + PROPERTYOFFSET;' 	    HeaderCopy->hd_Succ = SymbolProps;r 	    SymbolProps = HeaderCopy;-             strcpy(HeaderCopy->hd_Text,cbuf);m             if(cbuf[0] != NULL) 5 		fprintf(RootDesc,"( ATTRIBUTE TABLE %s );\n",cbuf); K             fprintf(RootDesc,"5 %d %s;\n",PROPERTYOFFSET + ATTRTABLE,cbuf);y             break;           default:=             fprintf(stderror,"15$ILLEGAL RECORD: %d\n",type); 
 	    exit(1);L
             } 	         }   -     fprintf(RootDesc,"9 %s;\n",RootFileName); $     fprintf(RootDesc,"DS 0 1 1;\n");     if(Root_flag){!         if(RootSymbolNumber < 0){cO             fprintf(RootDesc,"( Root structure %s not found. );\n",RootSymbol);[0 	    fprintf(RootDesc,"9 %s;\n",SymbolNames[0]);  	    fprintf(RootDesc,"C 1;\n");I             fprintf(stderror,"112$WARNING: ROOT STRUCTURE NOT FOUND.\n"); 
             } 
         else{ A 	    fprintf(RootDesc,"9 %s;\n",SymbolNames[RootSymbolNumber-1]);s2 	    fprintf(RootDesc,"C %d;\n",RootSymbolNumber); 	    }	         } 	     else{  	if(NumSymbols > 0){0 	    fprintf(RootDesc,"9 %s;\n",SymbolNames[0]);  	    fprintf(RootDesc,"C 1;\n"); 	    } 	};     fprintf(RootDesc,"(** STREAM-KIC SYMBOL TABLE **);\n");;#     for(i = 0; i < NumSymbols; ++i)e< 	fprintf(RootDesc,"(  %-16s = %d  );\n",SymbolNames[i],i+1);     fprintf(RootDesc,"DF;\n");     fprintf(RootDesc,"E\n");     fclose(RootDesc);e     if(StandardInput)  	/* unlink(template); */ 	delete(template);     }c  G /**********************************************************************      Function PRINTLAYERe       Giles Billingsley  3/30/83H ***********************************************************************/  PrintLayer(ofile,layer,datatype)     FILE *ofile;     int layer;     int datatype;H     {p
     int l;  A     if(layer < 0 || datatype < 0 || layer > 63 || datatype > 63){uJ 	fprintf(stderror,"ILLEGAL LAYER: LAYER %d DATATYPE %d\n",layer,datatype);	 	exit(1);  	}D     if(layer == CurrentLayer && datatype == CurrentDataType) return;     if(UseLayerTable){+         for(l = 0; l < NumLayerTable; ++l){-D 	    if(LayerNumbers[l] == layer && DataTypeNumbers[l] == datatype){7                 fprintf(ofile,"L %s;\n",LayerNames[l]);  		break; 		}e# 	    else if(l == NumLayerTable-1){)6 		fprintf(stderror,"777$WARNING: UNDEFINED LAYER - ");> 		fprintf(stderror,"layer %d, datatype %d.\n",layer,datatype);	 		return;T 		}N
             }t	         })	     else{          if(layer < 10)" 	    fprintf(ofile,"L 0%d",layer);         else! 	    fprintf(ofile,"L %d",layer);E         if(datatype < 10)a& 	    fprintf(ofile,"0%d;\n",datatype);         else% 	    fprintf(ofile,"%d;\n",datatype);p	         }c     CurrentLayer = layer;[     CurrentDataType = datatype;"     }B  D /*******************************************************************     Function STRUCT_INDEXu       Giles Billingsley  3/30/83E ********************************************************************/) struct_index(cbuf)     char *cbuf;      { 
     int i;  ;     /* the symbol table should be complete at this point */S$     for(i = 0; i < NumSymbols; ++i){* 	if(strcmp(&SymbolNames[i][0],cbuf) == 0){ 	    return(i+1);  	    } 	}B     fprintf(stderror,"200$WARNING: UNDEFINED SYMBOL: %s.\n",cbuf);)     strcpy(SymbolNames[NumSymbols],cbuf);C     ++NumSymbols;      return(NumSymbols);A     }R  D /*******************************************************************     Function CONVERT_PATHTYPEa       Giles BillingsleysE ********************************************************************/ # convert_pathtype(xe,ye,xb,yb,width) .     long *xe,*ye;	/* coordinate of endpoint */C     long xb,yb;		/* coordinate of previous or next point in path */*!     long width;		/* path width */;     {o     double angle;b     double deltaX,deltaY;s     double sin(),cos(),atan2();e       if(width == 0) 	return;     else if(width < 0) 	width = -width;     width /= 2;s     if(*xe == xb){
 	if(*ye > yb)n 	    *ye -= width; 	else( 	    *ye += width; 	}     else if(*ye == yb){*
 	if(*xe > xb)* 	    *xe -= width; 	else  	    *xe += width; 	}	     else{i 	deltaX = (double)(*xe - xb);* 	deltaY = (double)(*ye - yb);* 	angle = atan2(deltaY,deltaX);' 	deltaX = (double)(width) * cos(angle); ' 	deltaY = (double)(width) * sin(angle);  	*xe -= (long)(deltaX);M 	*ye -= (long)(deltaY);  	}     }y  H /***********************************************************************.  * This file contains the following functions:  * RECT *pgtorex(PATHLIST *pg)5  *    convert path list for polygon to rectangle list '  * int lowx(PATHLIST **a, PATHLIST **b);>  *    qsort compare routine for comparison by low x coordinate!  * int lowy(POINT **a, POINT **b) >  *    qsort compare routine for comparison by low y coordinate5  * int orient(PATHLIST *edges, int nedges, int dir[]) 8  *    assign direction to edges and insure manhattanness;  * int cross(PATHLIST *edge, int dir, long ybot, long ytop)eG  *    would horizontal line at height between ybot and ytop cross edge?eJ  * RECT *makerect (long xbot, long ybot, long xtop, long ytop, RECT *next)>  *    make a new rectangle and assign values to its componentsJ  ************************************************************************/    : #define MAXPG 500     /* maximum # of points in polygon */+ #define HEDGE 0       /* Horizontal edge */ ' #define REDGE 1       /* Rising edge */t( #define FEDGE -1      /* Falling edge */   RECT *pgtorex(pg)=     PATHLIST *pg;o     /*<      * Convert path list representing manhattan polygon into!      * linked list of rectangles.\F      * Return rectangle list, or null pointer if something goes wrong.      */s     {&.     int npts = 0, n, dir[MAXPG], curr, wrapno;*     int orient(), cross(), lowx(), lowy();      long xbot, xtop, ybot, ytop;     POINT *pts[MAXPG];*     PATHLIST *p, *edges[MAXPG], *tail = 0;     RECT *rex = 0, *makerect();   $     for(p = pg; p; p = p->pathlink){         if(++npts >= MAXPG){1             /*Polygon with more than 200 points*/              goto exit;
             } &         pts[npts-1] = &(p->pathpoint);         edges[npts-1] = p;	         }e       if(npts < 4){i,         /*Polygon with fewer than 4 points*/         goto exit;	         }   @     /* close path list - don't worry, it's disconnected later */*     (tail = edges[npts-1])->pathlink = pg;  .     /* sort points by low y, edges by low x */=     qsort ((char *) pts, npts, (int) sizeof (POINT *), lowy);iB     qsort ((char *) edges, npts, (int) sizeof (PATHLIST *), lowx);       /* orient edges */#     if(!orient (edges, npts, dir)){x+         /*WARNING , non-manhattan Polygon*/e         goto exit;	         }l       /*;      * Start at the bottom of the polygon and scan upwards,a%      * building rectangles as you go.w      */o'     for(curr = 1; curr < npts; curr++){i#         ybot = pts[curr-1]->pointy; )         while (ybot == pts[curr]->pointy)*             if(++curr >= npts)0                 /* At top of polygon and done */                 goto done;!         ytop = pts[curr]->pointy;p  *         for(wrapno=0, n=0; n < npts; n++){             if(wrapno == 0)H.             xbot = edges[n]->pathpoint.pointx;5             if(!cross (edges[n], dir[n], ybot, ytop))O                 continue; /             wrapno += dir[n] == REDGE ? 1 : -1;r             if(wrapno == 0){2                 xtop = edges[n]->pathpoint.pointx;                  if(xbot == xtop)                     continue;g=                 rex = makerect (xbot, ybot, xtop, ytop, rex);                  if(!rex){y2                     /*makerect ran out of memory*/                     goto exit;                     }n                 }s
             }t	         }s   exit:*      /* shouldn't get here ... */     rex = (RECT *) 0;*   done: -     /* this is the ONLY way out of pgtorex */s3     /* disconnect start of polygon from its tail */d     if(tail)(         tail->pathlink = (PATHLIST *) 0;     return (rex);F     }e     lowx (a, b)g     PATHLIST **a, **b;     /*;      * compare points a and b, after following indirection.o      * Return       *    0 if identical      *      1 if a.x > b.x      *     -1 if a.x < b.x      */      {      POINT *p, *q;        p = &(**a).pathpoint;,     q = &(**b).pathpoint;e     if(p->pointx < q->pointx)          return (-1);     if(p->pointx > q->pointx)G         return (1);*     return (0);i     }      lowy (a, b),     POINT **a, **b;      /*;      * compare points a and b, after following indirection.       * Return       *    0 if identical      *      1 if a.y > b.y      *     -1 if a.y < b.y      */      {t#     if((**a).pointy < (**b).pointy)          return (-1);#     if((**a).pointy > (**b).pointy)w         return (1);      return (0);      }      orient (edges, nedges, dir)n     PATHLIST *edges[];     int dir[], nedges;     /*M      * Assign a direction, "dir[i]" to each of the "nedges" edges "edges[i]".eE      * "Start" points to the first PATHLIST in the path list "edges". L      * Return 1 if all of the edges are horizontal or vertical, 0 otherwise.      */l     { 
     int n;     POINT *p, *q;e        for(n = 0; n < nedges; n++){5         /* note - path list should close on itself */ !         p = &edges[n]->pathpoint;d+         q = &edges[n]->pathlink->pathpoint;y#         if(p->pointy == q->pointy){"9             /* note - point may connect to itself here */*             dir[n] = HEDGE;c             continue; 
             }s#         if(p->pointx == q->pointx){*&             if(p->pointy < q->pointy){                 dir[n] = REDGE;h                 continue;                  }m&             if(p->pointy > q->pointy){                  dir [n] = FEDGE;                 continue;b                 } *             /* Point connects to itself */             dir[n] = HEDGE;:             continue;n
             }t'         /* It's not manhattan folks. */          return (0);e	         }b     return (1);      }*   cross (edge, dir, ybot, ytop)*     PATHLIST *edge;*     int dir;     long ybot, ytop;     /*D      * return 1 if a horizontal line at height between ybot and ytop=      * (ybot < ytop) crosses the edge from edge->pathpoint to D      * edge->pathlink->pathpoint, 0 otherwise.  Dir is the direction      * of the edge.e      */i     {*     long ebot, etop;       switch (dir){      case REDGE:g&         ebot = edge->pathpoint.pointy;0         etop = edge->pathlink->pathpoint.pointy;.         return (ebot <= ybot && etop >= ytop);       case FEDGE:r0         ebot = edge->pathlink->pathpoint.pointy;&         etop = edge->pathpoint.pointy;.         return (ebot <= ybot && etop >= ytop);       default:         return (0); 	         };     }   - RECT *makerect (xbot, ybot, xtop, ytop, next)       long xbot, ybot, xtop, ytop;     RECT *next;l     /*C      * allocate space for a RECT structure and assign values to its B      * components from parameters.  Return pointer to structure or,      * null pointer if can't allocate space.      */r     {i     RECT *r;  (     r = (RECT *) malloc (sizeof (RECT));
     if(r){         r->left = xbot;          r->bottom = ybot;          r->right = xtop;         r->top = ytop;         r->r_next = next;(	         }      return (r);      }    freepath( pathheadpp )     PATHLIST **pathheadpp;     {d     PATHLIST *herep;     PATHLIST *therep;i  @     for( herep = *pathheadpp ; herep != NULL ; herep = therep ){#         therep = herep -> pathlink;          free( (char *) herep );T	         }e     *pathheadpp = NULL;      }r   char *nextarg() {     if(argv[1][2] != '\0') 	return(&argv[1][2]);l     argv++;      argc--;O     return(argv[1]);     };