 /*  * viewports.c  **  * Copyright -C- 1981 Giles C. Billingsley'  * sccsid "@(#)viewports.c	1.1  9/5/83"n  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program	;  * KIC is available free of charge to any interested party.eB  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */        /*<  * Management of PARAMETER, LAYER TABLE, and MENU viewports.  * aK  * ONLY PointLayerTable, MenuSelect, MenuDeselect, ShowPrompt, ShowProcess,FH  * and ShowFineViewport invoke FBTransfer by themselves.  Remember this.  * %  */b   #include <signal.h>t #include "kic.h"   /* Library routines */ char *strncpy(); #ifndef vms	 char *sprintf(); #endif   char TypeOut[200];  	 ShowXY(){+     int Row;  6     Row = FB.fNumRows - Parameters.kpNumLayerMenuRows;+     OutlineText(1,Row,33,Row,FILL,ERASE,0);,5     FBForeground(DISPLAY,Parameters.kpMenuTextColor);t"     FBText(ROW_COLUMN,Row,1,"x:");0     sprintf(TypeOut,"%d",Cursor.kcX/RESOLUTION);%     FBText(ROW_COLUMN,Row,3,TypeOut);0#     FBText(ROW_COLUMN,Row,8," y:");e0     sprintf(TypeOut,"%d",Cursor.kcY/RESOLUTION);&     FBText(ROW_COLUMN,Row,11,TypeOut);%     FBText(ROW_COLUMN,Row,16," dx:");L1     sprintf(TypeOut,"%d",Cursor.kcDX/RESOLUTION);B&     FBText(ROW_COLUMN,Row,21,TypeOut);%     FBText(ROW_COLUMN,Row,25," dy:");01     sprintf(TypeOut,"%d",Cursor.kcDY/RESOLUTION);B&     FBText(ROW_COLUMN,Row,29,TypeOut);     }       ShowParameters(){      long time();     char *ctime();     int Row;  6     Row = FB.fNumRows - Parameters.kpNumLayerMenuRows;
     ShowXY(); 8     OutlineText(34,Row,FB.fNumColumns,Row,FILL,ERASE,0);5     FBForeground(DISPLAY,Parameters.kpMenuTextColor); (     FBText(ROW_COLUMN,Row,34," width:");P     sprintf(TypeOut,"%d",(CoarseWindow.kaRight-CoarseWindow.kaLeft)/RESOLUTION);&     FBText(ROW_COLUMN,Row,41,TypeOut);'     FBText(ROW_COLUMN,Row,46," cell:");(=     strncpy(TypeOut,Parameters.kpCellName,FB.fNumColumns-52);(%     TypeOut[FB.fNumColumns-52] = EOS;d&     FBText(ROW_COLUMN,Row,52,TypeOut);     }s   ShowLayerTable(){k     int Row,Column,Layer,i,j;)     char LayerName[5];       LayerName[4] = EOS;07     for(i = 1;i <= Parameters.kpNumLayerMenuRows; ++i){25 	for(j = 1; j <= Parameters.kpLayersPerMenuRow; ++j){02 	    Layer = (Parameters.kpNumLayerMenuRows - i) *$ 		Parameters.kpLayersPerMenuRow + j;  	    if(Layer <= NumLayerTable){ 		Row = FB.fNumRows - i + 1; 		Column = (j - 1) * 5 + 1;  		FBForeground(DISPLAY,Layer);0 		LayerName[0] = LayerTable[Layer].klTechnology;- 		LayerName[1] = LayerTable[Layer].klMask[0];2- 		LayerName[2] = LayerTable[Layer].klMask[1];Q- 		LayerName[3] = LayerTable[Layer].klMask[2];e, 		FBText(ROW_COLUMN,Row,Column+1,LayerName);! 		if(LayerTable[Layer].klVisible)(< 		    OutlineText(Column,Row,Column,Row,FILL,DISPLAY,Layer);! 		if(Layer == Parameters.kpLayer) < 		    OutlineText(Column+1,Row,Column+4,Row,OUTLINE,DISPLAY,# 			Parameters.kpHighlightingPixel);  		}  	    } 	}     }    PointLayerTable(){     int Row,Column,Layer;      char LayerName[5];       LayerName[4] = EOS;i)     Column = (Cursor.kcColumn - 1)/5 + 1;nH     Layer = (Parameters.kpNumLayerMenuRows-FB.fNumRows+Cursor.kcRow-1) *( 	Parameters.kpLayersPerMenuRow + Column;K     if(Layer <= NumLayerTable And Column <= Parameters.kpLayersPerMenuRow){ % 	Parameters.kpPointLayerTable = True; < 	LayerName[0] = LayerTable[Parameters.kpLayer].klTechnology;9 	LayerName[1] = LayerTable[Parameters.kpLayer].klMask[0];A9 	LayerName[2] = LayerTable[Parameters.kpLayer].klMask[1];;9 	LayerName[3] = LayerTable[Parameters.kpLayer].klMask[2]; 9 	Row = FB.fNumRows - (Parameters.kpNumLayerMenuRows - 1 -e= 	    ((Parameters.kpLayer-1)/Parameters.kpLayersPerMenuRow));*I 	Column = (Parameters.kpLayer - 1 - ((Parameters.kpNumLayerMenuRows - 1 - @ 	    (FB.fNumRows - Row)) * Parameters.kpLayersPerMenuRow)) * 5;8 	OutlineText(Column+2,Row,Column+5,Row,OUTLINE,ERASE,0);* 	FBForeground(DISPLAY,Parameters.kpLayer);+ 	FBText(ROW_COLUMN,Row,Column+2,LayerName);n 	Parameters.kpLayer = Layer;# 	Column = (Parameters.kpLayer - 1 -C? 	    (((Parameters.kpLayer-1)/Parameters.kpLayersPerMenuRow) * n) 	    Parameters.kpLayersPerMenuRow)) * 5;oI 	OutlineText(Column+2,Cursor.kcRow,Column+5,Cursor.kcRow,OUTLINE,DISPLAY,,% 	    Parameters.kpHighlightingPixel);, 	/*(@ 	 * A user might have done a redisplay with this layer chosen to; 	 * be invisible.  If so, make this layer visible.  If thisc< 	 * wasn't done, he might create a geometry, but not see it.  	 * This would be very annoying! 	 */1 	if(Not LayerTable[Parameters.kpLayer].klVisible) * 	    MakeLayerVisible(Parameters.kpLayer); 	FBTransfer(); 	}     }L   ShowPrompt(Prompt)     char *Prompt;      /*3     Implements a basic scroller in a prompt window.rG     Displays MORE when window is full and continues when user types anye     single character.      */     {e
     char *cp;e     char *TypeIn;(     char buffer[200];{
     int Int1;u     int Row;:     Row = FB.fNumRows - Parameters.kpNumLayerMenuRows - 1;     ErasePrompt();5     FBForeground(DISPLAY,Parameters.kpMenuTextColor);r     cp = Prompt;
     Int1 = 0;N     while(*cp != EOS){ 	buffer[Int1++] = *cp++; 	if(*cp == EOS){ 	    buffer[Int1++] = EOS;% 	    FBText(ROW_COLUMN,Row,1,buffer);	+ 	    FB.fLastCursorColumn = strlen(buffer);n 	    FBTransfer(); 	    }3 	elif((Int1 > FB.fNumColumns - 8) Or (Int1 > 190)){r$ 	    sprintf(&buffer[Int1]," MORE");% 	    FBText(ROW_COLUMN,Row,1,buffer);r+ 	    FB.fLastCursorColumn = strlen(buffer);  	    FBTransfer(); 	    FBKeyboard(&TypeIn);L 	    ErasePrompt();r6 	    FBForeground(DISPLAY,Parameters.kpMenuTextColor); 	    Int1 = 0; 	    } 	}     }      ShowPromptAndWait(cp)u
     char *cp;s     {.     ShowPrompt(" ");     ShowPrompt(cp);C
     sleep(3);L     }      ErasePrompt(){M     OutlineText(1,FB.fNumRows-Parameters.kpNumLayerMenuRows-1,FB.fNumColumns, ; 	FB.fNumRows-Parameters.kpNumLayerMenuRows-1,FILL,ERASE,0);;     }r   ShowMenu(Menu,NumMenu)     char **Menu;     int NumMenu;     { 
     int Int1;m     char MenuSelection[81];L       /*'      * Erase the entire menu viewport. [      */w:     OutlineText(MenuViewport.kaLeft,MenuViewport.kaBottom,7 	MenuViewport.kaRight,MenuViewport.kaTop,FILL,ERASE,0);*     /*      * Display Menu Table       */e6     for(Int1 = 0;Int1 < MenuViewport.kaBottom;++Int1){ 	if(Int1 < NumMenu){6 	    FBForeground(DISPLAY,Parameters.kpMenuTextColor);& 	    strncpy(MenuSelection,Menu[Int1],. 		MenuViewport.kaRight-MenuViewport.kaLeft+1);C 	    MenuSelection[MenuViewport.kaRight-MenuViewport.kaLeft+1]=EOS;mA 	    FBText(ROW_COLUMN,Int1+1,MenuViewport.kaLeft,MenuSelection);y 	    } 	else* 	    break;m 	}     }e     ShowCommandMenu(){)     if(Parameters.kpMenu == INSTANCEMENU)* 	ShowInstanceMenu();-     elif(Parameters.kpMenu == ATTRIBUTESMENU)  	ShowAttributeMenu();s(     elif(Parameters.kpMenu == BASICMENU) 	ShowBasicMenu();b,     elif(Parameters.kpMenu == SELECTIONMENU) 	ShowSelectionMenu();d(     elif(Parameters.kpMenu == DEBUGMENU) 	ShowDebugMenu();M+     elif(Parameters.kpMenu == PROPERTYMENU)d 	ShowPropertyMenu();     }a     MenuSelect(Selection)b     char *Selection;       {e
     int Int1;i     int NumMenu;     char **Menu;     char MenuSelection[81];e  '     if(Parameters.kpMenu == BASICMENU){p 	Menu = BasicMenu; 	NumMenu = NumBasicMenu; 	}-     elif(Parameters.kpMenu == SELECTIONMENU){  	Menu = SelectionMenu; 	NumMenu = NumSelectionMenu; 	},     elif(Parameters.kpMenu == INSTANCEMENU){ 	Menu = InstanceMenu;, 	NumMenu = NumInstanceMenu;, 	}.     elif(Parameters.kpMenu == ATTRIBUTESMENU){ 	Menu = AttributeMenu; 	NumMenu = NumAttributeMenu; 	}-     elif(Parameters.kpMenu == AMBIGUITYMENU){  	Menu = AmbiguityMenu; 	NumMenu = NumAmbiguityMenu; 	},     elif(Parameters.kpMenu == PROPERTYMENU){ 	Menu = PropertyMenu;) 	NumMenu = NumPropertyMenu;, 	})     elif(Parameters.kpMenu == DEBUGMENU){: 	Menu = DebugMenu; 	NumMenu = NumDebugMenu; 	}(     for(Int1 = 0;Int1 < NumMenu;++Int1){' 	if(strcmp(Menu[Int1],Selection) == 0){  	    /*m 	     * Erase Menu command 	     */, 	    OutlineText(MenuViewport.kaLeft,Int1+1,, 		MenuViewport.kaRight,Int1+1,FILL,ERASE,0); 	    /*. 	     * Display highlight box. 	     */ 	    if(FB.fNonDestructiveText)m0 	        OutlineText(MenuViewport.kaLeft,Int1+1,/ 		    MenuViewport.kaRight,Int1+1,FILL,DISPLAY,h* 		    Parameters.kpMenuHighlightingColor);	 	    elsei0 	        OutlineText(MenuViewport.kaLeft,Int1+1,2 		    MenuViewport.kaRight,Int1+1,OUTLINE,DISPLAY,* 		    Parameters.kpMenuHighlightingColor); 	    /* ! 	     * Redisplay menu selection.e 	     */8 	    FBForeground(DISPLAY,Parameters.kpMenuSelectColor);& 	    strncpy(MenuSelection,Menu[Int1],1 	    MenuViewport.kaRight-MenuViewport.kaLeft+1);c' 	    MenuSelection[MenuViewport.kaRight ! 		- MenuViewport.kaLeft+1] = EOS; A 	    FBText(ROW_COLUMN,Int1+1,MenuViewport.kaLeft,MenuSelection);o 	    FBTransfer(); 	    return; 	    } 	}     }y   MenuDeselect(Selection)      char *Selection; M     {p
     int Int1;      int NumMenu;     char **Menu;     char MenuSelection[81];S  '     if(Parameters.kpMenu == BASICMENU){o 	Menu = BasicMenu; 	NumMenu = NumBasicMenu; 	}-     elif(Parameters.kpMenu == SELECTIONMENU){  	Menu = SelectionMenu; 	NumMenu = NumSelectionMenu; 	},     elif(Parameters.kpMenu == INSTANCEMENU){ 	Menu = InstanceMenu;u 	NumMenu = NumInstanceMenu;e 	}.     elif(Parameters.kpMenu == ATTRIBUTESMENU){ 	Menu = AttributeMenu; 	NumMenu = NumAttributeMenu; 	}-     elif(Parameters.kpMenu == AMBIGUITYMENU){b 	Menu = AmbiguityMenu; 	NumMenu = NumAmbiguityMenu; 	},     elif(Parameters.kpMenu == PROPERTYMENU){ 	Menu = PropertyMenu;e 	NumMenu = NumPropertyMenu;n 	})     elif(Parameters.kpMenu == DEBUGMENU){h 	Menu = DebugMenu; 	NumMenu = NumDebugMenu; 	}(     for(Int1 = 0;Int1 < NumMenu;++Int1){' 	if(strcmp(Menu[Int1],Selection) == 0){t 	    /*u 	     * Erase highlight box. 	     */, 	    OutlineText(MenuViewport.kaLeft,Int1+1,, 		MenuViewport.kaRight,Int1+1,FILL,ERASE,0); 	    /*e! 	     * Redisplay menu selection., 	     */6 	    FBForeground(DISPLAY,Parameters.kpMenuTextColor);& 	    strncpy(MenuSelection,Menu[Int1],1 	    MenuViewport.kaRight-MenuViewport.kaLeft+1); ' 	    MenuSelection[MenuViewport.kaRightm! 		- MenuViewport.kaLeft+1] = EOS;rA 	    FBText(ROW_COLUMN,Int1+1,MenuViewport.kaLeft,MenuSelection);r 	    FBTransfer(); 	    break;t 	    } 	}     }M    < OutlineText(Left,Bottom,Right,Top,Type,DisplayOrErase,Pixel)$     int Left,Bottom,Right,Top,Pixel;     char Type,DisplayOrErase;      /*I      * Outline the box defined by LeftColumn, BottomRow, RightColumn, and.1      * TopRow in the color associated with Pixel.E      */      {.     int style;,     Bottom = FB.fMaxY-Bottom*FB.fFontHeight;     if(Bottom < 0) 	Bottom = 0;*     Top = FB.fMaxY-(Top-1)*FB.fFontHeight;     if(Top > FB.fMaxY) 	Top = FB.fMaxY;$     Left = (Left-1) * FB.fFontWidth;(     Right = (Right * FB.fFontWidth) - 1;0     if(Type == FILL And DisplayOrErase == ERASE)	 	++Right;N     if(Type == OUTLINE){
 	++Bottom; 	--Top;C 	}+     if(Pixel == 0 Or Pixel > NumLayerTable)n 	style = 0;      else% 	style = LayerTable[Pixel].klStyleID;CA     FBBox(Pixel,DisplayOrErase,Type,style,Left,Bottom,Right,Top);a     }e  
 ShowLayout(){+     /*I      * Why -1?  Major grid points that are centered on the left or bottomnC      * edges of the viewport wouldn't be totally erased without -1.       */e6     FBBox(0,ERASE,FILL,0,LargeCoarseViewport.kaLeft-1,  	LargeCoarseViewport.kaBottom-1, 	LargeCoarseViewport.kaRight,M 	LargeCoarseViewport.kaTop);     }    ShowFineViewport(){r     int Layer, Width;)     char Type;     struct p *Path; <     if(Parameters.kpRedisplayControl == COARSEVIEWPORTONLY){ 	ShowLayout();/ 	Redisplay(Parameters.kpCellDesc,CoarseWindow);f 	} 		     else{LD 	FBBox(0,ERASE,FILL,0,FineViewport.kaLeft-1,FineViewport.kaBottom-1,. 	    FineViewport.kaRight,FineViewport.kaTop);5 	/* Show fine positioning window in coarse window. */OA 	ShowBox(Parameters.kpHighlightingPixel,FineWindow,CoarseWindow); % 	/* Redisplay in magnifying glass. */p2 	Parameters.kpRedisplayControl = FINEVIEWPORTONLY;- 	Redisplay(Parameters.kpCellDesc,FineWindow);;- 	Parameters.kpRedisplayControl = SPLITSCREEN;u 	}     /*E      * Here we special case the input routines for wires and polygons)      */ %     if(Parameters.kpPointer != NULL){,$ 	CDType(Parameters.kpPointer,&Type); 	if(Type == CDWIRE){6 	    CDWire(Parameters.kpPointer,&Layer,&Width,&Path);- 	    ShowWire(Layer,Width,Path,CoarseWindow);h 	    } 	elif(Type == CDPOLYGON){ 2 	    CDPolygon(Parameters.kpPointer,&Layer,&Path);- 	    ShowPath(Layer,Path,CoarseWindow,False);  	    } 	}     FBTransfer();i     }k   EraseMagnifyingGlass()     {n     /*?      * Erase fine positioning window in coarse window and patcheA      * up the hole.  'c' will disable showing of fine positioning_      * window in Redisplay.L      */e7     Parameters.kpRedisplayControl = COARSEVIEWPORTONLY; $     EraseBox(FineWindow,FineWindow);0     Redisplay(Parameters.kpCellDesc,FineWindow);0     Parameters.kpRedisplayControl = SPLITSCREEN;     }]   KIC(){     FILE *kiclogo;     char buffer[200];      int i,j,k,l,m,n;
     int semi;;     int command;  
 #ifdef vms3     if((kiclogo = fopen("LOGO.KIC", "r")) == NULL){  #elseB3     if((kiclogo = fopen(".KICLogo", "r")) == NULL){; #endifF 	if((kiclogo = POpen(DEFAULT_KIC_LOGO,"r",(char *)NULL,(char **)NULL)) 	    == NULL){ 	    /*. 	     * Old KIC Logo@ 	     * Left == 200.  Right == 400.  Top == 400.  Bottom == 150. 	     */      	    /* Skull */ 	    FBForeground(DISPLAY,1);P 	    FBLine(200,400,400,400);= 	    FBLine(200,400,300,150);a 	    FBLine(400,400,300,150);o 	    /* Eyes */E 	    FBForeground(DISPLAY,2);h 	    /* Left eye */h 	    FBLine(200,400,275,375);y 	    /* Right eye */ 	    FBLine(400,400,325,375);  	    /* Nose */* 	    FBForeground(DISPLAY,3);  	    FBLine(300,300,300,300);  	    /* Mouth */ 	    FBForeground(DISPLAY,4);w 	    FBLine(270,225,330,225);w 	    /* KIC */ 	    FBForeground(DISPLAY,5);M 	    /* K */ 	    FBLine(425,400,330,225);w 	    FBLine(330,225,425,150);, 	    /* i */ 	    FBLine(350,200,350,150);  	    /* c */ 	    FBLine(450,200,400,200);R 	    FBLine(400,200,400,150);; 	    FBLine(400,150,450,150);e 	    return; 	    } 	}
     l = 0;	     loop{A  	fscanf(kiclogo,"%[^;]",buffer); 	/* get rid of semicolon */F 	semi = getc(kiclogo); 	i = 0;k 	/* flush white space */( 	while((command = buffer[i++]) <= 040) ;% 	if(command == 'e' Or command == 'E')e 	    break;W( 	elif(command == 'l' Or command == 'L'){	 	    ++l;r 	    FBForeground(DISPLAY,l);N 	    }( 	elif(command == 'b' Or command == 'B'){2 	    sscanf(&buffer[i],"%d %d %d %d",&n,&m,&j,&k); 	    j /= RESOLUTION;  	    k /= RESOLUTION;s 	    n /= RESOLUTION;r 	    m /= RESOLUTION;  	    n /= 2; 	    m /= 2;8 	    FBBox(l,DISPLAY,OUTLINE,0,j - n,k - m,j + n,k + m); 	    }( 	elif(command == 'w' Or command == 'W'){< 	    sscanf(&buffer[i]," %d %d %d %d %d",&semi,&j,&k,&n,&m); 	    j /= RESOLUTION;e 	    k /= RESOLUTION;  	    n /= RESOLUTION;t 	    m /= RESOLUTION;a 	    FBLine(j,k,n,m);e 	    } 	}     },   InViewport(X,Y,AOI)      int X,Y;     struct ka AOI;     {nE     if(AOI.kaLeft <= X And X <= AOI.kaRight And AOI.kaBottom >= Y Ande 	Y >= AOI.kaTop)   	return(True);     else return(False);w     }f    ) ShowCurrentObject(Pointer,DisplayOrErase)      struct o *Pointer;     char DisplayOrErase;     {O     struct ka AOI;     /*:      * Show the object with an X through the bounding box.      */ A     CDBB(Parameters.kpCellDesc,Pointer,&AOI.kaLeft,&AOI.kaBottom,  	&AOI.kaRight,&AOI.kaTop);"     if(DisplayOrErase == DISPLAY){H         ShowLine(Parameters.kpHighlightingPixel,AOI.kaLeft,AOI.kaBottom,) 	    AOI.kaRight,AOI.kaTop,CoarseWindow);ME         ShowLine(Parameters.kpHighlightingPixel,AOI.kaLeft,AOI.kaTop,e, 	    AOI.kaRight,AOI.kaBottom,CoarseWindow);D         ShowManhattanLine(Parameters.kpHighlightingPixel,AOI.kaLeft,9 	    AOI.kaBottom,AOI.kaRight,AOI.kaBottom,CoarseWindow);=E         ShowManhattanLine(Parameters.kpHighlightingPixel,AOI.kaRight,;6 	    AOI.kaBottom,AOI.kaRight,AOI.kaTop,CoarseWindow);E         ShowManhattanLine(Parameters.kpHighlightingPixel,AOI.kaRight,r2 	    AOI.kaTop,AOI.kaLeft,AOI.kaTop,CoarseWindow);D         ShowManhattanLine(Parameters.kpHighlightingPixel,AOI.kaLeft,5 	    AOI.kaTop,AOI.kaLeft,AOI.kaBottom,CoarseWindow); 	         }i	     else{  	EraseBox(AOI,AOI);e& 	Redisplay(Parameters.kpCellDesc,AOI); 	}     }g     ShowProcess(cp)0
     char *cp;      {e
 #ifdef vms     FILE *list, *fopen(); 
     char *bp;I     char *tmp;     char *cmd;     char buffer[80];     char tmpname[80]; 
     int i;  
     cmd = cp;i5     FBForeground(DISPLAY,Parameters.kpMenuTextColor);i     /* convert to upper case */=     bp = cp;     while(*bp != NULL){e 	if(*bp >= 'a' And *bp <= 'z') 	    *bp -= 32;e 	++bp; 	}  3     /* substitute tmp filename for "/OUTPUT=KIC" */,     bp = cp;     tmp = mktemp("SYSXXXXXX");"     sprintf(tmpname,"%s.LIS",tmp);     tmp = tmpname;     while(*bp != NULL){i6 	if(*bp == 'O' And *(bp+1) == 'U' And *(bp+2) == 'T'){
 	    bp += 3;T 	    /* scan ahead for '=' */i, 	    while(*bp != NULL And *bp != '=') ++bp; 	    if(*bp != NULL){o 		i = bp - cp + 1;9 		if(cp[i] == 'K' And cp[i+1] == 'I' And cp[i+2] == 'C'){" 		    cp[i] = NULL;e 		    bp = &cp[i + 3];* 		    sprintf(buffer,"%s%s %s",cp,tmp,bp); 		    cmd = buffer;L 		    }/ 		}  	    break;  	    } 	++bp; 	}     system(cmd);(     if((list = fopen(tmp,"r")) != NULL){6 	FBMore(FineViewport.kaLeft-1,FineViewport.kaBottom-1,3 	    FineViewport.kaRight,FineViewport.kaTop,list);, 	fclose(list);# 	sprintf(buffer,"DELETE %s;*",tmp);y 	system(buffer); 	} #elseP     FILE *list,*propen();*5     FBForeground(DISPLAY,Parameters.kpMenuTextColor);r(     if((list = propen(cp,"r")) == NULL){# 	ShowPrompt("Can't open process.");a 	return; 	}N     FBMore(FineViewport.kaLeft-1,FineViewport.kaBottom-1,FineViewport.kaRight, 	FineViewport.kaTop,list);     prclose(list); #endif'     if(Parameters.kpCellName[0] != EOS)e 	ShowFineViewport();	     else{a 	ShowLayout(); 	KIC();A 	}     FBTransfer();l     }s    0 ShowInstanceMarker(DisplayOrErase,Layer,Pointer)     int Layer;     char DisplayOrErase;     struct o *Pointer;     {o     struct t *TGen;e     char Type;     int DX,DY,X,Y;,     if(Not Parameters.kpShowInstanceMarkers) 	return;,     /*Mark reference point of symbol call */     X = Y = 0;     CDInitTGen(Pointer,&TGen);
     loop { 	CDTGen(&TGen,&Type,&DX,&DY);= 	if(TGen == NULL)t 	    break;e 	elif(Type == CDTRANSLATE){k 	    X = DX; 	    Y = DY; 	    } 	}-     ShowMarker(DisplayOrErase,Layer,X,Y,600);L     }a    * ShowMarker(DisplayOrErase,Layer,X,Y,Delta)     char DisplayOrErase;     int Layer;     int X,Y;9     int Delta;	/* width of marker in RESOLUTION*Lambda */      {I     struct ka BB;O     int X1,Y1,X2,Y2;"     if(DisplayOrErase == DISPLAY){ #ifdef FBCONTROL 	if(Parameters.kpEnableFB) #endif! 	    FBForeground(DISPLAY,Layer); , 	X1 = X; Y1 = Y+Delta; X2 = X+Delta; Y2 = Y;* 	ShowLine(Layer,X1,Y1,X2,Y2,CoarseWindow); 	X1 = X; Y1 = Y-Delta;* 	ShowLine(Layer,X1,Y1,X2,Y2,CoarseWindow); 	X2 = X-Delta; Y2 = Y;* 	ShowLine(Layer,X1,Y1,X2,Y2,CoarseWindow); 	X1 = X; Y1 = Y+Delta;* 	ShowLine(Layer,X1,Y1,X2,Y2,CoarseWindow); 	}
     else { 	BB.kaLeft = X - Delta;d 	BB.kaRight = X + Delta; 	BB.kaBottom = Y - Delta;s 	BB.kaTop = Y + Delta; 	EraseBox(BB,CoarseWindow);=% 	Redisplay(Parameters.kpCellDesc,BB);  	}     }m     #ifndef vmsp  - #define  tst(a,b)   (*mode == 'r'? (b) : (a))  #define  RDR	0 #define  WTR	1   static int propen_pid[20];   FILE * propen(cmd,mode)     char *cmd;     char *mode;U     {*
     int p[2];;"     register myside, hisside, pid;       if(pipe(p) < 0)  	return(NULL);!     myside = tst(p[WTR], p[RDR]); "     hisside = tst(p[RDR], p[WTR]);     if((pid = vfork()) == 0){%0 	/* myside and hisside reverse roles in child */ 	close(myside); # 	if(dup2(hisside, tst(0, 1)) == -1) 
 	    exit(1);f 	close(hisside);& 	execl("/bin/sh", "sh", "-c", cmd, 0);
 	_exit(1); 	}     if(pid == -1)e 	return(NULL);     propen_pid[myside] = pid;s     close(hisside);f!     return(fdopen(myside, mode));u     }    prclose(ptr)     FILE *ptr;     { 6     register f, r, (*hstat)(), (*istat)(), (*qstat)();     int status;0       f = fileno(ptr);     fclose(ptr);$     istat = signal(SIGINT, SIG_IGN);%     qstat = signal(SIGQUIT, SIG_IGN);F$     hstat = signal(SIGHUP, SIG_IGN);A     while((r = wait((int *)&status)) != propen_pid[f] && r != -1)  	    ;     if(r == -1)(
 	status = -1;)     signal(SIGINT, istat);     signal(SIGQUIT, qstat);L     signal(SIGHUP, hstat);     return(status);(     }, #endif