 /*
  * vmsio.c  *-  * Written by Giles Billingsley, UC Berkeley.)#  * sccsid "@(#)vmsio.c	1.9  9/3/83"r  *E  *     MFB is a graphics package that was developed by the integratedo@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atD  * the University of California, Berkeley, California.  The programs?  * in MFB are available free of charge to any interested party.nC  * The sale, resale, or use of these program for profit without the;F  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,i  * is forbidden.  *#  * Routines to replace stty on VMS.r  *8  *          dev_init(buf,size)   initialize this packageD  *          dev_getchar()        input a char (no-echo, 1 char buff),  *                               from stdin.C  *          dev_printf()         output a string of n chars with noe.  *				 hacking of special characters to stdoutD  *          dev_getc()           input a char (no-echo, 1 char buff)C  *          dev_write()          output a string of n chars with noD$  *				 hacking of special characters  */L   #include ssdef #include descrip #include iodef #include rms #include "mfb.h"   static unsigned rfunc; static unsigned wfunc; static int dev_channel;w static int initialized = 0;S   /*  * Test routine for vmsio.cd  *
  * main(){
  *     int c;S  *     dev_init();  *     c = dev_getchar(); $  *     printf("character = %d\n",c);  *     c = dev_getchar(); $  *     printf("character = %d\n",c);  *     c = dev_getchar();B$  *     printf("character = %d\n",c);  *     c = dev_getchar();a$  *     printf("character = %d\n",c);  *     c = dev_getchar(); $  *     printf("character = %d\n",c);'  *     dev_printf("this is a test",14);R  *     }  */R    
 /*									*/o9 /*	DEV_INIT - initializes global variables in DISPLAY		*/ 
 /*									*/  dev_init() {%     struct dsc$descriptor_s com_desc;      char *cp = "TT";     int status;U       if(initialized)p 	return;     initialized = 1;)     com_desc.dsc$w_length = strlen( cp );)      com_desc.dsc$a_pointer = cp;)     com_desc.dsc$b_class = DSC$K_CLASS_S; )     com_desc.dsc$b_dtype = DSC$K_DTYPE_T;e*     wfunc = IO$_WRITEVBLK | IO$M_NOFORMAT;'     rfunc = IO$_READVBLK | IO$M_NOECHO; 4     status = sys$assign(&com_desc,&dev_channel,0,0);     if(status != SS$_NORMAL){f;         printf("SYS$ASSIGN failed.  Status = %d\n",status);          exit(1);	         }e     }f    
 /*									*/i: /*	DEV_OPEN - initializes global variables in DISPLAY.		*/> /*	open and assign the 'channel' to device 'name' (stdio by	*/ /*	default).							*/ 
 /*									*/  dev_open(name,channel)     char *name;l     int *channel;&     {)%     struct dsc$descriptor_s com_desc;      char *cp = "TT";     int status;i       /* initialize stdio */     dev_init();).     /* open the standard channel by default */&     if(name == NULL || *name == NULL){ 	/* stdout by default */-         com_desc.dsc$w_length = strlen( cp ); $         com_desc.dsc$a_pointer = cp; 	}	     else{r/         com_desc.dsc$w_length = strlen( name );c&         com_desc.dsc$a_pointer = name; 	})     com_desc.dsc$b_class = DSC$K_CLASS_S;i)     com_desc.dsc$b_dtype = DSC$K_DTYPE_T;b*     wfunc = IO$_WRITEVBLK | IO$M_NOFORMAT;'     rfunc = IO$_READVBLK | IO$M_NOECHO;A/     status = sys$assign(&com_desc,channel,0,0);=     if(status != SS$_NORMAL){";         printf("SYS$ASSIGN failed.  Status = %d\n",status);          exit(1);	         }U     }     
 /*									*/N6 /*	DEV_PRINTF - dumps buffer to standard terminal			*/
 /*									*/-> /*	It is necessary to have the length argument because the		*/1 /*	character buffer may have embedded nulls.			*/&
 /*									*/  dev_printf(buffer,length)k     char *buffer;      int length;N     {      int status;a     int f_status;,  O     status = sys$qiow(6,dev_channel,wfunc,&f_status,0,0,buffer,length,0,0,0,0);      if(status != SS$_NORMAL){A9         printf("SYS$QIOW failed.  Status = %d\n",status); 	         }b     return(status);U     }l    
 /*									*/#@ /*  DEV_GETCHAR - get a character from the standard terminal		*/
 /*									*/y dev_getchar(){     char buf[10];      int status;s     int f_status;y  G     status = sys$qiow(7,dev_channel,rfunc,&f_status,0,0,buf,1,0,0,0,0);      return((int)buf[0]);     }B    
 /*									*/.2 /*	DEV_WRITE - dumps buffer to device channel			*/
 /*									*/e> /*	It is necessary to have the length argument because the		*/1 /*	character buffer may have embedded nulls.			*/ 
 /*									*/n  dev_write(channel,buffer,length)     char *buffer;p     int channel;     int length;c     {      int status;a     int f_status;   K     status = sys$qiow(6,channel,wfunc,&f_status,0,0,buffer,length,0,0,0,0);N     if(status != SS$_NORMAL){B9         printf("SYS$QIOW failed.  Status = %d\n",status);c	         };     return(status);$     })    
 /*									*/"; /*  DEV_GETC - get a character from the device channel			*/;
 /*									*/  dev_getc(channel)	     int channel;     {a     char buf[10];l     int status;/     int f_status;n  C     status = sys$qiow(7,channel,rfunc,&f_status,0,0,buf,1,0,0,0,0);*     return((int)buf[0]);     }e  