 /*
  * wires.c  **  * Copyright -C- 1981 Giles C. Billingsley#  * sccsid "@(#)wires.c	1.1  9/5/83"   *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The programV;  * KIC is available free of charge to any interested party. B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */b  e    /*  * Wire management.e  */    #include "kic.h"   /* Library routines */ #ifndef vmsh char *sprintf(); #endif   char TypeOut[200];   Wires(LookedAhead)     int *LookedAhead;      {      struct p *Path;i     struct ka BB;_     int Width;     int X,Y;      int ExpectFirstPoint = True;     int NumWiresMade = 0;t     int Terminated = False;c     int NumReferencePoints = 0;o       Path = NULL;     MenuSelect(MenuWIRES);B     Width = LayerTable[Parameters.kpLayer].klWireWidth*RESOLUTION;-     ShowPrompt("Point to reference points.");p
     loop {	 	Point();u$ 	if(Parameters.kpCommand[0] != EOS){4 	    if(strcmp(Parameters.kpCommand,MenuUNDO) == 0){3 		if(NumWiresMade == 0 Or NumReferencePoints == 0){  		    *LookedAhead = True;" 		    Parameters.kpPointer = NULL; 		    MenuDeselect(MenuWIRES);
 		    return;i 		    }a. 		elif(Terminated Or NumReferencePoints == 1){ 		    MenuSelect(MenuUNDO);"; 		    CDDelete(Parameters.kpCellDesc,Parameters.kpPointer);% 		    --NumWiresMade;v 		    NumReferencePoints = 0;a 		    EraseBox(BB,BB);* 		    Redisplay(Parameters.kpCellDesc,BB); 		    ExpectFirstPoint = True; 		    MenuDeselect(MenuUNDO);  		    }R 		elif(NumReferencePoints > 1){  		    /* Undo last segment. */ 		    MenuSelect(MenuUNDO); # 		    RemoveLastPointInPath(&Path);p- 		    /* Delete the wire with the old path */; 		    CDDelete(Parameters.kpCellDesc,Parameters.kpPointer);( 		    EraseBox(BB,BB);* 		    Redisplay(Parameters.kpCellDesc,BB);+ 		    /* Make the wire with the new path */ A 		    if(Not CDMakeWire(Parameters.kpCellDesc,Parameters.kpLayer,u% 			Width,Path,&Parameters.kpPointer))= 			MallocFailed();> 		    CDSetInfo(Parameters.kpCellDesc,Parameters.kpPointer,5); 		    --NumReferencePoints;  		    X = Y = -INFINITY; 		    /* find new BB */t/ 		    CDStatusInt = CDBB(Parameters.kpCellDesc,  			Parameters.kpPointer, 			&BB.kaLeft,&BB.kaBottom,b 			&BB.kaRight,&BB.kaTop);1 		    ShowWire(Parameters.kpLayer,Width,Path,BB);e 		    MenuDeselect(MenuUNDO);, 		    }  		}u 	    else {] 		*LookedAhead = True; 		if(Not ExpectFirstPoint)> 		    CDSetInfo(Parameters.kpCellDesc,Parameters.kpPointer,0); 		if(NumWiresMade > 0){  		    if(Not ExpectFirstPoint){e 			EraseBox(BB,BB);e' 			Redisplay(Parameters.kpCellDesc,BB);  			}# 		    Parameters.kpModified = True;o 		    }a 		Parameters.kpPointer = NULL; 		MenuDeselect(MenuWIRES);	 		return;c 		}a 	    }G 	elif(Parameters.kpPointLayerTable Or !Parameters.kpPointCoarseWindow){ C 	    Width = LayerTable[Parameters.kpLayer].klWireWidth*RESOLUTION;= 	    continue; 	    } 	elif(ExpectFirstPoint){I 	    sprintf(TypeOut,"The wire width is currently %d.",Width/RESOLUTION);D 	    ShowPrompt(TypeOut);t 	    ExpectFirstPoint = False; 	    Terminated = False; 	    NumReferencePoints = 1;> 	    if((Path = (struct p *)malloc(sizeof(struct p))) == NULL) 		MallocFailed();  	    Path->pX = X = Cursor.kcX;I 	    Path->pY = Y = Cursor.kcY;r 	    Path->pSucc = NULL;F 	    if(Not CDMakeWire(Parameters.kpCellDesc,Parameters.kpLayer,Width, 		Path,&Parameters.kpPointer)) 		MallocFailed();	= 	    CDSetInfo(Parameters.kpCellDesc,Parameters.kpPointer,5);n 	    BB.kaLeft = X - Width;t 	    BB.kaRight = X + Width; 	    BB.kaBottom = Y - Width;n 	    BB.kaTop = Y + Width;0 	    ShowWire(Parameters.kpLayer,Width,Path,BB); 	    ++NumWiresMade; 	    }+ 	elif(Cursor.kcX == X And Cursor.kcY == Y){- 	    /*iH 	     * If wire has one reference point--if it is a round flash--it will 	     * be displayed now.s 	     */ 	    Terminated = True;r= 	    CDSetInfo(Parameters.kpCellDesc,Parameters.kpPointer,0);D 	    EraseBox(BB,BB); ) 	    Redisplay(Parameters.kpCellDesc,BB);e 	    ExpectFirstPoint = True;e 	    } 	else {  	    /*aD 	     * Make a copy of Path with the new reference point appended to  	     * it and store it in Path. 	     */ 	    X = Cursor.kcX; 	    Y = Cursor.kcY;$ 	    AppendPointToPath(&X,&Y,&Path);, 	    /* Delete the wire with the old path */: 	    CDDelete(Parameters.kpCellDesc,Parameters.kpPointer);* 	    /* Make the wire with the new path */F 	    if(Not CDMakeWire(Parameters.kpCellDesc,Parameters.kpLayer,Width, 		Path,&Parameters.kpPointer)) 		MallocFailed();a= 	    CDSetInfo(Parameters.kpCellDesc,Parameters.kpPointer,5);eC 	    CDStatusInt = CDBB(Parameters.kpCellDesc,Parameters.kpPointer,D7 	       &BB.kaLeft,&BB.kaBottom,&BB.kaRight,&BB.kaTop);p 	    ++NumReferencePoints;0 	    ShowWire(Parameters.kpLayer,Width,Path,BB); 	    } 	}     }a    ! ShowWire(Layer,Width,Path,Window)t     int Layer,Width;     struct p *Path;      struct ka Window;      {t     struct p *Pair;	#     int C,D,PredX,X,PredY,Y,Width2;a     double alpha;0     struct ka BB;d     struct p PolyPath[4];c       if(Width <= 0){e 	ShowPath(Layer,Path,Window,0);t 	return; 	}     Width2 = Width >> 1;     Pair = Path;     PredX = Pair->pX;a     PredY = Pair->pY;;     Pair = Pair->pSucc;S     while(Pair != NULL){ 	BB.kaLeft = PredX-Width2; 	BB.kaBottom = PredY-Width2; 	BB.kaRight = PredX+Width2;h 	BB.kaTop = PredY+Width2;L 	ShowBox(Layer,BB,Window); 	X = Pair->pX; 	Y = Pair->pY;" 	if(IsManhattan(PredX,PredY,X,Y)){ 	    if(PredY == Y){ 		/* Horizontal thick line */T 		BB.kaLeft = min(PredX,X);u 		BB.kaBottom = Y-Width2;  		BB.kaRight = max(PredX,X); 		BB.kaTop = Y+Width2; i 		}  	    else {P 		/* Vertical thick line */o 		BB.kaLeft = X-Width2;	 		BB.kaBottom = min(PredY,Y);  		BB.kaRight = X+Width2; 		BB.kaTop = max(PredY,Y);   		}t 	    ShowBox(Layer,BB,Window); 	    } 	else {r 	    /* Non-manhattan Wire */,= 	    alpha = -atan2((double)(PredY - Y),(double)(PredX - X)); ' 	    C = (double)(Width2) * sin(alpha);r' 	    D = (double)(Width2) * cos(alpha);d  	    PolyPath[0].pX = PredX + C;  	    PolyPath[0].pY = PredY + D;& 	    PolyPath[0].pSucc = &PolyPath[1]; 	    PolyPath[1].pX = X + C; 	    PolyPath[1].pY = Y + D;& 	    PolyPath[1].pSucc = &PolyPath[2]; 	    PolyPath[2].pX = X - C; 	    PolyPath[2].pY = Y - D;& 	    PolyPath[2].pSucc = &PolyPath[3];  	    PolyPath[3].pX = PredX - C;  	    PolyPath[3].pY = PredY - D; 	    PolyPath[3].pSucc = NULL;0 	    if(Layer == Parameters.kpHighlightingPixel)$ 		ShowPath(Layer,PolyPath,Window,1);	 	    elseE% 		ShowPolygon(Layer,PolyPath,Window);  	    } 	Pair = Pair->pSucc; 	PredX = X;i 	PredY = Y;f 	}     BB.kaLeft = PredX-Width2;t     BB.kaBottom = PredY-Width2;      BB.kaRight = PredX+Width2;     BB.kaTop = PredY+Width2;     ShowBox(Layer,BB,Window);a     }u     Width(LookedAhead)     int *LookedAhead;y     {o     int X,Y;       MenuSelect(MenuWIDTH);3     ShowPrompt("Point twice to show wire width."); L     Point();N     if((Not Parameters.kpPointLayerTable) And Parameters.kpCommand[0] == EOS){& 	if((Not Parameters.kpPointLayerTable)) 	    And Parameters.kpCommand[0] == EOS){  	    X = Cursor.kcX; 	    Y = Cursor.kcY;
 	    Point();u' 	    To45(X,Y,&Cursor.kcX,&Cursor.kcY);e 	    if(Cursor.kcX == X){ 6 		if(LayerTable[Parameters.kpLayer].klMinDimensions >  		    abs(Cursor.kcY-Y))  ; 		    ShowPrompt("Width is less than minimum dimensions."); 3 		else LayerTable[Parameters.kpLayer].klWireWidth ={$ 		    abs(Cursor.kcY-Y)/RESOLUTION;  		}= 	    else {i6 		if(LayerTable[Parameters.kpLayer].klMinDimensions >  		    abs(Cursor.kcX-X)) n; 		    ShowPrompt("Width is less than minimum dimensions.");s3 		else LayerTable[Parameters.kpLayer].klWireWidth =	# 		    abs(Cursor.kcX-X)/RESOLUTION;a 		}r 	    *LookedAhead = False; 	    MenuDeselect(MenuWIDTH);	 	    return; 	    } 	else {e 	    *LookedAhead = True;  	    MenuDeselect(MenuWIDTH);u 	    return; 	    } 	}
     else { 	*LookedAhead = True;a 	MenuDeselect(MenuWIDTH);; 	return; 	}     }i     RemoveLastPointInPath(Path)n     struct p **Path;     {m     struct p *OldPair;     struct p *NewPair;     OldPair = *Path;1     if(OldPair == NULL Or OldPair->pSucc == NULL)p 	return;@     if((NewPair = (struct p *)malloc(sizeof(struct p))) == NULL) 	MallocFailed();     *Path = NewPair;     NewPair->pX = OldPair->pX;       NewPair->pY = OldPair->pY; ,     NewPair->pSucc = NULL;     OldPair = OldPair->pSucc;p"     while(OldPair->pSucc != NULL){D 	if((NewPair->pSucc = (struct p *)malloc(sizeof(struct p))) == NULL) 	    MallocFailed(); 	NewPair = NewPair->pSucc; 	NewPair->pX = OldPair->pX;  	NewPair->pY = OldPair->pY;  	NewPair->pSucc = NULL;, 	OldPair = OldPair->pSucc; 	}     }e     AppendPointToPath(X,Y,Path)c     struct p **Path;     int *X,*Y;     {;     struct p *OldPair;     struct p *NewPair;%     if(Path == NULL || *Path == NULL)] 	return;     OldPair = *Path;@     if((NewPair = (struct p *)malloc(sizeof(struct p))) == NULL) 	MallocFailed();     *Path = NewPair;     NewPair->pX = OldPair->pX;       NewPair->pY = OldPair->pY; o     NewPair->pSucc = NULL;     OldPair = OldPair->pSucc;i     while(OldPair != NULL){LD 	if((NewPair->pSucc = (struct p *)malloc(sizeof(struct p))) == NULL) 	    MallocFailed(); 	NewPair = NewPair->pSucc; 	NewPair->pX = OldPair->pX;  	NewPair->pY = OldPair->pY;  	NewPair->pSucc = NULL;  	OldPair = OldPair->pSucc; 	}(     /* Append the new reference point */     if(Parameters.kp45s)# 	To45(NewPair->pX,NewPair->pY,X,Y);eG     if((NewPair->pSucc = (struct p *)malloc(sizeof(struct p))) == NULL)r 	MallocFailed();     NewPair = NewPair->pSucc;p     NewPair->pX = *X;      NewPair->pY = *Y;      NewPair->pSucc = NULL;     } 