 /*  * xforms.cu  *=  * Copyright -C- 1981 Kenneth H. Keller, Giles C. Billingsleyt$  * sccsid "@(#)xforms.c	1.1  9/5/83"  *D  *     KIC is a graphics editor that was developed by the integrated@  * circuits group of the Electronics Research Laboratory and the@  * Department of Electrical Engineering and Computer Sciences atC  * the University of California, Berkeley, California.  The program-;  * KIC is available free of charge to any interested party. B  * The sale, resale, or use of this program for profit without theF  * express written consent of the Department of Electrical EngineeringI  * and Computer Sciences, University of California, Berkeley, California,   * is forbidden.  */e  e    /*  * Transforms package.  * )  */4   #include "cd.h"i   static struct tt TTransforms;u   TInit(){     TTransforms.ttSP = 0;)     TIdentity();     }e  	 TEmpty(){P     if(TTransforms.ttSP == 0)P 	return(True);     else 	return(False);      }-   TFull(){*     if(TTransforms.ttSP == XFORMSTACKSIZE) 	return(True);     else 	return(False);r     }a   TPush(){     int Int1,Int2;  !     for(Int1 = 0;Int1 < 3;++Int1)  	for(Int2 = 0;Int2 < 2;++Int2)9 	    TTransforms.ttStack[TTransforms.ttSP][Int1][Int2] = y$ 		TTransforms.ttCurrent[Int1][Int2];     ++TTransforms.ttSP;      }s   TPop(){L     int Int1,Int2;       --TTransforms.ttSP; "     for(Int1 = 0;Int1 < 3;++Int1){ 	for(Int2 = 0;Int2 < 2;++Int2){n& 	    TTransforms.ttCurrent[Int1][Int2]6 		= TTransforms.ttStack[TTransforms.ttSP][Int1][Int2]; 	    } 	}     }	  
 TCurrent(TFP)h
     int *TFP;      {D     int i,j;     for(i=0; i<3; ++i){  	for(j=0; j<3; ++j){;             TFP[(3 * i) + j] = TTransforms.ttCurrent[i][j];r 	    } 	}     }    TTranslate(X,Y)a     int X,Y;     {l@     TTransforms.ttCurrent[2][0] = TTransforms.ttCurrent[2][0]+X;@     TTransforms.ttCurrent[2][1] = TTransforms.ttCurrent[2][1]+Y;     }p   TMY(){?     TTransforms.ttCurrent[0][1] = -TTransforms.ttCurrent[0][1];=?     TTransforms.ttCurrent[1][1] = -TTransforms.ttCurrent[1][1];t?     TTransforms.ttCurrent[2][1] = -TTransforms.ttCurrent[2][1];e     }p   TMX(){?     TTransforms.ttCurrent[0][0] = -TTransforms.ttCurrent[0][0];N?     TTransforms.ttCurrent[1][0] = -TTransforms.ttCurrent[1][0]; ?     TTransforms.ttCurrent[2][0] = -TTransforms.ttCurrent[2][0];)     }L   TRotate(XDirection,YDirection)     int XDirection,YDirection;     /*@     Rotation angle is expressed as a CIF-style direction vector.     */     {a
     int Int1;        if(XDirection == 0){ 	if(abs(YDirection) > 1) 	    if(YDirection < 0)  		YDirection = -1;	 	    elsed 		YDirection = 1;} 	}     elif(YDirection == 0){ 	if(abs(XDirection) > 1) 	    if(XDirection < 0)u 		XDirection = -1;	 	    elsed 		XDirection = 1;t 	}+     if(XDirection == 1 And YDirection == 0)2 	/*  	Don't rotate at all.t 	*/k 	return;/     elif(XDirection == 0 And YDirection == -1){  	/*P 	Rotate ccw by 270 degrees.r 	*/;$ 	Int1 = TTransforms.ttCurrent[0][0];; 	TTransforms.ttCurrent[0][0] = TTransforms.ttCurrent[0][1]; % 	TTransforms.ttCurrent[0][1] = -Int1;!$ 	Int1 = TTransforms.ttCurrent[1][0];; 	TTransforms.ttCurrent[1][0] = TTransforms.ttCurrent[1][1];B% 	TTransforms.ttCurrent[1][1] = -Int1;r$ 	Int1 = TTransforms.ttCurrent[2][0];; 	TTransforms.ttCurrent[2][0] = TTransforms.ttCurrent[2][1];Y% 	TTransforms.ttCurrent[2][1] = -Int1;B 	}.     elif(XDirection == 0 And YDirection == 1){ 	/*B 	Rotate ccw by 90 degrees. 	*/T$ 	Int1 = TTransforms.ttCurrent[0][0];< 	TTransforms.ttCurrent[0][0] = -TTransforms.ttCurrent[0][1];$ 	TTransforms.ttCurrent[0][1] = Int1;$ 	Int1 = TTransforms.ttCurrent[1][0];< 	TTransforms.ttCurrent[1][0] = -TTransforms.ttCurrent[1][1];$ 	TTransforms.ttCurrent[1][1] = Int1;$ 	Int1 = TTransforms.ttCurrent[2][0];< 	TTransforms.ttCurrent[2][0] = -TTransforms.ttCurrent[2][1];$ 	TTransforms.ttCurrent[2][1] = Int1; 	}/     elif(XDirection == -1 And YDirection == 0){] 	/*  	Rotate ccw by 180 degrees.p 	*/= 	int Int1,Int2;    	for(Int1 = 0;Int1 < 3;++Int1){l# 	    for(Int2 = 0;Int2 < 2;++Int2){ # 		TTransforms.ttCurrent[Int1][Int2]-+ 		    = -TTransforms.ttCurrent[Int1][Int2];t 		}s 	    } 	}     }	   TIdentity(){@     TTransforms.ttCurrent[0][0] = TTransforms.ttCurrent[1][1] = ! 	TTransforms.ttCurrent[2][2] = 1;t?     TTransforms.ttCurrent[0][1] = TTransforms.ttCurrent[1][0] =n< 	TTransforms.ttCurrent[0][2] = TTransforms.ttCurrent[1][2] =? 	TTransforms.ttCurrent[2][0] = TTransforms.ttCurrent[2][1] = 0;r     }h   TPoint(X,Y)e     int *X,*Y;     /*     Transform the point.     */     {t
     int Int1;t  I     Int1 = *X*TTransforms.ttCurrent[0][0]+*Y*TTransforms.ttCurrent[1][0]+  	TTransforms.ttCurrent[2][0];nG     *Y = *X*TTransforms.ttCurrent[0][1]+*Y*TTransforms.ttCurrent[1][1]+  	TTransforms.ttCurrent[2][1];      *X = Int1;     }r   TPremultiply(){f     /*      Form the instance transform.H     This is done by computing TTransforms.ttCurrent*TTransforms.ttStack[     TTransforms.ttSP-1] andF5     placing the product in TTransforms.ttCurrent.     J     So, the scenario for transforming the coordinates of a master follows.     TPush();     TIdentity();=     Invoke TMX, TTranslate, etc. to build instance transform.b      Form the instance transform.     TPremultiply();i@     Invoke TPoint to transform master points to instance points.     TPop();t     */&     int Int1,Int2,Int3,Int4,Int5,Int6;     int SP;        SP = TTransforms.ttSP-1;E     Int1 = TTransforms.ttCurrent[0][0]*TTransforms.ttStack[SP][0][0]+o; 	TTransforms.ttCurrent[0][1]*TTransforms.ttStack[SP][1][0];rE     Int2 = TTransforms.ttCurrent[0][0]*TTransforms.ttStack[SP][0][1]+T; 	TTransforms.ttCurrent[0][1]*TTransforms.ttStack[SP][1][1];rE     Int3 = TTransforms.ttCurrent[1][0]*TTransforms.ttStack[SP][0][0]+t; 	TTransforms.ttCurrent[1][1]*TTransforms.ttStack[SP][1][0];]E     Int4 = TTransforms.ttCurrent[1][0]*TTransforms.ttStack[SP][0][1]+B; 	TTransforms.ttCurrent[1][1]*TTransforms.ttStack[SP][1][1];RE     Int5 = TTransforms.ttCurrent[2][0]*TTransforms.ttStack[SP][0][0]+T; 	TTransforms.ttCurrent[2][1]*TTransforms.ttStack[SP][1][0]+T 	TTransforms.ttStack[SP][2][0];;E     Int6 = TTransforms.ttCurrent[2][0]*TTransforms.ttStack[SP][0][1]+-; 	TTransforms.ttCurrent[2][1]*TTransforms.ttStack[SP][1][1]+I 	TTransforms.ttStack[SP][2][1];n'     TTransforms.ttCurrent[0][0] = Int1;-'     TTransforms.ttCurrent[0][1] = Int2;s'     TTransforms.ttCurrent[1][0] = Int3;i'     TTransforms.ttCurrent[1][1] = Int4; '     TTransforms.ttCurrent[2][0] = Int5;t'     TTransforms.ttCurrent[2][1] = Int6;I     }   
 TInverse()     /*;     Compute the inverse transform of the current transform. 2     Because all transformations are Manhattan, the;     det of the current transform matrix is always -1 or +1.      */     {u     int detCurrent;n       detCurrent = ] 	TTransforms.ttCurrent[0][0]*n 	TTransforms.ttCurrent[1][1]-[ 	TTransforms.ttCurrent[1][0]*t 	TTransforms.ttCurrent[0][1];1       if(detCurrent == 1)e 	{B 	TTransforms.ttInverseCurrent[0][0] = TTransforms.ttCurrent[1][1];C 	TTransforms.ttInverseCurrent[0][1] = -TTransforms.ttCurrent[0][1];tC 	TTransforms.ttInverseCurrent[1][0] = -TTransforms.ttCurrent[1][0];EB 	TTransforms.ttInverseCurrent[1][1] = TTransforms.ttCurrent[0][0];% 	TTransforms.ttInverseCurrent[2][0] =*! 	    TTransforms.ttCurrent[1][0]*g! 	    TTransforms.ttCurrent[2][1]- ! 	    TTransforms.ttCurrent[2][0]* ! 	    TTransforms.ttCurrent[1][1];)% 	TTransforms.ttInverseCurrent[2][1] =P" 	    -TTransforms.ttCurrent[0][0]*! 	    TTransforms.ttCurrent[2][1]+s! 	    TTransforms.ttCurrent[0][1]*r! 	    TTransforms.ttCurrent[2][0];r 	}     else 	{C 	TTransforms.ttInverseCurrent[0][0] = -TTransforms.ttCurrent[1][1]; B 	TTransforms.ttInverseCurrent[0][1] = TTransforms.ttCurrent[0][1];B 	TTransforms.ttInverseCurrent[1][0] = TTransforms.ttCurrent[1][0];C 	TTransforms.ttInverseCurrent[1][1] = -TTransforms.ttCurrent[0][0];L% 	TTransforms.ttInverseCurrent[2][0] =m" 	    -TTransforms.ttCurrent[1][0]*! 	    TTransforms.ttCurrent[2][1]+I! 	    TTransforms.ttCurrent[2][0]*I! 	    TTransforms.ttCurrent[1][1];[% 	TTransforms.ttInverseCurrent[2][1] = ! 	    TTransforms.ttCurrent[0][0]*n! 	    TTransforms.ttCurrent[2][1]- ! 	    TTransforms.ttCurrent[0][1]*;! 	    TTransforms.ttCurrent[2][0];] 	}(     TTransforms.ttInverseCurrent[0][2] = 	0; (     TTransforms.ttInverseCurrent[1][2] = 	0; (     TTransforms.ttInverseCurrent[2][2] = 	1;r     }0   TInversePoint(X,Y)     int *X,*Y;     /*     Transform the point.     */     {{
     int Int1;m  2     Int1 = *X * TTransforms.ttInverseCurrent[0][0]+ 	 + *Y * TTransforms.ttInverseCurrent[1][0]t' 	 + TTransforms.ttInverseCurrent[2][0];o2     *Y   = *X * TTransforms.ttInverseCurrent[0][1]+ 	 + *Y * TTransforms.ttInverseCurrent[1][1]*' 	 + TTransforms.ttInverseCurrent[2][1];s     *X = Int1;     }r