.TH OCLOCK 1 "Release 5" "X Version 11"
.SH NAME
oclock \- display time of day and moon phase
.SH SYNOPSIS
.B oclock
[-option ...]
.SH DESCRIPTION
.I Clock
simply displays the current time on an analog display
.SH STANDARD OPTIONS
.TP 8
.B \-fg \fIforeground color\fB
choose a different color for the both hands and the jewel of the clock
.TP 8
.B \-bg \fIbackground color\fB
choose a different color for the background.
.TP 8
.B \-jewel \fIjewel color\fB
choose a different color for the jewel on the clock.
.TP 8
.B \-minute \fIminute color\fB
choose a different color for the minute hand of the clock.
.TP 8
.B \-hour \fIhour color\fB
choose a different color for the hour hand of the clock.
.TP 8
.B \-backing \fI{ WhenMapped Always NotUseful }\fB
selects an appropriate level of backing store.
.TP 8
.B \-geometry \fIgeometry\fB
define the initial window geometry; see \fIX(1)\fP.
.TP 8
.B \-display \fIdisplay\fB
specify the display to use; see \fIX(1)\fP.
.TP 8
.B \-bd \fIborder color\fB
choose a different color for the window border.
.TP 8
.B \-bw \fIborder width\fB
choose a different width for the window border.  As the Clock widget changes
its border around quite a bit, this is most usefully set to zero.
.TP 8
.B \-noshape
causes the clock to not reshape itself and ancestors to exactly
fit the outline of the clock.
.TP 8
.B \-transparent
causes the clock to consist only of the jewel, the hands, and the border.
.SH MOON OPTIONS
.TP 8
.B \-moonclock
switch oclock into moonclock mode
.TP 8
.B \-moon \fImoon color\fB
choose a different color for the moon
.TP 8
.B \-sky \fIsky color\fB
choose a different color for the sky
.TP 8
.B \-stars \fIstars color\fB
choose a different color for the "stars"
.TP 8
.B \-night \fInight color\fB
choose a different color for the border and
the sky, when the night has begun.
.TP 8
.B \-nightstart \fI 24h hour
by default the night-colors are set at 6pm (18h). 
you can change this time (early morning hackers might
prefer values between 2 and 4 ?)
.TP 8
.B \-timezone \fI +- 24h hour
you can set another timezone; this is useful, if
there are many clocks on your screen (One oclock
for SFO, another for Germany ?)
.SH NOTES RELATING MOON-MODE
Please see the Copyright-Notices in the moon-related files.
These files are copyed from xphoon.
.B
It is not possible to use oclock in transparent and moonclock mode at the same time.
.SH COLORS
If you would like your clock to be viewable in color, include the following 
in the #ifdef COLOR section you read with xrdb:
.sp 1
*customization:                 -color
.sp 1
.br
This will cause oclock to pick up the colors in the app-defaults color
customization file:
/usr/lib/X11/app-defaults/Clock-color.
Below are the default colors:
.sp 1
Clock*Background: lightsteelblue2
.br
Clock*Foreground: violetred1
.br
Clock*BorderColor: white
.br
Clock*hour: yellow
.br
Clock*jewel: yellow
.br
Clock*minute: yellow
.br
Clock*night: dodgerblue3
.br
Clock*moon: yellow
.br
Clock*sky: dodgerblue1
.br
Clock*stars: white
.SH "SEE ALSO"
X(1), X Toolkit documentation
.SH COPYRIGHT
Copyright 1989, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Keith Packard, MIT X Consortium
.br
moonclock extensions by Gunter Sprenger
.br
gunter@cs.tu-berlin.de

