< (* DELIVER.PAS - General MAIL delivery manager for VMS MAIL.  ;    Written by Ned Freed, 23-Sep-1985, modified 30-Apr-1986. ?    Mail dispatch interface originally written by Kevin Carosso. 6    Some modifications by Sheldon Smith, December 1986.G    Rewrite by Ned Freed to use new $GETUAI system service, 15-Dec-1986. :    This change requires the use of VMS 4.4 and Pascal 3.4.@    Additional changes by Shel Smith and Andy Leslie, 6-Sep-1988.F    Added support for use of SJC$_USER_IDENTIFICATION item code, to getD      around problems with SJC$_USERNAME. Since this item code is notE      documented and may be removed in the future the support for this G      feature is conditional -- the constant use_sjc_user_identification       controls it.   C    DELIVER provides a general-purpose MAIL delivery manager similar @    to the MMDF-II MAILDELIVERY system. DELIVER makes it possibleC    for users to set up a file containing screening information that A    automatically deals with each incoming message. Actions may be B    selectively taken by DELIVER based on information in the From:,1    To: and Subject: fields of the message header.   B    DELIVER operates as a foreign mail interface to VMS MAIL and isF    invoked with a call to LIB$FIND_IMAGE_SYMBOL in MAIL. The shareableI    image containing this code should be placed in SYS$LIBRARY as the file     DELIVER_MAILSHR.EXE).  A    Users may activate DELIVER by setting their forwarding address E    to DELIVER%username, where "username" is the user's own user name. D    In order for DELIVER to perform any useful function a file calledG    MAIL.DELIVERY must be present in the user's default login directory.   K    DELIVER's operation is only meaningful in outgoing mode; however, rather F    than waste a possible incoming MAIL interface, DELIVER implements aK    rudimentary mail posting mechanism on the incoming side that can be used I    to send messages contained in data files. Full privileges are required B    to run DELIVER in this mode since it is possible to forge From:"    addresses using this mechanism.     Note: A     The foreign protocol interface within MAIL is undocumented at @     this time.  It may change without notice in a future release     of VMS.   D     The information necessary to write this code comes from the MAILE     source on the VMS microfiche.  The most useful information is the G     routine NETJOB in module MAIL$MAIL (230-E2), which handles incoming G     foreign mail, and the various routines in module NETSUBS (230-N11), 2     most of which deal with outgoing foreign mail.     Revision history:        PMDF 3.1 release:   :       13-Jul-1989, Ned Freed, Innosoft International, Inc.  L         Changed the batch queue from MAIL$BATCH to DELIVER_BATCH, to make it=         easier to run in a different queue than PMDF runs in.   #         Added support for CC lines.   C         Change DELIVER$STATUS to DELIVER_STATUS, DELIVER$MESSAGE to E         DELIVER_MESSAGE, and change the incoming interface to look at 0         the symbol DELIVER_FROM instead of FROM.  A         Added the K, L, and M actions (all for easier debugging):   4           K - Keep the command file after execution.N           L - Keep the log file after execution -- log file name is parameter.H           M - Keep the message after execution -- same as MESSAGE_DELETE               flag.   9       3-Oct-1989, Ned Freed, Innosoft International, Inc.   H         Added the ability to specify a CC line with a DELIVER_CC symbol.  =       15-Sep-92, Dick Munroe, Doyle, Munroe Consultants, Inc.  	         267 Cox St.  	         Hudson, Ma.  01749 	         munroe@dmc.com  6 	Add the ability to turn debugging on/off dynamically.  ; 		DELIVER_DEBUG_IN    If defined, input debugging is armed. < 		DELIVER_DEBUG_OUT   If defined, output debugging is armed.  D 	There appears to be a problem in MAIL.  If SYSPRV is enabled, thereK         seems to be a bug in MAIL preventing the sharable images from being O         properly invoked.  If BYPASS is asserted, everything works just fine or O         if NO privileges are asserted, everything works just fine.  Note that a N         test for bypass CANNOT be put into IN_CONNECT since that would preventM         the normal delivery mechanism from working properly.  The test is put O         into the generated command file and if BYPASS is not available, MAIL is          not invoked.  B 	The to address must be quoted on forwarding to allow use of other! 	transports as forward addresses.   I 	I believe that setting the "matched" switch for the K, L, and M flags is F 	unreasonable.  These are intended to capture output state and must be8 	present in ways that screw up the rest of the behavior.  <       16-Sep-92 Dick Munroe, Doyle, Munroe Consultants, Inc.  B 	Setting the 'L' flag doesn't actually keep the log.  It now does.  <       16-Nov-92 Dick Munroe, Doyle, Munroe Consultants, Inc. 	 B 	If the command procedure is created without S:RD protection, thenH 	deliver can't execute and delete the command procedure.  Since it can'tF 	hurt to make the command procedure have wide open protections, create, 	the command procedure with all protections.  F 	Allow the forward and privileged forward to have a list of arguments.C 	the logic for quoting the forwarding addresses now takes that into 	 	account.  *)  : [inherit ('SYS$LIBRARY:STARLET')] module deliver (output);   const   2   (* Switch for use of SJC$_USER_IDENTIFICATION *)&   use_sjc_user_identification = false;  K   LNK_C_OUT_CONNECT  = 0;       (* MAIL protocol link actions.           *) K   LNK_C_OUT_SENDER   = 1;       (* These are defined in MAILSHR.MAR      *) K   LNK_C_OUT_CKUSER   = 2;       (* but because we cannot have external   *) K   LNK_C_OUT_TO       = 3;       (* constants in Pascal, they are         *) K   LNK_C_OUT_SUBJ     = 4;       (* redefined here.                       *)    LNK_C_OUT_FILE     = 5;    LNK_C_OUT_CKSEND   = 6;    LNK_C_OUT_DEACCESS = 7;      LNK_C_IN_CONNECT = 8;    LNK_C_IN_SENDER  = 9;    LNK_C_IN_CKUSER  = 10;   LNK_C_IN_TO      = 11;   LNK_C_IN_SUBJ    = 12;   LNK_C_IN_FILE    = 13;     LNK_C_IO_READ  = 14;   LNK_C_IO_WRITE = 15;     LNK_C_IN_CC = 16;    LNK_C_OUT_CC = 17;     LNK_C_IN_ATTRIBS = 18;   LNK_C_OUT_ATTRIBS = 19;   D   parameter_size     = 256;     (* Size of a single parameter in theG                                    MAIL.DELIVERY file. This is also the O                                    maximum size of lines read from any file. *) D   max_parameters     = 7;       (* Maximum number of parameters that<                                    can appear on a line in a8                                    MAIL.DELIVERY file *)D   min_parameters     = 5;       (* Minimum number of parameters that<                                    can appear on a line in a8                                    MAIL.DELIVERY file *)E   from_parameter     = 1;       (* Position of the From: parameter *) C   to_parameter       = 2;       (* Position of the To: parameter *) H   subject_parameter  = 3;       (* Position of the Subject: parameter *)H   decision_parameter = 4;       (* Position of the decision parameter *)F   action_parameter   = 5;       (* Position of the action parameter *)H   argument_parameter = 6;       (* Position of the argument parameter *)  N   stack_size = 10;              (* State mach. stack for messages from MAIL *)  K   DCL_line_size = 256;          (* Maximum possible line allowed by DCL. *)    type,   string = varying [parameter_size] of char;  J   (* A string descriptor type used to handle the descriptors MAIL hands to      DELIVER. *)<   longest_possible_string = packed array [1..65536] of char;   string_descriptor = record1                         length : [word] 0..65535; 6                         dclass, dtype : [byte] 0..255;;                         address : ^longest_possible_string;                        end;  C   (* Storage for a single line of MAIL.DELIVERY file information *) )   parameter_block_ptr = ^parameter_block;    parameter_block = recordH                       parameters  : array [1..max_parameters] of string;8                       next        : parameter_block_ptr;,                       any_from    : boolean;,                       any_to      : boolean;,                       any_subject : boolean;5                     end; (* parameter_block record *)   -   account_name = packed array [1..8] of char; +   user_name = packed array [1..12] of char;    priorities = [byte] 0..255;   I   (* Storage for information about a single recipient. The uic, username, E      account and priority fields are ordered to match the format of a @      SJC$_USER_IDENTIFICATION buffer and cannot be reordered. *)   user_block_ptr = ^user_block;    user_block = record (                  uic         : unsigned;)                  username    : user_name; ,                  account     : account_name;-                  priority    : [byte] 0..255; /                  user_length : [word] 0..65535; &                  directory   : string;3                  rules_list  : parameter_block_ptr; .                  next        : user_block_ptr;4                  copyname    : varying [29] of char;+                end; (* user_block record *)   :   (* Possible reasons why MAIL_IO_WRITE will be called. *)B   write_states = (bad_msg, user_check, delivery_check, error_msg);  B   (* A stack structure to store information about pending calls to      MAIL_IO_WRITE. *)   write_state_stack = record&                         top : integer;F                         store : array [1..stack_size] of write_states;9                       end; (* write_state_check record *)   "   (* Record for VMS item lists. *)   item = record $            len    : [word] 0..65535;$            code   : [word] 0..65535;#            addr   : [long] integer; #            rlen   : [long] integer;           end; (* item record *)   1   file_attribute_block = array [0..1] of integer;    var    (* Debugging control flags *) Q   DEBUG_IN  : boolean := false;				(* Debug messages produced by receive code. *) Q   DEBUG_OUT : boolean := false;				(* Debug messages produced by send code.    *)    =   batch_queue : [static, readonly] string := 'DELIVER_BATCH'; @   system_batch_queue : [static, readonly] string := 'SYS$BATCH';  =   batch_log : [static] string; batch_keep : [static] boolean; d   batch_log_keep : [static] boolean ;			(* True if the log file is to be kept, false otherwise.			*)  C   (* Storage for message header information on the outgoing side *) B   tostring, fromstring, subjectstring, ccstring : [static] string;  <   (* List of active recipients and associated information *)6   user_list, user_list_last : [static] user_block_ptr;%   user_count : [static] integer := 0;       from_owner : [static] boolean;  ?   (* Storage for accumulated To: line for incoming messages. *)      toline : [static] string;   6   (* The state machine for MAIL status information. *)  )   write_recv_states  : write_state_stack;    last_error : integer;   6   (* Error message codes defined in DELIVER_ERR.MSG *))   DELIVER__GOTNOSYSPRV, DELIVER__NOTPRIV, @   DELIVER__CANACCUAF, DELIVER__NOSUCHUSER, DELIVER__NAMETOOLONG,G   DELIVER__NODEFAULTDIR, DELIVER__TOOMANYPARAMS, DELIVER__TOOFEWPARAMS, N   DELIVER__NOMDFILE, DELIVER__MDIGNORED, DELIVER__NORULES, DELIVER__MESREAERR,P   DELIVER__GETFILERR, DELIVER__MESWRTERR, DELIVER__INTSTKOVR, DELIVER__STKEMPTY,=   DELIVER__BADSTKELE, DELIVER__MESOPNERR, DELIVER__MSGWRTERR, G   DELIVER__MSGREAERR, DELIVER__USERNOEXIST : [external, value] integer;   , (* Routine to get job/process information *)   function LIB$GETJPI ( =   item_code : integer; var process_id : unsigned := %immed 0; =   process_name : [readonly] varying [u1] of char := %immed 0; '   var out_value : unsigned := %immed 0; 4   var out_string : varying [u2] of char := %immed 0;9   var out_len : integer := %immed 0) : integer; external;    (* Routine to signal errors *)  D procedure LIB$SIGNAL (%IMMED stat : [list, unsafe] integer); extern;  , (* Routine to read command line arguments *)  6 function CLI$GET_VALUE (name : varying [max1] of char;6   var val : varying [max2] of char) : integer; extern;  " (* Routine to get symbol values *)  7 function LIB$GET_SYMBOL (name : varying [max1] of char; 9   var result : varying [max2] of char) : integer; extern;   " (* Routine to set symbol values *)  7 function LIB$SET_SYMBOL (name : varying [max1] of char; 5   svalue : varying [max2] of char) : integer; extern;   
 [ GLOBAL ]) FUNCTION initializationRoutine: integer ;         {      FUNCTIONAL DESCRIPTION:        G 	This routine is invoked by the LIB$INITIALIZATION process during image C 	startup.  It exists to initialize the debugging log, if necessary.             FORMAL PARAMETERS:          	none             IMPLICIT INPUTS:       2 	Logical names DELIVER_DEBUG_IN, DELIVER_DEBUG_OUT            IMPLICIT OUTPUTS:        < 	debug_in set to TRUE if DELIVER_DEBUG_IN has a translation.> 	debug_out set to TRUE if DELIVER_DEBUG_OUT has a translation.            ROUTINE VALUE:        	%[description_or_none]%            SIDE EFFECTS:         	%[description_or_none]%     }                VAR  	status :	integer; 	translation :	string;  	     BEGIN 
     status := 
 	$trnlnm ( 	    tabnam := 'LNM$FILE_DEV',$ 	    lognam := 'DELIVER_DEBUG_IN') ;]     debug_in := odd(status) ;				(* Write debugging output during input mail processing.			*) 
     status := 
 	$trnlnm ( 	    tabnam := 'LNM$FILE_DEV',$ 	    lognam := 'DELIVER_DEBUG_OUT');`     debug_out := odd(status) ;				(* Write debugging output during oututput mail processing.		*)%     initializationRoutine := status ; C     END;						(* End FUNCTION initializationRoutine: integer ;			*)    J (* create_with_SYSPRV is a Pascal user-action routine for OPEN statements.J    It enables SYSPRV while doing certain OPEN's so we can write files into    user directories. *)    0 function create_with_SYSPRV (var fab : FAB$TYPE;0                              var rab : RAB$TYPE;7                              var fil : text) : integer;  var @   stat : integer; ppriv, priv : [quad] array [0..1] of unsigned;+   xabpro : [volatile] xab$type value zero ;    begin (* create_with_SYSPRV *)(   priv[0] := PRV$M_SYSPRV; priv[1] := 0;N   stat := $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);   if odd (stat) then beginJ     xabpro.xab$b_cod := XAB$C_PRO ;			(* This is a protection XAB.						*)H     xabpro.xab$b_bln := XAB$K_PROLEN ;			(* This is the length.							*)p     xabpro.xab$w_pro := 16#'ff00' ;			(* System and owner get all provileges.  Everyone else can suck rocks!.	*)4     FAB.FAB$L_XAB := (ADDRESS( xabpro ))::unsigned ;     <     FAB.FAB$V_LNM_MODE := PSL$C_EXEC; stat := $CREATE (FAB);.     if odd (stat) then stat := $CONNECT (RAB);   end;-   priv[0] := uand (priv[0], unot (ppriv[0])); -   priv[1] := uand (priv[1], unot (ppriv[1])); 5   $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);    create_with_SYSPRV := stat;  end; (* create_with_SYSPRV *)   H (* open_with_SYSPRV is a Pascal user-action routine for OPEN statements.E    It enables SYSPRV while doing certain OPEN's so we can read system     files. *)  . function open_with_SYSPRV (var fab : FAB$TYPE;.                            var rab : RAB$TYPE;5                            var fil : text) : integer;  var @   stat : integer; ppriv, priv : [quad] array [0..1] of unsigned;   begin (* open_with_SYSPRV *)(   priv[0] := PRV$M_SYSPRV; priv[1] := 0;N   stat := $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);   if odd (stat) then begin:     FAB.FAB$V_LNM_MODE := PSL$C_EXEC; stat := $OPEN (FAB);.     if odd (stat) then stat := $CONNECT (RAB);   end;-   priv[0] := uand (priv[0], unot (ppriv[0])); -   priv[1] := uand (priv[1], unot (ppriv[1])); 5   $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);    open_with_SYSPRV := stat;  end; (* open_with_SYSPRV *)   F (* find_user_directory locates a user in the system authorization fileC    and returns his or her default login directory (which is where a D    MAIL.DELIVERY file must reside). find_user_directory also returnsC    the user's UIC and account since this information will be needed *    for creating the delivery batch job. *)  > function find_user_directory (username : varying [l1] of char;7   var user_directory : string; var user_uic : unsigned;MH   var user_account : account_name; var priority : priorities) : boolean;   varn4   device_with_prefix : packed array [1..16] of char;7   directory_with_prefix : packed array [1..64] of char; /   items : array [1..6] of item; stat : integer;a0   ppriv, priv : [quad] array [0..1] of unsigned;   begin (* find_user_directory *)p<   if DEBUG_OUT then writeln ('find_user_directory called.');   find_user_directory := false;N    if length (username) > 12 then(     LIB$SIGNAL (DELIVER__NAMETOOLONG, 2,:                 username.length, iaddress (username.body))   else begin     with items[1] do beginI       len := 4; code := UAI$_UIC; addr := iaddress (user_uic); rlen := 0;      end; (* with *)t     with items[2] do begin%       len := 8; code := UAI$_ACCOUNT;r1       addr := iaddress (user_account); rlen := 0;a     end; (* with *)t     with items[3] do begin%       len := 16; code := UAI$_DEFDEV;i7       addr := iaddress (device_with_prefix); rlen := 0;      end; (* with *)i     with items[4] do begin%       len := 64; code := UAI$_DEFDIR;i:       addr := iaddress (directory_with_prefix); rlen := 0;     end; (* with *)n     with items[5] do beginI       len := 1; code := UAI$_PRI; addr := iaddress (priority); rlen := 0;L     end; (* with *)      with items[6] do begin0       len := 0; code := 0; addr := 0; rlen := 0;     end; (* with *)u?     (* Enable SYSPRV to check for valid user recipient-name. *)o*     priv[0] := PRV$M_SYSPRV; priv[1] := 0;H     $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);:     stat := $GETUAI (usrnam := username, itmlst := items);>     if DEBUG_OUT then writeln ('  $GETUAI returned status: "',+                                stat, '".');i=     if stat = SS$_NOPRIV then LIB$SIGNAL (DELIVER__CANACCUAF)t$     else if stat = SS$_NOSYSPRV then;       LIB$SIGNAL (DELIVER__GOTNOSYSPRV, 2, username.length,o+                   iaddress (username.body))d     else if not odd (stat) then )       LIB$SIGNAL (DELIVER__NOSUCHUSER, 2,w<                   username.length, iaddress (username.body))     else begin6       user_directory := substr (device_with_prefix, 2,>                                 ord (device_with_prefix[1])) +9                         substr (directory_with_prefix, 2, @                                 ord (directory_with_prefix[1]));:       if DEBUG_OUT then writeln ('  Default directory: "',7                                  user_directory, '".');fE       if DEBUG_OUT then writeln ('  Account: "', user_account, '".'); G       if DEBUG_OUT then writeln ('  UIC: ', hex (user_uic, 8, 8), '.');h*       if length (user_directory) <= 0 then-         LIB$SIGNAL (DELIVER__NODEFAULTDIR, 2,e>                     username.length, iaddress (username.body))'       else find_user_directory := true;o1       (* Disable and reestablish former privs. *)E1       priv[0] := uand (priv[0], unot (ppriv[0]));k1       priv[1] := uand (priv[1], unot (ppriv[1]));O9       $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);      end;   end; end; (* find_user_directory *)  H (* copy_descr_to_string copies a MAIL string (passed by descriptor) into    a Pascal VARYING string. *)    procedure copy_descr_to_string (&   var mail_string : string_descriptor;/   var out_string : string; DEBUG_ON : boolean);f   varn   index : integer;    begin (* copy_descr_to_string *)<   if DEBUG_ON then writeln ('copy_descr_to_string called.');   out_string := '';o/   if mail_string.length > 256 then index := 256 #   else index := mail_string.length;e   for index := 1 to index do;     out_string := out_string + mail_string.address^[index]; D   if DEBUG_ON then writeln ('  String copied: "', out_string, '".'); end; (* copy_descr_to_string *)   I (* copy_string_to_descr copies a Pascal VARYING string into a MAIL string     (passed by descriptor). *)n    procedure copy_string_to_descr (   var in_string : string; ;   var mail_string : string_descriptor; DEBUG_ON : boolean);   4   [asynchronous, unbound, external (LIB$SCOPY_DXDX)]9   function copy_string (var src : varying [max1] of char;n3     var dst : string_descriptor) : integer; extern;o    begin (* copy_string_to_descr *)<   if DEBUG_ON then writeln ('copy_string_to_descr called.');'   copy_string (in_string, mail_string);AC   if DEBUG_ON then writeln ('  String copied: "', in_string, '".');w end; (* copy_string_to_descr *)a  F (* charupper is a simple function to convert characters to upper case.>    The full DEC Multinational Character Set is accomodated. *)  & function charupper (ch : char) : char;   begin (* charupper *)c%   if (ch >= 'a') and (ch <= 'z') then 9     charupper := chr (ord (ch) + (ord ('A') - ord ('a'))) 6   else if (ord (ch) >= 224) and (ord (ch) <= 253) then-     charupper := chr (ord (ch) + (192 - 224))e   else charupper := ch;. end; (* charupper *)  > (* dispose_rules_list disposes of heap storage associated with!    a list of parameter blocks. *)c  D procedure dispose_rules_list (var rules_list : parameter_block_ptr);   vare"   temp_list : parameter_block_ptr;   begin (* dispose_rules_list *)"   while rules_list <> nil do begin<     temp_list := rules_list; rules_list := rules_list^.next;     dispose (temp_list);$   end; (* while rules_list <> nil *) end; (* dispose_rules_list *)e  = (* dispose_user_list disposes of heap storage associated withI!    a list of user name blocks. *)e  = procedure dispose_user_list (var user_list : user_block_ptr);r   varl   temp_list : user_block_ptr;N   begin (* dispose_user_list *)e!   while user_list <> nil do begin*9     temp_list := user_list; user_list := user_list^.next;tD     dispose_rules_list (temp_list^.rules_list); dispose (temp_list);#   end; (* while user_list <> nil *)_ end; (* dispose_user_list *)  D (* read_maildelivery_file reads the contents of a MAIL.DELIVERY file?    and creates a rules_list structure. Any errors are signalledC    by returning FALSE. *)N  2 function read_maildelivery_file (var dfile : text;2   var rules_list : parameter_block_ptr) : boolean;   label    99;_   varA8   current, last : parameter_block_ptr; quoted : boolean;:   pindex, lindex, rindex, lcount : integer; line : string;     procedure addch (ch : char);     label6     88;S     vars     cindex : integer;      begin (* addch *) )     if pindex > max_parameters then begin H       if FROM_OWNER then LIB$SIGNAL (DELIVER__TOOMANYPARAMS, 1, lcount);       goto 99;     end;@     if current = nil then if (ch = '!') or (ch = ';') then begin=       if DEBUG_OUT then writeln ('  Skipping comment line.'); '       lindex := length (line); goto 88;l     end else begin       new (current);       with current^ do beginF         for cindex := 1 to max_parameters do parameters[cindex] := '';         next := nil;       end; (* with current^ *)       rindex := rindex + 1; ;       if DEBUG_OUT then writeln (' Rule #', rindex:0, '.');=       if last = nil then begin/         last := current; rules_list := current;*       end else begin/         last^.next := current; last := current; 
       end;     end;D     current^.parameters[pindex] := current^.parameters[pindex] + ch;   88:    end; (* addch *)  " begin (* read_maildelivery_file *)?   if DEBUG_OUT then writeln ('read_maildelivery_file called.');*<   read_maildelivery_file := false; last := nil; lcount := 0;   rindex := 0;    while not eof (dfile) do begin/     readln (dfile, line); lcount := lcount + 1;eK     if DEBUG_OUT then writeln ('  Line from MAIL.DELIVERY: "', line, '".');o>     pindex := 1; current := nil; lindex := 1; quoted := false;*     while lindex <= length (line) do beginE       if (not quoted) and (line[lindex] in [' ', chr (9)]) then begin ?         if current <> nil then if pindex <= max_parameters then @           if length (current^.parameters[pindex]) > 0 then beginK             if DEBUG_OUT then writeln ('  Parameter #', pindex:0, ' is: "',iJ                                        current^.parameters[pindex], '".');!             pindex := pindex + 1;s           end;/       end else if line[lindex] = '"' then begine&         if length (line) > lindex then,           if line[lindex+1] = '"' then begin1             addch ('"'); lindex := succ (lindex); '           end else quoted := not quoted "         else quoted := not quoted;C       end else if quoted and (pindex > 5) then addch (line[lindex])n,       else addch (charupper (line[lindex]));       lindex := lindex + 1;*     end; (* while not eoln *)a1     if current <> nil then with current^ do begint&       if pindex <= max_parameters then5         if length (parameters[pindex]) > 0 then beginrI           if DEBUG_OUT then writeln ('  Parameter #', pindex:0, ' is: "',k?                                      parameters[pindex], '".');            pindex := pindex + 1;          end;       pindex := pindex - 1; +       if pindex < min_parameters then begin I         if FROM_OWNER then LIB$SIGNAL (DELIVER__TOOFEWPARAMS, 1, lcount);o         goto 99;
       end;=       any_from      := parameters[from_parameter]      = '*'; =       any_to        := parameters[to_parameter]        = '*';[=       any_subject   := parameters[subject_parameter]   = '*'; 1       if parameters[subject_parameter] = '"' thend,         parameters[subject_parameter] := '';     end;   end; (* while not eof *)I   if FROM_OWNER and (rules_list = nil) then LIB$SIGNAL (DELIVER__NORULES)I&   else read_maildelivery_file := true;   99:    close (dfile);! end; (* read_maildelivery_file *)   J (* MAIL_OUT_CONNECT is called by VMS MAIL to initiate a send operation. *)  ; [global] function MAIL_OUT_CONNECT (var context : unsigned;    var link_flag : integer;)   var protocol, node : string_descriptor;c   var log_link_error : integer; #   var file_RAT, file_RFM : integer;    var MAIL$GL_FLAGS : integer;3   var attached_file : string_descriptor) : integer;o   begin (* MAIL_OUT_CONNECT *)H   fromstring := ''; tostring := ''; subjectstring := ''; ccstring := '';   user_list_last := nil;9   if DEBUG_OUT then writeln ('MAIL_OUT_CONNECT called.');	!   MAIL_OUT_CONNECT := SS$_NORMAL;  end; (* MAIL_OUT_CONNECT *)u  F (* MAIL_OUT_LINE is called by VMS MAIL whenever a single line of stuff2    must be delivered to the DELIVER mail relay. *)  8 [global] function MAIL_OUT_LINE (var context : unsigned;   var link_flag : integer;0   var node, line : string_descriptor) : integer;   begin (* MAIL_OUT_LINE *)S6   if DEBUG_OUT then writeln ('MAIL_OUT_LINE called.');   case iaddress (link_flag) of*     (* MAIL is delivering a To: address *)     LNK_C_OUT_TO     : beginM                          if DEBUG_OUT then writeln ('  OUT_TO option used.');lJ                          copy_descr_to_string (line, tostring, DEBUG_OUT);.                        end; (* LNK_C_OUT_TO *),     (* MAIL is delivering a From: address *)     LNK_C_OUT_SENDER : begin*                          if DEBUG_OUT thenA                            writeln ('  OUT_SENDER option used.');rL                          copy_descr_to_string (line, fromstring, DEBUG_OUT);2                        end; (* LNK_C_OUT_SENDER *),     (* MAIL is delivering a Subject: line *)     LNK_C_OUT_SUBJ   : beginO                          if DEBUG_OUT then writeln ('  OUT_SUBJ option used.');DO                          copy_descr_to_string (line, subjectstring, DEBUG_OUT);E0                        end; (* LNK_C_OUT_SUBJ *)'     (* MAIL is delivering a Cc: line *)G     LNK_C_OUT_CC     : beginM                          if DEBUG_OUT then writeln ('  OUT_CC option used.');rJ                          copy_descr_to_string (line, ccstring, DEBUG_OUT);.                        end; (* LNK_C_OUT_CC *)   end; (* case *)y   MAIL_OUT_LINE := SS$_NORMAL; end; (* MAIL_OUT_LINE *)  D (* MAIL_OUT_CHECK is called once with each addressee for the currentB    message and once again after the message body has been sent. *)  " [global] function MAIL_OUT_CHECK (   var context : unsigned;s   var link_flag : integer;.   var protocol, addressee : string_descriptor;,   procedure MAIL$READ_ERROR_TEXT) : integer;   varcD   usernamebuffer, userdirectory : string; userpriority : priorities;F   maildelivery : text; useruic : unsigned; useraccount : account_name;   currenttime : [quad] record:+                          l0, l1 : unsigned;                         end;l   begin (* MAIL_OUT_CHECK *)7   if DEBUG_OUT then writeln ('MAIL_OUT_CHECK called.');[   case iaddress (link_flag) of      (* Check out an addressee *)4     LNK_C_OUT_CKUSER : if (addressee.length = 1) andF                           (addressee.address^[1] = chr (0)) then beginK                          (* The null byte indicates that all the addresseesg5                             have been accomodated. *) N                          if DEBUG_OUT then writeln ('  Terminate user list.');6                          MAIL_OUT_CHECK := SS$_NORMAL;%                        end else beginDM                          if DEBUG_OUT then writeln ('  CKUSER option used.');rI                          copy_descr_to_string (addressee, usernamebuffer, :                                                DEBUG_OUT);*                          if DEBUG_OUT then<                            writeln ('  Checking out user "',:                                     usernamebuffer, '".');D                          if not find_user_directory (usernamebuffer,C                                                      userdirectory,mJ                                                      useruic, useraccount,G                                                      userpriority) then A                            MAIL_OUT_CHECK := DELIVER__USERNOEXISTN#                          else beginnK                            if DEBUG_OUT then writeln ('  Trying to open "',oD                              userdirectory + 'MAIL.DELIVERY', '".');?                            open (file_variable := maildelivery,uN                                  file_name := userdirectory + 'MAIL.DELIVERY',<                                  organization := SEQUENTIAL,5                                  sharing := READONLY,aA                                  user_action := open_with_SYSPRV,zI                                  error := CONTINUE, history := READONLY);]=                            if status (maildelivery) <= 0 then:E                              reset (maildelivery, error := CONTINUE);dB                            if status (maildelivery) > 0 then begin>                              LIB$SIGNAL (DELIVER__NOMDFILE, 2,5                                usernamebuffer.length, ?                                iaddress (usernamebuffer.body));AA                              MAIL_OUT_CHECK := DELIVER__NOMDFILE;_)                            end else begin .                              if DEBUG_OUT thenN                                writeln ('  Adding this user to active list.');:                              user_count := user_count + 1;?                              if user_list_last = nil then begine4                                new (user_list_last);;                                user_list := user_list_last;w+                              end else begine:                                new (user_list_last^.next);F                                user_list_last := user_list_last^.next;!                              end;r:                              with user_list_last^ do beginI                                FROM_OWNER := fromstring = usernamebuffer;pK                                if not read_maildelivery_file (maildelivery,V8                                   rules_list) then begin3                                  if FROM_OWNER thenoC                                    LIB$SIGNAL (DELIVER__MDIGNORED);iA                                  dispose_rules_list (rules_list);]#                                end;:2                                next        := nil;L                                username    := pad (usernamebuffer, ' ', 12);<                                directory   := userdirectory;6                                uic         := useruic;:                                account     := useraccount;;                                priority    := userpriority; D                                user_length := usernamebuffer.length;5                                $GETTIM (currenttime);o4                                copyname := 'MAIL_' +G                                            hex (currenttime.l0, 8, 8) +iG                                            hex (currenttime.l1, 8, 8) + B                                            hex (user_count, 8, 8);0                                if DEBUG_OUT thenK                                  writeln ('  Added user "', usernamebuffer, >                                           '"; file code is "',:                                           copyname, '".');<                              end; (* with user_list_last^ *):                              MAIL_OUT_CHECK := SS$_NORMAL;                            end;                           end;e2                        end; (* LNK_C_OUT_CKUSER *).     (* Check out the message send operation *)     LNK_C_OUT_CKSEND : beginM                          if DEBUG_OUT then writeln ('  CKSEND option used.');e6                          MAIL_OUT_CHECK := SS$_NORMAL;2                        end; (* LNK_C_OUT_CKSEND *)   end; (* case *)4 end; (* MAIL_OUT_CHECK *);  F (* MAIL_OUT_FILE is called when the body of the message is ready to beF    sent. The message is available as a file and must be read from thisF    temporary file using RMS. MAIL_OUT_FILE is where most of the actual@    work DELIVER does takes place. The following steps are taken:  H    (1) The mode of the message file is set to record I/O (MAIL sometimes&        leaves the file in block mode).  D    (2) The list of users to whom messages are being sent is scanned.!        For each user on the list:p  @        (a) A copy of the message is placed in the user's defaultA            directory. The file is created with SYSPRV, so it will !            be owned by that user..  @        (b) The user's rules are scanned and checked for matches.  D        (c) If any of the rules are satisfied, a command file is alsoG            created. This files contains some initial symbol definitionsdG            and then commands to implement each of the user's rules that,G            matched. The command file ends with commands that delete thelC            copy of the message as well as the commmand file itself.   I        (d) A batch job is created to run the command file. Note that this >            means MAIL must be installed with CMKRNL privilege. *)  8 [global] function MAIL_OUT_FILE (var context : unsigned;   var link_flag : integer;#   var protocol : string_descriptor;    var message_RAB : RAB$TYPE; A   [asynchronous, unbound] procedure UTIL$REPORT_ERROR) : integer;)   var P   user_list_scan : user_block_ptr; onehasmatched, match, previous_bio : boolean;=   rules_list_scan : parameter_block_ptr; message_file : text;D;   fromupstring, toupstring, subjectupstring, line : string;    index, lleft, stat : integer;_6   ppriv, priv, iosb : [quad] array [0..1] of unsigned;    items : array [1..10] of item;R   inQuote : BOOLEAN ;					(* True if inside a quoted string, false otherwise.			*)b   quoted : BOOLEAN ;					(* True if a quoted string occurred in this segment of a mail address,	*)# 							(* false otherwise.							*)s<   function STR$MATCH_WILD (candidate : varying [l1] of char;6     pattern : varying [l2] of char) : integer; extern;  9   function STR$UPCASE (var dststr : varying [l1] of char;g9     var srcstr : varying [l2] of char) : integer; extern;;  5   (* function to read a line from the message file *)w  2   function get_line (var line : string) : boolean;     var      stat : integer;t     begin (* get_line *)     get_line := false;2     message_RAB.RAB$L_UBF := iaddress (line.body);,     message_RAB.RAB$W_USZ := parameter_size;&     stat := $GET (RAB := message_RAB);     if odd (stat) then begin+       line.length := message_RAB.RAB$W_RSZ;        get_line := true;oO     end else if stat <> RMS$_EOF then LIB$SIGNAL (DELIVER__MESREAERR, 1, stat);    end; (* get_line *)_  '   procedure put_string (line : string);a     begin (* put_string *)(     if lleft >= length (line) then beginA       write (message_file, line); lleft := lleft - length (line);(     end;   end; (* put_string *)   !   procedure put_char (ch : char);t     begin (* put_char *)     if lleft >= 1 then begin6       write (message_file, ch); lleft := pred (lleft);     end;   end; (* put_char *)s  1   procedure put_symbol (symbol, svalue : string);d     begin (* put_symbol *)0     write (message_file, '$ ', symbol, ' == "');1     lleft := DCL_line_size - 8 - length (symbol);s(     for index := 1 to length (svalue) do3       if svalue[index] = '"' then put_string ('""')c$       else put_char (svalue[index]);3     writeln (message_file, '"', error := CONTINUE);e%     if status (message_file) > 0 then'@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));1     write (message_file, '$ Q', symbol, ' == "');e1     lleft := DCL_line_size - 9 - length (symbol);o(     for index := 1 to length (svalue) do5       if svalue[index] = '"' then put_string ('""""')c$       else put_char (svalue[index]);3     writeln (message_file, '"', error := CONTINUE);a%     if status (message_file) > 0 thenl@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));2     write (message_file, '$ QQ', symbol, ' == "');2     lleft := DCL_line_size - 10 - length (symbol);(     for index := 1 to length (svalue) do9       if svalue[index] = '"' then put_string ('""""""""') $       else put_char (svalue[index]);3     writeln (message_file, '"', error := CONTINUE);c%     if status (message_file) > 0 theno@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));   end; (* put_symbol *)s   begin (* MAIL_OUT_FILE *)u6   if DEBUG_OUT then writeln ('MAIL_OUT_FILE called.');  D   (* Do some fancy footwork with RMS to insure that the file is openC      for sequential access and not block access. MAIL sometimes hastB      this file open in block mode. The only way to change modes isI      to disconnect the RAB, diddle the mode bit and then reconnect it. *)l?   previous_bio := uand (message_RAB.RAB$L_ROP, RAB$M_BIO) <> 0;oB   if DEBUG_OUT then writeln ('  The BIO field of the RAB is set ',+                              previous_bio); #   $DISCONNECT (RAB := message_RAB);eJ   message_RAB.RAB$L_ROP := uand (message_RAB.RAB$L_ROP, unot (RAB$M_BIO));    $CONNECT (RAB := message_RAB);  O   if DEBUG_OUT then writeln (' Creating upper case copies of header strings.');n+   STR$UPCASE (fromupstring,    fromstring);t)   STR$UPCASE (toupstring,      tostring);t.   STR$UPCASE (subjectupstring, subjectstring);O   if DEBUG_OUT then writeln ('  From: "', fromupstring, '", To: "', toupstring,:E                              '", Subject: "', subjectupstring, '".');   9   if DEBUG_OUT then writeln (' Pruning the rules list.');r   user_list_scan := user_list;&   while user_list_scan <> nil do begin+     if DEBUG_OUT then writeln ('  User: "',1O       substr (user_list_scan^.username, 1, user_list_scan^.user_length), '".'); D     if DEBUG_OUT then writeln ('  Create copy of message in file "',9                                user_list_scan^.directory,rD                                user_list_scan^.copyname, '.TEXT".');8     open (file_variable := message_file, history := NEW,C           record_length := parameter_size, record_type := VARIABLE,e2           file_name := user_list_scan^.directory +:                        user_list_scan^.copyname + '.TEXT',?           user_action := create_with_SYSPRV, error := CONTINUE,t&           organization := SEQUENTIAL);>     if status (message_file) <= 0 then rewrite (message_file);%     if status (message_file) > 0 thenu@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));!     $REWIND (RAB := message_RAB);n"     while get_line (line) do begin6       writeln (message_file, line, error := CONTINUE);'       if status (message_file) > 0 theneB         LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));     end; (* while get_line *) ,     close (message_file, error := CONTINUE);%     if status (message_file) > 0 then @       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  A     if DEBUG_OUT then writeln ('  Creating command file named "',n9                                user_list_scan^.directory, C                                user_list_scan^.copyname, '.COM".');n8     open (file_variable := message_file, history := NEW,C           record_length := parameter_size, record_type := VARIABLE,e2           file_name := user_list_scan^.directory +9                        user_list_scan^.copyname + '.COM',t?           user_action := create_with_SYSPRV, error := CONTINUE,m&           organization := SEQUENTIAL);>     if status (message_file) <= 0 then rewrite (message_file);%     if status (message_file) > 0 then @       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  <     writeln (message_file, '$ SET NOON', error := CONTINUE);%     if status (message_file) > 0 thena@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  E     writeln (message_file, '$ DELETE = "DELETE"', error := CONTINUE);m%     if status (message_file) > 0 then @       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  K     writeln (message_file, '$ MESSAGE_DELETE == "YES"', error := CONTINUE);f%     if status (message_file) > 0 thene@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  I     writeln (message_file, '$ MESSAGE_SEND == "YES"', error := CONTINUE);(%     if status (message_file) > 0 theni@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  $     put_symbol ('FROM', fromstring);      put_symbol ('TO', tostring);*     put_symbol ('SUBJECT', subjectstring);      put_symbol ('CC', ccstring);  1     writeln (message_file, '$ MESSAGE_FILE == "',e'              user_list_scan^.directory,rD              user_list_scan^.copyname, '.TEXT"', error := CONTINUE);%     if status (message_file) > 0 thent@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  1     writeln (message_file, '$ COMMAND_FILE == "',c'              user_list_scan^.directory, C              user_list_scan^.copyname, '.COM"', error := CONTINUE);T%     if status (message_file) > 0 thenO@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  F     if DEBUG_OUT then writeln ('  Check this user''s delivery list.');     onehasmatched := false;TI     batch_log := '_NLA0:'; batch_keep := false; batch_log_keep := false ;e2     rules_list_scan := user_list_scan^.rules_list;B     while rules_list_scan <> nil do with rules_list_scan^ do begin;       match := (any_to      or (STR$MATCH_WILD (toupstring,oL                                 parameters[to_parameter]) = STR$_MATCH)) and=                (any_from    or (STR$MATCH_WILD (fromupstring, N                                 parameters[from_parameter]) = STR$_MATCH)) and@                (any_subject or (STR$MATCH_WILD (subjectupstring,N                                 parameters[subject_parameter]) = STR$_MATCH));/       case parameters[decision_parameter][1] of !         'A'      : match := true; "         'X'      : match := false;"         'T', 'Y' : match := match;&         'F', 'N' : match := not match;:         '?', 'O' : match := match and (not onehasmatched);@         'B', 'Q' : match := (not match) and (not onehasmatched);9         'E'      : match := match or (not onehasmatched);p!         otherwise match := false;i       end; (* decision case *)       if match then beginSE         if DEBUG_OUT then writeln (' Rule matched. From: pattern: "',::           parameters[from_parameter], '", To: pattern: "',=           parameters[to_parameter], '", Subject: pattern: "',_C           parameters[subject_parameter], '", Decision character: ',*2           parameters[decision_parameter][1], '.');  ( 	case parameters[action_parameter][1] OF` 	  'K', 'L', 'M' : ;				(* The K, L, and M directives don't have any effect on onehasmatched.	*) 	  otherwise\ 	    onehasmatched := true			(* All other directives cause onehasmatched to become true.		*)! 	end ;						(* End case								*)r 	  l/         case parameters[action_parameter][1] ofL           (* append *)           'A'  : beginG                    writeln (message_file, '$ APPEND ''MESSAGE_FILE'' ',y;                             parameters[argument_parameter],u/                             error := CONTINUE); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));."                  end; (* append *)           (* create, copy *)           'C'  : beginE                    writeln (message_file, '$ COPY ''MESSAGE_FILE'' ',e;                             parameters[argument_parameter],(/                             error := CONTINUE);g4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));;(                  end; (* create, copy *)           (* deliver *)            'D'  : begin_                    write (message_file, '$ IF MESSAGE_SEND THEN MAIL/NOSELF/SUBJECT="(From: '); H                    write (message_file, '''''QFROM'') ''''QSUBJECT''"');@                    write (message_file, ' ''MESSAGE_FILE'' "_');'                    write (message_file, 9                      substr (user_list_scan^.username, 1, ;                              user_list_scan^.user_length)); B                    writeln (message_file, '"', error := CONTINUE);4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); #                  end; (* deliver *)            (* execute *))           'E'  : beginC                    if parameters[argument_parameter][1] <> '$' then .                    write (message_file, '$ ');I                    writeln (message_file, parameters[argument_parameter], /                             error := CONTINUE); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));Y#                  end; (* execute *)o           (* forward *),           'F'  : begin_                    write (message_file, '$ IF MESSAGE_SEND THEN MAIL/NOSELF/SUBJECT="(From: ');VH                    write (message_file, '''''QFROM'') ''''QSUBJECT''"');?                    write (message_file, ' ''MESSAGE_FILE'' ') ;e                      (* L                    ** Write the to address as a quoted string, if necessary.                    *)    		   quoted := false ; 		   inQuote := false ;G 		   LU                    for index := 1 to length (parameters[argument_parameter]) do begin N                      if parameters[argument_parameter][index] = '"' then begin 		       (*Hb 		       ** Emit the outer most quote and note that a quoted string has been seen in this segment. 		       *) ! 		       if not quoted then begin & 		         write (message_file, '"') ; 			 quoted := true ; 		       end ; 		       (*=$ 		       ** Emit the doubling quote. 		       *)s! 		       inQuote := not inQuote ; 1                        write (message_file, '"');  		     end ;  	 		     (* F 		     ** Ignore quoted commas, but when a comma appears terminate the& 		     ** quoted string if one exists.	 		     *)_ 		     t; 		     if (parameters[argument_parameter][index] = ',') andt 		        (not inQuote) and  			quoted then begin$ 		       write (message_file, '"') ; 		       quoted := false ; 		     end ;  C 		     write (message_file, parameters[argument_parameter][index]); !                    end; (* for *)r   		   if quoted then begin D                      writeln (message_file, '"', error := CONTINUE);( 		     if status (message_file) > 0 thenQ                        LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); 	 		   end   		   else beginsC                      writeln (message_file, '', error := CONTINUE); ( 		     if status (message_file) > 0 thenQ                        LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); 
 		   end ;#                  end; (* forward *);           (* keep-command *)$           'K'  : batch_keep := true;           (* log-keep *)           'L'  : begin 		   batch_log_keep := true ;p>                    if parameters[argument_parameter] = '' thenK                      batch_log := user_list_scan^.directory + 'DELIVER.LOG'u@                    else batch_log := user_list_scan^.directory +D                                      parameters[argument_parameter];$                  end; (* log-keep *)           (* message-keep *)           'M'  : beginE                    writeln (message_file, '$ MESSAGE_DELETE == "NO"', /                             error := CONTINUE); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); (                  end; (* message-keep *)           (* quit *)(           'Q'  : rules_list_scan := nil;"           (* privileged-deliver *)           'V'  : begin@ 		   writeln (message_file,'$ PRIV = F$SETPRV("BYPASS,TMPMBX")',/                             error := CONTINUE);U4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));nC                    writeln (message_file, '$ DELIVER_FROM = FROM'); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));i?                    writeln (message_file, '$ DELIVER_CC = CC');e4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));wM                    write (message_file, '$ IF MESSAGE_SEND THEN MAIL/NOSELF', J                     '/PROTOCOL=DELIVER_MAILSHR/SUBJECT="''''QSUBJECT''"');@                    write (message_file, ' ''MESSAGE_FILE'' "_');'                    write (message_file,c9                      substr (user_list_scan^.username, 1, ;                              user_list_scan^.user_length));iB                    writeln (message_file, '"', error := CONTINUE);4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));iC                    writeln (message_file,'$ PRIV = F$SETPRV(PRIV)',e/                             error := CONTINUE);m4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));s.                  end; (* privileged-deliver *)"           (* privileged-forward *)           'W'  : begin@ 		   writeln (message_file,'$ PRIV = F$SETPRV("BYPASS,TMPMBX")',/                             error := CONTINUE); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));nC                    writeln (message_file, '$ DELIVER_FROM = FROM');r4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));t?                    writeln (message_file, '$ DELIVER_CC = CC'); 4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file)); M                    write (message_file, '$ IF MESSAGE_SEND THEN MAIL/NOSELF',dK                      '/PROTOCOL=DELIVER_MAILSHR/SUBJECT="''''QSUBJECT''"');l?                    write (message_file, ' ''MESSAGE_FILE'' ') ;R                      (*vL                    ** Write the to address as a quoted string, if necessary.                    *)    		   quoted := false ; 		   inQuote := false ;r 		   iU                    for index := 1 to length (parameters[argument_parameter]) do beginiN                      if parameters[argument_parameter][index] = '"' then begin 		       (* b 		       ** Emit the outer most quote and note that a quoted string has been seen in this segment. 		       *)_! 		       if not quoted then begin & 		         write (message_file, '"') ; 			 quoted := true ; 		       end ; 		       (*s$ 		       ** Emit the doubling quote. 		       *) ! 		       inQuote := not inQuote ;I1                        write (message_file, '"');  		     end ;  	 		     (* F 		     ** Ignore quoted commas, but when a comma appears terminate the& 		     ** quoted string if one exists.	 		     *)l 		      ; 		     if (parameters[argument_parameter][index] = ',') andi 		        (not inQuote) andr 			quoted then begin$ 		       write (message_file, '"') ; 		       quoted := false ; 		     end ;  C 		     write (message_file, parameters[argument_parameter][index]);r!                    end; (* for *)n   		   if quoted then begin D                      writeln (message_file, '"', error := CONTINUE);( 		     if status (message_file) > 0 thenQ                        LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));"	 		   end   		   else beginaC                      writeln (message_file, '', error := CONTINUE); ( 		     if status (message_file) > 0 thenQ                        LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));l
 		   end ;4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));=C                    writeln (message_file,'$ PRIV = F$SETPRV(PRIV)', /                             error := CONTINUE);)4                    if status (message_file) > 0 thenO                      LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));'.                  end; (* privileged-forward *)           otherwise begin end;         end; (* case *)h=       end; (* add commands to implement this matching rule *)"N       if rules_list_scan <> nil then rules_list_scan := rules_list_scan^.next;     end; (* while *)  #     if not onehasmatched then begin I       if DEBUG_OUT then writeln ('  No rules matched, just deliver it.'); R       write (message_file, '$ IF MESSAGE_SEND THEN MAIL/NOSELF/SUBJECT="(From: ');O       writeln (message_file, '''''QFROM'') ''''QSUBJECT''" ''MESSAGE_FILE'' _',i3                substr (user_list_scan^.username, 1,sH                        user_list_scan^.user_length), error := CONTINUE);'       if status (message_file) > 0 thenRB         LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));     end;  H     if DEBUG_OUT then writeln ('  Finishing up delivery command file.');7     writeln (message_file, '$ IF MESSAGE_DELETE then ', <              'DELETE ''MESSAGE_FILE'';', error := CONTINUE);%     if status (message_file) > 0 thenB@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));:     writeln (message_file, '$ LOGOUT', error := CONTINUE);%     if status (message_file) > 0 thenr@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));,     close (message_file, error := CONTINUE);%     if status (message_file) > 0 then'@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));  :     if DEBUG_OUT then writeln ('  Submitting batch job.');9     priv[0] := PRV$M_CMKRNL + PRV$M_SYSPRV; priv[1] := 0; H     $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);J     line := user_list_scan^.directory + user_list_scan^.copyname + '.COM';     with items[2] do begin6       len := length (batch_queue); code := SJC$_QUEUE;4       addr := iaddress (batch_queue) + 2; rlen := 0;     end; (* with items[2] *)     with items[3] do begin<       len := length (line); code := SJC$_FILE_SPECIFICATION;-       addr := iaddress (line) + 2; rlen := 0;      end; (* with items[3] *)     with items[4] do begin@       len := length (batch_log); code := SJC$_LOG_SPECIFICATION;2       addr := iaddress (batch_log) + 2; rlen := 0;     end; (* with items[4] *)     with items[5] do begin*       len := 0; code := SJC$_NO_LOG_SPOOL;       addr := 0; rlen := 0;a     end; (* with items[5] *)     with items[6] do begin       len := 0;04       if batch_keep then code := SJC$_NO_DELETE_FILE$       else code := SJC$_DELETE_FILE;       addr := 0; rlen := 0;e     end; (* with items[6] *)-     if use_sjc_user_identification then begin;       with items[1] do begin4         len := 25; code := SJC$_USER_IDENTIFICATION;:         addr := iaddress (user_list_scan^.uic); rlen := 0;       end; (* with items[1] *)       with items[7] do begin2         len := 0; code := 0; addr := 0; rlen := 0;       end; (* with items[7] *)     end else begin       with items[1] do beginB         len := user_list_scan^.user_length; code := SJC$_USERNAME;?         addr := iaddress (user_list_scan^.username); rlen := 0;c       end; (* with items[1] *)       with items[7] do begin#         len := 4; code := SJC$_UIC;n:         addr := iaddress (user_list_scan^.uic); rlen := 0;       end; (* with items[7] *)       with items[8] do begin,         len := 8; code := SJC$_ACCOUNT_NAME;>         addr := iaddress (user_list_scan^.account); rlen := 0;       end; (* with items[8] *)       with items[9] do       begin 
 	len := 0;2 	if batch_log_keep then code := SJC$_NO_LOG_DELETE 	else code := SJC$_LOG_DELETE; 	addr := 0 ; 	rlen := 0 ;       end ; (* with items[9] *)e       with items[10] do beginO2         len := 0; code := 0; addr := 0; rlen := 0;       end; (* with items[10] *)R     end;3     if DEBUG_OUT then writeln ('    Opening job.');EN     stat := $SNDJBCW (func := SJC$_ENTER_FILE, itmlst := items, iosb := iosb);9     if (not odd (stat)) or (not odd (iosb[0])) then beginl       with items[2] do begin+         len := length (system_batch_queue);N2         addr := iaddress (system_batch_queue) + 2;
       end;P       stat := $SNDJBCW (func := SJC$_ENTER_FILE, itmlst := items, iosb := iosb);     end;-     if not odd (stat) then LIB$SIGNAL (stat);a3     if not odd (iosb[0]) then LIB$SIGNAL (iosb[0]);E/     priv[0] := uand (priv[0], unot (ppriv[0]));u/     priv[1] := uand (priv[1], unot (ppriv[1]));T7     $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);;+     user_list_scan := user_list_scan^.next;t   end; (* while *)6   (* Turn the BIO bit back on if it was set before. *)   if previous_bio then begin%     $DISCONNECT (RAB := message_RAB);OD     message_RAB.RAB$L_ROP := uor (message_RAB.RAB$L_ROP, RAB$M_BIO);"     $CONNECT (RAB := message_RAB);   end;   MAIL_OUT_FILE := SS$_NORMAL; end; (* MAIL_OUT_FILE *)  J (* MAIL_OUT_DEACCESS is called to shut down the current send operation. *)  < [global] function MAIL_OUT_DEACCESS (var context : unsigned;%   var link_flag : integer) : integer;R   begin (* MAIL_OUT_DEACCESS *) :   if DEBUG_OUT then writeln ('MAIL_OUT_DEACCESS called.');    if user_list <> nil then beginM     if DEBUG_OUT then writeln ('  Deleting user list and associated rules.');s"     dispose_user_list (user_list);   end;"   MAIL_OUT_DEACCESS := SS$_NORMAL; end; (* MAIL_OUT_DEACCESS *)  K (* MAIL_OUT_ATTRIBS delivers the message file's attributes to DELIVER. This L    information is currently unused (see comment in MAIL_IN_ATTRIBS below. *)  ; [global] function MAIL_OUT_ATTRIBS (var context : unsigned; 6   var link_flag : integer; var system_flags : integer;.   var idtld : file_attribute_block) : integer;   begin (* MAIL_OUT_ATTRIBS *)9   if DEBUG_OUT then writeln ('MAIL_OUT_ATTRIBS called.');p!   MAIL_OUT_ATTRIBS := SS$_NORMAL;a end; (* MAIL_OUT_ATTRIBS *)t  O (* These routines manipulate a stack in which we maintain state information for F    information being "written" to us when MAIL calls MAIL_IO_WRITE. *)  5 procedure init_stack (var stack : write_state_stack);h   begin (* init_stack *)2   if DEBUG_IN then writeln ('INIT_STACK called.');   stack.top := 0;: end; (* init_stack *)a  E procedure push (var stack : write_state_stack; state : write_states);    var    i : integer;   begin (* push *),   if DEBUG_IN then writeln ('PUSH called.');   with stack do begin      top := succ (top);=     if top > stack_size then LIB$SIGNAL (DELIVER__INTSTKOVR);"     store[top] := state;   end; (* with *)s   if DEBUG_IN then begin     writeln ('  after PUSH:');D     for i := stack.top downto 1 do writeln ('    ', stack.store[i]);   end; end; (* push *)   . procedure pop (var stack : write_state_stack);   vara   i : integer;   begin (* pop *)o+   if DEBUG_IN then writeln ('POP called.');    with stack do begino     top := pred (top);3     if top < 1 then LIB$SIGNAL (DELIVER__STKEMPTY);    end; (* with *)r   if DEBUG_IN then begin     writeln ('  after POP:'); D     for i := stack.top downto 1 do writeln ('    ', stack.store[i]);   end; end; (* pop *)  E function top_of_stack (var stack : write_state_stack) : write_states;    begin (* top_of_stack *)4   if DEBUG_IN then writeln ('TOP_OF_STACK called.');)   top_of_stack := stack.store[stack.top];LC   if DEBUG_IN then writeln (' returning ', stack.store[stack.top]);* end; (* top_of_stack *)c  I (* The incoming mail handling routines are activated by a command line ofi    the form:  M    $ MAIL/PROTOCOL=DELIVER_MAILSHR/SUBJECT="subject" message.txt address-list   H    Everything is specified on the command line except the From: address,E    which is obtained by getting the value of the symbol DELIVER_FROM.E  H    BYPASS privilege is required to use this interface since this routine4    makes it possible to "forge" return addresses. *)  : [global] function MAIL_IN_CONNECT (var context : unsigned;   var link_flag : integer;%   var input_tran : string_descriptor;g#   var file_RAT, file_RFM : integer;'!   var MAIL$GL_SYSFLAGS : integer;g*   var MAIL$Q_PROTOCOL : string_descriptor;"   var pflags : integer) : integer;   var 9   priv : [quad] array [0..1] of unsigned; stat : integer;    begin (* MAIL_IN_CONNECT *)^7   if DEBUG_IN then writeln ('MAIL_IN_CONNECT called.');e   priv[0] := 0; priv[1] := 0; 6   stat := LIB$GETJPI (JPI$_PROCPRIV, , , priv[0], , );+   if not odd (stat) then LIB$SIGNAL (stat);,0   if uand (priv[0], PRV$M_BYPASS) = 0 then begin"     LIB$SIGNAL (DELIVER__NOTPRIV);(     MAIL_IN_CONNECT := DELIVER__NOTPRIV;   end else begin     toline := '';e;     if DEBUG_IN then writeln ('Initializing state stack.'); #     init_stack (write_recv_states);e&     push (write_recv_states, bad_msg);4     LIB$SET_SYMBOL ('DELIVER_STATUS', '%X00000001');"     MAIL_IN_CONNECT := SS$_NORMAL;   end; end; (* MAIL_IN_CONNECT *)  J (* MAIL calls MAIL_IN_LINE to get single line information from DELIVER. *)  7 [global] function MAIL_IN_LINE (var context : unsigned;    var link_flag : integer;*   var line : string_descriptor) : integer;   var &   linebuffer : string; stat : integer;   begin (* MAIL_IN_LINE *)4   if DEBUG_IN then writeln ('MAIL_IN_LINE called.');   case iaddress (link_flag) of*     (* Return From: information to MAIL *)     LNK_C_IN_SENDER : begin L                         if DEBUG_IN then writeln ('IN_SENDER option used.');L                         stat := LIB$GET_SYMBOL ('DELIVER_FROM', linebuffer);O                         if not odd (stat) then linebuffer := '<not specified>'; M 		        if DEBUG_IN then writeln ('LIB$GET_SYMBOL status = ',HEX( stat )) ;	J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);1                        end; (* LNK_C_IN_SENDER *) (     (* Return To: information to MAIL *)     LNK_C_IN_CKUSER : begin:L                         if DEBUG_IN then writeln ('IN_CKUSER option used.');E                         stat := CLI$GET_VALUE ('TOLIST', linebuffer); O                         if not odd (stat) then linebuffer := chr (0) else begin M                           if length (toline) > 0 then toline := toline + ',';e8                           toline := toline + linebuffer;?                           push (write_recv_states, user_check);	                         end;J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);0                       end; (* LNK_C_IN_CKUSER *)(     (* Return entire To: line to MAIL *)     LNK_C_IN_TO     : begineH                         if DEBUG_IN then writeln ('IN_TO option used.');F                         copy_string_to_descr (toline, line, DEBUG_IN);-                        end; (* LNK_C_IN_TO *)g-     (* Return entire Subject: line to MAIL *)      LNK_C_IN_SUBJ   : begingJ                         if DEBUG_IN then writeln ('IN_SUBJ option used.');F                         stat := CLI$GET_VALUE ('SUBJECT', linebuffer);@                         if not odd (stat) then linebuffer := '';J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);/                        end; (* LNK_C_IN_SUBJ *)l(     (* Return entire Cc: line to MAIL *)     LNK_C_IN_CC     : begin]H                         if DEBUG_IN then writeln ('IN_CC option used.');J                         stat := LIB$GET_SYMBOL ('DELIVER_CC', linebuffer);@                         if not odd (stat) then linebuffer := '';M 		        if DEBUG_IN then writeln ('LIB$GET_SYMBOL status = ',HEX( stat )) ; J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);/                        end; (* LNK_C_IN_SUBJ *)o   end; (* case *)    MAIL_IN_LINE := SS$_NORMAL;s end; (* MAIL_IN_LINE *)   G (* MAIL_IN_FILE is called by MAIL to read the body of the message to be J    delivered. This routine gets the file name from the command line, opens;    the file and copies it into MAIL's intermediate file. *)   7 [global] function MAIL_IN_FILE (var context : unsigned;R   var link_flag : integer;   var scratch : integer;   var RAB : RAB$TYPE;U,   procedure UTIL$REPORT_IO_ERROR) : integer;   var E   filename, linebuffer : string; message_file : text; stat : integer;e   begin (* MAIL_IN_FILE *)4   if DEBUG_IN then writeln ('MAIL_IN_FILE called.');H   (* Get the name of the file containing the message to be delivered. *)+   stat := CLI$GET_VALUE ('FILE', filename);s   if not odd (stat) then begin-     LIB$SIGNAL (DELIVER__GETFILERR, 1, stat);C'     MAIL_IN_FILE := DELIVER__GETFILERR;g   end else begin?     open (file_variable := message_file, file_name := filename,e:           organization := SEQUENTIAL, sharing := READONLY,2           error := CONTINUE, history := READONLY);&     if status (message_file) <= 0 then.       reset (message_file, error := CONTINUE);+     if status (message_file) > 0 then begin &       LIB$SIGNAL (DELIVER__MESOPNERR);)       MAIL_IN_FILE := DELIVER__MESOPNERR;n     end else begin1       RAB.RAB$L_RBF := iaddress (linebuffer) + 2;        stat := SS$_NORMAL;(>       while (not eof (message_file)) and (odd (stat)) do begin=         readln (message_file, linebuffer, error := CONTINUE);D/         if status (message_file) > 0 then begin D           LIB$SIGNAL (DELIVER__MSGREAERR, 1, status (message_file));%           stat := DELIVER__MSGREAERR;I         end else begin/           RAB.RAB$W_RSZ := length (linebuffer); $           stat := $PUT (RAB := RAB);J           if not odd (stat) then LIB$SIGNAL (DELIVER__MSGWRTERR, 1, stat);         end;       end; (* while *).       close (message_file, error := CONTINUE);       MAIL_IN_FILE := stat;S     end;   end;+   push (write_recv_states, delivery_check);  end; (* MAIL_IN_FILE *)t  N (* MAIL_IN_ATTRIBS is called to get file attributes for the message file. ThisJ    routine is currently unused. It is not possible to add support for fileI    attributes to DELIVER at this time (VMS 5.0-2) because this routine is H    *never* called for foreign protocols. See the code in the accept_linkK    routine in MAIL$SERVER_SUBS -- the only way that the SERV_FORRECV bit in H    MAIL$L_SRVFLAGS can be set is by a MAIL-11 transaction. This bit thenN    determines if LNK_C_IN_ATTRIBS is used and MAIL_IN_ATTRIBS is called by theL    mail_server routine in MAIL$SERVER_MAIN. Until this code is expanded uponM    (or if we are willing to patch the MAIL image) it will not be possible foriK    DELIVER to handle file attributes and the things they apply to like DDIF     files. *)  : [global] function MAIL_IN_ATTRIBS (var context : unsigned;G   var link_flag : integer; var idtld : file_attribute_block) : integer;    begin (* MAIL_IN_ATTRIBS *)x7   if DEBUG_IN then writeln ('MAIL_IN_ATTRIBS called.');i    MAIL_IN_ATTRIBS := SS$_NORMAL; end; (* MAIL_IN_ATTRIBS *)  H (* MAIL_IO_WRITE is called by MAIL to tell DELIVER what it thinks of the8    results returned by the various MAIL_IN_ routines. *)  8 [global] function MAIL_IO_WRITE (var context : unsigned;   var link_flag : integer;&   line : string_descriptor) : integer;   var    error_text : string;  E   function string_to_integer (var str : string_descriptor) : integer;      var 6     number : packed array [1..4] of char; i : integer;     begin (* string_to_integer *)o=     if str.length <> 4 then string_to_integer := 0 else begins6       for i := 1 to 4 do number[i] := str.address^[i];-       string_to_integer := number :: integer;i     end;   end; (* string_to_integer *)   begin (* MAIL_IO_WRITE *)e5   if DEBUG_IN then writeln ('MAIL_IO_WRITE called.');e*   case top_of_stack (write_recv_states) of     delivery_check : beginD                        if DEBUG_IN then writeln ('Delivery check.');>                        last_error := string_to_integer (line);O                        if DEBUG_IN then writeln (' got a stat : ', last_error);A/                        pop (write_recv_states);"3                        if not odd (last_error) thenw:                          LIB$SET_SYMBOL ('DELIVER_STATUS',H                                          '%X' + hex (last_error, 8, 8));7                        if last_error <> SS$_NORMAL then =                          push (write_recv_states, error_msg); .                      end; (* delivery_check *)     user_check :     begin@                        if DEBUG_IN then writeln ('User check.');>                        last_error := string_to_integer (line);O                        if DEBUG_IN then writeln (' got a stat : ', last_error);T/                        pop (write_recv_states); 3                        if not odd (last_error) thene:                          LIB$SET_SYMBOL ('DELIVER_STATUS',H                                          '%X' + hex (last_error, 8, 8));7                        if last_error <> SS$_NORMAL then =                          push (write_recv_states, error_msg);G*                      end; (* user_check *)     error_msg :      begin@                        if DEBUG_IN then writeln ('Error text.');L                        if (line.length = 1) and (line.address^[1] = chr (0))!                        then beginu)                          if DEBUG_IN then P                            writeln (' got a NULL -- popping write_recv_states');%                        end else begin(K                          copy_descr_to_string (line, error_text, DEBUG_IN);t)                          if DEBUG_IN thennI                            writeln ('Error message: "', error_text, '"'); 5                          if not odd (last_error) then J                            LIB$SET_SYMBOL ('DELIVER_MESSAGE', error_text);                        end; /                        pop (write_recv_states);O*                      end; (* error_text *)     bad_msg :        beginH                        if DEBUG_IN then writeln ('Unexpected message.');>                        last_error := string_to_integer (line);'                        if DEBUG_IN thenmE                          writeln (' UNEXPECTED stat : ', last_error);b;                        push (write_recv_states, error_msg);0'                      end; (* bad_msg *)r.     otherwise LIB$SIGNAL (DELIVER__BADSTKELE);   end; (* case *)e   MAIL_IO_WRITE := SS$_NORMAL; end; (* MAIL_IO_WRITE *)  7 [global] function MAIL_IO_READ (var context : unsigned;C   var link_flag : integer;3   var returned_line : string_descriptor) : integer;i   begin (* MAIL_IO_READ *)4   if DEBUG_IN then writeln ('MAIL_IO_READ called.');   MAIL_IO_READ := SS$_NORMAL;: end; (* MAIL_IO_READ *)e   (* End of DELIVER.PAS *) end.