 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             DDDD   IIIII  SSSSS  PPPP   L       AAA   Y   Y                 % O %             D   D    I    SS     P   P  L      A   A   Y Y                  % O %             D   D    I     SSS   PPPP   L      AAAAA    Y                   % O %             D   D    I       SS  P      L      A   A    Y                   % O %             DDDD   IIIII  SSSSS  P      LLLLL  A   A    Y                   % O %                                                                             % O %                                                                             % O %          Display Machine Independent File Format Image via X11.             % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Display is a machine architecture independent image processing G %  and display program.  It can display any image in the MIFF format on C %  any workstation display running X.  Display first determines the E %  hardware capabilities of the workstation.  If the number of unique J %  colors in the image is less than or equal to the number the workstationE %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Display program command syntax is:  % > %  Usage: display [options ...] file [ [options ...] file ...] %  %  Where options include: < %    -backdrop          display image centered on a backdrop= %    -border geometry   surround image with a border of color ) %    -colormap type     Shared or Private ? %    -colors value      preferred number of colors in the image G %    -colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV 5 %    -comment string    annotate image with comment", / %    -compress type     RunlengthEncoded or Zip < %    -contrast          enhance or reduce the image contrastH %    -crop geometry     preferred size and location of the cropped image< %    -delay seconds     display the next image after pausingD %    -density geometry  vertical and horizontal density of the image; %    -despeckle         reduce the speckles within an image 6 %    -display server    display image to this X serverF %    -dither            apply Floyd/Steinberg error diffusion to imageC %    -edge factor       apply a filter to detect edges in the image G %    -enhance           apply a digital filter to enhance a noisy image B %    -equalize          perform histogram equalization to an image< %    -flip              flip image in the vertical direction> %    -flop              flop image in the horizontal direction@ %    -frame geometry    surround image with an ornamental border1 %    -gamma value       level of gamma correction G %    -geometry geometry preferred size and location of the Image window : %    -immutable         displayed image cannot be modified, %    -interlace type    NONE, LINE, or PLANE2 %    -label name        assign a label to an imageB %    -map type          display image using this Standard Colormap@ %    -matte             store matte channel if the image has one@ %    -modulate value    vary the brightness, saturation, and hue: %    -monochrome        transform image to black and white6 %    -negate            apply color inversion to imageI %    -noise             reduce noise with a noise peak elimination filter L %    -normalize         transform image to span the full the range of colors: %    -opaque color      change this color to the pen color@ %    -page geometry     size and location of the Postscript page, %    -quality value     JPEG quality settingI %    -raise value       lighten/darken image edges to create a 3-D effect @ %    -roll geometry     roll an image vertically or horizontally9 %    -rotate degrees    apply Paeth rotation to the image 7 %    -sample geometry   scale image with pixel sampling * %    -scene value       image scene number( %    -segment value     segment an image; %    -sharpen factor    apply a filter to sharpen the image I %    -shear geometry    slide one edge of the image along the X or Y axis 1 %    -size geometry     width and height of image @ %    -spread amount     displace image pixels by a random amount; %    -swirl degrees     swirl image pixels about the center I %    -texture filename  name of texture to tile onto the image background > %    -treedepth value   depth of the color classification treeH %    -update seconds    detect when image file is modified and redisplayB %    -verbose           print detailed information about the image< %    -visual type       display image using this visual typeB %    -window id         display image to background of this windowE %    -window_group id   exit program when this window id is destroyed - %    -write filename    write image to a file  % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, I %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor, 0 %  -name, -shared_memory, -usePixmap, or -title. % D %  Change '-' to '+' in any option above to reverse its effect.  ForH %  example, specify +matte to store the image without its matte channel. % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 2 %    1    press to map or unmap the Command widget8 %    2    press and drag to magnify a region of an image> %    3    press to load an image from a visual image directory %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "display.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Function Usage displays the program command syntax. % & %  The format of the Usage routine is: %  %      Usage(terminate)  % + %  A description of each parameter follows:  % J %    o terminate: A value other than zero is returned if the program is to %      terminate immediately.  %  */) static void Usage(unsigned int terminate)  {    char     **p;  
   static char      *buttons[]=      { 6       "1    press to map or unmap the Command widget",<       "2    press and drag to magnify a region of an image",B       "3    press to load an image from a visual image directory",       (char *) NULL      },     *options[]=      { @       "-backdrop          display image centered on a backdrop",A       "-border geometry   surround image with a border of color", -       "-colormap type     Shared or Private", C       "-colors value      preferred number of colors in the image", K       "-colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV", 7       "-comment string    annotate image with comment", 3       "-compress type     RunlengthEncoded or Zip", @       "-contrast          enhance or reduce the image contrast",L       "-crop geometry     preferred size and location of the cropped image",@       "-delay seconds     display the next image after pausing",H       "-density geometry  vertical and horizontal density of the image",?       "-despeckle         reduce the speckles within an image", :       "-display server    display image to this X server",J       "-dither            apply Floyd/Steinberg error diffusion to image",G       "-edge factor       apply a filter to detect edges in the image", K       "-enhance           apply a digital filter to enhance a noisy image", F       "-equalize          perform histogram equalization to an image",@       "-flip              flip image in the vertical direction",B       "-flop              flop image in the horizontal direction",D       "-frame geometry    surround image with an ornamental border",5       "-gamma value       level of gamma correction", K       "-geometry geometry preferred size and location of the Image window", >       "-immutable         displayed image cannot be modified",0       "-interlace type    NONE, LINE, or PLANE",6       "-label name        assign a label to an image",F       "-map type          display image using this Standard Colormap",D       "-matte             store matte channel if the image has one",D       "-modulate value    vary the brightness, saturation, and hue",>       "-monochrome        transform image to black and white",:       "-negate            apply color inversion to image",M       "-noise             reduce noise with a noise peak elimination filter", L       "-normalize         transform image to span the full range of colors",>       "-opaque color      change this color to the pen color",D       "-page geometry     size and location of the Postscript page",0       "-quality value     JPEG quality setting",M       "-raise value       lighten/darken image edges to create a 3-D effect", D       "-roll geometry     roll an image vertically or horizontally",=       "-rotate degrees    apply Paeth rotation to the image", .       "-scene value       image scene number",,       "-segment value     segment an image",;       "-sample geometry   scale image with pixel sampling", ?       "-sharpen factor    apply a filter to sharpen the image", M       "-shear geometry    slide one edge of the image along the X or Y axis", 5       "-size geometry     width and height of image", D       "-spread amount     displace image pixels by a random amount",?       "-swirl degrees     swirl image pixels about the center", M       "-texture filename  name of texture to tile onto the image background", B       "-treedepth value   depth of the color classification tree",L       "-update seconds    detect when image file is modified and redisplay",F       "-verbose           print detailed information about the image",@       "-visual type       display image using this visual type",F       "-window id         display image to background of this window",I       "-window_group id   exit program when this window id is destroyed", 1       "-write filename    write image to a file",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version);    (void) printf(N     "Usage: %s [-options ...] file [ [-options ...] file ...]\n",client_name);/   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) printf(H     "resources as command line options:  -background, -bordercolor,\n");   (void) printf(P     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor,\n");   (void) printf(7     "-name, -shared_memory, -usePixmap, or -title.\n");    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(M     "example, specify +matte to store the image without a matte channel.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); !   (void) printf("\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    if (terminate)     exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e E d i t I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XAnnotateEditImage annotates the image with text.  % 3 %  The format of the XAnnotateEditImage routine is:  % < %    XAnnotateEditImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */8 static unsigned int XAnnotateEditImage(Display *display,>   XResourceInfo *resource_info,XWindows *windows,Image *image) {  #define AnnotateModeNameOp  0 " #define AnnotateModeFontColorOp  1( #define AnnotateModeBackgroundColorOp  2 #define AnnotateModeRotateOp  3  #define AnnotateModeHelpOp  4   #define AnnotateModeDismissOp  5 #define TextModeHelpOp  0  #define TextModeDismissOp  1  
   static char      *AnnotateModeMenu[]=     {        "Font Name",       "Font Color",        "Box Color",       "Rotate Text",
       "Help",        "Dismiss",       (char *) NULL      },     *TextModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      };     char      *ColorMenu[MaxNumberPens+1],     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      GC     annotate_context;      int      id,      pen_number,      x,     y;     KeySym     key_symbol;      register char      *p;      register int     i;     static double      degrees = 0.0;     static unsigned int      box_id = MaxNumberPens-2,      font_id = 0,     pen_id = 0,      transparent_box = True,      transparent_pen = False;     unsigned int     height,      status, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XAnnotateInfo      *annotate_info,      *previous_info;      XColor
     color;  
   XFontStruct      *font_info;      XEvent
     event,     text_event;      /*     Map Command widget.    */#   windows->command.name="Annotate";    windows->command.data=4;J   (void) XCommandWidget(display,windows,AnnotateModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { "           case AnnotateModeNameOp:           {              char(               *FontMenu[MaxNumberFonts];               int                font_number;               /*)               Initialize menu selections.              */.             for (i=0; i < MaxNumberFonts; i++)6               FontMenu[i]=resource_info->font_name[i];4             FontMenu[MaxNumberFonts-2]="Browser...";5             FontMenu[MaxNumberFonts-1]=(char *) NULL;              /*6               Select a font name from the pop-up menu.             */I             font_number=XMenuWidget(display,windows,AnnotateModeMenu[id],                 FontMenu,command);              if (font_number < 0)               break;2             if (font_number == (MaxNumberFonts-2))               {                  static char 3                   font_name[MaxTextLength]="fixed";                    /*4                   Select a font name from a browser.                 */@                 resource_info->font_name[font_number]=font_name;G                 XFontBrowserWidget(display,windows,"Select",font_name); '                 if (*font_name == '\0')                    break;               }              /*#               Initialize font info.              */             font_info=L               XLoadQueryFont(display,resource_info->font_name[font_number]);2             if (font_info == (XFontStruct *) NULL)               { E                 XNoticeWidget(display,windows,"Unable to load font:", 9                   resource_info->font_name[font_number]);                  break;               }               font_id=font_number;)             XFreeFont(display,font_info);              break;           } '           case AnnotateModeFontColorOp:            {              /*)               Initialize menu selections.              */1             for (i=0; i < (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */H             pen_number=XMenuWidget(display,windows,AnnotateModeMenu[id],!               ColorMenu,command);              if (pen_number < 0)                break;<             transparent_pen=pen_number == (MaxNumberPens-2);              if (transparent_pen)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextLength] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } -           case AnnotateModeBackgroundColorOp:            {              /*)               Initialize menu selections.              */1             for (i=0; i < (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */H             pen_number=XMenuWidget(display,windows,AnnotateModeMenu[id],!               ColorMenu,command);              if (pen_number < 0)                break;<             transparent_box=pen_number == (MaxNumberPens-2);              if (transparent_box)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextLength] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             box_id=pen_number;             break;           } $           case AnnotateModeRotateOp:           {              int                entry;               static char ,               angle[MaxTextLength] = "30.0",               *RotateMenu[]=               {                  "-90",                 "-45",                 "-30",                 "0",                 "30",                  "45",                  "90",                  "180",                 (char *) NULL,                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */&             RotateMenu[8]="Dialog...";N             entry=XMenuWidget(display,windows,AnnotateModeMenu[id],RotateMenu,               command);              if (entry < 0)               break;             if (entry != 8)                { 0                 degrees=atof(RotateMenu[entry]);                 break;               } N             (void) XDialogWidget(display,windows,"OK","Enter rotation angle:",               angle);              if (*angle == '\0')                break;              degrees=atof(angle);             break;           } "           case AnnotateModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           } %           case AnnotateModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 6         if (event.xbutton.window != windows->image.id)           break;
         /*'           Change to text entering mode. 
         */         x=event.xbutton.x;         y=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*0     Set font info and check boundary conditions.   */F   font_info=XLoadQueryFont(display,resource_info->font_name[font_id]);(   if (font_info == (XFontStruct *) NULL)     { ;       XNoticeWidget(display,windows,"Unable to load font:", +         resource_info->font_name[font_id]); )       font_info=windows->image.font_info;      } >   if ((x+font_info->max_bounds.width) >= windows->image.width)7     x=windows->image.width-font_info->max_bounds.width; 1   if (y < (font_info->ascent+font_info->descent)) +     y=font_info->ascent+font_info->descent; =   if ((font_info->max_bounds.width > windows->image.width) || H       ((font_info->ascent+font_info->descent) >= windows->image.height))     return(False);   /*"     Initialize annotate structure.   */@   annotate_info=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));.   if (annotate_info == (XAnnotateInfo *) NULL)     return(False);"   XGetAnnotateInfo(annotate_info);   annotate_info->x=x;    annotate_info->y=y; +   if (!transparent_box && !transparent_pen) )     annotate_info->stencil=OpaqueStencil;    else     if (!transparent_box) /       annotate_info->stencil=BackgroundStencil;      else/       annotate_info->stencil=ForegroundStencil; =   annotate_info->height=font_info->ascent+font_info->descent; !   annotate_info->degrees=degrees; %   annotate_info->font_info=font_info; &   annotate_info->text=(char *) malloc(N     (windows->image.width/Max(font_info->min_bounds.width,1)+2)*sizeof(char));+   if (annotate_info->text == (char *) NULL)      return(False);   /**     Create cursor and set graphic context.   */.   cursor=XCreateFontCursor(display,XC_pencil);2   XDefineCursor(display,windows->image.id,cursor);3   annotate_context=windows->image.annotate_context; 4   XSetFont(display,annotate_context,font_info->fid);*   XSetBackground(display,annotate_context,9     windows->image.pixel_info->pen_colors[box_id].pixel); *   XSetForeground(display,annotate_context,9     windows->image.pixel_info->pen_colors[pen_id].pixel);    /*)     Begin annotating the image with text.    */   windows->command.name="Text";    windows->command.data=0;F   (void) XCommandWidget(display,windows,TextModeMenu,(XEvent *) NULL);   state=DefaultState; D   XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);F   text_event.xexpose.width=(unsigned int) font_info->max_bounds.width;9   text_event.xexpose.height=font_info->max_bounds.ascent+ "     font_info->max_bounds.descent;   p=annotate_info->text;   do   {      /*       Display text cursor.     */     *p='\0';F     XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */0         XSetBackground(display,annotate_context,=           windows->image.pixel_info->background_color.pixel); 0         XSetForeground(display,annotate_context,=           windows->image.pixel_info->foreground_color.pixel); C         id=XCommandWidget(display,windows,AnnotateModeMenu,&event); 0         XSetBackground(display,annotate_context,?           windows->image.pixel_info->pen_colors[box_id].pixel); 0         XSetForeground(display,annotate_context,?           windows->image.pixel_info->pen_colors[pen_id].pixel);          if (id < 0)            continue;          switch (id) 	         {            case TextModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);<             XDefineCursor(display,windows->image.id,cursor);             break;           } !           case TextModeDismissOp:            {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:             break;	         }          continue;        }      /*       Erase text cursor.     */     text_event.xexpose.x=x; 8     text_event.xexpose.y=y-font_info->max_bounds.ascent;@     XClearArea(display,windows->image.id,x,text_event.xexpose.y,@       text_event.xexpose.width,text_event.xexpose.height,False);8     XRefreshWindow(display,&windows->image,&text_event);     switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);             break;           } ,         if (event.xbutton.button == Button2)           {              /*(               Request primary selection.             */E             XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, -               windows->image.id,CurrentTime);              break;           }          break;       }        case Expose:       { %         if (event.xexpose.count == 0)            {              XAnnotateInfo                *text_info;                /*#               Refresh Image window.              */D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);$             text_info=annotate_info;7             while (text_info != (XAnnotateInfo *) NULL) 
             { >               if (annotate_info->stencil == ForegroundStencil)G                 XDrawString(display,windows->image.id,annotate_context, <                   text_info->x,text_info->y,text_info->text,+                   strlen(text_info->text));                elseL                 XDrawImageString(display,windows->image.id,annotate_context,<                   text_info->x,text_info->y,text_info->text,+                   strlen(text_info->text)); ,               text_info=text_info->previous;
             } N             XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);           }          break;       }        case KeyPress:       {          int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; N         if ((event.xkey.state & ControlMask) || (event.xkey.state & Mod1Mask))           state|=ModifierState; "         if (state & ModifierState)           switch (key_symbol)            {              case XK_u:             case XK_U:
             { #               key_symbol=XK_Delete;                break;
             }              default:               break;           }          switch (key_symbol) 	         {            case XK_BackSpace:           {              /*"               Erase one character.             */)             if (p == annotate_info->text) D               if (annotate_info->previous == (XAnnotateInfo *) NULL)                 break;               else                 {                    /*;                     Go to end of the previous line of text.                    */8                   annotate_info=annotate_info->previous;(                   p=annotate_info->text;:                   x=annotate_info->x+annotate_info->width;%                   y=annotate_info->y; 0                   if (annotate_info->width != 0)3                     p+=strlen(annotate_info->text);                    break;                 }              p--;)             x-=XTextWidth(font_info,p,1); #             text_event.xexpose.x=x; @             text_event.xexpose.y=y-font_info->max_bounds.ascent;@             XRefreshWindow(display,&windows->image,&text_event);             break;           }            case XK_Delete:            {              /*,               Erase the entire line of text.             */,             while (p != annotate_info->text)
             {                p--;+               x-=XTextWidth(font_info,p,1); %               text_event.xexpose.x=x; B               XRefreshWindow(display,&windows->image,&text_event);
             }              break;           }            case XK_Escape:            case XK_F20:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:           {              /*:               Draw a single character on the Image window.             */&             if (state & ModifierState)               break;!             if (*command == '\0')                break;             *p=(*command);<             if (annotate_info->stencil == ForegroundStencil)N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);             elseJ               XDrawImageString(display,windows->image.id,annotate_context,                 x,y,p,1); )             x+=XTextWidth(font_info,p,1);              p++;G             if ((x+font_info->max_bounds.width) < windows->image.width)                break;           }            case XK_Return:            case XK_KP_Enter:            {              /*/               Advance to the next line of text.              */             *p='\0';J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); >             if (annotate_info->next != (XAnnotateInfo *) NULL)               {                  /*.                   Line of text already exists.                 */2                 annotate_info=annotate_info->next;#                 x=annotate_info->x; #                 y=annotate_info->y; &                 p=annotate_info->text;                 break;               } P             annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));>             if (annotate_info->next == (XAnnotateInfo *) NULL)               return(False);2             *annotate_info->next=(*annotate_info);8             annotate_info->next->previous=annotate_info;.             annotate_info=annotate_info->next;F             annotate_info->text=(char *) malloc((windows->image.width/B               Max(font_info->min_bounds.width,1)+2)*sizeof(char));5             if (annotate_info->text == (char *) NULL)                return(False);4             annotate_info->y+=annotate_info->height;9             if (annotate_info->y > windows->image.height) 5               annotate_info->y=annotate_info->height; 7             annotate_info->next=(XAnnotateInfo *) NULL;              x=annotate_info->x;              y=annotate_info->y; "             p=annotate_info->text;             break;           } 	         }          break;       }        case KeyRelease:       { 
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);           state&=(~ModifierState);         break;       }        case SelectionNotify:        {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;
         /*7           Annotate Image window with primary selection. 
         */"         for (i=0; i < length; i++)	         {            if (data[i] != '\n')
             {                /*<                 Draw a single character on the Image window.               */               *p=data[i]; N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);+               x+=XTextWidth(font_info,p,1);                p++;I               if ((x+font_info->max_bounds.width) < windows->image.width)                  continue; 
             }            /*-             Advance to the next line of text.            */           *p='\0';H           annotate_info->width=XTextWidth(font_info,annotate_info->text,)             strlen(annotate_info->text)); <           if (annotate_info->next != (XAnnotateInfo *) NULL)
             {                /*,                 Line of text already exists.               */0               annotate_info=annotate_info->next;!               x=annotate_info->x; !               y=annotate_info->y; $               p=annotate_info->text;               continue; 
             } N           annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));<           if (annotate_info->next == (XAnnotateInfo *) NULL)             return(False);0           *annotate_info->next=(*annotate_info);6           annotate_info->next->previous=annotate_info;,           annotate_info=annotate_info->next;D           annotate_info->text=(char *) malloc((windows->image.width/@             Max(font_info->min_bounds.width,1)+2)*sizeof(char));3           if (annotate_info->text == (char *) NULL)              return(False);2           annotate_info->y+=annotate_info->height;7           if (annotate_info->y > windows->image.height) 3             annotate_info->y=annotate_info->height; 5           annotate_info->next=(XAnnotateInfo *) NULL;            x=annotate_info->x;            y=annotate_info->y;             p=annotate_info->text;	         }          XFree((void *) data);          break;       }        default:         break;     } !   } while (!(state & ExitState));    XFreeCursor(display,cursor);   /*2     Annotation is relative to image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    /*     Initialize annotated image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);1   while (annotate_info != (XAnnotateInfo *) NULL)    { "     if (annotate_info->width == 0)       { 
         /*>           No text on this line--  go to the next line of text.
         */.         previous_info=annotate_info->previous;+         free((char *) annotate_info->text); %         free((char *) annotate_info); $         annotate_info=previous_info;         continue;        }      /*2       Determine pixel index for box and pen color.     */)     windows->image.pixel_info->box_color= 4       windows->image.pixel_info->pen_colors[box_id];/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == @             windows->image.pixel_info->pen_colors[box_id].pixel)           { 3             windows->image.pixel_info->box_index=i;              break;           } )     windows->image.pixel_info->pen_color= 4       windows->image.pixel_info->pen_colors[pen_id];/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == @             windows->image.pixel_info->pen_colors[pen_id].pixel)           { 3             windows->image.pixel_info->pen_index=i;              break;           }      /**       Define the annotate geometry string.     */9     x_factor=UpShift(width)/windows->image.ximage->width; '     annotate_info->x+=windows->image.x; :     annotate_info->x=DownShift(annotate_info->x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height; ;     annotate_info->y+=(windows->image.y-font_info->ascent); :     annotate_info->y=DownShift(annotate_info->y*y_factor);9     (void) sprintf(annotate_info->geometry,"%ux%u%+d%+d", >       (unsigned int) DownShift(annotate_info->width*x_factor),?       (unsigned int) DownShift(annotate_info->height*y_factor), -       annotate_info->x+x,annotate_info->y+y);      /*       Annotate image with text.      */     status= L       XAnnotateImage(display,windows->image.pixel_info,annotate_info,image);     if (status == 0)       return(False);     /*       Free up memory.      */*     previous_info=annotate_info->previous;'     free((char *) annotate_info->text); !     free((char *) annotate_info);       annotate_info=previous_info;   } *   XSetForeground(display,annotate_context,7     windows->image.pixel_info->foreground_color.pixel); *   XSetBackground(display,annotate_context,7     windows->image.pixel_info->background_color.pixel); C   XSetFont(display,annotate_context,windows->image.font_info->fid); )   XSetCursorState(display,windows,False);    XFreeFont(display,font_info);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B a c k g r o u n d I m a g e                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XBackgroundImage displays the image in the background of a window. % 1 %  The format of the XBackgroundImage routine is:  % A %    status=XBackgroundImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o status: Function XBackgroundImage return True if the image isJ %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */6 static unsigned int XBackgroundImage(Display *display,?   XResourceInfo *resource_info,XWindows *windows,Image **image)  { = #define BackgroundImageText  "  Backgrounding the image...  "   
   static char &     window_id[MaxTextLength] = "root";     XResourceInfo      background_resources;      unsigned int     status;      /*     Put image in background.   */4   status=XDialogWidget(display,windows,"Background",H     "Enter window id (id 0x00 selects window with pointer):",window_id);   if (*window_id == '\0')      return(False);M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); 3   XInfoWidget(display,windows,BackgroundImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);(   background_resources=(*resource_info);+   background_resources.window_id=window_id; '   background_resources.backdrop=status; G   status=XDisplayBackgroundImage(display,&background_resources,*image); 
   if (status) C     XClientMessage(display,windows->image.id,windows->im_protocols, -       windows->im_retain_colors,CurrentTime); )   XSetCursorState(display,windows,False); M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ) %  Function XChopImage chops the X image.  % + %  The format of the XChopImage routine is:  % ; %    status=XChopImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % > %    o status: Function XChopImage return True if the image isF %      cut.  False is returned is there is a memory shortage or if the %      image fails to cut. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */M static unsigned int XChopImage(Display *display,XResourceInfo *resource_info, "   XWindows *windows,Image **image) {  #define ChopModeDirectionOp  0 #define ChopModeHelpOp  1  #define ChopModeDismissOp  2 #define HorizontalChopOp  0  #define VerticalChopOp  1   
   static char      *ChopModeMenu[]=     {        "Direction",
       "Help",        "Dismiss",       (char *) NULL      };     char     text[MaxTextLength];     Image      *chop_image;     int      id,      x,     y;     RectangleInfo      chop_info;     static unsigned int !     direction = HorizontalChopOp;      unsigned int
     distance,      height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;  
   XSegment     segment_info;      /*     Map Command widget.    */   windows->command.name="Chop";    windows->command.data=1;F   (void) XCommandWidget(display,windows,ChopModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,ChopModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         { #           case ChopModeDirectionOp:            {              char%               command[MaxTextLength];                static char                *Directions[]=               {                  "horizontal",                  "vertical",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */             direction=O               XMenuWidget(display,windows,ChopModeMenu[id],Directions,command);              break;           }            case ChopModeHelpOp:           { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);             break;           } !           case ChopModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*=           User has committed to start point of chopting line. 
         */(         segment_info.x1=event.xbutton.x;(         segment_info.x2=event.xbutton.x;(         segment_info.y1=event.xbutton.y;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */?         (void) XLookupString((XKeyEvent *) &event.xkey,command, ?           sizeof(command),&key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);        }      } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*B     Draw line as pointer moves until the mouse button is released.   */   chop_info.width=0;   chop_info.height=0;    chop_info.x=0;   chop_info.y=0;
   distance=0; B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      if (distance > 9)        { 
         /*.           Display info and draw chopping line.
         */"         if (!windows->info.mapped)/           XMapWindow(display,windows->info.id); L         (void) sprintf(text," %ux%u%+d%+d",chop_info.width,chop_info.height,#           chop_info.x,chop_info.y); *         XInfoWidget(display,windows,text);1         XHighlightLine(display,windows->image.id, :           windows->image.highlight_context,&segment_info);       }      else       if (windows->info.mapped) G         XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      if (distance > 9) /       XHighlightLine(display,windows->image.id, 8         windows->image.highlight_context,&segment_info);     switch (event.type)      {        case ButtonPress:        { (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;         break;       }        case ButtonRelease:        { 
         /*.           User has committed to chopping line.
         */(         segment_info.x2=event.xbutton.x;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case Expose:         break;       case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;       }        default:         break;     }      /*        Check boundary conditions.     */     if (segment_info.x2 < 0)       segment_info.x2=0;     else9       if (segment_info.x2 > windows->image.ximage->width) 5         segment_info.x2=windows->image.ximage->width;      if (segment_info.y2 < 0)       segment_info.y2=0;     else:       if (segment_info.y2 > windows->image.ximage->height)6         segment_info.y2=windows->image.ximage->height;
     distance= L       ((segment_info.x2-segment_info.x1)*(segment_info.x2-segment_info.x1))+L       ((segment_info.y2-segment_info.y1)*(segment_info.y2-segment_info.y1));     /*        Compute chopping geometry.     */&     if (direction == HorizontalChopOp)       { :         chop_info.width=segment_info.x2-segment_info.x1+1;5         chop_info.x=windows->image.x+segment_info.x1;          chop_info.height=0;          chop_info.y=0;.         if (segment_info.x1 > segment_info.x2)           { >             chop_info.width=segment_info.x1-segment_info.x2+1;9             chop_info.x=windows->image.x+segment_info.x2;            }        }      else       {          chop_info.width=0;;         chop_info.height=segment_info.y2-segment_info.y1+1;          chop_info.x=0;5         chop_info.y=windows->image.y+segment_info.y1; .         if (segment_info.y1 > segment_info.y2)           { ?             chop_info.height=segment_info.y1-segment_info.y2+1; 9             chop_info.y=windows->image.y+segment_info.y2;            }        } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (distance <= 9)     return(True);    /*6     Image chopping is relative to image configuration.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   windows->image.window_changes.width=1     windows->image.ximage->width-chop_info.width; '   windows->image.window_changes.height= 3     windows->image.ximage->height-chop_info.height;    x=0;   y=0;   width=(*image)->columns;   height=(*image)->rows;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    chop_info.x+=x; 2   chop_info.x=DownShift(chop_info.x*scale_factor);:   chop_info.width=DownShift(chop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    chop_info.y+=y; 2   chop_info.y=DownShift(chop_info.y*scale_factor);<   chop_info.height=DownShift(chop_info.height*scale_factor);   /*     Chop image.    */*   chop_image=ChopImage(*image,&chop_info);)   XSetCursorState(display,windows,False); #   if (chop_image == (Image *) NULL)      return(False);   DestroyImage(*image);    *image=chop_image;   /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r E d i t I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XColorEditImage allows the user to interactively change K %  the color of one pixel for a DirectColor image or one colormap entry for G %  a PseudoClass image.  The floodfill algorithm is strongly based on a : %  similiar algorithm in "Graphics Gems" by Paul Heckbert. % 0 %  The format of the XColorEditImage routine is: % 9 %    XColorEditImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */  B static void ColorFloodfill(Image *image,int x,int y,XColor xcolor,   int delta) {    int      offset, 	     skip, 
     start,     x1,      x2;      register RunlengthPacket     *pixel;      register XSegment      *p;      RunlengthPacket 
     color,     target;   
   XSegment     *segment_stack;      /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))      return; +   target=image->pixels[y*image->columns+x]; #   color.red=XDownScale(xcolor.red); '   color.green=XDownScale(xcolor.green); %   color.blue=XDownScale(xcolor.blue); %   if (ColorMatch(color,target,delta))      return;    /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)      { D       Warning("Unable to recolor image","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */
   start=0;   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (p > segment_stack)    {      /*       Pop segment off stack.     */     p--;
     x1=p->x1; 
     x2=p->x2;      offset=p->y2;      y=p->y1+offset;      /*!       Recolor neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     { /       pixel=image->pixels+(y*image->columns+x); +       if (!ColorMatch(*pixel,target,delta))          break;       pixel->red=color.red;        pixel->green=color.green;        pixel->blue=color.blue;      }      skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) %           Push(y,start,x1-1,-offset);          x=x1+1;        }      do     {        if (!skip)	         { *           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x); 1             if (!ColorMatch(*pixel,target,delta))                break;!             pixel->red=color.red; %             pixel->green=color.green; #             pixel->blue=color.blue;            } #           Push(y,start,x-1,offset);            if (x > (x2+1)) %             Push(y,x2+1,x-1,-offset); 	         }        skip=False;        for (x++; x <= x2 ; x++)       { 1         pixel=image->pixels+(y*image->columns+x); ,         if (ColorMatch(*pixel,target,delta))           break;       }        start=x;     } while (x <= x2);   }    free((char *) segment_stack);  }   5 static unsigned int XColorEditImage(Display *display, ?   XResourceInfo *resource_info,XWindows *windows,Image **image)  {  #define ColorEditColorOp  0  #define ColorEditMethodOp  1 #define ColorEditDeltaOp  2  #define ColorEditUndoOp  3 #define ColorEditHelpOp  4 #define ColorEditDismissOp  5   
   static char      *ColorEditMenu[]=      {        "Pixel Color",       "Method",        "Delta",
       "Undo", 
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int 
     entry,     id,      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *p;      static unsigned int      delta = 0,     method = PointMethodOp,      pen_id = 0;      unsigned int     height, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XColor
     color;     XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Color Edit";    windows->command.data=3;G   (void) XCommandWidget(display,windows,ColorEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,ColorEditMenu,&event);         if (id < 0)            { <             XDefineCursor(display,windows->image.id,cursor);             continue;            }          switch (id) 	         {             case ColorEditColorOp:           {              char(               *ColorMenu[MaxNumberPens];               int                pen_number;                /*)               Initialize menu selections.              */1             for (i=0; i < (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];4             ColorMenu[MaxNumberPens-2]="Browser...";5             ColorMenu[MaxNumberPens-1]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */O             pen_number=XMenuWidget(display,windows,ColorEditMenu[id],ColorMenu,                command);              if (pen_number < 0)                break;0             if (pen_number == (MaxNumberPens-2))               {                  static char 5                   color_name[MaxTextLength] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } !           case ColorEditMethodOp:            {              static char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */             entry=P               XMenuWidget(display,windows,ColorEditMenu[id],MethodMenu,command);             if (entry >= 0)                method=entry;              break;           }             case ColorEditDeltaOp:           {              static char                *DeltaMenu[]=                {                  "0",                 "1",                 "2",                 "4",                 "8",                 "16",                  "32",                  (char *) NULL,                 (char *) NULL,               },)               value[MaxTextLength] = "3";                /*8               Select a delta value from the pop-up menu.             */%             DeltaMenu[7]="Dialog..."; J             entry=XMenuWidget(display,windows,ColorEditMenu[id],DeltaMenu,               command);              if (entry < 0)               break;             if (entry != 7)                { -                 delta=atoi(DeltaMenu[entry]);                  break;               } K             (void) XDialogWidget(display,windows,"Ok","Enter delta value:",                value);              if (*value == '\0')                break;             delta=atoi(value);             break;           }            case ColorEditUndoOp:            { B             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);              break;           }            case ColorEditHelpOp:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           } "           case ColorEditDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           } 	         } 8         XDefineCursor(display,windows->image.id,cursor);         continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Exit loop.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        { 
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image); *         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     }      x_offset=x;      y_offset=y; )     if (state & UpdateConfigurationState)        {          int            x,           y;  
         /*8           Pixel edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True); <         color=windows->image.pixel_info->pen_colors[pen_id];G         XPutPixel(windows->image.ximage,x_offset,y_offset,color.pixel);          x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height); =         x_factor=UpShift(width)/windows->image.ximage->width; C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x; ?         y_factor=UpShift(height)/windows->image.ximage->height; C         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y; -         if ((x_offset < 0) || (y_offset < 0))            continue; L         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue;          switch (method) 	         {            case PointMethodOp:            default:           {              /*=               Update color information using point algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset); )             p->red=XDownScale(color.red); -             p->green=XDownScale(color.green); +             p->blue=XDownScale(color.blue);              break;           }            case ReplaceMethodOp:            {              RunlengthPacket                target;                /*?               Update color information using replace algorithm.              */             x=0;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             {                x+=(p->length+1); <               if (x > (y_offset*(*image)->columns+x_offset))                 break;               p++;
             } '             target=(*image)->pixels[i]; /             if ((*image)->class == DirectClass)                { #                 p=(*image)->pixels; 5                 for (i=0; i < (*image)->packets; i++)                  { 2                   if (ColorMatch(*p,target,delta))                     { 3                       p->red=XDownScale(color.red); 7                       p->green=XDownScale(color.green); 5                       p->blue=XDownScale(color.blue);                      }                    p++;                 }                }              else               { 4                 for (i=0; i < (*image)->colors; i++)E                   if (ColorMatch((*image)->colormap[i],target,delta))                      { F                       (*image)->colormap[i].red=XDownScale(color.red);J                       (*image)->colormap[i].green=XDownScale(color.green);H                       (*image)->colormap[i].blue=XDownScale(color.blue);                     } "                 SyncImage(*image);               }              break;           } !           case FloodfillMethodOp:            {              /*A               Update color information using floodfill algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;A             ColorFloodfill(*image,x_offset,y_offset,color,delta);              break;           }            case ResetMethodOp:            {              /*=               Update color information using reset algorithm.              */(             (*image)->class=DirectClass;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             { +               p->red=XDownScale(color.red); /               p->green=XDownScale(color.green); -               p->blue=XDownScale(color.blue);                p++;
             }              break;           } 	         } +         state&=(~UpdateConfigurationState);        } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m p o s i t e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XCompositeImage requests an image name from the user, reads M %  the image and composites it with the X window image at a location the user  %  chooses with the pointer. % 0 %  The format of the XCompositeImage routine is: % @ %    status=XCompositeImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % D %    o status: Function XCompositeImage returns True if the image isM %      composited.  False is returned is there is a memory shortage or if the $ %      image fails to be composited. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */5 static unsigned int XCompositeImage(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) { # #define CompositeModeOperatorsOp  0  #define CompositeModeBlendOp  1  #define CompositeModeHelpOp  2! #define CompositeModeDismissOp  3   
   static char      *CompositeModeMenu[]=      {        "Operators",       "Blend",
       "Help",        "Dismiss",       (char *) NULL      },#     filename[MaxTextLength] = "\0";      char     text[MaxTextLength];     Cursor     cursor;      double
     blend;     Image      *composite_image;      int      id,      x,     y;     RectangleInfo      highlight_info,      composite_info;      static unsigned int #     operation = ReplaceCompositeOp;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*&     Request image file name from user.   */;   XFileBrowserWidget(display,windows,"Composite",filename);    if (*filename == '\0')     return(True);    /*     Read image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);7   composite_image=ReadImage(resource_info->image_info); )   XSetCursorState(display,windows,False); (   if (composite_image == (Image *) NULL)     { F       XNoticeWidget(display,windows,"Unable to read image:",filename);       return(False);     }    /*     Map Command widget.    */$   windows->command.name="Composite";   windows->command.data=1;K   (void) XCommandWidget(display,windows,CompositeModeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);&   composite_info.x=windows->image.x+x;&   composite_info.y=windows->image.y+y;   composite_info.width=0;    composite_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); 0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   blend=0.0;   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */J         (void) sprintf(text," %+d%+d ",composite_info.x,composite_info.y);*         XInfoWidget(display,windows,text);       } "     highlight_info=composite_info;7     highlight_info.x=composite_info.x-windows->image.x; 7     highlight_info.y=composite_info.y-windows->image.y; 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */D         id=XCommandWidget(display,windows,CompositeModeMenu,&event);         if (id < 0)            continue;          switch (id) 	         { (           case CompositeModeOperatorsOp:           {              char%               command[MaxTextLength];                static char                *OperatorMenu[]=               {                  "over",                  "in",                  "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",                  "difference",                  "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */H             operation=XMenuWidget(display,windows,CompositeModeMenu[id],&               OperatorMenu,command)+1;             break;           } $           case CompositeModeBlendOp:           {              static char -               factor[MaxTextLength] = "20.0";                /*3               Blend the two images a given percent.              */J             XSetFunction(display,windows->image.highlight_context,GXcopy);9             (void) XDialogWidget(display,windows,"Blend", >               "Enter the blend factor (0.0 - 99.9%):",factor);L             XSetFunction(display,windows->image.highlight_context,GXinvert);              if (*factor == '\0')               break;             blend=atof(factor);              break;           } #           case CompositeModeHelpOp:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           } &           case CompositeModeDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } 
         /*           Change cursor.
         */6         composite_info.width=composite_image->columns;4         composite_info.height=composite_image->rows;8         XDefineCursor(display,windows->image.id,cursor);:         composite_info.x=windows->image.x+event.xbutton.x;:         composite_info.y=windows->image.y+event.xbutton.y;         break;       }        case ButtonRelease:        { !         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); H         if ((composite_info.width != 0) && (composite_info.height != 0))           {              /*D               User has selected the location of the composite image.             */>             composite_info.x=windows->image.x+event.xbutton.x;>             composite_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;            int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */*             DestroyImage(composite_image);             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); ,         composite_info.x=windows->image.x+x;,         composite_info.y=windows->image.y+y;         break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);    /*9     Image compositing is relative to image configuration.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    composite_info.x+=x;<   composite_info.x=DownShift(composite_info.x*scale_factor);D   composite_info.width=DownShift(composite_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    composite_info.y+=y;<   composite_info.y=DownShift(composite_info.y*scale_factor);F   composite_info.height=DownShift(composite_info.height*scale_factor);;   if ((composite_info.width != composite_image->columns) || 7       (composite_info.height != composite_image->rows))      {        Image          *zoomed_image;         /*         Scale composite image.       */B       zoomed_image=ZoomImage(composite_image,composite_info.width,.         composite_info.height,MitchellFilter);$       DestroyImage(composite_image);)       if (zoomed_image == (Image *) NULL) 	         { 1           XSetCursorState(display,windows,False);            return(False);	         } #       composite_image=zoomed_image;      }    if (blend != 0.0)      {        register int
         i;         register RunlengthPacket         *p;          unsigned short         index;         /*#         Create mattes for blending.        */C       index=(unsigned short) (((int) DownScale(MaxRGB)*blend)/100); )       composite_image->class=DirectClass; "       composite_image->matte=True;        p=composite_image->pixels;2       for (i=0; i < composite_image->packets; i++)       {          p->index=index;          p++;       }        index=(unsigned short)F         ((int) DownScale(MaxRGB)-((int) DownScale(MaxRGB)*blend)/100);       image->class=DirectClass;        image->matte=True;       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          p->index=index;          p++;       } !       operation=BlendCompositeOp;      }    /*(     Composite image with X Image window.   */B   CompositeImage(image,operation,composite_image,composite_info.x,     composite_info.y);    DestroyImage(composite_image);)   XSetCursorState(display,windows,False);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e C o l o r m a p                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XConfigureImageColormap creates a new X colormap.  % 8 %  The format of the XConfigureImageColormap routine is: % A %    XConfigureImageColormap(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */5 static void XConfigureImageColormap(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) { 
   Colormap
     colormap;      /*     Make standard colormap.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);5   if (image->packets == (image->columns*image->rows))      CompressImage(image); I   XMakeStandardColormap(display,windows->image.visual_info,resource_info, =     image,windows->image.map_info,windows->image.pixel_info); -   colormap=windows->image.map_info->colormap; 9   XSetWindowColormap(display,windows->image.id,colormap); ;   XSetWindowColormap(display,windows->command.id,colormap); :   XSetWindowColormap(display,windows->widget.id,colormap);   if (windows->magnify.mapped)=     XSetWindowColormap(display,windows->magnify.id,colormap);    if (windows->pan.mapped)9     XSetWindowColormap(display,windows->pan.id,colormap); )   XSetCursorState(display,windows,False); A   XClientMessage(display,windows->image.id,windows->im_protocols, -     windows->im_update_colormap,CurrentTime);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XConfigureImage creates a new X image.  It also notifies theL %  window manager of the new image size and configures the transient widows. % 0 %  The format of the XConfigureImage routine is: % @ %    status=XConfigureImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o status: Function XConfigureImage returns True if the window is J %      resized.  False is returned is there is a memory shortage or if the %      window fails to resize. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */5 static unsigned int XConfigureImage(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) {    unsigned int     height, 	     mask,      status, 
     width,
     x_factor, 
     y_factor;      XSizeHints     *size_hints;     XWindowChanges     window_changes;      /**     Dismiss if window dimensions are zero.   */,   width=windows->image.window_changes.width;.   height=windows->image.window_changes.height;   if (resource_info->debug) <     (void) fprintf(stderr,"Configure Image: %dx%d=>%ux%u\n",O       windows->image.ximage->width,windows->image.ximage->height,width,height);    if ((width*height) == 0)     return(True);    /*0     Resize image to fit Image window dimensions.   */(   XSetCursorState(display,windows,True);   XFlush(display);7   x_factor=UpShift(width)/windows->image.ximage->width; 9   y_factor=UpShift(height)/windows->image.ximage->height; N   status=XMakeImage(display,resource_info,&windows->image,image,width,height);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);   if (status == False)A     XNoticeWidget(display,windows,"Unable to configure X image:",        windows->image.name);    /*3     Notify window manager of the new configuration.    */;   if (width > XDisplayWidth(display,windows->image.screen)) 7     width=XDisplayWidth(display,windows->image.screen);    window_changes.width=width; =   if (height > XDisplayHeight(display,windows->image.screen)) 9     height=XDisplayHeight(display,windows->image.screen);    window_changes.height=height;    mask=CWWidth | CWHeight;   if (resource_info->backdrop)     {        mask|=CWX | CWY;       window_changes.x= I         (XDisplayWidth(display,windows->image.screen) >> 1)-(width >> 1);        window_changes.y= K         (XDisplayHeight(display,windows->image.screen) >> 1)-(height >> 1);      } L   XReconfigureWMWindow(display,windows->image.id,windows->image.screen,mask,     &window_changes);    if (image->matte) ,     XClearWindow(display,windows->image.id);;   if ((x_factor == UpShift(1)) || (y_factor == UpShift(1))) <     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*(     Update Magnify window configuration.   */<   windows->magnify.x=DownShift(x_factor*windows->magnify.x);<   windows->magnify.y=DownShift(y_factor*windows->magnify.y);   if (windows->magnify.mapped)'     XMakeMagnifyImage(display,windows);    /*$     Update pan window configuration.   */8   windows->image.x=DownShift(x_factor*windows->image.x);8   windows->image.y=DownShift(y_factor*windows->image.y);:   windows->pan.crop_geometry=windows->image.crop_geometry;-   XBestIconSize(display,&windows->pan,image); -   while ((windows->pan.width < MinPanSize) && ,          (windows->pan.height < MinPanSize))   {      windows->pan.width<<=1;      windows->pan.height<<=1;   } -   if (windows->pan.geometry != (char *) NULL) A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,        &windows->pan.height);*   window_changes.width=windows->pan.width;,   window_changes.height=windows->pan.height;   size_hints=XAllocSizeHints(); (   if (size_hints != (XSizeHints *) NULL)     {        /*         Set new size hints.        */4       size_hints->flags=PSize | PMinSize | PMaxSize;-       size_hints->width=window_changes.width; /       size_hints->height=window_changes.height; .       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;:       XSetNormalHints(display,windows->pan.id,size_hints);!       XFree((void *) size_hints);      } L   XReconfigureWMWindow(display,windows->pan.id,windows->pan.screen,CWWidth |     CWHeight,&window_changes);   if (windows->pan.mapped)7     XMakePanImage(display,resource_info,windows,image);    /*%     Update icon window configuration.    */;   windows->icon.crop_geometry=windows->image.crop_geometry; .   XBestIconSize(display,&windows->icon,image);+   window_changes.width=windows->icon.width; -   window_changes.height=windows->icon.height; E   XReconfigureWMWindow(display,windows->icon.id,windows->icon.screen, (     CWWidth | CWHeight,&window_changes);)   XSetCursorState(display,windows,False);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C r o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XCropImage allows the user to select a region of the image andI %  crop, copy, or cut it.  For copy or cut, the image can subsequently be . %  composited onto the image with XPasteImage. % + %  The format of the XCropImage routine is:  % @ %    status=XCropImage(display,resource_info,windows,image,mode) % + %  A description of each parameter follows:  % ? %    o status: Function XCropImage returns True if the image is J %      copyped.  False is returned is there is a memory shortage or if the! %      image fails to be copyped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  % F %    o mode: This unsigned value specified whether the image should be %      cropped, copied, or cut.  %  %  */M static unsigned int XCropImage(Display *display,XResourceInfo *resource_info, 3   XWindows *windows,Image *image,unsigned int mode)  {  #define CropModeHelpOp  0  #define CropModeDismissOp  1 #define RectifyModeCopyOp  0 #define RectifyModeHelpOp  1 #define RectifyModeDismissOp  2   
   static char      *CropModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      },     *RectifyModeMenu[]=      { 
       "Crop", 
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      int      id,      x,     y;     KeySym     key_symbol;      Image      *crop_image;     RectangleInfo      crop_info,     highlight_info;      register RunlengthPacket     *p;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget.    */   switch (mode)    {      case CopyMode:     { #       windows->command.name="Copy";        break;     }      case CropMode:     { #       windows->command.name="Crop";        break;     }      case CutMode:      { "       windows->command.name="Cut";       break;     }    } +   RectifyModeMenu[0]=windows->command.name;    windows->command.data=0;F   (void) XCommandWidget(display,windows,CropModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);!   crop_info.x=windows->image.x+x; !   crop_info.y=windows->image.y+y;    crop_info.width=0;   crop_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */@         (void) sprintf(text," %+d%+d ",crop_info.x,crop_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,CropModeMenu,&event);          if (id < 0)            continue;          switch (id) 	         {            case CropModeHelpOp:           {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           } !           case CropModeDismissOp:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {              /*B               Note first corner of cropping rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);9             crop_info.x=windows->image.x+event.xbutton.x; 9             crop_info.y=windows->image.y+event.xbutton.y;              state|=ExitState;              break;           }          break;       }        case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         crop_info.x=windows->image.x+x; '         crop_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {        /**         User want to exit without croping.       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=crop_info.x;     y=crop_info.y;     crop_info.width=0;     crop_info.height=0;      state=DefaultState; +     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*5             Display info and draw cropping rectangle.            */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id); N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y;            break;	         }          case ButtonRelease: 	         {            /*4             User has committed to croping rectangle.           */7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y; 1           XSetCursorState(display,windows,False);            state|=ExitState; ;           if (strcmp(windows->command.name,"Rectify") == 0)              break;*           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);            break;	         }          case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.            */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 7           crop_info.x=windows->image.x+event.xmotion.x; 7           crop_info.y=windows->image.y+event.xmotion.y; 	         }          default:           break;       } L       if (((crop_info.x != x) && (crop_info.y != y)) || (state & ExitState))	         {            /*&             Check boundary conditions.           */           if (crop_info.x < 0)             crop_info.x=0;           else;             if (crop_info.x > windows->image.ximage->width) 7               crop_info.x=windows->image.ximage->width;            if (crop_info.x < x);             crop_info.width=(unsigned int) (x-crop_info.x);            else
             { =               crop_info.width=(unsigned int) (crop_info.x-x);                crop_info.x=x;
             }            if (crop_info.y < 0)             crop_info.y=0;           else<             if (crop_info.y > windows->image.ximage->height)8               crop_info.y=windows->image.ximage->height;           if (crop_info.y < y)<             crop_info.height=(unsigned int) (y-crop_info.y);           else
             { >               crop_info.height=(unsigned int) (crop_info.y-y);               crop_info.y=y;
             } 	         } #     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;      do     {        if (windows->info.mapped) 	         {            /*%             Display pointer position.            */N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);	         }        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;            state|=ExitState;            break;	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */H           XSetFunction(display,windows->image.highlight_context,GXcopy);D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);J           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);           if (id >= 0)             switch (id) 
             { %               case RectifyModeCopyOp:                { !                 state|=ExitState;                  break;               } %               case RectifyModeHelpOp:                { N                 XSetFunction(display,windows->image.highlight_context,GXcopy);                 switch (mode)                  {                     case CopyMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,C                       "Help Viewer - Image Copying",ImageCopyHelp);                      break;                   }                     case CropMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,D                       "Help Viewer - Image Cropping",ImageCropHelp);                     break;                   }                    case CutMode:                    { H                     XTextViewWidget(display,resource_info,windows,False,B                       "Help Viewer - Image Cutting",ImageCutHelp);                     break;                   }                  } P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               } (               case RectifyModeDismissOp:               {                  /*#                   Prematurely exit.                  */#                 state|=EscapeState; !                 state|=ExitState;                  break;               }                default:                 break;
             }            continue; 	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 6               crop_info.x=crop_info.x+crop_info.width;7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { 6               crop_info.x=crop_info.x+crop_info.width;.               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { .               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease:            break;         case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                { 1                 event.xexpose.x=highlight_info.x; 1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width; ;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);                } 7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         { 5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return: 
             {                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);               switch (mode)                {                  case CopyMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,A                     "Help Viewer - Image Copying",ImageCopyHelp);                    break;                 }                  case CropMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,B                     "Help Viewer - Image Cropping",ImageCropHelp);                   break;                 }                  case CutMode:                  { F                   XTextViewWidget(display,resource_info,windows,False,@                     "Help Viewer - Image Cutting",ImageCutHelp);                   break;                 }                } N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);                break;
             }            }            break;	         }          case KeyRelease:           break;         case MotionNotify:	         {            /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));            x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped) 
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState)); !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);    if (state & EscapeState)     return(True);    if (mode == CropMode) <     if ((crop_info.width != windows->image.ximage->width) ||<         (crop_info.height != windows->image.ximage->height))       { 
         /*D           Reconfigure Image window as defined by cropping rectangle.
         */;         XSetCropGeometry(display,windows,&crop_info,image); <         windows->image.window_changes.width=crop_info.width;>         windows->image.window_changes.height=crop_info.height;D         (void) XConfigureImage(display,resource_info,windows,image);         return(True);        }    /*0     Copy image before applying image transforms.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    crop_info.x+=x; 2   crop_info.x=DownShift(crop_info.x*scale_factor);:   crop_info.width=DownShift(crop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    crop_info.y+=y; 2   crop_info.y=DownShift(crop_info.y*scale_factor);<   crop_info.height=DownShift(crop_info.height*scale_factor);)   crop_image=CropImage(image,&crop_info); )   XSetCursorState(display,windows,False); #   if (crop_image == (Image *) NULL)      return(False);#   if (copy_image != (Image *) NULL)      DestroyImage(copy_image);    copy_image=crop_image;   if (mode == CopyMode)      { B       (void) XConfigureImage(display,resource_info,windows,image);       return(True);      }    /*     Cut image.   */   image->class=DirectClass;    if (!image->matte)     {        /*         Initialize matte data.       */       p=image->pixels;(       for (x=0; x < image->packets; x++)       {          p->index=Opaque;         p++;       }        image->matte=True;     }    if (UncompressImage(image)) (     for (y=0; y < crop_info.height; y++)     { A       p=image->pixels+(crop_info.y+y)*image->columns+crop_info.x; )       for (x=0; x < crop_info.width; x++)        {          p->index=Transparent;          p++;       }      }    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y B a c k g r o u n d I m a g e                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDisplayBackgroundImage displays an image in the background of a
 %  window. % 8 %  The format of the XDisplayBackgroundImage routine is: % B %      status=XDisplayBackgroundImage(display,resource_info,image) % + %  A description of each parameter follows:  % C %    o status: Function XDisplayBackgroundImage returns True if the , %      designated window is the root window. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */= static unsigned int XDisplayBackgroundImage(Display *display, ,   XResourceInfo *resource_info,Image *image) {    char     visual_type[MaxTextLength];      unsigned int     height,      status, 
     width;     Window     root_window;     XGCValues      context_values;      XPixelInfo     pixel_info;      XResourceInfo      resources;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      XWindowAttributes      window_attributes;  
   XWindowInfo      window_info;     /*     Determine target window.   */   window_info.id=(Window) NULL; %   window_info.ximage=(XImage *) NULL; *   window_info.matte_image=(XImage *) NULL;#   window_info.pixmap=(Pixmap) NULL; )   window_info.matte_pixmap=(Pixmap) NULL; "   window_info.shared_memory=False;;   root_window=XRootWindow(display,XDefaultScreen(display)); :   if (Latin1Compare(resource_info->window_id,"root") == 0)     window_info.id=root_window;    else     { -       if (isdigit(*resource_info->window_id)) ?         window_info.id=XWindowByID(display,root_window,(Window) F           strtol((char *) resource_info->window_id,(char **) NULL,0));*       if (window_info.id == (Window) NULL)         window_info.id= F           XWindowByName(display,root_window,resource_info->window_id);     } &   if (window_info.id == (Window) NULL)I     Error("No window with specified id exists",resource_info->window_id);    /*     Determine window visual id.    */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display)); K   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display)); '   (void) strcpy(visual_type,"default"); I   status=XGetWindowAttributes(display,window_info.id,&window_attributes);    if (status != False)'     (void) sprintf(visual_type,"0x%lx", 5       XVisualIDFromVisual(window_attributes.visual));    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) K     Error("Unable to create standard colormap","Memory allocation failed"); %   map_info->colormap=(Colormap) NULL; +   pixel_info.pixels=(unsigned long *) NULL; '   pixel_info.gamma_map=(XColor *) NULL;    /*     Initialize visual info.    */   resources=(*resource_info); #   resources.map_type=(char *) NULL; $   resources.visual_type=visual_type;;   visual_info=XBestVisualInfo(display,map_info,&resources); *   if (visual_info == (XVisualInfo *) NULL)=     Error("Unable to get visual",resource_info->visual_type);    /*     Free previous root colors.   */$   if (window_info.id == root_window).     XDestroyWindowColors(display,root_window);   /*     Initialize colormap.   */$   resources.colormap=SharedColormap;F   XMakeStandardColormap(display,visual_info,&resources,image,map_info,     &pixel_info);    /*     Graphic context superclass.    */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);   /*'     Initialize Image window attributes.    */O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,%      resource_info,&window_info);   /*     Create the X image.    */#   window_info.width=image->columns; 3   if (window_info.width >= window_attributes.width) .     window_info.width=window_attributes.width;!   window_info.height=image->rows; 5   if (window_info.height >= window_attributes.height) 0     window_info.height=window_attributes.height;O   status=XMakeImage(display,resource_info,&window_info,image,window_info.width,      window_info.height);   if (status == False)4     Error("Unable to create X image",(char *) NULL);   window_info.x=0;   window_info.y=0;   if (resource_info->debug)S     { C       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",image->filename, 1         image->scene,image->columns,image->rows);        if (image->colors != 0) 4         (void) fprintf(stderr,"%uc ",image->colors);2       (void) fprintf(stderr,"%s\n",image->magick);     }X   /*I     Adjust image dimensions as specified by backdrop or geometry options.    */   width=window_info.width;   height=window_info.height;   if (resource_info->backdrop)     {        /*$         Center image on root window.       */3       window_info.x=(window_attributes.width >> 1)-t)         (window_info.ximage->width >> 1); 4       window_info.y=(window_attributes.height >> 1)-*         (window_info.ximage->height >> 1);$       width=window_attributes.width;&       height=window_attributes.height;     } 5   if (resource_info->image_geometry != (char *) NULL)      { 
       char(         default_geometry[MaxTextLength];  	       int          flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints(); ,       if (size_hints == (XSizeHints *) NULL)H         Error("Unable to display on window","Memory allocation failed");$       size_hints->flags=(long) NULL;<       (void) sprintf(default_geometry,"%ux%u",width,height);4       flags=XWMGeometry(display,visual_info->screen,7         resource_info->image_geometry,default_geometry, J         window_info.border_width,size_hints,&window_info.x,&window_info.y,1         (int *) &width,(int *) &height,&gravity);s$       if (flags & (XValue | YValue))	         {s(           width=window_attributes.width;*           height=window_attributes.height;	         } !       XFree((void *) size_hints);s     }r   /*     Create the X pixmap.   */   window_info.pixmap= I     XCreatePixmap(display,window_info.id,width,height,window_info.depth);a*   if (window_info.pixmap == (Pixmap) NULL)5     Error("Unable to create X pixmap",(char *) NULL);    /*!     Display pixmap on the window.d   */C   if ((width > window_info.width) || (height > window_info.height))sK     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,f       0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,s     window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);    /*     Free resources.c   */*   XFreePixmap(display,window_info.pixmap);$   XDestroyImage(window_info.ximage);0   XFreeGC(display,window_info.annotate_context);*   XFreeCursor(display,window_info.cursor);/   XFreeCursor(display,window_info.busy_cursor);D$   if (window_info.id != root_window)D     XFreeStandardColormap(display,visual_info,map_info,&pixel_info);   else     {F6       if (pixel_info.pixels != (unsigned long *) NULL))         free((char *) pixel_info.pixels);a2       if (pixel_info.gamma_map != (XColor *) NULL),         free((char *) pixel_info.gamma_map);     }h   XFree((void *) map_info);c   XFree((void *) visual_info);(   return(window_info.id == root_window); }  c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %pO %                                                                             % O %                                                                             %lO %   X D i s p l a y I m a g e                                                 %oO %                                                                             % O %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p % L %  Function XDisplayImage displays an image via X11.  A new image is createdI %  and returned if the user interactively transforms the displayed image.o %U. %  The format of the XDisplayImage routine is: %mN %      loaded_image=XDisplayImage(display,resource_info,argv,argc,image,state) %n+ %  A description of each parameter follows:p %oF %    o loaded_image:  Function XDisplayImage returns an image when theF %      user chooses 'Load Image' from the command menu or picks a tileE %      from the image directory.  Otherwise a null image is returned.  %uE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %iK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.c % 7 %    o argv: Specifies the application's argument list.- %a/ %    o argc: Specifies the number of arguments.  %sG %    o image: Specifies an address to an address of an Image structure;a %      returned from ReadImage.i %e %  */J static Image *XDisplayImage(Display *display,XResourceInfo *resource_info,:   char **argv,int argc,Image **image,unsigned long *state) {a4 #define MagnifySize  256  /* must be a power of 2 */ #define MagickMenus  9 #define MaxWindows  10 #define MagickTitle  "Commands"   
   static char      *CommandMenu[]=      {b
       "File", 
       "Edit",e
       "View",        "Transform",       "Enhance",       "Effects",       "Image Edit",        "Miscellany", 
       "Help",d       (char *) NULLa     },     *FileMenu[]=     {e       "Load...",
       "Next",u       "Former",y       "Select...",       "Save...",       "Print...",        "Delete...",       "Canvas...",       "Visual Directory...",
       "Quit",        (char *) NULL      },     *EditMenu[]=     {o
       "Undo",a
       "Redo",        "Cut",
       "Copy",r       "Paste",       (char *) NULL      },     *ViewMenu[]=     {h       "Half Size",       "Original Size",       "Double Size",       "Resize...",       "Apply",       "Refresh",       "Restore",       (char *) NULLa     },     *TransformMenu[]=e     { 
       "Crop",f
       "Chop",l
       "Flop",o
       "Flip",t       "Rotate Right",        "Rotate Left",       "Rotate...",       "Shear...",        "Trim Edges",        (char *) NULLl     },     *EnhanceMenu[]=      {m       "Hue...",        "Saturation...",       "Brightness...",       "Gamma...",p       "Spiff",
       "Dull",g       "Equalize",m       "Normalize",       "Negate",l       "Grayscale",       "Quantize...",       (char *) NULLo     },     *EffectsMenu[]=      {p       "Despeckle",       "Peak Noise",        "Sharpen...",w       "Blur...",       "Edge Detect",       "Emboss",e       "Spread",        "Swirl",       "Oil Painting",        "Raise...",        "Segment...",a       (char *) NULL      },     *ImageEditMenu[]=      {i       "Annotate...",       "Draw...",       "Color...",        "Matte...",n       "Composite...",-       "Add Border...",       "Add Frame...",a       "Comment...",i       "Region of Interest...",       (char *) NULL      },     *MiscellanyMenu[]=     {e       "Image Info",e       "Zoom Image",        "Show Histogram",o       "Background...",       "Slide Show...",       "Preferences...",        (char *) NULLc     },     *HelpMenu[]=     {k       "Overview",r       "Browse Documentation",r       "About Display",       (char *) NULL      },     *ShortCutsMenu[]=e     { 
       "Next",        "Former",'       "Load...",       "Save...",
       "Undo",        "Restore",       "Gamma...",h       "Image Info",a
       "Quit",        (char *) NULLi     },     *ImmutableMenu[]=i     {i       "Image Info", 
       "Quit",r       (char *) NULL      };  
   static charw     **Menus[MagickMenus]=d     {n       FileMenu,o       EditMenu,        ViewMenu,e       TransformMenu,       EnhanceMenu,       EffectsMenu,       ImageEditMenu,       MiscellanyMenu,        HelpMenu     };     static KeySymn     CommandKeys[]=     {n       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,     },     FileKeys[]=%     {%       XK_l,%       XK_n,%       XK_f,%       XK_F2,       XK_s,        XK_p,        XK_Delete,       XK_C,        XK_V, 
       XK_q     },     EditKeys[]=      {        XK_u,        XK_Redo,       XK_F3,       XK_F4,       XK_F5      },     ViewKeys[]=      {        XK_less,       XK_o,        XK_greater,        XK_percent,        XK_A,        XK_at,
       XK_r     },     TransformKeys[]=     {        XK_bracketleft,        XK_bracketright,
       XK_bar,        XK_minus,        XK_slash,        XK_backslash,        XK_asterisk,       XK_F6,
       XK_t     },     EnhanceKeys[]=     {%       XK_F7,       XK_F8,       XK_F9,       XK_g,%
       XK_F10,%
       XK_F11,n       XK_equal,a       XK_N,m       XK_asciitilde,       XK_G,        XK_numbersigni     },     EffectsKeys[]=     {        XK_D,p       XK_P,p       XK_S,o       XK_B,        XK_E,        XK_M, 
       XK_F13,t
       XK_F14,o       XK_O,        XK_asciicircum,e
       XK_Z     },     ImageEditKeys[]=     {i       XK_a,        XK_d,;       XK_c,c       XK_m,t       XK_x,        XK_b,        XK_F,p       XK_exclam,
       XK_R     },     MiscellanyKeys[]=      {        XK_i,n       XK_z,        XK_H,        XK_ampersand,        XK_comma,r       XK_F12     },     HelpKeys[]=      {t       XK_h,        XK_Find,
       XK_v     },     ShortCutsKeys[]=     {p       XK_n,o       XK_f,        XK_l,a       XK_s,d       XK_u,        XK_r,o       XK_g,        XK_i,v
       XK_q     },     ImmutableKeys[]=     {r       XK_i, 
       XK_q     };     static KeySym      *Keys[MagickMenus]=C     {        FileKeys,        EditKeys,t       ViewKeys,i       TransformKeys,       EnhanceKeys,       EffectsKeys,       ImageEditKeys,       MiscellanyKeys,c       HelpKeys     };     char     command[MaxTextLength],f#     image_signature[MaxTextLength],d!     resource_name[MaxTextLength];      Image      *displayed_image,g     *loaded_image;     int 
     entry,     id,a     status;t     KeySym     key_symbol;      register int     i;  
   static char"%     working_directory[MaxTextLength];m     static Windowr     root_window;     static XClassHint/     *class_hints;f     static XFontStruct     *font_info;      static XPixelInfoe     icon_pixel,m     pixel_info;n     static XPointl
     vid_info;t     static XResourceInfo     icon_resources;e     static XStandardColormap     *icon_map,     *map_info;     static XVisualInfo     *icon_visual,c(     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo      *magick_windows[MaxWindows];     static XWMHintsa     *manager_hints;      static unsigned inta     number_windows;m  
   struct stat      file_info;     time_t
     timer,     time_stamp,t     update_time;     unsigned int     context_mask;      XEvent
     event;     XGCValuese     context_values;I     XWindowChanges     window_changes;   *   if (visual_info != (XVisualInfo *) NULL)$     (void) chdir(working_directory);   else     {,       /*#         Allocate standard colormap.        */       if (resource_info->debug)l	         {t%           XSynchronize(display,True); 9           (void) fprintf(stderr,"Version: %s\n",Version);,	         }e(       map_info=XAllocStandardColormap();(       icon_map=XAllocStandardColormap();5       if ((map_info == (XStandardColormap *) NULL) ||o3           (icon_map == (XStandardColormap *) NULL))eO         Error("Unable to create standard colormap","Memory allocation failed"); )       map_info->colormap=(Colormap) NULL;t)       icon_map->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL; +       pixel_info.gamma_map=(XColor *) NULL;D,       pixel_info.annotate_context=(GC) NULL;-       pixel_info.highlight_context=(GC) NULL;a*       pixel_info.widget_context=(GC) NULL;%       font_info=(XFontStruct *) NULL; ,       icon_pixel.annotate_context=(GC) NULL;/       icon_pixel.pixels=(unsigned long *) NULL;m+       icon_pixel.gamma_map=(XColor *) NULL;a       /*         Allocate visual.       */&       icon_resources=(*resource_info);,       icon_resources.map_type=(char *) NULL;+       icon_resources.visual_type="default";g-       icon_resources.colormap=SharedColormap;pB       visual_info=XBestVisualInfo(display,map_info,resource_info);D       icon_visual=XBestVisualInfo(display,icon_map,&icon_resources);2       if ((visual_info == (XVisualInfo *) NULL) ||0           (icon_visual == (XVisualInfo *) NULL))A         Error("Unable to get visual",resource_info->visual_type);r       if (resource_info->debug) 	         {e-           (void) fprintf(stderr,"Visual:\n");iN           (void) fprintf(stderr,"  visual id: 0x%lx\n",visual_info->visualid);0           (void) fprintf(stderr,"  class: %s\n",2             XVisualClassName(visual_info->class));K           (void) fprintf(stderr,"  depth: %d planes\n",visual_info->depth); C           (void) fprintf(stderr,"  size of colormap: %d entries\n",)(             visual_info->colormap_size);P           (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",:             visual_info->red_mask,visual_info->green_mask,$             visual_info->blue_mask);I           (void) fprintf(stderr,"  significant bits in color: %d bits\n",a'             visual_info->bits_per_rgb);)	         }        /*         Allocate atoms.s       */4       windows=(XWindows *) malloc(sizeof(XWindows));'       if (windows == (XWindows *) NULL)yG         Error("Unable to create X windows","Memory allocation failed");yF       windows->wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);N       windows->wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);H       windows->wm_take_focus=XInternAtom(display,"WM_TAKE_FOCUS",False);F       windows->im_protocols=XInternAtom(display,"IM_PROTOCOLS",False);N       windows->im_update_widget=XInternAtom(display,"IM_UPDATE_WIDGET",False);"       windows->im_update_colormap=8         XInternAtom(display,"IM_UPDATE_COLORMAP",False);#       windows->im_update_signature=f9         XInternAtom(display,"IM_UPDATE_SIGNATURE",False);m       *image_signature='\0';L       windows->im_former_image=XInternAtom(display,"IM_FORMER_IMAGE",False);H       windows->im_next_image=XInternAtom(display,"IM_NEXT_IMAGE",False);N       windows->im_retain_colors=XInternAtom(display,"IM_RETAIN_COLORS",False);<       windows->im_exit=XInternAtom(display,"IM_EXIT",False);       if (resource_info->debug) 	         { 0           (void) fprintf(stderr,"Protocols:\n");<           (void) fprintf(stderr,"  Window Manager: 0x%lx\n",#             windows->wm_protocols); =           (void) fprintf(stderr,"    delete window: 0x%lx\n", '             windows->wm_delete_window); :           (void) fprintf(stderr,"    take focus: 0x%lx\n",$             windows->wm_take_focus);9           (void) fprintf(stderr,"  ImageMagick: 0x%lx\n", #             windows->im_protocols); =           (void) fprintf(stderr,"    update widget: 0x%lx\n", '             windows->im_update_widget);%?           (void) fprintf(stderr,"    update colormap: 0x%lx\n",%)             windows->im_update_colormap);I@           (void) fprintf(stderr,"    update signature: 0x%lx\n",*             windows->im_update_signature);<           (void) fprintf(stderr,"    former image: 0x%lx\n",&             windows->im_former_image);:           (void) fprintf(stderr,"    next image: 0x%lx\n",$             windows->im_next_image);=           (void) fprintf(stderr,"    retain colors: 0x%lx\n",e'             windows->im_retain_colors);cF           (void) fprintf(stderr,"    exit: 0x%lx\n",windows->im_exit);	         }a       /*)         Allocate class and manager hints.        */$       class_hints=XAllocClassHint();$       manager_hints=XAllocWMHints();1       if ((class_hints == (XClassHint *) NULL) ||f/           (manager_hints == (XWMHints *) NULL))o:         Error("Unable to allocate X hints",(char *) NULL);       /*.         Determine group leader if we have one.       */;       root_window=XRootWindow(display,visual_info->screen);n-       windows->group_leader.id=(Window) NULL;A7       if (resource_info->window_group != (char *) NULL)n	         { 4           if (isdigit(*resource_info->window_group))M             windows->group_leader.id=XWindowByID(display,root_window,(Window) M               strtol((char *) resource_info->window_group,(char **) NULL,0)); 8           if (windows->group_leader.id == (Window) NULL)%             windows->group_leader.id= M               XWindowByName(display,root_window,resource_info->window_group);r	         }        /*         Initialize window id's.e       */       number_windows=0;r8       magick_windows[number_windows++]=(&windows->icon);<       magick_windows[number_windows++]=(&windows->backdrop);9       magick_windows[number_windows++]=(&windows->image); 8       magick_windows[number_windows++]=(&windows->info);;       magick_windows[number_windows++]=(&windows->command); :       magick_windows[number_windows++]=(&windows->widget);9       magick_windows[number_windows++]=(&windows->popup); ;       magick_windows[number_windows++]=(&windows->magnify); 7       magick_windows[number_windows++]=(&windows->pan);i(       for (i=0; i < number_windows; i++),         magick_windows[i]->id=(Window) NULL;       vid_info.x=0;e       vid_info.y=0;U     }    /*!     Initialize Standard Colormap.    */   loaded_image=(Image *) NULL;   displayed_image=(*image);    if (resource_info->debug),     {TM       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",displayed_image->filename,iO         displayed_image->scene,displayed_image->columns,displayed_image->rows);n'       if (displayed_image->colors != 0) >         (void) fprintf(stderr,"%uc ",displayed_image->colors);<       (void) fprintf(stderr,"%s\n",displayed_image->magick);     }nJ   XMakeStandardColormap(display,visual_info,resource_info,displayed_image,     map_info,&pixel_info);   /*     Initialize font info.i   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info);s3   font_info=XBestFont(display,resource_info,False);((   if (font_info == (XFontStruct *) NULL)5     Error("Unable to load font",resource_info->font);    /*     Initialize graphic context.    */$   windows->context.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->context);a%   class_hints->res_name="superclass"; #   class_hints->res_class="Display";n-   manager_hints->flags=InputHint | StateHint;    manager_hints->input=False; .   manager_hints->initial_state=WithdrawnState;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->context);r   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);>   context_values.background=pixel_info.background_color.pixel;%   context_values.font=font_info->fid; >   context_values.foreground=pixel_info.foreground_color.pixel;*   context_values.graphics_exposures=False;J   context_mask=GCBackground | GCFont | GCForeground | GCGraphicsExposures;/   if (pixel_info.annotate_context != (GC) NULL) 1     XFreeGC(display,pixel_info.annotate_context);    pixel_info.annotate_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);/   if (pixel_info.annotate_context == (GC) NULL)e<     Error("Unable to create graphic context",(char *) NULL);9   context_values.background=pixel_info.depth_color.pixel; -   if (pixel_info.widget_context != (GC) NULL) /     XFreeGC(display,pixel_info.widget_context);    pixel_info.widget_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);-   if (pixel_info.widget_context == (GC) NULL)m<     Error("Unable to create graphic context",(char *) NULL);>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;   context_values.plane_mask=:     context_values.background ^ context_values.foreground;0   if (pixel_info.highlight_context != (GC) NULL)2     XFreeGC(display,pixel_info.highlight_context);E   pixel_info.highlight_context=XCreateGC(display,windows->context.id,t0     context_mask | GCPlaneMask,&context_values);0   if (pixel_info.highlight_context == (GC) NULL)<     Error("Unable to create graphic context",(char *) NULL);.   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.]   */O   XGetWindowInfo(display,icon_visual,icon_map,&icon_pixel,(XFontStruct *) NULL, $     &icon_resources,&windows->icon);6   windows->icon.geometry=resource_info->icon_geometry;8   XBestIconSize(display,&windows->icon,displayed_image);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);I   windows->icon.attributes.event_mask=ExposureMask | StructureNotifyMask;n   class_hints->res_name="icon";;-   manager_hints->flags=InputHint | StateHint;1   manager_hints->input=False; +   manager_hints->initial_state=IconicState;aF   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->icon);   if (resource_info->debug)/H     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window."   *//   if (icon_pixel.annotate_context != (GC) NULL))1     XFreeGC(display,icon_pixel.annotate_context); >   context_values.background=icon_pixel.background_color.pixel;>   context_values.foreground=icon_pixel.foreground_color.pixel;A   icon_pixel.annotate_context=XCreateGC(display,windows->icon.id, 1     GCBackground | GCForeground,&context_values);o/   if (icon_pixel.annotate_context == (GC) NULL)g<     Error("Unable to create graphic context",(char *) NULL);=   windows->icon.annotate_context=icon_pixel.annotate_context;m   /*     Initialize Image window.   */)   if (windows->image.id != (Window) NULL)      { )       free((char *) windows->image.name);a.       free((char *) windows->image.icon_name);     } D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->image);oB   windows->image.name=(char *) malloc(MaxTextLength*sizeof(char));G   windows->image.icon_name=(char *) malloc(MaxTextLength*sizeof(char)); J   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))F     Error("Unable to create Image window","Memory allocation failed");O   if ((resource_info->title != (char *) NULL) && !(*state & MontageImageState))b     {        /*#         User specified window name._       */>       (void) strcpy(windows->image.name,resource_info->title);C       (void) strcpy(windows->image.icon_name,resource_info->title);      }    else     {        register char          *p;          register Image         *q;a         unsigned int         count;         /*0         Window name is the base of the filename.       */F       p=displayed_image->filename+strlen(displayed_image->filename)-1;O       while ((p > displayed_image->filename) && (*(p-1) != *BasenameSeparator))f         p--;A       (void) sprintf(windows->image.name,"ImageMagick: %s[%u]",p,*          displayed_image->scene);       q=displayed_image;+       while (q->previous != (Image *) NULL)_         q=q->previous;7       for (count=1; q->next != (Image *) NULL; count++)          q=q->next;G       (void) sprintf(windows->image.name,"ImageMagick: %s[%u of %u]",p,L&         displayed_image->scene,count);:       if ((displayed_image->previous == (Image *) NULL) &&6           (displayed_image->next == (Image *) NULL) &&(           (displayed_image->scene == 0))@         (void) sprintf(windows->image.name,"ImageMagick: %s",p);0       (void) strcpy(windows->image.icon_name,p);     }L   if (resource_info->immutable)R"     windows->image.immutable=True;8   windows->image.geometry=resource_info->image_geometry;0   windows->image.width=displayed_image->columns;H   if (windows->image.width > XDisplayWidth(display,visual_info->screen))D     windows->image.width=XDisplayWidth(display,visual_info->screen);.   windows->image.height=displayed_image->rows;J   if (windows->image.height > XDisplayHeight(display,visual_info->screen))F     windows->image.height=XDisplayHeight(display,visual_info->screen);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask | G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | <     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,&     resource_info,&windows->backdrop);K   if ((resource_info->backdrop) || (windows->backdrop.id != (Window) NULL))f     {;       /*#         Initialize backdrop window.a       */       windows->backdrop.x=0;       windows->backdrop.y=0;4       windows->backdrop.name="ImageMagick Backdrop";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen); K       windows->backdrop.height=XDisplayHeight(display,visual_info->screen); '       windows->backdrop.border_width=0; '       windows->backdrop.immutable=True; J       windows->backdrop.attributes.do_not_propagate_mask=ButtonPressMask |         ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;'       class_hints->res_name="backdrop";dB       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state= :         resource_info->iconic ? IconicState : NormalState;J       XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,         &windows->backdrop);       if (resource_info->debug)r>         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id); 1       XClearWindow(display,windows->backdrop.id);n-       if (windows->image.id != (Window) NULL)y	         {o4           XDestroyWindow(display,windows->image.id);*           windows->image.id=(Window) NULL;	         }X       /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition;SI       windows->image.x=(XDisplayWidth(display,visual_info->screen) >> 1)- $         (windows->image.width >> 1);J       windows->image.y=(XDisplayHeight(display,visual_info->screen) >> 1)-%         (windows->image.height >> 1);r     }e+   if (resource_info->name == (char *) NULL) &     class_hints->res_name=client_name;   else.     class_hints->res_name=resource_info->name;>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state= 6     resource_info->iconic ? IconicState : NormalState;0   if (windows->group_leader.id != (Window) NULL)     {t       /*         Follow the leader.       */,       manager_hints->flags|=WindowGroupHint;;       manager_hints->window_group=windows->group_leader.id; I       XSelectInput(display,windows->group_leader.id,StructureNotifyMask);        if (resource_info->debug)iB         (void) fprintf(stderr,"Window id: 0x%lx (group leader)\n",$           windows->group_leader.id);     }    XMakeWindow(display,L     (Window) (resource_info->backdrop ? windows->backdrop.id : root_window),9     argv,argc,class_hints,manager_hints,&windows->image);l0   if (windows->group_leader.id != (Window) NULL)M     XSetTransientForHint(display,windows->image.id,windows->group_leader.id);S   if (resource_info->debug)mJ     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*!     Initialize X image structure.    */   windows->image.x=0;    windows->image.y=0; J   status=XMakeImage(display,resource_info,&windows->image,displayed_image,4     displayed_image->columns,displayed_image->rows);   if (status == False)4     Error("Unable to create X image",(char *) NULL);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);H   if (!windows->image.mapped || (windows->backdrop.id != (Window) NULL))*     XMapWindow(display,windows->image.id);   if (windows->image.mapped)<     XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XClientMessage(display,windows->image.id,windows->im_protocols,s.     windows->im_update_signature,CurrentTime);   /*     Initialize Info widget.=   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,"     resource_info,&windows->info);   windows->info.name="Info";!   windows->info.icon_name="Info";f   windows->info.border_width=1;    windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition;n+   windows->info.attributes.save_under=True; 4   windows->info.attributes.win_gravity=UnmapGravity;&   windows->info.attributes.event_mask=9     ButtonPressMask | ExposureMask | StructureNotifyMask;    class_hints->res_name="info";l?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;o   manager_hints->input=False;i+   manager_hints->initial_state=NormalState;_0   manager_hints->window_group=windows->image.id;L   XMakeWindow(display,windows->image.id,argv,argc,class_hints,manager_hints,     &windows->info);C   XSetTransientForHint(display,windows->info.id,windows->image.id);e   if (windows->image.mapped)C     XWithdrawWindow(display,windows->info.id,windows->info.screen);r   if (resource_info->debug),H     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*     Initialize Command widget.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->command);t$   windows->command.data=MagickMenus;E   (void) XCommandWidget(display,windows,CommandMenu,(XEvent *) NULL);e9   (void) sprintf(resource_name,"%s.command",client_name);aO   windows->command.geometry=XGetResourceClass(resource_info->resource_database,d,     resource_name,"geometry",(char *) NULL);$   windows->command.name=MagickTitle;"   windows->command.border_width=0;$   windows->command.flags|=PPosition;7   windows->command.attributes.backing_store=WhenMapped;x.   windows->command.attributes.save_under=True;M   windows->command.attributes.event_mask=ButtonMotionMask | ButtonPressMask | J     ButtonReleaseMask | EnterWindowMask | ExposureMask | LeaveWindowMask |.     OwnerGrabButtonMask | StructureNotifyMask;"   class_hints->res_name="command";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False;w+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->command);fC   windows->command.highlight_stipple=XCreateBitmapFromData(display,_@     windows->command.id,(char *) HighlightBitmap,HighlightWidth,     HighlightHeight);m@   windows->command.shadow_stipple=XCreateBitmapFromData(display,H     windows->command.id,(char *) ShadowBitmap,ShadowWidth,ShadowHeight);F   XSetTransientForHint(display,windows->command.id,windows->image.id);   if (windows->command.mapped),     XMapRaised(display,windows->command.id);   if (resource_info->debug)oN     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);   /*     Initialize Widget window.(   */*   if (windows->widget.id != (Window) NULL)(     free((char *) windows->widget.name);D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,$     resource_info,&windows->widget);8   (void) sprintf(resource_name,"%s.widget",client_name);N   windows->widget.geometry=XGetResourceClass(resource_info->resource_database,,     resource_name,"geometry",(char *) NULL);C   windows->widget.name=(char *) malloc(MaxTextLength*sizeof(char)); #   if (windows->widget.name == NULL)eF     Error("Unable to create Image window","Memory allocation failed");   *windows->widget.name='\0'; !   windows->widget.border_width=0; #   windows->widget.flags|=PPosition; 6   windows->widget.attributes.backing_store=WhenMapped;-   windows->widget.attributes.save_under=True;nL   windows->widget.attributes.event_mask=ButtonMotionMask | ButtonPressMask |G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |f;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;(!   class_hints->res_name="widget";t?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;-   manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->widget);G   windows->widget.highlight_stipple=windows->command.highlight_stipple;IA   windows->widget.shadow_stipple=windows->command.shadow_stipple; E   XSetTransientForHint(display,windows->widget.id,windows->image.id);s   if (resource_info->debug)nL     (void) fprintf(stderr,"Window id: 0x%lx (widget)\n",windows->widget.id);   /*     Initialize popup window.   */)   if (windows->popup.id != (Window) NULL)/'     free((char *) windows->popup.name);dD   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->popup);aB   windows->popup.name=(char *) malloc(MaxTextLength*sizeof(char));"   if (windows->popup.name == NULL)F     Error("Unable to create Image window","Memory allocation failed");   *windows->popup.name='\0';    windows->popup.border_width=0;"   windows->popup.flags|=PPosition;5   windows->popup.attributes.backing_store=WhenMapped;g,   windows->popup.attributes.save_under=True;K   windows->popup.attributes.event_mask=ButtonMotionMask | ButtonPressMask | G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |;;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;a    class_hints->res_name="popup";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState;=0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->popup);)F   windows->popup.highlight_stipple=windows->command.highlight_stipple;@   windows->popup.shadow_stipple=windows->command.shadow_stipple;D   XSetTransientForHint(display,windows->popup.id,windows->image.id);   if (resource_info->debug) K     (void) fprintf(stderr,"Window id: 0x%lx (pop up)\n",windows->popup.id);    /*)     Initialize Magnify window and cursor.:   */+   if (windows->magnify.id != (Window) NULL)e)     free((char *) windows->magnify.name); D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->magnify);a9   (void) sprintf(resource_name,"%s.magnify",client_name); O   windows->magnify.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);D   windows->magnify.name=(char *) malloc(MaxTextLength*sizeof(char));$   if (windows->magnify.name == NULL)H     Error("Unable to create Magnify window","Memory allocation failed");M   (void) sprintf(windows->magnify.name,"Magnify %uX",resource_info->magnify); @   windows->magnify.cursor=XMakeCursor(display,windows->image.id,7     map_info->colormap,resource_info->background_color,i%     resource_info->foreground_color);e/   if (windows->magnify.cursor == (Cursor) NULL)(3     Error("Unable to create cursor",(char *) NULL); %   windows->magnify.width=MagnifySize; &   windows->magnify.height=MagnifySize;$   windows->magnify.flags|=PPosition;)   windows->magnify.min_width=MagnifySize;>*   windows->magnify.min_height=MagnifySize;)   windows->magnify.width_inc=MagnifySize; *   windows->magnify.height_inc=MagnifySize;/   windows->magnify.data=resource_info->magnify; .   windows->magnify.attributes.save_under=True;=   windows->magnify.attributes.cursor=windows->magnify.cursor; N   windows->magnify.attributes.event_mask=ButtonPressMask | ButtonReleaseMask |H     ExposureMask | KeyPressMask | KeyReleaseMask | OwnerGrabButtonMask |     StructureNotifyMask;"   class_hints->res_name="magnify";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;:   manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->magnify);e   if (resource_info->debug)aN     (void) fprintf(stderr,"Window id: 0x%lx (magnify)\n",windows->magnify.id);F   XSetTransientForHint(display,windows->magnify.id,windows->image.id);   if (windows->magnify.mapped),     XMapRaised(display,windows->magnify.id);   /*     Initialize panning window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,!     resource_info,&windows->pan);a   windows->pan.name="Pan Icon";n7   XBestIconSize(display,&windows->pan,displayed_image);,-   while ((windows->pan.width < MinPanSize) && ,          (windows->pan.height < MinPanSize))   {.     windows->pan.width<<=1;      windows->pan.height<<=1;   }X5   (void) sprintf(resource_name,"%s.pan",client_name); K   windows->pan.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);-   if (windows->pan.geometry != (char *) NULL) A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,        &windows->pan.height);    windows->pan.flags|=PPosition;   windows->pan.immutable=True;*   windows->pan.attributes.save_under=True;I   windows->pan.attributes.event_mask=ButtonMotionMask | ButtonPressMask |NF     ButtonReleaseMask | ExposureMask | KeyPressMask | KeyReleaseMask |     StructureNotifyMask;   class_hints->res_name="pan";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;-   manager_hints->input=True;+   manager_hints->initial_state=NormalState;-0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->pan);    if (resource_info->debug)AF     (void) fprintf(stderr,"Window id: 0x%lx (pan)\n",windows->pan.id);B   XSetTransientForHint(display,windows->pan.id,windows->image.id);   if (windows->image.mapped)@     if ((windows->image.width < windows->image.ximage->width) ||@         (windows->image.height < windows->image.ximage->height))*       XMapRaised(display,windows->pan.id);   /*     Respond to events.   */-   (void) SetMonitorHandler(XProgressMonitor);l%   (void) SetWarningHandler(XWarning);o3   timer=time((time_t *) NULL)+resource_info->delay;>   update_time=0;   if (resource_info->update)     {y       /*3         Determine when file data was last modified.o       */8       status=stat(displayed_image->filename,&file_info);       if (status == 0)'         update_time=file_info.st_mtime;      };   *state&=(~FormerImageState);   *state&=(~MontageImageState);K   *state&=(~NextImageState);   do   {      /*       Handle a window event.     */"     if (resource_info->delay != 0)       {v*         if (timer < time((time_t *) NULL))%           if (!resource_info->update) /             *state|=NextImageState | ExitState;;           else
             {n               /*5                 Determine if image file was modified.                */@               status=stat(displayed_image->filename,&file_info);               if (status == 0)6                 if (update_time != file_info.st_mtime)                   {                      /*&                       Redisplay image.                     */F                     (void) strcpy(resource_info->image_info->filename,1                       displayed_image->filename);,F                     loaded_image=ReadImage(resource_info->image_info);7                     if (loaded_image != (Image *) NULL) 9                       *state|=NextImageState | ExitState;                    }w?               timer=time((time_t *) NULL)+resource_info->delay; 
             } 9         if (XEventsQueued(display,QueuedAfterFlush) == 0)            {*             /*(               Do not block if delay > 0.             */-             XDelay(display,SuspendTime << 2);              continue;i           }i       }e%     time_stamp=time((time_t *) NULL);e     XNextEvent(display,&event);      if (!windows->image.stasis)fC       windows->image.stasis=(time((time_t *) NULL)-time_stamp) > 0; 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */>         id=XCommandWidget(display,windows,CommandMenu,&event);         if (id < 0)_           continue; /         (void) strcpy(command,CommandMenu[id]);N#         key_symbol=CommandKeys[id];*         if (id < MagickMenus)a           {.             /*2               Select a command from a pop-up menu.             */H             entry=XMenuWidget(display,windows,CommandMenu[id],Menus[id],               command);              if (entry < 0)               continue;a4             (void) strcpy(command,Menus[id][entry]);'             key_symbol=Keys[id][entry];x           }t(         if (key_symbol != XK_VoidSymbol)F           loaded_image=XMagickCommand(display,resource_info,windows,0,)             key_symbol,&displayed_image);          continue;o       }-     switch (event.type)e     {t       case ButtonPress:o       {.!         if (resource_info->debug)mB           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 0         if ((event.xbutton.button == Button3) &&-             (event.xbutton.state & Mod1Mask))n           {              /*-               Convert Alt-Button3 to Button2.              */)             event.xbutton.button=Button2; -             event.xbutton.state&=(~Mod1Mask);            } 9         if (event.xbutton.window == windows->backdrop.id)            { G             XSetInputFocus(display,event.xbutton.window,RevertToParent, "               event.xbutton.time);             break;           } 6         if (event.xbutton.window == windows->image.id)           {w)             switch (event.xbutton.button) 
             {G               case Button1:e               {t-                 if (resource_info->immutable)a                   {s                     /*?                       Select a command from the Immutable menu.t                     */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,                        command); #                     if (entry >= 0) H                       loaded_image=XMagickCommand(display,resource_info,I                         windows,0,ImmutableKeys[entry],&displayed_image);i                     break;                   }                  /*+                   Map/unmap Command widget./                 */,                 if (windows->command.mapped)>                   XWithdrawWindow(display,windows->command.id,-                     windows->command.screen);-                 else                   {fF                     (void) XCommandWidget(display,windows,CommandMenu,'                       (XEvent *) NULL); <                     XMapRaised(display,windows->command.id);                   }                  break;               }f               case Button2:-               {-                 /*8                   User pressed the image magnify button.                 */F                 (void) XMagickCommand(display,resource_info,windows,0,2                   (KeySym) XK_z,&displayed_image);6                 XMagnifyImage(display,windows,&event);                 break;               }                case Button3:                { >                 if (displayed_image->montage != (char *) NULL)                   {i                     /*J                       Load or delete a tile from a visual image directory.                     */J                     loaded_image=XTileImage(display,resource_info,windows,.                       displayed_image,&event);7                     if (loaded_image != (Image *) NULL);M                       *state|=MontageImageState | NextImageState | ExitState;n0                     vid_info.x=windows->image.x;0                     vid_info.y=windows->image.y;                     break;                   }o-                 if (resource_info->immutable)t                   {s                     /*?                       Select a command from the Immutable menu.(                     */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,f                       command);n#                     if (entry >= 0)*H                       loaded_image=XMagickCommand(display,resource_info,I                         windows,0,ImmutableKeys[entry],&displayed_image);o                     break;                   }t                 /*<                   Select a command from the Short Cuts menu.                 */M                 entry=XMenuWidget(display,windows,"Short Cuts",ShortCutsMenu,F                   command);                  if (entry >= 0)iN                   loaded_image=XMagickCommand(display,resource_info,windows,0,;                     ShortCutsKeys[entry],&displayed_image);                  break;               }%               default:                 break;
             }%             break;           } 8         if (event.xbutton.window == windows->magnify.id)           {              char%               command[MaxTextLength];                int                factor;                static char                *MagnifyMenu[]=                {                  "2",                 "3",                 "4",                 "5",                 "6",                 "7",                 "8",                 "9",                 (char *) NULL,               };               static KeySym                MagnifyKeys[]=               {%                 XK_2,%                 XK_4,%                 XK_5,                  XK_6,o                 XK_7,m                 XK_8,f                 XK_9,f                 XK_3               };               /*;               Select a magnify factor from the pop-up menu.              */N             factor=XMenuWidget(display,windows,"Magnify",MagnifyMenu,command);             if (factor >= 0)K               XMagnifyWindowCommand(display,windows,0,MagnifyKeys[factor]);i             break;           }d4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);             break;           }n9         timer=time((time_t *) NULL)+resource_info->delay;a         break;       }        case ButtonRelease:o         break;       case ClientMessage:        {a!         if (resource_info->debug)eI           (void) fprintf(stderr,"Client Message: 0x%lx 0x%lx %d 0x%lx\n",i<             event.xclient.window,event.xclient.message_type,J             event.xclient.format,(unsigned long) event.xclient.data.l[0]);@         if (event.xclient.message_type == windows->im_protocols)           {dC             if (*event.xclient.data.l == windows->im_update_widget)t               {d2                 windows->command.name=MagickTitle;2                 windows->command.data=MagickMenus;B                 (void) XCommandWidget(display,windows,CommandMenu,#                   (XEvent *) NULL);K                 break;               }aE             if (*event.xclient.data.l == windows->im_update_colormap)e               {s                 /*=                   Update graphic context and window colormap.r                 */2                 for (i=0; i < number_windows; i++)                 {B@                   if (magick_windows[i]->id == windows->icon.id)                     continue;yN                   context_values.background=pixel_info.background_color.pixel;N                   context_values.foreground=pixel_info.foreground_color.pixel;H                   XChangeGC(display,magick_windows[i]->annotate_context,2                     context_mask,&context_values);F                   XChangeGC(display,magick_windows[i]->widget_context,2                     context_mask,&context_values);N                   context_values.background=pixel_info.foreground_color.pixel;N                   context_values.foreground=pixel_info.background_color.pixel;,                   context_values.plane_mask=J                     context_values.background ^ context_values.foreground;I                   XChangeGC(display,magick_windows[i]->highlight_context, @                     context_mask | GCPlaneMask,&context_values);A                   magick_windows[i]->attributes.background_pixel= 6                     pixel_info.background_color.pixel;=                   magick_windows[i]->attributes.border_pixel=X2                     pixel_info.border_color.pixel;L                   magick_windows[i]->attributes.colormap=map_info->colormap;H                   XChangeWindowAttributes(display,magick_windows[i]->id,L                     magick_windows[i]->mask,&magick_windows[i]->attributes);                 }a(                 if (windows->pan.mapped)                   {pG                     XSetWindowBackgroundPixmap(display,windows->pan.id, +                       windows->pan.pixmap); :                     XClearWindow(display,windows->pan.id);7                     XDrawPanRectangle(display,windows);e                   } :                 if (windows->backdrop.id != (Window) NULL)?                   XInstallColormap(display,map_info->colormap);c                 break;               }wF             if (*event.xclient.data.l == windows->im_update_signature)               { 0                 SignatureImage(displayed_image);J                 (void) strcpy(image_signature,displayed_image->signature);                 break;               } B             if (*event.xclient.data.l == windows->im_former_image)               {m5                 *state|=FormerImageState | ExitState;                  break;               } @             if (*event.xclient.data.l == windows->im_next_image)               {i3                 *state|=NextImageState | ExitState;                  break;               }eC             if (*event.xclient.data.l == windows->im_retain_colors)m               {/*                 *state|=RetainColorsState;                 break;               }e:             if (*event.xclient.data.l == windows->im_exit)               {s"                 *state|=ExitState;                 break;               }o             break;           }e
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;?         if (*event.xclient.data.l != windows->wm_delete_window)t           break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {i             *state|=ExitState;             break;           };4         if (event.xclient.window == windows->pan.id)           {              /*E               Restore original image size when pan window is deleted.w             */M             windows->image.window_changes.width=windows->image.ximage->width;tO             windows->image.window_changes.height=windows->image.ximage->height;aA             (void) XConfigureImage(display,resource_info,windows,o               displayed_image);            }          break;       }i       case ConfigureNotify:        { !         if (resource_info->debug)]K           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d %d\n", ;             event.xconfigure.window,event.xconfigure.width, J             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y,)             event.xconfigure.send_event);n9         if (event.xconfigure.window == windows->image.id)M           {p             /*3               Image window has a new configuration.;             */1             if (event.xconfigure.send_event != 0)                {d                 XWindowChanges!                   window_changes;r                   /*N                   Position the transient windows relative of the Image window.                 */?                 if (windows->command.geometry == (char *) NULL) /                   if (!windows->command.mapped)|                     { )                       windows->command.x= E                         event.xconfigure.x-windows->command.width-25;h<                       windows->command.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->command);:                       window_changes.x=windows->command.x;:                       window_changes.y=windows->command.y;G                       XReconfigureWMWindow(display,windows->command.id, K                         windows->command.screen,CWX | CWY,&window_changes);x                     } ?                 if (windows->magnify.geometry == (char *) NULL)n/                   if (!windows->magnify.mapped)                      { )                       windows->magnify.x= E                         event.xconfigure.x+event.xconfigure.width+25;h<                       windows->magnify.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->magnify);:                       window_changes.x=windows->magnify.x;:                       window_changes.y=windows->magnify.y;G                       XReconfigureWMWindow(display,windows->magnify.id,sK                         windows->magnify.screen,CWX | CWY,&window_changes);X                     }a;                 if (windows->pan.geometry == (char *) NULL)t+                   if (!windows->pan.mapped)t                     { %                       windows->pan.x=rE                         event.xconfigure.x+event.xconfigure.width+25; %                       windows->pan.y=sF                         event.xconfigure.y+windows->magnify.height+50;F                       XConstrainWindowPosition(display,&windows->pan);6                       window_changes.x=windows->pan.x;6                       window_changes.y=windows->pan.y;C                       XReconfigureWMWindow(display,windows->pan.id, G                         windows->pan.screen,CWX | CWY,&window_changes);                      }                }oC             if ((event.xconfigure.width == windows->image.width) &&iC                 (event.xconfigure.height == windows->image.height))r               {)*                 if (windows->image.mapped)J                   XRefreshWindow(display,&windows->image,(XEvent *) NULL);                 break;               } 8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             windows->image.x=0;i             windows->image.y=0; :             if (displayed_image->montage != (char *) NULL)               { ,                 windows->image.x=vid_info.x;,                 windows->image.y=vid_info.y;               }-?             if (windows->image.mapped && windows->image.stasis)w               {                  /*4                   Update Image window configuration.                 */K                 windows->image.window_changes.width=event.xconfigure.width;-M                 windows->image.window_changes.height=event.xconfigure.height; E                 (void) XConfigureImage(display,resource_info,windows,e#                   displayed_image);p               } J             if ((event.xconfigure.width < windows->image.ximage->width) ||J                 (event.xconfigure.height < windows->image.ximage->height))               {n4                 XMapRaised(display,windows->pan.id);3                 XDrawPanRectangle(display,windows);n               })             else&               if (windows->pan.mapped)M                 XWithdrawWindow(display,windows->pan.id,windows->pan.screen);              break;           } ;         if (event.xconfigure.window == windows->magnify.id)e           {o             MonitorHandler               handler;               unsigned int               magnify;               /*5               Magnify window has a new configuration.d             */:             windows->magnify.width=event.xconfigure.width;<             windows->magnify.height=event.xconfigure.height;)             if (!windows->magnify.mapped)l               break;             magnify=1;5             while (magnify <= event.xconfigure.width)y               magnify<<=1;6             while (magnify <= event.xconfigure.height)               magnify<<=1;             magnify>>=1;6             if ((magnify != event.xconfigure.width) ||5                 (magnify != event.xconfigure.height))g               {/-                 window_changes.width=magnify; .                 window_changes.height=magnify;A                 XReconfigureWMWindow(display,windows->magnify.id, N                   windows->magnify.screen,CWWidth | CWHeight,&window_changes);                 break;               } =             handler=SetMonitorHandler((MonitorHandler) NULL);)F             status=XMakeImage(display,resource_info,&windows->magnify,N               displayed_image,windows->magnify.width,windows->magnify.height);I             status|=XMakePixmap(display,resource_info,&windows->magnify);m              if (status == False)D               Error("Unable to create magnify image",(char *) NULL);/             XMakeMagnifyImage(display,windows);m.             (void) SetMonitorHandler(handler);             break;           } 7         if (event.xconfigure.window == windows->pan.id)i           {x             /*6               Pan icon window has a new configuration.             */1             if (event.xconfigure.send_event != 0)n               {n2                 windows->pan.x=event.xconfigure.x;2                 windows->pan.y=event.xconfigure.y;               } 6             windows->pan.width=event.xconfigure.width;8             windows->pan.height=event.xconfigure.height;             break;           }t8         if (event.xconfigure.window == windows->icon.id)           {o             /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width; 9             windows->icon.height=event.xconfigure.height;i             break;           }e         break;       }e       case DestroyNotify:p       {;
         /*"           Group leader has exited.
         */D         if (event.xdestroywindow.window == windows->group_leader.id)           {e             *state|=ExitState;             break;           }=         break;       }i       case EnterNotify:        { 
         /*'           Selectively install colormap.l
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)T8             XInductColormap(display,map_info->colormap);         break;       })       case Expose:       {r!         if (resource_info->debug)g>           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y);d
         /*/           Refresh windows that are now exposed.-
         */6         if (event.xexpose.window == windows->image.id)$           if (windows->image.mapped)
             {o=               XRefreshWindow(display,&windows->image,&event);-?               timer=time((time_t *) NULL)+resource_info->delay;i               break;
             }h8         if (event.xexpose.window == windows->magnify.id)'           if (event.xexpose.count == 0)h(             if (windows->magnify.mapped)               {h3                 XMakeMagnifyImage(display,windows);+                 break;               }*4         if (event.xexpose.window == windows->pan.id)'           if (event.xexpose.count == 0)a
             {h1               XDrawPanRectangle(display,windows);r               break;
             }(5         if (event.xexpose.window == windows->icon.id)e'           if (event.xexpose.count == 0);
             {a<               XRefreshWindow(display,&windows->icon,&event);               break;
             }          break;       }s       case KeyPress:       {g         intn           length;*  
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);%         if (resource_info->immutable)            { =             if ((key_symbol != XK_q) && (key_symbol != XK_i))                XBell(display,0);              elseO               (void) XMagickCommand(display,resource_info,windows,0,key_symbol, "                 &displayed_image);             break;           }%3         if (event.xkey.window == windows->image.id)%D           loaded_image=XMagickCommand(display,resource_info,windows,:             event.xkey.state,key_symbol,&displayed_image);5         if (event.xkey.window == windows->magnify.id)iM           XMagnifyWindowCommand(display,windows,event.xkey.state,key_symbol);n1         if (event.xkey.window == windows->pan.id)a!           if (key_symbol == XK_q):I             XWithdrawWindow(display,windows->pan.id,windows->pan.screen);d           elseA             if ((key_symbol == XK_F1) || (key_symbol == XK_Help))tB               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Panning",ImagePanHelp);             elseA               XTranslateImage(display,windows,*image,key_symbol);a9         timer=time((time_t *) NULL)+resource_info->delay;          break;       }        case KeyRelease:       {I
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),a/           &key_symbol,(XComposeStatus *) NULL);p!         if (resource_info->debug),G           (void) fprintf(stderr,"Key release: 0x%lx (%c)\n",key_symbol,n             *command);         break;       }a       case LeaveNotify:        {<
         /*)           Selectively uninstall colormap.i
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)b:             XUninductColormap(display,map_info->colormap);         break;       }e       case MapNotify:m       {=!         if (resource_info->debug)zI           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window); 6         if (event.xmap.window == windows->backdrop.id)           { D             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime); *             windows->backdrop.mapped=True;             break;           } 3         if (event.xmap.window == windows->image.id)            { 6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap); <             if (strcmp(displayed_image->magick,"LOGO") == 0)K               loaded_image=XLoadImage(display,resource_info,windows,False);;H             if ((windows->image.width < windows->image.ximage->width) ||H                 (windows->image.height < windows->image.ximage->height))2               XMapRaised(display,windows->pan.id);'             windows->image.mapped=True;              break;           } 5         if (event.xmap.window == windows->magnify.id)            {m/             XMakeMagnifyImage(display,windows);p)             windows->magnify.mapped=True;fK             XWithdrawWindow(display,windows->info.id,windows->info.screen);-             break;           }e1         if (event.xmap.window == windows->pan.id)o           { I             XMakePanImage(display,resource_info,windows,displayed_image); %             windows->pan.mapped=True;              break;           } 2         if (event.xmap.window == windows->info.id)           {l&             windows->info.mapped=True;             break;           } 2         if (event.xmap.window == windows->icon.id)           {              /*#               Create an icon image.u             */F             XMakeStandardColormap(display,icon_visual,&icon_resources,4               displayed_image,icon_map,&icon_pixel);E             (void) XMakeImage(display,&icon_resources,&windows->icon,nH               displayed_image,windows->icon.width,windows->icon.height);G             (void) XMakePixmap(display,&icon_resources,&windows->icon);l@             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id); K             XWithdrawWindow(display,windows->info.id,windows->info.screen); &             windows->icon.mapped=True;             break;           } 5         if (event.xmap.window == windows->command.id)t           {n)             windows->command.mapped=True;d             break;           }n3         if (event.xmap.window == windows->popup.id)            { '             windows->popup.mapped=True;              break;           };4         if (event.xmap.window == windows->widget.id)           {C(             windows->widget.mapped=True;             break;           }i         break;       }n       case MappingNotify:d       {n1         XRefreshKeyboardMapping(&event.xmapping);s         break;       }o       case NoExpose:         break;       case ReparentNotify:       {o!         if (resource_info->debug)lB           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);o         break;       }p       case UnmapNotify:s       {*!         if (resource_info->debug)iM           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window);I8         if (event.xunmap.window == windows->backdrop.id)           { +             windows->backdrop.mapped=False;e             break;           }i5         if (event.xunmap.window == windows->image.id)o           {n(             windows->image.mapped=False;             break;           }-7         if (event.xunmap.window == windows->magnify.id)e           { *             windows->magnify.mapped=False;             break;           }r3         if (event.xunmap.window == windows->pan.id)o           {>&             windows->pan.mapped=False;             break;           }o4         if (event.xunmap.window == windows->info.id)           {w'             windows->info.mapped=False;<             break;           }D4         if (event.xunmap.window == windows->icon.id)           {e9             if (map_info->colormap == icon_map->colormap) D               XConfigureImageColormap(display,resource_info,windows,!                 displayed_image); L             XFreeStandardColormap(display,icon_visual,icon_map,&icon_pixel);'             windows->icon.mapped=False;              break;           }b7         if (event.xunmap.window == windows->command.id)o           {i*             windows->command.mapped=False;             break;           }n5         if (event.xunmap.window == windows->popup.id)            {e6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime); (             windows->popup.mapped=False;             break;           }e6         if (event.xunmap.window == windows->widget.id)           {t6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);/)             windows->widget.mapped=False;[             break;           }          break;       }e       default:       {"!         if (resource_info->debug)(?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      }    }o    while (!(*state & ExitState));   /*     Apply image transforms.>   */F   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,     &displayed_image);"   SignatureImage(displayed_image);>   if (strcmp(displayed_image->signature,image_signature) != 0)     {o       /*(         Query user if image has changed.       */B       status=XConfirmWidget(display,windows,"Your image changed.","         "Do you want to save it");       if (status != False)L         (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_s,           &displayed_image);     } J   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_Break,     &displayed_image);   /*$     Withdraw pan and Magnify window.   */   if (windows->pan.mapped)A     XWithdrawWindow(display,windows->pan.id,windows->pan.screen);    if (windows->magnify.mapped)I     XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);    if (windows->command.mapped)I     XWithdrawWindow(display,windows->command.id,windows->command.screen);    if (!resource_info->backdrop) !     if (windows->backdrop.mapped)        { O         XWithdrawWindow(display,windows->backdrop.id,windows->backdrop.screen); 5         XDestroyWindow(display,windows->backdrop.id); +         windows->backdrop.id=(Window) NULL; I         XWithdrawWindow(display,windows->image.id,windows->image.screen);t2         XDestroyWindow(display,windows->image.id);(         windows->image.id=(Window) NULL;       } (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);?   if ((*state & FormerImageState) || (*state & NextImageState))      *state&=(~ExitState);    if (*state & ExitState)f     {        /*         Destroy X windows.       */(       for (i=0; i < number_windows; i++)       { 3         if (magick_windows[i]->id != (Window) NULL)l8           XDestroyWindow(display,magick_windows[i]->id);9         if (magick_windows[i]->ximage != (XImage *) NULL);3           XDestroyImage(magick_windows[i]->ximage); 7         if (magick_windows[i]->pixmap != (Pixmap) NULL) 9           XFreePixmap(display,magick_windows[i]->pixmap);,       },       /*         Free Standard Colormap.        */3       if (resource_info->map_type == (char *) NULL) H         XFreeStandardColormap(display,visual_info,map_info,&pixel_info);"       XFree((void *) class_hints);$       XFree((void *) manager_hints);"       XFree((void *) icon_visual);"       XFree((void *) visual_info);       XFree((void *) icon_map);        XFree((void *) map_info); )       free((char *) windows->popup.name); *       free((char *) windows->widget.name);+       free((char *) windows->magnify.name);D.       free((char *) windows->image.icon_name);)       free((char *) windows->image.name);v       free((char *) windows);B'       visual_info=(XVisualInfo *) NULL;.'       if (copy_image != (Image *) NULL) !         DestroyImage(copy_image);a     }w   /*     Change to home directory.i   */3   (void) getcwd(working_directory,MaxTextLength-1); .   (void) chdir(resource_info->home_directory);   *image=displayed_image;    return(loaded_image);  }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %eO %                                                                             % O %                                                                             %uO %   X D r a w I m a g e                                                       %IO %                                                                             %,O %                                                                             %(O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%L %tM %  Function XDrawEditImage draws a graphic primitive (point, line, rectangle,  %  etc.) on the image. % / %  The format of the XDrawEditImage routine is:u % G %    status=XDrawEditImage(display,resource_info,windows,degrees,image). %y+ %  A description of each parameter follows:m %,H %    o status: Function XDrawEditImage return True if the image is drawnG %      upon.  False is returned is there is a memory shortage or if the   %      image cannot be drawn on. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.( %p< %    o windows: Specifies a pointer to a XWindows structure. %aF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */Q static unsigned int XDrawEditImage(Display *display,XResourceInfo *resource_info, "   XWindows *windows,Image **image) {N #define DrawModePrimitiveOp  0 #define DrawModeColorOp  1 #define DrawModeStippleOp  2 #define DrawModeWidthOp  3 #define DrawModeUndoOp  4a #define DrawModeHelpOp  5n #define DrawModeDismissOp  60 #define Swap(x,y) ((x)^=(y), (y)^=(x), (x)^=(y))  
   static charo     *DrawModeMenu[]=     {        "Primitive",       "Color",       "Stipple",       "Width",
       "Undo",d
       "Help",d       "Dismiss",       (char *) NULLy     };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;d     double     degrees;     int 
     entry,     id,      number_coordinates,i     x,     y;     RectangleInfo      rectangle_info;w     register int     i;     static Pixmap      stipple = (Pixmap) NULL;     static unsigned int;     pen_id = 0,      primitive = PointPrimitive,      line_width = 1;      unsigned int
     distance,a     height,o     max_coordinates,     status, 
     width;     unsigned long 
     state,
     x_factor,t
     y_factor;      Window     root_window;     XDrawInfoe     draw_info;     XEvent
     event;     XPoint     *coordinate_info;o  
   XSegment     line_info;     /*     Allocate polygon info.   */   max_coordinates=2048;tD   coordinate_info=(XPoint *) malloc(max_coordinates*sizeof(XPoint));)   if (coordinate_info == (XPoint *) NULL)r     { D       Warning("Unable to draw on image","Memory allocation failed");       return(False);     }i   /*     Map Command widget.,   */   windows->command.name="Draw";t   windows->command.data=4;F   (void) XCommandWidget(display,windows,DrawModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,t+     windows->im_update_widget,CurrentTime);    /*      Wait for first button press.   */;   root_window=XRootWindow(display,XDefaultScreen(display));m"   draw_info.stencil=OpaqueStencil;   status=True;.   cursor=XCreateFontCursor(display,XC_tcross);
   for ( ; ; )i   {h4     XQueryPosition(display,windows->image.id,&x,&y);4     XDefineCursor(display,windows->image.id,cursor);+     XSelectInput(display,windows->image.id,m@       windows->image.attributes.event_mask | PointerMotionMask);     state=DefaultState;      do     {*       if (windows->info.mapped)-	         {o           /*%             Display pointer position.            */P           (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);,           XInfoWidget(display,windows,text);	         }h       /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);e3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */A           id=XCommandWidget(display,windows,DrawModeMenu,&event);            if (id < 0)o             continue;+           switch (id)            { %             case DrawModePrimitiveOp: 
             {i               static char                  *Primitives[]=                 {                    "point",                   "line",                    "rectangle",#                   "fill rectangle",                    "ellipse",!                   "fill ellipse",                    "polygon",!                   "fill polygon",                     (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */P               primitive=XMenuWidget(display,windows,DrawModeMenu[id],Primitives,                 command)+1;                break;
             } !             case DrawModeColorOp:a
             {t               char,                 *ColorMenu[MaxNumberPens+1];                 inte                 pen_number;                  unsigned int                 transparent;                 XColor                 color;                 /*+                 Initialize menu selections.                */3               for (i=0; i < (MaxNumberPens-2); i++) :                 ColorMenu[i]=resource_info->pen_colors[i];7               ColorMenu[MaxNumberPens-2]="transparent";i6               ColorMenu[MaxNumberPens-1]="Browser...";5               ColorMenu[MaxNumberPens]=(char *) NULL;g               /*8                 Select a pen color from the pop-up menu.               */P               pen_number=XMenuWidget(display,windows,DrawModeMenu[id],ColorMenu,                 command); !               if (pen_number < 0)s                 break;:               transparent=pen_number == (MaxNumberPens-2);               if (transparent)                 {*7                   draw_info.stencil=TransparentStencil;r                   break;                 }g2               if (pen_number == (MaxNumberPens-1))                 {b                   static char 7                     color_name[MaxTextLength] = "gray";                      /*5                     Select a pen color from a dialog.i                   */C                   resource_info->pen_colors[pen_number]=color_name; K                   XColorBrowserWidget(display,windows,"Select",color_name); *                   if (*color_name == '\0')                     break;                 }%               /*                 Set pen color.               */K               (void) XParseColor(display,windows->image.map_info->colormap, >                 resource_info->pen_colors[pen_number],&color);C               XBestPixel(display,windows->image.map_info->colormap, A                 (XColor *) NULL,(unsigned int) MaxColors,&color); F               windows->image.pixel_info->pen_colors[pen_number]=color;                pen_id=pen_number;.               draw_info.stencil=OpaqueStencil;               break;
             } #             case DrawModeStippleOp: 
             {                static char%/                 filename[MaxTextLength] = "\0",%                  *StipplesMenu[]=                 {                    "Brick",                   "Diagonal",w                   "Scales",o                   "Vertical",t                   "Wavy",f                    "Translucent",                   "Opaque",o                    (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               StipplesMenu[7]="Load...";N               entry=XMenuWidget(display,windows,DrawModeMenu[id],StipplesMenu,                 command);n               if (entry < 0)                 break;+               if (stipple != (Pixmap) NULL)e-                 XFreePixmap(display,stipple);o$               stipple=(Pixmap) NULL;               if (entry == 6)a                 break;               if (entry != 7)f                 {a                    switch (entry)                   {a                     case 0:                      { H                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) BricksBitmap,BricksWidth,BricksHeight);                       break;                     }o                     case 1:e                     {,H                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) DiagonalBitmap,DiagonalWidth,DiagonalHeight);                       break;                     }c                     case 2:                      { H                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) ScalesBitmap,ScalesWidth,ScalesHeight);                       break;                     }_                     case 3:e                     { H                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) VerticalBitmap,VerticalWidth,VerticalHeight);                       break;                     }a                     case 4:r                     {oH                       stipple=XCreateBitmapFromData(display,root_window,B                         (char *) WavyBitmap,WavyWidth,WavyHeight);                       break;                     }=                     case 5:                      default:                     {:H                       stipple=XCreateBitmapFromData(display,root_window,@                         (char *) HighlightBitmap,HighlightWidth,)                         HighlightHeight);d                       break;                     }d                   }m                   break;                 }mE               XFileBrowserWidget(display,windows,"Stipple",filename);m$               if (*filename == '\0')                 break;I               status=XReadBitmapFile(display,root_window,filename,&width,n(                 &height,&stipple,&x,&y);*               if (status != BitmapSuccess)O                 XNoticeWidget(display,windows,"Unable to read X bitmap image:",g                   filename);               break;
             }a!             case DrawModeWidthOp: 
             {d               static chari+                 width[MaxTextLength] = "3",=                 *WidthsMenu[]=                 {a                   "1",                   "2",                   "4",                   "8",                   "16",m                    (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               WidthsMenu[5]="Dialog...";L               entry=XMenuWidget(display,windows,DrawModeMenu[id],WidthsMenu,                 command);t               if (entry < 0)                 break;               if (entry != 5)&                 {(5                   line_width=atoi(WidthsMenu[entry]);d                   break;                 }tL               (void) XDialogWidget(display,windows,"Ok","Enter line width:",                 width); !               if (*width == '\0')o                 break;%               line_width=atoi(width);i               break;
             }               case DrawModeUndoOp:
             {wD               (void) XMagickCommand(display,resource_info,windows,0,%                 (KeySym) XK_u,image);                break;
             }               case DrawModeHelpOp:
             { B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);>               XDefineCursor(display,windows->image.id,cursor);               break;
             } #             case DrawModeDismissOp:e
             {                /*!                 Prematurely exit.                */!               state|=EscapeState;t               state|=ExitState;                break;
             }=             default:               break;           } :           XDefineCursor(display,windows->image.id,cursor);           continue;e	         }o       switch (event.type)        {          case ButtonPress: 	         {e6           if (event.xbutton.window == windows->pan.id)
             {g0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }l           /*             Exit loop.           */           x=event.xbutton.x;           y=event.xbutton.y;           state|=ExitState;>           break;	         }e         case ButtonRelease:            break;         case Expose:           break;         case KeyPress:	         {            char#             command[MaxTextLength];              KeySym             key_symbol;>  5           if (event.xkey.window != windows->image.id)d             break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command,gA             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)s           {              case XK_Escape:              case XK_F20:
             {                /*!                 Prematurely exit.E               */!               state|=EscapeState;                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help:P
             { B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);               break;
             }t             default:
             {                XBell(display,0);w               break;
             }            }n           break;	         };         case MotionNotify:	         {w           /*2             Discard pending pointer motion events.           */D           while (XCheckMaskEvent(display,PointerMotionMask,&event));           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)s
             {.@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height)))rO                 XWithdrawWindow(display,windows->info.id,windows->info.screen);w
             }b           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);o           break;	         }.       } #     } while (!(state & ExitState));w+     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);C     XWithdrawWindow(display,windows->info.id,windows->info.screen);      if (state & EscapeState)       break;     /*C       Draw primitive as pointer moves until the button is released.]     */     distance=0;      degrees=0.0;     line_info.x1=x;      line_info.y1=y;      line_info.x2=x;n     line_info.y2=y;.     rectangle_info.x=x;      rectangle_info.y=y;n     rectangle_info.width=0;      rectangle_info.height=0;     number_coordinates=1;k     coordinate_info->x=x;      coordinate_info->y=y;oD     XSetFunction(display,windows->image.highlight_context,GXinvert);     state=DefaultState;      do     {f       switch (primitive)       {)         case PointPrimitive:         default:	         { %           if (number_coordinates > 1) 
             {23               XDrawLines(display,windows->image.id,tA                 windows->image.highlight_context,coordinate_info,a4                 number_coordinates,CoordModeOrigin);,               (void) sprintf(text," %+d%+d",8                 coordinate_info[number_coordinates-1].x,9                 coordinate_info[number_coordinates-1].y);.0               XInfoWidget(display,windows,text);
             }e           break;	         }          case LinePrimitive:a	         {i           if (distance > 9) 
             {c               /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2-,E                 line_info.y1),(double) (line_info.x2-line_info.x1))); 3               (void) sprintf(text," %.2f",degrees); 0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,r=                 windows->image.highlight_context,&line_info);n
             }            else%             if (windows->info.mapped)uM               XWithdrawWindow(display,windows->info.id,windows->info.screen);            break;	         }x          case RectanglePrimitive:$         case FillRectanglePrimitive:	         {+H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {>               /*8                 Display info and draw drawing rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);o0               XInfoWidget(display,windows,text);<               XHighlightRectangle(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }t           else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);.           break;	         }          case EllipsePrimitive:"         case FillEllipsePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {                /*8                 Display info and draw drawing rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);i0               XInfoWidget(display,windows,text);:               XHighlightEllipse(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }x           else%             if (windows->info.mapped)oM               XWithdrawWindow(display,windows->info.id,windows->info.screen);c           break;	         }t         case PolygonPrimitive:"         case FillPolygonPrimitive:	         {t%           if (number_coordinates > 1)i1             XDrawLines(display,windows->image.id,o?               windows->image.highlight_context,coordinate_info,m2               number_coordinates,CoordModeOrigin);           if (distance > 9)!
             {g               /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2-iE                 line_info.y1),(double) (line_info.x2-line_info.x1)));r3               (void) sprintf(text," %.2f",degrees);o0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,e=                 windows->image.highlight_context,&line_info); 
             }l           else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);n           break;	         }a       }        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows);m       switch (primitive)       {p         case PointPrimitive:         default:	         { %           if (number_coordinates > 1)c1             XDrawLines(display,windows->image.id, ?               windows->image.highlight_context,coordinate_info,D2               number_coordinates,CoordModeOrigin);           break;	         }C         case LinePrimitive:u	         {=           if (distance > 9)05             XHighlightLine(display,windows->image.id,i;               windows->image.highlight_context,&line_info);e           break;	         }s          case RectanglePrimitive:$         case FillRectanglePrimitive:	         {aH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3)):             XHighlightRectangle(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }g         case EllipsePrimitive:"         case FillEllipsePrimitive:	         {TH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))8             XHighlightEllipse(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }          case PolygonPrimitive:"         case FillPolygonPrimitive:	         { %           if (number_coordinates > 1) 1             XDrawLines(display,windows->image.id, ?               windows->image.highlight_context,coordinate_info, 2               number_coordinates,CoordModeOrigin);           if (distance > 9) 5             XHighlightLine(display,windows->image.id, ;               windows->image.highlight_context,&line_info);            break;	         }%       }%       switch (event.type)%       {%         case ButtonPress:o           break;         case ButtonRelease:m	         {            /*,             User has committed to primitive.           */'           line_info.x2=event.xbutton.x;o'           line_info.y2=event.xbutton.y;p+           rectangle_info.x=event.xbutton.x;f+           rectangle_info.y=event.xbutton.y;m@           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;1           if (((primitive != PolygonPrimitive) &&iG                (primitive != FillPolygonPrimitive)) || (distance <= 9))a
             {                state|=ExitState;C               break;
             }c           number_coordinates++;n3           if (number_coordinates < max_coordinates) 
             {s+               line_info.x1=event.xbutton.x;i+               line_info.y1=event.xbutton.y;d               break;
             }s           max_coordinates<<=1;$           coordinate_info=(XPoint *)D             realloc(coordinate_info,max_coordinates*sizeof(XPoint));1           if (coordinate_info == (XPoint *) NULL)xJ             Warning("Unable to draw on image","Memory allocation failed");           break;	         }d         case Expose:           break;         case MotionNotify:	         {S           /*1             Discard pending button motion events.d           */8           if (event.xmotion.window != windows->image.id)             break;*           if (primitive != PointPrimitive)
             {sG               while (XCheckMaskEvent(display,ButtonMotionMask,&event));n+               line_info.x2=event.xmotion.x;m+               line_info.y2=event.xmotion.y;,/               rectangle_info.x=event.xmotion.x;%/               rectangle_info.y=event.xmotion.y;%               break;
             } @           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;           number_coordinates++; 3           if (number_coordinates < max_coordinates)              break;           max_coordinates<<=1;$           coordinate_info=(XPoint *)D             realloc(coordinate_info,max_coordinates*sizeof(XPoint));1           if (coordinate_info == (XPoint *) NULL) J             Warning("Unable to draw on image","Memory allocation failed");           break;	         }          default:           break;       }%       /*"         Check boundary conditions.       */       if (line_info.x2 < 0)          line_info.x2=0;i
       else0         if (line_info.x2 > windows->image.width),           line_info.x2=windows->image.width;       if (line_info.y2 < 0)i         line_info.y2=0;i
       else1         if (line_info.y2 > windows->image.height)p-           line_info.y2=windows->image.height;a       distance=nF         ((line_info.x2-line_info.x1+1)*(line_info.x2-line_info.x1+1))+F         ((line_info.y2-line_info.y1+1)*(line_info.y2-line_info.y1+1));A       if (((rectangle_info.x != x) && (rectangle_info.y != y)) ||r           (state & ExitState))	         { #           if (rectangle_info.x < 0)              rectangle_info.x=0;            else8             if (rectangle_info.x > windows->image.width)4               rectangle_info.x=windows->image.width;#           if (rectangle_info.x < x) E             rectangle_info.width=(unsigned int) (x-rectangle_info.x);s           else
             {wG               rectangle_info.width=(unsigned int) (rectangle_info.x-x); !               rectangle_info.x=x;r
             }r#           if (rectangle_info.y < 0)              rectangle_info.y=0;a           else9             if (rectangle_info.y > windows->image.height)i5               rectangle_info.y=windows->image.height;m#           if (rectangle_info.y < y)oF             rectangle_info.height=(unsigned int) (y-rectangle_info.y);           else
             {xH               rectangle_info.height=(unsigned int) (rectangle_info.y-y);!               rectangle_info.y=y; 
             }i	         } #     } while (!(state & ExitState));tB     XSetFunction(display,windows->image.highlight_context,GXcopy);K     if ((primitive == PointPrimitive) || (primitive == PolygonPrimitive) ||o,         (primitive == FillPolygonPrimitive))       {,
         /*)           Determine polygon bounding box.f
         */,         rectangle_info.x=coordinate_info->x;,         rectangle_info.y=coordinate_info->y;         x=coordinate_info->x;(         y=coordinate_info->y;i.         for (i=1; i < number_coordinates; i++)	         {o'           if (coordinate_info[i].x > x)i#             x=coordinate_info[i].x;t'           if (coordinate_info[i].y > y)i#             y=coordinate_info[i].y;a6           if (coordinate_info[i].x < rectangle_info.x)9             rectangle_info.x=Max(coordinate_info[i].x,0);e6           if (coordinate_info[i].y < rectangle_info.y)9             rectangle_info.y=Max(coordinate_info[i].y,0); 	         }r0         rectangle_info.width=x-rectangle_info.x;1         rectangle_info.height=y-rectangle_info.y;d.         for (i=0; i < number_coordinates; i++)	         {i1           coordinate_info[i].x-=rectangle_info.x;i1           coordinate_info[i].y-=rectangle_info.y; 	         }u       }w     else       if (distance <= 9)         continue; 
       else0         if ((primitive == RectanglePrimitive) ||,             (primitive == EllipsePrimitive))           {)#             rectangle_info.width--;R$             rectangle_info.height--;           }L     /*1       Drawing is relative to image configuration.      */!     draw_info.x=rectangle_info.x;w!     draw_info.y=rectangle_info.y;yM     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_Select,M
       image);(     x=0;     y=0;     width=(*image)->columns;     height=(*image)->rows;6     if (windows->image.crop_geometry != (char *) NULL)O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);w9     x_factor=UpShift(width)/windows->image.ximage->width;o4     draw_info.x+=windows->image.x-(line_width >> 1);     if (draw_info.x < 0)       draw_info.x=0;0     draw_info.x=DownShift(draw_info.x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height;=4     draw_info.y+=windows->image.y-(line_width >> 1);     if (draw_info.y < 0)       draw_info.y=0;0     draw_info.y=DownShift(draw_info.y*y_factor);;     draw_info.width=rectangle_info.width+(line_width << 1);h,     if (draw_info.width > (*image)->columns)(       draw_info.width=(*image)->columns;=     draw_info.height=rectangle_info.height+(line_width << 1);S*     if (draw_info.height > (*image)->rows)&       draw_info.height=(*image)->rows;4     (void) sprintf(draw_info.geometry,"%ux%u%+d%+d",9       (unsigned int) DownShift(draw_info.width*x_factor),e:       (unsigned int) DownShift(draw_info.height*y_factor),#       draw_info.x+x,draw_info.y+y);e     /*$       Initialize drawing attributes.     */     draw_info.degrees=0.0;"     draw_info.primitive=primitive;     draw_info.stipple=stipple;$     draw_info.line_width=line_width;"     draw_info.line_info=line_info;)     if (line_info.x1 > (line_width >> 1)) -       draw_info.line_info.x1=line_width >> 1;,)     if (line_info.y1 > (line_width >> 1))i-       draw_info.line_info.y1=line_width >> 1;=G     draw_info.line_info.x2=line_info.x2-line_info.x1+(line_width >> 1);aG     draw_info.line_info.y2=line_info.y2-line_info.y1+(line_width >> 1);hE     if ((draw_info.line_info.x2 < 0) && (draw_info.line_info.y2 < 0))i       {-9         draw_info.line_info.x2=(-draw_info.line_info.x2); 9         draw_info.line_info.y2=(-draw_info.line_info.y2);        } #     if (draw_info.line_info.x2 < 0)%       {%9         draw_info.line_info.x2=(-draw_info.line_info.x2); <         Swap(draw_info.line_info.x1,draw_info.line_info.x2);       } #     if (draw_info.line_info.y2 < 0)        { 9         draw_info.line_info.y2=(-draw_info.line_info.y2); <         Swap(draw_info.line_info.y1,draw_info.line_info.y2);       } ,     draw_info.rectangle_info=rectangle_info;7     if (draw_info.rectangle_info.x > (line_width >> 1)) 1       draw_info.rectangle_info.x=line_width >> 1; 7     if (draw_info.rectangle_info.y > (line_width >> 1)) 1       draw_info.rectangle_info.y=line_width >> 1; 4     draw_info.number_coordinates=number_coordinates;.     draw_info.coordinate_info=coordinate_info;)     windows->image.pixel_info->pen_color=l4       windows->image.pixel_info->pen_colors[pen_id];     /*       Draw primitive on image.     */*     XSetCursorState(display,windows,True);*     XCheckRefreshWindows(display,windows);K     status=XDrawImage(display,windows->image.pixel_info,&draw_info,*image);_+     XSetCursorState(display,windows,False);n     /*8       Update image colormap and return to image drawing.     */B     XConfigureImageColormap(display,resource_info,windows,*image);A     (void) XConfigureImage(display,resource_info,windows,*image);    } )   XSetCursorState(display,windows,False);n!   free((char *) coordinate_info);p   return(status);  }r u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             % O %                                                                             %cO %   X D r a w P a n R e c t a n g l e                                         %rO %                                                                             % O %                                                                             %dO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XDrawPanRectangle draws a rectangle in the pan window.  The pan J %  window displays a zoomed image and the rectangle shows which portion of. %  the image is displayed in the Image window. %s2 %  The format of the XDrawPanRectangle routine is: % ' %    XDrawPanRectangle(display,windows)g % + %  A description of each parameter follows:i %_E %    o display: Specifies a connection to an X server;  returned frome %      XOpenDisplay. %n< %    o windows: Specifies a pointer to a XWindows structure. %n %  */A static void XDrawPanRectangle(Display *display,XWindows *windows)e {p   unsigned long      scale_factor;d     RectangleInfo      highlight_info;      /*2     Determine dimensions of the panning rectangle.   */   scale_factor=(unsigned long)?     (UpShift(windows->pan.width)/windows->image.ximage->width); <   highlight_info.x=DownShift(windows->image.x*scale_factor);D   highlight_info.width=DownShift(windows->image.width*scale_factor);   scale_factor=(unsigned long)A     (UpShift(windows->pan.height)/windows->image.ximage->height);o<   highlight_info.y=DownShift(windows->image.y*scale_factor);F   highlight_info.height=DownShift(windows->image.height*scale_factor);   /*"     Display the panning rectangle.   */(   XClearWindow(display,windows->pan.id);L   XHighlightRectangle(display,windows->pan.id,windows->pan.annotate_context,     &highlight_info);a }o u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             % O %                                                                             %nO %   X L o a d I m a g e                                                       %fO %                                                                             %)O %                                                                             % O %                                                                             %WO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %e2 %  Function XLoadImage loads an image from a file. %o+ %  The format of the XLoadImage routine is:h %oC %    loaded_image=XLoadImage(display,resource_info,windows,command)  % + %  A description of each parameter follows:i %,J %    o loaded_image: Function XLoadImage returns an image if can be loaded9 %      successfully.  Otherwise a null image is returned.  %aD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %aK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % K %    o command: A value other than zero indicates that the file is selecteda+ %      from the command line argument list.C %i %, */G static Image *XLoadImage(Display *display,XResourceInfo *resource_info, )   XWindows *windows,unsigned int command)e {o   Imagei     *loaded_image;     ImageInfo*     image_info;r  
   static char #     filename[MaxTextLength] = "\0";c     /*      Request file name from user.   */   if (!command) 8     XFileBrowserWidget(display,windows,"Load",filename);   else     {o
       char         **filelist,v         **files;  	       intB         count,         status;f         register int
         i,
         j;         /*0         Select next image from the command line.       */B       status=XGetCommand(display,windows->image.id,&files,&count);       if (!status)	         {tA           Warning("Unable to select image","XGetCommand failed");r!           return((Image *) NULL);x	         } 6       filelist=(char **) malloc(count*sizeof(char *));%       if (filelist == (char **) NULL)f	         {-G           Warning("Unable to select image","Memory allocation failed");t!           XFreeStringList(files);i!           return((Image *) NULL); 	         } 
       j=0;       for (i=1; i < count; i++)          if (*files[i] != '-'):!           filelist[j++]=files[i];w        filelist[j]=(char *) NULL;J       XListBrowserWidget(display,windows,&windows->widget,filelist,"Load",*         "Select Image to Load:",filename);       free((char *) filelist);       XFreeStringList(files);X     }S   if (*filename == '\0')     return((Image *) NULL);    GetImageInfo(&image_info);.   (void) strcpy(image_info.filename,filename);   SetImageInfo(&image_info);)   if (strcmp(image_info.magick,"X") == 0)t     {p
       char         seconds[MaxTextLength];          /*8         User may want to delay the X server screen grab.       */!       (void) strcpy(seconds,"0");oP       (void) XDialogWidget(display,windows,"Grab","Enter any delay in seconds:",         seconds);()       XDelay(display,1000*atoi(seconds));      } 0   if ((strcmp(image_info.magick,"CMYK") == 0) ||0       (strcmp(image_info.magick,"GRAY") == 0) ||/       (strcmp(image_info.magick,"MAP") == 0) || 1       (strcmp(image_info.magick,"MATTE") == 0) ||w/       (strcmp(image_info.magick,"RGB") == 0) ||C0       (strcmp(image_info.magick,"TEXT") == 0) ||0       (strcmp(image_info.magick,"TILE") == 0) ||0       (strcmp(image_info.magick,"UYVY") == 0) ||.       (strcmp(image_info.magick,"XC") == 0) ||/       (strcmp(image_info.magick,"YUV") == 0) ||;.       (strcmp(image_info.magick,"YUV3") == 0))     {        static chara,         geometry[MaxTextLength] = "512x512";         /*)         Request image size from the user.;       */;       if (resource_info->image_info->size != (char *) NULL)N@         (void) strcpy(geometry,resource_info->image_info->size);/       resource_info->image_info->size=geometry;s2       (void) XDialogWidget(display,windows,"Load",.         "Enter the image geometry:",geometry);     }    /*     Load the image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);4   loaded_image=ReadImage(resource_info->image_info);)   XSetCursorState(display,windows,False); %   if (loaded_image != (Image *) NULL)fC     XClientMessage(display,windows->image.id,windows->im_protocols,f*       windows->im_next_image,CurrentTime);   else     { 
       char         *text,         **textlist;   
       FILE         *file;  	       intn
         c;         register charw         *p;          unsigned int         length;y         /*         Unknown image format.:       */(       file=(FILE *) fopen(filename,"r");        if (file == (FILE *) NULL)         return((Image *) NULL);t       length=MaxTextLength;(0       text=(char *) malloc(length*sizeof(char));/       for (p=text ; text != (char *) NULL; p++)        {W         c=fgetc(file);         if (c == EOF)r           break;!         if ((p-text+1) >= length)u           {              *p='\0';             length<<=1;hE             text=(char *) realloc((char *) text,length*sizeof(char));o&             if (text == (char *) NULL)               break;              p=text+strlen(text);           }f         *p=(unsigned char) c;t       }        (void) fclose(file);        if (text == (char *) NULL)         return((Image *) NULL);u       *p='\0';"       textlist=StringToList(text);%       if (textlist != (char **) NULL) 	         {_           char!             title[MaxTextLength];h             register int             i;  >           (void) sprintf(title,"Unknown format: %s",filename);M           XTextViewWidget(display,resource_info,windows,True,title,textlist);e6           for (i=0; textlist[i] != (char *) NULL; i++)'             free((char *) textlist[i]);n"           free((char *) textlist);	         }%       free((char *) text);     }i   return(loaded_image);f }, p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %iO %                                                                             % O %                                                                             % O %   X M a g i c k C o m m a n d                                               %rO %                                                                             %3O %                                                                             %aO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %nI %  Function XMagickCommand makes a transform to the image or Image window : %  as specified by a user menu button or keyboard command. %a/ %  The format of the XMagickCommand routine is:- %aE %    loaded_image=XMagickCommand(display,resource_info,windows,state,u %      key_symbol,image) % + %  A description of each parameter follows:  % G %    o loaded_image:  Function XMagickCommand returns an image when the I %      user chooses 'Load Image' from the command menu.  Otherwise a null  %      image is returned.e %eD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %a< %    o windows: Specifies a pointer to a XWindows structure. %- %    o state: key mask.  %v2 %    o key_symbol: Specifies a command to perform. % G %    o image: Specifies a pointer to a Image structure;  XMagickCommandE> %      may transform the image and return a new image pointer. %  %  */K static Image *XMagickCommand(Display *display,XResourceInfo *resource_info, G   XWindows *windows,unsigned int state,KeySym key_symbol,Image **image)r {i   char
     *argv[5],e     geometry[MaxTextLength],$     modulate_factors[MaxTextLength];     Image      *cache_image,a     *loaded_image;     ImageInfo      image_info;f     int      x,     y;  
   static char&"     color[MaxTextLength] = "gray",     delta[MaxTextLength] = "",     Digits[]="01234567890";      static KeySym.     last_symbol = XK_0;i     static Image!     *redo_image = (Image *) NULL, !     *undo_image = (Image *) NULL;      unsigned int     height,-     status,-
     width;  (   XCheckRefreshWindows(display,windows);3   if ((key_symbol >= XK_0) && (key_symbol <= XK_9))      {e<       if (!((last_symbol >= XK_0) && (last_symbol <= XK_9)))	         {.           *delta='\0';#           resource_info->quantum=1; 	         }i       last_symbol=key_symbol;f"       delta[strlen(delta)+1]='\0';3       delta[strlen(delta)]=Digits[key_symbol-XK_0]; )       resource_info->quantum=atoi(delta);-       return((Image *) NULL);f     })   last_symbol=key_symbol;g   switch (key_symbol)o   {o     case XK_Break:     {        /*1         Free memory from the undo and redo cache._       */*       while (undo_image != (Image *) NULL)       {          cache_image=undo_image;S(         undo_image=undo_image->previous;(         DestroyImage(cache_image->list);"         DestroyImage(cache_image);       }         undo_image=(Image *) NULL;'       if (redo_image != (Image *) NULL)l!         DestroyImage(redo_image);(        redo_image=(Image *) NULL;       return((Image *) NULL);p     }n     case XK_u:     case XK_Undo:      {i       /*+         Undo the last image transformation.o       */'       if (undo_image == (Image *) NULL) 	         {f           XBell(display,0);;!           return((Image *) NULL);c	         }        cache_image=undo_image;o&       undo_image=undo_image->previous;?       windows->image.window_changes.width=cache_image->columns;t=       windows->image.window_changes.height=cache_image->rows; 8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);9       windows->image.crop_geometry=cache_image->geometry;n'       if (redo_image != (Image *) NULL)s!         DestroyImage(redo_image);i       redo_image=(*image);       *image=cache_image->list;         DestroyImage(cache_image);        if (windows->image.orphan)         return((Image *) NULL); D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        return((Image *) NULL);w     }>     case XK_Up:o     case XK_KP_Up:     case XK_Down:e     case XK_KP_Down:     case XK_Left:      case XK_KP_Left:     case XK_Right:     case XK_KP_Right:      {d       if (!(state & Mod1Mask))         break;     }      case XK_F3:i     case XK_F5:      case XK_A:     case XK_less:t     case XK_o:     case XK_greater:     case XK_percent:     case XK_t:     case XK_bracketleft:     case XK_bracketright:      case XK_minus:     case XK_bar:     case XK_slash:     case XK_backslash:     case XK_asterisk:      case XK_F6:      case XK_asciitilde::     case XK_equal:     case XK_N:     case XK_F7:W     case XK_F8:o     case XK_F9:,     case XK_g:     case XK_F10:     case XK_F11:     case XK_D:     case XK_P:     case XK_S:     case XK_B:     case XK_E:     case XK_M:     case XK_F13:     case XK_F14:     case XK_O:     case XK_asciicircum:     case XK_Z:     case XK_G:     case XK_numbersign:l     case XK_R:     case XK_a:     case XK_b:     case XK_F:     case XK_x:     case XK_exclam:      case XK_Select:e     case XK_Redo:      {        Image          *previous_image;         unsigned int         bytes;         /*:         Ensure the undo cache has enough memory available.       */       if (state & Mod5Mask)          break;6       bytes=(*image)->packets*sizeof(RunlengthPacket);4       if ((bytes >> 20) > resource_info->undo_cache)         break;        previous_image=undo_image;.       while (previous_image != (Image *) NULL)       { E         bytes+=previous_image->list->packets*sizeof(RunlengthPacket);E#         cache_image=previous_image;E0         previous_image=previous_image->previous;6         if (bytes > (resource_info->undo_cache << 20))           { 4             if (cache_image->next != (Image *) NULL)9               cache_image->next->previous=(Image *) NULL;l,             DestroyImage(cache_image->list);&             DestroyImage(cache_image);           }        }        /*6         Save image before transformations are applied.       */4       cache_image=AllocateImage((ImageInfo *) NULL);(       if (cache_image == (Image *) NULL)         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       (*image)->orphan=True;       cache_image->list=@         CopyImage(*image,(*image)->columns,(*image)->rows,True);       (*image)->orphan=False;>-       XSetCursorState(display,windows,False);<.       if (cache_image->list == (Image *) NULL)	         { $           DestroyImage(cache_image);           break;	         }t8       cache_image->columns=windows->image.ximage->width;6       cache_image->rows=windows->image.ximage->height;9       cache_image->geometry=windows->image.crop_geometry;i8       if (windows->image.crop_geometry != (char *) NULL)	         {yL           cache_image->geometry=(char *) malloc(MaxTextLength*sizeof(char));5           if (cache_image->geometry != (char *) NULL) N             (void) strcpy(cache_image->geometry,windows->image.crop_geometry);	         }t'       if (undo_image == (Image *) NULL) 	         {f!           undo_image=cache_image;+           break;	         } #       undo_image->next=cache_image;D,       undo_image->next->previous=undo_image;"       undo_image=undo_image->next;       break;     }      default:       break;   }i   if (key_symbol ==  XK_Redo)      {        /*+         Redo the last image transformation.        */'       if (redo_image == (Image *) NULL)p	         {+           XBell(display,0); !           return((Image *) NULL);o	         } >       windows->image.window_changes.width=redo_image->columns;<       windows->image.window_changes.height=redo_image->rows;8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);8       windows->image.crop_geometry=redo_image->geometry;       DestroyImage(*image);        *image=redo_image;        redo_image=(Image *) NULL;        if (windows->image.orphan)         return((Image *) NULL); D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);_       return((Image *) NULL);v     }p   /*     Process user command.    */   argv[0]=client_name;   loaded_image=(Image *) NULL;C   windows->image.window_changes.width=windows->image.ximage->width;-E   windows->image.window_changes.height=windows->image.ximage->height;I   switch (key_symbol)w   {t     case XK_l:     {        /*         Load image.:       */C       loaded_image=XLoadImage(display,resource_info,windows,False);        break;     }*     case XK_n:     case XK_space:     {        /*         Display next image.t       */E       XClientMessage(display,windows->image.id,windows->im_protocols,,,         windows->im_next_image,CurrentTime);       break;     }      case XK_f:     case XK_KP_Prior:      case XK_BackSpace:     {        /*         Display former image.e       */E       XClientMessage(display,windows->image.id,windows->im_protocols,a.         windows->im_former_image,CurrentTime);       break;     }p     case XK_F2:      {        /*         Select image.o       */2       (void) chdir(resource_info->home_directory);B       loaded_image=XLoadImage(display,resource_info,windows,True);       break;     }      case XK_s:     {p       /*         Save image.,       */=       status=XSaveImage(display,resource_info,windows,image);        if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to write X image:",               (*image)->filename);           break;	         }        break;     }w     case XK_p:     {a       /*         Print image.       */>       status=XPrintImage(display,resource_info,windows,image);       if (status == False)	         {(C           XNoticeWidget(display,windows,"Unable to print X image:",r              (*image)->filename);           break;	         }        break;     }      case XK_Delete:      {t       static charn'         filename[MaxTextLength] = "\0";          /*         Delete image file.       */<       XFileBrowserWidget(display,windows,"Delete",filename);       if (*filename == '\0')         break;       status=remove(filename);       if (status != False)O         XNoticeWidget(display,windows,"Unable to delete image file:",filename);        break;     }n     case XK_C:     {        static char &         color[MaxTextLength] = "gray",,         geometry[MaxTextLength] = "640x480";         /*'         Query user for canvas geometry.        */M       (void) XDialogWidget(display,windows,"Canvas","Enter canvas geometry:",          geometry);       if (*geometry == '\0')         break;:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0').         break;       /*         Create canvas.       */        GetImageInfo(&image_info);8       (void) sprintf(image_info.filename,"xc:%s",color);       image_info.size=geometry;w*       loaded_image=ReadImage(&image_info);)       free((char *) image_info.filename); E       XClientMessage(display,windows->image.id,windows->im_protocols, ,         windows->im_next_image,CurrentTime);       break;     }t     case XK_comma:     {e       static char #         delay[MaxTextLength] = "5";          /*)         Display next image after pausing.r       */       resource_info->delay=0;h8       (void) XDialogWidget(display,windows,"Slide Show",8         "Pause how many seconds between images:",delay);       if (*delay == '\0')r         break;'       resource_info->delay=atoi(delay);)E       XClientMessage(display,windows->image.id,windows->im_protocols,h,         windows->im_next_image,CurrentTime);       break;     }w     case XK_V:     {e       /*         Visual Image directory.o       */H       loaded_image=XVisualDirectoryImage(display,resource_info,windows);       break;     }o     case XK_F3:g     {        /*         Cut image.       */F       (void) XCropImage(display,resource_info,windows,*image,CutMode);       break;     }v     case XK_F4:a     {l       /*         Copy image.;       */G       (void) XCropImage(display,resource_info,windows,*image,CopyMode);s       break;     }u     case XK_F5:,     {,       /*         Paste image.       */?       status=XPasteImage(display,resource_info,windows,*image);>       if (status == False)	         {tB           XNoticeWidget(display,windows,"Unable to paste X image",              (*image)->filename);           break;	         }/       break;     }-     case XK_at:i     {xC       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }f     case XK_F12:     {        /*         Set user preferences.g       */?       status=XPreferencesWidget(display,resource_info,windows);*       if (status == False)         break;       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);d       (*image)->orphan=False;=)       if (loaded_image != (Image *) NULL)fG         XClientMessage(display,windows->image.id,windows->im_protocols,i.           windows->im_next_image,CurrentTime);       break;     }f     case XK_A:     {u
       char&         image_geometry[MaxTextLength];  <       if ((windows->image.crop_geometry == (char *) NULL) &&@           ((*image)->columns == windows->image.ximage->width) &&>           ((*image)->rows == windows->image.ximage->height) &&.           (resource_info->number_colors == 0))         break;       /*'         Apply size transforms to image.(       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       /**         Crop and/or scale displayed image.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height);eH       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         {s6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;%	         }        windows->image.x=0;        windows->image.y=0; ,       if (resource_info->number_colors != 0)	         {            /*5             Reduce the number of colors in the image.            */1           if (((*image)->class == DirectClass) || B               ((*image)->colors > resource_info->number_colors) ||<               (resource_info->colorspace == GRAYColorspace))>             QuantizeImage(*image,resource_info->number_colors,>               resource_info->tree_depth,resource_info->dither,)               resource_info->colorspace);            SyncImage(*image);	         }%D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);a       break;     }T     case XK_less:i     {c       /*         Half image size.       */L       windows->image.window_changes.width=windows->image.ximage->width >> 1;N       windows->image.window_changes.height=windows->image.ximage->height >> 1;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }e     case XK_o:     {s       /*         Original image size.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;C       (void) XConfigureImage(display,resource_info,windows,*image);c       break;     }y     case XK_greater:     {l       /*         Double the image size.       */L       windows->image.window_changes.width=windows->image.ximage->width << 1;N       windows->image.window_changes.height=windows->image.ximage->height << 1;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }a     case XK_percent:     {;       unsigned int         height,          width;         /*         Resize image.        */)       width=windows->image.ximage->width;n+       height=windows->image.ximage->height;d4       (void) sprintf(geometry,"%ux%u",width,height);4       status=XDialogWidget(display,windows,"Resize",@         "Enter resize geometry (e.g. 640x480, 200%):",geometry);       if (*geometry == '\0')         break;       if (!status)$         (void) strcat(geometry,"!");2       ParseImageGeometry(geometry,&width,&height);0       windows->image.window_changes.width=width;2       windows->image.window_changes.height=height;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }*     case XK_r:     {_       /*2         Restore Image window to its original size.       */8       if ((windows->image.width == (*image)->columns) &&6           (windows->image.height == (*image)->rows) &&:           (windows->image.crop_geometry == (char *) NULL))	         {t           XBell(display,0);            break;	         }v<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {u6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;!           windows->image.x=0;s           windows->image.y=0;a	         }aD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     }      case XK_bracketleft:     {n       /*         Crop image.o       */G       (void) XCropImage(display,resource_info,windows,*image,CropMode);        break;     }e     case XK_bracketright:      {        /*         Chop image.o       */=       status=XChopImage(display,resource_info,windows,image);U       if (status == False)	         {p@           XNoticeWidget(display,windows,"Unable to cut X image",              (*image)->filename);           break;	         }o       break;     }_     case XK_bar:     {*       /*         Flop image scanlines.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flop";;       MogrifyImage(resource_info->image_info,2,argv,image);p-       XSetCursorState(display,windows,False); 8       if (windows->image.crop_geometry != (char *) NULL)	         {x           /*             Flop crop geometry..           */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height);iJ           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,<             height,(int) (*image)->columns-(int) width-x,y);	         }t        if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);a       break;     }l     case XK_minus:     {%       /*         Flip image scanlines.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flip";;       MogrifyImage(resource_info->image_info,2,argv,image);e-       XSetCursorState(display,windows,False); 8       if (windows->image.crop_geometry != (char *) NULL)	         {h           /*             Flip crop geometry.f           */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height);cJ           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,:             height,x,(int) (*image)->rows-(int) height-y);	         }s        if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }d     case XK_slash:     {        /**         Rotate image 90 degrees clockwise.       */D       status=XRotateImage(display,resource_info,windows,90.0,image);       if (status == False)	         {;C           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }        break;     }o     case XK_backslash:     {        /*2         Rotate image 90 degrees counter-clockwise.       */E       status=XRotateImage(display,resource_info,windows,-90.0,image);        if (status == False)	         {eC           XNoticeWidget(display,windows,"Unable to rotate X image",o              (*image)->filename);           break;	         }e       break;     };     case XK_asterisk:      {        /*         Rotate image.n       */C       status=XRotateImage(display,resource_info,windows,0.0,image);/       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",o              (*image)->filename);           break;	         }n       break;     };     case XK_F6:r     {f       static charu.         geometry[MaxTextLength] = "45.0x45.0";         /*0         Query user for shear color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')          break;K       (void) XDialogWidget(display,windows,"Shear","Enter shear geometry:",          geometry);       if (*geometry == '\0')         break;       /*         Shear image.       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image);i,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";L       argv[2]=color;       argv[3]="-shear";        argv[4]=geometry;p;       MogrifyImage(resource_info->image_info,5,argv,image);w-       XSetCursorState(display,windows,False);F<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }a     case XK_t:     {w       /*         Trim image.p       */>       status=XTrimImage(display,resource_info,windows,*image);       if (status == False)	         {.A           XNoticeWidget(display,windows,"Unable to trim X image",i              (*image)->filename);           break;	         }.       break;     }o     case XK_F7:i     {y       static chari)         hue_percent[MaxTextLength] = "3";d         /**         Query user for percent hue change.       */3       (void) XDialogWidget(display,windows,"Apply",):         "Enter percent change in image hue:",hue_percent);       if (*hue_percent == '\0')          break;       /*         Vary the image hue.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);1       (void) strcpy(modulate_factors,"0.0,0.0,");%2       (void) strcat(modulate_factors,hue_percent);       argv[1]="-modulate";       argv[2]=modulate_factors; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_F8:      {        static char 1         saturation_percent[MaxTextLength] = "10";          /*1         Query user for percent saturation change.        */3       (void) XDialogWidget(display,windows,"Apply",%H         "Enter percent change in color saturation:",saturation_percent);&       if (*saturation_percent == '\0')         break;       /*         Vary color saturation.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);-       (void) strcpy(modulate_factors,"0.0,");a9       (void) strcat(modulate_factors,saturation_percent);l       argv[1]="-modulate";       argv[2]=modulate_factors;r;       MogrifyImage(resource_info->image_info,3,argv,image);h-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }e     case XK_F9:u     {        static chari0         brightness_percent[MaxTextLength] = "3";         /*1         Query user for percent brightness change.p       */3       (void) XDialogWidget(display,windows,"Apply", H         "Enter percent change in color brightness:",brightness_percent);&       if (*brightness_percent == '\0')         break;       /*"         Vary the color brightness.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);9       (void) strcpy(modulate_factors,brightness_percent);        argv[1]="-modulate";       argv[2]=modulate_factors; ;       MogrifyImage(resource_info->image_info,3,argv,image);c-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }C     case XK_g:     {a       static char &         factor[MaxTextLength] = "1.6";         /*#         Query user for gamma value.        */P       (void) XDialogWidget(display,windows,"Gamma","Enter gamma value:",factor);       if (*factor == '\0')         break;       /*         Gamma correct image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-gamma";e       argv[2]=factor;f;       MogrifyImage(resource_info->image_info,3,argv,image);t-       XSetCursorState(display,windows,False);.        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);"       break;     }      case XK_F10:     {l       /*#         Sharpen the image contrast.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-contrast";;       MogrifyImage(resource_info->image_info,2,argv,image);g-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }M     case XK_F11:     {i       /*          Dull the image contrast.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="+contrast";;       MogrifyImage(resource_info->image_info,2,argv,image);g-       XSetCursorState(display,windows,False);o        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }e     case XK_equal:     {"       /*4         Perform histogram equalization on the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-equalize";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);*        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_N:     {        /*5         Perform histogram normalization on the image.m       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-normalize";m;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_asciitilde:      {s       /*         Negate colors in image.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-negate";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);c       break;     }      case XK_G:     {        /*#         Convert image to grayscale.p       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colorspace";       argv[2] = "gray"; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_numbersign:      {F       static char &         colors[MaxTextLength] = "256";         /*0         Query user for maximum number of colors.       */6       status=XDialogWidget(display,windows,"Quantize",,         "Maximum number of colors:",colors);       if (*colors == '\0')         break;       /*         Color reduce the image.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colors";       argv[2]=colors; -       argv[3]=status ? "-dither" : "+dither";L;       MogrifyImage(resource_info->image_info,4,argv,image);n-       XSetCursorState(display,windows,False);d        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case XK_D:     {t       /*         Despeckle image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-despeckle";n;       MogrifyImage(resource_info->image_info,2,argv,image);t-       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);s       break;     }e     case XK_P:     {o       /*"         Reduce noise in the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-noise";e;       MogrifyImage(resource_info->image_info,2,argv,image);g-       XSetCursorState(display,windows,False);L        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);l       break;     }      case XK_S:     {V       static charo'         factor[MaxTextLength] = "60.0";a         /*&         Query user for sharpen factor.       */5       (void) XDialogWidget(display,windows,"Sharpen", =         "Enter the sharpening factor (0.0 - 99.9%):",factor);o       if (*factor == '\0')         break;       /*          Sharpen image scanlines.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-sharpen";e       argv[2]=factor;r;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);x       break;     }*     case XK_B:     {        static char.'         factor[MaxTextLength] = "60.0";c         /*#         Query user for blur factor.N       */2       (void) XDialogWidget(display,windows,"Blur",;         "Enter the blurring factor (0.0 - 99.9%):",factor);V       if (*factor == '\0')         break;       /*         Blur an image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-blur";       argv[2]=factor;o;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);C       break;     }>     case XK_E:     {i       static char '         factor[MaxTextLength] = "50.0";          /*#         Query user for edge factor.r       */:       (void) XDialogWidget(display,windows,"Detect Edges",>         "Enter the edge detect factor (0.0 - 99.9%):",factor);       if (*factor == '\0')         break;       /*         Detect edge in image.i       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-edge";       argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image);w-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }o     case XK_M:     {W       /*         Emboss image scanlines._       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-emboss";;       MogrifyImage(resource_info->image_info,2,argv,image);E-       XSetCursorState(display,windows,False);r        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);;       break;     }o     case XK_F13:     {s       static charG$         amount[MaxTextLength] = "2";         /*%         Query user for spread amount.        */4       (void) XDialogWidget(display,windows,"Spread",1         "Enter the displacement amount:",amount);l       if (*amount == '\0')         break;       /*1         Displace image pixels by a random amount.o       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-spread";       argv[2]=amount;l;       MogrifyImage(resource_info->image_info,3,argv,image);)-       XSetCursorState(display,windows,False);o        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);u       break;     }"     case XK_F14:     {i       static char &         degrees[MaxTextLength] = "10";         /*#         Query user for swirl angle._       */L       (void) XDialogWidget(display,windows,"Swirl","Enter the swirl angle:",         degrees);i       if (*degrees == '\0')          break;       /*,         Swirl image pixels about the center.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-swirl";        argv[2]=degrees;;       MogrifyImage(resource_info->image_info,3,argv,image);n-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }=     case XK_O:     {|       /*!         OilPaint image scanlines.N       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-paint"; ;       MogrifyImage(resource_info->image_info,2,argv,image);r-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);r       break;     }      case XK_asciicircum:     {o       static charr*         bevel_width[MaxTextLength] = "10";         /*#         Query user for bevel width.        */O       (void) XDialogWidget(display,windows,"Raise","Bevel width:",bevel_width);-       if (*bevel_width == '\0')          break;       /*         Raise an image.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-raise";o       argv[2]=bevel_width;;       MogrifyImage(resource_info->image_info,3,argv,image);w-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);k       break;     }w     case XK_Z:     {)       static charn)         threshold[MaxTextLength] = "1.5";          /*+         Query user for smoothing threshold.n       */L       (void) XDialogWidget(display,windows,"Segment","Smoothing threshold:",         threshold);        if (*threshold == '\0')e         break;       /*         Segment an image.(       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-segment";_       argv[2]=threshold;;       MogrifyImage(resource_info->image_info,3,argv,image);g-       XSetCursorState(display,windows,False);,        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);n       break;     }*     case XK_R:     {n       /*D         Apply an image processing technique to a region of interest.       */<       (void) XROIImage(display,resource_info,windows,image);       break;     }c     case XK_a:     {U       /*%         Annotate the image with text.        */F       status=XAnnotateEditImage(display,resource_info,windows,*image);       if (status == False)	         {fE           XNoticeWidget(display,windows,"Unable to annotate X image",s              (*image)->filename);           break;	         }p       break;     }t     case XK_d:     {a       /*         Draw image.t       */A       status=XDrawEditImage(display,resource_info,windows,image);a       if (status == False)	         {aH           XNoticeWidget(display,windows,"Unable to draw on the X image",              (*image)->filename);           break;	         }t       break;     }a     case XK_b:     {n       static char.(         geometry[MaxTextLength] = "6x6";         /*1         Query user for border color and geometry.i       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')o         break;8       (void) XDialogWidget(display,windows,"Add Border",+         "Enter border geometry:",geometry);o       if (*geometry == '\0')         break;       /*"         Add a border to the image.       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image);r,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";        argv[2]=color;       argv[3]="-border";       argv[4]=geometry;_;       MogrifyImage(resource_info->image_info,5,argv,image);i-       XSetCursorState(display,windows,False);n<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }      case XK_F:     {o       static charn(         geometry[MaxTextLength] = "6x6";         /*0         Query user for frame color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')a         break;O       (void) XDialogWidget(display,windows,"Add Frame","Enter frame geometry:",t         geometry);       if (*geometry == '\0')         break;       /*1         Surround image with an ornamental border.o       */J       (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,         image); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-mattecolor";       argv[2]=color;       argv[3]="-frame";m       argv[4]=geometry;c;       MogrifyImage(resource_info->image_info,5,argv,image);S-       XSetCursorState(display,windows,False);i<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     },     case XK_x:     {)       /*         Composite image.       */C       status=XCompositeImage(display,resource_info,windows,*image);t       if (status == False)	         {,F           XNoticeWidget(display,windows,"Unable to composite X image",              (*image)->filename);           break;	         }f       break;     };     case XK_c:     {_       /*         Color edit.w       */B       status=XColorEditImage(display,resource_info,windows,image);       if (status == False)	         { G           XNoticeWidget(display,windows,"Unable to pixel edit X image",o              (*image)->filename);           break;	         }t       break;     }      case XK_m:     {a       /*         Matte edit.        */B       status=XMatteEditImage(display,resource_info,windows,image);       if (status == False)	         {oG           XNoticeWidget(display,windows,"Unable to matte edit X image",w              (*image)->filename);           break;	         }L       break;     }      case XK_exclam:_     {h
       char         command[MaxTextLength],           filename[MaxTextLength];  
       FILE         *file;         /*         Edit image comment.g       */"       TemporaryFilename(filename);.       if ((*image)->comments != (char *) NULL)	         {g           register char              *p;s  #           file=fopen(filename,"w"); $           if (file == (FILE *) NULL)
             {tK               XNoticeWidget(display,windows,"Unable to edit image comment",                  filename);               break;
             } 5           for (p=(*image)->comments; *p != '\0'; p++) '             (void) putc((int) *p,file);n!           (void) putc('\n',file);            (void) fclose(file);	         }t5       (void) sprintf(command,EditorCommand,filename);i9       if (resource_info->editor_command != (char *) NULL)fG         (void) sprintf(command,resource_info->editor_command,filename);[,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);$       status=SystemCommand(command);       if (status) N         XNoticeWidget(display,windows,"Unable to edit image comment",command);
       else	         {.1           (void) sprintf(command,"@%s",filename);a'           CommentImage(*image,command);l	         }>       (void) remove(filename);-       XSetCursorState(display,windows,False);U       break;     }s     case XK_i:     {0       /*         Display image info.g       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);I       XDisplayImageInfo(display,resource_info,windows,undo_image,*image);o-       XSetCursorState(display,windows,False);-       break;     }d     case XK_ampersand:     {-       /*         Background image.v       */C       status=XBackgroundImage(display,resource_info,windows,image);o       if (status == False)         break;       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);a       (*image)->orphan=False;y)       if (loaded_image != (Image *) NULL)tG         XClientMessage(display,windows->image.id,windows->im_protocols,s.           windows->im_next_image,CurrentTime);       break;     }a     case XK_z:     {k       /*         Zoom image.t       */"       if (windows->magnify.mapped)2         XRaiseWindow(display,windows->magnify.id);
       else	         {k           /*             Make magnify image.d           */0           XSetCursorState(display,windows,True);K           status=XMakeImage(display,resource_info,&windows->magnify,*image,i<             windows->magnify.width,windows->magnify.height);G           status|=XMakePixmap(display,resource_info,&windows->magnify);i           if (status == False)B             Error("Unable to create magnify image",(char *) NULL);2           XMapRaised(display,windows->magnify.id);1           XSetCursorState(display,windows,False);b	         }u       break;     }i     case XK_H:     {t
       char         command[MaxTextLength],           filename[MaxTextLength];         /*         Show image histogram.n       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);"       TemporaryFilename(filename);@       (void) sprintf(command,HistogramCommand,windows->image.id,%         (*image)->filename,filename);iA       (void) sprintf((*image)->filename,"histogram:%s",filename);;        GetImageInfo(&image_info);,       status=WriteImage(&image_info,*image);       if (status) '         status=!SystemCommand(command);v       if (!status)	         {,I           XNoticeWidget(display,windows,"Unable to show image histogram",v             command);n"           (void) remove(filename);	         }-       XDelay(display,1500);d-       XSetCursorState(display,windows,False);r       break;     }s     case XK_h:     case XK_F1:w     case XK_Help:d     {L       /*         User requested help.       */:       XTextViewWidget(display,resource_info,windows,False,1         "Help Viewer - Display",ImageMagickHelp);        break;     }o     case XK_Find:      {-
       Atom         mozilla_atom;i  
       char         command[MaxTextLength];f         Window         mozilla_window,g         root_window;         /*-         Browse the ImageMagick documentation.n       */?       root_window=XRootWindow(display,XDefaultScreen(display));fA       mozilla_atom=XInternAtom(display,"_MOZILLA_VERSION",False); I       mozilla_window=XWindowByProperty(display,root_window,mozilla_atom);a*       if (mozilla_window != (Window) NULL)
         {            /*@             Display documentation using Netscape remote control.           */B           (void) sprintf(command,"openURL(%s,new-window,noraise)",             DocumentationURL);E           mozilla_atom=XInternAtom(display,"_MOZILLA_COMMAND",False); J           XChangeProperty(display,mozilla_window,mozilla_atom,XA_STRING,8,M             PropModeReplace,(const unsigned char *) command,strlen(command));,1           XSetCursorState(display,windows,False);b           break;
         } M       (void) sprintf(command,resource_info->browse_command,DocumentationURL);;4       (void) XDialogWidget(display,windows,"Browse",1         "Browse documentation command:",command);d       if (*command == '\0')t         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);$       status=SystemCommand(command);       if (status) P         XNoticeWidget(display,windows,"Unable to browse documentation",command);       XDelay(display,1500); -       XSetCursorState(display,windows,False);d       break;     }i     case XK_v:     {t,       XNoticeWidget(display,windows,Version,?         "Copyright 1996 E. I. du Pont de Nemours and Company");i       break;     }t     case XK_q:     {o       /*         Exit program.r       */'       if (!resource_info->confirm_exit)vG         XClientMessage(display,windows->image.id,windows->im_protocols,>(           windows->im_exit,CurrentTime);
       else	         {p           /*!             Confirm program exit.-           */M           status=XConfirmWidget(display,windows,"Do you really want to exit",e             client_name);w           if (status == True)dK             XClientMessage(display,windows->image.id,windows->im_protocols, ,               windows->im_exit,CurrentTime);	         }i       break;     }e     case XK_Next:s     case XK_Prior:     case XK_Home:      case XK_KP_Home:     {f9       XTranslateImage(display,windows,*image,key_symbol);;       break;     };     case XK_Up:.     case XK_KP_Up:     case XK_Down:r     case XK_KP_Down:     case XK_Left:.     case XK_KP_Left:     case XK_Right:     case XK_KP_Right:e     {s       if (state & Mod1Mask)o	         {S           RectangleInfol             crop_info;             /*.             Trim one pixel from edge of image.           */           crop_info.x=0;           crop_info.y=0;7           crop_info.width=windows->image.ximage->width;-9           crop_info.height=windows->image.ximage->height;g@           if ((key_symbol == XK_Up) || (key_symbol == XK_KP_Up))
             {y=               if (resource_info->quantum >= crop_info.height)p:                 resource_info->quantum=crop_info.height-1;7               crop_info.height-=resource_info->quantum;f
             }WD           if ((key_symbol == XK_Down) || (key_symbol == XK_KP_Down))
             { K               if (resource_info->quantum >= (crop_info.height-crop_info.y)) F                 resource_info->quantum=crop_info.height-crop_info.y-1;2               crop_info.y+=resource_info->quantum;7               crop_info.height-=resource_info->quantum;c
             }nD           if ((key_symbol == XK_Left) || (key_symbol == XK_KP_Left))
             {e<               if (resource_info->quantum >= crop_info.width)9                 resource_info->quantum=crop_info.width-1;;6               crop_info.width-=resource_info->quantum;
             }aF           if ((key_symbol == XK_Right) || (key_symbol == XK_KP_Right))
             {mJ               if (resource_info->quantum >= (crop_info.width-crop_info.x))E                 resource_info->quantum=crop_info.width-crop_info.x-1;w2               crop_info.x+=resource_info->quantum;6               crop_info.width-=resource_info->quantum;
             }|H           if ((windows->image.x+windows->image.width) > crop_info.width)B             windows->image.x=crop_info.width-windows->image.width;J           if ((windows->image.y+windows->image.height) > crop_info.height)D             windows->image.y=crop_info.height-windows->image.height;>           XSetCropGeometry(display,windows,&crop_info,*image);>           windows->image.window_changes.width=crop_info.width;@           windows->image.window_changes.height=crop_info.height;E           XSetWindowBackgroundPixmap(display,windows->image.id,None);rG           (void) XConfigureImage(display,resource_info,windows,*image);d           break;	         }p9       XTranslateImage(display,windows,*image,key_symbol);d       break;     }r     case XK_Return:d     case XK_KP_Enter:n     case XK_Select:        break;     default:     { %       if (!IsModifierKey(key_symbol))o         XBell(display,0);        break;     };   }G   return(loaded_image);a }n m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             %CO %                                                                             %LO %                                                                             %iO %   X M a g n i f y I m a g e                                                 %lO %                                                                             %hO %                                                                             %sO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s % F %  Function XMagnifyImage magnifies portions of the image as indicatedL %  by the pointer.  The magnified portion is displayed in a separate window. %a. %  The format of the XMagnifyImage routine is: %p) %    XMagnifyImage(display,windows,event)a %_+ %  A description of each parameter follows:_ %tE %    o display: Specifies a connection to an X server;  returned fromr %      XOpenDisplay. %e< %    o windows: Specifies a pointer to a XWindows structure. %pH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.S %r %i */= static void XMagnifyImage(Display *display,XWindows *windows,e   XEvent *event) {    char     text[MaxTextLength];     register int     x,     y;     unsigned long 
     state;     /*>     Update magnified image until the mouse button is released.   */C   XDefineCursor(display,windows->image.id,windows->magnify.cursor);i   state=DefaultState;f   x=event->xbutton.x;w   y=event->xbutton.y;d(   windows->magnify.x=windows->image.x+x;(   windows->magnify.y=windows->image.y+y;   do   {)     /*F       Map and unmap Info widget as text cursor crosses its boundaries.     */     if (windows->info.mapped)p       {i:         if ((x < (windows->info.x+windows->info.width)) &&9             (y < (windows->info.y+windows->info.height)))tI           XWithdrawWindow(display,windows->info.id,windows->info.screen);o       }u     else8       if ((x > (windows->info.x+windows->info.width)) ||7           (y > (windows->info.y+windows->info.height)))a-         XMapWindow(display,windows->info.id);n     if (windows->info.mapped)f       {t
         /*#           Display pointer position.i
         */N         (void) sprintf(text," %+d%+d ",windows->magnify.x,windows->magnify.y);*         XInfoWidget(display,windows,text);       }o     /*       Wait for next event.     */:     XIfEvent(display,event,XScreenEvent,(char *) windows);     switch (event->type)     {        case ButtonPress:p         break;       case ButtonRelease:t       {F
         /*-           User has finished magnifying image.(
         */         x=event->xbutton.x;f         y=event->xbutton.y;p         state|=ExitState;          break;       }g       case Expose:         break;       case MotionNotify:       {U
         /*/           Discard pending button motion events.w
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));         x=event->xmotion.x;s         y=event->xmotion.y;i         break;       }d       default:         break;     }(     /*        Check boundary conditions.     */     if (x < 0)
       x=0;     else$       if (x >= windows->image.width)!         x=windows->image.width-1;d     if (y < 0)
       y=0;     else$      if (y >= windows->image.height)!        y=windows->image.height-1;s!   } while (!(state & ExitState));f   /*     Display magnified image.   */)   XSetCursorState(display,windows,False);w }i e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %aO %                                                                             % O %                                                                             %dO %   X M a g n i f y W i n d o w C o m m a n d                                 % O %                                                                             %SO %                                                                             %uO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%| % M %  Function XMagnifyWindowCommand moves the image within an Magnify window byu, %  one pixel as specified by the key symbol. %y6 %  The format of the XMagnifyWindowCommand routine is: %o< %    XMagnifyWindowCommand(display,windows,state,key_symbol) %s+ %  A description of each parameter follows:r %=D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %r %    o state: key mask.x % M %    o key_symbol: Specifies a KeySym which indicates which side of the imagen %      to trim.m %. %; */E static void XMagnifyWindowCommand(Display *display,XWindows *windows,d'   unsigned int state,KeySym key_symbol)  {/   unsigned int     quantum;     /*0     User specified a magnify factor or position.   */   quantum=1;   if (state & Mod1Mask)I     quantum=10;o   switch (key_symbol)>   {i     case XK_q:     {lK       XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);P       break;     }i     case XK_Home:1     case XK_KP_Home:     {=3       windows->magnify.x=windows->image.width >> 1;e4       windows->magnify.y=windows->image.height >> 1;       break;     }c     case XK_Left:e     case XK_KP_Left:     {*!       if (windows->magnify.x > 0)r$         windows->magnify.x-=quantum;       break;     }e     case XK_Up:p     case XK_KP_Up:     {>!       if (windows->magnify.y > 0)=$         windows->magnify.y-=quantum;       break;     }a     case XK_Right:     case XK_KP_Right:a     {e8       if (windows->magnify.x < (windows->image.width-1))$         windows->magnify.x+=quantum;       break;     }a     case XK_Down:N     case XK_KP_Down:     {s9       if (windows->magnify.y < (windows->image.height-1))|$         windows->magnify.y+=quantum;       break;     }_     case XK_0:     case XK_1:     case XK_2:     case XK_3:     case XK_4:     case XK_5:     case XK_6:     case XK_7:     case XK_8:     case XK_9:     {o,       windows->magnify.data=key_symbol-XK_0;       break;     },     case XK_KP_0:p     case XK_KP_1:.     case XK_KP_2:n     case XK_KP_3:n     case XK_KP_4:s     case XK_KP_5:(     case XK_KP_6:e     case XK_KP_7:s     case XK_KP_8:d     case XK_KP_9:w     {|/       windows->magnify.data=key_symbol-XK_KP_0;.       break;     }      default:       break;   }.%   XMakeMagnifyImage(display,windows);/ }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %eO %                                                                             %iO %                                                                             %fO %   X M a k e P a n I m a g e                                                 %mO %                                                                             % O %                                                                             %lO %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eM %  Function XMakePanImage creates a thumbnail of the image and displays it in  %  the Pan icon window.  % . %  The format of the XMakePanImage routine is: %,9 %      XMakePanImage(display,resource_info,windows,image)  %f+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from. %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %dF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.a %* %U */H static void XMakePanImage(Display *display,XResourceInfo *resource_info,!   XWindows *windows,Image *image)( {e   unsigned int     status;l     /*.     Create and display image for panning icon.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   windows->pan.x=windows->image.x;"   windows->pan.y=windows->image.y;>   status=XMakeImage(display,resource_info,&windows->pan,image,,     windows->pan.width,windows->pan.height);;   status|=XMakePixmap(display,resource_info,&windows->pan);i   if (status == False);     Error("Unable to create Pan icon image",(char *) NULL);nJ   XSetWindowBackgroundPixmap(display,windows->pan.id,windows->pan.pixmap);(   XClearWindow(display,windows->pan.id);%   XDrawPanRectangle(display,windows);M)   XSetCursorState(display,windows,False);  }o n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             % O %                                                                             %dO %                                                                             % O %   X M a t t a E d i t I m a g e                                             %eO %                                                                             % O %                                                                             %eO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XMatteEditImage allows the user to interactively changeBM %  the Matte channel of an image.  If the image is PseudoClass it is promotednH %  to DirectClass before the matte information is stored.  The floodfillL %  algorithm is strongly based on a similiar algorithm in "Graphics Gems" by %  Paul Heckbert.  % 0 %  The format of the XMatteEditImage routine is: %29 %    XMatteEditImage(display,resource_info,windows,image)2 % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.v %.< %    o windows: Specifies a pointer to a XWindows structure. %nE %    o image: Specifies a pointer to a Image structure; returned fromh %      ReadImage.t %  */  H static void MatteFloodfill(Image *image,int x,int y,int matte,int delta) {f   intr     offset,t	     skip, 
     start,     x1,      x2;      register RunlengthPacket     *pixel;m     register XSegment      *p;      RunlengthPacket      target;   
   XSegment     *segment_stack;d     /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return;='   if ((x < 0) || (x >= image->columns))X     return;(+   target=image->pixels[y*image->columns+x]; -   if (target.index == (unsigned short) matte)g     return;    /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)-     {d@       Warning("Unable to floodfill","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */
   start=0;   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);i   while (p > segment_stack)    {      /*       Pop segment off stack.     */     p--;
     x1=p->x1;y
     x2=p->x2;n     offset=p->y2;      y=p->y1+offset;      /*5       Update matte information in neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     { /       pixel=image->pixels+(y*image->columns+x); +       if (!MatteMatch(*pixel,target,delta))k         break;*       pixel->index=(unsigned short) matte;     })     skip=x >= x1;a     if (!skip)       {g         start=x+1;         if (start < x1) %           Push(y,start,x1-1,-offset);          x=x1+1;3       }      do     {        if (!skip)	         {g*           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x);a1             if (!MatteMatch(*pixel,target,delta))                break;0             pixel->index=(unsigned short) matte;           } #           Push(y,start,x-1,offset);,           if (x > (x2+1)) %             Push(y,x2+1,x-1,-offset); 	         }        skip=False;o       for (x++; x <= x2 ; x++)       {a1         pixel=image->pixels+(y*image->columns+x);.,         if (MatteMatch(*pixel,target,delta))           break;       }        start=x;     } while (x <= x2);   }    free((char *) segment_stack);  }   5 static unsigned int XMatteEditImage(Display *display, ?   XResourceInfo *resource_info,XWindows *windows,Image **image)  {/ #define MatteEditMethodOp  0 #define MatteEditDeltaOp  1m #define MatteEditValueOp  2  #define MatteEditUndoOp  3 #define MatteEditHelpOp  4 #define MatteEditDismissOp  5   
   static chari     *MatteEditMenu[]=r     {,       "Method",        "Delta",       "Matte Value",
       "Undo",g
       "Help",        "Dismiss",       (char *) NULL      };     char     command[MaxTextLength],c     text[MaxTextLength];     Cursor     cursor;/     int 
     entry,     id,d     x,
     x_offset,o     y,
     y_offset;F     register int     i;     register RunlengthPacket     *p;   
   static char      matte[MaxTextLength] = "0";a     static unsigned int,     delta = 0,     method = PointMethodOp;i     unsigned int     height, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Matte Edit";i   windows->command.data=2;G   (void) XCommandWidget(display,windows,MatteEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);4   /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    state=DefaultState;e   do   {y     if (windows->info.mapped)        { 
         /*#           Display pointer position.o
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget.d
         */@         id=XCommandWidget(display,windows,MatteEditMenu,&event);         if (id < 0)a           {a<             XDefineCursor(display,windows->image.id,cursor);             continue;:           }%         switch (id) 	         {c!           case MatteEditMethodOp:t           {              static char(               *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.i             */             entry=P               XMenuWidget(display,windows,MatteEditMenu[id],MethodMenu,command);             if (entry >= 0)                method=entry;              break;           }t            case MatteEditDeltaOp:           {              static char                *DeltaMenu[]=e               {a                 "0",                 "1",                 "2",                 "4",                 "8",                 "16",f                 "32",                  (char *) NULL,                 (char *) NULL,               },)               value[MaxTextLength] = "3";.               /*8               Select a delta value from the pop-up menu.             */%             DeltaMenu[7]="Dialog...";wJ             entry=XMenuWidget(display,windows,MatteEditMenu[id],DeltaMenu,               command);C             if (entry < 0)               break;             if (entry != 7)_               {u-                 delta=atoi(DeltaMenu[entry]);n                 break;               } K             (void) XDialogWidget(display,windows,"Ok","Enter delta value:",                value);_             if (*value == '\0')                break;             delta=atoi(value);             break;           }G            case MatteEditValueOp:           {              /*0               Request matte value from the user.             */N             (void) XDialogWidget(display,windows,"Matte","Enter matte value:",               matte);i             break;           }n           case MatteEditUndoOp:X           { B             (void) XMagickCommand(display,resource_info,windows,0,#               (KeySym) XK_u,image);-             break;           }a           case MatteEditHelpOp:k           {i@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);-             break;           }p"           case MatteEditDismissOp:           {d             /*               Prematurely exit.i             */             state|=EscapeState;i             state|=ExitState;              break;           }n           default:             break;	         } 8         XDefineCursor(display,windows->image.id,cursor);         continue;a       }p     switch (event.type)a     {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           {n.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }e
         /*           Update matte data.
         */         x=event.xbutton.x;         y=event.xbutton.y;>         (void) XMagickCommand(display,resource_info,windows,0,$           (KeySym) XK_Select,image);(         state|=UpdateConfigurationState;         break;       }d       case ButtonRelease:m       { 
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image);;*         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }o       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;-  3         if (event.xkey.window != windows->image.id)l           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),./           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {a           case XK_Escape:f           case XK_F20:           {n             /*               Prematurely exit.              */             state|=ExitState;d             break;           }            case XK_F1:o           case XK_Help:i           {w@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);l             break;           }            default:           {              XBell(display,0);i             break;           } 	         }          break;       }b       case MotionNotify:       {r
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap Info widget as cursor crosses its boundaries.g
         */!         if (windows->info.mapped)            {d>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))r1             XMapWindow(display,windows->info.id);.         break;       }        default:         break;     }c     x_offset=x;      y_offset=y; )     if (state & UpdateConfigurationState)5       {          int           x,m          y;x  
         /*8           Matte edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True); :         XPutPixel(windows->image.ximage,x_offset,y_offset,=           windows->image.pixel_info->background_color.pixel);          x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,              &width,&height);=         x_factor=UpShift(width)/windows->image.ximage->width;cC         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x;-?         y_factor=UpShift(height)/windows->image.ximage->height;iC         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y;w-         if ((x_offset < 0) || (y_offset < 0))            continue;yL         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue; $         (*image)->class=DirectClass;         if (!(*image)->matte))           {              /*$               Initialize matte data.             */             p=(*image)->pixels;o1             for (i=0; i < (*image)->packets; i++) 
             {d               p->index=Opaque;               p++;
             }f!             (*image)->matte=True;            }p         switch (method) 	         {.           case PointMethodOp:e           default:           {C             /*=               Update matte information using point algorithm.a             */)             if (!UncompressImage(*image))s               break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset); (             p->index=atoi(matte) & 0xff;             break;           }            case ReplaceMethodOp:o           {              RunlengthPacket=               target;&               /*?               Update matte information using replace algorithm.              */             x=0;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             {                x+=(p->length+1); <               if (x > (y_offset*(*image)->columns+x_offset))                 break;               p++;
             } '             target=(*image)->pixels[i];              p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             { .               if (ColorMatch(*p,target,delta)),                 p->index=atoi(matte) & 0xff;               p++;
             }w             break;           }.!           case FloodfillMethodOp:            {              /*A               Update matte information using floodfill algorithm.              */)             if (!UncompressImage(*image))d               break;N             MatteFloodfill(*image,x_offset,y_offset,atoi(matte) & 0xff,delta);             break;           }s           case ResetMethodOp:            {a             /*=               Update matte information using reset algorithm.w             */             p=(*image)->pixels;t1             for (i=0; i < (*image)->packets; i++))
             { *               p->index=atoi(matte) & 0xff;               p++;
             }P/             if ((atoi(matte) & 0xff) == Opaque) $               (*image)->matte=False;             break;           } 	         }W+         state&=(~UpdateConfigurationState);r       } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             % O %                                                                             %cO %   X P a n I m a g e                                                         %.O %                                                                             % O %                                                                             %.O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %iH %  Function XPanImage pans the image until the mouse button is released. %,* %  The format of the XPanImage routine is: % % %    XPanImage(display,windows,event)  % + %  A description of each parameter follows:L %)E %    o display: Specifies a connection to an X server;  returned from, %      XOpenDisplay. %_< %    o windows: Specifies a pointer to a XWindows structure. % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.  %o */G static void XPanImage(Display *display,XWindows *windows,XEvent *event)m {(   char     text[MaxTextLength];     Cursor     cursor;n     RectangleInfo 
     pan_info;      unsigned longv
     state,
     x_factor,n
     y_factor;      /*     Define cursor.   */>   if ((windows->image.ximage->width > windows->image.width) &&>       (windows->image.ximage->height > windows->image.height))/     cursor=XCreateFontCursor(display,XC_fleur);o   else<     if (windows->image.ximage->width > windows->image.width)=       cursor=XCreateFontCursor(display,XC_sb_h_double_arrow);t     else@       if (windows->image.ximage->height > windows->image.height)?         cursor=XCreateFontCursor(display,XC_sb_v_double_arrow);s
       else3         cursor=XCreateFontCursor(display,XC_arrow);o0   XDefineCursor(display,windows->pan.id,cursor);   /*B     Pan image as pointer moves until the mouse button is released.   */   x_factor=(unsigned long)=     UpShift(windows->image.ximage->width)/windows->pan.width;    y_factor=(unsigned long)?     UpShift(windows->image.ximage->height)/windows->pan.height; I   pan_info.width=(unsigned int) (UpShift(windows->image.width)/x_factor); K   pan_info.height=(unsigned int) (UpShift(windows->image.height)/y_factor); !   state=UpdateConfigurationState;e   do   {y     switch (event->type)     {        case ButtonPress:o       { 
         /*.           User choose an initial pan location.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;(         state|=UpdateConfigurationState;         break;       }a       case ButtonRelease:p       { 
         /*.           User has finished panning the image.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;4         state|=UpdateConfigurationState | ExitState;         break;       }d       case MotionNotify:       {d
         /*/           Discard pending button motion events.p
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));$         pan_info.x=event->xmotion.x;$         pan_info.y=event->xmotion.y;(         state|=UpdateConfigurationState;       }f       default:         break;     } )     if (state & UpdateConfigurationState)=       {-
         /*$           Check boundary conditions.
         */J         pan_info.x=DownShift((pan_info.x-(pan_info.width >> 1))*x_factor);         if (pan_info.x < 0)+           pan_info.x=0;          elseO           if ((pan_info.x+windows->image.width) > windows->image.ximage->width)pI             pan_info.x=windows->image.ximage->width-windows->image.width;iK         pan_info.y=DownShift((pan_info.y-(pan_info.height >> 1))*y_factor);d         if (pan_info.y < 0)            pan_info.y=0;o         else2           if ((pan_info.y+windows->image.height) >-                windows->image.ximage->height) K             pan_info.y=windows->image.ximage->height-windows->image.height; /         if ((windows->image.x != pan_info.x) || -             (windows->image.y != pan_info.y))            {o             /*'               Display image pan offset.n             */(             windows->image.x=pan_info.x;(             windows->image.y=pan_info.y;E             (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,xG               windows->image.height,windows->image.x,windows->image.y); .             XInfoWidget(display,windows,text);             /*#               Refresh Image window.p             *//             XDrawPanRectangle(display,windows);iD             XRefreshWindow(display,&windows->image,(XEvent *) NULL);           } +         state&=(~UpdateConfigurationState);n       }n     /*       Wait for next event.     */     if (!(state & ExitState))e<       XIfEvent(display,event,XScreenEvent,(char *) windows);!   } while (!(state & ExitState));n   /*     Restore cursor.a   */=   XDefineCursor(display,windows->pan.id,windows->pan.cursor);y   XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);= }K : /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %lO %                                                                             %aO %   X P a s t e I m a g e                                                     %+O %                                                                             %IO %                                                                             %)O %                                                                             %yO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %iH %  Function XPasteImage pastes an image previously saved with XCropImageI %  in the X window image at a location the user chooses with the pointer.  % , %  The format of the XPasteImage routine is: % < %    status=XPasteImage(display,resource_info,windows,image) %l+ %  A description of each parameter follows:. %o@ %    o status: Function XPasteImage returns True if the image isI %      pasted.  False is returned is there is a memory shortage or if the   %      image fails to be pasted. %bE %    o display: Specifies a connection to an X server;  returned fromw %      XOpenDisplay. %nK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.c %d< %    o windows: Specifies a pointer to a XWindows structure. %mE %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %( */N static unsigned int XPasteImage(Display *display,XResourceInfo *resource_info,!   XWindows *windows,Image *image)  {  #define PasteModeOperatorsOp  0f #define PasteModeHelpOp  1 #define PasteModeDismissOp  2i  
   static char      *PasteModeMenu[]=a     {d       "Operator",r
       "Help",,       "Dismiss",       (char *) NULLg     };     char     text[MaxTextLength];     Cursor     cursor;>     Imaget     *paste_image;i     intg     id,      x,     y;     RectangleInfos     highlight_info,      paste_info;m     static unsigned int #     operation = ReplaceCompositeOp;n     unsigned int     height,f
     width;     unsigned long      scale_factor,(
     state;     XEvent
     event;     /*     Copy image.f   */#   if (copy_image == (Image *) NULL)w     return(False);   copy_image->orphan=True;N   paste_image=CopyImage(copy_image,copy_image->columns,copy_image->rows,True);   copy_image->orphan=False;m   /*     Map Command widget.w   */    windows->command.name="Paste";   windows->command.data=1;G   (void) XCommandWidget(display,windows,PasteModeMenu,(XEvent *) NULL);o*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,.+     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */)   XSetCursorState(display,windows,False);r2   XQueryPosition(display,windows->image.id,&x,&y);"   paste_info.x=windows->image.x+x;"   paste_info.y=windows->image.y+y;   paste_info.width=0;e   paste_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);y0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {C     if (windows->info.mapped)n       { 
         /*#           Display pointer position.d
         */B         (void) sprintf(text," %+d%+d ",paste_info.x,paste_info.y);*         XInfoWidget(display,windows,text);       }w     highlight_info=paste_info;3     highlight_info.x=paste_info.x-windows->image.x; 3     highlight_info.y=paste_info.y-windows->image.y;n2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);a2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)        {r
         /*3           Select a command from the Command widget.R
         */@         id=XCommandWidget(display,windows,PasteModeMenu,&event);         if (id < 0)r           continue;%         switch (id)v	         {n$           case PasteModeOperatorsOp:           {              char%               command[MaxTextLength];(               static char                *OperatorMenu[]=               {n                 "over",                  "in",p                 "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",d                 "difference",i                 "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */D             operation=XMenuWidget(display,windows,PasteModeMenu[id],&               OperatorMenu,command)+1;             break;           }e           case PasteModeHelpOp:            { @             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);             break;           }w"           case PasteModeDismissOp:           {              /*               Prematurely exit.              */             state|=EscapeState;e             state|=ExitState;              break;           }            default:             break;	         }m         continue;        }      switch (event.type)e     {        case ButtonPress:        { !         if (resource_info->debug)sB           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 4         if (event.xbutton.window == windows->pan.id)           { .             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           }e
         /*=           Paste rectangle is relative to image configuration. 
         */         x=0;         y=0;         width=image->columns;.         height=image->rows; :         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,d             &width,&height);A         scale_factor=UpShift(width)/windows->image.ximage->width; F         paste_info.width=DownShift(paste_image->columns*scale_factor);C         scale_factor=UpShift(height)/windows->image.ximage->height; D         paste_info.height=DownShift(paste_image->rows*scale_factor);8         XDefineCursor(display,windows->image.id,cursor);6         paste_info.x=windows->image.x+event.xbutton.x;6         paste_info.y=windows->image.y+event.xbutton.y;         break;       }        case ButtonRelease:        {s!         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);o@         if ((paste_info.width != 0) && (paste_info.height != 0))           {i             /*@               User has selected the location of the paste image.             */:             paste_info.x=windows->image.x+event.xbutton.x;:             paste_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;d           }m         break;       }o       case Expose:         break;       case KeyPress:       {d         char!           command[MaxTextLength];,           KeySym           key_symbol;e           ints           length;p  3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),i/           &key_symbol,(XComposeStatus *) NULL);d         *(command+length)='\0';e!         if (resource_info->debug)yN           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol)r	         {e           case XK_Escape:n           case XK_F20:           {a             /*               Prematurely exit.~             */&             DestroyImage(paste_image);             state|=EscapeState;              state|=ExitState;b             break;           }            case XK_F1:-           case XK_Help:            {rJ             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }o           default:           {r             XBell(display,0);U             break;           }a	         }i         break;       }_       case MotionNotify:       {h
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)h           {->             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))*M               XWithdrawWindow(display,windows->info.id,windows->info.screen);m           }w         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))r1             XMapWindow(display,windows->info.id);e(         paste_info.x=windows->image.x+x;(         paste_info.y=windows->image.y+y;         break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);    /*5     Image pasting is relative to image configuration.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;t   height=image->rows;s4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;i   paste_info.x+=x;4   paste_info.x=DownShift(paste_info.x*scale_factor);<   paste_info.width=DownShift(paste_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;r   paste_info.y+=y;4   paste_info.y=DownShift(paste_info.y*scale_factor);>   paste_info.height=DownShift(paste_info.height*scale_factor);   /*$     Paste image with X Image window.   */H   CompositeImage(image,operation,paste_image,paste_info.x,paste_info.y);   DestroyImage(paste_image);)   XSetCursorState(display,windows,False);e   /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image);i>   (void) XConfigureImage(display,resource_info,windows,image);   return(True);f }  w /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %nO %                                                                             %tO %                                                                             % O %   X P r i n t I m a g e                                                     % O %                                                                             %tO %                                                                             %,O %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) %L@ %  Function XPrintImage prints an image to a Postscript printer. %P, %  The format of the XPrintImage routine is: %t< %    status=XPrintImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % ? %    o status: Function XPrintImage return True if the image isaJ %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. %fD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %nK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.t % < %    o windows: Specifies a pointer to a XWindows structure. %lF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.i %w %c */N static unsigned int XPrintImage(Display *display,XResourceInfo *resource_info,"   XWindows *windows,Image **image) {    char     command[MaxTextLength],d     filename[MaxTextLength],     geometry[MaxTextLength];     ImageInfo      *image_info;     intu     status;   
   static charr!     print_command[MaxTextLength];w     /*/     Request Postscript page geometry from user.r   */'   image_info=resource_info->image_info; *   (void) sprintf(geometry,PSPageGeometry);(   if (image_info->page != (char *) NULL)-     (void) strcpy(geometry,image_info->page);nI   XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",s1     "Select Postscript Page Geometry:",geometry);_   if (*geometry == '\0')     return(True);S0   image_info->page=PostscriptGeometry(geometry);   /*      Request file name from user.   */(   XCheckRefreshWindows(display,windows);   TemporaryFilename(filename);<   (void) strcpy(print_command,resource_info->print_command);O   (void) XDialogWidget(display,windows,"Print","Print command:",print_command);n   if (*print_command == '\0')s     return(True);E>   if (strcmp(print_command,resource_info->print_command) != 0)     {n1       resource_info->print_command=print_command;t&       XUserPreferences(resource_info);     }    /*     Print image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image);o(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);6   (void) sprintf((*image)->filename,"ps:%s",filename);'   status=WriteImage(image_info,*image); 1   (void) sprintf(command,print_command,filename);n"   status&=!SystemCommand(command); #ifndef vms    (void) remove(filename); #endif)   XSetCursorState(display,windows,False); M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);    return(status);a }) L /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %wO %                                                                             %;O %                                                                             % O %   X P r o g r e s s M o n i t o r                                           % O %                                                                             %;O %                                                                             % O %                                                                             %MO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % F %  Function XProgressMonitor displays the progress a task is making in %  completing a task.] %r1 %  The format of the XProgressMonitor routine is:( %r* %      XProgressMonitor(task,quantum,span) %e+ %  A description of each parameter follows:  % - %    o task: Identifies the task in progress.s %yO %    o quantum: Specifies the quantum position within the span which representsf< %      how much progress has been made in completing a task. %r> %    o span: Specifies the span relative to completing a task. %) %  */O static void XProgressMonitor(char *task,unsigned int quantum,unsigned int span)  { 4   XMonitorWidget(display,windows,task,quantum,span); }b = /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %wO %   X R O I I m a g e                                                         %mO %                                                                             % O %                                                                             %sO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%> %oG %  Function XROIImage applies an image processing technique to a region  %  of interest.i %w* %  The format of the XROIImage routine is: %o: %    status=XROIImage(display,resource_info,windows,image) %t+ %  A description of each parameter follows:  % > %    o status: Function XROIImage returns True if the image isJ %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %SK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from; %      ReadImage.* %  %  */L static unsigned int XROIImage(Display *display,XResourceInfo *resource_info,"   XWindows *windows,Image **image) {  #define ApplyModeMenus  5, #define ApplyModeFileOp  0 #define ApplyModeEditOp  1 #define ApplyModeTransformOp  2r #define ApplyModeEnhanceOp  3  #define ApplyModeEffectsOp  4i #define ApplyModeHelpOp  5 #define ApplyModeDismissOp  6o #define ROIModeHelpOp  0 #define ROIModeDismissOp  1f  
   static char      *ROIModeMenu[]=      { 
       "Help",        "Dismiss",       (char *) NULL      },     *ApplyModeMenu[]=      { 
       "File", 
       "Edit",        "Transform",       "Enhance",       "Effects",
       "Help",o       "Dismiss",       (char *) NULL      },     *FileMenu[]=     {,       "Image Info",g       (char *) NULL      },     *EditMenu[]=     { 
       "Undo", 
       "Redo",e       (char *) NULL      },     *TransformMenu[]=l     {t
       "Flop",(
       "Flip",n       "Rotate Right",        "Rotate Left",       (char *) NULL,     },     *EnhanceMenu[]=      {        "Hue...",        "Saturation...",       "Brightness...",       "Gamma...",        "Spiff",
       "Dull",=       "Equalize",t       "Normalize",       "Negate",        "Grayscale",       "Quantize...",       (char *) NULL      },     *EffectsMenu[]=      {        "Despeckle",       "Peak Noise",        "Sharpen...",        "Blur...",       "Edge Detect",       "Emboss",p       "Spread",        "Swirl",       "Oil Painting",a       "Raise...",t       "Segment...",        (char *) NULLr     };  
   static char      **Menus[ApplyModeMenus]=     {        FileMenu,o       EditMenu,        TransformMenu,       EnhanceMenu,       EffectsMenu      };     static KeySym)     ApplyModeKeys[]=     {g       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_h, 
       XK_q     },     FileKeys[]=      {p
       XK_i     },     EditKeys[]=t     {,       XK_u, 
       XK_Redoa     },     TransformKeys[]=     { 
       XK_bar,        XK_minus,H       XK_slash,        XK_backslash     },     EnhanceKeys[]=     {        XK_F7,       XK_F8,       XK_F9,       XK_g,m
       XK_F10, 
       XK_F11,g       XK_equal,s       XK_N,l       XK_asciitilde,       XK_G,m       XK_numbersign      },     EffectsKeys[]=     {X       XK_D,e       XK_P,_       XK_S,m       XK_B,        XK_E,        XK_M,p
       XK_F13, 
       XK_F14,t       XK_O,p       XK_asciicircum, 
       XK_Z     };     static KeySym      *Keys[ApplyModeMenus]=     {        FileKeys,e       EditKeys,        TransformKeys,       EnhanceKeys,       EffectsKeys,     };     char     command[MaxTextLength],      text[MaxTextLength];     Cursor     cursor;      inth
     entry,     id,      x,     y;     KeySym     key_symbol;      MonitorHandler     handler;     RectangleInfo8     highlight_info, 
     roi_info;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget..   */   windows->command.name="ROI";   windows->command.data=0;E   (void) XCommandWidget(display,windows,ROIModeMenu,(XEvent *) NULL);,*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,5+     windows->im_update_widget,CurrentTime);e   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);    roi_info.x=windows->image.x+x;    roi_info.y=windows->image.y+y;   roi_info.width=0;f   roi_info.height=0;-   cursor=XCreateFontCursor(display,XC_fleur);aO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |O     PointerMotionMask);    state=DefaultState;o   do   {a     if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */>         (void) sprintf(text," %+d%+d ",roi_info.x,roi_info.y);*         XInfoWidget(display,windows,text);       },     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);d1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */>         id=XCommandWidget(display,windows,ROIModeMenu,&event);         if (id < 0)            continue;i         switch (id) 	         {            case ROIModeHelpOp:l           { @             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);h             break;           }             case ROIModeDismissOp:           {v             /*               Prematurely exit.              */             state|=EscapeState;e             state|=ExitState;(             break;           }            default:             break;	         }          continue;        }      switch (event.type);     {        case ButtonPress:        {t4         if (event.xbutton.window == windows->pan.id)           {R.             XPanImage(display,windows,&event);.             XInfoWidget(display,windows,text);             break;           } ,         if (event.xbutton.button == Button1)           {              /*L               Note first corner of region of interest rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);8             roi_info.x=windows->image.x+event.xbutton.x;8             roi_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;_             break;           }          break;       }        case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);f         switch (key_symbol) 	         {i           case XK_Escape:e           case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;r             state|=ExitState;              break;           }            case XK_F1:f           case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);              break;           }            default:           {              XBell(display,0);w             break;           }b	         }          break;       }f       case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)y           {i>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }w         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);o&         roi_info.x=windows->image.x+x;&         roi_info.y=windows->image.y+y;         break;       }        default:         break;     } !   } while (!(state & ExitState));_O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);_   if (state & EscapeState)     {t       /*5         User want to exit without region of interest.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen);a"       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {c     /*I       Size rectangle as pointer moves until the mouse button is released.d     */     x=roi_info.x;-     y=roi_info.y;n     roi_info.width=0;      roi_info.height=0;     state=DefaultState;n+     XSelectInput(display,windows->image.id,d@       windows->image.attributes.event_mask | PointerMotionMask);     do     {r       highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x;t3       highlight_info.y=roi_info.y-windows->image.y; D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {c           /*?             Display info and draw region of interest rectangle./           */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id);,L           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);W,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         }l
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)x       {%         case ButtonPress:,	         { 6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }h6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;           break;	         }p         case ButtonRelease:>	         {)           /*?             User has committed to region of interest rectangle.F           */6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;1           XSetCursorState(display,windows,False);a           state|=ExitState; 9           if (strcmp(windows->command.name,"Apply") == 0)r             break;(           windows->command.name="Apply";/           windows->command.data=ApplyModeMenus; O           (void) XCommandWidget(display,windows,ApplyModeMenu,(XEvent *) NULL);w           break;	         }          case Expose:           break;         case MotionNotify:	         {l           /*1             Discard pending button motion events.a           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 6           roi_info.x=windows->image.x+event.xmotion.x;6           roi_info.y=windows->image.y+event.xmotion.y;	         }          default:           break;       }.J       if (((roi_info.x != x) && (roi_info.y != y)) || (state & ExitState))	         {u           /*&             Check boundary conditions.           */           if (roi_info.x < 0)              roi_info.x=0;l           else:             if (roi_info.x > windows->image.ximage->width)6               roi_info.x=windows->image.ximage->width;           if (roi_info.x < x)_9             roi_info.width=(unsigned int) (x-roi_info.x);r           else
             {e;               roi_info.width=(unsigned int) (roi_info.x-x);y               roi_info.x=x; 
             }-           if (roi_info.y < 0)i             roi_info.y=0;            else;             if (roi_info.y > windows->image.ximage->height)n7               roi_info.y=windows->image.ximage->height;            if (roi_info.y < y) :             roi_info.height=(unsigned int) (y-roi_info.y);           else
             {E<               roi_info.height=(unsigned int) (roi_info.y-y);               roi_info.y=y; 
             }:	         } #     } while (!(state & ExitState));1+     XSelectInput(display,windows->image.id,m,       windows->image.attributes.event_mask);     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;      do     {P       if (windows->info.mapped) 	         {e           /*%             Display pointer position.m           */L           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);t,           XInfoWidget(display,windows,text);	         }        highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x;H3       highlight_info.y=roi_info.y-windows->image.y; F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;v           state|=ExitState;r           break;	         } $       if (state & UpdateRegionState)	         {fH           XSetFunction(display,windows->image.highlight_context,GXcopy);           switch (key_symbol)g           {t             case XK_i:             case XK_u:             case XK_Undo:t             case XK_Redo:g
             { O               (void) XMagickCommand(display,resource_info,windows,0,key_symbol,w                 image);                break;
             }e             default:
             {u               Imaged                 *roi_image;i                 RectangleInfol                 crop_info;                 /*F                 Region of interest is relative to image configuration.               */?               handler=SetMonitorHandler((MonitorHandler) NULL);o!               crop_info=roi_info;t               x=0;               y=0;&               width=(*image)->columns;$               height=(*image)->rows;@               if (windows->image.crop_geometry != (char *) NULL)I                 (void) XParseGeometry(windows->image.crop_geometry,&x,&y,e"                   &width,&height);G               scale_factor=UpShift(width)/windows->image.ximage->width;u               crop_info.x+=x;o>               crop_info.x=DownShift(crop_info.x*scale_factor);F               crop_info.width=DownShift(crop_info.width*scale_factor);I               scale_factor=UpShift(height)/windows->image.ximage->height;                crop_info.y+=y;n>               crop_info.y=DownShift(crop_info.y*scale_factor);H               crop_info.height=DownShift(crop_info.height*scale_factor);5               roi_image=CropImage(*image,&crop_info); 0               (void) SetMonitorHandler(handler);.               if (roi_image == (Image *) NULL)                 continue;_               /*K                 Apply image processing technique to the region of interest.a               */)               windows->image.orphan=True; K               (void) XMagickCommand(display,resource_info,windows,Mod5Mask, '                 key_symbol,&roi_image); ?               handler=SetMonitorHandler((MonitorHandler) NULL); D               (void) XMagickCommand(display,resource_info,windows,0,*                 (KeySym) XK_Select,image);*               windows->image.orphan=False;A               CompositeImage(*image,ReplaceCompositeOp,roi_image, )                 crop_info.x,crop_info.y); &               DestroyImage(roi_image);0               (void) SetMonitorHandler(handler);               break;
             }o           } !           if (key_symbol != XK_i) 
             {aL               XConfigureImageColormap(display,resource_info,windows,*image);K               (void) XConfigureImage(display,resource_info,windows,*image); 
             }o0           XCheckRefreshWindows(display,windows);,           XInfoWidget(display,windows,text);J           XSetFunction(display,windows->image.highlight_context,GXinvert);&           state&=(~UpdateRegionState);	         }(4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows);*3       if (event.xany.window == windows->command.id) 	         {f           /*5             Select a command from the Command widget.f           */H           XSetFunction(display,windows->image.highlight_context,GXcopy);#           key_symbol=XK_VoidSymbol;2B           id=XCommandWidget(display,windows,ApplyModeMenu,&event);           if (id >= 0)
             {.7               (void) strcpy(command,ApplyModeMenu[id]);n+               key_symbol=ApplyModeKeys[id]; &               if (id < ApplyModeMenus)                 {y                   /*8                     Select a command from a pop-up menu.                   */P                   entry=XMenuWidget(display,windows,ApplyModeMenu[id],Menus[id],                     command); !                   if (entry >= 0)>                     { >                       (void) strcpy(command,Menus[id][entry]);1                       key_symbol=Keys[id][entry];(                     }g                 } 
             } J           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);!           if (key_symbol == XK_h) 
             {_L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);eN               XSetFunction(display,windows->image.highlight_context,GXinvert);               continue; 
             }y!           if (key_symbol == XK_q) 
             {a               /*                 Exit.l               */!               state|=EscapeState;(               state|=ExitState;(               continue;t
             } *           if (key_symbol != XK_VoidSymbol)%             state|=UpdateRegionState;o           continue; 	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type)a       {y         case ButtonPress:u	         {n6           if (event.xbutton.window == windows->pan.id)
             { 0               XPanImage(display,windows,&event);0               XInfoWidget(display,windows,text);               break;
             }i8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x;<-           y=windows->image.y+event.xbutton.y;yK           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) &&cI               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))) 
             {u3               roi_info.x=roi_info.x+roi_info.width;a4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             } K           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) &&i<               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             {h3               roi_info.x=roi_info.x+roi_info.width; .               state|=UpdateConfigurationState;               break;
             }=;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) &&e;               (x > (roi_info.x+roi_info.width-RoiDelta)) &&;I               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta)))f
             {e4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             }d;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) &&>;               (x > (roi_info.x+roi_info.width-RoiDelta)) &&r<               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             {f.               state|=UpdateConfigurationState;               break;
             }=	         }w         case ButtonRelease:*           break;         case Expose:	         {h8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)o               {i1                 event.xexpose.x=highlight_info.x;S1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width;n;                 event.xexpose.height=highlight_info.height;a?                 XRefreshWindow(display,&windows->image,&event);o               },7           if (event.xexpose.window == windows->info.id)t)             if (event.xexpose.count == 0)w0               XInfoWidget(display,windows,text);           break;	         }t         case KeyPress:	         {n5           if (event.xkey.window != windows->image.id)i             break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command,nA             sizeof(command),&key_symbol,(XComposeStatus *) NULL);1/           for (id=0; id < ApplyModeMenus; id++)l           {iE             for (entry=0; Menus[id][entry] != (char *) NULL; entry++) 0               if (key_symbol == Keys[id][entry])                 {.+                   state|=UpdateRegionState;i                   break;                 } *             if (state & UpdateRegionState)               break;           }e(           if (state & UpdateRegionState)             break;           switch (key_symbol).           {              case XK_Shift_L:             case XK_Shift_R:               break;             case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return:l
             {e               state|=ExitState;l               break;
             }              case XK_F1:x             case XK_Help:(
             {nL               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);iN               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }/             default:
             {,               XBell(display,0);d               break;
             }g           }d           break;	         }n         case KeyRelease:           break;         case MotionNotify:	         {a           /*2             Discard pending pointer motion events.           */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event));l           x=event.xmotion.x;           y=event.xmotion.y;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */#           if (windows->info.mapped)%
             {%@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         }P#     } while (!(state & ExitState));p!   } while (!(state & ExitState));p@   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);    if (state & EscapeState)     return(True);i   return(True);X }w R /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             % O %                                                                             %iO %   X R o t a t e I m a g e                                                   % O %                                                                             %dO %                                                                             %iO %                                                                             %SO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%S %tG %  Function XRotateImage rotates the X image.  If the degrees parameteryL %  if zero, the rotation angle is computed from the slope of a line drawn by %  the user. %i- %  The format of the XRotateImage routine is:n %eE %    status=XRotateImage(display,resource_info,windows,degrees,image)e %n+ %  A description of each parameter follows:t %_@ %    o status: Function XRotateImage return True if the image isJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % D %    o degrees: Specifies the number of degrees to rotate the image. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */O static unsigned int XRotateImage(Display *display,XResourceInfo *resource_info, 1   XWindows *windows,double degrees,Image **image)% {% #define RotateModeColorOp  0  #define RotateModeDirectionOp  1 #define RotateModeCropOp  2a #define RotateModeSharpenOp  3 #define RotateModeHelpOp  4  #define RotateModeDismissOp  5 #define HorizontalRotateOp  0a #define VerticalRotateOp  1   
   static charl     *RotateModeMenu[]=     {:       "Pixel Color",       "Direction",
       "Crop",        "Sharpen",
       "Help",u       "Dismiss",       (char *) NULLl     };     char     command[MaxTextLength],r     text[MaxTextLength];  
   ColorPacketr     background;c     double     normalized_degrees;o     Image      *rotated_image;      int      id,      x,     y;     register int     i;     static unsigned intr     crop = False,e#     direction = HorizontalRotateOp,o     pen_id = 0,n     sharpen = True;      unsigned int     height,y     rotations,
     width;     if (degrees == 0.0)*     {,       unsigned int         distance;          unsigned longm         state;         XEvent         event;         XSegment         rotate_info;         /*         Map Command widget./       */%       windows->command.name="Rotate";y       windows->command.data=4;L       (void) XCommandWidget(display,windows,RotateModeMenu,(XEvent *) NULL);.       XMapRaised(display,windows->command.id);E       XClientMessage(display,windows->image.id,windows->im_protocols,r/         windows->im_update_widget,CurrentTime);C       /*$         Wait for first button press.       */F       XSetFunction(display,windows->image.highlight_context,GXinvert);-       XSelectInput(display,windows->image.id,NB         windows->image.attributes.event_mask | PointerMotionMask);6       XQueryPosition(display,windows->image.id,&x,&y);       rotate_info.x1=x;a       rotate_info.y1=y;o       rotate_info.x2=x;        rotate_info.y2=y;(       state=DefaultState;(       do       { 1         XHighlightLine(display,windows->image.id,+9           windows->image.highlight_context,&rotate_info);=
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows); 1         XHighlightLine(display,windows->image.id,r9           windows->image.highlight_context,&rotate_info); 5         if (event.xany.window == windows->command.id))           {e             /*7               Select a command from the Command widget.I             */E             id=XCommandWidget(display,windows,RotateModeMenu,&event);              if (id < 0)n               continue; J             XSetFunction(display,windows->image.highlight_context,GXcopy);             switch (id) 
             {g%               case RotateModeColorOp:y               {:                 char,                   *ColorMenu[MaxNumberPens];                   intm                   pen_number;|                   XColor                   color;                   /*-                   Initialize menu selections._                 */5                 for (i=0; i < (MaxNumberPens-2); i++))<                   ColorMenu[i]=resource_info->pen_colors[i];8                 ColorMenu[MaxNumberPens-2]="Browser...";9                 ColorMenu[MaxNumberPens-1]=(char *) NULL;o                 /*:                   Select a pen color from the pop-up menu.                 */J                 pen_number=XMenuWidget(display,windows,RotateModeMenu[id],%                   ColorMenu,command); #                 if (pen_number < 0)                    break;4                 if (pen_number == (MaxNumberPens-2))                   {r                     static char 9                       color_name[MaxTextLength] = "gray";i                       /*7                       Select a pen color from a dialog.t                     */E                     resource_info->pen_colors[pen_number]=color_name;eM                     XColorBrowserWidget(display,windows,"Select",color_name);f,                     if (*color_name == '\0')                       break;                   }a                 /*                    Set pen color.                 */M                 (void) XParseColor(display,windows->image.map_info->colormap,i@                   resource_info->pen_colors[pen_number],&color);E                 XBestPixel(display,windows->image.map_info->colormap, C                   (XColor *) NULL,(unsigned int) MaxColors,&color); H                 windows->image.pixel_info->pen_colors[pen_number]=color;"                 pen_id=pen_number;                 break;               }e)               case RotateModeDirectionOp:t               {e                 static chare                    *Directions[]=                   {p!                     "horizontal",e                     "vertical", "                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */I                 direction=XMenuWidget(display,windows,RotateModeMenu[id], &                   Directions,command);                 break;               }a$               case RotateModeCropOp:               {(                 static char                    *Options[]=                    {t                     "false",                     "true",U"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */D                 crop=XMenuWidget(display,windows,RotateModeMenu[id],#                   Options,command);                  break;               } '               case RotateModeSharpenOp:i               {r                 static char                    *Options[]=;                   {a                     "false",                     "true",%"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */G                 sharpen=XMenuWidget(display,windows,RotateModeMenu[id], #                   Options,command);                  break;               } $               case RotateModeHelpOp:               { D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);                 break;               } '               case RotateModeDismissOp:                {                  /*#                   Prematurely exit.%                 */#                 state|=EscapeState;g!                 state|=ExitState;                  break;               }y               default:                 break;
             }tL             XSetFunction(display,windows->image.highlight_context,GXinvert);             continue;a           }k         switch (event.type)s	         {            case ButtonPress:            {_8             if (event.xbutton.window == windows->pan.id)               {o2                 XPanImage(display,windows,&event);2                 XInfoWidget(display,windows,text);                 break;               };J             XSetFunction(display,windows->image.highlight_context,GXcopy);             /*               Exit loop.             */+             rotate_info.x1=event.xbutton.x;t+             rotate_info.y1=event.xbutton.y;o             state|=ExitState;d             break;           }p           case ButtonRelease:r             break;           case Expose:             break;           case KeyPress:           {t             char%               command[MaxTextLength];                KeySym               key_symbol;t  7             if (event.xkey.window != windows->image.id)a               break;             /**               Respond to a user key press.             */C             (void) XLookupString((XKeyEvent *) &event.xkey,command, C               sizeof(command),&key_symbol,(XComposeStatus *) NULL);r             switch (key_symbol)"
             {]               case XK_Escape:y               case XK_F20:               {a                 /*#                   Prematurely exit.                  */#                 state|=EscapeState;t!                 state|=ExitState;W                 break;               }o               case XK_F1:=               case XK_Help:(               {KN                 XSetFunction(display,windows->image.highlight_context,GXcopy);D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               }_               default:               { !                 XBell(display,0);                  break;               }o
             }              break;           }m           case MotionNotify:           {=             /*4               Discard pending pointer motion events.             */F             while (XCheckMaskEvent(display,PointerMotionMask,&event));+             rotate_info.x1=event.xmotion.x;I+             rotate_info.y1=event.xmotion.y;g           }e	         }m&         rotate_info.x2=rotate_info.x1;&         rotate_info.y2=rotate_info.y1;,         if (direction == HorizontalRotateOp)           rotate_info.x2+=32;          else           rotate_info.y2-=32; %       } while (!(state & ExitState));)-       XSelectInput(display,windows->image.id, .         windows->image.attributes.event_mask);D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);e       if (state & EscapeState)         return(True);!       /*F         Draw line as pointer moves until the mouse button is released.       */       distance=0;eF       XSetFunction(display,windows->image.highlight_context,GXinvert);       state=DefaultState;        do       {a         if (distance > 9)a           {              /*2               Display info and draw rotation line.             */&             if (!windows->info.mapped)3               XMapWindow(display,windows->info.id);v(             (void) sprintf(text," %.2f",F               direction == VerticalRotateOp ? degrees-90.0 : degrees);.             XInfoWidget(display,windows,text);5             XHighlightLine(display,windows->image.id,L=               windows->image.highlight_context,&rotate_info);            }          else#           if (windows->info.mapped)iK             XWithdrawWindow(display,windows->info.id,windows->info.screen);a
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows);i         if (distance > 9) 3           XHighlightLine(display,windows->image.id,s;             windows->image.highlight_context,&rotate_info);e         switch (event.type) 	         {7           case ButtonPress:e             break;           case ButtonRelease:e           {              /*2               User has committed to rotation line.             */+             rotate_info.x2=event.xbutton.x; +             rotate_info.y2=event.xbutton.y;a             state|=ExitState;a             break;           }:           case Expose:             break;           case MotionNotify:           {              /*3               Discard pending button motion events.              */E             while (XCheckMaskEvent(display,ButtonMotionMask,&event));e+             rotate_info.x2=event.xmotion.x; +             rotate_info.y2=event.xmotion.y;r           }y           default:             break;	         } 
         /*$           Check boundary conditions.
         */         if (rotate_info.x2 < 0)g           rotate_info.x2=0;g         else4           if (rotate_info.x2 > windows->image.width)0             rotate_info.x2=windows->image.width;         if (rotate_info.y2 < 0)r           rotate_info.y2=0;p         else5           if (rotate_info.y2 > windows->image.height) 1             rotate_info.y2=windows->image.height;g
         /*<           Compute rotation angle from the slope of the line.
         */         degrees=0.0;         distance= P           ((rotate_info.x2-rotate_info.x1+1)*(rotate_info.x2-rotate_info.x1+1))+P           ((rotate_info.y2-rotate_info.y1+1)*(rotate_info.y2-rotate_info.y1+1));         if (distance > 9)fC           degrees=RadiansToDegrees(-atan2((double) (rotate_info.y2-tG             rotate_info.y1),(double) (rotate_info.x2-rotate_info.x1))); %       } while (!(state & ExitState));_D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);,       if (distance <= 9)         return(True);(     })$   if (direction == VerticalRotateOp)     degrees-=90.0;   if (degrees == 0.0)      return(True);m   /*     Rotate image.g   */   normalized_degrees=degrees;r$   while (normalized_degrees < -45.0)     normalized_degrees+=360.0;;   for (rotations=0; normalized_degrees > 45.0; rotations++)t     normalized_degrees-=90.0;y    if (normalized_degrees != 0.0)O     (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);O   background.red=XDownScale(windows->image.pixel_info->pen_colors[pen_id].red);    background.green=cD     XDownScale(windows->image.pixel_info->pen_colors[pen_id].green);   background.blue=C     XDownScale(windows->image.pixel_info->pen_colors[pen_id].blue);x   background.index=0; E   rotated_image=RotateImage(*image,degrees,&background,crop,sharpen); )   XSetCursorState(display,windows,False);r&   if (rotated_image == (Image *) NULL)     return(False);   DestroyImage(*image);    *image=rotated_image; 4   if (windows->image.crop_geometry != (char *) NULL)     {i       /*         Rotate crop geometry.u       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);e       switch (rotations % 4)       {          default:         case 0:_           break;         case 1:o	         {r           /*             Rotate 90 degrees.           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",C             height,width,(int) (*image)->columns-(int) height-y,x);g           break;	         }f         case 2:;	         {i           /*             Rotate 180 degrees.s           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",7             width,height,(int) width-x,(int) height-y);N           break;	         }_         case 3:d	         {x           /*             Rotate 270 degrees..           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",?             height,width,y,(int) (*image)->rows-(int) width-x);i           break;	         }r       }i     }a   if (windows->image.orphan)     return(True);     if (normalized_degrees != 0.0)     {        /*         Update image colormap.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {            /*:             Obtain dimensions of image from crop geometry.           */C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,C             &width,&height);4           windows->image.window_changes.width=width;6           windows->image.window_changes.height=height;	         }oD       XConfigureImageColormap(display,resource_info,windows,*image);     }    else9     if (((rotations % 4) == 1) || ((rotations % 4) == 3))a       { J         windows->image.window_changes.width=windows->image.ximage->height;J         windows->image.window_changes.height=windows->image.ximage->width;       }w   /*     Update image configuration.>   */?   (void) XConfigureImage(display,resource_info,windows,*image);e   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %,O %                                                                             % O %                                                                             %tO %   X S a v e I m a g e                                                       %aO %                                                                             % O %                                                                             % O %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c %a0 %  Function XSaveImage saves an image to a file. %e+ %  The format of the XSaveImage routine is:* % ; %    status=XSaveImage(display,resource_info,windows,image)) %i+ %  A description of each parameter follows:n % > %    o status: Function XSaveImage return True if the image isJ %      written.  False is returned is there is a memory shortage or if the %      image fails to write. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %vK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.t %w< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.s %  %  */M static unsigned int XSaveImage(Display *display,XResourceInfo *resource_info, "   XWindows *windows,Image **image) {a   char     filename[MaxTextLength];     ImageInfo      *image_info;     int      status;      register charl     *p;      /*      Request file name from user.   */4   p=(*image)->filename+strlen((*image)->filename)-1;D   while ((p > (*image)->filename) && (*(p-1) != *BasenameSeparator))     p--;   (void) strcpy(filename,p);5   if (resource_info->write_filename != (char *) NULL)s:     (void) strcpy(filename,resource_info->write_filename);6   XFileBrowserWidget(display,windows,"Save",filename);   if (*filename == '\0')     return(True);d   if (IsAccessible(filename))s     {s       /*@         File exists-- seek user's permission before overwriting.       */B       status=XConfirmWidget(display,windows,"Overwrite",filename);       if (status == False)         return(True);      }X'   image_info=resource_info->image_info;a/   (void) strcpy(image_info->filename,filename);e*   SetImageInfo(resource_info->image_info);1   if ((strcmp(image_info->magick,"JPEG") == 0) ||*.       (strcmp(image_info->magick,"JPG") == 0))     {a
       char         quality[MaxTextLength];          /*'         Request JPEG quality from user.c       */7       (void) sprintf(quality,"%u",image_info->quality);mH       status=XDialogWidget(display,windows,"Save","Enter JPEG quality:",         quality);x       if (*quality == '\0')e         return(True);w(       image_info->quality=atoi(quality);D       image_info->interlace=status ? PlaneInterlace : NoneInterlace;     } 0   if ((strcmp(image_info->magick,"EPS") == 0) ||/       (strcmp(image_info->magick,"PS") == 0) || .       (strcmp(image_info->magick,"PS2") == 0))     {e
       char          geometry[MaxTextLength];         /*3         Request Postscript page geometry from user.a       */.       (void) sprintf(geometry,PSPageGeometry);,       if (image_info->page != (char *) NULL)1         (void) strcpy(geometry,image_info->page);aM       XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",e5         "Select Postscript Page Geometry:",geometry);h       if (*geometry != '\0')6         image_info->page=PostscriptGeometry(geometry);     }(   /*     Write image.   */M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_A,image);r(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);-   (void) strcpy((*image)->filename,filename);s'   status=WriteImage(image_info,*image); )   XSetCursorState(display,windows,False); M   (void) XMagickCommand(display,resource_info,windows,0,(KeySym) XK_u,image);,A   XClientMessage(display,windows->image.id,windows->im_protocols,a.     windows->im_update_signature,CurrentTime);   return(status);- }a c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             % O %                                                                             %nO %                                                                             %lO %   X S c r e e n E v e n t                                                   %|O %                                                                             % O %                                                                             %aO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eK %  Function XScreenEvent returns True if the certain events on the X serveri8 %  queue is associated with the image or Magnify window. %n. %  The format of the XScreenEvent function is: %e' %      XScreenEvent(display,event,data)e %z+ %  A description of each parameter follows:n %.L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %a< %    o event: Specifies a pointer to a X11 XEvent structure. %n9 %    o data: Specifies a pointer to a XWindows structure.  %  %  */B static int XScreenEvent(Display *display,XEvent *event,char *data) {o   register int     x,     y;     register XWindowse
     *windows;.     windows=(XWindows *) data;0   if (event->xany.window == windows->command.id)     return(True);r   switch (event->type)   {a     case ButtonPress:      case ButtonRelease:s     { /       if ((event->xbutton.button == Button3) &&=,           (event->xbutton.state & Mod1Mask))	         {w           /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         } 8       if (event->xbutton.window == windows->backdrop.id)D         XSetInputFocus(display,event->xbutton.window,RevertToParent,           event->xbutton.time);t5       if (event->xbutton.window == windows->image.id)g$         if (windows->magnify.mapped)           {g             /*%               Update magnified image.              */             x=event->xbutton.x;              y=event->xbutton.y;r             if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;.2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;t2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);s           }        return(True);g     }*     case ClientMessage:      {o       /*.         If client window delete message, exit.       */?       if (event->xclient.message_type != windows->wm_protocols)a         break;>       if (*event->xclient.data.l != windows->wm_delete_window)         break;7       if (event->xclient.window == windows->magnify.id))	         { O           XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);-           return(True);r	         }        break;     }a     case Expose:     {w5       if (event->xexpose.window == windows->image.id)a	         {e8           XRefreshWindow(display,&windows->image,event);           return(True);n	         })3       if (event->xexpose.window == windows->pan.id) &         if (event->xexpose.count == 0)           { /             XDrawPanRectangle(display,windows);i             return(True);a           }        break;     }t     case KeyPress:     { 
       char         command[MaxTextLength];m         KeySym         key_symbol;g         /*$         Respond to a user key press.       */N       (void) XLookupString((XKeyEvent *) &event->xkey,command,sizeof(command),-         &key_symbol,(XComposeStatus *) NULL);;4       if (event->xkey.window == windows->magnify.id)L         XMagnifyWindowCommand(display,windows,event->xkey.state,key_symbol);       return(True);W     }d     case MapNotify:      {14       if (event->xmap.window == windows->magnify.id)	         {m-           XMakeMagnifyImage(display,windows);a'           windows->magnify.mapped=True;m           return(True); 	         } 1       if (event->xmap.window == windows->info.id) 	         { $           windows->info.mapped=True;           return(True);&	         }        break;     }      case MotionNotify:     {>5       if (event->xmotion.window == windows->image.id)e$         if (windows->magnify.mapped)           {              /*%               Update magnified image.;             */             x=event->xmotion.x;n             y=event->xmotion.y;;             if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;r2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;!2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);            }G       return(True);e     }e     case UnmapNotify:      { 6       if (event->xunmap.window == windows->magnify.id)	         {,(           windows->magnify.mapped=False;           return(True);t	         };3       if (event->xunmap.window == windows->info.id) 	         { %           windows->info.mapped=False;u           return(True); 	         }a       break;     }X     case KeyRelease:     case SelectionNotify:9       return(True);      default:       break;   }g   return(False); }f i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             % O %                                                                             %sO %   X S e t C r o p G e o m e t r y                                           %aO %                                                                             %gO %                                                                             %;O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %tH %  Function XSetCropGeometry accepts a cropping geometry relative to theH %  Image window and translates it to a cropping geometry relative to the	 %  image.n % 1 %  The format of the XSetCropGeometry routine is:  %t6 %    XSetCropGeometry(display,windows,crop_info,image) % + %  A description of each parameter follows:a %gD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %r< %    o windows: Specifies a pointer to a XWindows structure. %nL %    o crop_info:  A pointer to a RectangleInfo that defines a region of the %      Image window to crop. % 7 %    o image: Specifies a pointer to a Image structure.o %n %i */@ static void XSetCropGeometry(Display *display,XWindows *windows,(   RectangleInfo *crop_info,Image *image) {    char     text[MaxTextLength];     int      x,     y;     unsigned int     height,;
     width;     unsigned long      scale_factor;p     if (windows->info.mapped)n     {g       /*+         Display info on cropping rectangle.i       */L       (void) sprintf(text," %ux%u%+d%+d",crop_info->width,crop_info->height,#         crop_info->x,crop_info->y);a(       XInfoWidget(display,windows,text);     },   /*@     Cropping geometry is relative to any previous crop geometry.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);s   else     {        /*&         Allocate crop geometry string.       */O       windows->image.crop_geometry=(char *) malloc(MaxTextLength*sizeof(char));a8       if (windows->image.crop_geometry == (char *) NULL)<         Error("Unable to crop X image",windows->image.name);     }    /*@     Define the crop geometry string from the cropping rectangle.   */;   scale_factor=UpShift(width)/windows->image.ximage->width;h   if (crop_info->x > 0)h,     x+=DownShift(crop_info->x*scale_factor);1   width=DownShift(crop_info->width*scale_factor);t   if (width == 0),     width=1;=   scale_factor=UpShift(height)/windows->image.ximage->height;r   if (crop_info->y > 0),,     y+=DownShift(crop_info->y*scale_factor);3   height=DownShift(crop_info->height*scale_factor);v   if (height == 0)
     height=1;fN   (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,x,y); }d , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %rO %                                                                             % O %                                                                             % O %   X T i l e I m a g e                                                       %gO %                                                                             %oO %                                                                             % O %                                                                             %,O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %uE %  Function XTileImage loads or deletes a selected tile from a visual_G %  image directory.  The load or delete command is choosen from a menu.  % + %  The format of the XTileImage routine is:g %mF %    tiled_image=XTileImage(display,resource_info,windows,image,event) %i+ %  A description of each parameter follows:e %g@ %    o tiled_image:  XTileImage reads or deletes the tiled imageD %      and returns it.  A null image is returned if an error occurs. %eE %    o display: Specifies a connection to an X server;  returned frome %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %v< %    o windows: Specifies a pointer to a XWindows structure. %eE %    o image: Specifies a pointer to a Image structure; returned fromn %      ReadImage.) % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.; %  %  */G static Image *XTileImage(Display *display,XResourceInfo *resource_info,b/   XWindows *windows,Image *image,XEvent *event)  {  #define LoadVerbOp  0o #define NextVerbOp  1e #define FormerVerbOp  2o #define DeleteVerbOp  3S #define UpdateVerbOp  4d     char     command[MaxTextLength],o     filename[MaxTextLength];     Imagem     *tiled_image;,     inti     status,i	     tile, 	     verb,o     x,     y;     register charw     *p,m     *q;      register int     i;  
   static char      *VerbMenu[]=     { 
       "Load",t
       "Next",;       "Former",        "Delete",r       "Update",        (char *) NULL,     };     unsigned int     height,n
     width;     unsigned long      scale_factor;0     /*:     Tile image is relative to montage image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows;o4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;d%   event->xbutton.x+=windows->image.x; >   event->xbutton.x=DownShift(event->xbutton.x*scale_factor)+x;=   scale_factor=UpShift(height)/windows->image.ximage->height;m%   event->xbutton.y+=windows->image.y;X>   event->xbutton.y=DownShift(event->xbutton.y*scale_factor)+y;   /*K     Determine size and location of each tile in the visual image directory.d   */   x=0;   y=0;   width=image->columns;    height=image->rows;c=   (void) XParseGeometry(image->montage,&x,&y,&width,&height);a@   tile=((event->xbutton.y-y)/height)*((image->columns-x)/width)+     (event->xbutton.x-x)/width;(   if (tile < 0)i     {d       /*)         Button press is outside any tile.s       */       XBell(display,0);        return((Image *) NULL);:     }i   /*0     Determine file name from the tile directory.   */   p=image->directory;,*   for (i=tile; (i != 0) && (*p != '\0'); )   {y     if (*p == '\n')v
       i--;     p++;   }r   if (*p == '\0')n     {g       /*)         Button press is outside any tile.,       */       XBell(display,0);-       return((Image *) NULL);      }C   /**     Select a command from the pop-up menu.   */A   verb=XMenuWidget(display,windows,"Tile Verb",VerbMenu,command);m   if (verb < 0)a     return((Image *) NULL);:   q=p;&   while ((*q != '\n') && (*q != '\0'))     q++;!   (void) strncpy(filename,p,q-p);t   filename[q-p]='\0';d   /**     Perform command for the selected tile.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   tiled_image=(Image *) NULL;i   switch (verb)s   {      case LoadVerbOp:     {a       /*         Load tile image.       */,       XCheckRefreshWindows(display,windows);>       (void) strcpy(resource_info->image_info->magick,"MIFF");B       (void) strcpy(resource_info->image_info->filename,filename);7       tiled_image=ReadImage(resource_info->image_info); E       XWithdrawWindow(display,windows->info.id,windows->info.screen);s       break;     }      case NextVerbOp:     {        /*         Display next image.n       */E       XClientMessage(display,windows->image.id,windows->im_protocols,d,         windows->im_next_image,CurrentTime);       break;     }i     case FormerVerbOp:     {a       /*         Display former image.y       */E       XClientMessage(display,windows->image.id,windows->im_protocols, .         windows->im_former_image,CurrentTime);       break;     }S     case DeleteVerbOp:     {r       /*         Delete tile image.       */"       if (!IsAccessible(filename))	         {eO           XNoticeWidget(display,windows,"Image file does not exist:",filename);,           break;	         }iK       status=XConfirmWidget(display,windows,"Really delete tile",filename);i       if (status == False)         break;       status=remove(filename);       if (status != False)	         { G           XNoticeWidget(display,windows,"Unable to delete image file:",              filename);           break;	         }      }e     case UpdateVerbOp:     {s	       intr         x_offset,;         y_offset;g         register int
         j;         register RunlengthPacket         *r;u         /*$         Ensure all the images exist.       */"       if (!UncompressImage(image))         return((Image *) NULL);r
       tile=0;,/       for (p=image->directory; *p != '\0'; p++)s       {o         q=p;,         while ((*q != '\n') && (*q != '\0'))           q++;'         (void) strncpy(filename,p,q-p);t         filename[q-p]='\0';          p=q;#         if (IsAccessible(filename))            {              tile++;d             continue;e           }M
         /*/           Overwrite tile with background color.)
         */=         x_offset=width*(tile % ((image->columns-x)/width))+x; <         y_offset=height*(tile/((image->columns-x)/width))+y;"         for (i=0; i < height; i++)	         {sA           r=image->pixels+((y_offset+i)*image->columns+x_offset);t#           for (j=0; j < width; j++)n"             *r++=(*image->pixels);	         }r         tile++;d       })9       windows->image.window_changes.width=image->columns; 7       windows->image.window_changes.height=image->rows;aC       XConfigureImageColormap(display,resource_info,windows,image);gB       (void) XConfigureImage(display,resource_info,windows,image);       break;     }      default:       break;   }p)   XSetCursorState(display,windows,False);o   return(tiled_image); }  v /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %;O %   X T r a n s l a t e I m a g e                                             % O %                                                                             %dO %                                                                             %gO %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %eG %  Function XTranslateImage translates the image within an Image windowoM %  by one pixel as specified by the key symbol.  If the image has a `montage'cM %  string the translation is respect to the width and height contained withinf %  the string. % 0 %  The format of the XTranslateImage routine is: %"6 %    XTranslateImage(display,windows,image,key_symbol) %9+ %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %i< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.3 %gM %    o key_symbol: Specifies a KeySym which indicates which side of the imagei %      to trim.  %  %a */? static void XTranslateImage(Display *display,XWindows *windows,e!   Image *image,KeySym key_symbol)s {y   char     text[MaxTextLength];     inta     x,     y;     unsigned int
     x_offset,c
     y_offset;a     /*)     User specified a pan position offset.    */    x_offset=windows->image.width;!   y_offset=windows->image.height;w&   if (image->montage != (char *) NULL)D     (void) XParseGeometry(image->montage,&x,&y,&x_offset,&y_offset);   switch (key_symbol)    {      case XK_Home:      case XK_KP_Home:     {i1       windows->image.x=windows->image.width >> 1;s2       windows->image.y=windows->image.height >> 1;       break;     }r     case XK_Left:n     case XK_KP_Left:     { !       windows->image.x-=x_offset;d       break;     }f     case XK_Next:p     case XK_Up:a     case XK_KP_Up:     {l!       windows->image.y-=y_offset;,       break;     })     case XK_Right:     case XK_KP_Right:o     {g!       windows->image.x+=x_offset;e       break;     }      case XK_Prior:     case XK_Down:g     case XK_KP_Down:     { !       windows->image.y+=y_offset;        break;     })     default:
       return;s   }e   /*     Check boundary conditions.   */   if (windows->image.x < 0);     windows->image.x=0;0   elseO     if ((windows->image.x+windows->image.width) > windows->image.ximage->width)tI       windows->image.x=windows->image.ximage->width-windows->image.width;    if (windows->image.y < 0)r     windows->image.y=0;r   else2     if ((windows->image.y+windows->image.height) >'          windows->image.ximage->height) K       windows->image.y=windows->image.ximage->height-windows->image.height;(   /*     Refresh Image window.a   */;   (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,m=     windows->image.height,windows->image.x,windows->image.y); $   XInfoWidget(display,windows,text);(   XCheckRefreshWindows(display,windows);%   XDrawPanRectangle(display,windows);s:   XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);i }a i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %sO %                                                                             % O %                                                                             % O %   X T r i m I m a g e                                                       %oO %                                                                             %nO %                                                                             %mO %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %o= %  Function XTrimImage trims the edges from the Image window.t %s+ %  The format of the XTrimImage routine is:i %w; %    status=XTrimImage(display,resource_info,windows,image)a %i+ %  A description of each parameter follows:v %)? %    o status: Function XTrimImage returns True if the image isrJ %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %"K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure.< %    o windows: Specifies a pointer to a XWindows structure. % 7 %    o image: Specifies a pointer to a Image structure.w %" %  */M static unsigned int XTrimImage(Display *display,XResourceInfo *resource_info,n!   XWindows *windows,Image *image)d {,   RectangleInfof     trim_info;     register int     x,     y;     unsigned longa     background,e
     pixel;     /*     Trim edges from image.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   /*     Crop the left edge.a   */2   background=XGetPixel(windows->image.ximage,0,0);/   trim_info.width=windows->image.ximage->width;w2   for (x=0; x < windows->image.ximage->width; x++)   {s5     for (y=0; y < windows->image.ximage->height; y++)r     {i1       pixel=XGetPixel(windows->image.ximage,x,y);p       if (pixel != background)         break;     }p*     if (y < windows->image.ximage->height)       break;   }e   trim_info.x=x;2   if (trim_info.x == windows->image.ximage->width)     {s-       XSetCursorState(display,windows,False);        return(False);     }"   /*     Crop the right edge.   */O   background=XGetPixel(windows->image.ximage,windows->image.ximage->width-1,0);e4   for (x=windows->image.ximage->width-1; x > 0; x--)   { 5     for (y=0; y < windows->image.ximage->height; y++)      { 1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     }-*     if (y < windows->image.ximage->height)       break;   }c"   trim_info.width=x-trim_info.x+1;   /*     Crop the top edge.   */2   background=XGetPixel(windows->image.ximage,0,0);1   trim_info.height=windows->image.ximage->height;o3   for (y=0; y < windows->image.ximage->height; y++)a   {s4     for (x=0; x < windows->image.ximage->width; x++)     { 1       pixel=XGetPixel(windows->image.ximage,x,y);h       if (pixel != background)         break;     }u)     if (x < windows->image.ximage->width)/       break;   }l   trim_info.y=y;   /*     Crop the bottom edge.h   */P   background=XGetPixel(windows->image.ximage,0,windows->image.ximage->height-1);5   for (y=windows->image.ximage->height-1; y > 0; y--)t   {i4     for (x=0; x < windows->image.ximage->width; x++)     {o1       pixel=XGetPixel(windows->image.ximage,x,y);e       if (pixel != background)         break;     }a)     if (x < windows->image.ximage->width),       break;   } #   trim_info.height=y-trim_info.y+1; 2   if ((trim_info.width != windows->image.width) ||2       (trim_info.height != windows->image.height))     {s       /*F         Reconfigure Image window as defined by the trimming rectangle.       */9       XSetCropGeometry(display,windows,&trim_info,image);f:       windows->image.window_changes.width=trim_info.width;<       windows->image.window_changes.height=trim_info.height;B       (void) XConfigureImage(display,resource_info,windows,image);     }t)   XSetCursorState(display,windows,False);f   return(True);; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %pO %                                                                             % O %                                                                             % O %   X V i s u a l D i r e c t o r y I m a g e                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r % C %  Function XVisualDirectoryImage creates a Visual Image Directory.t %s6 %  The format of the XVisualDirectoryImage routine is: %"F %    loaded_image=XVisualDirectoryImage(display,resource_info,windows) % + %  A description of each parameter follows:  %iJ %    o loaded_image: Function XVisualDirectoryImage returns a visual imageK %      directory if it can be created successfully.  Otherwise a null imageo %      is returned.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %tK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.t %s< %    o windows: Specifies a pointer to a XWindows structure. %n %. */5 static Image *XVisualDirectoryImage(Display *display,e1   XResourceInfo *resource_info,XWindows *windows)r {(. #define LoadImageText  "  Loading images...  " #define XClientName  "montage"     char     **filelist,t     *resource_value,     window_id[MaxTextLength];      Imagen     *image,m
     **images,g     *scaled_image;     ImageInfou     local_info;e     intd     number_files;/     MonitorHandler     handler;     register int     i,     j;  
   static char'#     filename[MaxTextLength] = "\0",l#     filenames[MaxTextLength] = "*";"     unsigned int
     backdrop,      height,      status,e
     width;     XMontageInfo
     vid_info;      XResourceInfot     background_resources,      vid_resources;  
   XrmDatabasei     resource_database;     /*      Request file name from user.   */<   XFileBrowserWidget(display,windows,"Directory",filenames);   if (*filenames == '\0')      return((Image *) NULL);    /*     Expand the filenames.r   */,   filelist=(char **) malloc(sizeof(char *));!   if (filelist == (char **) NULL)m     { 7       Warning("Memory allocation error",(char *) NULL);d       return((Image *) NULL);=     })   number_files=1;i   filelist[0]=filenames;+   ExpandFilenames(&number_files,&filelist);g   if (number_files == 0)     {i5       Warning("No image files were found",filenames);s       return((Image *) NULL);      }a   /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));p    if (images == (Image **) NULL)     {*7       Warning("Memory allocation error",(char *) NULL); &       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);*       free((char *) filelist);       return((Image *) NULL);      }    /*/     Get any Visual Image Directory X resources.    */5   resource_database=resource_info->resource_database;w!   vid_resources=(*resource_info); H   vid_resources.background_color=XGetResourceInstance(resource_database,4     XClientName,"background",DefaultTileBackground);O   resource_value=XGetResourceClass(resource_database,XClientName,"borderWidth",      DefaultTileBorderwidth);2   vid_resources.border_width=atoi(resource_value);5   vid_resources.font=resource_info->image_info->font; H   vid_resources.foreground_color=XGetResourceInstance(resource_database,4     XClientName,"foreground",DefaultTileForeground);F   vid_resources.image_geometry=XGetResourceInstance(resource_database,5     XClientName,"imageGeometry",DefaultTileGeometry);aC   vid_resources.matte_color=XGetResourceInstance(resource_database, /     XClientName,"mattecolor",DefaultTileMatte);l   /*#     Set image background resources.n   */(   background_resources=(*resource_info);+   background_resources.window_id=window_id;eK   (void) sprintf(background_resources.window_id,"0x%lx",windows->image.id); %   background_resources.backdrop=True;d   /*/     Read each image and convert them to a tile.i   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   backdrop=(windows->image.visual_info->class == TrueColor) ||6    (windows->image.visual_info->class == DirectColor);   j=0;    handler=(MonitorHandler) NULL;"   for (i=0; i < number_files; i++)   {e5     handler=SetMonitorHandler((MonitorHandler) NULL); ,     local_info=(*resource_info->image_info);$     local_info.filename=filelist[i];     *local_info.magick='\0';)     if (local_info.size == (char *) NULL) 3       local_info.size=vid_resources.image_geometry;s!     image=ReadImage(&local_info);i!     if (filelist[i] != filenames)"!       free((char *) filelist[i]);       if (image == (Image *) NULL)       continue;      image->scene=j;e     image->matte=False;      LabelImage(image,"%f");e     /*       Scale image.     */     width=image->columns;r     height=image->rows;_D     ParseImageGeometry(vid_resources.image_geometry,&width,&height);0     scaled_image=ScaleImage(image,width,height);     DestroyImage(image);'     if (scaled_image == (Image *) NULL)e       continue;w     image=scaled_image;      if (backdrop)(       {iL         (void) XDisplayBackgroundImage(display,&background_resources,image);.         XSetCursorState(display,windows,True);       }k     images[j]=image;     j++;&     (void) SetMonitorHandler(handler);2     ProgressMonitor(LoadImageText,i,number_files);   } $   (void) SetMonitorHandler(handler);   free((char *) filelist);
   if (j == 0)*     {>-       XSetCursorState(display,windows,False);e1       Warning("No images were loaded",filenames);>       free((char *) images);       return((Image *) NULL);i     }r   /*>     Request the Visual Image Directory filename from the user.   */A   XClientMessage(display,windows->image.id,windows->im_protocols, (     windows->im_next_image,CurrentTime);6   XFileBrowserWidget(display,windows,"Save",filename);   if (*filename == '\0')     {        free((char *) images);       return((Image *) NULL);t     }e   /*&     Create the Visual Image Directory.   */:   XRefreshWindow(display,&windows->image,(XEvent *) NULL);   XGetMontageInfo(&vid_info);x   vid_info.number_tiles=j;@   image=XMontageImage(images,&vid_resources,&vid_info,filename);)   XSetCursorState(display,windows,False);*   free((char *) images);   if (image == (Image *) NULL)     return(image);   /*$     Save the Visual Image Directory.   */*   local_info=(*resource_info->image_info);   local_info.filename=filename;x   local_info.adjoin=True;e   SetImageInfo(&local_info);,   if (strcmp(local_info.magick,"MIFF") != 0)"     XNoticeWidget(display,windows,N       "Visual Image Directory is non-conforming (not MIFF format):",filename);'   status=WriteImage(&local_info,image);o   if (status == False)L     XNoticeWidget(display,windows,"Unable to write Visual Image Directory:",       filename);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             % O %                                                                             %sO %   X W a r n i n g                                                           %sO %                                                                             % O %                                                                             %wO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XWarning displays a warning message in a Notice widget.  % ) %  The format of the XWarning routine is:e %e" %      XWarning(message,qualifier) % + %  A description of each parameter follows:t %eG %    o message: Specifies the message to display before terminating the, %      program.o %l9 %    o qualifier: Specifies any qualifier to the message.) %  %  */3 static void XWarning(char *message,char *qualifier)  {    char     text[MaxTextLength];     if (message == (char *) NULL)      return;    (void) strcpy(text,message);   (void) strcat(text,":");0   XNoticeWidget(display,windows,text,qualifier); }i _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %sO %                                                                             %wO %                                                                             %nO %    M a i n                                                                  %sO %                                                                             %dO %                                                                             %CO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %c %a */ int main(int argc,char **argv) { + #define NotInitialized  (unsigned int) (~0)      char     density[MaxTextLength],      *option,     *resource_value,     *server_name;      floatt     x_density,     y_density;     Image)     *image,a     *next_image;     ImageInfoo     image_info;      into     x,     y;     register int     i,     j;     unsigned int     first_scene,     height,>     *image_marker,     image_number,      last_scene,x
     scene,
     width;     unsigned long 
     state;     XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*     Set defaults.l   */   ReadCommandlLine(argc,&argv);n    client_name=ClientName(*argv);   display=(Display *) NULL;a   first_scene=0;F   image_marker=(unsigned int *) malloc((argc+1)*sizeof(unsigned int));,   if (image_marker == (unsigned int *) NULL)@     Error("Unable to display image","Memory allocation failed");   for (i=0; i <= argc; i++)T     image_marker[i]=argc;w   image_number=0;)   GetImageInfo(&image_info);   last_scene=0; '   resource_database=(XrmDatabase) NULL;a   server_name=(char *) NULL;   state=DefaultState;f   /*8     Check for server name specified on the command line.   */   ExpandFilenames(&argc,&argv);    for (i=1; i < argc; i++)   {r     /*)       Check command line for server name.l     */     option=argv[i]; N     if (((int) strlen(option) == 1) || ((*option != '-') && (*option != '+')))       continue;e+     if (strncmp("display",option+1,3) == 0)w       {m
         /*%           User specified server name.X
         */         i++;         if (i == argc)A           Error("Missing server name on -display",(char *) NULL);          server_name=argv[i];         break;       };(     if (strncmp("help",option+1,2) == 0)       Usage(True);   }    /*     Open X server connection.X   */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)E     Error("Unable to connect to X server",XDisplayName(server_name));e   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);+   /*/     Get user defaults from X resource database.t   */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info); A   (void) sscanf(PSDensityGeometry,"%fx%f",&x_density,&y_density); =   (void) XParseGeometry(PSPageGeometry,&x,&y,&width,&height);p7   (void) sprintf(density,"%f",Min(x_density,y_density)* J     (XDisplayHeight(display,XDefaultScreen(display))-40)/(double) height);   image_info.density=fG     XGetResourceClass(resource_database,client_name,"density",density);    resource_value=aH     XGetResourceClass(resource_database,client_name,"interlace","none");*   image_info.interlace=UndefinedInterlace;0   if (Latin1Compare("none",resource_value) == 0)'     image_info.interlace=NoneInterlace;w0   if (Latin1Compare("line",resource_value) == 0)'     image_info.interlace=LineInterlace;;1   if (Latin1Compare("plane",resource_value) == 0)i(     image_info.interlace=PlaneInterlace;1   if (image_info.interlace == UndefinedInterlace);:     Warning("Unrecognized interlace type",resource_value);B   image_info.page=XGetResourceClass(resource_database,client_name,"     "pageGeometry",(char *) NULL);   resource_value=nD     XGetResourceClass(resource_database,client_name,"quality","75");*   image_info.quality=atoi(resource_value);   resource_value=_G     XGetResourceClass(resource_database,client_name,"verbose","False");g,   image_info.verbose=IsTrue(resource_value);   /*     Parse command line.u   */7   for (i=1; ((i <= argc) && !(state & ExitState)); i++);   {      if (i < argc)        option=argv[i];k     else       if (image_number != 0)         break;
       else!         if (isatty(STDIN_FILENO))            option="logo:";%         else           option="-";%M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+')))        switch (*(option+1))       {          case 'b': 	         { 2           if (strncmp("backdrop",option+1,5) == 0)
             { 6               resource_info.backdrop=(*option == '-');               break;
             } 8           if ((strncmp("background",option+1,5) == 0) ||.               (strncmp("bg",option+1,2) == 0))
             { ;               resource_info.background_color=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing color on -background",(char *) NULL);9                   resource_info.background_color=argv[i];d                 }o               break;
             }l-           if (strcmp("border",option+1) == 0)f
             {a!               if (*option == '-')a                 {e                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     Error("Missing geometry on -border",(char *) NULL);e                 }p               break;
             }t5           if (strncmp("bordercolor",option+1,7) == 0) 
             {i7               resource_info.border_color=(char *) NULL;i!               if (*option == '-')p                 {w                   i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL);;5                   resource_info.border_color=argv[i];t                 }                break;
             }i5           if (strncmp("borderwidth",option+1,7) == 0)e
             {x+               resource_info.border_width=0;-!               if (*option == '-')i                 {n                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing width on -borderwidth",(char *) NULL); ;                   resource_info.border_width=atoi(argv[i]);                  }-               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'c': 	         {i2           if (strncmp("colormap",option+1,6) == 0)
             {f5               resource_info.colormap=PrivateColormap;y!               if (*option == '-')w                 {                    i++;                    if (i == argc)E                     Error("Missing type on -colormap",(char *) NULL);i!                   option=argv[i];d;                   resource_info.colormap=UndefinedColormap;n;                   if (Latin1Compare("private",option) == 0)c;                     resource_info.colormap=PrivateColormap;e:                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)G                     Error("Invalid colormap type on -colormap",option);                  }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             {s,               resource_info.number_colors=0;!               if (*option == '-')                  {o                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL); <                   resource_info.number_colors=atoi(argv[i]);                 }=               break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { 5               resource_info.colorspace=RGBColorspace;S!               if (*option == '-')e                 {S                   i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL);r!                   option=argv[i]; ?                   resource_info.colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0)                     { >                       resource_info.colorspace=GRAYColorspace;6                       resource_info.number_colors=256;1                       resource_info.tree_depth=8;                      } 8                   if (Latin1Compare("ohta",option) == 0)<                     resource_info.colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0) ;                     resource_info.colorspace=RGBColorspace;%?                   if (Latin1Compare("transparent",option) == 0)dC                     resource_info.colorspace=TransparentColorspace;a7                   if (Latin1Compare("xyz",option) == 0)X;                     resource_info.colorspace=XYZColorspace;a9                   if (Latin1Compare("ycbcr",option) == 0)o=                     resource_info.colorspace=YCbCrColorspace;n7                   if (Latin1Compare("yiq",option) == 0).;                     resource_info.colorspace=YIQColorspace;t9                   if (Latin1Compare("ypbpr",option) == 0)S=                     resource_info.colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0)n;                     resource_info.colorspace=YUVColorspace;KF                   if (resource_info.colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);1                 }=               break;
             } 1           if (strncmp("comment",option+1,4) == 0),
             {y!               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);o                 }                break;
             }_2           if (strncmp("compress",option+1,3) == 0)
             {>3               image_info.compression=NoCompression;a!               if (*option == '-')a                 {>                   i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL);_!                   option=argv[i];wD                   if (Latin1Compare("runlengthencoded",option) == 0)G                     image_info.compression=RunlengthEncodedCompression;                    else9                     if (Latin1Compare("zip",option) == 0)-<                       image_info.compression=ZipCompression;                     elseL                       Error("Invalid compression type on -compress",option);                 }:               break;
             }w2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')5                 {6                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -crop",(char *) NULL);:                 }.               break;
             }).           Error("Unrecognized option",option);           break;	         }%         case 'd': 	         { /           if (strncmp("debug",option+1,3) == 0) 
             { 3               resource_info.debug=(*option == '-');                break;
             } /           if (strncmp("delay",option+1,3) == 0) 
             { $               resource_info.delay=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing seconds on -delay",(char *) NULL);l4                   resource_info.delay=atoi(argv[i]);                 }                break;
             }%1           if (strncmp("density",option+1,3) == 0) 
             {o/               image_info.density=(char *) NULL;a!               if (*option == '-')                  {e                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];X                 }f               break;
             }o3           if (strncmp("despeckle",option+1,3) == 0)e             break;1           if (strncmp("display",option+1,3) == 0) 
             { (               server_name=(char *) NULL;!               if (*option == '-')                  {U                   i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL); &                   server_name=argv[i];                 }i4               resource_info.server_name=server_name;               break;
             }n0           if (strncmp("dither",option+1,3) == 0)
             {o4               resource_info.dither=(*option == '-');               break;
             }p.           Error("Unrecognized option",option);           break;	         }w         case 'e':f	         { .           if (strncmp("edge",option+1,2) == 0)
             {L!               if (*option == '-')d                 {.                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing factor on -edge",(char *) NULL);%                 }%               break;
             }%1           if (strncmp("enhance",option+1,2) == 0)              break;2           if (strncmp("equalize",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }          case 'f': 	         { .           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,3) == 0)
             { /               resource_info.font=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);-                   resource_info.font=argv[i];e                 }M               break;
             }g8           if ((strncmp("foreground",option+1,3) == 0) ||.               (strncmp("fg",option+1,2) == 0))            {:              resource_info.foreground_color=(char *) NULL;               if (*option == '-')                {                  i++;i                  if (i == argc)lL                    Error("Missing foreground on -foreground",(char *) NULL);8                  resource_info.foreground_color=argv[i];                }               break;            }/           if (strncmp("frame",option+1,2) == 0)e
             {c!               if (*option == '-')e                 {i                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     Error("Missing geometry on -frame",(char *) NULL);                 },               break;
             } .           Error("Unrecognized option",option);           break;	         }a         case 'g': 	         {r/           if (strncmp("gamma",option+1,2) == 0)a
             {g!               if (*option == '-')                  {c                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);]                 }d               break;
             }e2           if (strncmp("geometry",option+1,2) == 0)
             {X9               resource_info.image_geometry=(char *) NULL;e!               if (*option == '-')                  {n                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))I                     Error("Missing geometry on -geometry",(char *) NULL); 7                   resource_info.image_geometry=argv[i];t                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }+         case 'h': 	         {m.           if (strncmp("help",option+1,2) == 0)             Usage(True);.           Error("Unrecognized option",option);           break;	         }t         case 'i':e	         { 6           if (strncmp("iconGeometry",option+1,5) == 0)
             { 8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')                  {-                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))M                     Error("Missing geometry on -iconGeometry",(char *) NULL);=6                   resource_info.icon_geometry=argv[i];                 }r               break;
             } 0           if (strncmp("iconic",option+1,5) == 0)
             { 4               resource_info.iconic=(*option == '-');               break;
             }o3           if (strncmp("immutable",option+1,5) == 0)x
             {+7               resource_info.immutable=(*option == '-');n               break;
             },3           if (strncmp("interlace",option+1,3) == 0)r
             {l1               image_info.interlace=NoneInterlace; !               if (*option == '-')d                 {s                   i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace;o9                   if (Latin1Compare("plane",option) == 0)r8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);t                 }t               break;
             } .           Error("Unrecognized option",option);           break;	         }i         case 'l':t	         {a/           if (strncmp("label",option+1,2) == 0) 
             {o!               if (*option == '-')m                 {i                   i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }                break;
             }g.           Error("Unrecognized option",option);           break;	         }          case 'm':.	         {u1           if (strncmp("magnify",option+1,3) == 0)i
             {p&               resource_info.magnify=2;!               if (*option == '-')o                 {f                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing level on -magnify",(char *) NULL);S6                   resource_info.magnify=atoi(argv[i]);                 }                break;
             }e-           if (strncmp("map",option+1,3) == 0).
             { 3               resource_info.map_type=(char *) NULL; !               if (*option == '-')t                 {n                   i++;                    if (i == argc)D                     Error("Missing map type on -map",(char *) NULL);1                   resource_info.map_type=argv[i];r                 }                break;
             }m,           if (strcmp("matte",option+1) == 0)             break;4           if (strncmp("mattecolor",option+1,6) == 0)
             {d6               resource_info.matte_color=(char *) NULL;!               if (*option == '-')i                 {e                   i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);4                   resource_info.matte_color=argv[i];                 }                break;
             } 2           if (strncmp("modulate",option+1,3) == 0)
             {r!               if (*option == '-')L                 {;                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing value on -modulate",(char *) NULL);                 };               break;
             } 4           if (strncmp("monochrome",option+1,3) == 0)
             {a8               resource_info.monochrome=(*option == '-');+               if (resource_info.monochrome)                  { 0                   resource_info.number_colors=2;-                   resource_info.tree_depth=8; :                   resource_info.colorspace=GRAYColorspace;                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'n':l	         {o.           if (strncmp("name",option+1,2) == 0)
             {i/               resource_info.name=(char *) NULL;,!               if (*option == '-'),                 {m                   i++;                    if (i == argc)A                     Error("Missing name on -name",(char *) NULL);t-                   resource_info.name=argv[i];a                 }                break;
             }s0           if (strncmp("negate",option+1,2) == 0)             break;/           if (strncmp("noise",option+1,3) == 0);             break;3           if (strncmp("normalize",option+1,3) == 0)              break;.           Error("Unrecognized option",option);           break;	         }t         case 'o': 	         { 0           if (strncmp("opaque",option+1,2) == 0)
             {a!               if (*option == '-')                  {                    i++;                    if (i == argc)D                     Error("Missing color on -opaque",(char *) NULL);                 })               break;
             } .           Error("Unrecognized option",option);           break;	         }V         case 'p':e	         {,.           if (strncmp("page",option+1,3) == 0)
             {a,               image_info.page=(char *) NULL;!               if (*option == '-')O                 {                    i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }                break;
             }i.           Error("Unrecognized option",option);           break;	         }          case 'q':o	         { 1           if (strncmp("quality",option+1,2) == 0)-
             { #               image_info.quality=0;,!               if (*option == '-')W                 {w                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing quality on -quality",(char *) NULL); 3                   image_info.quality=atoi(argv[i]);,                 })               break;
             }d.           Error("Unrecognized option",option);           break;	         }          case 'r':*	         { /           if (strncmp("raise",option+1,2) == 0) 
             {.               i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))E                 Error("Missing bevel width on -raise",(char *) NULL);_               break;
             }W.           if (strncmp("roll",option+1,3) == 0)
             {d!               if (*option == '-')t                 {a                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -roll",(char *) NULL);                  }                break;
             }(0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')e                 {/                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing degrees on -rotate",(char *) NULL);                 }e               break;
             } .           Error("Unrecognized option",option);           break;	         }/         case 's':|	         {d0           if (strncmp("sample",option+1,2) == 0)
             { !               if (*option == '-')                  {W                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     Error("Missing geometry on -sample",(char *) NULL);l                 }                break;
             } /           if (strncmp("scene",option+1,3) == 0)a
             {                first_scene=0;               last_scene=0;c!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene; J                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 }i               break;
             } 1           if (strncmp("segment",option+1,3) == 0)f
             {n!               if (*option == '-')                  {(                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))I                     Error("Missing threshold on -segment",(char *) NULL);a                 }                break;
             } 1           if (strncmp("sharpen",option+1,5) == 0)a
             {S!               if (*option == '-')                  {y                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing factor on -sharpen",(char *) NULL);                 }-               break;
             } /           if (strncmp("shear",option+1,3) == 0).
             { !               if (*option == '-')=                 {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))L                     Error("Missing shear geometry on -shear",(char *) NULL);                 }                break;
             }i7           if (strncmp("shared_memory",option+1,5) == 0)-
             {e?               resource_info.use_shared_memory=(*option == '-');.               break;
             }w.           if (strncmp("size",option+1,2) == 0)
             {x,               image_info.size=(char *) NULL;!               if (*option == '-')(                 {|                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -size",(char *) NULL); *                   image_info.size=argv[i];                 }                break;
             } 0           if (strncmp("spread",option+1,2) == 0)
             { !               if (*option == '-');                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing amount on -spread",(char *) NULL);                  }                break;
             }t/           if (strncmp("swirl",option+1,2) == 0)c
             {m!               if (*option == '-')                  {i                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))E                     Error("Missing degrees on -swirl",(char *) NULL);                  }t               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 't': 	         {=3           if (strncmp("text_font",option+1,3) == 0) 
             {g4               resource_info.text_font=(char *) NULL;!               if (*option == '-')                  {)                   i++;                    if (i == argc)K                     Error("Missing font name on -text_font",(char *) NULL); 2                   resource_info.text_font=argv[i];                 }                break;
             }o1           if (strncmp("texture",option+1,5) == 0)x
             {0/               image_info.texture=(char *) NULL; !               if (*option == '-')                  {d                   i++;                    if (i == argc)H                     Error("Missing filename on -texture",(char *) NULL);-                   image_info.texture=argv[i];r                 }a               break;
             },/           if (strncmp("title",option+1,2) == 0) 
             { 0               resource_info.title=(char *) NULL;!               if (*option == '-')i                 {s                   i++;                    if (i == argc)C                     Error("Missing title on -title",(char *) NULL); .                   resource_info.title=argv[i];                 };               break;
             }o5           if (strncmp("transparent",option+1,3) == 0)a
             { !               if (*option == '-')                  {&                   i++;                    if (i == argc)I                     Error("Missing color on -transparent",(char *) NULL);.                 }s               break;
             }w3           if (strncmp("treedepth",option+1,3) == 0)T
             { )               resource_info.tree_depth=0;%!               if (*option == '-')%                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL); 9                   resource_info.tree_depth=atoi(argv[i]);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'u': 	         { 0           if (strncmp("update",option+1,2) == 0)
             { 4               resource_info.update=(*option == '-');!               if (*option == '-')                  {%                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing seconds on -update",(char *) NULL);4                   resource_info.delay=atoi(argv[i]);                 }o               break;
             }a4           if (strncmp("use_pixmap",option+1,2) == 0)
             { 8               resource_info.use_pixmap=(*option == '-');               break;
             }a.           Error("Unrecognized option",option);           break;	         }t         case 'v':,	         {e1           if (strncmp("verbose",option+1,2) == 0)P
             { 2               image_info.verbose=(*option == '-');               break;
             }s0           if (strncmp("visual",option+1,2) == 0)
             {d6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')(                 {a                   i++;                    if (i == argc)K                     Error("Missing visual class on -visual",(char *) NULL);l4                   resource_info.visual_type=argv[i];                 }m               break;
             }u.           Error("Unrecognized option",option);           break;	         }g         case 'w':-	         {h-           if (strcmp("window",option+1) == 0)_
             {o4               resource_info.window_id=(char *) NULL;!               if (*option == '-')i                 {i                   i++;                    if (i == argc)C                     Error("Missing id, name, or 'root' on -window",h%                       (char *) NULL);w2                   resource_info.window_id=argv[i];                 }x               break;
             } 6           if (strncmp("window_group",option+1,7) == 0)
             {)7               resource_info.window_group=(char *) NULL;a!               if (*option == '-')a                 {e                   i++;                    if (i == argc)I                     Error("Missing id, name, or 'root' on -window_group",n%                       (char *) NULL);o5                   resource_info.window_group=argv[i];.                 }U               break;
             }a/           if (strncmp("write",option+1,2) == 0) 
             { 9               resource_info.write_filename=(char *) NULL; !               if (*option == '-')                  {e                   i++;                    if (i == argc)G                     Error("Missing file name on -write",(char *) NULL);d7                   resource_info.write_filename=argv[i];nA                   if (IsAccessible(resource_info.write_filename))o                     {                        char"                         answer[2];  =                       (void) fprintf(stderr,"Overwrite %s? ",a6                         resource_info.write_filename);B                       (void) fgets(answer,sizeof(answer)-1,stdin);B                       if (!((*answer == 'y') || (*answer == 'Y')))                          exit(1);                     }+                 }o               break;
             }p.           Error("Unrecognized option",option);           break;	         }          case '?':>	         {e           Usage(True);           break;	         }w         default:	         {h.           Error("Unrecognized option",option);           break;	         }0       }      else<       for (scene=first_scene; scene <= last_scene ; scene++)       {s
         /*L           Option is a file name: begin by reading image from specified file.
         */2         (void) strcpy(image_info.filename,option);&         if (first_scene != last_scene)           {              char&               filename[MaxTextLength];               /*2               Form filename for multi-part images.             */?             (void) sprintf(filename,image_info.filename,scene);+:             if (strcmp(filename,image_info.filename) == 0)I               (void) sprintf(filename,"%s.%u",image_info.filename,scene);i8             (void) strcpy(image_info.filename,filename);           } 0         (void) strcpy(image_info.magick,"MIFF");9         image_info.server_name=resource_info.server_name;a+         image_info.font=resource_info.font;t/         image_info.dither=resource_info.dither; 7         image_info.monochrome=resource_info.monochrome; /         resource_info.image_info=(&image_info);n%         image=ReadImage(&image_info);s$         if (image == (Image *) NULL)5           if ((i < (argc-1)) || (scene < last_scene))i             continue;y           else
             {;               state|=ExitState;w               break;
             }K
         do	         {%           /*J             Transmogrify image as defined by the image processing options.           */"           resource_info.quantum=1;2           MogrifyImage(&image_info,i,argv,&image);(           if (first_scene != last_scene)             image->scene=scene;            /*&             Display image to X server.           */7           if (resource_info.window_id != (char *) NULL)+
             {                unsigned int                 status;                  /*6                 Display image to a specified X window.               */K               status=XDisplayBackgroundImage(display,&resource_info,image);                if (status)%)                 state|=RetainColorsState;%+               if (resource_info.delay == 0)a!                 state|=ExitState; 
             }i           else             do
             {o               Image                  *loaded_image;                 /**                 Display image to X server.               */               loaded_image=aN                 XDisplayImage(display,&resource_info,argv,argc,&image,&state);1               if (loaded_image == (Image *) NULL)t                 break;P               while ((loaded_image != (Image *) NULL) && (!(state & ExitState)))               {s;                 if (loaded_image->montage != (char *) NULL)u                   {                      /*G                       User selected a visual directory image (montage).                      */)                     DestroyImages(image);u'                     image=loaded_image;(                     break;                   }s?                 MogrifyImage(&image_info,i,argv,&loaded_image);a.                 if (first_scene != last_scene)%                   image->scene=scene;dJ                 next_image=XDisplayImage(display,&resource_info,argv,argc,(                   &loaded_image,&state);*                 if (loaded_image != image).                   DestroyImages(loaded_image);(                 loaded_image=next_image;               },+             } while (!(state & ExitState));n<           if (resource_info.write_filename != (char *) NULL)
             {o               /*                 Write image.               */J               (void) strcpy(image->filename,resource_info.write_filename);3               (void) WriteImage(&image_info,image);L
             }F!           if (image_info.verbose) .             DescribeImage(image,stderr,False);           /*+             Proceed to next/previous image.m           */           next_image=image;i'           if (state & FormerImageState)c5             for (j=0; j < resource_info.quantum; j++),
             {X.               next_image=next_image->previous;/               if (next_image == (Image *) NULL)m                 break;
             }d           else5             for (j=0; j < resource_info.quantum; j++)t
             {.*               next_image=next_image->next;/               if (next_image == (Image *) NULL)d                 break;
             }.+           if (next_image != (Image *) NULL)a             image=next_image;oI         } while ((next_image != (Image *) NULL) && !(state & ExitState));t
         /*           Free image resources. 
         */         DestroyImages(image);e(         if (!(state & FormerImageState)))           image_marker[i]=image_number++;l         else           {f             /*(               Proceed to previous image.             */!             for (i--; i > 0; i--)i6               if (image_marker[i] == (image_number-2))                 break;"             if (image_number != 0)               image_number--;i           }x         if (state & ExitState)           break;       }e     /*8       Determine if we should proceed to the first image.     */     if (i == (argc-1))A       if (resource_info.confirm_exit && (state & NextImageState)) 	         {            unsigned int             status;(             /*!             Confirm program exit.,           */M           status=XConfirmWidget(display,windows,"Do you really want to exit",a             client_name);n           if (status == False)
             {a               i=0;               image_number=0; 
             }W	         }a   }d    if (state & RetainColorsState)N     XRetainWindowColors(display,XRootWindow(display,XDefaultScreen(display)));   free((char *) image_marker);%   free((char *) image_info.filename);    XSync(display,False);]
   exit(0);   return(False); } 