 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %           IIIII  DDDD   EEEEE  N   N  TTTTT  IIIII  FFFFF  Y   Y            % O %             I    D   D  E      NN  N    T      I    F       Y Y             % O %             I    D   D  EEE    N N N    T      I    FFF      Y              % O %             I    D   D  E      N  NN    T      I    F        Y              % O %           IIIII  DDDD   EEEEE  N   N    T    IIIII  F        Y              % O %                                                                             % O %                                                                             % O %               Identify an Image Format and Characteristics.                 % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                            September 1994                                   % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Identify describes the format and characteristics of one or more image D %  files.  It will also report if an image is incomplete or corrupt. %  %  */   /*   Include declarations.  */ #include "magick.h"    /*   Function prototypes. */ static void    Usage(void);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Procedure Usage displays the program usage; % & %  The format of the Usage routine is: %  %      Usage() %  %  */ static void Usage(void)  {    char     **p;  
   static char      *options[]=      { G       "-verbose            print detailed information about the image",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version); M   (void) printf("Usage: %s [ options ... ] file [ file ... ]\n",client_name); .   (void) printf("\nWhere options include:\n");+   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(P     "example,  specify +verbose to display a one description of each image.\n");
   exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %    M a i n                                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(int argc,char **argv) {    Image      *image,      *next_image;     ImageInfo      image_info;      register int     i;     unsigned int
     count,     verbose;     /*!     Initialize program variables.    */   ReadCommandlLine(argc,&argv);     client_name=ClientName(*argv);   if (argc < 2)      Usage();
   count=0;   verbose=False;   /*     Identify an image.   */   GetImageInfo(&image_info);&   image_info.size=DefaultTileGeometry;   ExpandFilenames(&argc,&argv);    for (i=1; i < argc; i++)   { %     if (strncmp("-h",argv[i],2) == 0)        Usage();%     if (strncmp("-?",argv[i],2) == 0)        Usage();%     if (strncmp("-v",argv[i],2) == 0)        {          verbose=True;          continue;        } /     (void) strcpy(image_info.filename,argv[i]); !     image=ReadImage(&image_info);       if (image == (Image *) NULL)       continue; )     image->columns=image->magick_columns; #     image->rows=image->magick_rows;      do     {        next_image=image->next;        if (image->scene == 0)         image->scene=count++;        if (verbose)*         NumberColors(image,(FILE *) NULL);*       DescribeImage(image,stdout,verbose);       DestroyImage(image);'       if (next_image != (Image *) NULL)          image=next_image; +     } while (next_image != (Image *) NULL);    } 
   exit(0);   return(False); } 