 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                   D   D  E      C      O   O  D   D  E                      % O %                   D   D  EEE    C      O   O  D   D  EEE                    % O %                   D   D  E      C      O   O  D   D  E                      % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Read Image Formats                   % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "XWDFile.h"   /*   Define declarations. */- #define LoadImageText  "  Loading image...  " & #define PrematureExit(message,image) \ { \ %   Warning(message,image->filename); \    DestroyImages(image); \    return((Image *) NULL); \  }    /*   Function prototypes. */ static Image   *ReadMIFFImage(ImageInfo *),   *ReadPNMImage(ImageInfo *),    *ReadXCImage(ImageInfo *);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d A V S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadAVSImage reads a AVS X image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadAVSImage routine is:  % % %      image=ReadAVSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadAVSImage returns a pointer to the image after N %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */1 static Image *ReadAVSImage(ImageInfo *image_info)  {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      Image      *image;   	   Quantum 	     blue, 
     green,     red;     register int     x,     y;     register RunlengthPacket     *q;      unsigned int     packets,     status;      unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read AVS image.    */J   status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),     image->file);    if (status == False)0     PrematureExit("Not a AVS image file",image);   do   {      /*!       Initialize image structure.      */     image->matte=True;$     image->columns=avs_header.width;"     image->rows=avs_header.height;     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert AVS raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength; #     for (y=0; y < image->rows; y++)      { (       for (x=0; x < image->columns; x++)       { (         index=Opaque-fgetc(image->file);(         red=UpScale(fgetc(image->file));*         green=UpScale(fgetc(image->file));)         blue=UpScale(fgetc(image->file)); J         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&D             (index == q->index) && ((int) q->length < MaxRunlength))           q->length++;         else           { $             if (image->packets != 0)               q++;             image->packets++; *             if (image->packets == packets)               {                  packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket)); >                 if (image->pixels == (RunlengthPacket *) NULL)C                   PrematureExit("Unable to allocate memory",image); 1                 q=image->pixels+image->packets-1;                }              q->red=red;              q->green=green;              q->blue=blue;              q->index=index;              q->length=0;           }        } 3       ProgressMonitor(LoadImageText,y,image->rows);      } %     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); L     status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),       image->file);      if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d B M P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadBMPImage reads a Microsoft Windows bitmap image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadBMPImage routine is:  % % %      image=ReadBMPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadBMPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */1 static Image *ReadBMPImage(ImageInfo *image_info)  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *bmp_data,     *bmp_pixels,     magick[12];      unsigned int     bytes_per_line,      start_position,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a BMP file.   */3   status=ReadData((char *) magick,1,2,image->file);    do   {      /*       Verify BMP identifier.     */(     start_position=ftell(image->file)-2;D     if ((status == False) || (strncmp((char *) magick,"BM",2) != 0))2       PrematureExit("Not a BMP image file",image);7     bmp_header.file_size=LSBFirstReadLong(image->file); :     bmp_header.reserved[0]=LSBFirstReadShort(image->file);:     bmp_header.reserved[1]=LSBFirstReadShort(image->file);9     bmp_header.offset_bits=LSBFirstReadLong(image->file); 2     bmp_header.size=LSBFirstReadLong(image->file);     if (bmp_header.size == 12)       { 
         /*           OS/2 BMP image file.
         */H         bmp_header.width=(unsigned long) LSBFirstReadShort(image->file);I         bmp_header.height=(unsigned long) LSBFirstReadShort(image->file); 9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);#         bmp_header.number_colors=0; !         bmp_header.compression=0;           bmp_header.image_size=0;       }      else       { 
         /*+           Microsoft Windows BMP image file. 
         */7         bmp_header.width=LSBFirstReadLong(image->file); 8         bmp_header.height=LSBFirstReadLong(image->file);9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);=         bmp_header.compression=LSBFirstReadLong(image->file); <         bmp_header.image_size=LSBFirstReadLong(image->file);:         bmp_header.x_pixels=LSBFirstReadLong(image->file);:         bmp_header.y_pixels=LSBFirstReadLong(image->file);?         bmp_header.number_colors=LSBFirstReadLong(image->file); B         bmp_header.colors_important=LSBFirstReadLong(image->file);6         for (i=0; i < ((int) bmp_header.size-40); i++)$           (void) fgetc(image->file);       } "     if (bmp_header.bit_count < 24)       {          unsigned char            *bmp_colormap;           unsigned int           packet_size;  
         /*#           Read BMP raster colormap. 
         */!         image->class=PseudoClass; /         image->colors=bmp_header.number_colors;          if (image->colors == 0) 2           image->colors=1 << bmp_header.bit_count;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         bmp_colormap=(unsigned char *)8           malloc(4*image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (bmp_colormap == (unsigned char *) NULL)) ;           PrematureExit("Unable to allocate memory",image);          packet_size=4;"         if (bmp_header.size == 12)           packet_size=3;H         (void) ReadData((char *) bmp_colormap,packet_size,image->colors,           image->file);          p=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { 0           image->colormap[i].blue=UpScale(*p++);1           image->colormap[i].green=UpScale(*p++); /           image->colormap[i].red=UpScale(*p++); $           if (bmp_header.size != 12)             p++;	         } $         free((char *) bmp_colormap);       }      /*       Read image data.     */H     while (ftell(image->file) < (start_position+bmp_header.offset_bits))        (void) fgetc(image->file);#     if (bmp_header.image_size == 0)        bmp_header.image_size=L         ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;     bmp_data=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));+     if (bmp_data == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image); M     (void) ReadData((char *) bmp_data,1,(unsigned int) bmp_header.image_size,        image->file);      bmp_pixels=bmp_data;$     if (bmp_header.compression != 0)       {          unsigned int           packets;  
         /*3           Convert run-length encoded raster pixels. 
         */         packets=N           ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;(         if (bmp_header.compression == 2)           packets<<=1;K         bmp_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); 1         if (bmp_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); 2         (void) BMPDecodeImage(bmp_data,bmp_pixels,P           (unsigned int) bmp_header.compression,(unsigned int) bmp_header.width,,           (unsigned int) bmp_header.height);(         if (bmp_header.compression == 2)#           bmp_header.bit_count<<=1;           free((char *) bmp_data);       }      /*!       Initialize image structure.      */$     image->columns=bmp_header.width;"     image->rows=bmp_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert BMP raster image to runlength-encoded packets.     */C     bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; !     switch (bmp_header.bit_count)      { 
       case 1:        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-7); x+=8)            { '             for (bit=0; bit < 8; bit++) 
             { <               q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);               q->length=0;               q++;
             }              p++;           } (           if ((image->columns % 8) != 0)
             { <               for (bit=0; bit < (image->columns % 8); bit++)               { >                 q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);                 q->length=0;                 q++;               }                p++;
             } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          SyncImage(image);          break;       } 
       case 4:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-1); x+=2)            { %             q->index=(*p >> 4) & 0xf;              q->length=0;             q++;              q->index=(*p) & 0xf;             q->length=0;             p++;             q++;           } (           if ((image->columns % 2) != 0)
             { '               q->index=(*p >> 4) & 0xf;                q->length=0;               q++;               p++;
             } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          SyncImage(image);           CompressColormap(image);         break;       } 
       case 8:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */(         if (bmp_header.compression == 1)(           bytes_per_line=image->columns;*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          SyncImage(image);           CompressColormap(image);         break;       }        case 24:       { 
         /*J           Convert DirectColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           { B             q->index=(unsigned short) (image->matte ? (*p++) : 0);"             q->blue=UpScale(*p++);#             q->green=UpScale(*p++); !             q->red=UpScale(*p++);              q->length=0;             q++;           } C           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }          break;       }        default:4         PrematureExit("Not a BMP image file",image);     }      free((char *) bmp_pixels);     CompressImage(image);      /*       Proceed to next image.     */5     status=ReadData((char *) magick,1,2,image->file); C     if ((status == True) && (strncmp((char *) magick,"BM",2) == 0))        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } G   } while ((status == True) && (strncmp((char *) magick,"BM",2) == 0)); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d C M Y K I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ReadCMYKImage reads an image of raw cyan, magenta, yellow, andM %  black bytes and returns it.  It allocates the memory necessary for the new : %  Image structure and returns a pointer to the new image. % . %  The format of the ReadCMYKImage routine is: % & %      image=ReadCMYKImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadCMYKImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadCMYKImage(ImageInfo *image_info) {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *cmyk_pixels;      unsigned int black, 	     cyan,      height,      magenta,     yellow, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;O   cmyk_pixels=(unsigned char *) malloc(4*image->packets*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if ((cmyk_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */E   (void) ReadData((char *) cmyk_pixels,4,image->packets,image->file);    p=cmyk_pixels;    switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       q=image->pixels;%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         {             ReadQuantum(q->red,p);"           ReadQuantum(q->green,p);!           ReadQuantum(q->blue,p); "           ReadQuantum(q->index,p);           q->length=0;           q++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }      case LineInterlace:      {        /*K         Line interlacing:  CCC...MMM...YYY...KKK...CCC...MMM...YYY...KKK...        */%       for (y=0; y < image->rows; y++)        { )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {             ReadQuantum(q->red,p);           q->length=0;           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { "           ReadQuantum(q->green,p);           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { !           ReadQuantum(q->blue,p);            q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         { "           ReadQuantum(q->index,p);           q++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          ReadQuantum(q->red,p);         q->length=0;         q++;       } -       ProgressMonitor(LoadImageText,100,400);        q=image->pixels;(       for (i=0; i < image->packets; i++)       {           ReadQuantum(q->green,p);         q++;       } -       ProgressMonitor(LoadImageText,200,400);        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          ReadQuantum(q->blue,p);          q++;       } -       ProgressMonitor(LoadImageText,300,400);        q=image->pixels;(       for (i=0; i < image->packets; i++)       {           ReadQuantum(q->index,p);         q++;       } -       ProgressMonitor(LoadImageText,400,400);        break;     }    }    /*%     Transform image from CMYK to RGB.    */   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        cyan=q->red;       magenta=q->green;        yellow=q->blue;        black=q->index;         if ((cyan+black) > MaxRGB)         q->red=0; 
       else#         q->red=MaxRGB-(cyan+black); #       if ((magenta+black) > MaxRGB)          q->green=0; 
       else(         q->green=MaxRGB-(magenta+black);"       if ((yellow+black) > MaxRGB)         q->blue=0;
       else&         q->blue=MaxRGB-(yellow+black);       q->index=0;        q->length=0;
       q++;     }    }    free((char *) cmyk_pixels);    CompressImage(image);    CloseImage(image);   return(image); }  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d D P S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % P %  Function ReadDPSImage reads a Adobe Postscript image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadDPSImage routine is:  % % %      image=ReadDPSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadDPSImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasDPS 1 static Image *ReadDPSImage(ImageInfo *image_info)  {  #include <DPS/dpsXclient.h>  #include <DPS/dpsXpreview.h>  	   Display 
     *display;      float      pixels_per_point;      Image      *image;      int 	     sans,      status,      x,     y;     Pixmap     pixmap;      register int     i;     register RunlengthPacket     *p;      register unsigned long
     pixel;     Screen     *screen;     XColor     *colors;     XImage     *dps_image;      XRectangle     bounding_box,      pixel_size;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     return((Image *) NULL);    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)      return((Image *) NULL);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    else     {        /*         Initialize visual info.        */*       resource_info.visual_type="default";C       visual_info=XBestVisualInfo(display,map_info,&resource_info); )       map_info->colormap=(Colormap) NULL;      } 1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*7     Create a pixmap the appropriate size for the image.    */6   screen=ScreenOfDisplay(display,visual_info->screen);.   pixels_per_point=XDPSPixelsPerPoint(screen);+   if (image_info->density != (char *) NULL)      {        float          x_resolution,          y_resolution;   	       int          count;  3       x_resolution=72.0*XDPSPixelsPerPoint(screen); L       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2) "         y_resolution=x_resolution;;       pixels_per_point=Min(x_resolution,y_resolution)/72.0;      } F   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,K     visual_info->depth,pixels_per_point,&pixmap,&pixel_size,&bounding_box); L   if ((status == dps_status_failure) || (status == dps_status_no_extension))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*'     Rasterize the file into the pixmap.    */O   status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap,image->file, G     pixel_size.height,visual_info->depth,&bounding_box,-bounding_box.x, <     -bounding_box.y,pixels_per_point,True,False,True,&sans);#   if (status != dps_status_success)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Initialize DPS X image.    */L   dps_image=XGetImage(display,pixmap,0,0,pixel_size.width,pixel_size.height,     AllPlanes,ZPixmap);    XFreePixmap(display,pixmap);#   if (dps_image == (XImage *) NULL)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {        DestroyImage(image);       XDestroyImage(dps_image); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      } ,   if ((visual_info->class != DirectColor) &&(       (visual_info->class != TrueColor))2     for (i=0; i < visual_info->colormap_size; i++)     {        colors[i].pixel=i;       colors[i].pad=0;     }    else     {        unsigned long 
         blue,          blue_bit,          green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0; C       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1); I       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1); F       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       { +         colors[i].pixel=red | green | blue;          colors[i].pad=0;         red+=red_bit; (         if (red > visual_info->red_mask)           red=0;         green+=green_bit; ,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit; *         if (blue > visual_info->blue_mask)           blue=0;        }      } L   XQueryColors(display,XDefaultColormap(display,visual_info->screen),colors,      visual_info->colormap_size);   /*#     Convert X image to MIFF format.    */*   if ((visual_info->class != TrueColor) &&*       (visual_info->class != DirectColor))     image->class=PseudoClass; "   image->columns=dps_image->width;    image->rows=dps_image->height;,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     {        DestroyImage(image);       free((char *) colors);       XDestroyImage(dps_image); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    p=image->pixels;   switch (image->class)    {      case DirectClass:      {        register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;        red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } )       green_mask=visual_info->green_mask;        green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } '       blue_mask=visual_info->blue_mask;        blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */-       if ((visual_info->colormap_size > 0) && .           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);              p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         } 
       else'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             color=(pixel >> red_shift) & red_mask;7             p->red=XDownScale((color*65535L)/red_mask); 6             color=(pixel >> green_shift) & green_mask;;             p->green=XDownScale((color*65535L)/green_mask); 4             color=(pixel >> blue_shift) & blue_mask;9             p->blue=XDownScale((color*65535L)/blue_mask);              p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }        break;     }      case PseudoClass:      {        /*         Create colormap.       *//       image->colors=visual_info->colormap_size; P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {            DestroyImage(image);            free((char *) colors);#           XDestroyImage(dps_image); J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { G         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red); K         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green); I         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { =           p->index=(unsigned short) XGetPixel(dps_image,x,y);            p->length=0;           p++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        SyncImage(image);        break;     }    } "   if (image->class == PseudoClass)     CompressColormap(image);   free((char *) colors);   XDestroyImage(dps_image);    /*     Rasterize matte image.   */H   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,1,8     pixels_per_point,&pixmap,&pixel_size,&bounding_box);L   if ((status != dps_status_failure) && (status != dps_status_no_extension))     { G       status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap, F         image->file,pixel_size.height,1,&bounding_box,-bounding_box.x,?         -bounding_box.y,pixels_per_point,True,True,True,&sans); '       if (status == dps_status_success) 	         {            XImage             *matte_image;              /*#             Initialize image matte.            */D           matte_image=XGetImage(display,pixmap,0,0,pixel_size.width,1             pixel_size.height,AllPlanes,ZPixmap); &           XFreePixmap(display,pixmap);-           if (matte_image != (XImage *) NULL) 
             { '               image->class=DirectClass;                 image->matte=True;               p=image->pixels;-               for (y=0; y < image->rows; y++) 2                 for (x=0; x < image->columns; x++)                 { "                   p->index=Opaque;2                   if (!XGetPixel(matte_image,x,y)))                     p->index=Transparent;                    p++;                 } )               XDestroyImage(matte_image); 
             } 	         }      }    /*     Free resources.    */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   CompressImage(image);    CloseImage(image);   return(image); }  #else 1 static Image *ReadDPSImage(ImageInfo *image_info)  { 9   Warning("Cannot read DPS images",image_info->filename);    return((Image *) NULL);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d F A X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadFAXImage reads a Group 3 FAX image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadFAXImage routine is:  % % %      image=ReadFAXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadFAXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */1 static Image *ReadFAXImage(ImageInfo *image_info)  {    Image      *image;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image structure.    */   image->class=PseudoClass;    image->columns=1728;   image->rows=2156; <   image->packets=Max((image->columns*image->rows+8) >> 4,1);#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Monochrome colormap.   */    image->colormap[0].red=MaxRGB;"   image->colormap[0].green=MaxRGB;!   image->colormap[0].blue=MaxRGB;    image->colormap[1].red=0;    image->colormap[1].green=0;    image->colormap[1].blue=0;#   status=HuffmanDecodeImage(image);    if (status == False)5     PrematureExit("Unable to read image data",image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d F I T S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadFITSImage reads a FITS image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadFITSImage routine is: % & %      image=ReadFITSImage(image_info) % + %  A description of each parameter follows:  % I %    o image: Function ReadFITSImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */2 static Image *ReadFITSImage(ImageInfo *image_info) {    typedef struct _FITSHeader   {      unsigned int
       simple;        int        bits_per_pixel;        unsigned int       number_of_axis,        columns,       rows,        depth;  
     double       min_data,        max_data,        zero,        scale;   } FITSHeader;      char     keyword[MaxTextLength],      value[MaxTextLength];      double
     pixel,
     scale,     scaled_pixel;      FITSHeader     fits_header;     Image      *image;      int      j,     packet_size,     y;     long
     count,     quantum;     register int     c,     i,     x;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *fits_pixels;      unsigned int     status,      value_expected;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image header.   */   fits_header.simple=False;    fits_header.bits_per_pixel=8;    fits_header.columns=1;   fits_header.rows=1;    fits_header.depth=1;   fits_header.min_data=0.0;    fits_header.max_data=0.0;    fits_header.zero=0.0;    fits_header.scale=1.0;   /*     Decode image header.   */   c=fgetc(image->file); 
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      } 
   for ( ; ; )    {      if (!isalnum(c))       {          c=fgetc(image->file);          count++;       }      else       {          register char 
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;+         } while (isalnum(c) || (c == '_'));          *p='\0';'         if (strcmp(keyword,"END") == 0)            break;         value_expected=False; (         while (isspace(c) || (c == '='))	         {            if (c == '=')               value_expected=True;           c=fgetc(image->file);            count++;	         } $         if (value_expected == False)           continue;          p=value;D         while (isalnum(c) || (c == '-') || (c == '+') || (c == '.'))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */*         if (strcmp(keyword,"SIMPLE") == 0)@           fits_header.simple=(*value == 'T') || (*value == 't');*         if (strcmp(keyword,"BITPIX") == 0)@           fits_header.bits_per_pixel=(unsigned int) atoi(value);)         if (strcmp(keyword,"NAXIS") == 0) @           fits_header.number_of_axis=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS1") == 0)9           fits_header.columns=(unsigned int) atoi(value); *         if (strcmp(keyword,"NAXIS2") == 0)6           fits_header.rows=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS3") == 0)7           fits_header.depth=(unsigned int) atoi(value); +         if (strcmp(keyword,"DATAMAX") == 0) +           fits_header.max_data=atof(value); +         if (strcmp(keyword,"DATAMIN") == 0) +           fits_header.min_data=atof(value); )         if (strcmp(keyword,"BZERO") == 0) '           fits_header.zero=atof(value); *         if (strcmp(keyword,"BSCALE") == 0)(           fits_header.scale=atof(value);       }      while (isspace(c))     {        c=fgetc(image->file);        count++;     }    }    while (count > 2880)     count-=2880;    for ( ; count < 2880; count++)     (void) fgetc(image->file);   /*6     Verify that required image information is defined.   */B   if ((!fits_header.simple) || (fits_header.number_of_axis < 1) ||)       (fits_header.number_of_axis > 3) || 2       (fits_header.columns*fits_header.rows) == 0)4     PrematureExit("image type not supported",image);   /*     Create linear colormap.    */%   image->columns=fits_header.columns;    image->rows=fits_header.rows;    image->class=PseudoClass;    image->colors=MaxRGB+1; L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)/     PrematureExit("Unable to open file",image); #   for (i=0; i < image->colors; i++)    { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);    }    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); +   packet_size=fits_header.bits_per_pixel/8;    if (packet_size < 0)     packet_size=(-packet_size);    fits_pixels=(unsigned char *) =     malloc(image->packets*packet_size*sizeof(unsigned char)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||.       (fits_pixels == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*5     Convert FITS pixels to runlength-encoded packets.    */B   status=ReadData((char *) fits_pixels,(unsigned int) packet_size,      image->packets,image->file);   if (status == False)?     Warning("Insufficient image data in file",image->filename); E   if ((fits_header.min_data == 0.0) && (fits_header.max_data == 0.0))      {        /*0         Determine minimum and maximum intensity.       */       p=fits_pixels;       quantum=(*p++); )       for (j=0; j < (packet_size-1); j++) (         quantum=(quantum << 8) | (*p++);       pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum)); D       fits_header.min_data=pixel*fits_header.scale+fits_header.zero;D       fits_header.max_data=pixel*fits_header.scale+fits_header.zero;(       for (i=1; i < image->packets; i++)       {          quantum=(*p++); +         for (j=0; j < (packet_size-1); j++) *           quantum=(quantum << 8) | (*p++);         pixel=(double) quantum; .         if (fits_header.bits_per_pixel == -32)1           pixel=(double) (*((float *) &quantum)); >         scaled_pixel=pixel*fits_header.scale+fits_header.zero;0         if (scaled_pixel < fits_header.min_data),           fits_header.min_data=scaled_pixel;0         if (scaled_pixel > fits_header.max_data),           fits_header.max_data=scaled_pixel;       }      }    /*5     Convert FITS pixels to runlength-encoded packets.    */   scale=1.0;3   if (fits_header.min_data != fits_header.max_data) A     scale=(MaxRGB+1)/(fits_header.max_data-fits_header.min_data);    p=fits_pixels;   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        quantum=(*p++); )       for (j=0; j < (packet_size-1); j++) (         quantum=(quantum << 8) | (*p++);       pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum));        scaled_pixel=scale* H         (pixel*fits_header.scale+fits_header.zero-fits_header.min_data);       while (scaled_pixel < 0)!         scaled_pixel+=(MaxRGB+1); #       while (scaled_pixel > MaxRGB) !         scaled_pixel-=(MaxRGB+1); -       q->index=(unsigned short) scaled_pixel;        q->length=0;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) fits_pixels);    SyncImage(image);    CompressColormap(image);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G I F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGIFImage reads a Compuserve Graphics image file and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % - %  The format of the ReadGIFImage routine is:  % % %      image=ReadGIFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadGIFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or %      an error occurs.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */1 static Image *ReadGIFImage(ImageInfo *image_info)  { 5 #define BitSet(byte,bit)  (((byte) & (bit)) == (bit)) . #define LSBFirstOrder(x,y)  (((y) << 8) | (x))     Image      *image;      int 	     left,      status,      top,     x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      short int      transparency_index;      unsigned char      c,	     flag,      *global_colormap,      header[MaxTextLength],     magick[12];      unsigned int
     delay,     global_colors,     height,      image_count,
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a GIF file.   */3   status=ReadData((char *) magick,1,6,image->file); H   if ((status == False) || ((strncmp((char *) magick,"GIF87",5) != 0) &&1       (strncmp((char *) magick,"GIF89",5) != 0))) 0     PrematureExit("Not a GIF image file",image);   global_colors=0;)   global_colormap=(unsigned char *) NULL; '   width=LSBFirstReadShort(image->file); (   height=LSBFirstReadShort(image->file);2   (void) ReadData((char *) &flag,1,1,image->file);G   (void) ReadData((char *) &c,1,1,image->file);  /* background color */ ?   (void) ReadData((char *) &c,1,1,image->file);  /* reserved */    if (BitSet(flag,0x80))     {        /*         Read global colormap.        */+       global_colors=1 << ((flag & 0x07)+1); '       global_colormap=(unsigned char *) 6         malloc(3*global_colors*sizeof(unsigned char));4       if (global_colormap == (unsigned char *) NULL)B         PrematureExit("Unable to read image colormap file",image);L       (void) ReadData((char *) global_colormap,3,global_colors,image->file);     } 
   delay=0;   transparency_index=(-1);   image_count=0;
   for ( ; ; )    { 1     status=ReadData((char *) &c,1,1,image->file);      if (status == False)       break;     if (c == ';')        break;  /* terminator */     if (c == '!')        { 
         /*           GIF Extension block.
         */5         status=ReadData((char *) &c,1,1,image->file);          if (status == False)@           PrematureExit("Unable to read extention block",image);         switch (c)	         {            case 0xf9:           {              /*.               Read Graphics Control extension.             */C             while (ReadDataBlock((char *) header,image->file) > 0); /             delay=(header[2] << 8) | header[1]; (             if ((header[0] & 0x01) == 1)+               transparency_index=header[3];              break;           }            case 0xfe:           {              int                length;                /*%               Read Comment extension.              */             for ( ; ; ) 
             { @               length=ReadDataBlock((char *) header,image->file);               if (length <= 0)                 break;3               if (image->comments != (char *) NULL) J                 image->comments=(char *) realloc((char *) image->comments,C                   (strlen(image->comments)+length+1)*sizeof(char));                else                 { K                   image->comments=(char *) malloc((length+1)*sizeof(char)); 7                   if (image->comments != (char *) NULL) *                     *image->comments='\0';                 } 3               if (image->comments == (char *) NULL) A                 PrematureExit("Unable to allocate memory",image); "               header[length]='\0';=               (void) strcat(image->comments,(char *) header); 
             }              break;           }            default:           { C             while (ReadDataBlock((char *) header,image->file) > 0);              break;           } 	         }        }      if (c != ',')        continue;      if (image_count != 0)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }      image_count++;     /*       Read image attributes.     */     image->class=PseudoClass; (     left=LSBFirstReadShort(image->file);'     top=LSBFirstReadShort(image->file); 2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file); .     image->packets=image->columns*image->rows;     if (image->packets == 0)-       PrematureExit("image size is 0",image);      /*       Allocate image.      */2     if (image->pixels != (RunlengthPacket *) NULL)#       free((char *) image->pixels); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); =     image->delay=(char *) malloc(MaxTextLength*sizeof(char)); <     image->page=(char *) malloc(MaxTextLength*sizeof(char));6     if ((image->pixels == (RunlengthPacket *) NULL) ||J         (image->delay == (char *) NULL) || (image->page == (char *) NULL))7       PrematureExit("Unable to allocate memory",image); D     (void) sprintf(image->page,"%ux%u%+d%+d",width,height,left,top);,     (void) sprintf(image->delay,"%u",delay);     /*       Inititialize colormap.     */4     (void) ReadData((char *) &flag,1,1,image->file);'     image->interlace=BitSet(flag,0x40); N     image->colors=!BitSet(flag,0x80) ? global_colors : 1 << ((flag & 0x07)+1);N     image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));0     if (image->colormap == (ColorPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      if (!BitSet(flag,0x80))        { 
         /*           Use global colormap.
         */         p=global_colormap;)         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }        }      else       {          unsigned char            *colormap;  
         /*           Read local colormap.
         */"         colormap=(unsigned char *)8           malloc(3*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); G         (void) ReadData((char *) colormap,3,image->colors,image->file);          p=colormap; )         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }           free((char *) colormap);       }      /*       Decode image.      */!     status=GIFDecodeImage(image);      if (image->interlace)        { 
         Image            *interlaced_image;           int            pass;             register RunlengthPacket
           *p;            static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */,         image_info->interlace=LineInterlace;         image->orphan=True; J         interlaced_image=CopyImage(image,image->columns,image->rows,True);         image->orphan=False;/         if (interlaced_image == (Image *) NULL) ;           PrematureExit("Unable to allocate memory",image); #         p=interlaced_image->pixels;          q=image->pixels;&         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             q=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } '         DestroyImage(interlaced_image);        }       if (transparency_index >= 0)       { 
         /*           Create matte channel. 
         */         q=image->pixels;*         for (i=0; i < image->packets; i++)	         { >           if (q->index != (unsigned short) transparency_index)             q->index=Opaque;           else!             q->index=Transparent;            q++;	         }           transparency_index=(-1);!         image->class=DirectClass;          image->matte=True;       }      if (status == False)       { 5         Warning("Corrupt GIF image",image->filename);          break;       }      CompressImage(image); "     if (image_info->subimage != 0)2       if ((image->scene+1) < image_info->subimage)	         {            Image              subimage;              /*             Destroy image.           */           subimage=(*image);$           image->file=(FILE *) NULL;           DestroyImage(image);*           image=AllocateImage(image_info);&           if (image == (Image *) NULL)#             return((Image *) NULL); $           image->file=subimage.file;(           image->scene=subimage.scene+1;           image_count=0;	         } 
       elseN         if ((image->scene+1) >= (image_info->subimage+image_info->subrange-1))           break;   } 0   if (global_colormap != (unsigned char *) NULL)#     free((char *) global_colormap); 0   if (image->pixels == (RunlengthPacket *) NULL)C     PrematureExit("Corrupt GIF image or subimage not found",image); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G R A Y I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGRAYImage reads an image of raw grayscale bytes and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % . %  The format of the ReadGRAYImage routine is: % & %      image=ReadGRAYImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadGRAYImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadGRAYImage(ImageInfo *image_info) {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      unsigned int     height,      packets,
     width;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Create linear colormap.    */   image->class=PseudoClass; "   image->colors=1 << QuantumDepth;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); #   for (i=0; i < image->colors; i++)    { '     image->colormap[i].red=(Quantum) i; )     image->colormap[i].green=(Quantum) i; (     image->colormap[i].blue=(Quantum) i;   }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   image->columns=width;    image->rows=height;    image->packets=0; 5   packets=Max((image->columns*image->rows+4) >> 3,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */   q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        ReadQuantumFile(index); B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;/               image->pixels=(RunlengthPacket *) P                 realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));<               if (image->pixels == (RunlengthPacket *) NULL)A                 PrematureExit("Unable to allocate memory",image); /               q=image->pixels+image->packets-1; 
             }            q->index=index;            q->length=0;	         }        } 1     ProgressMonitor(LoadImageText,y,image->rows);    } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    SyncImage(image);    CompressColormap(image);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H D F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadHDFImage reads a Hierarchical Data Format image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadHDFImage routine is:  % % %      image=ReadHDFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadHDFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasHDF 1 static Image *ReadHDFImage(ImageInfo *image_info)  {  #include "hdf.h"
 #undef BSD #undef LOCAL     Image      *image;      int      interlace,     is_palette,      status,      y;     int32      height,      length, 
     width;     register int     i,     x;     register unsigned char     *p;      register RunlengthPacket     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int
     class,     packet_size;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);   /*     Read HDF image.    */   class=DirectClass;@   status=DF24getdims(image->filename,&width,&height,&interlace);   if (status == -1)      {        class=PseudoClass;E       status=DFR8getdims(image->filename,&width,&height,&is_palette);      }    if (status == -1) I     PrematureExit("Image file or does not contain any image data",image);    do   {      /*!       Initialize image structure.      */     image->class=class;      image->columns=width;      image->rows=height; .     image->packets=image->columns*image->rows;     packet_size=1;$     if (image->class == DirectClass)       packet_size=3;      hdf_pixels=(unsigned char *)?       malloc(packet_size*image->packets*sizeof(unsigned char)); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 1     if ((hdf_pixels == (unsigned char *) NULL) || 4         (image->pixels == (RunlengthPacket *) NULL))7       PrematureExit("Unable to allocate memory",image);      q=image->pixels;$     if (image->class == PseudoClass)       {          unsigned char            *hdf_palette;   
         /*           Create colormap.
         */H         hdf_palette=(unsigned char *) malloc(768*sizeof(unsigned char));         image->colors=256;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));6         if ((hdf_palette == (unsigned char *) NULL) ||6             (image->colormap == (ColorPacket *) NULL));           PrematureExit("Unable to allocate memory",image); L         (void) DFR8getimage(image->filename,hdf_pixels,(int) image->columns,)           (int) image->rows,hdf_palette);           reference=DFR8lastref();
         /*L           Convert HDF raster image to PseudoClass runlength-encoded packets.
         */         p=hdf_palette;         if (is_palette) !           for (i=0; i < 256; i++)            { 1             image->colormap[i].red=UpScale(*p++); 3             image->colormap[i].green=UpScale(*p++); 2             image->colormap[i].blue=UpScale(*p++);           }          else+           for (i=0; i < image->colors; i++)            { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);            } #         free((char *) hdf_palette);          p=hdf_pixels; '         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }          SyncImage(image);        }      else       {          int            x,           y;  
         /*L           Convert HDF raster image to DirectClass runlength-encoded packets.
         */O         (void) DF24getimage(image->filename,(void *) hdf_pixels,image->columns,            image->rows);           reference=DF24lastref();         p=hdf_pixels; *         image_info->interlace=interlace+1;&         switch (image_info->interlace)	         {            case NoneInterlace:            default:           {              /*4               No interlacing:  RGBRGBRGBRGBRGBRGB...             */             q=image->pixels;+             for (y=0; y < image->rows; y++) 
             { 0               for (x=0; x < image->columns; x++)               { %                 q->red=UpScale(*p++); '                 q->green=UpScale(*p++); &                 q->blue=UpScale(*p++);                 q->index=0;                  q->length=0;                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows); 
             }              break;           }            case LineInterlace:            {              /*E               Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...              */+             for (y=0; y < image->rows; y++) 
             { /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { %                 q->red=UpScale(*p++);                  q->index=0;                  q->length=0;                 q++;               } /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { '                 q->green=UpScale(*p++);                  q++;               } /               q=image->pixels+y*image->columns; 0               for (x=0; x < image->columns; x++)               { &                 q->blue=UpScale(*p++);                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows); 
             }              break;           }            case PlaneInterlace:           {              /*=               Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...              */3             ProgressMonitor(LoadImageText,100,400);              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { #               q->red=UpScale(*p++);                q->index=0;                q->length=0;               q++;
             } 3             ProgressMonitor(LoadImageText,200,400);              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { %               q->green=UpScale(*p++);                q++;
             } 3             ProgressMonitor(LoadImageText,300,400);              q=image->pixels;.             for (i=0; i < image->packets; i++)
             { $               q->blue=UpScale(*p++);               q++;
             } 3             ProgressMonitor(LoadImageText,400,400);              break;           } 	         }        } >     length=DFANgetlablen(image->filename,DFTAG_RIG,reference);     if (length > 0)        { 
         /*           Read the image label. 
         */         length+=MaxTextLength;:         image->label=(char *) malloc(length*sizeof(char));*         if (image->label != (char *) NULL)P           DFANgetlabel(image->filename,DFTAG_RIG,reference,image->label,length);       } ?     length=DFANgetdesclen(image->filename,DFTAG_RIG,reference);      if (length > 0)        { 
         /*"           Read the image comments.
         */         length+=MaxTextLength;=         image->comments=(char *) malloc(length*sizeof(char)); -         if (image->comments != (char *) NULL) J           DFANgetdesc(image->filename,DFTAG_RIG,reference,image->comments,             length);       }      free((char *) hdf_pixels);     CompressImage(image);      class=DirectClass;B     status=DF24getdims(image->filename,&width,&height,&interlace);     if (status == -1)        {          class=PseudoClass;G         status=DFR8getdims(image->filename,&width,&height,&is_palette);        }      if (status != -1)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status != -1); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }  #else 1 static Image *ReadHDFImage(ImageInfo *image_info)  { ?   Warning("HDF library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H I S T O G R A M I m a g e                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadHISTOGRAMImage reads a HISTOGRAM image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % 3 %  The format of the ReadHISTOGRAMImage routine is:  % + %      image=ReadHISTOGRAMImage(image_info)  % + %  A description of each parameter follows:  % O %    o image:  Function ReadHISTOGRAMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadHISTOGRAMImage(ImageInfo *image_info)  {    Image      *image;   "   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H T M L I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadHTMLImage reads a HTML image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadHTMLImage routine is: % & %      image=ReadHTMLImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadHTMLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadHTMLImage(ImageInfo *image_info) {    Image      *image;   :   Warning("Cannot read HTML images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }    #ifdef HasJBIG #include "jbig.h"  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J B I G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadJBIGImage reads a JBIG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadJBIGImage routine is: % & %      image=ReadJBIGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJBIGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadJBIGImage(ImageInfo *image_info) {  #define MaxBufferSize  8192      Image      *image;      int      length,      status,      x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      register unsigned short 
     index;     size_t
     count;     struct jbg_dec_state     jbig_info;     unsigned char      bit,     buffer[MaxBufferSize];     unsigned int	     byte,      height,      packets,
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*5     Determine maximum width and height, e.g. 640x512.    */   width=65535L;    height=65535L;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Read JBIG file.    */   jbg_dec_init(&jbig_info); K   jbg_dec_maxsize(&jbig_info,(unsigned long) width,(unsigned long) height);    status=JBG_EAGAIN;   do   { 5     length=fread(buffer,1,MaxBufferSize,image->file);      if (length == 0)       break;
     p=buffer;      count=0;K     while ((length > 0) && ((status == JBG_EAGAIN) || (status == JBG_EOK)))      { 4       status=jbg_dec_in(&jbig_info,p,length,&count);       p+=count;        length-=count;     } :   } while ((status == JBG_EAGAIN) || (status == JBG_EOK));   /*     Initialize image structure.    */.   image->columns=jbg_dec_getwidth(&jbig_info);,   image->rows=jbg_dec_getheight(&jbig_info);   image->packets=0; 5   packets=Max((image->columns*image->rows+8) >> 4,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Create colormap.   */   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    image->colormap[0].red=0;    image->colormap[0].green=0;    image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    /*8     Convert X bitmap image to runlength-encoded packets.   */	   byte=0; #   p=jbg_dec_getimage(&jbig_info,0);    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 
     bit=0;&     for (x=0; x < image->columns; x++)     {        if (bit == 0)          byte=(*p++);"       index=(byte & 0x80) ? 0 : 1;B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;O               image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, 1                 packets*sizeof(RunlengthPacket)); <               if (image->pixels == (RunlengthPacket *) NULL)                 { +                   jbg_dec_free(&jbig_info); C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->index=index;            q->length=0;	         }        bit++;       byte<<=1;        if (bit == 8)          bit=0;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    jbg_dec_free(&jbig_info);    SyncImage(image); #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    CloseImage(image);   return(image); }  #else 2 static Image *ReadJBIGImage(ImageInfo *image_info) { @   Warning("JBIG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   #ifdef HasJPEG #include <setjmp.h>  #include "jpeglib.h" #include "jerror.h"    static Image	   *image;    static jmp_buf   error_recovery;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadJPEGImage reads a JPEG image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % . %  The format of the ReadJPEGImage routine is: % & %      image=ReadJPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJPEGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % ? %    o filename:  Specifies the name of the jpeg image to read.  %  %  */  < static unsigned int GetCharacter(j_decompress_ptr jpeg_info) {    struct jpeg_source_mgr
     *data;     data=jpeg_info->src;!   if (data->bytes_in_buffer == 0) +     (*data->fill_input_buffer) (jpeg_info);    data->bytes_in_buffer--;.   return(GETJOCTET(*data->next_input_byte++)); }   5 static int CommentHandler(j_decompress_ptr jpeg_info)  { 
   long int     length;      register char      *p;      /*      Determine length of comment.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2;'   if (image->comments != (char *) NULL) >     image->comments=(char *) realloc((char *) image->comments,F       (unsigned int) (strlen(image->comments)+length+1)*sizeof(char));   else     {        image->comments=(char *)7         malloc((unsigned int) (length+1)*sizeof(char)); +       if (image->comments != (char *) NULL)          *image->comments='\0';     } '   if (image->comments == (char *) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        return(False);     }    /*     Read comment.    */,   p=image->comments+strlen(image->comments);   while (--length >= 0) !     *p++=GetCharacter(jpeg_info); 
   *p='\0';   return(True);  }   9 static void EmitMessage(j_common_ptr jpeg_info,int level)  {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { L       if ((jpeg_error->num_warnings == 0) || (jpeg_error->trace_level >= 3))2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }   - static void ErrorExit(j_common_ptr jpeg_info)  {    EmitMessage(jpeg_info,0);    longjmp(error_recovery,1); }   2 static Image *ReadJPEGImage(ImageInfo *image_info) {    int      y;  	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];  	   Quantum 	     blue, 
     green,     red;     register int     i,     x;     register JSAMPLE     *p;      register RunlengthPacket     *q;      struct jpeg_decompress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     packets;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image structure.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;&   jpeg_info.err->error_exit=ErrorExit;)   image->pixels=(RunlengthPacket *) NULL;    jpeg_pixels=(JSAMPLE *) NULL;    if (setjmp(error_recovery))      {        /*         JPEG image is corrupt.       */*       if (jpeg_pixels != (JSAMPLE *) NULL)	         { %           free((char *) jpeg_pixels); .           jpeg_destroy_decompress(&jpeg_info);	         }        DestroyImage(image);       return((Image *) NULL);      } %   jpeg_create_decompress(&jpeg_info); @   jpeg_set_marker_processor(&jpeg_info,JPEG_COM,CommentHandler);)   jpeg_stdio_src(&jpeg_info,image->file); +   (void) jpeg_read_header(&jpeg_info,True); (   if (image_info->size != (char *) NULL)     {        unsigned int         height,          width;         unsigned long          scale_factor;          /*.         Let the JPEG library subsample for us.       */.       jpeg_calc_output_dimensions(&jpeg_info);3       image->magick_columns=jpeg_info.output_width; 1       image->magick_rows=jpeg_info.output_height; #       width=jpeg_info.output_width; %       height=jpeg_info.output_height; :       ParseImageGeometry(image_info->size,&width,&height);       if (width == 0)          width=1;9       scale_factor=UpShift(jpeg_info.output_width)/width;        if (height == 0)         height=1; C       if (scale_factor > (UpShift(jpeg_info.output_height)/height)) =         scale_factor=UpShift(jpeg_info.output_height)/height; 4       jpeg_info.scale_denom=DownShift(scale_factor);.       jpeg_calc_output_dimensions(&jpeg_info);     }  #if (JPEG_LIB_VERSION >= 61)"   jpeg_info.dct_method=JDCT_FLOAT;.   image->interlace=jpeg_info.progressive_mode; #endif$   jpeg_start_decompress(&jpeg_info);(   image->columns=jpeg_info.output_width;&   image->rows=jpeg_info.output_height;   image->packets=0; 5   packets=Max((image->columns*image->rows+2) >> 2,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   jpeg_pixels=(JSAMPLE *) G     malloc(jpeg_info.output_components*image->columns*sizeof(JSAMPLE)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||(       (jpeg_pixels == (JSAMPLE *) NULL))5     PrematureExit("Unable to allocate memory",image); 1   if (jpeg_info.out_color_space == JCS_GRAYSCALE)      {        /*&         Initialize grayscale colormap.       */       image->class=PseudoClass;        image->colors=256;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); '       for (i=0; i < image->colors; i++)        { *         image->colormap[i].red=UpScale(i);,         image->colormap[i].green=UpScale(i);+         image->colormap[i].blue=UpScale(i);        }      }    /*5     Convert JPEG pixels to runlength-encoded packets.    */   red=0;
   green=0;	   blue=0; 
   index=0;%   scanline[0]=(JSAMPROW) jpeg_pixels;    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 6     (void) jpeg_read_scanlines(&jpeg_info,scanline,1);     p=jpeg_pixels;&     for (x=0; x < image->columns; x++)     { 2       if (jpeg_info.data_precision > QuantumDepth)	         { 9           if (jpeg_info.out_color_space == JCS_GRAYSCALE) (             index=GETJSAMPLE(*p++) >> 4;           else
             { 4               red=(Quantum) (GETJSAMPLE(*p++) >> 4);6               green=(Quantum) (GETJSAMPLE(*p++) >> 4);5               blue=(Quantum) (GETJSAMPLE(*p++) >> 4); 8               if (jpeg_info.out_color_space == JCS_CMYK)8                 index=(Quantum) (GETJSAMPLE(*p++) >> 4);
             } 
          }        else 8          if (jpeg_info.out_color_space == JCS_GRAYSCALE)"            index=GETJSAMPLE(*p++);
          else             {5              red=(Quantum) UpScale(GETJSAMPLE(*p++)); 7              green=(Quantum) UpScale(GETJSAMPLE(*p++)); 6              blue=(Quantum) UpScale(GETJSAMPLE(*p++));7              if (jpeg_info.out_color_space == JCS_CMYK) 9                index=(Quantum) UpScale(GETJSAMPLE(*p++));             }0       if (jpeg_info.out_color_space == JCS_CMYK)	         { !           index=MAXJSAMPLE-index; $           if ((int) (red-index) < 0)             red=0;           else             red-=index; &           if ((int) (green-index) < 0)             green=0;           else             green-=index; %           if ((int) (blue-index) < 0)              blue=0;            else             blue-=index;           index=0;	         } H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;/               image->pixels=(RunlengthPacket *) P                 realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));<               if (image->pixels == (RunlengthPacket *) NULL)                 { -                   free((char *) jpeg_pixels); 6                   jpeg_destroy_decompress(&jpeg_info);C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->red=red;            q->green=green;            q->blue=blue;            q->index=index;            q->length=0;	         }      } 1     ProgressMonitor(LoadImageText,y,image->rows);    } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); "   if (image->class == PseudoClass)     {        SyncImage(image);        CompressColormap(image);     }    /*     Free memory.   */   free((char *) jpeg_pixels); ,   (void) jpeg_finish_decompress(&jpeg_info);&   jpeg_destroy_decompress(&jpeg_info);   CloseImage(image);   return(image); }  #else 2 static Image *ReadJPEGImage(ImageInfo *image_info) { @   Warning("JPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d L O G O I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadLOGOImage reads a LOGO image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadLOGOImage routine is: % & %      image=ReadLOGOImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadLOGOImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadLOGOImage(ImageInfo *image_info) {  #include "logo.h"      char     *filename,!     logo_filename[MaxTextLength];      FILE
     *file;     Image      *image;      register int     i;     register unsigned char     *p;      /*     Open temporary output file.    */#   TemporaryFilename(logo_filename);     file=fopen(logo_filename,"w");   if (file == (FILE *) NULL)     { 4       Warning("Unable to write file",logo_filename);&       return(ReadXCImage(image_info));     }    p=LogoImage;%   for (i=0; i < LogoImageLength; i++)    { !     (void) fputc((char) *p,file);      p++;   }    if (ferror(file))      { E       Warning("An error has occurred writing to file",logo_filename);        (void) fclose(file);#       (void) remove(logo_filename); &       return(ReadXCImage(image_info));     }    (void) fclose(file);    filename=image_info->filename;%   image_info->filename=logo_filename; "   image=ReadMIFFImage(image_info);    image_info->filename=filename;   if (image != (Image *) NULL)8     (void) strcpy(image->filename,image_info->filename);   (void) remove(logo_filename);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadMAPImage reads an image of raw RGB colormap and colormap indexM %  bytes and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadMAPImage routine is:  % % %      image=ReadMAPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMAPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */1 static Image *ReadMAPImage(ImageInfo *image_info)  {    Image      *image;      int      colors;      register int     i;     register unsigned char     *p;      unsigned char      *colormap;     unsigned int     height,      packet_size,     status, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*D     Determine width, height, and number of colors, e.g. 640x512+256.   */   width=512;
   height=512; 
   colors=256; (   if (image_info->size != (char *) NULL)K     (void) XParseGeometry(image_info->size,&colors,&colors,&width,&height);    /*     Initialize image structure.    */   image->class=PseudoClass; #   image->compression=NoCompression;    image->columns=width;    image->rows=height;    image->colors=colors; ,   image->packets=image->columns*image->rows;$   packet_size=3*(image->depth >> 3);   colormap=(unsigned char *)<     malloc(packet_size*image->colors*sizeof(unsigned char));L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));(   image->packed_pixels=(unsigned char *);     malloc(image->packets*packet_size*(image->depth >> 3)); -   if ((colormap == (unsigned char *) NULL) || 0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Read image colormap.   */M   (void) ReadData((char *) colormap,1,image->colors*packet_size,image->file); 
   p=colormap; #   for (i=0; i < image->colors; i++)    { *     ReadQuantum(image->colormap[i].red,p);,     ReadQuantum(image->colormap[i].green,p);+     ReadQuantum(image->colormap[i].blue,p);    }    free((char *) colormap);   /*6     Convert raster image to runlength-encoded packets.   */   packet_size=1;   if (image->colors > 256)     packet_size++;5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);(   image->packed_pixels=(unsigned char *)'     malloc(image->packets*packet_size); 5   if (image->packed_pixels == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image); K   (void) ReadData((char *) image->packed_pixels,packet_size,image->packets,      image->file); %   status=RunlengthDecodeImage(image);    if (status == False)     {        DestroyImages(image);        return((Image *) NULL);      }    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A T T E I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadMATTEImage reads an image of raw matte bytes and returns it.N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % / %  The format of the ReadMATTEImage routine is:  % ' %      image=ReadMATTEImage(image_info)  % + %  A description of each parameter follows:  % K %    o image:  Function ReadMATTEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */3 static Image *ReadMATTEImage(ImageInfo *image_info)  {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char
     index,     *p;      unsigned char      *matte_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   image->matte=True;   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;N   matte_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 1   if ((matte_pixels == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */F   (void) ReadData((char *) matte_pixels,1,image->packets,image->file);   p=matte_pixels;    q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        index=(*p++);        q->red=0;        q->green=0;        q->blue=0;&       q->index=(unsigned short) index;       q->length=0;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) matte_pixels);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d M I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMIFFImage reads a MIFF image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMIFFImage routine is: % $ %      image=ReadMIFFImage(filename) % + %  A description of each parameter follows:  % I %    o image: Function ReadMIFFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasPNG  #include "zlib.h"  #endif  2 static Image *ReadMIFFImage(ImageInfo *image_info) {    char     keyword[MaxTextLength],      value[MaxTextLength];      Image      *image;      register int     c,     i;     register unsigned char     *p;      unsigned int     length,      packet_size,     status;      unsigned long 
     count,     packets;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    image->depth=8;    /*G     Decode image header;  header terminates one character beyond a ':'.    */   c=fgetc(image->file);    if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    do   {      /*I       Decode image header;  header terminates one character beyond a ':'.      */%     image->compression=NoCompression; $     while (isgraph(c) && (c != ':'))     {        register char          *p;          if (c == '{') 	         {            /*0             Read comment-- any text between { }.           *//           if (image->comments != (char *) NULL) 
             { -               length=strlen(image->comments); '               p=image->comments+length; 
             }            else
             { #               length=MaxTextLength; C               image->comments=(char *) malloc(length*sizeof(char));                 p=image->comments;
             } 8           for ( ; image->comments != (char *) NULL; p++)           { !             c=fgetc(image->file); )             if ((c == EOF) || (c == '}'))                break;0             if ((p-image->comments+1) >= length)               {                  *p='\0';                 length<<=1; (                 image->comments=(char *)H                   realloc((char *) image->comments,length*sizeof(char));5                 if (image->comments == (char *) NULL)                    break;:                 p=image->comments+strlen(image->comments);               } !             *p=(unsigned char) c;            } /           if (image->comments == (char *) NULL) =             PrematureExit("Unable to allocate memory",image);            *p='\0';           c=fgetc(image->file); 	         } 
       else         if (isalnum(c))            {              /*0               Determine a keyword and its value.             */             p=keyword;             do
             { 2               if ((p-keyword) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); !             } while (isalnum(c));              *p='\0';,             while (isspace(c) || (c == '='))#               c=fgetc(image->file);              p=value;-             while (!isspace(c) && (c != EOF)) 
             { 0               if ((p-value) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); 
             }              *p='\0';             /*6               Assign a value to the specified keyword.             */-             if (strcmp(keyword,"class") == 0) 3               if (strcmp(value,"PseudoClass") == 0) )                 image->class=PseudoClass;                else5                 if (strcmp(value,"DirectClass") == 0) +                   image->class=DirectClass;                  else.                   image->class=UndefinedClass;.             if (strcmp(keyword,"colors") == 0)7               image->colors=(unsigned int) atoi(value); 3             if (strcmp(keyword,"compression") == 0) L               if ((strcmp(value,"Zip") == 0) || (strcmp(value,"Zlib") == 0))2                 image->compression=ZipCompression;               else:                 if (strcmp(value,"RunlengthEncoded") == 0)A                   image->compression=RunlengthEncodedCompression;                  else:                   image->compression=UndefinedCompression;/             if (strcmp(keyword,"columns") == 0) 8               image->columns=(unsigned int) atoi(value);-             if (strcmp(keyword,"depth") == 0) 5               image->depth=atoi(value) <= 8 ? 8 : 16; -             if (strcmp(keyword,"gamma") == 0) '               image->gamma=atof(value); *             if (strcmp(keyword,"id") == 0)3               if (strcmp(value,"ImageMagick") == 0) (                 image->id=ImageMagickId;               else&                 image->id=UndefinedId;1             if ((strcmp(keyword,"matte") == 0) || /                 (strcmp(keyword,"alpha") == 0)) M               if ((strcmp(value,"True") == 0) || (strcmp(value,"true") == 0)) "                 image->matte=True;               else#                 image->matte=False; /             if (strcmp(keyword,"montage") == 0)                { M                 image->montage=(char *) malloc(strlen(value)+1*sizeof(char)); 4                 if (image->montage == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 4                 (void) strcpy(image->montage,value);               } /             if (strcmp(keyword,"packets") == 0) 8               image->packets=(unsigned int) atoi(value);,             if (strcmp(keyword,"rows") == 0)5               image->rows=(unsigned int) atoi(value); -             if (strcmp(keyword,"scene") == 0) 6               image->scene=(unsigned int) atoi(value);1             if (strcmp(keyword,"signature") == 0)                { )                 image->signature=(char *) 9                   malloc((strlen(value)+1)*sizeof(char)); 6                 if (image->signature == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 6                 (void) strcpy(image->signature,value);               }            }          else           c=fgetc(image->file);        while (isspace(c))         c=fgetc(image->file);      }      (void) fgetc(image->file);     /*8       Verify that required image information is defined.     */I     if ((image->id == UndefinedId) || (image->class == UndefinedClass) || P         (image->compression == UndefinedCompression) || (image->columns == 0) ||         (image->rows == 0)) <       PrematureExit("Incorrect image header in file",image);(     if (image->montage != (char *) NULL)       {          register char 
           *p;   
         /*           Image directory.
         */E         image->directory=(char *) malloc(MaxTextLength*sizeof(char)); .         if (image->directory == (char *) NULL);           PrematureExit("Unable to read image data",image);          p=image->directory; 
         do	         {            *p='\0';H           if ((((int) strlen(image->directory)+1) % MaxTextLength) == 0)
             {                /*=                 Allocate more memory for the image directory.                */J               image->directory=(char *) realloc((char *) image->directory,I                 (strlen(image->directory)+MaxTextLength+1)*sizeof(char)); 4               if (image->directory == (char *) NULL)A                 PrematureExit("Unable to read image data",image); :               p=image->directory+strlen(image->directory);
             }            c=fgetc(image->file); !           *p++=(unsigned char) c;          } while (c != '\0');       } $     if (image->class == PseudoClass)       {          unsigned int           colors;            unsigned short           value;  
         /*3           PseudoClass image cannot have matte data. 
         */         if (image->matte) B           PrematureExit("Matte images must be DirectClass",image);
         /*            Create image colormap.
         */         colors=image->colors;          if (colors == 0)           colors=256; K         image->colormap=(ColorPacket *) malloc(colors*sizeof(ColorPacket)); 4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          if (image->colors == 0) $           for (i=0; i < colors; i++)           { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);              image->colors++;           }          else           {              unsigned char                *colormap;               /*,               Read image colormap from file.             */.             packet_size=3*(image->depth >> 3);&             colormap=(unsigned char *)F               malloc(packet_size*image->colors*sizeof(unsigned char));3             if (colormap == (unsigned char *) NULL) ?               PrematureExit("Unable to allocate memory",image); J             (void) ReadData((char *) colormap,1,packet_size*image->colors,               image->file);              p=colormap; -             for (i=0; i < image->colors; i++) 
             { 4               ReadQuantum(image->colormap[i].red,p);6               ReadQuantum(image->colormap[i].green,p);5               ReadQuantum(image->colormap[i].blue,p); 
             } $             free((char *) colormap);           }        }      /*#       Determine packed packet size.      */$     if (image->class == PseudoClass)       {          image->packet_size=1;           if (image->colors > 256)           image->packet_size++;        }      else       { 1         image->packet_size=3*(image->depth >> 3);          if (image->matte)            image->packet_size++;        } :     if (image->compression == RunlengthEncodedCompression)       image->packet_size++; #     packet_size=image->packet_size; -     if (image->compression == ZipCompression)        packet_size=1;     /*       Allocate image pixels.     */,     if (image->compression == NoCompression)0       image->packets=image->columns*image->rows;     packets=image->packets;      if (image->packets == 0))       packets=image->columns*image->rows; *     image->packed_pixels=(unsigned char *)G       malloc((unsigned int) packets*packet_size*sizeof(unsigned char)); 7     if (image->packed_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      /*"       Read image pixels from file.     */>     if ((image->compression != RunlengthEncodedCompression) ||         (image->packets != 0))D       (void) ReadData((char *) image->packed_pixels,1,(unsigned int))         packets*packet_size,image->file);      else       { 
         /*5           Number of runlength packets is unspecified. 
         */         count=0;         p=image->packed_pixels; 
         do	         { @           (void) ReadData((char *) p,1,packet_size,image->file);           image->packets++;            p+=(packet_size-1);            count+=(*p+1);           p++;	         } 5         while (count < (image->columns*image->rows));        } .     if (image->compression ==  ZipCompression)       {          int            status;            unsigned char            *compressed_pixels;   
         /*4           Uncompress image pixels with Zip encoding.
         *//         compressed_pixels=image->packed_pixels; >         packets=image->columns*image->rows*image->packet_size;.         image->packed_pixels=(unsigned char *)0           malloc(packets*sizeof(unsigned char));;         if (image->packed_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          status=True;
 #ifdef HasPNG J         status=uncompress(image->packed_pixels,&packets,compressed_pixels,           image->packets); #endif2         image->packets=packets/image->packet_size;)         free((char *) compressed_pixels);          if (status) @           PrematureExit("Unable to Zip uncompress image",image);       }      /*J       Unpack the packed image pixels into runlength-encoded pixel packets.     */'     status=RunlengthDecodeImage(image);      if (status == False)       {          DestroyImages(image);          return((Image *) NULL);        }      /*       Proceed to next image.     */     do     {        c=fgetc(image->file); (     } while (!isgraph(c) && (c != EOF));     if (c != EOF)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (c != EOF); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #ifdef HasMPEG #undef BitmapPad #include "mpeg.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMPEGImage reads a MPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMPEGImage routine is: % & %      image=ReadMPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadMPEGImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadMPEGImage(ImageInfo *image_info) {    Image      *image;      ImageDesc      mpeg_info;     int      y;     register int     x;     register unsigned char     *p;      register RunlengthPacket     *q;      unsigned char      *mpeg_pixels;      unsigned int     number_frames,     status;      unsigned long      lsb_first;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate MPEG pixels.    */*   (void) OpenMPEG(image->file,&mpeg_info);C   number_frames=8*image->filesize/mpeg_info.Width/mpeg_info.Height; M   mpeg_pixels=(unsigned char *) malloc(mpeg_info.Size*sizeof(unsigned char)); ,   if (mpeg_pixels == (unsigned char *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Read MPEG image.   */,   status=GetMPEGFrame((char *) mpeg_pixels);    if (image_info->subimage != 0)/     while (image->scene < image_info->subimage)      {        /*         Skip to next image.        */       image->scene++; 0       status=GetMPEGFrame((char *) mpeg_pixels);       if (status == False)         break;@       ProgressMonitor(LoadImageText,image->scene,number_frames);     }    if (status == False)     { !       free((char *) mpeg_pixels); 0       PrematureExit("Corrupt MPEG image",image);     }    while (status == True)   {      /*!       Initialize image structure.      */#     image->columns=mpeg_info.Width; #     image->rows=mpeg_info.Height-8; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*=       Convert MPEG raster image to runlength-encoded packets.      */     p=mpeg_pixels;     q=image->pixels;     lsb_first=1;     if (*(char *) &lsb_first) %       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         {            q->red=UpScale(*p++); !           q->green=UpScale(*p++);             q->blue=UpScale(*p++);           q->length=0;           p++;           q++;	         }        }      else%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         {            p++;            q->blue=UpScale(*p++);!           q->green=UpScale(*p++);            q->red=UpScale(*p++);            q->length=0;           q++;	         }        }      if (image_info->verbose)(       DescribeImage(image,stderr,False);     CompressImage(image); "     if (image_info->subimage != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;.     status=GetMPEGFrame((char *) mpeg_pixels);     if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } =     if ((status == False) || (image->scene == number_frames)) #       number_frames=image->scene+1; >     ProgressMonitor(LoadImageText,image->scene,number_frames);   }    free((char *) mpeg_pixels); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #else 2 static Image *ReadMPEGImage(ImageInfo *image_info) { @   Warning("MPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M T V I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadMTVImage reads a MTV image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % - %  The format of the ReadMTVImage routine is:  % % %      image=ReadMTVImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMTVImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */1 static Image *ReadMTVImage(ImageInfo *image_info)  {    Image      *image;      int 
     count,     y;  	   Quantum 	     blue, 
     green,     red;     register int     x;     register RunlengthPacket     *q;      unsigned int     columns,     packets,	     rows;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read MTV image.    */5   count=fscanf(image->file,"%u %u\n",&columns,&rows);    if (count == 0) 0     PrematureExit("Not a MTV image file",image);   do   {      /*!       Initialize image structure.      */     image->columns=columns;      image->rows=rows;      image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert MTV raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength; #     for (y=0; y < image->rows; y++)      { (       for (x=0; x < image->columns; x++)       { (         red=UpScale(fgetc(image->file));*         green=UpScale(fgetc(image->file));)         blue=UpScale(fgetc(image->file)); J         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&-             ((int) q->length < MaxRunlength))            q->length++;         else           { $             if (image->packets != 0)               q++;             image->packets++; *             if (image->packets == packets)               {                  packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket)); >                 if (image->pixels == (RunlengthPacket *) NULL)C                   PrematureExit("Unable to allocate memory",image); 1                 q=image->pixels+image->packets-1;                }              q->red=red;              q->green=green;              q->blue=blue;              q->index=0;              q->length=0;           }        } 3       ProgressMonitor(LoadImageText,y,image->rows);      } %     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));      /*       Proceed to next image.     */7     count=fscanf(image->file,"%u %u\n",&columns,&rows);      if (count > 0)       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (count > 0);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             % O %                                                                             % O %  R e a d N U L L I m a g e                                                  % O %                                                                             %CO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadNULLImage reads a NULL image file and returns it.  ItEK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadNULLImage routine is: % & %      image=ReadNULLImage(image_info) % + %  A description of each parameter follows:  %RJ %    o image:  Function ReadNULLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadNULLImage(ImageInfo *image_info) {    Image      *image;   :   Warning("Cannot read NULL images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             % O %                                                                             %yO %  R e a d P C D I m a g e                                                    %oO %                                                                             %gO %                                                                             % O %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %sH %  Function ReadPCDImage reads a Photo CD image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns aPF %  pointer to the new image.  Much of the PCD decoder was derived from. %  the program hpcdtoppm(1) by Hadmut Danisch. %r- %  The format of the ReadPCDImage routine is:l % % %      image=ReadPCDImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPCDImage returns a pointer to the image aftercL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.a %b %  */  V static void Upsample(unsigned int width,unsigned int height,unsigned int scaled_width,   unsigned char *pixels) {m   register int     x,     y;     register unsigned char     *p,r     *q,i     *r;o     /*L     Create a new image that is a integral size greater than an existing one.   */   for (y=0; y < height; y++)   { 1     p=pixels+(height-1-y)*scaled_width+(width-1); ?     q=pixels+((height-1-y) << 1)*scaled_width+((width-1) << 1);%     *q=(*p);     *(q+1)=(*(p));     for (x=1; x < width; x++)b     {n
       p--;       q-=2;i       *q=(*p);0       *(q+1)=(((int) *p)+((int) *(p+1))+1) >> 1;     }d   }l    for (y=0; y < (height-1); y++)   {i#     p=pixels+(y << 1)*scaled_width;d     q=p+scaled_width;n     r=q+scaled_width;d!     for (x=0; x < (width-1); x++)E     {s(       *q=(((int) *p)+((int) *r)+1) >> 1;J       *(q+1)=(((int) *p)+((int) *(p+2))+((int) *r)+((int) *(r+2))+2) >> 2;       q+=2;        p+=2;o       r+=2;t     }a,     *q++=(((int) *p++)+((int) *r++)+1) >> 1;,     *q++=(((int) *p++)+((int) *r++)+1) >> 1;   } %   p=pixels+(2*height-2)*scaled_width;%%   q=pixels+(2*height-1)*scaled_width;%   for (x=0; x < width; x++)    {      *q++=(*p++);     *q++=(*p++);   }  }   ? static Image *OverviewImage(ImageInfo *image_info,Image *image,    unsigned int number_images)  {  #define ClientName  "montage"      char     *resource_value;  	   Displaya
     *display;g     Image 
     **images;      register int     i,     j;     XMontageInfo     montage_info;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     /*     Allocate images array.   */:   images=(Image **) malloc(number_images*sizeof(Image *));    if (images == (Image **) NULL)     {%7       Warning("Memory allocation error",(char *) NULL);        return((Image *) NULL);r     }A   /*     Open X server connection.    */7   resource_info.background_color=DefaultTileBackground;n*   resource_info.border_color=BorderColor;;:   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground;o&   resource_info.gravity=CenterGravity;3   resource_info.image_geometry=DefaultTileGeometry; -   resource_info.matte_color=DefaultTileMatte;e$   resource_info.title=(char *) NULL;0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {a       /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);e       /*3         Get user defaults from X resource database.t       */B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);L       resource_info.background_color=XGetResourceInstance(resource_database,7         ClientName,"background",DefaultTileBackground); D       resource_value=XGetResourceClass(resource_database,ClientName,.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,7         ClientName,"foreground",DefaultTileForeground);RJ       resource_info.image_geometry=XGetResourceInstance(resource_database,8         ClientName,"imageGeometry",DefaultTileGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database,c2         ClientName,"mattecolor",DefaultTileMatte);       XCloseDisplay(display);m     }w   /*/     Read each image and convert them to a tile.t   */   j=0;#   for (i=0; i < number_images; i++)    {-     LabelImage(image,"%f");aF     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)(       DescribeImage(image,stderr,False);     images[j]=image;     image=image->next;     j++;   }o   /*"     Create the PCD Overview image.   */!   XGetMontageInfo(&montage_info);y   montage_info.number_tiles=j;%   if (montage_info.number_tiles != 0) 
     image=N       XMontageImage(images,&resource_info,&montage_info,image_info->filename);   free((char *) images);   if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);=   CompressImage(image);>   return(image); }>  1 static Image *ReadPCDImage(ImageInfo *image_info)- {n   ImageR     *image;   
   long int     offset;      register int     i;     register RunlengthPacket     *p;      register unsigned char     *c1,     *c2,     *y;      unsigned char=
     *chroma1, 
     *chroma2,      *header,
     *luma;     unsigned int     height,=     number_images,
     overview,)     rotate,      status,p
     subimage,i
     width;     /*     Allocate image structure.-   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);)   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)n/     PrematureExit("Unable to open file",image);    /*$     Determine if this is a PCD file.   */A   header=(unsigned char *) malloc(3*0x800*sizeof(unsigned char));)'   if (header == (unsigned char *) NULL)a5     PrematureExit("Unable to allocate memory",image);a9   status=ReadData((char *) header,1,3*0x800,image->file); 5   overview=strncmp((char *) header,"PCD_OPA",7) == 0;    if ((status == False) ||C       ((strncmp((char *) header+0x800,"PCD",3) != 0) && !overview))u0     PrematureExit("Not a PCD image file",image);   rotate=header[0x0e02] & 0x03;-/   number_images=(header[10] << 8) | header[11];    free((char *) header);
   subimage=3;u    if (image_info->subimage != 0)"     subimage=image_info->subimage;(   if (image_info->size != (char *) NULL)     {n	       intm
         x,
         y;         /*.         Determine which image size to extract.       */       width=768;       height=512; C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);U1       for (subimage=1; subimage <= 6; subimage++)e       {u.         if ((width <= 192) && (height <= 128))           break;         width>>=1;         height>>=1;        }      }    if (overview)      subimage=1;    /*     Initialize image structure.    */   width=192;
   height=128; %   for (i=1; i < Min(subimage,3); i++)    {      width<<=1;     height<<=1;    }    image->columns=width;    image->rows=height;a   for ( ; i < subimage; i++)   {      image->columns<<=1;      image->rows<<=1;   }    /*$     Allocate luma and chroma memory.   */,   image->packets=image->columns*image->rows;M   chroma1=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char)); M   chroma2=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));%J   luma=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));,   if ((chroma1 == (unsigned char *) NULL) ||N       (chroma2 == (unsigned char *) NULL) || (luma == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);r   /*     Advance to image data.   */   offset=93;   if (overview)g
     offset=2;    else     if (subimage == 2)       offset=20;     else       if (subimage == 1)         offset=1; $   for (i=0; i < (offset*0x800); i++)     (void) fgetc(image->file);   if (overview)t     {        Image          *overview_image;         register int
         j;         /*,         Read thumbnails from overview image.       */(       for (j=1; j <= number_images; j++)       {t8         (void) sprintf(image->filename,"img%04d.pcd",j);         image->scene=j;          image->columns=width;l         image->rows=height; 2         image->packets=image->columns*image->rows;)         image->pixels=(RunlengthPacket *) 9           malloc(image->packets*sizeof(RunlengthPacket)); 6         if (image->pixels == (RunlengthPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          y=luma;          c1=chroma1;e         c2=chroma2; #         for (i=0; i < height; i+=2) 	         {n:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;@           (void) ReadData((char *) c1,1,width >> 1,image->file);           c1+=image->columns;(@           (void) ReadData((char *) c2,1,width >> 1,image->file);           c2+=image->columns;f	         } N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);
         /*6           Transfer luminance and chrominance channels.
         */         p=image->pixels;         y=luma;f         c1=chroma1;r         c2=chroma2;e*         for (i=0; i < image->packets; i++)	         {            p->red=UpScale(*y++);r"           p->green=UpScale(*c1++);!           p->blue=UpScale(*c2++);B           p->index=0;l           p->length=0;           p++;	         }i/         TransformRGBImage(image,YCCColorspace);R         CompressImage(image);_          if (image_info->verbose),           DescribeImage(image,stderr,False);         if (j < number_images)           {z             /*'               Allocate image structure.f             */2             image->next=AllocateImage(image_info);.             if (image->next == (Image *) NULL)               { %                 DestroyImages(image); '                 return((Image *) NULL);g               } *             image->next->file=image->file;(             image->next->previous=image;             image=image->next;           } 9         ProgressMonitor(LoadImageText,j-1,number_images);        }        free(chroma2);       free(chroma1);       free(luma); /       while (image->previous != (Image *) NULL)l         image=image->previous;       CloseImage(image);C       overview_image=OverviewImage(image_info,image,number_images);        return(overview_image);s     }o   /*     Allocate image pixels.   */#   image->pixels=(RunlengthPacket *))3     malloc(image->packets*sizeof(RunlengthPacket));a0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);r   /*     Read interleaved image.m   */	   y=luma;o
   c1=chroma1;a
   c2=chroma2;l   for (i=0; i < height; i+=2)_   {t4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;:     (void) ReadData((char *) c1,1,width >> 1,image->file);     c1+=image->columns; :     (void) ReadData((char *) c2,1,width >> 1,image->file);     c2+=image->columns;o   }    if (subimage >= 4)     {c       /*5         Recover luminance deltas for 1536x1024 image.s       */,       Upsample(768,512,image->columns,luma);/       Upsample(384,256,image->columns,chroma1);c/       Upsample(384,256,image->columns,chroma2);>       image->rows=1024;)#       for (i=0; i < (4*0x800); i++)a"         (void) fgetc(image->file);8       status=PCDDecodeImage(image,luma,chroma1,chroma2);$       if ((subimage >= 5) && status)	         {r           /*9             Recover luminance deltas for 3072x2048 image.c           */2           Upsample(1536,1024,image->columns,luma);3           Upsample(768,512,image->columns,chroma1);i3           Upsample(768,512,image->columns,chroma2);c           image->rows=2048;)-           offset=ftell(image->file)/0x800+12; 3           (void) fseek(image->file,offset*0x800,0);-<           status=PCDDecodeImage(image,luma,chroma1,chroma2);(           if ((subimage >= 6) && status)
             {U               /*I                 Recover luminance deltas for 6144x4096 image (vaporware).r               */6               Upsample(3072,2048,image->columns,luma);9               Upsample(1536,1024,image->columns,chroma1);d9               Upsample(1536,1024,image->columns,chroma2);(               image->rows=4096; 
             }a	         }      }(H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);   /*0     Transfer luminance and chrominance channels.   */   p=image->pixels;	   y=luma;c
   c1=chroma1;g
   c2=chroma2;)$   for (i=0; i < image->packets; i++)   {)     p->red=UpScale(*y++);      p->green=UpScale(*c1++);     p->blue=UpScale(*c2++);e     p->index=0;!     p->length=0;     p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(LoadImageText,i,image->packets);   }s   free(chroma2);   free(chroma1);
   free(luma);e)   TransformRGBImage(image,YCCColorspace);m%   if ((rotate == 1) || (rotate == 3))r     {s       double         degrees;         Image_         *rotated_image;m         /*         Rotate image.)       */)       degrees=rotate == 1 ? -90.0 : 90.0;        image->orphan=True;UO       rotated_image=RotateImage(image,degrees,(ColorPacket *) NULL,False,True);x       image->orphan=False;*       if (rotated_image != (Image *) NULL)	         {t           DestroyImage(image);           image=rotated_image;	         }m     }n   CompressImage(image);d   CloseImage(image);   return(image); }m a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %>O %                                                                             %>O %                                                                             %NO %  R e a d P C X I m a g e                                                    %vO %                                                                             %iO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %0M %  Function ReadPCXImage reads a ZSoft IBM PC Paintbrush file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % - %  The format of the ReadPCXImage routine is:  % % %      image=ReadPCXImage(image_info)0 % + %  A description of each parameter follows:= % I %    o image:  Function ReadPCXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.x %; %  */1 static Image *ReadPCXImage(ImageInfo *image_info)  {    typedef struct _PCXHeader    {      unsigned charr       identifier,m       version,       encoding,)       bits_per_pixel;   
     short int        left,a
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned chark       reserved, 
       planes;i  
     short int=       bytes_per_line,        palette_info;(       unsigned chars       colormap_signature;g   } PCXHeader;     PCXHeader      pcx_header;0     Imagee     *image;      int 	     bits, 
     count,     id,(	     mask,0     packets,     pcx_packets;  	   Quantum+	     blue, 
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p,)     *r;      unsigned char      packet,p     *pcx_colormap,     *pcx_pixels,     *scanline;     unsigned int     status;      unsigned long      *page_table;     unsigned short
     index;     /*     Allocate image structure.m   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);.#   if (image->file == (FILE *) NULL)c/     PrematureExit("Unable to open file",image);>   /*$     Determine if this is a PCX file.   */$   page_table=(unsigned long *) NULL;,   if (strcmp(image_info->magick,"DCX") == 0)     {-       unsigned longu         magic;         /*          Read the DCX page table.       */*       magic=LSBFirstReadLong(image->file);       if (magic != 987654321) 4         PrematureExit("Not a DCX image file",image);F       page_table=(unsigned long *) malloc(1024*sizeof(unsigned long));/       if (page_table == (unsigned long *) NULL) 9         PrematureExit("Unable to allocate memory",image);i!       for (id=0; id < 1024; id++)o       { 5         page_table[id]=LSBFirstReadLong(image->file);=          if (page_table[id] == 0)           break;       })     }p+   if (page_table != (unsigned long *) NULL)>.     (void) fseek(image->file,page_table[0],0);C   status=ReadData((char *) &pcx_header.identifier,1,1,image->file);>   for (id=1; id < 1024; id++)    {b     /*       Verify PCX identifier.     */B     (void) ReadData((char *) &pcx_header.version,1,1,image->file);?     if ((status == False) || (pcx_header.identifier != 0x0a) ||oA         ((pcx_header.version != 2) && (pcx_header.version != 5)));2       PrematureExit("Not a PCX image file",image);C     (void) ReadData((char *) &pcx_header.encoding,1,1,image->file); I     (void) ReadData((char *) &pcx_header.bits_per_pixel,1,1,image->file); 3     pcx_header.left=LSBFirstReadShort(image->file); 2     pcx_header.top=LSBFirstReadShort(image->file);4     pcx_header.right=LSBFirstReadShort(image->file);5     pcx_header.bottom=LSBFirstReadShort(image->file);=D     pcx_header.horizontal_resolution=LSBFirstReadShort(image->file);B     pcx_header.vertical_resolution=LSBFirstReadShort(image->file);     /*       Read PCX raster colormap.      */8     image->columns=(pcx_header.right-pcx_header.left)+1;5     image->rows=(pcx_header.bottom-pcx_header.top)+1;-.     image->packets=image->columns*image->rows;     image->colors=16;mD     image->colormap=(ColorPacket *) malloc(256*sizeof(ColorPacket));G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char));L4     if ((image->colormap == (ColorPacket *) NULL) ||1         (pcx_colormap == (unsigned char *) NULL))%7       PrematureExit("Unable to allocate memory",image); G     (void) ReadData((char *) pcx_colormap,3,image->colors,image->file);      p=pcx_colormap; %     for (i=0; i < image->colors; i++)      { +       image->colormap[i].red=UpScale(*p++); -       image->colormap[i].green=UpScale(*p++); ,       image->colormap[i].blue=UpScale(*p++);     } C     (void) ReadData((char *) &pcx_header.reserved,1,1,image->file); A     (void) ReadData((char *) &pcx_header.planes,1,1,image->file); E     if ((pcx_header.bits_per_pixel != 8) || (pcx_header.planes != 3))        image->class=PseudoClass; =     pcx_header.bytes_per_line=LSBFirstReadShort(image->file);%;     pcx_header.palette_info=LSBFirstReadShort(image->file);      for (i=0; i < 58; i++)        (void) fgetc(image->file);     /*       Read image data.     */     image->packets=0;m7     packets=Max((image->columns*image->rows+4) >> 3,1);r'     if (pcx_header.bits_per_pixel == 1)e9       packets=Max((image->columns*image->rows+8) >> 4,1);RN     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));H     pcx_packets=image->rows*pcx_header.bytes_per_line*pcx_header.planes;K     pcx_pixels=(unsigned char *) malloc(pcx_packets*sizeof(unsigned char));r     scanline=(unsigned char *)E       malloc(image->columns*pcx_header.planes*sizeof(unsigned char));c6     if ((image->pixels == (RunlengthPacket *) NULL) ||1         (pcx_pixels == (unsigned char *) NULL) || -         (scanline == (unsigned char *) NULL)) 7       PrematureExit("Unable to allocate memory",image);      /*       Uncompress image data.     */     p=pcx_pixels;n     while (pcx_packets > 0)      {t        packet=fgetc(image->file);"       if ((packet & 0xc0) != 0xc0)	         {*           *p++=packet;           pcx_packets--;           continue;o	         }m       count=packet & 0x3f;9       for (packet=fgetc(image->file); count > 0; count--)        {g         *p++=packet;         pcx_packets--;         if (pcx_packets == 0)            break;       }o     }e$     if (image->class == DirectClass))       image->matte=pcx_header.planes > 3;1     else"       if (pcx_header.version == 5)	         {a           /*&             Initialize image colormap.           */K           image->colors=1 << (pcx_header.bits_per_pixel*pcx_header.planes); "           if (image->colors > 256)D             PrematureExit("PCX colormap exceeded 256 colors",image);!           if (image->colors > 16)p
             {                /*M                 256 color images have their color map at the end of the file.                */J               (void) ReadData((char *) &pcx_header.colormap_signature,1,1,                 image->file); D               (void) ReadData((char *) pcx_colormap,3,image->colors,                 image->file);                p=pcx_colormap;e/               for (i=0; i < image->colors; i++)_               {a5                 image->colormap[i].red=UpScale(*p++);_7                 image->colormap[i].green=UpScale(*p++);a6                 image->colormap[i].blue=UpScale(*p++);               }.
             }            elseO             if (Intensity(image->colormap[0]) == Intensity(image->colormap[1]))g%               if (image->colors == 2)                  {p                   /*(                     Monochrome colormap.                   */0                   image->colormap[0].red=MaxRGB;2                   image->colormap[0].green=MaxRGB;1                   image->colormap[0].blue=MaxRGB;a+                   image->colormap[1].red=0; -                   image->colormap[1].green=0;.,                   image->colormap[1].blue=0;                 } &           free((char *) pcx_colormap);	         }p     /*<       Convert PCX raster image to runlength-encoded packets.     */
     red=0;     green=0;     blue=0;      index=0;     q=image->pixels;     q->length=MaxRunlength;-#     for (y=0; y < image->rows; y++)o     { C       p=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes);p       r=scanline; &       if (image->class == DirectClass)3         for (i=0; i < (int) pcx_header.planes; i++) 	         {            r=scanline+i;u7           for (x=0; x < pcx_header.bytes_per_line; x++)g           {m             switch (i)
             {m               case 0:                { !                 *r=UpScale(*p++);                  break;               }(               case 1:r               { !                 *r=UpScale(*p++);e                 break;               }n               case 2:.               {.!                 *r=UpScale(*p++);-                 break;               }e               case 3:                default:               {n!                 *r=UpScale(*p++);                  break;               } 
             }-!             r+=pcx_header.planes;-           })	         } 
       else"         if (pcx_header.planes > 1)           { .             for (x=0; x < image->columns; x++)               *r++=0; 7             for (i=0; i < (int) pcx_header.planes; i++)e
             {u               r=scanline; ;               for (x=0; x < pcx_header.bytes_per_line; x++)m               {                   bits=(*p++); 5                  for (mask=0x80; mask != 0; mask>>=1)                   {#                    if (bits & mask),                       *r|=1 << i;                    r++;g                  }                }
             }            }g         else,           switch (pcx_header.bits_per_pixel)           {              case 1: 
             {n               register int                 bit;  5               for (x=0; x < (image->columns-7); x+=8)                { ,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               } ,               if ((image->columns % 8) != 0)                 { E                   for (bit=7; bit >= (8-(image->columns % 8)); bit--)t>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }e               break;
             }%             case 2:%
             {%5               for (x=0; x < (image->columns-3); x+=4)                { %                 *r++=(*p >> 6) & 0x3; %                 *r++=(*p >> 4) & 0x3; %                 *r++=(*p >> 2) & 0x3;                   *r++=(*p) & 0x3;                 p++;               } ,               if ((image->columns % 4) != 0)                 { ?                   for (i=3; i >= (4-(image->columns % 4)); i--) .                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }                break;
             }              case 4: 
             { 5               for (x=0; x < (image->columns-1); x+=2)%               {%%                 *r++=(*p >> 4) & 0xf;%                  *r++=(*p) & 0xf;                 p++;               }e,               if ((image->columns % 2) != 0)'                 *r++=(*p++ >> 4) & 0xf;                break;
             }g             case 8: 
             {m0               for (x=0; x < image->columns; x++)                 *r++=(*p++);               break;
             }              default:               break;           }h       /*          Transfer image scanline.       */       r=scanline; (       for (x=0; x < image->columns; x++)       {e(         if (image->class == PseudoClass)           index=(*r++);r         else           {f             red=UpScale(*r++);              green=UpScale(*r++);             blue=UpScale(*r++);c             if (image->matte)i               index=(*r++);l           }eJ         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&D             (index == q->index) && ((int) q->length < MaxRunlength))           q->length++;         else           {r$             if (image->packets != 0)               q++;             image->packets++;e*             if (image->packets == packets)               {i                 packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket));n>                 if (image->pixels == (RunlengthPacket *) NULL)                   {-,                     free((char *) scanline);E                     PrematureExit("Unable to allocate memory",image);a                   }r1                 q=image->pixels+image->packets-1;c               }m             q->red=red;n             q->green=green;)             q->blue=blue;)             q->index=index;e             q->length=0;           }a       }n3       ProgressMonitor(LoadImageText,y,image->rows);      }($     if (image->class == PseudoClass)       {r         SyncImage(image);           CompressColormap(image);       }e     free((char *) scanline);     free((char *) pcx_pixels);E     image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, .       image->packets*sizeof(RunlengthPacket));     /*       Proceed to next image.     */-     if (page_table != (unsigned long *) NULL)e       {c          if (page_table[id] == 0)           break;3         (void) fseek(image->file,page_table[id],0);f       }tE     status=ReadData((char *) &pcx_header.identifier,1,1,image->file);o<     if ((status == True) && (pcx_header.identifier == 0x0a))       {(
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {o!             DestroyImages(image); #             return((Image *) NULL);f           }oB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    }m+   if (page_table != (unsigned long *) NULL) %     (void) free((char *) page_table); +   while (image->previous != (Image *) NULL)o     image=image->previous;   CloseImage(image);   return(image); }n s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             %eO %                                                                             %dO %  R e a d P D F I m a g e                                                    %nO %                                                                             %nO %                                                                             %iO %                                                                             %hO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%U %sH %  Function ReadPDFImage reads a Portable Document Format image file andM %  returns it.  It allocates the memory necessary for the new Image structuree* %  and returns a pointer to the new image. % - %  The format of the ReadPDFImage routine is:R %u% %      image=ReadPDFImage(image_info)e %f+ %  A description of each parameter follows:o %eI %    o image:  Function ReadPDFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %lA %    o image_info: Specifies a pointer to an ImageInfo structure.  %( %a */1 static Image *ReadPDFImage(ImageInfo *image_info)  {e #define MediaBox  "/MediaBox ["p     char     command[MaxTextLength],o     *device,     filename[MaxTextLength],     options[MaxTextLength],g'     postscript_filename[MaxTextLength];o     FILE
     *file;     floatC     dx_resolution,     dy_resolution,     lower_x,     lower_y,     upper_x,     upper_y,     x_resolution,I     y_resolution;      Imageg     *image,      *next_image;     intl
     count,     status;X  
   long int
     filesize;X     register char&     *p;i     register int     c,     i;     unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);d#   if (image->file == (FILE *) NULL)b/     PrematureExit("Unable to open file",image);    /*     Open temporary output file.    */)   TemporaryFilename(postscript_filename); &   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);   /*     Set the page geometry.   */   *options='\0';(   if (image_info->page != (char *) NULL)     { #       (void) strcat(options," -g"); .       (void) strcat(options,image_info->page);     }    else     for (p=command; ; )      {        c=fgetc(image->file);=       if (c == EOF)b         break;       (void) fputc(c,file);)
       *p++=c;=J       if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextLength-1)))         continue;;       *p='\0';       p=command;       /*5         Continue unless this is a MediaBox statement.        */:       if (strncmp(MediaBox,command,strlen(MediaBox)) != 0)         continue; G       count=sscanf(command,"/MediaBox [ %f %f %f %f",&lower_x,&lower_y,          &upper_x,&upper_y);l       if (count != 4)          continue;l5       if ((lower_x > upper_x) || (lower_y > upper_y))          continue;i       /*         Determine bounding box.h       */       dx_resolution=72.0;m       dy_resolution=72.0;=       x_resolution=72.0;J       count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL)eN         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2)v"         y_resolution=x_resolution;,       if (image_info->page != (char *) NULL)         continue;        /*'         Set Postscript render geometry.=       */-       width=(unsigned int) (upper_x-lower_x);D-       if ((float) ((int) upper_x) != upper_x)o         width++;.       height=(unsigned int) (upper_y-lower_y);-       if ((float) ((int) upper_y) != upper_y)e         height++;r'       (void) sprintf(options,"-g%ux%u",eB         (unsigned int) (((width*x_resolution)/dx_resolution)+0.5),D         (unsigned int) (((height*y_resolution)/dy_resolution)+0.5));       break;     }h
   for ( ; ; )&   {)     c=fgetc(image->file);e     if (c == EOF)        break;     (void) fputc(c,file);k   }a   if (ferror(file))      {rK       Warning("An error has occurred writing to file",postscript_filename);_       (void) fclose(file);       return((Image *) NULL);s     }l   (void) fclose(file);   CloseImage(image);   filesize=image->filesize;=   DestroyImage(image);   /*2     Determine if the density options is specified.   */   (void) strcat(options," -r");s+   if (image_info->density == (char *) NULL)>-     (void) strcat(options,PSDensityGeometry);>   else/     (void) strcat(options,image_info->density);;    if (image_info->subimage != 0)     { O       (void) sprintf(options,"%s -dFirstPage=%u",options,image_info->subimage); M       (void) sprintf(options,"%s -dLastPage=%u",options,image_info->subimage+c          image_info->subrange-1);     }e   /*0     Use Ghostscript to convert Postscript image.   */   device=PostscriptColorDevice;    if (image_info->monochrome)e      device=PostscriptMonoDevice;/   (void) strcpy(filename,image_info->filename);    for (i=0; i < 50; i++)   {-     /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   } O   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,t     postscript_filename);     status=SystemCommand(command);
   if (status)      {        /*7         Pre GS 3.51 does not support the pnmraw device.p       */@       (void) sprintf(command,PostscriptCommand,"ppmraw",options,2         image_info->filename,postscript_filename);$       status=SystemCommand(command);     }D
   if (status)*     {/K       Warning("Portable Document translation failed",image_info->filename); )       (void) remove(postscript_filename);o       return((Image *) NULL);      } !   image=ReadPNMImage(image_info);e%   (void) remove(postscript_filename); &   (void) remove(image_info->filename);   if (image == (Image *) NULL)     { K       Warning("Portable Document translation failed",image_info->filename);)       return((Image *) NULL);=     }P   do   {L,     (void) strcpy(image->filename,filename);     image->filesize=filesize;s     next_image=image->next;p%     if (next_image != (Image *) NULL)s       image=next_image;,)   } while (next_image != (Image *) NULL);u+   while (image->previous != (Image *) NULL)L     image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %eO %                                                                             %DO %                                                                             %CO %  R e a d P I C T I m a g e                                                  % O %                                                                             %oO %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %eL %  Function ReadPICTImage reads an Apple Macintosh QuickDraw/PICT image fileG %  and returns it.  It allocates the memory necessary for the new ImageP4 %  structure and returns a pointer to the new image. %t. %  The format of the ReadPICTImage routine is: % & %      image=ReadPICTImage(image_info) %a+ %  A description of each parameter follows:I %eJ %    o image:  Function ReadPICTImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadPICTImage(ImageInfo *image_info) {a   char     filename[MaxTextLength];     ImageG     *image,a     *next_image,     *proxy_image;      /*     Allocate image structure.a   */(   proxy_image=AllocateImage(image_info);$   if (proxy_image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   OpenImage(image_info,proxy_image,ReadBinaryType);m)   if (proxy_image->file == (FILE *) NULL)m5     PrematureExit("Unable to open file",proxy_image);c   CloseImage(proxy_image);   DestroyImage(proxy_image);   /*2     Use picttoppm to convert Macintosh PICT image.   *//   (void) strcpy(filename,image_info->filename); <   (void) sprintf(image_info->filename,PICTCommand,filename);!   image=ReadPNMImage(image_info);    if (image == (Image *) NULL)     {u>       Warning("PICT translation failed",image_info->filename);       return((Image *) NULL);u     }U   /*     Assign proper filename.U   */   do   {m,     (void) strcpy(image->filename,filename);     next_image=image->next;a%     if (next_image != (Image *) NULL)        image=next_image;e)   } while (next_image != (Image *) NULL);e+   while (image->previous != (Image *) NULL)%     image=image->previous;   return(image); }% %
 #ifdef HasPNG% #include "png.h" /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %FO %                                                                             % O %  R e a d P N G I m a g e                                                    % O %                                                                             % O %                                                                             %%O %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %eI %  Function ReadPNGImage reads a Portable Network Graphics image file and M %  returns it.  It allocates the memory necessary for the new Image structurei* %  and returns a pointer to the new image. %p- %  The format of the ReadPNGImage routine is:a % % %      image=ReadPNGImage(image_info)r % + %  A description of each parameter follows:g %sI %    o image:  Function ReadPNGImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.a %IA %    o image_info: Specifies a pointer to an ImageInfo structure.t %  %t */1 static Image *ReadPNGImage(ImageInfo *image_info)  {g   Imagee     *image;n     register int     i,     x,     y;     register unsigned char     *p;p     register RunlengthPacket     *q;_  
   png_info     *ping_info;      png_struct
     *ping;     unsigned charr     *png_pixels,     **scanlines;     unsigned int     bytes_per_line,      packets;     unsigned short
     index,
     value;     /*     Allocate image structure.e   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);>   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);a#   if (image->file == (FILE *) NULL)o/     PrematureExit("Unable to open file",image);a   /*     Allocate the PNG structuresp   */1   ping=(png_struct *) malloc(sizeof(png_struct));a2   ping_info=(png_info *) malloc(sizeof(png_info));H   if ((ping == (png_struct *) NULL) || (ping_info == (png_info *) NULL))5     PrematureExit("Unable to allocate memory",image);l)   image->pixels=(RunlengthPacket *) NULL;n$   png_pixels=(unsigned char *) NULL;$   scanlines=(unsigned char **) NULL;   if (setjmp(ping->jmpbuf))m     {i       /*         PNG image is corrupt.        */9       png_read_destroy(ping,ping_info,(png_info *) NULL);%/       if (scanlines != (unsigned char **) NULL)%!         free((char *) scanlines); /       if (png_pixels != (unsigned char *) NULL) "         free((char *) png_pixels);       free((char *) ping);       free((char *) ping_info);        CloseImage(image);6       if ((image->columns == 0) || (image->rows == 0))	         {            DestroyImage(image);!           return((Image *) NULL); 	         }        return(image);     }    /*     Prepare PNG for reading.   */   png_info_init(ping_info);    png_read_init(ping);    png_init_io(ping,image->file);    png_read_info(ping,ping_info);*   if (ping_info->bit_depth > QuantumDepth)     {%       png_set_strip_16(ping);%       ping_info->bit_depth=8;      }F    if (ping_info->bit_depth < 16)     image->depth=8;n   /*     Initialize image structure.e   */"   image->columns=ping_info->width;    image->rows=ping_info->height;   image->packets=0; 5   packets=Max((image->columns*image->rows+4) >> 3,1);F    if (ping_info->bit_depth == 1)7     packets=Max((image->columns*image->rows+8) >> 4,1);uL   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   bytes_per_line=rN     Max((int) ping_info->bit_depth >> 3,1)*ping_info->channels*image->columns;   png_pixels=(unsigned char *)7     malloc(bytes_per_line*image->rows*sizeof(Quantum));eK   scanlines=(unsigned char **) malloc(image->rows*sizeof(unsigned char *)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (png_pixels == (unsigned char *) NULL) ||_-       (scanlines == (unsigned char **) NULL))t5     PrematureExit("Unable to allocate memory",image); :   if ((ping_info->color_type == PNG_COLOR_TYPE_PALETTE) ||5       (ping_info->color_type == PNG_COLOR_TYPE_GRAY))      {        /*"         Initialize image colormap.       */       image->class=PseudoClass; .       image->colors=1 << ping_info->bit_depth;:       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE)-         image->colors=ping_info->num_palette;gP       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); :       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE))         for (i=0; i < image->colors; i++) 	         {nD           image->colormap[i].red=UpScale(ping_info->palette[i].red);H           image->colormap[i].green=UpScale(ping_info->palette[i].green);F           image->colormap[i].blue=UpScale(ping_info->palette[i].blue);	         } 
       else)         for (i=0; i < image->colors; i++)=	         {h>           image->colormap[i].red=(MaxRGB*i)/(image->colors-1);@           image->colormap[i].green=(MaxRGB*i)/(image->colors-1);?           image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);g	         }f     }    /*     Read image scanlines.    */"   if (image->class == DirectClass)!     if (ping_info->bit_depth < 8)        png_set_packing(ping);!   for (i=0; i < image->rows; i++)m/     scanlines[i]=png_pixels+(bytes_per_line*i);e!   png_read_image(ping,scanlines);    png_read_end(ping,ping_info);    /*4     Convert PNG pixels to runlength-encoded packets.   */   q=image->pixels;   q->length=MaxRunlength;p"   if (image->class == DirectClass)     { 
       Quantum 
         blue,t         green,         red;         /*?         Convert image to DirectClass runlength-encoded packets.        */@       if ((ping_info->color_type == PNG_COLOR_TYPE_RGB_ALPHA) ||?           (ping_info->color_type == PNG_COLOR_TYPE_GRAY_ALPHA))          image->matte=True;%       for (y=0; y < image->rows; y++)        {m         p=scanlines[y];o*         for (x=0; x < image->columns; x++)	         {)           ReadQuantum(red,p);            green=red;           blue=red;=A           if (ping_info->color_type != PNG_COLOR_TYPE_GRAY_ALPHA)l
             {e#               ReadQuantum(green,p); "               ReadQuantum(blue,p);
             };           index=0;           if (image->matte) !             ReadQuantum(index,p); L           if ((red == q->red) && (green == q->green) && (blue == q->blue) &&F               (index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {p&               if (image->packets != 0)                 q++;               image->packets++;a,               if (image->packets == packets)                 {p                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)                     {s0                       free((char *) png_pixels);G                       PrematureExit("Unable to allocate memory",image);                      }A3                   q=image->pixels+image->packets-1;a                 }(               q->red=red;0               q->green=green;a               q->blue=blue;c               q->index=index;                q->length=0;
             } 	         }l5         ProgressMonitor(LoadImageText,y,image->rows);        }+     }    else     {l
       Quantum)         *quantum_scanline;         register Quantum         *r;e         /*?         Convert image to PseudoClass runlength-encoded packets..       */J       quantum_scanline=(Quantum *) malloc(image->columns*sizeof(Quantum));/       if (quantum_scanline == (Quantum *) NULL)d9         PrematureExit("Unable to allocate memory",image);e%       for (y=0; y < image->rows; y++)        {n         p=scanlines[y];m         r=quantum_scanline;m%         switch (ping_info->bit_depth) 	         {a           case 1:            {=             register int               bit;  9             for (x=0; x < ((int) image->columns-7); x+=8)r
             {c*               for (bit=7; bit >= 0; bit--):                 *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);               p++;
             }n*             if ((image->columns % 8) != 0)               {aC                 for (bit=7; bit >= (8-(image->columns % 8)); bit--)*<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               }l             break;           }c           case 2:e           {a9             for (x=0; x < ((int) image->columns-3); x+=4)f
             { #               *r++=(*p >> 6) & 0x3; #               *r++=(*p >> 4) & 0x3; #               *r++=(*p >> 2) & 0x3;e               *r++=(*p) & 0x3;               p++;
             }U*             if ((image->columns % 4) != 0)               {r=                 for (i=3; i >= (4-(image->columns % 4)); i--)v,                   *r++=(*p >> (i*2)) & 0x03;                 p++;               }_             break;           },           case 4:s           {;9             for (x=0; x < ((int) image->columns-1); x+=2)a
             {g#               *r++=(*p >> 4) & 0xf;n               *r++=(*p) & 0xf;               p++;
             } *             if ((image->columns % 2) != 0)%               *r++=(*p++ >> 4) & 0xf;              break;           }j           case 8:e           { .             for (x=0; x < image->columns; x++)               *r++=(*p++);             break;           }=           case 16:           {(.             for (x=0; x < image->columns; x++)
             {e                ReadQuantum(*r,p);               r++;
             }e             break;           }            default:             break;	         } 
         /*"           Transfer image scanline.
         */         r=quantum_scanline;a*         for (x=0; x < image->columns; x++)	         {            index=(*r++);iF           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {r&               if (image->packets != 0)                 q++;               image->packets++;_,               if (image->packets == packets)                 {                    packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));s@                   if (image->pixels == (RunlengthPacket *) NULL)                     { 6                       free((char *) quantum_scanline);G                       PrematureExit("Unable to allocate memory",image);                      } 3                   q=image->pixels+image->packets-1;u                 }(               q->index=index;a               q->length=0;
             }l	         } 5         ProgressMonitor(LoadImageText,y,image->rows);c       }l&       if (image->class == PseudoClass)         SyncImage(image);a&       free((char *) quantum_scanline);+       if (ping_info->valid & PNG_INFO_tRNS) 	         {s           /*/             Image has a transparent background.            */#           image->class=DirectClass;-           image->matte=True;           q=image->pixels;,           for (i=0; i < image->packets; i++)           {)             index=q->index;o             q->index=Opaque;@             if (ping_info->color_type != PNG_COLOR_TYPE_PALETTE)               {%:                 if (index == ping_info->trans_values.gray)'                   q->index=Transparent;                }              else/               if (index < ping_info->num_trans) 1                 q->index=ping_info->trans[index];              q++;           } 	         } &       if (image->class == PseudoClass)          CompressColormap(image);     } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); '   if (ping_info->valid & PNG_INFO_gAMA) "     image->gamma=ping_info->gamma;   if (ping_info->num_text > 0)     {        unsigned int         length;          /*!         Initialize image comment.%       */       length=1;%-       for (i=0; i < ping_info->num_text; i++)aP         length+=strlen(ping_info->text[i].key)+ping_info->text[i].text_length+4;.       image->comments=(char *) malloc(length);+       if (image->comments == (char *) NULL)a9         PrematureExit("Unable to allocate memory",image);F       *image->comments='\0';-       for (i=0; i < ping_info->num_text; i++)        { D         p=(unsigned char *) image->comments+strlen(image->comments);?         (void) strncat(image->comments,ping_info->text[i].text, *           ping_info->text[i].text_length);*         p+=ping_info->text[i].text_length;(         if (i < (ping_info->num_text-1))           *p++='\n';         *p='\0';       }i     }t   /*     Free memory.   */5   png_read_destroy(ping,ping_info,(png_info *) NULL);    free((char *) png_pixels);   free((char *) ping);   free((char *) ping_info);    CloseImage(image);   return(image); }R #elseh1 static Image *ReadPNGImage(ImageInfo *image_info)p { ?   Warning("PNG library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }  #endif x /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %nO %                                                                             %eO %  R e a d P N M I m a g e                                                    %lO %                                                                             %tO %                                                                             %cO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %bK %  Function ReadPNMImage reads a Portable Anymap image file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %(- %  The format of the ReadPNMImage routine is:l %*% %      image=ReadPNMImage(image_info)m %-+ %  A description of each parameter follows:x %)I %    o image:  Function ReadPNMImage returns a pointer to the image aftercL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.i %dA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %m */  > static unsigned int PNMInteger(Image *image,unsigned int base) {D #define MaxRawValue  255     inta     c;     unsigned int
     value;     /*      Skip any leading whitespace.   */   do   {      c=fgetc(image->file);a     if (c == EOF),       return(0);     if (c == '#')a       {          register char'
           *p;a           unsigned int           length;   
         /*           Read comment.s
         */-         if (image->comments != (char *) NULL),           {l+             length=strlen(image->comments); %             p=image->comments+length;            };         else           { !             length=MaxTextLength; A             image->comments=(char *) malloc(length*sizeof(char));.             p=image->comments;           }B6         for ( ; image->comments != (char *) NULL; p++)	         {[.           if ((p-image->comments+2) >= length)
             {)               *p='\0';               length<<=1; &               image->comments=(char *)F                 realloc((char *) image->comments,length*sizeof(char));3               if (image->comments == (char *) NULL)                  break;8               p=image->comments+strlen(image->comments);
             }r           c=fgetc(image->file); (           if ((c == EOF) || (c == '\n'))             break;           *p=(unsigned char) c;U	         } -         if (image->comments == (char *) NULL)r           {m=             Warning("Memory allocation error",(char *) NULL);z             return(0);           }          *p++='\n';         *p='\0';       }t   } while (!isdigit(c));   if (base == 2)     return(c-'0');   /*     Evaluate number.   */
   value=0;   do   {      value*=10;     value+=c-'0';      c=fgetc(image->file);(     if (c == EOF)(       return(0);   }    while (isdigit(c));U   return(value); }o  1 static Image *ReadPNMImage(ImageInfo *image_info)  {    char     format;m     Imaget     *image;a     int      y;  	   Quantum 	     blue, 
     green,     red,     *scale;      register int     i,     x;     register RunlengthPacket     *q;      unsigned int     max_value,     packets,     status;      unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);m   /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read PNM image.-   */4   status=ReadData((char *) &format,1,1,image->file);   do   {-     /*       Verify PNM identifier.     */-     if ((status == False) || (format != 'P')) 2       PrematureExit("Not a PNM image file",image);     /*!       Initialize image structure.      */     format=fgetc(image->file);     if (format == '7')"       (void) PNMInteger(image,10);(     image->columns=PNMInteger(image,10);%     image->rows=PNMInteger(image,10);-*     if ((image->columns*image->rows) == 0)M       PrematureExit("Unable to read image: image dimensions are zero",image);      image->packets=0;z7     packets=Max((image->columns*image->rows+4) >> 3,1); +     if ((format == '1') || (format == '4'))N9       packets=Max((image->columns*image->rows+8) >> 4,1);lN     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);*+     if ((format == '1') || (format == '4'))n        max_value=1;  /* bitmap */     else%       max_value=PNMInteger(image,10);=     scale=(Quantum *) NULL;t+     if ((format != '3') && (format != '6'))        {)
         /*           Create colormap.
         */!         image->class=PseudoClass;e.         image->colors=Min(max_value,MaxRGB)+1;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);=         if (format != '7')+           for (i=0; i < image->colors; i++)-           {(@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);;           }          else           {+             /*&               Initialize 332 colormap.             */             i=0;'             for (red=0; red < 8; red++)g/               for (green=0; green < 8; green++) .                 for (blue=0; blue < 4; blue++)                 {rB                   image->colormap[i].red=(Quantum) (red*MaxRGB)/7;F                   image->colormap[i].green=(Quantum) (green*MaxRGB)/7;D                   image->colormap[i].blue=(Quantum) (blue*MaxRGB)/3;                   i++;                 }e           }        }      if (max_value != MaxRGB)       {g
         /*&           Compute pixel scaling table.
         */@         scale=(Quantum *) malloc((max_value+1)*sizeof(Quantum));&         if (scale == (Quantum *) NULL);           PrematureExit("Unable to allocate memory",image);[&         for (i=0; i <= max_value; i++)E           scale[i]=(Quantum) ((i*MaxRGB+(max_value >> 1))/max_value);        }      /*;       Convert PNM pixels to runlength-encoded MIFF packets.      */     q=image->pixels;     q->length=MaxRunlength;      switch (format)      {        case '1':h       { 
         /*9           Convert PBM image to runlength-encoded packets.8
         */'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           {g'             index=!PNMInteger(image,2); H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {f(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));)B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;                    }                  q->index=index;                  q->length=0;               }            } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }x         break;       }        case '2':        { 
         /*9           Convert PGM image to runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         {x,           for (x=0; x < image->columns; x++)           {r'             index=PNMInteger(image,10);r*             if (scale != (Quantum *) NULL)!               index=scale[index]; H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {u(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));gB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);m5                     q=image->pixels+image->packets-1;e                   }i                 q->index=index;e                 q->length=0;               }r           }n7           ProgressMonitor(LoadImageText,y,image->rows); 	         }p         break;       }        case '3':m       {(
         /*9           Convert PNM image to runlength-encoded packets.v
         */'         for (y=0; y < image->rows; y++) 	         {e,           for (x=0; x < image->columns; x++)           {%%             red=PNMInteger(image,10);%'             green=PNMInteger(image,10); &             blue=PNMInteger(image,10);*             if (scale != (Quantum *) NULL)               {                  red=scale[red]; #                 green=scale[green]; !                 blue=scale[blue];                } N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))                q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {%                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));aB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);i5                     q=image->pixels+image->packets-1;o                   }e                 q->red=red;u                 q->green=green;                  q->blue=blue;s                 q->index=0;o                 q->length=0;
             }            } 7           ProgressMonitor(LoadImageText,y,image->rows);c	         } !         if (IsPseudoClass(image))(>           QuantizeImage(image,MaxRGB+1,8,False,RGBColorspace);         break;       }r       case '4':        {R         unsigned char            bit,           byte;            unsigned int           x,           y;  
         /*=           Convert PBM raw image to runlength-encoded packets.g
         */'         for (y=0; y < image->rows; y++)(	         {L           bit=0;           byte=0;/,           for (x=0; x < image->columns; x++)           {g             if (bit == 0) &               byte=fgetc(image->file);(             index=(byte & 0x80) ? 0 : 1;H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {((                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {g                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);t5                     q=image->pixels+image->packets-1;c                   }                  q->index=index;                  q->length=0;               }e             bit++;             if (bit == 8)a               bit=0;             byte<<=1;-           }e7           ProgressMonitor(LoadImageText,y,image->rows); 	         }p         break;       }        case '5':m       case '7':        {t
         /*=           Convert PGM raw image to runlength-encoded packets.k
         */'         for (y=0; y < image->rows; y++)g	         { ,           for (x=0; x < image->columns; x++)           {-)             if (max_value <= MaxRawValue)l'               index=fgetc(image->file);              else3               index=LSBFirstReadShort(image->file); H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {)                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));sB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);w5                     q=image->pixels+image->packets-1;e                   }>                 q->index=index;e                 q->length=0;               }s           }e7           ProgressMonitor(LoadImageText,y,image->rows);%	         }%         break;       }%       case '6':%       {%
         /*@           Convert PNM raster image to runlength-encoded packets.
         */'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { )             if (max_value <= MaxRawValue)                {e'                 red=fgetc(image->file); )                 green=fgetc(image->file); (                 blue=fgetc(image->file);               }              else               { 3                 red=LSBFirstReadShort(image->file); 5                 green=LSBFirstReadShort(image->file); 4                 blue=LSBFirstReadShort(image->file);               }%*             if (scale != (Quantum *) NULL)               {D                 red=scale[red];F#                 green=scale[green]; !                 blue=scale[blue];o               }tN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))m               q->length++;             else               {s(                 if (image->packets != 0)                   q++;!                 image->packets++;A.                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 7                       q=image->pixels+image->packets-1;e                   }                  q->red=red;h                 q->green=green;g                 q->blue=blue;                  q->index=0;c                 q->length=0;               }l           }k7           ProgressMonitor(LoadImageText,y,image->rows); 	         }a!         if (IsPseudoClass(image))=>           QuantizeImage(image,MaxRGB+1,8,False,RGBColorspace);         break;       }m       default:4         PrematureExit("Not a PNM image file",image);     } "     if (scale != (Quantum *) NULL)       free((char *) scale);a$     if (image->class == PseudoClass)       {=         SyncImage(image);g          CompressColormap(image);       }r%     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));,     /*       Proceed to next image.     */>     if ((format == '1') || (format == '2') || (format == '3'))       do       { 
         /*           Skip to end of line.
         */1         status=ReadData(&format,1,1,image->file);          if (status == False)           break;       } while (format != '\n');a6     status=ReadData((char *) &format,1,1,image->file);,     if ((status == True) && (format == 'P'))       { 
         /*#           Allocate image structure.e
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {h!             DestroyImages(image);)#             return((Image *) NULL);e           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } 0   } while ((status == True) && (format == 'P'));+   while (image->previous != (Image *) NULL)m     image=image->previous;   CloseImage(image);   return(image); }a c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%UO %                                                                             %rO %                                                                             %lO %                                                                             % O %  R e a d P S I m a g e                                                      %eO %                                                                             % O %                                                                             % O %                                                                             %UO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadPSImage reads a Adobe Postscript image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns ag %  pointer to the new image. % , %  The format of the ReadPSImage routine is: %)$ %      image=ReadPSImage(image_info) %d+ %  A description of each parameter follows:  % H %    o image:  Function ReadPSImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %y */0 static Image *ReadPSImage(ImageInfo *image_info) {n% #define BoundingBox  "%%BoundingBox:" ) #define DocumentMedia  "%%DocumentMedia:" - #define PageBoundingBox  "%%PageBoundingBox:"      char     command[MaxTextLength],f     *device,     filename[MaxTextLength],     options[MaxTextLength], '     postscript_filename[MaxTextLength],=&     translate_geometry[MaxTextLength];     FILE
     *file;     float(     dx_resolution,     dy_resolution,     lower_x,     lower_y,     upper_x,     upper_y,     x_resolution,*     y_resolution;i     Image      *image,R     *next_image;     int      c,
     count,     status;   
   long int
     filesize;w     register char      *p;      register int     i;     unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)m/     PrematureExit("Unable to open file",image);    /*     Open temporary output file.a   */)   TemporaryFilename(postscript_filename); &   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);O   (void) sprintf(translate_geometry,"%f %f translate\n              ",0.0,0.0);o(   (void) fputs(translate_geometry,file);   /*     Set the page geometry.   */   lower_x=0;   lower_y=0;   *options='\0';(   if (image_info->page != (char *) NULL)     { #       (void) strcat(options," -g");p.       (void) strcat(options,image_info->page);     }m   else     for (p=command; ; )      {        c=fgetc(image->file);*       if (c == EOF)          break;       (void) fputc(c,file);g
       *p++=c;gJ       if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextLength-1)))         continue;        *p='\0';       p=command;       /*'         Parse a bounding box statement.e       */       count=0;@       if (strncmp(BoundingBox,command,strlen(BoundingBox)) == 0)N         count=sscanf(command,"%%%%BoundingBox: %f %f %f %f",&lower_x,&lower_y,           &upper_x,&upper_y);.D       if (strncmp(DocumentMedia,command,strlen(DocumentMedia)) == 0)         count=M           sscanf(command,"%%%%DocumentMedia: %*s %f %f",&upper_x,&upper_y)+2; H       if (strncmp(PageBoundingBox,command,strlen(PageBoundingBox)) == 0)@         count=sscanf(command,"%%%%PageBoundingBox: %f %f %f %f",/           &lower_x,&lower_y,&upper_x,&upper_y);0       if (count != 4)g         continue; 5       if ((lower_x > upper_x) || (lower_y > upper_y))          continue;e       /*         Determine bounding box.        */       dx_resolution=72.0;o       dy_resolution=72.0;        x_resolution=72.0;J       count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL) N         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2) "         y_resolution=x_resolution;       /*'         Set Postscript render geometry.        */O       (void) sprintf(translate_geometry,"%f %f translate\n",-lower_x,-lower_y); -       width=(unsigned int) (upper_x-lower_x);l-       if ((float) ((int) upper_x) != upper_x)          width++;.       height=(unsigned int) (upper_y-lower_y);-       if ((float) ((int) upper_y) != upper_y)h         height++;e'       (void) sprintf(options,"-g%ux%u",_B         (unsigned int) (((width*x_resolution)/dx_resolution)+0.5),D         (unsigned int) (((height*y_resolution)/dy_resolution)+0.5));       break;     }m
   for ( ; ; )m   {(     c=fgetc(image->file);      if (c == EOF)e       break;     (void) fputc(c,file);d   }m   if (ferror(file))I     {eK       Warning("An error has occurred writing to file",postscript_filename);i       (void) fclose(file);       return((Image *) NULL);      }t   (void) fseek(file,0,0);a(   (void) fputs(translate_geometry,file);   (void) fclose(file);   CloseImage(image);   filesize=image->filesize;i   DestroyImage(image);   /*.     Determine if density options is specified.   */   (void) strcat(options," -r");l+   if (image_info->density == (char *) NULL) -     (void) strcat(options,PSDensityGeometry);    else/     (void) strcat(options,image_info->density);    /*0     Use Ghostscript to convert Postscript image.   */   device=PostscriptColorDevice;s   if (image_info->monochrome)g      device=PostscriptMonoDevice;/   (void) strcpy(filename,image_info->filename);e   for (i=0; i < 50; i++)   {g     /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   }eO   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,(     postscript_filename);l    status=SystemCommand(command);
   if (status)e     {i       /*7         Pre GS 3.51 does not support the pnmraw device.%       */@       (void) sprintf(command,PostscriptCommand,"ppmraw",options,2         image_info->filename,postscript_filename);$       status=SystemCommand(command);     } *   if (!IsAccessible(image_info->filename))     {        /*1         Ghostscript requires a showpage operator.        */*       file=fopen(postscript_filename,"a");        if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);&       (void) fputs("showpage\n",file);       (void) fclose(file);$       status=SystemCommand(command);     } %   (void) remove(postscript_filename); 
   if (status)      {        /*F         Ghostscript has failed-- try the Display Postscript Extension.       */3       (void) strcpy(image_info->filename,filename);a%       image=ReadDPSImage(image_info);t"       if (image != (Image *) NULL)         return(image);D       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);      }a!   image=ReadPNMImage(image_info); &   (void) remove(image_info->filename);   if (image == (Image *) NULL)     {eD       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);t     }    do   {s,     (void) strcpy(image->filename,filename);     image->filesize=filesize;i     next_image=image->next;o%     if (next_image != (Image *) NULL)*       image=next_image;n)   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)u     image=image->previous;   return(image); }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d R A D I A N C E I m a g e                                          % O %                                                                             % O %                                                                             % O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d % I %  Function ReadRADIANCEImage reads a RADIANCE image file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %i2 %  The format of the ReadRADIANCEImage routine is: % * %      image=ReadRADIANCEImage(image_info) % + %  A description of each parameter follows:n % N %    o image:  Function ReadRADIANCEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.a %nA %    o image_info: Specifies a pointer to an ImageInfo structure.i %e %f */6 static Image *ReadRADIANCEImage(ImageInfo *image_info) {m   char     command[MaxTextLength],=     filename[MaxTextLength];     Imagee     *image,i     *next_image;     intg     status;%     /*     Allocate image structure.%   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);   /*)     Use ra_ppm to convert RADIANCE image.    *//   (void) strcpy(filename,image_info->filename); *   TemporaryFilename(image_info->filename);G   (void) sprintf(command,"ra_ppm %s %s",filename,image_info->filename);     status=SystemCommand(command);
   if (status) 7     PrematureExit("RADIANCE translation failed",image);%   DestroyImage(image);!   image=ReadPNMImage(image_info);%&   (void) remove(image_info->filename);   if (image == (Image *) NULL)7     PrematureExit("RADIANCE translation failed",image);m   /*     Assign proper filename.i   */   do   {m,     (void) strcpy(image->filename,filename);     next_image=image->next;R%     if (next_image != (Image *) NULL)r       image=next_image;f)   } while (next_image != (Image *) NULL);B+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }e   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SO %                                                                             %GO %                                                                             %iO %                                                                             %gO %  R e a d R G B I m a g e                                                    %hO %                                                                             %;O %                                                                             % O %                                                                             %uO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eM %  Function ReadRGBImage reads an image of raw red, green, and blue bytes andoM %  returns it.  It allocates the memory necessary for the new Image structurei* %  and returns a pointer to the new image. %e- %  The format of the ReadRGBImage routine is:  %/% %      image=ReadRGBImage(image_info)  %(+ %  A description of each parameter follows:) %aI %    o image:  Function ReadRGBImage returns a pointer to the image afteriL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.) % A %    o image_info: Specifies a pointer to an ImageInfo structure.e %z %m */1 static Image *ReadRGBImage(ImageInfo *image_info)= {f   Image      *image;      inte     x,     y;     register int     i;     register RunlengthPacket     *q;t     register unsigned char     *p;u     unsigned chart     *rgb_pixels;     unsigned int     height,t     packet_size,
     width;     unsigned short
     value;     /*     Allocate image structure.l   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);h#   if (image->file == (FILE *) NULL)n/     PrematureExit("Unable to open file",image);c   /*-     Determine width and height, e.g. 640x512.e   */   width=512;
   height=512;l   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);s   for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Initialize image structure.    */   packet_size=3;-   if (strcmp(image_info->magick,"RGBA") == 0)l     {]       image->matte=True;       packet_size=4;     }r   image->columns=width;g   image->rows=height;x,   image->packets=image->columns*image->rows;   rgb_pixels=(unsigned char *)=     malloc(packet_size*image->packets*sizeof(unsigned char));a#   image->pixels=(RunlengthPacket *);3     malloc(image->packets*sizeof(RunlengthPacket));r/   if ((rgb_pixels == (unsigned char *) NULL) ||m2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */D   (void) ReadData((char *) rgb_pixels,3,image->packets,image->file);   p=rgb_pixels;     switch (image_info->interlace)   {      case NoneInterlace:c     default:     {        /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       q=image->pixels;%       for (y=0; y < image->rows; y++)        {k*         for (x=0; x < image->columns; x++)	         {-            ReadQuantum(q->red,p);"           ReadQuantum(q->green,p);!           ReadQuantum(q->blue,p);            q->index=0;r           if (image->matte)o             q->index=(*p++);           q->length=0;           q++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }=       break;     }      case LineInterlace:      {f       /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...m       */%       for (y=0; y < image->rows; y++)        {g)         q=image->pixels+y*image->columns;t*         for (x=0; x < image->columns; x++)	         {*            ReadQuantum(q->red,p);           q->index=0;n           q->length=0;           q++;	         }m)         q=image->pixels+y*image->columns;i*         for (x=0; x < image->columns; x++)	         {n"           ReadQuantum(q->green,p);           q++;	         }i)         q=image->pixels+y*image->columns;i*         for (x=0; x < image->columns; x++)	         {c!           ReadQuantum(q->blue,p);*           q++;	         }%)         q=image->pixels+y*image->columns;%         if (image->matte) ,           for (x=0; x < image->columns; x++)           { $             ReadQuantum(q->index,p);             q++;           } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        break;     }      case PlaneInterlace:     {m       /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...        */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          ReadQuantum(q->red,p);         q->index=0;          q->length=0;         q++;       } -       ProgressMonitor(LoadImageText,100,400);        q=image->pixels;(       for (i=0; i < image->packets; i++)       {%          ReadQuantum(q->green,p);         q++;       }e-       ProgressMonitor(LoadImageText,200,400);m       q=image->pixels;(       for (i=0; i < image->packets; i++)       {n         ReadQuantum(q->blue,p);t         q++;       }e-       ProgressMonitor(LoadImageText,300,400);)       q=image->pixels;       if (image->matte) *         for (i=0; i < image->packets; i++)	         {o"           ReadQuantum(q->index,p);           q++;	         }r-       ProgressMonitor(LoadImageText,400,400);i       break;     }    }    free((char *) rgb_pixels);   CompressImage(image);i   CloseImage(image);   return(image); }e n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %pO %                                                                             %eO %                                                                             % O %  R e a d R L A I m a g e                                                    % O %                                                                             %aO %                                                                             %mO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %=L %  Function ReadRLAImage reads a run-length encoded Wavefront RLA image fileG %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % O %  Note:  This module was contributed by Lester Vecsey (master@internexus.net).  %*- %  The format of the ReadRLAImage routine is:+ %l% %      image=ReadRLAImage(image_info)  %0+ %  A description of each parameter follows:' %;I %    o image:  Function ReadRLAImage returns a pointer to the image aftertL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.j %_A %    o image_info: Specifies a pointer to an ImageInfo structure.  %( %e */1 static Image *ReadRLAImage(ImageInfo *image_info)0 {|   typedef struct _WindowFrame)   { 	     short(       left,a       right,
       bottom,p
       top;   } WindowFrame;     typedef struct _RLAHeaderr   {c     WindowFrame 
       window,(       active_window;  	     short        frame,       storage_type,n       number_channels,       number_matte_channels,        number_auxillary_channels,       revision;d       char       gamma[16],       red_primary[24],       green_primary[24],       blue_primary[24],        white_point[24];       long       job_number;        char       name[128],       description[128],A       program[64],       machine[32],       user[32],        date[20],o       aspect[24],        aspect_ratio[8],       chan[32];   	     short        field;       char       time[12],n       filter[32];;  	     short        bits_per_channel,        matte_type,o       matte_bits,o       auxillary_type,g       auxillary_bits;(       char       auxillary[32],       space[36];       long       next;a   } RLAHeader;     Image(     *image;=     int      length,r     runlength,     y;     long     *scanlines;      register int     i;     register RunlengthPacket     *q;r     RLAHeader;     rla_header;-     unsigned chare	     byte;p     unsigned int     channel;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);G   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)l/     PrematureExit("Unable to open file",image);o8   rla_header.window.left=MSBFirstReadShort(image->file);9   rla_header.window.right=MSBFirstReadShort(image->file);f:   rla_header.window.bottom=MSBFirstReadShort(image->file);7   rla_header.window.top=MSBFirstReadShort(image->file); ?   rla_header.active_window.left=MSBFirstReadShort(image->file);e@   rla_header.active_window.right=MSBFirstReadShort(image->file);A   rla_header.active_window.bottom=MSBFirstReadShort(image->file); >   rla_header.active_window.top=MSBFirstReadShort(image->file);2   rla_header.frame=MSBFirstReadShort(image->file);9   rla_header.storage_type=MSBFirstReadShort(image->file);m<   rla_header.number_channels=MSBFirstReadShort(image->file);&   if (rla_header.number_channels == 0)!     rla_header.number_channels=3;eB   rla_header.number_matte_channels=MSBFirstReadShort(image->file);F   rla_header.number_auxillary_channels=MSBFirstReadShort(image->file);5   rla_header.revision=MSBFirstReadShort(image->file); ?   (void) ReadData((char *) &rla_header.gamma,16,1,image->file); E   (void) ReadData((char *) &rla_header.red_primary,24,1,image->file);gG   (void) ReadData((char *) &rla_header.green_primary,24,1,image->file);iF   (void) ReadData((char *) &rla_header.blue_primary,24,1,image->file);E   (void) ReadData((char *) &rla_header.white_point,24,1,image->file);d6   rla_header.job_number=MSBFirstReadLong(image->file);?   (void) ReadData((char *) &rla_header.name,128,1,image->file);;F   (void) ReadData((char *) &rla_header.description,128,1,image->file);A   (void) ReadData((char *) &rla_header.program,64,1,image->file);uA   (void) ReadData((char *) &rla_header.machine,32,1,image->file);o>   (void) ReadData((char *) &rla_header.user,32,1,image->file);>   (void) ReadData((char *) &rla_header.date,20,1,image->file);@   (void) ReadData((char *) &rla_header.aspect,24,1,image->file);E   (void) ReadData((char *) &rla_header.aspect_ratio,8,1,image->file); >   (void) ReadData((char *) &rla_header.chan,32,1,image->file);2   rla_header.field=MSBFirstReadShort(image->file);>   (void) ReadData((char *) &rla_header.time,12,1,image->file);@   (void) ReadData((char *) &rla_header.filter,32,1,image->file);=   rla_header.bits_per_channel=MSBFirstReadShort(image->file); 7   rla_header.matte_type=MSBFirstReadShort(image->file); 7   rla_header.matte_bits=MSBFirstReadShort(image->file);l;   rla_header.auxillary_type=MSBFirstReadShort(image->file);p;   rla_header.auxillary_bits=MSBFirstReadShort(image->file);oC   (void) ReadData((char *) &rla_header.auxillary,32,1,image->file); ?   (void) ReadData((char *) &rla_header.space,36,1,image->file);x0   rla_header.next=MSBFirstReadLong(image->file);   /*     Initialize image structure.e   */N   image->columns=rla_header.active_window.right-rla_header.active_window.left;K   image->rows=rla_header.active_window.top-rla_header.active_window.bottom; ,   image->packets=image->columns*image->rows;   image->depth=QuantumDepth;.   image->matte=rla_header.number_channels > 3;6   scanlines=(long *) malloc(image->rows*sizeof(long));#   image->pixels=(RunlengthPacket *)=3     malloc(image->packets*sizeof(RunlengthPacket));e0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); &   if (*rla_header.description != '\0')     {        /*         RLA image comment.       */       image->comments=(char *)@         malloc((strlen(rla_header.description)+1)*sizeof(char));+       if (image->comments == (char *) NULL))8         PrematureExit("Unable to allocate memory",image)5       strcpy(image->comments,rla_header.description);m     }l   /*'     Read offsets to each scanline data.o   */!   for (i=0; i < image->rows; i++) /     scanlines[i]=MSBFirstReadLong(image->file);    /*     Read image data.   */   q=image->pixels;!   for (y=0; y < image->rows; y++)e   {J;     (void) fseek(image->file,scanlines[image->rows-y-1],0); D     for (channel=0; channel < rla_header.number_channels; channel++)     {e,       length=MSBFirstReadShort(image->file);)       q=image->pixels+(y*image->columns);        while (length > 0)       { 8         (void) ReadData((char *) &byte,1,1,image->file);         runlength=byte;          if (byte > 127)            runlength=byte-256;&         length--;          if (length == 0)           break;         if (runlength < 0)           {n!             while (runlength < 0) 
             {->               (void) ReadData((char *) &byte,1,1,image->file);               length--;e               switch (channel)               {k                 case 0:m                 {g                   q->red=byte;                   q->index=0;c                   q->length=0;                   break;                 }P                 case 1:                  {                     q->green=byte;                   break;                 }(                 case 2:                  {(                   q->blue=byte;)                   break;                 }-                 case 3:                  default:                 {                     q->index=byte;                   break;                 }                }=               q++;               runlength++;
             }g             continue;g           }n8         (void) ReadData((char *) &byte,1,1,image->file);         length--;n         runlength++;
         do	         {o           switch (channel)           {              case 0:p
             {                q->red=byte;               q->index=0;x               q->length=0;               break;
             }r             case 1:n
             {a               q->green=byte;               break;
             }g             case 2:f
             {n               q->blue=byte;b               break;
             }R             case 3:f             default:
             {%               q->index=byte;               break;
             }            }            q++;           runlength--;	         }          while (runlength > 0);       }      } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %  R e a d R L E I m a g e                                                    % O %                                                                             %tO %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function ReadRLEImage reads a run-length encoded Utah Raster Toolkit L %  image file and returns it.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. %e- %  The format of the ReadRLEImage routine is:  % % %      image=ReadRLEImage(image_info)I % + %  A description of each parameter follows:r % I %    o image:  Function ReadRLEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.t % A %    o image_info: Specifies a pointer to an ImageInfo structure.g %i %a */1 static Image *ReadRLEImage(ImageInfo *image_info)a {n #define SkipLinesOp  0x01g #define SetColorOp  0x02 #define SkipPixelsOp  0x03 #define ByteDataOp  0x05 #define RunDataOp  0x06n #define EOFOp  0x07      char     magick[12];)     Image;     *image;(     intl     opcode,      operand,     status,      x,     y;     register int     i,     j;     register RunlengthPacket     *q;v     register unsigned char     *p;X     unsigned char;     background_color[256],     *colormap,
     pixel,
     plane,     *rle_pixels;     unsigned int     bits_per_pixel,m
     flags,     map_length,o     number_colormaps,      number_planes;     /*     Allocate image structure.n   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);%   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a RLE file.   */3   status=ReadData((char *) magick,1,2,image->file); ?   if ((status == False) || (strncmp(magick,"\122\314",2) != 0))g0     PrematureExit("Not a RLE image file",image);   do   {      /*       Read image header.     */*     (void) LSBFirstReadShort(image->file);*     (void) LSBFirstReadShort(image->file);2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file); .     image->packets=image->columns*image->rows;     flags=fgetc(image->file);%     image->matte=flags & 0x04;%     number_planes=fgetc(image->file);r&     bits_per_pixel=fgetc(image->file);(     number_colormaps=fgetc(image->file);'     map_length=1 << fgetc(image->file);tP     if ((number_planes == 0) || (number_planes == 2) || (bits_per_pixel != 8) ||         (image->columns == 0))8       PrematureExit("Unsupported RLE image file",image);     if (flags & 0x02)e       {o
         /*4           No background color-- initialize to black.
         */)         for (i=0; i < number_planes; i++)o0           background_color[i]=(unsigned char) 0;"         (void) fgetc(image->file);       }n     else       {e
         /*&           Initialize background color.
         */         p=background_color; )         for (i=0; i < number_planes; i++) 2           *p++=(unsigned char) fgetc(image->file);       }a$     if ((number_planes & 0x01) == 0)        (void) fgetc(image->file);$     colormap=(unsigned char *) NULL;     if (number_colormaps != 0)       {a
         /*           Read image colormaps.m
         */"         colormap=(unsigned char *)D           malloc(number_colormaps*map_length*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL)-;           PrematureExit("Unable to allocate memory",image);i         p=colormap; ,         for (i=0; i < number_colormaps; i++)(           for (j=0; j < map_length; j++)<             *p++=XDownScale(LSBFirstReadShort(image->file));       })     if (flags & 0x08)e       {_         unsigned int           length;)  
         /*           Read image comment. 
         */.         length=LSBFirstReadShort(image->file);=         image->comments=(char *) malloc(length*sizeof(char)); -         if (image->comments == (char *) NULL)>;           PrematureExit("Unable to allocate memory",image); I         (void) ReadData((char *) image->comments,1,length-1,image->file);i'         image->comments[length-1]='\0';k!         if ((length & 0x01) == 0)o$           (void) fgetc(image->file);       }c     /*       Allocate RLE pixels.     */     if (image->matte)        number_planes++;      rle_pixels=(unsigned char *)A       malloc(image->packets*number_planes*sizeof(unsigned char)); -     if (rle_pixels == (unsigned char *) NULL)a7       PrematureExit("Unable to allocate memory",image);,*     if ((flags & 0x01) && !(flags & 0x02))       {p
         /*           Set background color. 
         */         p=rle_pixels;]*         for (i=0; i < image->packets; i++)	         {            if (!image->matte)-             for (j=0; j < number_planes; j++);'               *p++=background_color[j];n           else
             {a3               for (j=0; j < (number_planes-1); j++)s)                 *p++=background_color[j];g5               *p++=0;  /* initialize matte channel */e
             }p	         }s       }d     /*#       Read runlength-encoded image.z     */     plane=0;     x=0;     y=0;     opcode=fgetc(image->file);     do     {o       switch (opcode & 0x3f)       {a         case SkipLinesOp:d	         {k%           operand=fgetc(image->file);l           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);            x=0;           y+=operand;m           break;	         }p         case SetColorOp:	         {e%           operand=fgetc(image->file);%           plane=operand;           if (plane == 255)%"             plane=number_planes-1;           x=0;           break;	         }          case SkipPixelsOp:	         { %           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);            x+=operand;R           break;	         }          case ByteDataOp:	         { %           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file); H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;           operand++;%           for (i=0; i < operand; i++)%           {%%             pixel=fgetc(image->file);t>             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;              p+=number_planes;a           }a           if (operand & 0x01) &             (void) fgetc(image->file);           x+=operand;            break;	         }m         case RunDataOp:A	         {n%           operand=fgetc(image->file);o           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);i#           pixel=fgetc(image->file);e$           (void) fgetc(image->file);           operand++;H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;%           for (i=0; i < operand; i++)            {i>             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;              p+=number_planes;            }e           x+=operand;n           break;	         }          default:           break;       }         opcode=fgetc(image->file);<     } while (((opcode & 0x3f) != EOFOp) && (opcode != EOF));     if (number_colormaps != 0)       {)         unsigned int           mask;   
         /*1           Apply colormap transformation to image.=
         */         mask=(map_length-1);         p=rle_pixels; "         if (number_colormaps == 1),           for (i=0; i < image->packets; i++)           {=3             *p=(unsigned char) colormap[*p & mask];i             p++;           }i         else>           if ((number_planes >= 3) && (number_colormaps >= 3)).             for (i=0; i < image->packets; i++)/               for (j=0; j < number_planes; j++)h               {=F                 *p=(unsigned char) colormap[j*map_length+(*p & mask)];                 p++;               }s       }i     /*!       Initialize image structure.k     */%     image->pixels=(RunlengthPacket *)g5       malloc(image->packets*sizeof(RunlengthPacket));N2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);m     q=image->pixels;     if (number_planes >= 3)-       {a
         /*H           Convert raster image to DirectClass runlength-encoded packets.
         */         p=rle_pixels;l'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { !             q->red=UpScale(*p++);0#             q->green=UpScale(*p++);("             q->blue=UpScale(*p++);B             q->index=(unsigned short) (image->matte ? (*p++) : 0);             q->length=0;             q++;           }e7           ProgressMonitor(LoadImageText,y,image->rows); 	         }        }%     else       {%
         /*           Create colormap.
         */!         image->class=PseudoClass; "         if (number_colormaps == 0)           map_length=256; !         image->colors=map_length; '         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          p=colormap; "         if (number_colormaps == 0)+           for (i=0; i < image->colors; i++)            {              /*               Grayscale.             */@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);            }c         else$           if (number_colormaps == 1)-             for (i=0; i < image->colors; i++) 
             {a               /*                 Pseudocolor.               */:               image->colormap[i].red=(Quantum) UpScale(i);<               image->colormap[i].green=(Quantum) UpScale(i);;               image->colormap[i].blue=(Quantum) UpScale(i); 
             }            else-             for (i=0; i < image->colors; i++) 
             {:1               image->colormap[i].red=UpScale(*p); @               image->colormap[i].green=UpScale(*(p+map_length));A               image->colormap[i].blue=UpScale(*(p+map_length*2));a               p++;
             }n         p=rle_pixels;          if (!image->matte)           {;             /*L               Convert raster image to PseudoClass runlength-encoded packets.             */+             for (y=0; y < image->rows; y++)*
             {i0               for (x=0; x < image->columns; x++)               {m1                 q->index=(unsigned short) (*p++);                  q->length=0;                 q++;               }B;               ProgressMonitor(LoadImageText,y,image->rows);t
             }              SyncImage(image);-           }          else           {;             /*A               Image has a matte channel-- promote to DirectClass.              */+             for (y=0; y < image->rows; y++)u
             {L0               for (x=0; x < image->columns; x++)               {r/                 q->red=image->colormap[*p].red; 3                 q->green=image->colormap[*p].green;g3                 q->blue=image->colormap[*p++].blue; 1                 q->index=(unsigned short) (*p++);                  q->length=0;                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows); 
             } "             free(image->colormap);1             image->colormap=(ColorPacket *) NULL; %             image->class=DirectClass;              image->colors=0;           }        }      if (number_colormaps != 0)       free((char *) colormap);     free((char *) rle_pixels);     CompressImage(image);      /*       Proceed to next image.     */     (void) fgetc(image->file);5     status=ReadData((char *) magick,1,2,image->file); @     if ((status == True) && (strncmp(magick,"\122\314",2) == 0))       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {*!             DestroyImages(image);(#             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }lD   } while ((status == True) && (strncmp(magick,"\122\314",2) == 0));+   while (image->previous != (Image *) NULL)s     image=image->previous;   CloseImage(image);   return(image); }w   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %gO %  R e a d S G I I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function ReadSGIImage reads a SGI RGB image file and returns it.  ItdK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %c- %  The format of the ReadSGIImage routine is:  % % %      image=ReadSGIImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadSGIImage returns a pointer to the image afteryL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %f */  C static void SGIDecode(unsigned char *packets,unsigned char *pixels)i {R   unsigned charm
     count,
     pixel;     for ( ; ;)   {      pixel=(*packets++);U     count=pixel & 0x7f;      if (count == 0)y       break;     if (pixel & 0x80) "       for ( ; count != 0; count--)       {          *pixels=(*packets++);e         pixels+=4;       }m     else       {u         pixel=(*packets++); $         for ( ; count != 0; count--)	         {            *pixels=pixel;           pixels+=4;	         }d       }    }  }   1 static Image *ReadSGIImage(ImageInfo *image_info)  {    typedef struct _SGIHeader;   {      unsigned short       magic;       unsigned char        storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned long0       minimum_value,       maximum_value;       unsigned charT       filler[492];   } SGIHeader;     Image-     *image;      SGIHeaderf     iris_header;     register int     i,     x,     y,     z;     register RunlengthPacket     *q;(     register unsigned char     *p;      unsigned chara     *iris_pixels;)     /*     Allocate image structure.l   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);n#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);m   /*     Read SGI raster header.)   */3   iris_header.magic=MSBFirstReadShort(image->file);    do   {-     /*       Verify SGI identifier.     */$     if (iris_header.magic != 0x01DA)1       PrematureExit("Not a SGI RGB image",image);u+     iris_header.storage=fgetc(image->file);n3     iris_header.bytes_per_pixel=fgetc(image->file);-)     if (iris_header.bytes_per_pixel != 1) F       PrematureExit("Image must have 1 byte per pixel channel",image);9     iris_header.dimension=MSBFirstReadShort(image->file); 7     iris_header.columns=MSBFirstReadShort(image->file); 4     iris_header.rows=MSBFirstReadShort(image->file);5     iris_header.depth=MSBFirstReadShort(image->file); <     iris_header.minimum_value=MSBFirstReadLong(image->file);<     iris_header.maximum_value=MSBFirstReadLong(image->file);2     (void) ReadData((char *) iris_header.filler,1,=       (unsigned int) sizeof(iris_header.filler),image->file);o     /*       Allocate SGI pixels.     */!     iris_pixels=(unsigned char *)fK       malloc(4*iris_header.columns*iris_header.rows*sizeof(unsigned char)); .     if (iris_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);x$     if (iris_header.storage != 0x01)       {d         unsigned charL           *scanline;  
         /*%           Read standard image format.=
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);e3         for (z=0; z < (int) iris_header.depth; z++)d	         {h           p=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           {tD             (void) ReadData((char *) scanline,1,iris_header.columns,               image->file);r9             for (x=0; x < (int) iris_header.columns; x++)=
             {y               *p=scanline[x];                p+=4; 
             }f           } 	         }n          free((char *) scanline);       }'     else       {f         unsigned charo           *packets;            unsigned int           data_order;            unsigned long            offset,*           *offsets,s           *runlength;t  
         /*.           Read runlength-encoded image format.
         */!         offsets=(unsigned long *)iK           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));o!         packets=(unsigned char *)oH           malloc(((iris_header.columns << 1)+10)*sizeof(unsigned char));#         runlength=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));(2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL));           PrematureExit("Unable to allocate memory",image);nF         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)3           offsets[i]=MSBFirstReadLong(image->file); F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)5           runlength[i]=MSBFirstReadLong(image->file);c
         /*           Check data order. 
         */         offset=0;t         data_order=0;oE         for (y=0; ((y < (int) iris_header.rows) && !data_order); y++)sH           for (z=0; ((z < (int) iris_header.depth) && !data_order); z++)           { 7             if (offsets[y+z*iris_header.rows] < offset)                data_order=1;c1             offset=offsets[y+z*iris_header.rows];            }-A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);-         if (data_order == 1)           { 7             for (z=0; z < (int) iris_header.depth; z++)e
             {-               p=iris_pixels;8               for (y=0; y < (int) iris_header.rows; y++)               { <                 if (offset != offsets[y+z*iris_header.rows])                   {p9                     offset=offsets[y+z*iris_header.rows]; =                     (void) fseek(image->file,(int) offset,0);l                   } 3                 (void) ReadData((char *) packets,1, N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z);o+                 p+=(iris_header.columns*4);s               }_
             }(           }s         else           {              p=iris_pixels;6             for (y=0; y < (int) iris_header.rows; y++)
             {o9               for (z=0; z < (int) iris_header.depth; z++);               {g<                 if (offset != offsets[y+z*iris_header.rows])                   {s9                     offset=offsets[y+z*iris_header.rows];c=                     (void) fseek(image->file,(int) offset,0);                    }i3                 (void) ReadData((char *) packets,1,(N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z);=               }))               p+=(iris_header.columns*4);u
             }            }*         free(runlength);         free(packets);         free(offsets);       }l     /*!       Initialize image structure.      */(     image->matte=iris_header.depth == 4;'     image->columns=iris_header.columns;)!     image->rows=iris_header.rows;i.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)o5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert SGI raster image to runlength-encoded packets.     */     q=image->pixels;     if (iris_header.depth >= 3)p       {h
         /*E           Convert SGI image to DirectClass runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++)z	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4);s,           for (x=0; x < image->columns; x++)           {              q->red=UpScale(*p); %             q->green=UpScale(*(p+1));o$             q->blue=UpScale(*(p+2));             q->index=(*(p+3));             q->length=0;             p+=4;s             q++;           }c7           ProgressMonitor(LoadImageText,y,image->rows);k	         }        }e     else       {d         unsigned short           index;  
         /*           Create grayscale map."
         */!         image->class=PseudoClass;c         image->colors=256;'         image->colormap=(ColorPacket *)t4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image); )         for (i=0; i < image->colors; i++) 	         {m6           image->colormap[i].red=(Quantum) UpScale(i);8           image->colormap[i].green=(Quantum) UpScale(i);7           image->colormap[i].blue=(Quantum) UpScale(i);o	         }m
         /*E           Convert SGI image to PseudoClass runlength-encoded packets.e
         */'         for (y=0; y < image->rows; y++)L	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4);i,           for (x=0; x < image->columns; x++)           {m(             index=(unsigned short) (*p);             q->index=index;              q->length=0;             p+=4;l             q++;           }>7           ProgressMonitor(LoadImageText,y,image->rows); 	         }e         SyncImage(image);        }f     free((char *) iris_pixels);u     CompressImage(image);%     /*       Proceed to next image.     */5     iris_header.magic=MSBFirstReadShort(image->file); $     if (iris_header.magic == 0x01DA)       { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } (   } while (iris_header.magic == 0x01DA);+   while (image->previous != (Image *) NULL)%     image=image->previous;   CloseImage(image);   return(image); }u   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %:O %                                                                             %tO %                                                                             %iO %  R e a d S U N I m a g e                                                    %aO %                                                                             %iO %                                                                             %fO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %tM %  Function ReadSUNImage reads a SUN image file and returns it.  It allocatesnL %  the memory necessary for the new Image structure and returns a pointer to %  the new image.e %a- %  The format of the ReadSUNImage routine is:g %n% %      image=ReadSUNImage(image_info)  %e+ %  A description of each parameter follows:f %.I %    o image:  Function ReadSUNImage returns a pointer to the image after=L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.) %eA %    o image_info: Specifies a pointer to an ImageInfo structure.p %i %. */1 static Image *ReadSUNImage(ImageInfo *image_info)* {a #define RMT_EQUAL_RGB  1 #define RMT_NONE  0  #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_ENCODED  2l #define RT_FORMAT_RGB  3     typedef struct _SUNHeader.   {/     unsigned longr       magic,       width,
       height,o       depth,
       length,i       type,        maptype,       maplength;   } SUNHeader;     Imaget     *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;t     register unsigned char     *p;      SUNHeader(     sun_header;g     unsigned charm     *sun_data,     *sun_pixels;     unsigned int     status;      /*     Allocate image structure.r   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);u   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);g#   if (image->file == (FILE *) NULL)u/     PrematureExit("Unable to open file",image);k   /*     Read SUN raster header.*   */1   sun_header.magic=MSBFirstReadLong(image->file);l   do   {      /*       Verify SUN identifier.     */'     if (sun_header.magic != 0x59a66a95)r4       PrematureExit("Not a SUN raster image",image);3     sun_header.width=MSBFirstReadLong(image->file);s4     sun_header.height=MSBFirstReadLong(image->file);3     sun_header.depth=MSBFirstReadLong(image->file);x4     sun_header.length=MSBFirstReadLong(image->file);2     sun_header.type=MSBFirstReadLong(image->file);5     sun_header.maptype=MSBFirstReadLong(image->file);n7     sun_header.maplength=MSBFirstReadLong(image->file);      switch (sun_header.maptype)      {r       case RMT_NONE:       {o"         if (sun_header.depth < 24)           {              /*'               Create linear color ramp.-             */0             image->colors=1 << sun_header.depth;+             image->colormap=(ColorPacket *) 8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image);--             for (i=0; i < image->colors; i++)a
             {GB               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);=
             })           }          break;       }e       case RMT_EQUAL_RGB:u       {          unsigned char            *sun_colormap;  
         /*#           Read SUN raster colormap. 
         */-         image->colors=sun_header.maplength/3;i'         image->colormap=(ColorPacket *)i4           malloc(image->colors*sizeof(ColorPacket));&         sun_colormap=(unsigned char *)6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (sun_colormap == (unsigned char *) NULL))i;           PrematureExit("Unable to allocate memory",image);;K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);m)         for (i=0; i < image->colors; i++)M:           image->colormap[i].red=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);%)         for (i=0; i < image->colors; i++)%<           image->colormap[i].green=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file); )         for (i=0; i < image->colors; i++) ;           image->colormap[i].blue=UpScale(sun_colormap[i]); $         free((char *) sun_colormap);         break;       }        case RMT_RAW:        {          unsigned char            *sun_colormap;  
         /*#           Read SUN raster colormap. 
         */&         sun_colormap=(unsigned char *)=           malloc(sun_header.maplength*sizeof(unsigned char)); 3         if (sun_colormap == (unsigned char *) NULL)%;           PrematureExit("Unable to allocate memory",image);F>         (void) ReadData((char *) sun_colormap,1,(unsigned int),           sun_header.maplength,image->file);$         free((char *) sun_colormap);         break;       }        default:>         PrematureExit("Colormap type is not supported",image);     }_O     sun_data=(unsigned char *) malloc(sun_header.length*sizeof(unsigned char));t+     if (sun_data == (unsigned char *) NULL)g7       PrematureExit("Unable to allocate memory",image);eI     status=ReadData((char *) sun_data,1,(unsigned int) sun_header.length,        image->file);i=     if ((status == False) && (sun_header.type != RT_ENCODED))a7       PrematureExit("Unable to read image data",image);      sun_pixels=sun_data;&     if (sun_header.type == RT_ENCODED)       {e         unsigned int           width,           height;g  
         /*0           Read run-length encoded raster pixels.
         */?         width=sun_header.width*(((sun_header.depth-1) >> 3)+1);m!         height=sun_header.height;mP         sun_pixels=(unsigned char *) malloc(width*height*sizeof(unsigned char));1         if (sun_pixels == (unsigned char *) NULL)m;           PrematureExit("Unable to allocate memory",image);e@         (void) SUNDecodeImage(sun_data,sun_pixels,width,height);          free((char *) sun_data);       }      /*!       Initialize image structure.M     */*     image->matte=(sun_header.depth == 32);E     image->class=(sun_header.depth < 24 ? PseudoClass : DirectClass);m$     image->columns=sun_header.width;"     image->rows=sun_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)u5       malloc(image->packets*sizeof(RunlengthPacket));c2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);e     /*<       Convert SUN raster image to runlength-encoded packets.     */     p=sun_pixels;o     q=image->pixels;     if (sun_header.depth == 1)%       for (y=0; y < image->rows; y++)        {=
         /*E           Convert bitmap scanline to runlength-encoded color packets.l
         */1         for (x=0; x < (image->columns >> 3); x++)&	         {q&           for (bit=7; bit >= 0; bit--)           {q:             q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);             q->length=0;             q++;           }            p++;	         } &         if ((image->columns % 8) != 0)           {s?             for (bit=7; bit >= (8-(image->columns % 8)); bit--) 
             {g<               q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);               q->length=0;               q++;
             }              p++;           }lI         if ((((image->columns/8)+(image->columns % 8 ? 1 : 0)) % 2) != 0)e           p++;5         ProgressMonitor(LoadImageText,y,image->rows);        }      else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++) 	         {i           /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } (           if ((image->columns % 2) != 0)             p++;7           ProgressMonitor(LoadImageText,y,image->rows); 	         } 
       else'         for (y=0; y < image->rows; y++) 	         {            /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {LB             q->index=(unsigned short) (image->matte ? (*p++) : 0);/             if (sun_header.type == RT_STANDARD)g               { &                 q->blue=UpScale(*p++);'                 q->green=UpScale(*p++); %                 q->red=UpScale(*p++);                }h             else               {U%                 q->red=UpScale(*p++);s'                 q->green=UpScale(*p++); &                 q->blue=UpScale(*p++);               }%#             if (image->colors != 0)                { 3                 q->red=image->colormap[q->red].red; 9                 q->green=image->colormap[q->green].green; 6                 q->blue=image->colormap[q->blue].blue;               }              q->length=0;             q++;           }eE           if (((image->columns % 2) != 0) && (image->matte == False))              p++;7           ProgressMonitor(LoadImageText,y,image->rows); 	         }      free((char *) sun_pixels);$     if (image->class == PseudoClass)       {          SyncImage(image);           CompressColormap(image);       }%     CompressImage(image);%     /*       Proceed to next image.     */3     sun_header.magic=MSBFirstReadLong(image->file); '     if (sun_header.magic == 0x59a66a95)        { 
         /*#           Allocate image structure.i
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {)!             DestroyImages(image);m#             return((Image *) NULL);n           }LB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }e+   } while (sun_header.magic == 0x59a66a95);m+   while (image->previous != (Image *) NULL)e     image=image->previous;   CloseImage(image);   return(image); }g e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d T G A I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%J %  Function ReadTGAImage reads a Truevision TGA image file and returns it.L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %n- %  The format of the ReadTGAImage routine is:h % % %      image=ReadTGAImage(image_info)e %o+ %  A description of each parameter follows:T %fI %    o image:  Function ReadTGAImage returns a pointer to the image after_L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.r % A %    o image_info: Specifies a pointer to an ImageInfo structure.e %  %  */1 static Image *ReadTGAImage(ImageInfo *image_info)  {  #define TGAColormap 1e #define TGARGB 2 #define TGAMonochrome 3a #define TGARLEColormap  9  #define TGARLERGB  10i #define TGARLEMonochrome  11     typedef struct _TGAHeaderd   {      unsigned chari       id_length,       colormap_type,       image_type;p       unsigned short       colormap_index,n       colormap_length;       unsigned char        colormap_size;       unsigned short       x_origin,        y_origin,t       width,
       height;        unsigned charh       pixel_size,_       attributes;    } TGAHeader;     Image+     *image;   	   Quantum 	     blue,+
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;      TGAHeader      tga_header;i     unsigned char      j,     k,     runlength;     unsigned int	     base, 	     flag,l     offset, 	     real, 	     skip,1     status;      unsigned short
     index;     /*     Allocate image structure.(   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);>#   if (image->file == (FILE *) NULL)c/     PrematureExit("Unable to open file",image);h   /*      Read TGA header information.   */B   status=ReadData((char *) &tga_header.id_length,1,1,image->file);.   tga_header.colormap_type=fgetc(image->file);+   tga_header.image_type=fgetc(image->file);e   do   { <     if ((status == False) || (tga_header.image_type == 0) ||%         (tga_header.image_type > 11))t2       PrematureExit("Not a TGA image file",image);=     tga_header.colormap_index=LSBFirstReadShort(image->file);s>     tga_header.colormap_length=LSBFirstReadShort(image->file);0     tga_header.colormap_size=fgetc(image->file);7     tga_header.x_origin=LSBFirstReadShort(image->file); 7     tga_header.y_origin=LSBFirstReadShort(image->file); 4     tga_header.width=LSBFirstReadShort(image->file);5     tga_header.height=LSBFirstReadShort(image->file);d-     tga_header.pixel_size=fgetc(image->file);.-     tga_header.attributes=fgetc(image->file);d     /*!       Initialize image structure.e     */-     image->matte=tga_header.pixel_size == 32; $     image->columns=tga_header.width;"     image->rows=tga_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)=5       malloc(image->packets*sizeof(RunlengthPacket));e2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image); "     if (tga_header.id_length != 0)       { 
         /*           TGA image comment.
         */          image->comments=(char *)8           malloc((tga_header.id_length+1)*sizeof(char));-         if (image->comments == (char *) NULL)u;           PrematureExit("Unable to allocate memory",image);IL         (void) ReadData(image->comments,1,tga_header.id_length,image->file);3         image->comments[tga_header.id_length]='\0';c       }e
     red=0;     green=0;     blue=0;a&     if (tga_header.colormap_type != 0)       {w
         /*#           Read TGA raster colormap.o
         */8         if ((tga_header.image_type == TGARLEColormap) ||1             (tga_header.image_type == TGARLERGB))o#           image->class=PseudoClass; 1         image->colors=tga_header.colormap_length;c'         image->colormap=(ColorPacket *)"4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image); )         for (i=0; i < image->colors; i++) 	         {m+           switch (tga_header.colormap_size);           {              case 8:+             default:
             {a               /*                 Gray scale.r               */.               red=UpScale(fgetc(image->file));               green=red;               blue=red;;               break;
             }              case 15:             case 16:
             {o               /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file);e#               k=fgetc(image->file);iB               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum)EP                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);               break;
             }t             case 32:             case 24:
             {e               /*3                 8 bits each of blue, green and red.                *//               blue=UpScale(fgetc(image->file));a0               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));               break;
             }i           } %           image->colormap[i].red=red; )           image->colormap[i].green=green;g'           image->colormap[i].blue=blue;)	         }        }p     /*6       Convert TGA pixels to runlength-encoded packets.     */     base=0;l     flag=0;      index=0;     skip=False;l     real=0;e     runlength=0;
     offset=0;f     q=image->pixels;&     for (i=0; i < image->packets; i++)     {*       q->red=0;h       q->green=0;r       q->blue=0;       q->index=0;m       q->length=0;
       q++;     }m#     for (y=0; y < image->rows; y++)a     {*       real=offset;E       if (((unsigned char) (tga_header.attributes & 0x20) >> 5) == 0)           real=image->rows-real-1;,       q=image->pixels+(real*image->columns);(       for (x=0; x < image->columns; x++)       {;8         if ((tga_header.image_type == TGARLEColormap) ||3             (tga_header.image_type == TGARLERGB) || 8             (tga_header.image_type == TGARLEMonochrome))           if (runlength != 0)f
             {i               runlength--;               skip=flag != 0; 
             }*           else
             { C               status=ReadData((char *) &runlength,1,1,image->file); "               if (status == False)A                 PrematureExit("Unable to read image data",image); $               flag=runlength & 0x80;               if (flag != 0)                 runlength-=128;t               skip=False; 
             }          if (!skip)(           switch (tga_header.pixel_size)           {e             case 8:;             default:
             {(               /*                 Gray scale.e               */'               index=fgetc(image->file);e0               if (tga_header.colormap_type == 0)                 { /                   red=(Quantum) UpScale(index);m1                   green=(Quantum) UpScale(index);>0                   blue=(Quantum) UpScale(index);                 }e               else                 {a1                   red=image->colormap[index].red;f5                   green=image->colormap[index].green;a3                   blue=image->colormap[index].blue;1                 }*               break;
             }e             case 15:             case 16:
             {r               /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file); #               k=fgetc(image->file);=B               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum)fP                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);0               index=((unsigned short) k << 8)+j;               break;
             }              case 24:             case 32:
             {i               /*2                 8 bits each of blue green and red.               *//               blue=UpScale(fgetc(image->file));p0               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));.               if (tga_header.pixel_size == 32))                 index=fgetc(image->file);N               break;
             }            }e         if (status == False);           PrematureExit("Unable to read image data",image);i         q->red=red;          q->green=green;v         q->blue=blue;y         q->index=index;          q->length=0;         q++;       }RE       if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 4)          offset+=4;
       elseG         if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 2)            offset+=2;         else           offset++;         if (offset >= image->rows)	         {            base++;e           offset=base;	         }g       if (feof(image->file))         break;3       ProgressMonitor(LoadImageText,y,image->rows);;     }      (void) IsGrayImage(image);$     if (image->class == PseudoClass)       SyncImage(image);l     CompressImage(image);      /*       Proceed to next image.     */D     status=ReadData((char *) &tga_header.id_length,1,1,image->file);0     tga_header.colormap_type=fgetc(image->file);-     tga_header.image_type=fgetc(image->file);iL     status&=((tga_header.image_type != 0) && (tga_header.image_type <= 11));     if (status == True)p       { 
         /*#           Allocate image structure.n
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);r#             return((Image *) NULL);            }lB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }-   } while (status == True);x+   while (image->previous != (Image *) NULL)n     image=image->previous;   CloseImage(image);   return(image); }a ) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             %lO %                                                                             %eO %                                                                             % O %  R e a d T E X T I m a g e                                                  %gO %                                                                             %(O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%v %)K %  Function ReadTEXTImage reads a text file and returns it as an image.  It)K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %i. %  The format of the ReadTEXTImage routine is: % & %      image=ReadTEXTImage(image_info) % + %  A description of each parameter follows:4 %aJ %    o image:  Function ReadTEXTImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %t */2 static Image *ReadTEXTImage(ImageInfo *image_info) {(   AnnotateInfo     annotate_info;     char     geometry[MaxTextLength],     text[MaxTextLength],     *text_status;   	   Display 
     *display;,     Image>     *image;;     int      offset,8     x,     y;     register int     i;     register RunlengthPacket     *p;)     RunlengthPacketr     background_color;f     unsigned int     height,2
     width;     XColor
     color;     XResourceInfo-     resource_info;     /*     Allocate image structure.2   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL)e/     PrematureExit("Unable to open file",image);4   /*     Initialize Image structure.    */?   (void) XParseGeometry(TextPageGeometry,&x,&y,&width,&height);w(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);c   else     {a       floato         dx_resolution,         dy_resolution,         x_resolution,r         y_resolution;n  	       int          count;         /*         Determine bounding box.r       */       dx_resolution=72.0;s       dy_resolution=72.0;S       x_resolution=72.0;J       count=sscanf(PSDensityGeometry,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL) N         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2)e"         y_resolution=x_resolution;F       width=(unsigned int) (((width*x_resolution)/dx_resolution)+0.5);H       height=(unsigned int) (((height*y_resolution)/dy_resolution)+0.5);     }    image->columns=width;    image->rows=height;a,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)g3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);i   /*%     Initialize image annotation info.    */"   GetAnnotateInfo(&annotate_info);4   annotate_info.server_name=image_info->server_name;&   annotate_info.font=image_info->font;   annotate_info.text=text;"   annotate_info.geometry=geometry;$   annotate_info.pen=ForegroundColor;5   (void) XQueryColorDatabase(BackgroundColor,&color); 0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {        XrmDatabase          resource_database;         /*%         Set background and pen color.        */       XSetErrorHandler(XError); B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);H       (void) XQueryColorDatabase(resource_info.background_color,&color);7       annotate_info.pen=resource_info.foreground_color;%       XCloseDisplay(display);      }t   /*.     Initialize text image to background color.   */-   background_color.red=XDownScale(color.red);y1   background_color.green=XDownScale(color.green);t/   background_color.blue=XDownScale(color.blue);a   background_color.index=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)     *p++=background_color;+   if (image_info->texture != (char *) NULL)t,     TextureImage(image,image_info->texture);   /*     Annotate the text image.   */   offset=0;s
   for ( ; ; )    {      /*       Annotate image with text.a     */F     ProgressMonitor(LoadImageText,ftell(image->file),image->filesize);8     text_status=fgets(text,MaxTextLength-1,image->file);%     if (text_status == (char *) NULL)a       break;-     if ((int) strlen(annotate_info.text) > 0) <       annotate_info.text[strlen(annotate_info.text)-1]='\0';?     (void) sprintf(annotate_info.geometry,"%+d%+d",x,y+offset); (     AnnotateImage(image,&annotate_info);$     offset+=annotate_info.pointsize;@     if (((y << 1)+offset+annotate_info.pointsize) < image->rows)       continue;s     /*3       Page is full-- allocate next image structure.      */     CompressImage(image);i-     if (image_info->texture == (char *) NULL)d3       QuantizeImage(image,2,8,False,RGBColorspace);u     image->orphan=True;rB     image->next=CopyImage(image,image->columns,image->rows,False);     image->orphan=False;&     if (image->next == (Image *) NULL)       { F         Warning("Unable to annotate image","Memory allocation error");         break;       }i>     (void) strcpy(image->next->filename,image_info->filename);"     image->next->file=image->file;*     image->next->filesize=image->filesize;&     image->next->scene=image->scene+1;      image->next->previous=image;     image=image->next;     /*0       Initialize text image to background color.     */     p=image->pixels;&     for (i=0; i < image->packets; i++)       *p++=background_color;-     if (image_info->texture != (char *) NULL)l.       TextureImage(image,image_info->texture);
     offset=0;a   }f   CompressImage(image); +   if (image_info->texture == (char *) NULL) 1     QuantizeImage(image,2,8,False,RGBColorspace);/+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }f " #ifdef HasTIFF #include "tiffio.h"l   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%LO %                                                                             %iO %                                                                             %=O %                                                                             %eO %  R e a d T I F F I m a g e                                                  %;O %                                                                             %=O %                                                                             %iO %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %xG %  Function ReadTIFFImage reads a Tagged image file and returns it.  IteK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %d. %  The format of the ReadTIFFImage routine is: %r& %      image=ReadTIFFImage(image_info) % + %  A description of each parameter follows:; % J %    o image:  Function ReadTIFFImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.r %rA %    o image_info: Specifies a pointer to an ImageInfo structure.d %X %s */  E static void TIFFWarningMessage(const char *module,const char *format,+   va_list warning) {x   char     message[MaxTextLength];      register chara     *p;n     p=message;   if (module != (char *) NULL)     {r&       (void) sprintf(p,"%s: ",module);       p+=strlen(message);m     }i   vsprintf(p,format,warning);f   strcat(p,".");!   Warning(message,(char *) NULL);r }k  2 static Image *ReadTIFFImage(ImageInfo *image_info) {)   char
     *comment;r     Imagel     *image;      intm
     range;  	   Quantumt	     blue,p
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;d     TIFF
     *tiff;     uint16     extra_samples,     *sample_info;m     unsigned charu     *scanline;     unsigned int     height,c     method,e     packets,     status,l
     width;     unsigned short     bits_per_sample,
     index,     interlace,     max_sample_value,x     min_sample_value,.     photometric,     samples_per_pixel,
     value;     /*     Allocate image structure.h   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image.c   */-   OpenImage(image_info,image,ReadBinaryType);/#   if (image->file == (FILE *) NULL)=/     PrematureExit("Unable to open file",image); ,   if ((image->file == stdin) || image->pipe)     {a
       FILE         *file;  	       intR
         c;         /*6         Copy standard input or pipe to temporary file.       */.       TemporaryFilename(image_info->filename);7       file=fopen(image_info->filename,WriteBinaryType);(        if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);       c=fgetc(image->file);i       while (c != EOF)       {i         (void) putc(c,file);         c=fgetc(image->file);x       }n       (void) fclose(file);:       (void) strcpy(image->filename,image_info->filename);       image->temporary=True;     }g   CloseImage(image);*   TIFFSetErrorHandler(TIFFWarningMessage);,   TIFFSetWarningHandler(TIFFWarningMessage);0   tiff=TIFFOpen(image->filename,ReadBinaryType);   if (tiff == (TIFF *) NULL)/     PrematureExit("Unable to open file",image);     if (image_info->subimage != 0)/     while (image->scene < image_info->subimage)t     {-       /*         Skip to next image.        */       image->scene++;_%       status=TIFFReadDirectory(tiff);0       if (status == False)7         PrematureExit("Unable to read subimage",image);m     }t   do   {e     if (image_info->verbose),       TIFFPrintDirectory(tiff,stderr,False);1     TIFFGetField(tiff,TIFFTAG_IMAGEWIDTH,&width); 3     TIFFGetField(tiff,TIFFTAG_IMAGELENGTH,&height);r@     TIFFGetFieldDefaulted(tiff,TIFFTAG_PLANARCONFIG,&interlace);G     TIFFGetFieldDefaulted(tiff,TIFFTAG_BITSPERSAMPLE,&bits_per_sample);eI     TIFFGetFieldDefaulted(tiff,TIFFTAG_MINSAMPLEVALUE,&min_sample_value); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MAXSAMPLEVALUE,&max_sample_value); A     TIFFGetFieldDefaulted(tiff,TIFFTAG_PHOTOMETRIC,&photometric);dK     TIFFGetFieldDefaulted(tiff,TIFFTAG_SAMPLESPERPIXEL,&samples_per_pixel);iE     TIFFGetFieldDefaulted(tiff,TIFFTAG_RESOLUTIONUNIT,&image->units);gI     TIFFGetFieldDefaulted(tiff,TIFFTAG_XRESOLUTION,&image->x_resolution);gI     TIFFGetFieldDefaulted(tiff,TIFFTAG_YRESOLUTION,&image->y_resolution);U     /*5       Allocate memory for the image and pixel buffer.e     */     image->columns=width;l     image->rows=height;+     image->depth=QuantumDepth;     if (bits_per_sample <= 8)        image->depth=8;c     image->packets=0;y7     packets=Max((image->columns*image->rows+4) >> 3,1);=     if (bits_per_sample == 1) 9       packets=Max((image->columns*image->rows+8) >> 4,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)       {m         TIFFClose(tiff);9         PrematureExit("Unable to allocate memory",image);        }      comment=(char *) NULL;9     TIFFGetField(tiff,TIFFTAG_IMAGEDESCRIPTION,&comment); !     if (comment != (char *) NULL)_$       if ((int) strlen(comment) > 4)	         { "           image->comments=(char *)D             malloc((unsigned int) (strlen(comment)+1)*sizeof(char));/           if (image->comments == (char *) NULL)-
             {                TIFFClose(tiff);?               PrematureExit("Unable to allocate memory",image);)
             }n1           (void) strcpy(image->comments,comment); 	         }0,     range=max_sample_value-min_sample_value;     if (range < 0)       range=max_sample_value;      q=image->pixels;     q->length=MaxRunlength; 
     method=0;h5     if ((samples_per_pixel > 1) || TIFFIsTiled(tiff))        {          method=2;SK         if ((samples_per_pixel >= 3) && (photometric == PHOTOMETRIC_RGB) &&r/             (interlace == PLANARCONFIG_CONTIG))+           method=1;        }      switch (method)      { 
       case 0:        {.         Quantum            *quantum_scanline;           register Quantum
           *r;   
         /*7           Convert TIFF image to PseudoClass MIFF image.r
         */!         image->class=PseudoClass;          image->colors=range+1;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));C         quantum_scanline=(Quantum *) malloc(width*sizeof(Quantum));)D         scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff)+1);8         if ((image->colormap == (ColorPacket *) NULL) ||5             (quantum_scanline == (Quantum *) NULL) ||x1             (scanline == (unsigned char *) NULL)))           {              TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);            } 
         /*           Create colormap.
         */         switch (photometric)	         { &           case PHOTOMETRIC_MINISBLACK:           { -             for (i=0; i < image->colors; i++) 
             {a6               image->colormap[i].red=(MaxRGB*i)/range;8               image->colormap[i].green=(MaxRGB*i)/range;7               image->colormap[i].blue=(MaxRGB*i)/range;b
             }              break;           }*&           case PHOTOMETRIC_MINISWHITE:           {+-             for (i=0; i < image->colors; i++)>
             { >               image->colormap[i].red=((range-i)*MaxRGB)/range;@               image->colormap[i].green=((range-i)*MaxRGB)/range;?               image->colormap[i].blue=((range-i)*MaxRGB)/range; 
             }              break;           } #           case PHOTOMETRIC_PALETTE:            {              unsigned short               *blue_colormap,                *green_colormap,               *red_colormap;  M             TIFFGetField(tiff,TIFFTAG_COLORMAP,&red_colormap,&green_colormap,                &blue_colormap);-             for (i=0; i < image->colors; i++) 
             { 3               image->colormap[i].red=(unsigned int)i0                 (red_colormap[i]*MaxRGB)/65535L;5               image->colormap[i].green=(unsigned int) 2                 (green_colormap[i]*MaxRGB)/65535L;4               image->colormap[i].blue=(unsigned int)1                 (blue_colormap[i]*MaxRGB)/65535L; 
             }              break;           }            default:             break;	         } 
         /*A           Convert image to PseudoClass runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         { 7           TIFFReadScanline(tiff,(char *) scanline,y,0);0           p=scanline;+           r=quantum_scanline;;"           switch (bits_per_sample)           {              case 1: 
             {                register int                 bit;  2               for (x=0; x < ((int) width-7); x+=8)               {+,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               } #               if ((width % 8) != 0)                  {)<                   for (bit=7; bit >= (8-(width % 8)); bit--)>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }i               break;
             }              case 2: 
             {+2               for (x=0; x < ((int) width-3); x+=4)               { %                 *r++=(*p >> 6) & 0x3;p%                 *r++=(*p >> 4) & 0x3;e%                 *r++=(*p >> 2) & 0x3;                   *r++=(*p) & 0x3;                 p++;               } #               if ((width % 4) != 0)m                 {*6                   for (i=3; i >= (4-(width % 4)); i--).                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }                break;
             }t             case 4:l
             {m2               for (x=0; x < ((int) width-1); x+=2)               {p%                 *r++=(*p >> 4) & 0xf;                   *r++=(*p) & 0xf;                 p++;               } #               if ((width % 2) != 0) '                 *r++=(*p++ >> 4) & 0xf;                break;
             },             case 8:(
             {-'               for (x=0; x < width; x++)                  *r++=(*p++);               break;
             }              case 16:
             {h0               for (x=0; x < image->columns; x++)               {c"                 ReadQuantum(*r,p);                 r++;               }                break;
             }              default:               break;           }            /*$             Transfer image scanline.           */           r=quantum_scanline;l,           for (x=0; x < image->columns; x++)           {d             index=(*r++);lH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {/(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {)                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)                       {b0                         free((char *) scanline);8                         free((char *) quantum_scanline);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);%                       }%5                     q=image->pixels+image->packets-1;                    }                  q->index=index;                  q->length=0;               }            } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }           free((char *) scanline);(         free((char *) quantum_scanline);(         if (image->class == PseudoClass)           {              SyncImage(image); $             CompressColormap(image);           }          break;       } 
       case 1:        { 
         /*7           Convert TIFF image to DirectClass MIFF image. 
         */K         scanline=(unsigned char *) malloc((TIFFScanlineSize(tiff) << 1)+1);%/         if (scanline == (unsigned char *) NULL)P           {e             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);            } G         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,F           &sample_info);         image->matte=(O           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA)); '         for (y=0; y < image->rows; y++)t	         { 7           TIFFReadScanline(tiff,(char *) scanline,y,0);e#           if (bits_per_sample == 4) 
             {t$               register unsigned char                 *r;n  +               width=TIFFScanlineSize(tiff);e!               p=scanline+width-1;o(               r=scanline+(width << 1)-1;-               for (x=0; x < (int) width; x++)v               {e'                 *r--=((*p) & 0xf) << 4;t,                 *r--=((*p >> 4) & 0xf) << 4;                 p--;               } 
             }            p=scanline; ,           for (x=0; x < image->columns; x++)           {e             ReadQuantum(red,p); !             ReadQuantum(green,p);m              ReadQuantum(blue,p);             index=0;             if (image->matte)a#               ReadQuantum(index,p);,N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {e(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {a                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));"B                     if (image->pixels == (RunlengthPacket *) NULL)                       { (                         TIFFClose(tiff);0                         free((char *) scanline);I                         PrematureExit("Unable to allocate memory",image);=                       } 5                     q=image->pixels+image->packets-1;f                   }=                 q->red=red;                  q->green=green;x                 q->blue=blue;;                 q->index=index;;                 q->length=0;               }e           }e7           ProgressMonitor(LoadImageText,y,image->rows);(	         }!          free((char *) scanline);         break;       }a
       case 2:%       default:       {          register uint32l
           *p,n           *pixels;  
         /*7           Convert TIFF image to DirectClass MIFF image. 
         */G         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,o           &sample_info);         image->matte=oO           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA));u         pixels=(uint32 *)oM           malloc((image->columns*image->rows+image->columns)*sizeof(uint32));&&         if (pixels == (uint32 *) NULL)           {              TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);t           } K         status=TIFFReadRGBAImage(tiff,image->columns,image->rows,pixels,0);          if (status == False)           { "             free((char *) pixels);             TIFFClose(tiff);8             PrematureExit("Unable to read image",image);           }r
         /*A           Convert image to DirectClass runlength-encoded packets.s
         */*         for (y=image->rows-1; y >= 0; y--)	         {s$           p=pixels+y*image->columns;,           for (x=0; x < image->columns; x++)           { &             red=UpScale(TIFFGetR(*p));(             green=UpScale(TIFFGetG(*p));'             blue=UpScale(TIFFGetB(*p)); E             index=(unsigned short) (image->matte ? TIFFGetA(*p) : 0);fN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {t(                 if (image->packets != 0)                   q++;!                 image->packets++;L.                 if (image->packets == packets)                   {)                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));sB                     if (image->pixels == (RunlengthPacket *) NULL)                       {e.                         free((char *) pixels);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);n                       }(5                     q=image->pixels+image->packets-1;+                   }                  q->red=red;r                 q->green=green;(                 q->blue=blue;(                 q->index=index;=                 q->length=0;               }s             p++;           }dC           ProgressMonitor(LoadImageText,image->rows-y,image->rows); 	         }e         free((char *) pixels);!         if (IsPseudoClass(image))SJ           QuantizeImage(image,(unsigned int) range,8,False,RGBColorspace);         break;       }"     },%     image->pixels=(RunlengthPacket *)pM       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));s     /*       Proceed to next image.     */"     if (image_info->subimage != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;#     status=TIFFReadDirectory(tiff);      if (status == True)t       {)
         /*#           Allocate image structure.(
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);l           }eB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }m   } while (status == True);n   TIFFClose(tiff);   if (image->temporary)%(     (void) remove(image_info->filename);+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }e #else 2 static Image *ReadTIFFImage(ImageInfo *image_info) { @   Warning("TIFF library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }e #endif T /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %  R e a d T I L E I m a g e                                                  %IO %                                                                             %tO %                                                                             %iO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %IH %  Function ReadTILEImage tiles a texture on an image.  It allocates theL %  memory necessary for the new Image structure and returns a pointer to the
 %  new image.i %h. %  The format of the ReadTILEImage routine is: %e& %      image=ReadTILEImage(image_info) % + %  A description of each parameter follows:g %fJ %    o image:  Function ReadTILEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.m %(A %    o image_info: Specifies a pointer to an ImageInfo structure.g %) %L */2 static Image *ReadTILEImage(ImageInfo *image_info) {n   Imagei     *image,r     *tiled_image;x     intf     x,     y;     unsigned int     height,l
     width;  $   tiled_image=ReadImage(image_info);$   if (tiled_image == (Image *) NULL)     return((Image *) NULL);n   /*     Allocate image structure.v   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*-     Determine width and height, e.g. 640x512.=   */   width=512;
   height=512;n(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);n   /*     Initialize Image structure.    */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;i   image->rows=height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)a3     malloc(image->packets*sizeof(RunlengthPacket));e0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);%   /*     Tile texture onto image.   */)   ProgressMonitor(LoadImageText,200,400); 2   for (y=0; y < image->rows; y+=tiled_image->rows):     for (x=0; x < image->columns; x+=tiled_image->columns)?       CompositeImage(image,ReplaceCompositeOp,tiled_image,x,y); )   ProgressMonitor(LoadImageText,400,400);N   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %  R e a d U Y V Y I m a g e                                                  %lO %                                                                             %sO %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %oI %  Function ReadUYVYImage reads an image in the UYVY (16bit/pixel) formatlG %  and returns it.  It allocates the memory necessary for the new Imageg4 %  structure and returns a pointer to the new image. %i- %  The format of the ReadYUVImage routine is:t %c& %      image=ReadUYVYImage(image_info) % + %  A description of each parameter follows:t % I %    o image:  Function ReadYUVImage returns a pointer to the image afternL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.x %,A %    o image_info: Specifies a pointer to an ImageInfo structure.k %; %  */2 static Image *ReadUYVYImage(ImageInfo *image_info) {a   Images     *image;      intg     x,     y;     register int     i;     register RunlengthPacket     *q;)     register unsigned char     *p;      unsigned charm     *uyvy_pixels;B     unsigned int     height, 
     width;     /*     Allocate image structure.e   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);_   /*     Open image file.   */6   (void) strcpy(image->filename,image_info->filename);-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) .     PrematureExit("Unable to open file",image)   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);,   for (i=0; i < x; i++)L     (void) fgetc(image->file);   /*     Read data.   */   image->columns=width;e   image->rows=height;e,   image->packets=image->columns*image->rows;   uyvy_pixels=(unsigned char *)(3     malloc((2*width*height)*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *)e3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if ((uyvy_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);nE   (void) ReadData((char *) uyvy_pixels,1,2*width*height,image->file);>   /*0     Accumulate UYVY, then upack into two pixels.   */   p=uyvy_pixels;   q=image->pixels;+   for (i=0; i < (image->packets >> 1); i++)t   {h     q->red=UpScale(p[1]);f     q->green=UpScale(p[0]);-     q->blue=UpScale(p[2]);     q->index=0;u     q->length=0;     q++;     q->red=UpScale(p[3]);-     q->green=UpScale(p[0]);m     q->blue=UpScale(p[2]);     q->index=0;n     q->length=0;     q++;	     p+=4;i     if (QuantumTick(i,image))t;       ProgressMonitor(LoadImageText,i,image->packets >> 1);l   }n   free((char *) uyvy_pixels);s+   TransformRGBImage(image,YCbCrColorspace);    CompressImage(image);b   return(image); }_ o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*O %                                                                             %*O %                                                                             % O %                                                                             %hO %   R e a d V I C A R I m a g e                                               %nO %                                                                             % O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c %rG %  Function ReadVICARImage reads a VICAR image file and returns it.  ItiK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %U/ %  The format of the ReadVICARImage routine is:g %f' %      image=ReadVICARImage(image_info)  % + %  A description of each parameter follows:  %nJ %    o image: Function ReadVICARImage returns a pointer to the image afterO %      reading.  A null image is returned if there is a a memory shortage or ifm  %      the image cannot be read. %f9 %    o filename: Specifies the name of the image to read.i %  %  */3 static Image *ReadVICARImage(ImageInfo *image_info)a {]   char     keyword[MaxTextLength],      value[MaxTextLength];g     ImageB     *image;o     int      c,     y;     long
     count;     register int     i,     x;     register RunlengthPacket     *q;l     register unsigned char     *p;i     unsigned char(     *vicar_pixels;     unsigned int     header_length,     status,      value_expected;      /*     Allocate image structure.l   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);i   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);e#   if (image->file == (FILE *) NULL)l/     PrematureExit("Unable to open file",image);    /*     Decode image header.   */   c=fgetc(image->file);D
   count=1;   if (c == EOF)p     {        DestroyImage(image);       return((Image *) NULL);Y     }A   header_length=0;;   while (isgraph(c) && ((image->columns*image->rows) == 0))    {g     if (!isalnum(c))       {          c=fgetc(image->file);m         count++;       }      else       {          register char 
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         {C.           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);p           count++;+         } while (isalnum(c) || (c == '_'));e         *p='\0';         value_expected=False; (         while (isspace(c) || (c == '='))	         {=           if (c == '=')               value_expected=True;           c=fgetc(image->file);            count++;	         }e$         if (value_expected == False)           continue;          p=value;         while (isalnum(c))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }k         *p='\0';
         /*2           Assign a value to the specified keyword.
         */1         if (strcmp(keyword,"LABEL_RECORDS") == 0)c3           header_length=(unsigned int) atoi(value); +         if (strcmp(keyword,"LBLSIZE") == 0) 3           header_length=(unsigned int) atoi(value);m0         if (strcmp(keyword,"RECORD_BYTES") == 0)4           image->columns=(unsigned int) atoi(value);&         if (strcmp(keyword,"NS") == 0)4           image->columns=(unsigned int) atoi(value);)         if (strcmp(keyword,"LINES") == 0) 1           image->rows=(unsigned int) atoi(value);r&         if (strcmp(keyword,"NL") == 0)1           image->rows=(unsigned int) atoi(value);u       }      while (isspace(c))     {e       c=fgetc(image->file);        count++;     }v   }m   /*      Read the rest of the header.   */   while (count < header_length)e   {n     c=fgetc(image->file);s     count++;   }    /*6     Verify that required image information is defined.   */(   if ((image->columns*image->rows) == 0).     PrematureExit("image size is zero",image);   /*     Create linear colormap.    */   image->class=PseudoClass;h   image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); #   for (i=0; i < image->colors; i++)    { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);    }    /*     Initialize image structure.u   */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); N   vicar_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (vicar_pixels == (unsigned char *) NULL))>5     PrematureExit("Unable to read image data",image);    /*6     Convert VICAR pixels to runlength-encoded packets.   */F   status=ReadData((char *) vicar_pixels,1,image->packets,image->file);   if (status == False);     PrematureExit("Insufficient image data in file",image);)   /*6     Convert VICAR pixels to runlength-encoded packets.   */   p=vicar_pixels;    q=image->pixels;!   for (y=0; y < image->rows; y++)    {)&     for (x=0; x < image->columns; x++)     { #       q->index=(unsigned short) *p;        q->length=0;
       p++;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) vicar_pixels);   SyncImage(image);a   CompressColormap(image);   CompressImage(image);    CloseImage(image);   return(image); })   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d V I D I m a g e                                                    %oO %                                                                             % O %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %=L %  Function ReadVIDImage reads one of more images and creates a Visual ImageG %  Directory file.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadVIDImage routine is:e %)% %      image=ReadVIDImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadVIDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.d %aA %    o image_info: Specifies a pointer to an ImageInfo structure.r %e %o */1 static Image *ReadVIDImage(ImageInfo *image_info)f {m #define ClientName  "montage"      char     **filelist,      **list,*     *resource_value;  	   Displayg
     *display;P     ImageS     *image,s
     **images;      ImageInfog     local_info;n     intu     number_files;      register int     i,     j;     XMontageInfo     montage_info;      XResourceInfol     resource_info;  
   XrmDatabasec     resource_database;     /*     Expand the filename.   */(   list=(char **) malloc(sizeof(char *));   if (list == (char **) NULL)T     {E7       Warning("Memory allocation error",(char *) NULL);_       return((Image *) NULL);      } :   list[0]=(char *) malloc(strlen(image_info->filename)+1);   if (list[0] == (char *) NULL)g     {n7       Warning("Memory allocation error",(char *) NULL);e       return((Image *) NULL);      } .   (void) strcpy(list[0],image_info->filename);   number_files=1;o   filelist=list;+   ExpandFilenames(&number_files,&filelist);    if (number_files == 0)     {i=       Warning("VID translation failed",image_info->filename);d       return((Image *) NULL);g     }n   /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));     if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);-&       for (i=0; i < number_files; i++)#         free((char *) filelist[i]);e       free((char *) filelist);       return((Image *) NULL);g     }    /*     Open X server connection.U   */7   resource_info.background_color=DefaultTileBackground;F/   resource_info.border_color=DefaultTileBorder; :   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground; &   resource_info.gravity=CenterGravity;3   resource_info.image_geometry=DefaultTileGeometry;e-   resource_info.matte_color=DefaultTileMatte;t$   resource_info.title=(char *) NULL;0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {/       /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);(       /*3         Get user defaults from X resource database.e       */B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);L       resource_info.background_color=XGetResourceInstance(resource_database,7         ClientName,"background",DefaultTileBackground);%D       resource_value=XGetResourceClass(resource_database,ClientName,.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,7         ClientName,"foreground",DefaultTileForeground); J       resource_info.image_geometry=XGetResourceInstance(resource_database,8         ClientName,"imageGeometry",DefaultTileGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database, 2         ClientName,"mattecolor",DefaultTileMatte);       XCloseDisplay(display);%     }%   /*/     Read each image and convert them to a tile.a   */   j=0;"   for (i=0; i < number_files; i++)   {      local_info=(*image_info);w)     if (local_info.size == (char *) NULL)t3       local_info.size=resource_info.image_geometry;g$     local_info.filename=filelist[i];     *local_info.magick='\0';!     image=ReadImage(&local_info);o     free((char *) filelist[i]);       if (image == (Image *) NULL)       continue;      image->scene=j;l     LabelImage(image,"%f");iF     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)(       DescribeImage(image,stderr,False);     images[j]=image;     j++;2     ProgressMonitor(LoadImageText,i,number_files);   }a   free((char *) filelist);   /*&     Create the visual image directory.   */!   XGetMontageInfo(&montage_info);    montage_info.number_tiles=j;   image=(Image *) NULL;e%   if (montage_info.number_tiles != 0) 
     image=N       XMontageImage(images,&resource_info,&montage_info,image_info->filename);   free((char *) images);   if (image == (Image *) NULL)     {m=       Warning("VID translation failed",image_info->filename);e       return((Image *) NULL);      }g   free((char *) list[0]);    free((char *) list);   return(image); }  e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             % O %                                                                             %)O %                                                                             % O %   R e a d V I F F I m a g e                                                 %tO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %cM %  Function ReadVIFFImage reads a Khoros Visualization image file and returnsnI %  it.  It allocates the memory necessary for the new Image structure and+& %  returns a pointer to the new image. %l. %  The format of the ReadVIFFImage routine is: %'& %      image=ReadVIFFImage(image_info) %u+ %  A description of each parameter follows:c %'I %    o image: Function ReadVIFFImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or ifn  %      the image cannot be read. %m9 %    o filename: Specifies the name of the image to read.u %  %  */2 static Image *ReadVIFFImage(ImageInfo *image_info) {t #define VFF_CM_genericRGB  15R #define VFF_CM_ntscRGB  1  #define VFF_CM_NONE  0 #define VFF_DEP_DECORDER  0x4s #define VFF_DEP_NSORDER  0x8 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1  #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_MS_SHARED  3 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1I #define VFF_TYP_2_BYTE  2E #define VFF_TYP_4_BYTE  4m     typedef struct _ViffHeader   {      unsigned chart       identifier,1       file_type,       release,       version,       machine_dependency,        reserve[3];l       char       comment[512];r       unsigned longM       rows,i       columns,       subrows;       long       x_offset,        y_offset;a  	     float        x_pixel_size,        y_pixel_size;e       unsigned longg       location_type,       location_dimension,=       number_of_images,        number_data_bands,       data_storage_type,       data_encode_scheme,m       map_scheme,n       map_storage_type,        map_rows,z       map_columns,       map_subrows,       map_enable,        maps_per_cycle,        color_space_model;   } ViffHeader;a     Image*     *image;)     register int     bit,     i,     x,     y;     register Quantum     *p;c     register RunlengthPacket     *q;n     unsigned char      buffer[7],     *viff_pixels;c     unsigned int     bytes_per_pixel,     status;m     unsigned long      packets;     ViffHeader     viff_header;     /*     Allocate image structure.=   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);=#   if (image->file == (FILE *) NULL)g/     PrematureExit("Unable to open file",image);a   /*"     Read VIFF header (1024 bytes).   */D   status=ReadData((char *) &viff_header.identifier,1,1,image->file);   do   {t     /*       Verify VIFF identifier.!     */N     if ((status == False) || ((unsigned char) viff_header.identifier != 0xab))/       PrematureExit("Not a VIFF raster",image);      /*       Initialize VIFF image.     */5     (void) ReadData((char *) buffer,1,7,image->file);M$     viff_header.file_type=buffer[0];"     viff_header.release=buffer[1];"     viff_header.version=buffer[2];-     viff_header.machine_dependency=buffer[3];=D     (void) ReadData((char *) viff_header.comment,1,512,image->file);"     viff_header.comment[511]='\0';.     if ((int) strlen(viff_header.comment) > 4)       {           image->comments=(char *)N           malloc((unsigned int) (strlen(viff_header.comment)+1)*sizeof(char));-         if (image->comments == (char *) NULL)g;           PrematureExit("Unable to allocate memory",image); ;         (void) strcpy(image->comments,viff_header.comment);(       } ?     if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || <         (viff_header.machine_dependency == VFF_DEP_NSORDER))       {o7         viff_header.rows=LSBFirstReadLong(image->file); :         viff_header.columns=LSBFirstReadLong(image->file);:         viff_header.subrows=LSBFirstReadLong(image->file);;         viff_header.x_offset=LSBFirstReadLong(image->file); ;         viff_header.y_offset=LSBFirstReadLong(image->file);eG         viff_header.x_pixel_size=(float) LSBFirstReadLong(image->file);tG         viff_header.y_pixel_size=(float) LSBFirstReadLong(image->file);o@         viff_header.location_type=LSBFirstReadLong(image->file);E         viff_header.location_dimension=LSBFirstReadLong(image->file); C         viff_header.number_of_images=LSBFirstReadLong(image->file);gD         viff_header.number_data_bands=LSBFirstReadLong(image->file);D         viff_header.data_storage_type=LSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=LSBFirstReadLong(image->file); =         viff_header.map_scheme=LSBFirstReadLong(image->file);pC         viff_header.map_storage_type=LSBFirstReadLong(image->file);<;         viff_header.map_rows=LSBFirstReadLong(image->file);e>         viff_header.map_columns=LSBFirstReadLong(image->file);>         viff_header.map_subrows=LSBFirstReadLong(image->file);=         viff_header.map_enable=LSBFirstReadLong(image->file);(A         viff_header.maps_per_cycle=LSBFirstReadLong(image->file);pD         viff_header.color_space_model=LSBFirstReadLong(image->file);       }      else       {-7         viff_header.rows=MSBFirstReadLong(image->file);g:         viff_header.columns=MSBFirstReadLong(image->file);:         viff_header.subrows=MSBFirstReadLong(image->file);;         viff_header.x_offset=MSBFirstReadLong(image->file); ;         viff_header.y_offset=MSBFirstReadLong(image->file); G         viff_header.x_pixel_size=(float) MSBFirstReadLong(image->file); G         viff_header.y_pixel_size=(float) MSBFirstReadLong(image->file);)@         viff_header.location_type=MSBFirstReadLong(image->file);E         viff_header.location_dimension=MSBFirstReadLong(image->file);;C         viff_header.number_of_images=MSBFirstReadLong(image->file);eD         viff_header.number_data_bands=MSBFirstReadLong(image->file);D         viff_header.data_storage_type=MSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=MSBFirstReadLong(image->file);n=         viff_header.map_scheme=MSBFirstReadLong(image->file);pC         viff_header.map_storage_type=MSBFirstReadLong(image->file);g;         viff_header.map_rows=MSBFirstReadLong(image->file); >         viff_header.map_columns=MSBFirstReadLong(image->file);>         viff_header.map_subrows=MSBFirstReadLong(image->file);=         viff_header.map_enable=MSBFirstReadLong(image->file);;A         viff_header.maps_per_cycle=MSBFirstReadLong(image->file);gD         viff_header.color_space_model=MSBFirstReadLong(image->file);       }      for (i=0; i < 420; i++)         (void) fgetc(image->file);     /*.       Verify that we can read this VIFF image.     */4     if ((viff_header.columns*viff_header.rows) == 0)G       PrematureExit("Image column or row size is not supported",image); 9     if ((viff_header.data_storage_type != VFF_TYP_BIT) &&e<         (viff_header.data_storage_type != VFF_TYP_1_BYTE) &&<         (viff_header.data_storage_type != VFF_TYP_2_BYTE) &&:         (viff_header.data_storage_type != VFF_TYP_4_BYTE))@       PrematureExit("Data storage type is not supported",image);6     if (viff_header.data_encode_scheme != VFF_DES_RAW)C       PrematureExit("Data encoding scheme is not supported",image);l<     if ((viff_header.map_storage_type != VFF_MAPTYP_NONE) &&<         (viff_header.map_storage_type != VFF_MAPTYP_1_BYTE))?       PrematureExit("Map storage type is not supported",image); 9     if ((viff_header.color_space_model != VFF_CM_NONE) &&m<         (viff_header.color_space_model != VFF_CM_ntscRGB) &&=         (viff_header.color_space_model != VFF_CM_genericRGB)) ?       PrematureExit("Colorspace model is not supported",image); 6     if (viff_header.location_type != VFF_LOC_IMPLICIT)       {gB         Warning("Location type is not supported",image->filename);         DestroyImages(image);          return((Image *) NULL);g       }n*     if (viff_header.number_of_images != 1)?       PrematureExit("Number of images is not supported",image); #     switch (viff_header.map_scheme)i     {d       case VFF_MS_NONE:c       { .         if (viff_header.number_data_bands < 3)           {g             /*'               Create linear color ramp.              */=             if (viff_header.data_storage_type == VFF_TYP_BIT)                image->colors=2;             elseN               image->colors=1 << (viff_header.number_data_bands*QuantumDepth);+             image->colormap=(ColorPacket *) 8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image);f-             for (i=0; i < image->colors; i++)x
             { B               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1); 
             }-           }          break;       }-       case VFF_MS_ONEPERBAND:        case VFF_MS_SHARED:        {t         unsigned char            *viff_colormap;h  
         /*$           Read VIFF raster colormap.
         */.         image->colors=viff_header.map_columns;'         image->colormap=(ColorPacket *)c4           malloc(image->colors*sizeof(ColorPacket));'         viff_colormap=(unsigned char *) 6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||6             (viff_colormap == (unsigned char *) NULL));           PrematureExit("Unable to allocate memory",image); L         (void) ReadData((char *) viff_colormap,1,image->colors,image->file);)         for (i=0; i < image->colors; i++) 	         {e;           image->colormap[i].red=UpScale(viff_colormap[i]);v=           image->colormap[i].green=UpScale(viff_colormap[i]); <           image->colormap[i].blue=UpScale(viff_colormap[i]);	         } %         if (viff_header.map_rows > 1)            {(P             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++)gA               image->colormap[i].green=UpScale(viff_colormap[i]);            }h%         if (viff_header.map_rows > 2)            { P             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++) @               image->colormap[i].blue=UpScale(viff_colormap[i]);           }k%         free((char *) viff_colormap);x         break;       }e       default:>         PrematureExit("Colormap type is not supported",image);     }      /*       Allocate VIFF pixels.      */     bytes_per_pixel=1;8     if (viff_header.data_storage_type == VFF_TYP_2_BYTE)       bytes_per_pixel=2;8     if (viff_header.data_storage_type == VFF_TYP_4_BYTE)       bytes_per_pixel=4;5     if (viff_header.data_storage_type == VFF_TYP_BIT) >       packets=((viff_header.columns+7) >> 3)*viff_header.rows;     else       packets=K         viff_header.columns*viff_header.rows*viff_header.number_data_bands; !     viff_pixels=(unsigned char *)t6       malloc(bytes_per_pixel*packets*sizeof(Quantum));.     if (viff_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);(P     (void) ReadData((char *) viff_pixels,bytes_per_pixel,(unsigned int) packets,       image->file); *     switch (viff_header.data_storage_type)     {e	       inti         max_value,         min_value,         value;         register Quantum         *q;r         unsigned long          scale_factor;t         case VFF_TYP_1_BYTE:       {          register unsigned char
           *p;            if (QuantumDepth == 8)           break;
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=viff_pixels;"         q=(Quantum *) viff_pixels;         p+=packets-1;          q+=packets-1;&#         for (i=0; i < packets; i++)l	         {            value=UpScale(*p);           *q=(Quantum) value;            p--;           q--;	         }          break;       }(       case VFF_TYP_2_BYTE:       {          register short int
           *p;   
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||c@             (viff_header.machine_dependency == VFF_DEP_NSORDER))3           MSBFirstOrderShort((char *) &viff_header,=6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor. 
         */$         p=(short int *) viff_pixels;         max_value=(*p);          min_value=(*p);r#         for (i=0; i < packets; i++)g	         {            if (*p > max_value)              max_value=(*p);            else             if (*p < min_value)k               min_value=(*p);d           p++;	         } 1         if ((min_value == 0) && (max_value == 0))            scale_factor=0;a         else%           if (min_value == max_value) 
             {l5               scale_factor=UpShift(MaxRGB)/min_value;;               min_value=0;
             })           else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value); 
         /*.           Scale integer pixels to [0..MaxRGB].
         */$         p=(short int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++)t	         {*7           value=DownShift((*p-min_value)*scale_factor);=           if (value > MaxRGB)r             value=MaxRGB;            else             if (value < 0)               value=0;           *q=(Quantum) value;m           p++;           q++;	         }          break;       }        case VFF_TYP_4_BYTE:       {R         register int
           *p;i  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||o@             (viff_header.machine_dependency == VFF_DEP_NSORDER))2           MSBFirstOrderLong((char *) &viff_header,6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor. 
         */         p=(int *) viff_pixels;         max_value=(*p);>         min_value=(*p);n#         for (i=0; i < packets; i++)m	         {            if (*p > max_value)              max_value=(*p);            else             if (*p < min_value)m               min_value=(*p);a           p++;	         };1         if ((min_value == 0) && (max_value == 0))%           scale_factor=0;%         else%           if (min_value == max_value) 
             { 5               scale_factor=UpShift(MaxRGB)/min_value;                min_value=0;
             }            else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value); 
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=(int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++) 	         { 7           value=DownShift((*p-min_value)*scale_factor);            if (value > MaxRGB)              value=MaxRGB;            else             if (value < 0)               value=0;#           *q=(unsigned char) value;%           p++;           q++;	         }d         break;       }      }u     /*!       Initialize image structure.s     */6     image->matte=(viff_header.number_data_bands == 4);     image->class= F       (viff_header.number_data_bands < 3 ? PseudoClass : DirectClass);$     image->columns=viff_header.rows;$     image->rows=viff_header.columns;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)l5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*=       Convert VIFF raster image to runlength-encoded packets.n     */     p=(Quantum *) viff_pixels;     q=image->pixels;5     if (viff_header.data_storage_type == VFF_TYP_BIT)g       {          unsigned int           polarity;d  
         /*E           Convert bitmap scanline to runlength-encoded color packets.l
         */H         polarity=(viff_header.machine_dependency == VFF_DEP_DECORDER) ||>           (viff_header.machine_dependency == VFF_DEP_NSORDER);'         for (y=0; y < image->rows; y++),	         {o           /*G             Convert bitmap scanline to runlength-encoded color packets.            */3           for (x=0; x < (image->columns >> 3); x++)i           { '             for (bit=0; bit < 8; bit++)i
             {eE               q->index=((*p) & (0x01 << bit) ? polarity : !polarity);g               q->length=0;               q++;
             }              p++;           }*(           if ((image->columns % 8) != 0)
             {e<               for (bit=0; bit < (image->columns % 8); bit++)               {aG                 q->index=((*p) & (0x01 << bit) ? polarity : !polarity);                  q->length=0;                 q++;               }i               p++;
             })7           ProgressMonitor(LoadImageText,y,image->rows); 	         }r       }s     else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++)r	         {            /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {g             q->index=(*p++);             q->length=0;             q++;           }d7           ProgressMonitor(LoadImageText,y,image->rows); 	         } 
       else	         {i           unsigned long              offset;c             /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           offset=image->columns*image->rows;)           for (y=0; y < image->rows; y++)            {m.             for (x=0; x < image->columns; x++)
             {=               q->red=(*p);%               q->green=(*(p+offset)); &               q->blue=(*(p+offset*2));%               if (image->colors != 0)c                 { 5                   q->red=image->colormap[q->red].red;e;                   q->green=image->colormap[q->green].green;e8                   q->blue=image->colormap[q->blue].blue;                 }aM               q->index=(unsigned short) (image->matte ? (*(p+offset*3)) : 0);p               q->length=0;               p++;               q++;
             } 9             ProgressMonitor(LoadImageText,y,image->rows);            } 	         }x     free((char *) viff_pixels);=$     if (image->class == PseudoClass)       {o         SyncImage(image);s          CompressColormap(image);       }n     CompressImage(image);(     /*       Proceed to next image.     */F     status=ReadData((char *) &viff_header.identifier,1,1,image->file);=     if ((status == True) && (viff_header.identifier == 0xab))        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {-!             DestroyImages(image);)#             return((Image *) NULL);+           }gB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }sA   } while ((status == True) && (viff_header.identifier == 0xab));a+   while (image->previous != (Image *) NULL)(     image=image->previous;   CloseImage(image);   return(image); }l d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %NO %                                                                             %eO %                                                                             % O %   R e a d X I m a g e                                                       % O %                                                                             % O %                                                                             %mO %                                                                             %/O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %r8 %  Procedure ReadXImage reads an image from an X window. %)+ %  The format of the ReadXImage routine is:  % @ %      image=ReadXImage(image_info,frame,borders,screen,descend) %n+ %  A description of each parameter follows:l %mA %    o image_info: Specifies a pointer to an ImageInfo structure.a %PL %    o frame: Specifies whether to include the window manager frame with the
 %      image.S %eE %    o borders: Specifies whether borders pixels are to be saved with5 %      the image.t %pN %    o screen: Specifies whether the GetImage request used to obtain the imageO %      should be done on the root window, rather than directly on the specifiede %      window. % O %    o descend: If this option is zero, check to see if the WM_COLORMAP_WINDOWSsJ %      property is set or if XListInstalledColormaps returns more than oneG %      colormap.  If so, the image is obtained by descending the window(= %      hierarchy and reading each subwindow and its colormap., %e %  */y Image *ReadXImage(ImageInfo *image_info,unsigned int frame,unsigned int borders,unsigned int screen,unsigned int descend)  { 
   Colormap     *colormaps;s  	   Displayl
     *display;s     Imager     *image;.     int/     status,)     x;     RectangleInfoe     crop_info;     Window     *children,     client,      prior_target,g	     root,      target;n     XTextPropertyn     window_name;     /*     Open X server connection.;   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {_.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));a       return((Image *) NULL);      }u   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);e   /*     Select target window.i   */   crop_info.x=0;   crop_info.y=0;   crop_info.width=0;   crop_info.height=0;=4   root=XRootWindow(display,XDefaultScreen(display));   target=(Window) NULL;o0   if ((image_info->filename != (char *) NULL) &&&       (*image_info->filename != '\0'))8     if (Latin1Compare(image_info->filename,"root") == 0)       target=root;     else       { 
         /*&           Select window by ID or name.
         */+         if (isdigit(*image_info->filename)) O           target=XWindowByID(display,root,(Window) strtol(image_info->filename,              (char **) NULL,0));R$         if (target == (Window) NULL)B           target=XWindowByName(display,root,image_info->filename);$         if (target == (Window) NULL)M           Warning("No window with specified id exists",image_info->filename);        }      /*>     If target window is not defined, interactively select one.   */   prior_target=target;   if (target == (Window) NULL)-     target=XSelectWindow(display,&crop_info);n!   client=target;   /* obsolete */I   if (target != root)u     {        unsigned int
         d;  B       status=XGetGeometry(display,target,&root,&x,&x,&d,&d,&d,&d);       if (status != 0)	         {R           for ( ; ; )e           {              Window               parent;                /*(               Find window manager frame.             */I             status=XQueryTree(display,target,&root,&parent,&children,&d);l8             if (status && (children != (Window *) NULL))'               XFree((char *) children); I             if (!status || (parent == (Window) NULL) || (parent == root))/               break;             target=parent;           }            /*             Get client window.           *//           client=XClientWindow(display,target);            if (!frame)              target=client;%           if (!frame && prior_target)(              target=prior_target;	         }      }u
   if (screen)L     { 	       intn
         y;         Window         child;         XWindowAttributesf         window_attributes;         /*1         Obtain window image directly from screen.I       */E       status=XGetWindowAttributes(display,target,&window_attributes);r       if (status == False)	         { M           Warning("Unable to read X window attributes",image_info->filename);s!           XCloseDisplay(display); !           return((Image *) NULL); 	         } B       XTranslateCoordinates(display,target,root,0,0,&x,&y,&child);       crop_info.x=x;       crop_info.y=y;.       crop_info.width=window_attributes.width;0       crop_info.height=window_attributes.height;       if (borders)	         {m           /*$             Include border in image.           */6           crop_info.x-=window_attributes.border_width;6           crop_info.y-=window_attributes.border_width;?           crop_info.width+=window_attributes.border_width << 1;)@           crop_info.height+=window_attributes.border_width << 1;	         }        target=root;     }*   if (descend)     {%	       int%         number_colormaps,%         number_windows;          /*N         If WM_COLORMAP_WINDOWS property is set or multiple colormaps, descend.       */       descend=False;       number_windows=0; M       status=XGetWMColormapWindows(display,target,&children,&number_windows); 3       if ((status == True) && (number_windows > 0)) 	         {            descend=True; $           XFree ((char *) children);	         } J       colormaps=XListInstalledColormaps(display,target,&number_colormaps);       if (number_colormaps > 0) 	         { #           if (number_colormaps > 1)              descend=True; $           XFree((char *) colormaps);	         }%     }%   /*+     Alert the user not to alter the screen.d   */   XBell(display,0);r   /*     Get image by window id.    */   XGrabServer(display);e8   image=XGetWindowImage(display,target,borders,descend);   XUngrabServer(display);m   if (image == (Image *) NULL)B     Warning("Unable to read X window image",image_info->filename);   else     {r:       (void) strcpy(image->filename,image_info->filename);<       if ((crop_info.width != 0) && (crop_info.height != 0))	         {A           Imaget             *cropped_image;s             /*<             Crop image as defined by the cropping rectangle.           */4           cropped_image=CropImage(image,&crop_info);.           if (cropped_image != (Image *) NULL)
             {e"               DestroyImage(image);"               image=cropped_image;
             } 	         } 5       status=XGetWMName(display,target,&window_name);        if (status == True)d	         {e8           if ((image_info->filename != (char *) NULL) &&.               (*image_info->filename == '\0'))
             {g               /**                 Initialize image filename.               */H               (void) strncpy(image->filename,(char *) window_name.value,*                 (int) window_name.nitems);7               image->filename[window_name.nitems]='\0';g
             } ,           XFree((void *) window_name.value);	         }=     }    /*     Alert the user we're done.   */   XBell(display,0);    XBell(display,0);r   CompressImage(image);&   XCloseDisplay(display);0   return(image); }v ) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %aO %  R e a d X B M I m a g e                                                    %gO %                                                                             %xO %                                                                             %UO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%x %,K %  Function ReadXBMImage reads an X11 bitmap image file and returns it.  ItlK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %G- %  The format of the ReadXBMImage routine is:o %y% %      image=ReadXBMImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadXBMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.o %o %m */7 static int XBMInteger(FILE *file,short int *hex_digits)  {e   intt     c,	     flag, 
     value;  
   value=0;	   flag=0;R
   for ( ; ; )R   {G     c=getc(file);      if (c == EOF)        {-         value=(-1);g         break;       }+     c&=0xff;     if (isxdigit(c))       {g)         value=(value << 4)+hex_digits[c];d         flag++;;         continue;x       } $     if ((hex_digits[c]) < 0 && flag)       break;   }=   return(value); }-  1 static Image *ReadXBMImage(ImageInfo *image_info)) {    char     buffer[MaxTextLength],     name[MaxTextLength];     Image      *image;g     register int     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;b     register unsigned short 
     index;     short intx     hex_digits[256];     unsigned char-     bit,
     *data;     unsigned int	     byte,+     bytes_per_line,      packets,     padding,
     value,     version;     /*     Allocate image structure.d   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);-#   if (image->file == (FILE *) NULL)p/     PrematureExit("Unable to open file",image);d   /*     Read X bitmap header.    */D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)?     if (sscanf(buffer,"#define %*32s %u",&image->columns) == 1)c       break;D   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)<     if (sscanf(buffer,"#define %*32s %u",&image->rows) == 1)       break;   /*     Scan until hex digits.   */
   version=11;dD   while (fgets(buffer,MaxTextLength-1,image->file) != (char *) NULL)   {g7     if (sscanf(buffer,"static short %s = {",name) == 1)-       version=10;o     elseA       if (sscanf(buffer,"static unsigned char %s = {",name) == 1)p         version=11; 
       else:         if (sscanf(buffer,"static char %s = {",name) == 1)           version=11;h         else           continue;(*     p=(unsigned char *) strrchr(name,'_');$     if (p == (unsigned char *) NULL)       p=(unsigned char *) name;%     else
       p++;)     if (strcmp("bits[]",(char *) p) == 0)        break;   } G   if ((image->columns == 0) || (image->rows == 0) || feof(image->file)) A     PrematureExit("XBM file is not in the correct format",image);    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    padding=0;O   if ((image->columns % 16) && ((image->columns % 16) < 9)  && (version == 10))      padding=1;.   bytes_per_line=(image->columns+7)/8+padding;%   packets=bytes_per_line*image->rows;%A   data=(unsigned char *) malloc(packets*sizeof(unsigned char *));%4   if ((image->pixels == (RunlengthPacket *) NULL) ||'       (data == (unsigned char *) NULL))t5     PrematureExit("Unable to allocate memory",image);    /*     Create colormap.   */   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);o   image->colormap[0].red=0;;   image->colormap[0].green=0;L   image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;h   /*     Initialize hex values.   */   hex_digits['0']=0;   hex_digits['1']=1;   hex_digits['2']=2;   hex_digits['3']=3;   hex_digits['4']=4;   hex_digits['5']=5;   hex_digits['6']=6;   hex_digits['7']=7;   hex_digits['8']=8;   hex_digits['9']=9;   hex_digits['A']=10;r   hex_digits['B']=11;t   hex_digits['C']=12;    hex_digits['D']=13;d   hex_digits['E']=14;o   hex_digits['F']=15;    hex_digits['a']=10;y   hex_digits['b']=11;n   hex_digits['c']=12;e   hex_digits['d']=13;r   hex_digits['e']=14;    hex_digits['f']=15;h   hex_digits['x']=0;   hex_digits[' ']=(-1);    hex_digits[',']=(-1);    hex_digits['}']=(-1);    hex_digits['\n']=(-1);   hex_digits['\t']=(-1);   /*     Read hex image data.   */	   p=data;[   if (version == 10)"     for (x=0; x < packets; (x+=2))     { /       value=XBMInteger(image->file,hex_digits);t       *p++=value;h/       if (!padding || ((x+2) % bytes_per_line))          *p++=value >> 8;     }]   else     for (x=0; x < packets; x++)      { /       value=XBMInteger(image->file,hex_digits);_       *p++=value;l     }s   /*8     Convert X bitmap image to runlength-encoded packets.   */	   byte=0; 	   p=data;e   q=image->pixels;!   for (y=0; y < image->rows; y++)    {l
     bit=0;&     for (x=0; x < image->columns; x++)     {t       if (bit == 0)r         byte=(*p++);"       index=(byte & 0x01) ? 0 : 1;       q->index=index;        q->length=0;
       q++;       bit++;       byte>>=1;e       if (bit == 8)          bit=0;     }g1     ProgressMonitor(LoadImageText,y,image->rows);    }n   SyncImage(image);    CompressImage(image);    CloseImage(image);   free((char *) data);   return(image); }f   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %hO %                                                                             % O %                                                                             %wO %  R e a d X C I m a g e                                                      %RO %                                                                             %-O %                                                                             %eO %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % G %  Function ReadXCImage creates a constant image and initializes to the H %  X server color as specified by the filename.  It allocates the memoryI %  necessary for the new Image structure and returns a pointer to the newd	 %  image.= %F, %  The format of the ReadXCImage routine is: %c$ %      image=ReadXCImage(image_info) %)+ %  A description of each parameter follows:d %iH %    o image:  Function ReadXCImage returns a pointer to the image afterL %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.m %= %F */0 static Image *ReadXCImage(ImageInfo *image_info) {l   Imagen     *image;g     int;     x,     y;     register int     i;     register RunlengthPacket     *q;)     unsigned int     height,p
     width;     XColor
     color;     /*     Allocate image structure.3   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);c   /*-     Determine width and height, e.g. 640x512.R   */   width=512;
   height=512;,(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);(   /*     Initialize Image structure.i   */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;l   image->rows=height;eE   image->packets=((image->columns*image->rows-1)/(MaxRunlength+1))+1;e#   image->pixels=(RunlengthPacket *)F3     malloc(image->packets*sizeof(RunlengthPacket));=   image->class=PseudoClass;)   image->colors=1;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Initialize colormap.   */:   (void) XQueryColorDatabase(image_info->filename,&color);/   image->colormap[0].red=XDownScale(color.red);u3   image->colormap[0].green=XDownScale(color.green);.1   image->colormap[0].blue=XDownScale(color.blue);=   q=image->pixels;$   for (i=0; i < image->packets; i++)   {      q->index=0;i     q->length=MaxRunlength;      q++;     if (QuantumTick(i,image))e6       ProgressMonitor(LoadImageText,i,image->packets);   }(   q--;M   q->length=image->columns*image->rows-(MaxRunlength+1)*(image->packets-1)-1;k   SyncImage(image);a   return(image); }- x /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             %oO %                                                                             %eO %                                                                             % O %  R e a d X P M I m a g e                                                    %nO %                                                                             %aO %                                                                             %mO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%1 %)K %  Function ReadXBMImage reads an X11 pixmap image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns aa %  pointer to the new image. %t- %  The format of the ReadXPMImage routine is:  %&% %      image=ReadXPMImage(image_info)t %y+ %  A description of each parameter follows:l %tI %    o image:  Function ReadXPMImage returns a pointer to the image after;L %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. %DA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasXPM  #include "xpm.h"1 static Image *ReadXPMImage(ImageInfo *image_info)  {    char     *xpm_buffer;  	   Display 
     *display;      Image      *image;=     int      length,r     status,      x,     y;     register char      *q;      register int     i;     register RunlengthPacket     *p;r     register unsigned long
     pixel;     XColor     *colors;     XImage     *matte_image,=     *ximage;     XpmAttributes      xpm_attributes;      XResourceInfo3     resource_info;  
   XrmDatabase      resource_database;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);&   /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL)(/     PrematureExit("Unable to open file",image);    /*     Read XPM file.   */   length=MaxTextLength;i2   xpm_buffer=(char *) malloc(length*sizeof(char));"   if (xpm_buffer != (char *) NULL)     {n       q=xpm_buffer; C       while (fgets(q,MaxTextLength-1,image->file) != (char *) NULL)        {e         q+=strlen(q); 2         if ((q-xpm_buffer+MaxTextLength) > length)           {              *q='\0';             length<<=1;              xpm_buffer=(char *)x?               realloc((char *) xpm_buffer,length*sizeof(char)); ,             if (xpm_buffer == (char *) NULL)               break;,             q=xpm_buffer+strlen(xpm_buffer);           }x       }-     } "   if (xpm_buffer == (char *) NULL)5     PrematureExit("Unable to allocate memory",image);%   CloseImage(image);   /*     Open X server connection.%   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name)); 8       PrematureExit("Unable to create XPM image",image);     }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */#   visual_info=(XVisualInfo *) NULL;%$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)aM     Warning("Unable to create standard colormap","Memory allocation failed");o   else     {y       /*         Initialize visual info.a       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info);o.       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;i     } 1   if ((map_info == (XStandardColormap *) NULL) ||r,       (visual_info == (XVisualInfo *) NULL))     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);8       PrematureExit("Unable to create XPM image",image);     }e   /*     Initialize X colormap.   */-   map_info->colormap=XCreateColormap(display, A     XRootWindow(display,visual_info->screen),visual_info->visual,;>     visual_info->class == DirectColor ? AllocAll : AllocNone);,   if (map_info->colormap == (Colormap) NULL)     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);7       PrematureExit("Unable to create colormap",image);i     }    /*     Initialize XPM attributes.   */L   xpm_attributes.valuemask=XpmColorKey | XpmColormap | XpmDepth | XpmVisual;,   xpm_attributes.visual=visual_info->visual;-   xpm_attributes.colormap=map_info->colormap;n*   xpm_attributes.depth=visual_info->depth;%   xpm_attributes.color_key=XPM_COLOR;R   /*>     Read in a file in the XPM format into a X image structure.   */J   status=XpmCreateImageFromBuffer(display,xpm_buffer,&ximage,&matte_image,     &xpm_attributes);c   if (status != XpmSuccess))     {fF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);8       PrematureExit("Unable to create XPM image",image);     }e   free((char *) xpm_buffer);%   XpmFreeAttributes(&xpm_attributes);B   /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {)F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);7       PrematureExit("Unable to read X colormap",image);)     }m,   if ((visual_info->class != DirectColor) &&(       (visual_info->class != TrueColor))2     for (i=0; i < visual_info->colormap_size; i++)     {g       colors[i].pixel=i;       colors[i].pad=0;     }    else     {i       unsigned long 
         blue,          blue_bit,a         green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0;.C       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1);bI       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1); F       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       {a+         colors[i].pixel=red | green | blue;d         colors[i].pad=0;         red+=red_bit;((         if (red > visual_info->red_mask)           red=0;         green+=green_bit; ,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit;t*         if (blue > visual_info->blue_mask)           blue=0;        }l     } M   XQueryColors(display,map_info->colormap,colors,visual_info->colormap_size);F   /*#     Convert X image to MIFF format.    */O   if ((visual_info->class != TrueColor) && (visual_info->class != DirectColor))      image->class=PseudoClass;    image->columns=ximage->width;R   image->rows=ximage->height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));o0   if (image->pixels == (RunlengthPacket *) NULL)     {        free((char *) colors);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);7       PrematureExit("Unable to allocate memory",image);e     }    p=image->pixels;   switch (image->class)i   {>     case DirectClass:i     {s       register unsigned long         color,         index;         unsigned longU         blue_mask,         blue_shift,f         green_mask,(         green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;e       red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;o         red_shift++;       } )       green_mask=visual_info->green_mask;_       green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;e         green_shift++;       }p'       blue_mask=visual_info->blue_mask;d       blue_shift=0;a%       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }h       /*/         Convert X image to DirectClass packets.        */-       if ((visual_info->colormap_size > 0) && .           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++) 	         {+,           for (x=0; x < image->columns; x++)           {o(             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red);e6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green);g4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);              p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows);(	         }4
       else'         for (y=0; y < image->rows; y++))	         { ,           for (x=0; x < image->columns; x++)           {n(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;7             p->red=XDownScale((color*65535L)/red_mask);l6             color=(pixel >> green_shift) & green_mask;;             p->green=XDownScale((color*65535L)/green_mask);_4             color=(pixel >> blue_shift) & blue_mask;9             p->blue=XDownScale((color*65535L)/blue_mask);a             p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows);)	         }        break;     }d     case PseudoClass:      {        /*         Create colormap.       *//       image->colors=visual_info->colormap_size; P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {             free((char *) colors);J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);            XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL); 	         }o'       for (i=0; i < image->colors; i++))       {fG         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red); K         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green);/I         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);c       }=       /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++)&       { *         for (x=0; x < image->columns; x++)	         { :           p->index=(unsigned short) XGetPixel(ximage,x,y);           p->length=0;           p++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);=       }        SyncImage(image);)       break;     }h   }&%   if (matte_image != (XImage *) NULL)      {s       /*         Initialize image matte.s       */       image->class=DirectClass;e       image->matte=True;       p=image->pixels;%       for (y=0; y < image->rows; y++)x*         for (x=0; x < image->columns; x++)	         {U           p->index=Opaque;*           if (!XGetPixel(matte_image,x,y))!             p->index=Transparent;*           p++;	         }i!       XDestroyImage(matte_image);e     }t"   if (image->class == PseudoClass)     CompressColormap(image);   /*     Free resources.    */   free((char *) colors);   XDestroyImage(ximage);B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   CompressImage(image);>   return(image); }  #else 1 static Image *ReadXPMImage(ImageInfo *image_info)  { ?   Warning("XPM library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }  #endif a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             %cO %                                                                             %EO %  R e a d X W D I m a g e                                                    %rO %                                                                             % O %                                                                             %[O %                                                                             %BO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %-L %  Function ReadXWDImage reads an X Window System window dump image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadXWDImage routine is:a %i% %      image=ReadXWDImage(image_info)e %(+ %  A description of each parameter follows:l %aI %    o image:  Function ReadXWDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.m %- %l */1 static Image *ReadXWDImage(ImageInfo *image_info)  {+   Image      *image;      int_     status,      x,     y;     register int     i;     register RunlengthPacket     *q;r     register unsigned long
     pixel;     unsigned long      lsb_first;     unsigned int     packets;     unsigned short
     index;     XColor     *colors;     XImage     *ximage;     XWDFileHeader      header;i     /*     Allocate image structure.-   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);-   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);l#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);D   /*       Read in header information.   */?   status=ReadData((char *) &header,sz_XWDheader,1,image->file);x   if (status == False);     PrematureExit("Unable to read dump file header",image);p   /*@     Ensure the header byte-order is most-significant byte first.   */   lsb_first=1;   if (*(char *) &lsb_first) 5     MSBFirstOrderLong((char *) &header,sz_XWDheader);    /*:     Check to see if the dump file is in the proper format.   */.   if (header.file_version != XWD_FILE_VERSION)<     PrematureExit("XWD file format version mismatch",image);(   if (header.header_size < sz_XWDheader)8     PrematureExit("XWD header size is too small",image);,   packets=(header.header_size-sz_XWDheader);<   image->comments=(char *) malloc((packets+1)*sizeof(char));'   if (image->comments == (char *) NULL)m5     PrematureExit("Unable to allocate memory",image); B   status=ReadData((char *) image->comments,1,packets,image->file);    image->comments[packets]='\0';   if (status == False)F     PrematureExit("Unable to  read window name from dump file",image);   /*     Initialize the X image.    */+   ximage=(XImage *) malloc(sizeof(XImage));     if (ximage == (XImage *) NULL)5     PrematureExit("Unable to allocate memory",image); $   ximage->depth=header.pixmap_depth;&   ximage->format=header.pixmap_format;!   ximage->xoffset=header.xoffset;a   ximage->data=(char *) NULL;=$   ximage->width=header.pixmap_width;&   ximage->height=header.pixmap_height;'   ximage->bitmap_pad=header.bitmap_pad;x/   ximage->bytes_per_line=header.bytes_per_line;n'   ximage->byte_order=header.byte_order; )   ximage->bitmap_unit=header.bitmap_unit;m3   ximage->bitmap_bit_order=header.bitmap_bit_order;i/   ximage->bits_per_pixel=header.bits_per_pixel;%#   ximage->red_mask=header.red_mask;%'   ximage->green_mask=header.green_mask; %   ximage->blue_mask=header.blue_mask;    status=XInitImage(ximage);   if (status == False).     PrematureExit("Invalid XWD header",image);   /*     Read colormap.   */   colors=(XColor *) NULL;    if (header.ncolors != 0)     {m       XWDColor         color;  M       colors=(XColor *) malloc((unsigned int) header.ncolors*sizeof(XColor)); $       if (colors == (XColor *) NULL)9         PrematureExit("Unable to allocate memory",image); (       for (i=0; i < header.ncolors; i++)       { C         status=ReadData((char *) &color,sz_XWDColor,1,image->file);%         if (status == False)I           PrematureExit("Unable to read color map from dump file",image);e$         colors[i].pixel=color.pixel;          colors[i].red=color.red;$         colors[i].green=color.green;"         colors[i].blue=color.blue;$         colors[i].flags=color.flags;       }        /*D         Ensure the header byte-order is most-significant byte first.       */       lsb_first=1;       if (*(char *) &lsb_first)t*         for (i=0; i < header.ncolors; i++)	         {sM           MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(unsigned long));dO           MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(unsigned short));f	         }t     }    /*     Allocate the pixel buffer.   */    if (ximage->format == ZPixmap)2     packets=ximage->bytes_per_line*ximage->height;   else@     packets=ximage->bytes_per_line*ximage->height*ximage->depth;>   ximage->data=(char *) malloc(packets*sizeof(unsigned char));$   if (ximage->data == (char *) NULL)5     PrematureExit("Unable to allocate memory",image); 6   status=ReadData(ximage->data,1,packets,image->file);   if (status == False)6     PrematureExit("Unable to read dump pixmap",image);   /*!     Convert image to MIFF format.e   */   image->columns=ximage->width;    image->rows=ximage->height;;?   if ((colors == (XColor *) NULL) || (ximage->red_mask != 0) || <       (ximage->green_mask != 0) || (ximage->blue_mask != 0))     image->class=DirectClass;    else     image->class=PseudoClass;n   image->colors=header.ncolors;    image->packets=0; 5   packets=Max((image->columns*image->rows+4) >> 3,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);p   q=image->pixels;   q->length=MaxRunlength;    switch (image->class)r   {e     case DirectClass:a     {(       register unsigned long         color;         unsigned int
         blue,          green,         red;         unsigned longe         blue_mask,         blue_shift,(         green_mask,r         green_shift,         red_mask,m         red_shift;         /*:         Determine shift and mask for red, green, and blue.       */        red_mask=ximage->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {m         red_mask>>=1;B         red_shift++;       }e$       green_mask=ximage->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {e         green_mask>>=1;          green_shift++;       }b"       blue_mask=ximage->blue_mask;       blue_shift=0;=%       while ((blue_mask & 0x01) == 0)r       {.         blue_mask>>=1;         blue_shift++;r       }.       /*/         Convert X image to DirectClass packets.=       */       if (image->colors != 0)s'         for (y=0; y < image->rows; y++)a	         { ,           for (x=0; x < image->columns; x++)           {;(             pixel=XGetPixel(ximage,x,y);E             index=(unsigned short) ((pixel >> red_shift) & red_mask);).             red=XDownScale(colors[index].red);I             index=(unsigned short) ((pixel >> green_shift) & green_mask);_2             green=XDownScale(colors[index].green);G             index=(unsigned short) ((pixel >> blue_shift) & blue_mask); 0             blue=XDownScale(colors[index].blue);N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))                q->length++;             else               {l(                 if (image->packets != 0)                   q++;!                 image->packets++;i.                 if (image->packets == packets)                   {r                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));,B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;f                   }                  q->red=red;c                 q->green=green;                  q->blue=blue;                  q->index=0;                  q->length=0;               }            } 7           ProgressMonitor(LoadImageText,y,image->rows);n	         } 
       else'         for (y=0; y < image->rows; y++)r	         { ,           for (x=0; x < image->columns; x++)           {i(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;4             red=XDownScale((color*65535L)/red_mask);6             color=(pixel >> green_shift) & green_mask;8             green=XDownScale((color*65535L)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;6             blue=XDownScale((color*65535L)/blue_mask);N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))                q->length++;             else               {)(                 if (image->packets != 0)                   q++;!                 image->packets++;r.                 if (image->packets == packets)                   {n                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));rB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);s5                     q=image->pixels+image->packets-1;                    }i                 q->red=red;-                 q->green=green;d                 q->blue=blue;)                 q->index=0;                  q->length=0;               }t           }.7           ProgressMonitor(LoadImageText,y,image->rows);;	         }        break;     }t     case PseudoClass:)     {        /*/         Convert X image to PseudoClass packets.h       */P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image);)'       for (i=0; i < image->colors; i++)        {u9         image->colormap[i].red=XDownScale(colors[i].red); =         image->colormap[i].green=XDownScale(colors[i].green); ;         image->colormap[i].blue=XDownScale(colors[i].blue);h       }u%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         {p&           pixel=XGetPixel(ximage,x,y);           index=pixel;F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {t&               if (image->packets != 0)                 q++;               image->packets++;d,               if (image->packets == packets)                 {f                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket)); @                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image);a3                   q=image->pixels+image->packets-1;                  }                q->index=index;                q->length=0;
             }t	         }e5         ProgressMonitor(LoadImageText,y,image->rows);h       }        SyncImage(image);d       CompressColormap(image);       break;     }    }-#   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));n   /*     Free image and colormap.   */   if (header.ncolors != 0)     free((char *) colors);   free(ximage->data);g   free(ximage);    CloseImage(image);   return(image); }o   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %sO %                                                                             %cO %  R e a d Y U V I m a g e                                                    %nO %                                                                             %(O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadYUVImage reads an image with digital YUV (CCIR 601 4:1:1) bytes G %  and returns it.  It allocates the memory necessary for the new Imagea4 %  structure and returns a pointer to the new image. %g- %  The format of the ReadYUVImage routine is:  %m% %      image=ReadYUVImage(image_info)m %)+ %  A description of each parameter follows:  % I %    o image:  Function ReadYUVImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.m % A %    o image_info: Specifies a pointer to an ImageInfo structure.d %p %e */1 static Image *ReadYUVImage(ImageInfo *image_info)+ {    Image      *image,=     *zoomed_image;     inty     x,     y;     register int     i;     register RunlengthPacket     *q;m     register unsigned char     *p;(     unsigned char-     *yuv_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */)   zoomed_image=AllocateImage(image_info); %   if (zoomed_image == (Image *) NULL)      return((Image *) NULL);r   /*     Open image file.   */=   (void) strcpy(zoomed_image->filename,image_info->filename);h4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)/   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;L   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);i   for (i=0; i < x; i++)l%     (void) fgetc(zoomed_image->file);m   /*     Read Y channel.;   */#   zoomed_image->columns=width >> 1;;!   zoomed_image->rows=height >> 1;gA   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;g   yuv_pixels=(unsigned char *)7     malloc((3*(width*height)/2)*sizeof(unsigned char)); *   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));/   if ((yuv_pixels == (unsigned char *) NULL) || 9       (zoomed_image->pixels == (RunlengthPacket *) NULL)):<     PrematureExit("Unable to allocate memory",zoomed_image);O   (void) ReadData((char *) yuv_pixels,1,3*(width*height)/2,zoomed_image->file);    /*     Initialize U channel.S   */   p=yuv_pixels+(width*height);   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)    {      q->green=UpScale(*p);      q->index=0;      q->length=0;     p++;     q++;   }    /*     Initialize V channel.    */)   ProgressMonitor(LoadImageText,100,400);    q=zoomed_image->pixels;%+   for (i=0; i < zoomed_image->packets; i++)%   {%     q->blue=UpScale(*p);     p++;     q++;   }a   /*     Scale image.   */)   ProgressMonitor(LoadImageText,250,400);e   zoomed_image->orphan=True;#   image=MagnifyImage(zoomed_image);e   zoomed_image->orphan=False;    CloseImage(zoomed_image);s   DestroyImage(zoomed_image);g   if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);n   p=yuv_pixels;e   q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {r     q->red=UpScale(*p);y     p++;     q++;   }h   free((char *) yuv_pixels);+   TransformRGBImage(image,YCbCrColorspace);I   CompressImage(image); )   ProgressMonitor(LoadImageText,400,400);o   return(image); }d n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %,O %                                                                             % O %  R e a d Y U V 3 I m a g e                                                  % O %                                                                             %HO %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) %LJ %  Function ReadYUV3Image reads an image with digital YUV (CCIR 601 2:1:1)M %  bytes and returns it.  It allocates the memory necessary for the new ImageoK %  structure and returns a pointer to the new image.  This function differsgJ %  from ReadYUVImage in that it reads the Y, U, and V planes from separate) %  files (image.Y, image.U, and image.V).! %x. %  The format of the ReadYUV3Image routine is: %m& %      image=ReadYUV3Image(image_info) %R+ %  A description of each parameter follows:= %FJ %    o image:  Function ReadYUV3Image returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %_A %    o image_info: Specifies a pointer to an ImageInfo structure.e %h %B */2 static Image *ReadYUV3Image(ImageInfo *image_info) {e   char     filename[MaxTextLength];     Image      *image,d     *zoomed_image;     int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;t     unsigned charg     *uv_pixels,r     *y_pixels;     unsigned int     height,s
     width;     /*     Allocate image structure.a   */)   zoomed_image=AllocateImage(image_info);r%   if (zoomed_image == (Image *) NULL))     return((Image *) NULL);    /*     Open image file.   *//   (void) strcpy(filename,image_info->filename);i1   (void) strcpy(zoomed_image->filename,filename);[.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".Y");c4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image);   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;u   x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);;   for (i=0; i < x; i++)n%     (void) fgetc(zoomed_image->file);>   /*     Read Y channel.)   */#   zoomed_image->columns=width >> 1;a!   zoomed_image->rows=height >> 1;cA   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;l   uv_pixels=(unsigned char *) 8     malloc(zoomed_image->packets*sizeof(unsigned char));   y_pixels=(unsigned char *):     malloc(4*zoomed_image->packets*sizeof(unsigned char));*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));.   if ((uv_pixels == (unsigned char *) NULL) ||-       (y_pixels == (unsigned char *) NULL) ||s9       (zoomed_image->pixels == (RunlengthPacket *) NULL))r<     PrematureExit("Unable to allocate memory",zoomed_image);P   (void) ReadData((char *) y_pixels,4,zoomed_image->packets,zoomed_image->file);   CloseImage(zoomed_image);m   /*     Read U channel.    */)   ProgressMonitor(LoadImageText,100,400);n1   (void) strcpy(zoomed_image->filename,filename); .   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".U"); 4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image)e=   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,,     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)    {      q->green=UpScale(*p);      q->index=0;l     q->length=0;     p++;     q++;   }_   CloseImage(zoomed_image);    /*     Read V channel.*   */)   ProgressMonitor(LoadImageText,200,400);s1   (void) strcpy(zoomed_image->filename,filename);o.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".V");g4   OpenImage(image_info,zoomed_image,ReadBinaryType);*   if (zoomed_image->file == (FILE *) NULL)5     PrematureExit("Unable to open file",zoomed_image) =   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,      zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)    {r     q->blue=UpScale(*p);     p++;     q++;   }h   CloseImage(zoomed_image);+   free((char *) uv_pixels);e   /*     Scale image.   */)   ProgressMonitor(LoadImageText,300,400);o   zoomed_image->orphan=True;#   image=MagnifyImage(zoomed_image);L   zoomed_image->orphan=False;a   CloseImage(zoomed_image);)   DestroyImage(zoomed_image);g   if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);*
   p=y_pixels;i   q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {      q->red=UpScale(*p);d     p++;     q++;   }    free((char *) y_pixels);+   TransformRGBImage(image,YCbCrColorspace);_*   (void) strcpy(image->filename,filename);   CompressImage(image);m)   ProgressMonitor(LoadImageText,400,400);l   return(image); }e R /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %eO %                                                                             % O %                                                                             % O %   R e a d I m a g e                                                         %lO %                                                                             % O %                                                                             %xO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Function ReadImage reads an image and returns it.  It allocatesL %  the memory necessary for the new Image structure and returns a pointer toJ %  the new image.  By default, the image format is determined by its magicM %  number. To specify a particular image format, precede the filename with an)M %  explicit image format name and a colon (i.e.  ps:image) or as the filenamew %  suffix  (i.e. image.ps).  %f* %  The format of the ReadImage routine is: %0" %      image=ReadImage(image_info) % + %  A description of each parameter follows:c %iE %    o image: Function ReadImage returns a pointer to the image after0L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.; %  %  */' Image *ReadImage(ImageInfo *image_info)w {    char      magic_number[MaxTextLength];     Image-     decode_image,      *image;      ImageInfo      decode_info;     register charl     *p;o     register int     i;     SetImageInfo(image_info);    decode_info=(*image_info);?   decode_image.temporary=strcmp(decode_info.magick,"TMP") == 0;)3   if ((strncmp(decode_info.magick,"FTP",3) == 0) ||D4       (strncmp(decode_info.magick,"HTTP",4) == 0) ||4       (strncmp(decode_info.magick,"GOPHER",6) == 0))     { 
       char         command[MaxTextLength],           filename[MaxTextLength];         /*H         Retrieve image as specified with a WWW uniform resource locator.       */"       decode_image.temporary=True;"       TemporaryFilename(filename);P       (void) sprintf(command,WWWCommand,decode_info.magick,decode_info.filename,         filename);$       (void) SystemCommand(command);!       SetImageInfo(&decode_info);c3       (void) strcpy(decode_info.filename,filename);      }tJ   if (!decode_info.assert || (strncmp(decode_info.magick,"SGI",3) == 0) ||1       (strncmp(decode_info.magick,"PCD",3) == 0))      {        /*/         Determine type from image magic number.        *//       for (i=0 ; i < sizeof(magic_number); i++)s         magic_number[i]='\0';y@       (void) strcpy(decode_image.filename,decode_info.filename);9       OpenImage(image_info,&decode_image,ReadBinaryType);.-       if (decode_image.file != (FILE *) NULL)(>         if ((decode_image.file == stdin) || decode_image.pipe)           {*             FILE               *file;               int                c;               /*<               Copy standard input or pipe to temporary file.             */(             decode_image.temporary=True;5             TemporaryFilename(decode_image.filename);g7             decode_info.filename=decode_image.filename;n>             file=fopen(decode_image.filename,WriteBinaryType);&             if (file == (FILE *) NULL)               {mE                 Warning("Unable to write file",decode_info.filename);h'                 return((Image *) NULL);                }p'             c=fgetc(decode_image.file);i             while (c != EOF)
             {%"               (void) putc(c,file);)               c=fgetc(decode_image.file); 
             }               (void) fclose(file);&             CloseImage(&decode_image);?             OpenImage(image_info,&decode_image,ReadBinaryType);            } -       if (decode_image.file != (FILE *) NULL) 	         {a           /*             Read magic number.           */C           (void) ReadData(magic_number,(unsigned int) sizeof(char), C             (unsigned int) sizeof(magic_number),decode_image.file); :           if (((unsigned char) magic_number[0] == 0xff) &&8               ((unsigned char) magic_number[1] == 0xff))
             {%               register int                 i;                 /*6                 For PCD image type, skip to byte 2048.               */D               for (i=0; i < (int) (0x800-sizeof(magic_number)); i++)0                 (void) fgetc(decode_image.file);G               (void) ReadData(magic_number,(unsigned int) sizeof(char),mG                 (unsigned int) sizeof(magic_number),decode_image.file); 
             }n$           CloseImage(&decode_image);	         }        /*#         Determine the image format.e       */)       magic_number[MaxTextLength-1]='\0';m,       if (strncmp(magic_number,"BM",2) == 0)0         (void) strcpy(decode_info.magick,"BMP");-       if (strncmp(magic_number,"IT0",3) == 0)*1         (void) strcpy(decode_info.magick,"FITS");G9       if (strncmp(magic_number,"\261\150\336\72",4) == 0) 0         (void) strcpy(decode_info.magick,"DCX");0       if (strncmp(magic_number,"SIMPLE",6) == 0)1         (void) strcpy(decode_info.magick,"FITS");,.       if (strncmp(magic_number,"GIF8",4) == 0)0         (void) strcpy(decode_info.magick,"GIF");:       if (strncmp(magic_number,"\016\003\023\001",4) == 0)0         (void) strcpy(decode_info.magick,"HDF");3       if ((strncmp(magic_number,"<HTML",5) == 0) ||e1           (strncmp(magic_number,"<html",5) == 0)) 1         (void) strcpy(decode_info.magick,"HTML"); 2       if (strncmp(magic_number,"\001\332",2) == 0)0         (void) strcpy(decode_info.magick,"SGI");:       if (strncmp(magic_number,"\377\330\377\340",4) == 0)1         (void) strcpy(decode_info.magick,"JPEG");l9       if (strncmp(magic_number,"id=ImageMagick",14) == 0) 1         (void) strcpy(decode_info.magick,"MIFF");i.       if (strncmp(magic_number,"PCD_",4) == 0)0         (void) strcpy(decode_info.magick,"PCD");/       if (strncmp(magic_number,"\12\2",2) == 0).0         (void) strcpy(decode_info.magick,"PCX");/       if (strncmp(magic_number,"\12\5",2) == 0)r0         (void) strcpy(decode_info.magick,"PCX");/       if (strncmp(magic_number,"%!PDF",5) == 0)R0         (void) strcpy(decode_info.magick,"PDF");=       if ((*magic_number == 'P') && isdigit(magic_number[1]))e0         (void) strcpy(decode_info.magick,"PNM");;       if (strncmp(magic_number,"\211PNG\r\n\032\n",8) == 0) 0         (void) strcpy(decode_info.magick,"PNG");,       if (strncmp(magic_number,"%!",2) == 0)/         (void) strcpy(decode_info.magick,"PS");-5       if (strncmp(magic_number,"#?RADIANCE",10) == 0)o0         (void) strcpy(decode_info.magick,"RAD");2       if (strncmp(magic_number,"\122\314",2) == 0)0         (void) strcpy(decode_info.magick,"RLE");:       if (strncmp(magic_number,"\131\246\152\225",4) == 0)0         (void) strcpy(decode_info.magick,"SUN");>       if ((strncmp(magic_number,"\115\115\000\052",4) == 0) ||<           (strncmp(magic_number,"\111\111\052\000",4) == 0))1         (void) strcpy(decode_info.magick,"TIFF");/5       if ((strncmp(magic_number,"LBLSIZE",7) == 0) ||m2           (strncmp(magic_number,"NJPL1I",6) == 0))2         (void) strcpy(decode_info.magick,"VICAR");0       if (strncmp(magic_number,"\253\1",2) == 0)1         (void) strcpy(decode_info.magick,"VIFF");t!       p=strchr(magic_number,'#');l       if (p != (char *) NULL)m(         if (strncmp(p,"#define",7) == 0)2           (void) strcpy(decode_info.magick,"XBM");3       if (strncmp(magic_number,"/* XPM */",9) == 0) 0         (void) strcpy(decode_info.magick,"XPM");A       if ((magic_number[1] == 0x00) && (magic_number[2] == 0x00))tC         if ((magic_number[5] == 0x00) && (magic_number[6] == 0x00))oE           if ((magic_number[4] == 0x07) || (magic_number[7] == 0x07))e4             (void) strcpy(decode_info.magick,"XWD");     }g   /*6     Call appropriate image reader based on image type.   */   switch (*decode_info.magick)   { 
     case 'A':*     { 0       if (strcmp(decode_info.magick,"AVS") == 0)	         {h+           image=ReadAVSImage(&decode_info);            break;	         }=(       image=ReadMIFFImage(&decode_info);       break;     }m
     case 'B':_     {c0       if (strcmp(decode_info.magick,"BIE") == 0)	         { ,           image=ReadJBIGImage(&decode_info);           break;	         }r0       if (strcmp(decode_info.magick,"BMP") == 0)	         { +           image=ReadBMPImage(&decode_info);0           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'C':      {81       if (strcmp(decode_info.magick,"CMYK") == 0) 	         { ,           image=ReadCMYKImage(&decode_info);           break;	         }((       image=ReadMIFFImage(&decode_info);       break;     }d
     case 'D':      {;3       if (strncmp(decode_info.magick,"DCX",3) == 0)a	         { +           image=ReadPCXImage(&decode_info);            break;	         }b0       if (strcmp(decode_info.magick,"DIB") == 0)	         { +           image=ReadBMPImage(&decode_info);            break;	         }((       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'E':(     {(3       if (strncmp(decode_info.magick,"EPS",3) == 0);	         { *           image=ReadPSImage(&decode_info);           break;	         };(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'F':      { 0       if (strcmp(decode_info.magick,"FAX") == 0)	         { +           image=ReadFAXImage(&decode_info);f           break;	         } 1       if (strcmp(decode_info.magick,"FITS") == 0) 	         {c,           image=ReadFITSImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }r
     case 'G':e     { 3       if (strncmp(decode_info.magick,"GIF",3) == 0) 	         { +           image=ReadGIFImage(&decode_info);o           break;	         }e1       if (strcmp(decode_info.magick,"GRAY") == 0) 	         {e,           image=ReadGRAYImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }0
     case 'H':u     { 0       if (strcmp(decode_info.magick,"HDF") == 0)	         { +           image=ReadHDFImage(&decode_info);            break;	         }n9       if (strncmp(decode_info.magick,"HISTOGRAM",4) == 0) 	         {i1           image=ReadHISTOGRAMImage(&decode_info);g           break;	         } 1       if (strcmp(decode_info.magick,"HTML") == 0)a	         {g,           image=ReadHTMLImage(&decode_info);           break;	         }G(       image=ReadMIFFImage(&decode_info);       break;     })
     case 'J':(     {t1       if (strcmp(decode_info.magick,"JBIG") == 0);	         { ,           image=ReadJBIGImage(&decode_info);           break;	         } 1       if (strcmp(decode_info.magick,"JPEG") == 0)g	         { ,           image=ReadJPEGImage(&decode_info);           break;	         }o(       image=ReadMIFFImage(&decode_info);       break;     };
     case 'L':      {g1       if (strcmp(decode_info.magick,"LOGO") == 0) 	         {l,           image=ReadLOGOImage(&decode_info);           break;	         }l(       image=ReadMIFFImage(&decode_info);       break;     }:
     case 'M':(     { 0       if (strcmp(decode_info.magick,"MAP") == 0)	         { +           image=ReadMAPImage(&decode_info);            break;	         }a2       if (strcmp(decode_info.magick,"MATTE") == 0)	         {m-           image=ReadMATTEImage(&decode_info);a           break;	         } 5       if ((strcmp(decode_info.magick,"MPEG") == 0) || 2           (strcmp(decode_info.magick,"MPG") == 0))	         { ,           image=ReadMPEGImage(&decode_info);           break;	         }[0       if (strcmp(decode_info.magick,"MTV") == 0)	         {.+           image=ReadMTVImage(&decode_info);a           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'N':      {i1       if (strcmp(decode_info.magick,"NULL") == 0) 	         { ,           image=ReadNULLImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'P':t     { 4       if ((strcmp(decode_info.magick,"PBM") == 0) ||4           (strcmp(decode_info.magick,"PGM") == 0) ||4           (strcmp(decode_info.magick,"PNM") == 0) ||2           (strcmp(decode_info.magick,"PPM") == 0))	         { +           image=ReadPNMImage(&decode_info);3           break;	         } 0       if (strcmp(decode_info.magick,"PCD") == 0)	         { +           image=ReadPCDImage(&decode_info);e           break;	         } 0       if (strcmp(decode_info.magick,"PCX") == 0)	         {c+           image=ReadPCXImage(&decode_info);g           break;	         } 0       if (strcmp(decode_info.magick,"PDF") == 0)	         {;+           image=ReadPDFImage(&decode_info);t           break;	         }m1       if (strcmp(decode_info.magick,"PICT") == 0) 	         {r,           image=ReadPICTImage(&decode_info);           break;	         }d0       if (strcmp(decode_info.magick,"PCD") == 0)	         {(+           image=ReadPCDImage(&decode_info);0           break;	         }t/       if (strcmp(decode_info.magick,"PM") == 0)g	         {t+           image=ReadXPMImage(&decode_info);t           break;	         } 0       if (strcmp(decode_info.magick,"PNG") == 0)	         { +           image=ReadPNGImage(&decode_info);            break;	         }i2       if (strncmp(decode_info.magick,"PS",2) == 0)	         {g*           image=ReadPSImage(&decode_info);           break;	         }=(       image=ReadMIFFImage(&decode_info);       break;     }g
     case 'R':      {c0       if (strcmp(decode_info.magick,"RAD") == 0)	         {_0           image=ReadRADIANCEImage(&decode_info);           break;	         }i0       if (strcmp(decode_info.magick,"RAS") == 0)	         {t+           image=ReadSUNImage(&decode_info);d           break;	         }f3       if (strncmp(decode_info.magick,"RGB",3) == 0)l	         {e+           image=ReadRGBImage(&decode_info);=           break;	         } 0       if (strcmp(decode_info.magick,"RLA") == 0)	         { +           image=ReadRLAImage(&decode_info);u           break;	         } 0       if (strcmp(decode_info.magick,"RLE") == 0)	         {>+           image=ReadRLEImage(&decode_info);f           break;	         }e(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'S':n     { 0       if (strcmp(decode_info.magick,"SGI") == 0)	         {s+           image=ReadSGIImage(&decode_info);u           break;	         }e0       if (strcmp(decode_info.magick,"SUN") == 0)	         {%+           image=ReadSUNImage(&decode_info);            break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'T':      { 1       if (strcmp(decode_info.magick,"TEXT") == 0) 	         { ,           image=ReadTEXTImage(&decode_info);           break;	         }T0       if (strcmp(decode_info.magick,"TGA") == 0)	         { +           image=ReadTGAImage(&decode_info);            break;	         } 3       if (strncmp(decode_info.magick,"TIF",3) == 0) 	         { ,           image=ReadTIFFImage(&decode_info);           break;	         } 1       if (strcmp(decode_info.magick,"TILE") == 0)%	         {%,           image=ReadTILEImage(&decode_info);           break;	         }E(       image=ReadMIFFImage(&decode_info);       break;     }a
     case 'U':m     {e1       if (strcmp(decode_info.magick,"UYVY") == 0) 	         { ,           image=ReadUYVYImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }h
     case 'V':o     {a2       if (strcmp(decode_info.magick,"VICAR") == 0)	         {e-           image=ReadVICARImage(&decode_info);e           break;	         } 0       if (strcmp(decode_info.magick,"VID") == 0)	         {i!           if (decode_info.assert)n-             image=ReadVIDImage(&decode_info);e           else.             image=ReadMIFFImage(&decode_info);           break;	         } 1       if (strcmp(decode_info.magick,"VIFF") == 0) 	         {t,           image=ReadVIFFImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }t
     case 'X':k     { .       if (strcmp(decode_info.magick,"X") == 0)	         {iA           image=ReadXImage(&decode_info,False,False,False,False);s           break;	         };/       if (strcmp(decode_info.magick,"XC") == 0) 	         {a*           image=ReadXCImage(&decode_info);           break;	         })0       if (strcmp(decode_info.magick,"XBM") == 0)	         {_+           image=ReadXBMImage(&decode_info);*           break;	         }U0       if (strcmp(decode_info.magick,"XPM") == 0)	         {c+           image=ReadXPMImage(&decode_info);e           break;	         })/       if (strcmp(decode_info.magick,"XV") == 0) 	         {s,           image=ReadVIFFImage(&decode_info);           break;	         }l0       if (strcmp(decode_info.magick,"XWD") == 0)	         { +           image=ReadXWDImage(&decode_info);            break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }l
     case 'Y':      {r0       if (strcmp(decode_info.magick,"YUV") == 0)	         {f+           image=ReadYUVImage(&decode_info);e           break;	         }n1       if (strcmp(decode_info.magick,"YUV3") == 0)f	         {-,           image=ReadYUV3Image(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }i     default:     {r/       (void) strcpy(decode_info.magick,"MIFF");h(       image=ReadMIFFImage(&decode_info);     }    }g   if (decode_image.temporary)w(     (void) remove(decode_info.filename);   if (image != (Image *) NULL)     {g       if (image->status)K         Warning("An error has occurred reading from file",image->filename);c!       if (decode_image.temporary)a<         (void) strcpy(image->filename,image_info->filename);+       if (image->comments == (char *) NULL)n;         CommentImage(image,"  Imported from %m image: %f");nA       (void) strcpy(image->magick_filename,image_info->filename);t%       if (image->magick_columns == 0);-         image->magick_columns=image->columns;)"       if (image->magick_rows == 0)'         image->magick_rows=image->rows;i2       image_info->interlace=decode_info.interlace;     }    return(image); } 