 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                       IIIII  M   M   AAA   GGGG  EEEEE                      % O %                         I    MM MM  A   A G      E                          % O %                         I    M M M  AAAAA G  GG  EEE                        % O %                         I    M   M  A   A G   G  E                          % O %                       IIIII  M   M  A   A  GGGG  EEEEE                      % O %                                                                             % O %                                                                             % O %                          ImageMagick Image Routines                         % O %                                                                             % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1996 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "Colorlist.h"   /*   Function prototypes. */
 static double    (*FilterFunction)(double);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A l l o c a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function AllocateImage allocates an Image structure and initializes each  %  field to a default value. % . %  The format of the AllocateImage routine is: % 0 %      allocated_image=AllocateImage(image_info) % + %  A description of each parameter follows:  % L %    o allocated_image: Function AllocateImage returns a pointer to an imageL %      structure initialized to default values.  A null image is returned if" %      there is a memory shortage. % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %  %  */+ Image *AllocateImage(ImageInfo *image_info)  {    Image      *allocated_image;      /*     Allocate image structure.    */2   allocated_image=(Image *) malloc(sizeof(Image));(   if (allocated_image == (Image *) NULL)     { E       Warning("Unable to allocate image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize Image structure.    */&   allocated_image->file=(FILE *) NULL;    allocated_image->status=False;#   allocated_image->temporary=False; "   *allocated_image->filename='\0';   allocated_image->filesize=0;   allocated_image->pipe=False;0   (void) strcpy(allocated_image->magick,"MIFF");*   allocated_image->comments=(char *) NULL;'   allocated_image->label=(char *) NULL; &   allocated_image->text=(char *) NULL;"   allocated_image->id=UndefinedId;%   allocated_image->class=DirectClass;    allocated_image->matte=False; ;   allocated_image->compression=RunlengthEncodedCompression;    allocated_image->columns=0;    allocated_image->rows=0;&   allocated_image->depth=QuantumDepth;#   allocated_image->interlace=False;    allocated_image->scene=0; 2   allocated_image->units=2;  /* pixels per inch */%   allocated_image->x_resolution=72.0; %   allocated_image->y_resolution=72.0; )   allocated_image->montage=(char *) NULL; +   allocated_image->directory=(char *) NULL; 1   allocated_image->colormap=(ColorPacket *) NULL;     allocated_image->colorspace=0;   allocated_image->colors=0;   allocated_image->gamma=0.0; 0   allocated_image->normalized_maximum_error=0.0;-   allocated_image->normalized_mean_error=0.0; *   allocated_image->mean_error_per_pixel=0;"   allocated_image->total_colors=0;+   allocated_image->signature=(char *) NULL; 3   allocated_image->pixels=(RunlengthPacket *) NULL; 3   allocated_image->packet=(RunlengthPacket *) NULL;    allocated_image->packets=0; !   allocated_image->packet_size=0; 8   allocated_image->packed_pixels=(unsigned char *) NULL;)   *allocated_image->magick_filename='\0'; $   allocated_image->magick_columns=0;!   allocated_image->magick_rows=0; 5   allocated_image->magick_time=time((time_t *) NULL); *   allocated_image->geometry=(char *) NULL;&   allocated_image->page=(char *) NULL;'   allocated_image->delay=(char *) NULL;     allocated_image->orphan=False;+   allocated_image->previous=(Image *) NULL; '   allocated_image->list=(Image *) NULL; '   allocated_image->next=(Image *) NULL; '   if (image_info != (ImageInfo *) NULL)      { D       (void) strcpy(allocated_image->filename,image_info->filename);@       (void) strcpy(allocated_image->magick,image_info->magick);     }    return(allocated_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A n n o t a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function AnnotateImage annotates an image with test.  Optionally the K %  annotation can include the image filename, type, width, height, or scene I %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  % " %  produces an image annotation of %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % . %  The format of the AnnotateImage routine is: % ) %      AnnotateImage(image,annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % > %    o annotate_info: The address of a AnnotateInfo structure. %  %  */< void AnnotateImage(Image *image,AnnotateInfo *annotate_info) {    char
     *text,     **textlist;      FILE
     *file;     int 
     flags,     status,      x,     y;     register char      *p,      *q;      register int     i,     j;     static AnnotateInfo      cache_info;      static Display      *display = (Display *) NULL;     static unsigned int      font_type = 0;     static XAnnotateInfo     xannotate_info;      static XFontStruct     *font_info;      static XPixelInfo      pixel_info;      static XResourceInfo     resource_info;     static XrmDatabase     resource_database;     static XStandardColormap     *map_info;     static XVisualInfo     *visual_info;      unsigned int     height,      indirection,     length, 
     width;  +   if (annotate_info->text == (char *) NULL)      return; ,   indirection=(*annotate_info->text == '@');   if (indirection)     { 	       int 
         c;         /*         Read text from a file.       */5       file=(FILE *) fopen(annotate_info->text+1,"r");         if (file == (FILE *) NULL)	         { D           Warning("Unable to read text file",annotate_info->text+1);           return; 	         }        length=MaxTextLength; 2       annotate_info->text=(char *) malloc(length);L       for (q=annotate_info->text; annotate_info->text != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)            break;0         if ((q-annotate_info->text+1) >= length)           {              *q='\0';             length<<=1; M             annotate_info->text=(char *) realloc(annotate_info->text,length); 5             if (annotate_info->text == (char *) NULL)                break;>             q=annotate_info->text+strlen(annotate_info->text);           }          *q=(unsigned char) c;        }        (void) fclose(file);/       if (annotate_info->text == (char *) NULL) 	         { I           Warning("Unable to annotate image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*'     Allocate and initialize image text.    */   p=annotate_info->text;3   length=strlen(annotate_info->text)+MaxTextLength; &   image->text=(char *) malloc(length);8   for (q=image->text; image->text != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;0     if ((q-image->text+MaxTextLength) >= length)       {          length<<=1; B         image->text=(char *) realloc((char *) image->text,length);)         if (image->text == (char *) NULL)            break;*         q=image->text+strlen(image->text);       }      /*,       Process formatting characters in text.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);*         q=image->text+strlen(image->text);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);*         q=image->text+strlen(image->text);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); *         q=image->text+strlen(image->text);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } #   if (image->text == (char *) NULL)      { E       Warning("Unable to annotate image","Memory allocation failed"); 
       return;      }    *q++='\0';   *q++='\0';   if (indirection)'     free((char *) annotate_info->text); %   textlist=StringToList(image->text);    free(image->text);   image->text=(char *) NULL;!   if (textlist == (char **) NULL)      return;    length=strlen(textlist[0]); .   for (i=0; textlist[i] != (char *) NULL; i++)%     if (strlen(textlist[i]) > length) !       length=strlen(textlist[i]); !   text=(char *) malloc(length+4);    if (text == (char *) NULL)     { D       Warning("Unable to annotate image","Memory allocation error");
       return;      }    /*     Get annotate geometry.   */   x=0;   y=0;   width=image->columns; "   height=annotate_info->pointsize;   flags=NoValue;/   if (annotate_info->geometry != (char *) NULL)      { I       flags=XParseGeometry(annotate_info->geometry,&x,&y,&width,&height); #       if ((flags & XNegative) != 0)          x+=image->columns;#       if ((flags & YNegative) != 0)          y+=image->rows;      }    switch (font_type)   {      case 0:      default:     {        /*!         Open X server connection.        */&       if (display != (Display *) NULL)         break;7       display=XOpenDisplay(annotate_info->server_name); &       if (display != (Display *) NULL)	         {            /*,             Set our forgiving error handler.           */#           XSetErrorHandler(XError);            /*7             Get user defaults from X resource database.            */F           resource_database=XGetResourceDatabase(display,client_name);I           XGetResourceInfo(resource_database,client_name,&resource_info); +           resource_info.close_server=False; 1           resource_info.colormap=PrivateColormap; 3           if (annotate_info->font != (char *) NULL) 3             resource_info.font=annotate_info->font; 2           if (annotate_info->box != (char *) NULL)>             resource_info.background_color=annotate_info->box;2           if (annotate_info->pen != (char *) NULL)>             resource_info.foreground_color=annotate_info->pen;,           map_info=XAllocStandardColormap();5           if (map_info == (XStandardColormap *) NULL) 9             Warning("Unable to create standard colormap", *               "Memory allocation failed");           /*#             Initialize visual info.            */G           visual_info=XBestVisualInfo(display,map_info,&resource_info); 2           if (visual_info == (XVisualInfo *) NULL)F             Warning("Unable to get visual",resource_info.visual_type);-           map_info->colormap=(Colormap) NULL; 3           pixel_info.pixels=(unsigned long *) NULL; /           pixel_info.gamma_map=(XColor *) NULL;            /*.             Initialize Standard Colormap info.           */P           XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),             map_info);D           XGetPixelInfo(display,visual_info,map_info,&resource_info,(             (Image *) NULL,&pixel_info);N           pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);           /*!             Initialize font info.            */<           font_info=XBestFont(display,&resource_info,False);0           if (font_info == (XFontStruct *) NULL)>             Warning("Unable to load font",resource_info.font);9           if ((map_info == (XStandardColormap *) NULL) || 6               (visual_info == (XVisualInfo *) NULL) ||2               (font_info == (XFontStruct *) NULL))
             { F               XFreeResources(display,visual_info,map_info,&pixel_info,?                 font_info,&resource_info,(XWindowInfo *) NULL); '               display=(Display *) NULL; 
             } &           cache_info=(*annotate_info);           break;	         } O       Warning("Unable to load X server fonts","substituting Postscript fonts");        font_type++;     }      case 1:      { 
       char          filename[MaxTextLength],         page[MaxTextLength];         Image          *annotate_image;         ImageInfo          image_info;          register RunlengthPacket         *q;          unsigned int         matte;         XColor         box_color,         pen_color;         /*E         X server fonts are not available, use Postscript to annotate.        */@       (void) XQueryColorDatabase(annotate_info->box,&box_color);@       (void) XQueryColorDatabase(annotate_info->pen,&pen_color);        GetImageInfo(&image_info);"       TemporaryFilename(filename);!       image_info.monochrome=True; =       (void) sprintf(page,"%ux%u",height*length,height << 1);        image_info.page=page; /       if (annotate_info->font == (char *) NULL) (         annotate_info->font=DefaultFont;2       for (i=0; textlist[i] != (char *) NULL; i++)       { 8         if ((x >= image->columns) || (y >= image->rows))           break;!         if (*textlist[i] == '\0')            {              free(textlist[i]);             continue;            } (         (void) strcpy(text,textlist[i]);?         for (j=((int) strlen(textlist[i])-1) >> 1; j >= 0; j--) 	         { 6           (void) strcpy(image_info.filename,filename);#           file=fopen(filename,"w"); $           if (file == (FILE *) NULL)             break;3           (void) fprintf(file,"%%!PS-Adobe-3.0\n"); D           (void) fprintf(file,"/%s findfont %u scalefont setfont\n",(             annotate_info->font,height);E           (void) fprintf(file,"0 %u moveto (%s) show\n",height,text); ,           (void) fprintf(file,"showpage\n");           (void) fclose(file);0           annotate_image=ReadImage(&image_info);/           if (annotate_image == (Image *) NULL)              break;>           TransformImage(&annotate_image,"0x0",(char *) NULL);.           if (annotate_image->columns < width)             break;'           DestroyImage(annotate_image); *           (void) strcpy(text,textlist[i]);&           (void) strcpy(text+j,"...");B           (void) strcat(text,textlist[i]+strlen(textlist[i])-j-1);	         }           (void) remove(filename);         free(textlist[i]);-         if (annotate_image == (Image *) NULL)            { >             Warning("Unable to annotate image",(char *) NULL);             break;           } 
         /*(           Composite text onto the image.
         */*         annotate_image->class=DirectClass;#         annotate_image->matte=True; !         q=annotate_image->pixels; 3         for (j=0; j < annotate_image->packets; j++) 	         {            if (q->index != 0)
             { /               q->red=XDownScale(box_color.red); 3               q->green=XDownScale(box_color.green); 1               q->blue=XDownScale(box_color.blue);                q->index= K                 annotate_info->box == (char *) NULL ? Transparent : Opaque; 
             }            else
             { /               q->red=XDownScale(pen_color.red); 3               q->green=XDownScale(pen_color.green); 1               q->blue=XDownScale(pen_color.blue);                q->index= K                 annotate_info->pen == (char *) NULL ? Transparent : Opaque; 
             }            q++;	         }          matte=image->matte; >         CompositeImage(image,OverCompositeOp,annotate_image,x+P           (annotate_info->center ? (width >> 1)-(annotate_image->columns >> 1) :           0),y);         image->matte=matte; $         y+=annotate_info->pointsize;%         DestroyImage(annotate_image);        }        free(text); 0       for ( ; textlist[i] != (char *) NULL; i++)         free(textlist[i]);       free((char *) textlist);
       return;      }    }    /*     Initialize annotate info.    */$   XGetAnnotateInfo(&xannotate_info);-   if (cache_info.font != annotate_info->font)      {        /*         Font name has changed.       */#       XFreeFont(display,font_info); /       if (annotate_info->font != (char *) NULL) /         resource_info.font=annotate_info->font; 8       font_info=XBestFont(display,&resource_info,False);,       if (font_info == (XFontStruct *) NULL):         Warning("Unable to load font",resource_info.font);     } !   if ((flags & HeightValue) == 0) 0     height=font_info->ascent+font_info->descent;%   xannotate_info.font_info=font_info;    xannotate_info.text=text;    xannotate_info.x=x;    xannotate_info.y=y;    xannotate_info.width=width; =   xannotate_info.height=font_info->ascent+font_info->descent; @   annotate_info->pointsize=font_info->ascent+font_info->descent;.   if ((annotate_info->pen != (char *) NULL) &&,       (annotate_info->box != (char *) NULL)))     xannotate_info.stencil=OpaqueStencil;    else,     if (annotate_info->pen != (char *) NULL)/       xannotate_info.stencil=ForegroundStencil;      else/       xannotate_info.stencil=BackgroundStencil; /   if ((cache_info.box != annotate_info->box) || -       (cache_info.pen != annotate_info->pen))      {        /*         Pen color has changed.       */.       if (annotate_info->box != (char *) NULL):         resource_info.background_color=annotate_info->box;.       if (annotate_info->pen != (char *) NULL):         resource_info.foreground_color=annotate_info->pen;O       XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,          &pixel_info);      }    /*     Annotate the text image.   */.   for (i=0; textlist[i] != (char *) NULL; i++)   { 4     if ((x >= image->columns) || (y >= image->rows))       break;     if (*textlist[i] == '\0')        {          free(textlist[i]);         continue;        } $     (void) strcpy(text,textlist[i]);;     for (j=((int) strlen(textlist[i])-1) >> 1; j >= 0; j--)      { L       xannotate_info.width=(height*XTextWidth(font_info,text,strlen(text)))/         xannotate_info.height;'       if (xannotate_info.width < width)          break;&       (void) strcpy(text,textlist[i]);"       (void) strcpy(text+j,"...");>       (void) strcat(text,textlist[i]+strlen(textlist[i])-j-1);     }      free(textlist[i]);N     (void) sprintf(xannotate_info.geometry,"%ux%u%+d%+d",xannotate_info.width,K       height,(int) (xannotate_info.x+(annotate_info->center ? (width >> 1)- :       (xannotate_info.width >> 1) : 0)),xannotate_info.y);A     xannotate_info.width=XTextWidth(font_info,text,strlen(text)); E     status=XAnnotateImage(display,&pixel_info,&xannotate_info,image);      if (status == 0)       { G         Warning("Unable to xannotate image","Memory allocation error");          break;       }      xannotate_info.y+=height;      y+=height;   }    /*     Free resources.    */   cache_info=(*annotate_info);
   free(text); ,   for ( ; textlist[i] != (char *) NULL; i++)     free(textlist[i]);   free((char *) textlist); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     B l u r I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BlurImage creates a new image that is a copy of an existing J %  one with the pixels blurred.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % F %  BlurImage convolves the pixel neighborhood with this blurring mask: % 
 %     1  2  1 
 %     2  W  2 
 %     1  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the BlurImage routine is: % , %      blurred_image=BlurImage(image,factor) % + %  A description of each parameter follows:  % G %    o blurred_image: Function BlurImage returns a pointer to the image J %      after it is blurred.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */, Image *BlurImage(Image *image,double factor) {  #define Blur(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;. #define BlurImageText  "  Blurring image...  "     Image      *blurred_image;      long     total_blue,      total_green,     total_red,     weight;      register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     { C       Warning("Unable to blur image","image size must exceed 3x3");        return((Image *) NULL);      }    /*(     Initialize blurred image attributes.   */B   blurred_image=CopyImage(image,image->columns,image->rows,False);&   if (blurred_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } #   blurred_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");"       DestroyImage(blurred_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=blurred_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */&   weight=(long) ((100.0-factor)/2-13);   quantum=Max(weight+12,1); %   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        s=s0; !       Blur(1);  Blur(2); Blur(1);        s=s1; %       Blur(2); Blur(weight); Blur(2);        s=s2; !       Blur(1);  Blur(2); Blur(1); <       q->red=(Quantum) ((total_red+(quantum >> 1))/quantum);@       q->green=(Quantum) ((total_green+(quantum >> 1))/quantum);>       q->blue=(Quantum) ((total_blue+(quantum >> 1))/quantum);       q->index=s1->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;1     ProgressMonitor(BlurImageText,y,image->rows);    }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   return(blurred_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   B o r d e r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BorderImage takes an image and puts a border around it of a I %  particular color.  It allocates the memory necessary for the new Image H %  structure and returns a pointer to the new image.  Set the border and5 %  highlight to the same color to get a solid border.  % , %  The format of the BorderImage routine is: % A %      bordered_image=BorderImage(image,border_info,border_color)  % + %  A description of each parameter follows:  % M %    o bordered_image: Function BorderImage returns a pointer to the bordered H %      image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % I %    o border_info: Specifies a pointer to a XRectangle which defines the  %      border region.  % G %    o border_color: A pointer to a ColorPacket which contains the red, 6 %      green, and blue components of the border color. %  %  */; Image *BorderImage(Image *image,RectangleInfo *border_info,    ColorPacket *border_color) { 8 #define BorderImageText  "  Adding border to image...  "     Image      *bordered_image;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      border;      /*)     Initialize bordered image attributes.    */J   bordered_image=CopyImage(image,image->columns+(border_info->width << 1),2     image->rows+(border_info->height << 1),False);'   if (bordered_image == (Image *) NULL)      { C       Warning("Unable to border image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize border color.   */   border.red=border_color->red; #   border.green=border_color->green; !   border.blue=border_color->blue; #   border.index=border_color->index;    border.length=0;   /*(     Copy image and put border around it.   */   q=bordered_image->pixels; )   for (y=0; y < border_info->height; y++) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)    {      /*,       Initialize scanline with border color.     */*     for (x=0; x < border_info->width; x++)       *q++=border;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     }      x=0;K     while (x < (bordered_image->columns-image->columns-border_info->width))      {        *q++=border;
       x++;     } 3     ProgressMonitor(BorderImageText,y,image->rows);    } O   for (y=(bordered_image->rows-image->rows-border_info->height-1); y >= 0; y--) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   return(bordered_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C h o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ChopImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure and& %  returns a pointer to the new image. % * %  The format of the ChopImage routine is: % , %      chop_image=ChopImage(image,chop_info) % + %  A description of each parameter follows:  % C %    o chop_image: Function ChopImage returns a pointer to the chop J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o chop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */7 Image *ChopImage(Image *image,RectangleInfo *chop_info)  { . #define ChopImageText  "  Chopping image...  "     Image      *chopped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      unsigned int     height;      /*     Check chop geometry.   */4   if (((chop_info->x+(int) chop_info->width) < 0) ||5       ((chop_info->y+(int) chop_info->height) < 0) || .       (chop_info->x > (int) image->columns) ||)       (chop_info->y > (int) image->rows))      { H       Warning("Unable to chop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((chop_info->x+(int) chop_info->width) > (int) image->columns) H     chop_info->width=(unsigned int) ((int) image->columns-chop_info->x);A   if ((chop_info->y+(int) chop_info->height) > (int) image->rows) F     chop_info->height=(unsigned int) ((int) image->rows-chop_info->y);   if (chop_info->x < 0)      { 7       chop_info->width-=(unsigned int) (-chop_info->x);        chop_info->x=0;      }    if (chop_info->y < 0)      { 8       chop_info->height-=(unsigned int) (-chop_info->y);       chop_info->y=0;      }    /*%     Initialize chop image attributes.    */@   chopped_image=CopyImage(image,image->columns-chop_info->width,)     image->rows-chop_info->height,False); &   if (chopped_image == (Image *) NULL)     { A       Warning("Unable to chop image","Memory allocation failed");        return((Image *) NULL);      }    /*     Extract chop image.    */   p=image->pixels;   image->runlength=p->length+1;    q=chopped_image->pixels;"   for (y=0; y < chop_info->y; y++)&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      }    /*%     Skip pixels up to the chop image.    */8   for (x=0; x < (chop_info->height*image->columns); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract chop image.    */6   height=image->rows-(chop_info->y+chop_info->height);   for (y=0; y < height; y++)   { &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      } ,     ProgressMonitor(ChopImageText,y,height);   }    return(chopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o s e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CloseImage closes a file associated with the image.  If the K %  filename prefix is '|', the file is a pipe and is closed with PipeClose.  % + %  The format of the CloseImage routine is:  %  %      CloseImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CloseImage(Image *image)  {    /*     Close image file.    */   if (image == (Image *) NULL)     return; #   if (image->file == (FILE *) NULL)      return; $   image->status=ferror(image->file);) #if !defined(vms) && !defined(__MWERKS__)    if (image->pipe)     (void) pclose(image->file);    else #endif:     if ((image->file != stdin) && (image->file != stdout))!       (void) fclose(image->file);    do   {      image->file=(FILE *) NULL;     image=image->next;   } "   while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m m e n t I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CommentImage initializes an image comment.  Optionally theH %  comment can include the image filename, type, width, height, or sceneI %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  %  %  produces an image comment of  %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % - %  The format of the CommentImage routine is:  % # %      CommentImage(image,comments)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % I %    o comments: The address of a character string containing the comment  %      format. %  %  */. void CommentImage(Image *image,char *comments) {    register char      *p,      *q;      unsigned int     indirection,     length;   '   if (image->comments != (char *) NULL) #     free((char *) image->comments);     image->comments=(char *) NULL;    if (comments == (char *) NULL)     return; !   indirection=(*comments == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*"         Read comments from a file.       */*       file=(FILE *) fopen(comments+1,"r");        if (file == (FILE *) NULL)	         { =           Warning("Unable to read comments file",comments+1);            return; 	         }        length=MaxTextLength; '       comments=(char *) malloc(length); 6       for (q=comments; comments != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)            break;%         if ((q-comments+1) >= length)            {              *q='\0';             length<<=1; @             comments=(char *) realloc((char *) comments,length);*             if (comments == (char *) NULL)               break;(             q=comments+strlen(comments);           }          *q=(unsigned char) c;        }        (void) fclose(file);$       if (comments == (char *) NULL)	         { I           Warning("Unable to comments image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*+     Allocate and initialize image comments.    */
   p=comments; (   length=strlen(comments)+MaxTextLength;*   image->comments=(char *) malloc(length);@   for (q=image->comments; image->comments != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;4     if ((q-image->comments+MaxTextLength) >= length)       {          length<<=1; J         image->comments=(char *) realloc((char *) image->comments,length);-         if (image->comments == (char *) NULL)            break;2         q=image->comments+strlen(image->comments);       }      /*0       Process formatting characters in comments.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);2         q=image->comments+strlen(image->comments);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);2         q=image->comments+strlen(image->comments);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); 2         q=image->comments+strlen(image->comments);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } '   if (image->comments == (char *) NULL)      { D       Warning("Unable to comment image","Memory allocation failed");
       return;      } 
   *q='\0';   if (indirection)     free((char *) comments); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s C o l o r m a p                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressColormap compresses an image colormap removing any %  unused color entries. % 1 %  The format of the CompressColormap routine is:  %  %      CompressColormap(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */# void CompressColormap(Image *image)  { 
   ColorPacket      *colormap;     int      number_colors;     register int     i;     register RunlengthPacket     *p;      register unsigned short 
     index;     /*,     Determine if colormap can be compressed.   */"   if (image->class != PseudoClass)     return;    number_colors=image->colors;#   for (i=0; i < image->colors; i++) #     image->colormap[i].flags=False;    image->colors=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { )     if (!image->colormap[p->index].flags)        { 6         image->colormap[p->index].index=image->colors;-         image->colormap[p->index].flags=True;          image->colors++;       }      p++;   } %   if (image->colors == number_colors) $     return;  /* no unused entries */   /*     Compress colormap.   */E   colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket)); '   if (colormap == (ColorPacket *) NULL)      { H       Warning("Unable to compress colormap","Memory allocation failed");"       image->colors=number_colors;
       return;      } #   for (i=0; i < number_colors; i++) !     if (image->colormap[i].flags)        { '         index=image->colormap[i].index; 3         colormap[index].red=image->colormap[i].red; 7         colormap[index].green=image->colormap[i].green; 5         colormap[index].blue=image->colormap[i].blue;        }    /*     Remap pixels.    */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { -     p->index=image->colormap[p->index].index;      p++;   } !   free((char *) image->colormap);    image->colormap=colormap;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressImage compresses an image to the minimum number of %  runlength-encoded packets.  % . %  The format of the CompressImage routine is: %  %      CompressImage(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */  void CompressImage(Image *image) {    register int     i;     register RunlengthPacket     *p,      *q;      /*     Compress image.    */   if (image == (Image *) NULL)     return;    p=image->pixels;   image->runlength=p->length+1;    image->packets=0;    q=image->pixels;   q->length=MaxRunlength;    if (image->matte) 4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      }    else4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && C           (p->blue == q->blue) && ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    /*H     Runlength-encode only if it takes up less space than no compression.   */8   if (image->compression == RunlengthEncodedCompression)$     if (image->class == DirectClass)       { D         if (image->packets >= ((image->columns*image->rows*3) >> 2))+           image->compression=NoCompression;        }      else@       if (image->packets >= ((image->columns*image->rows) >> 1)))         image->compression=NoCompression;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p o s i t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CompositeImage returns the second image composited onto the " %  first at the specified offsets. % / %  The format of the CompositeImage routine is:  % F %      CompositeImage(image,compose,composite_image,x_offset,y_offset) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 6 %    o compose: Specifies an image composite operator. % A %    o composite_image: The address of a structure of type Image.  % N %    o x_offset: An integer that specifies the column offset of the composited
 %      image.  % K %    o y_offset: An integer that specifies the row offset of the composited 
 %      image.  %  %  */M void CompositeImage(Image *image,unsigned int compose,Image *composite_image,    int x_offset,int y_offset) { 6 #define CompositeImageText  "  Compositing image...  "     int 	     blue, 
     green,     red;     register int     i,
     index,     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check composite geometry.    */.   if (((x_offset+(int) image->columns) < 0) ||+       ((y_offset+(int) image->rows) < 0) || J       (x_offset > (int) image->columns) || (y_offset > (int) image->rows))     { M       Warning("Unable to composite image","geometry does not contain image"); 
       return;      }    /*     Image must be uncompressed.    */   if (!UncompressImage(image))     return; $   if (compose == ReplaceCompositeOp)     {        /*9         Promote image to DirectClass if colormaps differ.        */&       if (image->class == PseudoClass)2         if (composite_image->class == DirectClass)#           image->class=DirectClass;          else           { 2             if (image->signature == (char *) NULL)$               SignatureImage(image);<             if (composite_image->signature == (char *) NULL).               SignatureImage(composite_image);I             if (strcmp(image->signature,composite_image->signature) != 0) '               image->class=DirectClass;            } 2       if (image->matte && !composite_image->matte)	         { $           p=composite_image->pixels;6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;             p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      }    else     {        /*$         Initialize image matte data.       */       if (!image->matte)	         {            q=image->pixels;           red=q->red;            green=q->green;            blue=q->blue; ,           for (i=0; i < image->packets; i++)           {              q->index=Opaque;             q++;           } #           image->class=DirectClass;            image->matte=True;	         } "       if (!composite_image->matte)	         { $           p=composite_image->pixels;           red=p->red;            green=p->green;            blue=p->blue; 6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;L             if ((p->red == red) && (p->green == green) && (p->blue == blue))#               p->index=Transparent;              p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }      }    /*      Initialize composited image.   */   p=composite_image->pixels;)   composite_image->runlength=p->length+1; +   for (y=0; y < composite_image->rows; y++)    { <     if (((y_offset+y) < 0) || ((y_offset+y) >= image->rows))       continue; 9     q=image->pixels+(y_offset+y)*image->columns+x_offset; 0     for (x=0; x < composite_image->columns; x++)     { *       if (composite_image->runlength != 0)%         composite_image->runlength--; 
       else	         {            p++;/           composite_image->runlength=p->length; 	         } A       if (((x_offset+x) < 0) || ((x_offset+x) >= image->columns)) 	         {            q++;           continue; 	         }        switch (compose)       {          case OverCompositeOp:          default:	         { &           if (p->index == Transparent)
             {                red=q->red;                green=q->green;                blue=q->blue;                index=q->index; 
             }            else#             if (p->index == Opaque)                {                  red=p->red;                  green=p->green;                  blue=p->blue;                  index=p->index;                }              else               { J                 red=(int) (p->red*Opaque+q->red*(Opaque-p->index))/Opaque;P                 green=(int) (p->green*Opaque+q->green*(Opaque-p->index))/Opaque;M                 blue=(int) (p->blue*Opaque+q->blue*(Opaque-p->index))/Opaque; P                 index=(int) (p->index*Opaque+q->index*(Opaque-p->index))/Opaque;               }            break;	         }          case InCompositeOp: 	         { -           red=(int) (p->red*q->index)/Opaque; 1           green=(int) (p->green*q->index)/Opaque; /           blue=(int) (p->blue*q->index)/Opaque; 1           index=(int) (p->index*q->index)/Opaque;            break;	         }          case OutCompositeOp:	         { 6           red=(int) (p->red*(Opaque-q->index))/Opaque;:           green=(int) (p->green*(Opaque-q->index))/Opaque;8           blue=(int) (p->blue*(Opaque-q->index))/Opaque;:           index=(int) (p->index*(Opaque-q->index))/Opaque;           break;	         }          case AtopCompositeOp: 	         { F           red=(int) (p->red*q->index+q->red*(Opaque-p->index))/Opaque;L           green=(int) (p->green*q->index+q->green*(Opaque-p->index))/Opaque;I           blue=(int) (p->blue*q->index+q->blue*(Opaque-p->index))/Opaque; L           index=(int) (p->index*q->index+q->index*(Opaque-p->index))/Opaque;           break;	         }          case XorCompositeOp:	         { O           red=(int) (p->red*(Opaque-q->index)+q->red*(Opaque-p->index))/Opaque; N           green=(int) (p->green*(Opaque-q->index)+q->green*(Opaque-p->index))/             Opaque; K           blue=(int) (p->blue*(Opaque-q->index)+q->blue*(Opaque-p->index))/              Opaque; N           index=(int) (p->index*(Opaque-q->index)+q->index*(Opaque-p->index))/             Opaque;            break;	         }          case PlusCompositeOp: 	         { (           red=(int) p->red+(int) q->red;.           green=(int) p->green+(int) q->green;+           blue=(int) p->blue+(int) q->blue; .           index=(int) p->index+(int) q->index;           break;	         }          case MinusCompositeOp:	         { (           red=(int) p->red-(int) q->red;.           green=(int) p->green-(int) q->green;+           blue=(int) p->blue-(int) q->blue;            index=Opaque;            break;	         }          case AddCompositeOp:	         { (           red=(int) p->red+(int) q->red;           if (red > Opaque)              red-=(Opaque+1);.           green=(int) p->green+(int) q->green;           if (green > Opaque)              green-=(Opaque+1);+           blue=(int) p->blue+(int) q->blue;            if (blue > Opaque)             blue-=(Opaque+1); .           index=(int) p->index+(int) q->index;           if (index > Opaque)              index-=(Opaque+1);           break;	         } !         case SubtractCompositeOp: 	         { (           red=(int) p->red-(int) q->red;           if (red < 0)             red+=(Opaque+1);.           green=(int) p->green-(int) q->green;           if (green < 0)             green+=(Opaque+1);+           blue=(int) p->blue-(int) q->blue;            if (blue < 0)              blue+=(Opaque+1); .           index=(int) p->index-(int) q->index;           if (index < 0)             index+=(Opaque+1);           break;	         } #         case DifferenceCompositeOp: 	         { 7           red=AbsoluteValue((int) p->red-(int) q->red); =           green=AbsoluteValue((int) p->green-(int) q->green); :           blue=AbsoluteValue((int) p->blue-(int) q->blue);=           index=AbsoluteValue((int) p->index-(int) q->index);            break;	         }           case ReplaceCompositeOp:	         {            red=p->red;            green=p->green;            blue=p->blue;            index=p->index;            break;	         } %         case MatteReplaceCompositeOp: 	         {            red=q->red;            green=q->green;            blue=q->blue;            index=p->index;            break;	         }          case BlendCompositeOp:	         { =           red=(int) (p->red*p->index+q->red*q->index)/Opaque; C           green=(int) (p->green*p->index+q->green*q->index)/Opaque; @           blue=(int) (p->blue*p->index+q->blue*q->index)/Opaque;           index=Opaque;            break;	         }        }        if (red > MaxRGB)          q->red=MaxRGB;
       else         if (red < 0)           q->red=0;          else           q->red=red;        if (green > MaxRGB)          q->green=MaxRGB;
       else         if (green < 0)           q->green=0;          else           q->green=green;        if (blue > MaxRGB)         q->blue=MaxRGB; 
       else         if (blue < 0)            q->blue=0;         else           q->blue=blue;        if (index > Opaque)          q->index=Opaque;
       else          if (index < Transparent)           q->index=Transparent;          else           q->index=index;        q->length=0;
       q++;     } @     ProgressMonitor(CompositeImageText,y,composite_image->rows);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C o n t r a s t I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ContrastImage enhances the intensity differences between the, %  lighter and darker elements of the image. % . %  The format of the ContrastImage routine is: % # %      ContrastImage(image,sharpen)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % C %    o sharpen: If True, the intensity is increased otherwise it is  %      decreased.  %  %  */  H static void HSVTransform(double hue,double saturation,double brightness,,   Quantum *red,Quantum *green,Quantum *blue) {    double     b,     g,     r;     /*"     Convert HSV to RGB colorspace.   */   r=brightness;    g=brightness;    b=brightness; +   if ((hue != -1.0) && (saturation != 0.0))      {        double
         f,
         j,
         k,
         l,
         v;  	       int 
         i;         if (hue == 360.0)          hue=0.0;       hue=hue/60.0;        i=(int) floor(hue);        if (i < 0)         i=0;       f=hue-i;$       j=brightness*(1.0-saturation);(       k=brightness*(1.0-(saturation*f));.       l=brightness*(1.0-(saturation*(1.0-f)));       v=brightness;        switch (i)       { )         case 0:  r=v;  g=l;  b=j;  break; )         case 1:  r=k;  g=v;  b=j;  break; )         case 2:  r=j;  g=v;  b=l;  break; )         case 3:  r=j;  g=k;  b=v;  break; )         case 4:  r=l;  g=j;  b=v;  break; )         case 5:  r=v;  g=j;  b=k;  break;        }      } 0   *red=(Quantum) floor((r*(double) MaxRGB)+0.5);2   *green=(Quantum) floor((g*(double) MaxRGB)+0.5);1   *blue=(Quantum) floor((b*(double) MaxRGB)+0.5);  }   O static void TransformHSV(unsigned int red,unsigned int green,unsigned int blue, 4   double *hue,double *saturation,double *brightness) {    double     b,     minimum,     g,     r;     /*"     Convert RGB to HSV colorspace.   */   *hue=(-1.0);   *saturation=0.0;!   r=(double) red/(double) MaxRGB; #   g=(double) green/(double) MaxRGB; "   b=(double) blue/(double) MaxRGB;
   if (r >= g)      {        if (r >= b)          *brightness=r;
       else         *brightness=b;     }    else     if (g >= b)        *brightness=g;     else       *brightness=b;
   if (r <= g)      {        if (r <= b)          minimum=r;
       else         minimum=b;     }    else     if (g <= b)        minimum=g;     else       minimum=b;   if (*brightness != 0.0) 4     *saturation=(*brightness-minimum)/(*brightness);   if (*saturation != 0.0)      {        if (r == *brightness) )         *hue=(g-b)/(*brightness-minimum); 
       else         if (g == *brightness) /           *hue=2.0+(b-r)/(*brightness-minimum);          else           if (b == *brightness) 1             *hue=4.0+(r-g)/(*brightness-minimum);        *hue=(*hue)*60.0;        if (*hue < 0.0)          *hue+=360.0;     }  }   H static void Contrast(int sign,Quantum *red,Quantum *green,Quantum *blue) {    double     brightness,      hue,     saturation, 
     theta;     /*K     Enhance contrast: dark color become darker, light color become lighter.    */?   TransformHSV(*red,*green,*blue,&hue,&saturation,&brightness);    theta=(brightness-0.5)*M_PI;?   brightness+=(((((sin(theta)+1.0))*0.5)-brightness)*sign)*0.5;    if (brightness > 1.0)      brightness=1.0;    else     if (brightness < 0)        brightness=0.0; 9   HSVTransform(hue,saturation,brightness,red,green,blue);  }   5 void ContrastImage(Image *image,unsigned int sharpen)  { > #define DullContrastImageText  "  Dulling image contrast...  "D #define SharpenContrastImageText  "  Sharpening image contrast...  "     int 	     sign;      register int     i;     register RunlengthPacket     *p;      sign=sharpen ? 1 : -1;   switch (image->class)    {      case DirectClass:      {        /*+         Contrast enhance DirectClass image.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { 2         Contrast(sign,&p->red,&p->green,&p->blue);         p++;!         if (QuantumTick(i,image))            if (sharpen)G             ProgressMonitor(SharpenContrastImageText,i,image->packets);            elseD             ProgressMonitor(DullContrastImageText,i,image->packets);       }        break;     }      case PseudoClass:      {        /*+         Contrast enhance PseudoClass image.        */'       for (i=0; i < image->colors; i++) H         Contrast(sign,&image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o p y I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function CopyImage returns a copy of all fields of the input image.  The B %  the pixel memory is allocated but the pixel data is not copied. % * %  The format of the CopyImage routine is: % ; %      copy_image=CopyImage(image,columns,rows,copy_pixels)  % + %  A description of each parameter follows:  % J %    o copy_image: Function CopyImage returns a pointer to the image afterH %      copying.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the copied 
 %      image.  % G %    o rows: An integer that specifies the number of rows in the copied 
 %      image.  % H %    o copy_pixels: Specifies whether the pixel data is copied.  Must be %      either True or False; %  %  */^ Image *CopyImage(Image *image,unsigned int columns,unsigned int rows,unsigned int copy_pixels) {    Image      *copy_image;     register int     i;     /*     Allocate image structure.    */-   copy_image=(Image *) malloc(sizeof(Image)); #   if (copy_image == (Image *) NULL)      return((Image *) NULL);    *copy_image=(*image); '   if (image->comments != (char *) NULL)      {        /*-         Allocate and copy the image comments.        */#       copy_image->comments=(char *) 9         malloc((unsigned int) strlen(image->comments)+1); 0       if (copy_image->comments == (char *) NULL)         return((Image *) NULL); :       (void) strcpy(copy_image->comments,image->comments);     } $   if (image->label != (char *) NULL)     {        /**         Allocate and copy the image label.       */O       copy_image->label=(char *) malloc((unsigned int) strlen(image->label)+1); -       if (copy_image->label == (char *) NULL)          return((Image *) NULL); 4       (void) strcpy(copy_image->label,image->label);     }    copy_image->columns=columns;   copy_image->rows=rows;$   copy_image->montage=(char *) NULL;&   copy_image->directory=(char *) NULL;.   if (image->colormap != (ColorPacket *) NULL)     {        /*-         Allocate and copy the image colormap.        */*       copy_image->colormap=(ColorPacket *)2         malloc(image->colors*sizeof(ColorPacket));7       if (copy_image->colormap == (ColorPacket *) NULL)          return((Image *) NULL); '       for (i=0; i < image->colors; i++) 3         copy_image->colormap[i]=image->colormap[i];      } (   if (image->signature != (char *) NULL)     {        /*.         Allocate and copy the image signature.       */$       copy_image->signature=(char *):         malloc((unsigned int) strlen(image->signature)+1);1       if (copy_image->signature == (char *) NULL)          return((Image *) NULL); <       (void) strcpy(copy_image->signature,image->signature);     }    /*     Allocate the image pixels.   */   if (copy_pixels)*     copy_image->pixels=(RunlengthPacket *)D       malloc((unsigned int) image->packets*sizeof(RunlengthPacket));   else     { ?       copy_image->packets=copy_image->columns*copy_image->rows; ,       copy_image->pixels=(RunlengthPacket *)K         malloc((unsigned int) copy_image->packets*sizeof(RunlengthPacket));      } 5   if (copy_image->pixels == (RunlengthPacket *) NULL)      return((Image *) NULL);    if (copy_pixels)     {        register RunlengthPacket         *p,          *q;          /*         Copy the image pixels.       */       p=image->pixels;       q=copy_image->pixels; (       for (i=0; i < image->packets; i++)       {          *q=(*p);         p++;         q++;       }      } #   if (image->page != (char *) NULL)      {        /*)         Allocate and copy the image page.        */M       copy_image->page=(char *) malloc((unsigned int) strlen(image->page)+1); ,       if (copy_image->page == (char *) NULL)         return((Image *) NULL); 2       (void) strcpy(copy_image->page,image->page);     }    if (image->orphan)     { %       copy_image->file=(FILE *) NULL; *       copy_image->previous=(Image *) NULL;&       copy_image->next=(Image *) NULL;     }    else     {        /*#         Link image into image list.        */1       if (copy_image->previous != (Image *) NULL) .         copy_image->previous->next=copy_image;-       if (copy_image->next != (Image *) NULL) .         copy_image->next->previous=copy_image;     }    copy_image->orphan=False;    return(copy_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C r o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function CropImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure andM %  returns a pointer to the new image.  This routine is optimized to perserve K %  the runlength encoding.  That is, the cropped image will always use less  %  memory than the original. % * %  The format of the CropImage routine is: % / %      cropped_image=CropImage(image,crop_info)  % + %  A description of each parameter follows:  % I %    o cropped_image: Function CropImage returns a pointer to the cropped J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o crop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */7 Image *CropImage(Image *image,RectangleInfo *crop_info)  { . #define CropImageText  "  Cropping image...  " #define DeltaX  16     Image      *cropped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check crop geometry.   */4   if (((crop_info->x+(int) crop_info->width) < 0) ||5       ((crop_info->y+(int) crop_info->height) < 0) || .       (crop_info->x > (int) image->columns) ||)       (crop_info->y > (int) image->rows))      { H       Warning("Unable to crop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((crop_info->x+(int) crop_info->width) > (int) image->columns) H     crop_info->width=(unsigned int) ((int) image->columns-crop_info->x);A   if ((crop_info->y+(int) crop_info->height) > (int) image->rows) F     crop_info->height=(unsigned int) ((int) image->rows-crop_info->y);   if (crop_info->x < 0)      { 7       crop_info->width-=(unsigned int) (-crop_info->x);        crop_info->x=0;      }    if (crop_info->y < 0)      { 8       crop_info->height-=(unsigned int) (-crop_info->y);       crop_info->y=0;      } :   if ((crop_info->width == 0) && (crop_info->height == 0))     {        register int
         i;         RunlengthPacket          corners[4];          /*1         Set bounding box to the image dimensions.        */       crop_info->width=0;        crop_info->height=0;"       crop_info->x=image->columns;       crop_info->y=image->rows;        p=image->pixels;#       image->runlength=p->length+1;        corners[0]=(*p);7       for (i=1; i <= (image->rows*image->columns); i++)        { "         if (image->runlength != 0)           image->runlength--;          else           {              p++;'             image->runlength=p->length;            }           if (i == image->columns)           corners[1]=(*p);?         if (i == (image->rows*image->columns-image->columns+1))            corners[2]=(*p);.         if (i == (image->rows*image->columns))           corners[3]=(*p);       }        p=image->pixels;#       image->runlength=p->length+1; %       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { $           if (image->runlength != 0)             image->runlength--;            else
             {                p++;)               image->runlength=p->length; 
             } @           if (((int) p->red >= (int) (corners[0].red+DeltaX)) ||@               ((int) p->red <= (int) (corners[0].red-DeltaX)) ||D               ((int) p->green >= (int) (corners[0].green+DeltaX)) ||D               ((int) p->green <= (int) (corners[0].green-DeltaX)) ||B               ((int) p->blue >= (int) (corners[0].blue+DeltaX)) ||@               ((int) p->blue <= (int) (corners[0].blue-DeltaX)))!             if (x < crop_info->x)                crop_info->x=x; @           if (((int) p->red >= (int) (corners[1].red+DeltaX)) ||@               ((int) p->red <= (int) (corners[1].red-DeltaX)) ||D               ((int) p->green >= (int) (corners[1].green+DeltaX)) ||D               ((int) p->green <= (int) (corners[1].green-DeltaX)) ||B               ((int) p->blue >= (int) (corners[1].blue+DeltaX)) ||@               ((int) p->blue <= (int) (corners[1].blue-DeltaX)))%             if (x > crop_info->width) !               crop_info->width=x; @           if (((int) p->red >= (int) (corners[0].red+DeltaX)) ||@               ((int) p->red <= (int) (corners[0].red-DeltaX)) ||D               ((int) p->green >= (int) (corners[0].green+DeltaX)) ||D               ((int) p->green <= (int) (corners[0].green-DeltaX)) ||B               ((int) p->blue >= (int) (corners[0].blue+DeltaX)) ||@               ((int) p->blue <= (int) (corners[0].blue-DeltaX)))!             if (y < crop_info->y)                crop_info->y=y; @           if (((int) p->red >= (int) (corners[2].red+DeltaX)) ||@               ((int) p->red <= (int) (corners[2].red-DeltaX)) ||D               ((int) p->green >= (int) (corners[2].green+DeltaX)) ||D               ((int) p->green <= (int) (corners[2].green-DeltaX)) ||B               ((int) p->blue >= (int) (corners[2].blue+DeltaX)) ||@               ((int) p->blue <= (int) (corners[2].blue-DeltaX)))&             if (y > crop_info->height)"               crop_info->height=y;	         }        } '       crop_info->width-=crop_info->x-1; (       crop_info->height-=crop_info->y-1;     } :   if ((crop_info->width == 0) || (crop_info->height == 0))     { E       Warning("Unable to crop image","geometry dimensions are zero");        return((Image *) NULL);      } -   if ((crop_info->width == image->columns) && B       (crop_info->height == image->rows) && (crop_info->x == 0) &&       (crop_info->y == 0))     return((Image *) NULL);    /*(     Initialize cropped image attributes.   */I   cropped_image=CopyImage(image,crop_info->width,crop_info->height,True); &   if (cropped_image == (Image *) NULL)     { A       Warning("Unable to crop image","Memory allocation failed");        return((Image *) NULL);      }    /*(     Skip pixels up to the cropped image.   */   p=image->pixels;   image->runlength=p->length+1; @   for (x=0; x < (crop_info->y*image->columns+crop_info->x); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract cropped image.   */   cropped_image->packets=0;    q=cropped_image->pixels;   q->red=0; 
   q->green=0;    q->blue=0;
   q->index=0;    q->length=MaxRunlength; -   for (y=0; y < (cropped_image->rows-1); y++)    {      /*       Transfer scanline.     */.     for (x=0; x < cropped_image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { *           if (cropped_image->packets != 0)             q++;#           cropped_image->packets++;            *q=(*p);           q->length=0;	         }      }      /*       Skip to next scanline.     */?     for (x=0; x < (image->columns-cropped_image->columns); x++)         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } ;     ProgressMonitor(CropImageText,y,cropped_image->rows-1);    }    /*     Transfer last scanline.    */,   for (x=0; x < cropped_image->columns; x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        } 7     if ((p->red == q->red) && (p->green == q->green) && 9         (p->blue == q->blue) && (p->index == q->index) && )         ((int) q->length < MaxRunlength))        q->length++;     else       { (         if (cropped_image->packets != 0)           q++;!         cropped_image->packets++;          *q=(*p);         q->length=0;       }    } <   cropped_image->pixels=(RunlengthPacket *) realloc((char *)J     cropped_image->pixels,cropped_image->packets*sizeof(RunlengthPacket));   return(cropped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s c r i b e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DescribeImage describes an image by printing its attributes to
 %  stderr. % . %  The format of the DescribeImage routine is: % ( %      DescribeImage(image,file,verbose) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 4 %    o file: send the image attributes to this file. % M %    o verbose: an unsigned value other than zero prints detailed information  %      about the image.  %  %  */@ void DescribeImage(Image *image,FILE *file,unsigned int verbose) {    char     **textlist;      Image      *p;      register int     i;     unsigned int
     count;     if (!verbose)      {        /*.         Display detailed info about the image.       */*       if (*image->magick_filename != '\0')@         if (strcmp(image->magick_filename,image->filename) != 0)=           (void) fprintf(file,"%s=>",image->magick_filename); 1        if ((image->previous == (Image *) NULL) && B            (image->next == (Image *) NULL) && (image->scene == 0))3         (void) fprintf(file,"%s ",image->filename); 
       elseD         (void) fprintf(file,"%s[%u] ",image->filename,image->scene);D       if ((image->magick_columns != 0) || (image->magick_rows != 0))8         if ((image->magick_columns != image->columns) ||0             (image->magick_rows != image->rows))>           (void) fprintf(file,"%ux%u=>",image->magick_columns,              image->magick_rows);?       (void) fprintf(file,"%ux%u ",image->columns,image->rows); &       if (image->class == DirectClass)	         { .           (void) fprintf(file,"DirectClass ");'           if (image->total_colors != 0) =             (void) fprintf(file,"%luc ",image->total_colors); 	         } 
       else1         if (image->total_colors <= image->colors) @           (void) fprintf(file,"PseudoClass %uc ",image->colors);         else           { L             (void) fprintf(file,"PseudoClass %lu=>%uc ",image->total_colors,               image->colors); M             (void) fprintf(file,"%u/%.6f/%.6fe ",image->mean_error_per_pixel, L               image->normalized_mean_error,image->normalized_maximum_error);           }        if (image->filesize != 0) 5         (void) fprintf(file,"%ldb ",image->filesize); J       (void) fprintf(file,"%s %lds\n",image->magick,time((time_t *) NULL)-         image->magick_time+1);
       return;      }    /*)     Display verbose info about the image.    */5   (void) fprintf(file,"Image: %s\n",image->filename); "   if (image->class == DirectClass)2     (void) fprintf(file,"  class: DirectClass\n");   else2     (void) fprintf(file,"  class: PseudoClass\n");"   if (image->class == DirectClass)     { "       if (image->total_colors > 0)C         (void) fprintf(file,"  colors: %lu\n",image->total_colors);      }    else-     if (image->total_colors <= image->colors) :       (void) fprintf(file,"  colors: %u\n",image->colors);     elseD       (void) fprintf(file,"  colors: %lu=>%u\n",image->total_colors,         image->colors); "   if (image->class == PseudoClass)     { 
       char         name[MaxTextLength];         ColorPacket          *p;          double         distance_squared,          min_distance;   	       int          distance;          register int
         i;         register XColorlist          *q;          /*         Display image colormap.        */       p=image->colormap;'       for (i=0; i < image->colors; i++)        { C         (void) fprintf(file,"    %d: (%3d,%3d,%3d)  #%02x%02x%02x", :           i,p->red,p->green,p->blue,(unsigned int) p->red,:           (unsigned int) p->green,(unsigned int) p->blue);)         min_distance=3.0*65536.0*65536.0; 8         for (q=Colorlist; q->name != (char *) NULL; q++)	         { 8           distance=(int) DownScale(p->red)-(int) q->red;>           distance_squared=(unsigned int) (distance*distance);<           distance=(int) DownScale(p->green)-(int) q->green;?           distance_squared+=(unsigned int) (distance*distance); :           distance=(int) DownScale(p->blue)-(int) q->blue;?           distance_squared+=(unsigned int) (distance*distance); .           if (distance_squared < min_distance)
             { ,               min_distance=distance_squared;*               (void) strcpy(name,q->name);
             } 	         } "         (void) fprintf(file,"  ");         if (min_distance < 16)           { !             if (min_distance > 0) '               (void) fprintf(file,"~"); +             (void) fprintf(file,"%s",name);            } "         (void) fprintf(file,"\n");         p++;       }      } (   if (image->signature != (char *) NULL)>     (void) fprintf(file,"  signature: %s\n",image->signature);   if (image->matte) +     (void) fprintf(file,"  matte: True\n");    else,     (void) fprintf(file,"  matte: False\n");   if (image->gamma != 0.0)6     (void) fprintf(file,"  depth: %f\n",image->gamma);4   if (image->packets < (image->columns*image->rows))I     (void) fprintf(file,"  runlength packets: %u of %u\n",image->packets, "       image->columns*image->rows);H   (void) fprintf(file,"  geometry: %ux%u\n",image->columns,image->rows);4   (void) fprintf(file,"  depth: %u\n",image->depth);   if (image->filesize != 0) :     (void) fprintf(file,"  bytes: %ld\n",image->filesize);   if (image->interlace) 0     (void) fprintf(file,"  interlaced: True\n");   else1     (void) fprintf(file,"  interlaced: False\n"); #   if (image->page != (char *) NULL) =     (void) fprintf(file,"  page geometry: %s\n",image->page); $   if (image->delay != (char *) NULL)6     (void) fprintf(file,"  delay: %s\n",image->delay);6   (void) fprintf(file,"  format: %s\n",image->magick);
   p=image;'   while (p->previous != (Image *) NULL)      p=p->previous;3   for (count=1; p->next != (Image *) NULL; count++)      p=p->next;   if (count > 1)B     (void) fprintf(file,"  scene: %u of %u\n",image->scene,count);   else     if (image->scene != 0)8       (void) fprintf(file,"  scene: %u\n",image->scene);$   if (image->label != (char *) NULL)6     (void) fprintf(file,"  label: %s\n",image->label);'   if (image->comments != (char *) NULL)      {        /*         Display image comment.       */+       (void) fprintf(file,"  comments:\n"); -       textlist=StringToList(image->comments); %       if (textlist != (char **) NULL) 	         { 6           for (i=0; textlist[i] != (char *) NULL; i++)           { 6             (void) fprintf(file,"  %s\n",textlist[i]);             free(textlist[i]);           } "           free((char *) textlist);	         }      } &   if (image->montage != (char *) NULL):     (void) fprintf(file,"  montage: %s\n",image->montage);(   if (image->directory != (char *) NULL)     { 
       char          filename[MaxTextLength];         Image          *tile;         ImageInfo          image_info;          register char          *p,          *q;          /*'         Display visual image directory.        */        GetImageInfo(&image_info);#       image_info.filename=filename;        image_info.size="64x64";,       (void) fprintf(file,"  directory:\n");/       for (p=image->directory; *p != '\0'; p++)        {          q=p;,         while ((*q != '\n') && (*q != '\0'))           q++;2         (void) strncpy(image_info.filename,p,q-p);&         image_info.filename[q-p]='\0';         p=q;:         (void) fprintf(file,"    %s",image_info.filename);$         tile=ReadImage(&image_info);#         if (tile == (Image *) NULL)            { &             (void) fprintf(file,"\n");             continue;            } ?         (void) fprintf(file," %ux%u %s\n",tile->magick_columns, *           tile->magick_rows,tile->magick);,         if (tile->comments != (char *) NULL)           {              /*#               Display tile comment.              */2             textlist=StringToList(tile->comments);+             if (textlist != (char **) NULL)                { <                 for (i=0; textlist[i] != (char *) NULL; i++)                 { >                   (void) fprintf(file,"    %s\n",textlist[i]);$                   free(textlist[i]);                 } (                 free((char *) textlist);               }            }          DestroyImage(tile);        }      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     D e s p e c k l e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function DespeckleImage creates a new image that is a copy of an existingI %  one with the speckle noise minified.  It uses the eight hull algorithm O %  described in Applied Optics, Vol. 24, No. 10, 15 May 1985, "Geometric filter L %  for Speckle Reduction", by Thomas R Crimmins.  Each pixel in the image isN %  replaced by one of its eight of its surrounding pixels using a polarity andM %  negative hull function.  DespeckleImage allocates the memory necessary for B %  the new Image structure and returns a pointer to the new image. % / %  The format of the DespeckleImage routine is:  % - %      despeckled_image=DespeckleImage(image)  % + %  A description of each parameter follows:  % O %    o despeckled_image: Function DespeckleImage returns a pointer to the image M %      after it is despeckled.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  8 static void Hull(int x_offset,int y_offset,int polarity,?   unsigned int columns,unsigned int rows,Quantum *f,Quantum *g)  {    int      y;     register int     x;     register Quantum     *p,      *q,      *r,      *s;   	   Quantum      v;     p=f+(columns+2);   q=g+(columns+2);,   r=p+(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*p);          if (*r > v)            v++;
         *q=v;          p++;         q++;         r++;       }      else!       for (x=0; x < columns; x++)        {          v=(*p); !         if (v > (Quantum) (*r+1))            v--;
         *q=v;          p++;         q++;         r++;       }      p++;     q++;     r++;   }    p=f+(columns+2);   q=g+(columns+2);,   r=q+(y_offset*((int) columns+2)+x_offset);,   s=q-(y_offset*((int) columns+2)+x_offset);   for (y=0; y < rows; y++)   {      p++;     q++;     r++;     s++;     if (polarity > 0) !       for (x=0; x < columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) > v) && (*r > v))            v++;
         *p=v;          p++;         q++;         r++;         s++;       }      else!       for (x=0; x < columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) < v) && (*r < v))            v--;
         *p=v;          p++;         q++;         r++;         s++;       }      p++;     q++;     r++;     s++;   }  }   # Image *DespeckleImage(Image *image)  { 6 #define DespeckleImageText  "  Despeckling image...  "     Image      *despeckled_image;     int      x;  	   Quantum      *blue_channel,     *buffer,     *green_channel,      *matte_channel,      *red_channel;      register int     i,     j;     register RunlengthPacket     *p,      *q;      static int     X[4]= {0, 1, 1,-1},      Y[4]= {1, 0, 1, 1};      unsigned int     packets;     /*     Allocate despeckled image.   */E   despeckled_image=CopyImage(image,image->columns,image->rows,False); )   if (despeckled_image == (Image *) NULL)      { F       Warning("Unable to despeckle image","Memory allocation failed");       return((Image *) NULL);      } &   despeckled_image->class=DirectClass;   /*     Allocate image buffers.    */-   packets=(image->columns+2)*(image->rows+2); :   red_channel=(Quantum *) malloc(packets*sizeof(Quantum));<   green_channel=(Quantum *) malloc(packets*sizeof(Quantum));;   blue_channel=(Quantum *) malloc(packets*sizeof(Quantum)); <   matte_channel=(Quantum *) malloc(packets*sizeof(Quantum));5   buffer=(Quantum *) malloc(packets*sizeof(Quantum)); *   if ((red_channel == (Quantum *) NULL) ||,       (green_channel == (Quantum *) NULL) ||+       (blue_channel == (Quantum *) NULL) || ,       (matte_channel == (Quantum *) NULL) ||>       (buffer == (Quantum *) NULL) || !UncompressImage(image))     { F       Warning("Unable to despeckle image","Memory allocation failed");%       DestroyImage(despeckled_image);        return((Image *) NULL);      }    /*     Zero image buffers.    */   for (i=0; i < packets; i++)    {      red_channel[i]=0;      green_channel[i]=0;      blue_channel[i]=0;     matte_channel[i]=0;      buffer[i]=0;   }    /*0     Copy image pixels to color component buffers   */   x=image->columns+2;    p=image->pixels;!   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        red_channel[x]=p->red;        green_channel[x]=p->green;       blue_channel[x]=p->blue;        matte_channel[x]=p->index;
       x++;
       p++;     }      x++;   }    /*"     Reduce speckle in red channel.   */   for (i=0; i < 4; i++)    { -     ProgressMonitor(DespeckleImageText,i,12); D     Hull(X[i],Y[i],1,image->columns,image->rows,red_channel,buffer);F     Hull(-X[i],-Y[i],1,image->columns,image->rows,red_channel,buffer);G     Hull(-X[i],-Y[i],-1,image->columns,image->rows,red_channel,buffer); E     Hull(X[i],Y[i],-1,image->columns,image->rows,red_channel,buffer);    }    /*$     Reduce speckle in green channel.   */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { /     ProgressMonitor(DespeckleImageText,i+4,12); F     Hull(X[i],Y[i],1,image->columns,image->rows,green_channel,buffer);H     Hull(-X[i],-Y[i],1,image->columns,image->rows,green_channel,buffer);I     Hull(-X[i],-Y[i],-1,image->columns,image->rows,green_channel,buffer); G     Hull(X[i],Y[i],-1,image->columns,image->rows,green_channel,buffer);    }    /*#     Reduce speckle in blue channel.    */   for (i=0; i < packets; i++)      buffer[i]=0;   for (i=0; i < 4; i++)    { /     ProgressMonitor(DespeckleImageText,i+8,12); E     Hull(X[i],Y[i],1,image->columns,image->rows,blue_channel,buffer); G     Hull(-X[i],-Y[i],1,image->columns,image->rows,blue_channel,buffer); H     Hull(-X[i],-Y[i],-1,image->columns,image->rows,blue_channel,buffer);F     Hull(X[i],Y[i],-1,image->columns,image->rows,blue_channel,buffer);   }    /*5     Copy color component buffers to despeckled image.    */   x=image->columns+2;    q=despeckled_image->pixels; !   for (j=0; j < image->rows; j++)    {      x++;&     for (i=0; i < image->columns; i++)     {        q->red=red_channel[x];        q->green=green_channel[x];       q->blue=blue_channel[x];        q->index=matte_channel[x];       q->length=0;
       q++;
       x++;     }      x++;   }    /*     Free memory.   */   free((char *) buffer);   free((char *) blue_channel);   free((char *) green_channel);    free((char *) red_channel);    return(despeckled_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function DestroyImage deallocates memory associated with an image.  % - %  The format of the DestroyImage routine is:  %  %      DestroyImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void DestroyImage(Image *image)  {    if (image == (Image *) NULL)     return;    /*     Close image.   */   CloseImage(image);   /*"     Deallocate the image comments.   */'   if (image->comments != (char *) NULL) #     free((char *) image->comments);    /*     Deallocate the image label.    */$   if (image->label != (char *) NULL)      free((char *) image->label);   /*+     Deallocate the image montage directory.    */&   if (image->montage != (char *) NULL)"     free((char *) image->montage);(   if (image->directory != (char *) NULL)$     free((char *) image->directory);   /*"     Deallocate the image colormap.   */.   if (image->colormap != (ColorPacket *) NULL)#     free((char *) image->colormap);    /*#     Deallocate the image signature.    */(   if (image->signature != (char *) NULL)$     free((char *) image->signature);   /*      Deallocate the image pixels.   */0   if (image->pixels != (RunlengthPacket *) NULL)!     free((char *) image->pixels); 5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);   /*'     Deallocate the image page geometry.    */#   if (image->page != (char *) NULL)      free((char *) image->page);    /*     Deallocate the image delay.    */$   if (image->delay != (char *) NULL)      free((char *) image->delay);   /*#     Deallocate the image structure.    */   free((char *) image);    image=(Image *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DestroyImages deallocates memory associated with a linked list
 %  of images.  % . %  The format of the DestroyImages routine is: %  %      DestroyImages(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */  void DestroyImages(Image *image) {    Image      *next_image;     if (image == (Image *) NULL)     return;    /*)     Proceed to the top of the image list.    */+   while (image->previous != (Image *) NULL)      image=image->previous;   do   {      /*       Destroy this image.      */     next_image=image->next;      DestroyImage(image);     image=next_image; $   } while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D r a w I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function DrawImage draws a primitive (line, rectangle, ellipse) on the 	 %  image.  % * %  The format of the DrawImage routine is: % % %      DrawImage(image,annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % : %    o annotate_info: The address of a DrawInfo structure. %  %  */  B static unsigned int InsidePrimitive(PrimitiveInfo *primitive_info,7   AnnotateInfo *annotate_info,int x,int y,Image *image)  {    register unsigned int      inside;      register PrimitiveInfo     *p,      *q;      inside=False;    p=primitive_info; ,   while (p->primitive != UndefinedPrimitive)   {      q=p+p->coordinates-1;      switch (p->primitive)      { "       case FillRectanglePrimitive:       default:       { H         inside=(x >= p->x) && (y >= p->y) && (x <= q->x) && (y <= q->y);         p+=p->coordinates;         break;       }         case FillEllipsePrimitive:       { ;         inside=(((p->y-y)*(p->y-y))+((p->x-x)*(p->x-x))) <= @           (((p->y-q->y)*(p->y-q->y))+((p->x-q->x)*(p->x-q->x)));         p+=p->coordinates;         break;       }         case FillPolygonPrimitive:       {          int            crossing,            crossings;           crossings=0;'         if ((q->y >= y) != (p->y >= y))            {              crossing=q->x >= x; (             if (crossing != (p->x >= x))F               crossings+=(q->x-(q->y-y)*(p->x-q->x)/(p->y-q->y)) >= x;             else               if (crossing)                  crossings++;           }          for (p++; p <= q; p++)	         {            if ((p-1)->y >= y)
             { -               while ((p <= q) && (p->y >= y))                  p++;               if (p > q)                 break;%               crossing=(p-1)->x >= x; *               if (crossing != (p->x >= x))                 crossings+= O                   ((p-1)->x-((p-1)->y-y)*(p->x-(p-1)->x)/(p->y-(p-1)->y)) >= x;                else                 if (crossing)                    crossings++;               continue; 
             } '          while ((p <= q) && (p->y < y))             p++;           if (p > q)             break;            crossing=(p-1)->x >= x;%          if (crossing != (p->x >= x))             crossings+=J              ((p-1)->x-((p-1)->y-y)*(p->x-(p-1)->x)/(p->y-(p-1)->y)) >= x;
          else             if (crossing)              crossings++; 	         }           inside=crossings & 0x01;         break;       }        case TextPrimitive:        case ImagePrimitive:       {          register char 
           *q;   '         if ((p->x != x) || (p->y != y))            {              p+=p->coordinates;             break;           }          q=p->text;         if (*q != '"')6           for (q++; (*q != ' ') && (*q != '\0'); q++);         else           {              p->text++;8             for (q++; (*q != '"') && (*q != '\0'); q++);           } >         (void) strncpy(annotate_info->text,p->text,q-p->text);,         annotate_info->text[q-p->text]='\0';*         if (p->primitive == TextPrimitive)           { G             (void) sprintf(annotate_info->geometry,"%+d%+d",p->x,p->y); /             AnnotateImage(image,annotate_info);            }          else           {              Image                *composite_image;                ImageInfo                composite_info;   *             GetImageInfo(&composite_info);G             (void) strcpy(composite_info.filename,annotate_info->text); 7             composite_image=ReadImage(&composite_info); 2             if (composite_image != (Image *) NULL)               { H                 CompositeImage(image,ReplaceCompositeOp,composite_image,                   p->x,p->y); .                 DestroyImage(composite_image);               }            }          p+=p->coordinates;         break;       }      }      if (inside)        return(True);    }    return(inside);  }   8 void DrawImage(Image *image,AnnotateInfo *annotate_info) { 0 #define DrawImageText  "  Drawing on image...  "     char
     *stop;     int      y;     PrimitiveInfo      *primitive_info;     register char      *p;      register int     i,     j,     x;     register RunlengthPacket     *q;      unsigned int     indirection,     length,      number_coordinates,      primitive;     XColor     pen_color;  0   if (annotate_info->primitive == (char *) NULL)     return;    if (!UncompressImage(image))     return; 1   indirection=(*annotate_info->primitive == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         register char          *q;          /*         Read text from a file.       */:       file=(FILE *) fopen(annotate_info->primitive+1,"r");        if (file == (FILE *) NULL)	         { N           Warning("Unable to read primitive file",annotate_info->primitive+1);           return; 	         }        length=MaxTextLength; 7       annotate_info->primitive=(char *) malloc(length); !       q=annotate_info->primitive; 7       while (annotate_info->primitive != (char *) NULL)        {          c=fgetc(file);         if (c == EOF)            break;5         if ((q-annotate_info->primitive+1) >= length)            {              *q='\0';             length<<=1; -             annotate_info->primitive=(char *) 7               realloc(annotate_info->primitive,length); :             if (annotate_info->primitive == (char *) NULL)               break;H             q=annotate_info->primitive+strlen(annotate_info->primitive);           }          *q++=(unsigned char) c;        }        (void) fclose(file);4       if (annotate_info->primitive == (char *) NULL)	         { E           Warning("Unable to draw image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*#     Allocate primitive info memory.    */   number_coordinates=2048;"   primitive_info=(PrimitiveInfo *)5     malloc(number_coordinates*sizeof(PrimitiveInfo)); F   annotate_info->geometry=(char *) malloc(MaxTextLength*sizeof(char));   annotate_info->text=(char *):     malloc(strlen(annotate_info->primitive)*sizeof(char));3   if ((primitive_info == (PrimitiveInfo *) NULL) || 3       (annotate_info->geometry == (char *) NULL) || -       (annotate_info->text == (char *) NULL))      {        if (indirection)0         free((char *) annotate_info->primitive);A       Warning("Unable to draw image","Memory allocation failed"); 
       return;      }    /*#     Parse the primitive attributes.    */<   (void) XQueryColorDatabase(annotate_info->pen,&pen_color);   image->class=DirectClass;    primitive=UndefinedPrimitive;    p=annotate_info->primitive;    for (i=0; *p != '\0'; )    {      while (isspace(*p)) 
       p++;!     primitive=UndefinedPrimitive; &     if (strncmp("rectangle",p,4) == 0)'       primitive=FillRectanglePrimitive; #     if (strncmp("circle",p,4) == 0) %       primitive=FillEllipsePrimitive; $     if (strncmp("polygon",p,4) == 0)%       primitive=FillPolygonPrimitive; !     if (strncmp("text",p,4) == 0)        primitive=TextPrimitive;"     if (strncmp("image",p,4) == 0)       primitive=ImagePrimitive; (     if (primitive == UndefinedPrimitive)       break;     while (isalpha(*p)) 
       p++;     j=i;     for (x=0; *p != '\0'; x++)     {        while (isspace(*p))          p++;       if (!isdigit(*p))          break;,       primitive_info[i].primitive=primitive;&       primitive_info[i].coordinates=0;,       primitive_info[i].x=strtol(p,&stop,0);
       p=stop; (       while (isspace(*p) || (*p == ','))         p++;       if (!isdigit(*p))          break;,       primitive_info[i].y=strtol(p,&stop,0);
       p=stop; 
       i++;&       if (i == (number_coordinates-1))	         { !           number_coordinates<<=1; *           primitive_info=(PrimitiveInfo *)M             realloc(primitive_info,number_coordinates*sizeof(PrimitiveInfo)); 7           if (primitive_info == (PrimitiveInfo *) NULL) 
             {                if (indirection)8                 free((char *) annotate_info->primitive);5               free((char *) annotate_info->geometry); 1               free((char *) annotate_info->text); I               Warning("Unable to draw image","Memory allocation failed");                return; 
             } 	         }      } $     primitive_info[j].coordinates=x;)     primitive_info[j].text=(char *) NULL; F     if ((primitive == TextPrimitive) || (primitive == ImagePrimitive))       { !         primitive_info[j].text=p;          if (*p == '"')6           for (p++; (*p != '"') && (*p != '\0'); p++);         else6           for (p++; (*p != ' ') && (*p != '\0'); p++);         if (*p != '\0')            p++;       }    } 1   primitive_info[i].primitive=UndefinedPrimitive; &   if (primitive == UndefinedPrimitive)     { ?       Warning("Non-conforming drawing primitive definition",p); $       free((char *) primitive_info);       if (indirection)0         free((char *) annotate_info->primitive);-       free((char *) annotate_info->geometry); )       free((char *) annotate_info->text); 
       return;      }    /*$     Draw the primitive on the image.   */   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { B       if (InsidePrimitive(primitive_info,annotate_info,x,y,image))	         { +           q->red=XDownScale(pen_color.red); /           q->green=XDownScale(pen_color.green); -           q->blue=XDownScale(pen_color.blue); 	         } 
       q++;     } 1     ProgressMonitor(DrawImageText,y,image->rows);    }     free((char *) primitive_info);   if (indirection),     free((char *) annotate_info->primitive);)   free((char *) annotate_info->geometry); %   free((char *) annotate_info->text);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E m b o s s I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function EmbossImage creates a new image that is a copy of an existing L %  one with the edge highlighted.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. % N %  EmbossImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1 -2  0 
 %    -2  0  2 
 %     0  2  1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % , %  The format of the EmbossImage routine is: % ( %      embossed_image=EmbossImage(image) % + %  A description of each parameter follows:  % J %    o embossed_image: Function EmbossImage returns a pointer to the imageK %      after it is embossed.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  Image *EmbossImage(Image *image) { 1 #define EmbossImageText  "  Embossing image...  "  #define Emboss(weight) \'   total_red+=(weight)*(int) (s->red); \ +   total_green+=(weight)*(int) (s->green); \ )   total_blue+=(weight)*(int) (s->blue); \    s++;     Image      *embossed_image;     long     total_blue,      total_green,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to emboss image","image size must exceed 3x3");        return((Image *) NULL);      }    /*)     Initialize embossed image attributes.    */C   embossed_image=CopyImage(image,image->columns,image->rows,False); '   if (embossed_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   embossed_image->class=DirectClass;   /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(embossed_image);        return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=embossed_image->pixels; $   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */%   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0; 
       s=s1+1;        s=s0; )       Emboss(-1); Emboss(-2); Emboss( 0);        s=s1; )       Emboss(-2); Emboss( 0); Emboss( 2);        s=s2; )       Emboss( 0); Emboss( 2); Emboss( 1); !       total_red+=(MaxRGB+1) >> 1;        if (total_red < 0)         total_red=0;
       else         if (total_red > MaxRGB)            total_red=MaxRGB; #       total_green+=(MaxRGB+1) >> 1;        if (total_green < 0)         total_green=0;
       else!         if (total_green > MaxRGB)            total_green=MaxRGB; "       total_blue+=(MaxRGB+1) >> 1;       if (total_blue < 0)          total_blue=0; 
       else          if (total_blue > MaxRGB)           total_blue=MaxRGB;!       q->red=(Quantum) total_red; %       q->green=(Quantum) total_green; #       q->blue=(Quantum) total_blue;        q->index=s1->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;5     ProgressMonitor(EmbossImageText,y,image->rows-1);    }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*.     Convert image to Gray_scale and normalize.   */$   embossed_image->class=DirectClass;%   (void) IsGrayImage(embossed_image); !   NormalizeImage(embossed_image);    return(embossed_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E d g e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function EdgeImage creates a new image that is a copy of an existing M %  one with the edges highlighted.  It allocates the memory necessary for the > %  new Image structure and returns a pointer to the new image. % L %  EdgeImage convolves the pixel neighborhood with this edge detection mask: % 
 %    -1  0 -1 
 %     0  W  0 
 %    -1  0 -1  % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % * %  The format of the EdgeImage routine is: % * %      edged_image=EdgeImage(image,factor) % + %  A description of each parameter follows:  % E %    o edged_image: Function EdgeImage returns a pointer to the image H %      after it is edged.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %  %  */, Image *EdgeImage(Image *image,double factor) {  #define Edge(weight) \0   total_red+=(long) ((weight)*(int) (s->red)); \4   total_green+=(long) ((weight)*(int) (s->green)); \2   total_blue+=(long) ((weight)*(int) (s->blue)); \4   total_index+=(long) ((weight)*(int) (s->index)); \   s++;5 #define EdgeImageText  "  Detecting image edges...  "      double     weight;      Image      *edged_image;      long     total_blue,      total_green,     total_index,     total_red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket      background_pixel,      *scanline;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { E       Warning("Unable to detect edges","image size must exceed 3x3");        return((Image *) NULL);      }    /*&     Initialize edged image attributes.   */@   edged_image=CopyImage(image,image->columns,image->rows,False);$   if (edged_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } !   edged_image->class=DirectClass;    /*6     Allocate scan line buffer for 3 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");        DestroyImage(edged_image);       return((Image *) NULL);      }    /*)     Read the first two rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*"     Dump first scanlines of image.   */   background_pixel.red=0;    background_pixel.green=0;    background_pixel.blue=0;   background_pixel.index=0;    background_pixel.length=0;   q=edged_image->pixels;$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    /*     Convolve each row.   */!   weight=((100.0-factor)/20)+1.5; %   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-1) % 3); '     s1=scanline+image->columns*(y % 3); +     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.      */	     s=s2; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*+       Transfer first pixel of the scanline.      */     *q=background_pixel;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        total_index=0;
       s=s1+1;        s=s0; 1       Edge(-weight/4); Edge( 0); Edge(-weight/4);        s=s1; '       Edge( 0); Edge(weight); Edge( 0);        s=s2; 1       Edge(-weight/4); Edge( 0); Edge(-weight/4);        if (total_red < 0)         q->red=0; 
       else         if (total_red > MaxRGB)            q->red=MaxRGB;         else%           q->red=(Quantum) total_red;        if (total_green < 0)         q->green=0; 
       else!         if (total_green > MaxRGB)            q->green=MaxRGB;         else)           q->green=(Quantum) total_green;        if (total_blue < 0)          q->blue=0;
       else          if (total_blue > MaxRGB)           q->blue=MaxRGB;          else'           q->blue=(Quantum) total_blue;        if (total_index < 0)         q->index=0; 
       else!         if (total_index > MaxRGB)            q->index=MaxRGB;         else0           q->index=(unsigned short) total_index;       q->length=0;
       q++;       s0++;        s1++;        s2++;      }      /**       Transfer last pixel of the scanline.     */     *q=background_pixel;     q++;3     ProgressMonitor(EdgeImageText,y,image->rows-1);    }    /*!     Dump last scanline of pixels.    */$   for (x=0; x < image->columns; x++)   {      *q=background_pixel;     q++;   }    free((char *) scanline);   /*     Normalize image.   */   NormalizeImage(edged_image);   return(edged_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E n h a n c e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EnhanceImage creates a new image that is a copy of an existingN %  one with the noise minified.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. % K %  EnhanceImage does a weighted average of pixels in a 5x5 cell around each L %  target pixel.  Only pixels in the 5x5 cell that are within a RGB distance. %  threshold of the target pixel are averaged. % G %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.  % - %  The format of the EnhanceImage routine is:  % ) %      enhanced_image=EnhanceImage(image)  % + %  A description of each parameter follows:  % K %    o enhanced_image: Function EnhanceImage returns a pointer to the image K %      after it is enhanced.  A null image is returned if there is a memory  %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */! Image *EnhanceImage(Image *image)  {  #define Enhance(weight) \ $   distance=(int) s->red-(int) red; \'   distance_squared=squares[distance]; \ (   distance=(int) s->green-(int) green; \(   distance_squared+=squares[distance]; \&   distance=(int) s->blue-(int) blue; \(   distance_squared+=squares[distance]; \%   if (distance_squared < Threshold) \      { \ %       total_red+=(weight)*(s->red); \ )       total_green+=(weight)*(s->green); \ '       total_blue+=(weight)*(s->blue); \        total_weight+=(weight); \      } \    s++;2 #define EnhanceImageText  "  Enhancing image...  " #define Threshold  2500      double     distance_squared;      Image      *enhanced_image;     int 
     distance,      i;  	   Quantum 	     blue, 
     green,     red;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2,     *s3,     *s4;     register unsigned int 
     *squares;      RunlengthPacket      *scanline;     unsigned int     x,     y;     unsigned long      total_blue,      total_green,     total_red,     total_weight;   0   if ((image->columns < 5) || (image->rows < 5))     { F       Warning("Unable to enhance image","image size must exceed 4x4");       return((Image *) NULL);      }    /*)     Initialize enhanced image attributes.    */C   enhanced_image=CopyImage(image,image->columns,image->rows,False); '   if (enhanced_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } $   enhanced_image->class=DirectClass;   /*6     Allocate scan line buffer for 5 rows of the image.   */P   scanline=(RunlengthPacket *) malloc(5*image->columns*sizeof(RunlengthPacket));J   squares=(unsigned int *) malloc((MaxRGB+MaxRGB+1)*sizeof(unsigned int));/   if ((scanline == (RunlengthPacket *) NULL) || )       (squares == (unsigned int *) NULL))      { D       Warning("Unable to enhance image","Memory allocation failed");#       DestroyImage(enhanced_image);        return((Image *) NULL);      }    squares+=MaxRGB;%   for (i=(-MaxRGB); i <= MaxRGB; i++)      squares[i]=i*i;    /*'     Read the first 4 rows of the image.    */   p=image->pixels;   image->runlength=p->length+1; 
   s=scanline; (   for (x=0; x < (image->columns*4); x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*$     Dump first 2 scanlines of image.   */   q=enhanced_image->pixels; 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    /*     Enhance each row.    */%   for (y=2; y < (image->rows-2); y++)    {      /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y-2) % 5); +     s1=scanline+image->columns*((y-1) % 5); '     s2=scanline+image->columns*(y % 5); +     s3=scanline+image->columns*((y+1) % 5); +     s4=scanline+image->columns*((y+2) % 5);      /*       Read another scan line.      */	     s=s4; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*.       Transfer first 2 pixels of the scanline.     */	     s=s2;      for (x=0; x < 2; x++)      {        *q=(*s);       q->length=0;
       q++;
       s++;     } *     for (x=2; x < (image->columns-2); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        total_weight=0; 
       s=s2+2;        red=s->red;        green=s->green;        blue=s->blue;        s=s0; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5);        s=s1; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=s2; F       Enhance(10); Enhance(40); Enhance(80); Enhance(40); Enhance(10);       s=s3; E       Enhance(8);  Enhance(20); Enhance(40); Enhance(20); Enhance(8);        s=s4; E       Enhance(5);  Enhance(8);  Enhance(10); Enhance(8);  Enhance(5); H       q->red=(Quantum) ((total_red+(total_weight >> 1)-1)/total_weight);M       q->green= (Quantum) ((total_green+(total_weight >> 1)-1)/total_weight); J       q->blue=(Quantum) ((total_blue+(total_weight >> 1)-1)/total_weight);       q->index=s2->index;        q->length=0;
       q++;       s0++;        s1++;        s2++;        s3++;        s4++;      }      /*-       Transfer last 2 pixels of the scanline.      */	     s=s2;      for (x=0; x < 2; x++)      {        *q=(*s);       q->length=0;
       q++;
       s++;     } 6     ProgressMonitor(EnhanceImageText,y,image->rows-2);   }    /*$     Dump last 2 scanlines of pixels.   */$   s=scanline+image->columns*(y % 5);+   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    squares-=MaxRGB;   free((char *) squares);    free((char *) scanline);   return(enhanced_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E q u a l i z e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EqualizeImage performs histogram equalization on the reference	 %  image.  % . %  The format of the EqualizeImage routine is: %  %      EqualizeImage(image)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  void EqualizeImage(Image *image) {%4 #define EqualizeImageText  "  Equalizing image...  "  	   Quantum      *equalize_map;     register int     i,     j;     register RunlengthPacket     *p;      unsigned int	     high,      *histogram,      low,	     *map;      /*-     Allocate and initialize histogram arrays.    */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); ?   map=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); >   equalize_map=(Quantum *) malloc((MaxRGB+1)*sizeof(Quantum));O   if ((histogram == (unsigned int *) NULL) || (map == (unsigned int *) NULL) || )       (equalize_map == (Quantum *) NULL))      { E       Warning("Unable to equalize image","Memory allocation failed"); 
       return;      }    /*     Form histogram.    */   for (i=0; i <= MaxRGB; i++)      histogram[i]=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)   { ,     histogram[Intensity(*p)]+=(p->length+1);     p++;   }    /*8     Integrate the histogram to get the equalization map.   */   j=0;   for (i=0; i <= MaxRGB; i++)    {      j+=histogram[i];
     map[i]=j;    }    free((char *) histogram);    if (map[MaxRGB] == 0)      { "       free((char *) equalize_map);       free((char *) map); 
       return;t     }s   /*
     Equalize.    */
   low=map[0];    high=map[MaxRGB];    for (i=0; i <= MaxRGB; i++)      equalize_map[i]=(Quantum) 9       ((((double) (map[i]-low))*MaxRGB)/Max(high-low,1));    free((char *) map);    /*     Stretch the histogram.   */   switch (image->class)    {      case DirectClass:      {        /*%         Equalize DirectClass packets.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { $         p->red=equalize_map[p->red];(         p->green=equalize_map[p->green];&         p->blue=equalize_map[p->blue];         p++;!         if (QuantumTick(i,image))m>           ProgressMonitor(EqualizeImageText,i,image->packets);       }p       break;     }e     case PseudoClass:r     {        /*%         Equalize PseudoClass packets.t       */'       for (i=0; i < image->colors; i++)        {pD         image->colormap[i].red=equalize_map[image->colormap[i].red];H         image->colormap[i].green=equalize_map[image->colormap[i].green];F         image->colormap[i].blue=equalize_map[image->colormap[i].blue];       }        SyncImage(image);o       break;     }N   }s   free((char *) equalize_map); }n   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F l i p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %tL %  Function FlipImage creates a new image that reflects each scanline in theI %  vertical direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. %%* %  The format of the FlipImage routine is: % % %      flipped_image=FlipImage(image)u %"+ %  A description of each parameter follows:  %cG %    o flipped_image: Function FlipImage returns a pointer to the image*G %      after reflecting.  A null image is returned if there is a memory% %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *FlipImage(Image *image) { . #define FlipImageText  "  Flipping image...  "     Image      *flipped_image;      register RunlengthPacket     *p,      *q,      *s;      register unsigned int      x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flipped image attributes.   */B   flipped_image=CopyImage(image,image->columns,image->rows,False);&   if (flipped_image == (Image *) NULL)     { A       Warning("Unable to flip image","Memory allocation failed");%       return((Image *) NULL);%     }%   /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL):     { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flipped_image);       return((Image *) NULL);l     }a   /*     Flip each row.   */   p=image->pixels;   image->runlength=p->length+1;n3   q=flipped_image->pixels+flipped_image->packets-1;o)   for (y=0; y < flipped_image->rows; y++)p   {r     /*       Read a scan line.      */     s=scanline;e&     for (x=0; x < image->columns; x++)     {l        if (image->runlength != 0)         image->runlength--; 
       else	         {*           p++;%           image->runlength=p->length;g	         }        *s=(*p);
       s++;     }l     /*       Flip each column.a     */     s=scanline+image->columns;.     for (x=0; x < flipped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q--;     }a9     ProgressMonitor(FlipImageText,y,flipped_image->rows);a   }i   free((char *) scanline);   return(flipped_image); }_ g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %gO %                                                                             %aO %                                                                             %nO %   F l o p I m a g e                                                         %-O %                                                                             %lO %                                                                             %cO %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r % L %  Function FlopImage creates a new image that reflects each scanline in theK %  horizontal direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. %a* %  The format of the FlopImage routine is: %a% %      flopped_image=FlopImage(image)l %a+ %  A description of each parameter follows:- %gG %    o flopped_image: Function FlopImage returns a pointer to the imageLG %      after reflecting.  A null image is returned if there is a memoryg %      shortage. %o7 %    o image: The address of a structure of type Image.i %s %n */ Image *FlopImage(Image *image) {e. #define FlopImageText  "  Flopping image...  "     Image=     *flopped_image;-     register RunlengthPacket     *p,g     *q,t     *s;_     register unsigned intm     x,     y;     RunlengthPacketa     *scanline;     /*(     Initialize flopped image attributes.   */B   flopped_image=CopyImage(image,image->columns,image->rows,False);&   if (flopped_image == (Image *) NULL)     { D       Warning("Unable to reflect image","Memory allocation failed");       return((Image *) NULL);      }i   /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)%     {%D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flopped_image);       return((Image *) NULL);      }    /*     Flop each row.   */   p=image->pixels;   image->runlength=p->length+1;    q=flopped_image->pixels;)   for (y=0; y < flopped_image->rows; y++)    {      /*       Read a scan line.      */     s=scanline; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*       Flop each column.%     */     s=scanline+image->columns;.     for (x=0; x < flopped_image->columns; x++)     {n
       s--;       *q=(*s);       q->length=0;
       q++;     }l9     ProgressMonitor(FlopImageText,y,flopped_image->rows);n   }    free((char *) scanline);   return(flopped_image); }e e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %oO %                                                                             %eO %                                                                             %iO %   F r a m e I m a g e                                                       %pO %                                                                             % O %                                                                             %oO %                                                                             %,O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function FrameImage takes an image and puts a frame around it of a,I %  particular color.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % + %  The format of the FrameImage routine is:  % 0 %      framed_image=FrameImage(image,frame_info) %n+ %  A description of each parameter follows:  % H %    o framed_image: Function FrameImage returns a pointer to the framedH %      image.  A null image is returned if there is a a memory shortage. %i7 %    o image: The address of a structure of type Image.t % E %    o frame_info: Specifies a pointer to a FrameInfo structure which ! %      defines the framed region.  %i %t */5 Image *FrameImage(Image *image,FrameInfo *frame_info)  { 6 #define FrameImageText  "  Adding frame to image...  "     Image      *framed_image;     int      height,e
     width;     register int     x,     y;     register RunlengthPacket     *p,(     *q;o     RunlengthPackett     highlight,
     matte,     shadow;      unsigned int     bevel_width;     /*     Check frame geometry.    */E   if ((frame_info->outer_bevel < 0) || (frame_info->inner_bevel < 0))(     { A       Warning("Unable to frame image","bevel width is negative");        return((Image *) NULL);(     }t>   bevel_width=frame_info->outer_bevel+frame_info->inner_bevel;:   width=(int) frame_info->width-frame_info->x-bevel_width;<   height=(int) frame_info->height-frame_info->y-bevel_width;9   if ((width < image->columns) || (height < image->rows))a     { G       Warning("Unable to frame image","frame is less than image size");        return((Image *) NULL);      }    /*'     Initialize framed image attributes.e   */K   framed_image=CopyImage(image,frame_info->width,frame_info->height,False);m%   if (framed_image == (Image *) NULL)      {eB       Warning("Unable to frame image","Memory allocation failed");       return((Image *) NULL);      }a   image->class=DirectClass;e(   matte.red=frame_info->matte_color.red;,   matte.green=frame_info->matte_color.green;*   matte.blue=frame_info->matte_color.blue;   matte.index=Opaque;;   matte.length=0;'0   highlight.red=frame_info->highlight_color.red;4   highlight.green=frame_info->highlight_color.green;2   highlight.blue=frame_info->highlight_color.blue;   highlight.index=Opaque;g   highlight.length=0;L*   shadow.red=frame_info->shadow_color.red;.   shadow.green=frame_info->shadow_color.green;,   shadow.blue=frame_info->shadow_color.blue;   shadow.index=Opaque;   shadow.length=0;   /*.     Put an ornamental border around the image.   */   q=framed_image->pixels;%-   for (y=0; y < frame_info->outer_bevel; y++)n   { 1     for (x=0; x < (framed_image->columns-y); x++)        *q++=highlight; +     for ( ; x < framed_image->columns; x++)        *q++=shadow;   }m1   for (y=0; y < (frame_info->y-bevel_width); y++)    {m/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight;nN     for (x=0; x < (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   }"-   for (y=0; y < frame_info->inner_bevel; y++)+   {n/     for (x=0; x < frame_info->outer_bevel; x++)a       *q++=highlight; 3     for (x=0; x < (frame_info->x-bevel_width); x++)e       *q++=matte; I     for (x=0; x < (image->columns+(frame_info->inner_bevel << 1)-y); x++)f       *q++=shadow;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++)        *q++=highlight; E     width=frame_info->width-frame_info->x-image->columns-bevel_width;=     for (x=0; x < width; x++);       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)'       *q++=shadow;   }    p=image->pixels;   image->runlength=p->length+1;x!   for (y=0; y < image->rows; y++)    {n     /*,       Initialize scanline with border color.     *//     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 3     for (x=0; x < (frame_info->x-bevel_width); x++)n       *q++=matte;)/     for (x=0; x < frame_info->inner_bevel; x++)N       *q++=shadow;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {i        if (image->runlength != 0)         image->runlength--; 
       else	         {e           p++;%           image->runlength=p->length;(	         }a       *q=(*p);       q->length=0;
       q++;     }m/     for (x=0; x < frame_info->inner_bevel; x++)        *q++=highlight;nE     width=frame_info->width-frame_info->x-image->columns-bevel_width;g     for (x=0; x < width; x++)        *q++=matte;f/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;2     ProgressMonitor(FrameImageText,y,image->rows);   } 0   for (y=frame_info->inner_bevel-1; y >= 0; y--)   {e/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 3     for (x=0; x < (frame_info->x-bevel_width); x++)        *q++=matte;      for (x=0; x < y; x++)r       *q++=shadow;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++)i       *q++=highlight;tE     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte;r/     for (x=0; x < frame_info->outer_bevel; x++)n       *q++=shadow;   } B   height=frame_info->height-frame_info->y-image->rows-bevel_width;   for (y=0; y < height; y++)   {=/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight;sN     for (x=0; x < (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   }n0   for (y=frame_info->outer_bevel-1; y >= 0; y--)   {n     for (x=0; x < y; x++)        *q++=highlight;x+     for ( ; x < framed_image->columns; x++).       *q++=shadow;   }_   return(framed_image);( }o e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %XO %                                                                             %aO %     G a m m a I m a g e                                                     %aO %                                                                             %aO %                                                                             % O %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%U % N %  Function GammaImage converts the reference image to gamma corrected colors. %a+ %  The format of the GammaImage routine is:  %  %      GammaImage(image,gamma) %t+ %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % J %    o gamma: A character string indicating the level of gamma correction. %d %l */) void GammaImage(Image *image,char *gamma)  { ; #define GammaImageText  "  Gamma correcting the image...  "s  
   ColorPackets     *gamma_map;;     double     blue_gamma,(     green_gamma,     red_gamma;     intU
     count;     register int     i;     register RunlengthPacket     *p;r     red_gamma=1.0;   green_gamma=1.0;   blue_gamma=1.0;uH   count=sscanf(gamma,"%lf,%lf,%lf",&red_gamma,&green_gamma,&blue_gamma);   if (count == 1)      {        if (red_gamma == 1.0)_         return;x       green_gamma=red_gamma;       blue_gamma=red_gamma;I     }N   /*'     Allocate and initialize gamma maps.    */C   gamma_map=(ColorPacket *) malloc((MaxRGB+1)*sizeof(ColorPacket)); (   if (gamma_map == (ColorPacket *) NULL)     {rB       Warning("Unable to gamma image","Memory allocation failed");
       return;      }    for (i=0; i <= MaxRGB; i++)M   {t     gamma_map[i].red=0;x     gamma_map[i].green=0;      gamma_map[i].blue=0;   }    /*     Initialize gamma table.    */   for (i=0; i <= MaxRGB; i++)    {      if (red_gamma != 0.0)         gamma_map[i].red=(Quantum)<         ((pow((double) i/MaxRGB,1.0/red_gamma)*MaxRGB)+0.5);     if (green_gamma != 0.0) "       gamma_map[i].green=(Quantum)>         ((pow((double) i/MaxRGB,1.0/green_gamma)*MaxRGB)+0.5);     if (blue_gamma != 0.0)!       gamma_map[i].blue=(Quantum)c=         ((pow((double) i/MaxRGB,1.0/blue_gamma)*MaxRGB)+0.5);m   }e   switch (image->class)m   {r     case DirectClass:)     {f       /*(         Gamma-correct DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {a%         p->red=gamma_map[p->red].red;i+         p->green=gamma_map[p->green].green; (         p->blue=gamma_map[p->blue].blue;         p++;!         if (QuantumTick(i,image))(;           ProgressMonitor(GammaImageText,i,image->packets);s       }        break;     }      case PseudoClass:v     {r       /*(         Gamma-correct PseudoClass image.       */'       for (i=0; i < image->colors; i++)        {vE         image->colormap[i].red=gamma_map[image->colormap[i].red].red;mK         image->colormap[i].green=gamma_map[image->colormap[i].green].green; H         image->colormap[i].blue=gamma_map[image->colormap[i].blue].blue;       }f       SyncImage(image);n       break;     }a   }f   if (image->gamma != 0.0)9     image->gamma*=(red_gamma+green_gamma+blue_gamma)/3.0;    free((char *) gamma_map);l }s p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             % O %                                                                             %iO %                                                                             %)O %   G e t A n n o t a t e I n f o                                             %.O %                                                                             % O %                                                                             %oO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %oC %  Function GetAnnotateInfo initializes the AnnotateInfo structure.s %i0 %  The format of the GetAnnotateInfo routine is: % % %      GetAnnotateInfo(annotate_info)  % + %  A description of each parameter follows:  % F %    o annotate_info: Specifies a pointer to a AnnotateInfo structure. %n %l */1 void GetAnnotateInfo(AnnotateInfo *annotate_info)o {o+   annotate_info->server_name=(char *) NULL;e$   annotate_info->font=(char *) NULL;,   annotate_info->pointsize=DefaultPointSize;#   annotate_info->box=(char *) NULL; #   annotate_info->pen=(char *) NULL; (   annotate_info->geometry=(char *) NULL;$   annotate_info->text=(char *) NULL;)   annotate_info->primitive=(char *) NULL;    annotate_info->center=False; }b ) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %mO %                                                                             % O %                                                                             % O %   G e t I m a g e I n f o                                                   % O %                                                                             % O %                                                                             %rO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %>= %  Function GetImageInfo initializes the ImageInfo structure.  % - %  The format of the GetImageInfo routine is:( %o %      GetImageInfo(image_info)  % + %  A description of each parameter follows:  % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %t %f */( void GetImageInfo(ImageInfo *image_info) {l   *image_info->magick='\0';.6   image_info->filename=(char *) malloc(MaxTextLength);,   if (image_info->filename == (char *) NULL)A     Error("Unable to get image info","Memory allocation failed");    *image_info->filename='\0';n   image_info->assert=False;_   image_info->subimage=0;t   image_info->subrange=0;a(   image_info->server_name=(char *) NULL;!   image_info->font=(char *) NULL;_!   image_info->size=(char *) NULL;o$   image_info->density=(char *) NULL;!   image_info->page=(char *) NULL; $   image_info->texture=(char *) NULL;   image_info->adjoin=True;6   image_info->compression=RunlengthEncodedCompression;
 #ifdef HasPNGS)   image_info->compression=ZipCompression;e #endif   image_info->dither=True;)   image_info->interlace=DefaultInterlace;    image_info->iterations=0;_   image_info->monochrome=False;    image_info->quality=75;.   image_info->verbose=False;   image_info->monochrome=False;  }  o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             %xO %     I s G e o m e t r y                                                     %tO %                                                                             %oO %                                                                             %sO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %wJ %  Function IsGeometry returns True if the geometry specification is valid# %  as determined by XParseGeometry.w %h+ %  The format of the IsGeometry routine is:p %e" %      status=IsGeometry(geometry) %e+ %  A description of each parameter follows:s %]J %    o status: Function IsGeometry returns True if the image is gray_scale# %      otherwise False is returned.+ %x; %    o geometry: This string is the geometry specification.n %a %i */' unsigned int IsGeometry(char *geometry)e {f   int      x,     y;     unsigned int
     flags,     height,e
     width;  6   flags=XParseGeometry(geometry,&x,&y,&width,&height);,   return(flags || sscanf(geometry,"%d",&x)); }( t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             %xO %     I s G r a y I m a g e                                                   %eO %                                                                             %%O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function IsGrayImage returns True if the image is gray_scale otherwise P %  False is returned.  If the image is DirectClass and gray_scale, it is demoted %  to PseudoClass. % , %  The format of the IsGrayImage routine is: %   %      status=IsGrayImage(image) % + %  A description of each parameter follows:% %%K %    o status: Function IsGrayImage returns True if the image is gray_scale # %      otherwise False is returned.  %oF %    o image: The address of a structure of type Image;  returned from %      ReadImage.u %a %r */& unsigned int IsGrayImage(Image *image) {I   register int     i;     unsigned int     gray_scale;s     /*%     Determine if image is gray_scale.    */   gray_scale=True;   switch (image->class)h   {      case DirectClass:      {        register RunlengthPacket         *p;o         if (image->matte)t         return(False);       p=image->pixels;(       for (i=0; i < image->packets; i++)       {u         if (!IsGray(*p))           {i             gray_scale=False;              break;           }n         p++;       }i       if (gray_scale) 	         { H           QuantizeImage(image,1 << QuantumDepth,8,False,GRAYColorspace);           SyncImage(image);r	         }r       break;     }      case PseudoClass:R     {e'       for (i=0; i < image->colors; i++)e(         if (!IsGray(image->colormap[i]))           {e             gray_scale=False;              break;           }*       break;     }    }d   return(gray_scale);  }a e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             %aO %                                                                             %_O %                                                                             % O %   L a b e l I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %rH %  Function LabelImage initializes an image label.  Optionally the labelJ %  can include the image filename, type, width, height, or scene number byF %  embedding special format characters.  Embed %f for filename, %m forD %  magick, %w for width, %h for height, or %s for scene number.  For %  example,o %h %     %f  %wx%h  %n %  produces an image label of( %m %     bird.miff  512x480 %PJ %  for an image titled bird.miff and whose width is 512 and height is 480. %U+ %  The format of the LabelImage routine is:i %" %      LabelImage(image,label) %e+ %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.g %pL %    o label: The address of a character string containing the label format. %> %u */) void LabelImage(Image *image,char *label)h {    register charr     *p,-     *q;l     unsigned int     indirection,     length;g  $   if (image->label != (char *) NULL)      free((char *) image->label);   image->label=(char *) NULL;    if (label == (char *) NULL)k     return;g   indirection=(*label == '@');   if (indirection)     {d
       FILE         *file;  	       int=
         c;         /*         Read label from a file.+       */'       file=(FILE *) fopen(label+1,"r");         if (file == (FILE *) NULL)	         {(7           Warning("Unable to read label file",label+1);            return;i	         }1       length=MaxTextLength; $       label=(char *) malloc(length);0       for (q=label; label != (char *) NULL; q++)       {1         c=fgetc(file);         if (c == EOF)l           break;"         if ((q-label+1) >= length)           {i             *q='\0';             length<<=1;g:             label=(char *) realloc((char *) label,length);'             if (label == (char *) NULL)                break;"             q=label+strlen(label);           }          *q=(unsigned char) c;+       }        (void) fclose(file);!       if (label == (char *) NULL) 	         {gF           Warning("Unable to label image","Memory allocation failed");           return; 	         }e       *q='\0';     }t   /*(     Allocate and initialize image label.   */
   p=label;%   length=strlen(label)+MaxTextLength; '   image->label=(char *) malloc(length); :   for (q=image->label; image->label != (char *) NULL; p++)   {2     *q='\0';     if (*p == '\0'))       break;1     if ((q-image->label+MaxTextLength) >= length)        {g         length<<=1;lD         image->label=(char *) realloc((char *) image->label,length);*         if (image->label == (char *) NULL)           break;,         q=image->label+strlen(image->label);       }      /*-       Process formatting characters in label.f     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {e         *q++=(*p);         continue;m       }      p++;     switch (*p)e     {        case 'f':e       {          register charu
           *p;   
         /*4           Label segment is the base of the filename.
         */4         p=image->filename+strlen(image->filename)-1;8         while ((p > image->filename) && (*(p-1) != '/'))           p--;         (void) strcpy(q,p);          q+=strlen(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);,         q=image->label+strlen(image->label);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=strlen(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);,         q=image->label+strlen(image->label);         break;       }%       case 'w':%       { 5         (void) sprintf(q,"%u",image->magick_columns); ,         q=image->label+strlen(image->label);         break;       }e       default:       {          *q++='%';r         *q++=(*p);         break;       }o     }d   }h$   if (image->label == (char *) NULL)     {dB       Warning("Unable to label image","Memory allocation failed");
       return;o     }g
   *q='\0';   if (indirection)     free((char *) label);  }h r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %oO %                                                                             %bO %                                                                             % O %   M a g n i f y I m a g e                                                   %rO %                                                                             %BO %                                                                             %)O %                                                                             %bO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %pL %  Function MagnifyImage creates a new image that is a integral size greaterM %  than an existing one.  It allocates the memory necessary for the new Imageb4 %  structure and returns a pointer to the new image. %eH %  MagnifyImage scans the reference image to create a magnified image byH %  bilinear interpolation.  The magnified image columns and rows become: %n %    number_columns << 1 %    number_rows << 1b %e- %  The format of the MagnifyImage routine is:  % * %      magnified_image=MagnifyImage(image) %u+ %  A description of each parameter follows:_ %oL %    o magnified_image: Function MagnifyImage returns a pointer to the imageL %      after magnification.  A null image is returned if there is a a memory %      shortage. % 7 %    o image: The address of a structure of type Image.m %- %x */! Image *MagnifyImage(Image *image)  {o7 #define MagnifyImageText  "  Magnifying the image...  "a     Imagen     *magnified_image;      int      y;     register int     x;     register RunlengthPacket     *p,      *q,s     *r;      /**     Initialize magnified image attributes.   */N   magnified_image=CopyImage(image,image->columns << 1,image->rows << 1,False);(   if (magnified_image == (Image *) NULL)     {pA       Warning("Unable to zoom image","Memory allocation failed");+       return((Image *) NULL);      }o%   magnified_image->class=DirectClass;r   /*!     Initialize zoom image pixels.r   */   p=image->pixels;   image->runlength=p->length+1;x   q=magnified_image->pixels;!   for (y=0; y < image->rows; y++)o   {r&     for (x=0; x < image->columns; x++)     {0        if (image->runlength != 0)         image->runlength--;u
       else	         {            p++;%           image->runlength=p->length;%	         }%       *q=(*p);       q->length=0;
       q++;     }      q+=image->columns;   }    /*     Magnify each row.    */!   for (y=0; y < image->rows; y++)    { I     p=magnified_image->pixels+(image->rows-1-y)*magnified_image->columns+        (image->columns-1); P     q=magnified_image->pixels+((image->rows-1-y) << 1)*magnified_image->columns+        ((image->columns-1) << 1);     *q=(*p);     *(q+1)=(*(p));&     for (x=1; x < image->columns; x++)     { 
       p--;       q-=2;        *q=(*p);<       (q+1)->red=(((int) p->red)+((int) (p+1)->red)+1) >> 1;B       (q+1)->green=(((int) p->green)+((int) (p+1)->green)+1) >> 1;?       (q+1)->blue=(((int) p->blue)+((int) (p+1)->blue)+1) >> 1;gB       (q+1)->index=(((int) p->index)+((int) (p+1)->index)+1) >> 1;       (q+1)->length=0;     }y   }t%   for (y=0; y < (image->rows-1); y++)a   {t@     p=magnified_image->pixels+(y << 1)*magnified_image->columns;!     q=p+magnified_image->columns;(!     r=q+magnified_image->columns;i*     for (x=0; x < (image->columns-1); x++)     {g4       q->red=(((int) p->red)+((int) r->red)+1) >> 1;:       q->green=(((int) p->green)+((int) r->green)+1) >> 1;7       q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;r:       q->index=(((int) p->index)+((int) r->index)+1) >> 1;       q->length=0;C       (q+1)->red=(((int) p->red)+((int) (p+2)->red)+((int) r->red)+ #         ((int) (r+2)->red)+2) >> 2; K       (q+1)->green=(((int) p->green)+((int) (p+2)->green)+((int) r->green)+ %         ((int) (r+2)->green)+2) >> 2; G       (q+1)->blue=(((int) p->blue)+((int) (p+2)->blue)+((int) r->blue)+e$         ((int) (r+2)->blue)+2) >> 2;K       (q+1)->index=(((int) p->index)+((int) (p+2)->index)+((int) r->index)+ %         ((int) (r+2)->index)+2) >> 2;i       (q+1)->length=0;       q+=2;n       p+=2;>       r+=2;|     } 2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;"8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;h8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;4     ProgressMonitor(MagnifyImageText,y,image->rows);   }xG   p=magnified_image->pixels+(2*image->rows-2)*magnified_image->columns;(G   q=magnified_image->pixels+(2*image->rows-1)*magnified_image->columns; $   for (x=0; x < image->columns; x++)   {      *q++=(*p++);     *q++=(*p++);   }m   return(magnified_image); }- w /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %)O %                                                                             %gO %                                                                             %-O %   M i n i f y I m a g e                                                     %gO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%h %hM %  Function MinifyImage creates a new image that is a integral size less than H %  an existing one.  It allocates the memory necessary for the new Image4 %  structure and returns a pointer to the new image. % P %  MinifyImage scans the reference image to create a minified image by computingL %  the weighted average of a 4x4 cell centered at each reference pixel.  TheJ %  target pixel requires two columns and two rows of the reference pixels.8 %  Therefore the minified image columns and rows become: %  %    number_columns/2g %    number_rows/2 % G %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. % L %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.% % , %  The format of the MinifyImage routine is: % ( %      minified_image=MinifyImage(image) % + %  A description of each parameter follows:  % J %    o minified_image: Function MinifyImage returns a pointer to the imageG %      after reducing.  A null image is returned if there is a a memory = %      shortage or if the image size is less than IconSize*2.  % 7 %    o image: The address of a structure of type Image.  %  %  */  Image *MinifyImage(Image *image) {  #define Minify(weight) \!   total_red+=(weight)*(s->red); \ %   total_green+=(weight)*(s->green); \ #   total_blue+=(weight)*(s->blue); \%%   total_matte+=(weight)*(s->index); \%   s++;1 #define MinifyImageText  "  Minifying image...  "i     Imagee     *minified_image;     register RunlengthPacket     *p,      *q,      *s,C     *s0,     *s1,     *s2,     *s3;     register unsigned int      x;     RunlengthPacketd     *scanline;     unsigned int     y;     unsigned int	     blue,f
     green,     packets,     red;     unsigned longg     total_matte,     total_blue,s     total_green,     total_red;     unsigned short
     index;  0   if ((image->columns < 4) || (image->rows < 4))     {gE       Warning("Unable to reduce image","image size must exceed 3x3");_       return((Image *) NULL);i     }s   /*)     Initialize minified image attributes.>   */%   packets=Max(image->packets >> 2,1); 2   minified_image=CopyImage(image,packets,1,False);'   if (minified_image == (Image *) NULL)-     { C       Warning("Unable to reduce image","Memory allocation failed");%       return((Image *) NULL);%     }%$   minified_image->class=DirectClass;.   minified_image->columns=image->columns >> 1;(   minified_image->rows=image->rows >> 1;   minified_image->packets=0;   /*F     Allocate image buffer and scanline buffer for 4 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(4*(image->columns+1)*sizeof(RunlengthPacket)); +   if (scanline == (RunlengthPacket *) NULL)      { C       Warning("Unable to reduce image","Memory allocation failed"); #       DestroyImage(minified_image);        return((Image *) NULL);      }    /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1;%,   for (x=0; x < (4*(image->columns+1)); x++)     scanline[x]=(*p);i
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)u   {e     if (image->runlength != 0)       image->runlength--;y     else       {f         p++;#         image->runlength=p->length;o       }      *s=(*p);     s++;   }%   /*     Reduce each row.   */   p=image->pixels;   image->runlength=p->length+1;    q=minified_image->pixels;    q->red=0;i
   q->green=0;0   q->blue=0;
   q->index=0;b   q->length=MaxRunlength; &   for (y=0; y < (image->rows-1); y+=2)   {t     /*)       Initialize sliding window pointers.g     */+     s0=scanline+image->columns*((y+0) % 4);m+     s1=scanline+image->columns*((y+1) % 4); +     s2=scanline+image->columns*((y+2) % 4);m+     s3=scanline+image->columns*((y+3) % 4);a     /*       Read another scan line.      */	     s=s2;t&     for (x=0; x < image->columns; x++)     {t        if (image->runlength != 0)         image->runlength--;,
       else	         {(           p++;%           image->runlength=p->length;m	         }t       *s=(*p);
       s++;     }L     /*       Read another scan line.      */	     s=s3;e&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {c           p++;%           image->runlength=p->length;e	         }1       *s=(*p);
       s++;     }N+     for (x=0; x < (image->columns-1); x+=2)o     {o       /*B         Compute weighted average of target pixel color components.  I         These particular coefficients total to 128.  Use 128/2-1 or 63 toc!         insure correct round off.        */       total_red=0;       total_green=0;       total_blue=0;        total_matte=0;       s=s0; 3       Minify(3); Minify(7);  Minify(7);  Minify(3);g       s=s1; 3       Minify(7); Minify(15); Minify(15); Minify(7);e       s=s2; 3       Minify(7); Minify(15); Minify(15); Minify(7);r       s=s3; 3       Minify(3); Minify(7);  Minify(7);  Minify(3);        s0+=2;       s1+=2;       s2+=2;       s3+=2;*       red=(Quantum) ((total_red+63) >> 7);.       green=(Quantum) ((total_green+63) >> 7);,       blue=(Quantum) ((total_blue+63) >> 7);5       index=(unsigned short) ((total_matte+63) >> 7);*H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         {-+           if (minified_image->packets != 0)q             q++;$           minified_image->packets++;1           if (minified_image->packets == packets) 
             {<               packets<<=1;I               minified_image->pixels=(RunlengthPacket *) realloc((char *)mH                 minified_image->pixels,packets*sizeof(RunlengthPacket));E               if (minified_image->pixels == (RunlengthPacket *) NULL)t                 { O                   Warning("Unable to reduce image","Memory allocation failed"); /                   DestroyImage(minified_image);p)                   return((Image *) NULL);                  } A               q=minified_image->pixels+minified_image->packets-1; 
             }t           q->red=red;            q->green=green;a           q->blue=blue;f           q->index=index;            q->length=0;	         }a     }e5     ProgressMonitor(MinifyImageText,y,image->rows-1);1   }'=   minified_image->pixels=(RunlengthPacket *) realloc((char *)sL     minified_image->pixels,minified_image->packets*sizeof(RunlengthPacket));   free((char *) scanline);   return(minified_image);- }m t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %-O %     M o d u l a t e I m a g e                                               % O %                                                                             %uO %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %aM %  Function ModulateImage modulates the hue, saturation, and brightness of an 	 %  image.' %;. %  The format of the ModulateImage routine is: % $ %      ModulateImage(image,modulate) %%+ %  A description of each parameter follows:% % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % I %    o modulate: A character string indicating the percent change in hue, " %      saturation, and brightness. %  %  */  \ static void Modulate(double percent_hue,double percent_saturation,double percent_brightness,,   Quantum *red,Quantum *green,Quantum *blue) {    double     brightness,      hue,     saturation;      /*>     Increase or decrease color brightness, saturation, or hue.   */?   TransformHSV(*red,*green,*blue,&hue,&saturation,&brightness); '   brightness+=percent_brightness/100.0;%   if (brightness < 0.0)%     brightness=0.0;    else     if (brightness > 1.0)c       brightness=1.0;r'   saturation+=percent_saturation/100.0;.   if (saturation < 0.0)e     saturation=0.0;t   else     if (saturation > 1.0)a       saturation=1.0;r   if (hue != -1.0)     {l#       hue+=360.0*percent_hue/100.0;        if (hue < 0.0)         hue+=360.0; 
       else         if (hue > 360.0)           hue-=360.0;      }a9   HSVTransform(hue,saturation,brightness,red,green,blue);  }   / void ModulateImage(Image *image,char *modulate)s {e4 #define ModulateImageText  "  Modulating image...  "     double     percent_brightness,g     percent_hue,     percent_saturation;u     register int     i;     register RunlengthPacket     *p;      /*     Initialize gamma table.    */   percent_hue=0.0;   percent_brightness=0.0;    percent_saturation=0.0; O   (void) sscanf(modulate,"%lf,%lf,%lf",&percent_brightness,&percent_saturation,-     &percent_hue);   switch (image->class)c   {a     case DirectClass:      {        /*3         Modulate the color for a DirectClass image.r       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {aC         Modulate(percent_hue,percent_saturation,percent_brightness,r&           &p->red,&p->green,&p->blue);         p++;!         if (QuantumTick(i,image))m>           ProgressMonitor(ModulateImageText,i,image->packets);       }c       break;     }      case PseudoClass:      {r       /*3         Modulate the color for a PseudoClass image.        */'       for (i=0; i < image->colors; i++)oC         Modulate(percent_hue,percent_saturation,percent_brightness,e<           &image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);/       break;     }    }  }0   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             % O %                                                                             %%O %     M o g r i f y I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function MogrifyImage applies image processing options to an image as& %  prescribed by command line options. % - %  The format of the MogrifyImage routine is:% %%/ %      MogrifyImage(image_info,argc,argv,image)% %%+ %  A description of each parameter follows:s %g@ %    o image_info: Specifies a pointer to a ImageInfo structure. %pG %    o argc: Specifies a pointer to an integer describing the number ofC' %      elements in the argument vector.n % L %    o argv: Specifies a pointer to a text array containing the command line %      arguments./ %oF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %p %  */= void MogrifyImage(ImageInfo *image_info,int argc,char **argv,    Image **image) {    AnnotateInfo     annotate_info;  
   ColorPacket      border_color,0     matte_color;     char     *option;     int 
     flags,     x,     y;     register int     i;     unsigned int     colorspace,      number_colors,     tree_depth;m     XColor
     color;     if (*image == (Image *) NULL)      return;g   /*!     Initialize routine variables.    */"   GetAnnotateInfo(&annotate_info);1   (void) XQueryColorDatabase(BorderColor,&color);>)   border_color.red=XDownScale(color.red);>-   border_color.green=XDownScale(color.green); +   border_color.blue=XDownScale(color.blue);p   border_color.index=0; 0   (void) XQueryColorDatabase(MatteColor,&color);(   matte_color.red=XDownScale(color.red);,   matte_color.green=XDownScale(color.green);*   matte_color.blue=XDownScale(color.blue);   number_colors=0;   tree_depth=0;r   colorspace=RGBColorspace;    if (image_info->monochrome) 8     if (!IsGrayImage(*image) || ((*image)->colors != 2))       {>         number_colors=2;         tree_depth=8;>"         colorspace=GRAYColorspace;       }l   /*     Transmogrify the image.    */   for (i=1; i < argc; i++)   {-     option=argv[i]; N     if (((int) strlen(option) <= 1) || ((*option != '-') && (*option != '+')))       continue; '     if (strncmp("-blur",option,3) == 0)*       {e         double           factor;>  
         Imagen           *blurred_image;   
         /*           Blur an image.
         */         factor=atof(argv[++i]);g/         blurred_image=BlurImage(*image,factor); ,         if (blurred_image != (Image *) NULL)           {m!             DestroyImage(*image);a!             *image=blurred_image;-           }N         continue;        } &     if (strcmp("-border",option) == 0)       {s
         Image>           *bordered_image;           RectangleInfo            border_info;  
         /*6           Surround image with a border of solid color.
         */         border_info.width=0;         border_info.height=0; E         flags=XParseGeometry(argv[++i],&border_info.x,&border_info.y, 2           &border_info.width,&border_info.height);'         if ((flags & HeightValue) == 0) /           border_info.height=border_info.width; F         bordered_image=BorderImage(*image,&border_info,&border_color);-         if (bordered_image != (Image *) NULL)            { !             DestroyImage(*image); .             bordered_image->class=DirectClass;"             *image=bordered_image;           }          continue;%       }%.     if (strncmp("-bordercolor",option,8) == 0)       {%         XColor           target_color;r  
         /*3           Determine RGB values of the border color. 
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);6         border_color.red=XDownScale(target_color.red);:         border_color.green=XDownScale(target_color.green);8         border_color.blue=XDownScale(target_color.blue);         continue;o       }f&     if (strncmp("-box",option,3) == 0)       {o$         annotate_info.box=argv[++i];         continue;        }x*     if (strncmp("colors",option+1,7) == 0)       {o&         number_colors=atoi(argv[++i]);         continue;n       }t-     if (strncmp("-colorspace",option,8) == 0)        {e         i++;         option=argv[i];g.         if (Latin1Compare("gray",option) == 0)           { &             colorspace=GRAYColorspace;#             if (number_colors == 0).                number_colors=256;             tree_depth=8;r           } .         if (Latin1Compare("ohta",option) == 0)$           colorspace=OHTAColorspace;-         if (Latin1Compare("rgb",option) == 0)_#           colorspace=RGBColorspace; 5         if (Latin1Compare("transparent",option) == 0)o+           colorspace=TransparentColorspace;(-         if (Latin1Compare("xyz",option) == 0)l#           colorspace=XYZColorspace;n/         if (Latin1Compare("ycbcr",option) == 0)*%           colorspace=YCbCrColorspace;/-         if (Latin1Compare("yiq",option) == 0) #           colorspace=YIQColorspace; /         if (Latin1Compare("ypbpr",option) == 0)C%           colorspace=YPbPrColorspace; -         if (Latin1Compare("yuv",option) == 0)f#           colorspace=YUVColorspace;s         continue;-       }r+     if (strncmp("comment",option+1,4) == 0)        {(         if (*option == '-')N)           CommentImage(*image,argv[++i]);          else-           CommentImage(*image,(char *) NULL);          continue;t       }c,     if (strncmp("contrast",option+1,3) == 0)       {r>         ContrastImage(*image,(unsigned int) (*option == '-'));         continue;        } +     if ((strncmp("-crop",option,3) == 0) ||a)         (strncmp("-clip",option,4) == 0))g       {;6         TransformImage(image,argv[++i],(char *) NULL);         continue;        }-(     if (strncmp("-delay",option,4) == 0)       { L         (*image)->delay=(char *) malloc((strlen(argv[++i])+1)*sizeof(char));-         if ((*image)->delay == (char *) NULL)            {nH             Warning("Unable to delay image","Memory allocation failed");             continue;x           } /         (void) strcpy((*image)->delay,argv[i]);          continue;        } ,     if (strncmp("-despeckle",option,4) == 0)       { 
         ImageO           *despeckled_image;  
         /*.           Reduce the speckles within an image.
         */0         despeckled_image=DespeckleImage(*image);/         if (despeckled_image != (Image *) NULL);           {e!             DestroyImage(*image);n$             *image=despeckled_image;           }          continue;p       }+*     if (strncmp("-display",option,4) == 0)       { ,         annotate_info.server_name=argv[++i];         continue;l       } (     if (strncmp("draw",option+1,2) == 0)       { *         annotate_info.primitive=argv[++i];)         DrawImage(*image,&annotate_info);-         continue;        } '     if (strncmp("-edge",option,3) == 0).       {          double           factor;s  
         Imageg           *edged_image;y  
         /*$           Detect edges in the image.
         */         factor=atof(argv[++i]);>-         edged_image=EdgeImage(*image,factor);y*         if (edged_image != (Image *) NULL)           {o!             DestroyImage(*image);              *image=edged_image;e           }          continue;g       }g)     if (strncmp("-emboss",option,3) == 0)+       { 
         Imagem           *embossed_image;  
         /*           Emboss image.)
         */+         embossed_image=EmbossImage(*image); -         if (embossed_image != (Image *) NULL)            {p!             DestroyImage(*image);m"             *image=embossed_image;           }          continue;r       })*     if (strncmp("-enhance",option,3) == 0)       { 
         Imageg           *enhanced_image;  
         /*           Enhance image.
         */,         enhanced_image=EnhanceImage(*image);-         if (enhanced_image != (Image *) NULL)            { !             DestroyImage(*image); "             *image=enhanced_image;           }e         continue;        } +     if (strncmp("-equalize",option,3) == 0)        {e         EqualizeImage(*image);         continue;a       } '     if (strncmp("-flip",option,4) == 0)q       {O
         Image)           *flipped_image;l  
         /*           Flip image scanlines.e
         */(         flipped_image=FlipImage(*image);,         if (flipped_image != (Image *) NULL)           { !             DestroyImage(*image); !             *image=flipped_image;            }=         continue;d       }e'     if (strncmp("-flop",option,4) == 0)d       {e
         Imagel           *flopped_image;/  
         /*           Flop image scanlines.d
         */(         flopped_image=FlopImage(*image);,         if (flopped_image != (Image *) NULL)           {*!             DestroyImage(*image); !             *image=flopped_image;i           };         continue;n       }u'     if (strncmp("-font",option,3) == 0)n       { %         annotate_info.font=argv[++i];          continue;        } %     if (strcmp("-frame",option) == 0)        { 
         Image>           *framed_image;           FrameInfo            frame_info;p  
         /*3           Surround image with an ornamental border.e
         */         frame_info.width=0;p         frame_info.height=0;?         flags=XParseGeometry(argv[++i],&frame_info.outer_bevel,;H           &frame_info.inner_bevel,&frame_info.width,&frame_info.height);'         if ((flags & HeightValue) == 0)d-           frame_info.height=frame_info.width; "         if ((flags & XValue) == 0);           frame_info.outer_bevel=(frame_info.width >> 2)+1; "         if ((flags & YValue) == 0)8           frame_info.inner_bevel=frame_info.outer_bevel;&         frame_info.x=frame_info.width;'         frame_info.y=frame_info.height; C         frame_info.width=(*image)->columns+(frame_info.width << 1);CB         frame_info.height=(*image)->rows+(frame_info.height << 1);+         frame_info.matte_color=matte_color;;J         frame_info.highlight_color.red=(matte_color.red*HighlightModulate+4           (MaxRGB-HighlightModulate)*65535L)/MaxRGB;N         frame_info.highlight_color.green=(matte_color.green*HighlightModulate+4           (MaxRGB-HighlightModulate)*65535L)/MaxRGB;L         frame_info.highlight_color.blue=(matte_color.blue*HighlightModulate+4           (MaxRGB-HighlightModulate)*65535L)/MaxRGB;$         frame_info.shadow_color.red=A           (unsigned int) (matte_color.red*ShadowModulate)/MaxRGB;1&         frame_info.shadow_color.green=C           (unsigned int) (matte_color.green*ShadowModulate)/MaxRGB;e%         frame_info.shadow_color.blue=)B           (unsigned int) (matte_color.blue*ShadowModulate)/MaxRGB;4         framed_image=FrameImage(*image,&frame_info);+         if (framed_image != (Image *) NULL)n           {1!             DestroyImage(*image); ,             framed_image->class=DirectClass;              *image=framed_image;           }          continue;        } (     if (strncmp("-gamma",option,3) == 0)       {n%         GammaImage(*image,argv[++i]);          continue;(       };+     if (strncmp("-geometry",option,4) == 0)        { 6         TransformImage(image,(char *) NULL,argv[++i]);'         annotate_info.geometry=argv[i];          continue;        } -     if (strncmp("interlace",option+1,3) == 0)        { ,         image_info->interlace=NoneInterlace;         if (*option == '-')u           {d             option=argv[++i];e2             if (Latin1Compare("none",option) == 0)2               image_info->interlace=NoneInterlace;2             if (Latin1Compare("line",option) == 0)2               image_info->interlace=LineInterlace;3             if (Latin1Compare("plane",option) == 0)e3               image_info->interlace=PlaneInterlace;e           }          continue;d       } )     if (strncmp("label",option+1,2) == 0)e       {m         if (*option == '-') '           LabelImage(*image,argv[++i]);n         else+           LabelImage(*image,(char *) NULL);          continue;        } &     if (strcmp("matte",option+1) == 0)       { )         (*image)->matte=(*option == '-');x         continue;        }i-     if (strncmp("-mattecolor",option,7) == 0)e       {          XColor           target_color;q  
         /*3           Determine RGB values of the border color. 
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);5         matte_color.red=XDownScale(target_color.red); 9         matte_color.green=XDownScale(target_color.green); 7         matte_color.blue=XDownScale(target_color.blue);)         continue;n       } +     if (strncmp("-modulate",option,4) == 0)f       {M(         ModulateImage(*image,argv[++i]);         continue;e       } )     if (strncmp("-negate",option,4) == 0)        {l         NegateImage(*image);         continue;x       } (     if (strncmp("-noise",option,4) == 0)       { 
         Imagea           *noisy_image;   
         /*            Reduce noise in image.
         */'         noisy_image=NoisyImage(*image);e*         if (noisy_image != (Image *) NULL)           {%!             DestroyImage(*image);%             *image=noisy_image;%           }          continue;        } ,     if (strncmp("-normalize",option,4) == 0)       {          NormalizeImage(*image);          continue;        } )     if (strncmp("-opaque",option,3) == 0)        { 8         OpaqueImage(*image,argv[++i],annotate_info.pen);         continue;        } '     if (strncmp("-page",option,4) == 0)        { 3         (*image)->page=PostscriptGeometry(argv[i]);          continue;        } (     if (strncmp("-paint",option,4) == 0)       { 
         Image%           *painted_image;%  
         /*           Oil paint image.
         */,         painted_image=OilPaintImage(*image);,         if (painted_image != (Image *) NULL)           {g!             DestroyImage(*image);s!             *image=painted_image;r           }e         continue;A       }i&     if (strncmp("-pen",option,3) == 0)       { $         annotate_info.pen=argv[++i];         continue;        }a,     if (strncmp("-pointsize",option,3) == 0)       { 0         annotate_info.pointsize=atoi(argv[++i]);         continue;v       }a)     if (strncmp("raise",option+1,2) == 0)b       {,C         RaiseImage(*image,*option == '-' ? 1 : -1,atoi(argv[++i]));          continue;        }o'     if (strncmp("-roll",option,4) == 0)r       { 
         Images           *rolled_image;           unsigned int           height,            width;  
         /*           Roll image. 
         */         x=0;         y=0;=         flags=XParseGeometry(argv[++i],&x,&y,&width,&height);u+         rolled_image=RollImage(*image,x,y); +         if (rolled_image != (Image *) NULL)            {e!             DestroyImage(*image);t              *image=rolled_image;           }(         continue;0       } )     if (strncmp("-rotate",option,4) == 0)        {          double           degrees;  
         Image            *rotated_image;   
         /*           Rotate image.k
         */          degrees=atof(argv[++i]);K         rotated_image=RotateImage(*image,degrees,&border_color,False,True);k,         if (rotated_image != (Image *) NULL)           {u!             DestroyImage(*image);u!             *image=rotated_image;            }t         continue;e       }+)     if (strncmp("-sample",option,3) == 0)g       {e
         Imageg           *sampled_image;            unsigned int           height,h           width;  
         /*.           Sample image with pixel replication.
         */          width=(*image)->columns;         height=(*image)->rows;5         ParseImageGeometry(argv[++i],&width,&height);R7         sampled_image=SampleImage(*image,width,height); ,         if (sampled_image != (Image *) NULL)           {l!             DestroyImage(*image); !             *image=sampled_image;i           }          continue;h       } )     if (strncmp("scene",option+1,3) == 0)        {i(         (*image)->scene=atoi(argv[++i]);         continue;        }b+     if (strncmp("segment",option+1,3) == 0)=       {(N         SegmentImage(*image,colorspace,image_info->verbose,SmoothingThreshold,           atof(argv[++i]));          SyncImage(*image);         continue;-       }h*     if (strncmp("-sharpen",option,5) == 0)       {t         double           factor;b  
         Image)           *sharpened_image;f  
         /*           Sharpen an image.(
         */         factor=atof(argv[++i]);e4         sharpened_image=SharpenImage(*image,factor);.         if (sharpened_image != (Image *) NULL)           {a!             DestroyImage(*image);o#             *image=sharpened_image;            }          continue;        }c(     if (strncmp("-shear",option,4) == 0)       {e
         float            x_shear,           y_shear;  
         Imageb           *sheared_image;h  
         /*           Shear image.
         */         x_shear=0.0;         y_shear=0.0;;         (void) sscanf(argv[++i],"%fx%f",&x_shear,&y_shear);e9         sheared_image=ShearImage(*image,(double) x_shear,t0           (double) y_shear,&border_color,False);,         if (sheared_image != (Image *) NULL)           {u!             DestroyImage(*image);g-             sheared_image->class=DirectClass;e!             *image=sheared_image;            }          continue;i       } )     if (strncmp("-spread",option,3) == 0)p       {i         unsigned int           amount;a  
         Imagea           *spread_image;  
         /*           Spread an image.
         */         amount=atoi(argv[++i]);;0         spread_image=SpreadImage(*image,amount);+         if (spread_image != (Image *) NULL)p           { !             DestroyImage(*image);,              *image=spread_image;           }r         continue;e       }I(     if (strncmp("-swirl",option,3) == 0)       {          double           degrees;  
         Imagep           *swirled_image;r  
         /*           Swirl image.
         */          degrees=atof(argv[++i]);1         swirled_image=SwirlImage(*image,degrees);g,         if (swirled_image != (Image *) NULL)           {.!             DestroyImage(*image); !             *image=swirled_image;            }(         continue;a       } )     if (strncmp("-spread",option,3) == 0)%       {%         unsigned int           amount;%  
         Image            *spread_image;  
         /*           Spread an image.
         */         amount=atoi(argv[++i]); 0         spread_image=SpreadImage(*image,amount);+         if (spread_image != (Image *) NULL)            { !             DestroyImage(*image);               *image=spread_image;           }          continue;        } /     if (strncmp("-transparency",option,4) == 0)        { +         TransparentImage(*image,argv[++i]);          continue;        } ,     if (strncmp("-treedepth",option,4) == 0)       { #         tree_depth=atoi(argv[++i]);%         continue;%       }%   }%   if (number_colors != 0)%     {%       /*1         Reduce the number of colors in the image.        */-       if (((*image)->class == DirectClass) ||bO           ((*image)->colors > number_colors) || (colorspace == GRAYColorspace)) I         QuantizeImage(*image,number_colors,tree_depth,image_info->dither,d           colorspace);       /*#         Measure quantization error.        */       if (image_info->verbose)"         QuantizationError(*image);       SyncImage(*image);     }s>   if ((*image)->packets == ((*image)->columns*(*image)->rows))     CompressImage(*image); }i g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%wO %                                                                             % O %                                                                             % O %     N e g a t e I m a g e                                                   %lO %                                                                             % O %                                                                             %aO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%* %UB %  Function NegateImage negates the colors in the reference image. % , %  The format of the NegateImage routine is: %  %      NegateImage(image)  %l+ %  A description of each parameter follows:e %oF %    o image: The address of a structure of type Image;  returned from %      ReadImage.> %m %s */ void NegateImage(Image *image) {-; #define NegateImageText  "  Negating the image colors...  "a     register int     i;     register RunlengthPacket     *p;      switch (image->class)r   {m     case DirectClass:      {y       /*#         Negate DirectClass packets.n       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {o         p->red=(~p->red);          p->green=(~p->green);y         p->blue=(~p->blue);;         p++;!         if (QuantumTick(i,image))m<           ProgressMonitor(NegateImageText,i,image->packets);       }a       break;     }      case PseudoClass:      {y       /*#         Negate PseudoClass packets.c       */'       for (i=0; i < image->colors; i++)y       {o9         image->colormap[i].red=(~image->colormap[i].red);N=         image->colormap[i].green=(~image->colormap[i].green);i;         image->colormap[i].blue=(~image->colormap[i].blue);s       }!       SyncImage(image);        break;     }o   }a }c   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             %hO %                                                                             %iO %     N o i s y I m a g e                                                     % O %                                                                             %nO %                                                                             %eO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %tH %  Function NoisyImage creates a new image that is a copy of an existingH %  one with the noise minified with a noise peak elimination filter.  ItK %  allocates the memory necessary for the new Image structure and returns ax %  pointer to the new image. %xK %  The principal function of noise peak elimination filter is to smooth the F %  objects within an image without losing edge information and withoutJ %  creating undesired structures.  The central idea of the algorithm is toI %  replace a pixel with its next neighbor in value within a 3 x 3 window,(I %  if this pixel has been found to be noise.  A pixel is defined as noise E %  if and only if this pixel is a maximum or minimum within the 3 x 3a
 %  window. %>+ %  The format of the NoisyImage routine is:  % $ %      noisy_image=NoisyImage(image) % + %  A description of each parameter follows:o %iL %    o noisy_image: Function NoisyImage returns a pointer to the image afterL %      the noise is minified.  A null image is returned if there is a memory %      shortage. %aF %    o image: The address of a structure of type Image;  returned from %      ReadImage.y %a %> */4 static int NoisyCompare(const void *x,const void *y) {e
   ColorPacketp
     *color_1, 
     *color_2;%     color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_1)-(int) Intensity(*color_2)); }    Image *NoisyImage(Image *image)  { 9 #define NoisyImageText  "  Reducing the image noise...  "      Image      *noisy_image;      int      i;     register RunlengthPacket     *p,      *q,      *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket 
     pixel,     *scanline,     window[9];     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     { I       Warning("Unable to reduce noise","the image size must exceed 2x2");        return((Image *) NULL);%     }%   /*&     Initialize noisy image attributes.   */@   noisy_image=CopyImage(image,image->columns,image->rows,False);$   if (noisy_image == (Image *) NULL)     { C       Warning("Unable to reduce noise","Memory allocation failed");r       return((Image *) NULL);e     }i   /*5     Allocate scanline buffer for 3 rows of the image.c   */P   scanline=(RunlengthPacket *) malloc(3*image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)i     {oC       Warning("Unable to reduce noise","Memory allocation failed");o        DestroyImage(noisy_image);       return((Image *) NULL);t     }h   /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1;i
   s=scanline;s+   for (x=0; x < (image->columns << 1); x++)r   {e     if (image->runlength != 0)       image->runlength--;      else       {w         p++;#         image->runlength=p->length;p       }      *s=(*p);     s++;   }*   /*!     Dump first scanline of image.f   */   q=noisy_image->pixels;
   s=scanline;f$   for (x=0; x < image->columns; x++)   {a     *q=(*s);     q->length=0;     q++;     s++;   }e   /*     Reduce noise in each row.*   */%   for (y=1; y < (image->rows-1); y++)p   {-     /*)       Initialize sliding window pointers.f     */+     s0=scanline+image->columns*((y-1) % 3);n'     s1=scanline+image->columns*(y % 3);c+     s2=scanline+image->columns*((y+1) % 3);      /*       Read another scan line.m     */	     s=s2;i&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--;c
       else	         {-           p++;%           image->runlength=p->length;x	         }c       *s=(*p);
       s++;     })     /*+       Transfer first pixel of the scanline.e     */	     s=s1;-     *q=(*s);     q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {)       /*3         Sort window pixels by increasing intensity.i       */       s=s0;        window[0]=(*s++);n       window[1]=(*s++);y       window[2]=(*s++);        s=s1;f       window[3]=(*s++);        window[4]=(*s++);0       window[5]=(*s++);r       s=s2;        window[6]=(*s++);e       window[7]=(*s++);        window[8]=(*s++);o       pixel=window[4];6       qsort((void *) window,9,sizeof(RunlengthPacket),<         (int (*)(const void *, const void *)) NoisyCompare);3       if (Intensity(pixel) == Intensity(window[0]));	         {g           /*H             Pixel is minimum noise; replace with next neighbor in value.           */           for (i=1; i < 8; i++)g=             if (Intensity(window[i]) != Intensity(window[0]))e               break;           pixel=window[i];	         }h
       else5         if (Intensity(pixel) == Intensity(window[8]))            {]             /*J               Pixel is maximum noise; replace with next neighbor in value.             */!             for (i=7; i > 0; i--)m?               if (Intensity(window[i]) != Intensity(window[8]));                 break;             pixel=window[i];           }r       *q=pixel;        q->length=0;
       q++;       s0++;)       s1++;        s2++;(     }r     /**       Transfer last pixel of the scanline.     */	     s=s1;      *q=(*s);     q->length=0;     q++;4     ProgressMonitor(NoisyImageText,y,image->rows-1);   }f   /*!     Dump last scanline of pixels.D   */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {      *q=(*s);     q->length=0;     q++;     s++;   }|   free((char *) scanline);   return(noisy_image); }e D /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             %)O %     N o r m a l i z e I m a g e                                             %dO %                                                                             %|O %                                                                             % O %                                                                             %>O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function NormalizeImage normalizes the pixel values to span the fullnD %  range of color values.  This is a contrast enhancement technique. %r/ %  The format of the NormalizeImage routine is:( %) %      NormalizeImage(image) % + %  A description of each parameter follows:[ %gF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */! void NormalizeImage(Image *image)e {l6 #define NormalizeImageText  "  Normalizing image...  "     intf     histogram[MaxRGB+1],     threshold_intensity;  	   Quantuml     gray_value,      normalize_map[MaxRGB+1];     register int     i,     intensity;     register RunlengthPacket     *p;e     unsigned int	     high,      low;     /*     Form histogram.e   */   for (i=0; i <= MaxRGB; i++)p     histogram[i]=0;e   p=image->pixels;$   for (i=0; i < image->packets; i++)   {c     gray_value=Intensity(*p); '     histogram[gray_value]+=p->length+1;      p++;   }-   /*C     Find the histogram boundaries by locating the 1 percent levels.    */7   threshold_intensity=(image->columns*image->rows)/100;n   intensity=0;"   for (low=0; low < MaxRGB; low++)   {      intensity+=histogram[low];(     if (intensity > threshold_intensity)       break;   }L   intensity=0;&   for (high=MaxRGB; high != 0; high--)   {      intensity+=histogram[high];-(     if (intensity > threshold_intensity)       break;   }    if (low == high)     {        /*K         Unreasonable contrast;  use zero threshold to determine boundaries.,       */       threshold_intensity=0;       intensity=0;&       for (low=0; low < MaxRGB; low++)       {a"         intensity+=histogram[low];,         if (intensity > threshold_intensity)           break;       }l       intensity=0;*       for (high=MaxRGB; high != 0; high--)       {p#         intensity+=histogram[high];n,         if (intensity > threshold_intensity)           break;       }        if (low == high)&         return;  /* zero span bound */     }m   /*A     Stretch the histogram to create the normalized image mapping.    */   for (i=0; i <= MaxRGB; i++)=     if (i < (int) low)       normalize_map[i]=0;      else       if (i > (int) high)l"         normalize_map[i]=MaxRGB-1;
       else7         normalize_map[i]=(MaxRGB-1)*(i-low)/(high-low);n   /*     Normalize the image.   */   switch (image->class)    {      case DirectClass:h     {        /*$         Normalize DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {p%         p->red=normalize_map[p->red];e)         p->green=normalize_map[p->green];p'         p->blue=normalize_map[p->blue];)         p++;!         if (QuantumTick(i,image));?           ProgressMonitor(NormalizeImageText,i,image->packets);        }        break;     }      case PseudoClass:+     {        /*$         Normalize PseudoClass image.       */'       for (i=0; i < image->colors; i++)        { E         image->colormap[i].red=normalize_map[image->colormap[i].red];(I         image->colormap[i].green=normalize_map[image->colormap[i].green]; G         image->colormap[i].blue=normalize_map[image->colormap[i].blue];        }o       SyncImage(image);p       break;     }    }  }*   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %>O %     O p a g u e I m a g e                                                   %qO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %xN %  Function OpaqueImage changes the color of an opaque pixel to the pen color. % , %  The format of the OpaqueImage routine is: %%1 %      OpaqueImage(image,opaque_color,pen_colors)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %    o opaque_color,G %      pen_colors: A character string that contain an X11 color string.  %  %  */B void OpaqueImage(Image *image,char *opaque_color,char *pen_colors) { C #define OpaqueImageText  "  Setting opaque color in the image...  "   	   Quantum 	     blue, 
     green,     red;     register int     i;     unsigned int     status;      XColor     target_color;      /*-     Determine RGB values of the opaque color.%   */9   status=XQueryColorDatabase(opaque_color,&target_color);    if (status == False)     return;r#   red=XDownScale(target_color.red); '   green=XDownScale(target_color.green);u%   blue=XDownScale(target_color.blue);e7   status=XQueryColorDatabase(pen_colors,&target_color);l   if (status == False)     return;    /*     Make image color opaque.   */   switch (image->class)r   {s     case DirectClass:      {o       register RunlengthPacket         *p;d         /*&         Make DirectClass image opaque.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { 2         if (((int) p->red < (int) (red+DeltaX)) &&2             ((int) p->red > (int) (red-DeltaX)) &&6             ((int) p->green < (int) (green+DeltaX)) &&6             ((int) p->green > (int) (green-DeltaX)) &&4             ((int) p->blue < (int) (blue+DeltaX)) &&2             ((int) p->blue > (int) (blue-DeltaX)))           {=0             p->red=XDownScale(target_color.red);4             p->green=XDownScale(target_color.green);2             p->blue=XDownScale(target_color.blue);           }n         p++;!         if (QuantumTick(i,image)) <           ProgressMonitor(OpaqueImageText,i,image->packets);       }        break;     }l     case PseudoClass:a     {w       register ColorPacket         *p;m         /*&         Make PseudoClass image opaque.       */       p=image->colormap;'       for (i=0; i < image->colors; i++)_       { 2         if (((int) p->red < (int) (red+DeltaX)) &&2             ((int) p->red > (int) (red-DeltaX)) &&6             ((int) p->green < (int) (green+DeltaX)) &&6             ((int) p->green > (int) (green-DeltaX)) &&4             ((int) p->blue < (int) (blue+DeltaX)) &&2             ((int) p->blue > (int) (blue-DeltaX)))           { 0             p->red=XDownScale(target_color.red);4             p->green=XDownScale(target_color.green);2             p->blue=XDownScale(target_color.blue);           }l         p++;!         if (QuantumTick(i,image)) <           ProgressMonitor(OpaqueImageText,i,image->packets);       }%       break;     }r   }r }x   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %gO %                                                                             %*O %                                                                             %aO %   O p e n I m a g e                                                         %-O %                                                                             %sO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function OpenImage open a file associated with the image.  A file name ofK %  '-' sets the file to stdin for type 'r' and stdout for type 'w'.  If the>K %  filename suffix is '.gz' or '.Z', the image is decompressed for type 'r'sK %  and compressed for type 'w'.  If the filename prefix is '|', it is pipedc %  to or from a system command.e % * %  The format of the OpenImage routine is: % ' %      OpenImage(image_info,image,type)  %e+ %  A description of each parameter follows:o %s@ %    o image_info: Specifies a pointer to a ImageInfo structure. % 7 %    o image: The address of a structure of type Image.c %r. %    o type: 'r' for reading; 'w' for writing. %  */= void OpenImage(ImageInfo *image_info,Image *image,char *type)- {u   char     filename[MaxTextLength];  *   (void) strcpy(filename,image->filename);   if (*filename != '|')0'     if (((int) strlen(filename) > 3) &&i9         (strcmp(filename+strlen(filename)-3,".gz") == 0))i       {n
         /*E           Uncompress/compress image file with GNU compress utilities.a
         */         if (*type == 'r'))A           (void) sprintf(filename,GunzipCommand,image->filename);u         else?           (void) sprintf(filename,GzipCommand,image->filename);-       }b     else)       if (((int) strlen(filename) > 2) &&t:           (strcmp(filename+strlen(filename)-2,".Z") == 0))	         {            /*H             Uncompress/compress image file with UNIX compress utilities.           */           if (*type == 'r') G             (void) sprintf(filename,UncompressCommand,image->filename);            elseE             (void) sprintf(filename,CompressCommand,image->filename); 	         })   /*     Open image file.   */   image->pipe=False;    if (strcmp(filename,"-") == 0)0     image->file=(*type == 'r') ? stdin : stdout;   else) #if !defined(vms) && !defined(__MWERKS__)s     if (*filename == '|')f       {m         char           mode[MaxTextLength];  
         /*1           Pipe image to or from a system command.f
         */         if (*type == 'w')n)           (void) signal(SIGPIPE,SIG_IGN);f$         (void) strncpy(mode,type,1);+         image->file=popen(filename+1,mode);g         image->pipe=True;g       }s     else #endif       {a2         if ((*type == 'w') && !image_info->adjoin)4           if ((image->previous != (Image *) NULL) ||.               (image->next != (Image *) NULL))
             {                /*4                 Form filename for multi-part images.               */D               (void) sprintf(filename,image->filename,image->scene);8               if (strcmp(filename,image->filename) == 0)N                 (void) sprintf(filename,"%s.%u",image->filename,image->scene);0               if (image->next != (Image *) NULL)A                 (void) strcpy(image->next->magick,image->magick); 6               (void) strcpy(image->filename,filename);
             }a2         image->file=(FILE *) fopen(filename,type);)         if (image->file != (FILE *) NULL)-           {(+             (void) fseek(image->file,0L,2); /             image->filesize=ftell(image->file);(+             (void) fseek(image->file,0L,0);,           }n       }s   image->status=False;   if (*type == 'r')      {i!       image->next=(Image *) NULL;g%       image->previous=(Image *) NULL;h     }U }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             %UO %                                                                             % O %   P a r s e I m a g e G e o m e t r y                                       % O %                                                                             %,O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ParseImageGeometry parse a geometry specification and returns thee %  width and height values.  %m3 %  The format of the ParseImageGeometry routine is:6 %46 %      ParseImageGeometry(image_geometry,width,height) % + %  A description of each parameter follows:  % N %    o image_geometry:  Specifies a character string representing the geometry %      specification.e %fL %    o width:  A pointer to an unsigned integer.  The width as determined by3 %      the geometry specification is returned here.; % N %    o height:  A pointer to an unsigned integer.  The height as determined by3 %      the geometry specification is returned here.  %  %o */A void ParseImageGeometry(char *image_geometry,unsigned int *width,>   unsigned int *height)  {i   char     geometry[MaxTextLength];     inte
     flags,     x,     y;     register char      *p;*     unsigned int     aspect_ratio,      former_height,     former_width,S     greater,	     less,s     percentage;f     unsigned long      scale_factor;   &   if (image_geometry == (char *) NULL)     return;r   /*J     Remove whitespaces and % and ! characters from geometry specification.   */)   (void) strcpy(geometry,image_geometry);[   aspect_ratio=True;   greater=False;
   less=False;    percentage=False; 
   p=geometry;    while ((int) strlen(p) > 0))   {      if (isspace(*p))       (void) strcpy(p,p+1);%     else       switch (*p)%       {%         case '%': 	         {            percentage=True;           (void) strcpy(p,p+1);            break;	         }          case '!': 	         {            aspect_ratio=False;            (void) strcpy(p,p+1);            break;	         }          case '<': 	         {            less=True;           (void) strcpy(p,p+1);            break;	         }          case '>': 	         {            greater=True;            (void) strcpy(p,p+1);            break;	         }          default:           p++;       }%   }%   /*(     Parse geometry using XParseGeometry.   */   former_width=(*width);   former_height=(*height);4   flags=XParseGeometry(geometry,&x,&y,width,height);@   if (((flags & WidthValue) != 0) && (flags & HeightValue) == 0)     *height=(*width);.   if (percentage)G     {c       /*3         Geometry is a percentage of the image size.h       */)       *width=(former_width*(*width))/100;h,       *height=(former_height*(*height))/100;       former_width=(*width);       former_height=(*height);     }e   if (aspect_ratio)n     {e       /**         Respect aspect ratio of the image.       */D       if (((flags & WidthValue) != 0) && (flags & HeightValue) != 0)	         {a4           scale_factor=UpShift(*width)/former_width;>           if (scale_factor > (UpShift(*height)/former_height))8             scale_factor=UpShift(*height)/former_height;	         }i
       else&         if ((flags & WidthValue) != 0)4           scale_factor=UpShift(*width)/former_width;         else6           scale_factor=UpShift(*height)/former_height;2       *width=DownShift(former_width*scale_factor);4       *height=DownShift(former_height*scale_factor);     }    if (greater)=     if ((former_width < *width) && (former_height < *height))        {          *width=former_width;         *height=former_height;       }c   if (less) =     if ((former_width > *width) && (former_height > *height))s       {          *width=former_width;         *height=former_height;       }0 }  o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %*O %     O i l P a i n t I m a g e                                               % O %                                                                             %2O %                                                                             %2O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %=K %  Function OilPaintImage creates a new image that is a copy of an existing N %  one with each pixel component replaced with the color of greatest number in %  a 5x5 neighborhood. % . %  The format of the OilPaintImage routine is: % ) %      painted_image=OilPaintImage(image)  % + %  A description of each parameter follows:  %+K %    o painted_image: Function OilPaintImage returns a pointer to the image+L %      after it is `painted'.  A null image is returned if there is a memory %      shortage. %gF %    o image: The address of a structure of type Image;  returned from %      ReadImage._ %n %, */" Image *OilPaintImage(Image *image) {m6 #define OilPaintImageText  "  Oil painting image...  "     Image;     *painted_image;g     int 
     count;     register int     i,     j;     register RunlengthPacket     *p,      *q,i     *s,      *s0,     *s1,     *s2,     *s3,     *s4;     register unsigned inte     x;     RunlengthPacketn
     pixel,     *scanline,     window[25];e     unsigned int     *histogram,      y;  0   if ((image->columns < 5) || (image->rows < 5))     { F       Warning("Unable to oil paint","the image size must exceed 4x4");       return((Image *) NULL);b     }    /*(     Initialize painted image attributes.   */B   painted_image=CopyImage(image,image->columns,image->rows,False);&   if (painted_image == (Image *) NULL)     {n@       Warning("Unable to oil paint","Memory allocation failed");       return((Image *) NULL);      }p#   painted_image->class=DirectClass;u   /*$     Allocate histogram and scanline.   */E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int));*P   scanline=(RunlengthPacket *) malloc(5*image->columns*sizeof(RunlengthPacket));-   if ((histogram == (unsigned int *) NULL) || -       (scanline == (RunlengthPacket *) NULL))      {n@       Warning("Unable to oil paint","Memory allocation failed");"       DestroyImage(painted_image);       return((Image *) NULL);      }    /**     Preload the first 4 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1;_
   s=scanline; +   for (x=0; x < (image->columns << 2); x++)0   {      if (image->runlength != 0)       image->runlength--;c     else       {          p++;#         image->runlength=p->length;o       }      *s=(*p);     s++;   }    /*!     Dump first scanline of image.    */   q=painted_image->pixels;
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)l   {-     *q=(*s);     q->length=0;     q++;     s++;   }    /*      Paint each row of the image.   */%   for (y=2; y < (image->rows-2); y++)    {      /*)       Initialize sliding window pointers.a     */+     s0=scanline+image->columns*((y-2) % 5);m+     s1=scanline+image->columns*((y-1) % 5);]'     s2=scanline+image->columns*(y % 5);h+     s3=scanline+image->columns*((y+1) % 5);-+     s4=scanline+image->columns*((y+2) % 5);      /*       Read another scan line.e     */	     s=s4;b&     for (x=0; x < image->columns; x++)     {e        if (image->runlength != 0)         image->runlength--;=
       else	         {i           p++;%           image->runlength=p->length;1	         }u       *s=(*p);
       s++;     }-     /*+       Transfer first pixel of the scanline.i     */	     s=s2;-     *q=(*s++);     q->length=0;     q++;     *q=(*s++);     q->length=0;     q++;*     for (x=2; x < (image->columns-2); x++)     {m       /*.         Note each pixel in a 5x5 neighborhood.       */       s=s0;a       window[0]=(*s++);        window[1]=(*s++);u       window[2]=(*s++);        window[3]=(*s++);g       window[4]=(*s++);e       s=s1;        window[5]=(*s++);a       window[6]=(*s++);l       window[7]=(*s++);        window[8]=(*s++);>       window[9]=(*s++);c       s=s2;)       window[10]=(*s++);       window[11]=(*s++);       window[12]=(*s++);       window[13]=(*s++);       window[14]=(*s++);       s=s3;f       window[15]=(*s++);       window[16]=(*s++);       window[17]=(*s++);       window[18]=(*s++);       window[19]=(*s++);       s=s4;j       window[20]=(*s++);       window[21]=(*s++);       window[22]=(*s++);       window[23]=(*s++);       window[24]=(*s++);       /*&         Determine most frequent color.       */       count=0;$       for (i=0; i < (MaxRGB+1); i++)         histogram[i]=0;        for (i=0; i < 25; i++)       {r%          j=Intensity(window[i]) >> 2;r          histogram[j]++;          j=histogram[j];          if (j > count)             {              pixel=window[i];               count=j;%            }       }%       *q=pixel;%       q->length=0;
       q++;       s0++;        s1++;        s2++;        s3++;        s4++;      }      /**       Transfer last pixel of the scanline.     */	     s=s2;      *q=(*s++);     q->length=0;     q++;     *q=(*s++);     q->length=0;     q++;7     ProgressMonitor(OilPaintImageText,y,image->rows-2);    }    /*!     Dump last scanline of pixels.    */$   s=scanline+image->columns*(y % 5);+   for (x=0; x < (image->columns << 1); x++)    {      *q=(*s);     q->length=0;     q++;     s++;   }    free((char *) histogram);    free((char *) scanline);   return(painted_image); }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%IO %                                                                             %rO %                                                                             %hO %                                                                             % O %   R a i s e I m a g e                                                       %)O %                                                                             %lO %                                                                             %rO %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %aK %  Function RaiseImage lightens and darkens the edges of an image to give a) %  3-D raised or lower effect. %;+ %  The format of the RaiseImage routine is:  %r+ %      RaiseImage(image,raised,bevel_width)l %a+ %  A description of each parameter follows:l %a7 %    o image: The address of a structure of type Image.r %)L %    o raised: A value other than zero causes the image to have a 3-D raised1 %      effect, otherwise it has a lowered effect.e % N %    o bevel_width: This unsigned integer defines the width of the 3-D effect. %e %) */A void RaiseImage(Image *image,int raised,unsigned int bevel_width)! {u# #define HighlightLeft  UpScale(160)r" #define HighlightTop  UpScale(180). #define RaiseImageText  "  Raising image...  "! #define ShadowRight  UpScale(180) " #define ShadowBottom  UpScale(160)  	   Quantumo     foreground,l     background;(     register int     x,     y;     register RunlengthPacket     *p;      unsigned int     height;e  .   if ((image->columns < (bevel_width << 1)) &&)       (image->rows < (bevel_width << 1)))%     {%L       Warning("Unable to raise image","image size must exceed bevel width");
       return;      }    if (!UncompressImage(image))     return;    foreground=MaxRGB;   background=0;    if (!raised)     {        foreground=0;        background=MaxRGB;     }    image->class=DirectClass;    p=image->pixels;!   for (y=0; y < bevel_width; y++)    {      for (x=0; x < y; x++)      {        p->red=(unsigned int) H         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int) J         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB; 
       p++;     }I1     for (x=0; x < (image->columns-(y << 1)); x++)i     {o       p->red=(unsigned int) F         (p->red*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB;       p->green=(unsigned int)tH         (p->green*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB;       p->blue=(unsigned int)G         (p->blue*HighlightTop+foreground*(MaxRGB-HighlightTop))/MaxRGB; 
       p++;     }n     for (x=0; x < y; x++)e     {        p->red=(unsigned int)lD         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int) F         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;%
       p++;     }%   }%(   height=image->rows-(bevel_width << 1);   for (y=0; y < height; y++)   { #     for (x=0; x < bevel_width; x++)      {        p->red=(unsigned int) H         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int) J         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB; 
       p++;     } ;     for (x=0; x < (image->columns-(bevel_width << 1)); x++) 
       p++;#     for (x=0; x < bevel_width; x++)      {        p->red=(unsigned int)%D         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int)gF         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;r
       p++;     }m-     ProgressMonitor(RaiseImageText,y,height);f   }r!   for (y=0; y < bevel_width; y++)a   {t'     for (x=0; x < (bevel_width-y); x++)r     {        p->red=(unsigned int) H         (p->red*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->green=(unsigned int) J         (p->green*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB;       p->blue=(unsigned int)I         (p->blue*HighlightLeft+foreground*(MaxRGB-HighlightLeft))/MaxRGB; 
       p++;     }d?     for (x=0; x < (image->columns-((bevel_width-y) << 1)); x++)c     {r       p->red=(unsigned int) F         (p->red*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;       p->green=(unsigned int)eH         (p->green*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;       p->blue=(unsigned int)G         (p->blue*ShadowBottom+background*(MaxRGB-ShadowBottom))/MaxRGB;>
       p++;     })'     for (x=0; x < (bevel_width-y); x++)r     {        p->red=(unsigned int)nD         (p->red*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->green=(unsigned int);F         (p->green*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;       p->blue=(unsigned int)E         (p->blue*ShadowRight+background*(MaxRGB-ShadowRight))/MaxRGB;*
       p++;     }-   }>	   return;  }  l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     R G B T r a n s f o r m I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %pF %  Function RGBTransformImage converts the reference image from RGB toM %  an alternate colorspace.  The transformation matrices are not the standard L %  ones: the weights are rescaled to normalized the range of the transformed %  values to be [0..MaxRGB]. % 2 %  The format of the RGBTransformImage routine is: %c* %      RGBTransformImage(image,colorspace) % + %  A description of each parameter follows:t %:F %    o image: The address of a structure of type Image;  returned from %      ReadImage.) % L %    o colorspace: An unsigned integer value that indicates which colorspace %      to transform the image. %q %  */< void RGBTransformImage(Image *image,unsigned int colorspace) { A #define RGBTransformImageText  "  Transforming image colors...  "* #define X 0( #define Y (MaxRGB+1) #define Z (MaxRGB+1)*2     long     tx,_     ty,t     tz,q     *x,;     *y,      *z;i  	   Quantum-     *range_table;      register int	     blue,m
     green,     i,     red;     register Quantum     *range_limit;y     register RunlengthPacket     *p;o  M   if ((colorspace == RGBColorspace) || (colorspace == TransparentColorspace))      return; #   if (colorspace == GRAYColorspace)      {        /*2         Return if the image is already gray_scale.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {a:         if ((p->red != p->green) || (p->green != p->blue))           break;         p++;       }_       if (i == image->packets)         return;      }    /*     Allocate the tables.   *//   x=(long *) malloc(3*(MaxRGB+1)*sizeof(long));)/   y=(long *) malloc(3*(MaxRGB+1)*sizeof(long));;/   z=(long *) malloc(3*(MaxRGB+1)*sizeof(long));o?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum)); 5   if ((x == (long *) NULL) || (y == (long *) NULL) ||d@       (z == (long *) NULL) || (range_table == (Quantum *) NULL))     {gL       Warning("Unable to transform color space","Memory allocation failed");
       return;      }i   /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)    {      range_table[i]=0;a*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;t   } %   range_limit=range_table+(MaxRGB+1);o   tx=0;f   ty=0;e   tz=0;i   switch (colorspace))   {      case GRAYColorspace:     {i       /*         Initialize GRAY tables:a  +           G = 0.29900*R+0.58600*G+0.11400*B)       */!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.29900)*i;$         y[i+Y]=UpShifted(0.58600)*i;$         z[i+Y]=UpShifted(0.11400)*i;$         x[i+Z]=UpShifted(0.29900)*i;$         y[i+Z]=UpShifted(0.58600)*i;$         z[i+Z]=UpShifted(0.11400)*i;       }        break;     }i     case OHTAColorspace:     {        /*         Initialize OHTA tables:l  ,           I1 = 0.33333*R+0.33334*G+0.33333*B,           I2 = 0.50000*R+0.00000*G-0.50000*B,           I3 =-0.25000*R+0.50000*G-0.25000*B  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)n       {f$         x[i+X]=UpShifted(0.33333)*i;$         y[i+X]=UpShifted(0.33334)*i;$         z[i+X]=UpShifted(0.33333)*i;$         x[i+Y]=UpShifted(0.50000)*i;         y[i+Y]=0;c'         z[i+Y]=(-UpShifted(0.50000))*i; '         x[i+Z]=(-UpShifted(0.25000))*i;a$         y[i+Z]=UpShifted(0.50000)*i;'         z[i+Z]=(-UpShifted(0.25000))*i;t       }d       break;     }n     case XYZColorspace:'     {        /*"         Initialize CIE XYZ tables:  .           X = 0.412453*X+0.357580*Y+0.180423*Z.           Y = 0.212671*X+0.715160*Y+0.072169*Z.           Z = 0.019334*X+0.119193*Y+0.950227*Z       */!       for (i=0; i <= MaxRGB; i++)f       { %         x[i+X]=UpShifted(0.412453)*i;l%         y[i+X]=UpShifted(0.357580)*i;e%         z[i+X]=UpShifted(0.180423)*i;r%         x[i+Y]=UpShifted(0.212671)*i;t%         y[i+Y]=UpShifted(0.715160)*i; %         z[i+Y]=UpShifted(0.072169)*i;N%         x[i+Z]=UpShifted(0.019334)*i; %         y[i+Z]=UpShifted(0.119193)*i;i%         z[i+Z]=UpShifted(0.950227)*i;        }e       break;     }d     case YCbCrColorspace:      {        /*          Initialize YCbCr tables:  /           Y =  0.299000*R+0.586000*G+0.114000*Bn/           Cb= -0.172586*R-0.338828*G+0.511414*Bv/           Cr=  0.511414*R-0.428246*G-0.083168*Bi  K         Cb and Cr, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.i       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)=       { %         x[i+X]=UpShifted(0.299000)*i; %         y[i+X]=UpShifted(0.586000)*i; %         z[i+X]=UpShifted(0.114000)*i;f(         x[i+Y]=(-UpShifted(0.172586))*i;(         y[i+Y]=(-UpShifted(0.338828))*i;%         z[i+Y]=UpShifted(0.511414)*i;i%         x[i+Z]=UpShifted(0.511414)*i;r(         y[i+Z]=(-UpShifted(0.428246))*i;(         z[i+Z]=(-UpShifted(0.083168))*i;       }\       break;     }      case YCCColorspace:      {+       /*         Initialize YCC tables:  +           Y = 0.29900*R+0.58600*G+0.11400*B;+           C1=-0.29900*R-0.58600*G+0.88600*B +           C2= 0.70100*R-0.58600*G+0.11400*B   B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */0       ty=UpShifted((unsigned int) UpScale(156));0       tz=UpShifted((unsigned int) UpScale(137));!       for (i=0; i <= MaxRGB; i++)t       { $         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;'         x[i+Y]=(-UpShifted(0.29900))*i;i'         y[i+Y]=(-UpShifted(0.58600))*i;o$         z[i+Y]=UpShifted(0.88600)*i;$         x[i+Z]=UpShifted(0.70100)*i;'         y[i+Z]=(-UpShifted(0.58600))*i;i'         z[i+Z]=(-UpShifted(0.11400))*i;r       }a       break;     }      case YIQColorspace:*     {a       /*         Initialize YIQ tables:  +           Y = 0.29900*R+0.58600*G+0.11400*B)+           I = 0.50000*R-0.23000*G-0.27000*B +           Q = 0.20200*R-0.50000*G+0.29800*Bi  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0e         through MaxRGB.e       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)'       {!$         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.50000)*i;'         y[i+Y]=(-UpShifted(0.23000))*i; '         z[i+Y]=(-UpShifted(0.27000))*i; $         x[i+Z]=UpShifted(0.20200)*i;'         y[i+Z]=(-UpShifted(0.50000))*i; $         z[i+Z]=UpShifted(0.29800)*i;       }e       break;     }(     case YPbPrColorspace:i     {        /*          Initialize YPbPr tables:  /           Y =  0.299000*R+0.587000*G+0.114000*B /           Pb= -0.168736*R-0.331264*G+0.500000*Bo/           Pr=  0.500000*R-0.418688*G-0.081312*B0  K         Pb and Pr, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.(       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)o       {e%         x[i+X]=UpShifted(0.299000)*i;w%         y[i+X]=UpShifted(0.587000)*i; %         z[i+X]=UpShifted(0.114000)*i;r(         x[i+Y]=(-UpShifted(0.168736))*i;(         y[i+Y]=(-UpShifted(0.331264))*i;%         z[i+Y]=UpShifted(0.500000)*i;p%         x[i+Z]=UpShifted(0.500000)*i;f(         y[i+Z]=(-UpShifted(0.418688))*i;(         z[i+Z]=(-UpShifted(0.081312))*i;       }%       break;     }%     case YUVColorspace:%     default:     {        /*         Initialize YUV tables:  ,           Y =  0.29900*R+0.58600*G+0.11400*B,           U = -0.14740*R-0.28950*G+0.43690*B,           V =  0.61500*R-0.51500*G-0.10000*B  I         U and V, normally -0.5 through 0.5, are normalized to the range 0 D         through MaxRGB.  Note that U = 0.493*(B-Y), V = 0.877*(R-Y).       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;'         x[i+Y]=(-UpShifted(0.14740))*i; '         y[i+Y]=(-UpShifted(0.28950))*i;e$         z[i+Y]=UpShifted(0.43690)*i;$         x[i+Z]=UpShifted(0.61500)*i;'         y[i+Z]=(-UpShifted(0.51500))*i;g'         z[i+Z]=(-UpShifted(0.10000))*i;l       }h       break;     }t   }n   /*     Convert from RGB.    */   switch (image->class)    {T     case DirectClass:p     {h       /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          red=p->red;r         green=p->green;u         blue=p->blue;bH         p->red=range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)];J         p->green=range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];I         p->blue=range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];          p++;!         if (QuantumTick(i,image)) B           ProgressMonitor(RGBTransformImageText,i,image->packets);       }        break;     }b     case PseudoClass:      {f       /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)i       {e#         red=image->colormap[i].red; '         green=image->colormap[i].green;n%         blue=image->colormap[i].blue;          image->colormap[i].red= C           range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)];h!         image->colormap[i].green= C           range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];           image->colormap[i].blue=C           range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];o       })       SyncImage(image);        break;     }U   }    /*     Free allocated memory.   */   free((char *) range_table);)   free((char *) z);*   free((char *) y);s   free((char *) x);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %lO %                                                                             % O %   R o l l I m a g e                                                         %)O %                                                                             %oO %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % E %  Function RollImage rolls an image vertically and horizontally.  IteK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % * %  The format of the RollImage routine is: % 1 %      rolled_image=RollImage(image,columns,rows)d %x+ %  A description of each parameter follows:a %rL %    o rolled_image: Function RollImage returns a pointer to the image afterH %      rolling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.e %cH %    o x_offset: An integer that specifies the number of columns to roll# %      in the horizontal direction.  % L %    o y_offset: An integer that specifies the number of rows to roll in the %      vertical direction. %m %- */8 Image *RollImage(Image *image,int x_offset,int y_offset) { - #define RollImageText  "  Rolling image...  "m     Image      *rolled_image;     register RunlengthPacket     *p,e     *q;      register unsigned int      packets,     x;     unsigned int     y;     /*'     Initialize rolled image attributes.    */A   rolled_image=CopyImage(image,image->columns,image->rows,False);c%   if (rolled_image == (Image *) NULL)      {aA       Warning("Unable to roll image","Memory allocation failed");e       return((Image *) NULL);o     }    /*     Roll image.e   */   p=image->pixels;   image->runlength=p->length+1;1%   packets=image->columns*image->rows;m!   for (y=0; y < image->rows; y++)    {      /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {s        if (image->runlength != 0)         image->runlength--; 
       else	         {=           p++;%           image->runlength=p->length; 	         }eD       q=rolled_image->pixels+(y_offset+y)*image->columns+x+x_offset;#       if (q < rolled_image->pixels)          q+=packets;a
       else0         if (q >= (rolled_image->pixels+packets))           q-=packets;;       *q=(*p);       q->length=0;     }_1     ProgressMonitor(RollImageText,y,image->rows);G   }    return(rolled_image);; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%QO %                                                                             % O %                                                                             %eO %                                                                             %oO %   S a m p l e I m a g e                                                     %sO %                                                                             % O %                                                                             %nO %                                                                             %bO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function SampleImage creates a new image that is a scaled size of an%H %  existing one using pixel sampling.  It allocates the memory necessaryF %  for the new Image structure and returns a pointer to the new image. % , %  The format of the SampleImage routine is: % 4 %      sampled_image=SampleImage(image,columns,rows) % + %  A description of each parameter follows:  % O %    o sampled_image: Function SampleImage returns a pointer to the image after H %      scaling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.% %%N %    o columns: An integer that specifies the number of columns in the sampled
 %      image.e %mH %    o rows: An integer that specifies the number of rows in the sampled
 %      image.m %r %e */G Image *SampleImage(Image *image,unsigned int columns,unsigned int rows)g { 0 #define SampleImageText  "  Sampling image...  "     Imaged     *sampled_image;      int      y;     register RunlengthPacket     *p,T     *q,n     *s;s     register int     x;     RunlengthPacketi     *scanline;     unsigned int     *x_offset,     *y_offset;     unsigned long      scale_factor;   $   if ((columns == 0) || (rows == 0))     { D       Warning("Unable to sample image","image dimensions are zero");       return((Image *) NULL);      }g   /*(     Initialize sampled image attributes.   */4   sampled_image=CopyImage(image,columns,rows,False);&   if (sampled_image == (Image *) NULL)     { C       Warning("Unable to sample image","Memory allocation failed");r       return((Image *) NULL);      }o   /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));P   x_offset=(unsigned int *) malloc(sampled_image->columns*sizeof(unsigned int));M   y_offset=(unsigned int *) malloc(sampled_image->rows*sizeof(unsigned int));=/   if ((scanline == (RunlengthPacket *) NULL) ||e,       (x_offset == (unsigned int *) NULL) ||*       (y_offset == (unsigned int *) NULL))     {.C       Warning("Unable to sample image","Memory allocation failed"); "       DestroyImage(sampled_image);       return((Image *) NULL);a     }    /*$     Initialize column pixel offsets.   */@   scale_factor=UpShift(image->columns-1)/sampled_image->columns;   columns=0;,   for (x=0; x < sampled_image->columns; x++)   {l<     x_offset[x]=DownShift((x+1)*scale_factor)-(int) columns;     columns+=x_offset[x];    }    /*!     Initialize row pixel offsets.    */:   scale_factor=UpShift(image->rows-1)/sampled_image->rows;	   rows=0;n)   for (y=0; y < sampled_image->rows; y++)d   {m9     y_offset[y]=DownShift((y+1)*scale_factor)-(int) rows;f     rows+=y_offset[y];   }L$   y_offset[sampled_image->rows-1]=0;   /*     Preload first scanline.i   */   p=image->pixels;   image->runlength=p->length+1;g
   s=scanline;C$   for (x=0; x < image->columns; x++)   {      if (image->runlength != 0)       image->runlength--;      else       {c         p++;#         image->runlength=p->length;        }h     *s=(*p);     s->length=0;     s++;   }    /*     Sample each row.   */   q=sampled_image->pixels;)   for (y=0; y < sampled_image->rows; y++)N   {      /*       Sample each column.t     */     s=scanline; .     for (x=0; x < sampled_image->columns; x++)     {        *q=(*s);
       q++;       s+=x_offset[x];<     }+     if (y_offset[y] != 0)n       { 
         /*           Skip a scan line. 
         */         if (y_offset[y] > 1)>           for (x=0; x < (image->columns*(y_offset[y]-1)); x++)&             if (image->runlength != 0)!               image->runlength--;a             else               {u                 p++;+                 image->runlength=p->length;l               }e
         /*           Read a scan line.c
         */         s=scanline;o*         for (x=0; x < image->columns; x++)	         {.$           if (image->runlength != 0)             image->runlength--;s           else
             {                p++;)               image->runlength=p->length;m
             }y           *s=(*p);           s->length=0;           s++;	         }m       }m;     ProgressMonitor(SampleImageText,y,sampled_image->rows);    }    free((char *) scanline);   free((char *) x_offset);   free((char *) y_offset);   return(sampled_image); }g - /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %oO %                                                                             %iO %                                                                             %gO %   S c a l e I m a g e                                                       % O %                                                                             %eO %                                                                             %hO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %RF %  Function ScaleImage creates a new image that is a scaled size of anE %  existing one.  It allocates the memory necessary for the new ImagelI %  structure and returns a pointer to the new image.  To scale a scanline K %  from x pixels to y pixels, each new pixel represents x/y old pixels.  To L %  read x/y pixels, read (x/y rounded up) pixels but only count the requiredH %  fraction of the last old pixel read in your new pixel.  The remainder: %  of the old pixel will be counted in the next new pixel. % K %  The scaling algorithm was suggested by rjohnson@shell.com and is adapted 0 %  from pnmscale(1) of PBMPLUS by Jef Poskanzer. %-+ %  The format of the ScaleImage routine is:1 % 2 %      scaled_image=ScaleImage(image,columns,rows) %e+ %  A description of each parameter follows:_ %eM %    o scaled_image: Function ScaleImage returns a pointer to the image after H %      scaling.  A null image is returned if there is a memory shortage. %)7 %    o image: The address of a structure of type Image.( %rM %    o columns: An integer that specifies the number of columns in the scaled;
 %      image.d %aG %    o rows: An integer that specifies the number of rows in the scaled%
 %      image.% %% %  */F Image *ScaleImage(Image *image,unsigned int columns,unsigned int rows) { . #define ScaleImageText  "  Scaling image...  "     typedef struct ScaledPacket    {      long
       red,       green,       blue,        index;   } ScaledPacket;      Image      *scaled_image;     int 
     next_row,      number_rows;     long     x_scale,     x_span;      register RunlengthPacket     *p,      *q;      register ScaledPacket      *s,      *t;      register unsigned int      x;     ScaledPacket     *scaled_scanline,%     *scanline,     *y_vector,     *x_vector;     unsigned int     packets,     y;     unsigned longs	     blue,e
     green,
     index,     red,     scale_factor;c  $   if ((columns == 0) || (rows == 0))     {rC       Warning("Unable to scale image","image dimensions are zero");v       return((Image *) NULL);r     }c   /*'     Initialize scaled image attributes.l   */B   scale_factor=UpShift(columns*rows)/(image->columns*image->rows);8   packets=Max(DownShift(image->packets*scale_factor),1);0   scaled_image=CopyImage(image,packets,1,False);%   if (scaled_image == (Image *) NULL)e     {.B       Warning("Unable to scale image","Memory allocation failed");       return((Image *) NULL);b     }l"   scaled_image->class=DirectClass;    scaled_image->columns=columns;   scaled_image->rows=rows;   scaled_image->packets=0;   /*     Allocate memory.   */H   x_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));   scanline=x_vector;(   if (scaled_image->rows != image->rows)J     scanline=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));"   scaled_scanline=(ScaledPacket *)7     malloc(scaled_image->columns*sizeof(ScaledPacket));rH   y_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));,   if ((x_vector == (ScaledPacket *) NULL) ||,       (scanline == (ScaledPacket *) NULL) ||3       (scaled_scanline == (ScaledPacket *) NULL) ||t*       (y_vector == (ScaledPacket *) NULL))     {\B       Warning("Unable to scale image","Memory allocation failed");!       DestroyImage(scaled_image);r       return((Image *) NULL);      }a   /*     Scale image.   */
   index=0;   number_rows=0;   next_row=True;2   x_scale=UpShift(scaled_image->rows)/image->rows;   x_span=UpShift(1);$   for (x=0; x < image->columns; x++)   {      y_vector[x].red=0;     y_vector[x].green=0;     y_vector[x].blue=0;s     y_vector[x].index=0;   }n   p=image->pixels;   image->runlength=p->length+1;n   q=scaled_image->pixels;,   q->red=0; 
   q->green=0;e   q->blue=0;
   q->index=0;    q->length=MaxRunlength;s(   for (y=0; y < scaled_image->rows; y++)   {u*     if (scaled_image->rows == image->rows)(       for (x=0; x < image->columns; x++)       { 
         /*           Read a new scanline.
         */"         if (image->runlength != 0)           image->runlength--;          else           {              p++;'             image->runlength=p->length;u           }"         x_vector[x].red=p->red; #         x_vector[x].green=p->green;e!         x_vector[x].blue=p->blue;c#         x_vector[x].index=p->index;n       }r     else       {(
         /*           Scale Y direction.
         */          while (x_scale < x_span)	         {i6           if (next_row && (number_rows < image->rows))
             {>               /*$                 Read a new scanline.               */0               for (x=0; x < image->columns; x++)               {s*                 if (image->runlength != 0)%                   image->runlength--;e                 else                   {l                     p++;/                     image->runlength=p->length;                    }l'                 x_vector[x].red=p->red;i+                 x_vector[x].green=p->green; )                 x_vector[x].blue=p->blue;q+                 x_vector[x].index=p->index;G               }a               number_rows++;
             } ,           for (x=0; x < image->columns; x++)           {h5             y_vector[x].red+=x_scale*x_vector[x].red;>9             y_vector[x].green+=x_scale*x_vector[x].green; 7             y_vector[x].blue+=x_scale*x_vector[x].blue; 9             y_vector[x].index+=x_scale*x_vector[x].index;;           }            x_span-=x_scale;:           x_scale=UpShift(scaled_image->rows)/image->rows;           next_row=True;	         }o4         if (next_row && (number_rows < image->rows))           {              /*"               Read a new scanline.             */.             for (x=0; x < image->columns; x++)
             {w(               if (image->runlength != 0)#                 image->runlength--;s               else                 {                    p++;-                   image->runlength=p->length;(                 }4%               x_vector[x].red=p->red; )               x_vector[x].green=p->green; '               x_vector[x].blue=p->blue;c)               x_vector[x].index=p->index;e
             }              number_rows++;             next_row=False;            }          s=scanline;p*         for (x=0; x < image->columns; x++)	         { @           red=DownShift(y_vector[x].red+x_span*x_vector[x].red);F           green=DownShift(y_vector[x].green+x_span*x_vector[x].green);C           blue=DownShift(y_vector[x].blue+x_span*x_vector[x].blue);eF           index=DownShift(y_vector[x].index+x_span*x_vector[x].index);-           s->red=red > MaxRGB ? MaxRGB : red; 3           s->green=green > MaxRGB ? MaxRGB : green;e0           s->blue=blue > MaxRGB ? MaxRGB : blue;E           s->index=index > MaxColormapSize ? MaxColormapSize : index;0           s++;           y_vector[x].red=0;           y_vector[x].green=0;           y_vector[x].blue=0;E           y_vector[x].index=0;	         }c         x_scale-=x_span;         if (x_scale == 0)            {E<             x_scale=UpShift(scaled_image->rows)/image->rows;             next_row=True;           }c         x_span=UpShift(1);       })0     if (scaled_image->columns == image->columns)       { 
         /*,           Transfer scanline to scaled image.
         */         s=scanline;t1         for (x=0; x < scaled_image->columns; x++)h	         { =           if ((s->red == q->red) && (s->green == q->green) &&g?               (s->blue == q->blue) && (s->index == q->index) && /               ((int) q->length < MaxRunlength))3             q->length++;           else
             { -               if (scaled_image->packets != 0)                  q++;&               scaled_image->packets++;3               if (scaled_image->packets == packets)o                 {e                   packets<<=1;K                   scaled_image->pixels=(RunlengthPacket *) realloc((char *)%J                     scaled_image->pixels,packets*sizeof(RunlengthPacket));G                   if (scaled_image->pixels == (RunlengthPacket *) NULL)*                     {h6                       Warning("Unable to scale image",4                         "Memory allocation failed");1                       DestroyImage(scaled_image); -                       return((Image *) NULL);                      } A                   q=scaled_image->pixels+scaled_image->packets-1;                  }                q->red=s->red;                q->green=s->green;               q->blue=s->blue;                q->index=s->index;               q->length=0;
             }            s++;	         }        }      else       {          int            next_column;           long           y_scale,           y_span;%  
         /*           Scale X direction.
         */         red=0;         green=0;         blue=0;s         next_column=False;         y_span=UpShift(1);         s=scanline;u         t=scaled_scanline;*         for (x=0; x < image->columns; x++)	         {a@           y_scale=UpShift(scaled_image->columns)/image->columns;#           while (y_scale >= y_span)            {              if (next_column)               {                  red=0;                 green=0;                 blue=0;                  index=0;                 t++;               }n-             red=DownShift(red+y_span*s->red);i3             green=DownShift(green+y_span*s->green); 0             blue=DownShift(blue+y_span*s->blue);3             index=DownShift(index+y_span*s->index);z/             t->red=red > MaxRGB ? MaxRGB : red;o5             t->green=green > MaxRGB ? MaxRGB : green;u2             t->blue=blue > MaxRGB ? MaxRGB : blue;G             t->index=index > MaxColormapSize ? MaxColormapSize : index;              y_scale-=y_span;             y_span=UpShift(1);             next_column=True;"           }c         if (y_scale > 0)           {              if (next_column)               {                  red=0;                 green=0;                 blue=0;                  index=0;"                 next_column=False;                 t++;               }               red+=y_scale*s->red;$             green+=y_scale*s->green;"             blue+=y_scale*s->blue;$             index+=y_scale*s->index;             y_span-=y_scale;           }[         s++;       }        if (y_span > 0)a	         {            s--;           red+=y_span*s->red; !           green+=y_span*s->green;o           blue+=y_span*s->blue; !           index+=y_span*s->index; 	         }p       if (!next_column)(	         {p           red=DownShift(red);1!           green=DownShift(green);            blue=DownShift(blue); !           index=DownShift(index); -           t->red=red > MaxRGB ? MaxRGB : red;q3           t->green=green > MaxRGB ? MaxRGB : green;-0           t->blue=blue > MaxRGB ? MaxRGB : blue;3           t->index=index > MaxRGB ? MaxRGB : index; 	         }n       /**         Transfer scanline to scaled image.       */       t=scaled_scanline;/       for (x=0; x < scaled_image->columns; x++)o       {e;         if ((t->red == q->red) && (t->green == q->green) && =             (t->blue == q->blue) && (t->index == q->index) &&d-             ((int) q->length < MaxRunlength))            q->length++;         else           {r+             if (scaled_image->packets != 0)d               q++;$             scaled_image->packets++;1             if (scaled_image->packets == packets)=               {e                 packets<<=1;I                 scaled_image->pixels=(RunlengthPacket *) realloc((char *)aH                   scaled_image->pixels,packets*sizeof(RunlengthPacket));E                 if (scaled_image->pixels == (RunlengthPacket *) NULL)                    { P                     Warning("Unable to scale image","Memory allocation failed");/                     DestroyImage(scaled_image); +                     return((Image *) NULL);                    } ?                 q=scaled_image->pixels+scaled_image->packets-1;                }              q->red=t->red;             q->green=t->green;             q->blue=t->blue;             q->index=t->index;             q->length=0;           }          t++;       }      } 9     ProgressMonitor(ScaleImageText,y,scaled_image->rows);%   }%;   scaled_image->pixels=(RunlengthPacket *) realloc((char *)tH     scaled_image->pixels,scaled_image->packets*sizeof(RunlengthPacket));   /*     Free allocated memory.   */   free((char *) y_vector);!   free((char *) scaled_scanline);t   if (scanline != x_vector)T     free((char *) scanline);   free((char *) x_vector);   return(scaled_image);  }  A /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %nO %                                                                             %rO %                                                                             %lO %   S e t I m a g e I n f o                                                   %tO %                                                                             % O %                                                                             %iO %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %iH %  Function SetImageInfo initializes the `magick' field of the ImageInfoI %  structure.  It is set to a type of image format based on the prefix or I %  suffix of the filename.  For example, `ps:image' returns PS indicating)H %  a Postscript image.  JPEG is returned for this filename: `image.jpg'.M %  The filename prefix has precedance over the suffix.  Use an optional indexdL %  enclosed in brackets after a file name to specify a desired subimage of aE %  multi-resolution image format like Photo CD (e.g. img0001.pcd[4]).m %-- %  The format of the SetImageInfo routine is:  %  %      SetImageInfo(image_info)  % + %  A description of each parameter follows:c %i@ %    o image_info: Specifies a pointer to a ImageInfo structure. %- %n */( void SetImageInfo(ImageInfo *image_info) { 
   static char*     *ImageFormats[][2]=      {-       { "AVS", "False" },        { "BIE", "False" },        { "BMP", "True" },       { "CMYK", "False" },       { "DCX", "True" },       { "EPS", "False" },        { "EPS2", "False" },       { "EPSF", "False" },       { "EPSI", "False" },       { "FAX", "True" },       { "FITS", "False" },       { "FTP", "False" },        { "GIF", "True" },       { "GIF87", "False" },e       { "GOPHER", "False" },       { "GRAY", "False" },       { "G3", "False" },       { "HDF", "True" },       { "HISTOGRAM", "False" },        { "HTML", "False" },       { "HTTP", "False" },       { "JBIG", "True" },        { "JPEG", "False" },       { "JPG", "False" },        { "LOGO", "False" },       { "MAP", "False" },        { "MATTE", "False" },        { "MIFF", "True" },        { "MPG", "True" },       { "MPEG", "False" },       { "MTV", "True" },       { "NULL", "False" },       { "PBM", "True" },       { "PCD", "False" },        { "PCX", "False" },c       { "PDF", "True" },       { "PGM", "True" },       { "PICT", "False" },       { "PM", "False" },       { "PNG", "False" },%       { "PPM", "True" },       { "PNM", "True" },       { "PS", "True" },        { "PS2", "True" },       { "RAD", "False" },e       { "RAS", "True" },       { "RGB", "False" },m       { "RGBA", "False" },       { "RLA", "False" },g       { "RLE", "False" },e       { "SGI", "True" },       { "SUN", "True" },       { "TGA", "True" },       { "TEXT", "False" },       { "TIF", "True" },       { "TIFF", "True" },a       { "TILE", "False" },       { "TMP", "False" },t       { "UYVY", "False" },       { "VICAR", "False" },        { "VID", "False" },a       { "VIFF", "True" },u       { "X", "False" },n       { "XBM", "False" },e       { "XC", "False" },       { "XPM", "False" },e       { "XV", "True" },f       { "XWD", "False" },r       { "YUV", "False" },        { "YUV3", "False" },&       { (char *) NULL, (char *) NULL }     };     char     c,     magick[MaxTextLength];     register chart     *p,      *q;l     register int     i;     /*(     Look for 'image.format' in filename.   */   *magick='\0';L8   p=image_info->filename+strlen(image_info->filename)-1;   if (*p == ']')     {        /*F         Look for sub-image enclosed in brackets (e.g. img0001.pcd[4]).       */0       for (q=p-1; q > image_info->filename; q--)(         if (!isdigit(*q) && (*q != '-'))           break;       if (*q == '[')	         {            p=q++;'           image_info->subimage=atoi(q);a'           image_info->subrange=atoi(q);dO           (void) sscanf(q,"%u-%u",&image_info->subimage,&image_info->subrange); 7           image_info->subrange-=image_info->subimage-1;=           *p='\0';	         }y     } 3   while ((*p != '.') && (p > image_info->filename))a     p--;6   if ((strcmp(p,".gz") == 0) || (strcmp(p,".Z") == 0))     do     { 
       p--;8     } while ((*p != '.') && (p > image_info->filename));2   if ((*p == '.') && (strlen(p) < sizeof(magick)))     {n       /*$         User specified image format.       */        (void) strcpy(magick,p+1);%       for (q=magick; *q != '\0'; q++)>       {          if (*q == '.')           {m             *q='\0';             break;           }l         c=(*q);+         if (islower(c))o           *q=toupper(c);       }-9       for (i=0; ImageFormats[i][0] != (char *) NULL; i++)d3         if (strcmp(magick,ImageFormats[i][0]) == 0)%           {%             /*(               SGI and RGB are ambiguous.             */=             if ((strncmp(image_info->magick,"SGI",3) != 0) || 8                 (strcmp(ImageFormats[i][0],"RGB") != 0))7               (void) strcpy(image_info->magick,magick);              break;           }      }    /*1     Look for explicit 'format:image' in filename.    */   image_info->assert=False;    p=image_info->filename; %   while ((*p != ':') && (*p != '\0'))      p++;A   if ((*p == ':') && ((p-image_info->filename) < sizeof(magick)))      {        /*$         User specified image format.       */I       (void) strncpy(magick,image_info->filename,p-image_info->filename);%*       magick[p-image_info->filename]='\0';%       for (q=magick; *q != '\0'; q++)o       {p         c=(*q);          if (islower(c))e           *q=toupper(c);       }c9       for (i=0; ImageFormats[i][0] != (char *) NULL; i++)r3         if (strcmp(magick,ImageFormats[i][0]) == 0)_           {a             /*,               Strip off image format prefix.             */             p++;2             (void) strcpy(image_info->filename,p);5             (void) strcpy(image_info->magick,magick); *             if (strcmp(magick,"TMP") != 0)&               image_info->assert=True;             break;           }p     }t   /*3     Determine if format supports multi-image files.e   */5   for (i=0; ImageFormats[i][0] != (char *) NULL; i++)*;     if (strcmp(image_info->magick,ImageFormats[i][0]) == 0)i5       image_info->adjoin&=IsTrue(ImageFormats[i][1]);  }e t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             % O %                                                                             %fO %     S h a r p e n I m a g e                                                 %nO %                                                                             %NO %                                                                             % O %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %gJ %  Function SharpenImage creates a new image that is a copy of an existingL %  one with the pixels sharpened.  It allocates the memory necessary for the> %  new Image structure and returns a pointer to the new image. %aK %  SharpenImage convolves the pixel neighborhood with this sharpening mask:U % 
 %    -1 -2 -1 
 %    -2  W -2 
 %    -1 -2 -1, %mL %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.. %e- %  The format of the SharpenImage routine is:  %a1 %      sharpened_image=SharpenImage(image,factor). %=+ %  A description of each parameter follows:. %eL %    o sharpened_image: Function SharpenImage returns a pointer to the imageL %      after it is sharpened.  A null image is returned if there is a memory %      shortage. %oF %    o image: The address of a structure of type Image;  returned from %      ReadImage.l %bL %    o factor:  An double value reflecting the percent weight to give to the( %      center pixel of the neighborhood. %a %> *// Image *SharpenImage(Image *image,double factor)+ {  #define Sharpen(weight) \a'   total_red+=(weight)*(int) (s->red); \h+   total_green+=(weight)*(int) (s->green); \u)   total_blue+=(weight)*(int) (s->blue); \ +   total_index+=(weight)*(int) (s->index); \    s++;3 #define SharpenImageText  "  Sharpening image...  "      Imageg     *sharpened_image;      long     total_blue,m     total_green,     total_index,     total_red,     weight;0     register RunlengthPacket     *p,      *q,s     *s,      *s0,     *s1,     *s2;     register unsigned int      x;     RunlengthPacket>     *scanline;     unsigned int     quantum,     y;  0   if ((image->columns < 3) || (image->rows < 3))     { F       Warning("Unable to sharpen image","image size must exceed 3x3");       return((Image *) NULL);o     }    /**     Initialize sharpened image attributes.   */D   sharpened_image=CopyImage(image,image->columns,image->rows,False);(   if (sharpened_image == (Image *) NULL)     {tD       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      }=%   sharpened_image->class=DirectClass;e   /*6     Allocate scan line buffer for 3 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(3*(image->columns+1)*sizeof(RunlengthPacket));++   if (scanline == (RunlengthPacket *) NULL)      {iD       Warning("Unable to enhance image","Memory allocation failed");$       DestroyImage(sharpened_image);       return((Image *) NULL);r     }n   /*)     Read the first two rows of the image.)   */   p=image->pixels;   image->runlength=p->length+1;r,   for (x=0; x < (3*(image->columns+1)); x++)     scanline[x]=(*p);-
   s=scanline;e+   for (x=0; x < (image->columns << 1); x++)l   {=     if (image->runlength != 0)       image->runlength--;_     else       {          p++;#         image->runlength=p->length;_       }m     *s=(*p);     s++;   }    /*!     Dump first scanline of image.m   */   q=sharpened_image->pixels;
   s=scanline;x$   for (x=0; x < image->columns; x++)   {o     *q=(*s);     q->index=0;;     q->length=0;     q++;     s++;   }    /*     Convolve each row.   */&   weight=(long) ((100.0-factor)/2+13);   quantum=Max(weight-12,1);0%   for (y=1; y < (image->rows-1); y++)    {      /*)       Initialize sliding window pointers.q     */+     s0=scanline+image->columns*((y-1) % 3);f'     s1=scanline+image->columns*(y % 3);h+     s2=scanline+image->columns*((y+1) % 3);_     /*       Read another scan line.      */	     s=s2;t&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--;g
       else	         {r           p++;%           image->runlength=p->length;e	         }        *s=(*p);
       s++;     }>     /*+       Transfer first pixel of the scanline.x     */
     *q=(*s1);c     q->length=0;     q++;*     for (x=1; x < (image->columns-1); x++)     {        /*B         Compute weighted average of target pixel color components.       */       total_red=0;       total_green=0;       total_blue=0;        total_index=0;       s=s0;r,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       s=s1;u0       Sharpen(-2); Sharpen(weight); Sharpen(-2);       s=s2;%,       Sharpen(-1); Sharpen(-2); Sharpen(-1);       if (total_red < 0)         q->red=0; 
       else)         if (total_red > (MaxRGB*quantum))            q->red=MaxRGB;         else@           q->red=(Quantum) ((total_red+(quantum >> 1))/quantum);       if (total_green < 0)         q->green=0; 
       else+         if (total_green > (MaxRGB*quantum))            q->green=MaxRGB;         elseD           q->green=(Quantum) ((total_green+(quantum >> 1))/quantum);       if (total_blue < 0)          q->blue=0;
       else*         if (total_blue > (MaxRGB*quantum))           q->blue=MaxRGB;%         elseB           q->blue=(Quantum) ((total_blue+(quantum >> 1))/quantum);       if (total_index < 0)         q->index=0;a
       else+         if (total_index > (MaxRGB*quantum))t           q->index=MaxRGB;         elseK           q->index=(unsigned short) ((total_index+(quantum >> 1))/quantum);r       q->length=0;
       q++;       s0++;h       s1++;g       s2++;h     }      /**       Transfer last pixel of the scanline.     */	     s1++;m
     *q=(*s1);n     q->length=0;     q++;6     ProgressMonitor(SharpenImageText,y,image->rows-1);   };   /*!     Dump last scanline of pixels._   */$   s=scanline+image->columns*(y % 3);$   for (x=0; x < image->columns; x++)   {n     *q=(*s);     q->length=0;     q++;     s++;   }=   free((char *) scanline);   return(sharpened_image); }" e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             %aO %                                                                             %lO %     S p r e a d I m a g e                                                   %cO %                                                                             %iO %                                                                             %aO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %aI %  Function SpreadImage creates a new image that is a copy of an existingxI %  one with the image pixels randomly displaced.  It allocates the memory_I %  necessary for the new Image structure and returns a pointer to the newx	 %  image.  % , %  The format of the SpreadImage routine is: %Q- %      spread_image=SpreadImage(image,amount)l %g+ %  A description of each parameter follows:c %sH %    o spread_image: Function SpreadImage returns a pointer to the imageI %      after it is spread.  A null image is returned if there is a memorym %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % K %    o amount:  An unsigned value constraining the "vicintity" for choosing( %      a random pixel to swap. %o %a */4 Image *SpreadImage(Image *image,unsigned int amount) { 1 #define SpreadImageText  "  Spreading image...  "      Imager     *spread_image;     long     quantum,     x_distance,c     y_distance;      register RunlengthPacket     *p,m     *q;a     register unsigned int      x;     unsigned int     y;  0   if ((image->columns < 3) || (image->rows < 3))     {cE       Warning("Unable to spread image","image size must exceed 3x3");        return((Image *) NULL);a     }    if (!UncompressImage(image))     return((Image *) NULL);g   /*'     Initialize spread image attributes.r   */A   spread_image=CopyImage(image,image->columns,image->rows,False);%%   if (spread_image == (Image *) NULL)      { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } "   spread_image->class=DirectClass;   /*     Convolve each row.   */   srand(time((time_t *) NULL));    amount++;    quantum=amount >> 1;   q=spread_image->pixels; !   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { +       x_distance=(rand() & amount)-quantum; +       y_distance=(rand() & amount)-quantum; C       p=image->pixels+(y+y_distance)*image->columns+(x+x_distance); F       if ((p > image->pixels) && (p < (image->pixels+image->packets)))         *q=(*p);
       q++;     } 3     ProgressMonitor(SpreadImageText,y,image->rows);o   }n   return(spread_image);e }r   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %fO %                                                                             %iO %   S o r t C o l o r m a p B y I n t e n t s i t y                           %eO %                                                                             %-O %                                                                             %pO %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function SortColormapByIntensity sorts the colormap of a PseudoClass image ! %  by decreasing color intensity.  % 8 %  The format of the SortColormapByIntensity routine is: % % %      SortColormapByIntensity(image)  % + %  A description of each parameter follows:  % - %    o image: A pointer to a Image structure.  %  %  */8 static int IntensityCompare(const void *x,const void *y) { 
   ColorPacket 
     *color_1, 
     *color_2;      color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }%  * void SortColormapByIntensity(Image *image) {%   register int     i;     register RunlengthPacket     *p;e     register unsigned shortf
     index;     unsigned short     *pixels;  "   if (image->class != PseudoClass)     return;n   /*&     Allocate memory for pixel indexes.   */I   pixels=(unsigned short *) malloc(image->colors*sizeof(unsigned short));f(   if (pixels == (unsigned short *) NULL)     {cD       Warning("Unable to sort colormap","Memory allocation failed");
       return;i     }=   /*,     Assign index values to colormap entries.   */#   for (i=0; i < image->colors; i++)i0     image->colormap[i].index=(unsigned short) i;   /*7     Sort image colormap by decreasing color popularity.g   */I   qsort((void *) image->colormap,(int) image->colors,sizeof(ColorPacket),n<     (int (*)(const void *, const void *)) IntensityCompare);   /*;     Update image colormap indexes to sorted colormap order.)   */#   for (i=0; i < image->colors; i++)_8     pixels[image->colormap[i].index]=(unsigned short) i;   p=image->pixels;$   for (i=0; i < image->packets; i++)   {g     index=pixels[p->index];_&     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p->index=index;s     p++;   }g   free((char *) pixels); }  o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             %xO %                                                                             %tO %   S t e r e o I m a g e                                                     %oO %                                                                             %sO %                                                                             %oO %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %aL %  Function StereoImage combines two images and produces a single image thatI %  is the composite of a left and right image of a stereo pair.  The leftpI %  image is converted to gray_scale and written to the red channel of thetO %  stereo image.  The right image is converted to gray_scale and written to the:L %  blue channel of the stereo image.  View the composite image with red-blue% %  glasses to create a stereo effect., % , %  The format of the StereoImage routine is: % 7 %      stereo_image=StereoImage(left_image,right_image)h %e+ %  A description of each parameter follows:" %)I %    o stereo_image: Function StereoImage returns a pointer to the stereo%F %      image.  A null image is returned if there is a memory shortage. % < %    o left_image: The address of a structure of type Image. % = %    o right_image: The address of a structure of type Image.  %  %  */8 Image *StereoImage(Image *left_image,Image *right_image) { . #define StereoImageText  "  Stereo image...  "     Image      *stereo_image;     int      y;     register int     x;     register RunlengthPacket     *p,      *q,      *r;   6   if ((left_image->columns != right_image->columns) ||.       (left_image->rows != right_image->rows))     {%.       Warning("Unable to create stereo image",-         "left and right image sizes differ");        return((Image *) NULL);      }s   /*'     Initialize stereo image attributes.t   */P   stereo_image=CopyImage(left_image,left_image->columns,left_image->rows,False);%   if (stereo_image == (Image *) NULL)      {rJ       Warning("Unable to create stereo image","Memory allocation failed");       return((Image *) NULL);o     }e"   stereo_image->class=DirectClass;   /*C     Copy left image to red channel and right image to blue channel.a   */7   QuantizeImage(left_image,256,8,False,GRAYColorspace);    SyncImage(left_image);   p=left_image->pixels;a$   left_image->runlength=p->length+1;8   QuantizeImage(right_image,256,8,False,GRAYColorspace);   SyncImage(right_image);r   q=right_image->pixels;%   right_image->runlength=q->length+1;    r=stereo_image->pixels; (   for (y=0; y < stereo_image->rows; y++)   { -     for (x=0; x < stereo_image->columns; x++)      { %       if (left_image->runlength != 0)           left_image->runlength--;
       else	         {            p++;*           left_image->runlength=p->length;	         } &       if (right_image->runlength != 0)!         right_image->runlength--; 
       else	         {            q++;+           right_image->runlength=q->length; 	         }i-       r->red=(unsigned int) (p->red*12) >> 4;a       r->green=0;]       r->blue=q->blue;       r->index=0;l       r->length=0;
       r++;     } :     ProgressMonitor(StereoImageText,y,stereo_image->rows);   }%   return(stereo_image);% }% % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     S w i r l I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%H %  Function SwirlImage creates a new image that is a copy of an existingN %  one with the image pixels "swirled" at a specified angle.  It allocates theL %  memory necessary for the new Image structure and returns a pointer to the
 %  new image.i %a+ %  The format of the SwirlImage routine is:e %t. %      swirled_image=SwirlImage(image,degrees) % + %  A description of each parameter follows:l %(H %    o swirled_image: Function SwirlImage returns a pointer to the imageJ %      after it is swirled.  A null image is returned if there is a memory %      shortage. % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.e %hL %    o degrees:  An double value that defines the tightness of the swirling. %a %r */  B static RunlengthPacket Interpolate(Image *image,double x,double y) {e   register RunlengthPacket     *p,      *q,      *r,      *s;n     RunlengthPacketo
     pixel;  1   p=image->pixels+image->columns*(int) y+(int) x;e   q=p+1;+   if (q > (image->pixels+image->packets-1))      q=p;   r=p+image->columns; +   if (r > (image->pixels+image->packets-1))      r=p;   s=q+image->columns; +   if (s > (image->pixels+image->packets-1));     s=q;   x=fmod(x,1.0);   y=fmod(y,1.0);   pixel.red=(Quantum)(D     ((1.0-y)*((1.0-x)*p->red+x*q->red)+y*((1.0-x)*r->red+x*s->red));   pixel.green=(Quantum)UL     ((1.0-y)*((1.0-x)*p->green+x*q->green)+y*((1.0-x)*r->green+x*s->green));   pixel.blue=(Quantum)H     ((1.0-y)*((1.0-x)*p->blue+x*q->blue)+y*((1.0-x)*r->blue+x*s->blue));   pixel.index=(unsigned short)L     ((1.0-y)*((1.0-x)*p->index+x*q->index)+y*((1.0-x)*r->index+x*s->index));   pixel.length=p->length;    return(pixel); }   . Image *SwirlImage(Image *image,double degrees) {r/ #define SwirlImageText  "  Swirling image...  "a     double     cosine, 
     distance,a     factor,      radius,l	     sine, 
     x_center,      x_distance,d     x_scale,
     y_center,v     y_distance,;     y_scale;     Imager     *swirled_image;g     register RunlengthPacket     *p,a     *q;r     register unsigned int      x;     unsigned int     y;     if (!UncompressImage(image))     return((Image *) NULL);.   /*(     Initialize swirled image attributes.   */B   swirled_image=CopyImage(image,image->columns,image->rows,False);&   if (swirled_image == (Image *) NULL)     { D       Warning("Unable to enhance image","Memory allocation failed");       return((Image *) NULL);      } #   swirled_image->class=DirectClass;l   /*     Compute scaling factor.e   */   x_scale=1.0;   y_scale=1.0;'   x_center=(double) image->columns/2.0; $   y_center=(double) image->rows/2.0;   radius=x_center;#   if (image->columns > image->rows)t'     y_scale=image->columns/image->rows;\   else%     if (image->columns < image->rows)'       { +         x_scale=image->rows/image->columns;f         radius=y_center;       }+$   degrees=DegreesToRadians(degrees);   /*     Swirl each row.    */   p=image->pixels;   q=swirled_image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        /*4         Determine if the pixel is within an ellipse.       *//       x_distance=x_scale*((double) x-x_center); /       y_distance=y_scale*((double) y-y_center); C       distance=AbsoluteValue(x_distance)+AbsoluteValue(y_distance);        if (distance >= radius)u         *q=(*p);
       else	         {l           /*             Swirl the pixel.           */%           factor=1.0-distance/radius;s           factor*=factor; #           sine=sin(degrees*factor); %           cosine=cos(degrees*factor);            *q=Interpolate(image,qA             (cosine*x_distance-sine*y_distance)/x_scale+x_center, B             (sine*x_distance+cosine*y_distance)/y_scale+y_center);	         }"
       p++;
       q++;     } 2     ProgressMonitor(SwirlImageText,y,image->rows);   };   return(swirled_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %,O %                                                                             %oO %                                                                             %%O %   S y n c I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function SyncImage initializes the red, green, and blue intensities of each* %  pixel as defined by the colormap index. % * %  The format of the SyncImage routine is: %  %      SyncImage(image)b %%+ %  A description of each parameter follows:% %%7 %    o image: The address of a structure of type Image.e %e %s */ void SyncImage(Image *image) {g   register int     i;     register RunlengthPacket     *p;s     register unsigned shortr
     index;  "   if (image->class == DirectClass)     return;m#   for (i=0; i < image->colors; i++)t   {a     image->colormap[i].index=0;e     image->colormap[i].flags=0;o   }    p=image->pixels;$   for (i=0; i < image->packets; i++)   {s     index=p->index;r&     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p++;   }  }o g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %iO %     T e x t u r e I m a g e                                                 % O %                                                                             %;O %                                                                             %iO %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function TextureImage layers a texture onto the background of an image. %n- %  The format of the TextureImage routine is:c %s# %      TextureImage(image,filename)z % + %  A description of each parameter follows:m %-F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %rK %    o filename: This file contains the texture to layer on the background.! %) %  */. void TextureImage(Image *image,char *filename) { 8 #define TextureImageText  "  Appling image texture...  "     Image      *texture_image;n     ImageInfo+     texture_info;i     intu     x,     y;      if (filename == (char *) NULL)     return;m   /*     Read the texture image.f   */   GetImageInfo(&texture_info);0   (void) strcpy(texture_info.filename,filename);)   texture_image=ReadImage(&texture_info);r&   if (texture_image == (Image *) NULL)     return;g   /*+     Tile texture onto the image background.)   */4   for (y=0; y < image->rows; y+=texture_image->rows)   { <     for (x=0; x < image->columns; x+=texture_image->columns)A       CompositeImage(image,ReplaceCompositeOp,texture_image,x,y);i4     ProgressMonitor(TextureImageText,y,image->rows);   }u   DestroyImage(texture_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %-O %                                                                             % O %                                                                             % O %   T r a n s f o r m I m a g e                                               %pO %                                                                             %)O %                                                                             %lO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %-L %  Function TransformImage creates a new image that is a transformed size ofE %  of existing one as specified by the crop and image geometries.  It K %  allocates the memory necessary for the new Image structure and returns a2 %  pointer to the new image. % H %  If a crop geometry is specified a subregion of the image is obtained.M %  If the specified image size, as defined by the image and scale geometries,)K %  is smaller than the actual image size, the image is first minified to an=N %  integral of the specified image size with an antialias digital filter.  TheD %  image is then scaled to the exact specified image size with pixelM %  replication.  If the specified image size is greater than the actual imageeJ %  size, the image is first enlarged to an integral of the specified imageK %  size with bilinear interpolation.  The image is then scaled to the exactn/ %  specified image size with pixel replication.s %i/ %  The format of the TransformImage routine is:a %f9 %      TransformImage(image,crop_geometry,image_geometry)s % + %  A description of each parameter follows:* %nJ %    o image: The address of an address of a structure of type Image.  The7 %      transformed image is returned as this parameter.e % D %    o crop_geometry: Specifies a pointer to a crop geometry string.6 %      This geometry defines a subregion of the image. % F %    o image_geometry: Specifies a pointer to a image geometry string.K %      The specified width and height of this geometry string are absolute.  %  %  */K void TransformImage(Image **image,char *crop_geometry,char *image_geometry)  {    Image      *transformed_image;      intg
     flags;     unsigned int     height,      sharpen,
     width;     transformed_image=(*image); %   if (crop_geometry != (char *) NULL)      {        Image          *cropped_image;          RectangleInfo          crop_info;         /*,         Crop image to a user specified size.       */       crop_info.x=0;       crop_info.y=0;       flags=O         XParseGeometry(crop_geometry,&crop_info.x,&crop_info.y,&width,&height);a$       if ((flags & WidthValue) == 0)L         width=(unsigned int) ((int) transformed_image->columns-crop_info.x);%       if ((flags & HeightValue) == 0)mJ         height=(unsigned int) ((int) transformed_image->rows-crop_info.y);#       if ((flags & XNegative) != 0)e6         crop_info.x+=transformed_image->columns-width;#       if ((flags & YNegative) != 0) 4         crop_info.y+=transformed_image->rows-height;5       if (strchr(crop_geometry,'%') != (char *) NULL)e	         {            /*4             Crop geometry is relative to image size.           */;           ParseImageGeometry(crop_geometry,&width,&height);l1           if (width > transformed_image->columns) -             width=transformed_image->columns;a/           if (height > transformed_image->rows) +             height=transformed_image->rows; !           crop_info.x=width >> 1;("           crop_info.y=height >> 1;1           width=transformed_image->columns-width;n0           height=transformed_image->rows-height;	         }r       crop_info.width=width;       crop_info.height=height;*       if ((width == 0) || (height == 0) ||=           ((flags & XValue) != 0) || ((flags & YValue) != 0))e>         cropped_image=CropImage(transformed_image,&crop_info);
       else	         {h           Image+             *next_image;             register int             x,             y;             /*8             Crop repeatedly to create uniform subimages.           */$           next_image=(Image *) NULL;'           cropped_image=(Image *) NULL;n;           for (y=0; y < transformed_image->rows; y+=height),           { ?             for (x=0; x < transformed_image->columns; x+=width) 
             { $               crop_info.width=width;&               crop_info.height=height;               crop_info.x=x;               crop_info.y=y;A               next_image=CropImage(transformed_image,&crop_info); /               if (next_image == (Image *) NULL)o                 break;2               if (cropped_image == (Image *) NULL)                 { +                   cropped_image=next_image;n                   continue;b                 }k-               cropped_image->next=next_image;a1               next_image->previous=cropped_image;d0               cropped_image=cropped_image->next;
             }c-             if (next_image == (Image *) NULL)e               break;           }i	         }e*       if (cropped_image != (Image *) NULL)	         {c*           DestroyImage(transformed_image);;           while (cropped_image->previous != (Image *) NULL)i2             cropped_image=cropped_image->previous;*           transformed_image=cropped_image;	         }4     }-   /*)     Scale image to a user specified size.n   */#   width=transformed_image->columns; !   height=transformed_image->rows;g4   ParseImageGeometry(image_geometry,&width,&height);P   sharpen=(width*height) < (transformed_image->rows*transformed_image->columns);.   if ((transformed_image->columns != width) ||*       (transformed_image->rows != height))     {        Imagec         *zoomed_image;         /*         Zoom image.        */L       zoomed_image=ZoomImage(transformed_image,width,height,MitchellFilter);)       if (zoomed_image == (Image *) NULL) @         zoomed_image=ScaleImage(transformed_image,width,height);)       if (zoomed_image != (Image *) NULL)e	         { *           DestroyImage(transformed_image);)           transformed_image=zoomed_image; 	         }i     }g   if (sharpen)L     if ((transformed_image->columns >= 3) && (transformed_image->rows >= 3))       {=
         Image*           *sharpened_image;n  
         /*           Sharpen image.
         */F         sharpened_image=SharpenImage(transformed_image,SharpenFactor);.         if (sharpened_image != (Image *) NULL)           {c,             DestroyImage(transformed_image);.             transformed_image=sharpened_image;           }c       }+   *image=transformed_image;r }e h /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %-O %     T r a n s f o r m R G B I m a g e                                       %hO %                                                                             %hO %                                                                             %uO %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%8 %1L %  Function TransformRGBImage converts the reference image from an alternateK %  colorspace.  The transformation matrices are not the standard ones:  the L %  weights are rescaled to normalized the range of the transformed values to %  be [0..MaxRGB]. %n2 %  The format of the TransformRGBImage routine is: %n* %      TransformRGBImage(image,colorspace) % + %  A description of each parameter follows:f %)F %    o image: The address of a structure of type Image;  returned from %      ReadImage.+ % J %    o colorspace: An unsigned integer value that indicates the colorspaceD %      the image is currently in.  On return the image is in the RGB %      color space.( %d %  */< void TransformRGBImage(Image *image,unsigned int colorspace) {d #define B (MaxRGB+1)*2 #define G (MaxRGB+1) #define R 0 A #define TransformRGBImageText  "  Transforming image colors...  "e     static QuantumJ     PCDMap[348] =  /* Photo CD information beyond 100% white, Gamma 2.2 */     {>K         0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  11,  12,  13,  14, K        15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28, K        29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,(K        43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  55, K        56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  66,  67,  68, K        69,  70,  71,  72,  73,  74,  75,  76,  76,  77,  78,  79,  80,  81,mK        82,  83,  84,  84,  85,  86,  87,  88,  89,  90,  91,  92,  92,  93,nK        94,  95,  96,  97,  98,  99,  99, 100, 101, 102, 103, 104, 105, 106,-K       106, 107, 108, 109, 110, 111, 112, 113, 114, 114, 115, 116, 117, 118, K       119, 120, 121, 122, 122, 123, 124, 125, 126, 127, 128, 129, 129, 130,gK       131, 132, 133, 134, 135, 136, 136, 137, 138, 139, 140, 141, 142, 142,rK       143, 144, 145, 146, 147, 148, 148, 149, 150, 151, 152, 153, 153, 154,eK       155, 156, 157, 158, 158, 159, 160, 161, 162, 163, 164, 165, 165, 166,%K       167, 168, 169, 170, 171, 172, 173, 173, 174, 175, 176, 177, 178, 178, K       179, 180, 181, 182, 182, 183, 184, 185, 186, 186, 187, 188, 189, 190, K       191, 192, 193, 194, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, K       204, 205, 205, 206, 207, 208, 209, 210, 210, 211, 212, 213, 214, 215, K       216, 216, 217, 218, 219, 220, 221, 221, 222, 223, 224, 225, 225, 226, K       227, 228, 228, 229, 230, 230, 231, 232, 233, 233, 234, 235, 235, 236, K       237, 237, 238, 239, 239, 240, 241, 241, 242, 242, 243, 243, 244, 244, K       245, 245, 245, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249,%K       250, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252,sK       253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254,tK       254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,p@       254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255     };     long
     *blue,     *green, 	     *red;I  	   Quantum      *range_table;a     register int     i,     x,     y,     z;     register Quantum     *range_limit;      register RunlengthPacket     *p;   H   if ((colorspace == RGBColorspace) || (colorspace == GRAYColorspace) ||,       (colorspace == TransparentColorspace))     return;t   /*     Allocate the tables.   */1   red=(long *) malloc(3*(MaxRGB+1)*sizeof(long));t3   green=(long *) malloc(3*(MaxRGB+1)*sizeof(long));l2   blue=(long *) malloc(3*(MaxRGB+1)*sizeof(long));?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum));s;   if ((red == (long *) NULL) || (green == (long *) NULL) ||1C       (blue == (long *) NULL) || (range_table == (Quantum *) NULL))0     { L       Warning("Unable to transform color space","Memory allocation failed");
       return;.     }    /*     Initialize tables.   */   for (i=0; i <= MaxRGB; i++)    {u     range_table[i]=0; *     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;o   }g%   range_limit=range_table+(MaxRGB+1);d   switch (colorspace),   {*     case OHTAColorspace:     {m       /*         Initialize OHTA tables:b  &           R = I1+1.00000*I2-0.66668*I3&           G = I1+0.00000*I2+1.33333*I3&           B = I1-1.00000*I2-0.66668*I3  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)(       {"&         red[i+R]=UpShifted(1.00000)*i;;         green[i+R]=UpShifted(1.0000*0.5)*((i << 1)-MaxRGB); >         blue[i+R]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);&         red[i+G]=UpShifted(1.00000)*i;         green[i+G]=0;p;         blue[i+G]=UpShifted(1.33333*0.5)*((i << 1)-MaxRGB); &         red[i+B]=UpShifted(1.00000)*i;?         green[i+B]=(-UpShifted(1.00000*0.5))*((i << 1)-MaxRGB);;>         blue[i+B]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);       }i       break;     },     case XYZColorspace:      {        /*"         Initialize CIE XYZ tables:  /           R =  3.240479*R-1.537150*G-0.498535*Bd/           G = -0.969256*R+1.875992*G+0.041556*Bg/           B =  0.055648*R-0.204043*G+1.057311*Br       */!       for (i=0; i <= MaxRGB; i++)        {>'         red[i+R]=UpShifted(3.240479)*i;,,         green[i+R]=(-UpShifted(1.537150))*i;+         blue[i+R]=(-UpShifted(0.498535))*i; *         red[i+G]=(-UpShifted(0.969256))*i;)         green[i+G]=UpShifted(1.875992)*i;%(         blue[i+G]=UpShifted(0.041556)*i;'         red[i+B]=UpShifted(0.055648)*i; ,         green[i+B]=(-UpShifted(0.204043))*i;(         blue[i+B]=UpShifted(1.057311)*i;       }        break;     }      case YCbCrColorspace:      {        /*          Initialize YCbCr tables:  '           R = Y            +1.370707*Cr '           G = Y-0.336453*Cb-0.698195*Cr            B = Y+1.732445*Cb   O         Cb and Cr, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.%       */!       for (i=0; i <= MaxRGB; i++)%       {%'         red[i+R]=UpShifted(1.000000)*i;a         green[i+R]=0;s<         blue[i+R]=UpShifted(1.370707*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i;g@         green[i+G]=(-UpShifted(0.336453*0.5))*((i << 1)-MaxRGB);?         blue[i+G]=(-UpShifted(0.698195*0.5))*((i << 1)-MaxRGB);i'         red[i+B]=UpShifted(1.000000)*i;I=         green[i+B]=UpShifted(1.732445*0.5)*((i << 1)-MaxRGB);g         blue[i+B]=0;       }        break;     }a     case YCCColorspace:      {:       /*         Initialize YCC tables:  '           R = Y            +1.340762*C2 '           G = Y-0.317038*C1-0.682243*C2u           B = Y+1.632639*C1r  B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */!       for (i=0; i <= MaxRGB; i++))       {n%         red[i+R]=UpShifted(1.3584)*i;o         green[i+R]=0;l5         blue[i+R]=UpShifted(1.8215)*(i-UpScale(137)); %         red[i+G]=UpShifted(1.3584)*i;tA         green[i+G]=(-(UpShifted(0.194*2.2179)*(i-UpScale(156))));r@         blue[i+G]=(-(UpShifted(0.509*1.8215)*(i-UpScale(137))));%         red[i+B]=UpShifted(1.3584)*i; 6         green[i+B]=UpShifted(2.2179)*(i-UpScale(156));         blue[i+B]=0;J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       }e$       for ( ; i < UpScale(348); i++)J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       break;     }X     case YIQColorspace:o     {l       /*         Initialize YIQ tables:  +           R = 0.97087*Y+1.17782*I+0.59800*Qn+           G = 0.97087*Y-0.28626*I-0.72851*Q;+           B = 0.97087*Y-1.27870*I+1.72801*Qo  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0g         through MaxRGB.=       */!       for (i=0; i <= MaxRGB; i++)        {d&         red[i+R]=UpShifted(0.97087)*i;<         green[i+R]=UpShifted(1.17782*0.5)*((i << 1)-MaxRGB);;         blue[i+R]=UpShifted(0.59800*0.5)*((i << 1)-MaxRGB);(&         red[i+G]=UpShifted(0.97087)*i;?         green[i+G]=(-UpShifted(0.28626*0.5))*((i << 1)-MaxRGB);->         blue[i+G]=(-UpShifted(0.72851*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(0.97087)*i;?         green[i+B]=(-UpShifted(1.27870*0.5))*((i << 1)-MaxRGB); ;         blue[i+B]=UpShifted(1.72801*0.5)*((i << 1)-MaxRGB);g       }f       break;     }(     case YPbPrColorspace:N     {        /*          Initialize YPbPr tables:  '           R = Y            +1.402000*C2 '           G = Y-0.344136*C1+0.714136*C2            B = Y+1.772000*C1)  O         Pb and Pr, normally -0.5 through 0.5, must be normalized to the range 0f         through MaxRGB.;       */!       for (i=0; i <= MaxRGB; i++)        {o'         red[i+R]=UpShifted(1.000000)*i;r         green[i+R]=0; <         blue[i+R]=UpShifted(1.402000*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i; @         green[i+G]=(-UpShifted(0.344136*0.5))*((i << 1)-MaxRGB);<         blue[i+G]=UpShifted(0.714136*0.5)*((i << 1)-MaxRGB);'         red[i+B]=UpShifted(1.000000)*i;e=         green[i+B]=UpShifted(1.772000*0.5)*((i << 1)-MaxRGB);e         blue[i+B]=0;       }        break;     }o     case YUVColorspace:      default:     {l       /*         Initialize YUV tables:  #           R = Y          +1.13980*Vn#           G = Y-0.39380*U-0.58050*Vd           B = Y+2.02790*U   M         U and V, normally -0.5 through 0.5, must be normalized to the range 0n         through MaxRGB.r       */!       for (i=0; i <= MaxRGB; i++)l       {e&         red[i+R]=UpShifted(1.00000)*i;         green[i+R]=0;(;         blue[i+R]=UpShifted(1.13980*0.5)*((i << 1)-MaxRGB);g&         red[i+G]=UpShifted(1.00000)*i;?         green[i+G]=(-UpShifted(0.39380*0.5))*((i << 1)-MaxRGB); >         blue[i+G]=(-UpShifted(0.58050*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(1.00000)*i;<         green[i+B]=UpShifted(2.02790*0.5)*((i << 1)-MaxRGB);         blue[i+B]=0;       }i       break;     }    }n   /*     Convert to RGB.n   */   switch (image->class)0   {      case DirectClass:      {p       /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {f         x=p->red;0         y=p->green;b         z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];oG         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];pF         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;!         if (QuantumTick(i,image)) B           ProgressMonitor(TransformRGBImageText,i,image->packets);       }p       break;     }      case PseudoClass:a     {        /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)f       {o!         x=image->colormap[i].red; #         y=image->colormap[i].green; "         z=image->colormap[i].blue;         image->colormap[i].red=o@           range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];!         image->colormap[i].green= @           range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];          image->colormap[i].blue=@           range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       {          x=p->red;s         y=p->green;          z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])]; G         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];pF         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;       }        break;     }    }    /*     Free allocated memory.   */   free((char *) range_table);e   free((char *) blue);   free((char *) green);c   free((char *) red);m }) e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             %rO %                                                                             %eO %     T r a n s p a r e n t I m a g e                                         % O %                                                                             % O %                                                                             %*O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %"F %  Function TransparentImage creates a matte image associated with theF %  image.  All pixel locations are initially set to opaque.  Any pixel; %  that matches the specified color are set to transparent.  %r1 %  The format of the TransparentImage routine is:  % $ %      TransparentImage(image,color) % + %  A description of each parameter follows:a %rF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %gB %    o color: A character string that contain an X11 color string. %d %m *// void TransparentImage(Image *image,char *color)g {) #define DeltaX  16M #define TransparentImageText  "  Setting transparent color in the image...  "      register int     i;  	   Quantum 	     blue,(
     green,     red;     register RunlengthPacket     *p;      unsigned int     status;*     XColor     target_color;      /*2     Determine RGB values of the transparent color.   */2   status=XQueryColorDatabase(color,&target_color);   if (status == False)     return; #   red=XDownScale(target_color.red); '   green=XDownScale(target_color.green); %   blue=XDownScale(target_color.blue);    /*!     Make image color transparent.n   */   if (!image->matte)     {        /*)         Initialize image matte to opaque.h       */       image->class=DirectClass;a       image->matte=True;       p=image->pixels;(       for (i=0; i < image->packets; i++)       {_         p->index=Opaque;         p++;       }      }f   p=image->pixels;$   for (i=0; i < image->packets; i++)   {i.     if (((int) p->red < (int) (red+DeltaX)) &&.         ((int) p->red > (int) (red-DeltaX)) &&2         ((int) p->green < (int) (green+DeltaX)) &&2         ((int) p->green > (int) (green-DeltaX)) &&0         ((int) p->blue < (int) (blue+DeltaX)) &&.         ((int) p->blue > (int) (blue-DeltaX)))       p->index=Transparent;a     p++;     if (QuantumTick(i,image))i=       ProgressMonitor(TransparentImageText,i,image->packets);n   }- }p p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             %oO %                                                                             %nO %   U n C o m p r e s s I m a g e                                             %aO %                                                                             %pO %                                                                             %IO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%h %;L %  Function UncompressImage uncompresses runlength-encoded pixels packets to! %  a rectangular array of pixels.. %t0 %  The format of the UncompressImage routine is: %l$ %      status=UncompressImage(image) %r+ %  A description of each parameter follows:) % D %    o status: Function UncompressImage returns True if the image is$ %      uncompressed otherwise False. % 7 %    o image: The address of a structure of type Image.r %_ %o */* unsigned int UncompressImage(Image *image) {f   register int     i,     j,     length;-     register RunlengthPacket     *p,      *q;_     RunlengthPacket>     *uncompressed_pixels;1  5   if (image->packets == (image->columns*image->rows))      return(True);t   /*)     Uncompress runlength-encoded packets.    */I   uncompressed_pixels=(RunlengthPacket *) realloc((char *) image->pixels,c8     image->columns*image->rows*sizeof(RunlengthPacket));6   if (uncompressed_pixels == (RunlengthPacket *) NULL)     return(False);$   image->pixels=uncompressed_pixels;#   p=image->pixels+image->packets-1;M5   q=uncompressed_pixels+image->columns*image->rows-1;o$   for (i=0; i < image->packets; i++)   {o     length=p->length;a     for (j=0; j <= length; j++)_     {r       *q=(*p);       q->length=0;
       q--;     }w     p--;   }B,   image->packets=image->columns*image->rows;   return(True);  }) a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             %eO %                                                                             %iO %                                                                             %-O %   Z o o m I m a g e                                                         % O %                                                                             % O %                                                                             %yO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %=E %  Function ZoomImage creates a new image that is a scaled size of anaE %  existing one.  It allocates the memory necessary for the new ImageoL %  structure and returns a pointer to the new image.  The Point filter givesM %  fast pixel replication, Triangle is equivalent to bi-linear interpolation,p7 %  and Mitchel giver slower, very high-quality results.t %a* %  The format of the ZoomImage routine is: % 8 %      zoomed_image=ZoomImage(image,columns,rows,filter) % + %  A description of each parameter follows:* %gL %    o zoomed_image: Function ZoomImage returns a pointer to the image afterH %      scaling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.n % M %    o columns: An integer that specifies the number of columns in the zoomedC
 %      image.  %gG %    o rows: An integer that specifies the number of rows in the scaledl
 %      image./ % G %    o filter: This unsigned integer is the filter type to used to zoom_ %      the image.e %r %_ */   static double Box(double x)r {=   if ((x > -0.5) && (x <= 0.5))      return(1.0);   return(0.0); }a    static double Mitchell(double x) {    double     b,     c;     b=1.0/3.0;   c=1.0/3.0;   if (x < 0)     x=(-x);m   if (x < 1.0)     { N       x=(((12.0-9.0*b-6.0*c)*(x*x*x))+((-18.0+12.0*b+6.0*c)*x*x)+(6.0-2.0*b))/         6.0;       return(x);     } 
  if (x < 2.0)     {K      x=(((-1.0*b-6.0*c)*(x*x*x))+((6.0*b+30.0*c)*x*x)+((-12.0*b-48.0*c)*x)+         (8.0*b+24.0*c))/6.0;*      return(x);e    }   return(0.0); }     static double Triangle(double x) {g   if (x < 0.0)     x=(-x);    if (x < 1.0)     return(1.0-x);   return(0.0); }a  E Image *ZoomImage(Image *image,unsigned int columns,unsigned int rows,t   unsigned int filter) {t- #define ZoomImageText  "  Zooming image...  "   "   typedef struct _ContributionInfo   {t     int        pixel;       long
       weight;3   } ContributionInfo;      ContributionInfo     *contribution_info;p     double     center,      filter_width,t     scale_factor,n
     width,
     x_factor, 
     y_factor;e     ImageG     *source_image,     *zoomed_image;     int      n,     y;     long     blue_weight,     green_weight,g     index_weight,t     red_weight,      weight;   	   Quantum      *range_table;      register int     i,     j,     x;     register Quantum     *range_limit;)     register RunlengthPacket     *p,o     *q;m  $   if ((columns == 0) || (rows == 0))     { B       Warning("Unable to zoom image","image dimensions are zero");       return((Image *) NULL);n     }i   /*     Image must be uncompressed.    */   if (!UncompressImage(image))     return((Image *) NULL);    /*'     Initialize zoomed image attributes.    */3   zoomed_image=CopyImage(image,columns,rows,False);n%   if (zoomed_image == (Image *) NULL)a     {gA       Warning("Unable to zoom image","Memory allocation failed");        return((Image *) NULL);,     }4"   zoomed_image->class=DirectClass;H   source_image=CopyImage(image,zoomed_image->columns,image->rows,False);%   if (source_image == (Image *) NULL)o     {eA       Warning("Unable to zoom image","Memory allocation failed");m!       DestroyImage(zoomed_image);)       return((Image *) NULL);a     }g   /*     Allocate the range table.    */?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum)); &   if (range_table == (Quantum *) NULL)     { A       Warning("Unable to zoom image","Memory allocation failed"); !       DestroyImage(source_image); !       DestroyImage(zoomed_image);        return((Image *) NULL);      }    /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)a   {m     range_table[i]=0;d*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;    } %   range_limit=range_table+(MaxRGB+1);    /*     Allocate filter info list.   */   switch (filter)n   {      case BoxFilter:n     {a       FilterFunction=Box;        filter_width=0.5;        break;     }      case TriangleFilter:     {        FilterFunction=Triangle;       filter_width=1.0;p       break;     }e     case MitchellFilter:     default:     {>       FilterFunction=Mitchell;       filter_width=2.0;a       break;     }&   },B   x_factor=(double) zoomed_image->columns/(double) image->columns;<   y_factor=(double) zoomed_image->rows/(double) image->rows;9   width=Max(filter_width/x_factor,filter_width/y_factor);l   if (width < filter_width)      width=filter_width; (   contribution_info=(ContributionInfo *)7     malloc((int) (width*2+1)*sizeof(ContributionInfo)); 5   if (contribution_info == (ContributionInfo *) NULL)i     { A       Warning("Unable to zoom image","Memory allocation failed");-!       free((char *) range_table); !       DestroyImage(source_image);c!       DestroyImage(zoomed_image);        return((Image *) NULL);r     }t   /*;     Apply filter to zoom horizontally from image to source.    */   width=filter_width;d   scale_factor=1.0;*   if (x_factor < 1.0)i     {        width/=x_factor;       scale_factor/=x_factor;h     }_+   for (x=0; x < source_image->columns; x++)f   {r     n=0;%     center=(double) (x+0.5)/x_factor; G     for (i=(int) (center-width+0.5); i < (int) (center+width+0.5); i++)      { 
       j=i;       if (j < 0)         j=(-j);(
       else          if (j >= image->columns)&           j=(image->columns << 1)-j-1;#       contribution_info[n].pixel=j;e"       contribution_info[n].weight=O         UpShifted((*FilterFunction)((i-center+0.5)/scale_factor)/scale_factor);v
       n++;     }i     q=source_image->pixels+x; *     for (y=0; y < source_image->rows; y++)     {s       red_weight=0;u       green_weight=0;l       blue_weight=0;       index_weight=0;g       for (i=0; i < n; i++)        {e+         weight=contribution_info[i].weight;gF         p=image->pixels+(y*image->columns)+contribution_info[i].pixel;"         red_weight+=weight*p->red;&         green_weight+=weight*p->green;$         blue_weight+=weight*p->blue;&         index_weight+=weight*p->index;       }_0       q->red=range_limit[DownShift(red_weight)];4       q->green=range_limit[DownShift(green_weight)];2       q->blue=range_limit[DownShift(blue_weight)];4       q->index=range_limit[DownShift(index_weight)];       q->length=0;       q+=source_image->columns;r     }gN     ProgressMonitor(ZoomImageText,x,source_image->columns+zoomed_image->rows);   }    /*?     Apply filter to zoom vertically from source to destination.    */   width=filter_width;    scale_factor=1.0;r   if (y_factor < 1.0)      {e       width/=y_factor;       scale_factor/=y_factor;e     },   q=zoomed_image->pixels;r(   for (y=0; y < zoomed_image->rows; y++)   {      n=0;%     center=(double) (y+0.5)/y_factor;eG     for (i=(int) (center-width+0.5); i < (int) (center+width+0.5); i++)n     {p
       j=i;       if (j < 0)         j=(-j);n
       else#        if (j >= source_image->rows) )          j=(source_image->rows << 1)-j-1; #       contribution_info[n].pixel=j; "       contribution_info[n].weight=O         UpShifted((*FilterFunction)((i-center+0.5)/scale_factor)/scale_factor);U
       n++;     } -     for (x=0; x < zoomed_image->columns; x++)      {s       red_weight=0;        green_weight=0;        blue_weight=0;       index_weight=0;p       for (i=0; i < n; i++)        {p+         weight=contribution_info[i].weight;n         p=source_image->pixels+-?           (contribution_info[i].pixel*source_image->columns)+x;v"         red_weight+=weight*p->red;&         green_weight+=weight*p->green;$         blue_weight+=weight*p->blue;&         index_weight+=weight*p->index;       }(0       q->red=range_limit[DownShift(red_weight)];4       q->green=range_limit[DownShift(green_weight)];2       q->blue=range_limit[DownShift(blue_weight)];4       q->index=range_limit[DownShift(index_weight)];       q->length=0;
       q++;     }nM     ProgressMonitor(ZoomImageText,y+x,zoomed_image->rows+zoomed_image->rows);n   }(   /*     Free allocated memory.   */#   free((char *) contribution_info);g   free((char *) range_table);    DestroyImage(source_image);g   return(zoomed_image);% }%