$!
$! This procedure links the TSERVER_TCPSHR.EXE from the object files.
$!
$! Parameters:
$!	P1		Keyword for TCP package to use: 
$!				UCXTCP, CMUTCP, TWGTCP, MULTINET, TCPWARE, SSL
$!	P2		Option additional link flags (e.g. /TRACE).
$!
$! Author:	David Jones
$! Date:	21-OCT-1994
$! Revised:	19-APR-1995	add entry for ts_set_local_addr
$! Recised:	17-OCT-1995	Add psect defs for vaxc.
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! First validate P1.
$ say = "WRITE SYS$OUTPUT"
$ tcp_list = "/UCXTCP/CMUTCP/TWGTCP/MULTINET/TCPWARE/SSL/"
$ if f$locate("/''P1'/",TCP_LIST) .GE. f$length(tcp_list)
$ then
$    say "Invalid P1 (tcp type), valid values: ",-
	"UCXTCP MULTINET CMUTCP TWGTCP TCPWARE SSL"
$    exit
$ endif
$ create TMP_LINK.OPT
$ open/append lopt TMP_LINK.OPT
$ on error then goto cleanup
$ on control_y then goto cleanup
$!
$! Determine our configuration.
$!
$ is_axp = (f$getsyi("CPU") .ge. 128)
$ is_vaxc = (.not.is_axp .and. (f$trnlnm("DECC$CC_DEFAULT") .nes. "/DECC"))
$ is_vmsv5 = ("V5." .eqs. f$extract(0,3,f$getsyi("VERSION")))
$ write lopt "!This file generated by LINK_TCPSHARE.COM, AXP flag: ", is_axp, -
	", VAXC flag: ", is_vaxc, ", TCP: ", P1
$!
$! Start with base files.
$!
$ if P1 .nes. "SSL" then write lopt "tserver_tcp.obj,tutil.obj"
$ if P1 .eqs. "SSL" 
$ then 
$   write lopt "tserver_ssl.obj,tutil.obj"
$ endif
$ if is_axp
$ then
$!	Make symbol vector
$    write lopt "SYMBOL_VECTOR=(ts_declare_tcp_port=PROCEDURE,-"
$    write lopt "  ts_tcp_write=PROCEDURE,ts_tcp_read=PROCEDURE,-"
$    write lopt "  ts_tcp_close=PROCEDURE,ts_tcp_stack_used=PROCEDURE,-"
$    write lopt "  ts_tcp_remote_host=PROCEDURE,ts_tcp_info=PROCEDURE,-"
$    write lopt "  ts_set_manage_port=PROCEDURE, ts_set_logging=PROCEDURE,-"
$    write lopt "  ts_set_local_addr=PROCEDURE,-"
$    write lopt "  ts_tcp_set_time_limit=PROCEDURE,-"
$    write lopt "  ts_tcp_transaction_count=PROCEDURE,-"
$    write lopt "  ts_tcp_end_transaction=PROCEDURE)"
$ else
$!	Use macro transfer vector.
$     gosub make_transvec
$    write lopt "transvec.obj"
$    write lopt "CLUSTER=FIRST,,,"		! make vect first in image
$    write lopt "COLLECT=FIRST,$$XVEC
$    if is_vmsv5 then write lopt "UNSUPPORTED=1" ! force demand zero compression
$    if is_vmsv5 then write lopt "DZRO_MIN=32"
$ endif
$ write lopt "GSMATCH=LEQUAL,2,1"	! 2.x interface
$!
$! Add Pthreads libraries.
$ write lopt "sys$share:cma$lib_shr/share,cma$rtl/share
$ if is_axp then write lopt "sys$share:cma$open_lib_shr/share,cma$open_rtl/share
$!
$! Add any speical lines needed for TCP package.(None needed for UCX or CMU)
$!
$ if P1 .eqs. "MULTINET" then write lopt -
"multinet_root:[multinet]multinet_socket_library/share"
$ if P1 .eqs. "TWGTCP" then write lopt "twg$tcp:[netdist.lib]twglib/lib"
$ if P1 .eqs. "TCPWARE" then write lopt "tcpip_socklib/share"
$!
$! Add special stuff for VAXC
$!
$ if is_vaxc then write lopt "sys$share:vaxcrtl/share"
$ if is_vaxc then write lopt "PSECT_ATTR=$CHAR_STRING_CONSTANTS,NOWRT"
$ if is_vaxc then write lopt "PSECT_ATTR=HTTP_REENTRANT_C_RTL,NOSHR"
$ if is_vaxc then write lopt "PSECT_ATTR=HTTP_REENTRANT_VMS_RTL,NOSHR"
$ if is_vaxc then write lopt "PSECT_ATTR=TSERVER_TCP_PORT_LIST,NOSHR"
$!
$ close lopt
$ on error then exit $status
$ purge tmp_link.opt
$!
$ link/share=tserver_tcpshr.exe 'P2' TMP_LINK.OPT/OPT
$ exit $status
$!
$ cleanup:
$ close lopt
$ exit
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ make_transvec:
$ macro/object=sys$disk:[]transvec.obj sys$input
; Threaded tcp server transfer vector.
;
; define macro to make transfer vector entry for a given routine.  Entry mask 
; is obtained from routine we are transfering to.  Jump to word past entry 
; since these are VAX procedures (written in FORTRAN).
;
	.MACRO TRANSFER_ENTRY routine
;
	.TRANSFER routine
	.MASK	  routine
	JMP	  routine + 2
;
	.ENDM TRANSFER_ENTRY
;
	.TITLE TSERVER_TCP_VECTOR
	.IDENT /02/
	.PSECT $$XVEC PIC,USR,CON,REL,LCL,SHR,EXE,RD,NOWRT,NOVEC
;
;	simply go through tserver procedures and declare transfer vector
;	entry points for them.  
;
ts_xfer:
	TRANSFER_ENTRY ts_declare_tcp_port
	TRANSFER_ENTRY ts_tcp_write
	TRANSFER_ENTRY ts_tcp_read
	TRANSFER_ENTRY ts_tcp_close
	TRANSFER_ENTRY ts_tcp_stack_used
	TRANSFER_ENTRY ts_tcp_remote_host
	TRANSFER_ENTRY ts_tcp_info
	TRANSFER_ENTRY ts_set_manage_port
	TRANSFER_ENTRY ts_set_logging
	TRANSFER_ENTRY ts_set_local_addr
	TRANSFER_ENTRY ts_tcp_set_time_limit
	TRANSFER_ENTRY ts_tcp_transaction_count
	TRANSFER_ENTRY ts_tcp_end_transaction
;
;	allocate extra space to allow for code modifications without changing 
;	the size of the shared image.
;
	.BLKB 512-<.-ts_xfer>		; reserve rest of page for future
;
	.END
$ RETURN
