 /*  *	*****************  *	*  L F N T . C  *  *	*****************  *6  * This program loads character patterns into the P/OS3  * terminal subsystem's character generator area in.3  * main memory.  It reads the pixel patterns from a.8  * standard ASCII file which contains the patterns in an7  * editable form (more on this later).  The replacement.8  * characters are loaded into the area normally occupied4  * by the "supplemental graphics" characters (a.k.a.  * "European" characters).  *;  * With release 2, this program also supports a binary font*9  * format for faster loading and smaller disk usage.  The ?  * format of the binary file is R.VAR with no carriage control.o9  * The 1st record is the font header, and each succeedingo?  * record is the data for a character.  Character data consists*?  * of 3 words of character header info, followed by 10 bytes ort:  * 10 words (132 or 80 col. format, respectively) of pixel  * row data.  *  * By:  *       Robert B. Denny  *       Alisa Systems, Inc.  *       Mezzanine Floor  *       234 E. Colorado Blvd.  *       Pasadena, CA   91101a  *	  * Edits:.  *B  * X1.1 06-Dec-83 RBD	Add 132-column support - new PXL file format:  * Y1.2 10-Dec-83 RBD	Add help text on startup per M. OtteD  * Y1.3 16-Dec-83 RBD	Fencepost error -- RH column not being loaded.(  *			Add help text for 132-column fonts.A  * Y1.4 20-Dec-83 RBD	Change font file locations to [ZZSYS].  Adde0  *			conditional code for DCS test version which1  *			will not support direct user interface, just /  *			spawning from CT*OS, and has no licensing..5  * Y1.5 22-Dec-83 TTC   Display loading font message.*C  * Y2.0 11-Jan-83 RBD	Major changes.  Use RMS, remove serial numberY/  *			checking, add binary font file capability, /  *			make silent version for CT*OS, spawn-only, -  *			requires password on command line.  Maker,  *			non-silent version use P/OS menu's etc.,  *			MUST be built using LFNTGEN now, as the1  *			PAB files are different, etc.  Automaticallyw.  *			loads both 80 and 132 column fonts if the-  *			font name doesn't contain those strings. 2  *			If one of the two don't exist, the non-SILENT3  *			one issues a warning.  The interactive versionm   *			keeps its files in [FONTS].J  * Y2.1 12-Jan-83 RBD   Removed CT*OS proprietary stuff prior to releasing9  *                      to M. Minow & friends at Digital.*  */n     /*  *			*************  *			** N O T E **  *			*************  *4  *	Use the LFNTGEN.CMD file to generate this program.  *	in either the interactive or quiet version.  */t #define DEBUGoff #define TESTINGoff   #include <rmstdio.h> #include <cx.h>t #include <rdbdf.h> #include <wdbdf.h> #include "lfcnd.h"   /*4  * The following definition establishes the location(  * on the P/OS system of the font files.  */  #ifdef INTERACTIVE #define FONT_LOC "LB:[FONTS]"i #elser #define FONT_LOC "LB:[ZZSYS]"* #endif  2 int $$narg = 1;			/* Supress the startup prompt */   /*;  * Data structures for PLAS access to the VDFNTS partition.h  *  * NOTE:?  *	Addresses within VDFNTS are APR4-relative, and the followingf9  *	code assumes that we map through APR4 as well.  If you.9  *	make this program too big, it'll bump into APR4's VA'sl;  *	and you'll have to make it even bigger, translating VA'ss"  *	to APR6-relative (or whatever).  */RF static struct rdb vrdb =	/* Define the VDFNTS partition as a region */    {    0, 0,    0105046, 055263,*
    026226, 0,a    RS_RED | RS_WRT,     0    };t  E static struct wdb vwdb = 	/* Set up an address window at 100000 VA */s4    { 0, 4, 0, 0, 0, 0, 0, WS_MAP|WS_64B|WS_WRT, 0 };   /*7  * Data structures which map the contents of the VDFNTSm7  * partition.  The actual structure is variable, driven*7  * by descriptive information also contained within thes1  * partition.  Hence the looseness of definition.s  */    /*7  * Partition header - points to index and map areas for 6  * each of the fonts resident in the partition.  There7  * are currently 3 separate fonts in VDFNTS.  The first*8  * contains the 80-column characters for ALL 3 CHARACTER<  * SETS (ASCII, Special Graphics and Supplemental Graphics).:  * The second font appears to contain the 132-column char-9  * acters for the same sets of characters.  I don't (yet)n9  * know what is in the third font (may belong to $GIDIS).t  *<  * The Indexing arrays contain bitmap indexes which identify9  * the character bitmaps for each of the 96 characters ind7  * each of the three character sets.  These are used to 4  * translate the character code into an address of a7  * character bitmap.  The bitmaps are packed end-to-end 7  * and can be viewed as an array of character cell mapsa:  * of whatever size.  The "index" is the index of the cell;  * array to use.  For example, if an octal 111 is received,e;  * then the 112th (octal) index is used to locate the char-a;  * acter cell.  If this index is 29, then the 29th cell mapt$  * is used to display the character.  *8  * The important thing to note is that the mapping index9  * correspond to the three 96-character "sets", and refera9  * to a single FONT.  Normally, the first font is in use,n7  * and the values in all three mapping indexes refer tot3  * cell maps in the first font.  When the system isa8  * switched to 132-column mode, the indexes all refer to!  * the second font ... Nuff said?u  */o struct fnt_hdr	{
 		word	xx;% 		word	n_fnts;		/* Number of fonts */h; 		address	bitmap[8];	/* APR-4 based VA's of font bitmaps */i/ 		word	n_indx;		/* Number of indexing arrays */ : 		address	index[8];	/* APR-4 based VA's of index arrays */ 		};  7 static int bin_fmt;			/* TRUE if font file is binary */d   #ifdef INTERACTIVE /*  * Menu data  */r, static int stat[8];				/* Used everywhere */ static char action[8]; static char *msg1 = "";  static char *msg2 = "";t  ( static char *clrseq = "\033[1;1H\033[J";< static char *wrgkey = "You pressed the wrong function key";* static char *unsup = "Not supported yet"; static char m1buf[80]; #endif   extern int $dsw; extern int $$ferr;     main(argc, argv)	 int argc;V
 char *argv[];r    {    register address pxlp;t    register char *cp;e&    word chcode, charset, idxval, i, j;    struct fnt_hdr *hdr;t(    word fntnum, nbpr, nbpc, nbits, bits;    char buf[64];    char filename[64]; 
    FILE *ffp;c    char *np;    word *wp;    byte *bp;    char *aflavor;     char *bflavor;     int pass;      /*n+     * Get the name of the font file to loads     */ #ifdef INTERACTIVE   #ifdef TESTING    /*e=     * The following 2 POSRES calls may be eliminated when thec:     * program is run via an application installation file.     */%    if(p$mfile("LFNT.MNU", stat) != 1)a(       my_err("Failed to open LFNT.MNU");/    if(p$hfile("LFNT.HLP", "LFMAIN", stat) != 1)4(       my_err("Failed to open LFNT.HLP"); #endif
    np = NULL;     while(np == NULL)       {l       display("LFMAIN");       switch(stat[0])n
          {          case 1:	/* DO key */aB             switch(stat[1])		/*** HACK -- use action string!! ***/                {                case 1:&                   np = "ASCII"; break;                case 2:'                   np = "SPCGRF"; break;                 case 3:'                   np = "SUPGRF"; break;f                case 4:'                   np = "GRKMTH"; break;p                case 5:&                   np = "USER1"; break;                case 6:&                   np = "USER2"; break;                case 7:&                   np = "USER3"; break;                case 8:&                   np = "USER4"; break;                default:                    msg1 = unsup;                 }             break;  %          case -14:	/* Function key */              switch(stat[1])p                {2                case 10:                 /* Exit */9                case 9:                  /* Main Screen */ 7                   printf("%s", clrseq); fflush(stdout); !                   p$hclose(stat); !                   p$mclose(stat);p                   exits(1);                   default:                     msg1 = wrgkey;                }             break;            default: #             my_error("MENU error"); 
          }       }i   #else )    if(argc < 3)				/* Bad command line */ &       exits(1);				/* Silently exit */    elseE6       np = argv[1];			/* OK, font name is first arg */ #endif   #ifdef DEBUG$    printf("Font name \"%s\"\n", np); #endif      /* *     * Map to the VDFNTS partition via APR4     */    if(atrg(&vrdb) != IS_SUC)1      my_err("Attach failed.  Status = %d", $dsw);     vwdb.w_nsiz = vrdb.r_gsiz;     vwdb.w_nrid = vrdb.r_gid;    if(craw(&vwdb) != IS_SUC).      my_err("Map failed.  Status = %d", $dsw);  >    hdr = (struct fnt_hdr *)vwdb.w_nbas;		/* Point to header */1    fntnum = -1;				/* Font header not yet seen */g   #ifdef DEBUG=    printf("VDFNTS partition mapped at %06o with size %06o\n",n       hdr, vwdb.w_nsiz * 64); 8    printf("There are %d fonts at %06o, %06o and %06o\n",B      hdr->n_fnts, hdr->bitmap[0], hdr->bitmap[1], hdr->bitmap[2]);<    printf(" and %d character sets at %06o, %06o and %06o\n",?      hdr->n_indx, hdr->index[0], hdr->index[1], hdr->index[2]);f #endif      /*%:     * Determine the font file(s) to open, and whether they!     * are binary or ASCII format.	     */0    bflavor = "80.DAT";					/* Do 80-col first */    aflavor = "80.FNT";    pass = 1;! nxtflavor:						/* Branch-back */_  H    concat(filename, FONT_LOC, np, bflavor, 0);		/* Make a binary name */C    if((ffp = fopen(filename, "run")) == NULL)		/* Try for binary */i       { G       concat(filename, FONT_LOC, np, aflavor, 0);	/* Make ASCII name */xC       if((ffp = fopen(filename, "r")) == NULL)		/* Try for ASCII */n-          my_err("Missing font file", $$ferr); 
       else          bin_fmt = FALSE;/       }v    elseD       bin_fmt = TRUE;i      /* C     * Load the font/character set.  THERE IS NO ERROR CHECKING, THE_*     * FILE'd BETTER DAMN WELL BE CORRECT!!     */*    while(!feof(ffp))			/* Read till EOF */       {,F       if(fget(buf, 64, ffp) == EOF)	/* Quit if EOF encountered here */          break;a  '       if(bin_fmt)			/* BINARY FLAVOR */f
          {6          wp = (word *)buf;			/* Make a word pointer */.          if(fntnum == -1)			/* First record */%             {					/* (font header) */ 0             fntnum = *wp++;			/* Font number, */3             nbpr = *wp++;  			/* # bytes per row */H-             nbpc = *wp;				/* # bytes/char */C6             continue;				/* Go back & read next rec */
             } 0          else					/* Character definition rec */-             {					/* so get its index info */ 2             charset = *wp++;			/* Character set */=             chcode  = *wp++;			/* Character code for index */(;             idxval = *wp++;			/* Offset in index to bash */t;             bp = (char *)wp;			/* bp & wp --> 1st bitmap *//
             }b
          }        else				/* ASCII FLAVOR */
          {9          if(buf[0] == '[')			/* If is font header line */o
             {xK             sscanf(buf, "[%d %d %d", &fntnum, &nbpr, &nbpc); /* Get info */              continue;e
             }o=          if(buf[0] != '<')			/* Read lines till start-cell */              continue;	3          if(fntnum == -1)			/* NO FONT HEADER??? */=-             my_err("Missing font header", 0); >          sscanf(buf, "<%d %d %d", &charset, &chcode, &idxval);
          }   #ifdef DEBUG5       printf("Code %d  Character set %d  Index %d\n",]"          chcode, charset, idxval); #endif    9       if(chcode > 95 || idxval > 221)		/* Check values */p
          {9          printf("Code %h  Character set %d  Index %h:\n", %             chcode, charset, idxval);t3          my_err("Illegal cell map in PXL file", 0);i
          }   #ifdef DEBUG7       printf("Loading index entry %d (%06o) with %d\n", 9          chcode, &(hdr->index[charset][chcode]), idxval);& #endif  H       hdr->index[charset][chcode] = idxval;	/* Load the mapping index */5       if(idxval == 0)				/* If undefined character */ 2          continue;				/* Finished, ignore noise */         /*/        * Point to the cell map to be bashed and .        * read in pixel rows, bashing the cell.	        */ 3       pxlp = hdr->bitmap[fntnum] + (nbpc * idxval);        nbits = nbpr << 3;        for(i=0; i<nbpc/nbpr; i++)
          {*          if(bin_fmt)			/* BINARY FLAVOR */
             {]1             if(nbpr == 1)			/* Byte sized rows */h                bits = *bp++;	 	    else                 bits = *wp++;
             }c#          else				/* ASCII FLAVOR */*
             {r@             if(fget(buf, 64, ffp) == EOF)	/* Read a pixel row */+                my_err("Unexpected EOF", 0);t             bits = 0; <             cp = buf + nbits;			/* Decode row data to bin */&             for(j=0; j<(nbits-1); j++)                {!                if(*(--cp) == '*')Y                   bits |= 1;                bits <<= 1;                }             if(*(--cp) == '*')                bits |= 1; 
             }    #ifdef DEBUG0          printf("Loc %06o: %06o\n", pxlp, bits); #endif            if(nbpr == 2)%             *((word *)(pxlp)) = bits; 
          elser              *pxlp = bits & 0377;          pxlp += nbpr;
          }       }	   #ifdef INTERACTIVE    /*/     * Display the new font     */    printf(clrseq);    if(nbpr == 1)1       printf("\033[?3h");		/* 80-column -> 132 */ 6    switch(charset)			/* HACK - ASSUMES ALL SAME SET */       {c9       case 0: i = 'B'; break;	/* G0 is ASCII (default) */i:       case 1: i = '0'; break;	/* G0 is Special Graphics */9       case 2: i = '<';		/* G0 is Supplemental Graphics */p       }i    printf("\033(%c\n\n\t", i);    for(i=0; i<6; i++)        {p       for(j=0; j<16; j++) +          printf("%c ", 040 + (16 * i) + j);i       printf("\n\t");        }i    if(pass == 1)C       printf("\033(B\nPress RETURN to see the 132-column set ...");s    elser1       printf("\033(B\nPress RETURN to exit ...");     fflush(stdout);
    gets(buf); )    if(nbpr == 1)			/* 132-column -> 80 */0       {	       printf("\033[?3l");/       fflush(stdout);;       }s #endif7    if(pass++ == 1)			/* If we just did the 80-column */i       {r       fclose(ffp);;       fntnum = -1;			/* Reset to see header in bin file! */0       aflavor = "132.FNT";       bflavor = "132.DAT";4       goto nxtflavor;			/* Go back for 132-column */       }3    elses       exits(1);s    }   /*#  * MY_ERR - Handle error conditions.  *?  * Non-interactive  version silently returns with severe error,o0  * otherwise calls FATLER for application error.  */  my_err(fmt, val)
 char *fmt; int val;    {    char mb[80];       sprintf(mb, fmt, val);* #ifdef DEBUG    printf(fmt, val); #endif #ifdef INTERACTIVE    p$fatler(mb); #endif    exits(EX$SEV);     }   #ifdef INTERACTIVE /*+  * DISPLAY - Load and display selected menuf  */2 display(frame) char *frame;    {9    if(p$mframe(frame, action, sizeof(action), stat) != 1)n       my_err("MFRAME error");s;    p$menu(action, sizeof(action), FALSE, msg1, msg2, stat);F    } #endif